/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/ctrlsub.h>



PyDoc_STRVAR(doc_wxItemContainerImmutable_GetCount, "GetCount() -> unsignedint\n"
"\n"
"Returns the number of items in the control.");

extern "C" {static PyObject *meth_wxItemContainerImmutable_GetCount(PyObject *, PyObject *);}
static PyObject *meth_wxItemContainerImmutable_GetCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxItemContainerImmutable *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxItemContainerImmutable, &sipCpp))
        {
            uint sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_ItemContainerImmutable, sipName_GetCount);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetCount();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ItemContainerImmutable, sipName_GetCount, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxItemContainerImmutable_IsEmpty, "IsEmpty() -> bool\n"
"\n"
"Returns true if the control is empty or false if it has some items.");

extern "C" {static PyObject *meth_wxItemContainerImmutable_IsEmpty(PyObject *, PyObject *);}
static PyObject *meth_wxItemContainerImmutable_IsEmpty(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxItemContainerImmutable *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxItemContainerImmutable, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsEmpty();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ItemContainerImmutable, sipName_IsEmpty, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxItemContainerImmutable_GetString, "GetString(n) -> String\n"
"\n"
"Returns the label of the item with the given index.");

extern "C" {static PyObject *meth_wxItemContainerImmutable_GetString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxItemContainerImmutable_GetString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
        uint n;
        const  ::wxItemContainerImmutable *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bu", &sipSelf, sipType_wxItemContainerImmutable, &sipCpp, &n))
        {
             ::wxString*sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_ItemContainerImmutable, sipName_GetString);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetString(n));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ItemContainerImmutable, sipName_GetString, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxItemContainerImmutable_GetStrings, "GetStrings() -> ArrayString\n"
"\n"
"Returns the array of the labels of all items in the control.");

extern "C" {static PyObject *meth_wxItemContainerImmutable_GetStrings(PyObject *, PyObject *);}
static PyObject *meth_wxItemContainerImmutable_GetStrings(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxItemContainerImmutable *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxItemContainerImmutable, &sipCpp))
        {
             ::wxArrayString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxArrayString(sipCpp->GetStrings());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxArrayString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ItemContainerImmutable, sipName_GetStrings, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxItemContainerImmutable_SetString, "SetString(n, string)\n"
"\n"
"Sets the label for the given item.");

extern "C" {static PyObject *meth_wxItemContainerImmutable_SetString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxItemContainerImmutable_SetString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
        uint n;
        const  ::wxString* string;
        int stringState = 0;
         ::wxItemContainerImmutable *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
            sipName_string,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BuJ1", &sipSelf, sipType_wxItemContainerImmutable, &sipCpp, &n, sipType_wxString,&string, &stringState))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_ItemContainerImmutable, sipName_SetString);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetString(n,*string);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(string),sipType_wxString,stringState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ItemContainerImmutable, sipName_SetString, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxItemContainerImmutable_FindString, "FindString(string, caseSensitive=False) -> int\n"
"\n"
"Finds an item whose label matches the given string.");

extern "C" {static PyObject *meth_wxItemContainerImmutable_FindString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxItemContainerImmutable_FindString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* string;
        int stringState = 0;
        bool caseSensitive = 0;
        const  ::wxItemContainerImmutable *sipCpp;

        static const char *sipKwdList[] = {
            sipName_string,
            sipName_caseSensitive,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|b", &sipSelf, sipType_wxItemContainerImmutable, &sipCpp, sipType_wxString,&string, &stringState, &caseSensitive))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxItemContainerImmutable::FindString(*string,caseSensitive) : sipCpp->FindString(*string,caseSensitive));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(string),sipType_wxString,stringState);

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ItemContainerImmutable, sipName_FindString, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxItemContainerImmutable_SetSelection, "SetSelection(n)\n"
"\n"
"Sets the selection to the given item n or removes the selection\n"
"entirely if n == wxNOT_FOUND.");

extern "C" {static PyObject *meth_wxItemContainerImmutable_SetSelection(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxItemContainerImmutable_SetSelection(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
        int n;
         ::wxItemContainerImmutable *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxItemContainerImmutable, &sipCpp, &n))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_ItemContainerImmutable, sipName_SetSelection);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetSelection(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ItemContainerImmutable, sipName_SetSelection, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxItemContainerImmutable_GetSelection, "GetSelection() -> int\n"
"\n"
"Returns the index of the selected item or wxNOT_FOUND if no item is\n"
"selected.");

extern "C" {static PyObject *meth_wxItemContainerImmutable_GetSelection(PyObject *, PyObject *);}
static PyObject *meth_wxItemContainerImmutable_GetSelection(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxItemContainerImmutable *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxItemContainerImmutable, &sipCpp))
        {
            int sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_ItemContainerImmutable, sipName_GetSelection);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetSelection();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ItemContainerImmutable, sipName_GetSelection, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxItemContainerImmutable_SetStringSelection, "SetStringSelection(string) -> bool\n"
"\n"
"Selects the item with the specified string in the control.");

extern "C" {static PyObject *meth_wxItemContainerImmutable_SetStringSelection(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxItemContainerImmutable_SetStringSelection(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* string;
        int stringState = 0;
         ::wxItemContainerImmutable *sipCpp;

        static const char *sipKwdList[] = {
            sipName_string,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxItemContainerImmutable, &sipCpp, sipType_wxString,&string, &stringState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetStringSelection(*string);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(string),sipType_wxString,stringState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ItemContainerImmutable, sipName_SetStringSelection, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxItemContainerImmutable_GetStringSelection, "GetStringSelection() -> String\n"
"\n"
"Returns the label of the selected item or an empty string if no item\n"
"is selected.");

extern "C" {static PyObject *meth_wxItemContainerImmutable_GetStringSelection(PyObject *, PyObject *);}
static PyObject *meth_wxItemContainerImmutable_GetStringSelection(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxItemContainerImmutable *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxItemContainerImmutable, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString((sipSelfWasArg ? sipCpp-> ::wxItemContainerImmutable::GetStringSelection() : sipCpp->GetStringSelection()));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ItemContainerImmutable, sipName_GetStringSelection, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxItemContainerImmutable_Select, "Select(n)\n"
"\n"
"This is the same as SetSelection() and exists only because it is\n"
"slightly more natural for controls which support multiple selection.");

extern "C" {static PyObject *meth_wxItemContainerImmutable_Select(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxItemContainerImmutable_Select(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int n;
         ::wxItemContainerImmutable *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxItemContainerImmutable, &sipCpp, &n))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Select(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ItemContainerImmutable, sipName_Select, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxItemContainerImmutable(void *, int);}
static void release_wxItemContainerImmutable(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxItemContainerImmutable *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxItemContainerImmutable(sipSimpleWrapper *);}
static void dealloc_wxItemContainerImmutable(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxItemContainerImmutable(sipGetAddress(sipSelf), 0);
    }
}


static PyMethodDef methods_wxItemContainerImmutable[] = {
    {SIP_MLNAME_CAST(sipName_FindString), (PyCFunction)meth_wxItemContainerImmutable_FindString, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxItemContainerImmutable_FindString)},
    {SIP_MLNAME_CAST(sipName_GetCount), meth_wxItemContainerImmutable_GetCount, METH_VARARGS, SIP_MLDOC_CAST(doc_wxItemContainerImmutable_GetCount)},
    {SIP_MLNAME_CAST(sipName_GetSelection), meth_wxItemContainerImmutable_GetSelection, METH_VARARGS, SIP_MLDOC_CAST(doc_wxItemContainerImmutable_GetSelection)},
    {SIP_MLNAME_CAST(sipName_GetString), (PyCFunction)meth_wxItemContainerImmutable_GetString, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxItemContainerImmutable_GetString)},
    {SIP_MLNAME_CAST(sipName_GetStringSelection), meth_wxItemContainerImmutable_GetStringSelection, METH_VARARGS, SIP_MLDOC_CAST(doc_wxItemContainerImmutable_GetStringSelection)},
    {SIP_MLNAME_CAST(sipName_GetStrings), meth_wxItemContainerImmutable_GetStrings, METH_VARARGS, SIP_MLDOC_CAST(doc_wxItemContainerImmutable_GetStrings)},
    {SIP_MLNAME_CAST(sipName_IsEmpty), meth_wxItemContainerImmutable_IsEmpty, METH_VARARGS, SIP_MLDOC_CAST(doc_wxItemContainerImmutable_IsEmpty)},
    {SIP_MLNAME_CAST(sipName_Select), (PyCFunction)meth_wxItemContainerImmutable_Select, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxItemContainerImmutable_Select)},
    {SIP_MLNAME_CAST(sipName_SetSelection), (PyCFunction)meth_wxItemContainerImmutable_SetSelection, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxItemContainerImmutable_SetSelection)},
    {SIP_MLNAME_CAST(sipName_SetString), (PyCFunction)meth_wxItemContainerImmutable_SetString, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxItemContainerImmutable_SetString)},
    {SIP_MLNAME_CAST(sipName_SetStringSelection), (PyCFunction)meth_wxItemContainerImmutable_SetStringSelection, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxItemContainerImmutable_SetStringSelection)}
};

sipVariableDef variables_wxItemContainerImmutable[] = {
    {PropertyVariable, sipName_Strings, &methods_wxItemContainerImmutable[5], NULL, NULL, NULL},
    {PropertyVariable, sipName_StringSelection, &methods_wxItemContainerImmutable[4], &methods_wxItemContainerImmutable[10], NULL, NULL},
    {PropertyVariable, sipName_Selection, &methods_wxItemContainerImmutable[2], &methods_wxItemContainerImmutable[8], NULL, NULL},
    {PropertyVariable, sipName_Count, &methods_wxItemContainerImmutable[1], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxItemContainerImmutable, "ItemContainerImmutable()\n"
"\n"
"wxItemContainer defines an interface which is implemented by all\n"
"controls which have string subitems each of which may be selected.");


sipClassTypeDef sipTypeDef__core_wxItemContainerImmutable = {
    {
        -1,
        0,
        0,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxItemContainerImmutable,
        {0},
        0
    },
    {
        sipNameNr_ItemContainerImmutable,
        {0, 0, 1},
        11, methods_wxItemContainerImmutable,
        0, 0,
        4, variables_wxItemContainerImmutable,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxItemContainerImmutable,
    -1,
    -1,
    0,
    0,
    0,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxItemContainerImmutable,
    0,
    0,
    0,
    release_wxItemContainerImmutable,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
