/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/menuitem.h>

        #include <wx/menu.h>
        #include <wx/accel.h>
        #include <wx/colour.h>
        #include <wx/font.h>
        #include <wx/bitmap.h>
        #include <wx/object.h>
        #include <wx/object.h>
    wxColour* _wxMenuItem_GetBackgroundColour(const wxMenuItem* self)
    {
        #ifdef __WXMSW__
            return &self->GetBackgroundColour();
        #else
            return &wxNullColour;
        #endif
    }
    const wxBitmap* _wxMenuItem_GetBitmap(const wxMenuItem* self, bool checked)
    {
        #ifdef __WXMSW__
            return &self->GetBitmap(checked);
        #else
            return &self->GetBitmap();
        #endif
    }
    const wxBitmap* _wxMenuItem_GetDisabledBitmap(const wxMenuItem* self)
    {
        #ifdef __WXMSW__
            return &self->GetDisabledBitmap();
        #else
            return &wxNullBitmap;
        #endif
    }
    wxFont* _wxMenuItem_GetFont(const wxMenuItem* self)
    {
        #ifdef __WXMSW__
            return &self->GetFont();
        #else
            return &wxNullFont;
        #endif
    }
    int _wxMenuItem_GetMarginWidth(const wxMenuItem* self)
    {
        #ifdef __WXMSW__
            return self->GetMarginWidth();
        #else
            return -1;
        #endif
    }
    wxColour* _wxMenuItem_GetTextColour(const wxMenuItem* self)
    {
        #ifdef __WXMSW__
            return &self->GetTextColour();
        #else
            return &wxNullColour;
        #endif
    }
    void _wxMenuItem_SetBackgroundColour(wxMenuItem* self, const wxColour *colour)
    {
        #ifdef __WXMSW__
            self->SetBackgroundColour(*colour);
        #endif
    }
    void _wxMenuItem_SetBitmap(wxMenuItem* self, const wxBitmap *bmp, bool checked)
    {
        #ifdef __WXMSW__
            self->SetBitmap(*bmp, checked);
        #else
            self->SetBitmap(*bmp); // no checked arg in this case
        #endif
    }
    void _wxMenuItem_SetBitmaps(wxMenuItem* self, const wxBitmap *checked, const wxBitmap *unchecked)
    {
        #ifdef __WXMSW__
            self->SetBitmaps(*checked, *unchecked);
        #else
            self->SetBitmap(*checked);
        #endif
    }
    void _wxMenuItem_SetDisabledBitmap(wxMenuItem* self, const wxBitmap *disabled)
    {
        #ifdef __WXMSW__
            self->SetDisabledBitmap(*disabled);
        #endif
    }
    void _wxMenuItem_SetFont(wxMenuItem* self, const wxFont *font)
    {
        #ifdef __WXMSW__
            self->SetFont(*font);
        #endif
    }
    void _wxMenuItem_SetMarginWidth(wxMenuItem* self, int width)
    {
        #ifdef __WXMSW__
            self->SetMarginWidth(width);
        #endif
    }
    void _wxMenuItem_SetTextColour(wxMenuItem* self, const wxColour *colour)
    {
        #ifdef __WXMSW__
            self->SetTextColour(*colour);
        #endif
    }


PyDoc_STRVAR(doc_wxMenuItem_GetBackgroundColour, "GetBackgroundColour() -> Colour\n"
"\n"
"Returns the background colour associated with the menu item.");

extern "C" {static PyObject *meth_wxMenuItem_GetBackgroundColour(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetBackgroundColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
             ::wxColour*sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxMenuItem_GetBackgroundColour(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromType(sipRes,sipType_wxColour,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetBackgroundColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_GetBitmap, "GetBitmap(checked=True) -> Bitmap\n"
"\n"
"Returns the checked or unchecked bitmap.");

extern "C" {static PyObject *meth_wxMenuItem_GetBitmap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetBitmap(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool checked = 1;
        const  ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_checked,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|b", &sipSelf, sipType_wxMenuItem, &sipCpp, &checked))
        {
            const  ::wxBitmap*sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxMenuItem_GetBitmap(sipCpp, checked);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromType(const_cast< ::wxBitmap *>(sipRes),sipType_wxBitmap,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetBitmap, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_GetDisabledBitmap, "GetDisabledBitmap() -> Bitmap\n"
"\n"
"Returns the bitmap to be used for disabled items.");

extern "C" {static PyObject *meth_wxMenuItem_GetDisabledBitmap(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetDisabledBitmap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
            const  ::wxBitmap*sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxMenuItem_GetDisabledBitmap(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromType(const_cast< ::wxBitmap *>(sipRes),sipType_wxBitmap,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetDisabledBitmap, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_GetFont, "GetFont() -> Font\n"
"\n"
"Returns the font associated with the menu item.");

extern "C" {static PyObject *meth_wxMenuItem_GetFont(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetFont(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
             ::wxFont*sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxMenuItem_GetFont(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFont,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetFont, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_GetHelp, "GetHelp() -> String\n"
"\n"
"Returns the help string associated with the menu item.");

extern "C" {static PyObject *meth_wxMenuItem_GetHelp(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetHelp(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetHelp());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetHelp, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_GetId, "GetId() -> int\n"
"\n"
"Returns the menu item identifier.");

extern "C" {static PyObject *meth_wxMenuItem_GetId(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetId(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetId();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetId, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_GetItemLabel, "GetItemLabel() -> String\n"
"\n"
"Returns the text associated with the menu item including any\n"
"accelerator characters that were passed to the constructor or\n"
"SetItemLabel().");

extern "C" {static PyObject *meth_wxMenuItem_GetItemLabel(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetItemLabel(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetItemLabel());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetItemLabel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_GetItemLabelText, "GetItemLabelText() -> String\n"
"\n"
"Returns the text associated with the menu item, without any\n"
"accelerator characters.");

extern "C" {static PyObject *meth_wxMenuItem_GetItemLabelText(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetItemLabelText(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetItemLabelText());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetItemLabelText, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_GetKind, "GetKind() -> ItemKind\n"
"\n"
"Returns the item kind, one of wxITEM_SEPARATOR, wxITEM_NORMAL,\n"
"wxITEM_CHECK or wxITEM_RADIO.");

extern "C" {static PyObject *meth_wxMenuItem_GetKind(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetKind(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
             ::wxItemKind sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetKind();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxItemKind);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetKind, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_GetLabel, "GetLabel() -> String\n"
"\n"
"Returns the text associated with the menu item without any accelerator\n"
"characters it might contain.");

extern "C" {static PyObject *meth_wxMenuItem_GetLabel(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetLabel(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetLabel());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetLabel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_GetMarginWidth, "GetMarginWidth() -> int\n"
"\n"
"Gets the width of the menu item checkmark bitmap.");

extern "C" {static PyObject *meth_wxMenuItem_GetMarginWidth(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetMarginWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
            int sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxMenuItem_GetMarginWidth(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetMarginWidth, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_GetMenu, "GetMenu() -> Menu\n"
"\n"
"Returns the menu this menu item is in, or NULL if this menu item is\n"
"not attached.");

extern "C" {static PyObject *meth_wxMenuItem_GetMenu(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetMenu(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
             ::wxMenu*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetMenu();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxMenu,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetMenu, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_GetName, "GetName() -> String\n"
"\n"
"Returns the text associated with the menu item.");

extern "C" {static PyObject *meth_wxMenuItem_GetName(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_GetSubMenu, "GetSubMenu() -> Menu\n"
"\n"
"Returns the submenu associated with the menu item, or NULL if there\n"
"isn't one.");

extern "C" {static PyObject *meth_wxMenuItem_GetSubMenu(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetSubMenu(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
             ::wxMenu*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetSubMenu();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxMenu,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetSubMenu, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_GetText, "GetText() -> String\n"
"\n"
"Returns the text associated with the menu item, such as it was passed\n"
"to the wxMenuItem constructor, i.e.");

extern "C" {static PyObject *meth_wxMenuItem_GetText(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetText(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetText());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetText, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_GetTextColour, "GetTextColour() -> Colour\n"
"\n"
"Returns the text colour associated with the menu item.");

extern "C" {static PyObject *meth_wxMenuItem_GetTextColour(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetTextColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
             ::wxColour*sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxMenuItem_GetTextColour(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromType(sipRes,sipType_wxColour,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetTextColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_GetAccel, "GetAccel() -> AcceleratorEntry\n"
"\n"
"Get our accelerator or NULL (caller must delete the pointer)");

extern "C" {static PyObject *meth_wxMenuItem_GetAccel(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetAccel(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
             ::wxAcceleratorEntry*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetAccel();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxAcceleratorEntry,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetAccel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_IsCheck, "IsCheck() -> bool\n"
"\n"
"Returns true if the item is a check item.");

extern "C" {static PyObject *meth_wxMenuItem_IsCheck(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_IsCheck(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsCheck();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_IsCheck, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_IsCheckable, "IsCheckable() -> bool\n"
"\n"
"Returns true if the item is checkable.");

extern "C" {static PyObject *meth_wxMenuItem_IsCheckable(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_IsCheckable(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsCheckable();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_IsCheckable, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_IsChecked, "IsChecked() -> bool\n"
"\n"
"Returns true if the item is checked.");

extern "C" {static PyObject *meth_wxMenuItem_IsChecked(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_IsChecked(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsChecked();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_IsChecked, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_IsEnabled, "IsEnabled() -> bool\n"
"\n"
"Returns true if the item is enabled.");

extern "C" {static PyObject *meth_wxMenuItem_IsEnabled(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_IsEnabled(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsEnabled();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_IsEnabled, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_IsRadio, "IsRadio() -> bool\n"
"\n"
"Returns true if the item is a radio button.");

extern "C" {static PyObject *meth_wxMenuItem_IsRadio(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_IsRadio(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsRadio();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_IsRadio, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_IsSeparator, "IsSeparator() -> bool\n"
"\n"
"Returns true if the item is a separator.");

extern "C" {static PyObject *meth_wxMenuItem_IsSeparator(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_IsSeparator(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsSeparator();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_IsSeparator, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_IsSubMenu, "IsSubMenu() -> bool\n"
"\n"
"Returns true if the item is a submenu.");

extern "C" {static PyObject *meth_wxMenuItem_IsSubMenu(PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_IsSubMenu(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxMenuItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxMenuItem, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsSubMenu();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_IsSubMenu, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_SetBackgroundColour, "SetBackgroundColour(colour)\n"
"\n"
"Sets the background colour associated with the menu item.");

extern "C" {static PyObject *meth_wxMenuItem_SetBackgroundColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_SetBackgroundColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxColour* colour;
        int colourState = 0;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxMenuItem, &sipCpp, sipType_wxColour, &colour, &colourState))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxMenuItem_SetBackgroundColour(sipCpp, colour);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxColour *>(colour),sipType_wxColour,colourState);

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_SetBackgroundColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_SetBitmap, "SetBitmap(bmp, checked=True)\n"
"\n"
"Sets the bitmap for the menu item.");

extern "C" {static PyObject *meth_wxMenuItem_SetBitmap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_SetBitmap(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxBitmap* bmp;
        bool checked = 1;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bmp,
            sipName_checked,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9|b", &sipSelf, sipType_wxMenuItem, &sipCpp, sipType_wxBitmap, &bmp, &checked))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxMenuItem_SetBitmap(sipCpp, bmp, checked);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_SetBitmap, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_SetBitmaps, "SetBitmaps(checked, unchecked=NullBitmap)\n"
"\n"
"Sets the checked/unchecked bitmaps for the menu item.");

extern "C" {static PyObject *meth_wxMenuItem_SetBitmaps(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_SetBitmaps(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxBitmap* checked;
        const  ::wxBitmap& uncheckeddef = wxNullBitmap;
        const  ::wxBitmap* unchecked = &uncheckeddef;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_checked,
            sipName_unchecked,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9|J9", &sipSelf, sipType_wxMenuItem, &sipCpp, sipType_wxBitmap, &checked, sipType_wxBitmap, &unchecked))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxMenuItem_SetBitmaps(sipCpp, checked, unchecked);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_SetBitmaps, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_SetDisabledBitmap, "SetDisabledBitmap(disabled)\n"
"\n"
"Sets the to be used for disabled menu items.");

extern "C" {static PyObject *meth_wxMenuItem_SetDisabledBitmap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_SetDisabledBitmap(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxBitmap* disabled;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_disabled,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxMenuItem, &sipCpp, sipType_wxBitmap, &disabled))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxMenuItem_SetDisabledBitmap(sipCpp, disabled);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_SetDisabledBitmap, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_SetFont, "SetFont(font)\n"
"\n"
"Sets the font associated with the menu item.");

extern "C" {static PyObject *meth_wxMenuItem_SetFont(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_SetFont(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont* font;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_font,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxMenuItem, &sipCpp, sipType_wxFont, &font))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxMenuItem_SetFont(sipCpp, font);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_SetFont, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_SetHelp, "SetHelp(helpString)\n"
"\n"
"Sets the help string.");

extern "C" {static PyObject *meth_wxMenuItem_SetHelp(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_SetHelp(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* helpString;
        int helpStringState = 0;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_helpString,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxMenuItem, &sipCpp, sipType_wxString,&helpString, &helpStringState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetHelp(*helpString);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(helpString),sipType_wxString,helpStringState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_SetHelp, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_SetItemLabel, "SetItemLabel(label)\n"
"\n"
"Sets the label associated with the menu item.");

extern "C" {static PyObject *meth_wxMenuItem_SetItemLabel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_SetItemLabel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* label;
        int labelState = 0;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_label,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxMenuItem, &sipCpp, sipType_wxString,&label, &labelState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetItemLabel(*label);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(label),sipType_wxString,labelState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_SetItemLabel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_SetMarginWidth, "SetMarginWidth(width)\n"
"\n"
"Sets the width of the menu item checkmark bitmap.");

extern "C" {static PyObject *meth_wxMenuItem_SetMarginWidth(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_SetMarginWidth(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int width;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_width,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxMenuItem, &sipCpp, &width))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxMenuItem_SetMarginWidth(sipCpp, width);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_SetMarginWidth, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_SetMenu, "SetMenu(menu)\n"
"\n"
"Sets the parent menu which will contain this menu item.");

extern "C" {static PyObject *meth_wxMenuItem_SetMenu(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_SetMenu(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxMenu* menu;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_menu,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxMenuItem, &sipCpp, sipType_wxMenu, &menu))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetMenu(menu);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_SetMenu, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_SetSubMenu, "SetSubMenu(menu)\n"
"\n"
"Sets the submenu of this menu item.");

extern "C" {static PyObject *meth_wxMenuItem_SetSubMenu(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_SetSubMenu(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxMenu* menu;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_menu,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ:", &sipSelf, sipType_wxMenuItem, &sipCpp, sipType_wxMenu, &menu))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetSubMenu(menu);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_SetSubMenu, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_SetText, "SetText(text)\n"
"\n"
"Sets the text associated with the menu item.");

extern "C" {static PyObject *meth_wxMenuItem_SetText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_SetText(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* text;
        int textState = 0;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxMenuItem, &sipCpp, sipType_wxString,&text, &textState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetText(*text);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_SetText, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_SetTextColour, "SetTextColour(colour)\n"
"\n"
"Sets the text colour associated with the menu item.");

extern "C" {static PyObject *meth_wxMenuItem_SetTextColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_SetTextColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxColour* colour;
        int colourState = 0;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxMenuItem, &sipCpp, sipType_wxColour, &colour, &colourState))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxMenuItem_SetTextColour(sipCpp, colour);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxColour *>(colour),sipType_wxColour,colourState);

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_SetTextColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_SetAccel, "SetAccel(accel)\n"
"\n"
"Set the accel for this item - this may also be done indirectly with\n"
"SetText()");

extern "C" {static PyObject *meth_wxMenuItem_SetAccel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_SetAccel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxAcceleratorEntry* accel;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_accel,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxMenuItem, &sipCpp, sipType_wxAcceleratorEntry, &accel))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetAccel(accel);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_SetAccel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_Check, "Check(check=True)\n"
"\n"
"Checks or unchecks the menu item.");

extern "C" {static PyObject *meth_wxMenuItem_Check(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_Check(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool check = 1;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_check,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|b", &sipSelf, sipType_wxMenuItem, &sipCpp, &check))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Check(check);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_Check, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_Enable, "Enable(enable=True)\n"
"\n"
"Enables or disables the menu item.");

extern "C" {static PyObject *meth_wxMenuItem_Enable(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_Enable(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool enable = 1;
         ::wxMenuItem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_enable,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|b", &sipSelf, sipType_wxMenuItem, &sipCpp, &enable))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Enable(enable);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_Enable, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_GetLabelFromText, "GetLabelFromText(text) -> String");

extern "C" {static PyObject *meth_wxMenuItem_GetLabelFromText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetLabelFromText(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* text;
        int textState = 0;

        static const char *sipKwdList[] = {
            sipName_text,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&text, &textState))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString( ::wxMenuItem::GetLabelFromText(*text));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetLabelFromText, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxMenuItem_GetLabelText, "GetLabelText(text) -> String\n"
"\n"
"Strips all accelerator characters and mnemonics from the given text.");

extern "C" {static PyObject *meth_wxMenuItem_GetLabelText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxMenuItem_GetLabelText(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* text;
        int textState = 0;

        static const char *sipKwdList[] = {
            sipName_text,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&text, &textState))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString( ::wxMenuItem::GetLabelText(*text));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_MenuItem, sipName_GetLabelText, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxMenuItem(void *, const sipTypeDef *);}
static void *cast_wxMenuItem(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxMenuItem *sipCpp = reinterpret_cast< ::wxMenuItem *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxMenuItem(void *, int);}
static void release_wxMenuItem(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxMenuItem *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxMenuItem(sipSimpleWrapper *);}
static void dealloc_wxMenuItem(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxMenuItem(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxMenuItem(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxMenuItem(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxMenuItem *sipCpp = 0;

    {
         ::wxMenu* parentMenu = 0;
        int id = wxID_SEPARATOR;
        const  ::wxString& textdef = wxEmptyString;
        const  ::wxString* text = &textdef;
        int textState = 0;
        const  ::wxString& helpStringdef = wxEmptyString;
        const  ::wxString* helpString = &helpStringdef;
        int helpStringState = 0;
         ::wxItemKind kind = wxITEM_NORMAL;
         ::wxMenu* subMenu = 0;

        static const char *sipKwdList[] = {
            sipName_parentMenu,
            sipName_id,
            sipName_text,
            sipName_helpString,
            sipName_kind,
            sipName_subMenu,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J8iJ1J1EJ8", sipType_wxMenu, &parentMenu, &id, sipType_wxString,&text, &textState, sipType_wxString,&helpString, &helpStringState, sipType_wxItemKind, &kind, sipType_wxMenu, &subMenu))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxMenuItem(parentMenu,id,*text,*helpString,kind,subMenu);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);
            sipReleaseType(const_cast< ::wxString *>(helpString),sipType_wxString,helpStringState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxMenuItem[] = {{348, 255, 1}};


static PyMethodDef methods_wxMenuItem[] = {
    {SIP_MLNAME_CAST(sipName_Check), (PyCFunction)meth_wxMenuItem_Check, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMenuItem_Check)},
    {SIP_MLNAME_CAST(sipName_Enable), (PyCFunction)meth_wxMenuItem_Enable, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMenuItem_Enable)},
    {SIP_MLNAME_CAST(sipName_GetAccel), meth_wxMenuItem_GetAccel, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMenuItem_GetAccel)},
    {SIP_MLNAME_CAST(sipName_GetBackgroundColour), meth_wxMenuItem_GetBackgroundColour, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMenuItem_GetBackgroundColour)},
    {SIP_MLNAME_CAST(sipName_GetBitmap), (PyCFunction)meth_wxMenuItem_GetBitmap, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMenuItem_GetBitmap)},
    {SIP_MLNAME_CAST(sipName_GetDisabledBitmap), meth_wxMenuItem_GetDisabledBitmap, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMenuItem_GetDisabledBitmap)},
    {SIP_MLNAME_CAST(sipName_GetFont), meth_wxMenuItem_GetFont, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMenuItem_GetFont)},
    {SIP_MLNAME_CAST(sipName_GetHelp), meth_wxMenuItem_GetHelp, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMenuItem_GetHelp)},
    {SIP_MLNAME_CAST(sipName_GetId), meth_wxMenuItem_GetId, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMenuItem_GetId)},
    {SIP_MLNAME_CAST(sipName_GetItemLabel), meth_wxMenuItem_GetItemLabel, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMenuItem_GetItemLabel)},
    {SIP_MLNAME_CAST(sipName_GetItemLabelText), meth_wxMenuItem_GetItemLabelText, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMenuItem_GetItemLabelText)},
    {SIP_MLNAME_CAST(sipName_GetKind), meth_wxMenuItem_GetKind, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMenuItem_GetKind)},
    {SIP_MLNAME_CAST(sipName_GetLabel), meth_wxMenuItem_GetLabel, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMenuItem_GetLabel)},
    {SIP_MLNAME_CAST(sipName_GetLabelFromText), (PyCFunction)meth_wxMenuItem_GetLabelFromText, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMenuItem_GetLabelFromText)},
    {SIP_MLNAME_CAST(sipName_GetLabelText), (PyCFunction)meth_wxMenuItem_GetLabelText, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMenuItem_GetLabelText)},
    {SIP_MLNAME_CAST(sipName_GetMarginWidth), meth_wxMenuItem_GetMarginWidth, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMenuItem_GetMarginWidth)},
    {SIP_MLNAME_CAST(sipName_GetMenu), meth_wxMenuItem_GetMenu, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMenuItem_GetMenu)},
    {SIP_MLNAME_CAST(sipName_GetName), meth_wxMenuItem_GetName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMenuItem_GetName)},
    {SIP_MLNAME_CAST(sipName_GetSubMenu), meth_wxMenuItem_GetSubMenu, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMenuItem_GetSubMenu)},
    {SIP_MLNAME_CAST(sipName_GetText), meth_wxMenuItem_GetText, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMenuItem_GetText)},
    {SIP_MLNAME_CAST(sipName_GetTextColour), meth_wxMenuItem_GetTextColour, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMenuItem_GetTextColour)},
    {SIP_MLNAME_CAST(sipName_IsCheck), meth_wxMenuItem_IsCheck, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMenuItem_IsCheck)},
    {SIP_MLNAME_CAST(sipName_IsCheckable), meth_wxMenuItem_IsCheckable, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMenuItem_IsCheckable)},
    {SIP_MLNAME_CAST(sipName_IsChecked), meth_wxMenuItem_IsChecked, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMenuItem_IsChecked)},
    {SIP_MLNAME_CAST(sipName_IsEnabled), meth_wxMenuItem_IsEnabled, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMenuItem_IsEnabled)},
    {SIP_MLNAME_CAST(sipName_IsRadio), meth_wxMenuItem_IsRadio, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMenuItem_IsRadio)},
    {SIP_MLNAME_CAST(sipName_IsSeparator), meth_wxMenuItem_IsSeparator, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMenuItem_IsSeparator)},
    {SIP_MLNAME_CAST(sipName_IsSubMenu), meth_wxMenuItem_IsSubMenu, METH_VARARGS, SIP_MLDOC_CAST(doc_wxMenuItem_IsSubMenu)},
    {SIP_MLNAME_CAST(sipName_SetAccel), (PyCFunction)meth_wxMenuItem_SetAccel, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMenuItem_SetAccel)},
    {SIP_MLNAME_CAST(sipName_SetBackgroundColour), (PyCFunction)meth_wxMenuItem_SetBackgroundColour, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMenuItem_SetBackgroundColour)},
    {SIP_MLNAME_CAST(sipName_SetBitmap), (PyCFunction)meth_wxMenuItem_SetBitmap, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMenuItem_SetBitmap)},
    {SIP_MLNAME_CAST(sipName_SetBitmaps), (PyCFunction)meth_wxMenuItem_SetBitmaps, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMenuItem_SetBitmaps)},
    {SIP_MLNAME_CAST(sipName_SetDisabledBitmap), (PyCFunction)meth_wxMenuItem_SetDisabledBitmap, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMenuItem_SetDisabledBitmap)},
    {SIP_MLNAME_CAST(sipName_SetFont), (PyCFunction)meth_wxMenuItem_SetFont, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMenuItem_SetFont)},
    {SIP_MLNAME_CAST(sipName_SetHelp), (PyCFunction)meth_wxMenuItem_SetHelp, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMenuItem_SetHelp)},
    {SIP_MLNAME_CAST(sipName_SetItemLabel), (PyCFunction)meth_wxMenuItem_SetItemLabel, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMenuItem_SetItemLabel)},
    {SIP_MLNAME_CAST(sipName_SetMarginWidth), (PyCFunction)meth_wxMenuItem_SetMarginWidth, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMenuItem_SetMarginWidth)},
    {SIP_MLNAME_CAST(sipName_SetMenu), (PyCFunction)meth_wxMenuItem_SetMenu, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMenuItem_SetMenu)},
    {SIP_MLNAME_CAST(sipName_SetSubMenu), (PyCFunction)meth_wxMenuItem_SetSubMenu, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMenuItem_SetSubMenu)},
    {SIP_MLNAME_CAST(sipName_SetText), (PyCFunction)meth_wxMenuItem_SetText, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMenuItem_SetText)},
    {SIP_MLNAME_CAST(sipName_SetTextColour), (PyCFunction)meth_wxMenuItem_SetTextColour, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxMenuItem_SetTextColour)}
};

sipVariableDef variables_wxMenuItem[] = {
    {PropertyVariable, sipName_TextColour, &methods_wxMenuItem[20], &methods_wxMenuItem[40], NULL, NULL},
    {PropertyVariable, sipName_Text, &methods_wxMenuItem[19], &methods_wxMenuItem[39], NULL, NULL},
    {PropertyVariable, sipName_SubMenu, &methods_wxMenuItem[18], &methods_wxMenuItem[38], NULL, NULL},
    {PropertyVariable, sipName_Name, &methods_wxMenuItem[17], NULL, NULL, NULL},
    {PropertyVariable, sipName_Menu, &methods_wxMenuItem[16], &methods_wxMenuItem[37], NULL, NULL},
    {PropertyVariable, sipName_MarginWidth, &methods_wxMenuItem[15], &methods_wxMenuItem[36], NULL, NULL},
    {PropertyVariable, sipName_Label, &methods_wxMenuItem[12], NULL, NULL, NULL},
    {PropertyVariable, sipName_Kind, &methods_wxMenuItem[11], NULL, NULL, NULL},
    {PropertyVariable, sipName_ItemLabelText, &methods_wxMenuItem[10], NULL, NULL, NULL},
    {PropertyVariable, sipName_ItemLabel, &methods_wxMenuItem[9], &methods_wxMenuItem[35], NULL, NULL},
    {PropertyVariable, sipName_Id, &methods_wxMenuItem[8], NULL, NULL, NULL},
    {PropertyVariable, sipName_Help, &methods_wxMenuItem[7], &methods_wxMenuItem[34], NULL, NULL},
    {PropertyVariable, sipName_Font, &methods_wxMenuItem[6], &methods_wxMenuItem[33], NULL, NULL},
    {PropertyVariable, sipName_DisabledBitmap, &methods_wxMenuItem[5], &methods_wxMenuItem[32], NULL, NULL},
    {PropertyVariable, sipName_Bitmap, &methods_wxMenuItem[4], &methods_wxMenuItem[30], NULL, NULL},
    {PropertyVariable, sipName_BackgroundColour, &methods_wxMenuItem[3], &methods_wxMenuItem[29], NULL, NULL},
    {PropertyVariable, sipName_Accel, &methods_wxMenuItem[2], &methods_wxMenuItem[28], NULL, NULL},
};

PyDoc_STRVAR(doc_wxMenuItem, "MenuItem(parentMenu=None, id=ID_SEPARATOR, text=EmptyString, helpString=EmptyString, kind=ITEM_NORMAL, subMenu=None)\n"
"\n"
"A menu item represents an item in a menu.");


sipClassTypeDef sipTypeDef__core_wxMenuItem = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxMenuItem,
        {0},
        0
    },
    {
        sipNameNr_MenuItem,
        {0, 0, 1},
        41, methods_wxMenuItem,
        0, 0,
        17, variables_wxMenuItem,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxMenuItem,
    -1,
    -1,
    supers_wxMenuItem,
    0,
    init_type_wxMenuItem,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxMenuItem,
    0,
    0,
    0,
    release_wxMenuItem,
    cast_wxMenuItem,
    0,
    0,
    0,
    0,
    0,
    0
};
