/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/statusbr.h>



PyDoc_STRVAR(doc_wxStatusBarPane_GetWidth, "GetWidth() -> int\n"
"\n"
"Returns the pane width; it maybe negative, indicating a variable-width\n"
"field.");

extern "C" {static PyObject *meth_wxStatusBarPane_GetWidth(PyObject *, PyObject *);}
static PyObject *meth_wxStatusBarPane_GetWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxStatusBarPane *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxStatusBarPane, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetWidth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_StatusBarPane, sipName_GetWidth, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxStatusBarPane_GetStyle, "GetStyle() -> int\n"
"\n"
"Returns the pane style.");

extern "C" {static PyObject *meth_wxStatusBarPane_GetStyle(PyObject *, PyObject *);}
static PyObject *meth_wxStatusBarPane_GetStyle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxStatusBarPane *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxStatusBarPane, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetStyle();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_StatusBarPane, sipName_GetStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxStatusBarPane_GetText, "GetText() -> String\n"
"\n"
"Returns the text currently shown in this pane.");

extern "C" {static PyObject *meth_wxStatusBarPane_GetText(PyObject *, PyObject *);}
static PyObject *meth_wxStatusBarPane_GetText(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxStatusBarPane *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxStatusBarPane, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetText());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_StatusBarPane, sipName_GetText, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxStatusBarPane_IsEllipsized, "IsEllipsized() -> bool");

extern "C" {static PyObject *meth_wxStatusBarPane_IsEllipsized(PyObject *, PyObject *);}
static PyObject *meth_wxStatusBarPane_IsEllipsized(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxStatusBarPane *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxStatusBarPane, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsEllipsized();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_StatusBarPane, sipName_IsEllipsized, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxStatusBarPane_SetIsEllipsized, "SetIsEllipsized(isEllipsized)");

extern "C" {static PyObject *meth_wxStatusBarPane_SetIsEllipsized(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxStatusBarPane_SetIsEllipsized(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool isEllipsized;
         ::wxStatusBarPane *sipCpp;

        static const char *sipKwdList[] = {
            sipName_isEllipsized,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bb", &sipSelf, sipType_wxStatusBarPane, &sipCpp, &isEllipsized))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetIsEllipsized(isEllipsized);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_StatusBarPane, sipName_SetIsEllipsized, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxStatusBarPane_SetWidth, "SetWidth(width)");

extern "C" {static PyObject *meth_wxStatusBarPane_SetWidth(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxStatusBarPane_SetWidth(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int width;
         ::wxStatusBarPane *sipCpp;

        static const char *sipKwdList[] = {
            sipName_width,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxStatusBarPane, &sipCpp, &width))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetWidth(width);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_StatusBarPane, sipName_SetWidth, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxStatusBarPane_SetStyle, "SetStyle(style)");

extern "C" {static PyObject *meth_wxStatusBarPane_SetStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxStatusBarPane_SetStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int style;
         ::wxStatusBarPane *sipCpp;

        static const char *sipKwdList[] = {
            sipName_style,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxStatusBarPane, &sipCpp, &style))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetStyle(style);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_StatusBarPane, sipName_SetStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxStatusBarPane_SetText, "SetText(text) -> bool\n"
"\n"
"Set text.");

extern "C" {static PyObject *meth_wxStatusBarPane_SetText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxStatusBarPane_SetText(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* text;
        int textState = 0;
         ::wxStatusBarPane *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxStatusBarPane, &sipCpp, sipType_wxString,&text, &textState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetText(*text);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_StatusBarPane, sipName_SetText, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxStatusBarPane_PushText, "PushText(text) -> bool\n"
"\n"
"Save the existing text on top of a stack and make the new text\n"
"current.");

extern "C" {static PyObject *meth_wxStatusBarPane_PushText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxStatusBarPane_PushText(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* text;
        int textState = 0;
         ::wxStatusBarPane *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxStatusBarPane, &sipCpp, sipType_wxString,&text, &textState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->PushText(*text);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_StatusBarPane, sipName_PushText, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxStatusBarPane_PopText, "PopText() -> bool\n"
"\n"
"Restore the message saved by the last call to Push() (unless it was\n"
"changed by an intervening call to SetText()) and return true if we\n"
"really restored anything.");

extern "C" {static PyObject *meth_wxStatusBarPane_PopText(PyObject *, PyObject *);}
static PyObject *meth_wxStatusBarPane_PopText(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxStatusBarPane *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxStatusBarPane, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->PopText();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_StatusBarPane, sipName_PopText, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxStatusBarPane(void *, int);}
static void release_wxStatusBarPane(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxStatusBarPane *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxStatusBarPane(void *, SIP_SSIZE_T, void *);}
static void assign_wxStatusBarPane(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxStatusBarPane *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxStatusBarPane *>(sipSrc);
}


extern "C" {static void *array_wxStatusBarPane(SIP_SSIZE_T);}
static void *array_wxStatusBarPane(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxStatusBarPane[sipNrElem];
}


extern "C" {static void *copy_wxStatusBarPane(const void *, SIP_SSIZE_T);}
static void *copy_wxStatusBarPane(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxStatusBarPane(reinterpret_cast<const  ::wxStatusBarPane *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxStatusBarPane(sipSimpleWrapper *);}
static void dealloc_wxStatusBarPane(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxStatusBarPane(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxStatusBarPane(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxStatusBarPane(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxStatusBarPane *sipCpp = 0;

    {
        int style = wxSB_NORMAL;
        int width = 0;

        static const char *sipKwdList[] = {
            sipName_style,
            sipName_width,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|ii", &style, &width))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxStatusBarPane(style,width);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxStatusBarPane* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxStatusBarPane, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxStatusBarPane(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return NULL;
}


static PyMethodDef methods_wxStatusBarPane[] = {
    {SIP_MLNAME_CAST(sipName_GetStyle), meth_wxStatusBarPane_GetStyle, METH_VARARGS, SIP_MLDOC_CAST(doc_wxStatusBarPane_GetStyle)},
    {SIP_MLNAME_CAST(sipName_GetText), meth_wxStatusBarPane_GetText, METH_VARARGS, SIP_MLDOC_CAST(doc_wxStatusBarPane_GetText)},
    {SIP_MLNAME_CAST(sipName_GetWidth), meth_wxStatusBarPane_GetWidth, METH_VARARGS, SIP_MLDOC_CAST(doc_wxStatusBarPane_GetWidth)},
    {SIP_MLNAME_CAST(sipName_IsEllipsized), meth_wxStatusBarPane_IsEllipsized, METH_VARARGS, SIP_MLDOC_CAST(doc_wxStatusBarPane_IsEllipsized)},
    {SIP_MLNAME_CAST(sipName_PopText), meth_wxStatusBarPane_PopText, METH_VARARGS, SIP_MLDOC_CAST(doc_wxStatusBarPane_PopText)},
    {SIP_MLNAME_CAST(sipName_PushText), (PyCFunction)meth_wxStatusBarPane_PushText, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxStatusBarPane_PushText)},
    {SIP_MLNAME_CAST(sipName_SetIsEllipsized), (PyCFunction)meth_wxStatusBarPane_SetIsEllipsized, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxStatusBarPane_SetIsEllipsized)},
    {SIP_MLNAME_CAST(sipName_SetStyle), (PyCFunction)meth_wxStatusBarPane_SetStyle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxStatusBarPane_SetStyle)},
    {SIP_MLNAME_CAST(sipName_SetText), (PyCFunction)meth_wxStatusBarPane_SetText, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxStatusBarPane_SetText)},
    {SIP_MLNAME_CAST(sipName_SetWidth), (PyCFunction)meth_wxStatusBarPane_SetWidth, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxStatusBarPane_SetWidth)}
};

sipVariableDef variables_wxStatusBarPane[] = {
    {PropertyVariable, sipName_Width, &methods_wxStatusBarPane[2], &methods_wxStatusBarPane[9], NULL, NULL},
    {PropertyVariable, sipName_Text, &methods_wxStatusBarPane[1], &methods_wxStatusBarPane[8], NULL, NULL},
    {PropertyVariable, sipName_Style, &methods_wxStatusBarPane[0], &methods_wxStatusBarPane[7], NULL, NULL},
};

PyDoc_STRVAR(doc_wxStatusBarPane, "StatusBarPane(style=SB_NORMAL, width=0)\n"
"\n"
"A status bar pane data container used by wxStatusBar.");


sipClassTypeDef sipTypeDef__core_wxStatusBarPane = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxStatusBarPane,
        {0},
        0
    },
    {
        sipNameNr_StatusBarPane,
        {0, 0, 1},
        10, methods_wxStatusBarPane,
        0, 0,
        3, variables_wxStatusBarPane,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxStatusBarPane,
    -1,
    -1,
    0,
    0,
    init_type_wxStatusBarPane,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxStatusBarPane,
    assign_wxStatusBarPane,
    array_wxStatusBarPane,
    copy_wxStatusBarPane,
    release_wxStatusBarPane,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
