/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/sysopt.h>

        #include <wx/object.h>
        #include <wx/object.h>


PyDoc_STRVAR(doc_wxSystemOptions_SetOption, "SetOption(name, value)\n"
"SetOption(name, value)\n"
"\n"
"Sets an option.\n"
"");

extern "C" {static PyObject *meth_wxSystemOptions_SetOption(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSystemOptions_SetOption(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxString* value;
        int valueState = 0;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1J1", sipType_wxString,&name, &nameState, sipType_wxString,&value, &valueState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxSystemOptions::SetOption(*name,*value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);
            sipReleaseType(const_cast< ::wxString *>(value),sipType_wxString,valueState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxString* name;
        int nameState = 0;
        int value;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1i", sipType_wxString,&name, &nameState, &value))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxSystemOptions::SetOption(*name,value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SystemOptions, sipName_SetOption, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSystemOptions_GetOption, "GetOption(name) -> String\n"
"\n"
"Gets an option.");

extern "C" {static PyObject *meth_wxSystemOptions_GetOption(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSystemOptions_GetOption(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&name, &nameState))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString( ::wxSystemOptions::GetOption(*name));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SystemOptions, sipName_GetOption, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSystemOptions_GetOptionInt, "GetOptionInt(name) -> int\n"
"\n"
"Gets an option as an integer.");

extern "C" {static PyObject *meth_wxSystemOptions_GetOptionInt(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSystemOptions_GetOptionInt(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&name, &nameState))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxSystemOptions::GetOptionInt(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SystemOptions, sipName_GetOptionInt, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSystemOptions_HasOption, "HasOption(name) -> bool\n"
"\n"
"Returns true if the given option is present.");

extern "C" {static PyObject *meth_wxSystemOptions_HasOption(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSystemOptions_HasOption(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&name, &nameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxSystemOptions::HasOption(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SystemOptions, sipName_HasOption, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSystemOptions_IsFalse, "IsFalse(name) -> bool\n"
"\n"
"Returns true if the option with the given name had been set to 0\n"
"value.");

extern "C" {static PyObject *meth_wxSystemOptions_IsFalse(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSystemOptions_IsFalse(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&name, &nameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxSystemOptions::IsFalse(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SystemOptions, sipName_IsFalse, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxSystemOptions(void *, const sipTypeDef *);}
static void *cast_wxSystemOptions(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxSystemOptions *sipCpp = reinterpret_cast< ::wxSystemOptions *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxSystemOptions(void *, int);}
static void release_wxSystemOptions(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxSystemOptions *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxSystemOptions(void *, SIP_SSIZE_T, void *);}
static void assign_wxSystemOptions(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxSystemOptions *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxSystemOptions *>(sipSrc);
}


extern "C" {static void *array_wxSystemOptions(SIP_SSIZE_T);}
static void *array_wxSystemOptions(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxSystemOptions[sipNrElem];
}


extern "C" {static void *copy_wxSystemOptions(const void *, SIP_SSIZE_T);}
static void *copy_wxSystemOptions(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxSystemOptions(reinterpret_cast<const  ::wxSystemOptions *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxSystemOptions(sipSimpleWrapper *);}
static void dealloc_wxSystemOptions(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxSystemOptions(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxSystemOptions(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxSystemOptions(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxSystemOptions *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxSystemOptions();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxSystemOptions* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxSystemOptions, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxSystemOptions(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxSystemOptions[] = {{348, 255, 1}};


static PyMethodDef methods_wxSystemOptions[] = {
    {SIP_MLNAME_CAST(sipName_GetOption), (PyCFunction)meth_wxSystemOptions_GetOption, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxSystemOptions_GetOption)},
    {SIP_MLNAME_CAST(sipName_GetOptionInt), (PyCFunction)meth_wxSystemOptions_GetOptionInt, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxSystemOptions_GetOptionInt)},
    {SIP_MLNAME_CAST(sipName_HasOption), (PyCFunction)meth_wxSystemOptions_HasOption, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxSystemOptions_HasOption)},
    {SIP_MLNAME_CAST(sipName_IsFalse), (PyCFunction)meth_wxSystemOptions_IsFalse, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxSystemOptions_IsFalse)},
    {SIP_MLNAME_CAST(sipName_SetOption), (PyCFunction)meth_wxSystemOptions_SetOption, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxSystemOptions_SetOption)}
};

PyDoc_STRVAR(doc_wxSystemOptions, "SystemOptions()\n"
"\n"
"wxSystemOptions stores option/value pairs that wxWidgets itself or\n"
"applications can use to alter behaviour at run-time.");


sipClassTypeDef sipTypeDef__core_wxSystemOptions = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxSystemOptions,
        {0},
        0
    },
    {
        sipNameNr_SystemOptions,
        {0, 0, 1},
        5, methods_wxSystemOptions,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxSystemOptions,
    -1,
    -1,
    supers_wxSystemOptions,
    0,
    init_type_wxSystemOptions,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxSystemOptions,
    assign_wxSystemOptions,
    array_wxSystemOptions,
    copy_wxSystemOptions,
    release_wxSystemOptions,
    cast_wxSystemOptions,
    0,
    0,
    0,
    0,
    0,
    0
};
