/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/settings.h>

        #include <wx/window.h>
        #include <wx/font.h>
        #include <wx/colour.h>


PyDoc_STRVAR(doc_wxSystemSettings_GetColour, "GetColour(index) -> Colour\n"
"\n"
"Returns a system colour.");

extern "C" {static PyObject *meth_wxSystemSettings_GetColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSystemSettings_GetColour(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxSystemColour index;

        static const char *sipKwdList[] = {
            sipName_index,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "E", sipType_wxSystemColour, &index))
        {
             ::wxColour*sipRes;

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxColour( ::wxSystemSettings::GetColour(index));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxColour,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SystemSettings, sipName_GetColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSystemSettings_GetFont, "GetFont(index) -> Font\n"
"\n"
"Returns a system font.");

extern "C" {static PyObject *meth_wxSystemSettings_GetFont(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSystemSettings_GetFont(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxSystemFont index;

        static const char *sipKwdList[] = {
            sipName_index,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "E", sipType_wxSystemFont, &index))
        {
             ::wxFont*sipRes;

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxFont( ::wxSystemSettings::GetFont(index));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFont,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SystemSettings, sipName_GetFont, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSystemSettings_GetMetric, "GetMetric(index, win=None) -> int\n"
"\n"
"Returns the value of a system metric, or -1 if the metric is not\n"
"supported on the current system.");

extern "C" {static PyObject *meth_wxSystemSettings_GetMetric(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSystemSettings_GetMetric(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxSystemMetric index;
         ::wxWindow* win = 0;

        static const char *sipKwdList[] = {
            sipName_index,
            sipName_win,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "E|J8", sipType_wxSystemMetric, &index, sipType_wxWindow, &win))
        {
            int sipRes;

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxSystemSettings::GetMetric(index,win);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SystemSettings, sipName_GetMetric, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSystemSettings_GetScreenType, "GetScreenType() -> SystemScreenType\n"
"\n"
"Returns the screen type.");

extern "C" {static PyObject *meth_wxSystemSettings_GetScreenType(PyObject *, PyObject *);}
static PyObject *meth_wxSystemSettings_GetScreenType(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxSystemScreenType sipRes;

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxSystemSettings::GetScreenType();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxSystemScreenType);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SystemSettings, sipName_GetScreenType, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSystemSettings_HasFeature, "HasFeature(index) -> bool\n"
"\n"
"Returns true if the port has certain feature.");

extern "C" {static PyObject *meth_wxSystemSettings_HasFeature(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSystemSettings_HasFeature(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxSystemFeature index;

        static const char *sipKwdList[] = {
            sipName_index,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "E", sipType_wxSystemFeature, &index))
        {
            bool sipRes;

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxSystemSettings::HasFeature(index);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_SystemSettings, sipName_HasFeature, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxSystemSettings(void *, int);}
static void release_wxSystemSettings(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxSystemSettings *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxSystemSettings(void *, SIP_SSIZE_T, void *);}
static void assign_wxSystemSettings(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxSystemSettings *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxSystemSettings *>(sipSrc);
}


extern "C" {static void *array_wxSystemSettings(SIP_SSIZE_T);}
static void *array_wxSystemSettings(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxSystemSettings[sipNrElem];
}


extern "C" {static void *copy_wxSystemSettings(const void *, SIP_SSIZE_T);}
static void *copy_wxSystemSettings(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxSystemSettings(reinterpret_cast<const  ::wxSystemSettings *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxSystemSettings(sipSimpleWrapper *);}
static void dealloc_wxSystemSettings(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxSystemSettings(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxSystemSettings(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxSystemSettings(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxSystemSettings *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxSystemSettings();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxSystemSettings* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxSystemSettings, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxSystemSettings(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return NULL;
}


static PyMethodDef methods_wxSystemSettings[] = {
    {SIP_MLNAME_CAST(sipName_GetColour), (PyCFunction)meth_wxSystemSettings_GetColour, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxSystemSettings_GetColour)},
    {SIP_MLNAME_CAST(sipName_GetFont), (PyCFunction)meth_wxSystemSettings_GetFont, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxSystemSettings_GetFont)},
    {SIP_MLNAME_CAST(sipName_GetMetric), (PyCFunction)meth_wxSystemSettings_GetMetric, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxSystemSettings_GetMetric)},
    {SIP_MLNAME_CAST(sipName_GetScreenType), meth_wxSystemSettings_GetScreenType, METH_VARARGS, SIP_MLDOC_CAST(doc_wxSystemSettings_GetScreenType)},
    {SIP_MLNAME_CAST(sipName_HasFeature), (PyCFunction)meth_wxSystemSettings_HasFeature, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxSystemSettings_HasFeature)}
};

PyDoc_STRVAR(doc_wxSystemSettings, "SystemSettings()\n"
"\n"
"wxSystemSettings allows the application to ask for details about the\n"
"system.");


sipClassTypeDef sipTypeDef__core_wxSystemSettings = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxSystemSettings,
        {0},
        0
    },
    {
        sipNameNr_SystemSettings,
        {0, 0, 1},
        5, methods_wxSystemSettings,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxSystemSettings,
    -1,
    -1,
    0,
    0,
    init_type_wxSystemSettings,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxSystemSettings,
    assign_wxSystemSettings,
    array_wxSystemSettings,
    copy_wxSystemSettings,
    release_wxSystemSettings,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
