/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/textentry.h>

        #include <wx/gdicmn.h>
        #include <wx/textcompleter.h>


PyDoc_STRVAR(doc_wxTextEntry_SetMargins, "SetMargins(pt) -> bool\n"
"SetMargins(left, top=-1) -> bool\n"
"\n"
"Attempts to set the control margins.\n"
"");

extern "C" {static PyObject *meth_wxTextEntry_SetMargins(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_SetMargins(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPoint* pt;
        int ptState = 0;
         ::wxTextEntry *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxTextEntry, &sipCpp, sipType_wxPoint, &pt, &ptState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetMargins(*pt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt),sipType_wxPoint,ptState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
         ::wxCoord left;
         ::wxCoord top = -1;
         ::wxTextEntry *sipCpp;

        static const char *sipKwdList[] = {
            sipName_left,
            sipName_top,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi|i", &sipSelf, sipType_wxTextEntry, &sipCpp, &left, &top))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetMargins(left,top);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_SetMargins, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_AppendText, "AppendText(text)\n"
"\n"
"Appends the text to the end of the text control.");

extern "C" {static PyObject *meth_wxTextEntry_AppendText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_AppendText(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* text;
        int textState = 0;
         ::wxTextEntry *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxTextEntry, &sipCpp, sipType_wxString,&text, &textState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AppendText(*text);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_AppendText, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_AutoComplete, "AutoComplete(choices) -> bool\n"
"AutoComplete(completer) -> bool\n"
"\n"
"Call this function to enable auto-completion of the text typed in a\n"
"single-line text control using the given choices.\n"
"");

extern "C" {static PyObject *meth_wxTextEntry_AutoComplete(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_AutoComplete(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxArrayString* choices;
        int choicesState = 0;
         ::wxTextEntry *sipCpp;

        static const char *sipKwdList[] = {
            sipName_choices,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxTextEntry, &sipCpp, sipType_wxArrayString,&choices, &choicesState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->AutoComplete(*choices);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxArrayString *>(choices),sipType_wxArrayString,choicesState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
         ::wxTextCompleter* completer;
         ::wxTextEntry *sipCpp;

        static const char *sipKwdList[] = {
            sipName_completer,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ:", &sipSelf, sipType_wxTextEntry, &sipCpp, sipType_wxTextCompleter, &completer))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->AutoComplete(completer);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_AutoComplete, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_AutoCompleteFileNames, "AutoCompleteFileNames() -> bool\n"
"\n"
"Call this function to enable auto-completion of the text typed in a\n"
"single-line text control using all valid file system paths.");

extern "C" {static PyObject *meth_wxTextEntry_AutoCompleteFileNames(PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_AutoCompleteFileNames(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextEntry, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->AutoCompleteFileNames();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_AutoCompleteFileNames, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_AutoCompleteDirectories, "AutoCompleteDirectories() -> bool\n"
"\n"
"Call this function to enable auto-completion of the text using the\n"
"file system directories.");

extern "C" {static PyObject *meth_wxTextEntry_AutoCompleteDirectories(PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_AutoCompleteDirectories(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextEntry, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->AutoCompleteDirectories();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_AutoCompleteDirectories, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_CanCopy, "CanCopy() -> bool\n"
"\n"
"Returns true if the selection can be copied to the clipboard.");

extern "C" {static PyObject *meth_wxTextEntry_CanCopy(PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_CanCopy(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextEntry, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CanCopy();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_CanCopy, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_CanCut, "CanCut() -> bool\n"
"\n"
"Returns true if the selection can be cut to the clipboard.");

extern "C" {static PyObject *meth_wxTextEntry_CanCut(PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_CanCut(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextEntry, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CanCut();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_CanCut, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_CanPaste, "CanPaste() -> bool\n"
"\n"
"Returns true if the contents of the clipboard can be pasted into the\n"
"text control.");

extern "C" {static PyObject *meth_wxTextEntry_CanPaste(PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_CanPaste(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextEntry, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CanPaste();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_CanPaste, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_CanRedo, "CanRedo() -> bool\n"
"\n"
"Returns true if there is a redo facility available and the last\n"
"operation can be redone.");

extern "C" {static PyObject *meth_wxTextEntry_CanRedo(PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_CanRedo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextEntry, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CanRedo();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_CanRedo, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_CanUndo, "CanUndo() -> bool\n"
"\n"
"Returns true if there is an undo facility available and the last\n"
"operation can be undone.");

extern "C" {static PyObject *meth_wxTextEntry_CanUndo(PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_CanUndo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextEntry, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CanUndo();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_CanUndo, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_ChangeValue, "ChangeValue(value)\n"
"\n"
"Sets the new text control value.");

extern "C" {static PyObject *meth_wxTextEntry_ChangeValue(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_ChangeValue(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* value;
        int valueState = 0;
         ::wxTextEntry *sipCpp;

        static const char *sipKwdList[] = {
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxTextEntry, &sipCpp, sipType_wxString,&value, &valueState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->ChangeValue(*value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(value),sipType_wxString,valueState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_ChangeValue, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_Clear, "Clear()\n"
"\n"
"Clears the text in the control.");

extern "C" {static PyObject *meth_wxTextEntry_Clear(PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_Clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextEntry, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Clear();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_Clear, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_Copy, "Copy()\n"
"\n"
"Copies the selected text to the clipboard.");

extern "C" {static PyObject *meth_wxTextEntry_Copy(PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_Copy(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextEntry, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Copy();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_Copy, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_Cut, "Cut()\n"
"\n"
"Copies the selected text to the clipboard and removes it from the\n"
"control.");

extern "C" {static PyObject *meth_wxTextEntry_Cut(PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_Cut(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextEntry, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Cut();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_Cut, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_GetInsertionPoint, "GetInsertionPoint() -> long\n"
"\n"
"Returns the insertion point, or cursor, position.");

extern "C" {static PyObject *meth_wxTextEntry_GetInsertionPoint(PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_GetInsertionPoint(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextEntry, &sipCpp))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetInsertionPoint();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_GetInsertionPoint, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_GetLastPosition, "GetLastPosition() -> TextPos\n"
"\n"
"Returns the zero based index of the last position in the text control,\n"
"which is equal to the number of characters in the control.");

extern "C" {static PyObject *meth_wxTextEntry_GetLastPosition(PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_GetLastPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextEntry, &sipCpp))
        {
             ::wxTextPos sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLastPosition();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_GetLastPosition, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_GetRange, "GetRange(from_, to_) -> String\n"
"\n"
"Returns the string containing the text starting in the positions from\n"
"and up to to in the control.");

extern "C" {static PyObject *meth_wxTextEntry_GetRange(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_GetRange(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        long from_;
        long to_;
        const  ::wxTextEntry *sipCpp;

        static const char *sipKwdList[] = {
            sipName_from_,
            sipName_to_,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bll", &sipSelf, sipType_wxTextEntry, &sipCpp, &from_, &to_))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetRange(from_,to_));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_GetRange, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_GetSelection, "GetSelection() -> (from, to)\n"
"\n"
"Gets the current selection span.");

extern "C" {static PyObject *meth_wxTextEntry_GetSelection(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_GetSelection(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        long from;
        long to;
        const  ::wxTextEntry *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, "B", &sipSelf, sipType_wxTextEntry, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GetSelection(&from,&to);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(ll)",from,to);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_GetSelection, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_GetStringSelection, "GetStringSelection() -> String\n"
"\n"
"Gets the text currently selected in the control.");

extern "C" {static PyObject *meth_wxTextEntry_GetStringSelection(PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_GetStringSelection(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextEntry, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetStringSelection());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_GetStringSelection, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_GetValue, "GetValue() -> String\n"
"\n"
"Gets the contents of the control.");

extern "C" {static PyObject *meth_wxTextEntry_GetValue(PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_GetValue(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextEntry, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetValue());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_GetValue, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_IsEditable, "IsEditable() -> bool\n"
"\n"
"Returns true if the controls contents may be edited by user (note that\n"
"it always can be changed by the program).");

extern "C" {static PyObject *meth_wxTextEntry_IsEditable(PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_IsEditable(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextEntry, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsEditable();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_IsEditable, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_IsEmpty, "IsEmpty() -> bool\n"
"\n"
"Returns true if the control is currently empty.");

extern "C" {static PyObject *meth_wxTextEntry_IsEmpty(PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_IsEmpty(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextEntry, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsEmpty();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_IsEmpty, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_Paste, "Paste()\n"
"\n"
"Pastes text from the clipboard to the text item.");

extern "C" {static PyObject *meth_wxTextEntry_Paste(PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_Paste(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextEntry, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Paste();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_Paste, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_Redo, "Redo()\n"
"\n"
"If there is a redo facility and the last operation can be redone,\n"
"redoes the last operation.");

extern "C" {static PyObject *meth_wxTextEntry_Redo(PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_Redo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextEntry, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Redo();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_Redo, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_Remove, "Remove(from_, to_)\n"
"\n"
"Removes the text starting at the first given position up to (but not\n"
"including) the character at the last position.");

extern "C" {static PyObject *meth_wxTextEntry_Remove(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_Remove(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        long from_;
        long to_;
         ::wxTextEntry *sipCpp;

        static const char *sipKwdList[] = {
            sipName_from_,
            sipName_to_,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bll", &sipSelf, sipType_wxTextEntry, &sipCpp, &from_, &to_))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Remove(from_,to_);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_Remove, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_Replace, "Replace(from_, to_, value)\n"
"\n"
"Replaces the text starting at the first position up to (but not\n"
"including) the character at the last position with the given text.");

extern "C" {static PyObject *meth_wxTextEntry_Replace(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_Replace(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        long from_;
        long to_;
        const  ::wxString* value;
        int valueState = 0;
         ::wxTextEntry *sipCpp;

        static const char *sipKwdList[] = {
            sipName_from_,
            sipName_to_,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BllJ1", &sipSelf, sipType_wxTextEntry, &sipCpp, &from_, &to_, sipType_wxString,&value, &valueState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Replace(from_,to_,*value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(value),sipType_wxString,valueState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_Replace, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_SetEditable, "SetEditable(editable)\n"
"\n"
"Makes the text item editable or read-only, overriding the\n"
"wxTE_READONLY flag.");

extern "C" {static PyObject *meth_wxTextEntry_SetEditable(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_SetEditable(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool editable;
         ::wxTextEntry *sipCpp;

        static const char *sipKwdList[] = {
            sipName_editable,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bb", &sipSelf, sipType_wxTextEntry, &sipCpp, &editable))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetEditable(editable);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_SetEditable, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_SetInsertionPoint, "SetInsertionPoint(pos)\n"
"\n"
"Sets the insertion point at the given position.");

extern "C" {static PyObject *meth_wxTextEntry_SetInsertionPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_SetInsertionPoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        long pos;
         ::wxTextEntry *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bl", &sipSelf, sipType_wxTextEntry, &sipCpp, &pos))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetInsertionPoint(pos);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_SetInsertionPoint, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_SetInsertionPointEnd, "SetInsertionPointEnd()\n"
"\n"
"Sets the insertion point at the end of the text control.");

extern "C" {static PyObject *meth_wxTextEntry_SetInsertionPointEnd(PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_SetInsertionPointEnd(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextEntry, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetInsertionPointEnd();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_SetInsertionPointEnd, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_SetMaxLength, "SetMaxLength(len)\n"
"\n"
"This function sets the maximum number of characters the user can enter\n"
"into the control.");

extern "C" {static PyObject *meth_wxTextEntry_SetMaxLength(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_SetMaxLength(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        unsigned long len;
         ::wxTextEntry *sipCpp;

        static const char *sipKwdList[] = {
            sipName_len,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bm", &sipSelf, sipType_wxTextEntry, &sipCpp, &len))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetMaxLength(len);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_SetMaxLength, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_SetSelection, "SetSelection(from_, to_)\n"
"\n"
"Selects the text starting at the first position up to (but not\n"
"including) the character at the last position.");

extern "C" {static PyObject *meth_wxTextEntry_SetSelection(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_SetSelection(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        long from_;
        long to_;
         ::wxTextEntry *sipCpp;

        static const char *sipKwdList[] = {
            sipName_from_,
            sipName_to_,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bll", &sipSelf, sipType_wxTextEntry, &sipCpp, &from_, &to_))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetSelection(from_,to_);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_SetSelection, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_SelectAll, "SelectAll()\n"
"\n"
"Selects all text in the control.");

extern "C" {static PyObject *meth_wxTextEntry_SelectAll(PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_SelectAll(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextEntry, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SelectAll();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_SelectAll, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_SelectNone, "SelectNone()\n"
"\n"
"Deselects selected text in the control.");

extern "C" {static PyObject *meth_wxTextEntry_SelectNone(PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_SelectNone(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextEntry, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SelectNone();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_SelectNone, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_SetHint, "SetHint(hint) -> bool\n"
"\n"
"Sets a hint shown in an empty unfocused text control.");

extern "C" {static PyObject *meth_wxTextEntry_SetHint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_SetHint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* hint;
        int hintState = 0;
         ::wxTextEntry *sipCpp;

        static const char *sipKwdList[] = {
            sipName_hint,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxTextEntry, &sipCpp, sipType_wxString,&hint, &hintState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetHint(*hint);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(hint),sipType_wxString,hintState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_SetHint, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_GetHint, "GetHint() -> String\n"
"\n"
"Returns the current hint string.");

extern "C" {static PyObject *meth_wxTextEntry_GetHint(PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_GetHint(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextEntry, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetHint());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_GetHint, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_GetMargins, "GetMargins() -> Point\n"
"\n"
"Returns the margins used by the control.");

extern "C" {static PyObject *meth_wxTextEntry_GetMargins(PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_GetMargins(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextEntry, &sipCpp))
        {
             ::wxPoint*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPoint(sipCpp->GetMargins());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPoint,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_GetMargins, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_SetValue, "SetValue(value)\n"
"\n"
"Sets the new text control value.");

extern "C" {static PyObject *meth_wxTextEntry_SetValue(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_SetValue(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* value;
        int valueState = 0;
         ::wxTextEntry *sipCpp;

        static const char *sipKwdList[] = {
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxTextEntry, &sipCpp, sipType_wxString,&value, &valueState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetValue(*value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(value),sipType_wxString,valueState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_SetValue, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_Undo, "Undo()\n"
"\n"
"If there is an undo facility and the last operation can be undone,\n"
"undoes the last operation.");

extern "C" {static PyObject *meth_wxTextEntry_Undo(PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_Undo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextEntry, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Undo();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_Undo, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextEntry_WriteText, "WriteText(text)\n"
"\n"
"Writes the text into the text control at the current insertion\n"
"position.");

extern "C" {static PyObject *meth_wxTextEntry_WriteText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextEntry_WriteText(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* text;
        int textState = 0;
         ::wxTextEntry *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxTextEntry, &sipCpp, sipType_wxString,&text, &textState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->WriteText(*text);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextEntry, sipName_WriteText, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxTextEntry(void *, int);}
static void release_wxTextEntry(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxTextEntry *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxTextEntry(sipSimpleWrapper *);}
static void dealloc_wxTextEntry(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxTextEntry(sipGetAddress(sipSelf), 0);
    }
}


static PyMethodDef methods_wxTextEntry[] = {
    {SIP_MLNAME_CAST(sipName_AppendText), (PyCFunction)meth_wxTextEntry_AppendText, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextEntry_AppendText)},
    {SIP_MLNAME_CAST(sipName_AutoComplete), (PyCFunction)meth_wxTextEntry_AutoComplete, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextEntry_AutoComplete)},
    {SIP_MLNAME_CAST(sipName_AutoCompleteDirectories), meth_wxTextEntry_AutoCompleteDirectories, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextEntry_AutoCompleteDirectories)},
    {SIP_MLNAME_CAST(sipName_AutoCompleteFileNames), meth_wxTextEntry_AutoCompleteFileNames, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextEntry_AutoCompleteFileNames)},
    {SIP_MLNAME_CAST(sipName_CanCopy), meth_wxTextEntry_CanCopy, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextEntry_CanCopy)},
    {SIP_MLNAME_CAST(sipName_CanCut), meth_wxTextEntry_CanCut, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextEntry_CanCut)},
    {SIP_MLNAME_CAST(sipName_CanPaste), meth_wxTextEntry_CanPaste, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextEntry_CanPaste)},
    {SIP_MLNAME_CAST(sipName_CanRedo), meth_wxTextEntry_CanRedo, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextEntry_CanRedo)},
    {SIP_MLNAME_CAST(sipName_CanUndo), meth_wxTextEntry_CanUndo, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextEntry_CanUndo)},
    {SIP_MLNAME_CAST(sipName_ChangeValue), (PyCFunction)meth_wxTextEntry_ChangeValue, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextEntry_ChangeValue)},
    {SIP_MLNAME_CAST(sipName_Clear), meth_wxTextEntry_Clear, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextEntry_Clear)},
    {SIP_MLNAME_CAST(sipName_Copy), meth_wxTextEntry_Copy, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextEntry_Copy)},
    {SIP_MLNAME_CAST(sipName_Cut), meth_wxTextEntry_Cut, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextEntry_Cut)},
    {SIP_MLNAME_CAST(sipName_GetHint), meth_wxTextEntry_GetHint, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextEntry_GetHint)},
    {SIP_MLNAME_CAST(sipName_GetInsertionPoint), meth_wxTextEntry_GetInsertionPoint, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextEntry_GetInsertionPoint)},
    {SIP_MLNAME_CAST(sipName_GetLastPosition), meth_wxTextEntry_GetLastPosition, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextEntry_GetLastPosition)},
    {SIP_MLNAME_CAST(sipName_GetMargins), meth_wxTextEntry_GetMargins, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextEntry_GetMargins)},
    {SIP_MLNAME_CAST(sipName_GetRange), (PyCFunction)meth_wxTextEntry_GetRange, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextEntry_GetRange)},
    {SIP_MLNAME_CAST(sipName_GetSelection), (PyCFunction)meth_wxTextEntry_GetSelection, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextEntry_GetSelection)},
    {SIP_MLNAME_CAST(sipName_GetStringSelection), meth_wxTextEntry_GetStringSelection, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextEntry_GetStringSelection)},
    {SIP_MLNAME_CAST(sipName_GetValue), meth_wxTextEntry_GetValue, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextEntry_GetValue)},
    {SIP_MLNAME_CAST(sipName_IsEditable), meth_wxTextEntry_IsEditable, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextEntry_IsEditable)},
    {SIP_MLNAME_CAST(sipName_IsEmpty), meth_wxTextEntry_IsEmpty, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextEntry_IsEmpty)},
    {SIP_MLNAME_CAST(sipName_Paste), meth_wxTextEntry_Paste, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextEntry_Paste)},
    {SIP_MLNAME_CAST(sipName_Redo), meth_wxTextEntry_Redo, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextEntry_Redo)},
    {SIP_MLNAME_CAST(sipName_Remove), (PyCFunction)meth_wxTextEntry_Remove, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextEntry_Remove)},
    {SIP_MLNAME_CAST(sipName_Replace), (PyCFunction)meth_wxTextEntry_Replace, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextEntry_Replace)},
    {SIP_MLNAME_CAST(sipName_SelectAll), meth_wxTextEntry_SelectAll, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextEntry_SelectAll)},
    {SIP_MLNAME_CAST(sipName_SelectNone), meth_wxTextEntry_SelectNone, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextEntry_SelectNone)},
    {SIP_MLNAME_CAST(sipName_SetEditable), (PyCFunction)meth_wxTextEntry_SetEditable, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextEntry_SetEditable)},
    {SIP_MLNAME_CAST(sipName_SetHint), (PyCFunction)meth_wxTextEntry_SetHint, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextEntry_SetHint)},
    {SIP_MLNAME_CAST(sipName_SetInsertionPoint), (PyCFunction)meth_wxTextEntry_SetInsertionPoint, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextEntry_SetInsertionPoint)},
    {SIP_MLNAME_CAST(sipName_SetInsertionPointEnd), meth_wxTextEntry_SetInsertionPointEnd, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextEntry_SetInsertionPointEnd)},
    {SIP_MLNAME_CAST(sipName_SetMargins), (PyCFunction)meth_wxTextEntry_SetMargins, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextEntry_SetMargins)},
    {SIP_MLNAME_CAST(sipName_SetMaxLength), (PyCFunction)meth_wxTextEntry_SetMaxLength, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextEntry_SetMaxLength)},
    {SIP_MLNAME_CAST(sipName_SetSelection), (PyCFunction)meth_wxTextEntry_SetSelection, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextEntry_SetSelection)},
    {SIP_MLNAME_CAST(sipName_SetValue), (PyCFunction)meth_wxTextEntry_SetValue, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextEntry_SetValue)},
    {SIP_MLNAME_CAST(sipName_Undo), meth_wxTextEntry_Undo, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextEntry_Undo)},
    {SIP_MLNAME_CAST(sipName_WriteText), (PyCFunction)meth_wxTextEntry_WriteText, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextEntry_WriteText)}
};

sipVariableDef variables_wxTextEntry[] = {
    {PropertyVariable, sipName_Value, &methods_wxTextEntry[20], &methods_wxTextEntry[36], NULL, NULL},
    {PropertyVariable, sipName_StringSelection, &methods_wxTextEntry[19], NULL, NULL, NULL},
    {PropertyVariable, sipName_Margins, &methods_wxTextEntry[16], &methods_wxTextEntry[33], NULL, NULL},
    {PropertyVariable, sipName_LastPosition, &methods_wxTextEntry[15], NULL, NULL, NULL},
    {PropertyVariable, sipName_InsertionPoint, &methods_wxTextEntry[14], &methods_wxTextEntry[31], NULL, NULL},
    {PropertyVariable, sipName_Hint, &methods_wxTextEntry[13], &methods_wxTextEntry[30], NULL, NULL},
};

PyDoc_STRVAR(doc_wxTextEntry, "Common base class for single line text entry fields.");


sipClassTypeDef sipTypeDef__core_wxTextEntry = {
    {
        -1,
        0,
        0,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxTextEntry,
        {0},
        0
    },
    {
        sipNameNr_TextEntry,
        {0, 0, 1},
        39, methods_wxTextEntry,
        0, 0,
        6, variables_wxTextEntry,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxTextEntry,
    -1,
    -1,
    0,
    0,
    0,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxTextEntry,
    0,
    0,
    0,
    release_wxTextEntry,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
