/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/unichar.h>



PyDoc_STRVAR(doc_wxUniChar_GetValue, "GetValue() -> value_type\n"
"\n"
"Returns Unicode code point value of the character.");

extern "C" {static PyObject *meth_wxUniChar_GetValue(PyObject *, PyObject *);}
static PyObject *meth_wxUniChar_GetValue(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxUniChar *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxUniChar, &sipCpp))
        {
             ::wxUniChar::value_type sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetValue();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_UniChar, sipName_GetValue, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxUniChar_IsAscii, "IsAscii() -> bool\n"
"\n"
"Returns true if the character is an ASCII character (i.e. if its value\n"
"is less than 128).");

extern "C" {static PyObject *meth_wxUniChar_IsAscii(PyObject *, PyObject *);}
static PyObject *meth_wxUniChar_IsAscii(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxUniChar *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxUniChar, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsAscii();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_UniChar, sipName_IsAscii, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxUniChar_GetAsChar, "GetAsChar(c) -> bool\n"
"\n"
"Returns true if the character is representable as a single byte in the\n"
"current locale encoding.");

extern "C" {static PyObject *meth_wxUniChar_GetAsChar(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUniChar_GetAsChar(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        char* c;
        const  ::wxUniChar *sipCpp;

        static const char *sipKwdList[] = {
            sipName_c,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bs", &sipSelf, sipType_wxUniChar, &sipCpp, &c))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetAsChar(c);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_UniChar, sipName_GetAsChar, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxUniChar(void *, int);}
static void release_wxUniChar(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxUniChar *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxUniChar(sipSimpleWrapper *);}
static void dealloc_wxUniChar(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxUniChar(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxUniChar(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxUniChar(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxUniChar *sipCpp = 0;

    {
        long c;

        static const char *sipKwdList[] = {
            sipName_c,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "l", &c))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxUniChar(c);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        unsigned long c;

        static const char *sipKwdList[] = {
            sipName_c,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "m", &c))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxUniChar(c);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxUniChar* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxUniChar, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxUniChar(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return NULL;
}


static PyMethodDef methods_wxUniChar[] = {
    {SIP_MLNAME_CAST(sipName_GetAsChar), (PyCFunction)meth_wxUniChar_GetAsChar, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxUniChar_GetAsChar)},
    {SIP_MLNAME_CAST(sipName_GetValue), meth_wxUniChar_GetValue, METH_VARARGS, SIP_MLDOC_CAST(doc_wxUniChar_GetValue)},
    {SIP_MLNAME_CAST(sipName_IsAscii), meth_wxUniChar_IsAscii, METH_VARARGS, SIP_MLDOC_CAST(doc_wxUniChar_IsAscii)}
};

sipVariableDef variables_wxUniChar[] = {
    {PropertyVariable, sipName_Value, &methods_wxUniChar[1], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxUniChar, "UniChar(c)\n"
"UniChar(c)\n"
"\n"
"This class represents a single Unicode character.");


sipClassTypeDef sipTypeDef__core_wxUniChar = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxUniChar,
        {0},
        0
    },
    {
        sipNameNr_UniChar,
        {0, 0, 1},
        3, methods_wxUniChar,
        0, 0,
        1, variables_wxUniChar,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxUniChar,
    -1,
    -1,
    0,
    0,
    init_type_wxUniChar,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxUniChar,
    0,
    0,
    0,
    release_wxUniChar,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
