/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/vscroll.h>

        #include <wx/window.h>
    #include <wxpy_api.h>


class sipwxVarVScrollHelper : public  ::wxVarVScrollHelper
{
public:
    sipwxVarVScrollHelper( ::wxWindow*);
    sipwxVarVScrollHelper(const  ::wxVarVScrollHelper&);
    virtual ~sipwxVarVScrollHelper();

    /*
     * There is a public method for every protected method visible from
     * this class.
     */
    void sipProtectVirt_OnGetRowsHeightHint(bool, ::size_t, ::size_t) const;
     ::wxCoord sipProtectVirt_EstimateTotalHeight(bool) const;
     ::wxCoord sipProtect_OnGetRowHeight( ::size_t) const;
    void sipProtectVirt_OnGetUnitsSizeHint(bool, ::size_t, ::size_t) const;
     ::wxCoord sipProtectVirt_EstimateTotalSize(bool) const;
    int sipProtectVirt_GetNonOrientationTargetSize(bool) const;
     ::wxOrientation sipProtectVirt_GetOrientation(bool) const;
    int sipProtectVirt_GetOrientationTargetSize(bool) const;
     ::wxCoord sipProtectVirt_OnGetUnitSize(bool, ::size_t) const;

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
     ::wxCoord OnGetRowHeight( ::size_t) const;
     ::wxCoord EstimateTotalHeight() const;
    void OnGetRowsHeightHint( ::size_t, ::size_t) const;
    bool ScrollRows(int);
    bool ScrollRowPages(int);
    void RefreshRows( ::size_t, ::size_t);
    void RefreshRow( ::size_t);
    int GetNonOrientationTargetSize() const;
     ::wxOrientation GetOrientation() const;
    int GetOrientationTargetSize() const;
    void OnGetUnitsSizeHint( ::size_t, ::size_t) const;
     ::wxCoord EstimateTotalSize() const;
     ::wxCoord OnGetUnitSize( ::size_t) const;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxVarVScrollHelper(const sipwxVarVScrollHelper &);
    sipwxVarVScrollHelper &operator = (const sipwxVarVScrollHelper &);

    char sipPyMethods[13];
};

sipwxVarVScrollHelper::sipwxVarVScrollHelper( ::wxWindow*winToScroll):  ::wxVarVScrollHelper(winToScroll), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxVarVScrollHelper::sipwxVarVScrollHelper(const  ::wxVarVScrollHelper& a0):  ::wxVarVScrollHelper(a0), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxVarVScrollHelper::~sipwxVarVScrollHelper()
{
    sipInstanceDestroyed(sipPySelf);
}

 ::wxCoord sipwxVarVScrollHelper::OnGetRowHeight( ::size_t row) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[0]),sipPySelf,sipName_VarVScrollHelper,sipName_OnGetRowHeight);

    if (!sipMeth)
        return 0;

    extern  ::wxCoord sipVH__core_121(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::size_t);

    return sipVH__core_121(sipGILState, 0, sipPySelf, sipMeth, row);
}

 ::wxCoord sipwxVarVScrollHelper::EstimateTotalHeight() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[1]),sipPySelf,NULL,sipName_EstimateTotalHeight);

    if (!sipMeth)
        return  ::wxVarVScrollHelper::EstimateTotalHeight();

    extern  ::wxCoord sipVH__core_88(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_88(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxVarVScrollHelper::OnGetRowsHeightHint( ::size_t rowMin, ::size_t rowMax) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[2]),sipPySelf,NULL,sipName_OnGetRowsHeightHint);

    if (!sipMeth)
    {
         ::wxVarVScrollHelper::OnGetRowsHeightHint(rowMin,rowMax);
        return;
    }

    extern void sipVH__core_120(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::size_t, ::size_t);

    sipVH__core_120(sipGILState, 0, sipPySelf, sipMeth, rowMin, rowMax);
}

bool sipwxVarVScrollHelper::ScrollRows(int rows)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[3],sipPySelf,NULL,sipName_ScrollRows);

    if (!sipMeth)
        return  ::wxVarVScrollHelper::ScrollRows(rows);

    extern bool sipVH__core_123(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int);

    return sipVH__core_123(sipGILState, 0, sipPySelf, sipMeth, rows);
}

bool sipwxVarVScrollHelper::ScrollRowPages(int pages)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[4],sipPySelf,NULL,sipName_ScrollRowPages);

    if (!sipMeth)
        return  ::wxVarVScrollHelper::ScrollRowPages(pages);

    extern bool sipVH__core_123(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int);

    return sipVH__core_123(sipGILState, 0, sipPySelf, sipMeth, pages);
}

void sipwxVarVScrollHelper::RefreshRows( ::size_t from_, ::size_t to_)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[5],sipPySelf,NULL,sipName_RefreshRows);

    if (!sipMeth)
    {
         ::wxVarVScrollHelper::RefreshRows(from_,to_);
        return;
    }

    extern void sipVH__core_120(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::size_t, ::size_t);

    sipVH__core_120(sipGILState, 0, sipPySelf, sipMeth, from_, to_);
}

void sipwxVarVScrollHelper::RefreshRow( ::size_t row)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[6],sipPySelf,NULL,sipName_RefreshRow);

    if (!sipMeth)
    {
         ::wxVarVScrollHelper::RefreshRow(row);
        return;
    }

    extern void sipVH__core_122(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::size_t);

    sipVH__core_122(sipGILState, 0, sipPySelf, sipMeth, row);
}

int sipwxVarVScrollHelper::GetNonOrientationTargetSize() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[7]),sipPySelf,NULL,sipName_GetNonOrientationTargetSize);

    if (!sipMeth)
        return  ::wxVarVScrollHelper::GetNonOrientationTargetSize();

    extern int sipVH__core_88(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_88(sipGILState, 0, sipPySelf, sipMeth);
}

 ::wxOrientation sipwxVarVScrollHelper::GetOrientation() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[8]),sipPySelf,NULL,sipName_GetOrientation);

    if (!sipMeth)
        return  ::wxVarVScrollHelper::GetOrientation();

    extern  ::wxOrientation sipVH__core_119(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_119(sipGILState, 0, sipPySelf, sipMeth);
}

int sipwxVarVScrollHelper::GetOrientationTargetSize() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[9]),sipPySelf,NULL,sipName_GetOrientationTargetSize);

    if (!sipMeth)
        return  ::wxVarVScrollHelper::GetOrientationTargetSize();

    extern int sipVH__core_88(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_88(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxVarVScrollHelper::OnGetUnitsSizeHint( ::size_t unitMin, ::size_t unitMax) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[10]),sipPySelf,NULL,sipName_OnGetUnitsSizeHint);

    if (!sipMeth)
    {
         ::wxVarVScrollHelper::OnGetUnitsSizeHint(unitMin,unitMax);
        return;
    }

    extern void sipVH__core_120(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::size_t, ::size_t);

    sipVH__core_120(sipGILState, 0, sipPySelf, sipMeth, unitMin, unitMax);
}

 ::wxCoord sipwxVarVScrollHelper::EstimateTotalSize() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[11]),sipPySelf,NULL,sipName_EstimateTotalSize);

    if (!sipMeth)
        return  ::wxVarVScrollHelper::EstimateTotalSize();

    extern  ::wxCoord sipVH__core_88(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_88(sipGILState, 0, sipPySelf, sipMeth);
}

 ::wxCoord sipwxVarVScrollHelper::OnGetUnitSize( ::size_t unit) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[12]),sipPySelf,NULL,sipName_OnGetUnitSize);

    if (!sipMeth)
        return  ::wxVarVScrollHelper::OnGetUnitSize(unit);

    extern  ::wxCoord sipVH__core_121(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::size_t);

    return sipVH__core_121(sipGILState, 0, sipPySelf, sipMeth, unit);
}

void sipwxVarVScrollHelper::sipProtectVirt_OnGetRowsHeightHint(bool sipSelfWasArg, ::size_t rowMin, ::size_t rowMax) const
{
    (sipSelfWasArg ?  ::wxVarVScrollHelper::OnGetRowsHeightHint(rowMin,rowMax) : OnGetRowsHeightHint(rowMin,rowMax));
}

 ::wxCoord sipwxVarVScrollHelper::sipProtectVirt_EstimateTotalHeight(bool sipSelfWasArg) const
{
    return (sipSelfWasArg ?  ::wxVarVScrollHelper::EstimateTotalHeight() : EstimateTotalHeight());
}

 ::wxCoord sipwxVarVScrollHelper::sipProtect_OnGetRowHeight( ::size_t row) const
{
    return OnGetRowHeight(row);
}

void sipwxVarVScrollHelper::sipProtectVirt_OnGetUnitsSizeHint(bool sipSelfWasArg, ::size_t unitMin, ::size_t unitMax) const
{
    (sipSelfWasArg ?  ::wxVarVScrollHelper::OnGetUnitsSizeHint(unitMin,unitMax) : OnGetUnitsSizeHint(unitMin,unitMax));
}

 ::wxCoord sipwxVarVScrollHelper::sipProtectVirt_EstimateTotalSize(bool sipSelfWasArg) const
{
    return (sipSelfWasArg ?  ::wxVarVScrollHelper::EstimateTotalSize() : EstimateTotalSize());
}

int sipwxVarVScrollHelper::sipProtectVirt_GetNonOrientationTargetSize(bool sipSelfWasArg) const
{
    return (sipSelfWasArg ?  ::wxVarVScrollHelper::GetNonOrientationTargetSize() : GetNonOrientationTargetSize());
}

 ::wxOrientation sipwxVarVScrollHelper::sipProtectVirt_GetOrientation(bool sipSelfWasArg) const
{
    return (sipSelfWasArg ?  ::wxVarVScrollHelper::GetOrientation() : GetOrientation());
}

int sipwxVarVScrollHelper::sipProtectVirt_GetOrientationTargetSize(bool sipSelfWasArg) const
{
    return (sipSelfWasArg ?  ::wxVarVScrollHelper::GetOrientationTargetSize() : GetOrientationTargetSize());
}

 ::wxCoord sipwxVarVScrollHelper::sipProtectVirt_OnGetUnitSize(bool sipSelfWasArg, ::size_t unit) const
{
    return (sipSelfWasArg ?  ::wxVarVScrollHelper::OnGetUnitSize(unit) : OnGetUnitSize(unit));
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_GetRowCount, "GetRowCount() -> size_t\n"
"\n"
"Returns the number of rows the target window contains.");

extern "C" {static PyObject *meth_wxVarVScrollHelper_GetRowCount(PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_GetRowCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxVarVScrollHelper *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp))
        {
             ::size_t*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::size_t(sipCpp->GetRowCount());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_size_t,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_GetRowCount, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_GetVisibleRowsBegin, "GetVisibleRowsBegin() -> size_t\n"
"\n"
"Returns the index of the first visible row based on the scroll\n"
"position.");

extern "C" {static PyObject *meth_wxVarVScrollHelper_GetVisibleRowsBegin(PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_GetVisibleRowsBegin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxVarVScrollHelper *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp))
        {
             ::size_t*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::size_t(sipCpp->GetVisibleRowsBegin());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_size_t,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_GetVisibleRowsBegin, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_GetVisibleRowsEnd, "GetVisibleRowsEnd() -> size_t\n"
"\n"
"Returns the index of the last visible row based on the scroll\n"
"position.");

extern "C" {static PyObject *meth_wxVarVScrollHelper_GetVisibleRowsEnd(PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_GetVisibleRowsEnd(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxVarVScrollHelper *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp))
        {
             ::size_t*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::size_t(sipCpp->GetVisibleRowsEnd());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_size_t,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_GetVisibleRowsEnd, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_IsRowVisible, "IsRowVisible(row) -> bool\n"
"\n"
"Returns true if the given row is currently visible (even if only\n"
"partially visible) or false otherwise.");

extern "C" {static PyObject *meth_wxVarVScrollHelper_IsRowVisible(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_IsRowVisible(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::size_t* row;
        int rowState = 0;
        const  ::wxVarVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_row,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp, sipType_size_t,&row, &rowState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsRowVisible(*row);
            Py_END_ALLOW_THREADS
            sipReleaseType(row,sipType_size_t,rowState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_IsRowVisible, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_RefreshRow, "RefreshRow(row)\n"
"\n"
"Triggers a refresh for just the given row's area of the window if it's\n"
"visible.");

extern "C" {static PyObject *meth_wxVarVScrollHelper_RefreshRow(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_RefreshRow(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::size_t* row;
        int rowState = 0;
         ::wxVarVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_row,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp, sipType_size_t,&row, &rowState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxVarVScrollHelper::RefreshRow(*row) : sipCpp->RefreshRow(*row));
            Py_END_ALLOW_THREADS
            sipReleaseType(row,sipType_size_t,rowState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_RefreshRow, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_RefreshRows, "RefreshRows(from_, to_)\n"
"\n"
"Triggers a refresh for the area between the specified range of rows\n"
"given (inclusively).");

extern "C" {static PyObject *meth_wxVarVScrollHelper_RefreshRows(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_RefreshRows(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::size_t* from_;
        int from_State = 0;
         ::size_t* to_;
        int to_State = 0;
         ::wxVarVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_from_,
            sipName_to_,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp, sipType_size_t,&from_, &from_State, sipType_size_t,&to_, &to_State))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxVarVScrollHelper::RefreshRows(*from_,*to_) : sipCpp->RefreshRows(*from_,*to_));
            Py_END_ALLOW_THREADS
            sipReleaseType(from_,sipType_size_t,from_State);
            sipReleaseType(to_,sipType_size_t,to_State);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_RefreshRows, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_ScrollRowPages, "ScrollRowPages(pages) -> bool\n"
"\n"
"Scroll by the specified number of pages which may be positive (to\n"
"scroll down) or negative (to scroll up).");

extern "C" {static PyObject *meth_wxVarVScrollHelper_ScrollRowPages(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_ScrollRowPages(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        int pages;
         ::wxVarVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pages,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp, &pages))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxVarVScrollHelper::ScrollRowPages(pages) : sipCpp->ScrollRowPages(pages));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_ScrollRowPages, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_ScrollRows, "ScrollRows(rows) -> bool\n"
"\n"
"Scroll by the specified number of rows which may be positive (to\n"
"scroll down) or negative (to scroll up).");

extern "C" {static PyObject *meth_wxVarVScrollHelper_ScrollRows(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_ScrollRows(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        int rows;
         ::wxVarVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rows,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp, &rows))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxVarVScrollHelper::ScrollRows(rows) : sipCpp->ScrollRows(rows));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_ScrollRows, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_ScrollToRow, "ScrollToRow(row) -> bool\n"
"\n"
"Scroll to the specified row.");

extern "C" {static PyObject *meth_wxVarVScrollHelper_ScrollToRow(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_ScrollToRow(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::size_t* row;
        int rowState = 0;
         ::wxVarVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_row,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp, sipType_size_t,&row, &rowState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ScrollToRow(*row);
            Py_END_ALLOW_THREADS
            sipReleaseType(row,sipType_size_t,rowState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_ScrollToRow, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_SetRowCount, "SetRowCount(rowCount)\n"
"\n"
"Set the number of rows the window contains.");

extern "C" {static PyObject *meth_wxVarVScrollHelper_SetRowCount(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_SetRowCount(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::size_t* rowCount;
        int rowCountState = 0;
         ::wxVarVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rowCount,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp, sipType_size_t,&rowCount, &rowCountState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetRowCount(*rowCount);
            Py_END_ALLOW_THREADS
            sipReleaseType(rowCount,sipType_size_t,rowCountState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_SetRowCount, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_OnGetRowsHeightHint, "OnGetRowsHeightHint(rowMin, rowMax)\n"
"\n"
"This function doesn't have to be overridden but it may be useful to do\n"
"so if calculating the rows' sizes is a relatively expensive operation\n"
"as it gives your code a chance to calculate several of them at once\n"
"and cache the result if necessary.");

extern "C" {static PyObject *meth_wxVarVScrollHelper_OnGetRowsHeightHint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_OnGetRowsHeightHint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::size_t* rowMin;
        int rowMinState = 0;
         ::size_t* rowMax;
        int rowMaxState = 0;
        const sipwxVarVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rowMin,
            sipName_rowMax,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp, sipType_size_t,&rowMin, &rowMinState, sipType_size_t,&rowMax, &rowMaxState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->sipProtectVirt_OnGetRowsHeightHint(sipSelfWasArg,*rowMin,*rowMax);
            Py_END_ALLOW_THREADS
            sipReleaseType(rowMin,sipType_size_t,rowMinState);
            sipReleaseType(rowMax,sipType_size_t,rowMaxState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_OnGetRowsHeightHint, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_EstimateTotalHeight, "EstimateTotalHeight() -> Coord\n"
"\n"
"This class forwards calls from EstimateTotalSize() to this function so\n"
"derived classes can override either just the height or the width\n"
"estimation, or just estimate both differently if desired in any\n"
"wxHVScrolledWindow derived class.");

extern "C" {static PyObject *meth_wxVarVScrollHelper_EstimateTotalHeight(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_EstimateTotalHeight(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const sipwxVarVScrollHelper *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, "B", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp))
        {
             ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_EstimateTotalHeight(sipSelfWasArg);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_EstimateTotalHeight, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_OnGetRowHeight, "OnGetRowHeight(row) -> Coord\n"
"\n"
"This function must be overridden in the derived class, and should\n"
"return the height of the given row in pixels.");

extern "C" {static PyObject *meth_wxVarVScrollHelper_OnGetRowHeight(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_OnGetRowHeight(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
         ::size_t* row;
        int rowState = 0;
        const sipwxVarVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_row,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp, sipType_size_t,&row, &rowState))
        {
             ::wxCoord sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_VarVScrollHelper, sipName_OnGetRowHeight);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtect_OnGetRowHeight(*row);
            Py_END_ALLOW_THREADS
            sipReleaseType(row,sipType_size_t,rowState);

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_OnGetRowHeight, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_OnGetUnitsSizeHint, "OnGetUnitsSizeHint(self, unitMin: object, unitMax: object)");

extern "C" {static PyObject *meth_wxVarVScrollHelper_OnGetUnitsSizeHint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_OnGetUnitsSizeHint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::size_t* unitMin;
        int unitMinState = 0;
         ::size_t* unitMax;
        int unitMaxState = 0;
        const sipwxVarVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_unitMin,
            sipName_unitMax,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp, sipType_size_t,&unitMin, &unitMinState, sipType_size_t,&unitMax, &unitMaxState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->sipProtectVirt_OnGetUnitsSizeHint(sipSelfWasArg,*unitMin,*unitMax);
            Py_END_ALLOW_THREADS
            sipReleaseType(unitMin,sipType_size_t,unitMinState);
            sipReleaseType(unitMax,sipType_size_t,unitMaxState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_OnGetUnitsSizeHint, doc_wxVarVScrollHelper_OnGetUnitsSizeHint);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_EstimateTotalSize, "EstimateTotalSize(self) -> int");

extern "C" {static PyObject *meth_wxVarVScrollHelper_EstimateTotalSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_EstimateTotalSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const sipwxVarVScrollHelper *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, "B", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp))
        {
             ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_EstimateTotalSize(sipSelfWasArg);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_EstimateTotalSize, doc_wxVarVScrollHelper_EstimateTotalSize);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_GetNonOrientationTargetSize, "GetNonOrientationTargetSize(self) -> int");

extern "C" {static PyObject *meth_wxVarVScrollHelper_GetNonOrientationTargetSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_GetNonOrientationTargetSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const sipwxVarVScrollHelper *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, "B", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_GetNonOrientationTargetSize(sipSelfWasArg);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_GetNonOrientationTargetSize, doc_wxVarVScrollHelper_GetNonOrientationTargetSize);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_GetOrientation, "GetOrientation(self) -> Orientation");

extern "C" {static PyObject *meth_wxVarVScrollHelper_GetOrientation(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_GetOrientation(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const sipwxVarVScrollHelper *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, "B", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp))
        {
             ::wxOrientation sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_GetOrientation(sipSelfWasArg);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxOrientation);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_GetOrientation, doc_wxVarVScrollHelper_GetOrientation);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_GetOrientationTargetSize, "GetOrientationTargetSize(self) -> int");

extern "C" {static PyObject *meth_wxVarVScrollHelper_GetOrientationTargetSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_GetOrientationTargetSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const sipwxVarVScrollHelper *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, "B", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_GetOrientationTargetSize(sipSelfWasArg);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_GetOrientationTargetSize, doc_wxVarVScrollHelper_GetOrientationTargetSize);

    return NULL;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_OnGetUnitSize, "OnGetUnitSize(self, unit: object) -> int");

extern "C" {static PyObject *meth_wxVarVScrollHelper_OnGetUnitSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_OnGetUnitSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::size_t* unit;
        int unitState = 0;
        const sipwxVarVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_unit,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp, sipType_size_t,&unit, &unitState))
        {
             ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_OnGetUnitSize(sipSelfWasArg,*unit);
            Py_END_ALLOW_THREADS
            sipReleaseType(unit,sipType_size_t,unitState);

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_OnGetUnitSize, doc_wxVarVScrollHelper_OnGetUnitSize);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxVarVScrollHelper(void *, const sipTypeDef *);}
static void *cast_wxVarVScrollHelper(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxVarVScrollHelper *sipCpp = reinterpret_cast< ::wxVarVScrollHelper *>(sipCppV);

    if (targetType == sipType_wxVarScrollHelperBase)
        return static_cast< ::wxVarScrollHelperBase *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxVarVScrollHelper(void *, int);}
static void release_wxVarVScrollHelper(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxVarVScrollHelper *>(sipCppV);
    else
        delete reinterpret_cast< ::wxVarVScrollHelper *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxVarVScrollHelper(sipSimpleWrapper *);}
static void dealloc_wxVarVScrollHelper(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxVarVScrollHelper *>(sipGetAddress(sipSelf))->sipPySelf = NULL;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxVarVScrollHelper(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxVarVScrollHelper(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxVarVScrollHelper(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxVarVScrollHelper *sipCpp = 0;

    {
         ::wxWindow* winToScroll;

        static const char *sipKwdList[] = {
            sipName_winToScroll,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J8", sipType_wxWindow, &winToScroll))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxVarVScrollHelper(winToScroll);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxVarVScrollHelper* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxVarVScrollHelper, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxVarVScrollHelper(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxVarVScrollHelper[] = {{553, 255, 1}};


static PyMethodDef methods_wxVarVScrollHelper[] = {
    {SIP_MLNAME_CAST(sipName_EstimateTotalHeight), (PyCFunction)meth_wxVarVScrollHelper_EstimateTotalHeight, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxVarVScrollHelper_EstimateTotalHeight)},
    {SIP_MLNAME_CAST(sipName_EstimateTotalSize), (PyCFunction)meth_wxVarVScrollHelper_EstimateTotalSize, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxVarVScrollHelper_EstimateTotalSize)},
    {SIP_MLNAME_CAST(sipName_GetNonOrientationTargetSize), (PyCFunction)meth_wxVarVScrollHelper_GetNonOrientationTargetSize, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxVarVScrollHelper_GetNonOrientationTargetSize)},
    {SIP_MLNAME_CAST(sipName_GetOrientation), (PyCFunction)meth_wxVarVScrollHelper_GetOrientation, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxVarVScrollHelper_GetOrientation)},
    {SIP_MLNAME_CAST(sipName_GetOrientationTargetSize), (PyCFunction)meth_wxVarVScrollHelper_GetOrientationTargetSize, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxVarVScrollHelper_GetOrientationTargetSize)},
    {SIP_MLNAME_CAST(sipName_GetRowCount), meth_wxVarVScrollHelper_GetRowCount, METH_VARARGS, SIP_MLDOC_CAST(doc_wxVarVScrollHelper_GetRowCount)},
    {SIP_MLNAME_CAST(sipName_GetVisibleRowsBegin), meth_wxVarVScrollHelper_GetVisibleRowsBegin, METH_VARARGS, SIP_MLDOC_CAST(doc_wxVarVScrollHelper_GetVisibleRowsBegin)},
    {SIP_MLNAME_CAST(sipName_GetVisibleRowsEnd), meth_wxVarVScrollHelper_GetVisibleRowsEnd, METH_VARARGS, SIP_MLDOC_CAST(doc_wxVarVScrollHelper_GetVisibleRowsEnd)},
    {SIP_MLNAME_CAST(sipName_IsRowVisible), (PyCFunction)meth_wxVarVScrollHelper_IsRowVisible, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxVarVScrollHelper_IsRowVisible)},
    {SIP_MLNAME_CAST(sipName_OnGetRowHeight), (PyCFunction)meth_wxVarVScrollHelper_OnGetRowHeight, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxVarVScrollHelper_OnGetRowHeight)},
    {SIP_MLNAME_CAST(sipName_OnGetRowsHeightHint), (PyCFunction)meth_wxVarVScrollHelper_OnGetRowsHeightHint, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxVarVScrollHelper_OnGetRowsHeightHint)},
    {SIP_MLNAME_CAST(sipName_OnGetUnitSize), (PyCFunction)meth_wxVarVScrollHelper_OnGetUnitSize, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxVarVScrollHelper_OnGetUnitSize)},
    {SIP_MLNAME_CAST(sipName_OnGetUnitsSizeHint), (PyCFunction)meth_wxVarVScrollHelper_OnGetUnitsSizeHint, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxVarVScrollHelper_OnGetUnitsSizeHint)},
    {SIP_MLNAME_CAST(sipName_RefreshRow), (PyCFunction)meth_wxVarVScrollHelper_RefreshRow, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxVarVScrollHelper_RefreshRow)},
    {SIP_MLNAME_CAST(sipName_RefreshRows), (PyCFunction)meth_wxVarVScrollHelper_RefreshRows, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxVarVScrollHelper_RefreshRows)},
    {SIP_MLNAME_CAST(sipName_ScrollRowPages), (PyCFunction)meth_wxVarVScrollHelper_ScrollRowPages, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxVarVScrollHelper_ScrollRowPages)},
    {SIP_MLNAME_CAST(sipName_ScrollRows), (PyCFunction)meth_wxVarVScrollHelper_ScrollRows, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxVarVScrollHelper_ScrollRows)},
    {SIP_MLNAME_CAST(sipName_ScrollToRow), (PyCFunction)meth_wxVarVScrollHelper_ScrollToRow, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxVarVScrollHelper_ScrollToRow)},
    {SIP_MLNAME_CAST(sipName_SetRowCount), (PyCFunction)meth_wxVarVScrollHelper_SetRowCount, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxVarVScrollHelper_SetRowCount)}
};

sipVariableDef variables_wxVarVScrollHelper[] = {
    {PropertyVariable, sipName_VisibleRowsEnd, &methods_wxVarVScrollHelper[7], NULL, NULL, NULL},
    {PropertyVariable, sipName_VisibleRowsBegin, &methods_wxVarVScrollHelper[6], NULL, NULL, NULL},
    {PropertyVariable, sipName_RowCount, &methods_wxVarVScrollHelper[5], &methods_wxVarVScrollHelper[18], NULL, NULL},
};

PyDoc_STRVAR(doc_wxVarVScrollHelper, "VarVScrollHelper(winToScroll)\n"
"\n"
"This class provides functions wrapping the wxVarScrollHelperBase\n"
"class, targeted for vertical-specific scrolling.");


sipClassTypeDef sipTypeDef__core_wxVarVScrollHelper = {
    {
        -1,
        0,
        0,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxVarVScrollHelper,
        {0},
        0
    },
    {
        sipNameNr_VarVScrollHelper,
        {0, 0, 1},
        19, methods_wxVarVScrollHelper,
        0, 0,
        3, variables_wxVarVScrollHelper,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxVarVScrollHelper,
    -1,
    -1,
    supers_wxVarVScrollHelper,
    0,
    init_type_wxVarVScrollHelper,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxVarVScrollHelper,
    0,
    0,
    0,
    release_wxVarVScrollHelper,
    cast_wxVarVScrollHelper,
    0,
    0,
    0,
    0,
    0,
    0
};
