/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_html.h"

        #include <wx/html/htmprint.h>

        #include <wx/window.h>
        #include <wx/cmndata.h>
        #include <wx/cmndata.h>
        #include <wx/object.h>
        #include <wx/object.h>
    void _wxHtmlEasyPrinting_SetFonts(wxHtmlEasyPrinting* self, const wxString * normal_face, const wxString * fixed_face, const wxArrayInt* sizes)
    {
        if (sizes->GetCount() != 7) {
            wxPyErr_SetString(PyExc_ValueError, "Sequence of 7 integers expected.");
            return;
        }
        self->SetFonts(*normal_face, *fixed_face, &sizes->Item(0));
    }


PyDoc_STRVAR(doc_wxHtmlEasyPrinting_GetName, "GetName() -> String\n"
"\n"
"Returns the current name being used for preview frames and setup\n"
"dialogs.");

extern "C" {static PyObject *meth_wxHtmlEasyPrinting_GetName(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlEasyPrinting_GetName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlEasyPrinting *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlEasyPrinting, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlEasyPrinting, sipName_GetName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlEasyPrinting_GetPageSetupData, "GetPageSetupData() -> wx.PageSetupDialogData\n"
"\n"
"Returns a pointer to wxPageSetupDialogData instance used by this\n"
"class.");

extern "C" {static PyObject *meth_wxHtmlEasyPrinting_GetPageSetupData(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlEasyPrinting_GetPageSetupData(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxHtmlEasyPrinting *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlEasyPrinting, &sipCpp))
        {
             ::wxPageSetupDialogData*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPageSetupData();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPageSetupDialogData,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlEasyPrinting, sipName_GetPageSetupData, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlEasyPrinting_GetParentWindow, "GetParentWindow() -> wx.Window\n"
"\n"
"Gets the parent window for dialogs.");

extern "C" {static PyObject *meth_wxHtmlEasyPrinting_GetParentWindow(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlEasyPrinting_GetParentWindow(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlEasyPrinting *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlEasyPrinting, &sipCpp))
        {
             ::wxWindow*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetParentWindow();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxWindow,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlEasyPrinting, sipName_GetParentWindow, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlEasyPrinting_GetPrintData, "GetPrintData() -> wx.PrintData\n"
"\n"
"Returns pointer to wxPrintData instance used by this class.");

extern "C" {static PyObject *meth_wxHtmlEasyPrinting_GetPrintData(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlEasyPrinting_GetPrintData(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxHtmlEasyPrinting *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlEasyPrinting, &sipCpp))
        {
             ::wxPrintData*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPrintData();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPrintData,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlEasyPrinting, sipName_GetPrintData, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlEasyPrinting_PageSetup, "PageSetup()\n"
"\n"
"Display page setup dialog and allows the user to modify settings.");

extern "C" {static PyObject *meth_wxHtmlEasyPrinting_PageSetup(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlEasyPrinting_PageSetup(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxHtmlEasyPrinting *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlEasyPrinting, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->PageSetup();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlEasyPrinting, sipName_PageSetup, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlEasyPrinting_PreviewFile, "PreviewFile(htmlfile) -> bool\n"
"\n"
"Preview HTML file.");

extern "C" {static PyObject *meth_wxHtmlEasyPrinting_PreviewFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlEasyPrinting_PreviewFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* htmlfile;
        int htmlfileState = 0;
         ::wxHtmlEasyPrinting *sipCpp;

        static const char *sipKwdList[] = {
            sipName_htmlfile,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxHtmlEasyPrinting, &sipCpp, sipType_wxString,&htmlfile, &htmlfileState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->PreviewFile(*htmlfile);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(htmlfile),sipType_wxString,htmlfileState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlEasyPrinting, sipName_PreviewFile, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlEasyPrinting_PreviewText, "PreviewText(htmltext, basepath=wx.EmptyString) -> bool\n"
"\n"
"Preview HTML text (not file!).");

extern "C" {static PyObject *meth_wxHtmlEasyPrinting_PreviewText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlEasyPrinting_PreviewText(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* htmltext;
        int htmltextState = 0;
        const  ::wxString& basepathdef = wxEmptyString;
        const  ::wxString* basepath = &basepathdef;
        int basepathState = 0;
         ::wxHtmlEasyPrinting *sipCpp;

        static const char *sipKwdList[] = {
            sipName_htmltext,
            sipName_basepath,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|J1", &sipSelf, sipType_wxHtmlEasyPrinting, &sipCpp, sipType_wxString,&htmltext, &htmltextState, sipType_wxString,&basepath, &basepathState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->PreviewText(*htmltext,*basepath);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(htmltext),sipType_wxString,htmltextState);
            sipReleaseType(const_cast< ::wxString *>(basepath),sipType_wxString,basepathState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlEasyPrinting, sipName_PreviewText, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlEasyPrinting_PrintFile, "PrintFile(htmlfile) -> bool\n"
"\n"
"Print HTML file.");

extern "C" {static PyObject *meth_wxHtmlEasyPrinting_PrintFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlEasyPrinting_PrintFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* htmlfile;
        int htmlfileState = 0;
         ::wxHtmlEasyPrinting *sipCpp;

        static const char *sipKwdList[] = {
            sipName_htmlfile,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxHtmlEasyPrinting, &sipCpp, sipType_wxString,&htmlfile, &htmlfileState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->PrintFile(*htmlfile);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(htmlfile),sipType_wxString,htmlfileState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlEasyPrinting, sipName_PrintFile, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlEasyPrinting_PrintText, "PrintText(htmltext, basepath=wx.EmptyString) -> bool\n"
"\n"
"Print HTML text (not file!).");

extern "C" {static PyObject *meth_wxHtmlEasyPrinting_PrintText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlEasyPrinting_PrintText(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* htmltext;
        int htmltextState = 0;
        const  ::wxString& basepathdef = wxEmptyString;
        const  ::wxString* basepath = &basepathdef;
        int basepathState = 0;
         ::wxHtmlEasyPrinting *sipCpp;

        static const char *sipKwdList[] = {
            sipName_htmltext,
            sipName_basepath,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|J1", &sipSelf, sipType_wxHtmlEasyPrinting, &sipCpp, sipType_wxString,&htmltext, &htmltextState, sipType_wxString,&basepath, &basepathState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->PrintText(*htmltext,*basepath);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(htmltext),sipType_wxString,htmltextState);
            sipReleaseType(const_cast< ::wxString *>(basepath),sipType_wxString,basepathState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlEasyPrinting, sipName_PrintText, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlEasyPrinting_SetFonts, "SetFonts(normal_face, fixed_face, sizes)\n"
"\n"
"Sets fonts.");

extern "C" {static PyObject *meth_wxHtmlEasyPrinting_SetFonts(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlEasyPrinting_SetFonts(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* normal_face;
        int normal_faceState = 0;
        const  ::wxString* fixed_face;
        int fixed_faceState = 0;
        const  ::wxArrayInt* sizes;
        int sizesState = 0;
         ::wxHtmlEasyPrinting *sipCpp;

        static const char *sipKwdList[] = {
            sipName_normal_face,
            sipName_fixed_face,
            sipName_sizes,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1J1", &sipSelf, sipType_wxHtmlEasyPrinting, &sipCpp, sipType_wxString,&normal_face, &normal_faceState, sipType_wxString,&fixed_face, &fixed_faceState, sipType_wxArrayInt,&sizes, &sizesState))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxHtmlEasyPrinting_SetFonts(sipCpp, normal_face, fixed_face, sizes);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(normal_face),sipType_wxString,normal_faceState);
            sipReleaseType(const_cast< ::wxString *>(fixed_face),sipType_wxString,fixed_faceState);
            sipReleaseType(const_cast< ::wxArrayInt *>(sizes),sipType_wxArrayInt,sizesState);

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlEasyPrinting, sipName_SetFonts, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlEasyPrinting_SetName, "SetName(name)\n"
"\n"
"Sets the name used for preview frames and setup dialogs.");

extern "C" {static PyObject *meth_wxHtmlEasyPrinting_SetName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlEasyPrinting_SetName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxHtmlEasyPrinting *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxHtmlEasyPrinting, &sipCpp, sipType_wxString,&name, &nameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetName(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlEasyPrinting, sipName_SetName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlEasyPrinting_SetStandardFonts, "SetStandardFonts(size=-1, normal_face=wx.EmptyString, fixed_face=wx.EmptyString)\n"
"\n"
"Sets default font sizes and/or default font size.");

extern "C" {static PyObject *meth_wxHtmlEasyPrinting_SetStandardFonts(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlEasyPrinting_SetStandardFonts(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int size = -1;
        const  ::wxString& normal_facedef = wxEmptyString;
        const  ::wxString* normal_face = &normal_facedef;
        int normal_faceState = 0;
        const  ::wxString& fixed_facedef = wxEmptyString;
        const  ::wxString* fixed_face = &fixed_facedef;
        int fixed_faceState = 0;
         ::wxHtmlEasyPrinting *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
            sipName_normal_face,
            sipName_fixed_face,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|iJ1J1", &sipSelf, sipType_wxHtmlEasyPrinting, &sipCpp, &size, sipType_wxString,&normal_face, &normal_faceState, sipType_wxString,&fixed_face, &fixed_faceState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetStandardFonts(size,*normal_face,*fixed_face);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(normal_face),sipType_wxString,normal_faceState);
            sipReleaseType(const_cast< ::wxString *>(fixed_face),sipType_wxString,fixed_faceState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlEasyPrinting, sipName_SetStandardFonts, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlEasyPrinting_SetFooter, "SetFooter(footer, pg=PAGE_ALL)\n"
"\n"
"Set page footer.");

extern "C" {static PyObject *meth_wxHtmlEasyPrinting_SetFooter(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlEasyPrinting_SetFooter(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* footer;
        int footerState = 0;
        int pg = wxPAGE_ALL;
         ::wxHtmlEasyPrinting *sipCpp;

        static const char *sipKwdList[] = {
            sipName_footer,
            sipName_pg,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|i", &sipSelf, sipType_wxHtmlEasyPrinting, &sipCpp, sipType_wxString,&footer, &footerState, &pg))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFooter(*footer,pg);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(footer),sipType_wxString,footerState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlEasyPrinting, sipName_SetFooter, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlEasyPrinting_SetHeader, "SetHeader(header, pg=PAGE_ALL)\n"
"\n"
"Set page header.");

extern "C" {static PyObject *meth_wxHtmlEasyPrinting_SetHeader(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlEasyPrinting_SetHeader(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* header;
        int headerState = 0;
        int pg = wxPAGE_ALL;
         ::wxHtmlEasyPrinting *sipCpp;

        static const char *sipKwdList[] = {
            sipName_header,
            sipName_pg,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|i", &sipSelf, sipType_wxHtmlEasyPrinting, &sipCpp, sipType_wxString,&header, &headerState, &pg))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetHeader(*header,pg);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(header),sipType_wxString,headerState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlEasyPrinting, sipName_SetHeader, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlEasyPrinting_SetParentWindow, "SetParentWindow(window)\n"
"\n"
"Sets the parent window for dialogs.");

extern "C" {static PyObject *meth_wxHtmlEasyPrinting_SetParentWindow(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlEasyPrinting_SetParentWindow(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxWindow* window;
         ::wxHtmlEasyPrinting *sipCpp;

        static const char *sipKwdList[] = {
            sipName_window,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxHtmlEasyPrinting, &sipCpp, sipType_wxWindow, &window))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetParentWindow(window);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlEasyPrinting, sipName_SetParentWindow, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxHtmlEasyPrinting(void *, const sipTypeDef *);}
static void *cast_wxHtmlEasyPrinting(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxHtmlEasyPrinting *sipCpp = reinterpret_cast< ::wxHtmlEasyPrinting *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxHtmlEasyPrinting(void *, int);}
static void release_wxHtmlEasyPrinting(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxHtmlEasyPrinting *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxHtmlEasyPrinting(sipSimpleWrapper *);}
static void dealloc_wxHtmlEasyPrinting(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxHtmlEasyPrinting(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxHtmlEasyPrinting(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxHtmlEasyPrinting(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxHtmlEasyPrinting *sipCpp = 0;

    {
        const  ::wxString& namedef = "Printing";
        const  ::wxString* name = &namedef;
        int nameState = 0;
         ::wxWindow* parentWindow = 0;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_parentWindow,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J1J8", sipType_wxString,&name, &nameState, sipType_wxWindow, &parentWindow))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxHtmlEasyPrinting(*name,parentWindow);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxHtmlEasyPrinting[] = {{26, 0, 1}};


static PyMethodDef methods_wxHtmlEasyPrinting[] = {
    {SIP_MLNAME_CAST(sipName_GetName), meth_wxHtmlEasyPrinting_GetName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlEasyPrinting_GetName)},
    {SIP_MLNAME_CAST(sipName_GetPageSetupData), meth_wxHtmlEasyPrinting_GetPageSetupData, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlEasyPrinting_GetPageSetupData)},
    {SIP_MLNAME_CAST(sipName_GetParentWindow), meth_wxHtmlEasyPrinting_GetParentWindow, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlEasyPrinting_GetParentWindow)},
    {SIP_MLNAME_CAST(sipName_GetPrintData), meth_wxHtmlEasyPrinting_GetPrintData, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlEasyPrinting_GetPrintData)},
    {SIP_MLNAME_CAST(sipName_PageSetup), meth_wxHtmlEasyPrinting_PageSetup, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlEasyPrinting_PageSetup)},
    {SIP_MLNAME_CAST(sipName_PreviewFile), (PyCFunction)meth_wxHtmlEasyPrinting_PreviewFile, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlEasyPrinting_PreviewFile)},
    {SIP_MLNAME_CAST(sipName_PreviewText), (PyCFunction)meth_wxHtmlEasyPrinting_PreviewText, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlEasyPrinting_PreviewText)},
    {SIP_MLNAME_CAST(sipName_PrintFile), (PyCFunction)meth_wxHtmlEasyPrinting_PrintFile, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlEasyPrinting_PrintFile)},
    {SIP_MLNAME_CAST(sipName_PrintText), (PyCFunction)meth_wxHtmlEasyPrinting_PrintText, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlEasyPrinting_PrintText)},
    {SIP_MLNAME_CAST(sipName_SetFonts), (PyCFunction)meth_wxHtmlEasyPrinting_SetFonts, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlEasyPrinting_SetFonts)},
    {SIP_MLNAME_CAST(sipName_SetFooter), (PyCFunction)meth_wxHtmlEasyPrinting_SetFooter, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlEasyPrinting_SetFooter)},
    {SIP_MLNAME_CAST(sipName_SetHeader), (PyCFunction)meth_wxHtmlEasyPrinting_SetHeader, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlEasyPrinting_SetHeader)},
    {SIP_MLNAME_CAST(sipName_SetName), (PyCFunction)meth_wxHtmlEasyPrinting_SetName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlEasyPrinting_SetName)},
    {SIP_MLNAME_CAST(sipName_SetParentWindow), (PyCFunction)meth_wxHtmlEasyPrinting_SetParentWindow, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlEasyPrinting_SetParentWindow)},
    {SIP_MLNAME_CAST(sipName_SetStandardFonts), (PyCFunction)meth_wxHtmlEasyPrinting_SetStandardFonts, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlEasyPrinting_SetStandardFonts)}
};

sipVariableDef variables_wxHtmlEasyPrinting[] = {
    {PropertyVariable, sipName_PrintData, &methods_wxHtmlEasyPrinting[3], NULL, NULL, NULL},
    {PropertyVariable, sipName_ParentWindow, &methods_wxHtmlEasyPrinting[2], &methods_wxHtmlEasyPrinting[13], NULL, NULL},
    {PropertyVariable, sipName_PageSetupData, &methods_wxHtmlEasyPrinting[1], NULL, NULL, NULL},
    {PropertyVariable, sipName_Name, &methods_wxHtmlEasyPrinting[0], &methods_wxHtmlEasyPrinting[12], NULL, NULL},
};

PyDoc_STRVAR(doc_wxHtmlEasyPrinting, "HtmlEasyPrinting(name=\"Printing\", parentWindow=None)\n"
"\n"
"This class provides very simple interface to printing architecture.");


sipClassTypeDef sipTypeDef__html_wxHtmlEasyPrinting = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxHtmlEasyPrinting,
        {0},
        0
    },
    {
        sipNameNr_HtmlEasyPrinting,
        {0, 0, 1},
        15, methods_wxHtmlEasyPrinting,
        0, 0,
        4, variables_wxHtmlEasyPrinting,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxHtmlEasyPrinting,
    -1,
    -1,
    supers_wxHtmlEasyPrinting,
    0,
    init_type_wxHtmlEasyPrinting,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxHtmlEasyPrinting,
    0,
    0,
    0,
    release_wxHtmlEasyPrinting,
    cast_wxHtmlEasyPrinting,
    0,
    0,
    0,
    0,
    0,
    0
};
