/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_html.h"

        #include <wx/html/winpars.h>

        #include <wx/html/htmlwin.h>
        #include <wx/object.h>
        #include <wx/colour.h>
        #include <wx/html/htmlcell.h>
        #include <wx/dc.h>
        #include <wx/html/htmlcell.h>
        #include <wx/font.h>
        #include <wx/html/htmltag.h>
        #include <wx/filesys.h>
        #include <wx/html/htmlpars.h>
        #include <wx/filesys.h>
    void _wxHtmlWinParser_SetFonts(wxHtmlWinParser* self, const wxString * normal_face, const wxString * fixed_face, const wxArrayInt* sizes)
    {
        if (sizes->GetCount() != 7) {
            wxPyErr_SetString(PyExc_ValueError, "Sequence of 7 integers expected.");
            return;
        }
        self->SetFonts(*normal_face, *fixed_face, &sizes->Item(0));
    }


class sipwxHtmlWinParser : public  ::wxHtmlWinParser
{
public:
    sipwxHtmlWinParser( ::wxHtmlWindowInterface*);
    virtual ~sipwxHtmlWinParser();

    /*
     * There is a public method for every protected method visible from
     * this class.
     */
    void sipProtectVirt_AddTag(bool,const  ::wxHtmlTag&);

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    void SetDC( ::wxDC*,double);
     ::wxFont* CreateCurrentFont();
    void AddTagHandler( ::wxHtmlTagHandler*);
    void DoneParser();
     ::wxObject* GetProduct();
    void InitParser(const  ::wxString&);
     ::wxFSFile* OpenURL( ::wxHtmlURLType,const  ::wxString&) const;
    void StopParsing();
    void AddTag(const  ::wxHtmlTag&);

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxHtmlWinParser(const sipwxHtmlWinParser &);
    sipwxHtmlWinParser &operator = (const sipwxHtmlWinParser &);

    char sipPyMethods[9];
};

sipwxHtmlWinParser::sipwxHtmlWinParser( ::wxHtmlWindowInterface*wndIface):  ::wxHtmlWinParser(wndIface), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxHtmlWinParser::~sipwxHtmlWinParser()
{
    sipInstanceDestroyed(sipPySelf);
}

void sipwxHtmlWinParser::SetDC( ::wxDC*dc,double pixel_scale)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[0],sipPySelf,NULL,sipName_SetDC);

    if (!sipMeth)
    {
         ::wxHtmlWinParser::SetDC(dc,pixel_scale);
        return;
    }

    extern void sipVH__html_60(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxDC*,double);

    sipVH__html_60(sipGILState, 0, sipPySelf, sipMeth, dc, pixel_scale);
}

 ::wxFont* sipwxHtmlWinParser::CreateCurrentFont()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[1],sipPySelf,NULL,sipName_CreateCurrentFont);

    if (!sipMeth)
        return  ::wxHtmlWinParser::CreateCurrentFont();

    extern  ::wxFont* sipVH__html_59(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__html_59(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxHtmlWinParser::AddTagHandler( ::wxHtmlTagHandler*handler)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[2],sipPySelf,NULL,sipName_AddTagHandler);

    if (!sipMeth)
    {
         ::wxHtmlWinParser::AddTagHandler(handler);
        return;
    }

    extern void sipVH__html_19(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxHtmlTagHandler*);

    sipVH__html_19(sipGILState, 0, sipPySelf, sipMeth, handler);
}

void sipwxHtmlWinParser::DoneParser()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[3],sipPySelf,NULL,sipName_DoneParser);

    if (!sipMeth)
    {
         ::wxHtmlWinParser::DoneParser();
        return;
    }

    extern void sipVH__html_20(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__html_20(sipGILState, 0, sipPySelf, sipMeth);
}

 ::wxObject* sipwxHtmlWinParser::GetProduct()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[4],sipPySelf,NULL,sipName_GetProduct);

    if (!sipMeth)
        return  ::wxHtmlWinParser::GetProduct();

    extern  ::wxObject* sipVH__html_21(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__html_21(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxHtmlWinParser::InitParser(const  ::wxString& source)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[5],sipPySelf,NULL,sipName_InitParser);

    if (!sipMeth)
    {
         ::wxHtmlWinParser::InitParser(source);
        return;
    }

    extern void sipVH__html_22(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&);

    sipVH__html_22(sipGILState, 0, sipPySelf, sipMeth, source);
}

 ::wxFSFile* sipwxHtmlWinParser::OpenURL( ::wxHtmlURLType type,const  ::wxString& url) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[6]),sipPySelf,NULL,sipName_OpenURL);

    if (!sipMeth)
        return  ::wxHtmlWinParser::OpenURL(type,url);

    extern  ::wxFSFile* sipVH__html_23(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxHtmlURLType,const  ::wxString&);

    return sipVH__html_23(sipGILState, 0, sipPySelf, sipMeth, type, url);
}

void sipwxHtmlWinParser::StopParsing()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[7],sipPySelf,NULL,sipName_StopParsing);

    if (!sipMeth)
    {
         ::wxHtmlWinParser::StopParsing();
        return;
    }

    extern void sipVH__html_20(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__html_20(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxHtmlWinParser::AddTag(const  ::wxHtmlTag& tag)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[8],sipPySelf,NULL,sipName_AddTag);

    if (!sipMeth)
    {
         ::wxHtmlWinParser::AddTag(tag);
        return;
    }

    extern void sipVH__html_24(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxHtmlTag&);

    sipVH__html_24(sipGILState, 0, sipPySelf, sipMeth, tag);
}

void sipwxHtmlWinParser::sipProtectVirt_AddTag(bool sipSelfWasArg,const  ::wxHtmlTag& tag)
{
    (sipSelfWasArg ?  ::wxHtmlParser::AddTag(tag) : AddTag(tag));
}


PyDoc_STRVAR(doc_wxHtmlWinParser_AddTag, "AddTag(tag)\n"
"\n"
"This may (and may not) be overwritten in derived class.");

extern "C" {static PyObject *meth_wxHtmlWinParser_AddTag(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_AddTag(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxHtmlTag* tag;
        sipwxHtmlWinParser *sipCpp;

        static const char *sipKwdList[] = {
            sipName_tag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxHtmlWinParser, &sipCpp, sipType_wxHtmlTag, &tag))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->sipProtectVirt_AddTag(sipSelfWasArg,*tag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_AddTag, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_CloseContainer, "CloseContainer() -> HtmlContainerCell\n"
"\n"
"Closes the container, sets actual container to the parent one and\n"
"returns pointer to it (see Cells and Containers).");

extern "C" {static PyObject *meth_wxHtmlWinParser_CloseContainer(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_CloseContainer(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxHtmlWinParser *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlWinParser, &sipCpp))
        {
             ::wxHtmlContainerCell*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CloseContainer();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxHtmlContainerCell,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_CloseContainer, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_CreateCurrentFont, "CreateCurrentFont() -> wx.Font\n"
"\n"
"Creates font based on current setting (see SetFontSize(),\n"
"SetFontBold(), SetFontItalic(), SetFontFixed(),\n"
"wxHtmlWinParser::SetFontUnderlined) and returns pointer to it.");

extern "C" {static PyObject *meth_wxHtmlWinParser_CreateCurrentFont(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_CreateCurrentFont(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxHtmlWinParser *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlWinParser, &sipCpp))
        {
             ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxHtmlWinParser::CreateCurrentFont() : sipCpp->CreateCurrentFont());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFont,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_CreateCurrentFont, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_GetActualColor, "GetActualColor() -> wx.Colour\n"
"\n"
"Returns actual text colour.");

extern "C" {static PyObject *meth_wxHtmlWinParser_GetActualColor(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_GetActualColor(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlWinParser *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlWinParser, &sipCpp))
        {
             ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxColour(sipCpp->GetActualColor());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxColour,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_GetActualColor, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_GetAlign, "GetAlign() -> int\n"
"\n"
"Returns default horizontal alignment.");

extern "C" {static PyObject *meth_wxHtmlWinParser_GetAlign(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_GetAlign(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlWinParser *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlWinParser, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetAlign();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_GetAlign, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_GetCharHeight, "GetCharHeight() -> int\n"
"\n"
"Returns (average) char height in standard font.");

extern "C" {static PyObject *meth_wxHtmlWinParser_GetCharHeight(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_GetCharHeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlWinParser *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlWinParser, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetCharHeight();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_GetCharHeight, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_GetCharWidth, "GetCharWidth() -> int\n"
"\n"
"Returns average char width in standard font.");

extern "C" {static PyObject *meth_wxHtmlWinParser_GetCharWidth(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_GetCharWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlWinParser *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlWinParser, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetCharWidth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_GetCharWidth, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_GetContainer, "GetContainer() -> HtmlContainerCell\n"
"\n"
"Returns pointer to the currently opened container (see Cells and\n"
"Containers).");

extern "C" {static PyObject *meth_wxHtmlWinParser_GetContainer(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_GetContainer(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlWinParser *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlWinParser, &sipCpp))
        {
             ::wxHtmlContainerCell*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetContainer();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxHtmlContainerCell,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_GetContainer, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_GetDC, "GetDC() -> wx.DC\n"
"\n"
"Returns pointer to the DC used during parsing.");

extern "C" {static PyObject *meth_wxHtmlWinParser_GetDC(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_GetDC(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxHtmlWinParser *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlWinParser, &sipCpp))
        {
             ::wxDC*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDC();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDC,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_GetDC, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_GetFontBold, "GetFontBold() -> int\n"
"\n"
"Returns true if actual font is bold, false otherwise.");

extern "C" {static PyObject *meth_wxHtmlWinParser_GetFontBold(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_GetFontBold(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlWinParser *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlWinParser, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFontBold();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_GetFontBold, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_GetFontFace, "GetFontFace() -> String\n"
"\n"
"Returns actual font face name.");

extern "C" {static PyObject *meth_wxHtmlWinParser_GetFontFace(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_GetFontFace(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlWinParser *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlWinParser, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetFontFace());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_GetFontFace, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_GetFontFixed, "GetFontFixed() -> int\n"
"\n"
"Returns true if actual font is fixed face, false otherwise.");

extern "C" {static PyObject *meth_wxHtmlWinParser_GetFontFixed(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_GetFontFixed(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlWinParser *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlWinParser, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFontFixed();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_GetFontFixed, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_GetFontItalic, "GetFontItalic() -> int\n"
"\n"
"Returns true if actual font is italic, false otherwise.");

extern "C" {static PyObject *meth_wxHtmlWinParser_GetFontItalic(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_GetFontItalic(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlWinParser *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlWinParser, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFontItalic();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_GetFontItalic, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_GetFontSize, "GetFontSize() -> int\n"
"\n"
"Returns actual font size (HTML size varies from -2 to +4)");

extern "C" {static PyObject *meth_wxHtmlWinParser_GetFontSize(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_GetFontSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlWinParser *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlWinParser, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFontSize();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_GetFontSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_GetFontUnderlined, "GetFontUnderlined() -> int\n"
"\n"
"Returns true if actual font is underlined, false otherwise.");

extern "C" {static PyObject *meth_wxHtmlWinParser_GetFontUnderlined(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_GetFontUnderlined(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlWinParser *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlWinParser, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFontUnderlined();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_GetFontUnderlined, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_GetLink, "GetLink() -> HtmlLinkInfo\n"
"\n"
"Returns actual hypertext link.");

extern "C" {static PyObject *meth_wxHtmlWinParser_GetLink(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_GetLink(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlWinParser *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlWinParser, &sipCpp))
        {
             ::wxHtmlLinkInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxHtmlLinkInfo(sipCpp->GetLink());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxHtmlLinkInfo,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_GetLink, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_GetLinkColor, "GetLinkColor() -> wx.Colour\n"
"\n"
"Returns the colour of hypertext link text.");

extern "C" {static PyObject *meth_wxHtmlWinParser_GetLinkColor(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_GetLinkColor(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlWinParser *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlWinParser, &sipCpp))
        {
             ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxColour(sipCpp->GetLinkColor());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxColour,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_GetLinkColor, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_GetWindowInterface, "GetWindowInterface() -> HtmlWindowInterface\n"
"\n"
"Returns associated window (wxHtmlWindow).");

extern "C" {static PyObject *meth_wxHtmlWinParser_GetWindowInterface(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_GetWindowInterface(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxHtmlWinParser *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlWinParser, &sipCpp))
        {
             ::wxHtmlWindowInterface*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetWindowInterface();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxHtmlWindowInterface,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_GetWindowInterface, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_OpenContainer, "OpenContainer() -> HtmlContainerCell\n"
"\n"
"Opens new container and returns pointer to it (see Cells and\n"
"Containers).");

extern "C" {static PyObject *meth_wxHtmlWinParser_OpenContainer(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_OpenContainer(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxHtmlWinParser *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlWinParser, &sipCpp))
        {
             ::wxHtmlContainerCell*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->OpenContainer();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxHtmlContainerCell,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_OpenContainer, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_SetActualColor, "SetActualColor(clr)\n"
"\n"
"Sets actual text colour.");

extern "C" {static PyObject *meth_wxHtmlWinParser_SetActualColor(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_SetActualColor(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxColour* clr;
        int clrState = 0;
         ::wxHtmlWinParser *sipCpp;

        static const char *sipKwdList[] = {
            sipName_clr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxHtmlWinParser, &sipCpp, sipType_wxColour, &clr, &clrState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetActualColor(*clr);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(clr),sipType_wxColour,clrState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_SetActualColor, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_SetAlign, "SetAlign(a)\n"
"\n"
"Sets default horizontal alignment (see\n"
"wxHtmlContainerCell::SetAlignHor).");

extern "C" {static PyObject *meth_wxHtmlWinParser_SetAlign(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_SetAlign(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int a;
         ::wxHtmlWinParser *sipCpp;

        static const char *sipKwdList[] = {
            sipName_a,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxHtmlWinParser, &sipCpp, &a))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetAlign(a);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_SetAlign, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_SetContainer, "SetContainer(c) -> HtmlContainerCell\n"
"\n"
"Allows you to directly set opened container.");

extern "C" {static PyObject *meth_wxHtmlWinParser_SetContainer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_SetContainer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxHtmlContainerCell* c;
         ::wxHtmlWinParser *sipCpp;

        static const char *sipKwdList[] = {
            sipName_c,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxHtmlWinParser, &sipCpp, sipType_wxHtmlContainerCell, &c))
        {
             ::wxHtmlContainerCell*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetContainer(c);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxHtmlContainerCell,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_SetContainer, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_SetDC, "SetDC(dc, pixel_scale=1.0e+0)\n"
"\n"
"Sets the DC.");

extern "C" {static PyObject *meth_wxHtmlWinParser_SetDC(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_SetDC(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxDC* dc;
        double pixel_scale = 1;
         ::wxHtmlWinParser *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dc,
            sipName_pixel_scale,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8|d", &sipSelf, sipType_wxHtmlWinParser, &sipCpp, sipType_wxDC, &dc, &pixel_scale))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxHtmlWinParser::SetDC(dc,pixel_scale) : sipCpp->SetDC(dc,pixel_scale));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_SetDC, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_SetFontBold, "SetFontBold(x)\n"
"\n"
"Sets bold flag of actualfont.");

extern "C" {static PyObject *meth_wxHtmlWinParser_SetFontBold(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_SetFontBold(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int x;
         ::wxHtmlWinParser *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxHtmlWinParser, &sipCpp, &x))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFontBold(x);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_SetFontBold, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_SetFontFace, "SetFontFace(face)\n"
"\n"
"Sets current font face to face.");

extern "C" {static PyObject *meth_wxHtmlWinParser_SetFontFace(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_SetFontFace(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* face;
        int faceState = 0;
         ::wxHtmlWinParser *sipCpp;

        static const char *sipKwdList[] = {
            sipName_face,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxHtmlWinParser, &sipCpp, sipType_wxString,&face, &faceState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFontFace(*face);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(face),sipType_wxString,faceState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_SetFontFace, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_SetFontFixed, "SetFontFixed(x)\n"
"\n"
"Sets fixed face flag of actualfont.");

extern "C" {static PyObject *meth_wxHtmlWinParser_SetFontFixed(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_SetFontFixed(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int x;
         ::wxHtmlWinParser *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxHtmlWinParser, &sipCpp, &x))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFontFixed(x);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_SetFontFixed, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_SetFontItalic, "SetFontItalic(x)\n"
"\n"
"Sets italic flag of actualfont.");

extern "C" {static PyObject *meth_wxHtmlWinParser_SetFontItalic(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_SetFontItalic(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int x;
         ::wxHtmlWinParser *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxHtmlWinParser, &sipCpp, &x))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFontItalic(x);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_SetFontItalic, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_SetFontSize, "SetFontSize(s)\n"
"\n"
"Sets actual font size (HTML size varies from 1 to 7).");

extern "C" {static PyObject *meth_wxHtmlWinParser_SetFontSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_SetFontSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int s;
         ::wxHtmlWinParser *sipCpp;

        static const char *sipKwdList[] = {
            sipName_s,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxHtmlWinParser, &sipCpp, &s))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFontSize(s);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_SetFontSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_SetFontUnderlined, "SetFontUnderlined(x)\n"
"\n"
"Sets underlined flag of actualfont.");

extern "C" {static PyObject *meth_wxHtmlWinParser_SetFontUnderlined(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_SetFontUnderlined(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int x;
         ::wxHtmlWinParser *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxHtmlWinParser, &sipCpp, &x))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFontUnderlined(x);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_SetFontUnderlined, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_SetFonts, "SetFonts(normal_face, fixed_face, sizes)\n"
"\n"
"Sets fonts.");

extern "C" {static PyObject *meth_wxHtmlWinParser_SetFonts(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_SetFonts(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* normal_face;
        int normal_faceState = 0;
        const  ::wxString* fixed_face;
        int fixed_faceState = 0;
        const  ::wxArrayInt* sizes;
        int sizesState = 0;
         ::wxHtmlWinParser *sipCpp;

        static const char *sipKwdList[] = {
            sipName_normal_face,
            sipName_fixed_face,
            sipName_sizes,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1J1", &sipSelf, sipType_wxHtmlWinParser, &sipCpp, sipType_wxString,&normal_face, &normal_faceState, sipType_wxString,&fixed_face, &fixed_faceState, sipType_wxArrayInt,&sizes, &sizesState))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxHtmlWinParser_SetFonts(sipCpp, normal_face, fixed_face, sizes);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(normal_face),sipType_wxString,normal_faceState);
            sipReleaseType(const_cast< ::wxString *>(fixed_face),sipType_wxString,fixed_faceState);
            sipReleaseType(const_cast< ::wxArrayInt *>(sizes),sipType_wxArrayInt,sizesState);

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_SetFonts, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_SetLink, "SetLink(link)\n"
"\n"
"Sets actual hypertext link.");

extern "C" {static PyObject *meth_wxHtmlWinParser_SetLink(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_SetLink(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlLinkInfo* link;
         ::wxHtmlWinParser *sipCpp;

        static const char *sipKwdList[] = {
            sipName_link,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxHtmlWinParser, &sipCpp, sipType_wxHtmlLinkInfo, &link))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLink(*link);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_SetLink, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_SetLinkColor, "SetLinkColor(clr)\n"
"\n"
"Sets colour of hypertext link.");

extern "C" {static PyObject *meth_wxHtmlWinParser_SetLinkColor(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_SetLinkColor(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxColour* clr;
        int clrState = 0;
         ::wxHtmlWinParser *sipCpp;

        static const char *sipKwdList[] = {
            sipName_clr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxHtmlWinParser, &sipCpp, sipType_wxColour, &clr, &clrState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLinkColor(*clr);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(clr),sipType_wxColour,clrState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_SetLinkColor, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlWinParser_GetProduct, "GetProduct(self) -> Object");

extern "C" {static PyObject *meth_wxHtmlWinParser_GetProduct(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWinParser_GetProduct(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxHtmlWinParser *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlWinParser, &sipCpp))
        {
             ::wxObject*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxHtmlWinParser::GetProduct() : sipCpp->GetProduct());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxObject,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWinParser, sipName_GetProduct, doc_wxHtmlWinParser_GetProduct);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxHtmlWinParser(void *, const sipTypeDef *);}
static void *cast_wxHtmlWinParser(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxHtmlWinParser *sipCpp = reinterpret_cast< ::wxHtmlWinParser *>(sipCppV);

    if (targetType == sipType_wxHtmlParser)
        return static_cast< ::wxHtmlParser *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxHtmlWinParser(void *, int);}
static void release_wxHtmlWinParser(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxHtmlWinParser *>(sipCppV);
    else
        delete reinterpret_cast< ::wxHtmlWinParser *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxHtmlWinParser(sipSimpleWrapper *);}
static void dealloc_wxHtmlWinParser(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxHtmlWinParser *>(sipGetAddress(sipSelf))->sipPySelf = NULL;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxHtmlWinParser(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxHtmlWinParser(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxHtmlWinParser(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxHtmlWinParser *sipCpp = 0;

    {
         ::wxHtmlWindowInterface* wndIface = 0;

        static const char *sipKwdList[] = {
            sipName_wndIface,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J8", sipType_wxHtmlWindowInterface, &wndIface))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxHtmlWinParser(wndIface);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxHtmlWinParser[] = {{22, 255, 1}};


static PyMethodDef methods_wxHtmlWinParser[] = {
    {SIP_MLNAME_CAST(sipName_AddTag), (PyCFunction)meth_wxHtmlWinParser_AddTag, METH_VARARGS|METH_KEYWORDS, NULL},
    {SIP_MLNAME_CAST(sipName_CloseContainer), meth_wxHtmlWinParser_CloseContainer, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_CloseContainer)},
    {SIP_MLNAME_CAST(sipName_CreateCurrentFont), meth_wxHtmlWinParser_CreateCurrentFont, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_CreateCurrentFont)},
    {SIP_MLNAME_CAST(sipName_GetActualColor), meth_wxHtmlWinParser_GetActualColor, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_GetActualColor)},
    {SIP_MLNAME_CAST(sipName_GetAlign), meth_wxHtmlWinParser_GetAlign, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_GetAlign)},
    {SIP_MLNAME_CAST(sipName_GetCharHeight), meth_wxHtmlWinParser_GetCharHeight, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_GetCharHeight)},
    {SIP_MLNAME_CAST(sipName_GetCharWidth), meth_wxHtmlWinParser_GetCharWidth, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_GetCharWidth)},
    {SIP_MLNAME_CAST(sipName_GetContainer), meth_wxHtmlWinParser_GetContainer, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_GetContainer)},
    {SIP_MLNAME_CAST(sipName_GetDC), meth_wxHtmlWinParser_GetDC, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_GetDC)},
    {SIP_MLNAME_CAST(sipName_GetFontBold), meth_wxHtmlWinParser_GetFontBold, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_GetFontBold)},
    {SIP_MLNAME_CAST(sipName_GetFontFace), meth_wxHtmlWinParser_GetFontFace, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_GetFontFace)},
    {SIP_MLNAME_CAST(sipName_GetFontFixed), meth_wxHtmlWinParser_GetFontFixed, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_GetFontFixed)},
    {SIP_MLNAME_CAST(sipName_GetFontItalic), meth_wxHtmlWinParser_GetFontItalic, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_GetFontItalic)},
    {SIP_MLNAME_CAST(sipName_GetFontSize), meth_wxHtmlWinParser_GetFontSize, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_GetFontSize)},
    {SIP_MLNAME_CAST(sipName_GetFontUnderlined), meth_wxHtmlWinParser_GetFontUnderlined, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_GetFontUnderlined)},
    {SIP_MLNAME_CAST(sipName_GetLink), meth_wxHtmlWinParser_GetLink, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_GetLink)},
    {SIP_MLNAME_CAST(sipName_GetLinkColor), meth_wxHtmlWinParser_GetLinkColor, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_GetLinkColor)},
    {SIP_MLNAME_CAST(sipName_GetProduct), meth_wxHtmlWinParser_GetProduct, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_GetProduct)},
    {SIP_MLNAME_CAST(sipName_GetWindowInterface), meth_wxHtmlWinParser_GetWindowInterface, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_GetWindowInterface)},
    {SIP_MLNAME_CAST(sipName_OpenContainer), meth_wxHtmlWinParser_OpenContainer, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_OpenContainer)},
    {SIP_MLNAME_CAST(sipName_SetActualColor), (PyCFunction)meth_wxHtmlWinParser_SetActualColor, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_SetActualColor)},
    {SIP_MLNAME_CAST(sipName_SetAlign), (PyCFunction)meth_wxHtmlWinParser_SetAlign, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_SetAlign)},
    {SIP_MLNAME_CAST(sipName_SetContainer), (PyCFunction)meth_wxHtmlWinParser_SetContainer, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_SetContainer)},
    {SIP_MLNAME_CAST(sipName_SetDC), (PyCFunction)meth_wxHtmlWinParser_SetDC, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_SetDC)},
    {SIP_MLNAME_CAST(sipName_SetFontBold), (PyCFunction)meth_wxHtmlWinParser_SetFontBold, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_SetFontBold)},
    {SIP_MLNAME_CAST(sipName_SetFontFace), (PyCFunction)meth_wxHtmlWinParser_SetFontFace, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_SetFontFace)},
    {SIP_MLNAME_CAST(sipName_SetFontFixed), (PyCFunction)meth_wxHtmlWinParser_SetFontFixed, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_SetFontFixed)},
    {SIP_MLNAME_CAST(sipName_SetFontItalic), (PyCFunction)meth_wxHtmlWinParser_SetFontItalic, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_SetFontItalic)},
    {SIP_MLNAME_CAST(sipName_SetFontSize), (PyCFunction)meth_wxHtmlWinParser_SetFontSize, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_SetFontSize)},
    {SIP_MLNAME_CAST(sipName_SetFontUnderlined), (PyCFunction)meth_wxHtmlWinParser_SetFontUnderlined, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_SetFontUnderlined)},
    {SIP_MLNAME_CAST(sipName_SetFonts), (PyCFunction)meth_wxHtmlWinParser_SetFonts, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_SetFonts)},
    {SIP_MLNAME_CAST(sipName_SetLink), (PyCFunction)meth_wxHtmlWinParser_SetLink, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_SetLink)},
    {SIP_MLNAME_CAST(sipName_SetLinkColor), (PyCFunction)meth_wxHtmlWinParser_SetLinkColor, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlWinParser_SetLinkColor)}
};

sipVariableDef variables_wxHtmlWinParser[] = {
    {PropertyVariable, sipName_WindowInterface, &methods_wxHtmlWinParser[18], NULL, NULL, NULL},
    {PropertyVariable, sipName_LinkColor, &methods_wxHtmlWinParser[16], &methods_wxHtmlWinParser[32], NULL, NULL},
    {PropertyVariable, sipName_Link, &methods_wxHtmlWinParser[15], &methods_wxHtmlWinParser[31], NULL, NULL},
    {PropertyVariable, sipName_FontUnderlined, &methods_wxHtmlWinParser[14], &methods_wxHtmlWinParser[29], NULL, NULL},
    {PropertyVariable, sipName_FontSize, &methods_wxHtmlWinParser[13], &methods_wxHtmlWinParser[28], NULL, NULL},
    {PropertyVariable, sipName_FontItalic, &methods_wxHtmlWinParser[12], &methods_wxHtmlWinParser[27], NULL, NULL},
    {PropertyVariable, sipName_FontFixed, &methods_wxHtmlWinParser[11], &methods_wxHtmlWinParser[26], NULL, NULL},
    {PropertyVariable, sipName_FontFace, &methods_wxHtmlWinParser[10], &methods_wxHtmlWinParser[25], NULL, NULL},
    {PropertyVariable, sipName_FontBold, &methods_wxHtmlWinParser[9], &methods_wxHtmlWinParser[24], NULL, NULL},
    {PropertyVariable, sipName_DC, &methods_wxHtmlWinParser[8], &methods_wxHtmlWinParser[23], NULL, NULL},
    {PropertyVariable, sipName_Container, &methods_wxHtmlWinParser[7], &methods_wxHtmlWinParser[22], NULL, NULL},
    {PropertyVariable, sipName_CharWidth, &methods_wxHtmlWinParser[6], NULL, NULL, NULL},
    {PropertyVariable, sipName_CharHeight, &methods_wxHtmlWinParser[5], NULL, NULL, NULL},
    {PropertyVariable, sipName_Align, &methods_wxHtmlWinParser[4], &methods_wxHtmlWinParser[21], NULL, NULL},
    {PropertyVariable, sipName_ActualColor, &methods_wxHtmlWinParser[3], &methods_wxHtmlWinParser[20], NULL, NULL},
};

PyDoc_STRVAR(doc_wxHtmlWinParser, "HtmlWinParser(wndIface=None)\n"
"\n"
"This class is derived from wxHtmlParser and its main goal is to parse\n"
"HTML input so that it can be displayed in wxHtmlWindow.");


sipClassTypeDef sipTypeDef__html_wxHtmlWinParser = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxHtmlWinParser,
        {0},
        0
    },
    {
        sipNameNr_HtmlWinParser,
        {0, 0, 1},
        33, methods_wxHtmlWinParser,
        0, 0,
        15, variables_wxHtmlWinParser,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxHtmlWinParser,
    -1,
    -1,
    supers_wxHtmlWinParser,
    0,
    init_type_wxHtmlWinParser,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxHtmlWinParser,
    0,
    0,
    0,
    release_wxHtmlWinParser,
    cast_wxHtmlWinParser,
    0,
    0,
    0,
    0,
    0,
    0
};
