/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.7
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"

        #include <wx/richtext/richtextbuffer.h>

        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextctrl.h>
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxRichTextAction : public  ::wxRichTextAction
{
public:
    sipwxRichTextAction( ::wxRichTextCommand*,const  ::wxString&, ::wxRichTextCommandId, ::wxRichTextBuffer*, ::wxRichTextParagraphLayoutBox*, ::wxRichTextCtrl*,bool);
    sipwxRichTextAction(const  ::wxRichTextAction&);
    ~sipwxRichTextAction();

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxRichTextAction(const sipwxRichTextAction &);
    sipwxRichTextAction &operator = (const sipwxRichTextAction &);
};

sipwxRichTextAction::sipwxRichTextAction( ::wxRichTextCommand*cmd,const  ::wxString& name, ::wxRichTextCommandId id, ::wxRichTextBuffer*buffer, ::wxRichTextParagraphLayoutBox*container, ::wxRichTextCtrl*ctrl,bool ignoreFirstTime):  ::wxRichTextAction(cmd,name,id,buffer,container,ctrl,ignoreFirstTime), sipPySelf(0)
{
}

sipwxRichTextAction::sipwxRichTextAction(const  ::wxRichTextAction& a0):  ::wxRichTextAction(a0), sipPySelf(0)
{
}

sipwxRichTextAction::~sipwxRichTextAction()
{
    sipInstanceDestroyed(sipPySelf);
}


PyDoc_STRVAR(doc_wxRichTextAction_Do, "Do() -> bool\n"
"\n"
"Performs the action.");

extern "C" {static PyObject *meth_wxRichTextAction_Do(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAction_Do(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextAction *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextAction, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Do();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAction, sipName_Do, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextAction_Undo, "Undo() -> bool\n"
"\n"
"Undoes the action.");

extern "C" {static PyObject *meth_wxRichTextAction_Undo(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAction_Undo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextAction *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextAction, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Undo();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAction, sipName_Undo, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextAction_UpdateAppearance, "UpdateAppearance(caretPosition, sendUpdateEvent=False, optimizationLineCharPositions=None, optimizationLineYPositions=None, isDoCmd=True)\n"
"\n"
"Updates the control appearance, optimizing if possible given\n"
"information from the call to Layout.");

extern "C" {static PyObject *meth_wxRichTextAction_UpdateAppearance(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAction_UpdateAppearance(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        long caretPosition;
        bool sendUpdateEvent = 0;
         ::wxArrayInt* optimizationLineCharPositions = 0;
        int optimizationLineCharPositionsState = 0;
         ::wxArrayInt* optimizationLineYPositions = 0;
        int optimizationLineYPositionsState = 0;
        bool isDoCmd = 1;
         ::wxRichTextAction *sipCpp;

        static const char *sipKwdList[] = {
            sipName_caretPosition,
            sipName_sendUpdateEvent,
            sipName_optimizationLineCharPositions,
            sipName_optimizationLineYPositions,
            sipName_isDoCmd,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bl|bJ0J0b", &sipSelf, sipType_wxRichTextAction, &sipCpp, &caretPosition, &sendUpdateEvent, sipType_wxArrayInt,&optimizationLineCharPositions, &optimizationLineCharPositionsState, sipType_wxArrayInt,&optimizationLineYPositions, &optimizationLineYPositionsState, &isDoCmd))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->UpdateAppearance(caretPosition,sendUpdateEvent,optimizationLineCharPositions,optimizationLineYPositions,isDoCmd);
            Py_END_ALLOW_THREADS
            sipReleaseType(optimizationLineCharPositions,sipType_wxArrayInt,optimizationLineCharPositionsState);
            sipReleaseType(optimizationLineYPositions,sipType_wxArrayInt,optimizationLineYPositionsState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAction, sipName_UpdateAppearance, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextAction_ApplyParagraphs, "ApplyParagraphs(fragment)\n"
"\n"
"Replaces the buffer paragraphs with the given fragment.");

extern "C" {static PyObject *meth_wxRichTextAction_ApplyParagraphs(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAction_ApplyParagraphs(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextParagraphLayoutBox* fragment;
         ::wxRichTextAction *sipCpp;

        static const char *sipKwdList[] = {
            sipName_fragment,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxRichTextAction, &sipCpp, sipType_wxRichTextParagraphLayoutBox, &fragment))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->ApplyParagraphs(*fragment);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAction, sipName_ApplyParagraphs, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextAction_GetNewParagraphs, "GetNewParagraphs() -> RichTextParagraphLayoutBox\n"
"\n"
"Returns the new fragments.");

extern "C" {static PyObject *meth_wxRichTextAction_GetNewParagraphs(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAction_GetNewParagraphs(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextAction *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextAction, &sipCpp))
        {
             ::wxRichTextParagraphLayoutBox*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetNewParagraphs();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxRichTextParagraphLayoutBox,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAction, sipName_GetNewParagraphs, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextAction_GetOldParagraphs, "GetOldParagraphs() -> RichTextParagraphLayoutBox\n"
"\n"
"Returns the old fragments.");

extern "C" {static PyObject *meth_wxRichTextAction_GetOldParagraphs(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAction_GetOldParagraphs(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextAction *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextAction, &sipCpp))
        {
             ::wxRichTextParagraphLayoutBox*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetOldParagraphs();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxRichTextParagraphLayoutBox,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAction, sipName_GetOldParagraphs, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextAction_GetAttributes, "GetAttributes() -> RichTextAttr\n"
"\n"
"Returns the attributes, for single-object commands.");

extern "C" {static PyObject *meth_wxRichTextAction_GetAttributes(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAction_GetAttributes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextAction *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextAction, &sipCpp))
        {
             ::wxRichTextAttr*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetAttributes();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxRichTextAttr,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAction, sipName_GetAttributes, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextAction_GetObject, "GetObject() -> RichTextObject\n"
"\n"
"Returns the object to replace the one at the position defined by the\n"
"container address and the action's range start position.");

extern "C" {static PyObject *meth_wxRichTextAction_GetObject(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAction_GetObject(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextAction *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextAction, &sipCpp))
        {
             ::wxRichTextObject*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetObject();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxRichTextObject,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAction, sipName_GetObject, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextAction_StoreObject, "StoreObject(obj)\n"
"\n"
"Stores the object to replace the one at the position defined by the\n"
"container address without making an address for it.");

extern "C" {static PyObject *meth_wxRichTextAction_StoreObject(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAction_StoreObject(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextObject* obj;
         ::wxRichTextAction *sipCpp;

        static const char *sipKwdList[] = {
            sipName_obj,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxRichTextAction, &sipCpp, sipType_wxRichTextObject, &obj))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->StoreObject(obj);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAction, sipName_StoreObject, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextAction_SetObject, "SetObject(obj)\n"
"\n"
"Sets the object to replace the one at the position defined by the\n"
"container address and the action's range start position.");

extern "C" {static PyObject *meth_wxRichTextAction_SetObject(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAction_SetObject(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextObject* obj;
         ::wxRichTextAction *sipCpp;

        static const char *sipKwdList[] = {
            sipName_obj,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxRichTextAction, &sipCpp, sipType_wxRichTextObject, &obj))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetObject(obj);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAction, sipName_SetObject, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextAction_MakeObject, "MakeObject(obj)\n"
"\n"
"Makes an address from the given object.");

extern "C" {static PyObject *meth_wxRichTextAction_MakeObject(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAction_MakeObject(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextObject* obj;
         ::wxRichTextAction *sipCpp;

        static const char *sipKwdList[] = {
            sipName_obj,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxRichTextAction, &sipCpp, sipType_wxRichTextObject, &obj))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->MakeObject(obj);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAction, sipName_MakeObject, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextAction_SetOldAndNewObjects, "SetOldAndNewObjects(oldObj, newObj)\n"
"\n"
"Sets the existing and new objects, for use with\n"
"wxRICHTEXT_CHANGE_OBJECT.");

extern "C" {static PyObject *meth_wxRichTextAction_SetOldAndNewObjects(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAction_SetOldAndNewObjects(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextObject* oldObj;
         ::wxRichTextObject* newObj;
         ::wxRichTextAction *sipCpp;

        static const char *sipKwdList[] = {
            sipName_oldObj,
            sipName_newObj,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8J8", &sipSelf, sipType_wxRichTextAction, &sipCpp, sipType_wxRichTextObject, &oldObj, sipType_wxRichTextObject, &newObj))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetOldAndNewObjects(oldObj,newObj);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAction, sipName_SetOldAndNewObjects, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextAction_CalculateRefreshOptimizations, "CalculateRefreshOptimizations(optimizationLineCharPositions, optimizationLineYPositions)\n"
"\n"
"Calculate arrays for refresh optimization.");

extern "C" {static PyObject *meth_wxRichTextAction_CalculateRefreshOptimizations(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAction_CalculateRefreshOptimizations(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxArrayInt* optimizationLineCharPositions;
        int optimizationLineCharPositionsState = 0;
         ::wxArrayInt* optimizationLineYPositions;
        int optimizationLineYPositionsState = 0;
         ::wxRichTextAction *sipCpp;

        static const char *sipKwdList[] = {
            sipName_optimizationLineCharPositions,
            sipName_optimizationLineYPositions,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxRichTextAction, &sipCpp, sipType_wxArrayInt,&optimizationLineCharPositions, &optimizationLineCharPositionsState, sipType_wxArrayInt,&optimizationLineYPositions, &optimizationLineYPositionsState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->CalculateRefreshOptimizations(*optimizationLineCharPositions,*optimizationLineYPositions);
            Py_END_ALLOW_THREADS
            sipReleaseType(optimizationLineCharPositions,sipType_wxArrayInt,optimizationLineCharPositionsState);
            sipReleaseType(optimizationLineYPositions,sipType_wxArrayInt,optimizationLineYPositionsState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAction, sipName_CalculateRefreshOptimizations, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextAction_SetPosition, "SetPosition(pos)\n"
"\n"
"Sets the position used for e.g.");

extern "C" {static PyObject *meth_wxRichTextAction_SetPosition(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAction_SetPosition(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        long pos;
         ::wxRichTextAction *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bl", &sipSelf, sipType_wxRichTextAction, &sipCpp, &pos))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPosition(pos);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAction, sipName_SetPosition, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextAction_GetPosition, "GetPosition() -> long\n"
"\n"
"Returns the position used for e.g.");

extern "C" {static PyObject *meth_wxRichTextAction_GetPosition(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAction_GetPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextAction *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextAction, &sipCpp))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPosition();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAction, sipName_GetPosition, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextAction_SetRange, "SetRange(range)\n"
"\n"
"Sets the range for e.g.");

extern "C" {static PyObject *meth_wxRichTextAction_SetRange(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAction_SetRange(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextRange* range;
        int rangeState = 0;
         ::wxRichTextAction *sipCpp;

        static const char *sipKwdList[] = {
            sipName_range,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxRichTextAction, &sipCpp, sipType_wxRichTextRange, &range, &rangeState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetRange(*range);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRichTextRange *>(range),sipType_wxRichTextRange,rangeState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAction, sipName_SetRange, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextAction_GetRange, "GetRange() -> RichTextRange\n"
"\n"
"Returns the range for e.g.");

extern "C" {static PyObject *meth_wxRichTextAction_GetRange(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAction_GetRange(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextAction *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextAction, &sipCpp))
        {
             ::wxRichTextRange*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxRichTextRange(sipCpp->GetRange());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxRichTextRange,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAction, sipName_GetRange, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextAction_GetContainerAddress, "GetContainerAddress() -> RichTextObjectAddress\n"
"\n"
"Returns the address (nested position) of the container within the\n"
"buffer being manipulated.");

extern "C" {static PyObject *meth_wxRichTextAction_GetContainerAddress(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAction_GetContainerAddress(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextAction *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextAction, &sipCpp))
        {
             ::wxRichTextObjectAddress*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetContainerAddress();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxRichTextObjectAddress,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAction, sipName_GetContainerAddress, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextAction_SetContainerAddress, "SetContainerAddress(address)\n"
"SetContainerAddress(container, obj)\n"
"\n"
"Sets the address (nested position) of the container within the buffer\n"
"being manipulated.\n"
"");

extern "C" {static PyObject *meth_wxRichTextAction_SetContainerAddress(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAction_SetContainerAddress(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextObjectAddress* address;
         ::wxRichTextAction *sipCpp;

        static const char *sipKwdList[] = {
            sipName_address,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxRichTextAction, &sipCpp, sipType_wxRichTextObjectAddress, &address))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetContainerAddress(*address);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
         ::wxRichTextParagraphLayoutBox* container;
         ::wxRichTextObject* obj;
         ::wxRichTextAction *sipCpp;

        static const char *sipKwdList[] = {
            sipName_container,
            sipName_obj,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8J8", &sipSelf, sipType_wxRichTextAction, &sipCpp, sipType_wxRichTextParagraphLayoutBox, &container, sipType_wxRichTextObject, &obj))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetContainerAddress(container,obj);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAction, sipName_SetContainerAddress, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextAction_GetContainer, "GetContainer() -> RichTextParagraphLayoutBox\n"
"\n"
"Returns the container that this action refers to, using the container\n"
"address and top-level buffer.");

extern "C" {static PyObject *meth_wxRichTextAction_GetContainer(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAction_GetContainer(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextAction *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextAction, &sipCpp))
        {
             ::wxRichTextParagraphLayoutBox*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetContainer();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxRichTextParagraphLayoutBox,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAction, sipName_GetContainer, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextAction_GetName, "GetName() -> String\n"
"\n"
"Returns the action name.");

extern "C" {static PyObject *meth_wxRichTextAction_GetName(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAction_GetName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextAction *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextAction, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAction, sipName_GetName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextAction_SetIgnoreFirstTime, "SetIgnoreFirstTime(b)\n"
"\n"
"Instructs the first Do() command should be skipped as it's already\n"
"been applied.");

extern "C" {static PyObject *meth_wxRichTextAction_SetIgnoreFirstTime(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAction_SetIgnoreFirstTime(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool b;
         ::wxRichTextAction *sipCpp;

        static const char *sipKwdList[] = {
            sipName_b,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bb", &sipSelf, sipType_wxRichTextAction, &sipCpp, &b))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetIgnoreFirstTime(b);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAction, sipName_SetIgnoreFirstTime, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextAction_GetIgnoreFirstTime, "GetIgnoreFirstTime() -> bool\n"
"\n"
"Returns true if the first Do() command should be skipped as it's\n"
"already been applied.");

extern "C" {static PyObject *meth_wxRichTextAction_GetIgnoreFirstTime(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextAction_GetIgnoreFirstTime(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextAction *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextAction, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetIgnoreFirstTime();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextAction, sipName_GetIgnoreFirstTime, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxRichTextAction(void *, const sipTypeDef *);}
static void *cast_wxRichTextAction(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxRichTextAction *sipCpp = reinterpret_cast< ::wxRichTextAction *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxRichTextAction(void *, int);}
static void release_wxRichTextAction(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxRichTextAction *>(sipCppV);
    else
        delete reinterpret_cast< ::wxRichTextAction *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxRichTextAction(sipSimpleWrapper *);}
static void dealloc_wxRichTextAction(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxRichTextAction *>(sipGetAddress(sipSelf))->sipPySelf = NULL;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxRichTextAction(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxRichTextAction(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxRichTextAction(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxRichTextAction *sipCpp = 0;

    {
         ::wxRichTextCommand* cmd;
        const  ::wxString* name;
        int nameState = 0;
         ::wxRichTextCommandId id;
         ::wxRichTextBuffer* buffer;
         ::wxRichTextParagraphLayoutBox* container;
         ::wxRichTextCtrl* ctrl;
        bool ignoreFirstTime = 0;

        static const char *sipKwdList[] = {
            sipName_cmd,
            sipName_name,
            sipName_id,
            sipName_buffer,
            sipName_container,
            sipName_ctrl,
            sipName_ignoreFirstTime,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J8J1EJ8J8J8|b", sipType_wxRichTextCommand, &cmd, sipType_wxString,&name, &nameState, sipType_wxRichTextCommandId, &id, sipType_wxRichTextBuffer, &buffer, sipType_wxRichTextParagraphLayoutBox, &container, sipType_wxRichTextCtrl, &ctrl, &ignoreFirstTime))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxRichTextAction(cmd,*name,id,buffer,container,ctrl,ignoreFirstTime);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxRichTextAction* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxRichTextAction, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxRichTextAction(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxRichTextAction[] = {{42, 0, 1}};


static PyMethodDef methods_wxRichTextAction[] = {
    {SIP_MLNAME_CAST(sipName_ApplyParagraphs), (PyCFunction)meth_wxRichTextAction_ApplyParagraphs, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextAction_ApplyParagraphs)},
    {SIP_MLNAME_CAST(sipName_CalculateRefreshOptimizations), (PyCFunction)meth_wxRichTextAction_CalculateRefreshOptimizations, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextAction_CalculateRefreshOptimizations)},
    {SIP_MLNAME_CAST(sipName_Do), meth_wxRichTextAction_Do, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextAction_Do)},
    {SIP_MLNAME_CAST(sipName_GetAttributes), meth_wxRichTextAction_GetAttributes, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextAction_GetAttributes)},
    {SIP_MLNAME_CAST(sipName_GetContainer), meth_wxRichTextAction_GetContainer, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextAction_GetContainer)},
    {SIP_MLNAME_CAST(sipName_GetContainerAddress), meth_wxRichTextAction_GetContainerAddress, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextAction_GetContainerAddress)},
    {SIP_MLNAME_CAST(sipName_GetIgnoreFirstTime), meth_wxRichTextAction_GetIgnoreFirstTime, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextAction_GetIgnoreFirstTime)},
    {SIP_MLNAME_CAST(sipName_GetName), meth_wxRichTextAction_GetName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextAction_GetName)},
    {SIP_MLNAME_CAST(sipName_GetNewParagraphs), meth_wxRichTextAction_GetNewParagraphs, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextAction_GetNewParagraphs)},
    {SIP_MLNAME_CAST(sipName_GetObject), meth_wxRichTextAction_GetObject, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextAction_GetObject)},
    {SIP_MLNAME_CAST(sipName_GetOldParagraphs), meth_wxRichTextAction_GetOldParagraphs, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextAction_GetOldParagraphs)},
    {SIP_MLNAME_CAST(sipName_GetPosition), meth_wxRichTextAction_GetPosition, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextAction_GetPosition)},
    {SIP_MLNAME_CAST(sipName_GetRange), meth_wxRichTextAction_GetRange, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextAction_GetRange)},
    {SIP_MLNAME_CAST(sipName_MakeObject), (PyCFunction)meth_wxRichTextAction_MakeObject, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextAction_MakeObject)},
    {SIP_MLNAME_CAST(sipName_SetContainerAddress), (PyCFunction)meth_wxRichTextAction_SetContainerAddress, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextAction_SetContainerAddress)},
    {SIP_MLNAME_CAST(sipName_SetIgnoreFirstTime), (PyCFunction)meth_wxRichTextAction_SetIgnoreFirstTime, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextAction_SetIgnoreFirstTime)},
    {SIP_MLNAME_CAST(sipName_SetObject), (PyCFunction)meth_wxRichTextAction_SetObject, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextAction_SetObject)},
    {SIP_MLNAME_CAST(sipName_SetOldAndNewObjects), (PyCFunction)meth_wxRichTextAction_SetOldAndNewObjects, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextAction_SetOldAndNewObjects)},
    {SIP_MLNAME_CAST(sipName_SetPosition), (PyCFunction)meth_wxRichTextAction_SetPosition, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextAction_SetPosition)},
    {SIP_MLNAME_CAST(sipName_SetRange), (PyCFunction)meth_wxRichTextAction_SetRange, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextAction_SetRange)},
    {SIP_MLNAME_CAST(sipName_StoreObject), (PyCFunction)meth_wxRichTextAction_StoreObject, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextAction_StoreObject)},
    {SIP_MLNAME_CAST(sipName_Undo), meth_wxRichTextAction_Undo, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextAction_Undo)},
    {SIP_MLNAME_CAST(sipName_UpdateAppearance), (PyCFunction)meth_wxRichTextAction_UpdateAppearance, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextAction_UpdateAppearance)}
};

sipVariableDef variables_wxRichTextAction[] = {
    {PropertyVariable, sipName_Range, &methods_wxRichTextAction[12], &methods_wxRichTextAction[19], NULL, NULL},
    {PropertyVariable, sipName_Position, &methods_wxRichTextAction[11], &methods_wxRichTextAction[18], NULL, NULL},
    {PropertyVariable, sipName_OldParagraphs, &methods_wxRichTextAction[10], NULL, NULL, NULL},
    {PropertyVariable, sipName_Object, &methods_wxRichTextAction[9], &methods_wxRichTextAction[16], NULL, NULL},
    {PropertyVariable, sipName_NewParagraphs, &methods_wxRichTextAction[8], NULL, NULL, NULL},
    {PropertyVariable, sipName_Name, &methods_wxRichTextAction[7], NULL, NULL, NULL},
    {PropertyVariable, sipName_IgnoreFirstTime, &methods_wxRichTextAction[6], &methods_wxRichTextAction[15], NULL, NULL},
    {PropertyVariable, sipName_ContainerAddress, &methods_wxRichTextAction[5], &methods_wxRichTextAction[14], NULL, NULL},
    {PropertyVariable, sipName_Container, &methods_wxRichTextAction[4], NULL, NULL, NULL},
    {PropertyVariable, sipName_Attributes, &methods_wxRichTextAction[3], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxRichTextAction, "RichTextAction(cmd, name, id, buffer, container, ctrl, ignoreFirstTime=False)\n"
"\n"
"Implements a part of a command.");


sipClassTypeDef sipTypeDef__richtext_wxRichTextAction = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxRichTextAction,
        {0},
        0
    },
    {
        sipNameNr_RichTextAction,
        {0, 0, 1},
        23, methods_wxRichTextAction,
        0, 0,
        10, variables_wxRichTextAction,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxRichTextAction,
    -1,
    -1,
    supers_wxRichTextAction,
    0,
    init_type_wxRichTextAction,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxRichTextAction,
    0,
    0,
    0,
    release_wxRichTextAction,
    cast_wxRichTextAction,
    0,
    0,
    0,
    0,
    0,
    0
};
