/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.1
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_adv.h"

        #include <wx/aboutdlg.h>

        #include <wx/icon.h>


PyDoc_STRVAR(doc_wxAboutDialogInfo_AddArtist, "AddArtist(artist)\n"
    "\n"
    "Adds an artist name to be shown in the program credits.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_AddArtist(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_AddArtist(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* artist;
        int artistState = 0;
         ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_artist,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxString,&artist, &artistState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddArtist(*artist);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(artist),sipType_wxString,artistState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_AddArtist, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_AddDeveloper, "AddDeveloper(developer)\n"
    "\n"
    "Adds a developer name to be shown in the program credits.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_AddDeveloper(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_AddDeveloper(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* developer;
        int developerState = 0;
         ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_developer,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxString,&developer, &developerState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddDeveloper(*developer);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(developer),sipType_wxString,developerState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_AddDeveloper, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_AddDocWriter, "AddDocWriter(docwriter)\n"
    "\n"
    "Adds a documentation writer name to be shown in the program credits.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_AddDocWriter(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_AddDocWriter(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* docwriter;
        int docwriterState = 0;
         ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_docwriter,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxString,&docwriter, &docwriterState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddDocWriter(*docwriter);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(docwriter),sipType_wxString,docwriterState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_AddDocWriter, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_AddTranslator, "AddTranslator(translator)\n"
    "\n"
    "Adds a translator name to be shown in the program credits.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_AddTranslator(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_AddTranslator(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* translator;
        int translatorState = 0;
         ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_translator,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxString,&translator, &translatorState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddTranslator(*translator);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(translator),sipType_wxString,translatorState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_AddTranslator, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_GetName, "GetName() -> String\n"
    "\n"
    "Get the name of the program.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_GetName(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_GetName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_GetName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_HasDescription, "HasDescription() -> bool\n"
    "\n"
    "Returns true if a description string has been specified.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_HasDescription(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_HasDescription(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasDescription();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_HasDescription, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_GetDescription, "GetDescription() -> String\n"
    "\n"
    "Get the description string.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_GetDescription(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_GetDescription(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetDescription());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_GetDescription, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_HasCopyright, "HasCopyright() -> bool\n"
    "\n"
    "Returns true if a copyright string has been specified.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_HasCopyright(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_HasCopyright(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasCopyright();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_HasCopyright, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_GetCopyright, "GetCopyright() -> String\n"
    "\n"
    "Get the copyright string.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_GetCopyright(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_GetCopyright(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetCopyright());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_GetCopyright, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_SetArtists, "SetArtists(artists)\n"
    "\n"
    "Sets the list of artists to be shown in the program credits.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_SetArtists(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_SetArtists(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxArrayString* artists;
        int artistsState = 0;
         ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_artists,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxArrayString,&artists, &artistsState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetArtists(*artists);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxArrayString *>(artists),sipType_wxArrayString,artistsState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_SetArtists, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_SetCopyright, "SetCopyright(copyright)\n"
    "\n"
    "Set the short string containing the program copyright information.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_SetCopyright(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_SetCopyright(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* copyright;
        int copyrightState = 0;
         ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_copyright,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxString,&copyright, &copyrightState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetCopyright(*copyright);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(copyright),sipType_wxString,copyrightState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_SetCopyright, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_SetDescription, "SetDescription(desc)\n"
    "\n"
    "Set brief, but possibly multiline, description of the program.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_SetDescription(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_SetDescription(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* desc;
        int descState = 0;
         ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_desc,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxString,&desc, &descState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDescription(*desc);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(desc),sipType_wxString,descState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_SetDescription, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_SetDevelopers, "SetDevelopers(developers)\n"
    "\n"
    "Set the list of developers of the program.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_SetDevelopers(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_SetDevelopers(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxArrayString* developers;
        int developersState = 0;
         ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_developers,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxArrayString,&developers, &developersState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDevelopers(*developers);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxArrayString *>(developers),sipType_wxArrayString,developersState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_SetDevelopers, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_SetDocWriters, "SetDocWriters(docwriters)\n"
    "\n"
    "Set the list of documentation writers.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_SetDocWriters(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_SetDocWriters(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxArrayString* docwriters;
        int docwritersState = 0;
         ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_docwriters,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxArrayString,&docwriters, &docwritersState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDocWriters(*docwriters);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxArrayString *>(docwriters),sipType_wxArrayString,docwritersState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_SetDocWriters, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_HasIcon, "HasIcon() -> bool\n"
    "\n"
    "Returns true if an icon has been set for the about dialog.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_HasIcon(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_HasIcon(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasIcon();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_HasIcon, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_GetIcon, "GetIcon() -> wx.Icon\n"
    "\n"
    "Returns the icon set by SetIcon().");

extern "C" {static PyObject *meth_wxAboutDialogInfo_GetIcon(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_GetIcon(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
             ::wxIcon*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxIcon(sipCpp->GetIcon());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxIcon,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_GetIcon, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_SetIcon, "SetIcon(icon)\n"
    "\n"
    "Set the icon to be shown in the dialog.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_SetIcon(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_SetIcon(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxIcon* icon;
         ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_icon,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxIcon, &icon))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetIcon(*icon);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_SetIcon, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_HasLicence, "HasLicence() -> bool\n"
    "\n"
    "Returns true if the licence string has been set.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_HasLicence(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_HasLicence(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasLicence();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_HasLicence, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_GetLicence, "GetLicence() -> String\n"
    "\n"
    "Returns the licence string.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_GetLicence(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_GetLicence(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetLicence());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_GetLicence, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_SetLicence, "SetLicence(licence)\n"
    "\n"
    "Set the long, multiline string containing the text of the program\n"
    "licence.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_SetLicence(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_SetLicence(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* licence;
        int licenceState = 0;
         ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_licence,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxString,&licence, &licenceState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLicence(*licence);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(licence),sipType_wxString,licenceState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_SetLicence, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_SetLicense, "SetLicense(licence)\n"
    "\n"
    "This is the same as SetLicence().");

extern "C" {static PyObject *meth_wxAboutDialogInfo_SetLicense(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_SetLicense(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* licence;
        int licenceState = 0;
         ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_licence,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxString,&licence, &licenceState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLicense(*licence);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(licence),sipType_wxString,licenceState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_SetLicense, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_SetName, "SetName(name)\n"
    "\n"
    "Set the name of the program.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_SetName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_SetName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxString,&name, &nameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetName(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_SetName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_SetTranslators, "SetTranslators(translators)\n"
    "\n"
    "Set the list of translators.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_SetTranslators(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_SetTranslators(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxArrayString* translators;
        int translatorsState = 0;
         ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_translators,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxArrayString,&translators, &translatorsState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetTranslators(*translators);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxArrayString *>(translators),sipType_wxArrayString,translatorsState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_SetTranslators, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_SetVersion, "SetVersion(version, longVersion=\"\")\n"
    "\n"
    "Set the version of the program.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_SetVersion(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_SetVersion(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* version;
        int versionState = 0;
        const  ::wxString& longVersiondef = wxString();
        const  ::wxString* longVersion = &longVersiondef;
        int longVersionState = 0;
         ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_version,
            sipName_longVersion,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|J1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxString,&version, &versionState, sipType_wxString,&longVersion, &longVersionState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetVersion(*version,*longVersion);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(version),sipType_wxString,versionState);
            sipReleaseType(const_cast< ::wxString *>(longVersion),sipType_wxString,longVersionState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_SetVersion, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_GetVersion, "GetVersion() -> String\n"
    "\n"
    "Return the short version string.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_GetVersion(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_GetVersion(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetVersion());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_GetVersion, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_GetLongVersion, "GetLongVersion() -> String\n"
    "\n"
    "Return the long version string if set.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_GetLongVersion(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_GetLongVersion(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetLongVersion());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_GetLongVersion, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_HasWebSite, "HasWebSite() -> bool\n"
    "\n"
    "Returns true if the website info has been set.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_HasWebSite(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_HasWebSite(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasWebSite();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_HasWebSite, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_GetWebSiteURL, "GetWebSiteURL() -> String\n"
    "\n"
    "Returns the website URL set for the dialog.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_GetWebSiteURL(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_GetWebSiteURL(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetWebSiteURL());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_GetWebSiteURL, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_GetWebSiteDescription, "GetWebSiteDescription() -> String\n"
    "\n"
    "Returns the description of the website URL set for the dialog.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_GetWebSiteDescription(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_GetWebSiteDescription(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetWebSiteDescription());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_GetWebSiteDescription, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_SetWebSite, "SetWebSite(url, desc=wx.EmptyString)\n"
    "\n"
    "Set the web site for the program and its description (which defaults\n"
    "to url itself if empty).");

extern "C" {static PyObject *meth_wxAboutDialogInfo_SetWebSite(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_SetWebSite(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* url;
        int urlState = 0;
        const  ::wxString& descdef = wxEmptyString;
        const  ::wxString* desc = &descdef;
        int descState = 0;
         ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_url,
            sipName_desc,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|J1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxString,&url, &urlState, sipType_wxString,&desc, &descState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetWebSite(*url,*desc);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(url),sipType_wxString,urlState);
            sipReleaseType(const_cast< ::wxString *>(desc),sipType_wxString,descState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_SetWebSite, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_HasDevelopers, "HasDevelopers() -> bool\n"
    "\n"
    "Returns true if developers have been set in the dialog info.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_HasDevelopers(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_HasDevelopers(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasDevelopers();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_HasDevelopers, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_GetDevelopers, "GetDevelopers() -> ArrayString\n"
    "\n"
    "Returns an array of the developer strings set in the dialog info.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_GetDevelopers(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_GetDevelopers(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
             ::wxArrayString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxArrayString(sipCpp->GetDevelopers());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxArrayString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_GetDevelopers, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_HasDocWriters, "HasDocWriters() -> bool\n"
    "\n"
    "Returns true if writers have been set in the dialog info.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_HasDocWriters(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_HasDocWriters(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasDocWriters();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_HasDocWriters, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_GetDocWriters, "GetDocWriters() -> ArrayString\n"
    "\n"
    "Returns an array of the writer strings set in the dialog info.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_GetDocWriters(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_GetDocWriters(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
             ::wxArrayString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxArrayString(sipCpp->GetDocWriters());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxArrayString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_GetDocWriters, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_HasArtists, "HasArtists() -> bool\n"
    "\n"
    "Returns true if artists have been set in the dialog info.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_HasArtists(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_HasArtists(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasArtists();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_HasArtists, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_GetArtists, "GetArtists() -> ArrayString\n"
    "\n"
    "Returns an array of the artist strings set in the dialog info.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_GetArtists(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_GetArtists(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
             ::wxArrayString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxArrayString(sipCpp->GetArtists());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxArrayString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_GetArtists, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_HasTranslators, "HasTranslators() -> bool\n"
    "\n"
    "Returns true if translators have been set in the dialog info.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_HasTranslators(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_HasTranslators(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasTranslators();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_HasTranslators, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_GetTranslators, "GetTranslators() -> ArrayString\n"
    "\n"
    "Returns an array of the translator strings set in the dialog info.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_GetTranslators(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_GetTranslators(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
             ::wxArrayString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxArrayString(sipCpp->GetTranslators());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxArrayString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_GetTranslators, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxAboutDialogInfo(void *, int);}
static void release_wxAboutDialogInfo(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxAboutDialogInfo *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxAboutDialogInfo(void *, SIP_SSIZE_T, const void *);}
static void assign_wxAboutDialogInfo(void *sipDst, SIP_SSIZE_T sipDstIdx, const void *sipSrc)
{
    reinterpret_cast< ::wxAboutDialogInfo *>(sipDst)[sipDstIdx] = *reinterpret_cast<const  ::wxAboutDialogInfo *>(sipSrc);
}


extern "C" {static void *array_wxAboutDialogInfo(SIP_SSIZE_T);}
static void *array_wxAboutDialogInfo(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxAboutDialogInfo[sipNrElem];
}


extern "C" {static void *copy_wxAboutDialogInfo(const void *, SIP_SSIZE_T);}
static void *copy_wxAboutDialogInfo(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxAboutDialogInfo(reinterpret_cast<const  ::wxAboutDialogInfo *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxAboutDialogInfo(sipSimpleWrapper *);}
static void dealloc_wxAboutDialogInfo(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxAboutDialogInfo(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxAboutDialogInfo(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxAboutDialogInfo(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxAboutDialogInfo *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxAboutDialogInfo();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxAboutDialogInfo* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxAboutDialogInfo, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxAboutDialogInfo(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return NULL;
}


static PyMethodDef methods_wxAboutDialogInfo[] = {
    {SIP_MLNAME_CAST(sipName_AddArtist), (PyCFunction)meth_wxAboutDialogInfo_AddArtist, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_AddArtist)},
    {SIP_MLNAME_CAST(sipName_AddDeveloper), (PyCFunction)meth_wxAboutDialogInfo_AddDeveloper, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_AddDeveloper)},
    {SIP_MLNAME_CAST(sipName_AddDocWriter), (PyCFunction)meth_wxAboutDialogInfo_AddDocWriter, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_AddDocWriter)},
    {SIP_MLNAME_CAST(sipName_AddTranslator), (PyCFunction)meth_wxAboutDialogInfo_AddTranslator, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_AddTranslator)},
    {SIP_MLNAME_CAST(sipName_GetArtists), meth_wxAboutDialogInfo_GetArtists, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_GetArtists)},
    {SIP_MLNAME_CAST(sipName_GetCopyright), meth_wxAboutDialogInfo_GetCopyright, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_GetCopyright)},
    {SIP_MLNAME_CAST(sipName_GetDescription), meth_wxAboutDialogInfo_GetDescription, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_GetDescription)},
    {SIP_MLNAME_CAST(sipName_GetDevelopers), meth_wxAboutDialogInfo_GetDevelopers, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_GetDevelopers)},
    {SIP_MLNAME_CAST(sipName_GetDocWriters), meth_wxAboutDialogInfo_GetDocWriters, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_GetDocWriters)},
    {SIP_MLNAME_CAST(sipName_GetIcon), meth_wxAboutDialogInfo_GetIcon, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_GetIcon)},
    {SIP_MLNAME_CAST(sipName_GetLicence), meth_wxAboutDialogInfo_GetLicence, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_GetLicence)},
    {SIP_MLNAME_CAST(sipName_GetLongVersion), meth_wxAboutDialogInfo_GetLongVersion, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_GetLongVersion)},
    {SIP_MLNAME_CAST(sipName_GetName), meth_wxAboutDialogInfo_GetName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_GetName)},
    {SIP_MLNAME_CAST(sipName_GetTranslators), meth_wxAboutDialogInfo_GetTranslators, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_GetTranslators)},
    {SIP_MLNAME_CAST(sipName_GetVersion), meth_wxAboutDialogInfo_GetVersion, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_GetVersion)},
    {SIP_MLNAME_CAST(sipName_GetWebSiteDescription), meth_wxAboutDialogInfo_GetWebSiteDescription, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_GetWebSiteDescription)},
    {SIP_MLNAME_CAST(sipName_GetWebSiteURL), meth_wxAboutDialogInfo_GetWebSiteURL, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_GetWebSiteURL)},
    {SIP_MLNAME_CAST(sipName_HasArtists), meth_wxAboutDialogInfo_HasArtists, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_HasArtists)},
    {SIP_MLNAME_CAST(sipName_HasCopyright), meth_wxAboutDialogInfo_HasCopyright, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_HasCopyright)},
    {SIP_MLNAME_CAST(sipName_HasDescription), meth_wxAboutDialogInfo_HasDescription, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_HasDescription)},
    {SIP_MLNAME_CAST(sipName_HasDevelopers), meth_wxAboutDialogInfo_HasDevelopers, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_HasDevelopers)},
    {SIP_MLNAME_CAST(sipName_HasDocWriters), meth_wxAboutDialogInfo_HasDocWriters, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_HasDocWriters)},
    {SIP_MLNAME_CAST(sipName_HasIcon), meth_wxAboutDialogInfo_HasIcon, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_HasIcon)},
    {SIP_MLNAME_CAST(sipName_HasLicence), meth_wxAboutDialogInfo_HasLicence, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_HasLicence)},
    {SIP_MLNAME_CAST(sipName_HasTranslators), meth_wxAboutDialogInfo_HasTranslators, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_HasTranslators)},
    {SIP_MLNAME_CAST(sipName_HasWebSite), meth_wxAboutDialogInfo_HasWebSite, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_HasWebSite)},
    {SIP_MLNAME_CAST(sipName_SetArtists), (PyCFunction)meth_wxAboutDialogInfo_SetArtists, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_SetArtists)},
    {SIP_MLNAME_CAST(sipName_SetCopyright), (PyCFunction)meth_wxAboutDialogInfo_SetCopyright, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_SetCopyright)},
    {SIP_MLNAME_CAST(sipName_SetDescription), (PyCFunction)meth_wxAboutDialogInfo_SetDescription, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_SetDescription)},
    {SIP_MLNAME_CAST(sipName_SetDevelopers), (PyCFunction)meth_wxAboutDialogInfo_SetDevelopers, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_SetDevelopers)},
    {SIP_MLNAME_CAST(sipName_SetDocWriters), (PyCFunction)meth_wxAboutDialogInfo_SetDocWriters, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_SetDocWriters)},
    {SIP_MLNAME_CAST(sipName_SetIcon), (PyCFunction)meth_wxAboutDialogInfo_SetIcon, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_SetIcon)},
    {SIP_MLNAME_CAST(sipName_SetLicence), (PyCFunction)meth_wxAboutDialogInfo_SetLicence, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_SetLicence)},
    {SIP_MLNAME_CAST(sipName_SetLicense), (PyCFunction)meth_wxAboutDialogInfo_SetLicense, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_SetLicense)},
    {SIP_MLNAME_CAST(sipName_SetName), (PyCFunction)meth_wxAboutDialogInfo_SetName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_SetName)},
    {SIP_MLNAME_CAST(sipName_SetTranslators), (PyCFunction)meth_wxAboutDialogInfo_SetTranslators, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_SetTranslators)},
    {SIP_MLNAME_CAST(sipName_SetVersion), (PyCFunction)meth_wxAboutDialogInfo_SetVersion, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_SetVersion)},
    {SIP_MLNAME_CAST(sipName_SetWebSite), (PyCFunction)meth_wxAboutDialogInfo_SetWebSite, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAboutDialogInfo_SetWebSite)}
};

sipVariableDef variables_wxAboutDialogInfo[] = {
    {PropertyVariable, sipName_WebSiteURL, &methods_wxAboutDialogInfo[16], NULL, NULL, NULL},
    {PropertyVariable, sipName_WebSiteDescription, &methods_wxAboutDialogInfo[15], NULL, NULL, NULL},
    {PropertyVariable, sipName_Version, &methods_wxAboutDialogInfo[14], &methods_wxAboutDialogInfo[36], NULL, NULL},
    {PropertyVariable, sipName_Translators, &methods_wxAboutDialogInfo[13], &methods_wxAboutDialogInfo[35], NULL, NULL},
    {PropertyVariable, sipName_Name, &methods_wxAboutDialogInfo[12], &methods_wxAboutDialogInfo[34], NULL, NULL},
    {PropertyVariable, sipName_LongVersion, &methods_wxAboutDialogInfo[11], NULL, NULL, NULL},
    {PropertyVariable, sipName_Licence, &methods_wxAboutDialogInfo[10], &methods_wxAboutDialogInfo[32], NULL, NULL},
    {PropertyVariable, sipName_Icon, &methods_wxAboutDialogInfo[9], &methods_wxAboutDialogInfo[31], NULL, NULL},
    {PropertyVariable, sipName_DocWriters, &methods_wxAboutDialogInfo[8], &methods_wxAboutDialogInfo[30], NULL, NULL},
    {PropertyVariable, sipName_Developers, &methods_wxAboutDialogInfo[7], &methods_wxAboutDialogInfo[29], NULL, NULL},
    {PropertyVariable, sipName_Description, &methods_wxAboutDialogInfo[6], &methods_wxAboutDialogInfo[28], NULL, NULL},
    {PropertyVariable, sipName_Copyright, &methods_wxAboutDialogInfo[5], &methods_wxAboutDialogInfo[27], NULL, NULL},
    {PropertyVariable, sipName_Artists, &methods_wxAboutDialogInfo[4], &methods_wxAboutDialogInfo[26], NULL, NULL},
};

PyDoc_STRVAR(doc_wxAboutDialogInfo, "AboutDialogInfo()\n"
    "\n"
    "wxAboutDialogInfo contains information shown in the standard About\n"
    "dialog displayed by the wxAboutBox() function.");


sipClassTypeDef sipTypeDef__adv_wxAboutDialogInfo = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxAboutDialogInfo,
        {0},
        0
    },
    {
        sipNameNr_AboutDialogInfo,
        {0, 0, 1},
        38, methods_wxAboutDialogInfo,
        0, 0,
        13, variables_wxAboutDialogInfo,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxAboutDialogInfo,
    -1,
    -1,
    0,
    0,
    init_type_wxAboutDialogInfo,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxAboutDialogInfo,
    assign_wxAboutDialogInfo,
    array_wxAboutDialogInfo,
    copy_wxAboutDialogInfo,
    release_wxAboutDialogInfo,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
