/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.1
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"




extern "C" {static void assign_wxArrayString(void *, SIP_SSIZE_T, const void *);}
static void assign_wxArrayString(void *sipDst, SIP_SSIZE_T sipDstIdx, const void *sipSrc)
{
    reinterpret_cast< ::wxArrayString *>(sipDst)[sipDstIdx] = *reinterpret_cast<const  ::wxArrayString *>(sipSrc);
}


extern "C" {static void *array_wxArrayString(SIP_SSIZE_T);}
static void *array_wxArrayString(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxArrayString[sipNrElem];
}


extern "C" {static void *copy_wxArrayString(const void *, SIP_SSIZE_T);}
static void *copy_wxArrayString(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxArrayString(reinterpret_cast<const  ::wxArrayString *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_wxArrayString(void *, int);}
static void release_wxArrayString(void *ptr, int)
{
    Py_BEGIN_ALLOW_THREADS
    delete reinterpret_cast< ::wxArrayString *>(ptr);
    Py_END_ALLOW_THREADS
}



extern "C" {static int convertTo_wxArrayString(PyObject *, void **, int *, PyObject *);}
static int convertTo_wxArrayString(PyObject *sipPy,void **sipCppPtrV,int *sipIsErr,PyObject *sipTransferObj)
{
     ::wxArrayString **sipCppPtr = reinterpret_cast< ::wxArrayString **>(sipCppPtrV);

        // Code to test a PyObject for compatibility
        if (!sipIsErr) {
            int success = TRUE;
            // ensure that it is a sequence
            if (! PySequence_Check(sipPy))
                success = FALSE;
            // Ensure it is not a string or unicode object (they are sequences)
            else if (PyBytes_Check(sipPy) || PyUnicode_Check(sipPy))
                success = FALSE;
            // ensure each item is a string/unicode object
            else {
                Py_ssize_t i, len = PySequence_Length(sipPy);
                for (i=0; i<len; i++) {
                    PyObject* item = PySequence_GetItem(sipPy, i);
                    if (!PyBytes_Check(item) && !PyUnicode_Check(item)) {
                        Py_DECREF(item);
                        success = FALSE;
                        break;
                    }
                    Py_DECREF(item);
                }
            }
            if (!success)
                PyErr_SetString(PyExc_TypeError, "Sequence of string or unicode objects expected.");
            return success;
        }

        // Code to create a new wxArrayString and convert a compatible PyObject
        wxArrayString *array = new wxArrayString;
        Py_ssize_t i, len = PySequence_Length(sipPy);
        for (i=0; i<len; i++) {
            PyObject* item = PySequence_GetItem(sipPy, i);

            // if it's a string object convert it to unicode first, assuming utf-8
            if (PyBytes_Check(item)) {
                Py_DECREF(item);
                item = PyUnicode_FromEncodedObject(item, "utf-8", "strict");
                if (PyErr_Occurred()) {
                    *sipIsErr = 1;
                    delete array;
                    Py_DECREF(item);
                    return 0;
                }
            }
            wxString string;
            size_t len = PyUnicode_GET_SIZE(item);
            if (len) {
                wxPyUnicode_AsWideChar(item, wxStringBuffer(string, len), len);
            }
            if (PyErr_Occurred()) {
                *sipIsErr = 1;
                delete array;
                Py_DECREF(item);
                return 0;
            }
            array->Add(string);
            Py_DECREF(item);
        }
        *sipCppPtr = array;
        return sipGetState(sipTransferObj);
}


extern "C" {static PyObject *convertFrom_wxArrayString(void *, PyObject *);}
static PyObject *convertFrom_wxArrayString(void *sipCppV, PyObject *)
{
    ::wxArrayString *sipCpp = reinterpret_cast< ::wxArrayString *>(sipCppV);

        // Code to convert a wxArrayString to a Python list of strings.
        PyObject* list = PyList_New(0);
        for (size_t i=0; i < sipCpp->GetCount(); i++) {
            PyObject* str = wx2PyString(sipCpp->Item(i));
            PyList_Append(list, str);
            Py_DECREF(str);
        }
        return list;
}


sipMappedTypeDef sipTypeDef__core_wxArrayString = {
    {
        -1,
        0,
        0,
        SIP_TYPE_MAPPED,
        sipNameNr_wxArrayString,     /* wxArrayString */
        {0},
        0
    },
    {
        -1,
        {0, 0, 1},
        0, 0,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
    assign_wxArrayString,
    array_wxArrayString,
    copy_wxArrayString,
    release_wxArrayString,
    convertTo_wxArrayString,
    convertFrom_wxArrayString
};
