/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.1
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/brush.h>

        #include <wx/colour.h>
        #include <wx/bitmap.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #ifdef __WXMAC__
        #include <wx/osx/private.h>
        #endif
    int _wxBrush___nonzero__(wxBrush* self)
    {
        return self->IsOk();
    }
    void _wxBrush_MacSetTheme(wxBrush* self, int macThemeBrushID)
    {
        #ifdef __WXMAC__
            self->SetColour(wxColour(wxMacCreateCGColorFromHITheme(macThemeBrushID)));
        #else
            wxPyRaiseNotImplemented();
        #endif
    }
    void _wxBrush__copyFrom(wxBrush* self, const wxBrush* other)
    {
        *self = *other;
    }


PyDoc_STRVAR(doc_wxBrush_SetColour, "SetColour(colour)\n"
    "SetColour(red, green, blue)\n"
    "\n"
    "Sets the brush colour using red, green and blue values.");

extern "C" {static PyObject *meth_wxBrush_SetColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBrush_SetColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxColour* colour;
        int colourState = 0;
         ::wxBrush *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxBrush, &sipCpp, sipType_wxColour, &colour, &colourState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetColour(*colour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour),sipType_wxColour,colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        unsigned char red;
        unsigned char green;
        unsigned char blue;
         ::wxBrush *sipCpp;

        static const char *sipKwdList[] = {
            sipName_red,
            sipName_green,
            sipName_blue,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bccc", &sipSelf, sipType_wxBrush, &sipCpp, &red, &green, &blue))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetColour(red,green,blue);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Brush, sipName_SetColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxBrush_GetColour, "GetColour() -> Colour\n"
    "\n"
    "Returns a reference to the brush colour.");

extern "C" {static PyObject *meth_wxBrush_GetColour(PyObject *, PyObject *);}
static PyObject *meth_wxBrush_GetColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxBrush *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBrush, &sipCpp))
        {
             ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxColour(sipCpp->GetColour());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxColour,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Brush, sipName_GetColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxBrush_GetStipple, "GetStipple() -> Bitmap\n"
    "\n"
    "Gets a pointer to the stipple bitmap.");

extern "C" {static PyObject *meth_wxBrush_GetStipple(PyObject *, PyObject *);}
static PyObject *meth_wxBrush_GetStipple(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxBrush *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBrush, &sipCpp))
        {
             ::wxBitmap*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetStipple();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxBitmap,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Brush, sipName_GetStipple, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxBrush_GetStyle, "GetStyle() -> BrushStyle\n"
    "\n"
    "Returns the brush style, one of the wxBrushStyle values.");

extern "C" {static PyObject *meth_wxBrush_GetStyle(PyObject *, PyObject *);}
static PyObject *meth_wxBrush_GetStyle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxBrush *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBrush, &sipCpp))
        {
             ::wxBrushStyle sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetStyle();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(sipRes,sipType_wxBrushStyle);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Brush, sipName_GetStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxBrush_IsHatch, "IsHatch() -> bool\n"
    "\n"
    "Returns true if the style of the brush is any of hatched fills.");

extern "C" {static PyObject *meth_wxBrush_IsHatch(PyObject *, PyObject *);}
static PyObject *meth_wxBrush_IsHatch(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxBrush *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBrush, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsHatch();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Brush, sipName_IsHatch, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxBrush_IsOk, "IsOk() -> bool\n"
    "\n"
    "Returns true if the brush is initialised.");

extern "C" {static PyObject *meth_wxBrush_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxBrush_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxBrush *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBrush, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Brush, sipName_IsOk, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxBrush_IsNonTransparent, "IsNonTransparent() -> bool\n"
    "\n"
    "Returns true if the brush is a valid non-transparent brush.");

extern "C" {static PyObject *meth_wxBrush_IsNonTransparent(PyObject *, PyObject *);}
static PyObject *meth_wxBrush_IsNonTransparent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxBrush *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBrush, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsNonTransparent();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Brush, sipName_IsNonTransparent, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxBrush_IsTransparent, "IsTransparent() -> bool\n"
    "\n"
    "Returns true if the brush is transparent.");

extern "C" {static PyObject *meth_wxBrush_IsTransparent(PyObject *, PyObject *);}
static PyObject *meth_wxBrush_IsTransparent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxBrush *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBrush, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsTransparent();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Brush, sipName_IsTransparent, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxBrush_SetStipple, "SetStipple(bitmap)\n"
    "\n"
    "Sets the stipple bitmap.");

extern "C" {static PyObject *meth_wxBrush_SetStipple(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBrush_SetStipple(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxBitmap* bitmap;
         ::wxBrush *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bitmap,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxBrush, &sipCpp, sipType_wxBitmap, &bitmap))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetStipple(*bitmap);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Brush, sipName_SetStipple, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxBrush_SetStyle, "SetStyle(style)\n"
    "\n"
    "Sets the brush style.");

extern "C" {static PyObject *meth_wxBrush_SetStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBrush_SetStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxBrushStyle style;
         ::wxBrush *sipCpp;

        static const char *sipKwdList[] = {
            sipName_style,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxBrush, &sipCpp, sipType_wxBrushStyle, &style))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetStyle(style);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Brush, sipName_SetStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxBrush_MacSetTheme, "MacSetTheme(macThemeBrushID)");

extern "C" {static PyObject *meth_wxBrush_MacSetTheme(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBrush_MacSetTheme(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int macThemeBrushID;
         ::wxBrush *sipCpp;

        static const char *sipKwdList[] = {
            sipName_macThemeBrushID,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxBrush, &sipCpp, &macThemeBrushID))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxBrush_MacSetTheme(sipCpp, macThemeBrushID);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Brush, sipName_MacSetTheme, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxBrush__copyFrom, "_copyFrom(other)\n"
    "\n"
    "For internal use only.");

extern "C" {static PyObject *meth_wxBrush__copyFrom(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBrush__copyFrom(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxBrush* other;
         ::wxBrush *sipCpp;

        static const char *sipKwdList[] = {
            sipName_other,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxBrush, &sipCpp, sipType_wxBrush, &other))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxBrush__copyFrom(sipCpp, other);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Brush, sipName__copyFrom, NULL);

    return NULL;
}


extern "C" {static int slot_wxBrush___nonzero__(PyObject *);}
static int slot_wxBrush___nonzero__(PyObject *sipSelf)
{
     ::wxBrush *sipCpp = reinterpret_cast< ::wxBrush *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxBrush));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxBrush___nonzero__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return -1;

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_wxBrush___eq__(PyObject *,PyObject *);}
static PyObject *slot_wxBrush___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxBrush *sipCpp = reinterpret_cast< ::wxBrush *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxBrush));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxBrush* brush;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxBrush, &brush))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxBrush::operator==(*brush);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, eq_slot, sipType_wxBrush, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxBrush___ne__(PyObject *,PyObject *);}
static PyObject *slot_wxBrush___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxBrush *sipCpp = reinterpret_cast< ::wxBrush *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxBrush));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxBrush* brush;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxBrush, &brush))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxBrush::operator!=(*brush);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, ne_slot, sipType_wxBrush, sipSelf, sipArg);
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxBrush(void *, const sipTypeDef *);}
static void *cast_wxBrush(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxBrush *sipCpp = reinterpret_cast< ::wxBrush *>(sipCppV);

    if (targetType == sipType_wxGDIObject)
        return static_cast< ::wxGDIObject *>(sipCpp);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxBrush(void *, int);}
static void release_wxBrush(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxBrush *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxBrush(void *, SIP_SSIZE_T, const void *);}
static void assign_wxBrush(void *sipDst, SIP_SSIZE_T sipDstIdx, const void *sipSrc)
{
    reinterpret_cast< ::wxBrush *>(sipDst)[sipDstIdx] = *reinterpret_cast<const  ::wxBrush *>(sipSrc);
}


extern "C" {static void *array_wxBrush(SIP_SSIZE_T);}
static void *array_wxBrush(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxBrush[sipNrElem];
}


extern "C" {static void *copy_wxBrush(const void *, SIP_SSIZE_T);}
static void *copy_wxBrush(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxBrush(reinterpret_cast<const  ::wxBrush *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxBrush(sipSimpleWrapper *);}
static void dealloc_wxBrush(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxBrush(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxBrush(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxBrush(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxBrush *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxBrush();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxColour* colour;
        int colourState = 0;
         ::wxBrushStyle style = wxBRUSHSTYLE_SOLID;

        static const char *sipKwdList[] = {
            sipName_colour,
            sipName_style,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1|E", sipType_wxColour, &colour, &colourState, sipType_wxBrushStyle, &style))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxBrush(*colour,style);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour),sipType_wxColour,colourState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxBitmap* stippleBitmap;

        static const char *sipKwdList[] = {
            sipName_stippleBitmap,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxBitmap, &stippleBitmap))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxBrush(*stippleBitmap);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxBrush* brush;

        static const char *sipKwdList[] = {
            sipName_brush,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxBrush, &brush))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxBrush(*brush);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxBrush[] = {{199, 255, 1}};


/* Define this type's Python slots. */
static sipPySlotDef slots_wxBrush[] = {
    {(void *)slot_wxBrush___nonzero__, bool_slot},
    {(void *)slot_wxBrush___eq__, eq_slot},
    {(void *)slot_wxBrush___ne__, ne_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxBrush[] = {
    {SIP_MLNAME_CAST(sipName_GetColour), meth_wxBrush_GetColour, METH_VARARGS, SIP_MLDOC_CAST(doc_wxBrush_GetColour)},
    {SIP_MLNAME_CAST(sipName_GetStipple), meth_wxBrush_GetStipple, METH_VARARGS, SIP_MLDOC_CAST(doc_wxBrush_GetStipple)},
    {SIP_MLNAME_CAST(sipName_GetStyle), meth_wxBrush_GetStyle, METH_VARARGS, SIP_MLDOC_CAST(doc_wxBrush_GetStyle)},
    {SIP_MLNAME_CAST(sipName_IsHatch), meth_wxBrush_IsHatch, METH_VARARGS, SIP_MLDOC_CAST(doc_wxBrush_IsHatch)},
    {SIP_MLNAME_CAST(sipName_IsNonTransparent), meth_wxBrush_IsNonTransparent, METH_VARARGS, SIP_MLDOC_CAST(doc_wxBrush_IsNonTransparent)},
    {SIP_MLNAME_CAST(sipName_IsOk), meth_wxBrush_IsOk, METH_VARARGS, SIP_MLDOC_CAST(doc_wxBrush_IsOk)},
    {SIP_MLNAME_CAST(sipName_IsTransparent), meth_wxBrush_IsTransparent, METH_VARARGS, SIP_MLDOC_CAST(doc_wxBrush_IsTransparent)},
    {SIP_MLNAME_CAST(sipName_MacSetTheme), (PyCFunction)meth_wxBrush_MacSetTheme, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxBrush_MacSetTheme)},
    {SIP_MLNAME_CAST(sipName_SetColour), (PyCFunction)meth_wxBrush_SetColour, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxBrush_SetColour)},
    {SIP_MLNAME_CAST(sipName_SetStipple), (PyCFunction)meth_wxBrush_SetStipple, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxBrush_SetStipple)},
    {SIP_MLNAME_CAST(sipName_SetStyle), (PyCFunction)meth_wxBrush_SetStyle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxBrush_SetStyle)},
    {SIP_MLNAME_CAST(sipName__copyFrom), (PyCFunction)meth_wxBrush__copyFrom, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxBrush__copyFrom)}
};

sipVariableDef variables_wxBrush[] = {
    {PropertyVariable, sipName_Style, &methods_wxBrush[2], &methods_wxBrush[10], NULL, NULL},
    {PropertyVariable, sipName_Stipple, &methods_wxBrush[1], &methods_wxBrush[9], NULL, NULL},
    {PropertyVariable, sipName_Colour, &methods_wxBrush[0], &methods_wxBrush[8], NULL, NULL},
};

PyDoc_STRVAR(doc_wxBrush, "Brush()\n"
    "Brush(colour, style=BRUSHSTYLE_SOLID)\n"
    "Brush(stippleBitmap)\n"
    "Brush(brush)\n"
    "\n"
    "A brush is a drawing tool for filling in areas.");


sipClassTypeDef sipTypeDef__core_wxBrush = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxBrush,
        {0},
        0
    },
    {
        sipNameNr_Brush,
        {0, 0, 1},
        12, methods_wxBrush,
        0, 0,
        3, variables_wxBrush,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxBrush,
    -1,
    -1,
    supers_wxBrush,
    slots_wxBrush,
    init_type_wxBrush,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxBrush,
    assign_wxBrush,
    array_wxBrush,
    copy_wxBrush,
    release_wxBrush,
    cast_wxBrush,
    0,
    0,
    0,
    0,
    0,
    0
};
