/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.1
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/filesys.h>

        #include <wx/stream.h>
        #include <wx/datetime.h>
        #include <datetime.h>
        #include <wx/object.h>
        #include <wx/object.h>


PyDoc_STRVAR(doc_wxFSFile_DetachStream, "DetachStream() -> InputStream\n"
    "\n"
    "Detaches the stream from the wxFSFile object.");

extern "C" {static PyObject *meth_wxFSFile_DetachStream(PyObject *, PyObject *);}
static PyObject *meth_wxFSFile_DetachStream(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxFSFile *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFSFile, &sipCpp))
        {
             ::wxInputStream*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->DetachStream();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxInputStream,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FSFile, sipName_DetachStream, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFSFile_GetAnchor, "GetAnchor() -> String\n"
    "\n"
    "Returns anchor (if present).");

extern "C" {static PyObject *meth_wxFSFile_GetAnchor(PyObject *, PyObject *);}
static PyObject *meth_wxFSFile_GetAnchor(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFSFile *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFSFile, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetAnchor());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FSFile, sipName_GetAnchor, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFSFile_GetLocation, "GetLocation() -> String\n"
    "\n"
    "Returns full location of the file, including path and protocol.");

extern "C" {static PyObject *meth_wxFSFile_GetLocation(PyObject *, PyObject *);}
static PyObject *meth_wxFSFile_GetLocation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFSFile *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFSFile, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetLocation());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FSFile, sipName_GetLocation, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFSFile_GetMimeType, "GetMimeType() -> String\n"
    "\n"
    "Returns the MIME type of the content of this file.");

extern "C" {static PyObject *meth_wxFSFile_GetMimeType(PyObject *, PyObject *);}
static PyObject *meth_wxFSFile_GetMimeType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFSFile *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFSFile, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetMimeType());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FSFile, sipName_GetMimeType, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFSFile_GetModificationTime, "GetModificationTime() -> DateTime\n"
    "\n"
    "Returns time when this file was modified.");

extern "C" {static PyObject *meth_wxFSFile_GetModificationTime(PyObject *, PyObject *);}
static PyObject *meth_wxFSFile_GetModificationTime(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFSFile *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFSFile, &sipCpp))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateTime(sipCpp->GetModificationTime());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FSFile, sipName_GetModificationTime, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFSFile_GetStream, "GetStream() -> InputStream\n"
    "\n"
    "Returns pointer to the stream.");

extern "C" {static PyObject *meth_wxFSFile_GetStream(PyObject *, PyObject *);}
static PyObject *meth_wxFSFile_GetStream(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFSFile *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFSFile, &sipCpp))
        {
             ::wxInputStream*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetStream();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxInputStream,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FSFile, sipName_GetStream, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxFSFile(void *, const sipTypeDef *);}
static void *cast_wxFSFile(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxFSFile *sipCpp = reinterpret_cast< ::wxFSFile *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxFSFile(void *, int);}
static void release_wxFSFile(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxFSFile *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxFSFile(sipSimpleWrapper *);}
static void dealloc_wxFSFile(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxFSFile(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxFSFile(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxFSFile(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxFSFile *sipCpp = 0;

    {
         ::wxInputStream* stream;
        int streamState = 0;
        const  ::wxString* location;
        int locationState = 0;
        const  ::wxString* mimetype;
        int mimetypeState = 0;
        const  ::wxString* anchor;
        int anchorState = 0;
         ::wxDateTime* modif;
        int modifState = 0;

        static const char *sipKwdList[] = {
            sipName_stream,
            sipName_location,
            sipName_mimetype,
            sipName_anchor,
            sipName_modif,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J0J1J1J1J1", sipType_wxInputStream, &stream, &streamState, sipType_wxString,&location, &locationState, sipType_wxString,&mimetype, &mimetypeState, sipType_wxString,&anchor, &anchorState, sipType_wxDateTime, &modif, &modifState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxFSFile(stream,*location,*mimetype,*anchor,*modif);
            Py_END_ALLOW_THREADS
            sipReleaseType(stream,sipType_wxInputStream,streamState);
            sipReleaseType(const_cast< ::wxString *>(location),sipType_wxString,locationState);
            sipReleaseType(const_cast< ::wxString *>(mimetype),sipType_wxString,mimetypeState);
            sipReleaseType(const_cast< ::wxString *>(anchor),sipType_wxString,anchorState);
            sipReleaseType(modif,sipType_wxDateTime,modifState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxFSFile[] = {{345, 255, 1}};


static PyMethodDef methods_wxFSFile[] = {
    {SIP_MLNAME_CAST(sipName_DetachStream), meth_wxFSFile_DetachStream, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFSFile_DetachStream)},
    {SIP_MLNAME_CAST(sipName_GetAnchor), meth_wxFSFile_GetAnchor, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFSFile_GetAnchor)},
    {SIP_MLNAME_CAST(sipName_GetLocation), meth_wxFSFile_GetLocation, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFSFile_GetLocation)},
    {SIP_MLNAME_CAST(sipName_GetMimeType), meth_wxFSFile_GetMimeType, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFSFile_GetMimeType)},
    {SIP_MLNAME_CAST(sipName_GetModificationTime), meth_wxFSFile_GetModificationTime, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFSFile_GetModificationTime)},
    {SIP_MLNAME_CAST(sipName_GetStream), meth_wxFSFile_GetStream, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFSFile_GetStream)}
};

sipVariableDef variables_wxFSFile[] = {
    {PropertyVariable, sipName_Stream, &methods_wxFSFile[5], NULL, NULL, NULL},
    {PropertyVariable, sipName_ModificationTime, &methods_wxFSFile[4], NULL, NULL, NULL},
    {PropertyVariable, sipName_MimeType, &methods_wxFSFile[3], NULL, NULL, NULL},
    {PropertyVariable, sipName_Location, &methods_wxFSFile[2], NULL, NULL, NULL},
    {PropertyVariable, sipName_Anchor, &methods_wxFSFile[1], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxFSFile, "FSFile(stream, location, mimetype, anchor, modif)\n"
    "\n"
    "This class represents a single file opened by wxFileSystem.");


sipClassTypeDef sipTypeDef__core_wxFSFile = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxFSFile,
        {0},
        0
    },
    {
        sipNameNr_FSFile,
        {0, 0, 1},
        6, methods_wxFSFile,
        0, 0,
        5, variables_wxFSFile,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxFSFile,
    -1,
    -1,
    supers_wxFSFile,
    0,
    init_type_wxFSFile,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxFSFile,
    0,
    0,
    0,
    release_wxFSFile,
    cast_wxFSFile,
    0,
    0,
    0,
    0,
    0,
    0
};
