/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.1
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/filesys.h>

        #include <wx/filesys.h>
        #include <wx/filesys.h>
        #include <wx/object.h>
        #include <wx/object.h>


PyDoc_STRVAR(doc_wxFileSystem_ChangePathTo, "ChangePathTo(location, is_dir=False)\n"
    "\n"
    "Sets the current location.");

extern "C" {static PyObject *meth_wxFileSystem_ChangePathTo(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileSystem_ChangePathTo(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* location;
        int locationState = 0;
        bool is_dir = 0;
         ::wxFileSystem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_location,
            sipName_is_dir,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|b", &sipSelf, sipType_wxFileSystem, &sipCpp, sipType_wxString,&location, &locationState, &is_dir))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->ChangePathTo(*location,is_dir);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(location),sipType_wxString,locationState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystem, sipName_ChangePathTo, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystem_FindFileInPath, "FindFileInPath(pStr, path, file) -> bool\n"
    "\n"
    "Looks for the file with the given name file in a colon or semi-colon\n"
    "(depending on the current platform) separated list of directories in\n"
    "path.");

extern "C" {static PyObject *meth_wxFileSystem_FindFileInPath(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileSystem_FindFileInPath(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxString* pStr;
        int pStrState = 0;
        const  ::wxString* path;
        int pathState = 0;
        const  ::wxString* file;
        int fileState = 0;
         ::wxFileSystem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pStr,
            sipName_path,
            sipName_file,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ0J1J1", &sipSelf, sipType_wxFileSystem, &sipCpp, sipType_wxString,&pStr, &pStrState, sipType_wxString,&path, &pathState, sipType_wxString,&file, &fileState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->FindFileInPath(pStr,*path,*file);
            Py_END_ALLOW_THREADS
            sipReleaseType(pStr,sipType_wxString,pStrState);
            sipReleaseType(const_cast< ::wxString *>(path),sipType_wxString,pathState);
            sipReleaseType(const_cast< ::wxString *>(file),sipType_wxString,fileState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystem, sipName_FindFileInPath, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystem_FindFirst, "FindFirst(wildcard, flags=0) -> String\n"
    "\n"
    "Works like wxFindFirstFile().");

extern "C" {static PyObject *meth_wxFileSystem_FindFirst(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileSystem_FindFirst(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* wildcard;
        int wildcardState = 0;
        int flags = 0;
         ::wxFileSystem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_wildcard,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|i", &sipSelf, sipType_wxFileSystem, &sipCpp, sipType_wxString,&wildcard, &wildcardState, &flags))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->FindFirst(*wildcard,flags));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(wildcard),sipType_wxString,wildcardState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystem, sipName_FindFirst, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystem_FindNext, "FindNext() -> String\n"
    "\n"
    "Returns the next filename that matches the parameters passed to\n"
    "FindFirst().");

extern "C" {static PyObject *meth_wxFileSystem_FindNext(PyObject *, PyObject *);}
static PyObject *meth_wxFileSystem_FindNext(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxFileSystem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFileSystem, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->FindNext());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystem, sipName_FindNext, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystem_GetPath, "GetPath() -> String\n"
    "\n"
    "Returns the actual path (set by wxFileSystem::ChangePathTo).");

extern "C" {static PyObject *meth_wxFileSystem_GetPath(PyObject *, PyObject *);}
static PyObject *meth_wxFileSystem_GetPath(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFileSystem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFileSystem, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetPath());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystem, sipName_GetPath, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystem_OpenFile, "OpenFile(location, flags=FS_READ) -> FSFile\n"
    "\n"
    "Opens the file and returns a pointer to a wxFSFile object or NULL if\n"
    "failed.");

extern "C" {static PyObject *meth_wxFileSystem_OpenFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileSystem_OpenFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* location;
        int locationState = 0;
        int flags = wxFS_READ;
         ::wxFileSystem *sipCpp;

        static const char *sipKwdList[] = {
            sipName_location,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|i", &sipSelf, sipType_wxFileSystem, &sipCpp, sipType_wxString,&location, &locationState, &flags))
        {
             ::wxFSFile*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->OpenFile(*location,flags);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(location),sipType_wxString,locationState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFSFile,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystem, sipName_OpenFile, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystem_AddHandler, "AddHandler(handler)\n"
    "\n"
    "This static function adds new handler into the list of handlers (see\n"
    "wxFileSystemHandler) which provide access to virtual FS.");

extern "C" {static PyObject *meth_wxFileSystem_AddHandler(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileSystem_AddHandler(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxFileSystemHandler* handler;

        static const char *sipKwdList[] = {
            sipName_handler,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J:", sipType_wxFileSystemHandler, &handler))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxFileSystem::AddHandler(handler);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystem, sipName_AddHandler, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystem_RemoveHandler, "RemoveHandler(handler) -> FileSystemHandler\n"
    "\n"
    "Remove a filesystem handler from the list of handlers.");

extern "C" {static PyObject *meth_wxFileSystem_RemoveHandler(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileSystem_RemoveHandler(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxFileSystemHandler* handler;

        static const char *sipKwdList[] = {
            sipName_handler,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J8", sipType_wxFileSystemHandler, &handler))
        {
             ::wxFileSystemHandler*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxFileSystem::RemoveHandler(handler);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFileSystemHandler,Py_None);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystem, sipName_RemoveHandler, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystem_FileNameToURL, "FileNameToURL(filename) -> String\n"
    "\n"
    "Converts a wxFileName into an URL.");

extern "C" {static PyObject *meth_wxFileSystem_FileNameToURL(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileSystem_FileNameToURL(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFileName* filename;
        int filenameState = 0;

        static const char *sipKwdList[] = {
            sipName_filename,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxFileName,&filename, &filenameState))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString( ::wxFileSystem::FileNameToURL(*filename));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxFileName *>(filename),sipType_wxFileName,filenameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystem, sipName_FileNameToURL, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystem_HasHandlerForPath, "HasHandlerForPath(location) -> bool\n"
    "\n"
    "This static function returns true if there is a registered handler\n"
    "which can open the given location.");

extern "C" {static PyObject *meth_wxFileSystem_HasHandlerForPath(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileSystem_HasHandlerForPath(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* location;
        int locationState = 0;

        static const char *sipKwdList[] = {
            sipName_location,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&location, &locationState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxFileSystem::HasHandlerForPath(*location);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(location),sipType_wxString,locationState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystem, sipName_HasHandlerForPath, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystem_URLToFileName, "URLToFileName(url) -> FileName\n"
    "\n"
    "Converts URL into a well-formed filename.");

extern "C" {static PyObject *meth_wxFileSystem_URLToFileName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileSystem_URLToFileName(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* url;
        int urlState = 0;

        static const char *sipKwdList[] = {
            sipName_url,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&url, &urlState))
        {
             ::wxFileName*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxFileName( ::wxFileSystem::URLToFileName(*url));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(url),sipType_wxString,urlState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFileName,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystem, sipName_URLToFileName, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxFileSystem(void *, const sipTypeDef *);}
static void *cast_wxFileSystem(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxFileSystem *sipCpp = reinterpret_cast< ::wxFileSystem *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxFileSystem(void *, int);}
static void release_wxFileSystem(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxFileSystem *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxFileSystem(sipSimpleWrapper *);}
static void dealloc_wxFileSystem(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxFileSystem(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxFileSystem(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxFileSystem(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxFileSystem *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxFileSystem();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxFileSystem[] = {{345, 255, 1}};


static PyMethodDef methods_wxFileSystem[] = {
    {SIP_MLNAME_CAST(sipName_AddHandler), (PyCFunction)meth_wxFileSystem_AddHandler, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileSystem_AddHandler)},
    {SIP_MLNAME_CAST(sipName_ChangePathTo), (PyCFunction)meth_wxFileSystem_ChangePathTo, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileSystem_ChangePathTo)},
    {SIP_MLNAME_CAST(sipName_FileNameToURL), (PyCFunction)meth_wxFileSystem_FileNameToURL, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileSystem_FileNameToURL)},
    {SIP_MLNAME_CAST(sipName_FindFileInPath), (PyCFunction)meth_wxFileSystem_FindFileInPath, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileSystem_FindFileInPath)},
    {SIP_MLNAME_CAST(sipName_FindFirst), (PyCFunction)meth_wxFileSystem_FindFirst, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileSystem_FindFirst)},
    {SIP_MLNAME_CAST(sipName_FindNext), meth_wxFileSystem_FindNext, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFileSystem_FindNext)},
    {SIP_MLNAME_CAST(sipName_GetPath), meth_wxFileSystem_GetPath, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFileSystem_GetPath)},
    {SIP_MLNAME_CAST(sipName_HasHandlerForPath), (PyCFunction)meth_wxFileSystem_HasHandlerForPath, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileSystem_HasHandlerForPath)},
    {SIP_MLNAME_CAST(sipName_OpenFile), (PyCFunction)meth_wxFileSystem_OpenFile, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileSystem_OpenFile)},
    {SIP_MLNAME_CAST(sipName_RemoveHandler), (PyCFunction)meth_wxFileSystem_RemoveHandler, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileSystem_RemoveHandler)},
    {SIP_MLNAME_CAST(sipName_URLToFileName), (PyCFunction)meth_wxFileSystem_URLToFileName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileSystem_URLToFileName)}
};

sipVariableDef variables_wxFileSystem[] = {
    {PropertyVariable, sipName_Path, &methods_wxFileSystem[6], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxFileSystem, "FileSystem()\n"
    "\n"
    "This class provides an interface for opening files on different file\n"
    "systems.");


sipClassTypeDef sipTypeDef__core_wxFileSystem = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxFileSystem,
        {0},
        0
    },
    {
        sipNameNr_FileSystem,
        {0, 0, 1},
        11, methods_wxFileSystem,
        0, 0,
        1, variables_wxFileSystem,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxFileSystem,
    -1,
    -1,
    supers_wxFileSystem,
    0,
    init_type_wxFileSystem,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxFileSystem,
    0,
    0,
    0,
    release_wxFileSystem,
    cast_wxFileSystem,
    0,
    0,
    0,
    0,
    0,
    0
};
