/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.1
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/graphics.h>

        #include <wx/graphics.h>
        #include <wx/graphics.h>
        #include <wx/pen.h>
        #include "arrayholder.h"
        #include <wx/graphics.h>
        #include <wx/font.h>
        #include <wx/colour.h>
        #include <wx/graphics.h>
        #include <wx/brush.h>
        #include <wx/graphics.h>
        #include <wx/icon.h>
        #include <wx/affinematrix2dbase.h>
        #include <wx/graphics.h>
        #include <wx/image.h>
        #include <wx/bitmap.h>
        #include <wx/region.h>
        #include <wx/window.h>
        #include <wx/dcclient.h>
        #include <wx/dcmemory.h>
        #include <wx/dcprint.h>
        #include <wx/graphics.h>
        #include <wx/graphics.h>
        #include <wx/object.h>
        #include <wx/object.h>
        // Convert a Python sequence of wxPoint2D objects, or items that can be converted
        // to wxPoint2D into a C array of wxPoint2D instances.
        static
        wxPoint2D* wxPoint2D_array_helper(PyObject* source, size_t *count)
        {
            wxPoint2D* array;
            Py_ssize_t idx, len;
            wxPyThreadBlocker blocker;
        
            // ensure that it is a sequence
            if (! PySequence_Check(source))
                goto error0;
            // ensure it is not a string or unicode object (they are sequences too)
            else if (PyBytes_Check(source) || PyUnicode_Check(source))
                goto error0;
            // ensure each item can be converted to wxPoint2D
            else {
                len = PySequence_Length(source);
                for (idx=0; idx<len; idx++) {
                    PyObject* item = PySequence_ITEM(source, idx);
                    if (!sipCanConvertToType(item, sipType_wxPoint2DDouble, SIP_NOT_NONE)) {
                        Py_DECREF(item);
                        goto error0;
                    }
                    Py_DECREF(item);
                }
            }
        
            // The length of the sequence is returned in count.
            *count = len;
            array = new wxPoint2D[*count];
            if (!array) {
                PyErr_SetString(PyExc_MemoryError, "Unable to allocate temporary array");
                return NULL;
            }
            for (idx=0; idx<len; idx++) {
                PyObject* obj = PySequence_ITEM(source, idx);
                int state = 0;
                int err = 0;
                wxPoint2D* item = reinterpret_cast<wxPoint2D*>(
                                sipConvertToType(obj, sipType_wxPoint2DDouble, NULL, 0, &state, &err));
                array[idx] = *item;
                sipReleaseType((void*)item, sipType_wxPoint2DDouble, state); // delete temporary instances
                Py_DECREF(obj);
            }
            return array;
        
        error0:
            PyErr_SetString(PyExc_TypeError, "Expected a sequence of length-2 sequences or wx.Point2D objects.");
            return NULL;
        }
    void _wxGraphicsContext_DrawLines(wxGraphicsContext* self, PyObject* points, wxPolygonFillMode fillStyle)
    {
        size_t count;
        wxPoint2D* ptsArray = wxPoint2D_array_helper(points, &count);
        
        if ( ptsArray != NULL ) {
            self->DrawLines(count, ptsArray, fillStyle);
            delete [] ptsArray;
        }
    }
    wxArrayDouble* _wxGraphicsContext_GetPartialTextExtents(const wxGraphicsContext* self, const wxString *text)
    {
        wxArrayDouble rval;
        self->GetPartialTextExtents(*text, rval);
        return new wxArrayDouble(rval);
    }
    PyObject* _wxGraphicsContext_GetTextExtent(wxGraphicsContext* self, const wxString* text)
    {
        wxDouble width = 0.0, height = 0.0;
        self->GetTextExtent(*text, &width, &height, NULL, NULL);
        return sipBuildResult(0, "(dd)", width, height);
    }
    void _wxGraphicsContext_StrokeLines(wxGraphicsContext* self, PyObject* points)
    {
        size_t count;
        wxPoint2D* ptsArray = wxPoint2D_array_helper(points, &count);
        
        if ( ptsArray != NULL ) {
            self->StrokeLines(count, ptsArray);
            delete [] ptsArray;
        }
    }
    void _wxGraphicsContext_StrokeLineSegments(wxGraphicsContext* self, PyObject* beginPoints, PyObject* endPoints)
    {
        size_t c1, c2, count;
        wxPoint2D* beginP = wxPoint2D_array_helper(beginPoints, &c1);
        wxPoint2D* endP =   wxPoint2D_array_helper(endPoints, &c2);
        
        if ( beginP != NULL && endP != NULL ) {
            count = wxMin(c1, c2);
            self->StrokeLines(count, beginP, endP);
        }
        delete [] beginP;
        delete [] endP;
    }


PyDoc_STRVAR(doc_wxGraphicsContext_CreateLinearGradientBrush, "CreateLinearGradientBrush(x1, y1, x2, y2, c1, c2) -> GraphicsBrush\n"
    "CreateLinearGradientBrush(x1, y1, x2, y2, stops) -> GraphicsBrush\n"
    "\n"
    "Creates a native brush with a linear gradient.");

extern "C" {static PyObject *meth_wxGraphicsContext_CreateLinearGradientBrush(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_CreateLinearGradientBrush(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDouble x1;
         ::wxDouble y1;
         ::wxDouble x2;
         ::wxDouble y2;
        const  ::wxColour* c1;
        int c1State = 0;
        const  ::wxColour* c2;
        int c2State = 0;
        const  ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x1,
            sipName_y1,
            sipName_x2,
            sipName_y2,
            sipName_c1,
            sipName_c2,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BddddJ1J1", &sipSelf, sipType_wxGraphicsContext, &sipCpp, &x1, &y1, &x2, &y2, sipType_wxColour, &c1, &c1State, sipType_wxColour, &c2, &c2State))
        {
             ::wxGraphicsBrush*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxGraphicsBrush(sipCpp->CreateLinearGradientBrush(x1,y1,x2,y2,*c1,*c2));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(c1),sipType_wxColour,c1State);
            sipReleaseType(const_cast< ::wxColour *>(c2),sipType_wxColour,c2State);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxGraphicsBrush,NULL);
        }
    }

    {
         ::wxDouble x1;
         ::wxDouble y1;
         ::wxDouble x2;
         ::wxDouble y2;
        const  ::wxGraphicsGradientStops* stops;
        const  ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x1,
            sipName_y1,
            sipName_x2,
            sipName_y2,
            sipName_stops,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BddddJ9", &sipSelf, sipType_wxGraphicsContext, &sipCpp, &x1, &y1, &x2, &y2, sipType_wxGraphicsGradientStops, &stops))
        {
             ::wxGraphicsBrush*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxGraphicsBrush(sipCpp->CreateLinearGradientBrush(x1,y1,x2,y2,*stops));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxGraphicsBrush,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_CreateLinearGradientBrush, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_CreateRadialGradientBrush, "CreateRadialGradientBrush(xo, yo, xc, yc, radius, oColor, cColor) -> GraphicsBrush\n"
    "CreateRadialGradientBrush(xo, yo, xc, yc, radius, stops) -> GraphicsBrush\n"
    "\n"
    "Creates a native brush with a radial gradient.");

extern "C" {static PyObject *meth_wxGraphicsContext_CreateRadialGradientBrush(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_CreateRadialGradientBrush(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDouble xo;
         ::wxDouble yo;
         ::wxDouble xc;
         ::wxDouble yc;
         ::wxDouble radius;
        const  ::wxColour* oColor;
        int oColorState = 0;
        const  ::wxColour* cColor;
        int cColorState = 0;
        const  ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_xo,
            sipName_yo,
            sipName_xc,
            sipName_yc,
            sipName_radius,
            sipName_oColor,
            sipName_cColor,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BdddddJ1J1", &sipSelf, sipType_wxGraphicsContext, &sipCpp, &xo, &yo, &xc, &yc, &radius, sipType_wxColour, &oColor, &oColorState, sipType_wxColour, &cColor, &cColorState))
        {
             ::wxGraphicsBrush*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxGraphicsBrush(sipCpp->CreateRadialGradientBrush(xo,yo,xc,yc,radius,*oColor,*cColor));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(oColor),sipType_wxColour,oColorState);
            sipReleaseType(const_cast< ::wxColour *>(cColor),sipType_wxColour,cColorState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxGraphicsBrush,NULL);
        }
    }

    {
         ::wxDouble xo;
         ::wxDouble yo;
         ::wxDouble xc;
         ::wxDouble yc;
         ::wxDouble radius;
        const  ::wxGraphicsGradientStops* stops;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_xo,
            sipName_yo,
            sipName_xc,
            sipName_yc,
            sipName_radius,
            sipName_stops,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BdddddJ9", &sipSelf, sipType_wxGraphicsContext, &sipCpp, &xo, &yo, &xc, &yc, &radius, sipType_wxGraphicsGradientStops, &stops))
        {
             ::wxGraphicsBrush*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxGraphicsBrush(sipCpp->CreateRadialGradientBrush(xo,yo,xc,yc,radius,*stops));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxGraphicsBrush,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_CreateRadialGradientBrush, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_DrawBitmap, "DrawBitmap(bmp, x, y, w, h)\n"
    "DrawBitmap(bmp, x, y, w, h)\n"
    "\n"
    "Draws the bitmap.");

extern "C" {static PyObject *meth_wxGraphicsContext_DrawBitmap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_DrawBitmap(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxGraphicsBitmap* bmp;
         ::wxDouble x;
         ::wxDouble y;
         ::wxDouble w;
         ::wxDouble h;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bmp,
            sipName_x,
            sipName_y,
            sipName_w,
            sipName_h,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9dddd", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxGraphicsBitmap, &bmp, &x, &y, &w, &h))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawBitmap(*bmp,x,y,w,h);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxBitmap* bmp;
         ::wxDouble x;
         ::wxDouble y;
         ::wxDouble w;
         ::wxDouble h;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bmp,
            sipName_x,
            sipName_y,
            sipName_w,
            sipName_h,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9dddd", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxBitmap, &bmp, &x, &y, &w, &h))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawBitmap(*bmp,x,y,w,h);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_DrawBitmap, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_Create, "Create(window) -> GraphicsContext\n"
    "Create(windowDC) -> GraphicsContext\n"
    "Create(memoryDC) -> GraphicsContext\n"
    "Create(printerDC) -> GraphicsContext\n"
    "Create(image) -> GraphicsContext\n"
    "Create() -> GraphicsContext\n"
    "\n"
    "Creates a wxGraphicsContext from a wxWindow.");

extern "C" {static PyObject *meth_wxGraphicsContext_Create(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_Create(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxWindow* window;

        static const char *sipKwdList[] = {
            sipName_window,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J8", sipType_wxWindow, &window))
        {
             ::wxGraphicsContext*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxGraphicsContext::Create(window);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxGraphicsContext,NULL);
        }
    }

    {
        const  ::wxWindowDC* windowDC;
        PyObject *windowDCKeep;

        static const char *sipKwdList[] = {
            sipName_windowDC,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "@J9", &windowDCKeep, sipType_wxWindowDC, &windowDC))
        {
             ::wxGraphicsContext*sipRes;
            PyObject *sipResObj;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxGraphicsContext::Create(*windowDC);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            sipResObj = sipConvertFromNewType(sipRes,sipType_wxGraphicsContext,NULL);

            sipKeepReference(sipResObj, -11, windowDCKeep);

            return sipResObj;
        }
    }

    {
        const  ::wxMemoryDC* memoryDC;
        PyObject *memoryDCKeep;

        static const char *sipKwdList[] = {
            sipName_memoryDC,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "@J9", &memoryDCKeep, sipType_wxMemoryDC, &memoryDC))
        {
             ::wxGraphicsContext*sipRes;
            PyObject *sipResObj;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxGraphicsContext::Create(*memoryDC);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            sipResObj = sipConvertFromNewType(sipRes,sipType_wxGraphicsContext,NULL);

            sipKeepReference(sipResObj, -12, memoryDCKeep);

            return sipResObj;
        }
    }

    {
        const  ::wxPrinterDC* printerDC;
        PyObject *printerDCKeep;

        static const char *sipKwdList[] = {
            sipName_printerDC,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "@J9", &printerDCKeep, sipType_wxPrinterDC, &printerDC))
        {
             ::wxGraphicsContext*sipRes;
            PyObject *sipResObj;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxGraphicsContext::Create(*printerDC);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            sipResObj = sipConvertFromNewType(sipRes,sipType_wxGraphicsContext,NULL);

            sipKeepReference(sipResObj, -13, printerDCKeep);

            return sipResObj;
        }
    }

    {
         ::wxImage* image;
        PyObject *imageKeep;

        static const char *sipKwdList[] = {
            sipName_image,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "@J9", &imageKeep, sipType_wxImage, &image))
        {
             ::wxGraphicsContext*sipRes;
            PyObject *sipResObj;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxGraphicsContext::Create(*image);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            sipResObj = sipConvertFromNewType(sipRes,sipType_wxGraphicsContext,NULL);

            sipKeepReference(sipResObj, -14, imageKeep);

            return sipResObj;
        }
    }

    {
        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, ""))
        {
             ::wxGraphicsContext*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxGraphicsContext::Create();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxGraphicsContext,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_Create, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_CreateFromNative, "CreateFromNative(context) -> GraphicsContext\n"
    "\n"
    "Creates a wxGraphicsContext from a native context.");

extern "C" {static PyObject *meth_wxGraphicsContext_CreateFromNative(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_CreateFromNative(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        void* context;

        static const char *sipKwdList[] = {
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "v", &context))
        {
             ::wxGraphicsContext*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxGraphicsContext::CreateFromNative(context);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxGraphicsContext,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_CreateFromNative, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_CreateFromNativeWindow, "CreateFromNativeWindow(window) -> GraphicsContext\n"
    "\n"
    "Creates a wxGraphicsContext from a native window.");

extern "C" {static PyObject *meth_wxGraphicsContext_CreateFromNativeWindow(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_CreateFromNativeWindow(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        void* window;

        static const char *sipKwdList[] = {
            sipName_window,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "v", &window))
        {
             ::wxGraphicsContext*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxGraphicsContext::CreateFromNativeWindow(window);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxGraphicsContext,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_CreateFromNativeWindow, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_Clip, "Clip(region)\n"
    "Clip(x, y, w, h)\n"
    "\n"
    "Clips drawings to the specified region.");

extern "C" {static PyObject *meth_wxGraphicsContext_Clip(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_Clip(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRegion* region;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_region,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxRegion, &region))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Clip(*region);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
         ::wxDouble x;
         ::wxDouble y;
         ::wxDouble w;
         ::wxDouble h;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_w,
            sipName_h,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bdddd", &sipSelf, sipType_wxGraphicsContext, &sipCpp, &x, &y, &w, &h))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Clip(x,y,w,h);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_Clip, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_ConcatTransform, "ConcatTransform(matrix)\n"
    "\n"
    "Concatenates the passed in transform with the current transform of\n"
    "this context.");

extern "C" {static PyObject *meth_wxGraphicsContext_ConcatTransform(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_ConcatTransform(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxGraphicsMatrix* matrix;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_matrix,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxGraphicsMatrix, &matrix))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->ConcatTransform(*matrix);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_ConcatTransform, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_CreateBitmap, "CreateBitmap(bitmap) -> GraphicsBitmap\n"
    "\n"
    "Creates wxGraphicsBitmap from an existing wxBitmap.");

extern "C" {static PyObject *meth_wxGraphicsContext_CreateBitmap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_CreateBitmap(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxBitmap* bitmap;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bitmap,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxBitmap, &bitmap))
        {
             ::wxGraphicsBitmap*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxGraphicsBitmap(sipCpp->CreateBitmap(*bitmap));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxGraphicsBitmap,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_CreateBitmap, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_CreateBitmapFromImage, "CreateBitmapFromImage(image) -> GraphicsBitmap\n"
    "\n"
    "Creates wxGraphicsBitmap from an existing wxImage.");

extern "C" {static PyObject *meth_wxGraphicsContext_CreateBitmapFromImage(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_CreateBitmapFromImage(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxImage* image;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_image,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxImage, &image))
        {
             ::wxGraphicsBitmap*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxGraphicsBitmap(sipCpp->CreateBitmapFromImage(*image));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxGraphicsBitmap,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_CreateBitmapFromImage, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_CreateSubBitmap, "CreateSubBitmap(bitmap, x, y, w, h) -> GraphicsBitmap\n"
    "\n"
    "Extracts a sub-bitmap from an existing bitmap.");

extern "C" {static PyObject *meth_wxGraphicsContext_CreateSubBitmap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_CreateSubBitmap(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxGraphicsBitmap* bitmap;
         ::wxDouble x;
         ::wxDouble y;
         ::wxDouble w;
         ::wxDouble h;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bitmap,
            sipName_x,
            sipName_y,
            sipName_w,
            sipName_h,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9dddd", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxGraphicsBitmap, &bitmap, &x, &y, &w, &h))
        {
             ::wxGraphicsBitmap*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxGraphicsBitmap(sipCpp->CreateSubBitmap(*bitmap,x,y,w,h));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxGraphicsBitmap,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_CreateSubBitmap, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_CreateBrush, "CreateBrush(brush) -> GraphicsBrush\n"
    "\n"
    "Creates a native brush from a wxBrush.");

extern "C" {static PyObject *meth_wxGraphicsContext_CreateBrush(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_CreateBrush(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxBrush* brush;
        const  ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_brush,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxBrush, &brush))
        {
             ::wxGraphicsBrush*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxGraphicsBrush(sipCpp->CreateBrush(*brush));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxGraphicsBrush,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_CreateBrush, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_CreateFont, "CreateFont(font, col=BLACK) -> GraphicsFont\n"
    "CreateFont(sizeInPixels, facename, flags=FONTFLAG_DEFAULT, col=BLACK) -> GraphicsFont\n"
    "\n"
    "Creates a native graphics font from a wxFont and a text colour.");

extern "C" {static PyObject *meth_wxGraphicsContext_CreateFont(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_CreateFont(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont* font;
        const  ::wxColour& coldef = *wxBLACK;
        const  ::wxColour* col = &coldef;
        int colState = 0;
        const  ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_font,
            sipName_col,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9|J1", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxFont, &font, sipType_wxColour, &col, &colState))
        {
             ::wxGraphicsFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxGraphicsFont(sipCpp->CreateFont(*font,*col));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(col),sipType_wxColour,colState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxGraphicsFont,NULL);
        }
    }

    {
        double sizeInPixels;
        const  ::wxString* facename;
        int facenameState = 0;
        int flags = wxFONTFLAG_DEFAULT;
        const  ::wxColour& coldef = *wxBLACK;
        const  ::wxColour* col = &coldef;
        int colState = 0;
        const  ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sizeInPixels,
            sipName_facename,
            sipName_flags,
            sipName_col,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BdJ1|iJ1", &sipSelf, sipType_wxGraphicsContext, &sipCpp, &sizeInPixels, sipType_wxString,&facename, &facenameState, &flags, sipType_wxColour, &col, &colState))
        {
             ::wxGraphicsFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxGraphicsFont(sipCpp->CreateFont(sizeInPixels,*facename,flags,*col));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(facename),sipType_wxString,facenameState);
            sipReleaseType(const_cast< ::wxColour *>(col),sipType_wxColour,colState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxGraphicsFont,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_CreateFont, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_CreateMatrix, "CreateMatrix(a=1.0, b=0.0, c=0.0, d=1.0, tx=0.0, ty=0.0) -> GraphicsMatrix\n"
    "CreateMatrix(mat) -> GraphicsMatrix\n"
    "\n"
    "Creates a native affine transformation matrix from the passed in\n"
    "values.");

extern "C" {static PyObject *meth_wxGraphicsContext_CreateMatrix(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_CreateMatrix(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDouble a = 1;
         ::wxDouble b = 0;
         ::wxDouble c = 0;
         ::wxDouble d = 1;
         ::wxDouble tx = 0;
         ::wxDouble ty = 0;
        const  ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_a,
            sipName_b,
            sipName_c,
            sipName_d,
            sipName_tx,
            sipName_ty,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|dddddd", &sipSelf, sipType_wxGraphicsContext, &sipCpp, &a, &b, &c, &d, &tx, &ty))
        {
             ::wxGraphicsMatrix*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxGraphicsMatrix(sipCpp->CreateMatrix(a,b,c,d,tx,ty));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxGraphicsMatrix,NULL);
        }
    }

    {
        const  ::wxAffineMatrix2DBase* mat;
        const  ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_mat,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxAffineMatrix2DBase, &mat))
        {
             ::wxGraphicsMatrix*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxGraphicsMatrix(sipCpp->CreateMatrix(*mat));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxGraphicsMatrix,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_CreateMatrix, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_CreatePath, "CreatePath() -> GraphicsPath\n"
    "\n"
    "Creates a native graphics path which is initially empty.");

extern "C" {static PyObject *meth_wxGraphicsContext_CreatePath(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_CreatePath(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxGraphicsContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsContext, &sipCpp))
        {
             ::wxGraphicsPath*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxGraphicsPath(sipCpp->CreatePath());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxGraphicsPath,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_CreatePath, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_CreatePen, "CreatePen(pen) -> GraphicsPen\n"
    "\n"
    "Creates a native pen from a wxPen.");

extern "C" {static PyObject *meth_wxGraphicsContext_CreatePen(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_CreatePen(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPen* pen;
        const  ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pen,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxPen, &pen))
        {
             ::wxGraphicsPen*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxGraphicsPen(sipCpp->CreatePen(*pen));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxGraphicsPen,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_CreatePen, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_DrawEllipse, "DrawEllipse(x, y, w, h)\n"
    "\n"
    "Draws an ellipse.");

extern "C" {static PyObject *meth_wxGraphicsContext_DrawEllipse(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_DrawEllipse(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDouble x;
         ::wxDouble y;
         ::wxDouble w;
         ::wxDouble h;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_w,
            sipName_h,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bdddd", &sipSelf, sipType_wxGraphicsContext, &sipCpp, &x, &y, &w, &h))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawEllipse(x,y,w,h);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_DrawEllipse, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_DrawIcon, "DrawIcon(icon, x, y, w, h)\n"
    "\n"
    "Draws the icon.");

extern "C" {static PyObject *meth_wxGraphicsContext_DrawIcon(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_DrawIcon(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxIcon* icon;
         ::wxDouble x;
         ::wxDouble y;
         ::wxDouble w;
         ::wxDouble h;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_icon,
            sipName_x,
            sipName_y,
            sipName_w,
            sipName_h,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9dddd", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxIcon, &icon, &x, &y, &w, &h))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawIcon(*icon,x,y,w,h);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_DrawIcon, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_DrawLines, "DrawLines(point2Ds, fillStyle=ODDEVEN_RULE)\n"
    "\n"
    "Draws a polygon.");

extern "C" {static PyObject *meth_wxGraphicsContext_DrawLines(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_DrawLines(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        PyObject * points;
         ::wxPolygonFillMode fillStyle = wxODDEVEN_RULE;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_points,
            sipName_fillStyle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BP0|E", &sipSelf, sipType_wxGraphicsContext, &sipCpp, &points, sipType_wxPolygonFillMode, &fillStyle))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxGraphicsContext_DrawLines(sipCpp, points, fillStyle);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_DrawLines, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_DrawPath, "DrawPath(path, fillStyle=ODDEVEN_RULE)\n"
    "\n"
    "Draws the path by first filling and then stroking.");

extern "C" {static PyObject *meth_wxGraphicsContext_DrawPath(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_DrawPath(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxGraphicsPath* path;
         ::wxPolygonFillMode fillStyle = wxODDEVEN_RULE;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_path,
            sipName_fillStyle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9|E", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxGraphicsPath, &path, sipType_wxPolygonFillMode, &fillStyle))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawPath(*path,fillStyle);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_DrawPath, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_DrawRectangle, "DrawRectangle(x, y, w, h)\n"
    "\n"
    "Draws a rectangle.");

extern "C" {static PyObject *meth_wxGraphicsContext_DrawRectangle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_DrawRectangle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDouble x;
         ::wxDouble y;
         ::wxDouble w;
         ::wxDouble h;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_w,
            sipName_h,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bdddd", &sipSelf, sipType_wxGraphicsContext, &sipCpp, &x, &y, &w, &h))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawRectangle(x,y,w,h);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_DrawRectangle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_DrawRoundedRectangle, "DrawRoundedRectangle(x, y, w, h, radius)\n"
    "\n"
    "Draws a rounded rectangle.");

extern "C" {static PyObject *meth_wxGraphicsContext_DrawRoundedRectangle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_DrawRoundedRectangle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDouble x;
         ::wxDouble y;
         ::wxDouble w;
         ::wxDouble h;
         ::wxDouble radius;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_w,
            sipName_h,
            sipName_radius,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bddddd", &sipSelf, sipType_wxGraphicsContext, &sipCpp, &x, &y, &w, &h, &radius))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawRoundedRectangle(x,y,w,h,radius);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_DrawRoundedRectangle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_DrawText, "DrawText(str, x, y)\n"
    "DrawText(str, x, y, angle)\n"
    "DrawText(str, x, y, backgroundBrush)\n"
    "DrawText(str, x, y, angle, backgroundBrush)\n"
    "\n"
    "Draws text at the defined position.");

extern "C" {static PyObject *meth_wxGraphicsContext_DrawText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_DrawText(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* str;
        int strState = 0;
         ::wxDouble x;
         ::wxDouble y;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_str,
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1dd", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxString,&str, &strState, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawText(*str,x,y);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(str),sipType_wxString,strState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxString* str;
        int strState = 0;
         ::wxDouble x;
         ::wxDouble y;
         ::wxDouble angle;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_str,
            sipName_x,
            sipName_y,
            sipName_angle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1ddd", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxString,&str, &strState, &x, &y, &angle))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawText(*str,x,y,angle);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(str),sipType_wxString,strState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxString* str;
        int strState = 0;
         ::wxDouble x;
         ::wxDouble y;
        const  ::wxGraphicsBrush* backgroundBrush;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_str,
            sipName_x,
            sipName_y,
            sipName_backgroundBrush,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1ddJ9", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxString,&str, &strState, &x, &y, sipType_wxGraphicsBrush, &backgroundBrush))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawText(*str,x,y,*backgroundBrush);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(str),sipType_wxString,strState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxString* str;
        int strState = 0;
         ::wxDouble x;
         ::wxDouble y;
         ::wxDouble angle;
        const  ::wxGraphicsBrush* backgroundBrush;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_str,
            sipName_x,
            sipName_y,
            sipName_angle,
            sipName_backgroundBrush,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1dddJ9", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxString,&str, &strState, &x, &y, &angle, sipType_wxGraphicsBrush, &backgroundBrush))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawText(*str,x,y,angle,*backgroundBrush);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(str),sipType_wxString,strState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_DrawText, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_FillPath, "FillPath(path, fillStyle=ODDEVEN_RULE)\n"
    "\n"
    "Fills the path with the current brush.");

extern "C" {static PyObject *meth_wxGraphicsContext_FillPath(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_FillPath(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxGraphicsPath* path;
         ::wxPolygonFillMode fillStyle = wxODDEVEN_RULE;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_path,
            sipName_fillStyle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9|E", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxGraphicsPath, &path, sipType_wxPolygonFillMode, &fillStyle))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->FillPath(*path,fillStyle);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_FillPath, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_GetNativeContext, "GetNativeContext() -> void\n"
    "\n"
    "Returns the native context (CGContextRef for Core Graphics, Graphics\n"
    "pointer for GDIPlus and cairo_t pointer for cairo).");

extern "C" {static PyObject *meth_wxGraphicsContext_GetNativeContext(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_GetNativeContext(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxGraphicsContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsContext, &sipCpp))
        {
            void*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetNativeContext();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromVoidPtr(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_GetNativeContext, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_GetPartialTextExtents, "GetPartialTextExtents(text) -> ArrayDouble\n"
    "\n"
    "Fills the widths array with the widths from the beginning of text to\n"
    "the corresponding character of text.");

extern "C" {static PyObject *meth_wxGraphicsContext_GetPartialTextExtents(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_GetPartialTextExtents(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* text;
        int textState = 0;
        const  ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxString,&text, &textState))
        {
             ::wxArrayDouble*sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxGraphicsContext_GetPartialTextExtents(sipCpp, text);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxArrayDouble,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_GetPartialTextExtents, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_GetFullTextExtent, "GetFullTextExtent(text) -> (width, height, descent, externalLeading)\n"
    "GetTextExtent(text) -> (width, height)\n"
    "\n"
    "Gets the dimensions of the string using the currently selected font.");

extern "C" {static PyObject *meth_wxGraphicsContext_GetFullTextExtent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_GetFullTextExtent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* text;
        int textState = 0;
         ::wxDouble width;
         ::wxDouble height;
         ::wxDouble descent;
         ::wxDouble externalLeading;
        const  ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxString,&text, &textState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GetTextExtent(*text,&width,&height,&descent,&externalLeading);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(dddd)",width,height,descent,externalLeading);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_GetFullTextExtent, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_GetTextExtent, "GetTextExtent(self, text: object) -> object");

extern "C" {static PyObject *meth_wxGraphicsContext_GetTextExtent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_GetTextExtent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* text;
        int textState = 0;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxString,&text, &textState))
        {
            PyObject * sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxGraphicsContext_GetTextExtent(sipCpp, text);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_GetTextExtent, doc_wxGraphicsContext_GetTextExtent);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_GetTransform, "GetTransform() -> GraphicsMatrix\n"
    "\n"
    "Gets the current transformation matrix of this context.");

extern "C" {static PyObject *meth_wxGraphicsContext_GetTransform(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_GetTransform(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxGraphicsContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsContext, &sipCpp))
        {
             ::wxGraphicsMatrix*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxGraphicsMatrix(sipCpp->GetTransform());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxGraphicsMatrix,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_GetTransform, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_ResetClip, "ResetClip()\n"
    "\n"
    "Resets the clipping to original shape.");

extern "C" {static PyObject *meth_wxGraphicsContext_ResetClip(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_ResetClip(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxGraphicsContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsContext, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->ResetClip();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_ResetClip, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_Rotate, "Rotate(angle)\n"
    "\n"
    "Rotates the current transformation matrix (in radians).");

extern "C" {static PyObject *meth_wxGraphicsContext_Rotate(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_Rotate(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDouble angle;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_angle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bd", &sipSelf, sipType_wxGraphicsContext, &sipCpp, &angle))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Rotate(angle);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_Rotate, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_Scale, "Scale(xScale, yScale)\n"
    "\n"
    "Scales the current transformation matrix.");

extern "C" {static PyObject *meth_wxGraphicsContext_Scale(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_Scale(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDouble xScale;
         ::wxDouble yScale;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_xScale,
            sipName_yScale,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bdd", &sipSelf, sipType_wxGraphicsContext, &sipCpp, &xScale, &yScale))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Scale(xScale,yScale);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_Scale, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_SetBrush, "SetBrush(brush)\n"
    "SetBrush(brush)\n"
    "\n"
    "Sets the brush for filling paths.");

extern "C" {static PyObject *meth_wxGraphicsContext_SetBrush(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_SetBrush(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxBrush* brush;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_brush,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxBrush, &brush))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBrush(*brush);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxGraphicsBrush* brush;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_brush,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxGraphicsBrush, &brush))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBrush(*brush);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_SetBrush, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_SetFont, "SetFont(font, colour)\n"
    "SetFont(font)\n"
    "\n"
    "Sets the font for drawing text.");

extern "C" {static PyObject *meth_wxGraphicsContext_SetFont(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_SetFont(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFont* font;
        const  ::wxColour* colour;
        int colourState = 0;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_font,
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9J1", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxFont, &font, sipType_wxColour, &colour, &colourState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFont(*font,*colour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour),sipType_wxColour,colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxGraphicsFont* font;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_font,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxGraphicsFont, &font))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFont(*font);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_SetFont, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_SetPen, "SetPen(pen)\n"
    "SetPen(pen)\n"
    "\n"
    "Sets the pen used for stroking.");

extern "C" {static PyObject *meth_wxGraphicsContext_SetPen(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_SetPen(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPen* pen;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pen,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxPen, &pen))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPen(*pen);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxGraphicsPen* pen;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pen,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxGraphicsPen, &pen))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPen(*pen);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_SetPen, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_SetTransform, "SetTransform(matrix)\n"
    "\n"
    "Sets the current transformation matrix of this context.");

extern "C" {static PyObject *meth_wxGraphicsContext_SetTransform(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_SetTransform(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxGraphicsMatrix* matrix;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_matrix,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxGraphicsMatrix, &matrix))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetTransform(*matrix);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_SetTransform, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_StrokeLine, "StrokeLine(x1, y1, x2, y2)\n"
    "\n"
    "Strokes a single line.");

extern "C" {static PyObject *meth_wxGraphicsContext_StrokeLine(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_StrokeLine(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDouble x1;
         ::wxDouble y1;
         ::wxDouble x2;
         ::wxDouble y2;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x1,
            sipName_y1,
            sipName_x2,
            sipName_y2,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bdddd", &sipSelf, sipType_wxGraphicsContext, &sipCpp, &x1, &y1, &x2, &y2))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->StrokeLine(x1,y1,x2,y2);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_StrokeLine, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_StrokeLines, "StrokeLines(point2Ds)\n"
    "\n"
    "Stroke lines conencting all the points.");

extern "C" {static PyObject *meth_wxGraphicsContext_StrokeLines(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_StrokeLines(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        PyObject * points;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_points,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BP0", &sipSelf, sipType_wxGraphicsContext, &sipCpp, &points))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxGraphicsContext_StrokeLines(sipCpp, points);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_StrokeLines, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_StrokePath, "StrokePath(path)\n"
    "\n"
    "Strokes along a path with the current pen.");

extern "C" {static PyObject *meth_wxGraphicsContext_StrokePath(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_StrokePath(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxGraphicsPath* path;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_path,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxGraphicsPath, &path))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->StrokePath(*path);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_StrokePath, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_Translate, "Translate(dx, dy)\n"
    "\n"
    "Translates the current transformation matrix.");

extern "C" {static PyObject *meth_wxGraphicsContext_Translate(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_Translate(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDouble dx;
         ::wxDouble dy;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dx,
            sipName_dy,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bdd", &sipSelf, sipType_wxGraphicsContext, &sipCpp, &dx, &dy))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Translate(dx,dy);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_Translate, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_BeginLayer, "BeginLayer(opacity)\n"
    "\n"
    "Redirects all rendering is done into a fully transparent temporary\n"
    "context.");

extern "C" {static PyObject *meth_wxGraphicsContext_BeginLayer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_BeginLayer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDouble opacity;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_opacity,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bd", &sipSelf, sipType_wxGraphicsContext, &sipCpp, &opacity))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->BeginLayer(opacity);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_BeginLayer, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_EndLayer, "EndLayer()\n"
    "\n"
    "Composites back the drawings into the context with the opacity given\n"
    "at the BeginLayer call.");

extern "C" {static PyObject *meth_wxGraphicsContext_EndLayer(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_EndLayer(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxGraphicsContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsContext, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->EndLayer();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_EndLayer, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_SetAntialiasMode, "SetAntialiasMode(antialias) -> bool\n"
    "\n"
    "Sets the antialiasing mode, returns true if it supported.");

extern "C" {static PyObject *meth_wxGraphicsContext_SetAntialiasMode(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_SetAntialiasMode(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxAntialiasMode antialias;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_antialias,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxAntialiasMode, &antialias))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetAntialiasMode(antialias);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_SetAntialiasMode, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_GetAntialiasMode, "GetAntialiasMode() -> AntialiasMode\n"
    "\n"
    "Returns the current shape antialiasing mode.");

extern "C" {static PyObject *meth_wxGraphicsContext_GetAntialiasMode(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_GetAntialiasMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxGraphicsContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsContext, &sipCpp))
        {
             ::wxAntialiasMode sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetAntialiasMode();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(sipRes,sipType_wxAntialiasMode);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_GetAntialiasMode, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_SetInterpolationQuality, "SetInterpolationQuality(interpolation) -> bool\n"
    "\n"
    "Sets the interpolation quality, returns true if it is supported.");

extern "C" {static PyObject *meth_wxGraphicsContext_SetInterpolationQuality(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_SetInterpolationQuality(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxInterpolationQuality interpolation;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_interpolation,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxInterpolationQuality, &interpolation))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetInterpolationQuality(interpolation);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_SetInterpolationQuality, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_GetInterpolationQuality, "GetInterpolationQuality() -> InterpolationQuality\n"
    "\n"
    "Returns the current interpolation quality.");

extern "C" {static PyObject *meth_wxGraphicsContext_GetInterpolationQuality(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_GetInterpolationQuality(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxGraphicsContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsContext, &sipCpp))
        {
             ::wxInterpolationQuality sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetInterpolationQuality();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(sipRes,sipType_wxInterpolationQuality);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_GetInterpolationQuality, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_SetCompositionMode, "SetCompositionMode(op) -> bool\n"
    "\n"
    "Sets the compositing operator, returns true if it supported.");

extern "C" {static PyObject *meth_wxGraphicsContext_SetCompositionMode(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_SetCompositionMode(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxCompositionMode op;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_op,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxCompositionMode, &op))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetCompositionMode(op);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_SetCompositionMode, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_GetCompositionMode, "GetCompositionMode() -> CompositionMode\n"
    "\n"
    "Returns the current compositing operator.");

extern "C" {static PyObject *meth_wxGraphicsContext_GetCompositionMode(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_GetCompositionMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxGraphicsContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsContext, &sipCpp))
        {
             ::wxCompositionMode sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetCompositionMode();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(sipRes,sipType_wxCompositionMode);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_GetCompositionMode, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_PushState, "PushState()\n"
    "\n"
    "Push the current state of the context's transformation matrix on a\n"
    "stack.");

extern "C" {static PyObject *meth_wxGraphicsContext_PushState(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_PushState(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxGraphicsContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsContext, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->PushState();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_PushState, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_PopState, "PopState()\n"
    "\n"
    "Pops a stored state from the stack and sets the current transformation\n"
    "matrix to that state.");

extern "C" {static PyObject *meth_wxGraphicsContext_PopState(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_PopState(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxGraphicsContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsContext, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->PopState();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_PopState, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_ShouldOffset, "ShouldOffset() -> bool");

extern "C" {static PyObject *meth_wxGraphicsContext_ShouldOffset(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_ShouldOffset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxGraphicsContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsContext, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ShouldOffset();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_ShouldOffset, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_EnableOffset, "EnableOffset(enable=True)");

extern "C" {static PyObject *meth_wxGraphicsContext_EnableOffset(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_EnableOffset(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool enable = 1;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_enable,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|b", &sipSelf, sipType_wxGraphicsContext, &sipCpp, &enable))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->EnableOffset(enable);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_EnableOffset, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_DisableOffset, "DisableOffset()");

extern "C" {static PyObject *meth_wxGraphicsContext_DisableOffset(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_DisableOffset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxGraphicsContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsContext, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DisableOffset();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_DisableOffset, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_OffsetEnabled, "OffsetEnabled() -> bool");

extern "C" {static PyObject *meth_wxGraphicsContext_OffsetEnabled(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_OffsetEnabled(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxGraphicsContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsContext, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->OffsetEnabled();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_OffsetEnabled, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_StartDoc, "StartDoc(message) -> bool\n"
    "\n"
    "Begin a new document (relevant only for printing / pdf etc.) If there\n"
    "is a progress dialog, message will be shown.");

extern "C" {static PyObject *meth_wxGraphicsContext_StartDoc(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_StartDoc(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* message;
        int messageState = 0;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_message,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxGraphicsContext, &sipCpp, sipType_wxString,&message, &messageState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->StartDoc(*message);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(message),sipType_wxString,messageState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_StartDoc, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_EndDoc, "EndDoc()\n"
    "\n"
    "Done with that document (relevant only for printing / pdf etc.)");

extern "C" {static PyObject *meth_wxGraphicsContext_EndDoc(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_EndDoc(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxGraphicsContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsContext, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->EndDoc();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_EndDoc, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_StartPage, "StartPage(width=0, height=0)\n"
    "\n"
    "Opens a new page (relevant only for printing / pdf etc.) with the\n"
    "given size in points.");

extern "C" {static PyObject *meth_wxGraphicsContext_StartPage(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_StartPage(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDouble width = 0;
         ::wxDouble height = 0;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|dd", &sipSelf, sipType_wxGraphicsContext, &sipCpp, &width, &height))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->StartPage(width,height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_StartPage, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_EndPage, "EndPage()\n"
    "\n"
    "Ends the current page (relevant only for printing / pdf etc.)");

extern "C" {static PyObject *meth_wxGraphicsContext_EndPage(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_EndPage(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxGraphicsContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsContext, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->EndPage();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_EndPage, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_Flush, "Flush()\n"
    "\n"
    "Make sure that the current content of this context is immediately\n"
    "visible.");

extern "C" {static PyObject *meth_wxGraphicsContext_Flush(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_Flush(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxGraphicsContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsContext, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Flush();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_Flush, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_GetSize, "GetSize() -> (width, height)\n"
    "\n"
    "Returns the size of the graphics context in device coordinates.");

extern "C" {static PyObject *meth_wxGraphicsContext_GetSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_GetSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDouble width;
         ::wxDouble height;
        const  ::wxGraphicsContext *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, "B", &sipSelf, sipType_wxGraphicsContext, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GetSize(&width,&height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(dd)",width,height);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_GetSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_GetDPI, "GetDPI() -> (dpiX, dpiY)\n"
    "\n"
    "Returns the resolution of the graphics context in device points per\n"
    "inch.");

extern "C" {static PyObject *meth_wxGraphicsContext_GetDPI(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_GetDPI(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDouble dpiX;
         ::wxDouble dpiY;
         ::wxGraphicsContext *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, "B", &sipSelf, sipType_wxGraphicsContext, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GetDPI(&dpiX,&dpiY);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(dd)",dpiX,dpiY);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_GetDPI, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsContext_StrokeLineSegments, "StrokeLineSegments(beginPoint2Ds, endPoint2Ds)\n"
    "\n"
    "Stroke disconnected lines from begin to end points.");

extern "C" {static PyObject *meth_wxGraphicsContext_StrokeLineSegments(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsContext_StrokeLineSegments(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        PyObject * beginPoints;
        PyObject * endPoints;
         ::wxGraphicsContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_beginPoints,
            sipName_endPoints,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BP0P0", &sipSelf, sipType_wxGraphicsContext, &sipCpp, &beginPoints, &endPoints))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxGraphicsContext_StrokeLineSegments(sipCpp, beginPoints, endPoints);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsContext, sipName_StrokeLineSegments, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxGraphicsContext(void *, const sipTypeDef *);}
static void *cast_wxGraphicsContext(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxGraphicsContext *sipCpp = reinterpret_cast< ::wxGraphicsContext *>(sipCppV);

    if (targetType == sipType_wxGraphicsObject)
        return static_cast< ::wxGraphicsObject *>(sipCpp);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxGraphicsContext(void *, int);}
static void release_wxGraphicsContext(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxGraphicsContext *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxGraphicsContext(sipSimpleWrapper *);}
static void dealloc_wxGraphicsContext(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxGraphicsContext(sipGetAddress(sipSelf), 0);
    }
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxGraphicsContext[] = {{215, 255, 1}};


static PyMethodDef methods_wxGraphicsContext[] = {
    {SIP_MLNAME_CAST(sipName_BeginLayer), (PyCFunction)meth_wxGraphicsContext_BeginLayer, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_BeginLayer)},
    {SIP_MLNAME_CAST(sipName_Clip), (PyCFunction)meth_wxGraphicsContext_Clip, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_Clip)},
    {SIP_MLNAME_CAST(sipName_ConcatTransform), (PyCFunction)meth_wxGraphicsContext_ConcatTransform, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_ConcatTransform)},
    {SIP_MLNAME_CAST(sipName_Create), (PyCFunction)meth_wxGraphicsContext_Create, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_Create)},
    {SIP_MLNAME_CAST(sipName_CreateBitmap), (PyCFunction)meth_wxGraphicsContext_CreateBitmap, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_CreateBitmap)},
    {SIP_MLNAME_CAST(sipName_CreateBitmapFromImage), (PyCFunction)meth_wxGraphicsContext_CreateBitmapFromImage, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_CreateBitmapFromImage)},
    {SIP_MLNAME_CAST(sipName_CreateBrush), (PyCFunction)meth_wxGraphicsContext_CreateBrush, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_CreateBrush)},
    {SIP_MLNAME_CAST(sipName_CreateFont), (PyCFunction)meth_wxGraphicsContext_CreateFont, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_CreateFont)},
    {SIP_MLNAME_CAST(sipName_CreateFromNative), (PyCFunction)meth_wxGraphicsContext_CreateFromNative, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_CreateFromNative)},
    {SIP_MLNAME_CAST(sipName_CreateFromNativeWindow), (PyCFunction)meth_wxGraphicsContext_CreateFromNativeWindow, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_CreateFromNativeWindow)},
    {SIP_MLNAME_CAST(sipName_CreateLinearGradientBrush), (PyCFunction)meth_wxGraphicsContext_CreateLinearGradientBrush, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_CreateLinearGradientBrush)},
    {SIP_MLNAME_CAST(sipName_CreateMatrix), (PyCFunction)meth_wxGraphicsContext_CreateMatrix, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_CreateMatrix)},
    {SIP_MLNAME_CAST(sipName_CreatePath), meth_wxGraphicsContext_CreatePath, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGraphicsContext_CreatePath)},
    {SIP_MLNAME_CAST(sipName_CreatePen), (PyCFunction)meth_wxGraphicsContext_CreatePen, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_CreatePen)},
    {SIP_MLNAME_CAST(sipName_CreateRadialGradientBrush), (PyCFunction)meth_wxGraphicsContext_CreateRadialGradientBrush, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_CreateRadialGradientBrush)},
    {SIP_MLNAME_CAST(sipName_CreateSubBitmap), (PyCFunction)meth_wxGraphicsContext_CreateSubBitmap, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_CreateSubBitmap)},
    {SIP_MLNAME_CAST(sipName_DisableOffset), meth_wxGraphicsContext_DisableOffset, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGraphicsContext_DisableOffset)},
    {SIP_MLNAME_CAST(sipName_DrawBitmap), (PyCFunction)meth_wxGraphicsContext_DrawBitmap, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_DrawBitmap)},
    {SIP_MLNAME_CAST(sipName_DrawEllipse), (PyCFunction)meth_wxGraphicsContext_DrawEllipse, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_DrawEllipse)},
    {SIP_MLNAME_CAST(sipName_DrawIcon), (PyCFunction)meth_wxGraphicsContext_DrawIcon, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_DrawIcon)},
    {SIP_MLNAME_CAST(sipName_DrawLines), (PyCFunction)meth_wxGraphicsContext_DrawLines, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_DrawLines)},
    {SIP_MLNAME_CAST(sipName_DrawPath), (PyCFunction)meth_wxGraphicsContext_DrawPath, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_DrawPath)},
    {SIP_MLNAME_CAST(sipName_DrawRectangle), (PyCFunction)meth_wxGraphicsContext_DrawRectangle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_DrawRectangle)},
    {SIP_MLNAME_CAST(sipName_DrawRoundedRectangle), (PyCFunction)meth_wxGraphicsContext_DrawRoundedRectangle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_DrawRoundedRectangle)},
    {SIP_MLNAME_CAST(sipName_DrawText), (PyCFunction)meth_wxGraphicsContext_DrawText, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_DrawText)},
    {SIP_MLNAME_CAST(sipName_EnableOffset), (PyCFunction)meth_wxGraphicsContext_EnableOffset, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_EnableOffset)},
    {SIP_MLNAME_CAST(sipName_EndDoc), meth_wxGraphicsContext_EndDoc, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGraphicsContext_EndDoc)},
    {SIP_MLNAME_CAST(sipName_EndLayer), meth_wxGraphicsContext_EndLayer, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGraphicsContext_EndLayer)},
    {SIP_MLNAME_CAST(sipName_EndPage), meth_wxGraphicsContext_EndPage, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGraphicsContext_EndPage)},
    {SIP_MLNAME_CAST(sipName_FillPath), (PyCFunction)meth_wxGraphicsContext_FillPath, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_FillPath)},
    {SIP_MLNAME_CAST(sipName_Flush), meth_wxGraphicsContext_Flush, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGraphicsContext_Flush)},
    {SIP_MLNAME_CAST(sipName_GetAntialiasMode), meth_wxGraphicsContext_GetAntialiasMode, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGraphicsContext_GetAntialiasMode)},
    {SIP_MLNAME_CAST(sipName_GetCompositionMode), meth_wxGraphicsContext_GetCompositionMode, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGraphicsContext_GetCompositionMode)},
    {SIP_MLNAME_CAST(sipName_GetDPI), (PyCFunction)meth_wxGraphicsContext_GetDPI, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_GetDPI)},
    {SIP_MLNAME_CAST(sipName_GetFullTextExtent), (PyCFunction)meth_wxGraphicsContext_GetFullTextExtent, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_GetFullTextExtent)},
    {SIP_MLNAME_CAST(sipName_GetInterpolationQuality), meth_wxGraphicsContext_GetInterpolationQuality, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGraphicsContext_GetInterpolationQuality)},
    {SIP_MLNAME_CAST(sipName_GetNativeContext), meth_wxGraphicsContext_GetNativeContext, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGraphicsContext_GetNativeContext)},
    {SIP_MLNAME_CAST(sipName_GetPartialTextExtents), (PyCFunction)meth_wxGraphicsContext_GetPartialTextExtents, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_GetPartialTextExtents)},
    {SIP_MLNAME_CAST(sipName_GetSize), (PyCFunction)meth_wxGraphicsContext_GetSize, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_GetSize)},
    {SIP_MLNAME_CAST(sipName_GetTextExtent), (PyCFunction)meth_wxGraphicsContext_GetTextExtent, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_GetTextExtent)},
    {SIP_MLNAME_CAST(sipName_GetTransform), meth_wxGraphicsContext_GetTransform, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGraphicsContext_GetTransform)},
    {SIP_MLNAME_CAST(sipName_OffsetEnabled), meth_wxGraphicsContext_OffsetEnabled, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGraphicsContext_OffsetEnabled)},
    {SIP_MLNAME_CAST(sipName_PopState), meth_wxGraphicsContext_PopState, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGraphicsContext_PopState)},
    {SIP_MLNAME_CAST(sipName_PushState), meth_wxGraphicsContext_PushState, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGraphicsContext_PushState)},
    {SIP_MLNAME_CAST(sipName_ResetClip), meth_wxGraphicsContext_ResetClip, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGraphicsContext_ResetClip)},
    {SIP_MLNAME_CAST(sipName_Rotate), (PyCFunction)meth_wxGraphicsContext_Rotate, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_Rotate)},
    {SIP_MLNAME_CAST(sipName_Scale), (PyCFunction)meth_wxGraphicsContext_Scale, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_Scale)},
    {SIP_MLNAME_CAST(sipName_SetAntialiasMode), (PyCFunction)meth_wxGraphicsContext_SetAntialiasMode, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_SetAntialiasMode)},
    {SIP_MLNAME_CAST(sipName_SetBrush), (PyCFunction)meth_wxGraphicsContext_SetBrush, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_SetBrush)},
    {SIP_MLNAME_CAST(sipName_SetCompositionMode), (PyCFunction)meth_wxGraphicsContext_SetCompositionMode, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_SetCompositionMode)},
    {SIP_MLNAME_CAST(sipName_SetFont), (PyCFunction)meth_wxGraphicsContext_SetFont, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_SetFont)},
    {SIP_MLNAME_CAST(sipName_SetInterpolationQuality), (PyCFunction)meth_wxGraphicsContext_SetInterpolationQuality, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_SetInterpolationQuality)},
    {SIP_MLNAME_CAST(sipName_SetPen), (PyCFunction)meth_wxGraphicsContext_SetPen, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_SetPen)},
    {SIP_MLNAME_CAST(sipName_SetTransform), (PyCFunction)meth_wxGraphicsContext_SetTransform, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_SetTransform)},
    {SIP_MLNAME_CAST(sipName_ShouldOffset), meth_wxGraphicsContext_ShouldOffset, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGraphicsContext_ShouldOffset)},
    {SIP_MLNAME_CAST(sipName_StartDoc), (PyCFunction)meth_wxGraphicsContext_StartDoc, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_StartDoc)},
    {SIP_MLNAME_CAST(sipName_StartPage), (PyCFunction)meth_wxGraphicsContext_StartPage, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_StartPage)},
    {SIP_MLNAME_CAST(sipName_StrokeLine), (PyCFunction)meth_wxGraphicsContext_StrokeLine, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_StrokeLine)},
    {SIP_MLNAME_CAST(sipName_StrokeLineSegments), (PyCFunction)meth_wxGraphicsContext_StrokeLineSegments, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_StrokeLineSegments)},
    {SIP_MLNAME_CAST(sipName_StrokeLines), (PyCFunction)meth_wxGraphicsContext_StrokeLines, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_StrokeLines)},
    {SIP_MLNAME_CAST(sipName_StrokePath), (PyCFunction)meth_wxGraphicsContext_StrokePath, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_StrokePath)},
    {SIP_MLNAME_CAST(sipName_Translate), (PyCFunction)meth_wxGraphicsContext_Translate, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsContext_Translate)}
};

sipVariableDef variables_wxGraphicsContext[] = {
    {PropertyVariable, sipName_Transform, &methods_wxGraphicsContext[40], &methods_wxGraphicsContext[53], NULL, NULL},
    {PropertyVariable, sipName_TextExtent, &methods_wxGraphicsContext[39], NULL, NULL, NULL},
    {PropertyVariable, sipName_NativeContext, &methods_wxGraphicsContext[36], NULL, NULL, NULL},
    {PropertyVariable, sipName_InterpolationQuality, &methods_wxGraphicsContext[35], &methods_wxGraphicsContext[51], NULL, NULL},
    {PropertyVariable, sipName_CompositionMode, &methods_wxGraphicsContext[32], &methods_wxGraphicsContext[49], NULL, NULL},
    {PropertyVariable, sipName_AntialiasMode, &methods_wxGraphicsContext[31], &methods_wxGraphicsContext[47], NULL, NULL},
};

PyDoc_STRVAR(doc_wxGraphicsContext, "A wxGraphicsContext instance is the object that is drawn upon.");


sipClassTypeDef sipTypeDef__core_wxGraphicsContext = {
    {
        -1,
        0,
        0,
        SIP_TYPE_ABSTRACT|SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxGraphicsContext,
        {0},
        0
    },
    {
        sipNameNr_GraphicsContext,
        {0, 0, 1},
        62, methods_wxGraphicsContext,
        0, 0,
        6, variables_wxGraphicsContext,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxGraphicsContext,
    -1,
    -1,
    supers_wxGraphicsContext,
    0,
    0,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxGraphicsContext,
    0,
    0,
    0,
    release_wxGraphicsContext,
    cast_wxGraphicsContext,
    0,
    0,
    0,
    0,
    0,
    0
};
