/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.1
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/platinfo.h>

        #include <wx/platinfo.h>


PyDoc_STRVAR(doc_wxPlatformInfo_GetArch, "GetArch(arch) -> Architecture\n"
    "\n"
    "Converts the given string to a wxArchitecture enum value or to\n"
    "wxARCH_INVALID if the given string is not a valid architecture string\n"
    "(i.e.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetArch(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetArch(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* arch;
        int archState = 0;

        static const char *sipKwdList[] = {
            sipName_arch,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&arch, &archState))
        {
             ::wxArchitecture sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxPlatformInfo::GetArch(*arch);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(arch),sipType_wxString,archState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(sipRes,sipType_wxArchitecture);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetArch, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetEndianness, "GetEndianness() -> Endianness\n"
    "\n"
    "Returns the endianness ID of this wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetEndianness(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetEndianness(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxEndianness sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetEndianness();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(sipRes,sipType_wxEndianness);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetEndianness, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetOperatingSystemId, "GetOperatingSystemId() -> OperatingSystemId\n"
    "\n"
    "Returns the operating system ID of this wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetOperatingSystemId(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetOperatingSystemId(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxOperatingSystemId sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetOperatingSystemId();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(sipRes,sipType_wxOperatingSystemId);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetOperatingSystemId, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetPortId, "GetPortId() -> PortId\n"
    "\n"
    "Returns the wxWidgets port ID associated with this wxPlatformInfo\n"
    "instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetPortId(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetPortId(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxPortId sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPortId();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(sipRes,sipType_wxPortId);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetPortId, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetArchName, "GetArchName() -> String\n"
    "\n"
    "Returns the name for the architecture of this wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetArchName(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetArchName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetArchName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetArchName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetEndiannessName, "GetEndiannessName() -> String\n"
    "\n"
    "Returns the name for the endianness of this wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetEndiannessName(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetEndiannessName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetEndiannessName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetEndiannessName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetOperatingSystemFamilyName, "GetOperatingSystemFamilyName() -> String\n"
    "\n"
    "Returns the operating system family name of the OS associated with\n"
    "this wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetOperatingSystemFamilyName(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetOperatingSystemFamilyName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetOperatingSystemFamilyName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetOperatingSystemFamilyName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetOperatingSystemIdName, "GetOperatingSystemIdName() -> String\n"
    "\n"
    "Returns the operating system name of the OS associated with this\n"
    "wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetOperatingSystemIdName(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetOperatingSystemIdName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetOperatingSystemIdName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetOperatingSystemIdName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetPortIdName, "GetPortIdName() -> String\n"
    "\n"
    "Returns the name of the wxWidgets port ID associated with this\n"
    "wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetPortIdName(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetPortIdName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetPortIdName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetPortIdName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetPortIdShortName, "GetPortIdShortName() -> String\n"
    "\n"
    "Returns the short name of the wxWidgets port ID associated with this\n"
    "wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetPortIdShortName(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetPortIdShortName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetPortIdShortName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetPortIdShortName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetOperatingSystemDirectory, "GetOperatingSystemDirectory() -> String\n"
    "\n"
    "Returns the operating system directory.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetOperatingSystemDirectory(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetOperatingSystemDirectory(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString( ::wxPlatformInfo::GetOperatingSystemDirectory());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetOperatingSystemDirectory, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetArchitecture, "GetArchitecture() -> Architecture\n"
    "\n"
    "Returns the architecture ID of this wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetArchitecture(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetArchitecture(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxArchitecture sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetArchitecture();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(sipRes,sipType_wxArchitecture);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetArchitecture, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetOSMajorVersion, "GetOSMajorVersion() -> int\n"
    "\n"
    "Returns the run-time major version of the OS associated with this\n"
    "wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetOSMajorVersion(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetOSMajorVersion(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetOSMajorVersion();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetOSMajorVersion, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetOSMinorVersion, "GetOSMinorVersion() -> int\n"
    "\n"
    "Returns the run-time minor version of the OS associated with this\n"
    "wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetOSMinorVersion(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetOSMinorVersion(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetOSMinorVersion();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetOSMinorVersion, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetOperatingSystemDescription, "GetOperatingSystemDescription() -> String\n"
    "\n"
    "Returns the description of the operating system of this wxPlatformInfo\n"
    "instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetOperatingSystemDescription(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetOperatingSystemDescription(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetOperatingSystemDescription());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetOperatingSystemDescription, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetLinuxDistributionInfo, "GetLinuxDistributionInfo() -> LinuxDistributionInfo\n"
    "\n"
    "Returns the Linux distribution info associated with this\n"
    "wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetLinuxDistributionInfo(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetLinuxDistributionInfo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxLinuxDistributionInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxLinuxDistributionInfo(sipCpp->GetLinuxDistributionInfo());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxLinuxDistributionInfo,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetLinuxDistributionInfo, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetDesktopEnvironment, "GetDesktopEnvironment() -> String\n"
    "\n"
    "Returns the desktop environment associated with this wxPlatformInfo\n"
    "instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetDesktopEnvironment(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetDesktopEnvironment(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetDesktopEnvironment());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetDesktopEnvironment, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetToolkitMajorVersion, "GetToolkitMajorVersion() -> int\n"
    "\n"
    "Returns the run-time major version of the toolkit associated with this\n"
    "wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetToolkitMajorVersion(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetToolkitMajorVersion(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetToolkitMajorVersion();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetToolkitMajorVersion, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetToolkitMinorVersion, "GetToolkitMinorVersion() -> int\n"
    "\n"
    "Returns the run-time minor version of the toolkit associated with this\n"
    "wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetToolkitMinorVersion(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetToolkitMinorVersion(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetToolkitMinorVersion();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetToolkitMinorVersion, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_SetArchitecture, "SetArchitecture(n)\n"
    "\n"
    "Sets the architecture enum value associated with this wxPlatformInfo\n"
    "instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_SetArchitecture(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_SetArchitecture(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxArchitecture n;
         ::wxPlatformInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxPlatformInfo, &sipCpp, sipType_wxArchitecture, &n))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetArchitecture(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_SetArchitecture, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_SetEndianness, "SetEndianness(n)\n"
    "\n"
    "Sets the endianness enum value associated with this wxPlatformInfo\n"
    "instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_SetEndianness(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_SetEndianness(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxEndianness n;
         ::wxPlatformInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxPlatformInfo, &sipCpp, sipType_wxEndianness, &n))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetEndianness(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_SetEndianness, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_SetOSVersion, "SetOSVersion(major, minor)\n"
    "\n"
    "Sets the version of the operating system associated with this\n"
    "wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_SetOSVersion(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_SetOSVersion(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int major;
        int minor;
         ::wxPlatformInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_major,
            sipName_minor,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii", &sipSelf, sipType_wxPlatformInfo, &sipCpp, &major, &minor))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetOSVersion(major,minor);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_SetOSVersion, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_SetOperatingSystemId, "SetOperatingSystemId(n)\n"
    "\n"
    "Sets the operating system associated with this wxPlatformInfo\n"
    "instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_SetOperatingSystemId(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_SetOperatingSystemId(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxOperatingSystemId n;
         ::wxPlatformInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxPlatformInfo, &sipCpp, sipType_wxOperatingSystemId, &n))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetOperatingSystemId(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_SetOperatingSystemId, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_SetPortId, "SetPortId(n)\n"
    "\n"
    "Sets the wxWidgets port ID associated with this wxPlatformInfo\n"
    "instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_SetPortId(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_SetPortId(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxPortId n;
         ::wxPlatformInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxPlatformInfo, &sipCpp, sipType_wxPortId, &n))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPortId(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_SetPortId, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_SetToolkitVersion, "SetToolkitVersion(major, minor)\n"
    "\n"
    "Sets the version of the toolkit associated with this wxPlatformInfo\n"
    "instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_SetToolkitVersion(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_SetToolkitVersion(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int major;
        int minor;
         ::wxPlatformInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_major,
            sipName_minor,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii", &sipSelf, sipType_wxPlatformInfo, &sipCpp, &major, &minor))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetToolkitVersion(major,minor);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_SetToolkitVersion, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_SetOperatingSystemDescription, "SetOperatingSystemDescription(desc)\n"
    "\n"
    "Sets the operating system description associated with this\n"
    "wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_SetOperatingSystemDescription(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_SetOperatingSystemDescription(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* desc;
        int descState = 0;
         ::wxPlatformInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_desc,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPlatformInfo, &sipCpp, sipType_wxString,&desc, &descState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetOperatingSystemDescription(*desc);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(desc),sipType_wxString,descState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_SetOperatingSystemDescription, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_SetDesktopEnvironment, "SetDesktopEnvironment(de)\n"
    "\n"
    "Sets the desktop environment associated with this wxPlatformInfo\n"
    "instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_SetDesktopEnvironment(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_SetDesktopEnvironment(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* de;
        int deState = 0;
         ::wxPlatformInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_de,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPlatformInfo, &sipCpp, sipType_wxString,&de, &deState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDesktopEnvironment(*de);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(de),sipType_wxString,deState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_SetDesktopEnvironment, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_SetLinuxDistributionInfo, "SetLinuxDistributionInfo(di)\n"
    "\n"
    "Sets the linux distribution info associated with this wxPlatformInfo\n"
    "instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_SetLinuxDistributionInfo(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_SetLinuxDistributionInfo(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxLinuxDistributionInfo* di;
         ::wxPlatformInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_di,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxPlatformInfo, &sipCpp, sipType_wxLinuxDistributionInfo, &di))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLinuxDistributionInfo(*di);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_SetLinuxDistributionInfo, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_CheckOSVersion, "CheckOSVersion(major, minor) -> bool\n"
    "\n"
    "Returns true if the OS version is at least major.minor.");

extern "C" {static PyObject *meth_wxPlatformInfo_CheckOSVersion(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_CheckOSVersion(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int major;
        int minor;
        const  ::wxPlatformInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_major,
            sipName_minor,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii", &sipSelf, sipType_wxPlatformInfo, &sipCpp, &major, &minor))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CheckOSVersion(major,minor);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_CheckOSVersion, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_CheckToolkitVersion, "CheckToolkitVersion(major, minor) -> bool\n"
    "\n"
    "Returns true if the toolkit version is at least major.minor.");

extern "C" {static PyObject *meth_wxPlatformInfo_CheckToolkitVersion(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_CheckToolkitVersion(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int major;
        int minor;
        const  ::wxPlatformInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_major,
            sipName_minor,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii", &sipSelf, sipType_wxPlatformInfo, &sipCpp, &major, &minor))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CheckToolkitVersion(major,minor);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_CheckToolkitVersion, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_IsOk, "IsOk() -> bool\n"
    "\n"
    "Returns true if this instance is fully initialized with valid values.");

extern "C" {static PyObject *meth_wxPlatformInfo_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_IsOk, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_IsUsingUniversalWidgets, "IsUsingUniversalWidgets() -> bool\n"
    "\n"
    "Returns true if this wxPlatformInfo describes wxUniversal build.");

extern "C" {static PyObject *meth_wxPlatformInfo_IsUsingUniversalWidgets(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_IsUsingUniversalWidgets(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsUsingUniversalWidgets();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_IsUsingUniversalWidgets, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPlatformInfo_Get, "Get() -> PlatformInfo\n"
    "\n"
    "Returns the global wxPlatformInfo object, initialized with the values\n"
    "for the currently running platform.");

extern "C" {static PyObject *meth_wxPlatformInfo_Get(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_Get(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxPlatformInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPlatformInfo( ::wxPlatformInfo::Get());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPlatformInfo,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_Get, NULL);

    return NULL;
}


extern "C" {static PyObject *slot_wxPlatformInfo___eq__(PyObject *,PyObject *);}
static PyObject *slot_wxPlatformInfo___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxPlatformInfo *sipCpp = reinterpret_cast< ::wxPlatformInfo *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxPlatformInfo));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxPlatformInfo* t;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxPlatformInfo, &t))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxPlatformInfo::operator==(*t);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, eq_slot, sipType_wxPlatformInfo, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxPlatformInfo___ne__(PyObject *,PyObject *);}
static PyObject *slot_wxPlatformInfo___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxPlatformInfo *sipCpp = reinterpret_cast< ::wxPlatformInfo *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxPlatformInfo));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxPlatformInfo* t;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxPlatformInfo, &t))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxPlatformInfo::operator!=(*t);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, ne_slot, sipType_wxPlatformInfo, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_wxPlatformInfo(void *, int);}
static void release_wxPlatformInfo(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxPlatformInfo *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxPlatformInfo(void *, SIP_SSIZE_T, const void *);}
static void assign_wxPlatformInfo(void *sipDst, SIP_SSIZE_T sipDstIdx, const void *sipSrc)
{
    reinterpret_cast< ::wxPlatformInfo *>(sipDst)[sipDstIdx] = *reinterpret_cast<const  ::wxPlatformInfo *>(sipSrc);
}


extern "C" {static void *array_wxPlatformInfo(SIP_SSIZE_T);}
static void *array_wxPlatformInfo(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxPlatformInfo[sipNrElem];
}


extern "C" {static void *copy_wxPlatformInfo(const void *, SIP_SSIZE_T);}
static void *copy_wxPlatformInfo(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxPlatformInfo(reinterpret_cast<const  ::wxPlatformInfo *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxPlatformInfo(sipSimpleWrapper *);}
static void dealloc_wxPlatformInfo(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxPlatformInfo(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxPlatformInfo(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxPlatformInfo(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxPlatformInfo *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxPlatformInfo();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
         ::wxPortId pid;
        int tkMajor = -1;
        int tkMinor = -1;
         ::wxOperatingSystemId id = wxOS_UNKNOWN;
        int osMajor = -1;
        int osMinor = -1;
         ::wxArchitecture arch = wxARCH_INVALID;
         ::wxEndianness endian = wxENDIAN_INVALID;

        static const char *sipKwdList[] = {
            sipName_pid,
            sipName_tkMajor,
            sipName_tkMinor,
            sipName_id,
            sipName_osMajor,
            sipName_osMinor,
            sipName_arch,
            sipName_endian,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "E|iiEiiEE", sipType_wxPortId, &pid, &tkMajor, &tkMinor, sipType_wxOperatingSystemId, &id, &osMajor, &osMinor, sipType_wxArchitecture, &arch, sipType_wxEndianness, &endian))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxPlatformInfo(pid,tkMajor,tkMinor,id,osMajor,osMinor,arch,endian);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxPlatformInfo* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxPlatformInfo, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxPlatformInfo(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxPlatformInfo[] = {
    {(void *)slot_wxPlatformInfo___eq__, eq_slot},
    {(void *)slot_wxPlatformInfo___ne__, ne_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxPlatformInfo[] = {
    {SIP_MLNAME_CAST(sipName_CheckOSVersion), (PyCFunction)meth_wxPlatformInfo_CheckOSVersion, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPlatformInfo_CheckOSVersion)},
    {SIP_MLNAME_CAST(sipName_CheckToolkitVersion), (PyCFunction)meth_wxPlatformInfo_CheckToolkitVersion, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPlatformInfo_CheckToolkitVersion)},
    {SIP_MLNAME_CAST(sipName_Get), meth_wxPlatformInfo_Get, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPlatformInfo_Get)},
    {SIP_MLNAME_CAST(sipName_GetArch), (PyCFunction)meth_wxPlatformInfo_GetArch, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPlatformInfo_GetArch)},
    {SIP_MLNAME_CAST(sipName_GetArchName), meth_wxPlatformInfo_GetArchName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPlatformInfo_GetArchName)},
    {SIP_MLNAME_CAST(sipName_GetArchitecture), meth_wxPlatformInfo_GetArchitecture, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPlatformInfo_GetArchitecture)},
    {SIP_MLNAME_CAST(sipName_GetDesktopEnvironment), meth_wxPlatformInfo_GetDesktopEnvironment, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPlatformInfo_GetDesktopEnvironment)},
    {SIP_MLNAME_CAST(sipName_GetEndianness), meth_wxPlatformInfo_GetEndianness, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPlatformInfo_GetEndianness)},
    {SIP_MLNAME_CAST(sipName_GetEndiannessName), meth_wxPlatformInfo_GetEndiannessName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPlatformInfo_GetEndiannessName)},
    {SIP_MLNAME_CAST(sipName_GetLinuxDistributionInfo), meth_wxPlatformInfo_GetLinuxDistributionInfo, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPlatformInfo_GetLinuxDistributionInfo)},
    {SIP_MLNAME_CAST(sipName_GetOSMajorVersion), meth_wxPlatformInfo_GetOSMajorVersion, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPlatformInfo_GetOSMajorVersion)},
    {SIP_MLNAME_CAST(sipName_GetOSMinorVersion), meth_wxPlatformInfo_GetOSMinorVersion, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPlatformInfo_GetOSMinorVersion)},
    {SIP_MLNAME_CAST(sipName_GetOperatingSystemDescription), meth_wxPlatformInfo_GetOperatingSystemDescription, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPlatformInfo_GetOperatingSystemDescription)},
    {SIP_MLNAME_CAST(sipName_GetOperatingSystemDirectory), meth_wxPlatformInfo_GetOperatingSystemDirectory, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPlatformInfo_GetOperatingSystemDirectory)},
    {SIP_MLNAME_CAST(sipName_GetOperatingSystemFamilyName), meth_wxPlatformInfo_GetOperatingSystemFamilyName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPlatformInfo_GetOperatingSystemFamilyName)},
    {SIP_MLNAME_CAST(sipName_GetOperatingSystemId), meth_wxPlatformInfo_GetOperatingSystemId, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPlatformInfo_GetOperatingSystemId)},
    {SIP_MLNAME_CAST(sipName_GetOperatingSystemIdName), meth_wxPlatformInfo_GetOperatingSystemIdName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPlatformInfo_GetOperatingSystemIdName)},
    {SIP_MLNAME_CAST(sipName_GetPortId), meth_wxPlatformInfo_GetPortId, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPlatformInfo_GetPortId)},
    {SIP_MLNAME_CAST(sipName_GetPortIdName), meth_wxPlatformInfo_GetPortIdName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPlatformInfo_GetPortIdName)},
    {SIP_MLNAME_CAST(sipName_GetPortIdShortName), meth_wxPlatformInfo_GetPortIdShortName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPlatformInfo_GetPortIdShortName)},
    {SIP_MLNAME_CAST(sipName_GetToolkitMajorVersion), meth_wxPlatformInfo_GetToolkitMajorVersion, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPlatformInfo_GetToolkitMajorVersion)},
    {SIP_MLNAME_CAST(sipName_GetToolkitMinorVersion), meth_wxPlatformInfo_GetToolkitMinorVersion, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPlatformInfo_GetToolkitMinorVersion)},
    {SIP_MLNAME_CAST(sipName_IsOk), meth_wxPlatformInfo_IsOk, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPlatformInfo_IsOk)},
    {SIP_MLNAME_CAST(sipName_IsUsingUniversalWidgets), meth_wxPlatformInfo_IsUsingUniversalWidgets, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPlatformInfo_IsUsingUniversalWidgets)},
    {SIP_MLNAME_CAST(sipName_SetArchitecture), (PyCFunction)meth_wxPlatformInfo_SetArchitecture, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPlatformInfo_SetArchitecture)},
    {SIP_MLNAME_CAST(sipName_SetDesktopEnvironment), (PyCFunction)meth_wxPlatformInfo_SetDesktopEnvironment, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPlatformInfo_SetDesktopEnvironment)},
    {SIP_MLNAME_CAST(sipName_SetEndianness), (PyCFunction)meth_wxPlatformInfo_SetEndianness, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPlatformInfo_SetEndianness)},
    {SIP_MLNAME_CAST(sipName_SetLinuxDistributionInfo), (PyCFunction)meth_wxPlatformInfo_SetLinuxDistributionInfo, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPlatformInfo_SetLinuxDistributionInfo)},
    {SIP_MLNAME_CAST(sipName_SetOSVersion), (PyCFunction)meth_wxPlatformInfo_SetOSVersion, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPlatformInfo_SetOSVersion)},
    {SIP_MLNAME_CAST(sipName_SetOperatingSystemDescription), (PyCFunction)meth_wxPlatformInfo_SetOperatingSystemDescription, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPlatformInfo_SetOperatingSystemDescription)},
    {SIP_MLNAME_CAST(sipName_SetOperatingSystemId), (PyCFunction)meth_wxPlatformInfo_SetOperatingSystemId, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPlatformInfo_SetOperatingSystemId)},
    {SIP_MLNAME_CAST(sipName_SetPortId), (PyCFunction)meth_wxPlatformInfo_SetPortId, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPlatformInfo_SetPortId)},
    {SIP_MLNAME_CAST(sipName_SetToolkitVersion), (PyCFunction)meth_wxPlatformInfo_SetToolkitVersion, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPlatformInfo_SetToolkitVersion)}
};

sipVariableDef variables_wxPlatformInfo[] = {
    {PropertyVariable, sipName_ToolkitMinorVersion, &methods_wxPlatformInfo[21], NULL, NULL, NULL},
    {PropertyVariable, sipName_ToolkitMajorVersion, &methods_wxPlatformInfo[20], NULL, NULL, NULL},
    {PropertyVariable, sipName_PortIdShortName, &methods_wxPlatformInfo[19], NULL, NULL, NULL},
    {PropertyVariable, sipName_PortIdName, &methods_wxPlatformInfo[18], NULL, NULL, NULL},
    {PropertyVariable, sipName_PortId, &methods_wxPlatformInfo[17], &methods_wxPlatformInfo[31], NULL, NULL},
    {PropertyVariable, sipName_OperatingSystemIdName, &methods_wxPlatformInfo[16], NULL, NULL, NULL},
    {PropertyVariable, sipName_OperatingSystemId, &methods_wxPlatformInfo[15], &methods_wxPlatformInfo[30], NULL, NULL},
    {PropertyVariable, sipName_OperatingSystemFamilyName, &methods_wxPlatformInfo[14], NULL, NULL, NULL},
    {PropertyVariable, sipName_OperatingSystemDescription, &methods_wxPlatformInfo[12], &methods_wxPlatformInfo[29], NULL, NULL},
    {PropertyVariable, sipName_OSMinorVersion, &methods_wxPlatformInfo[11], NULL, NULL, NULL},
    {PropertyVariable, sipName_OSMajorVersion, &methods_wxPlatformInfo[10], NULL, NULL, NULL},
    {PropertyVariable, sipName_LinuxDistributionInfo, &methods_wxPlatformInfo[9], &methods_wxPlatformInfo[27], NULL, NULL},
    {PropertyVariable, sipName_EndiannessName, &methods_wxPlatformInfo[8], NULL, NULL, NULL},
    {PropertyVariable, sipName_Endianness, &methods_wxPlatformInfo[7], &methods_wxPlatformInfo[26], NULL, NULL},
    {PropertyVariable, sipName_DesktopEnvironment, &methods_wxPlatformInfo[6], &methods_wxPlatformInfo[25], NULL, NULL},
    {PropertyVariable, sipName_Architecture, &methods_wxPlatformInfo[5], &methods_wxPlatformInfo[24], NULL, NULL},
    {PropertyVariable, sipName_ArchName, &methods_wxPlatformInfo[4], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxPlatformInfo, "PlatformInfo()\n"
    "PlatformInfo(pid, tkMajor=-1, tkMinor=-1, id=OS_UNKNOWN, osMajor=-1, osMinor=-1, arch=ARCH_INVALID, endian=ENDIAN_INVALID)\n"
    "\n"
    "This class holds information about the operating system, the toolkit\n"
    "and the basic architecture of the machine where the application is\n"
    "currently running.");


sipClassTypeDef sipTypeDef__core_wxPlatformInfo = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxPlatformInfo,
        {0},
        0
    },
    {
        sipNameNr_PlatformInformation,
        {0, 0, 1},
        33, methods_wxPlatformInfo,
        0, 0,
        17, variables_wxPlatformInfo,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxPlatformInfo,
    -1,
    -1,
    0,
    slots_wxPlatformInfo,
    init_type_wxPlatformInfo,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxPlatformInfo,
    assign_wxPlatformInfo,
    array_wxPlatformInfo,
    copy_wxPlatformInfo,
    release_wxPlatformInfo,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
