/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.1
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/gdicmn.h>

        #include <wx/gdicmn.h>
        #include <wx/gdicmn.h>
    bool _wxSize___eq__(wxSize* self, const wxSize* other)
    {
        return *self == *other;
    }
    bool _wxSize___ne__(wxSize* self, const wxSize* other)
    {
        return *self != *other;
    }
    PyObject* _wxSize_Get(wxSize* self)
    {
        return sipBuildResult(0, "(ii)", self->GetWidth(), self->GetHeight());
    }


PyDoc_STRVAR(doc_wxSize_DecBy, "DecBy(pt)\n"
    "DecBy(size)\n"
    "DecBy(dx, dy)\n"
    "DecBy(d)\n"
    "\n"
    "Decreases the size in both x and y directions.");

extern "C" {static PyObject *meth_wxSize_DecBy(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSize_DecBy(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPoint* pt;
        int ptState = 0;
         ::wxSize *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxSize, &sipCpp, sipType_wxPoint, &pt, &ptState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DecBy(*pt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt),sipType_wxPoint,ptState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxSize* size;
        int sizeState = 0;
         ::wxSize *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxSize, &sipCpp, sipType_wxSize, &size, &sizeState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DecBy(*size);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(size),sipType_wxSize,sizeState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        int dx;
        int dy;
         ::wxSize *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dx,
            sipName_dy,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii", &sipSelf, sipType_wxSize, &sipCpp, &dx, &dy))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DecBy(dx,dy);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        int d;
         ::wxSize *sipCpp;

        static const char *sipKwdList[] = {
            sipName_d,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxSize, &sipCpp, &d))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DecBy(d);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Size, sipName_DecBy, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSize_IncBy, "IncBy(pt)\n"
    "IncBy(size)\n"
    "IncBy(dx, dy)\n"
    "IncBy(d)\n"
    "\n"
    "Increases the size in both x and y directions.");

extern "C" {static PyObject *meth_wxSize_IncBy(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSize_IncBy(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPoint* pt;
        int ptState = 0;
         ::wxSize *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxSize, &sipCpp, sipType_wxPoint, &pt, &ptState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->IncBy(*pt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt),sipType_wxPoint,ptState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxSize* size;
        int sizeState = 0;
         ::wxSize *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxSize, &sipCpp, sipType_wxSize, &size, &sizeState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->IncBy(*size);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(size),sipType_wxSize,sizeState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        int dx;
        int dy;
         ::wxSize *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dx,
            sipName_dy,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii", &sipSelf, sipType_wxSize, &sipCpp, &dx, &dy))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->IncBy(dx,dy);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        int d;
         ::wxSize *sipCpp;

        static const char *sipKwdList[] = {
            sipName_d,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxSize, &sipCpp, &d))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->IncBy(d);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Size, sipName_IncBy, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSize_DecTo, "DecTo(size)\n"
    "\n"
    "Decrements this object so that both of its dimensions are not greater\n"
    "than the corresponding dimensions of the size.");

extern "C" {static PyObject *meth_wxSize_DecTo(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSize_DecTo(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxSize* size;
        int sizeState = 0;
         ::wxSize *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxSize, &sipCpp, sipType_wxSize, &size, &sizeState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DecTo(*size);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(size),sipType_wxSize,sizeState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Size, sipName_DecTo, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSize_DecToIfSpecified, "DecToIfSpecified(size)\n"
    "\n"
    "Decrements this object to be not bigger than the given size ignoring\n"
    "non-specified components.");

extern "C" {static PyObject *meth_wxSize_DecToIfSpecified(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSize_DecToIfSpecified(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxSize* size;
        int sizeState = 0;
         ::wxSize *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxSize, &sipCpp, sipType_wxSize, &size, &sizeState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DecToIfSpecified(*size);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(size),sipType_wxSize,sizeState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Size, sipName_DecToIfSpecified, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSize_GetHeight, "GetHeight() -> int\n"
    "\n"
    "Gets the height member.");

extern "C" {static PyObject *meth_wxSize_GetHeight(PyObject *, PyObject *);}
static PyObject *meth_wxSize_GetHeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxSize *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSize, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetHeight();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Size, sipName_GetHeight, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSize_GetWidth, "GetWidth() -> int\n"
    "\n"
    "Gets the width member.");

extern "C" {static PyObject *meth_wxSize_GetWidth(PyObject *, PyObject *);}
static PyObject *meth_wxSize_GetWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxSize *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSize, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetWidth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Size, sipName_GetWidth, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSize_IncTo, "IncTo(size)\n"
    "\n"
    "Increments this object so that both of its dimensions are not less\n"
    "than the corresponding dimensions of the size.");

extern "C" {static PyObject *meth_wxSize_IncTo(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSize_IncTo(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxSize* size;
        int sizeState = 0;
         ::wxSize *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxSize, &sipCpp, sipType_wxSize, &size, &sizeState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->IncTo(*size);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(size),sipType_wxSize,sizeState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Size, sipName_IncTo, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSize_IsFullySpecified, "IsFullySpecified() -> bool\n"
    "\n"
    "Returns true if neither of the size object components is equal to -1,\n"
    "which is used as default for the size values in wxWidgets (hence the\n"
    "predefined wxDefaultSize has both of its components equal to -1).");

extern "C" {static PyObject *meth_wxSize_IsFullySpecified(PyObject *, PyObject *);}
static PyObject *meth_wxSize_IsFullySpecified(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxSize *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSize, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsFullySpecified();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Size, sipName_IsFullySpecified, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSize_Scale, "Scale(xscale, yscale) -> Size\n"
    "\n"
    "Scales the dimensions of this object by the given factors.");

extern "C" {static PyObject *meth_wxSize_Scale(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSize_Scale(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        float xscale;
        float yscale;
         ::wxSize *sipCpp;

        static const char *sipKwdList[] = {
            sipName_xscale,
            sipName_yscale,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bff", &sipSelf, sipType_wxSize, &sipCpp, &xscale, &yscale))
        {
             ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Scale(xscale,yscale);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxSize,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Size, sipName_Scale, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSize_Set, "Set(width, height)\n"
    "\n"
    "Sets the width and height members.");

extern "C" {static PyObject *meth_wxSize_Set(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSize_Set(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int width;
        int height;
         ::wxSize *sipCpp;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii", &sipSelf, sipType_wxSize, &sipCpp, &width, &height))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Set(width,height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Size, sipName_Set, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSize_SetDefaults, "SetDefaults(sizeDefault)\n"
    "\n"
    "Combine this size object with another one replacing the default (i.e.\n"
    "equal to -1) components of this object with those of the other.");

extern "C" {static PyObject *meth_wxSize_SetDefaults(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSize_SetDefaults(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxSize* sizeDefault;
        int sizeDefaultState = 0;
         ::wxSize *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sizeDefault,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxSize, &sipCpp, sipType_wxSize, &sizeDefault, &sizeDefaultState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDefaults(*sizeDefault);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(sizeDefault),sipType_wxSize,sizeDefaultState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Size, sipName_SetDefaults, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSize_SetHeight, "SetHeight(height)\n"
    "\n"
    "Sets the height.");

extern "C" {static PyObject *meth_wxSize_SetHeight(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSize_SetHeight(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int height;
         ::wxSize *sipCpp;

        static const char *sipKwdList[] = {
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxSize, &sipCpp, &height))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetHeight(height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Size, sipName_SetHeight, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSize_SetWidth, "SetWidth(width)\n"
    "\n"
    "Sets the width.");

extern "C" {static PyObject *meth_wxSize_SetWidth(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSize_SetWidth(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int width;
         ::wxSize *sipCpp;

        static const char *sipKwdList[] = {
            sipName_width,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxSize, &sipCpp, &width))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetWidth(width);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Size, sipName_SetWidth, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxSize_Get, "Get() -> (width, height)\n"
    "\n"
    "Return the width and height properties as a tuple.");

extern "C" {static PyObject *meth_wxSize_Get(PyObject *, PyObject *);}
static PyObject *meth_wxSize_Get(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxSize *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSize, &sipCpp))
        {
            PyObject * sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxSize_Get(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Size, sipName_Get, NULL);

    return NULL;
}


extern "C" {static PyObject *slot_wxSize___div__(PyObject *,PyObject *);}
static PyObject *slot_wxSize___div__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxSize* a0;
        int a0State = 0;
        int i;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1i", sipType_wxSize, &a0, &a0State, &i))
        {
             ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxSize((*a0 / i));
            Py_END_ALLOW_THREADS
            sipReleaseType(a0,sipType_wxSize,a0State);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxSize,NULL);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, div_slot, NULL, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_wxSize___mul__(PyObject *,PyObject *);}
static PyObject *slot_wxSize___mul__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxSize* a0;
        int a0State = 0;
        int i;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1i", sipType_wxSize, &a0, &a0State, &i))
        {
             ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxSize((*a0 * i));
            Py_END_ALLOW_THREADS
            sipReleaseType(a0,sipType_wxSize,a0State);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxSize,NULL);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, mul_slot, NULL, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_wxSize___sub__(PyObject *,PyObject *);}
static PyObject *slot_wxSize___sub__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxSize* a0;
        int a0State = 0;
        const  ::wxSize* other;
        int otherState = 0;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1J1", sipType_wxSize, &a0, &a0State, sipType_wxSize, &other, &otherState))
        {
             ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxSize((*a0 - *other));
            Py_END_ALLOW_THREADS
            sipReleaseType(a0,sipType_wxSize,a0State);
            sipReleaseType(const_cast< ::wxSize *>(other),sipType_wxSize,otherState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxSize,NULL);
        }
    }

    {
         ::wxSize* a0;
        int a0State = 0;
        const  ::wxPoint* other;
        int otherState = 0;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1J1", sipType_wxSize, &a0, &a0State, sipType_wxPoint, &other, &otherState))
        {
             ::wxPoint*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPoint((*a0 - *other));
            Py_END_ALLOW_THREADS
            sipReleaseType(a0,sipType_wxSize,a0State);
            sipReleaseType(const_cast< ::wxPoint *>(other),sipType_wxPoint,otherState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPoint,NULL);
        }
    }

    {
         ::wxSize* a0;
        int a0State = 0;
        const  ::wxRealPoint* other;
        int otherState = 0;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1J1", sipType_wxSize, &a0, &a0State, sipType_wxRealPoint, &other, &otherState))
        {
             ::wxRealPoint*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxRealPoint((*a0 - *other));
            Py_END_ALLOW_THREADS
            sipReleaseType(a0,sipType_wxSize,a0State);
            sipReleaseType(const_cast< ::wxRealPoint *>(other),sipType_wxRealPoint,otherState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxRealPoint,NULL);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, sub_slot, NULL, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_wxSize___add__(PyObject *,PyObject *);}
static PyObject *slot_wxSize___add__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxSize* a0;
        int a0State = 0;
        const  ::wxSize* other;
        int otherState = 0;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1J1", sipType_wxSize, &a0, &a0State, sipType_wxSize, &other, &otherState))
        {
             ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxSize((*a0 + *other));
            Py_END_ALLOW_THREADS
            sipReleaseType(a0,sipType_wxSize,a0State);
            sipReleaseType(const_cast< ::wxSize *>(other),sipType_wxSize,otherState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxSize,NULL);
        }
    }

    {
         ::wxSize* a0;
        int a0State = 0;
        const  ::wxPoint* other;
        int otherState = 0;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1J1", sipType_wxSize, &a0, &a0State, sipType_wxPoint, &other, &otherState))
        {
             ::wxPoint*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPoint((*a0 + *other));
            Py_END_ALLOW_THREADS
            sipReleaseType(a0,sipType_wxSize,a0State);
            sipReleaseType(const_cast< ::wxPoint *>(other),sipType_wxPoint,otherState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPoint,NULL);
        }
    }

    {
         ::wxSize* a0;
        int a0State = 0;
        const  ::wxRealPoint* other;
        int otherState = 0;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1J1", sipType_wxSize, &a0, &a0State, sipType_wxRealPoint, &other, &otherState))
        {
             ::wxRealPoint*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxRealPoint((*a0 + *other));
            Py_END_ALLOW_THREADS
            sipReleaseType(a0,sipType_wxSize,a0State);
            sipReleaseType(const_cast< ::wxRealPoint *>(other),sipType_wxRealPoint,otherState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxRealPoint,NULL);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, add_slot, NULL, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_wxSize___ne__(PyObject *,PyObject *);}
static PyObject *slot_wxSize___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxSize *sipCpp = reinterpret_cast< ::wxSize *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxSize));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxSize* other;
        int otherState = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_wxSize, &other, &otherState))
        {
            bool sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxSize___ne__(sipCpp, other);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxSize *>(other),sipType_wxSize,otherState);

            if (sipIsErr)
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, ne_slot, sipType_wxSize, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxSize___eq__(PyObject *,PyObject *);}
static PyObject *slot_wxSize___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxSize *sipCpp = reinterpret_cast< ::wxSize *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxSize));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxSize* other;
        int otherState = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_wxSize, &other, &otherState))
        {
            bool sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxSize___eq__(sipCpp, other);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxSize *>(other),sipType_wxSize,otherState);

            if (sipIsErr)
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, eq_slot, sipType_wxSize, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxSize___imul__(PyObject *,PyObject *);}
static PyObject *slot_wxSize___imul__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_wxSize)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::wxSize *sipCpp = reinterpret_cast< ::wxSize *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxSize));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        int factor;

        if (sipParseArgs(&sipParseErr, sipArg, "1i", &factor))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp-> ::wxSize::operator*=(factor);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_wxSize___idiv__(PyObject *,PyObject *);}
static PyObject *slot_wxSize___idiv__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_wxSize)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::wxSize *sipCpp = reinterpret_cast< ::wxSize *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxSize));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        int factor;

        if (sipParseArgs(&sipParseErr, sipArg, "1i", &factor))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp-> ::wxSize::operator/=(factor);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_wxSize___isub__(PyObject *,PyObject *);}
static PyObject *slot_wxSize___isub__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_wxSize)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::wxSize *sipCpp = reinterpret_cast< ::wxSize *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxSize));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxSize* sz;
        int szState = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_wxSize, &sz, &szState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp-> ::wxSize::operator-=(*sz);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(sz),sipType_wxSize,szState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_wxSize___iadd__(PyObject *,PyObject *);}
static PyObject *slot_wxSize___iadd__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_wxSize)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::wxSize *sipCpp = reinterpret_cast< ::wxSize *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxSize));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxSize* sz;
        int szState = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_wxSize, &sz, &szState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp-> ::wxSize::operator+=(*sz);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(sz),sipType_wxSize,szState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxSize(void *, int);}
static void release_wxSize(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxSize *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxSize(void *, SIP_SSIZE_T, const void *);}
static void assign_wxSize(void *sipDst, SIP_SSIZE_T sipDstIdx, const void *sipSrc)
{
    reinterpret_cast< ::wxSize *>(sipDst)[sipDstIdx] = *reinterpret_cast<const  ::wxSize *>(sipSrc);
}


extern "C" {static void *array_wxSize(SIP_SSIZE_T);}
static void *array_wxSize(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxSize[sipNrElem];
}


extern "C" {static void *copy_wxSize(const void *, SIP_SSIZE_T);}
static void *copy_wxSize(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxSize(reinterpret_cast<const  ::wxSize *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxSize(sipSimpleWrapper *);}
static void dealloc_wxSize(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxSize(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxSize(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxSize(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxSize *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxSize();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        int width;
        int height;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "ii", &width, &height))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxSize(width,height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxSize* a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J1", sipType_wxSize, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxSize(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(a0),sipType_wxSize,a0State);

            return sipCpp;
        }
    }

    return NULL;
}


extern "C" {static int convertTo_wxSize(PyObject *, void **, int *, PyObject *);}
static int convertTo_wxSize(PyObject *sipPy,void **sipCppPtrV,int *sipIsErr,PyObject *sipTransferObj)
{
     ::wxSize **sipCppPtr = reinterpret_cast< ::wxSize **>(sipCppPtrV);

        // is it just a typecheck?
        if (!sipIsErr) {
            // is it already an instance of wxSize?
            if (sipCanConvertToType(sipPy, sipType_wxSize, SIP_NO_CONVERTORS))
                return 1;
        
            if (wxPyNumberSequenceCheck(sipPy, 2)) {
                return 1;
            }
            return 0;
        }
        
         // otherwise do the conversion
         if (sipCanConvertToType(sipPy, sipType_wxSize, SIP_NO_CONVERTORS)) {
             // Just fetch the existing instance
             *sipCppPtr = reinterpret_cast<wxSize*>(sipConvertToType(
                     sipPy, sipType_wxSize, sipTransferObj, SIP_NO_CONVERTORS, 0, sipIsErr));
             return 0;  // not a new instance
         }
        
         // or create a new instance
         PyObject* o1 = PySequence_ITEM(sipPy, 0);
         PyObject* o2 = PySequence_ITEM(sipPy, 1);
         *sipCppPtr = new wxSize(wxPyInt_AsLong(o1), wxPyInt_AsLong(o2));
         Py_DECREF(o1);
         Py_DECREF(o2);
         return SIP_TEMPORARY;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxSize[] = {
    {(void *)slot_wxSize___div__, div_slot},
    {(void *)slot_wxSize___mul__, mul_slot},
    {(void *)slot_wxSize___sub__, sub_slot},
    {(void *)slot_wxSize___add__, add_slot},
    {(void *)slot_wxSize___ne__, ne_slot},
    {(void *)slot_wxSize___eq__, eq_slot},
    {(void *)slot_wxSize___imul__, imul_slot},
    {(void *)slot_wxSize___idiv__, idiv_slot},
    {(void *)slot_wxSize___isub__, isub_slot},
    {(void *)slot_wxSize___iadd__, iadd_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxSize[] = {
    {SIP_MLNAME_CAST(sipName_DecBy), (PyCFunction)meth_wxSize_DecBy, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxSize_DecBy)},
    {SIP_MLNAME_CAST(sipName_DecTo), (PyCFunction)meth_wxSize_DecTo, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxSize_DecTo)},
    {SIP_MLNAME_CAST(sipName_DecToIfSpecified), (PyCFunction)meth_wxSize_DecToIfSpecified, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxSize_DecToIfSpecified)},
    {SIP_MLNAME_CAST(sipName_Get), meth_wxSize_Get, METH_VARARGS, SIP_MLDOC_CAST(doc_wxSize_Get)},
    {SIP_MLNAME_CAST(sipName_GetHeight), meth_wxSize_GetHeight, METH_VARARGS, SIP_MLDOC_CAST(doc_wxSize_GetHeight)},
    {SIP_MLNAME_CAST(sipName_GetWidth), meth_wxSize_GetWidth, METH_VARARGS, SIP_MLDOC_CAST(doc_wxSize_GetWidth)},
    {SIP_MLNAME_CAST(sipName_IncBy), (PyCFunction)meth_wxSize_IncBy, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxSize_IncBy)},
    {SIP_MLNAME_CAST(sipName_IncTo), (PyCFunction)meth_wxSize_IncTo, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxSize_IncTo)},
    {SIP_MLNAME_CAST(sipName_IsFullySpecified), meth_wxSize_IsFullySpecified, METH_VARARGS, SIP_MLDOC_CAST(doc_wxSize_IsFullySpecified)},
    {SIP_MLNAME_CAST(sipName_Scale), (PyCFunction)meth_wxSize_Scale, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxSize_Scale)},
    {SIP_MLNAME_CAST(sipName_Set), (PyCFunction)meth_wxSize_Set, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxSize_Set)},
    {SIP_MLNAME_CAST(sipName_SetDefaults), (PyCFunction)meth_wxSize_SetDefaults, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxSize_SetDefaults)},
    {SIP_MLNAME_CAST(sipName_SetHeight), (PyCFunction)meth_wxSize_SetHeight, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxSize_SetHeight)},
    {SIP_MLNAME_CAST(sipName_SetWidth), (PyCFunction)meth_wxSize_SetWidth, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxSize_SetWidth)}
};

sipVariableDef variables_wxSize[] = {
    {PropertyVariable, sipName_y, &methods_wxSize[4], &methods_wxSize[12], NULL, NULL},
    {PropertyVariable, sipName_x, &methods_wxSize[5], &methods_wxSize[13], NULL, NULL},
    {PropertyVariable, sipName_height, &methods_wxSize[4], &methods_wxSize[12], NULL, NULL},
    {PropertyVariable, sipName_width, &methods_wxSize[5], &methods_wxSize[13], NULL, NULL},
    {PropertyVariable, sipName_Width, &methods_wxSize[5], &methods_wxSize[13], NULL, NULL},
    {PropertyVariable, sipName_Height, &methods_wxSize[4], &methods_wxSize[12], NULL, NULL},
};

PyDoc_STRVAR(doc_wxSize, "Size()\n"
    "Size(width, height)\n"
    "\n"
    "A wxSize is a useful data structure for graphics operations.");


sipClassTypeDef sipTypeDef__core_wxSize = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxSize,
        {0},
        0
    },
    {
        sipNameNr_Size,
        {0, 0, 1},
        14, methods_wxSize,
        0, 0,
        6, variables_wxSize,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxSize,
    -1,
    -1,
    0,
    slots_wxSize,
    init_type_wxSize,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxSize,
    assign_wxSize,
    array_wxSize,
    copy_wxSize,
    release_wxSize,
    0,
    convertTo_wxSize,
    0,
    0,
    0,
    0,
    0
};
