/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.1
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_html.h"

        #include <wx/html/htmprint.h>

        #include <wx/dc.h>
        #include <wx/object.h>
        #include <wx/object.h>
    void _wxHtmlDCRenderer_SetFonts(wxHtmlDCRenderer* self, const wxString * normal_face, const wxString * fixed_face, const wxArrayInt* sizes)
    {
        if (sizes->GetCount() != 7) {
            wxPyErr_SetString(PyExc_ValueError, "Sequence of 7 integers expected.");
            return;
        }
        self->SetFonts(*normal_face, *fixed_face, &sizes->Item(0));
    }


PyDoc_STRVAR(doc_wxHtmlDCRenderer_GetTotalWidth, "GetTotalWidth() -> int\n"
    "\n"
    "Returns the width of the HTML text in pixels.");

extern "C" {static PyObject *meth_wxHtmlDCRenderer_GetTotalWidth(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlDCRenderer_GetTotalWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlDCRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlDCRenderer, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetTotalWidth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlDCRenderer, sipName_GetTotalWidth, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlDCRenderer_GetTotalHeight, "GetTotalHeight() -> int\n"
    "\n"
    "Returns the height of the HTML text in pixels.");

extern "C" {static PyObject *meth_wxHtmlDCRenderer_GetTotalHeight(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlDCRenderer_GetTotalHeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlDCRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlDCRenderer, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetTotalHeight();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlDCRenderer, sipName_GetTotalHeight, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlDCRenderer_Render, "Render(x, y, known_pagebreaks, from_=0, dont_render=False, to_=INT_MAX) -> int\n"
    "\n"
    "Renders HTML text to the DC.");

extern "C" {static PyObject *meth_wxHtmlDCRenderer_Render(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlDCRenderer_Render(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int x;
        int y;
         ::wxArrayInt* known_pagebreaks;
        int known_pagebreaksState = 0;
        int from_ = 0;
        int dont_render = 0;
        int to_ = INT_MAX;
         ::wxHtmlDCRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_known_pagebreaks,
            sipName_from_,
            sipName_dont_render,
            sipName_to_,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BiiJ1|iii", &sipSelf, sipType_wxHtmlDCRenderer, &sipCpp, &x, &y, sipType_wxArrayInt,&known_pagebreaks, &known_pagebreaksState, &from_, &dont_render, &to_))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Render(x,y,*known_pagebreaks,from_,dont_render,to_);
            Py_END_ALLOW_THREADS
            sipReleaseType(known_pagebreaks,sipType_wxArrayInt,known_pagebreaksState);

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlDCRenderer, sipName_Render, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlDCRenderer_SetDC, "SetDC(dc, pixel_scale=1.0)\n"
    "\n"
    "Assign DC instance to the renderer.");

extern "C" {static PyObject *meth_wxHtmlDCRenderer_SetDC(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlDCRenderer_SetDC(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxDC* dc;
        double pixel_scale = 1;
         ::wxHtmlDCRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dc,
            sipName_pixel_scale,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8|d", &sipSelf, sipType_wxHtmlDCRenderer, &sipCpp, sipType_wxDC, &dc, &pixel_scale))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDC(dc,pixel_scale);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlDCRenderer, sipName_SetDC, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlDCRenderer_SetFonts, "SetFonts(normal_face, fixed_face, sizes)\n"
    "\n"
    "This function sets font sizes and faces.");

extern "C" {static PyObject *meth_wxHtmlDCRenderer_SetFonts(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlDCRenderer_SetFonts(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* normal_face;
        int normal_faceState = 0;
        const  ::wxString* fixed_face;
        int fixed_faceState = 0;
        const  ::wxArrayInt* sizes;
        int sizesState = 0;
         ::wxHtmlDCRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_normal_face,
            sipName_fixed_face,
            sipName_sizes,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1J1", &sipSelf, sipType_wxHtmlDCRenderer, &sipCpp, sipType_wxString,&normal_face, &normal_faceState, sipType_wxString,&fixed_face, &fixed_faceState, sipType_wxArrayInt,&sizes, &sizesState))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxHtmlDCRenderer_SetFonts(sipCpp, normal_face, fixed_face, sizes);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(normal_face),sipType_wxString,normal_faceState);
            sipReleaseType(const_cast< ::wxString *>(fixed_face),sipType_wxString,fixed_faceState);
            sipReleaseType(const_cast< ::wxArrayInt *>(sizes),sipType_wxArrayInt,sizesState);

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlDCRenderer, sipName_SetFonts, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlDCRenderer_SetStandardFonts, "SetStandardFonts(size=-1, normal_face=wx.EmptyString, fixed_face=wx.EmptyString)\n"
    "\n"
    "Sets font sizes to be relative to the given size or the system default\n"
    "size; use either specified or default font.");

extern "C" {static PyObject *meth_wxHtmlDCRenderer_SetStandardFonts(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlDCRenderer_SetStandardFonts(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int size = -1;
        const  ::wxString& normal_facedef = wxEmptyString;
        const  ::wxString* normal_face = &normal_facedef;
        int normal_faceState = 0;
        const  ::wxString& fixed_facedef = wxEmptyString;
        const  ::wxString* fixed_face = &fixed_facedef;
        int fixed_faceState = 0;
         ::wxHtmlDCRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
            sipName_normal_face,
            sipName_fixed_face,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|iJ1J1", &sipSelf, sipType_wxHtmlDCRenderer, &sipCpp, &size, sipType_wxString,&normal_face, &normal_faceState, sipType_wxString,&fixed_face, &fixed_faceState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetStandardFonts(size,*normal_face,*fixed_face);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(normal_face),sipType_wxString,normal_faceState);
            sipReleaseType(const_cast< ::wxString *>(fixed_face),sipType_wxString,fixed_faceState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlDCRenderer, sipName_SetStandardFonts, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlDCRenderer_SetHtmlText, "SetHtmlText(html, basepath=wx.EmptyString, isdir=True)\n"
    "\n"
    "Assign text to the renderer.");

extern "C" {static PyObject *meth_wxHtmlDCRenderer_SetHtmlText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlDCRenderer_SetHtmlText(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* html;
        int htmlState = 0;
        const  ::wxString& basepathdef = wxEmptyString;
        const  ::wxString* basepath = &basepathdef;
        int basepathState = 0;
        bool isdir = 1;
         ::wxHtmlDCRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_html,
            sipName_basepath,
            sipName_isdir,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|J1b", &sipSelf, sipType_wxHtmlDCRenderer, &sipCpp, sipType_wxString,&html, &htmlState, sipType_wxString,&basepath, &basepathState, &isdir))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetHtmlText(*html,*basepath,isdir);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(html),sipType_wxString,htmlState);
            sipReleaseType(const_cast< ::wxString *>(basepath),sipType_wxString,basepathState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlDCRenderer, sipName_SetHtmlText, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlDCRenderer_SetSize, "SetSize(width, height)\n"
    "\n"
    "Set size of output rectangle, in pixels.");

extern "C" {static PyObject *meth_wxHtmlDCRenderer_SetSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlDCRenderer_SetSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int width;
        int height;
         ::wxHtmlDCRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii", &sipSelf, sipType_wxHtmlDCRenderer, &sipCpp, &width, &height))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetSize(width,height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlDCRenderer, sipName_SetSize, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxHtmlDCRenderer(void *, const sipTypeDef *);}
static void *cast_wxHtmlDCRenderer(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxHtmlDCRenderer *sipCpp = reinterpret_cast< ::wxHtmlDCRenderer *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxHtmlDCRenderer(void *, int);}
static void release_wxHtmlDCRenderer(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxHtmlDCRenderer *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxHtmlDCRenderer(sipSimpleWrapper *);}
static void dealloc_wxHtmlDCRenderer(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxHtmlDCRenderer(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxHtmlDCRenderer(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxHtmlDCRenderer(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxHtmlDCRenderer *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxHtmlDCRenderer();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxHtmlDCRenderer[] = {{26, 0, 1}};


static PyMethodDef methods_wxHtmlDCRenderer[] = {
    {SIP_MLNAME_CAST(sipName_GetTotalHeight), meth_wxHtmlDCRenderer_GetTotalHeight, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlDCRenderer_GetTotalHeight)},
    {SIP_MLNAME_CAST(sipName_GetTotalWidth), meth_wxHtmlDCRenderer_GetTotalWidth, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlDCRenderer_GetTotalWidth)},
    {SIP_MLNAME_CAST(sipName_Render), (PyCFunction)meth_wxHtmlDCRenderer_Render, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlDCRenderer_Render)},
    {SIP_MLNAME_CAST(sipName_SetDC), (PyCFunction)meth_wxHtmlDCRenderer_SetDC, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlDCRenderer_SetDC)},
    {SIP_MLNAME_CAST(sipName_SetFonts), (PyCFunction)meth_wxHtmlDCRenderer_SetFonts, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlDCRenderer_SetFonts)},
    {SIP_MLNAME_CAST(sipName_SetHtmlText), (PyCFunction)meth_wxHtmlDCRenderer_SetHtmlText, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlDCRenderer_SetHtmlText)},
    {SIP_MLNAME_CAST(sipName_SetSize), (PyCFunction)meth_wxHtmlDCRenderer_SetSize, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlDCRenderer_SetSize)},
    {SIP_MLNAME_CAST(sipName_SetStandardFonts), (PyCFunction)meth_wxHtmlDCRenderer_SetStandardFonts, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlDCRenderer_SetStandardFonts)}
};

sipVariableDef variables_wxHtmlDCRenderer[] = {
    {PropertyVariable, sipName_TotalWidth, &methods_wxHtmlDCRenderer[1], NULL, NULL, NULL},
    {PropertyVariable, sipName_TotalHeight, &methods_wxHtmlDCRenderer[0], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxHtmlDCRenderer, "HtmlDCRenderer()\n"
    "\n"
    "This class can render HTML document into a specified area of a DC.");


sipClassTypeDef sipTypeDef__html_wxHtmlDCRenderer = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxHtmlDCRenderer,
        {0},
        0
    },
    {
        sipNameNr_HtmlDCRenderer,
        {0, 0, 1},
        8, methods_wxHtmlDCRenderer,
        0, 0,
        2, variables_wxHtmlDCRenderer,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxHtmlDCRenderer,
    -1,
    -1,
    supers_wxHtmlDCRenderer,
    0,
    init_type_wxHtmlDCRenderer,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxHtmlDCRenderer,
    0,
    0,
    0,
    release_wxHtmlDCRenderer,
    cast_wxHtmlDCRenderer,
    0,
    0,
    0,
    0,
    0,
    0
};
