/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.1
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_propgrid.h"

        #include <wx/propgrid/propgridiface.h>

        #include <wx/propgrid/editors.h>
        #include <wx/propgrid/propgridiface.h>
        #include <wx/datetime.h>
        #include <datetime.h>
        #include <wx/object.h>
        #include <wx/validate.h>
        #include <wx/colour.h>
        #include <wx/bitmap.h>
        #include <wx/propgrid/property.h>
        #include <wx/propgrid/propgridpagestate.h>
        #include <wx/propgrid/property.h>
        #include <wx/propgrid/propgridpagestate.h>


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetIterator, "GetIterator(flags=PG_ITERATE_DEFAULT, firstProp=None) -> PropertyGridIterator\n"
    "GetIterator(flags, startPos) -> PropertyGridIterator\n"
    "\n"
    "Returns iterator class instance.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetIterator(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetIterator(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int flags = wxPG_ITERATE_DEFAULT;
         ::wxPGProperty* firstProp = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
            sipName_firstProp,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|iJ8", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, &flags, sipType_wxPGProperty, &firstProp))
        {
             ::wxPropertyGridIterator*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPropertyGridIterator(sipCpp->GetIterator(flags,firstProp));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPropertyGridIterator,NULL);
        }
    }

    {
        int flags;
        int startPos;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
            sipName_startPos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, &flags, &startPos))
        {
             ::wxPropertyGridIterator*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPropertyGridIterator(sipCpp->GetIterator(flags,startPos));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPropertyGridIterator,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetIterator, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_Append, "Append(property) -> PGProperty\n"
    "\n"
    "Appends property to the list.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_Append(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_Append(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxPGProperty* property;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_property,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ:", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGProperty, &property))
        {
             ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Append(property);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPGProperty,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_Append, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_AppendIn, "AppendIn(id, newProperty) -> PGProperty\n"
    "\n"
    "Same as Append(), but appends under given parent property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_AppendIn(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_AppendIn(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
         ::wxPGProperty* newProperty;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_newProperty,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J:", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxPGProperty, &newProperty))
        {
             ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->AppendIn(*id,newProperty);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPGProperty,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_AppendIn, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_BeginAddChildren, "BeginAddChildren(id)\n"
    "\n"
    "In order to add new items into a property with private children (for\n"
    "instance, wxFlagsProperty), you need to call this method.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_BeginAddChildren(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_BeginAddChildren(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->BeginAddChildren(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_BeginAddChildren, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_Clear, "Clear()\n"
    "\n"
    "Deletes all properties.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_Clear(PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_Clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
         ::wxPropertyGridInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_PropertyGridInterface, sipName_Clear);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Clear();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_Clear, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_ClearSelection, "ClearSelection(validation=False) -> bool\n"
    "\n"
    "Clears current selection, if any.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_ClearSelection(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_ClearSelection(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool validation = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_validation,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|b", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, &validation))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ClearSelection(validation);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_ClearSelection, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_ClearModifiedStatus, "ClearModifiedStatus()\n"
    "\n"
    "Resets modified status of all properties.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_ClearModifiedStatus(PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_ClearModifiedStatus(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxPropertyGridInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->ClearModifiedStatus();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_ClearModifiedStatus, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_Collapse, "Collapse(id) -> bool\n"
    "\n"
    "Collapses given category or property with children.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_Collapse(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_Collapse(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Collapse(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_Collapse, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_CollapseAll, "CollapseAll() -> bool\n"
    "\n"
    "Collapses all items that can be collapsed.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_CollapseAll(PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_CollapseAll(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxPropertyGridInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CollapseAll();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_CollapseAll, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_ChangePropertyValue, "ChangePropertyValue(id, newValue) -> bool\n"
    "\n"
    "Changes value of a property, as if by user.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_ChangePropertyValue(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_ChangePropertyValue(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
         ::wxPGVariant* newValue;
        int newValueState = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_newValue,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxPGVariant,&newValue, &newValueState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ChangePropertyValue(*id,*newValue);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);
            sipReleaseType(newValue,sipType_wxPGVariant,newValueState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_ChangePropertyValue, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_DeleteProperty, "DeleteProperty(id)\n"
    "\n"
    "Removes and deletes a property and any children.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_DeleteProperty(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_DeleteProperty(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DeleteProperty(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_DeleteProperty, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_DisableProperty, "DisableProperty(id) -> bool\n"
    "\n"
    "Disables a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_DisableProperty(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_DisableProperty(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->DisableProperty(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_DisableProperty, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_EditorValidate, "EditorValidate() -> bool\n"
    "\n"
    "Returns true if all property grid data changes have been committed.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_EditorValidate(PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_EditorValidate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxPropertyGridInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->EditorValidate();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_EditorValidate, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_EnableProperty, "EnableProperty(id, enable=True) -> bool\n"
    "\n"
    "Enables or disables property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_EnableProperty(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_EnableProperty(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        bool enable = 1;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_enable,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|b", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, &enable))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->EnableProperty(*id,enable);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_EnableProperty, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_EndAddChildren, "EndAddChildren(id)\n"
    "\n"
    "Called after population of property with fixed children has finished.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_EndAddChildren(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_EndAddChildren(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->EndAddChildren(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_EndAddChildren, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_Expand, "Expand(id) -> bool\n"
    "\n"
    "Expands given category or property with children.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_Expand(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_Expand(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Expand(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_Expand, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_ExpandAll, "ExpandAll(expand=True) -> bool\n"
    "\n"
    "Expands all items that can be expanded.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_ExpandAll(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_ExpandAll(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool expand = 1;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_expand,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|b", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, &expand))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ExpandAll(expand);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_ExpandAll, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetColumnProportion, "GetColumnProportion(column) -> int\n"
    "\n"
    "Returns auto-resize proportion of the given column.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetColumnProportion(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetColumnProportion(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        uint column;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_column,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bu", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, &column))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetColumnProportion(column);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetColumnProportion, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetFirstChild, "GetFirstChild(id) -> PGProperty\n"
    "\n"
    "Returns id of first child of given property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetFirstChild(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetFirstChild(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
             ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFirstChild(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPGProperty,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetFirstChild, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetFirst, "GetFirst(flags=PG_ITERATE_ALL) -> PGProperty\n"
    "\n"
    "Returns id of first item that matches given criteria.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetFirst(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetFirst(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int flags = wxPG_ITERATE_ALL;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|i", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, &flags))
        {
             ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFirst(flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPGProperty,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetFirst, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetProperty, "GetProperty(name) -> PGProperty\n"
    "\n"
    "Returns pointer to a property with given name (case-sensitive).");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetProperty(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetProperty(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxString,&name, &nameState))
        {
             ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetProperty(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPGProperty,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetProperty, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertiesWithFlag, "GetPropertiesWithFlag(targetArr, flags, inverse=False, iterFlags=PG_ITERATE_PROPERTIES|PG_ITERATE_HIDDEN|PG_ITERATE_CATEGORIES)\n"
    "\n"
    "Adds to 'targetArr' pointers to properties that have given flags\n"
    "'flags' set.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertiesWithFlag(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertiesWithFlag(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxArrayPGProperty* targetArr;
         ::wxPGProperty::FlagType flags;
        bool inverse = 0;
        int iterFlags = wxPG_ITERATE_PROPERTIES|wxPG_ITERATE_HIDDEN|wxPG_ITERATE_CATEGORIES;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_targetArr,
            sipName_flags,
            sipName_inverse,
            sipName_iterFlags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8u|bi", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxArrayPGProperty, &targetArr, &flags, &inverse, &iterFlags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GetPropertiesWithFlag(targetArr,flags,inverse,iterFlags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertiesWithFlag, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyAttribute, "GetPropertyAttribute(id, attrName) -> PGVariant\n"
    "\n"
    "Returns value of given attribute.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyAttribute(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyAttribute(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxString* attrName;
        int attrNameState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_attrName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxString,&attrName, &attrNameState))
        {
             ::wxPGVariant*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPGVariant(sipCpp->GetPropertyAttribute(*id,*attrName));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);
            sipReleaseType(const_cast< ::wxString *>(attrName),sipType_wxString,attrNameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPGVariant,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyAttribute, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyBackgroundColour, "GetPropertyBackgroundColour(id) -> wx.Colour\n"
    "\n"
    "Returns background colour of first cell of a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyBackgroundColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyBackgroundColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
             ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxColour(sipCpp->GetPropertyBackgroundColour(*id));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxColour,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyBackgroundColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyCategory, "GetPropertyCategory(id) -> PropertyCategory\n"
    "\n"
    "Returns pointer of property's nearest parent category.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyCategory(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyCategory(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
             ::wxPropertyCategory*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyCategory(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPropertyCategory,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyCategory, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyByLabel, "GetPropertyByLabel(label) -> PGProperty\n"
    "\n"
    "Returns first property which label matches given string.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyByLabel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyByLabel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* label;
        int labelState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_label,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxString,&label, &labelState))
        {
             ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyByLabel(*label);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(label),sipType_wxString,labelState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPGProperty,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyByLabel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyByName, "GetPropertyByName(name) -> PGProperty\n"
    "GetPropertyByName(name, subname) -> PGProperty\n"
    "\n"
    "Returns pointer to a property with given name (case-sensitive).");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyByName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyByName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxString,&name, &nameState))
        {
             ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyByName(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPGProperty,NULL);
        }
    }

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxString* subname;
        int subnameState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_subname,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxString,&name, &nameState, sipType_wxString,&subname, &subnameState))
        {
             ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyByName(*name,*subname);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);
            sipReleaseType(const_cast< ::wxString *>(subname),sipType_wxString,subnameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPGProperty,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyByName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyEditor, "GetPropertyEditor(id) -> PGEditor\n"
    "\n"
    "Returns property's editor.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyEditor(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyEditor(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            const  ::wxPGEditor*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyEditor(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(const_cast< ::wxPGEditor *>(sipRes),sipType_wxPGEditor,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyEditor, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyHelpString, "GetPropertyHelpString(id) -> String\n"
    "\n"
    "Returns help string associated with a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyHelpString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyHelpString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetPropertyHelpString(*id));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyHelpString, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyImage, "GetPropertyImage(id) -> wx.Bitmap\n"
    "\n"
    "Returns property's custom value image (NULL of none).");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyImage(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyImage(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
             ::wxBitmap*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyImage(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxBitmap,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyImage, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyLabel, "GetPropertyLabel(id) -> String\n"
    "\n"
    "Returns label of a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyLabel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyLabel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetPropertyLabel(*id));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyLabel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyName, "GetPropertyName(property) -> String\n"
    "\n"
    "Returns property's name, by which it is globally accessible.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxPGProperty* property;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_property,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGProperty, &property))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetPropertyName(property));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyTextColour, "GetPropertyTextColour(id) -> wx.Colour\n"
    "\n"
    "Returns text colour of first cell of a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyTextColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyTextColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
             ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxColour(sipCpp->GetPropertyTextColour(*id));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxColour,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyTextColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyValidator, "GetPropertyValidator(id) -> wx.Validator\n"
    "\n"
    "Returns validator of a property as a reference, which you can pass to\n"
    "any number of SetPropertyValidator.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyValidator(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyValidator(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
             ::wxValidator*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyValidator(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxValidator,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyValidator, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyValue, "GetPropertyValue(id) -> PGVariant\n"
    "\n"
    "Returns property's value as wxVariant.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyValue(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyValue(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
             ::wxPGVariant*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPGVariant(sipCpp->GetPropertyValue(*id));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPGVariant,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyValue, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyValueAsArrayInt, "GetPropertyValueAsArrayInt(id) -> ArrayInt\n"
    "\n"
    "Return's property's value as wxArrayInt.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsArrayInt(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsArrayInt(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
             ::wxArrayInt*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxArrayInt(sipCpp->GetPropertyValueAsArrayInt(*id));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxArrayInt,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyValueAsArrayInt, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyValueAsArrayString, "GetPropertyValueAsArrayString(id) -> ArrayString\n"
    "\n"
    "Returns property's value as wxArrayString.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsArrayString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsArrayString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
             ::wxArrayString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxArrayString(sipCpp->GetPropertyValueAsArrayString(*id));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxArrayString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyValueAsArrayString, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyValueAsBool, "GetPropertyValueAsBool(id) -> bool\n"
    "\n"
    "Returns property's value as bool.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsBool(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsBool(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyValueAsBool(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyValueAsBool, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyValueAsDateTime, "GetPropertyValueAsDateTime(id) -> wx.DateTime\n"
    "\n"
    "Return's property's value as wxDateTime.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsDateTime(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsDateTime(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
             ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDateTime(sipCpp->GetPropertyValueAsDateTime(*id));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyValueAsDateTime, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyValueAsDouble, "GetPropertyValueAsDouble(id) -> double\n"
    "\n"
    "Returns property's value as double-precision floating point number.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsDouble(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsDouble(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            double sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyValueAsDouble(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyValueAsDouble, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyValueAsInt, "GetPropertyValueAsInt(id) -> int\n"
    "\n"
    "Returns property's value as integer.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsInt(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsInt(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyValueAsInt(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyValueAsInt, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyValueAsLong, "GetPropertyValueAsLong(id) -> long\n"
    "\n"
    "Returns property's value as integer.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsLong(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsLong(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyValueAsLong(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyValueAsLong, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyValueAsLongLong, "GetPropertyValueAsLongLong(id) -> LongLong_t\n"
    "\n"
    "Returns property's value as native signed 64-bit integer.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsLongLong(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsLongLong(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            PY_LONG_LONG sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyValueAsLongLong(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLongLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyValueAsLongLong, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyValueAsString, "GetPropertyValueAsString(id) -> String\n"
    "\n"
    "Returns property's value as wxString.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetPropertyValueAsString(*id));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyValueAsString, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyValueAsULong, "GetPropertyValueAsULong(id) -> unsignedlong\n"
    "\n"
    "Returns property's value as unsigned integer.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsULong(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsULong(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            unsigned long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyValueAsULong(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyValueAsULong, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyValueAsULongLong, "GetPropertyValueAsULongLong(id) -> ULongLong_t\n"
    "\n"
    "Returns property's value as native unsigned 64-bit integer.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsULongLong(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsULongLong(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            unsigned PY_LONG_LONG sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyValueAsULongLong(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLongLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyValueAsULongLong, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetSelectedProperties, "GetSelectedProperties() -> ArrayPGProperty\n"
    "\n"
    "Returns list of currently selected properties.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetSelectedProperties(PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetSelectedProperties(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPropertyGridInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp))
        {
             ::wxArrayPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxArrayPGProperty(sipCpp->GetSelectedProperties());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxArrayPGProperty,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetSelectedProperties, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetSelection, "GetSelection() -> PGProperty\n"
    "\n"
    "Returns currently selected property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetSelection(PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetSelection(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPropertyGridInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp))
        {
             ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetSelection();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPGProperty,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetSelection, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetVIterator, "GetVIterator(flags) -> PGVIterator\n"
    "\n"
    "Similar to GetIterator(), but instead returns wxPGVIterator instance,\n"
    "which can be useful for forward-iterating through arbitrary property\n"
    "containers.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetVIterator(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetVIterator(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        int flags;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, &flags))
        {
             ::wxPGVIterator*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPGVIterator((sipSelfWasArg ? sipCpp-> ::wxPropertyGridInterface::GetVIterator(flags) : sipCpp->GetVIterator(flags)));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPGVIterator,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetVIterator, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_HideProperty, "HideProperty(id, hide=True, flags=PG_RECURSE) -> bool\n"
    "\n"
    "Hides or reveals a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_HideProperty(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_HideProperty(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        bool hide = 1;
        int flags = wxPG_RECURSE;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_hide,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|bi", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, &hide, &flags))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HideProperty(*id,hide,flags);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_HideProperty, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_Insert, "Insert(priorThis, newProperty) -> PGProperty\n"
    "Insert(parent, index, newProperty) -> PGProperty\n"
    "\n"
    "Inserts property to the property container.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_Insert(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_Insert(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* priorThis;
        int priorThisState = 0;
         ::wxPGProperty* newProperty;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_priorThis,
            sipName_newProperty,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J:", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &priorThis, &priorThisState, sipType_wxPGProperty, &newProperty))
        {
             ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Insert(*priorThis,newProperty);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(priorThis),sipType_wxPGPropArgCls,priorThisState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPGProperty,NULL);
        }
    }

    {
        const  ::wxPGPropArgCls* parent;
        int parentState = 0;
        int index;
         ::wxPGProperty* newProperty;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_parent,
            sipName_index,
            sipName_newProperty,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1iJ:", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &parent, &parentState, &index, sipType_wxPGProperty, &newProperty))
        {
             ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Insert(*parent,index,newProperty);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(parent),sipType_wxPGPropArgCls,parentState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPGProperty,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_Insert, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_IsPropertyCategory, "IsPropertyCategory(id) -> bool\n"
    "\n"
    "Returns true if property is a category.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_IsPropertyCategory(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_IsPropertyCategory(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsPropertyCategory(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_IsPropertyCategory, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_IsPropertyEnabled, "IsPropertyEnabled(id) -> bool\n"
    "\n"
    "Returns true if property is enabled.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_IsPropertyEnabled(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_IsPropertyEnabled(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsPropertyEnabled(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_IsPropertyEnabled, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_IsPropertyExpanded, "IsPropertyExpanded(id) -> bool\n"
    "\n"
    "Returns true if given property is expanded.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_IsPropertyExpanded(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_IsPropertyExpanded(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsPropertyExpanded(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_IsPropertyExpanded, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_IsPropertyModified, "IsPropertyModified(id) -> bool\n"
    "\n"
    "Returns true if property has been modified after value set or modify\n"
    "flag clear by software.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_IsPropertyModified(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_IsPropertyModified(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsPropertyModified(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_IsPropertyModified, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_IsPropertySelected, "IsPropertySelected(id) -> bool\n"
    "\n"
    "Returns true if property is selected.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_IsPropertySelected(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_IsPropertySelected(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxPropertyGridInterface::IsPropertySelected(*id) : sipCpp->IsPropertySelected(*id));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_IsPropertySelected, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_IsPropertyShown, "IsPropertyShown(id) -> bool\n"
    "\n"
    "Returns true if property is shown (ie.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_IsPropertyShown(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_IsPropertyShown(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsPropertyShown(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_IsPropertyShown, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_IsPropertyValueUnspecified, "IsPropertyValueUnspecified(id) -> bool\n"
    "\n"
    "Returns true if property value is set to unspecified.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_IsPropertyValueUnspecified(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_IsPropertyValueUnspecified(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsPropertyValueUnspecified(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_IsPropertyValueUnspecified, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_LimitPropertyEditing, "LimitPropertyEditing(id, limit=True)\n"
    "\n"
    "Disables (limit = true) or enables (limit = false) wxTextCtrl editor\n"
    "of a property, if it is not the sole mean to edit the value.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_LimitPropertyEditing(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_LimitPropertyEditing(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        bool limit = 1;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_limit,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|b", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, &limit))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->LimitPropertyEditing(*id,limit);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_LimitPropertyEditing, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_RemoveProperty, "RemoveProperty(id) -> PGProperty\n"
    "\n"
    "Removes a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_RemoveProperty(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_RemoveProperty(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
             ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->RemoveProperty(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPGProperty,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_RemoveProperty, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_ReplaceProperty, "ReplaceProperty(id, property) -> PGProperty\n"
    "\n"
    "Replaces property with id with newly created one.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_ReplaceProperty(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_ReplaceProperty(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
         ::wxPGProperty* property;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_property,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J8", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxPGProperty, &property))
        {
             ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ReplaceProperty(*id,property);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPGProperty,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_ReplaceProperty, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_RestoreEditableState, "RestoreEditableState(src, restoreStates=AllStates) -> bool\n"
    "\n"
    "Restores user-editable state.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_RestoreEditableState(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_RestoreEditableState(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* src;
        int srcState = 0;
        int restoreStates =  ::wxPropertyGridInterface::AllStates;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_src,
            sipName_restoreStates,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|i", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxString,&src, &srcState, &restoreStates))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->RestoreEditableState(*src,restoreStates);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(src),sipType_wxString,srcState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_RestoreEditableState, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SaveEditableState, "SaveEditableState(includedStates=AllStates) -> String\n"
    "\n"
    "Used to acquire user-editable state (selected property, expanded\n"
    "properties, scrolled position, splitter positions).");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SaveEditableState(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SaveEditableState(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int includedStates =  ::wxPropertyGridInterface::AllStates;
        const  ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_includedStates,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|i", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, &includedStates))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->SaveEditableState(includedStates));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SaveEditableState, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetColumnProportion, "SetColumnProportion(column, proportion) -> bool\n"
    "\n"
    "Set proportion of a auto-stretchable column.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetColumnProportion(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetColumnProportion(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        uint column;
        int proportion;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_column,
            sipName_proportion,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bui", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, &column, &proportion))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetColumnProportion(column,proportion);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetColumnProportion, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyAttribute, "SetPropertyAttribute(id, attrName, value, argFlags=0)\n"
    "\n"
    "Sets an attribute for this property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyAttribute(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyAttribute(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxString* attrName;
        int attrNameState = 0;
         ::wxPGVariant* value;
        int valueState = 0;
        long argFlags = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_attrName,
            sipName_value,
            sipName_argFlags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1J1|l", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxString,&attrName, &attrNameState, sipType_wxPGVariant,&value, &valueState, &argFlags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyAttribute(*id,*attrName,*value,argFlags);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);
            sipReleaseType(const_cast< ::wxString *>(attrName),sipType_wxString,attrNameState);
            sipReleaseType(value,sipType_wxPGVariant,valueState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyAttribute, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyAttributeAll, "SetPropertyAttributeAll(attrName, value)\n"
    "\n"
    "Sets property attribute for all applicapple properties.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyAttributeAll(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyAttributeAll(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* attrName;
        int attrNameState = 0;
         ::wxPGVariant* value;
        int valueState = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attrName,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxString,&attrName, &attrNameState, sipType_wxPGVariant,&value, &valueState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyAttributeAll(*attrName,*value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(attrName),sipType_wxString,attrNameState);
            sipReleaseType(value,sipType_wxPGVariant,valueState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyAttributeAll, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyBackgroundColour, "SetPropertyBackgroundColour(id, colour, flags=PG_RECURSE)\n"
    "\n"
    "Sets background colour of a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyBackgroundColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyBackgroundColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxColour* colour;
        int colourState = 0;
        int flags = wxPG_RECURSE;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_colour,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1|i", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxColour, &colour, &colourState, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyBackgroundColour(*id,*colour,flags);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);
            sipReleaseType(const_cast< ::wxColour *>(colour),sipType_wxColour,colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyBackgroundColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyCell, "SetPropertyCell(id, column, text=wx.EmptyString, bitmap=wx.NullBitmap, fgCol=wx.NullColour, bgCol=wx.NullColour)\n"
    "\n"
    "Sets text, bitmap, and colours for given column's cell.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyCell(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyCell(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        int column;
        const  ::wxString& textdef = wxEmptyString;
        const  ::wxString* text = &textdef;
        int textState = 0;
        const  ::wxBitmap& bitmapdef = wxNullBitmap;
        const  ::wxBitmap* bitmap = &bitmapdef;
        const  ::wxColour& fgColdef = wxNullColour;
        const  ::wxColour* fgCol = &fgColdef;
        int fgColState = 0;
        const  ::wxColour& bgColdef = wxNullColour;
        const  ::wxColour* bgCol = &bgColdef;
        int bgColState = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_column,
            sipName_text,
            sipName_bitmap,
            sipName_fgCol,
            sipName_bgCol,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1i|J1J9J1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, &column, sipType_wxString,&text, &textState, sipType_wxBitmap, &bitmap, sipType_wxColour, &fgCol, &fgColState, sipType_wxColour, &bgCol, &bgColState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyCell(*id,column,*text,*bitmap,*fgCol,*bgCol);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);
            sipReleaseType(const_cast< ::wxColour *>(fgCol),sipType_wxColour,fgColState);
            sipReleaseType(const_cast< ::wxColour *>(bgCol),sipType_wxColour,bgColState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyCell, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyColoursToDefault, "SetPropertyColoursToDefault(id)\n"
    "\n"
    "Resets text and background colours of given property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyColoursToDefault(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyColoursToDefault(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyColoursToDefault(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyColoursToDefault, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyEditor, "SetPropertyEditor(id, editor)\n"
    "SetPropertyEditor(id, editorName)\n"
    "\n"
    "Sets editor for a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyEditor(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyEditor(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxPGEditor* editor;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_editor,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J8", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxPGEditor, &editor))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyEditor(*id,editor);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxString* editorName;
        int editorNameState = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_editorName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxString,&editorName, &editorNameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyEditor(*id,*editorName);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);
            sipReleaseType(const_cast< ::wxString *>(editorName),sipType_wxString,editorNameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyEditor, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyLabel, "SetPropertyLabel(id, newproplabel)\n"
    "\n"
    "Sets label of a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyLabel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyLabel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxString* newproplabel;
        int newproplabelState = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_newproplabel,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxString,&newproplabel, &newproplabelState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyLabel(*id,*newproplabel);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);
            sipReleaseType(const_cast< ::wxString *>(newproplabel),sipType_wxString,newproplabelState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyLabel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyName, "SetPropertyName(id, newName)\n"
    "\n"
    "Sets name of a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxString* newName;
        int newNameState = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_newName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxString,&newName, &newNameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyName(*id,*newName);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);
            sipReleaseType(const_cast< ::wxString *>(newName),sipType_wxString,newNameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyReadOnly, "SetPropertyReadOnly(id, set=True, flags=PG_RECURSE)\n"
    "\n"
    "Sets property (and, recursively, its children) to have read-only\n"
    "value.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyReadOnly(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyReadOnly(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        bool set = 1;
        int flags = wxPG_RECURSE;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_set,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|bi", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, &set, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyReadOnly(*id,set,flags);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyReadOnly, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyValueUnspecified, "SetPropertyValueUnspecified(id)\n"
    "\n"
    "Sets property's value to unspecified.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyValueUnspecified(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyValueUnspecified(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyValueUnspecified(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyValueUnspecified, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyHelpString, "SetPropertyHelpString(id, helpString)\n"
    "\n"
    "Associates the help string with property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyHelpString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyHelpString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxString* helpString;
        int helpStringState = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_helpString,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxString,&helpString, &helpStringState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyHelpString(*id,*helpString);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);
            sipReleaseType(const_cast< ::wxString *>(helpString),sipType_wxString,helpStringState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyHelpString, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyImage, "SetPropertyImage(id, bmp)\n"
    "\n"
    "Set wxBitmap in front of the value.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyImage(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyImage(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
         ::wxBitmap* bmp;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_bmp,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J9", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxBitmap, &bmp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyImage(*id,*bmp);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyImage, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyMaxLength, "SetPropertyMaxLength(id, maxLen) -> bool\n"
    "\n"
    "Sets max length of property's text.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyMaxLength(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyMaxLength(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        int maxLen;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_maxLen,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1i", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, &maxLen))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetPropertyMaxLength(*id,maxLen);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyMaxLength, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyTextColour, "SetPropertyTextColour(id, colour, flags=PG_RECURSE)\n"
    "\n"
    "Sets text colour of a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyTextColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyTextColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxColour* colour;
        int colourState = 0;
        int flags = wxPG_RECURSE;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_colour,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1|i", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxColour, &colour, &colourState, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyTextColour(*id,*colour,flags);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);
            sipReleaseType(const_cast< ::wxColour *>(colour),sipType_wxColour,colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyTextColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyValidator, "SetPropertyValidator(id, validator)\n"
    "\n"
    "Sets validator of a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyValidator(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyValidator(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxValidator* validator;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_validator,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J9", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxValidator, &validator))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyValidator(*id,*validator);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyValidator, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyValue, "SetPropertyValue(id, value)\n"
    "SetPropertyValue(id, value)\n"
    "SetPropertyValue(id, value)\n"
    "SetPropertyValue(id, value)\n"
    "SetPropertyValue(id, value)\n"
    "SetPropertyValue(id, value)\n"
    "SetPropertyValue(id, value)\n"
    "SetPropertyValue(id, value)\n"
    "\n"
    "Sets value (integer) of a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyValue(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyValue(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        long value;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1l", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, &value))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyValue(*id,value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        double value;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1d", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, &value))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyValue(*id,value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxString* value;
        int valueState = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxString,&value, &valueState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyValue(*id,*value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);
            sipReleaseType(const_cast< ::wxString *>(value),sipType_wxString,valueState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxArrayString* value;
        int valueState = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxArrayString,&value, &valueState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyValue(*id,*value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);
            sipReleaseType(const_cast< ::wxArrayString *>(value),sipType_wxArrayString,valueState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxDateTime* value;
        int valueState = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxDateTime, &value, &valueState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyValue(*id,*value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);
            sipReleaseType(const_cast< ::wxDateTime *>(value),sipType_wxDateTime,valueState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
         ::wxObject* value;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J9", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxObject, &value))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyValue(*id,*value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxArrayInt* value;
        int valueState = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxArrayInt,&value, &valueState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyValue(*id,*value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);
            sipReleaseType(const_cast< ::wxArrayInt *>(value),sipType_wxArrayInt,valueState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
         ::wxPGVariant* value;
        int valueState = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxPGVariant,&value, &valueState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyValue(*id,*value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);
            sipReleaseType(value,sipType_wxPGVariant,valueState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyValue, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyValueString, "SetPropertyValueString(id, value)\n"
    "\n"
    "Sets value (wxString) of a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyValueString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyValueString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        const  ::wxString* value;
        int valueState = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxString,&value, &valueState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyValueString(*id,*value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);
            sipReleaseType(const_cast< ::wxString *>(value),sipType_wxString,valueState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyValueString, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetValidationFailureBehavior, "SetValidationFailureBehavior(vfbFlags)\n"
    "\n"
    "Adjusts how wxPropertyGrid behaves when invalid value is entered in a\n"
    "property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetValidationFailureBehavior(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetValidationFailureBehavior(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int vfbFlags;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_vfbFlags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, &vfbFlags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetValidationFailureBehavior(vfbFlags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetValidationFailureBehavior, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_Sort, "Sort(flags=0)\n"
    "\n"
    "Sorts all properties recursively.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_Sort(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_Sort(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int flags = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|i", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Sort(flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_Sort, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SortChildren, "SortChildren(id, flags=0)\n"
    "\n"
    "Sorts children of a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SortChildren(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SortChildren(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPGPropArgCls* id;
        int idState = 0;
        int flags = 0;
         ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|i", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SortChildren(*id,flags);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPGPropArgCls *>(id),sipType_wxPGPropArgCls,idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SortChildren, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_InitAllTypeHandlers, "InitAllTypeHandlers()\n"
    "\n"
    "Initializes all property types.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_InitAllTypeHandlers(PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_InitAllTypeHandlers(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxPropertyGridInterface::InitAllTypeHandlers();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_InitAllTypeHandlers, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_RegisterAdditionalEditors, "RegisterAdditionalEditors()\n"
    "\n"
    "Initializes additional property editors (SpinCtrl etc.).");

extern "C" {static PyObject *meth_wxPropertyGridInterface_RegisterAdditionalEditors(PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_RegisterAdditionalEditors(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxPropertyGridInterface::RegisterAdditionalEditors();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_RegisterAdditionalEditors, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetBoolChoices, "SetBoolChoices(trueChoice, falseChoice)\n"
    "\n"
    "Sets strings listed in the choice dropdown of a wxBoolProperty.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetBoolChoices(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetBoolChoices(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* trueChoice;
        int trueChoiceState = 0;
        const  ::wxString* falseChoice;
        int falseChoiceState = 0;

        static const char *sipKwdList[] = {
            sipName_trueChoice,
            sipName_falseChoice,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1J1", sipType_wxString,&trueChoice, &trueChoiceState, sipType_wxString,&falseChoice, &falseChoiceState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxPropertyGridInterface::SetBoolChoices(*trueChoice,*falseChoice);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(trueChoice),sipType_wxString,trueChoiceState);
            sipReleaseType(const_cast< ::wxString *>(falseChoice),sipType_wxString,falseChoiceState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetBoolChoices, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetEditorByName, "GetEditorByName(editorName) -> PGEditor\n"
    "\n"
    "Returns editor pointer of editor with given name;.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetEditorByName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetEditorByName(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* editorName;
        int editorNameState = 0;

        static const char *sipKwdList[] = {
            sipName_editorName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&editorName, &editorNameState))
        {
             ::wxPGEditor*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxPropertyGridInterface::GetEditorByName(*editorName);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(editorName),sipType_wxString,editorNameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPGEditor,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetEditorByName, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxPropertyGridInterface(void *, int);}
static void release_wxPropertyGridInterface(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxPropertyGridInterface *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxPropertyGridInterface(sipSimpleWrapper *);}
static void dealloc_wxPropertyGridInterface(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxPropertyGridInterface(sipGetAddress(sipSelf), 0);
    }
}


static PyMethodDef methods_wxPropertyGridInterface[] = {
    {SIP_MLNAME_CAST(sipName_Append), (PyCFunction)meth_wxPropertyGridInterface_Append, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_Append)},
    {SIP_MLNAME_CAST(sipName_AppendIn), (PyCFunction)meth_wxPropertyGridInterface_AppendIn, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_AppendIn)},
    {SIP_MLNAME_CAST(sipName_BeginAddChildren), (PyCFunction)meth_wxPropertyGridInterface_BeginAddChildren, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_BeginAddChildren)},
    {SIP_MLNAME_CAST(sipName_ChangePropertyValue), (PyCFunction)meth_wxPropertyGridInterface_ChangePropertyValue, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_ChangePropertyValue)},
    {SIP_MLNAME_CAST(sipName_Clear), meth_wxPropertyGridInterface_Clear, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_Clear)},
    {SIP_MLNAME_CAST(sipName_ClearModifiedStatus), meth_wxPropertyGridInterface_ClearModifiedStatus, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_ClearModifiedStatus)},
    {SIP_MLNAME_CAST(sipName_ClearSelection), (PyCFunction)meth_wxPropertyGridInterface_ClearSelection, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_ClearSelection)},
    {SIP_MLNAME_CAST(sipName_Collapse), (PyCFunction)meth_wxPropertyGridInterface_Collapse, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_Collapse)},
    {SIP_MLNAME_CAST(sipName_CollapseAll), meth_wxPropertyGridInterface_CollapseAll, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_CollapseAll)},
    {SIP_MLNAME_CAST(sipName_DeleteProperty), (PyCFunction)meth_wxPropertyGridInterface_DeleteProperty, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_DeleteProperty)},
    {SIP_MLNAME_CAST(sipName_DisableProperty), (PyCFunction)meth_wxPropertyGridInterface_DisableProperty, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_DisableProperty)},
    {SIP_MLNAME_CAST(sipName_EditorValidate), meth_wxPropertyGridInterface_EditorValidate, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_EditorValidate)},
    {SIP_MLNAME_CAST(sipName_EnableProperty), (PyCFunction)meth_wxPropertyGridInterface_EnableProperty, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_EnableProperty)},
    {SIP_MLNAME_CAST(sipName_EndAddChildren), (PyCFunction)meth_wxPropertyGridInterface_EndAddChildren, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_EndAddChildren)},
    {SIP_MLNAME_CAST(sipName_Expand), (PyCFunction)meth_wxPropertyGridInterface_Expand, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_Expand)},
    {SIP_MLNAME_CAST(sipName_ExpandAll), (PyCFunction)meth_wxPropertyGridInterface_ExpandAll, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_ExpandAll)},
    {SIP_MLNAME_CAST(sipName_GetColumnProportion), (PyCFunction)meth_wxPropertyGridInterface_GetColumnProportion, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetColumnProportion)},
    {SIP_MLNAME_CAST(sipName_GetEditorByName), (PyCFunction)meth_wxPropertyGridInterface_GetEditorByName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetEditorByName)},
    {SIP_MLNAME_CAST(sipName_GetFirst), (PyCFunction)meth_wxPropertyGridInterface_GetFirst, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetFirst)},
    {SIP_MLNAME_CAST(sipName_GetFirstChild), (PyCFunction)meth_wxPropertyGridInterface_GetFirstChild, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetFirstChild)},
    {SIP_MLNAME_CAST(sipName_GetIterator), (PyCFunction)meth_wxPropertyGridInterface_GetIterator, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetIterator)},
    {SIP_MLNAME_CAST(sipName_GetPropertiesWithFlag), (PyCFunction)meth_wxPropertyGridInterface_GetPropertiesWithFlag, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetPropertiesWithFlag)},
    {SIP_MLNAME_CAST(sipName_GetProperty), (PyCFunction)meth_wxPropertyGridInterface_GetProperty, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetProperty)},
    {SIP_MLNAME_CAST(sipName_GetPropertyAttribute), (PyCFunction)meth_wxPropertyGridInterface_GetPropertyAttribute, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetPropertyAttribute)},
    {SIP_MLNAME_CAST(sipName_GetPropertyBackgroundColour), (PyCFunction)meth_wxPropertyGridInterface_GetPropertyBackgroundColour, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetPropertyBackgroundColour)},
    {SIP_MLNAME_CAST(sipName_GetPropertyByLabel), (PyCFunction)meth_wxPropertyGridInterface_GetPropertyByLabel, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetPropertyByLabel)},
    {SIP_MLNAME_CAST(sipName_GetPropertyByName), (PyCFunction)meth_wxPropertyGridInterface_GetPropertyByName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetPropertyByName)},
    {SIP_MLNAME_CAST(sipName_GetPropertyCategory), (PyCFunction)meth_wxPropertyGridInterface_GetPropertyCategory, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetPropertyCategory)},
    {SIP_MLNAME_CAST(sipName_GetPropertyEditor), (PyCFunction)meth_wxPropertyGridInterface_GetPropertyEditor, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetPropertyEditor)},
    {SIP_MLNAME_CAST(sipName_GetPropertyHelpString), (PyCFunction)meth_wxPropertyGridInterface_GetPropertyHelpString, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetPropertyHelpString)},
    {SIP_MLNAME_CAST(sipName_GetPropertyImage), (PyCFunction)meth_wxPropertyGridInterface_GetPropertyImage, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetPropertyImage)},
    {SIP_MLNAME_CAST(sipName_GetPropertyLabel), (PyCFunction)meth_wxPropertyGridInterface_GetPropertyLabel, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetPropertyLabel)},
    {SIP_MLNAME_CAST(sipName_GetPropertyName), (PyCFunction)meth_wxPropertyGridInterface_GetPropertyName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetPropertyName)},
    {SIP_MLNAME_CAST(sipName_GetPropertyTextColour), (PyCFunction)meth_wxPropertyGridInterface_GetPropertyTextColour, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetPropertyTextColour)},
    {SIP_MLNAME_CAST(sipName_GetPropertyValidator), (PyCFunction)meth_wxPropertyGridInterface_GetPropertyValidator, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetPropertyValidator)},
    {SIP_MLNAME_CAST(sipName_GetPropertyValue), (PyCFunction)meth_wxPropertyGridInterface_GetPropertyValue, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetPropertyValue)},
    {SIP_MLNAME_CAST(sipName_GetPropertyValueAsArrayInt), (PyCFunction)meth_wxPropertyGridInterface_GetPropertyValueAsArrayInt, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetPropertyValueAsArrayInt)},
    {SIP_MLNAME_CAST(sipName_GetPropertyValueAsArrayString), (PyCFunction)meth_wxPropertyGridInterface_GetPropertyValueAsArrayString, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetPropertyValueAsArrayString)},
    {SIP_MLNAME_CAST(sipName_GetPropertyValueAsBool), (PyCFunction)meth_wxPropertyGridInterface_GetPropertyValueAsBool, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetPropertyValueAsBool)},
    {SIP_MLNAME_CAST(sipName_GetPropertyValueAsDateTime), (PyCFunction)meth_wxPropertyGridInterface_GetPropertyValueAsDateTime, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetPropertyValueAsDateTime)},
    {SIP_MLNAME_CAST(sipName_GetPropertyValueAsDouble), (PyCFunction)meth_wxPropertyGridInterface_GetPropertyValueAsDouble, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetPropertyValueAsDouble)},
    {SIP_MLNAME_CAST(sipName_GetPropertyValueAsInt), (PyCFunction)meth_wxPropertyGridInterface_GetPropertyValueAsInt, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetPropertyValueAsInt)},
    {SIP_MLNAME_CAST(sipName_GetPropertyValueAsLong), (PyCFunction)meth_wxPropertyGridInterface_GetPropertyValueAsLong, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetPropertyValueAsLong)},
    {SIP_MLNAME_CAST(sipName_GetPropertyValueAsLongLong), (PyCFunction)meth_wxPropertyGridInterface_GetPropertyValueAsLongLong, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetPropertyValueAsLongLong)},
    {SIP_MLNAME_CAST(sipName_GetPropertyValueAsString), (PyCFunction)meth_wxPropertyGridInterface_GetPropertyValueAsString, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetPropertyValueAsString)},
    {SIP_MLNAME_CAST(sipName_GetPropertyValueAsULong), (PyCFunction)meth_wxPropertyGridInterface_GetPropertyValueAsULong, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetPropertyValueAsULong)},
    {SIP_MLNAME_CAST(sipName_GetPropertyValueAsULongLong), (PyCFunction)meth_wxPropertyGridInterface_GetPropertyValueAsULongLong, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetPropertyValueAsULongLong)},
    {SIP_MLNAME_CAST(sipName_GetSelectedProperties), meth_wxPropertyGridInterface_GetSelectedProperties, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetSelectedProperties)},
    {SIP_MLNAME_CAST(sipName_GetSelection), meth_wxPropertyGridInterface_GetSelection, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetSelection)},
    {SIP_MLNAME_CAST(sipName_GetVIterator), (PyCFunction)meth_wxPropertyGridInterface_GetVIterator, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_GetVIterator)},
    {SIP_MLNAME_CAST(sipName_HideProperty), (PyCFunction)meth_wxPropertyGridInterface_HideProperty, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_HideProperty)},
    {SIP_MLNAME_CAST(sipName_InitAllTypeHandlers), meth_wxPropertyGridInterface_InitAllTypeHandlers, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_InitAllTypeHandlers)},
    {SIP_MLNAME_CAST(sipName_Insert), (PyCFunction)meth_wxPropertyGridInterface_Insert, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_Insert)},
    {SIP_MLNAME_CAST(sipName_IsPropertyCategory), (PyCFunction)meth_wxPropertyGridInterface_IsPropertyCategory, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_IsPropertyCategory)},
    {SIP_MLNAME_CAST(sipName_IsPropertyEnabled), (PyCFunction)meth_wxPropertyGridInterface_IsPropertyEnabled, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_IsPropertyEnabled)},
    {SIP_MLNAME_CAST(sipName_IsPropertyExpanded), (PyCFunction)meth_wxPropertyGridInterface_IsPropertyExpanded, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_IsPropertyExpanded)},
    {SIP_MLNAME_CAST(sipName_IsPropertyModified), (PyCFunction)meth_wxPropertyGridInterface_IsPropertyModified, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_IsPropertyModified)},
    {SIP_MLNAME_CAST(sipName_IsPropertySelected), (PyCFunction)meth_wxPropertyGridInterface_IsPropertySelected, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_IsPropertySelected)},
    {SIP_MLNAME_CAST(sipName_IsPropertyShown), (PyCFunction)meth_wxPropertyGridInterface_IsPropertyShown, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_IsPropertyShown)},
    {SIP_MLNAME_CAST(sipName_IsPropertyValueUnspecified), (PyCFunction)meth_wxPropertyGridInterface_IsPropertyValueUnspecified, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_IsPropertyValueUnspecified)},
    {SIP_MLNAME_CAST(sipName_LimitPropertyEditing), (PyCFunction)meth_wxPropertyGridInterface_LimitPropertyEditing, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_LimitPropertyEditing)},
    {SIP_MLNAME_CAST(sipName_RegisterAdditionalEditors), meth_wxPropertyGridInterface_RegisterAdditionalEditors, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_RegisterAdditionalEditors)},
    {SIP_MLNAME_CAST(sipName_RemoveProperty), (PyCFunction)meth_wxPropertyGridInterface_RemoveProperty, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_RemoveProperty)},
    {SIP_MLNAME_CAST(sipName_ReplaceProperty), (PyCFunction)meth_wxPropertyGridInterface_ReplaceProperty, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_ReplaceProperty)},
    {SIP_MLNAME_CAST(sipName_RestoreEditableState), (PyCFunction)meth_wxPropertyGridInterface_RestoreEditableState, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_RestoreEditableState)},
    {SIP_MLNAME_CAST(sipName_SaveEditableState), (PyCFunction)meth_wxPropertyGridInterface_SaveEditableState, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_SaveEditableState)},
    {SIP_MLNAME_CAST(sipName_SetBoolChoices), (PyCFunction)meth_wxPropertyGridInterface_SetBoolChoices, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_SetBoolChoices)},
    {SIP_MLNAME_CAST(sipName_SetColumnProportion), (PyCFunction)meth_wxPropertyGridInterface_SetColumnProportion, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_SetColumnProportion)},
    {SIP_MLNAME_CAST(sipName_SetPropertyAttribute), (PyCFunction)meth_wxPropertyGridInterface_SetPropertyAttribute, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_SetPropertyAttribute)},
    {SIP_MLNAME_CAST(sipName_SetPropertyAttributeAll), (PyCFunction)meth_wxPropertyGridInterface_SetPropertyAttributeAll, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_SetPropertyAttributeAll)},
    {SIP_MLNAME_CAST(sipName_SetPropertyBackgroundColour), (PyCFunction)meth_wxPropertyGridInterface_SetPropertyBackgroundColour, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_SetPropertyBackgroundColour)},
    {SIP_MLNAME_CAST(sipName_SetPropertyCell), (PyCFunction)meth_wxPropertyGridInterface_SetPropertyCell, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_SetPropertyCell)},
    {SIP_MLNAME_CAST(sipName_SetPropertyColoursToDefault), (PyCFunction)meth_wxPropertyGridInterface_SetPropertyColoursToDefault, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_SetPropertyColoursToDefault)},
    {SIP_MLNAME_CAST(sipName_SetPropertyEditor), (PyCFunction)meth_wxPropertyGridInterface_SetPropertyEditor, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_SetPropertyEditor)},
    {SIP_MLNAME_CAST(sipName_SetPropertyHelpString), (PyCFunction)meth_wxPropertyGridInterface_SetPropertyHelpString, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_SetPropertyHelpString)},
    {SIP_MLNAME_CAST(sipName_SetPropertyImage), (PyCFunction)meth_wxPropertyGridInterface_SetPropertyImage, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_SetPropertyImage)},
    {SIP_MLNAME_CAST(sipName_SetPropertyLabel), (PyCFunction)meth_wxPropertyGridInterface_SetPropertyLabel, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_SetPropertyLabel)},
    {SIP_MLNAME_CAST(sipName_SetPropertyMaxLength), (PyCFunction)meth_wxPropertyGridInterface_SetPropertyMaxLength, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_SetPropertyMaxLength)},
    {SIP_MLNAME_CAST(sipName_SetPropertyName), (PyCFunction)meth_wxPropertyGridInterface_SetPropertyName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_SetPropertyName)},
    {SIP_MLNAME_CAST(sipName_SetPropertyReadOnly), (PyCFunction)meth_wxPropertyGridInterface_SetPropertyReadOnly, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_SetPropertyReadOnly)},
    {SIP_MLNAME_CAST(sipName_SetPropertyTextColour), (PyCFunction)meth_wxPropertyGridInterface_SetPropertyTextColour, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_SetPropertyTextColour)},
    {SIP_MLNAME_CAST(sipName_SetPropertyValidator), (PyCFunction)meth_wxPropertyGridInterface_SetPropertyValidator, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_SetPropertyValidator)},
    {SIP_MLNAME_CAST(sipName_SetPropertyValue), (PyCFunction)meth_wxPropertyGridInterface_SetPropertyValue, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_SetPropertyValue)},
    {SIP_MLNAME_CAST(sipName_SetPropertyValueString), (PyCFunction)meth_wxPropertyGridInterface_SetPropertyValueString, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_SetPropertyValueString)},
    {SIP_MLNAME_CAST(sipName_SetPropertyValueUnspecified), (PyCFunction)meth_wxPropertyGridInterface_SetPropertyValueUnspecified, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_SetPropertyValueUnspecified)},
    {SIP_MLNAME_CAST(sipName_SetValidationFailureBehavior), (PyCFunction)meth_wxPropertyGridInterface_SetValidationFailureBehavior, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_SetValidationFailureBehavior)},
    {SIP_MLNAME_CAST(sipName_Sort), (PyCFunction)meth_wxPropertyGridInterface_Sort, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_Sort)},
    {SIP_MLNAME_CAST(sipName_SortChildren), (PyCFunction)meth_wxPropertyGridInterface_SortChildren, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPropertyGridInterface_SortChildren)}
};

static sipEnumMemberDef enummembers_wxPropertyGridInterface[] = {
    {sipName_AllStates, static_cast<int>( ::wxPropertyGridInterface::AllStates), 66},
    {sipName_DescBoxState, static_cast<int>( ::wxPropertyGridInterface::DescBoxState), 66},
    {sipName_ExpandedState, static_cast<int>( ::wxPropertyGridInterface::ExpandedState), 66},
    {sipName_PageState, static_cast<int>( ::wxPropertyGridInterface::PageState), 66},
    {sipName_ScrollPosState, static_cast<int>( ::wxPropertyGridInterface::ScrollPosState), 66},
    {sipName_SelectionState, static_cast<int>( ::wxPropertyGridInterface::SelectionState), 66},
    {sipName_SplitterPosState, static_cast<int>( ::wxPropertyGridInterface::SplitterPosState), 66},
};

PyDoc_STRVAR(doc_wxPropertyGridInterface, "Most of the shared property manipulation interface shared by\n"
    "wxPropertyGrid, wxPropertyGridPage, and wxPropertyGridManager is\n"
    "defined in this class.");


sipClassTypeDef sipTypeDef__propgrid_wxPropertyGridInterface = {
    {
        -1,
        0,
        0,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxPropertyGridInterface,
        {0},
        0
    },
    {
        sipNameNr_PropertyGridInterface,
        {0, 0, 1},
        88, methods_wxPropertyGridInterface,
        7, enummembers_wxPropertyGridInterface,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxPropertyGridInterface,
    -1,
    -1,
    0,
    0,
    0,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxPropertyGridInterface,
    0,
    0,
    0,
    release_wxPropertyGridInterface,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
