/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.1
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"

        #include <wx/richtext/richtextbuffer.h>

        #include <wx/richtext/richtextbuffer.h>
    #include <wxpy_api.h>
        #include <wx/dataobj.h>
        #include <wx/dataobj.h>


class sipwxRichTextBufferDataObject : public  ::wxRichTextBufferDataObject
{
public:
    sipwxRichTextBufferDataObject( ::wxRichTextBuffer*);
    virtual ~sipwxRichTextBufferDataObject();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    bool SetData(const  ::wxDataFormat&, ::size_t,const void*);
     ::wxDataFormat GetPreferredFormat( ::wxDataObject::Direction) const;
     ::size_t GetFormatCount( ::wxDataObject::Direction) const;
     ::size_t GetDataSize(const  ::wxDataFormat&) const;
    bool GetDataHere(const  ::wxDataFormat&,void*) const;
    void GetAllFormats( ::wxDataFormat*, ::wxDataObject::Direction) const;
    bool GetDataHere(void*) const;
     ::size_t GetDataSize() const;
    bool SetData( ::size_t,const void*);

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxRichTextBufferDataObject(const sipwxRichTextBufferDataObject &);
    sipwxRichTextBufferDataObject &operator = (const sipwxRichTextBufferDataObject &);

    char sipPyMethods[9];
};

sipwxRichTextBufferDataObject::sipwxRichTextBufferDataObject( ::wxRichTextBuffer*richTextBuffer):  ::wxRichTextBufferDataObject(richTextBuffer), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxRichTextBufferDataObject::~sipwxRichTextBufferDataObject()
{
    sipCommonDtor(sipPySelf);
}

bool sipwxRichTextBufferDataObject::SetData(const  ::wxDataFormat& format, ::size_t len,const void*buf)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[0],sipPySelf,NULL,sipName_SetData);

    if (!sipMeth)
        return  ::wxRichTextBufferDataObject::SetData(format,len,buf);

    extern bool sipVH__richtext_123(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxDataFormat&, ::size_t,const void*);

    return sipVH__richtext_123(sipGILState, 0, sipPySelf, sipMeth, format, len, buf);
}

 ::wxDataFormat sipwxRichTextBufferDataObject::GetPreferredFormat( ::wxDataObject::Direction dir) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[1]),sipPySelf,NULL,sipName_GetPreferredFormat);

    if (!sipMeth)
        return  ::wxRichTextBufferDataObject::GetPreferredFormat(dir);

    extern  ::wxDataFormat sipVH__richtext_122(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxDataObject::Direction);

    return sipVH__richtext_122(sipGILState, 0, sipPySelf, sipMeth, dir);
}

 ::size_t sipwxRichTextBufferDataObject::GetFormatCount( ::wxDataObject::Direction dir) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[2]),sipPySelf,NULL,sipName_GetFormatCount);

    if (!sipMeth)
        return  ::wxRichTextBufferDataObject::GetFormatCount(dir);

    extern  ::size_t sipVH__richtext_121(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxDataObject::Direction);

    return sipVH__richtext_121(sipGILState, 0, sipPySelf, sipMeth, dir);
}

 ::size_t sipwxRichTextBufferDataObject::GetDataSize(const  ::wxDataFormat& format) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[3]),sipPySelf,NULL,sipName_GetDataSize);

    if (!sipMeth)
        return  ::wxRichTextBufferDataObject::GetDataSize(format);

    extern  ::size_t sipVH__richtext_120(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxDataFormat&);

    return sipVH__richtext_120(sipGILState, 0, sipPySelf, sipMeth, format);
}

bool sipwxRichTextBufferDataObject::GetDataHere(const  ::wxDataFormat& format,void*buf) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[4]),sipPySelf,NULL,sipName_GetDataHere);

    if (!sipMeth)
        return  ::wxRichTextBufferDataObject::GetDataHere(format,buf);

    extern bool sipVH__richtext_119(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxDataFormat&,void*);

    return sipVH__richtext_119(sipGILState, 0, sipPySelf, sipMeth, format, buf);
}

void sipwxRichTextBufferDataObject::GetAllFormats( ::wxDataFormat*formats, ::wxDataObject::Direction dir) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[5]),sipPySelf,NULL,sipName_GetAllFormats);

    if (!sipMeth)
    {
         ::wxRichTextBufferDataObject::GetAllFormats(formats,dir);
        return;
    }

    extern void sipVH__richtext_118(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxDataFormat*, ::wxDataObject::Direction);

    sipVH__richtext_118(sipGILState, 0, sipPySelf, sipMeth, formats, dir);
}

bool sipwxRichTextBufferDataObject::GetDataHere(void*buf) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[6]),sipPySelf,NULL,sipName_GetDataHere);

    if (!sipMeth)
        return  ::wxRichTextBufferDataObject::GetDataHere(buf);

    extern bool sipVH__richtext_117(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, void*);

    return sipVH__richtext_117(sipGILState, 0, sipPySelf, sipMeth, buf);
}

 ::size_t sipwxRichTextBufferDataObject::GetDataSize() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[7]),sipPySelf,NULL,sipName_GetDataSize);

    if (!sipMeth)
        return  ::wxRichTextBufferDataObject::GetDataSize();

    extern  ::size_t sipVH__richtext_99(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__richtext_99(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxRichTextBufferDataObject::SetData( ::size_t len,const void*buf)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[8],sipPySelf,NULL,sipName_SetData);

    if (!sipMeth)
        return  ::wxRichTextBufferDataObject::SetData(len,buf);

    extern bool sipVH__richtext_116(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::size_t,const void*);

    return sipVH__richtext_116(sipGILState, 0, sipPySelf, sipMeth, len, buf);
}


PyDoc_STRVAR(doc_wxRichTextBufferDataObject_GetRichTextBuffer, "GetRichTextBuffer() -> RichTextBuffer\n"
    "\n"
    "After a call to this function, the buffer is owned by the caller and\n"
    "it is responsible for deleting it.");

extern "C" {static PyObject *meth_wxRichTextBufferDataObject_GetRichTextBuffer(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextBufferDataObject_GetRichTextBuffer(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextBufferDataObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextBufferDataObject, &sipCpp))
        {
             ::wxRichTextBuffer*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetRichTextBuffer();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxRichTextBuffer,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextBufferDataObject, sipName_GetRichTextBuffer, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextBufferDataObject_GetPreferredFormat, "GetPreferredFormat(dir) -> wx.DataFormat\n"
    "\n"
    "Returns the preferred format for either rendering the data (if dir is\n"
    "Get, its default value) or for setting it.");

extern "C" {static PyObject *meth_wxRichTextBufferDataObject_GetPreferredFormat(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextBufferDataObject_GetPreferredFormat(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxDataObject::Direction dir;
        const  ::wxRichTextBufferDataObject *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dir,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxRichTextBufferDataObject, &sipCpp, sipType_wxDataObject_Direction, &dir))
        {
             ::wxDataFormat*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDataFormat((sipSelfWasArg ? sipCpp-> ::wxRichTextBufferDataObject::GetPreferredFormat(dir) : sipCpp->GetPreferredFormat(dir)));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDataFormat,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextBufferDataObject, sipName_GetPreferredFormat, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextBufferDataObject_GetDataSize, "GetDataSize() -> size_t\n"
    "GetDataSize(format) -> size_t\n"
    "\n"
    "Gets the size of our data.");

extern "C" {static PyObject *meth_wxRichTextBufferDataObject_GetDataSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextBufferDataObject_GetDataSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxRichTextBufferDataObject *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, "B", &sipSelf, sipType_wxRichTextBufferDataObject, &sipCpp))
        {
             ::size_t*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::size_t((sipSelfWasArg ? sipCpp-> ::wxRichTextBufferDataObject::GetDataSize() : sipCpp->GetDataSize()));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_size_t,NULL);
        }
    }

    {
        const  ::wxDataFormat* format;
        const  ::wxRichTextBufferDataObject *sipCpp;

        static const char *sipKwdList[] = {
            sipName_format,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxRichTextBufferDataObject, &sipCpp, sipType_wxDataFormat, &format))
        {
             ::size_t*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::size_t((sipSelfWasArg ? sipCpp-> ::wxRichTextBufferDataObject::GetDataSize(*format) : sipCpp->GetDataSize(*format)));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_size_t,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextBufferDataObject, sipName_GetDataSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextBufferDataObject_GetDataHere, "GetDataHere(buf) -> bool\n"
    "GetDataHere(format, buf) -> bool\n"
    "\n"
    "Copy the data to the buffer, return true on success.");

extern "C" {static PyObject *meth_wxRichTextBufferDataObject_GetDataHere(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextBufferDataObject_GetDataHere(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        void* buf;
        const  ::wxRichTextBufferDataObject *sipCpp;

        static const char *sipKwdList[] = {
            sipName_buf,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bv", &sipSelf, sipType_wxRichTextBufferDataObject, &sipCpp, &buf))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxRichTextBufferDataObject::GetDataHere(buf) : sipCpp->GetDataHere(buf));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxDataFormat* format;
        void* buf;
        const  ::wxRichTextBufferDataObject *sipCpp;

        static const char *sipKwdList[] = {
            sipName_format,
            sipName_buf,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9v", &sipSelf, sipType_wxRichTextBufferDataObject, &sipCpp, sipType_wxDataFormat, &format, &buf))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxRichTextBufferDataObject::GetDataHere(*format,buf) : sipCpp->GetDataHere(*format,buf));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextBufferDataObject, sipName_GetDataHere, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextBufferDataObject_SetData, "SetData(len, buf) -> bool\n"
    "SetData(format, len, buf) -> bool\n"
    "\n"
    "Copy the data from the buffer, return true on success.");

extern "C" {static PyObject *meth_wxRichTextBufferDataObject_SetData(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextBufferDataObject_SetData(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::size_t* len;
        int lenState = 0;
        const void* buf;
         ::wxRichTextBufferDataObject *sipCpp;

        static const char *sipKwdList[] = {
            sipName_len,
            sipName_buf,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1v", &sipSelf, sipType_wxRichTextBufferDataObject, &sipCpp, sipType_size_t,&len, &lenState, &buf))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxRichTextBufferDataObject::SetData(*len,buf) : sipCpp->SetData(*len,buf));
            Py_END_ALLOW_THREADS
            sipReleaseType(len,sipType_size_t,lenState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxDataFormat* format;
         ::size_t* len;
        int lenState = 0;
        const void* buf;
         ::wxRichTextBufferDataObject *sipCpp;

        static const char *sipKwdList[] = {
            sipName_format,
            sipName_len,
            sipName_buf,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9J1v", &sipSelf, sipType_wxRichTextBufferDataObject, &sipCpp, sipType_wxDataFormat, &format, sipType_size_t,&len, &lenState, &buf))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxRichTextBufferDataObject::SetData(*format,*len,buf) : sipCpp->SetData(*format,*len,buf));
            Py_END_ALLOW_THREADS
            sipReleaseType(len,sipType_size_t,lenState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextBufferDataObject, sipName_SetData, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextBufferDataObject_GetRichTextBufferFormatId, "GetRichTextBufferFormatId() -> Char\n"
    "\n"
    "Returns the id for the new data format.");

extern "C" {static PyObject *meth_wxRichTextBufferDataObject_GetRichTextBufferFormatId(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextBufferDataObject_GetRichTextBufferFormatId(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            const  ::wxChar*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxRichTextBufferDataObject::GetRichTextBufferFormatId();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            if (sipRes == NULL)
            {
                Py_INCREF(Py_None);
                return Py_None;
            }

            return PyUnicode_FromWideChar(sipRes,(SIP_SSIZE_T)wcslen(sipRes));
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextBufferDataObject, sipName_GetRichTextBufferFormatId, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxRichTextBufferDataObject(void *, const sipTypeDef *);}
static void *cast_wxRichTextBufferDataObject(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxRichTextBufferDataObject *sipCpp = reinterpret_cast< ::wxRichTextBufferDataObject *>(sipCppV);

    if (targetType == sipType_wxDataObjectSimple)
        return static_cast< ::wxDataObjectSimple *>(sipCpp);

    if (targetType == sipType_wxDataObject)
        return static_cast< ::wxDataObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxRichTextBufferDataObject(void *, int);}
static void release_wxRichTextBufferDataObject(void *sipCppV, int sipIsDerived)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipIsDerived)
        delete reinterpret_cast<sipwxRichTextBufferDataObject *>(sipCppV);
    else
        delete reinterpret_cast< ::wxRichTextBufferDataObject *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxRichTextBufferDataObject(sipSimpleWrapper *);}
static void dealloc_wxRichTextBufferDataObject(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxRichTextBufferDataObject *>(sipGetAddress(sipSelf))->sipPySelf = NULL;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxRichTextBufferDataObject(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxRichTextBufferDataObject(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxRichTextBufferDataObject(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxRichTextBufferDataObject *sipCpp = 0;

    {
         ::wxRichTextBuffer* richTextBuffer = 0;

        static const char *sipKwdList[] = {
            sipName_richTextBuffer,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J8", sipType_wxRichTextBuffer, &richTextBuffer))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxRichTextBufferDataObject(richTextBuffer);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxRichTextBufferDataObject[] = {{21, 0, 1}};


static PyMethodDef methods_wxRichTextBufferDataObject[] = {
    {SIP_MLNAME_CAST(sipName_GetDataHere), (PyCFunction)meth_wxRichTextBufferDataObject_GetDataHere, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextBufferDataObject_GetDataHere)},
    {SIP_MLNAME_CAST(sipName_GetDataSize), (PyCFunction)meth_wxRichTextBufferDataObject_GetDataSize, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextBufferDataObject_GetDataSize)},
    {SIP_MLNAME_CAST(sipName_GetPreferredFormat), (PyCFunction)meth_wxRichTextBufferDataObject_GetPreferredFormat, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextBufferDataObject_GetPreferredFormat)},
    {SIP_MLNAME_CAST(sipName_GetRichTextBuffer), meth_wxRichTextBufferDataObject_GetRichTextBuffer, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextBufferDataObject_GetRichTextBuffer)},
    {SIP_MLNAME_CAST(sipName_GetRichTextBufferFormatId), meth_wxRichTextBufferDataObject_GetRichTextBufferFormatId, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextBufferDataObject_GetRichTextBufferFormatId)},
    {SIP_MLNAME_CAST(sipName_SetData), (PyCFunction)meth_wxRichTextBufferDataObject_SetData, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextBufferDataObject_SetData)}
};

sipVariableDef variables_wxRichTextBufferDataObject[] = {
    {PropertyVariable, sipName_RichTextBuffer, &methods_wxRichTextBufferDataObject[3], NULL, NULL, NULL},
    {PropertyVariable, sipName_DataSize, &methods_wxRichTextBufferDataObject[1], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxRichTextBufferDataObject, "RichTextBufferDataObject(richTextBuffer=None)\n"
    "\n"
    "Implements a rich text data object for clipboard transfer.");


sipClassTypeDef sipTypeDef__richtext_wxRichTextBufferDataObject = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxRichTextBufferDataObject,
        {0},
        0
    },
    {
        sipNameNr_RichTextBufferDataObject,
        {0, 0, 1},
        6, methods_wxRichTextBufferDataObject,
        0, 0,
        2, variables_wxRichTextBufferDataObject,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxRichTextBufferDataObject,
    -1,
    -1,
    supers_wxRichTextBufferDataObject,
    0,
    init_type_wxRichTextBufferDataObject,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxRichTextBufferDataObject,
    0,
    0,
    0,
    release_wxRichTextBufferDataObject,
    cast_wxRichTextBufferDataObject,
    0,
    0,
    0,
    0,
    0,
    0
};
