/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.1
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"

        #include <wx/richtext/richtextbuffer.h>

        #include <wx/richtext/richtextbuffer.h>
        #include <wx/stream.h>
        #include <wx/stream.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxRichTextFileHandler : public  ::wxRichTextFileHandler
{
public:
    sipwxRichTextFileHandler(const  ::wxString&,const  ::wxString&,int);
    sipwxRichTextFileHandler(const  ::wxRichTextFileHandler&);
    virtual ~sipwxRichTextFileHandler();

    /*
     * There is a public method for every protected method visible from
     * this class.
     */
    bool sipProtect_DoLoadFile( ::wxRichTextBuffer*, ::wxInputStream&);
    bool sipProtect_DoSaveFile( ::wxRichTextBuffer*, ::wxOutputStream&);

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    bool DoSaveFile( ::wxRichTextBuffer*, ::wxOutputStream&);
    bool DoLoadFile( ::wxRichTextBuffer*, ::wxInputStream&);
    void SetVisible(bool);
    bool IsVisible() const;
    bool CanLoad() const;
    bool CanSave() const;
    bool CanHandle(const  ::wxString&) const;
    bool SaveFile( ::wxRichTextBuffer*,const  ::wxString&);
    bool LoadFile( ::wxRichTextBuffer*,const  ::wxString&);

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxRichTextFileHandler(const sipwxRichTextFileHandler &);
    sipwxRichTextFileHandler &operator = (const sipwxRichTextFileHandler &);

    char sipPyMethods[9];
};

sipwxRichTextFileHandler::sipwxRichTextFileHandler(const  ::wxString& name,const  ::wxString& ext,int type):  ::wxRichTextFileHandler(name,ext,type), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxRichTextFileHandler::sipwxRichTextFileHandler(const  ::wxRichTextFileHandler& a0):  ::wxRichTextFileHandler(a0), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxRichTextFileHandler::~sipwxRichTextFileHandler()
{
    sipCommonDtor(sipPySelf);
}

bool sipwxRichTextFileHandler::DoSaveFile( ::wxRichTextBuffer*buffer, ::wxOutputStream& stream)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[0],sipPySelf,sipName_RichTextFileHandler,sipName_DoSaveFile);

    if (!sipMeth)
        return 0;

    extern bool sipVH__richtext_109(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxRichTextBuffer*, ::wxOutputStream&);

    return sipVH__richtext_109(sipGILState, 0, sipPySelf, sipMeth, buffer, stream);
}

bool sipwxRichTextFileHandler::DoLoadFile( ::wxRichTextBuffer*buffer, ::wxInputStream& stream)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[1],sipPySelf,sipName_RichTextFileHandler,sipName_DoLoadFile);

    if (!sipMeth)
        return 0;

    extern bool sipVH__richtext_108(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxRichTextBuffer*, ::wxInputStream&);

    return sipVH__richtext_108(sipGILState, 0, sipPySelf, sipMeth, buffer, stream);
}

void sipwxRichTextFileHandler::SetVisible(bool visible)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[2],sipPySelf,NULL,sipName_SetVisible);

    if (!sipMeth)
    {
         ::wxRichTextFileHandler::SetVisible(visible);
        return;
    }

    extern void sipVH__richtext_33(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, bool);

    sipVH__richtext_33(sipGILState, 0, sipPySelf, sipMeth, visible);
}

bool sipwxRichTextFileHandler::IsVisible() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[3]),sipPySelf,NULL,sipName_IsVisible);

    if (!sipMeth)
        return  ::wxRichTextFileHandler::IsVisible();

    extern bool sipVH__richtext_9(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__richtext_9(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxRichTextFileHandler::CanLoad() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[4]),sipPySelf,NULL,sipName_CanLoad);

    if (!sipMeth)
        return  ::wxRichTextFileHandler::CanLoad();

    extern bool sipVH__richtext_9(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__richtext_9(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxRichTextFileHandler::CanSave() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[5]),sipPySelf,NULL,sipName_CanSave);

    if (!sipMeth)
        return  ::wxRichTextFileHandler::CanSave();

    extern bool sipVH__richtext_9(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__richtext_9(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxRichTextFileHandler::CanHandle(const  ::wxString& filename) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[6]),sipPySelf,NULL,sipName_CanHandle);

    if (!sipMeth)
        return  ::wxRichTextFileHandler::CanHandle(filename);

    extern bool sipVH__richtext_95(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&);

    return sipVH__richtext_95(sipGILState, 0, sipPySelf, sipMeth, filename);
}

bool sipwxRichTextFileHandler::SaveFile( ::wxRichTextBuffer*buffer,const  ::wxString& filename)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[7],sipPySelf,NULL,sipName_SaveFile);

    if (!sipMeth)
        return  ::wxRichTextFileHandler::SaveFile(buffer,filename);

    extern bool sipVH__richtext_107(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxRichTextBuffer*,const  ::wxString&);

    return sipVH__richtext_107(sipGILState, 0, sipPySelf, sipMeth, buffer, filename);
}

bool sipwxRichTextFileHandler::LoadFile( ::wxRichTextBuffer*buffer,const  ::wxString& filename)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[8],sipPySelf,NULL,sipName_LoadFile);

    if (!sipMeth)
        return  ::wxRichTextFileHandler::LoadFile(buffer,filename);

    extern bool sipVH__richtext_107(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxRichTextBuffer*,const  ::wxString&);

    return sipVH__richtext_107(sipGILState, 0, sipPySelf, sipMeth, buffer, filename);
}

bool sipwxRichTextFileHandler::sipProtect_DoLoadFile( ::wxRichTextBuffer*buffer, ::wxInputStream& stream)
{
    return DoLoadFile(buffer,stream);
}

bool sipwxRichTextFileHandler::sipProtect_DoSaveFile( ::wxRichTextBuffer*buffer, ::wxOutputStream& stream)
{
    return DoSaveFile(buffer,stream);
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_LoadFile, "LoadFile(buffer, stream) -> bool\n"
    "LoadFile(buffer, filename) -> bool\n"
    "\n"
    "Loads the buffer from a stream.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_LoadFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_LoadFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxRichTextBuffer* buffer;
         ::wxInputStream* stream;
        int streamState = 0;
         ::wxRichTextFileHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_buffer,
            sipName_stream,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8J1", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp, sipType_wxRichTextBuffer, &buffer, sipType_wxInputStream, &stream, &streamState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadFile(buffer,*stream);
            Py_END_ALLOW_THREADS
            sipReleaseType(stream,sipType_wxInputStream,streamState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
         ::wxRichTextBuffer* buffer;
        const  ::wxString* filename;
        int filenameState = 0;
         ::wxRichTextFileHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_buffer,
            sipName_filename,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8J1", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp, sipType_wxRichTextBuffer, &buffer, sipType_wxString,&filename, &filenameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxRichTextFileHandler::LoadFile(buffer,*filename) : sipCpp->LoadFile(buffer,*filename));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(filename),sipType_wxString,filenameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_LoadFile, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_SaveFile, "SaveFile(buffer, stream) -> bool\n"
    "SaveFile(buffer, filename) -> bool\n"
    "\n"
    "Saves the buffer to a stream.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_SaveFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_SaveFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxRichTextBuffer* buffer;
         ::wxOutputStream* stream;
        int streamState = 0;
         ::wxRichTextFileHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_buffer,
            sipName_stream,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8J1", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp, sipType_wxRichTextBuffer, &buffer, sipType_wxOutputStream, &stream, &streamState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SaveFile(buffer,*stream);
            Py_END_ALLOW_THREADS
            sipReleaseType(stream,sipType_wxOutputStream,streamState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
         ::wxRichTextBuffer* buffer;
        const  ::wxString* filename;
        int filenameState = 0;
         ::wxRichTextFileHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_buffer,
            sipName_filename,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8J1", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp, sipType_wxRichTextBuffer, &buffer, sipType_wxString,&filename, &filenameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxRichTextFileHandler::SaveFile(buffer,*filename) : sipCpp->SaveFile(buffer,*filename));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(filename),sipType_wxString,filenameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_SaveFile, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_CanHandle, "CanHandle(filename) -> bool\n"
    "\n"
    "Returns true if we handle this filename (if using files).");

extern "C" {static PyObject *meth_wxRichTextFileHandler_CanHandle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_CanHandle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* filename;
        int filenameState = 0;
        const  ::wxRichTextFileHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_filename,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp, sipType_wxString,&filename, &filenameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxRichTextFileHandler::CanHandle(*filename) : sipCpp->CanHandle(*filename));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(filename),sipType_wxString,filenameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_CanHandle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_CanSave, "CanSave() -> bool\n"
    "\n"
    "Returns true if we can save using this handler.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_CanSave(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_CanSave(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxRichTextFileHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxRichTextFileHandler::CanSave() : sipCpp->CanSave());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_CanSave, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_CanLoad, "CanLoad() -> bool\n"
    "\n"
    "Returns true if we can load using this handler.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_CanLoad(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_CanLoad(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxRichTextFileHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxRichTextFileHandler::CanLoad() : sipCpp->CanLoad());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_CanLoad, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_IsVisible, "IsVisible() -> bool\n"
    "\n"
    "Returns true if this handler should be visible to the user.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_IsVisible(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_IsVisible(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxRichTextFileHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxRichTextFileHandler::IsVisible() : sipCpp->IsVisible());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_IsVisible, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_SetVisible, "SetVisible(visible)\n"
    "\n"
    "Sets whether the handler should be visible to the user (via the\n"
    "application's load and save dialogs).");

extern "C" {static PyObject *meth_wxRichTextFileHandler_SetVisible(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_SetVisible(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        bool visible;
         ::wxRichTextFileHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_visible,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bb", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp, &visible))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxRichTextFileHandler::SetVisible(visible) : sipCpp->SetVisible(visible));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_SetVisible, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_SetName, "SetName(name)\n"
    "\n"
    "Sets the name of the handler.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_SetName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_SetName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxRichTextFileHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp, sipType_wxString,&name, &nameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetName(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_SetName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_GetName, "GetName() -> String\n"
    "\n"
    "Returns the name of the handler.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_GetName(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_GetName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextFileHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_GetName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_SetExtension, "SetExtension(ext)\n"
    "\n"
    "Sets the default extension to recognise.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_SetExtension(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_SetExtension(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* ext;
        int extState = 0;
         ::wxRichTextFileHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ext,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp, sipType_wxString,&ext, &extState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetExtension(*ext);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(ext),sipType_wxString,extState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_SetExtension, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_GetExtension, "GetExtension() -> String\n"
    "\n"
    "Returns the default extension to recognise.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_GetExtension(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_GetExtension(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextFileHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetExtension());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_GetExtension, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_SetType, "SetType(type)\n"
    "\n"
    "Sets the handler type.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_SetType(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_SetType(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int type;
         ::wxRichTextFileHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_type,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp, &type))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetType(type);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_SetType, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_GetType, "GetType() -> int\n"
    "\n"
    "Returns the handler type.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_GetType(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_GetType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextFileHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetType();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_GetType, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_SetFlags, "SetFlags(flags)\n"
    "\n"
    "Sets flags that change the behaviour of loading or saving.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_SetFlags(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_SetFlags(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int flags;
         ::wxRichTextFileHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFlags(flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_SetFlags, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_GetFlags, "GetFlags() -> int\n"
    "\n"
    "Returns flags controlling how loading and saving is done.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_GetFlags(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_GetFlags(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextFileHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFlags();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_GetFlags, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_SetEncoding, "SetEncoding(encoding)\n"
    "\n"
    "Sets the encoding to use when saving a file.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_SetEncoding(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_SetEncoding(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* encoding;
        int encodingState = 0;
         ::wxRichTextFileHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_encoding,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp, sipType_wxString,&encoding, &encodingState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetEncoding(*encoding);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(encoding),sipType_wxString,encodingState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_SetEncoding, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_GetEncoding, "GetEncoding() -> String\n"
    "\n"
    "Returns the encoding to use when saving a file.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_GetEncoding(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_GetEncoding(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextFileHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetEncoding());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_GetEncoding, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_DoLoadFile, "DoLoadFile(buffer, stream) -> bool\n"
    "\n"
    "Override to load content from stream into buffer.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_DoLoadFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_DoLoadFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
         ::wxRichTextBuffer* buffer;
         ::wxInputStream* stream;
        int streamState = 0;
        sipwxRichTextFileHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_buffer,
            sipName_stream,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8J1", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp, sipType_wxRichTextBuffer, &buffer, sipType_wxInputStream, &stream, &streamState))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_RichTextFileHandler, sipName_DoLoadFile);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtect_DoLoadFile(buffer,*stream);
            Py_END_ALLOW_THREADS
            sipReleaseType(stream,sipType_wxInputStream,streamState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_DoLoadFile, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_DoSaveFile, "DoSaveFile(buffer, stream) -> bool\n"
    "\n"
    "Override to save content to stream from buffer.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_DoSaveFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_DoSaveFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
         ::wxRichTextBuffer* buffer;
         ::wxOutputStream* stream;
        int streamState = 0;
        sipwxRichTextFileHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_buffer,
            sipName_stream,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8J1", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp, sipType_wxRichTextBuffer, &buffer, sipType_wxOutputStream, &stream, &streamState))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_RichTextFileHandler, sipName_DoSaveFile);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtect_DoSaveFile(buffer,*stream);
            Py_END_ALLOW_THREADS
            sipReleaseType(stream,sipType_wxOutputStream,streamState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_DoSaveFile, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxRichTextFileHandler(void *, const sipTypeDef *);}
static void *cast_wxRichTextFileHandler(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxRichTextFileHandler *sipCpp = reinterpret_cast< ::wxRichTextFileHandler *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxRichTextFileHandler(void *, int);}
static void release_wxRichTextFileHandler(void *sipCppV, int sipIsDerived)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipIsDerived)
        delete reinterpret_cast<sipwxRichTextFileHandler *>(sipCppV);
    else
        delete reinterpret_cast< ::wxRichTextFileHandler *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxRichTextFileHandler(sipSimpleWrapper *);}
static void dealloc_wxRichTextFileHandler(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxRichTextFileHandler *>(sipGetAddress(sipSelf))->sipPySelf = NULL;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxRichTextFileHandler(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxRichTextFileHandler(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxRichTextFileHandler(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxRichTextFileHandler *sipCpp = 0;

    {
        const  ::wxString& namedef = wxEmptyString;
        const  ::wxString* name = &namedef;
        int nameState = 0;
        const  ::wxString& extdef = wxEmptyString;
        const  ::wxString* ext = &extdef;
        int extState = 0;
        int type = 0;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_ext,
            sipName_type,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J1J1i", sipType_wxString,&name, &nameState, sipType_wxString,&ext, &extState, &type))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxRichTextFileHandler(*name,*ext,type);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);
            sipReleaseType(const_cast< ::wxString *>(ext),sipType_wxString,extState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxRichTextFileHandler* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxRichTextFileHandler, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxRichTextFileHandler(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxRichTextFileHandler[] = {{42, 0, 1}};


static PyMethodDef methods_wxRichTextFileHandler[] = {
    {SIP_MLNAME_CAST(sipName_CanHandle), (PyCFunction)meth_wxRichTextFileHandler_CanHandle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextFileHandler_CanHandle)},
    {SIP_MLNAME_CAST(sipName_CanLoad), meth_wxRichTextFileHandler_CanLoad, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextFileHandler_CanLoad)},
    {SIP_MLNAME_CAST(sipName_CanSave), meth_wxRichTextFileHandler_CanSave, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextFileHandler_CanSave)},
    {SIP_MLNAME_CAST(sipName_DoLoadFile), (PyCFunction)meth_wxRichTextFileHandler_DoLoadFile, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextFileHandler_DoLoadFile)},
    {SIP_MLNAME_CAST(sipName_DoSaveFile), (PyCFunction)meth_wxRichTextFileHandler_DoSaveFile, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextFileHandler_DoSaveFile)},
    {SIP_MLNAME_CAST(sipName_GetEncoding), meth_wxRichTextFileHandler_GetEncoding, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextFileHandler_GetEncoding)},
    {SIP_MLNAME_CAST(sipName_GetExtension), meth_wxRichTextFileHandler_GetExtension, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextFileHandler_GetExtension)},
    {SIP_MLNAME_CAST(sipName_GetFlags), meth_wxRichTextFileHandler_GetFlags, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextFileHandler_GetFlags)},
    {SIP_MLNAME_CAST(sipName_GetName), meth_wxRichTextFileHandler_GetName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextFileHandler_GetName)},
    {SIP_MLNAME_CAST(sipName_GetType), meth_wxRichTextFileHandler_GetType, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextFileHandler_GetType)},
    {SIP_MLNAME_CAST(sipName_IsVisible), meth_wxRichTextFileHandler_IsVisible, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextFileHandler_IsVisible)},
    {SIP_MLNAME_CAST(sipName_LoadFile), (PyCFunction)meth_wxRichTextFileHandler_LoadFile, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextFileHandler_LoadFile)},
    {SIP_MLNAME_CAST(sipName_SaveFile), (PyCFunction)meth_wxRichTextFileHandler_SaveFile, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextFileHandler_SaveFile)},
    {SIP_MLNAME_CAST(sipName_SetEncoding), (PyCFunction)meth_wxRichTextFileHandler_SetEncoding, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextFileHandler_SetEncoding)},
    {SIP_MLNAME_CAST(sipName_SetExtension), (PyCFunction)meth_wxRichTextFileHandler_SetExtension, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextFileHandler_SetExtension)},
    {SIP_MLNAME_CAST(sipName_SetFlags), (PyCFunction)meth_wxRichTextFileHandler_SetFlags, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextFileHandler_SetFlags)},
    {SIP_MLNAME_CAST(sipName_SetName), (PyCFunction)meth_wxRichTextFileHandler_SetName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextFileHandler_SetName)},
    {SIP_MLNAME_CAST(sipName_SetType), (PyCFunction)meth_wxRichTextFileHandler_SetType, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextFileHandler_SetType)},
    {SIP_MLNAME_CAST(sipName_SetVisible), (PyCFunction)meth_wxRichTextFileHandler_SetVisible, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextFileHandler_SetVisible)}
};

sipVariableDef variables_wxRichTextFileHandler[] = {
    {PropertyVariable, sipName_Type, &methods_wxRichTextFileHandler[9], &methods_wxRichTextFileHandler[17], NULL, NULL},
    {PropertyVariable, sipName_Name, &methods_wxRichTextFileHandler[8], &methods_wxRichTextFileHandler[16], NULL, NULL},
    {PropertyVariable, sipName_Flags, &methods_wxRichTextFileHandler[7], &methods_wxRichTextFileHandler[15], NULL, NULL},
    {PropertyVariable, sipName_Extension, &methods_wxRichTextFileHandler[6], &methods_wxRichTextFileHandler[14], NULL, NULL},
    {PropertyVariable, sipName_Encoding, &methods_wxRichTextFileHandler[5], &methods_wxRichTextFileHandler[13], NULL, NULL},
};

PyDoc_STRVAR(doc_wxRichTextFileHandler, "RichTextFileHandler(name=wx.EmptyString, ext=wx.EmptyString, type=0)\n"
    "\n"
    "The base class for file handlers.");


sipClassTypeDef sipTypeDef__richtext_wxRichTextFileHandler = {
    {
        -1,
        0,
        0,
        SIP_TYPE_ABSTRACT|SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxRichTextFileHandler,
        {0},
        0
    },
    {
        sipNameNr_RichTextFileHandler,
        {0, 0, 1},
        19, methods_wxRichTextFileHandler,
        0, 0,
        5, variables_wxRichTextFileHandler,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxRichTextFileHandler,
    -1,
    -1,
    supers_wxRichTextFileHandler,
    0,
    init_type_wxRichTextFileHandler,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxRichTextFileHandler,
    0,
    0,
    0,
    release_wxRichTextFileHandler,
    cast_wxRichTextFileHandler,
    0,
    0,
    0,
    0,
    0,
    0
};
