/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.1
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"

        #include <wx/richtext/richtextstyles.h>

        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextstyles.h>
    #include <wxpy_api.h>
        #include <wx/richtext/richtextstyles.h>
        #include <wx/richtext/richtextstyles.h>
        #include <wx/richtext/richtextstyles.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxRichTextStyleSheet : public  ::wxRichTextStyleSheet
{
public:
    sipwxRichTextStyleSheet();
    sipwxRichTextStyleSheet(const  ::wxRichTextStyleSheet&);
    ~sipwxRichTextStyleSheet();

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxRichTextStyleSheet(const sipwxRichTextStyleSheet &);
    sipwxRichTextStyleSheet &operator = (const sipwxRichTextStyleSheet &);
};

sipwxRichTextStyleSheet::sipwxRichTextStyleSheet():  ::wxRichTextStyleSheet(), sipPySelf(0)
{
}

sipwxRichTextStyleSheet::sipwxRichTextStyleSheet(const  ::wxRichTextStyleSheet& a0):  ::wxRichTextStyleSheet(a0), sipPySelf(0)
{
}

sipwxRichTextStyleSheet::~sipwxRichTextStyleSheet()
{
    sipCommonDtor(sipPySelf);
}


PyDoc_STRVAR(doc_wxRichTextStyleSheet_AddCharacterStyle, "AddCharacterStyle(styleDef) -> bool\n"
    "\n"
    "Adds a definition to the character style list.");

extern "C" {static PyObject *meth_wxRichTextStyleSheet_AddCharacterStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleSheet_AddCharacterStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextCharacterStyleDefinition* styleDef;
         ::wxRichTextStyleSheet *sipCpp;

        static const char *sipKwdList[] = {
            sipName_styleDef,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ:", &sipSelf, sipType_wxRichTextStyleSheet, &sipCpp, sipType_wxRichTextCharacterStyleDefinition, &styleDef))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->AddCharacterStyle(styleDef);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleSheet, sipName_AddCharacterStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleSheet_AddListStyle, "AddListStyle(styleDef) -> bool\n"
    "\n"
    "Adds a definition to the list style list.");

extern "C" {static PyObject *meth_wxRichTextStyleSheet_AddListStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleSheet_AddListStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextListStyleDefinition* styleDef;
         ::wxRichTextStyleSheet *sipCpp;

        static const char *sipKwdList[] = {
            sipName_styleDef,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ:", &sipSelf, sipType_wxRichTextStyleSheet, &sipCpp, sipType_wxRichTextListStyleDefinition, &styleDef))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->AddListStyle(styleDef);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleSheet, sipName_AddListStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleSheet_AddParagraphStyle, "AddParagraphStyle(styleDef) -> bool\n"
    "\n"
    "Adds a definition to the paragraph style list.");

extern "C" {static PyObject *meth_wxRichTextStyleSheet_AddParagraphStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleSheet_AddParagraphStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextParagraphStyleDefinition* styleDef;
         ::wxRichTextStyleSheet *sipCpp;

        static const char *sipKwdList[] = {
            sipName_styleDef,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ:", &sipSelf, sipType_wxRichTextStyleSheet, &sipCpp, sipType_wxRichTextParagraphStyleDefinition, &styleDef))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->AddParagraphStyle(styleDef);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleSheet, sipName_AddParagraphStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleSheet_AddStyle, "AddStyle(styleDef) -> bool\n"
    "\n"
    "Adds a definition to the appropriate style list.");

extern "C" {static PyObject *meth_wxRichTextStyleSheet_AddStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleSheet_AddStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextStyleDefinition* styleDef;
         ::wxRichTextStyleSheet *sipCpp;

        static const char *sipKwdList[] = {
            sipName_styleDef,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ:", &sipSelf, sipType_wxRichTextStyleSheet, &sipCpp, sipType_wxRichTextStyleDefinition, &styleDef))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->AddStyle(styleDef);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleSheet, sipName_AddStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleSheet_DeleteStyles, "DeleteStyles()\n"
    "\n"
    "Deletes all styles.");

extern "C" {static PyObject *meth_wxRichTextStyleSheet_DeleteStyles(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleSheet_DeleteStyles(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextStyleSheet *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextStyleSheet, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DeleteStyles();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleSheet, sipName_DeleteStyles, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleSheet_FindCharacterStyle, "FindCharacterStyle(name, recurse=True) -> RichTextCharacterStyleDefinition\n"
    "\n"
    "Finds a character definition by name.");

extern "C" {static PyObject *meth_wxRichTextStyleSheet_FindCharacterStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleSheet_FindCharacterStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
        bool recurse = 1;
        const  ::wxRichTextStyleSheet *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_recurse,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|b", &sipSelf, sipType_wxRichTextStyleSheet, &sipCpp, sipType_wxString,&name, &nameState, &recurse))
        {
             ::wxRichTextCharacterStyleDefinition*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->FindCharacterStyle(*name,recurse);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxRichTextCharacterStyleDefinition,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleSheet, sipName_FindCharacterStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleSheet_FindListStyle, "FindListStyle(name, recurse=True) -> RichTextListStyleDefinition\n"
    "\n"
    "Finds a list definition by name.");

extern "C" {static PyObject *meth_wxRichTextStyleSheet_FindListStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleSheet_FindListStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
        bool recurse = 1;
        const  ::wxRichTextStyleSheet *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_recurse,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|b", &sipSelf, sipType_wxRichTextStyleSheet, &sipCpp, sipType_wxString,&name, &nameState, &recurse))
        {
             ::wxRichTextListStyleDefinition*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->FindListStyle(*name,recurse);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxRichTextListStyleDefinition,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleSheet, sipName_FindListStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleSheet_FindParagraphStyle, "FindParagraphStyle(name, recurse=True) -> RichTextParagraphStyleDefinition\n"
    "\n"
    "Finds a paragraph definition by name.");

extern "C" {static PyObject *meth_wxRichTextStyleSheet_FindParagraphStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleSheet_FindParagraphStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
        bool recurse = 1;
        const  ::wxRichTextStyleSheet *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_recurse,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|b", &sipSelf, sipType_wxRichTextStyleSheet, &sipCpp, sipType_wxString,&name, &nameState, &recurse))
        {
             ::wxRichTextParagraphStyleDefinition*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->FindParagraphStyle(*name,recurse);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxRichTextParagraphStyleDefinition,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleSheet, sipName_FindParagraphStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleSheet_FindStyle, "FindStyle(name) -> RichTextStyleDefinition\n"
    "\n"
    "Finds a style definition by name.");

extern "C" {static PyObject *meth_wxRichTextStyleSheet_FindStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleSheet_FindStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxRichTextStyleSheet *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxRichTextStyleSheet, &sipCpp, sipType_wxString,&name, &nameState))
        {
             ::wxRichTextStyleDefinition*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->FindStyle(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxRichTextStyleDefinition,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleSheet, sipName_FindStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleSheet_GetCharacterStyle, "GetCharacterStyle(n) -> RichTextCharacterStyleDefinition\n"
    "\n"
    "Returns the nth character style.");

extern "C" {static PyObject *meth_wxRichTextStyleSheet_GetCharacterStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleSheet_GetCharacterStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::size_t* n;
        int nState = 0;
        const  ::wxRichTextStyleSheet *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxRichTextStyleSheet, &sipCpp, sipType_size_t,&n, &nState))
        {
             ::wxRichTextCharacterStyleDefinition*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetCharacterStyle(*n);
            Py_END_ALLOW_THREADS
            sipReleaseType(n,sipType_size_t,nState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxRichTextCharacterStyleDefinition,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleSheet, sipName_GetCharacterStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleSheet_GetCharacterStyleCount, "GetCharacterStyleCount() -> size_t\n"
    "\n"
    "Returns the number of character styles.");

extern "C" {static PyObject *meth_wxRichTextStyleSheet_GetCharacterStyleCount(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleSheet_GetCharacterStyleCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextStyleSheet *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextStyleSheet, &sipCpp))
        {
             ::size_t*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::size_t(sipCpp->GetCharacterStyleCount());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_size_t,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleSheet, sipName_GetCharacterStyleCount, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleSheet_GetDescription, "GetDescription() -> String\n"
    "\n"
    "Returns the style sheet's description.");

extern "C" {static PyObject *meth_wxRichTextStyleSheet_GetDescription(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleSheet_GetDescription(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextStyleSheet *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextStyleSheet, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetDescription());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleSheet, sipName_GetDescription, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleSheet_GetListStyle, "GetListStyle(n) -> RichTextListStyleDefinition\n"
    "\n"
    "Returns the nth list style.");

extern "C" {static PyObject *meth_wxRichTextStyleSheet_GetListStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleSheet_GetListStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::size_t* n;
        int nState = 0;
        const  ::wxRichTextStyleSheet *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxRichTextStyleSheet, &sipCpp, sipType_size_t,&n, &nState))
        {
             ::wxRichTextListStyleDefinition*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetListStyle(*n);
            Py_END_ALLOW_THREADS
            sipReleaseType(n,sipType_size_t,nState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxRichTextListStyleDefinition,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleSheet, sipName_GetListStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleSheet_GetListStyleCount, "GetListStyleCount() -> size_t\n"
    "\n"
    "Returns the number of list styles.");

extern "C" {static PyObject *meth_wxRichTextStyleSheet_GetListStyleCount(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleSheet_GetListStyleCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextStyleSheet *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextStyleSheet, &sipCpp))
        {
             ::size_t*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::size_t(sipCpp->GetListStyleCount());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_size_t,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleSheet, sipName_GetListStyleCount, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleSheet_GetName, "GetName() -> String\n"
    "\n"
    "Returns the style sheet's name.");

extern "C" {static PyObject *meth_wxRichTextStyleSheet_GetName(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleSheet_GetName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextStyleSheet *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextStyleSheet, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleSheet, sipName_GetName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleSheet_GetParagraphStyle, "GetParagraphStyle(n) -> RichTextParagraphStyleDefinition\n"
    "\n"
    "Returns the nth paragraph style.");

extern "C" {static PyObject *meth_wxRichTextStyleSheet_GetParagraphStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleSheet_GetParagraphStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::size_t* n;
        int nState = 0;
        const  ::wxRichTextStyleSheet *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxRichTextStyleSheet, &sipCpp, sipType_size_t,&n, &nState))
        {
             ::wxRichTextParagraphStyleDefinition*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetParagraphStyle(*n);
            Py_END_ALLOW_THREADS
            sipReleaseType(n,sipType_size_t,nState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxRichTextParagraphStyleDefinition,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleSheet, sipName_GetParagraphStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleSheet_GetParagraphStyleCount, "GetParagraphStyleCount() -> size_t\n"
    "\n"
    "Returns the number of paragraph styles.");

extern "C" {static PyObject *meth_wxRichTextStyleSheet_GetParagraphStyleCount(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleSheet_GetParagraphStyleCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextStyleSheet *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextStyleSheet, &sipCpp))
        {
             ::size_t*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::size_t(sipCpp->GetParagraphStyleCount());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_size_t,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleSheet, sipName_GetParagraphStyleCount, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleSheet_RemoveCharacterStyle, "RemoveCharacterStyle(styleDef, deleteStyle=False) -> bool\n"
    "\n"
    "Removes a character style.");

extern "C" {static PyObject *meth_wxRichTextStyleSheet_RemoveCharacterStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleSheet_RemoveCharacterStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextStyleDefinition* styleDef;
        bool deleteStyle = 0;
         ::wxRichTextStyleSheet *sipCpp;

        static const char *sipKwdList[] = {
            sipName_styleDef,
            sipName_deleteStyle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8|b", &sipSelf, sipType_wxRichTextStyleSheet, &sipCpp, sipType_wxRichTextStyleDefinition, &styleDef, &deleteStyle))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->RemoveCharacterStyle(styleDef,deleteStyle);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleSheet, sipName_RemoveCharacterStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleSheet_RemoveListStyle, "RemoveListStyle(styleDef, deleteStyle=False) -> bool\n"
    "\n"
    "Removes a list style.");

extern "C" {static PyObject *meth_wxRichTextStyleSheet_RemoveListStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleSheet_RemoveListStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextStyleDefinition* styleDef;
        bool deleteStyle = 0;
         ::wxRichTextStyleSheet *sipCpp;

        static const char *sipKwdList[] = {
            sipName_styleDef,
            sipName_deleteStyle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8|b", &sipSelf, sipType_wxRichTextStyleSheet, &sipCpp, sipType_wxRichTextStyleDefinition, &styleDef, &deleteStyle))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->RemoveListStyle(styleDef,deleteStyle);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleSheet, sipName_RemoveListStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleSheet_RemoveParagraphStyle, "RemoveParagraphStyle(styleDef, deleteStyle=False) -> bool\n"
    "\n"
    "Removes a paragraph style.");

extern "C" {static PyObject *meth_wxRichTextStyleSheet_RemoveParagraphStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleSheet_RemoveParagraphStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextStyleDefinition* styleDef;
        bool deleteStyle = 0;
         ::wxRichTextStyleSheet *sipCpp;

        static const char *sipKwdList[] = {
            sipName_styleDef,
            sipName_deleteStyle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8|b", &sipSelf, sipType_wxRichTextStyleSheet, &sipCpp, sipType_wxRichTextStyleDefinition, &styleDef, &deleteStyle))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->RemoveParagraphStyle(styleDef,deleteStyle);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleSheet, sipName_RemoveParagraphStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleSheet_RemoveStyle, "RemoveStyle(styleDef, deleteStyle=False) -> bool\n"
    "\n"
    "Removes a style.");

extern "C" {static PyObject *meth_wxRichTextStyleSheet_RemoveStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleSheet_RemoveStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextStyleDefinition* styleDef;
        bool deleteStyle = 0;
         ::wxRichTextStyleSheet *sipCpp;

        static const char *sipKwdList[] = {
            sipName_styleDef,
            sipName_deleteStyle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8|b", &sipSelf, sipType_wxRichTextStyleSheet, &sipCpp, sipType_wxRichTextStyleDefinition, &styleDef, &deleteStyle))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->RemoveStyle(styleDef,deleteStyle);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleSheet, sipName_RemoveStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleSheet_SetDescription, "SetDescription(descr)\n"
    "\n"
    "Sets the style sheet's description.");

extern "C" {static PyObject *meth_wxRichTextStyleSheet_SetDescription(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleSheet_SetDescription(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* descr;
        int descrState = 0;
         ::wxRichTextStyleSheet *sipCpp;

        static const char *sipKwdList[] = {
            sipName_descr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxRichTextStyleSheet, &sipCpp, sipType_wxString,&descr, &descrState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDescription(*descr);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(descr),sipType_wxString,descrState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleSheet, sipName_SetDescription, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleSheet_SetName, "SetName(name)\n"
    "\n"
    "Sets the style sheet's name.");

extern "C" {static PyObject *meth_wxRichTextStyleSheet_SetName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleSheet_SetName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxRichTextStyleSheet *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxRichTextStyleSheet, &sipCpp, sipType_wxString,&name, &nameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetName(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleSheet, sipName_SetName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleSheet_GetProperties, "GetProperties() -> RichTextProperties\n"
    "\n"
    "Returns the sheet's properties.");

extern "C" {static PyObject *meth_wxRichTextStyleSheet_GetProperties(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleSheet_GetProperties(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextStyleSheet *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextStyleSheet, &sipCpp))
        {
             ::wxRichTextProperties*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetProperties();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxRichTextProperties,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleSheet, sipName_GetProperties, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleSheet_SetProperties, "SetProperties(props)\n"
    "\n"
    "Sets the sheet's properties.");

extern "C" {static PyObject *meth_wxRichTextStyleSheet_SetProperties(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleSheet_SetProperties(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextProperties* props;
         ::wxRichTextStyleSheet *sipCpp;

        static const char *sipKwdList[] = {
            sipName_props,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxRichTextStyleSheet, &sipCpp, sipType_wxRichTextProperties, &props))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetProperties(*props);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleSheet, sipName_SetProperties, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxRichTextStyleSheet(void *, const sipTypeDef *);}
static void *cast_wxRichTextStyleSheet(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxRichTextStyleSheet *sipCpp = reinterpret_cast< ::wxRichTextStyleSheet *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxRichTextStyleSheet(void *, int);}
static void release_wxRichTextStyleSheet(void *sipCppV, int sipIsDerived)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipIsDerived)
        delete reinterpret_cast<sipwxRichTextStyleSheet *>(sipCppV);
    else
        delete reinterpret_cast< ::wxRichTextStyleSheet *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxRichTextStyleSheet(void *, SIP_SSIZE_T, const void *);}
static void assign_wxRichTextStyleSheet(void *sipDst, SIP_SSIZE_T sipDstIdx, const void *sipSrc)
{
    reinterpret_cast< ::wxRichTextStyleSheet *>(sipDst)[sipDstIdx] = *reinterpret_cast<const  ::wxRichTextStyleSheet *>(sipSrc);
}


extern "C" {static void *array_wxRichTextStyleSheet(SIP_SSIZE_T);}
static void *array_wxRichTextStyleSheet(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxRichTextStyleSheet[sipNrElem];
}


extern "C" {static void *copy_wxRichTextStyleSheet(const void *, SIP_SSIZE_T);}
static void *copy_wxRichTextStyleSheet(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxRichTextStyleSheet(reinterpret_cast<const  ::wxRichTextStyleSheet *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxRichTextStyleSheet(sipSimpleWrapper *);}
static void dealloc_wxRichTextStyleSheet(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxRichTextStyleSheet *>(sipGetAddress(sipSelf))->sipPySelf = NULL;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxRichTextStyleSheet(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxRichTextStyleSheet(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxRichTextStyleSheet(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxRichTextStyleSheet *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxRichTextStyleSheet();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxRichTextStyleSheet* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxRichTextStyleSheet, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxRichTextStyleSheet(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxRichTextStyleSheet[] = {{42, 0, 1}};


static PyMethodDef methods_wxRichTextStyleSheet[] = {
    {SIP_MLNAME_CAST(sipName_AddCharacterStyle), (PyCFunction)meth_wxRichTextStyleSheet_AddCharacterStyle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextStyleSheet_AddCharacterStyle)},
    {SIP_MLNAME_CAST(sipName_AddListStyle), (PyCFunction)meth_wxRichTextStyleSheet_AddListStyle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextStyleSheet_AddListStyle)},
    {SIP_MLNAME_CAST(sipName_AddParagraphStyle), (PyCFunction)meth_wxRichTextStyleSheet_AddParagraphStyle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextStyleSheet_AddParagraphStyle)},
    {SIP_MLNAME_CAST(sipName_AddStyle), (PyCFunction)meth_wxRichTextStyleSheet_AddStyle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextStyleSheet_AddStyle)},
    {SIP_MLNAME_CAST(sipName_DeleteStyles), meth_wxRichTextStyleSheet_DeleteStyles, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextStyleSheet_DeleteStyles)},
    {SIP_MLNAME_CAST(sipName_FindCharacterStyle), (PyCFunction)meth_wxRichTextStyleSheet_FindCharacterStyle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextStyleSheet_FindCharacterStyle)},
    {SIP_MLNAME_CAST(sipName_FindListStyle), (PyCFunction)meth_wxRichTextStyleSheet_FindListStyle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextStyleSheet_FindListStyle)},
    {SIP_MLNAME_CAST(sipName_FindParagraphStyle), (PyCFunction)meth_wxRichTextStyleSheet_FindParagraphStyle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextStyleSheet_FindParagraphStyle)},
    {SIP_MLNAME_CAST(sipName_FindStyle), (PyCFunction)meth_wxRichTextStyleSheet_FindStyle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextStyleSheet_FindStyle)},
    {SIP_MLNAME_CAST(sipName_GetCharacterStyle), (PyCFunction)meth_wxRichTextStyleSheet_GetCharacterStyle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextStyleSheet_GetCharacterStyle)},
    {SIP_MLNAME_CAST(sipName_GetCharacterStyleCount), meth_wxRichTextStyleSheet_GetCharacterStyleCount, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextStyleSheet_GetCharacterStyleCount)},
    {SIP_MLNAME_CAST(sipName_GetDescription), meth_wxRichTextStyleSheet_GetDescription, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextStyleSheet_GetDescription)},
    {SIP_MLNAME_CAST(sipName_GetListStyle), (PyCFunction)meth_wxRichTextStyleSheet_GetListStyle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextStyleSheet_GetListStyle)},
    {SIP_MLNAME_CAST(sipName_GetListStyleCount), meth_wxRichTextStyleSheet_GetListStyleCount, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextStyleSheet_GetListStyleCount)},
    {SIP_MLNAME_CAST(sipName_GetName), meth_wxRichTextStyleSheet_GetName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextStyleSheet_GetName)},
    {SIP_MLNAME_CAST(sipName_GetParagraphStyle), (PyCFunction)meth_wxRichTextStyleSheet_GetParagraphStyle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextStyleSheet_GetParagraphStyle)},
    {SIP_MLNAME_CAST(sipName_GetParagraphStyleCount), meth_wxRichTextStyleSheet_GetParagraphStyleCount, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextStyleSheet_GetParagraphStyleCount)},
    {SIP_MLNAME_CAST(sipName_GetProperties), meth_wxRichTextStyleSheet_GetProperties, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextStyleSheet_GetProperties)},
    {SIP_MLNAME_CAST(sipName_RemoveCharacterStyle), (PyCFunction)meth_wxRichTextStyleSheet_RemoveCharacterStyle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextStyleSheet_RemoveCharacterStyle)},
    {SIP_MLNAME_CAST(sipName_RemoveListStyle), (PyCFunction)meth_wxRichTextStyleSheet_RemoveListStyle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextStyleSheet_RemoveListStyle)},
    {SIP_MLNAME_CAST(sipName_RemoveParagraphStyle), (PyCFunction)meth_wxRichTextStyleSheet_RemoveParagraphStyle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextStyleSheet_RemoveParagraphStyle)},
    {SIP_MLNAME_CAST(sipName_RemoveStyle), (PyCFunction)meth_wxRichTextStyleSheet_RemoveStyle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextStyleSheet_RemoveStyle)},
    {SIP_MLNAME_CAST(sipName_SetDescription), (PyCFunction)meth_wxRichTextStyleSheet_SetDescription, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextStyleSheet_SetDescription)},
    {SIP_MLNAME_CAST(sipName_SetName), (PyCFunction)meth_wxRichTextStyleSheet_SetName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextStyleSheet_SetName)},
    {SIP_MLNAME_CAST(sipName_SetProperties), (PyCFunction)meth_wxRichTextStyleSheet_SetProperties, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextStyleSheet_SetProperties)}
};

sipVariableDef variables_wxRichTextStyleSheet[] = {
    {PropertyVariable, sipName_Properties, &methods_wxRichTextStyleSheet[17], &methods_wxRichTextStyleSheet[24], NULL, NULL},
    {PropertyVariable, sipName_ParagraphStyleCount, &methods_wxRichTextStyleSheet[16], NULL, NULL, NULL},
    {PropertyVariable, sipName_Name, &methods_wxRichTextStyleSheet[14], &methods_wxRichTextStyleSheet[23], NULL, NULL},
    {PropertyVariable, sipName_ListStyleCount, &methods_wxRichTextStyleSheet[13], NULL, NULL, NULL},
    {PropertyVariable, sipName_Description, &methods_wxRichTextStyleSheet[11], &methods_wxRichTextStyleSheet[22], NULL, NULL},
    {PropertyVariable, sipName_CharacterStyleCount, &methods_wxRichTextStyleSheet[10], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxRichTextStyleSheet, "RichTextStyleSheet()\n"
    "\n"
    "A style sheet contains named paragraph and character styles that make\n"
    "it easy for a user to apply combinations of attributes to a\n"
    "wxRichTextCtrl.");


sipClassTypeDef sipTypeDef__richtext_wxRichTextStyleSheet = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxRichTextStyleSheet,
        {0},
        0
    },
    {
        sipNameNr_RichTextStyleSheet,
        {0, 0, 1},
        25, methods_wxRichTextStyleSheet,
        0, 0,
        6, variables_wxRichTextStyleSheet,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxRichTextStyleSheet,
    -1,
    -1,
    supers_wxRichTextStyleSheet,
    0,
    init_type_wxRichTextStyleSheet,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxRichTextStyleSheet,
    assign_wxRichTextStyleSheet,
    array_wxRichTextStyleSheet,
    copy_wxRichTextStyleSheet,
    release_wxRichTextStyleSheet,
    cast_wxRichTextStyleSheet,
    0,
    0,
    0,
    0,
    0,
    0
};
