/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.1
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"

        #include <wx/richtext/richtextbuffer.h>

        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextbuffer.h>


PyDoc_STRVAR(doc_wxTextBoxAttr_Init, "Init()\n"
    "\n"
    "Initialises this object.");

extern "C" {static PyObject *meth_wxTextBoxAttr_Init(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_Init(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Init();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_Init, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_Reset, "Reset()\n"
    "\n"
    "Resets this object.");

extern "C" {static PyObject *meth_wxTextBoxAttr_Reset(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_Reset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Reset();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_Reset, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_EqPartial, "EqPartial(attr, weakTest=True) -> bool\n"
    "\n"
    "Partial equality test, ignoring unset attributes.");

extern "C" {static PyObject *meth_wxTextBoxAttr_EqPartial(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_EqPartial(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextBoxAttr* attr;
        bool weakTest = 1;
        const  ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attr,
            sipName_weakTest,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9|b", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextBoxAttr, &attr, &weakTest))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->EqPartial(*attr,weakTest);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_EqPartial, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_Apply, "Apply(style, compareWith=None) -> bool\n"
    "\n"
    "Merges the given attributes.");

extern "C" {static PyObject *meth_wxTextBoxAttr_Apply(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_Apply(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextBoxAttr* style;
        const  ::wxTextBoxAttr* compareWith = 0;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_style,
            sipName_compareWith,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9|J8", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextBoxAttr, &style, sipType_wxTextBoxAttr, &compareWith))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Apply(*style,compareWith);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_Apply, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_CollectCommonAttributes, "CollectCommonAttributes(attr, clashingAttr, absentAttr)\n"
    "\n"
    "Collects the attributes that are common to a range of content,\n"
    "building up a note of which attributes are absent in some objects and\n"
    "which clash in some objects.");

extern "C" {static PyObject *meth_wxTextBoxAttr_CollectCommonAttributes(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_CollectCommonAttributes(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextBoxAttr* attr;
         ::wxTextBoxAttr* clashingAttr;
         ::wxTextBoxAttr* absentAttr;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attr,
            sipName_clashingAttr,
            sipName_absentAttr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9J9J9", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextBoxAttr, &attr, sipType_wxTextBoxAttr, &clashingAttr, sipType_wxTextBoxAttr, &absentAttr))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->CollectCommonAttributes(*attr,*clashingAttr,*absentAttr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_CollectCommonAttributes, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_RemoveStyle, "RemoveStyle(attr) -> bool\n"
    "\n"
    "Removes the specified attributes from this object.");

extern "C" {static PyObject *meth_wxTextBoxAttr_RemoveStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_RemoveStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextBoxAttr* attr;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextBoxAttr, &attr))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->RemoveStyle(*attr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_RemoveStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_SetFlags, "SetFlags(flags)\n"
    "\n"
    "Sets the flags.");

extern "C" {static PyObject *meth_wxTextBoxAttr_SetFlags(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_SetFlags(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int flags;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFlags(flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_SetFlags, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetFlags, "GetFlags() -> int\n"
    "\n"
    "Returns the flags.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetFlags(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetFlags(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFlags();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetFlags, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_HasFlag, "HasFlag(flag) -> bool\n"
    "\n"
    "Is this flag present?");

extern "C" {static PyObject *meth_wxTextBoxAttr_HasFlag(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_HasFlag(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttrFlags flag;
        const  ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextBoxAttrFlags, &flag))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasFlag(flag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_HasFlag, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_RemoveFlag, "RemoveFlag(flag)\n"
    "\n"
    "Removes this flag.");

extern "C" {static PyObject *meth_wxTextBoxAttr_RemoveFlag(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_RemoveFlag(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttrFlags flag;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextBoxAttrFlags, &flag))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->RemoveFlag(flag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_RemoveFlag, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_AddFlag, "AddFlag(flag)\n"
    "\n"
    "Adds this flag.");

extern "C" {static PyObject *meth_wxTextBoxAttr_AddFlag(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_AddFlag(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttrFlags flag;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextBoxAttrFlags, &flag))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddFlag(flag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_AddFlag, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_IsDefault, "IsDefault() -> bool\n"
    "\n"
    "Returns true if no attributes are set.");

extern "C" {static PyObject *meth_wxTextBoxAttr_IsDefault(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_IsDefault(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsDefault();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_IsDefault, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetFloatMode, "GetFloatMode() -> TextBoxAttrFloatStyle\n"
    "\n"
    "Returns the float mode.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetFloatMode(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetFloatMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextBoxAttrFloatStyle sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFloatMode();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(sipRes,sipType_wxTextBoxAttrFloatStyle);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetFloatMode, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_SetFloatMode, "SetFloatMode(mode)\n"
    "\n"
    "Sets the float mode.");

extern "C" {static PyObject *meth_wxTextBoxAttr_SetFloatMode(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_SetFloatMode(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttrFloatStyle mode;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_mode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextBoxAttrFloatStyle, &mode))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFloatMode(mode);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_SetFloatMode, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_HasFloatMode, "HasFloatMode() -> bool\n"
    "\n"
    "Returns true if float mode is active.");

extern "C" {static PyObject *meth_wxTextBoxAttr_HasFloatMode(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_HasFloatMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasFloatMode();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_HasFloatMode, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_IsFloating, "IsFloating() -> bool\n"
    "\n"
    "Returns true if this object is floating.");

extern "C" {static PyObject *meth_wxTextBoxAttr_IsFloating(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_IsFloating(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsFloating();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_IsFloating, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetClearMode, "GetClearMode() -> TextBoxAttrClearStyle\n"
    "\n"
    "Returns the clear mode - whether to wrap text after object.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetClearMode(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetClearMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextBoxAttrClearStyle sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetClearMode();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(sipRes,sipType_wxTextBoxAttrClearStyle);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetClearMode, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_SetClearMode, "SetClearMode(mode)\n"
    "\n"
    "Set the clear mode.");

extern "C" {static PyObject *meth_wxTextBoxAttr_SetClearMode(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_SetClearMode(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttrClearStyle mode;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_mode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextBoxAttrClearStyle, &mode))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetClearMode(mode);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_SetClearMode, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_HasClearMode, "HasClearMode() -> bool\n"
    "\n"
    "Returns true if we have a clear flag.");

extern "C" {static PyObject *meth_wxTextBoxAttr_HasClearMode(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_HasClearMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasClearMode();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_HasClearMode, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetCollapseBorders, "GetCollapseBorders() -> TextBoxAttrCollapseMode\n"
    "\n"
    "Returns the collapse mode - whether to collapse borders.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetCollapseBorders(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetCollapseBorders(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextBoxAttrCollapseMode sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetCollapseBorders();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(sipRes,sipType_wxTextBoxAttrCollapseMode);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetCollapseBorders, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_SetCollapseBorders, "SetCollapseBorders(collapse)\n"
    "\n"
    "Sets the collapse mode - whether to collapse borders.");

extern "C" {static PyObject *meth_wxTextBoxAttr_SetCollapseBorders(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_SetCollapseBorders(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttrCollapseMode collapse;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_collapse,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextBoxAttrCollapseMode, &collapse))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetCollapseBorders(collapse);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_SetCollapseBorders, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_HasCollapseBorders, "HasCollapseBorders() -> bool\n"
    "\n"
    "Returns true if the collapse borders flag is present.");

extern "C" {static PyObject *meth_wxTextBoxAttr_HasCollapseBorders(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_HasCollapseBorders(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasCollapseBorders();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_HasCollapseBorders, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetVerticalAlignment, "GetVerticalAlignment() -> TextBoxAttrVerticalAlignment\n"
    "\n"
    "Returns the vertical alignment.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetVerticalAlignment(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetVerticalAlignment(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextBoxAttrVerticalAlignment sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetVerticalAlignment();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(sipRes,sipType_wxTextBoxAttrVerticalAlignment);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetVerticalAlignment, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_SetVerticalAlignment, "SetVerticalAlignment(verticalAlignment)\n"
    "\n"
    "Sets the vertical alignment.");

extern "C" {static PyObject *meth_wxTextBoxAttr_SetVerticalAlignment(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_SetVerticalAlignment(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttrVerticalAlignment verticalAlignment;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_verticalAlignment,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextBoxAttrVerticalAlignment, &verticalAlignment))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetVerticalAlignment(verticalAlignment);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_SetVerticalAlignment, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_HasVerticalAlignment, "HasVerticalAlignment() -> bool\n"
    "\n"
    "Returns true if a vertical alignment flag is present.");

extern "C" {static PyObject *meth_wxTextBoxAttr_HasVerticalAlignment(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_HasVerticalAlignment(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasVerticalAlignment();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_HasVerticalAlignment, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetMargins, "GetMargins() -> TextAttrDimensions\n"
    "\n"
    "Returns the margin values.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetMargins(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetMargins(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimensions*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetMargins();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimensions,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetMargins, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetLeftMargin, "GetLeftMargin() -> TextAttrDimension\n"
    "\n"
    "Returns the left margin.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetLeftMargin(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetLeftMargin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetLeftMargin();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetLeftMargin, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetRightMargin, "GetRightMargin() -> TextAttrDimension\n"
    "\n"
    "Returns the right margin.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetRightMargin(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetRightMargin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetRightMargin();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetRightMargin, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetTopMargin, "GetTopMargin() -> TextAttrDimension\n"
    "\n"
    "Returns the top margin.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetTopMargin(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetTopMargin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetTopMargin();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetTopMargin, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetBottomMargin, "GetBottomMargin() -> TextAttrDimension\n"
    "\n"
    "Returns the bottom margin.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetBottomMargin(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetBottomMargin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetBottomMargin();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetBottomMargin, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetPosition, "GetPosition() -> TextAttrDimensions\n"
    "\n"
    "Returns the position.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetPosition(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimensions*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetPosition();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimensions,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetPosition, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetLeft, "GetLeft() -> TextAttrDimension\n"
    "\n"
    "Returns the left position.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetLeft(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetLeft(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetLeft();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetLeft, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetRight, "GetRight() -> TextAttrDimension\n"
    "\n"
    "Returns the right position.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetRight(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetRight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetRight();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetRight, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetTop, "GetTop() -> TextAttrDimension\n"
    "\n"
    "Returns the top position.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetTop(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetTop(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetTop();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetTop, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetBottom, "GetBottom() -> TextAttrDimension\n"
    "\n"
    "Returns the bottom position.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetBottom(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetBottom(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetBottom();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetBottom, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetPadding, "GetPadding() -> TextAttrDimensions\n"
    "\n"
    "Returns the padding values.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetPadding(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetPadding(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimensions*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetPadding();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimensions,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetPadding, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetLeftPadding, "GetLeftPadding() -> TextAttrDimension\n"
    "\n"
    "Returns the left padding value.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetLeftPadding(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetLeftPadding(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetLeftPadding();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetLeftPadding, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetRightPadding, "GetRightPadding() -> TextAttrDimension\n"
    "\n"
    "Returns the right padding value.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetRightPadding(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetRightPadding(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetRightPadding();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetRightPadding, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetTopPadding, "GetTopPadding() -> TextAttrDimension\n"
    "\n"
    "Returns the top padding value.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetTopPadding(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetTopPadding(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetTopPadding();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetTopPadding, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetBottomPadding, "GetBottomPadding() -> TextAttrDimension\n"
    "\n"
    "Returns the bottom padding value.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetBottomPadding(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetBottomPadding(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetBottomPadding();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetBottomPadding, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetBorder, "GetBorder() -> TextAttrBorders\n"
    "\n"
    "Returns the borders.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetBorder(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetBorder(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrBorders*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetBorder();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrBorders,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetBorder, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetLeftBorder, "GetLeftBorder() -> TextAttrBorder\n"
    "\n"
    "Returns the left border.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetLeftBorder(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetLeftBorder(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrBorder*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetLeftBorder();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrBorder,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetLeftBorder, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetTopBorder, "GetTopBorder() -> TextAttrBorder\n"
    "\n"
    "Returns the top border.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetTopBorder(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetTopBorder(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrBorder*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetTopBorder();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrBorder,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetTopBorder, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetRightBorder, "GetRightBorder() -> TextAttrBorder\n"
    "\n"
    "Returns the right border.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetRightBorder(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetRightBorder(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrBorder*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetRightBorder();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrBorder,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetRightBorder, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetBottomBorder, "GetBottomBorder() -> TextAttrBorder\n"
    "\n"
    "Returns the bottom border.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetBottomBorder(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetBottomBorder(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrBorder*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetBottomBorder();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrBorder,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetBottomBorder, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetOutline, "GetOutline() -> TextAttrBorders\n"
    "\n"
    "Returns the outline.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetOutline(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetOutline(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrBorders*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetOutline();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrBorders,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetOutline, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetLeftOutline, "GetLeftOutline() -> TextAttrBorder\n"
    "\n"
    "Returns the left outline.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetLeftOutline(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetLeftOutline(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrBorder*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetLeftOutline();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrBorder,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetLeftOutline, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetTopOutline, "GetTopOutline() -> TextAttrBorder\n"
    "\n"
    "Returns the top outline.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetTopOutline(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetTopOutline(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrBorder*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetTopOutline();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrBorder,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetTopOutline, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetRightOutline, "GetRightOutline() -> TextAttrBorder\n"
    "\n"
    "Returns the right outline.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetRightOutline(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetRightOutline(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrBorder*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetRightOutline();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrBorder,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetRightOutline, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetBottomOutline, "GetBottomOutline() -> TextAttrBorder\n"
    "\n"
    "Returns the bottom outline.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetBottomOutline(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetBottomOutline(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrBorder*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetBottomOutline();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrBorder,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetBottomOutline, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetSize, "GetSize() -> TextAttrSize\n"
    "\n"
    "Returns the object size.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetSize(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetSize();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrSize,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetMinSize, "GetMinSize() -> TextAttrSize\n"
    "\n"
    "Returns the object minimum size.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetMinSize(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetMinSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetMinSize();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrSize,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetMinSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetMaxSize, "GetMaxSize() -> TextAttrSize\n"
    "\n"
    "Returns the object maximum size.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetMaxSize(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetMaxSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetMaxSize();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrSize,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetMaxSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_SetSize, "SetSize(sz)\n"
    "\n"
    "Sets the object size.");

extern "C" {static PyObject *meth_wxTextBoxAttr_SetSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_SetSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttrSize* sz;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextAttrSize, &sz))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetSize(*sz);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_SetSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_SetMinSize, "SetMinSize(sz)\n"
    "\n"
    "Sets the object minimum size.");

extern "C" {static PyObject *meth_wxTextBoxAttr_SetMinSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_SetMinSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttrSize* sz;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextAttrSize, &sz))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetMinSize(*sz);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_SetMinSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_SetMaxSize, "SetMaxSize(sz)\n"
    "\n"
    "Sets the object maximum size.");

extern "C" {static PyObject *meth_wxTextBoxAttr_SetMaxSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_SetMaxSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextAttrSize* sz;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxTextAttrSize, &sz))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetMaxSize(*sz);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_SetMaxSize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetWidth, "GetWidth() -> TextAttrDimension\n"
    "\n"
    "Returns the object width.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetWidth(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetWidth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetWidth, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetHeight, "GetHeight() -> TextAttrDimension\n"
    "\n"
    "Returns the object height.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetHeight(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetHeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetHeight();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetHeight, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_GetBoxStyleName, "GetBoxStyleName() -> String\n"
    "\n"
    "Returns the box style name.");

extern "C" {static PyObject *meth_wxTextBoxAttr_GetBoxStyleName(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_GetBoxStyleName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetBoxStyleName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_GetBoxStyleName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_SetBoxStyleName, "SetBoxStyleName(name)\n"
    "\n"
    "Sets the box style name.");

extern "C" {static PyObject *meth_wxTextBoxAttr_SetBoxStyleName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_SetBoxStyleName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxTextBoxAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxTextBoxAttr, &sipCpp, sipType_wxString,&name, &nameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBoxStyleName(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_SetBoxStyleName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxTextBoxAttr_HasBoxStyleName, "HasBoxStyleName() -> bool\n"
    "\n"
    "Returns true if the box style name is present.");

extern "C" {static PyObject *meth_wxTextBoxAttr_HasBoxStyleName(PyObject *, PyObject *);}
static PyObject *meth_wxTextBoxAttr_HasBoxStyleName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextBoxAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextBoxAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasBoxStyleName();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextBoxAttr, sipName_HasBoxStyleName, NULL);

    return NULL;
}


extern "C" {static PyObject *slot_wxTextBoxAttr___ne__(PyObject *,PyObject *);}
static PyObject *slot_wxTextBoxAttr___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxTextBoxAttr));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextBoxAttr* attr;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTextBoxAttr, &attr))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = !sipCpp-> ::wxTextBoxAttr::operator==(*attr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__richtext, ne_slot, sipType_wxTextBoxAttr, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxTextBoxAttr___eq__(PyObject *,PyObject *);}
static PyObject *slot_wxTextBoxAttr___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxTextBoxAttr));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxTextBoxAttr* attr;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTextBoxAttr, &attr))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxTextBoxAttr::operator==(*attr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__richtext, eq_slot, sipType_wxTextBoxAttr, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_wxTextBoxAttr(void *, int);}
static void release_wxTextBoxAttr(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxTextBoxAttr *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxTextBoxAttr(void *, SIP_SSIZE_T, const void *);}
static void assign_wxTextBoxAttr(void *sipDst, SIP_SSIZE_T sipDstIdx, const void *sipSrc)
{
    reinterpret_cast< ::wxTextBoxAttr *>(sipDst)[sipDstIdx] = *reinterpret_cast<const  ::wxTextBoxAttr *>(sipSrc);
}


extern "C" {static void *array_wxTextBoxAttr(SIP_SSIZE_T);}
static void *array_wxTextBoxAttr(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxTextBoxAttr[sipNrElem];
}


extern "C" {static void *copy_wxTextBoxAttr(const void *, SIP_SSIZE_T);}
static void *copy_wxTextBoxAttr(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxTextBoxAttr(reinterpret_cast<const  ::wxTextBoxAttr *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxTextBoxAttr(sipSimpleWrapper *);}
static void dealloc_wxTextBoxAttr(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxTextBoxAttr(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxTextBoxAttr(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxTextBoxAttr(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxTextBoxAttr *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxTextBoxAttr();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxTextBoxAttr* attr;

        static const char *sipKwdList[] = {
            sipName_attr,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxTextBoxAttr, &attr))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxTextBoxAttr(*attr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxTextBoxAttr[] = {
    {(void *)slot_wxTextBoxAttr___ne__, ne_slot},
    {(void *)slot_wxTextBoxAttr___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxTextBoxAttr[] = {
    {SIP_MLNAME_CAST(sipName_AddFlag), (PyCFunction)meth_wxTextBoxAttr_AddFlag, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_AddFlag)},
    {SIP_MLNAME_CAST(sipName_Apply), (PyCFunction)meth_wxTextBoxAttr_Apply, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_Apply)},
    {SIP_MLNAME_CAST(sipName_CollectCommonAttributes), (PyCFunction)meth_wxTextBoxAttr_CollectCommonAttributes, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_CollectCommonAttributes)},
    {SIP_MLNAME_CAST(sipName_EqPartial), (PyCFunction)meth_wxTextBoxAttr_EqPartial, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_EqPartial)},
    {SIP_MLNAME_CAST(sipName_GetBorder), meth_wxTextBoxAttr_GetBorder, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetBorder)},
    {SIP_MLNAME_CAST(sipName_GetBottom), meth_wxTextBoxAttr_GetBottom, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetBottom)},
    {SIP_MLNAME_CAST(sipName_GetBottomBorder), meth_wxTextBoxAttr_GetBottomBorder, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetBottomBorder)},
    {SIP_MLNAME_CAST(sipName_GetBottomMargin), meth_wxTextBoxAttr_GetBottomMargin, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetBottomMargin)},
    {SIP_MLNAME_CAST(sipName_GetBottomOutline), meth_wxTextBoxAttr_GetBottomOutline, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetBottomOutline)},
    {SIP_MLNAME_CAST(sipName_GetBottomPadding), meth_wxTextBoxAttr_GetBottomPadding, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetBottomPadding)},
    {SIP_MLNAME_CAST(sipName_GetBoxStyleName), meth_wxTextBoxAttr_GetBoxStyleName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetBoxStyleName)},
    {SIP_MLNAME_CAST(sipName_GetClearMode), meth_wxTextBoxAttr_GetClearMode, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetClearMode)},
    {SIP_MLNAME_CAST(sipName_GetCollapseBorders), meth_wxTextBoxAttr_GetCollapseBorders, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetCollapseBorders)},
    {SIP_MLNAME_CAST(sipName_GetFlags), meth_wxTextBoxAttr_GetFlags, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetFlags)},
    {SIP_MLNAME_CAST(sipName_GetFloatMode), meth_wxTextBoxAttr_GetFloatMode, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetFloatMode)},
    {SIP_MLNAME_CAST(sipName_GetHeight), meth_wxTextBoxAttr_GetHeight, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetHeight)},
    {SIP_MLNAME_CAST(sipName_GetLeft), meth_wxTextBoxAttr_GetLeft, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetLeft)},
    {SIP_MLNAME_CAST(sipName_GetLeftBorder), meth_wxTextBoxAttr_GetLeftBorder, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetLeftBorder)},
    {SIP_MLNAME_CAST(sipName_GetLeftMargin), meth_wxTextBoxAttr_GetLeftMargin, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetLeftMargin)},
    {SIP_MLNAME_CAST(sipName_GetLeftOutline), meth_wxTextBoxAttr_GetLeftOutline, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetLeftOutline)},
    {SIP_MLNAME_CAST(sipName_GetLeftPadding), meth_wxTextBoxAttr_GetLeftPadding, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetLeftPadding)},
    {SIP_MLNAME_CAST(sipName_GetMargins), meth_wxTextBoxAttr_GetMargins, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetMargins)},
    {SIP_MLNAME_CAST(sipName_GetMaxSize), meth_wxTextBoxAttr_GetMaxSize, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetMaxSize)},
    {SIP_MLNAME_CAST(sipName_GetMinSize), meth_wxTextBoxAttr_GetMinSize, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetMinSize)},
    {SIP_MLNAME_CAST(sipName_GetOutline), meth_wxTextBoxAttr_GetOutline, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetOutline)},
    {SIP_MLNAME_CAST(sipName_GetPadding), meth_wxTextBoxAttr_GetPadding, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetPadding)},
    {SIP_MLNAME_CAST(sipName_GetPosition), meth_wxTextBoxAttr_GetPosition, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetPosition)},
    {SIP_MLNAME_CAST(sipName_GetRight), meth_wxTextBoxAttr_GetRight, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetRight)},
    {SIP_MLNAME_CAST(sipName_GetRightBorder), meth_wxTextBoxAttr_GetRightBorder, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetRightBorder)},
    {SIP_MLNAME_CAST(sipName_GetRightMargin), meth_wxTextBoxAttr_GetRightMargin, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetRightMargin)},
    {SIP_MLNAME_CAST(sipName_GetRightOutline), meth_wxTextBoxAttr_GetRightOutline, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetRightOutline)},
    {SIP_MLNAME_CAST(sipName_GetRightPadding), meth_wxTextBoxAttr_GetRightPadding, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetRightPadding)},
    {SIP_MLNAME_CAST(sipName_GetSize), meth_wxTextBoxAttr_GetSize, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetSize)},
    {SIP_MLNAME_CAST(sipName_GetTop), meth_wxTextBoxAttr_GetTop, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetTop)},
    {SIP_MLNAME_CAST(sipName_GetTopBorder), meth_wxTextBoxAttr_GetTopBorder, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetTopBorder)},
    {SIP_MLNAME_CAST(sipName_GetTopMargin), meth_wxTextBoxAttr_GetTopMargin, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetTopMargin)},
    {SIP_MLNAME_CAST(sipName_GetTopOutline), meth_wxTextBoxAttr_GetTopOutline, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetTopOutline)},
    {SIP_MLNAME_CAST(sipName_GetTopPadding), meth_wxTextBoxAttr_GetTopPadding, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetTopPadding)},
    {SIP_MLNAME_CAST(sipName_GetVerticalAlignment), meth_wxTextBoxAttr_GetVerticalAlignment, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetVerticalAlignment)},
    {SIP_MLNAME_CAST(sipName_GetWidth), meth_wxTextBoxAttr_GetWidth, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_GetWidth)},
    {SIP_MLNAME_CAST(sipName_HasBoxStyleName), meth_wxTextBoxAttr_HasBoxStyleName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_HasBoxStyleName)},
    {SIP_MLNAME_CAST(sipName_HasClearMode), meth_wxTextBoxAttr_HasClearMode, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_HasClearMode)},
    {SIP_MLNAME_CAST(sipName_HasCollapseBorders), meth_wxTextBoxAttr_HasCollapseBorders, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_HasCollapseBorders)},
    {SIP_MLNAME_CAST(sipName_HasFlag), (PyCFunction)meth_wxTextBoxAttr_HasFlag, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_HasFlag)},
    {SIP_MLNAME_CAST(sipName_HasFloatMode), meth_wxTextBoxAttr_HasFloatMode, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_HasFloatMode)},
    {SIP_MLNAME_CAST(sipName_HasVerticalAlignment), meth_wxTextBoxAttr_HasVerticalAlignment, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_HasVerticalAlignment)},
    {SIP_MLNAME_CAST(sipName_Init), meth_wxTextBoxAttr_Init, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_Init)},
    {SIP_MLNAME_CAST(sipName_IsDefault), meth_wxTextBoxAttr_IsDefault, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_IsDefault)},
    {SIP_MLNAME_CAST(sipName_IsFloating), meth_wxTextBoxAttr_IsFloating, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_IsFloating)},
    {SIP_MLNAME_CAST(sipName_RemoveFlag), (PyCFunction)meth_wxTextBoxAttr_RemoveFlag, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_RemoveFlag)},
    {SIP_MLNAME_CAST(sipName_RemoveStyle), (PyCFunction)meth_wxTextBoxAttr_RemoveStyle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_RemoveStyle)},
    {SIP_MLNAME_CAST(sipName_Reset), meth_wxTextBoxAttr_Reset, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_Reset)},
    {SIP_MLNAME_CAST(sipName_SetBoxStyleName), (PyCFunction)meth_wxTextBoxAttr_SetBoxStyleName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_SetBoxStyleName)},
    {SIP_MLNAME_CAST(sipName_SetClearMode), (PyCFunction)meth_wxTextBoxAttr_SetClearMode, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_SetClearMode)},
    {SIP_MLNAME_CAST(sipName_SetCollapseBorders), (PyCFunction)meth_wxTextBoxAttr_SetCollapseBorders, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_SetCollapseBorders)},
    {SIP_MLNAME_CAST(sipName_SetFlags), (PyCFunction)meth_wxTextBoxAttr_SetFlags, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_SetFlags)},
    {SIP_MLNAME_CAST(sipName_SetFloatMode), (PyCFunction)meth_wxTextBoxAttr_SetFloatMode, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_SetFloatMode)},
    {SIP_MLNAME_CAST(sipName_SetMaxSize), (PyCFunction)meth_wxTextBoxAttr_SetMaxSize, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_SetMaxSize)},
    {SIP_MLNAME_CAST(sipName_SetMinSize), (PyCFunction)meth_wxTextBoxAttr_SetMinSize, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_SetMinSize)},
    {SIP_MLNAME_CAST(sipName_SetSize), (PyCFunction)meth_wxTextBoxAttr_SetSize, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_SetSize)},
    {SIP_MLNAME_CAST(sipName_SetVerticalAlignment), (PyCFunction)meth_wxTextBoxAttr_SetVerticalAlignment, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextBoxAttr_SetVerticalAlignment)}
};


extern "C" {static PyObject *varget_wxTextBoxAttr_m_border(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_border(void *sipSelf, PyObject *, PyObject *)
{
     ::wxTextAttrBorders*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = &sipCpp->m_border;

    return sipConvertFromType(sipVal, sipType_wxTextAttrBorders, NULL);
}


extern "C" {static int varset_wxTextBoxAttr_m_border(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_border(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextAttrBorders*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxTextAttrBorders *>(sipForceConvertToType(sipPy,sipType_wxTextAttrBorders,NULL,SIP_NOT_NONE,NULL,&sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_border = *sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_boxStyleName(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_boxStyleName(void *sipSelf, PyObject *, PyObject *)
{
     ::wxString*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = &sipCpp->m_boxStyleName;

    return sipConvertFromType(sipVal, sipType_wxString, NULL);
}


extern "C" {static int varset_wxTextBoxAttr_m_boxStyleName(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_boxStyleName(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxString*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    int sipValState;
    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxString *>(sipForceConvertToType(sipPy,sipType_wxString,NULL,SIP_NOT_NONE,&sipValState,&sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_boxStyleName = *sipVal;

    sipReleaseType(sipVal, sipType_wxString, sipValState);

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_clearMode(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_clearMode(void *sipSelf, PyObject *, PyObject *)
{
     ::wxTextBoxAttrClearStyle sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = sipCpp->m_clearMode;

    return sipConvertFromEnum(sipVal, sipType_wxTextBoxAttrClearStyle);
}


extern "C" {static int varset_wxTextBoxAttr_m_clearMode(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_clearMode(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextBoxAttrClearStyle sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = ( ::wxTextBoxAttrClearStyle)SIPLong_AsLong(sipPy);

    if (PyErr_Occurred() != NULL)
        return -1;

    sipCpp->m_clearMode = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_collapseMode(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_collapseMode(void *sipSelf, PyObject *, PyObject *)
{
     ::wxTextBoxAttrCollapseMode sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = sipCpp->m_collapseMode;

    return sipConvertFromEnum(sipVal, sipType_wxTextBoxAttrCollapseMode);
}


extern "C" {static int varset_wxTextBoxAttr_m_collapseMode(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_collapseMode(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextBoxAttrCollapseMode sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = ( ::wxTextBoxAttrCollapseMode)SIPLong_AsLong(sipPy);

    if (PyErr_Occurred() != NULL)
        return -1;

    sipCpp->m_collapseMode = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_flags(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_flags(void *sipSelf, PyObject *, PyObject *)
{
    int sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = sipCpp->m_flags;

    return SIPLong_FromLong(sipVal);
}


extern "C" {static int varset_wxTextBoxAttr_m_flags(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_flags(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = (int)SIPLong_AsLong(sipPy);

    if (PyErr_Occurred() != NULL)
        return -1;

    sipCpp->m_flags = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_floatMode(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_floatMode(void *sipSelf, PyObject *, PyObject *)
{
     ::wxTextBoxAttrFloatStyle sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = sipCpp->m_floatMode;

    return sipConvertFromEnum(sipVal, sipType_wxTextBoxAttrFloatStyle);
}


extern "C" {static int varset_wxTextBoxAttr_m_floatMode(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_floatMode(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextBoxAttrFloatStyle sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = ( ::wxTextBoxAttrFloatStyle)SIPLong_AsLong(sipPy);

    if (PyErr_Occurred() != NULL)
        return -1;

    sipCpp->m_floatMode = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_margins(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_margins(void *sipSelf, PyObject *, PyObject *)
{
     ::wxTextAttrDimensions*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = &sipCpp->m_margins;

    return sipConvertFromType(sipVal, sipType_wxTextAttrDimensions, NULL);
}


extern "C" {static int varset_wxTextBoxAttr_m_margins(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_margins(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextAttrDimensions*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxTextAttrDimensions *>(sipForceConvertToType(sipPy,sipType_wxTextAttrDimensions,NULL,SIP_NOT_NONE,NULL,&sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_margins = *sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_maxSize(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_maxSize(void *sipSelf, PyObject *, PyObject *)
{
     ::wxTextAttrSize*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = &sipCpp->m_maxSize;

    return sipConvertFromType(sipVal, sipType_wxTextAttrSize, NULL);
}


extern "C" {static int varset_wxTextBoxAttr_m_maxSize(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_maxSize(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextAttrSize*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxTextAttrSize *>(sipForceConvertToType(sipPy,sipType_wxTextAttrSize,NULL,SIP_NOT_NONE,NULL,&sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_maxSize = *sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_minSize(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_minSize(void *sipSelf, PyObject *, PyObject *)
{
     ::wxTextAttrSize*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = &sipCpp->m_minSize;

    return sipConvertFromType(sipVal, sipType_wxTextAttrSize, NULL);
}


extern "C" {static int varset_wxTextBoxAttr_m_minSize(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_minSize(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextAttrSize*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxTextAttrSize *>(sipForceConvertToType(sipPy,sipType_wxTextAttrSize,NULL,SIP_NOT_NONE,NULL,&sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_minSize = *sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_outline(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_outline(void *sipSelf, PyObject *, PyObject *)
{
     ::wxTextAttrBorders*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = &sipCpp->m_outline;

    return sipConvertFromType(sipVal, sipType_wxTextAttrBorders, NULL);
}


extern "C" {static int varset_wxTextBoxAttr_m_outline(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_outline(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextAttrBorders*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxTextAttrBorders *>(sipForceConvertToType(sipPy,sipType_wxTextAttrBorders,NULL,SIP_NOT_NONE,NULL,&sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_outline = *sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_padding(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_padding(void *sipSelf, PyObject *, PyObject *)
{
     ::wxTextAttrDimensions*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = &sipCpp->m_padding;

    return sipConvertFromType(sipVal, sipType_wxTextAttrDimensions, NULL);
}


extern "C" {static int varset_wxTextBoxAttr_m_padding(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_padding(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextAttrDimensions*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxTextAttrDimensions *>(sipForceConvertToType(sipPy,sipType_wxTextAttrDimensions,NULL,SIP_NOT_NONE,NULL,&sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_padding = *sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_position(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_position(void *sipSelf, PyObject *, PyObject *)
{
     ::wxTextAttrDimensions*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = &sipCpp->m_position;

    return sipConvertFromType(sipVal, sipType_wxTextAttrDimensions, NULL);
}


extern "C" {static int varset_wxTextBoxAttr_m_position(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_position(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextAttrDimensions*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxTextAttrDimensions *>(sipForceConvertToType(sipPy,sipType_wxTextAttrDimensions,NULL,SIP_NOT_NONE,NULL,&sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_position = *sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_size(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_size(void *sipSelf, PyObject *, PyObject *)
{
     ::wxTextAttrSize*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = &sipCpp->m_size;

    return sipConvertFromType(sipVal, sipType_wxTextAttrSize, NULL);
}


extern "C" {static int varset_wxTextBoxAttr_m_size(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_size(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextAttrSize*sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxTextAttrSize *>(sipForceConvertToType(sipPy,sipType_wxTextAttrSize,NULL,SIP_NOT_NONE,NULL,&sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_size = *sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextBoxAttr_m_verticalAlignment(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextBoxAttr_m_verticalAlignment(void *sipSelf, PyObject *, PyObject *)
{
     ::wxTextBoxAttrVerticalAlignment sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = sipCpp->m_verticalAlignment;

    return sipConvertFromEnum(sipVal, sipType_wxTextBoxAttrVerticalAlignment);
}


extern "C" {static int varset_wxTextBoxAttr_m_verticalAlignment(void *, PyObject *, PyObject *);}
static int varset_wxTextBoxAttr_m_verticalAlignment(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextBoxAttrVerticalAlignment sipVal;
     ::wxTextBoxAttr *sipCpp = reinterpret_cast< ::wxTextBoxAttr *>(sipSelf);

    sipVal = ( ::wxTextBoxAttrVerticalAlignment)SIPLong_AsLong(sipPy);

    if (PyErr_Occurred() != NULL)
        return -1;

    sipCpp->m_verticalAlignment = sipVal;

    return 0;
}

sipVariableDef variables_wxTextBoxAttr[] = {
    {PropertyVariable, sipName_Width, &methods_wxTextBoxAttr[39], NULL, NULL, NULL},
    {PropertyVariable, sipName_VerticalAlignment, &methods_wxTextBoxAttr[38], &methods_wxTextBoxAttr[60], NULL, NULL},
    {PropertyVariable, sipName_TopPadding, &methods_wxTextBoxAttr[37], NULL, NULL, NULL},
    {PropertyVariable, sipName_TopOutline, &methods_wxTextBoxAttr[36], NULL, NULL, NULL},
    {PropertyVariable, sipName_TopMargin, &methods_wxTextBoxAttr[35], NULL, NULL, NULL},
    {PropertyVariable, sipName_TopBorder, &methods_wxTextBoxAttr[34], NULL, NULL, NULL},
    {PropertyVariable, sipName_Top, &methods_wxTextBoxAttr[33], NULL, NULL, NULL},
    {PropertyVariable, sipName_Size, &methods_wxTextBoxAttr[32], &methods_wxTextBoxAttr[59], NULL, NULL},
    {PropertyVariable, sipName_RightPadding, &methods_wxTextBoxAttr[31], NULL, NULL, NULL},
    {PropertyVariable, sipName_RightOutline, &methods_wxTextBoxAttr[30], NULL, NULL, NULL},
    {PropertyVariable, sipName_RightMargin, &methods_wxTextBoxAttr[29], NULL, NULL, NULL},
    {PropertyVariable, sipName_RightBorder, &methods_wxTextBoxAttr[28], NULL, NULL, NULL},
    {PropertyVariable, sipName_Right, &methods_wxTextBoxAttr[27], NULL, NULL, NULL},
    {PropertyVariable, sipName_Position, &methods_wxTextBoxAttr[26], NULL, NULL, NULL},
    {PropertyVariable, sipName_Padding, &methods_wxTextBoxAttr[25], NULL, NULL, NULL},
    {PropertyVariable, sipName_Outline, &methods_wxTextBoxAttr[24], NULL, NULL, NULL},
    {PropertyVariable, sipName_MinSize, &methods_wxTextBoxAttr[23], &methods_wxTextBoxAttr[58], NULL, NULL},
    {PropertyVariable, sipName_MaxSize, &methods_wxTextBoxAttr[22], &methods_wxTextBoxAttr[57], NULL, NULL},
    {PropertyVariable, sipName_Margins, &methods_wxTextBoxAttr[21], NULL, NULL, NULL},
    {PropertyVariable, sipName_LeftPadding, &methods_wxTextBoxAttr[20], NULL, NULL, NULL},
    {PropertyVariable, sipName_LeftOutline, &methods_wxTextBoxAttr[19], NULL, NULL, NULL},
    {PropertyVariable, sipName_LeftMargin, &methods_wxTextBoxAttr[18], NULL, NULL, NULL},
    {PropertyVariable, sipName_LeftBorder, &methods_wxTextBoxAttr[17], NULL, NULL, NULL},
    {PropertyVariable, sipName_Left, &methods_wxTextBoxAttr[16], NULL, NULL, NULL},
    {PropertyVariable, sipName_Height, &methods_wxTextBoxAttr[15], NULL, NULL, NULL},
    {PropertyVariable, sipName_FloatMode, &methods_wxTextBoxAttr[14], &methods_wxTextBoxAttr[56], NULL, NULL},
    {PropertyVariable, sipName_Flags, &methods_wxTextBoxAttr[13], &methods_wxTextBoxAttr[55], NULL, NULL},
    {PropertyVariable, sipName_CollapseBorders, &methods_wxTextBoxAttr[12], &methods_wxTextBoxAttr[54], NULL, NULL},
    {PropertyVariable, sipName_ClearMode, &methods_wxTextBoxAttr[11], &methods_wxTextBoxAttr[53], NULL, NULL},
    {PropertyVariable, sipName_BoxStyleName, &methods_wxTextBoxAttr[10], &methods_wxTextBoxAttr[52], NULL, NULL},
    {PropertyVariable, sipName_BottomPadding, &methods_wxTextBoxAttr[9], NULL, NULL, NULL},
    {PropertyVariable, sipName_BottomOutline, &methods_wxTextBoxAttr[8], NULL, NULL, NULL},
    {PropertyVariable, sipName_BottomMargin, &methods_wxTextBoxAttr[7], NULL, NULL, NULL},
    {PropertyVariable, sipName_BottomBorder, &methods_wxTextBoxAttr[6], NULL, NULL, NULL},
    {PropertyVariable, sipName_Bottom, &methods_wxTextBoxAttr[5], NULL, NULL, NULL},
    {PropertyVariable, sipName_Border, &methods_wxTextBoxAttr[4], NULL, NULL, NULL},
    {InstanceVariable, sipName_m_border, (PyMethodDef *)varget_wxTextBoxAttr_m_border, (PyMethodDef *)varset_wxTextBoxAttr_m_border, NULL, NULL},
    {InstanceVariable, sipName_m_boxStyleName, (PyMethodDef *)varget_wxTextBoxAttr_m_boxStyleName, (PyMethodDef *)varset_wxTextBoxAttr_m_boxStyleName, NULL, NULL},
    {InstanceVariable, sipName_m_clearMode, (PyMethodDef *)varget_wxTextBoxAttr_m_clearMode, (PyMethodDef *)varset_wxTextBoxAttr_m_clearMode, NULL, NULL},
    {InstanceVariable, sipName_m_collapseMode, (PyMethodDef *)varget_wxTextBoxAttr_m_collapseMode, (PyMethodDef *)varset_wxTextBoxAttr_m_collapseMode, NULL, NULL},
    {InstanceVariable, sipName_m_flags, (PyMethodDef *)varget_wxTextBoxAttr_m_flags, (PyMethodDef *)varset_wxTextBoxAttr_m_flags, NULL, NULL},
    {InstanceVariable, sipName_m_floatMode, (PyMethodDef *)varget_wxTextBoxAttr_m_floatMode, (PyMethodDef *)varset_wxTextBoxAttr_m_floatMode, NULL, NULL},
    {InstanceVariable, sipName_m_margins, (PyMethodDef *)varget_wxTextBoxAttr_m_margins, (PyMethodDef *)varset_wxTextBoxAttr_m_margins, NULL, NULL},
    {InstanceVariable, sipName_m_maxSize, (PyMethodDef *)varget_wxTextBoxAttr_m_maxSize, (PyMethodDef *)varset_wxTextBoxAttr_m_maxSize, NULL, NULL},
    {InstanceVariable, sipName_m_minSize, (PyMethodDef *)varget_wxTextBoxAttr_m_minSize, (PyMethodDef *)varset_wxTextBoxAttr_m_minSize, NULL, NULL},
    {InstanceVariable, sipName_m_outline, (PyMethodDef *)varget_wxTextBoxAttr_m_outline, (PyMethodDef *)varset_wxTextBoxAttr_m_outline, NULL, NULL},
    {InstanceVariable, sipName_m_padding, (PyMethodDef *)varget_wxTextBoxAttr_m_padding, (PyMethodDef *)varset_wxTextBoxAttr_m_padding, NULL, NULL},
    {InstanceVariable, sipName_m_position, (PyMethodDef *)varget_wxTextBoxAttr_m_position, (PyMethodDef *)varset_wxTextBoxAttr_m_position, NULL, NULL},
    {InstanceVariable, sipName_m_size, (PyMethodDef *)varget_wxTextBoxAttr_m_size, (PyMethodDef *)varset_wxTextBoxAttr_m_size, NULL, NULL},
    {InstanceVariable, sipName_m_verticalAlignment, (PyMethodDef *)varget_wxTextBoxAttr_m_verticalAlignment, (PyMethodDef *)varset_wxTextBoxAttr_m_verticalAlignment, NULL, NULL},
};

PyDoc_STRVAR(doc_wxTextBoxAttr, "TextBoxAttr()\n"
    "TextBoxAttr(attr)\n"
    "\n"
    "A class representing the box attributes of a rich text object.");


sipClassTypeDef sipTypeDef__richtext_wxTextBoxAttr = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxTextBoxAttr,
        {0},
        0
    },
    {
        sipNameNr_TextBoxAttr,
        {0, 0, 1},
        61, methods_wxTextBoxAttr,
        0, 0,
        50, variables_wxTextBoxAttr,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxTextBoxAttr,
    -1,
    -1,
    0,
    slots_wxTextBoxAttr,
    init_type_wxTextBoxAttr,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxTextBoxAttr,
    assign_wxTextBoxAttr,
    array_wxTextBoxAttr,
    copy_wxTextBoxAttr,
    release_wxTextBoxAttr,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
