# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# This file is generated by wxPython's PI generator.  Do not edit by hand.
#
# The *.pyi files are used by PyCharm to provide more information than it is
# able to glean from introspection of extension types and methods.  They are
# not intended to be imported, executed or used for any other purpose other
# than providing info to the IDE.  If you don't use PyCharm you can safely
# ignore this file.
#
# See: https://www.jetbrains.com/help/pycharm/2016.1/type-hinting-in-pycharm.html
#
# Copyright: (c) 2011-2016 by Total Control Software
# License:   wxWindows License
#---------------------------------------------------------------------------


"""
The classes in this module are the most commonly used classes for wxPython,
which is why they have been made visible in the core `wx` namespace.
Everything you need for building typical GUI applications is here.
"""
#-- begin-_core --#

#-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# This code block was included from src/core_ex.py
import sys as _sys

# Load version numbers from __version__ and some other initialization tasks...
if 'wxEVT_NULL' in dir():
    from wx.__version__ import *
    import wx._core
    __version__ = VERSION_STRING

    # Register a function to be called when Python terminates that will clean
    # up and release all system resources that wxWidgets allocated.
    import atexit
    atexit.register(wx._core._wxPyCleanup)
    del atexit

else:
    Port = ''
    Platform = ''
    PlatformInfo = []

# A little trick to make 'wx' be a reference to this module so wx.Names can
# be used in the python code here.
wx = _sys.modules[__name__]


import warnings
class wxPyDeprecationWarning(DeprecationWarning):
    pass

warnings.simplefilter('default', wxPyDeprecationWarning)
del warnings


def deprecated(item, msg='', useName=False):
    """
    Create a delegating wrapper that raises a deprecation warning.  Can be
    used with callable objects (functions, methods, classes) or with
    properties.
    """
    import warnings

    name = ''
    if useName:
        try:
            name = ' ' + item.__name__
        except AttributeError:
            pass

    if isinstance(item, type):
        # It is a class.  Make a subclass that raises a warning.
        class DeprecatedClassProxy(item):
            def __init__(*args, **kw):
                warnings.warn("Using deprecated class%s. %s" % (name, msg),
                          wxPyDeprecationWarning, stacklevel=2)
                item.__init__(*args, **kw)
        DeprecatedClassProxy.__name__ = item.__name__
        return DeprecatedClassProxy

    elif callable(item):
        # wrap a new function around the callable
        def deprecated_func(*args, **kw):
            warnings.warn("Call to deprecated item%s. %s" % (name, msg),
                          wxPyDeprecationWarning, stacklevel=2)
            if not kw:
                return item(*args)
            return item(*args, **kw)
        deprecated_func.__name__ = item.__name__
        deprecated_func.__doc__ = item.__doc__
        if hasattr(item, '__dict__'):
            deprecated_func.__dict__.update(item.__dict__)
        return deprecated_func

    elif hasattr(item, '__get__'):
        # it should be a property if there is a getter
        class DepGetProp(object):
            def __init__(self, item, msg):
                self.item = item
                self.msg = msg
            def __get__(self, inst, klass):
                warnings.warn("Accessing deprecated property. %s" % msg,
                              wxPyDeprecationWarning, stacklevel=2)
                return self.item.__get__(inst, klass)
        class DepGetSetProp(DepGetProp):
            def __set__(self, inst, val):
                warnings.warn("Accessing deprecated property. %s" % msg,
                              wxPyDeprecationWarning, stacklevel=2)
                return self.item.__set__(inst, val)
        class DepGetSetDelProp(DepGetSetProp):
            def __delete__(self, inst):
                warnings.warn("Accessing deprecated property. %s" % msg,
                              wxPyDeprecationWarning, stacklevel=2)
                return self.item.__delete__(inst)

        if hasattr(item, '__set__') and hasattr(item, '__delete__'):
            return DepGetSetDelProp(item, msg)
        elif hasattr(item, '__set__'):
            return DepGetSetProp(item, msg)
        else:
            return DepGetProp(item, msg)
    else:
        raise TypeError("unsupported type %s" % type(item))


def deprecatedMsg(msg):
    """
    A wrapper for the deprecated decorator that makes it easier to attach a
    custom message to the warning that is raised if the item is used. This
    can also be used in the @decorator role since it returns the real
    decorator when called.
    """
    import functools
    return functools.partial(deprecated, msg=msg, useName=True)

#----------------------------------------------------------------------------

EmptyString = ""

#----------------------------------------------------------------------------

# End of included code block
#-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

def version():
    """
    Returns a string containing version and port info
    """
    pass

def CallAfter(callableObj, *args, **kw):
    """
    Call the specified function after the current and pending event
    handlers have been completed.  This is also good for making GUI
    method calls from non-GUI threads.  Any extra positional or
    keyword args are passed on to the callable when it is called.
    
    :param PyObject callableObj: the callable object
    :param args: arguments to be passed to the callable object
    :param kw: keywords to be passed to the callable object
    
    .. seealso::
        :ref:`wx.CallLater`
    """
    pass
class CallLater(object):
    """
    A convenience class for :class:`wx.Timer`, that calls the given callable
    object once after the given amount of milliseconds, passing any
    positional or keyword args.  The return value of the callable is
    available after it has been run with the :meth:`~wx.CallLater.GetResult`
    method.
    
    If you don't need to get the return value or restart the timer
    then there is no need to hold a reference to this object.  It will
    hold a reference to itself while the timer is running (the timer
    has a reference to :meth:`~wx.CallLater.Notify`) but the cycle will be
    broken when the timer completes, automatically cleaning up the
    :class:`wx.CallLater` object.
    
    .. seealso::
        :func:`wx.CallAfter`
    """

    def __init__(self, millis, callableObj, *args, **kwargs):
        """
        Constructs a new :class:`wx.CallLater` object.
        
        :param int millis: number of milliseconds to delay until calling the callable object
        :param PyObject callableObj: the callable object
        :param args: arguments to be passed to the callable object
        :param kw: keywords to be passed to the callable object
        """
        pass

    def __del__(self):
        pass

    def Start(self, millis=None, *args, **kwargs):
        """
        (Re)start the timer
        
        :param int millis: number of milli seconds
        :param args: arguments to be passed to the callable object
        :param kw: keywords to be passed to the callable object
        """
        pass

    Restart = Start

    def Stop(self):
        """
        Stop and destroy the timer.
        """
        pass

    def GetInterval(self):
        pass

    def IsRunning(self):
        pass

    def SetArgs(self, *args, **kwargs):
        """
        (Re)set the args passed to the callable object.  This is
        useful in conjunction with :meth:`Start` if
        you want to schedule a new call to the same callable
        object but with different parameters.
        
        :param args: arguments to be passed to the callable object
        :param kw: keywords to be passed to the callable object
        """
        pass

    def HasRun(self):
        """
        Returns whether or not the callable has run.
        
        :rtype: bool
        """
        pass

    def GetResult(self):
        """
        Returns the value of the callable.
        
        :rtype: a Python object
        :return: result from callable
        """
        pass

    def Notify(self):
        """
        The timer has expired so call the callable.
        """
        pass
    Interval = property(None, None)
    Result = property(None, None)

FutureCall = deprecated(CallLater, 'Use CallLater instead.')

def GetDefaultPyEncoding():
    return "utf-8"
GetDefaultPyEncoding = deprecated(GetDefaultPyEncoding, msg="wxPython now always uses utf-8")

def IsMainThread(self):
    """
    IsMainThread() -> bool
    
    Returns ``True`` if the current thread is what wx considers the GUI
    thread.
    """
#-- end-_core --#
#-- begin-defs --#
INT8_MIN = 0
INT8_MAX = 0
UINT8_MAX = 0
INT16_MIN = 0
INT16_MAX = 0
UINT16_MAX = 0
INT32_MIN = 0
INT32_MAX = 0
UINT32_MAX = 0
INT64_MIN = 0
INT64_MAX = 0
UINT64_MAX = 0
SIZE_AUTO_WIDTH = 0
SIZE_AUTO_HEIGHT = 0
SIZE_AUTO = 0
SIZE_USE_EXISTING = 0
SIZE_ALLOW_MINUS_ONE = 0
SIZE_NO_ADJUSTMENTS = 0
SIZE_FORCE = 0
SIZE_FORCE_EVENT = 0
VSCROLL = 0
HSCROLL = 0
CAPTION = 0
DOUBLE_BORDER = 0
SUNKEN_BORDER = 0
RAISED_BORDER = 0
BORDER = 0
SIMPLE_BORDER = 0
STATIC_BORDER = 0
NO_BORDER = 0
ALWAYS_SHOW_SB = 0
CLIP_CHILDREN = 0
CLIP_SIBLINGS = 0
TRANSPARENT_WINDOW = 0
TAB_TRAVERSAL = 0
WANTS_CHARS = 0
RETAINED = 0
BACKINGSTORE = 0
POPUP_WINDOW = 0
FULL_REPAINT_ON_RESIZE = 0
NO_FULL_REPAINT_ON_RESIZE = 0
WINDOW_STYLE_MASK = 0
WS_EX_VALIDATE_RECURSIVELY = 0
WS_EX_BLOCK_EVENTS = 0
WS_EX_TRANSIENT = 0
WS_EX_THEMED_BACKGROUND = 0
WS_EX_PROCESS_IDLE = 0
WS_EX_PROCESS_UI_UPDATES = 0
FRAME_EX_METAL = 0
DIALOG_EX_METAL = 0
WS_EX_CONTEXTHELP = 0
FRAME_EX_CONTEXTHELP = 0
DIALOG_EX_CONTEXTHELP = 0
FRAME_DRAWER = 0
FRAME_NO_WINDOW_MENU = 0
MB_DOCKABLE = 0
MENU_TEAROFF = 0
COLOURED = 0
FIXED_LENGTH = 0
LB_SORT = 0
LB_SINGLE = 0
LB_MULTIPLE = 0
LB_EXTENDED = 0
LB_NEEDED_SB = 0
LB_OWNERDRAW = 0
LB_ALWAYS_SB = 0
LB_NO_SB = 0
LB_HSCROLL = 0
LB_INT_HEIGHT = 0
CB_SIMPLE = 0
CB_SORT = 0
CB_READONLY = 0
CB_DROPDOWN = 0
RA_LEFTTORIGHT = 0
RA_TOPTOBOTTOM = 0
RA_SPECIFY_COLS = 0
RA_SPECIFY_ROWS = 0
RA_HORIZONTAL = 0
RA_VERTICAL = 0
RB_GROUP = 0
RB_SINGLE = 0
SB_HORIZONTAL = 0
SB_VERTICAL = 0
SP_HORIZONTAL = 0
SP_VERTICAL = 0
SP_ARROW_KEYS = 0
SP_WRAP = 0
TC_RIGHTJUSTIFY = 0
TC_FIXEDWIDTH = 0
TC_TOP = 0
TC_LEFT = 0
TC_RIGHT = 0
TC_BOTTOM = 0
TC_MULTILINE = 0
TC_OWNERDRAW = 0
BI_EXPAND = 0
LI_HORIZONTAL = 0
LI_VERTICAL = 0
YES = 0
OK = 0
NO = 0
YES_NO = 0
CANCEL = 0
APPLY = 0
CLOSE = 0
OK_DEFAULT = 0
YES_DEFAULT = 0
NO_DEFAULT = 0
CANCEL_DEFAULT = 0
ICON_EXCLAMATION = 0
ICON_HAND = 0
ICON_WARNING = 0
ICON_ERROR = 0
ICON_QUESTION = 0
ICON_INFORMATION = 0
ICON_STOP = 0
ICON_ASTERISK = 0
HELP = 0
FORWARD = 0
BACKWARD = 0
RESET = 0
MORE = 0
SETUP = 0
ICON_NONE = 0
ICON_AUTH_NEEDED = 0
ICON_MASK = 0
NOT_FOUND = 0
PRINT_QUALITY_HIGH = 0
PRINT_QUALITY_MEDIUM = 0
PRINT_QUALITY_LOW = 0
PRINT_QUALITY_DRAFT = 0
STAY_ON_TOP = 0
ICONIZE = 0
MINIMIZE = 0
MAXIMIZE = 0
CLOSE_BOX = 0
SYSTEM_MENU = 0
MINIMIZE_BOX = 0
MAXIMIZE_BOX = 0
TINY_CAPTION = 0
RESIZE_BORDER = 0
CENTRE = 0
CENTER = 0
HORIZONTAL = 0
VERTICAL = 0
BOTH = 0
ORIENTATION_MASK = 0
LEFT = 0
RIGHT = 0
UP = 0
DOWN = 0
TOP = 0
BOTTOM = 0
NORTH = 0
SOUTH = 0
WEST = 0
EAST = 0
ALL = 0
DIRECTION_MASK = 0
ALIGN_INVALID = 0
ALIGN_NOT = 0
ALIGN_CENTER_HORIZONTAL = 0
ALIGN_CENTRE_HORIZONTAL = 0
ALIGN_LEFT = 0
ALIGN_TOP = 0
ALIGN_RIGHT = 0
ALIGN_BOTTOM = 0
ALIGN_CENTER_VERTICAL = 0
ALIGN_CENTRE_VERTICAL = 0
ALIGN_CENTER = 0
ALIGN_CENTRE = 0
ALIGN_MASK = 0
FIXED_MINSIZE = 0
RESERVE_SPACE_EVEN_IF_HIDDEN = 0
SIZER_FLAG_BITS_MASK = 0
STRETCH_NOT = 0
SHRINK = 0
GROW = 0
EXPAND = 0
SHAPED = 0
TILE = 0
STRETCH_MASK = 0
BORDER_DEFAULT = 0
BORDER_NONE = 0
BORDER_STATIC = 0
BORDER_SIMPLE = 0
BORDER_RAISED = 0
BORDER_SUNKEN = 0
BORDER_DOUBLE = 0
BORDER_THEME = 0
BORDER_MASK = 0
BG_STYLE_ERASE = 0
BG_STYLE_SYSTEM = 0
BG_STYLE_PAINT = 0
BG_STYLE_COLOUR = 0
BG_STYLE_TRANSPARENT = 0
ID_AUTO_LOWEST = 0
ID_AUTO_HIGHEST = 0
ID_NONE = 0
ID_SEPARATOR = 0
ID_ANY = 0
ID_LOWEST = 0
ID_OPEN = 0
ID_CLOSE = 0
ID_NEW = 0
ID_SAVE = 0
ID_SAVEAS = 0
ID_REVERT = 0
ID_EXIT = 0
ID_UNDO = 0
ID_REDO = 0
ID_HELP = 0
ID_PRINT = 0
ID_PRINT_SETUP = 0
ID_PAGE_SETUP = 0
ID_PREVIEW = 0
ID_ABOUT = 0
ID_HELP_CONTENTS = 0
ID_HELP_INDEX = 0
ID_HELP_SEARCH = 0
ID_HELP_COMMANDS = 0
ID_HELP_PROCEDURES = 0
ID_HELP_CONTEXT = 0
ID_CLOSE_ALL = 0
ID_PREFERENCES = 0
ID_EDIT = 0
ID_CUT = 0
ID_COPY = 0
ID_PASTE = 0
ID_CLEAR = 0
ID_FIND = 0
ID_DUPLICATE = 0
ID_SELECTALL = 0
ID_DELETE = 0
ID_REPLACE = 0
ID_REPLACE_ALL = 0
ID_PROPERTIES = 0
ID_VIEW_DETAILS = 0
ID_VIEW_LARGEICONS = 0
ID_VIEW_SMALLICONS = 0
ID_VIEW_LIST = 0
ID_VIEW_SORTDATE = 0
ID_VIEW_SORTNAME = 0
ID_VIEW_SORTSIZE = 0
ID_VIEW_SORTTYPE = 0
ID_FILE = 0
ID_FILE1 = 0
ID_FILE2 = 0
ID_FILE3 = 0
ID_FILE4 = 0
ID_FILE5 = 0
ID_FILE6 = 0
ID_FILE7 = 0
ID_FILE8 = 0
ID_FILE9 = 0
ID_OK = 0
ID_CANCEL = 0
ID_APPLY = 0
ID_YES = 0
ID_NO = 0
ID_STATIC = 0
ID_FORWARD = 0
ID_BACKWARD = 0
ID_DEFAULT = 0
ID_MORE = 0
ID_SETUP = 0
ID_RESET = 0
ID_CONTEXT_HELP = 0
ID_YESTOALL = 0
ID_NOTOALL = 0
ID_ABORT = 0
ID_RETRY = 0
ID_IGNORE = 0
ID_ADD = 0
ID_REMOVE = 0
ID_UP = 0
ID_DOWN = 0
ID_HOME = 0
ID_REFRESH = 0
ID_STOP = 0
ID_INDEX = 0
ID_BOLD = 0
ID_ITALIC = 0
ID_JUSTIFY_CENTER = 0
ID_JUSTIFY_FILL = 0
ID_JUSTIFY_RIGHT = 0
ID_JUSTIFY_LEFT = 0
ID_UNDERLINE = 0
ID_INDENT = 0
ID_UNINDENT = 0
ID_ZOOM_100 = 0
ID_ZOOM_FIT = 0
ID_ZOOM_IN = 0
ID_ZOOM_OUT = 0
ID_UNDELETE = 0
ID_REVERT_TO_SAVED = 0
ID_CDROM = 0
ID_CONVERT = 0
ID_EXECUTE = 0
ID_FLOPPY = 0
ID_HARDDISK = 0
ID_BOTTOM = 0
ID_FIRST = 0
ID_LAST = 0
ID_TOP = 0
ID_INFO = 0
ID_JUMP_TO = 0
ID_NETWORK = 0
ID_SELECT_COLOR = 0
ID_SELECT_FONT = 0
ID_SORT_ASCENDING = 0
ID_SORT_DESCENDING = 0
ID_SPELL_CHECK = 0
ID_STRIKETHROUGH = 0
ID_SYSTEM_MENU = 0
ID_CLOSE_FRAME = 0
ID_MOVE_FRAME = 0
ID_RESIZE_FRAME = 0
ID_MAXIMIZE_FRAME = 0
ID_ICONIZE_FRAME = 0
ID_RESTORE_FRAME = 0
ID_MDI_WINDOW_FIRST = 0
ID_MDI_WINDOW_CASCADE = 0
ID_MDI_WINDOW_TILE_HORZ = 0
ID_MDI_WINDOW_TILE_VERT = 0
ID_MDI_WINDOW_ARRANGE_ICONS = 0
ID_MDI_WINDOW_PREV = 0
ID_MDI_WINDOW_NEXT = 0
ID_MDI_WINDOW_LAST = 0
ID_FILEDLGG = 0
ID_FILECTRL = 0
ID_HIGHEST = 0
ITEM_SEPARATOR = 0
ITEM_NORMAL = 0
ITEM_CHECK = 0
ITEM_RADIO = 0
ITEM_DROPDOWN = 0
ITEM_MAX = 0
HT_NOWHERE = 0
HT_SCROLLBAR_FIRST = 0
HT_SCROLLBAR_ARROW_LINE_1 = 0
HT_SCROLLBAR_ARROW_LINE_2 = 0
HT_SCROLLBAR_ARROW_PAGE_1 = 0
HT_SCROLLBAR_ARROW_PAGE_2 = 0
HT_SCROLLBAR_THUMB = 0
HT_SCROLLBAR_BAR_1 = 0
HT_SCROLLBAR_BAR_2 = 0
HT_SCROLLBAR_LAST = 0
HT_WINDOW_OUTSIDE = 0
HT_WINDOW_INSIDE = 0
HT_WINDOW_VERT_SCROLLBAR = 0
HT_WINDOW_HORZ_SCROLLBAR = 0
HT_WINDOW_CORNER = 0
HT_MAX = 0
DF_INVALID = 0
DF_TEXT = 0
DF_BITMAP = 0
DF_METAFILE = 0
DF_SYLK = 0
DF_DIF = 0
DF_TIFF = 0
DF_OEMTEXT = 0
DF_DIB = 0
DF_PALETTE = 0
DF_PENDATA = 0
DF_RIFF = 0
DF_WAVE = 0
DF_UNICODETEXT = 0
DF_ENHMETAFILE = 0
DF_FILENAME = 0
DF_LOCALE = 0
DF_PRIVATE = 0
DF_HTML = 0
DF_MAX = 0
WXK_NONE = 0
WXK_CONTROL_A = 0
WXK_CONTROL_B = 0
WXK_CONTROL_C = 0
WXK_CONTROL_D = 0
WXK_CONTROL_E = 0
WXK_CONTROL_F = 0
WXK_CONTROL_G = 0
WXK_CONTROL_H = 0
WXK_CONTROL_I = 0
WXK_CONTROL_J = 0
WXK_CONTROL_K = 0
WXK_CONTROL_L = 0
WXK_CONTROL_M = 0
WXK_CONTROL_N = 0
WXK_CONTROL_O = 0
WXK_CONTROL_P = 0
WXK_CONTROL_Q = 0
WXK_CONTROL_R = 0
WXK_CONTROL_S = 0
WXK_CONTROL_T = 0
WXK_CONTROL_U = 0
WXK_CONTROL_V = 0
WXK_CONTROL_W = 0
WXK_CONTROL_X = 0
WXK_CONTROL_Y = 0
WXK_CONTROL_Z = 0
WXK_BACK = 0
WXK_TAB = 0
WXK_RETURN = 0
WXK_ESCAPE = 0
WXK_SPACE = 0
WXK_DELETE = 0
WXK_START = 0
WXK_LBUTTON = 0
WXK_RBUTTON = 0
WXK_CANCEL = 0
WXK_MBUTTON = 0
WXK_CLEAR = 0
WXK_SHIFT = 0
WXK_ALT = 0
WXK_CONTROL = 0
WXK_RAW_CONTROL = 0
WXK_MENU = 0
WXK_PAUSE = 0
WXK_CAPITAL = 0
WXK_END = 0
WXK_HOME = 0
WXK_LEFT = 0
WXK_UP = 0
WXK_RIGHT = 0
WXK_DOWN = 0
WXK_SELECT = 0
WXK_PRINT = 0
WXK_EXECUTE = 0
WXK_SNAPSHOT = 0
WXK_INSERT = 0
WXK_HELP = 0
WXK_NUMPAD0 = 0
WXK_NUMPAD1 = 0
WXK_NUMPAD2 = 0
WXK_NUMPAD3 = 0
WXK_NUMPAD4 = 0
WXK_NUMPAD5 = 0
WXK_NUMPAD6 = 0
WXK_NUMPAD7 = 0
WXK_NUMPAD8 = 0
WXK_NUMPAD9 = 0
WXK_MULTIPLY = 0
WXK_ADD = 0
WXK_SEPARATOR = 0
WXK_SUBTRACT = 0
WXK_DECIMAL = 0
WXK_DIVIDE = 0
WXK_F1 = 0
WXK_F2 = 0
WXK_F3 = 0
WXK_F4 = 0
WXK_F5 = 0
WXK_F6 = 0
WXK_F7 = 0
WXK_F8 = 0
WXK_F9 = 0
WXK_F10 = 0
WXK_F11 = 0
WXK_F12 = 0
WXK_F13 = 0
WXK_F14 = 0
WXK_F15 = 0
WXK_F16 = 0
WXK_F17 = 0
WXK_F18 = 0
WXK_F19 = 0
WXK_F20 = 0
WXK_F21 = 0
WXK_F22 = 0
WXK_F23 = 0
WXK_F24 = 0
WXK_NUMLOCK = 0
WXK_SCROLL = 0
WXK_PAGEUP = 0
WXK_PAGEDOWN = 0
WXK_NUMPAD_SPACE = 0
WXK_NUMPAD_TAB = 0
WXK_NUMPAD_ENTER = 0
WXK_NUMPAD_F1 = 0
WXK_NUMPAD_F2 = 0
WXK_NUMPAD_F3 = 0
WXK_NUMPAD_F4 = 0
WXK_NUMPAD_HOME = 0
WXK_NUMPAD_LEFT = 0
WXK_NUMPAD_UP = 0
WXK_NUMPAD_RIGHT = 0
WXK_NUMPAD_DOWN = 0
WXK_NUMPAD_PAGEUP = 0
WXK_NUMPAD_PAGEDOWN = 0
WXK_NUMPAD_END = 0
WXK_NUMPAD_BEGIN = 0
WXK_NUMPAD_INSERT = 0
WXK_NUMPAD_DELETE = 0
WXK_NUMPAD_EQUAL = 0
WXK_NUMPAD_MULTIPLY = 0
WXK_NUMPAD_ADD = 0
WXK_NUMPAD_SEPARATOR = 0
WXK_NUMPAD_SUBTRACT = 0
WXK_NUMPAD_DECIMAL = 0
WXK_NUMPAD_DIVIDE = 0
WXK_WINDOWS_LEFT = 0
WXK_WINDOWS_RIGHT = 0
WXK_WINDOWS_MENU = 0
WXK_COMMAND = 0
WXK_SPECIAL1 = 0
WXK_SPECIAL2 = 0
WXK_SPECIAL3 = 0
WXK_SPECIAL4 = 0
WXK_SPECIAL5 = 0
WXK_SPECIAL6 = 0
WXK_SPECIAL7 = 0
WXK_SPECIAL8 = 0
WXK_SPECIAL9 = 0
WXK_SPECIAL10 = 0
WXK_SPECIAL11 = 0
WXK_SPECIAL12 = 0
WXK_SPECIAL13 = 0
WXK_SPECIAL14 = 0
WXK_SPECIAL15 = 0
WXK_SPECIAL16 = 0
WXK_SPECIAL17 = 0
WXK_SPECIAL18 = 0
WXK_SPECIAL19 = 0
WXK_SPECIAL20 = 0
MOD_NONE = 0
MOD_ALT = 0
MOD_CONTROL = 0
MOD_ALTGR = 0
MOD_SHIFT = 0
MOD_META = 0
MOD_WIN = 0
MOD_RAW_CONTROL = 0
MOD_CMD = 0
MOD_ALL = 0
PAPER_10X11 = 0
PAPER_10X14 = 0
PAPER_11X17 = 0
PAPER_12X11 = 0
PAPER_15X11 = 0
PAPER_9X11 = 0
PAPER_A2 = 0
PAPER_A3 = 0
PAPER_A3_EXTRA = 0
PAPER_A3_EXTRA_TRANSVERSE = 0
PAPER_A3_ROTATED = 0
PAPER_A3_TRANSVERSE = 0
PAPER_A4 = 0
PAPER_A4SMALL = 0
PAPER_A4_EXTRA = 0
PAPER_A4_PLUS = 0
PAPER_A4_ROTATED = 0
PAPER_A4_TRANSVERSE = 0
PAPER_A5 = 0
PAPER_A5_EXTRA = 0
PAPER_A5_ROTATED = 0
PAPER_A5_TRANSVERSE = 0
PAPER_A6 = 0
PAPER_A6_ROTATED = 0
PAPER_A_PLUS = 0
PAPER_B4 = 0
PAPER_B4_JIS_ROTATED = 0
PAPER_B5 = 0
PAPER_B5_EXTRA = 0
PAPER_B5_JIS_ROTATED = 0
PAPER_B5_TRANSVERSE = 0
PAPER_B6_JIS = 0
PAPER_B6_JIS_ROTATED = 0
PAPER_B_PLUS = 0
PAPER_CSHEET = 0
PAPER_DBL_JAPANESE_POSTCARD = 0
PAPER_DBL_JAPANESE_POSTCARD_ROTATED = 0
PAPER_DSHEET = 0
PAPER_ENV_10 = 0
PAPER_ENV_11 = 0
PAPER_ENV_12 = 0
PAPER_ENV_14 = 0
PAPER_ENV_9 = 0
PAPER_ENV_B4 = 0
PAPER_ENV_B5 = 0
PAPER_ENV_B6 = 0
PAPER_ENV_C3 = 0
PAPER_ENV_C4 = 0
PAPER_ENV_C5 = 0
PAPER_ENV_C6 = 0
PAPER_ENV_C65 = 0
PAPER_ENV_DL = 0
PAPER_ENV_INVITE = 0
PAPER_ENV_ITALY = 0
PAPER_ENV_MONARCH = 0
PAPER_ENV_PERSONAL = 0
PAPER_ESHEET = 0
PAPER_EXECUTIVE = 0
PAPER_FANFOLD_LGL_GERMAN = 0
PAPER_FANFOLD_STD_GERMAN = 0
PAPER_FANFOLD_US = 0
PAPER_FOLIO = 0
PAPER_ISO_B4 = 0
PAPER_JAPANESE_POSTCARD = 0
PAPER_JAPANESE_POSTCARD_ROTATED = 0
PAPER_JENV_CHOU3 = 0
PAPER_JENV_CHOU3_ROTATED = 0
PAPER_JENV_CHOU4 = 0
PAPER_JENV_CHOU4_ROTATED = 0
PAPER_JENV_KAKU2 = 0
PAPER_JENV_KAKU2_ROTATED = 0
PAPER_JENV_KAKU3 = 0
PAPER_JENV_KAKU3_ROTATED = 0
PAPER_JENV_YOU4 = 0
PAPER_JENV_YOU4_ROTATED = 0
PAPER_LEDGER = 0
PAPER_LEGAL = 0
PAPER_LEGAL_EXTRA = 0
PAPER_LETTER = 0
PAPER_LETTERSMALL = 0
PAPER_LETTER_EXTRA = 0
PAPER_LETTER_EXTRA_TRANSVERSE = 0
PAPER_LETTER_PLUS = 0
PAPER_LETTER_ROTATED = 0
PAPER_LETTER_TRANSVERSE = 0
PAPER_NONE = 0
PAPER_NOTE = 0
PAPER_P16K = 0
PAPER_P16K_ROTATED = 0
PAPER_P32K = 0
PAPER_P32KBIG = 0
PAPER_P32KBIG_ROTATED = 0
PAPER_P32K_ROTATED = 0
PAPER_PENV_1 = 0
PAPER_PENV_10 = 0
PAPER_PENV_10_ROTATED = 0
PAPER_PENV_1_ROTATED = 0
PAPER_PENV_2 = 0
PAPER_PENV_2_ROTATED = 0
PAPER_PENV_3 = 0
PAPER_PENV_3_ROTATED = 0
PAPER_PENV_4 = 0
PAPER_PENV_4_ROTATED = 0
PAPER_PENV_5 = 0
PAPER_PENV_5_ROTATED = 0
PAPER_PENV_6 = 0
PAPER_PENV_6_ROTATED = 0
PAPER_PENV_7 = 0
PAPER_PENV_7_ROTATED = 0
PAPER_PENV_8 = 0
PAPER_PENV_8_ROTATED = 0
PAPER_PENV_9 = 0
PAPER_PENV_9_ROTATED = 0
PAPER_QUARTO = 0
PAPER_STATEMENT = 0
PAPER_TABLOID = 0
PAPER_TABLOID_EXTRA = 0
PORTRAIT = 0
LANDSCAPE = 0
DUPLEX_SIMPLEX = 0
DUPLEX_HORIZONTAL = 0
DUPLEX_VERTICAL = 0
PRINT_MODE_NONE = 0
PRINT_MODE_PREVIEW = 0
PRINT_MODE_FILE = 0
PRINT_MODE_PRINTER = 0
PRINT_MODE_STREAM = 0
UPDATE_UI_NONE = 0
UPDATE_UI_RECURSE = 0
UPDATE_UI_FROMIDLE = 0
DefaultCoord = 0

BG_STYLE_CUSTOM = BG_STYLE_PAINT
ADJUST_MINSIZE = 0
#-- end-defs --#
#-- begin-debug --#

def Abort():
    """
    Abort()
    
    Exits the program immediately.
    """

def DisableAsserts():
    """
    DisableAsserts()
    
    Disable the condition checks in the assertions.
    """

def Trap():
    """
    Trap()
    
    Generate a debugger exception meaning that the control is passed to
    the debugger if one is attached to the process.
    """
#-- end-debug --#
#-- begin-object --#

class RefCounter(object):
    """
    RefCounter()
    
    This class is used to manage reference-counting providing a simple
    interface and a counter.
    """

    def __init__(self):
        """
        RefCounter()
        
        This class is used to manage reference-counting providing a simple
        interface and a counter.
        """

    def DecRef(self):
        """
        DecRef()
        
        Decrements the reference count associated with this shared data and,
        if it reaches zero, destroys this instance of wxRefCounter releasing
        its memory.
        """

    def GetRefCount(self):
        """
        GetRefCount() -> int
        
        Returns the reference count associated with this shared data.
        """

    def IncRef(self):
        """
        IncRef()
        
        Increments the reference count associated with this shared data.
        """
    RefCount = property(None, None)
# end of class RefCounter


class Object(object):
    """
    Object()
    Object(other)
    
    This is the root class of many of the wxWidgets classes.
    """

    def __init__(self, *args, **kw):
        """
        Object()
        Object(other)
        
        This is the root class of many of the wxWidgets classes.
        """

    def GetRefData(self):
        """
        GetRefData() -> ObjectRefData
        
        Returns the wxObject::m_refData pointer, i.e. the data referenced by
        this object.
        """

    def IsSameAs(self, obj):
        """
        IsSameAs(obj) -> bool
        
        Returns true if this object has the same data pointer as obj.
        """

    def Ref(self, clone):
        """
        Ref(clone)
        
        Makes this object refer to the data in clone.
        """

    def SetRefData(self, data):
        """
        SetRefData(data)
        
        Sets the wxObject::m_refData pointer.
        """

    def UnRef(self):
        """
        UnRef()
        
        Decrements the reference count in the associated data, and if it is
        zero, deletes the data.
        """

    def UnShare(self):
        """
        UnShare()
        
        This is the same of AllocExclusive() but this method is public.
        """

    def GetClassName(self):
        """
        GetClassName() -> Char
        
        Returns the class name of the C++ class using wxRTTI.
        """

    def Destroy(self):
        """
        Destroy()
        
        Deletes the C++ object this Python object is a proxy for.
        """
    ClassName = property(None, None)
    RefData = property(None, None)
# end of class Object

#-- end-object --#
#-- begin-clntdatactnr --#

class ClientDataContainer(object):
    """
    ClientDataContainer()
    
    This class is a mixin that provides storage and management of "client
    data".
    """

    def __init__(self):
        """
        ClientDataContainer()
        
        This class is a mixin that provides storage and management of "client
        data".
        """

    def GetClientData(self):
        """
        GetClientData() -> ClientData
        
        Get a pointer to the client data object.
        """

    def SetClientData(self, data):
        """
        SetClientData(data)
        
        Set the client data object.
        """

    def GetClientObject(self):
        """
        Alias for :meth:`GetClientData`
        """

    def SetClientObject(self, data):
        """
        Alias for :meth:`SetClientData`
        """
    ClientData = property(None, None)
# end of class ClientDataContainer

#-- end-clntdatactnr --#
#-- begin-wxdatetime --#
DefaultTimeSpanFormat = ""
DefaultDateTimeFormat = ""

class DateTime(object):
    """
    DateTime()
    DateTime(date)
    DateTime(day, month, year=Inv_Year, hour=0, minute=0, second=0, millisec=0)
    
    wxDateTime class represents an absolute moment in time.
    """

    class TimeZone(object):
        """
        TimeZone(tz)
        TimeZone(offset=0)
        
        Class representing a time zone.
        """

        def __init__(self, *args, **kw):
            """
            TimeZone(tz)
            TimeZone(offset=0)
            
            Class representing a time zone.
            """

        def GetOffset(self):
            """
            GetOffset() -> long
            
            Return the offset of this time zone from UTC, in seconds.
            """

        @staticmethod
        def Make(offset):
            """
            Make(offset) -> DateTime.TimeZone
            
            Create a time zone with the given offset in seconds.
            """
        Offset = property(None, None)
    # end of class TimeZone


    class Tm(object):
        """
        Contains broken down date-time representation.
        """
        msec = property(None, None)
        sec = property(None, None)
        min = property(None, None)
        hour = property(None, None)
        mday = property(None, None)
        yday = property(None, None)
        mon = property(None, None)
        year = property(None, None)

        def IsValid(self):
            """
            IsValid() -> bool
            
            Check if the given date/time is valid (in Gregorian calendar).
            """

        def GetWeekDay(self):
            """
            GetWeekDay() -> DateTime.WeekDay
            
            Return the week day corresponding to this date.
            """
        WeekDay = property(None, None)
    # end of class Tm

    Local = 0
    GMT_12 = 0
    GMT_11 = 0
    GMT_10 = 0
    GMT_9 = 0
    GMT_8 = 0
    GMT_7 = 0
    GMT_6 = 0
    GMT_5 = 0
    GMT_4 = 0
    GMT_3 = 0
    GMT_2 = 0
    GMT_1 = 0
    GMT0 = 0
    GMT1 = 0
    GMT2 = 0
    GMT3 = 0
    GMT4 = 0
    GMT5 = 0
    GMT6 = 0
    GMT7 = 0
    GMT8 = 0
    GMT9 = 0
    GMT10 = 0
    GMT11 = 0
    GMT12 = 0
    GMT13 = 0
    WET = 0
    WEST = 0
    CET = 0
    CEST = 0
    EET = 0
    EEST = 0
    MSK = 0
    MSD = 0
    AST = 0
    ADT = 0
    EST = 0
    EDT = 0
    CST = 0
    CDT = 0
    MST = 0
    MDT = 0
    PST = 0
    PDT = 0
    HST = 0
    AKST = 0
    AKDT = 0
    A_WST = 0
    A_CST = 0
    A_EST = 0
    A_ESST = 0
    NZST = 0
    NZDT = 0
    UTC = 0
    Gregorian = 0
    Julian = 0
    Country_Unknown = 0
    Country_Default = 0
    Country_WesternEurope_Start = 0
    Country_EEC = 0
    France = 0
    Germany = 0
    UK = 0
    Country_WesternEurope_End = 0
    Russia = 0
    USA = 0
    Jan = 0
    Feb = 0
    Mar = 0
    Apr = 0
    May = 0
    Jun = 0
    Jul = 0
    Aug = 0
    Sep = 0
    Oct = 0
    Nov = 0
    Dec = 0
    Inv_Month = 0
    Sun = 0
    Mon = 0
    Tue = 0
    Wed = 0
    Thu = 0
    Fri = 0
    Sat = 0
    Inv_WeekDay = 0
    Inv_Year = 0
    Name_Full = 0
    Name_Abbr = 0
    Default_First = 0
    Monday_First = 0
    Sunday_First = 0

    def __init__(self, *args, **kw):
        """
        DateTime()
        DateTime(date)
        DateTime(day, month, year=Inv_Year, hour=0, minute=0, second=0, millisec=0)
        
        wxDateTime class represents an absolute moment in time.
        """

    def ResetTime(self):
        """
        ResetTime() -> DateTime
        
        Reset time to midnight (00:00:00) without changing the date.
        """

    def Set(self, day, month, year=Inv_Year, hour=0, minute=0, second=0, millisec=0):
        """
        Set(day, month, year=Inv_Year, hour=0, minute=0, second=0, millisec=0) -> DateTime
        
        Sets the date and time from the parameters.
        """

    def SetHMS(self, hour, minute=0, second=0, millisec=0):
        """
        SetHMS(hour, minute=0, second=0, millisec=0) -> DateTime
        
        Sets the date to be equal to Today() and the time from supplied
        parameters.
        """

    def SetJDN(self, jdn):
        """
        SetJDN(jdn) -> DateTime
        
        Sets the date from the so-called Julian Day Number.
        """

    def SetTimeT(self, timet):
        """
        SetTimeT(timet) -> DateTime
        
        Constructs the object from timet value holding the number of seconds
        since Jan 1, 1970 UTC.
        """

    def SetTm(self, tm):
        """
        SetTm(tm) -> DateTime
        
        Sets the date and time from the broken down representation in the
        wxDateTime::Tm structure.
        """

    def SetDay(self, day):
        """
        SetDay(day) -> DateTime
        
        Sets the day without changing other date components.
        """

    def SetFromDOS(self, ddt):
        """
        SetFromDOS(ddt) -> DateTime
        
        Sets the date from the date and time in DOS format.
        """

    def SetHour(self, hour):
        """
        SetHour(hour) -> DateTime
        
        Sets the hour without changing other date components.
        """

    def SetMillisecond(self, millisecond):
        """
        SetMillisecond(millisecond) -> DateTime
        
        Sets the millisecond without changing other date components.
        """

    def SetMinute(self, minute):
        """
        SetMinute(minute) -> DateTime
        
        Sets the minute without changing other date components.
        """

    def SetMonth(self, month):
        """
        SetMonth(month) -> DateTime
        
        Sets the month without changing other date components.
        """

    def SetSecond(self, second):
        """
        SetSecond(second) -> DateTime
        
        Sets the second without changing other date components.
        """

    def SetToCurrent(self):
        """
        SetToCurrent() -> DateTime
        
        Sets the date and time of to the current values.
        """

    def SetYear(self, year):
        """
        SetYear(year) -> DateTime
        
        Sets the year without changing other date components.
        """

    def GetAsDOS(self):
        """
        GetAsDOS() -> unsignedlong
        
        Returns the date and time in DOS format.
        """

    def GetCentury(self, tz=Local):
        """
        GetCentury(tz=Local) -> int
        
        Returns the century of this date.
        """

    def GetDateOnly(self):
        """
        GetDateOnly() -> DateTime
        
        Returns the object having the same date component as this one but time
        of 00:00:00.
        """

    def GetDay(self, tz=Local):
        """
        GetDay(tz=Local) -> unsignedshort
        
        Returns the day in the given timezone (local one by default).
        """

    def GetDayOfYear(self, tz=Local):
        """
        GetDayOfYear(tz=Local) -> unsignedshort
        
        Returns the day of the year (in 1-366 range) in the given timezone
        (local one by default).
        """

    def GetHour(self, tz=Local):
        """
        GetHour(tz=Local) -> unsignedshort
        
        Returns the hour in the given timezone (local one by default).
        """

    def GetMillisecond(self, tz=Local):
        """
        GetMillisecond(tz=Local) -> unsignedshort
        
        Returns the milliseconds in the given timezone (local one by default).
        """

    def GetMinute(self, tz=Local):
        """
        GetMinute(tz=Local) -> unsignedshort
        
        Returns the minute in the given timezone (local one by default).
        """

    def GetMonth(self, tz=Local):
        """
        GetMonth(tz=Local) -> DateTime.Month
        
        Returns the month in the given timezone (local one by default).
        """

    def GetSecond(self, tz=Local):
        """
        GetSecond(tz=Local) -> unsignedshort
        
        Returns the seconds in the given timezone (local one by default).
        """

    def GetTicks(self):
        """
        GetTicks() -> time_t
        
        Returns the number of seconds since Jan 1, 1970 UTC.
        """

    def GetTm(self, tz=Local):
        """
        GetTm(tz=Local) -> DateTime.Tm
        
        Returns broken down representation of the date and time.
        """

    def GetWeekDay(self, *args, **kw):
        """
        GetWeekDay(tz=Local) -> DateTime.WeekDay
        GetWeekDay(weekday, n=1, month=Inv_Month, year=Inv_Year) -> DateTime
        
        Returns the week day in the given timezone (local one by default).
        """

    def GetWeekOfMonth(self, flags=Monday_First, tz=Local):
        """
        GetWeekOfMonth(flags=Monday_First, tz=Local) -> unsignedshort
        
        Returns the ordinal number of the week in the month (in 1-5 range).
        """

    def GetWeekOfYear(self, flags=Monday_First, tz=Local):
        """
        GetWeekOfYear(flags=Monday_First, tz=Local) -> unsignedshort
        
        Returns the number of the week of the year this date is in.
        """

    def GetYear(self, tz=Local):
        """
        GetYear(tz=Local) -> int
        
        Returns the year in the given timezone (local one by default).
        """

    def IsValid(self):
        """
        IsValid() -> bool
        
        Returns true if the object represents a valid time moment.
        """

    def IsWorkDay(self, country=Country_Default):
        """
        IsWorkDay(country=Country_Default) -> bool
        
        Returns true is this day is not a holiday in the given country.
        """

    def IsEarlierThan(self, datetime):
        """
        IsEarlierThan(datetime) -> bool
        
        Returns true if this date precedes the given one.
        """

    def IsEqualTo(self, datetime):
        """
        IsEqualTo(datetime) -> bool
        
        Returns true if the two dates are strictly identical.
        """

    def IsEqualUpTo(self, dt, ts):
        """
        IsEqualUpTo(dt, ts) -> bool
        
        Returns true if the date is equal to another one up to the given time
        interval, i.e. if the absolute difference between the two dates is
        less than this interval.
        """

    def IsLaterThan(self, datetime):
        """
        IsLaterThan(datetime) -> bool
        
        Returns true if this date is later than the given one.
        """

    def IsSameDate(self, dt):
        """
        IsSameDate(dt) -> bool
        
        Returns true if the date is the same without comparing the time parts.
        """

    def IsSameTime(self, dt):
        """
        IsSameTime(dt) -> bool
        
        Returns true if the time is the same (although dates may differ).
        """

    def IsStrictlyBetween(self, t1, t2):
        """
        IsStrictlyBetween(t1, t2) -> bool
        
        Returns true if this date lies strictly between the two given dates.
        """

    def IsBetween(self, t1, t2):
        """
        IsBetween(t1, t2) -> bool
        
        Returns true if IsStrictlyBetween() is true or if the date is equal to
        one of the limit values.
        """

    def Add(self, *args, **kw):
        """
        Add(diff) -> DateTime
        Add(diff) -> DateTime
        
        Adds the given date span to this object.
        """

    def Subtract(self, *args, **kw):
        """
        Subtract(diff) -> DateTime
        Subtract(diff) -> DateTime
        Subtract(dt) -> TimeSpan
        
        Subtracts the given time span from this object.
        """

    def DiffAsDateSpan(self, dt):
        """
        DiffAsDateSpan(dt) -> DateSpan
        
        Returns the difference between this object and dt as a wxDateSpan.
        """

    def Format(self, format=DefaultDateTimeFormat, tz=Local):
        """
        Format(format=DefaultDateTimeFormat, tz=Local) -> String
        
        This function does the same as the standard ANSI C strftime(3)
        function
        (http://www.cplusplus.com/reference/clibrary/ctime/strftime.html).
        """

    def FormatDate(self):
        """
        FormatDate() -> String
        
        Identical to calling Format() with "%x" argument (which means
        "preferred date representation for the current locale").
        """

    def FormatISOCombined(self, sep='T'):
        """
        FormatISOCombined(sep='T') -> String
        
        Returns the combined date-time representation in the ISO 8601 format
        "YYYY-MM-DDTHH:MM:SS".
        """

    def FormatISODate(self):
        """
        FormatISODate() -> String
        
        This function returns the date representation in the ISO 8601 format
        "YYYY-MM-DD".
        """

    def FormatISOTime(self):
        """
        FormatISOTime() -> String
        
        This function returns the time representation in the ISO 8601 format
        "HH:MM:SS".
        """

    def FormatTime(self):
        """
        FormatTime() -> String
        
        Identical to calling Format() with "%X" argument (which means
        "preferred time representation for the current locale").
        """

    def ParseDate(self, date):
        """
        ParseDate(date) -> int
        
        This function is like ParseDateTime(), but it only allows the date to
        be specified.
        """

    def ParseDateTime(self, datetime):
        """
        ParseDateTime(datetime) -> int
        
        Parses the string datetime containing the date and time in free
        format.
        """

    def ParseFormat(self, *args, **kw):
        """
        ParseFormat(date, format, dateDef) -> int
        ParseFormat(date, format) -> int
        ParseFormat(date) -> int
        
        This function parses the string date according to the given format.
        """

    def ParseISOCombined(self, date, sep='T'):
        """
        ParseISOCombined(date, sep='T') -> bool
        
        This function parses the string containing the date and time in ISO
        8601 combined format "YYYY-MM-DDTHH:MM:SS".
        """

    def ParseISODate(self, date):
        """
        ParseISODate(date) -> bool
        
        This function parses the date in ISO 8601 format "YYYY-MM-DD".
        """

    def ParseISOTime(self, date):
        """
        ParseISOTime(date) -> bool
        
        This function parses the time in ISO 8601 format "HH:MM:SS".
        """

    def ParseRfc822Date(self, date):
        """
        ParseRfc822Date(date) -> int
        
        Parses the string date looking for a date formatted according to the
        RFC 822 in it.
        """

    def ParseTime(self, time):
        """
        ParseTime(time) -> int
        
        This functions is like ParseDateTime(), but only allows the time to be
        specified in the input string.
        """

    def GetLastMonthDay(self, month=Inv_Month, year=Inv_Year):
        """
        GetLastMonthDay(month=Inv_Month, year=Inv_Year) -> DateTime
        
        Returns the copy of this object to which SetToLastMonthDay() was
        applied.
        """

    def GetLastWeekDay(self, weekday, month=Inv_Month, year=Inv_Year):
        """
        GetLastWeekDay(weekday, month=Inv_Month, year=Inv_Year) -> DateTime
        
        Returns the copy of this object to which SetToLastWeekDay() was
        applied.
        """

    def GetNextWeekDay(self, weekday):
        """
        GetNextWeekDay(weekday) -> DateTime
        
        Returns the copy of this object to which SetToNextWeekDay() was
        applied.
        """

    def GetPrevWeekDay(self, weekday):
        """
        GetPrevWeekDay(weekday) -> DateTime
        
        Returns the copy of this object to which SetToPrevWeekDay() was
        applied.
        """

    def GetWeekDayInSameWeek(self, weekday, flags=Monday_First):
        """
        GetWeekDayInSameWeek(weekday, flags=Monday_First) -> DateTime
        
        Returns the copy of this object to which SetToWeekDayInSameWeek() was
        applied.
        """

    def GetYearDay(self, yday):
        """
        GetYearDay(yday) -> DateTime
        
        Returns the copy of this object to which SetToYearDay() was applied.
        """

    def SetToLastMonthDay(self, month=Inv_Month, year=Inv_Year):
        """
        SetToLastMonthDay(month=Inv_Month, year=Inv_Year) -> DateTime
        
        Sets the date to the last day in the specified month (the current one
        by default).
        """

    def SetToLastWeekDay(self, weekday, month=Inv_Month, year=Inv_Year):
        """
        SetToLastWeekDay(weekday, month=Inv_Month, year=Inv_Year) -> bool
        
        The effect of calling this function is the same as of calling
        SetToWeekDay(-1, weekday, month, year).
        """

    def SetToNextWeekDay(self, weekday):
        """
        SetToNextWeekDay(weekday) -> DateTime
        
        Sets the date so that it will be the first weekday following the
        current date.
        """

    def SetToPrevWeekDay(self, weekday):
        """
        SetToPrevWeekDay(weekday) -> DateTime
        
        Sets the date so that it will be the last weekday before the current
        date.
        """

    def SetToWeekDay(self, weekday, n=1, month=Inv_Month, year=Inv_Year):
        """
        SetToWeekDay(weekday, n=1, month=Inv_Month, year=Inv_Year) -> bool
        
        Sets the date to the n-th weekday in the given month of the given year
        (the current month and year are used by default).
        """

    def SetToWeekDayInSameWeek(self, weekday, flags=Monday_First):
        """
        SetToWeekDayInSameWeek(weekday, flags=Monday_First) -> DateTime
        
        Adjusts the date so that it will still lie in the same week as before,
        but its week day will be the given one.
        """

    def SetToYearDay(self, yday):
        """
        SetToYearDay(yday) -> DateTime
        
        Sets the date to the day number yday in the same year (i.e. unlike the
        other functions, this one does not use the current year).
        """

    def GetJDN(self):
        """
        GetJDN() -> double
        
        Synonym for GetJulianDayNumber().
        """

    def GetJulianDayNumber(self):
        """
        GetJulianDayNumber() -> double
        
        Returns the JDN corresponding to this date.
        """

    def GetMJD(self):
        """
        GetMJD() -> double
        
        Synonym for GetModifiedJulianDayNumber().
        """

    def GetModifiedJulianDayNumber(self):
        """
        GetModifiedJulianDayNumber() -> double
        
        Returns the "Modified Julian Day Number" (MJD) which is, by
        definition, is equal to JDN - 2400000.5.
        """

    def GetRataDie(self):
        """
        GetRataDie() -> double
        
        Return the Rata Die number of this date.
        """

    def FromTimezone(self, tz, noDST=False):
        """
        FromTimezone(tz, noDST=False) -> DateTime
        
        Transform the date from the given time zone to the local one.
        """

    def IsDST(self, country=Country_Default):
        """
        IsDST(country=Country_Default) -> int
        
        Returns true if the DST is applied for this date in the given country.
        """

    def MakeFromTimezone(self, tz, noDST=False):
        """
        MakeFromTimezone(tz, noDST=False) -> DateTime
        
        Same as FromTimezone() but modifies the object in place.
        """

    def MakeTimezone(self, tz, noDST=False):
        """
        MakeTimezone(tz, noDST=False) -> DateTime
        
        Modifies the object in place to represent the date in another time
        zone.
        """

    def MakeUTC(self, noDST=False):
        """
        MakeUTC(noDST=False) -> DateTime
        
        This is the same as calling MakeTimezone() with the argument GMT0.
        """

    def ToTimezone(self, tz, noDST=False):
        """
        ToTimezone(tz, noDST=False) -> DateTime
        
        Transform the date to the given time zone.
        """

    def ToUTC(self, noDST=False):
        """
        ToUTC(noDST=False) -> DateTime
        
        This is the same as calling ToTimezone() with the argument GMT0.
        """

    @staticmethod
    def ConvertYearToBC(year):
        """
        ConvertYearToBC(year) -> int
        
        Converts the year in absolute notation (i.e. a number which can be
        negative, positive or zero) to the year in BC/AD notation.
        """

    @staticmethod
    def GetAmPmStrings():
        """
        GetAmPmStrings() -> (am, pm)
        
        Returns the translations of the strings AM and PM used for time
        formatting for the current locale.
        """

    @staticmethod
    def GetBeginDST(year=Inv_Year, country=Country_Default):
        """
        GetBeginDST(year=Inv_Year, country=Country_Default) -> DateTime
        
        Get the beginning of DST for the given country in the given year
        (current one by default).
        """

    @staticmethod
    def GetEndDST(year=Inv_Year, country=Country_Default):
        """
        GetEndDST(year=Inv_Year, country=Country_Default) -> DateTime
        
        Returns the end of DST for the given country in the given year
        (current one by default).
        """

    @staticmethod
    def GetCountry():
        """
        GetCountry() -> Country
        
        Returns the current default country.
        """

    @staticmethod
    def GetCurrentMonth(cal=Gregorian):
        """
        GetCurrentMonth(cal=Gregorian) -> DateTime.Month
        
        Get the current month in given calendar (only Gregorian is currently
        supported).
        """

    @staticmethod
    def GetCurrentYear(cal=Gregorian):
        """
        GetCurrentYear(cal=Gregorian) -> int
        
        Get the current year in given calendar (only Gregorian is currently
        supported).
        """

    @staticmethod
    def GetEnglishMonthName(month, flags=Name_Full):
        """
        GetEnglishMonthName(month, flags=Name_Full) -> String
        
        Return the standard English name of the given month.
        """

    @staticmethod
    def GetEnglishWeekDayName(weekday, flags=Name_Full):
        """
        GetEnglishWeekDayName(weekday, flags=Name_Full) -> String
        
        Return the standard English name of the given week day.
        """

    @staticmethod
    def GetMonthName(month, flags=Name_Full):
        """
        GetMonthName(month, flags=Name_Full) -> String
        
        Gets the full (default) or abbreviated name of the given month.
        """

    @staticmethod
    def GetNumberOfDays(month, year=Inv_Year, cal=Gregorian):
        """
        GetNumberOfDays(month, year=Inv_Year, cal=Gregorian) -> unsignedshort
        
        Returns the number of days in the given month of the given year.
        """

    @staticmethod
    def GetTimeNow():
        """
        GetTimeNow() -> time_t
        
        Returns the current time.
        """

    @staticmethod
    def GetWeekDayName(weekday, flags=Name_Full):
        """
        GetWeekDayName(weekday, flags=Name_Full) -> String
        
        Gets the full (default) or abbreviated name of the given week day.
        """

    @staticmethod
    def IsDSTApplicable(year=Inv_Year, country=Country_Default):
        """
        IsDSTApplicable(year=Inv_Year, country=Country_Default) -> bool
        
        Returns true if DST was used in the given year (the current one by
        default) in the given country.
        """

    @staticmethod
    def IsLeapYear(year=Inv_Year, cal=Gregorian):
        """
        IsLeapYear(year=Inv_Year, cal=Gregorian) -> bool
        
        Returns true if the year is a leap one in the specified calendar.
        """

    @staticmethod
    def IsWestEuropeanCountry(country=Country_Default):
        """
        IsWestEuropeanCountry(country=Country_Default) -> bool
        
        This function returns true if the specified (or default) country is
        one of Western European ones.
        """

    @staticmethod
    def Now():
        """
        Now() -> DateTime
        
        Returns the object corresponding to the current time.
        """

    @staticmethod
    def SetCountry(country):
        """
        SetCountry(country)
        
        Sets the country to use by default.
        """

    @staticmethod
    def SetToWeekOfYear(year, numWeek, weekday=Mon):
        """
        SetToWeekOfYear(year, numWeek, weekday=Mon) -> DateTime
        
        Set the date to the given weekday in the week number numWeek of the
        given year .
        """

    @staticmethod
    def Today():
        """
        Today() -> DateTime
        
        Returns the object corresponding to the midnight of the current day
        (i.e. the same as Now(), but the time part is set to 0).
        """

    @staticmethod
    def UNow():
        """
        UNow() -> DateTime
        
        Returns the object corresponding to the current UTC time including the
        milliseconds.
        """

    @staticmethod
    def FromTimeT(timet):
        """
        FromTimeT(timet) -> DateTime
        
        Construct a :class:`DateTime` from a C ``time_t`` value, the number of
        seconds since the epoch.
        """

    @staticmethod
    def FromJDN(jdn):
        """
        FromJDN(jdn) -> DateTime
        
        Construct a :class:`DateTime` from a Julian Day Number.
        
        By definition, the Julian Day Number, usually abbreviated as JDN, of a
        particular instant is the fractional number of days since 12 hours
        Universal Coordinated Time (Greenwich mean noon) on January 1 of the
        year -4712 in the Julian proleptic calendar.
        """

    @staticmethod
    def FromHMS(hour, minute=0, second=0, millisecond=0):
        """
        FromHMS(hour, minute=0, second=0, millisecond=0) -> DateTime
        
        Construct a :class:`DateTime` equal to :meth:`Today` () with the time
        set to the supplied parameters.
        """

    @staticmethod
    def FromDMY(day, month, year=Inv_Year, hour=0, minute=0, second=0, millisecond=0):
        """
        FromDMY(day, month, year=Inv_Year, hour=0, minute=0, second=0, millisecond=0) -> DateTime
        
        Construct a :class:`DateTime` using the supplied parameters.
        """

    def __repr__(self):
        """
        
        """

    def __str__(self):
        """
        
        """
    day = property(None, None)
    month = property(None, None)
    year = property(None, None)
    hour = property(None, None)
    minute = property(None, None)
    second = property(None, None)
    millisecond = property(None, None)
    JDN = property(None, None)
    DayOfYear = property(None, None)
    JulianDayNumber = property(None, None)
    LastMonthDay = property(None, None)
    MJD = property(None, None)
    ModifiedJulianDayNumber = property(None, None)
    RataDie = property(None, None)
    Ticks = property(None, None)
    WeekOfMonth = property(None, None)
    WeekOfYear = property(None, None)
# end of class DateTime


class DateSpan(object):
    """
    DateSpan(years=0, months=0, weeks=0, days=0)
    
    This class is a "logical time span" and is useful for implementing
    program logic for such things as "add one month to the date" which, in
    general, doesn't mean to add 60*60*24*31 seconds to it, but to take
    the same date the next month (to understand that this is indeed
    different consider adding one month to Feb, 15  we want to get Mar,
    15, of course).
    """

    def __init__(self, years=0, months=0, weeks=0, days=0):
        """
        DateSpan(years=0, months=0, weeks=0, days=0)
        
        This class is a "logical time span" and is useful for implementing
        program logic for such things as "add one month to the date" which, in
        general, doesn't mean to add 60*60*24*31 seconds to it, but to take
        the same date the next month (to understand that this is indeed
        different consider adding one month to Feb, 15  we want to get Mar,
        15, of course).
        """

    def Add(self, other):
        """
        Add(other) -> DateSpan
        
        Adds the given wxDateSpan to this wxDateSpan and returns a reference
        to itself.
        """

    def GetDays(self):
        """
        GetDays() -> int
        
        Returns the number of days (not counting the weeks component) in this
        date span.
        """

    def GetMonths(self):
        """
        GetMonths() -> int
        
        Returns the number of the months (not counting the years) in this date
        span.
        """

    def GetTotalMonths(self):
        """
        GetTotalMonths() -> int
        
        Returns the combined number of months in this date span, counting both
        years and months.
        """

    def GetTotalDays(self):
        """
        GetTotalDays() -> int
        
        Returns the combined number of days in this date span, counting both
        weeks and days.
        """

    def GetWeeks(self):
        """
        GetWeeks() -> int
        
        Returns the number of weeks in this date span.
        """

    def GetYears(self):
        """
        GetYears() -> int
        
        Returns the number of years in this date span.
        """

    def Multiply(self, factor):
        """
        Multiply(factor) -> DateSpan
        
        Multiplies this date span by the specified factor.
        """

    def Neg(self):
        """
        Neg() -> DateSpan
        
        Changes the sign of this date span.
        """

    def Negate(self):
        """
        Negate() -> DateSpan
        
        Returns a date span with the opposite sign.
        """

    def SetDays(self, n):
        """
        SetDays(n) -> DateSpan
        
        Sets the number of days (without modifying any other components) in
        this date span.
        """

    def SetMonths(self, n):
        """
        SetMonths(n) -> DateSpan
        
        Sets the number of months (without modifying any other components) in
        this date span.
        """

    def SetWeeks(self, n):
        """
        SetWeeks(n) -> DateSpan
        
        Sets the number of weeks (without modifying any other components) in
        this date span.
        """

    def SetYears(self, n):
        """
        SetYears(n) -> DateSpan
        
        Sets the number of years (without modifying any other components) in
        this date span.
        """

    def Subtract(self, other):
        """
        Subtract(other) -> DateSpan
        
        Subtracts the given wxDateSpan to this wxDateSpan and returns a
        reference to itself.
        """

    @staticmethod
    def Day():
        """
        Day() -> DateSpan
        
        Returns a date span object corresponding to one day.
        """

    @staticmethod
    def Days(days):
        """
        Days(days) -> DateSpan
        
        Returns a date span object corresponding to the given number of days.
        """

    @staticmethod
    def Month():
        """
        Month() -> DateSpan
        
        Returns a date span object corresponding to one month.
        """

    @staticmethod
    def Months(mon):
        """
        Months(mon) -> DateSpan
        
        Returns a date span object corresponding to the given number of
        months.
        """

    @staticmethod
    def Week():
        """
        Week() -> DateSpan
        
        Returns a date span object corresponding to one week.
        """

    @staticmethod
    def Weeks(weeks):
        """
        Weeks(weeks) -> DateSpan
        
        Returns a date span object corresponding to the given number of weeks.
        """

    @staticmethod
    def Year():
        """
        Year() -> DateSpan
        
        Returns a date span object corresponding to one year.
        """

    @staticmethod
    def Years(years):
        """
        Years(years) -> DateSpan
        
        Returns a date span object corresponding to the given number of years.
        """
# end of class DateSpan


class TimeSpan(object):
    """
    TimeSpan()
    TimeSpan(hours, min=0, sec=0, msec=0)
    
    wxTimeSpan class represents a time interval.
    """

    def __init__(self, *args, **kw):
        """
        TimeSpan()
        TimeSpan(hours, min=0, sec=0, msec=0)
        
        wxTimeSpan class represents a time interval.
        """

    def Abs(self):
        """
        Abs() -> TimeSpan
        
        Returns the absolute value of the timespan: does not modify the
        object.
        """

    def Add(self, diff):
        """
        Add(diff) -> TimeSpan
        
        Adds the given wxTimeSpan to this wxTimeSpan and returns a reference
        to itself.
        """

    def Format(self, format=DefaultTimeSpanFormat):
        """
        Format(format=DefaultTimeSpanFormat) -> String
        
        Returns the string containing the formatted representation of the time
        span.
        """

    def GetDays(self):
        """
        GetDays() -> int
        
        Returns the difference in number of days.
        """

    def GetHours(self):
        """
        GetHours() -> int
        
        Returns the difference in number of hours.
        """

    def GetMilliseconds(self):
        """
        GetMilliseconds() -> LongLong
        
        Returns the difference in number of milliseconds.
        """

    def GetMinutes(self):
        """
        GetMinutes() -> int
        
        Returns the difference in number of minutes.
        """

    def GetSeconds(self):
        """
        GetSeconds() -> LongLong
        
        Returns the difference in number of seconds.
        """

    def GetValue(self):
        """
        GetValue() -> LongLong
        
        Returns the internal representation of timespan.
        """

    def GetWeeks(self):
        """
        GetWeeks() -> int
        
        Returns the difference in number of weeks.
        """

    def IsEqualTo(self, ts):
        """
        IsEqualTo(ts) -> bool
        
        Returns true if two timespans are equal.
        """

    def IsLongerThan(self, ts):
        """
        IsLongerThan(ts) -> bool
        
        Compares two timespans: works with the absolute values, i.e. -2 hours
        is longer than 1 hour.
        """

    def IsNegative(self):
        """
        IsNegative() -> bool
        
        Returns true if the timespan is negative.
        """

    def IsNull(self):
        """
        IsNull() -> bool
        
        Returns true if the timespan is empty.
        """

    def IsPositive(self):
        """
        IsPositive() -> bool
        
        Returns true if the timespan is positive.
        """

    def IsShorterThan(self, ts):
        """
        IsShorterThan(ts) -> bool
        
        Compares two timespans: works with the absolute values, i.e. 1 hour is
        shorter than -2 hours.
        """

    def Multiply(self, n):
        """
        Multiply(n) -> TimeSpan
        
        Multiplies this time span by n.
        """

    def Neg(self):
        """
        Neg() -> TimeSpan
        
        Negate the value of the timespan.
        """

    def Negate(self):
        """
        Negate() -> TimeSpan
        
        Returns timespan with inverted sign.
        """

    def Subtract(self, diff):
        """
        Subtract(diff) -> TimeSpan
        
        Subtracts the given wxTimeSpan to this wxTimeSpan and returns a
        reference to itself.
        """

    @staticmethod
    def Day():
        """
        Day() -> TimeSpan
        
        Returns the timespan for one day.
        """

    @staticmethod
    def Days(days):
        """
        Days(days) -> TimeSpan
        
        Returns the timespan for the given number of days.
        """

    @staticmethod
    def Hour():
        """
        Hour() -> TimeSpan
        
        Returns the timespan for one hour.
        """

    @staticmethod
    def Hours(hours):
        """
        Hours(hours) -> TimeSpan
        
        Returns the timespan for the given number of hours.
        """

    @staticmethod
    def Millisecond():
        """
        Millisecond() -> TimeSpan
        
        Returns the timespan for one millisecond.
        """

    @staticmethod
    def Milliseconds(ms):
        """
        Milliseconds(ms) -> TimeSpan
        
        Returns the timespan for the given number of milliseconds.
        """

    @staticmethod
    def Minute():
        """
        Minute() -> TimeSpan
        
        Returns the timespan for one minute.
        """

    @staticmethod
    def Minutes(min):
        """
        Minutes(min) -> TimeSpan
        
        Returns the timespan for the given number of minutes.
        """

    @staticmethod
    def Second():
        """
        Second() -> TimeSpan
        
        Returns the timespan for one second.
        """

    @staticmethod
    def Seconds(sec):
        """
        Seconds(sec) -> TimeSpan
        
        Returns the timespan for the given number of seconds.
        """

    @staticmethod
    def Week():
        """
        Week() -> TimeSpan
        
        Returns the timespan for one week.
        """

    @staticmethod
    def Weeks(weeks):
        """
        Weeks(weeks) -> TimeSpan
        
        Returns the timespan for the given number of weeks.
        """
# end of class TimeSpan

DefaultDateTime = DateTime()

InvalidDateTime = DefaultDateTime

@wx.deprecated
def DateTimeFromTimeT(timet):
    """
    Compatibility wrapper for :meth:`DateTime.FromTimeT`
    """
    pass

@wx.deprecated
def DateTimeFromJDN(jdn):
    """
    Compatibility wrapper for :meth:`DateTime.FromJDN`
    """
    pass

@wx.deprecated
def DateTimeFromHMS(hour, minute=0, second=0, millisecond=0):
    """
    Compatibility wrapper for :meth:`DateTime.FromHMS`
    """
    pass

@wx.deprecated
def DateTimeFromDMY(day, month, year=DateTime.Inv_Year, hour=0, minute=0, second=0, millisecond=0):
    """
    Compatibility wrapper for :meth:`DateTime.FromDMY`
    """
    pass

def pydate2wxdate(date):
    """
    Convert a Python date or datetime to a :class:`DateTime` object
    """
    pass

def wxdate2pydate(date):
    """
    Convert a :class:`DateTime` object to a Python datetime.
    """
    pass
#-- end-wxdatetime --#
#-- begin-stopwatch --#

class StopWatch(object):
    """
    StopWatch()
    
    The wxStopWatch class allow you to measure time intervals.
    """

    def __init__(self):
        """
        StopWatch()
        
        The wxStopWatch class allow you to measure time intervals.
        """

    def Pause(self):
        """
        Pause()
        
        Pauses the stop watch.
        """

    def Resume(self):
        """
        Resume()
        
        Resumes the stop watch which had been paused with Pause().
        """

    def Start(self, milliseconds=0):
        """
        Start(milliseconds=0)
        
        (Re)starts the stop watch with a given initial value.
        """

    def Time(self):
        """
        Time() -> long
        
        Returns the time in milliseconds since the start (or restart) or the
        last call of Pause().
        """

    def TimeInMicro(self):
        """
        TimeInMicro() -> LongLong
        
        Returns elapsed time in microseconds.
        """
# end of class StopWatch

#-- end-stopwatch --#
#-- begin-windowid --#

class IdManager(object):
    """
    wxIdManager is responsible for allocating and releasing window IDs.
    """

    @staticmethod
    def ReserveId(count=1):
        """
        ReserveId(count=1) -> WindowID
        
        Called directly by wxWindow::NewControlId(), this function will create
        a new ID or range of IDs.
        """

    @staticmethod
    def UnreserveId(id, count=1):
        """
        UnreserveId(id, count=1)
        
        Called directly by wxWindow::UnreserveControlId(), this function will
        unreserve an ID or range of IDs that is currently reserved.
        """
# end of class IdManager

#-- end-windowid --#
#-- begin-platinfo --#
OS_UNKNOWN = 0
OS_MAC_OS = 0
OS_MAC_OSX_DARWIN = 0
OS_MAC = 0
OS_WINDOWS_9X = 0
OS_WINDOWS_NT = 0
OS_WINDOWS_MICRO = 0
OS_WINDOWS_CE = 0
OS_WINDOWS = 0
OS_UNIX_LINUX = 0
OS_UNIX_FREEBSD = 0
OS_UNIX_OPENBSD = 0
OS_UNIX_NETBSD = 0
OS_UNIX_SOLARIS = 0
OS_UNIX_AIX = 0
OS_UNIX_HPUX = 0
OS_UNIX = 0
OS_DOS = 0
OS_OS2 = 0
PORT_UNKNOWN = 0
PORT_BASE = 0
PORT_MSW = 0
PORT_MOTIF = 0
PORT_GTK = 0
PORT_DFB = 0
PORT_X11 = 0
PORT_OS2 = 0
PORT_MAC = 0
PORT_COCOA = 0
PORT_WINCE = 0
ARCH_INVALID = 0
ARCH_32 = 0
ARCH_64 = 0
ARCH_MAX = 0
ENDIAN_INVALID = 0
ENDIAN_BIG = 0
ENDIAN_LITTLE = 0
ENDIAN_PDP = 0
ENDIAN_MAX = 0

class PlatformInformation(object):
    """
    PlatformInfo()
    PlatformInfo(pid, tkMajor=-1, tkMinor=-1, id=OS_UNKNOWN, osMajor=-1, osMinor=-1, arch=ARCH_INVALID, endian=ENDIAN_INVALID)
    
    This class holds information about the operating system, the toolkit
    and the basic architecture of the machine where the application is
    currently running.
    """

    def __init__(self, *args, **kw):
        """
        PlatformInfo()
        PlatformInfo(pid, tkMajor=-1, tkMinor=-1, id=OS_UNKNOWN, osMajor=-1, osMinor=-1, arch=ARCH_INVALID, endian=ENDIAN_INVALID)
        
        This class holds information about the operating system, the toolkit
        and the basic architecture of the machine where the application is
        currently running.
        """

    @staticmethod
    def GetArch(arch):
        """
        GetArch(arch) -> Architecture
        
        Converts the given string to a wxArchitecture enum value or to
        wxARCH_INVALID if the given string is not a valid architecture string
        (i.e.
        """

    def GetEndianness(self):
        """
        GetEndianness() -> Endianness
        
        Returns the endianness ID of this wxPlatformInfo instance.
        """

    def GetOperatingSystemId(self):
        """
        GetOperatingSystemId() -> OperatingSystemId
        
        Returns the operating system ID of this wxPlatformInfo instance.
        """

    def GetPortId(self):
        """
        GetPortId() -> PortId
        
        Returns the wxWidgets port ID associated with this wxPlatformInfo
        instance.
        """

    def GetArchName(self):
        """
        GetArchName() -> String
        
        Returns the name for the architecture of this wxPlatformInfo instance.
        """

    def GetEndiannessName(self):
        """
        GetEndiannessName() -> String
        
        Returns the name for the endianness of this wxPlatformInfo instance.
        """

    def GetOperatingSystemFamilyName(self):
        """
        GetOperatingSystemFamilyName() -> String
        
        Returns the operating system family name of the OS associated with
        this wxPlatformInfo instance.
        """

    def GetOperatingSystemIdName(self):
        """
        GetOperatingSystemIdName() -> String
        
        Returns the operating system name of the OS associated with this
        wxPlatformInfo instance.
        """

    def GetPortIdName(self):
        """
        GetPortIdName() -> String
        
        Returns the name of the wxWidgets port ID associated with this
        wxPlatformInfo instance.
        """

    def GetPortIdShortName(self):
        """
        GetPortIdShortName() -> String
        
        Returns the short name of the wxWidgets port ID associated with this
        wxPlatformInfo instance.
        """

    @staticmethod
    def GetOperatingSystemDirectory():
        """
        GetOperatingSystemDirectory() -> String
        
        Returns the operating system directory.
        """

    def GetArchitecture(self):
        """
        GetArchitecture() -> Architecture
        
        Returns the architecture ID of this wxPlatformInfo instance.
        """

    def GetOSMajorVersion(self):
        """
        GetOSMajorVersion() -> int
        
        Returns the run-time major version of the OS associated with this
        wxPlatformInfo instance.
        """

    def GetOSMinorVersion(self):
        """
        GetOSMinorVersion() -> int
        
        Returns the run-time minor version of the OS associated with this
        wxPlatformInfo instance.
        """

    def GetOperatingSystemDescription(self):
        """
        GetOperatingSystemDescription() -> String
        
        Returns the description of the operating system of this wxPlatformInfo
        instance.
        """

    def GetLinuxDistributionInfo(self):
        """
        GetLinuxDistributionInfo() -> LinuxDistributionInfo
        
        Returns the Linux distribution info associated with this
        wxPlatformInfo instance.
        """

    def GetDesktopEnvironment(self):
        """
        GetDesktopEnvironment() -> String
        
        Returns the desktop environment associated with this wxPlatformInfo
        instance.
        """

    def GetToolkitMajorVersion(self):
        """
        GetToolkitMajorVersion() -> int
        
        Returns the run-time major version of the toolkit associated with this
        wxPlatformInfo instance.
        """

    def GetToolkitMinorVersion(self):
        """
        GetToolkitMinorVersion() -> int
        
        Returns the run-time minor version of the toolkit associated with this
        wxPlatformInfo instance.
        """

    def SetArchitecture(self, n):
        """
        SetArchitecture(n)
        
        Sets the architecture enum value associated with this wxPlatformInfo
        instance.
        """

    def SetEndianness(self, n):
        """
        SetEndianness(n)
        
        Sets the endianness enum value associated with this wxPlatformInfo
        instance.
        """

    def SetOSVersion(self, major, minor):
        """
        SetOSVersion(major, minor)
        
        Sets the version of the operating system associated with this
        wxPlatformInfo instance.
        """

    def SetOperatingSystemId(self, n):
        """
        SetOperatingSystemId(n)
        
        Sets the operating system associated with this wxPlatformInfo
        instance.
        """

    def SetPortId(self, n):
        """
        SetPortId(n)
        
        Sets the wxWidgets port ID associated with this wxPlatformInfo
        instance.
        """

    def SetToolkitVersion(self, major, minor):
        """
        SetToolkitVersion(major, minor)
        
        Sets the version of the toolkit associated with this wxPlatformInfo
        instance.
        """

    def SetOperatingSystemDescription(self, desc):
        """
        SetOperatingSystemDescription(desc)
        
        Sets the operating system description associated with this
        wxPlatformInfo instance.
        """

    def SetDesktopEnvironment(self, de):
        """
        SetDesktopEnvironment(de)
        
        Sets the desktop environment associated with this wxPlatformInfo
        instance.
        """

    def SetLinuxDistributionInfo(self, di):
        """
        SetLinuxDistributionInfo(di)
        
        Sets the linux distribution info associated with this wxPlatformInfo
        instance.
        """

    def CheckOSVersion(self, major, minor):
        """
        CheckOSVersion(major, minor) -> bool
        
        Returns true if the OS version is at least major.minor.
        """

    def CheckToolkitVersion(self, major, minor):
        """
        CheckToolkitVersion(major, minor) -> bool
        
        Returns true if the toolkit version is at least major.minor.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if this instance is fully initialized with valid values.
        """

    def IsUsingUniversalWidgets(self):
        """
        IsUsingUniversalWidgets() -> bool
        
        Returns true if this wxPlatformInfo describes wxUniversal build.
        """

    def __ne__(self):
        """
        """

    def __eq__(self):
        """
        """

    @staticmethod
    def Get():
        """
        Get() -> PlatformInfo
        
        Returns the global wxPlatformInfo object, initialized with the values
        for the currently running platform.
        """
    ArchName = property(None, None)
    Architecture = property(None, None)
    DesktopEnvironment = property(None, None)
    Endianness = property(None, None)
    EndiannessName = property(None, None)
    LinuxDistributionInfo = property(None, None)
    OSMajorVersion = property(None, None)
    OSMinorVersion = property(None, None)
    OperatingSystemDescription = property(None, None)
    OperatingSystemFamilyName = property(None, None)
    OperatingSystemId = property(None, None)
    OperatingSystemIdName = property(None, None)
    PortId = property(None, None)
    PortIdName = property(None, None)
    PortIdShortName = property(None, None)
    ToolkitMajorVersion = property(None, None)
    ToolkitMinorVersion = property(None, None)
# end of class PlatformInformation


class LinuxDistributionInfo(object):
    """
    A structure containing information about a Linux distribution as
    returned by the lsb_release utility.
    """
    Id = property(None, None)
    Release = property(None, None)
    CodeName = property(None, None)
    Description = property(None, None)

    def __eq__(self):
        """
        """

    def __ne__(self):
        """
        """
# end of class LinuxDistributionInfo

#-- end-platinfo --#
#-- begin-vidmode --#

class VideoMode(object):
    """
    VideoMode(width=0, height=0, depth=0, freq=0)
    
    Determines the sizes and locations of displays connected to the
    system.
    """

    def __init__(self, width=0, height=0, depth=0, freq=0):
        """
        VideoMode(width=0, height=0, depth=0, freq=0)
        
        Determines the sizes and locations of displays connected to the
        system.
        """
    w = property(None, None)
    h = property(None, None)
    bpp = property(None, None)
    refresh = property(None, None)

    def Matches(self, other):
        """
        Matches(other) -> bool
        
        Returns true if this mode matches the other one in the sense that all
        non zero fields of the other mode have the same value in this one
        (except for refresh which is allowed to have a greater value).
        """

    def GetWidth(self):
        """
        GetWidth() -> int
        
        Returns the screen width in pixels (e.g. 640), 0 means unspecified.
        """

    def GetHeight(self):
        """
        GetHeight() -> int
        
        Returns the screen height in pixels (e.g. 480), 0 means unspecified.
        """

    def GetDepth(self):
        """
        GetDepth() -> int
        
        Returns bits per pixel (e.g. 32), 1 is monochrome and 0 means
        unspecified/known.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if the object has been initialized.
        """

    def __eq__(self):
        """
        """

    def __ne__(self):
        """
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """
    Depth = property(None, None)
    Height = property(None, None)
    Width = property(None, None)
# end of class VideoMode

DefaultVideoMode = VideoMode()
#-- end-vidmode --#
#-- begin-display --#

class Display(object):
    """
    Display(index=0)
    
    Determines the sizes and locations of displays connected to the
    system.
    """

    def __init__(self, index=0):
        """
        Display(index=0)
        
        Determines the sizes and locations of displays connected to the
        system.
        """

    def ChangeMode(self, mode=DefaultVideoMode):
        """
        ChangeMode(mode=DefaultVideoMode) -> bool
        
        Changes the video mode of this display to the mode specified in the
        mode parameter.
        """

    def GetClientArea(self):
        """
        GetClientArea() -> Rect
        
        Returns the client area of the display.
        """

    def GetCurrentMode(self):
        """
        GetCurrentMode() -> VideoMode
        
        Returns the current video mode that this display is in.
        """

    def GetGeometry(self):
        """
        GetGeometry() -> Rect
        
        Returns the bounding rectangle of the display whose index was passed
        to the constructor.
        """

    def GetModes(self, mode=DefaultVideoMode):
        """
        GetModes(mode=DefaultVideoMode) -> ArrayVideoModes
        
        Fills and returns an array with all the video modes that are supported
        by this display, or video modes that are supported by this display and
        match the mode parameter (if mode is not wxDefaultVideoMode).
        """

    def GetName(self):
        """
        GetName() -> String
        
        Returns the display's name.
        """

    def IsPrimary(self):
        """
        IsPrimary() -> bool
        
        Returns true if the display is the primary display.
        """

    @staticmethod
    def GetCount():
        """
        GetCount() -> unsignedint
        
        Returns the number of connected displays.
        """

    @staticmethod
    def GetFromPoint(pt):
        """
        GetFromPoint(pt) -> int
        
        Returns the index of the display on which the given point lies, or
        wxNOT_FOUND if the point is not on any connected display.
        """

    @staticmethod
    def GetFromWindow(win):
        """
        GetFromWindow(win) -> int
        
        Returns the index of the display on which the given window lies.
        """
    ClientArea = property(None, None)
    CurrentMode = property(None, None)
    Geometry = property(None, None)
    Name = property(None, None)
# end of class Display

#-- end-display --#
#-- begin-intl --#
LANGUAGE_DEFAULT = 0
LANGUAGE_UNKNOWN = 0
LANGUAGE_ABKHAZIAN = 0
LANGUAGE_AFAR = 0
LANGUAGE_AFRIKAANS = 0
LANGUAGE_ALBANIAN = 0
LANGUAGE_AMHARIC = 0
LANGUAGE_ARABIC = 0
LANGUAGE_ARABIC_ALGERIA = 0
LANGUAGE_ARABIC_BAHRAIN = 0
LANGUAGE_ARABIC_EGYPT = 0
LANGUAGE_ARABIC_IRAQ = 0
LANGUAGE_ARABIC_JORDAN = 0
LANGUAGE_ARABIC_KUWAIT = 0
LANGUAGE_ARABIC_LEBANON = 0
LANGUAGE_ARABIC_LIBYA = 0
LANGUAGE_ARABIC_MOROCCO = 0
LANGUAGE_ARABIC_OMAN = 0
LANGUAGE_ARABIC_QATAR = 0
LANGUAGE_ARABIC_SAUDI_ARABIA = 0
LANGUAGE_ARABIC_SUDAN = 0
LANGUAGE_ARABIC_SYRIA = 0
LANGUAGE_ARABIC_TUNISIA = 0
LANGUAGE_ARABIC_UAE = 0
LANGUAGE_ARABIC_YEMEN = 0
LANGUAGE_ARMENIAN = 0
LANGUAGE_ASSAMESE = 0
LANGUAGE_ASTURIAN = 0
LANGUAGE_AYMARA = 0
LANGUAGE_AZERI = 0
LANGUAGE_AZERI_CYRILLIC = 0
LANGUAGE_AZERI_LATIN = 0
LANGUAGE_BASHKIR = 0
LANGUAGE_BASQUE = 0
LANGUAGE_BELARUSIAN = 0
LANGUAGE_BENGALI = 0
LANGUAGE_BHUTANI = 0
LANGUAGE_BIHARI = 0
LANGUAGE_BISLAMA = 0
LANGUAGE_BOSNIAN = 0
LANGUAGE_BRETON = 0
LANGUAGE_BULGARIAN = 0
LANGUAGE_BURMESE = 0
LANGUAGE_CAMBODIAN = 0
LANGUAGE_CATALAN = 0
LANGUAGE_CHINESE = 0
LANGUAGE_CHINESE_SIMPLIFIED = 0
LANGUAGE_CHINESE_TRADITIONAL = 0
LANGUAGE_CHINESE_HONGKONG = 0
LANGUAGE_CHINESE_MACAU = 0
LANGUAGE_CHINESE_SINGAPORE = 0
LANGUAGE_CHINESE_TAIWAN = 0
LANGUAGE_CORSICAN = 0
LANGUAGE_CROATIAN = 0
LANGUAGE_CZECH = 0
LANGUAGE_DANISH = 0
LANGUAGE_DUTCH = 0
LANGUAGE_DUTCH_BELGIAN = 0
LANGUAGE_ENGLISH = 0
LANGUAGE_ENGLISH_UK = 0
LANGUAGE_ENGLISH_US = 0
LANGUAGE_ENGLISH_AUSTRALIA = 0
LANGUAGE_ENGLISH_BELIZE = 0
LANGUAGE_ENGLISH_BOTSWANA = 0
LANGUAGE_ENGLISH_CANADA = 0
LANGUAGE_ENGLISH_CARIBBEAN = 0
LANGUAGE_ENGLISH_DENMARK = 0
LANGUAGE_ENGLISH_EIRE = 0
LANGUAGE_ENGLISH_JAMAICA = 0
LANGUAGE_ENGLISH_NEW_ZEALAND = 0
LANGUAGE_ENGLISH_PHILIPPINES = 0
LANGUAGE_ENGLISH_SOUTH_AFRICA = 0
LANGUAGE_ENGLISH_TRINIDAD = 0
LANGUAGE_ENGLISH_ZIMBABWE = 0
LANGUAGE_ESPERANTO = 0
LANGUAGE_ESTONIAN = 0
LANGUAGE_FAEROESE = 0
LANGUAGE_FARSI = 0
LANGUAGE_FIJI = 0
LANGUAGE_FINNISH = 0
LANGUAGE_FRENCH = 0
LANGUAGE_FRENCH_BELGIAN = 0
LANGUAGE_FRENCH_CANADIAN = 0
LANGUAGE_FRENCH_LUXEMBOURG = 0
LANGUAGE_FRENCH_MONACO = 0
LANGUAGE_FRENCH_SWISS = 0
LANGUAGE_FRISIAN = 0
LANGUAGE_GALICIAN = 0
LANGUAGE_GEORGIAN = 0
LANGUAGE_GERMAN = 0
LANGUAGE_GERMAN_AUSTRIAN = 0
LANGUAGE_GERMAN_BELGIUM = 0
LANGUAGE_GERMAN_LIECHTENSTEIN = 0
LANGUAGE_GERMAN_LUXEMBOURG = 0
LANGUAGE_GERMAN_SWISS = 0
LANGUAGE_GREEK = 0
LANGUAGE_GREENLANDIC = 0
LANGUAGE_GUARANI = 0
LANGUAGE_GUJARATI = 0
LANGUAGE_HAUSA = 0
LANGUAGE_HEBREW = 0
LANGUAGE_HINDI = 0
LANGUAGE_HUNGARIAN = 0
LANGUAGE_ICELANDIC = 0
LANGUAGE_INDONESIAN = 0
LANGUAGE_INTERLINGUA = 0
LANGUAGE_INTERLINGUE = 0
LANGUAGE_INUKTITUT = 0
LANGUAGE_INUPIAK = 0
LANGUAGE_IRISH = 0
LANGUAGE_ITALIAN = 0
LANGUAGE_ITALIAN_SWISS = 0
LANGUAGE_JAPANESE = 0
LANGUAGE_JAVANESE = 0
LANGUAGE_KANNADA = 0
LANGUAGE_KASHMIRI = 0
LANGUAGE_KASHMIRI_INDIA = 0
LANGUAGE_KAZAKH = 0
LANGUAGE_KERNEWEK = 0
LANGUAGE_KINYARWANDA = 0
LANGUAGE_KIRGHIZ = 0
LANGUAGE_KIRUNDI = 0
LANGUAGE_KONKANI = 0
LANGUAGE_KOREAN = 0
LANGUAGE_KURDISH = 0
LANGUAGE_LAOTHIAN = 0
LANGUAGE_LATIN = 0
LANGUAGE_LATVIAN = 0
LANGUAGE_LINGALA = 0
LANGUAGE_LITHUANIAN = 0
LANGUAGE_MACEDONIAN = 0
LANGUAGE_MALAGASY = 0
LANGUAGE_MALAY = 0
LANGUAGE_MALAYALAM = 0
LANGUAGE_MALAY_BRUNEI_DARUSSALAM = 0
LANGUAGE_MALAY_MALAYSIA = 0
LANGUAGE_MALTESE = 0
LANGUAGE_MANIPURI = 0
LANGUAGE_MAORI = 0
LANGUAGE_MARATHI = 0
LANGUAGE_MOLDAVIAN = 0
LANGUAGE_MONGOLIAN = 0
LANGUAGE_NAURU = 0
LANGUAGE_NEPALI = 0
LANGUAGE_NEPALI_INDIA = 0
LANGUAGE_NORWEGIAN_BOKMAL = 0
LANGUAGE_NORWEGIAN_NYNORSK = 0
LANGUAGE_OCCITAN = 0
LANGUAGE_ORIYA = 0
LANGUAGE_OROMO = 0
LANGUAGE_PASHTO = 0
LANGUAGE_POLISH = 0
LANGUAGE_PORTUGUESE = 0
LANGUAGE_PORTUGUESE_BRAZILIAN = 0
LANGUAGE_PUNJABI = 0
LANGUAGE_QUECHUA = 0
LANGUAGE_RHAETO_ROMANCE = 0
LANGUAGE_ROMANIAN = 0
LANGUAGE_RUSSIAN = 0
LANGUAGE_RUSSIAN_UKRAINE = 0
LANGUAGE_SAMI = 0
LANGUAGE_SAMOAN = 0
LANGUAGE_SANGHO = 0
LANGUAGE_SANSKRIT = 0
LANGUAGE_SCOTS_GAELIC = 0
LANGUAGE_SERBIAN = 0
LANGUAGE_SERBIAN_CYRILLIC = 0
LANGUAGE_SERBIAN_LATIN = 0
LANGUAGE_SERBO_CROATIAN = 0
LANGUAGE_SESOTHO = 0
LANGUAGE_SETSWANA = 0
LANGUAGE_SHONA = 0
LANGUAGE_SINDHI = 0
LANGUAGE_SINHALESE = 0
LANGUAGE_SISWATI = 0
LANGUAGE_SLOVAK = 0
LANGUAGE_SLOVENIAN = 0
LANGUAGE_SOMALI = 0
LANGUAGE_SPANISH = 0
LANGUAGE_SPANISH_ARGENTINA = 0
LANGUAGE_SPANISH_BOLIVIA = 0
LANGUAGE_SPANISH_CHILE = 0
LANGUAGE_SPANISH_COLOMBIA = 0
LANGUAGE_SPANISH_COSTA_RICA = 0
LANGUAGE_SPANISH_DOMINICAN_REPUBLIC = 0
LANGUAGE_SPANISH_ECUADOR = 0
LANGUAGE_SPANISH_EL_SALVADOR = 0
LANGUAGE_SPANISH_GUATEMALA = 0
LANGUAGE_SPANISH_HONDURAS = 0
LANGUAGE_SPANISH_MEXICAN = 0
LANGUAGE_SPANISH_MODERN = 0
LANGUAGE_SPANISH_NICARAGUA = 0
LANGUAGE_SPANISH_PANAMA = 0
LANGUAGE_SPANISH_PARAGUAY = 0
LANGUAGE_SPANISH_PERU = 0
LANGUAGE_SPANISH_PUERTO_RICO = 0
LANGUAGE_SPANISH_URUGUAY = 0
LANGUAGE_SPANISH_US = 0
LANGUAGE_SPANISH_VENEZUELA = 0
LANGUAGE_SUNDANESE = 0
LANGUAGE_SWAHILI = 0
LANGUAGE_SWEDISH = 0
LANGUAGE_SWEDISH_FINLAND = 0
LANGUAGE_TAGALOG = 0
LANGUAGE_TAJIK = 0
LANGUAGE_TAMIL = 0
LANGUAGE_TATAR = 0
LANGUAGE_TELUGU = 0
LANGUAGE_THAI = 0
LANGUAGE_TIBETAN = 0
LANGUAGE_TIGRINYA = 0
LANGUAGE_TONGA = 0
LANGUAGE_TSONGA = 0
LANGUAGE_TURKISH = 0
LANGUAGE_TURKMEN = 0
LANGUAGE_TWI = 0
LANGUAGE_UIGHUR = 0
LANGUAGE_UKRAINIAN = 0
LANGUAGE_URDU = 0
LANGUAGE_URDU_INDIA = 0
LANGUAGE_URDU_PAKISTAN = 0
LANGUAGE_UZBEK = 0
LANGUAGE_UZBEK_CYRILLIC = 0
LANGUAGE_UZBEK_LATIN = 0
LANGUAGE_VALENCIAN = 0
LANGUAGE_VIETNAMESE = 0
LANGUAGE_VOLAPUK = 0
LANGUAGE_WELSH = 0
LANGUAGE_WOLOF = 0
LANGUAGE_XHOSA = 0
LANGUAGE_YIDDISH = 0
LANGUAGE_YORUBA = 0
LANGUAGE_ZHUANG = 0
LANGUAGE_ZULU = 0
LANGUAGE_KABYLE = 0
LANGUAGE_USER_DEFINED = 0
Layout_Default = 0
Layout_LeftToRight = 0
Layout_RightToLeft = 0
LOCALE_CAT_NUMBER = 0
LOCALE_CAT_DATE = 0
LOCALE_CAT_MONEY = 0
LOCALE_CAT_DEFAULT = 0
LOCALE_THOUSANDS_SEP = 0
LOCALE_DECIMAL_POINT = 0
LOCALE_SHORT_DATE_FMT = 0
LOCALE_LONG_DATE_FMT = 0
LOCALE_DATE_TIME_FMT = 0
LOCALE_TIME_FMT = 0

class LanguageInfo(object):
    """
    Encapsulates a wxLanguage identifier together with OS-specific
    information related to that language.
    """
    Language = property(None, None)
    CanonicalName = property(None, None)
    Description = property(None, None)
    LayoutDirection = property(None, None)

    def GetLocaleName(self):
        """
        GetLocaleName() -> String
        
        Return the locale name corresponding to this language usable with
        setlocale() on the current system.
        """
    LocaleName = property(None, None)
# end of class LanguageInfo


class Locale(object):
    """
    Locale()
    Locale(language, flags=LOCALE_LOAD_DEFAULT)
    Locale(name, shortName=EmptyString, locale=EmptyString, bLoadDefault=True)
    
    wxLocale class encapsulates all language-dependent settings and is a
    generalization of the C locale concept.
    """

    def __init__(self, *args, **kw):
        """
        Locale()
        Locale(language, flags=LOCALE_LOAD_DEFAULT)
        Locale(name, shortName=EmptyString, locale=EmptyString, bLoadDefault=True)
        
        wxLocale class encapsulates all language-dependent settings and is a
        generalization of the C locale concept.
        """

    def AddCatalog(self, *args, **kw):
        """
        AddCatalog(domain) -> bool
        AddCatalog(domain, msgIdLanguage) -> bool
        AddCatalog(domain, msgIdLanguage, msgIdCharset) -> bool
        
        Calls wxTranslations::AddCatalog(const wxString&).
        """

    def GetCanonicalName(self):
        """
        GetCanonicalName() -> String
        
        Returns the canonical form of current locale name.
        """

    def GetHeaderValue(self, header, domain=EmptyString):
        """
        GetHeaderValue(header, domain=EmptyString) -> String
        
        Calls wxTranslations::GetHeaderValue().
        """

    def GetLanguage(self):
        """
        GetLanguage() -> int
        
        Returns the wxLanguage constant of current language.
        """

    def GetLocale(self):
        """
        GetLocale() -> String
        
        Returns the locale name as passed to the constructor or Init().
        """

    def GetName(self):
        """
        GetName() -> String
        
        Returns the current short name for the locale (as given to the
        constructor or the Init() function).
        """

    def GetString(self, *args, **kw):
        """
        GetString(origString, domain=EmptyString) -> String
        GetString(origString, origString2, n, domain=EmptyString) -> String
        
        Calls wxGetTranslation(const wxString&, const wxString&).
        """

    def GetSysName(self):
        """
        GetSysName() -> String
        
        Returns current platform-specific locale name as passed to
        setlocale().
        """

    def Init(self, *args, **kw):
        """
        Init(language=LANGUAGE_DEFAULT, flags=LOCALE_LOAD_DEFAULT) -> bool
        Init(name, shortName=EmptyString, locale=EmptyString, bLoadDefault=True) -> bool
        
        Initializes the wxLocale instance.
        """

    def IsLoaded(self, domain):
        """
        IsLoaded(domain) -> bool
        
        Calls wxTranslations::IsLoaded().
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if the locale could be set successfully.
        """

    @staticmethod
    def AddCatalogLookupPathPrefix(prefix):
        """
        AddCatalogLookupPathPrefix(prefix)
        
        Calls wxFileTranslationsLoader::AddCatalogLookupPathPrefix().
        """

    @staticmethod
    def AddLanguage(info):
        """
        AddLanguage(info)
        
        Adds custom, user-defined language to the database of known languages.
        """

    @staticmethod
    def FindLanguageInfo(locale):
        """
        FindLanguageInfo(locale) -> LanguageInfo
        
        This function may be used to find the language description structure
        for the given locale, specified either as a two letter ISO language
        code (for example, "pt"), a language code followed by the country code
        ("pt_BR") or a full, human readable, language description
        ("Portuguese-Brazil").
        """

    @staticmethod
    def GetLanguageInfo(lang):
        """
        GetLanguageInfo(lang) -> LanguageInfo
        
        Returns a pointer to wxLanguageInfo structure containing information
        about the given language or NULL if this language is unknown.
        """

    @staticmethod
    def GetLanguageName(lang):
        """
        GetLanguageName(lang) -> String
        
        Returns English name of the given language or empty string if this
        language is unknown.
        """

    @staticmethod
    def GetLanguageCanonicalName(lang):
        """
        GetLanguageCanonicalName(lang) -> String
        
        Returns canonical name (see GetCanonicalName()) of the given language
        or empty string if this language is unknown.
        """

    @staticmethod
    def GetSystemEncoding():
        """
        GetSystemEncoding() -> FontEncoding
        
        Tries to detect the user's default font encoding.
        """

    @staticmethod
    def GetSystemEncodingName():
        """
        GetSystemEncodingName() -> String
        
        Tries to detect the name of the user's default font encoding.
        """

    @staticmethod
    def GetSystemLanguage():
        """
        GetSystemLanguage() -> int
        
        Tries to detect the user's default locale setting.
        """

    @staticmethod
    def GetInfo(index, cat=LOCALE_CAT_DEFAULT):
        """
        GetInfo(index, cat=LOCALE_CAT_DEFAULT) -> String
        
        Get the values of the given locale-dependent datum.
        """

    @staticmethod
    def IsAvailable(lang):
        """
        IsAvailable(lang) -> bool
        
        Check whether the operating system and/or C run time environment
        supports this locale.
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """
    CanonicalName = property(None, None)
    Language = property(None, None)
    Locale = property(None, None)
    Name = property(None, None)
    SysName = property(None, None)
# end of class Locale


#----------------------------------------------------------------------------
# Add the directory where the wxWidgets catalogs were installed
# to the default catalog path, if they were put in the pacakge dir.
import os
_localedir = os.path.join(os.path.dirname(__file__), "locale")
if os.path.exists(_localedir):
    Locale.AddCatalogLookupPathPrefix(_localedir)
del os
#----------------------------------------------------------------------------
#-- end-intl --#
#-- begin-translation --#

class Translations(object):
    """
    Translations()
    
    This class allows to get translations for strings.
    """

    def __init__(self):
        """
        Translations()
        
        This class allows to get translations for strings.
        """

    def SetLoader(self, loader):
        """
        SetLoader(loader)
        
        Changes loader use to read catalogs to a non-default one.
        """

    def SetLanguage(self, *args, **kw):
        """
        SetLanguage(lang)
        SetLanguage(lang)
        
        Sets translations language to use.
        """

    def GetAvailableTranslations(self, domain):
        """
        GetAvailableTranslations(domain) -> ArrayString
        
        Returns list of all translations of domain that were found.
        """

    def GetBestTranslation(self, *args, **kw):
        """
        GetBestTranslation(domain, msgIdLanguage) -> String
        GetBestTranslation(domain, msgIdLanguage="en") -> String
        
        Returns the best UI language for the domain.
        """

    def AddStdCatalog(self):
        """
        AddStdCatalog() -> bool
        
        Add standard wxWidgets catalogs ("wxstd" and possible port-specific
        catalogs).
        """

    def AddCatalog(self, *args, **kw):
        """
        AddCatalog(domain) -> bool
        AddCatalog(domain, msgIdLanguage) -> bool
        
        Add a catalog for use with the current locale.
        """

    def IsLoaded(self, domain):
        """
        IsLoaded(domain) -> bool
        
        Check if the given catalog is loaded, and returns true if it is.
        """

    def GetTranslatedString(self, *args, **kw):
        """
        GetTranslatedString(origString, domain=EmptyString) -> String
        GetTranslatedString(origString, n, domain=EmptyString) -> String
        
        Retrieves the translation for a string in all loaded domains unless
        the domain parameter is specified (and then only this catalog/domain
        is searched).
        """

    def GetHeaderValue(self, header, domain=EmptyString):
        """
        GetHeaderValue(header, domain=EmptyString) -> String
        
        Returns the header value for header header.
        """

    @staticmethod
    def Get():
        """
        Get() -> Translations
        
        Returns current translations object, may return NULL.
        """

    @staticmethod
    def Set(t):
        """
        Set(t)
        
        Sets current translations object.
        """
# end of class Translations


class TranslationsLoader(object):
    """
    TranslationsLoader()
    
    Abstraction of translations discovery and loading.
    """

    def __init__(self):
        """
        TranslationsLoader()
        
        Abstraction of translations discovery and loading.
        """

    def LoadCatalog(self, domain, lang):
        """
        LoadCatalog(domain, lang) -> MsgCatalog
        
        Called to load requested catalog.
        """

    def GetAvailableTranslations(self, domain):
        """
        GetAvailableTranslations(domain) -> ArrayString
        
        Implements wxTranslations::GetAvailableTranslations().
        """
# end of class TranslationsLoader


class FileTranslationsLoader(TranslationsLoader):
    """
    Standard wxTranslationsLoader implementation.
    """

    @staticmethod
    def AddCatalogLookupPathPrefix(prefix):
        """
        AddCatalogLookupPathPrefix(prefix)
        
        Add a prefix to the catalog lookup path: the message catalog files
        will be looked up under prefix/lang/LC_MESSAGES and prefix/lang
        directories (in this order).
        """
# end of class FileTranslationsLoader


def GetTranslation(*args, **kw):
    """
    GetTranslation(string, domain=EmptyString) -> String
    GetTranslation(string, plural, n, domain=EmptyString) -> String
    
    This function returns the translation of string in the current
    locale().
    """
#-- end-translation --#
#-- begin-cmndata --#
PRINTBIN_DEFAULT = 0
PRINTBIN_ONLYONE = 0
PRINTBIN_LOWER = 0
PRINTBIN_MIDDLE = 0
PRINTBIN_MANUAL = 0
PRINTBIN_ENVELOPE = 0
PRINTBIN_ENVMANUAL = 0
PRINTBIN_AUTO = 0
PRINTBIN_TRACTOR = 0
PRINTBIN_SMALLFMT = 0
PRINTBIN_LARGEFMT = 0
PRINTBIN_LARGECAPACITY = 0
PRINTBIN_CASSETTE = 0
PRINTBIN_FORMSOURCE = 0
PRINTBIN_USER = 0

class PageSetupDialogData(Object):
    """
    PageSetupDialogData()
    PageSetupDialogData(data)
    PageSetupDialogData(printData)
    
    This class holds a variety of information related to
    wxPageSetupDialog.
    """

    def __init__(self, *args, **kw):
        """
        PageSetupDialogData()
        PageSetupDialogData(data)
        PageSetupDialogData(printData)
        
        This class holds a variety of information related to
        wxPageSetupDialog.
        """

    def EnableHelp(self, flag):
        """
        EnableHelp(flag)
        
        Enables or disables the "Help" button (Windows only).
        """

    def EnableMargins(self, flag):
        """
        EnableMargins(flag)
        
        Enables or disables the margin controls (Windows only).
        """

    def EnableOrientation(self, flag):
        """
        EnableOrientation(flag)
        
        Enables or disables the orientation control (Windows only).
        """

    def EnablePaper(self, flag):
        """
        EnablePaper(flag)
        
        Enables or disables the paper size control (Windows only).
        """

    def EnablePrinter(self, flag):
        """
        EnablePrinter(flag)
        
        Enables or disables the "Printer" button, which invokes a printer
        setup dialog.
        """

    def GetDefaultInfo(self):
        """
        GetDefaultInfo() -> bool
        
        Returns true if the dialog will simply return default printer
        information (such as orientation) instead of showing a dialog (Windows
        only).
        """

    def GetDefaultMinMargins(self):
        """
        GetDefaultMinMargins() -> bool
        
        Returns true if the page setup dialog will take its minimum margin
        values from the currently selected printer properties (Windows only).
        """

    def GetEnableHelp(self):
        """
        GetEnableHelp() -> bool
        
        Returns true if the printer setup button is enabled.
        """

    def GetEnableMargins(self):
        """
        GetEnableMargins() -> bool
        
        Returns true if the margin controls are enabled (Windows only).
        """

    def GetEnableOrientation(self):
        """
        GetEnableOrientation() -> bool
        
        Returns true if the orientation control is enabled (Windows only).
        """

    def GetEnablePaper(self):
        """
        GetEnablePaper() -> bool
        
        Returns true if the paper size control is enabled (Windows only).
        """

    def GetEnablePrinter(self):
        """
        GetEnablePrinter() -> bool
        
        Returns true if the printer setup button is enabled.
        """

    def GetMarginBottomRight(self):
        """
        GetMarginBottomRight() -> Point
        
        Returns the right (x) and bottom (y) margins in millimetres.
        """

    def GetMarginTopLeft(self):
        """
        GetMarginTopLeft() -> Point
        
        Returns the left (x) and top (y) margins in millimetres.
        """

    def GetMinMarginBottomRight(self):
        """
        GetMinMarginBottomRight() -> Point
        
        Returns the right (x) and bottom (y) minimum margins the user can
        enter (Windows only).
        """

    def GetMinMarginTopLeft(self):
        """
        GetMinMarginTopLeft() -> Point
        
        Returns the left (x) and top (y) minimum margins the user can enter
        (Windows only).
        """

    def GetPaperId(self):
        """
        GetPaperId() -> PaperSize
        
        Returns the paper id (stored in the internal wxPrintData object).
        """

    def GetPaperSize(self):
        """
        GetPaperSize() -> Size
        
        Returns the paper size in millimetres.
        """

    def GetPrintData(self):
        """
        GetPrintData() -> PrintData
        
        Returns a reference to the print data associated with this object.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if the print data associated with the dialog data is
        valid.
        """

    def SetDefaultInfo(self, flag):
        """
        SetDefaultInfo(flag)
        
        Pass true if the dialog will simply return default printer information
        (such as orientation) instead of showing a dialog (Windows only).
        """

    def SetDefaultMinMargins(self, flag):
        """
        SetDefaultMinMargins(flag)
        
        Pass true if the page setup dialog will take its minimum margin values
        from the currently selected printer properties (Windows only).
        """

    def SetMarginBottomRight(self, pt):
        """
        SetMarginBottomRight(pt)
        
        Sets the right (x) and bottom (y) margins in millimetres.
        """

    def SetMarginTopLeft(self, pt):
        """
        SetMarginTopLeft(pt)
        
        Sets the left (x) and top (y) margins in millimetres.
        """

    def SetMinMarginBottomRight(self, pt):
        """
        SetMinMarginBottomRight(pt)
        
        Sets the right (x) and bottom (y) minimum margins the user can enter
        (Windows only).
        """

    def SetMinMarginTopLeft(self, pt):
        """
        SetMinMarginTopLeft(pt)
        
        Sets the left (x) and top (y) minimum margins the user can enter
        (Windows only).
        """

    def SetPaperId(self, id):
        """
        SetPaperId(id)
        
        Sets the paper size id.
        """

    def SetPaperSize(self, size):
        """
        SetPaperSize(size)
        
        Sets the paper size in millimetres.
        """

    def SetPrintData(self, printData):
        """
        SetPrintData(printData)
        
        Sets the print data associated with this object.
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """
    MarginBottomRight = property(None, None)
    MarginTopLeft = property(None, None)
    MinMarginBottomRight = property(None, None)
    MinMarginTopLeft = property(None, None)
    PaperId = property(None, None)
    PaperSize = property(None, None)
    PrintData = property(None, None)
# end of class PageSetupDialogData


class PrintData(Object):
    """
    PrintData()
    PrintData(data)
    
    This class holds a variety of information related to printers and
    printer device contexts.
    """

    def __init__(self, *args, **kw):
        """
        PrintData()
        PrintData(data)
        
        This class holds a variety of information related to printers and
        printer device contexts.
        """

    def GetBin(self):
        """
        GetBin() -> PrintBin
        
        Returns the current bin (papersource).
        """

    def GetCollate(self):
        """
        GetCollate() -> bool
        
        Returns true if collation is on.
        """

    def GetColour(self):
        """
        GetColour() -> bool
        
        Returns true if colour printing is on.
        """

    def GetDuplex(self):
        """
        GetDuplex() -> DuplexMode
        
        Returns the duplex mode.
        """

    def GetNoCopies(self):
        """
        GetNoCopies() -> int
        
        Returns the number of copies requested by the user.
        """

    def GetOrientation(self):
        """
        GetOrientation() -> PrintOrientation
        
        Gets the orientation.
        """

    def GetPaperId(self):
        """
        GetPaperId() -> PaperSize
        
        Returns the paper size id.
        """

    def GetPrinterName(self):
        """
        GetPrinterName() -> String
        
        Returns the printer name.
        """

    def GetQuality(self):
        """
        GetQuality() -> PrintQuality
        
        Returns the current print quality.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if the print data is valid for using in print dialogs.
        """

    def SetBin(self, flag):
        """
        SetBin(flag)
        
        Sets the current bin.
        """

    def SetCollate(self, flag):
        """
        SetCollate(flag)
        
        Sets collation to on or off.
        """

    def SetColour(self, flag):
        """
        SetColour(flag)
        
        Sets colour printing on or off.
        """

    def SetDuplex(self, mode):
        """
        SetDuplex(mode)
        
        Returns the duplex mode.
        """

    def SetNoCopies(self, n):
        """
        SetNoCopies(n)
        
        Sets the default number of copies to be printed out.
        """

    def SetOrientation(self, orientation):
        """
        SetOrientation(orientation)
        
        Sets the orientation.
        """

    def SetPaperId(self, paperId):
        """
        SetPaperId(paperId)
        
        Sets the paper id.
        """

    def SetPrinterName(self, printerName):
        """
        SetPrinterName(printerName)
        
        Sets the printer name.
        """

    def SetQuality(self, quality):
        """
        SetQuality(quality)
        
        Sets the desired print quality.
        """

    def GetFilename(self):
        """
        GetFilename() -> String
        """

    def SetFilename(self, filename):
        """
        SetFilename(filename)
        """

    def GetPrintMode(self):
        """
        GetPrintMode() -> PrintMode
        """

    def SetPrintMode(self, printMode):
        """
        SetPrintMode(printMode)
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """

    def GetPrivData(self):
        """
        GetPrivData() -> PyObject
        """

    def SetPrivData(self, data):
        """
        SetPrivData(data)
        """
    Bin = property(None, None)
    Collate = property(None, None)
    Colour = property(None, None)
    Duplex = property(None, None)
    Filename = property(None, None)
    NoCopies = property(None, None)
    Orientation = property(None, None)
    PaperId = property(None, None)
    PrintMode = property(None, None)
    PrinterName = property(None, None)
    PrivData = property(None, None)
    Quality = property(None, None)
# end of class PrintData


class PrintDialogData(Object):
    """
    PrintDialogData()
    PrintDialogData(dialogData)
    PrintDialogData(printData)
    
    This class holds information related to the visual characteristics of
    wxPrintDialog.
    """

    def __init__(self, *args, **kw):
        """
        PrintDialogData()
        PrintDialogData(dialogData)
        PrintDialogData(printData)
        
        This class holds information related to the visual characteristics of
        wxPrintDialog.
        """

    def EnableHelp(self, flag):
        """
        EnableHelp(flag)
        
        Enables or disables the "Help" button.
        """

    def EnablePageNumbers(self, flag):
        """
        EnablePageNumbers(flag)
        
        Enables or disables the "Page numbers" controls.
        """

    def EnablePrintToFile(self, flag):
        """
        EnablePrintToFile(flag)
        
        Enables or disables the "Print to file" checkbox.
        """

    def EnableSelection(self, flag):
        """
        EnableSelection(flag)
        
        Enables or disables the "Selection" radio button.
        """

    def GetAllPages(self):
        """
        GetAllPages() -> bool
        
        Returns true if the user requested that all pages be printed.
        """

    def GetCollate(self):
        """
        GetCollate() -> bool
        
        Returns true if the user requested that the document(s) be collated.
        """

    def GetFromPage(self):
        """
        GetFromPage() -> int
        
        Returns the from page number, as entered by the user.
        """

    def GetMaxPage(self):
        """
        GetMaxPage() -> int
        
        Returns the maximum page number.
        """

    def GetMinPage(self):
        """
        GetMinPage() -> int
        
        Returns the minimum page number.
        """

    def GetNoCopies(self):
        """
        GetNoCopies() -> int
        
        Returns the number of copies requested by the user.
        """

    def GetPrintData(self):
        """
        GetPrintData() -> PrintData
        
        Returns a reference to the internal wxPrintData object.
        """

    def GetPrintToFile(self):
        """
        GetPrintToFile() -> bool
        
        Returns true if the user has selected printing to a file.
        """

    def GetSelection(self):
        """
        GetSelection() -> bool
        
        Returns true if the user requested that the selection be printed
        (where "selection" is a concept specific to the application).
        """

    def GetToPage(self):
        """
        GetToPage() -> int
        
        Returns the "print to" page number, as entered by the user.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if the print data is valid for using in print dialogs.
        """

    def SetCollate(self, flag):
        """
        SetCollate(flag)
        
        Sets the "Collate" checkbox to true or false.
        """

    def SetFromPage(self, page):
        """
        SetFromPage(page)
        
        Sets the from page number.
        """

    def SetMaxPage(self, page):
        """
        SetMaxPage(page)
        
        Sets the maximum page number.
        """

    def SetMinPage(self, page):
        """
        SetMinPage(page)
        
        Sets the minimum page number.
        """

    def SetNoCopies(self, n):
        """
        SetNoCopies(n)
        
        Sets the default number of copies the user has requested to be printed
        out.
        """

    def SetPrintData(self, printData):
        """
        SetPrintData(printData)
        
        Sets the internal wxPrintData.
        """

    def SetPrintToFile(self, flag):
        """
        SetPrintToFile(flag)
        
        Sets the "Print to file" checkbox to true or false.
        """

    def SetSelection(self, flag):
        """
        SetSelection(flag)
        
        Selects the "Selection" radio button.
        """

    def SetToPage(self, page):
        """
        SetToPage(page)
        
        Sets the "print to" page number.
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """
    AllPages = property(None, None)
    Collate = property(None, None)
    FromPage = property(None, None)
    MaxPage = property(None, None)
    MinPage = property(None, None)
    NoCopies = property(None, None)
    PrintData = property(None, None)
    PrintToFile = property(None, None)
    Selection = property(None, None)
    ToPage = property(None, None)
# end of class PrintDialogData

#-- end-cmndata --#
#-- begin-gdicmn --#
BITMAP_TYPE_INVALID = 0
BITMAP_TYPE_BMP = 0
BITMAP_TYPE_ICO = 0
BITMAP_TYPE_CUR = 0
BITMAP_TYPE_XBM = 0
BITMAP_TYPE_XBM_DATA = 0
BITMAP_TYPE_XPM = 0
BITMAP_TYPE_XPM_DATA = 0
BITMAP_TYPE_TIFF = 0
BITMAP_TYPE_TIF = 0
BITMAP_TYPE_GIF = 0
BITMAP_TYPE_PNG = 0
BITMAP_TYPE_JPEG = 0
BITMAP_TYPE_PNM = 0
BITMAP_TYPE_PCX = 0
BITMAP_TYPE_PICT = 0
BITMAP_TYPE_ICON = 0
BITMAP_TYPE_ANI = 0
BITMAP_TYPE_IFF = 0
BITMAP_TYPE_TGA = 0
BITMAP_TYPE_MACCURSOR = 0
BITMAP_TYPE_ANY = 0
ODDEVEN_RULE = 0
WINDING_RULE = 0
CURSOR_NONE = 0
CURSOR_ARROW = 0
CURSOR_RIGHT_ARROW = 0
CURSOR_BULLSEYE = 0
CURSOR_CHAR = 0
CURSOR_CROSS = 0
CURSOR_HAND = 0
CURSOR_IBEAM = 0
CURSOR_LEFT_BUTTON = 0
CURSOR_MAGNIFIER = 0
CURSOR_MIDDLE_BUTTON = 0
CURSOR_NO_ENTRY = 0
CURSOR_PAINT_BRUSH = 0
CURSOR_PENCIL = 0
CURSOR_POINT_LEFT = 0
CURSOR_POINT_RIGHT = 0
CURSOR_QUESTION_ARROW = 0
CURSOR_RIGHT_BUTTON = 0
CURSOR_SIZENESW = 0
CURSOR_SIZENS = 0
CURSOR_SIZENWSE = 0
CURSOR_SIZEWE = 0
CURSOR_SIZING = 0
CURSOR_SPRAYCAN = 0
CURSOR_WAIT = 0
CURSOR_WATCH = 0
CURSOR_BLANK = 0
CURSOR_DEFAULT = 0
CURSOR_COPY_ARROW = 0
CURSOR_ARROWWAIT = 0
CURSOR_MAX = 0

class Point(object):
    """
    Point()
    Point(x, y)
    Point(pt)
    
    A wxPoint is a useful data structure for graphics operations.
    """

    def __init__(self, *args, **kw):
        """
        Point()
        Point(x, y)
        Point(pt)
        
        A wxPoint is a useful data structure for graphics operations.
        """

    def __iadd__(self, *args, **kw):
        """
        """

    def __isub__(self, *args, **kw):
        """
        """

    def IsFullySpecified(self):
        """
        IsFullySpecified() -> bool
        
        Returns true if neither of the point components is equal to
        wxDefaultCoord.
        """

    def SetDefaults(self, pt):
        """
        SetDefaults(pt)
        
        Combine this object with another one replacing the uninitialized
        values.
        """
    x = property(None, None)
    y = property(None, None)

    def __eq__(self, other):
        """
        __eq__(other) -> bool
        """

    def __ne__(self, other):
        """
        __ne__(other) -> bool
        """

    def Get(self):
        """
        Get() -> (x,y)
        
        Return the x and y properties as a tuple.
        """

    def GetIM(self):
        """
        Returns an immutable representation of the ``wx.Point`` object, based on ``namedtuple``.
        
        This new object is hashable and can be used as a dictionary key,
        be added to sets, etc.  It can be converted back into a real ``wx.Point``
        with a simple statement like this: ``obj = wx.Point(imObj)``.
        """

    def __str__(self):
        """
        
        """

    def __repr__(self):
        """
        
        """

    def __len__(self):
        """
        
        """

    def __nonzero__(self):
        """
        
        """

    def __reduce__(self):
        """
        
        """

    def __getitem__(self, idx):
        """
        
        """

    def __setitem__(self, idx, val):
        """
        
        """

    __safe_for_unpickling__ = True
    IM = property(None, None)
# end of class Point


class Size(object):
    """
    Size()
    Size(width, height)
    
    A wxSize is a useful data structure for graphics operations.
    """

    def __init__(self, *args, **kw):
        """
        Size()
        Size(width, height)
        
        A wxSize is a useful data structure for graphics operations.
        """

    def DecBy(self, *args, **kw):
        """
        DecBy(pt)
        DecBy(size)
        DecBy(dx, dy)
        DecBy(d)
        
        Decreases the size in both x and y directions.
        """

    def IncBy(self, *args, **kw):
        """
        IncBy(pt)
        IncBy(size)
        IncBy(dx, dy)
        IncBy(d)
        
        Increases the size in both x and y directions.
        """

    def __iadd__(self):
        """
        """

    def __isub__(self):
        """
        """

    def __idiv__(self):
        """
        """

    def __imul__(self):
        """
        """

    def DecTo(self, size):
        """
        DecTo(size)
        
        Decrements this object so that both of its dimensions are not greater
        than the corresponding dimensions of the size.
        """

    def DecToIfSpecified(self, size):
        """
        DecToIfSpecified(size)
        
        Decrements this object to be not bigger than the given size ignoring
        non-specified components.
        """

    def GetHeight(self):
        """
        GetHeight() -> int
        
        Gets the height member.
        """

    def GetWidth(self):
        """
        GetWidth() -> int
        
        Gets the width member.
        """

    def IncTo(self, size):
        """
        IncTo(size)
        
        Increments this object so that both of its dimensions are not less
        than the corresponding dimensions of the size.
        """

    def IsFullySpecified(self):
        """
        IsFullySpecified() -> bool
        
        Returns true if neither of the size object components is equal to -1,
        which is used as default for the size values in wxWidgets (hence the
        predefined wxDefaultSize has both of its components equal to -1).
        """

    def Scale(self, xscale, yscale):
        """
        Scale(xscale, yscale) -> Size
        
        Scales the dimensions of this object by the given factors.
        """

    def Set(self, width, height):
        """
        Set(width, height)
        
        Sets the width and height members.
        """

    def SetDefaults(self, sizeDefault):
        """
        SetDefaults(sizeDefault)
        
        Combine this size object with another one replacing the default (i.e.
        equal to -1) components of this object with those of the other.
        """

    def SetHeight(self, height):
        """
        SetHeight(height)
        
        Sets the height.
        """

    def SetWidth(self, width):
        """
        SetWidth(width)
        
        Sets the width.
        """
    Height = property(None, None)
    Width = property(None, None)
    width = property(None, None)
    height = property(None, None)
    x = property(None, None)
    y = property(None, None)

    def __eq__(self, other):
        """
        __eq__(other) -> bool
        """

    def __ne__(self, other):
        """
        __ne__(other) -> bool
        """

    def Get(self):
        """
        Get() -> (width, height)
        
        Return the width and height properties as a tuple.
        """

    def GetIM(self):
        """
        Returns an immutable representation of the ``wx.Size`` object, based on ``namedtuple``.
        
        This new object is hashable and can be used as a dictionary key,
        be added to sets, etc.  It can be converted back into a real ``wx.Size``
        with a simple statement like this: ``obj = wx.Size(imObj)``.
        """

    def __str__(self):
        """
        
        """

    def __repr__(self):
        """
        
        """

    def __len__(self):
        """
        
        """

    def __nonzero__(self):
        """
        
        """

    def __reduce__(self):
        """
        
        """

    def __getitem__(self, idx):
        """
        
        """

    def __setitem__(self, idx, val):
        """
        
        """

    __safe_for_unpickling__ = True
# end of class Size


class Rect(object):
    """
    Rect()
    Rect(x, y, width, height)
    Rect(pos, size)
    Rect(size)
    Rect(topLeft, bottomRight)
    
    A class for manipulating rectangles.
    """

    def __init__(self, *args, **kw):
        """
        Rect()
        Rect(x, y, width, height)
        Rect(pos, size)
        Rect(size)
        Rect(topLeft, bottomRight)
        
        A class for manipulating rectangles.
        """

    def CentreIn(self, r, dir=BOTH):
        """
        CentreIn(r, dir=BOTH) -> Rect
        
        Returns the rectangle having the same size as this one but centered
        relatively to the given rectangle r.
        """

    def CenterIn(self, r, dir=BOTH):
        """
        CenterIn(r, dir=BOTH) -> Rect
        
        Returns the rectangle having the same size as this one but centered
        relatively to the given rectangle r.
        """

    def Deflate(self, *args, **kw):
        """
        Deflate(dx, dy) -> Rect
        Deflate(diff) -> Rect
        Deflate(diff) -> Rect
        
        Decrease the rectangle size.
        """

    def Inflate(self, *args, **kw):
        """
        Inflate(dx, dy) -> Rect
        Inflate(diff) -> Rect
        Inflate(diff) -> Rect
        
        Increases the size of the rectangle.
        """

    def Offset(self, *args, **kw):
        """
        Offset(dx, dy)
        Offset(pt)
        
        Moves the rectangle by the specified offset.
        """

    def Union(self, rect):
        """
        Union(rect) -> Rect
        
        Modifies the rectangle to contain the bounding box of this rectangle
        and the one passed in as parameter.
        """

    def __iadd__(self):
        """
        """

    def __imul__(self):
        """
        """
    height = property(None, None)
    width = property(None, None)
    x = property(None, None)
    y = property(None, None)

    def Contains(self, *args, **kw):
        """
        Contains(x, y) -> bool
        Contains(pt) -> bool
        Contains(rect) -> bool
        
        Returns true if the given point is inside the rectangle (or on its
        boundary) and false otherwise.
        """

    def GetBottom(self):
        """
        GetBottom() -> int
        
        Gets the bottom point of the rectangle.
        """

    def GetBottomLeft(self):
        """
        GetBottomLeft() -> Point
        
        Gets the position of the bottom left corner.
        """

    def GetBottomRight(self):
        """
        GetBottomRight() -> Point
        
        Gets the position of the bottom right corner.
        """

    def GetHeight(self):
        """
        GetHeight() -> int
        
        Gets the height member.
        """

    def GetLeft(self):
        """
        GetLeft() -> int
        
        Gets the left point of the rectangle (the same as GetX()).
        """

    def GetPosition(self):
        """
        GetPosition() -> Point
        
        Gets the position.
        """

    def GetRight(self):
        """
        GetRight() -> int
        
        Gets the right point of the rectangle.
        """

    def GetSize(self):
        """
        GetSize() -> Size
        
        Gets the size.
        """

    def GetTop(self):
        """
        GetTop() -> int
        
        Gets the top point of the rectangle (the same as GetY()).
        """

    def GetTopLeft(self):
        """
        GetTopLeft() -> Point
        
        Gets the position of the top left corner of the rectangle, same as
        GetPosition().
        """

    def GetTopRight(self):
        """
        GetTopRight() -> Point
        
        Gets the position of the top right corner.
        """

    def GetWidth(self):
        """
        GetWidth() -> int
        
        Gets the width member.
        """

    def GetX(self):
        """
        GetX() -> int
        
        Gets the x member.
        """

    def GetY(self):
        """
        GetY() -> int
        
        Gets the y member.
        """

    def Intersect(self, rect):
        """
        Intersect(rect) -> Rect
        
        Modifies this rectangle to contain the overlapping portion of this
        rectangle and the one passed in as parameter.
        """

    def Intersects(self, rect):
        """
        Intersects(rect) -> bool
        
        Returns true if this rectangle has a non-empty intersection with the
        rectangle rect and false otherwise.
        """

    def IsEmpty(self):
        """
        IsEmpty() -> bool
        
        Returns true if this rectangle has a width or height less than or
        equal to 0 and false otherwise.
        """

    def SetHeight(self, height):
        """
        SetHeight(height)
        
        Sets the height.
        """

    def SetPosition(self, pos):
        """
        SetPosition(pos)
        
        Sets the position.
        """

    def SetSize(self, s):
        """
        SetSize(s)
        
        Sets the size.
        """

    def SetWidth(self, width):
        """
        SetWidth(width)
        
        Sets the width.
        """

    def SetX(self, x):
        """
        SetX(x)
        
        Sets the x position.
        """

    def SetY(self, y):
        """
        SetY(y)
        
        Sets the y position.
        """

    def SetLeft(self, left):
        """
        SetLeft(left)
        
        Set the left side of the rectangle.
        """

    def SetRight(self, right):
        """
        SetRight(right)
        
        Set the right side of the rectangle.
        """

    def SetTop(self, top):
        """
        SetTop(top)
        
        Set the top edge of the rectangle.
        """

    def SetBottom(self, bottom):
        """
        SetBottom(bottom)
        
        Set the bottom edge of the rectangle.
        """

    def SetTopLeft(self, p):
        """
        SetTopLeft(p)
        
        Set the top-left point of the rectangle.
        """

    def SetBottomRight(self, p):
        """
        SetBottomRight(p)
        
        Set the bottom-right point of the rectangle.
        """

    def SetTopRight(self, p):
        """
        SetTopRight(p)
        
        Set the top-right point of the rectangle.
        """

    def SetBottomLeft(self, p):
        """
        SetBottomLeft(p)
        
        Set the bottom-left point of the rectangle.
        """
    Bottom = property(None, None)
    BottomLeft = property(None, None)
    BottomRight = property(None, None)
    Height = property(None, None)
    Left = property(None, None)
    Position = property(None, None)
    Right = property(None, None)
    Size = property(None, None)
    Top = property(None, None)
    TopLeft = property(None, None)
    TopRight = property(None, None)
    Width = property(None, None)
    X = property(None, None)
    Y = property(None, None)
    left = property(None, None)
    top = property(None, None)
    right = property(None, None)
    bottom = property(None, None)
    bottomLeft = property(None, None)
    bottomRight = property(None, None)
    topLeft = property(None, None)
    topRight = property(None, None)

    def __eq__(self, other):
        """
        __eq__(other) -> bool
        """

    def __ne__(self, other):
        """
        __ne__(other) -> bool
        """

    def Get(self):
        """
        Get() -> (x, y, width, height)
        
        Return the rectangle's properties as a tuple.
        """

    def GetIM(self):
        """
        Returns an immutable representation of the ``wx.Rect`` object, based on ``namedtuple``.
        
        This new object is hashable and can be used as a dictionary key,
        be added to sets, etc.  It can be converted back into a real ``wx.Rect``
        with a simple statement like this: ``obj = wx.Rect(imObj)``.
        """

    def __str__(self):
        """
        
        """

    def __repr__(self):
        """
        
        """

    def __len__(self):
        """
        
        """

    def __nonzero__(self):
        """
        
        """

    def __reduce__(self):
        """
        
        """

    def __getitem__(self, idx):
        """
        
        """

    def __setitem__(self, idx, val):
        """
        
        """

    __safe_for_unpickling__ = True
# end of class Rect


class RealPoint(object):
    """
    RealPoint()
    RealPoint(x, y)
    RealPoint(pt)
    
    A wxRealPoint is a useful data structure for graphics operations.
    """

    def __init__(self, *args, **kw):
        """
        RealPoint()
        RealPoint(x, y)
        RealPoint(pt)
        
        A wxRealPoint is a useful data structure for graphics operations.
        """

    def __iadd__(self, *args, **kw):
        """
        """

    def __isub__(self, *args, **kw):
        """
        """
    x = property(None, None)
    y = property(None, None)

    def __eq__(self, other):
        """
        __eq__(other) -> bool
        """

    def __ne__(self, other):
        """
        __ne__(other) -> bool
        """

    def Get(self):
        """
        Get() -> (x, y)
        
        Return the point's properties as a tuple.
        """

    def GetIM(self):
        """
        Returns an immutable representation of the ``wx.RealPoint`` object, based on ``namedtuple``.
        
        This new object is hashable and can be used as a dictionary key,
        be added to sets, etc.  It can be converted back into a real ``wx.RealPoint``
        with a simple statement like this: ``obj = wx.RealPoint(imObj)``.
        """

    def __str__(self):
        """
        
        """

    def __repr__(self):
        """
        
        """

    def __len__(self):
        """
        
        """

    def __nonzero__(self):
        """
        
        """

    def __reduce__(self):
        """
        
        """

    def __getitem__(self, idx):
        """
        
        """

    def __setitem__(self, idx, val):
        """
        
        """

    __safe_for_unpickling__ = True
    IM = property(None, None)
# end of class RealPoint


class ColourDatabase(object):
    """
    ColourDatabase()
    
    wxWidgets maintains a database of standard RGB colours for a
    predefined set of named colours.
    """

    def __init__(self):
        """
        ColourDatabase()
        
        wxWidgets maintains a database of standard RGB colours for a
        predefined set of named colours.
        """

    def AddColour(self, colourName, colour):
        """
        AddColour(colourName, colour)
        
        Adds a colour to the database.
        """

    def Find(self, colourName):
        """
        Find(colourName) -> Colour
        
        Finds a colour given the name.
        """

    def FindName(self, colour):
        """
        FindName(colour) -> String
        
        Finds a colour name given the colour.
        """

    def FindColour(self, colour):
        """
        
        """
# end of class ColourDatabase


def ColourDisplay():
    """
    ColourDisplay() -> bool
    
    Returns true if the display is colour, false otherwise.
    """

def DisplayDepth():
    """
    DisplayDepth() -> int
    
    Returns the depth of the display (a value of 1 denotes a monochrome
    display).
    """

def SetCursor(cursor):
    """
    SetCursor(cursor)
    
    Globally sets the cursor; only has an effect on Windows, Mac and GTK+.
    """

def ClientDisplayRect():
    """
    ClientDisplayRect() -> (x, y, width, height)
    
    Returns the dimensions of the work area on the display.
    """

def GetClientDisplayRect():
    """
    GetClientDisplayRect() -> Rect
    
    Returns the dimensions of the work area on the display.
    """

def GetDisplayPPI():
    """
    GetDisplayPPI() -> Size
    
    Returns the display resolution in pixels per inch.
    """

def DisplaySize():
    """
    DisplaySize() -> (width, height)
    
    Returns the display size in pixels.
    """

def GetDisplaySize():
    """
    GetDisplaySize() -> Size
    
    Returns the display size in pixels.
    """

def DisplaySizeMM():
    """
    DisplaySizeMM() -> (width, height)
    
    Returns the display size in millimeters.
    """

def GetDisplaySizeMM():
    """
    GetDisplaySizeMM() -> Size
    
    Returns the display size in millimeters.
    """
DefaultPosition = Point()
DefaultSize = Size()

from collections import namedtuple
_im_Point = namedtuple('_im_Point', ['x', 'y'])
del namedtuple

from collections import namedtuple
_im_Size = namedtuple('_im_Size', ['width', 'height'])
del namedtuple

from collections import namedtuple
_im_Rect = namedtuple('_im_Rect', ['x', 'y', 'width', 'height'])
del namedtuple

from collections import namedtuple
_im_RealPoint = namedtuple('_im_RealPoint', ['x', 'y'])
del namedtuple

def IntersectRect(self, r1, r2):
    """
    IntersectRect(r1, r2) -> PyObject
    
    Calculate and return the intersection of r1 and r2.  Returns None if
    there
    is no intersection.
    """
#-- end-gdicmn --#
#-- begin-geometry --#
Inside = 0
OutLeft = 0
OutRight = 0
OutTop = 0
OutBottom = 0

class Point2D(object):
    """
    Point2DDouble()
    Point2DDouble(x, y)
    Point2DDouble(pt)
    Point2DDouble(pt)
    """

    def __init__(self, *args, **kw):
        """
        Point2DDouble()
        Point2DDouble(x, y)
        Point2DDouble(pt)
        Point2DDouble(pt)
        """
    m_x = property(None, None)
    m_y = property(None, None)

    def GetFloor(self):
        """
        GetFloor() -> (x, y)
        """

    def GetRounded(self):
        """
        GetRounded() -> (x, y)
        """

    def GetVectorLength(self):
        """
        GetVectorLength() -> Double
        """

    def GetVectorAngle(self):
        """
        GetVectorAngle() -> Double
        """

    def SetVectorLength(self, length):
        """
        SetVectorLength(length)
        """

    def SetVectorAngle(self, degrees):
        """
        SetVectorAngle(degrees)
        """

    def Normalize(self):
        """
        Normalize()
        """

    def GetDistance(self, pt):
        """
        GetDistance(pt) -> Double
        """

    def GetDistanceSquare(self, pt):
        """
        GetDistanceSquare(pt) -> Double
        """

    def GetDotProduct(self, vec):
        """
        GetDotProduct(vec) -> Double
        """

    def GetCrossProduct(self, vec):
        """
        GetCrossProduct(vec) -> Double
        """

    def __sub__(self):
        """
        """

    def __iadd__(self):
        """
        """

    def __isub__(self):
        """
        """

    def __imul__(self):
        """
        """

    def __idiv__(self):
        """
        """

    def __eq__(self):
        """
        """

    def __ne__(self):
        """
        """

    def Get(self):
        """
        Get() -> PyObject
        
        Get() -> (x,y)
        
        Return the x and y properties as a tuple.
        """

    def GetIM(self):
        """
        Returns an immutable representation of the ``wx.Point2D`` object, based on ``namedtuple``.
        
        This new object is hashable and can be used as a dictionary key,
        be added to sets, etc.  It can be converted back into a real ``wx.Point2D``
        with a simple statement like this: ``obj = wx.Point2D(imObj)``.
        """

    def __str__(self):
        """
        
        """

    def __repr__(self):
        """
        
        """

    def __len__(self):
        """
        
        """

    def __nonzero__(self):
        """
        
        """

    def __reduce__(self):
        """
        
        """

    def __getitem__(self, idx):
        """
        
        """

    def __setitem__(self, idx, val):
        """
        
        """

    __safe_for_unpickling__ = True
    IM = property(None, None)
    VectorAngle = property(None, None)
    VectorLength = property(None, None)
# end of class Point2D


class Rect2D(object):
    """
    Rect2DDouble()
    Rect2DDouble(x, y, w, h)
    """

    def __init__(self, *args, **kw):
        """
        Rect2DDouble()
        Rect2DDouble(x, y, w, h)
        """
    m_x = property(None, None)
    m_y = property(None, None)
    m_width = property(None, None)
    m_height = property(None, None)

    def GetPosition(self):
        """
        GetPosition() -> Point2DDouble
        """

    def GetSize(self):
        """
        GetSize() -> Size
        """

    def GetLeft(self):
        """
        GetLeft() -> Double
        """

    def SetLeft(self, n):
        """
        SetLeft(n)
        """

    def MoveLeftTo(self, n):
        """
        MoveLeftTo(n)
        """

    def GetTop(self):
        """
        GetTop() -> Double
        """

    def SetTop(self, n):
        """
        SetTop(n)
        """

    def MoveTopTo(self, n):
        """
        MoveTopTo(n)
        """

    def GetBottom(self):
        """
        GetBottom() -> Double
        """

    def SetBottom(self, n):
        """
        SetBottom(n)
        """

    def MoveBottomTo(self, n):
        """
        MoveBottomTo(n)
        """

    def GetRight(self):
        """
        GetRight() -> Double
        """

    def SetRight(self, n):
        """
        SetRight(n)
        """

    def MoveRightTo(self, n):
        """
        MoveRightTo(n)
        """

    def GetLeftTop(self):
        """
        GetLeftTop() -> Point2DDouble
        """

    def SetLeftTop(self, pt):
        """
        SetLeftTop(pt)
        """

    def MoveLeftTopTo(self, pt):
        """
        MoveLeftTopTo(pt)
        """

    def GetLeftBottom(self):
        """
        GetLeftBottom() -> Point2DDouble
        """

    def SetLeftBottom(self, pt):
        """
        SetLeftBottom(pt)
        """

    def MoveLeftBottomTo(self, pt):
        """
        MoveLeftBottomTo(pt)
        """

    def GetRightTop(self):
        """
        GetRightTop() -> Point2DDouble
        """

    def SetRightTop(self, pt):
        """
        SetRightTop(pt)
        """

    def MoveRightTopTo(self, pt):
        """
        MoveRightTopTo(pt)
        """

    def GetRightBottom(self):
        """
        GetRightBottom() -> Point2DDouble
        """

    def SetRightBottom(self, pt):
        """
        SetRightBottom(pt)
        """

    def MoveRightBottomTo(self, pt):
        """
        MoveRightBottomTo(pt)
        """

    def GetCentre(self):
        """
        GetCentre() -> Point2DDouble
        """

    def SetCentre(self, pt):
        """
        SetCentre(pt)
        """

    def MoveCentreTo(self, pt):
        """
        MoveCentreTo(pt)
        """

    def GetOutCode(self, pt):
        """
        GetOutCode(pt) -> OutCode
        """

    def GetOutcode(self, pt):
        """
        GetOutcode(pt) -> OutCode
        """

    def Contains(self, *args, **kw):
        """
        Contains(pt) -> bool
        Contains(rect) -> bool
        """

    def IsEmpty(self):
        """
        IsEmpty() -> bool
        """

    def HaveEqualSize(self, rect):
        """
        HaveEqualSize(rect) -> bool
        """

    def Inset(self, *args, **kw):
        """
        Inset(x, y)
        Inset(left, top, right, bottom)
        """

    def Offset(self, pt):
        """
        Offset(pt)
        """

    def ConstrainTo(self, rect):
        """
        ConstrainTo(rect)
        """

    def Interpolate(self, widthfactor, heightfactor):
        """
        Interpolate(widthfactor, heightfactor) -> Point2DDouble
        """

    def Intersect(self, *args, **kw):
        """
        Intersect(otherRect)
        Intersect(src1, src2, dest)
        """

    def CreateIntersection(self, otherRect):
        """
        CreateIntersection(otherRect) -> Rect2DDouble
        """

    def Intersects(self, rect):
        """
        Intersects(rect) -> bool
        """

    def Union(self, *args, **kw):
        """
        Union(otherRect)
        Union(pt)
        Union(src1, src2, dest)
        """

    def CreateUnion(self, otherRect):
        """
        CreateUnion(otherRect) -> Rect2DDouble
        """

    def Scale(self, *args, **kw):
        """
        Scale(f)
        Scale(num, denum)
        """

    def __eq__(self):
        """
        """

    def __ne__(self):
        """
        """

    def Get(self):
        """
        Get() -> PyObject
        
        Get() -> (x, y, width, height)
        
        Return the rectangle's properties as a tuple.
        """

    def GetIM(self):
        """
        Returns an immutable representation of the ``wx.Rect2D`` object, based on ``namedtuple``.
        
        This new object is hashable and can be used as a dictionary key,
        be added to sets, etc.  It can be converted back into a real ``wx.Rect2D``
        with a simple statement like this: ``obj = wx.Rect2D(imObj)``.
        """

    def __str__(self):
        """
        
        """

    def __repr__(self):
        """
        
        """

    def __len__(self):
        """
        
        """

    def __nonzero__(self):
        """
        
        """

    def __reduce__(self):
        """
        
        """

    def __getitem__(self, idx):
        """
        
        """

    def __setitem__(self, idx, val):
        """
        
        """

    __safe_for_unpickling__ = True
    Bottom = property(None, None)
    Centre = property(None, None)
    IM = property(None, None)
    Left = property(None, None)
    LeftBottom = property(None, None)
    LeftTop = property(None, None)
    Position = property(None, None)
    Right = property(None, None)
    RightBottom = property(None, None)
    RightTop = property(None, None)
    Size = property(None, None)
    Top = property(None, None)
# end of class Rect2D


from collections import namedtuple
_im_Point2D = namedtuple('_im_Point2D', ['x', 'y'])
del namedtuple

from collections import namedtuple
_im_Rect2D = namedtuple('_im_Rect2D', ['x', 'y', 'width', 'height'])
del namedtuple
#-- end-geometry --#
#-- begin-affinematrix2d --#

class Matrix2D(object):
    """
    Matrix2D(v11=1, v12=0, v21=0, v22=1)
    
    A simple container for 2x2 matrix.
    """

    def __init__(self, v11=1, v12=0, v21=0, v22=1):
        """
        Matrix2D(v11=1, v12=0, v21=0, v22=1)
        
        A simple container for 2x2 matrix.
        """
    m_11 = property(None, None)
    m_12 = property(None, None)
    m_21 = property(None, None)
    m_22 = property(None, None)
# end of class Matrix2D


class AffineMatrix2DBase(object):
    """
    AffineMatrix2DBase()
    
    A 2x3 matrix representing an affine 2D transformation.
    """

    def __init__(self):
        """
        AffineMatrix2DBase()
        
        A 2x3 matrix representing an affine 2D transformation.
        """

    def IsEqual(self, t):
        """
        IsEqual(t) -> bool
        
        Check that this matrix is identical with t.
        """

    def __eq__(self):
        """
        """

    def Set(self, mat2D, tr):
        """
        Set(mat2D, tr)
        
        Set all elements of this matrix.
        """

    def Get(self):
        """
        Get() -> (mat2D, tr)
        
        Get the component values of the matrix.
        """

    def Concat(self, t):
        """
        Concat(t)
        
        Concatenate this matrix with another one.
        """

    def Invert(self):
        """
        Invert() -> bool
        
        Invert this matrix.
        """

    def IsIdentity(self):
        """
        IsIdentity() -> bool
        
        Check if this is the identity matrix.
        """

    def __ne__(self):
        """
        """

    def Translate(self, dx, dy):
        """
        Translate(dx, dy)
        
        Add the translation to this matrix.
        """

    def Scale(self, xScale, yScale):
        """
        Scale(xScale, yScale)
        
        Add scaling to this matrix.
        """

    def Rotate(self, cRadians):
        """
        Rotate(cRadians)
        
        Add clockwise rotation to this matrix.
        """

    def Mirror(self, direction=HORIZONTAL):
        """
        Mirror(direction=HORIZONTAL)
        
        Add mirroring to this matrix.
        """

    def TransformPoint(self, *args, **kw):
        """
        TransformPoint(p) -> Point2DDouble
        TransformPoint(x, y) -> (x, y)
        
        Applies this matrix to the point.
        """

    def TransformDistance(self, *args, **kw):
        """
        TransformDistance(p) -> Point2DDouble
        TransformDistance(dx, dy) -> (dx, dy)
        
        Applies the linear part of this matrix, i.e. without translation.
        """
# end of class AffineMatrix2DBase


class AffineMatrix2D(AffineMatrix2DBase):
    """
    AffineMatrix2D()
    
    A 3x2 matrix representing an affine 2D transformation.
    """

    def __init__(self):
        """
        AffineMatrix2D()
        
        A 3x2 matrix representing an affine 2D transformation.
        """

    def IsEqual(self, t):
        """
        IsEqual(t)
        
        Check that this matrix is identical with t.
        """

    def __eq__(self):
        """
        """

    def Get(self):
        """
        Get() -> (mat2D, tr)
        
        Get the component values of the matrix.
        """

    def Set(self, mat2D, tr):
        """
        Set(mat2D, tr)
        
        Set all elements of this matrix.
        """

    def Concat(self, t):
        """
        Concat(t)
        
        Concatenate this matrix with another one.
        """

    def Invert(self):
        """
        Invert() -> bool
        
        Invert this matrix.
        """

    def IsIdentity(self):
        """
        IsIdentity() -> bool
        
        Check if this is the identity matrix.
        """

    def __ne__(self):
        """
        """

    def Translate(self, dx, dy):
        """
        Translate(dx, dy)
        
        Add the translation to this matrix.
        """

    def Scale(self, xScale, yScale):
        """
        Scale(xScale, yScale)
        
        Add scaling to this matrix.
        """

    def Mirror(self, direction=HORIZONTAL):
        """
        Mirror(direction=HORIZONTAL)
        
        Add mirroring to this matrix.
        """

    def Rotate(self, cRadians):
        """
        Rotate(cRadians)
        
        Add clockwise rotation to this matrix.
        """

    def TransformPoint(self, *args, **kw):
        """
        TransformPoint(p) -> Point2DDouble
        TransformPoint(x, y) -> (x, y)
        
        Applies this matrix to the point.
        """

    def TransformDistance(self, *args, **kw):
        """
        TransformDistance(p) -> Point2DDouble
        TransformDistance(dx, dy) -> (dx, dy)
        
        Applies the linear part of this matrix, i.e. without translation.
        """
# end of class AffineMatrix2D

#-- end-affinematrix2d --#
#-- begin-position --#

class Position(object):
    """
    Position()
    Position(row, col)
    
    This class represents the position of an item in any kind of grid of
    rows and columns such as wxGridBagSizer, or wxHVScrolledWindow.
    """

    def __init__(self, *args, **kw):
        """
        Position()
        Position(row, col)
        
        This class represents the position of an item in any kind of grid of
        rows and columns such as wxGridBagSizer, or wxHVScrolledWindow.
        """

    def __eq__(self):
        """
        """

    def __ne__(self):
        """
        """

    def __iadd__(self, *args, **kw):
        """
        """

    def __isub__(self, *args, **kw):
        """
        """

    def __add__(self, *args, **kw):
        """
        """

    def __sub__(self, *args, **kw):
        """
        """

    def GetCol(self):
        """
        GetCol() -> int
        
        A synonym for GetColumn().
        """

    def GetColumn(self):
        """
        GetColumn() -> int
        
        Get the current row value.
        """

    def GetRow(self):
        """
        GetRow() -> int
        
        Get the current row value.
        """

    def SetCol(self, column):
        """
        SetCol(column)
        
        A synonym for SetColumn().
        """

    def SetColumn(self, column):
        """
        SetColumn(column)
        
        Set a new column value.
        """

    def SetRow(self, row):
        """
        SetRow(row)
        
        Set a new row value.
        """

    def Get(self):
        """
        Get() -> (row,col)
        
        Return the row and col properties as a tuple.
        """

    def GetIM(self):
        """
        Returns an immutable representation of the ``wx.Position`` object, based on ``namedtuple``.
        
        This new object is hashable and can be used as a dictionary key,
        be added to sets, etc.  It can be converted back into a real ``wx.Position``
        with a simple statement like this: ``obj = wx.Position(imObj)``.
        """

    def __str__(self):
        """
        
        """

    def __repr__(self):
        """
        
        """

    def __len__(self):
        """
        
        """

    def __nonzero__(self):
        """
        
        """

    def __reduce__(self):
        """
        
        """

    def __getitem__(self, idx):
        """
        
        """

    def __setitem__(self, idx, val):
        """
        
        """

    __safe_for_unpickling__ = True
    Col = property(None, None)
    Column = property(None, None)
    IM = property(None, None)
    Row = property(None, None)
# end of class Position


from collections import namedtuple
_im_Position = namedtuple('_im_Position', ['Row', 'Col'])
del namedtuple
#-- end-position --#
#-- begin-colour --#
C2S_NAME = 0
C2S_CSS_SYNTAX = 0
C2S_HTML_SYNTAX = 0
ALPHA_TRANSPARENT = 0
ALPHA_OPAQUE = 0

class Colour(Object):
    """
    Colour()
    Colour(red, green, blue, alpha=ALPHA_OPAQUE)
    Colour(colRGB)
    Colour(colour)
    
    A colour is an object representing a combination of Red, Green, and
    Blue (RGB) intensity values, and is used to determine drawing colours.
    """

    def __init__(self, *args, **kw):
        """
        Colour()
        Colour(red, green, blue, alpha=ALPHA_OPAQUE)
        Colour(colRGB)
        Colour(colour)
        
        A colour is an object representing a combination of Red, Green, and
        Blue (RGB) intensity values, and is used to determine drawing colours.
        """

    def SetRGB(self, colRGB):
        """
        SetRGB(colRGB)
        
        Sets the RGB or RGBA colour values from a single 32 bit value.
        """

    def SetRGBA(self, colRGBA):
        """
        SetRGBA(colRGBA)
        
        Sets the RGB or RGBA colour values from a single 32 bit value.
        """

    def GetRGB(self):
        """
        GetRGB() -> Uint32
        
        Gets the RGB or RGBA colour values as a single 32 bit value.
        """

    def GetRGBA(self):
        """
        GetRGBA() -> Uint32
        
        Gets the RGB or RGBA colour values as a single 32 bit value.
        """

    def Set(self, *args, **kw):
        """
        Set(red, green, blue, alpha=ALPHA_OPAQUE)
        Set(RGB)
        Set(str) -> bool
        
        Sets the RGB intensity values using the given values (first overload),
        extracting them from the packed long (second overload), using the
        given string (third overload).
        """

    def Alpha(self):
        """
        Alpha() -> unsignedchar
        
        Returns the alpha value, on platforms where alpha is not yet
        supported, this always returns wxALPHA_OPAQUE.
        """

    def Blue(self):
        """
        Blue() -> unsignedchar
        
        Returns the blue intensity.
        """

    def GetAsString(self, flags=C2S_NAME|C2S_CSS_SYNTAX):
        """
        GetAsString(flags=C2S_NAME|C2S_CSS_SYNTAX) -> String
        
        Converts this colour to a wxString using the given flags.
        """

    def GetPixel(self):
        """
        GetPixel() -> IntPtr
        """

    def Green(self):
        """
        Green() -> unsignedchar
        
        Returns the green intensity.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if the colour object is valid (the colour has been
        initialised with RGB values).
        """

    def Red(self):
        """
        Red() -> unsignedchar
        
        Returns the red intensity.
        """

    def __ne__(self):
        """
        """

    def __eq__(self):
        """
        """

    def MakeDisabled(self, *args, **kw):
        """
        MakeDisabled(brightness=255) -> Colour
        MakeDisabled(r, g, b, brightness=255) -> (r, g, b)
        
        Make a disabled version of this colour.
        """

    def ChangeLightness(self, *args, **kw):
        """
        ChangeLightness(ialpha) -> Colour
        ChangeLightness(r, g, b, ialpha) -> (r, g, b)
        
        wxColour wrapper for ChangeLightness(r,g,b,ialpha).
        """

    @staticmethod
    def MakeMono(on):
        """
        MakeMono(on) -> (r, g, b)
        
        Assign 0 or 255 to rgb out parameters.
        """

    @staticmethod
    def MakeGrey(*args, **kw):
        """
        MakeGrey(r, g, b) -> (r, g, b)
        MakeGrey(r, g, b, weight_r, weight_g, weight_b) -> (r, g, b)
        
        Create a grey colour from (in/out) rgb parameters using integer
        arithmetic.
        """

    @staticmethod
    def AlphaBlend(fg, bg, alpha):
        """
        AlphaBlend(fg, bg, alpha) -> unsignedchar
        
        Blend colour, taking alpha into account.
        """
    Pixel = property(None, None)
    RGB = property(None, None)
    RGBA = property(None, None)
    red = property(None, None)
    green = property(None, None)
    blue = property(None, None)
    alpha = property(None, None)

    def _copyFrom(self, other):
        """
        _copyFrom(other)
        
        For internal use only.
        """

    def Get(self, includeAlpha=True):
        """
        Get(includeAlpha=True) -> (r,g,b) or (r,g,b,a)
        
        Returns the RGB intensity values as a tuple, optionally the alpha
        value as well.
        """

    def GetIM(self):
        """
        Returns an immutable representation of the ``wx.Colour`` object, based on ``namedtuple``.
        
        This new object is hashable and can be used as a dictionary key,
        be added to sets, etc.  It can be converted back into a real ``wx.Colour``
        with a simple statement like this: ``obj = wx.Colour(imObj)``.
        """

    def __str__(self):
        """
        
        """

    def __repr__(self):
        """
        
        """

    def __len__(self):
        """
        
        """

    def __nonzero__(self):
        """
        
        """

    def __reduce__(self):
        """
        
        """

    def __getitem__(self, idx):
        """
        
        """

    def __setitem__(self, idx, val):
        """
        
        """

    __safe_for_unpickling__ = True
# end of class Colour

NullColour = Colour()
TransparentColour = Colour()

def MacThemeColour(self, themeBrushID):
    """
    MacThemeColour(themeBrushID) -> Colour
    """

# These stock colours will be initialized when the wx.App object is created.
BLACK = Colour()
BLUE = Colour()
CYAN = Colour()
GREEN = Colour()
YELLOW = Colour()
LIGHT_GREY = Colour()
RED = Colour()
WHITE = Colour()

from collections import namedtuple
_im_Colour = namedtuple('_im_Colour', ['red', 'green', 'blue', 'alpha'])
del namedtuple

NamedColour = wx.deprecated(Colour, "Use Colour instead.")
#-- end-colour --#
#-- begin-stream --#
STREAM_NO_ERROR = 0
STREAM_EOF = 0
STREAM_WRITE_ERROR = 0
STREAM_READ_ERROR = 0
FromStart = 0
FromCurrent = 0
FromEnd = 0

class StreamBase(object):
    """
    StreamBase()
    
    This class is the base class of most stream related classes in
    wxWidgets.
    """

    def __init__(self):
        """
        StreamBase()
        
        This class is the base class of most stream related classes in
        wxWidgets.
        """

    def GetLastError(self):
        """
        GetLastError() -> StreamError
        
        This function returns the last error.
        """

    def GetLength(self):
        """
        GetLength() -> FileOffset
        
        Returns the length of the stream in bytes.
        """

    def GetSize(self):
        """
        GetSize() -> size_t
        
        This function returns the size of the stream.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if no error occurred on the stream.
        """

    def IsSeekable(self):
        """
        IsSeekable() -> bool
        
        Returns true if the stream supports seeking to arbitrary offsets.
        """

    def Reset(self, error=STREAM_NO_ERROR):
        """
        Reset(error=STREAM_NO_ERROR)
        
        Resets the stream state.
        """
    LastError = property(None, None)
    Length = property(None, None)
    Size = property(None, None)
# end of class StreamBase


class InputStream(StreamBase):
    """
    InputStream()
    
    wxInputStream is an abstract base class which may not be used
    directly.
    """

    def __init__(self):
        """
        InputStream()
        
        wxInputStream is an abstract base class which may not be used
        directly.
        """

    def CanRead(self):
        """
        CanRead() -> bool
        
        Returns true if some data is available in the stream right now, so
        that calling Read() wouldn't block.
        """

    def Eof(self):
        """
        Eof() -> bool
        
        Returns true after an attempt has been made to read past the end of
        the stream.
        """

    def GetC(self):
        """
        GetC() -> int
        
        Returns the first character in the input queue and removes it,
        blocking until it appears if necessary.
        """

    def LastRead(self):
        """
        LastRead() -> size_t
        
        Returns the last number of bytes read.
        """

    def Peek(self):
        """
        Peek() -> char
        
        Returns the first character in the input queue without removing it.
        """

    def Read(self, *args, **kw):
        """
        Read(buffer, size) -> InputStream
        Read(stream_out) -> InputStream
        
        Reads the specified amount of bytes and stores the data in buffer.
        """

    def ReadAll(self, buffer, size):
        """
        ReadAll(buffer, size) -> bool
        
        Reads exactly the specified number of bytes into the buffer.
        """

    def SeekI(self, pos, mode=FromStart):
        """
        SeekI(pos, mode=FromStart) -> FileOffset
        
        Changes the stream current position.
        """

    def TellI(self):
        """
        TellI() -> FileOffset
        
        Returns the current stream position or wxInvalidOffset if it's not
        available (e.g.
        """

    def Ungetch(self, *args, **kw):
        """
        Ungetch(buffer, size) -> size_t
        Ungetch(c) -> bool
        
        This function is only useful in read mode.
        """

    def seek(self, offset, whence=0):
        """
        seek(offset, whence=0)
        """

    def tell(self):
        """
        tell() -> FileOffset
        """

    def close(self):
        """
        close()
        """

    def flush(self):
        """
        flush()
        """

    def eof(self):
        """
        eof() -> bool
        """

    def read(self, *args, **kw):
        """
        read() -> PyObject
        read(size) -> PyObject
        """

    def readline(self, *args, **kw):
        """
        readline() -> PyObject
        readline(size) -> PyObject
        """

    def readlines(self, *args, **kw):
        """
        readlines() -> PyObject
        readlines(sizehint) -> PyObject
        """
    C = property(None, None)
# end of class InputStream


class OutputStream(StreamBase):
    """
    OutputStream()
    
    wxOutputStream is an abstract base class which may not be used
    directly.
    """

    def __init__(self):
        """
        OutputStream()
        
        wxOutputStream is an abstract base class which may not be used
        directly.
        """

    def Close(self):
        """
        Close() -> bool
        
        Closes the stream, returning false if an error occurs.
        """

    def LastWrite(self):
        """
        LastWrite() -> size_t
        
        Returns the number of bytes written during the last Write().
        """

    def PutC(self, c):
        """
        PutC(c)
        
        Puts the specified character in the output queue and increments the
        stream position.
        """

    def SeekO(self, pos, mode=FromStart):
        """
        SeekO(pos, mode=FromStart) -> FileOffset
        
        Changes the stream current position.
        """

    def TellO(self):
        """
        TellO() -> FileOffset
        
        Returns the current stream position.
        """

    def Write(self, *args, **kw):
        """
        Write(buffer, size) -> OutputStream
        Write(stream_in) -> OutputStream
        
        Writes up to the specified amount of bytes using the data of buffer.
        """

    def WriteAll(self, buffer, size):
        """
        WriteAll(buffer, size) -> bool
        
        Writes exactly the specified number of bytes from the buffer.
        """

    def seek(self, offset, whence=0):
        """
        seek(offset, whence=0)
        """

    def tell(self):
        """
        tell() -> FileOffset
        """

    def close(self):
        """
        close()
        """

    def flush(self):
        """
        flush()
        """

    def eof(self):
        """
        eof() -> bool
        """

    def write(self, data):
        """
        write(data) -> PyObject
        """
# end of class OutputStream

#-- end-stream --#
#-- begin-filesys --#
FS_READ = 0
FS_SEEKABLE = 0

class FileSystem(Object):
    """
    FileSystem()
    
    This class provides an interface for opening files on different file
    systems.
    """

    def __init__(self):
        """
        FileSystem()
        
        This class provides an interface for opening files on different file
        systems.
        """

    def ChangePathTo(self, location, is_dir=False):
        """
        ChangePathTo(location, is_dir=False)
        
        Sets the current location.
        """

    def FindFileInPath(self, pStr, path, file):
        """
        FindFileInPath(pStr, path, file) -> bool
        
        Looks for the file with the given name file in a colon or semi-colon
        (depending on the current platform) separated list of directories in
        path.
        """

    def FindFirst(self, wildcard, flags=0):
        """
        FindFirst(wildcard, flags=0) -> String
        
        Works like wxFindFirstFile().
        """

    def FindNext(self):
        """
        FindNext() -> String
        
        Returns the next filename that matches the parameters passed to
        FindFirst().
        """

    def GetPath(self):
        """
        GetPath() -> String
        
        Returns the actual path (set by wxFileSystem::ChangePathTo).
        """

    def OpenFile(self, location, flags=FS_READ):
        """
        OpenFile(location, flags=FS_READ) -> FSFile
        
        Opens the file and returns a pointer to a wxFSFile object or NULL if
        failed.
        """

    @staticmethod
    def AddHandler(handler):
        """
        AddHandler(handler)
        
        This static function adds new handler into the list of handlers (see
        wxFileSystemHandler) which provide access to virtual FS.
        """

    @staticmethod
    def RemoveHandler(handler):
        """
        RemoveHandler(handler) -> FileSystemHandler
        
        Remove a filesystem handler from the list of handlers.
        """

    @staticmethod
    def FileNameToURL(filename):
        """
        FileNameToURL(filename) -> String
        
        Converts a wxFileName into an URL.
        """

    @staticmethod
    def HasHandlerForPath(location):
        """
        HasHandlerForPath(location) -> bool
        
        This static function returns true if there is a registered handler
        which can open the given location.
        """

    @staticmethod
    def URLToFileName(url):
        """
        URLToFileName(url) -> FileName
        
        Converts URL into a well-formed filename.
        """
    Path = property(None, None)
# end of class FileSystem


class FSFile(Object):
    """
    FSFile(stream, location, mimetype, anchor, modif)
    
    This class represents a single file opened by wxFileSystem.
    """

    def __init__(self, stream, location, mimetype, anchor, modif):
        """
        FSFile(stream, location, mimetype, anchor, modif)
        
        This class represents a single file opened by wxFileSystem.
        """

    def DetachStream(self):
        """
        DetachStream() -> InputStream
        
        Detaches the stream from the wxFSFile object.
        """

    def GetAnchor(self):
        """
        GetAnchor() -> String
        
        Returns anchor (if present).
        """

    def GetLocation(self):
        """
        GetLocation() -> String
        
        Returns full location of the file, including path and protocol.
        """

    def GetMimeType(self):
        """
        GetMimeType() -> String
        
        Returns the MIME type of the content of this file.
        """

    def GetModificationTime(self):
        """
        GetModificationTime() -> DateTime
        
        Returns time when this file was modified.
        """

    def GetStream(self):
        """
        GetStream() -> InputStream
        
        Returns pointer to the stream.
        """
    Anchor = property(None, None)
    Location = property(None, None)
    MimeType = property(None, None)
    ModificationTime = property(None, None)
    Stream = property(None, None)
# end of class FSFile


class FileSystemHandler(Object):
    """
    FileSystemHandler()
    
    Classes derived from wxFileSystemHandler are used to access virtual
    file systems.
    """

    def __init__(self):
        """
        FileSystemHandler()
        
        Classes derived from wxFileSystemHandler are used to access virtual
        file systems.
        """

    def CanOpen(self, location):
        """
        CanOpen(location) -> bool
        
        Returns true if the handler is able to open this file.
        """

    def FindFirst(self, wildcard, flags=0):
        """
        FindFirst(wildcard, flags=0) -> String
        
        Works like wxFindFirstFile().
        """

    def FindNext(self):
        """
        FindNext() -> String
        
        Returns next filename that matches parameters passed to
        wxFileSystem::FindFirst.
        """

    def OpenFile(self, fs, location):
        """
        OpenFile(fs, location) -> FSFile
        
        Opens the file and returns wxFSFile pointer or NULL if failed.
        """

    @staticmethod
    def GetMimeTypeFromExt(location):
        """
        GetMimeTypeFromExt(location) -> String
        
        Returns the MIME type based on extension of location.
        """

    @staticmethod
    def GetAnchor(location):
        """
        GetAnchor(location) -> String
        
        Returns the anchor if present in the location.
        """

    @staticmethod
    def GetLeftLocation(location):
        """
        GetLeftLocation(location) -> String
        
        Returns the left location string extracted from location.
        """

    @staticmethod
    def GetProtocol(location):
        """
        GetProtocol(location) -> String
        
        Returns the protocol string extracted from location.
        """

    @staticmethod
    def GetRightLocation(location):
        """
        GetRightLocation(location) -> String
        
        Returns the right location string extracted from location.
        """
# end of class FileSystemHandler


class MemoryFSHandler(FileSystemHandler):
    """
    MemoryFSHandler()
    
    This wxFileSystem handler can store arbitrary data in memory stream
    and make them accessible via an URL.
    """

    def __init__(self):
        """
        MemoryFSHandler()
        
        This wxFileSystem handler can store arbitrary data in memory stream
        and make them accessible via an URL.
        """

    @staticmethod
    def AddFile(*args, **kw):
        """
        AddFile(filename, image, type)
        AddFile(filename, bitmap, type)
        AddFile(filename, textdata)
        AddFile(filename, binarydata)
        
        Adds a file to the list of the files stored in memory.
        """

    @staticmethod
    def AddFileWithMimeType(*args, **kw):
        """
        AddFileWithMimeType(filename, textdata, mimetype)
        AddFileWithMimeType(filename, binarydata, mimetype)
        
        Like AddFile(), but lets you explicitly specify added file's MIME
        type.
        """

    @staticmethod
    def RemoveFile(filename):
        """
        RemoveFile(filename)
        
        Removes a file from memory FS and frees the occupied memory.
        """
# end of class MemoryFSHandler


class ArchiveFSHandler(FileSystemHandler):
    """
    ArchiveFSHandler()
    
    A file system handler for accessing files inside of archives.
    """

    def __init__(self):
        """
        ArchiveFSHandler()
        
        A file system handler for accessing files inside of archives.
        """

    def Cleanup(self):
        """
        Cleanup()
        """
# end of class ArchiveFSHandler


class FilterFSHandler(FileSystemHandler):
    """
    FilterFSHandler()
    
    Filter file system handler.
    """

    def __init__(self):
        """
        FilterFSHandler()
        
        Filter file system handler.
        """
# end of class FilterFSHandler


class InternetFSHandler(FileSystemHandler):
    """
    InternetFSHandler()
    
    A file system handler for accessing files from internet servers.
    """

    def __init__(self):
        """
        InternetFSHandler()
        
        A file system handler for accessing files from internet servers.
        """
# end of class InternetFSHandler


ZipFSHandler = wx.deprecated(ArchiveFSHandler, "Use ArchiveFSHandler instead.")
#-- end-filesys --#
#-- begin-image --#
IMAGE_RESOLUTION_NONE = 0
IMAGE_RESOLUTION_INCHES = 0
IMAGE_RESOLUTION_CM = 0
IMAGE_QUALITY_NEAREST = 0
IMAGE_QUALITY_BILINEAR = 0
IMAGE_QUALITY_BICUBIC = 0
IMAGE_QUALITY_BOX_AVERAGE = 0
IMAGE_QUALITY_NORMAL = 0
IMAGE_QUALITY_HIGH = 0
PNG_TYPE_COLOUR = 0
PNG_TYPE_GREY = 0
PNG_TYPE_GREY_RED = 0
PNG_TYPE_PALETTE = 0
BMP_24BPP = 0
BMP_8BPP = 0
BMP_8BPP_GREY = 0
BMP_8BPP_GRAY = 0
BMP_8BPP_RED = 0
BMP_8BPP_PALETTE = 0
BMP_4BPP = 0
BMP_1BPP = 0
BMP_1BPP_BW = 0
IMAGE_ALPHA_TRANSPARENT = 0
IMAGE_ALPHA_OPAQUE = 0
IMAGE_ALPHA_THRESHOLD = 0

class Image(Object):
    """
    Image()
    Image(width, height, clear=True)
    Image(sz, clear=True)
    Image(name, type=BITMAP_TYPE_ANY, index=-1)
    Image(name, mimetype, index=-1)
    Image(stream, type=BITMAP_TYPE_ANY, index=-1)
    Image(stream, mimetype, index=-1)
    Image(width, height, data)
    Image(width, height, data, alpha)
    Image(size, data)
    Image(size, data, alpha)
    
    This class encapsulates a platform-independent image.
    """

    class HSVValue(object):
        """
        HSVValue(h=0.0, s=0.0, v=0.0)
        
        A simple class which stores hue, saturation and value as doubles in
        the range 0.0-1.0.
        """

        def __init__(self, h=0.0, s=0.0, v=0.0):
            """
            HSVValue(h=0.0, s=0.0, v=0.0)
            
            A simple class which stores hue, saturation and value as doubles in
            the range 0.0-1.0.
            """
        hue = property(None, None)
        saturation = property(None, None)
        value = property(None, None)
    # end of class HSVValue


    class RGBValue(object):
        """
        RGBValue(r=0, g=0, b=0)
        
        A simple class which stores red, green and blue values as 8 bit
        unsigned integers in the range of 0-255.
        """

        def __init__(self, r=0, g=0, b=0):
            """
            RGBValue(r=0, g=0, b=0)
            
            A simple class which stores red, green and blue values as 8 bit
            unsigned integers in the range of 0-255.
            """
        red = property(None, None)
        green = property(None, None)
        blue = property(None, None)
    # end of class RGBValue


    def __init__(self, *args, **kw):
        """
        Image()
        Image(width, height, clear=True)
        Image(sz, clear=True)
        Image(name, type=BITMAP_TYPE_ANY, index=-1)
        Image(name, mimetype, index=-1)
        Image(stream, type=BITMAP_TYPE_ANY, index=-1)
        Image(stream, mimetype, index=-1)
        Image(width, height, data)
        Image(width, height, data, alpha)
        Image(size, data)
        Image(size, data, alpha)
        
        This class encapsulates a platform-independent image.
        """

    def Copy(self):
        """
        Copy() -> Image
        
        Returns an identical copy of this image.
        """

    def Create(self, *args, **kw):
        """
        Create(width, height, clear=True) -> bool
        Create(sz, clear=True) -> bool
        Create(width, height, data) -> bool
        Create(width, height, data, alpha) -> bool
        Create(size, data) -> bool
        Create(size, data, alpha) -> bool
        
        Creates a fresh image.
        """

    def Clear(self, value=0):
        """
        Clear(value=0)
        
        Initialize the image data with zeroes (the default) or with the byte
        value given as value.
        """

    def Destroy(self):
        """
        Destroy()
        
        Destroys the image data.
        """

    def InitAlpha(self):
        """
        InitAlpha()
        
        Initializes the image alpha channel data.
        """

    def Blur(self, blurRadius):
        """
        Blur(blurRadius) -> Image
        
        Blurs the image in both horizontal and vertical directions by the
        specified pixel blurRadius.
        """

    def BlurHorizontal(self, blurRadius):
        """
        BlurHorizontal(blurRadius) -> Image
        
        Blurs the image in the horizontal direction only.
        """

    def BlurVertical(self, blurRadius):
        """
        BlurVertical(blurRadius) -> Image
        
        Blurs the image in the vertical direction only.
        """

    def Mirror(self, horizontally=True):
        """
        Mirror(horizontally=True) -> Image
        
        Returns a mirrored copy of the image.
        """

    def Paste(self, image, x, y):
        """
        Paste(image, x, y)
        
        Copy the data of the given image to the specified position in this
        image.
        """

    def Replace(self, r1, g1, b1, r2, g2, b2):
        """
        Replace(r1, g1, b1, r2, g2, b2)
        
        Replaces the colour specified by r1,g1,b1 by the colour r2,g2,b2.
        """

    def Rescale(self, width, height, quality=IMAGE_QUALITY_NORMAL):
        """
        Rescale(width, height, quality=IMAGE_QUALITY_NORMAL) -> Image
        
        Changes the size of the image in-place by scaling it: after a call to
        this function,the image will have the given width and height.
        """

    def Resize(self, size, pos, red=-1, green=-1, blue=-1):
        """
        Resize(size, pos, red=-1, green=-1, blue=-1) -> Image
        
        Changes the size of the image in-place without scaling it by adding
        either a border with the given colour or cropping as necessary.
        """

    def Rotate(self, angle, rotationCentre, interpolating=True, offsetAfterRotation=None):
        """
        Rotate(angle, rotationCentre, interpolating=True, offsetAfterRotation=None) -> Image
        
        Rotates the image about the given point, by angle radians.
        """

    def Rotate90(self, clockwise=True):
        """
        Rotate90(clockwise=True) -> Image
        
        Returns a copy of the image rotated 90 degrees in the direction
        indicated by clockwise.
        """

    def Rotate180(self):
        """
        Rotate180() -> Image
        
        Returns a copy of the image rotated by 180 degrees.
        """

    def RotateHue(self, angle):
        """
        RotateHue(angle)
        
        Rotates the hue of each pixel in the image by angle, which is a double
        in the range of -1.0 to +1.0, where -1.0 corresponds to -360 degrees
        and +1.0 corresponds to +360 degrees.
        """

    def Scale(self, width, height, quality=IMAGE_QUALITY_NORMAL):
        """
        Scale(width, height, quality=IMAGE_QUALITY_NORMAL) -> Image
        
        Returns a scaled version of the image.
        """

    def Size(self, size, pos, red=-1, green=-1, blue=-1):
        """
        Size(size, pos, red=-1, green=-1, blue=-1) -> Image
        
        Returns a resized version of this image without scaling it by adding
        either a border with the given colour or cropping as necessary.
        """

    def ConvertAlphaToMask(self, *args, **kw):
        """
        ConvertAlphaToMask(threshold=IMAGE_ALPHA_THRESHOLD) -> bool
        ConvertAlphaToMask(mr, mg, mb, threshold=IMAGE_ALPHA_THRESHOLD) -> bool
        
        If the image has alpha channel, this method converts it to mask.
        """

    def ConvertToGreyscale(self, *args, **kw):
        """
        ConvertToGreyscale(weight_r, weight_g, weight_b) -> Image
        ConvertToGreyscale() -> Image
        
        Returns a greyscale version of the image.
        """

    def ConvertToMono(self, r, g, b):
        """
        ConvertToMono(r, g, b) -> Image
        
        Returns monochromatic version of the image.
        """

    def ConvertToDisabled(self, brightness=255):
        """
        ConvertToDisabled(brightness=255) -> Image
        
        Returns disabled (dimmed) version of the image.
        """

    def ComputeHistogram(self, histogram):
        """
        ComputeHistogram(histogram) -> unsignedlong
        
        Computes the histogram of the image.
        """

    def FindFirstUnusedColour(self, startR=1, startG=0, startB=0):
        """
        FindFirstUnusedColour(startR=1, startG=0, startB=0) -> (r, g, b)
        
        Finds the first colour that is never used in the image.
        """

    def GetAlpha(self, *args, **kw):
        """
        GetAlpha(x, y) -> unsignedchar
        GetAlpha() -> PyObject
        
        Return alpha value at given pixel location.
        """

    def GetData(self):
        """
        GetData() -> PyObject
        
        Returns a copy of the RGB bytes of the image.
        """

    def GetRed(self, x, y):
        """
        GetRed(x, y) -> unsignedchar
        
        Returns the red intensity at the given coordinate.
        """

    def GetGreen(self, x, y):
        """
        GetGreen(x, y) -> unsignedchar
        
        Returns the green intensity at the given coordinate.
        """

    def GetBlue(self, x, y):
        """
        GetBlue(x, y) -> unsignedchar
        
        Returns the blue intensity at the given coordinate.
        """

    def GetMaskRed(self):
        """
        GetMaskRed() -> unsignedchar
        
        Gets the red value of the mask colour.
        """

    def GetMaskGreen(self):
        """
        GetMaskGreen() -> unsignedchar
        
        Gets the green value of the mask colour.
        """

    def GetMaskBlue(self):
        """
        GetMaskBlue() -> unsignedchar
        
        Gets the blue value of the mask colour.
        """

    def GetWidth(self):
        """
        GetWidth() -> int
        
        Gets the width of the image in pixels.
        """

    def GetHeight(self):
        """
        GetHeight() -> int
        
        Gets the height of the image in pixels.
        """

    def GetSize(self):
        """
        GetSize() -> Size
        
        Returns the size of the image in pixels.
        """

    def GetOption(self, name):
        """
        GetOption(name) -> String
        
        Gets a user-defined string-valued option.
        """

    def GetOptionInt(self, name):
        """
        GetOptionInt(name) -> int
        
        Gets a user-defined integer-valued option.
        """

    def GetOrFindMaskColour(self):
        """
        GetOrFindMaskColour() -> (r, g, b)
        
        Get the current mask colour or find a suitable unused colour that
        could be used as a mask colour.
        """

    def GetPalette(self):
        """
        GetPalette() -> Palette
        
        Returns the palette associated with the image.
        """

    def GetSubImage(self, rect):
        """
        GetSubImage(rect) -> Image
        
        Returns a sub image of the current one as long as the rect belongs
        entirely to the image.
        """

    def GetType(self):
        """
        GetType() -> BitmapType
        
        Gets the type of image found by LoadFile() or specified with
        SaveFile().
        """

    def HasAlpha(self):
        """
        HasAlpha() -> bool
        
        Returns true if this image has alpha channel, false otherwise.
        """

    def HasMask(self):
        """
        HasMask() -> bool
        
        Returns true if there is a mask active, false otherwise.
        """

    def HasOption(self, name):
        """
        HasOption(name) -> bool
        
        Returns true if the given option is present.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if image data is present.
        """

    def IsTransparent(self, x, y, threshold=IMAGE_ALPHA_THRESHOLD):
        """
        IsTransparent(x, y, threshold=IMAGE_ALPHA_THRESHOLD) -> bool
        
        Returns true if the given pixel is transparent, i.e. either has the
        mask colour if this image has a mask or if this image has alpha
        channel and alpha value of this pixel is strictly less than threshold.
        """

    def LoadFile(self, *args, **kw):
        """
        LoadFile(stream, type=BITMAP_TYPE_ANY, index=-1) -> bool
        LoadFile(name, type=BITMAP_TYPE_ANY, index=-1) -> bool
        LoadFile(name, mimetype, index=-1) -> bool
        LoadFile(stream, mimetype, index=-1) -> bool
        
        Loads an image from an input stream.
        """

    def SaveFile(self, *args, **kw):
        """
        SaveFile(stream, mimetype) -> bool
        SaveFile(name, type) -> bool
        SaveFile(name, mimetype) -> bool
        SaveFile(name) -> bool
        SaveFile(stream, type) -> bool
        
        Saves an image in the given stream.
        """

    def SetAlpha(self, *args, **kw):
        """
        SetAlpha(x, y, alpha)
        SetAlpha(alpha)
        
        Sets the alpha value for the given pixel.
        """

    def ClearAlpha(self):
        """
        ClearAlpha()
        
        Removes the alpha channel from the image.
        """

    def SetData(self, *args, **kw):
        """
        SetData(data)
        SetData(data, new_width, new_height)
        
        Sets the image data without performing checks.
        """

    def SetMask(self, hasMask=True):
        """
        SetMask(hasMask=True)
        
        Specifies whether there is a mask or not.
        """

    def SetMaskColour(self, red, green, blue):
        """
        SetMaskColour(red, green, blue)
        
        Sets the mask colour for this image (and tells the image to use the
        mask).
        """

    def SetMaskFromImage(self, mask, mr, mg, mb):
        """
        SetMaskFromImage(mask, mr, mg, mb) -> bool
        
        Sets image's mask so that the pixels that have RGB value of mr,mg,mb
        in mask will be masked in the image.
        """

    def SetOption(self, *args, **kw):
        """
        SetOption(name, value)
        SetOption(name, value)
        
        Sets a user-defined option.
        """

    def SetPalette(self, palette):
        """
        SetPalette(palette)
        
        Associates a palette with the image.
        """

    def SetRGB(self, *args, **kw):
        """
        SetRGB(x, y, r, g, b)
        SetRGB(rect, red, green, blue)
        
        Set the color of the pixel at the given x and y coordinate.
        """

    def SetType(self, type):
        """
        SetType(type)
        
        Set the type of image returned by GetType().
        """

    @staticmethod
    def AddHandler(handler):
        """
        AddHandler(handler)
        
        Register an image handler.
        """

    @staticmethod
    def CleanUpHandlers():
        """
        CleanUpHandlers()
        
        Deletes all image handlers.
        """

    @staticmethod
    def FindHandler(*args, **kw):
        """
        FindHandler(name) -> ImageHandler
        FindHandler(extension, imageType) -> ImageHandler
        FindHandler(imageType) -> ImageHandler
        
        Finds the handler with the given name.
        """

    @staticmethod
    def FindHandlerMime(mimetype):
        """
        FindHandlerMime(mimetype) -> ImageHandler
        
        Finds the handler associated with the given MIME type.
        """

    @staticmethod
    def InitStandardHandlers():
        """
        InitStandardHandlers()
        
        Internal use only.
        """

    @staticmethod
    def InsertHandler(handler):
        """
        InsertHandler(handler)
        
        Adds a handler at the start of the static list of format handlers.
        """

    @staticmethod
    def RemoveHandler(name):
        """
        RemoveHandler(name) -> bool
        
        Finds the handler with the given name, and removes it.
        """

    @staticmethod
    def GetImageCount(*args, **kw):
        """
        GetImageCount(filename, type=BITMAP_TYPE_ANY) -> int
        GetImageCount(stream, type=BITMAP_TYPE_ANY) -> int
        
        If the image file contains more than one image and the image handler
        is capable of retrieving these individually, this function will return
        the number of available images.
        """

    @staticmethod
    def CanRead(*args, **kw):
        """
        CanRead(filename) -> bool
        CanRead(stream) -> bool
        
        Returns true if at least one of the available image handlers can read
        the file with the given name.
        """

    @staticmethod
    def GetImageExtWildcard():
        """
        GetImageExtWildcard() -> String
        
        Iterates all registered wxImageHandler objects, and returns a string
        containing file extension masks suitable for passing to file open/save
        dialog boxes.
        """

    @staticmethod
    def RGBtoHSV(rgb):
        """
        RGBtoHSV(rgb) -> Image.HSVValue
        
        Converts a color in RGB color space to HSV color space.
        """

    @staticmethod
    def HSVtoRGB(hsv):
        """
        HSVtoRGB(hsv) -> Image.RGBValue
        
        Converts a color in HSV color space to RGB color space.
        """

    def GetDataBuffer(self):
        """
        GetDataBuffer() -> PyObject
        
        Returns a writable Python buffer object that is pointing at the RGB
        image data buffer inside the :class:`Image`. You need to ensure that
        you do
        not use this buffer object after the image has been destroyed.
        """

    def GetAlphaBuffer(self):
        """
        GetAlphaBuffer() -> PyObject
        
        Returns a writable Python buffer object that is pointing at the Alpha
        data buffer inside the :class:`Image`. You need to ensure that you do
        not use this buffer object after the image has been destroyed.
        """

    def SetDataBuffer(self, *args, **kw):
        """
        SetDataBuffer(data)
        SetDataBuffer(data, new_width, new_height)
        
        Sets the internal image data pointer to point at a Python buffer
        object.  This can save making an extra copy of the data but you must
        ensure that the buffer object lives lives at least as long as the
        :class:`Image` does.
        """

    def SetAlphaBuffer(self, alpha):
        """
        SetAlphaBuffer(alpha)
        
        Sets the internal image alpha pointer to point at a Python buffer
        object.  This can save making an extra copy of the data but you must
        ensure that the buffer object lives lives at least as long as the
        :class:`Image` does.
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """

    def ConvertToBitmap(self, depth=-1):
        """
        ConvertToBitmap(depth=-1) -> Bitmap
        
        Convert the image to a :class:`wx.Bitmap`.
        """

    def ConvertToMonoBitmap(self, red, green, blue):
        """
        ConvertToMonoBitmap(red, green, blue) -> Bitmap
        
        Creates a monochrome version of the image and returns it as a :class:`wx.Bitmap`.
        """

    def AdjustChannels(self, factor_red, factor_green, factor_blue, factor_alpha=1.0):
        """
        AdjustChannels(factor_red, factor_green, factor_blue, factor_alpha=1.0) -> Image
        
        This function muliplies all 4 channels (red, green, blue, alpha) with
        a factor (around 1.0). Useful for gamma correction, colour correction
        and to add a certain amount of transparency to a image (fade in fade
        out effects). If factor_alpha is given but the original image has no
        alpha channel then a alpha channel will be added.
        """
    Width = property(None, None)
    Height = property(None, None)
    MaskBlue = property(None, None)
    MaskGreen = property(None, None)
    MaskRed = property(None, None)
    Type = property(None, None)
# end of class Image


class ImageHistogram(object):
    """
    ImageHistogram()
    """

    def __init__(self):
        """
        ImageHistogram()
        """

    def FindFirstUnusedColour(self, startR=1, startG=0, startB=0):
        """
        FindFirstUnusedColour(startR=1, startG=0, startB=0) -> (r, g, b)
        """

    @staticmethod
    def MakeKey(r, g, b):
        """
        MakeKey(r, g, b) -> unsignedlong
        """
# end of class ImageHistogram


class ImageHandler(Object):
    """
    ImageHandler()
    
    This is the base class for implementing image file loading/saving, and
    image creation from data.
    """

    def __init__(self):
        """
        ImageHandler()
        
        This is the base class for implementing image file loading/saving, and
        image creation from data.
        """

    def CanRead(self, *args, **kw):
        """
        CanRead(stream) -> bool
        CanRead(filename) -> bool
        
        Returns true if this handler supports the image format contained in
        the given stream.
        """

    def GetExtension(self):
        """
        GetExtension() -> String
        
        Gets the preferred file extension associated with this handler.
        """

    def GetAltExtensions(self):
        """
        GetAltExtensions() -> ArrayString
        
        Returns the other file extensions associated with this handler.
        """

    def GetImageCount(self, stream):
        """
        GetImageCount(stream) -> int
        
        If the image file contains more than one image and the image handler
        is capable of retrieving these individually, this function will return
        the number of available images.
        """

    def GetMimeType(self):
        """
        GetMimeType() -> String
        
        Gets the MIME type associated with this handler.
        """

    def GetName(self):
        """
        GetName() -> String
        
        Gets the name of this handler.
        """

    def GetType(self):
        """
        GetType() -> BitmapType
        
        Gets the image type associated with this handler.
        """

    def LoadFile(self, image, stream, verbose=True, index=-1):
        """
        LoadFile(image, stream, verbose=True, index=-1) -> bool
        
        Loads a image from a stream, putting the resulting data into image.
        """

    def SaveFile(self, image, stream, verbose=True):
        """
        SaveFile(image, stream, verbose=True) -> bool
        
        Saves a image in the output stream.
        """

    def SetExtension(self, extension):
        """
        SetExtension(extension)
        
        Sets the preferred file extension associated with this handler.
        """

    def SetAltExtensions(self, extensions):
        """
        SetAltExtensions(extensions)
        
        Sets the alternative file extensions associated with this handler.
        """

    def SetMimeType(self, mimetype):
        """
        SetMimeType(mimetype)
        
        Sets the handler MIME type.
        """

    def SetName(self, name):
        """
        SetName(name)
        
        Sets the handler name.
        """

    def SetType(self, type):
        """
        SetType(type)
        
        Sets the bitmap type for the handler.
        """
    AltExtensions = property(None, None)
    Extension = property(None, None)
    MimeType = property(None, None)
    Name = property(None, None)
    Type = property(None, None)

    def DoGetImageCount(self, stream):
        """
        DoGetImageCount(stream) -> int
        
        Called to get the number of images available in a multi-image file
        type, if supported.
        """

    def DoCanRead(self, stream):
        """
        DoCanRead(stream) -> bool
        
        Called to test if this handler can read an image from the given
        stream.
        """
# end of class ImageHandler


def InitAllImageHandlers():
    """
    InitAllImageHandlers()
    
    Initializes all available image handlers.
    """
NullImage = Image()

@wx.deprecated
def EmptyImage(width=0, height=0, clear=True):
    """
    A compatibility wrapper for the wx.Image(width, height) constructor
    """
    pass

@wx.deprecated
def ImageFromBitmap(bitmap):
    """
    Create a :class:`Image` from a :class:`wx.Bitmap`
    """
    pass

@wx.deprecated
def ImageFromStream(stream, type=BITMAP_TYPE_ANY, index=-1):
    """
    Load an image from a stream (file-like object)
    """
    pass

@wx.deprecated
def ImageFromData(width, height, data):
    """
    Compatibility wrapper for creating an image from RGB data
    """
    pass

@wx.deprecated
def ImageFromDataWithAlpha(width, height, data, alpha):
    """
    Compatibility wrapper for creating an image from RGB and Alpha data
    """
    pass

def ImageFromBuffer(width, height, dataBuffer, alphaBuffer=None):
    """
    Creates a :class:`Image` from the data in `dataBuffer`.  The `dataBuffer`
    parameter must be a Python object that implements the buffer interface,
    such as a string, array, etc.  The `dataBuffer` object is expected to
    contain a series of RGB bytes and be width*height*3 bytes long.  A buffer
    object can optionally be supplied for the image's alpha channel data, and
    it is expected to be width*height bytes long.
    
    The :class:`Image` will be created with its data and alpha pointers initialized
    to the memory address pointed to by the buffer objects, thus saving the
    time needed to copy the image data from the buffer object to the :class:`Image`.
    While this has advantages, it also has the shoot-yourself-in-the-foot
    risks associated with sharing a C pointer between two objects.
    
    To help alleviate the risk a reference to the data and alpha buffer
    objects are kept with the :class:`Image`, so that they won't get deleted until
    after the wx.Image is deleted.  However please be aware that it is not
    guaranteed that an object won't move its memory buffer to a new location
    when it needs to resize its contents.  If that happens then the :class:`Image`
    will end up referring to an invalid memory location and could cause the
    application to crash.  Therefore care should be taken to not manipulate
    the objects used for the data and alpha buffers in a way that would cause
    them to change size.
    """
    pass

IMAGE_OPTION_QUALITY = "quality"
IMAGE_OPTION_FILENAME = "FileName"
IMAGE_OPTION_RESOLUTION = "Resolution"
IMAGE_OPTION_RESOLUTIONX = "ResolutionX"
IMAGE_OPTION_RESOLUTIONY = "ResolutionY"
IMAGE_OPTION_RESOLUTIONUNIT = "ResolutionUnit"
IMAGE_OPTION_MAX_WIDTH = "MaxWidth"
IMAGE_OPTION_MAX_HEIGHT = "MaxHeight"
IMAGE_OPTION_ORIGINAL_WIDTH = "OriginalWidth"
IMAGE_OPTION_ORIGINAL_HEIGHT = "OriginalHeight"
IMAGE_OPTION_BMP_FORMAT = "wxBMP_FORMAT"
IMAGE_OPTION_CUR_HOTSPOT_X = "HotSpotX"
IMAGE_OPTION_CUR_HOTSPOT_Y = "HotSpotY"
IMAGE_OPTION_GIF_COMMENT = "GifComment"
IMAGE_OPTION_PNG_FORMAT = "PngFormat"
IMAGE_OPTION_PNG_BITDEPTH = "PngBitDepth"
IMAGE_OPTION_PNG_FILTER = "PngF"
IMAGE_OPTION_PNG_COMPRESSION_LEVEL = "PngZL"
IMAGE_OPTION_PNG_COMPRESSION_MEM_LEVEL = "PngZM"
IMAGE_OPTION_PNG_COMPRESSION_STRATEGY = "PngZS"
IMAGE_OPTION_PNG_COMPRESSION_BUFFER_SIZE = "PngZB"
IMAGE_OPTION_TIFF_BITSPERSAMPLE = "BitsPerSample"
IMAGE_OPTION_TIFF_SAMPLESPERPIXEL = "SamplesPerPixel"
IMAGE_OPTION_TIFF_COMPRESSION = "Compression"
IMAGE_OPTION_TIFF_PHOTOMETRIC = "Photometric"
IMAGE_OPTION_TIFF_IMAGEDESCRIPTOR = "ImageDescriptor"
#-- end-image --#
#-- begin-gdiobj --#

class GDIObject(Object):
    """
    GDIObject()
    
    This class allows platforms to implement functionality to optimise GDI
    objects, such as wxPen, wxBrush and wxFont.
    """

    def __init__(self):
        """
        GDIObject()
        
        This class allows platforms to implement functionality to optimise GDI
        objects, such as wxPen, wxBrush and wxFont.
        """
# end of class GDIObject

#-- end-gdiobj --#
#-- begin-bitmap --#
BitmapBufferFormat_RGB = 0
BitmapBufferFormat_RGBA = 0
BitmapBufferFormat_RGB32 = 0
BitmapBufferFormat_ARGB32 = 0
BITMAP_SCREEN_DEPTH = 0

class Bitmap(GDIObject):
    """
    Bitmap()
    Bitmap(bitmap)
    Bitmap(bits, width, height, depth=1)
    Bitmap(width, height, depth=BITMAP_SCREEN_DEPTH)
    Bitmap(sz, depth=BITMAP_SCREEN_DEPTH)
    Bitmap(name, type=BITMAP_TYPE_ANY)
    Bitmap(img, depth=BITMAP_SCREEN_DEPTH)
    Bitmap(listOfBytes)
    
    This class encapsulates the concept of a platform-dependent bitmap,
    either monochrome or colour or colour with alpha channel support.
    """

    def __init__(self, *args, **kw):
        """
        Bitmap()
        Bitmap(bitmap)
        Bitmap(bits, width, height, depth=1)
        Bitmap(width, height, depth=BITMAP_SCREEN_DEPTH)
        Bitmap(sz, depth=BITMAP_SCREEN_DEPTH)
        Bitmap(name, type=BITMAP_TYPE_ANY)
        Bitmap(img, depth=BITMAP_SCREEN_DEPTH)
        Bitmap(listOfBytes)
        
        This class encapsulates the concept of a platform-dependent bitmap,
        either monochrome or colour or colour with alpha channel support.
        """

    def ConvertToImage(self):
        """
        ConvertToImage() -> Image
        
        Creates an image from a platform-dependent bitmap.
        """

    def CopyFromIcon(self, icon):
        """
        CopyFromIcon(icon) -> bool
        
        Creates the bitmap from an icon.
        """

    def Create(self, *args, **kw):
        """
        Create(width, height, depth=BITMAP_SCREEN_DEPTH) -> bool
        Create(sz, depth=BITMAP_SCREEN_DEPTH) -> bool
        
        Creates a fresh bitmap.
        """

    def GetDepth(self):
        """
        GetDepth() -> int
        
        Gets the colour depth of the bitmap.
        """

    def GetHeight(self):
        """
        GetHeight() -> int
        
        Gets the height of the bitmap in pixels.
        """

    def GetMask(self):
        """
        GetMask() -> Mask
        
        Gets the associated mask (if any) which may have been loaded from a
        file or set for the bitmap.
        """

    def GetPalette(self):
        """
        GetPalette() -> Palette
        
        Gets the associated palette (if any) which may have been loaded from a
        file or set for the bitmap.
        """

    def GetSubBitmap(self, rect):
        """
        GetSubBitmap(rect) -> Bitmap
        
        Returns a sub bitmap of the current one as long as the rect belongs
        entirely to the bitmap.
        """

    def GetSize(self):
        """
        GetSize() -> Size
        
        Returns the size of the bitmap in pixels.
        """

    def ConvertToDisabled(self, brightness=255):
        """
        ConvertToDisabled(brightness=255) -> Bitmap
        
        Returns disabled (dimmed) version of the bitmap.
        """

    def GetWidth(self):
        """
        GetWidth() -> int
        
        Gets the width of the bitmap in pixels.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if bitmap data is present.
        """

    def LoadFile(self, name, type=BITMAP_TYPE_ANY):
        """
        LoadFile(name, type=BITMAP_TYPE_ANY) -> bool
        
        Loads a bitmap from a file or resource.
        """

    def SaveFile(self, name, type, palette=None):
        """
        SaveFile(name, type, palette=None) -> bool
        
        Saves a bitmap in the named file.
        """

    def SetDepth(self, depth):
        """
        SetDepth(depth)
        
        Sets the depth member (does not affect the bitmap data).
        """

    def SetHeight(self, height):
        """
        SetHeight(height)
        
        Sets the height member (does not affect the bitmap data).
        """

    def SetMask(self, mask):
        """
        SetMask(mask)
        
        Sets the mask for this bitmap.
        """

    def SetPalette(self, palette):
        """
        SetPalette(palette)
        
        Sets the associated palette.
        """

    def SetWidth(self, width):
        """
        SetWidth(width)
        
        Sets the width member (does not affect the bitmap data).
        """

    @staticmethod
    def NewFromPNGData(data, size):
        """
        NewFromPNGData(data, size) -> Bitmap
        
        Loads a bitmap from the memory containing image data in PNG format.
        """

    def SetMaskColour(self, colour):
        """
        SetMaskColour(colour)
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """

    def GetHandle(self):
        """
        GetHandle() -> long
        
        MSW-only method to fetch the windows handle for the bitmap.
        """

    def SetHandle(self, handle):
        """
        SetHandle(handle)
        
        MSW-only method to set the windows handle for the bitmap.
        """

    def SetSize(self, size):
        """
        SetSize(size)
        
        Set the bitmap size (does not alter the existing native bitmap data or
        image size).
        """

    def CopyFromBuffer(self, data, format=BitmapBufferFormat_RGB, stride=-1):
        """
        CopyFromBuffer(data, format=BitmapBufferFormat_RGB, stride=-1)
        
        Copy data from a buffer object to replace the bitmap pixel data.
        Default format is plain RGB, but other formats are now supported as
        well.  The following symbols are used to specify the format of the
        bytes in the buffer:
        
            =============================  ================================
            wx.BitmapBufferFormat_RGB      A simple sequence of RGB bytes
            wx.BitmapBufferFormat_RGBA     A simple sequence of RGBA bytes
            wx.BitmapBufferFormat_ARGB32   A sequence of 32-bit values in
        native endian order, with alpha in the upper 8 bits, followed by red,
        green, and blue.
            wx.BitmapBufferFormat_RGB32    Same as above but the alpha byte is
        ignored.
            =============================  ================================
        """

    def CopyToBuffer(self, data, format=BitmapBufferFormat_RGB, stride=-1):
        """
        CopyToBuffer(data, format=BitmapBufferFormat_RGB, stride=-1)
        
        Copy pixel data to a buffer object.  See :meth:`CopyFromBuffer` for
        buffer
        format details.
        """

    @staticmethod
    def FromBufferAndAlpha(width, height, data, alpha):
        """
        FromBufferAndAlpha(width, height, data, alpha) -> Bitmap
        
        Creates a :class:`wx.Bitmap` from in-memory data.  The data and alpha
        parameters must be a Python object that implements the buffer
        interface, such as a string, bytearray, etc.  The data object
        is expected to contain a series of RGB bytes and be at least
        width*height*3 bytes long, while the alpha object is expected
        to be width*height bytes long and represents the image's alpha
        channel.  On Windows and Mac the RGB values will be
        'premultiplied' by the alpha values.  (The other platforms do
        the multiplication themselves.)
        
        Unlike :func:`wx.ImageFromBuffer` the bitmap created with this
        function
        does not share the memory block with the buffer object.  This is
        because the native pixel buffer format varies on different
        platforms, and so instead an efficient as possible copy of the
        data is made from the buffer object to the bitmap's native pixel
        buffer.
        """

    @staticmethod
    def FromBuffer(width, height, data):
        """
        FromBuffer(width, height, data) -> Bitmap
        
        Creates a :class:`wx.Bitmap` from in-memory data.  The data parameter
        must be a Python object that implements the buffer interface, such
        as a string, bytearray, etc.  The data object is expected to contain
        a series of RGB bytes and be at least width*height*3 bytes long.
        
        Unlike :func:`wx.ImageFromBuffer` the bitmap created with this
        function
        does not share the memory block with the buffer object.  This is
        because the native pixel buffer format varies on different
        platforms, and so instead an efficient as possible copy of the
        data is made from the buffer object to the bitmap's native pixel
        buffer.
        """

    @staticmethod
    def FromBufferRGBA(width, height, data):
        """
        FromBufferRGBA(width, height, data) -> Bitmap
        
        Creates a :class:`wx.Bitmap` from in-memory data.  The data parameter
        must be a Python object that implements the buffer interface, such
        as a string, bytearray, etc.  The data object is expected to contain
        a series of RGBA bytes and be at least width*height*4 bytes long.
        On Windows and Mac the RGB values will be 'premultiplied' by the
        alpha values.  (The other platforms do the multiplication themselves.)
        
        Unlike :func:`wx.ImageFromBuffer` the bitmap created with this
        function
        does not share the memory block with the buffer object.  This is
        because the native pixel buffer format varies on different
        platforms, and so instead an efficient as possible copy of the
        data is made from the buffer object to the bitmap's native pixel
        buffer.
        """

    @staticmethod
    def FromRGBA(width, height, red=0, green=0, blue=0, alpha=0):
        """
        FromRGBA(width, height, red=0, green=0, blue=0, alpha=0) -> Bitmap
        
        Creates a new empty 32-bit :class:`wx.Bitmap` where every pixel has
        been
        initialized with the given RGBA values.
        """
    Depth = property(None, None)
    Handle = property(None, None)
    Height = property(None, None)
    Mask = property(None, None)
    Palette = property(None, None)
    Size = property(None, None)
    Width = property(None, None)
# end of class Bitmap


class Mask(Object):
    """
    Mask()
    Mask(bitmap, index)
    Mask(bitmap)
    Mask(bitmap, colour)
    
    This class encapsulates a monochrome mask bitmap, where the masked
    area is black and the unmasked area is white.
    """

    def __init__(self, *args, **kw):
        """
        Mask()
        Mask(bitmap, index)
        Mask(bitmap)
        Mask(bitmap, colour)
        
        This class encapsulates a monochrome mask bitmap, where the masked
        area is black and the unmasked area is white.
        """

    def Create(self, *args, **kw):
        """
        Create(bitmap, index) -> bool
        Create(bitmap) -> bool
        Create(bitmap, colour) -> bool
        
        Constructs a mask from a bitmap and a palette index that indicates the
        background.
        """

    def GetBitmap(self):
        """
        GetBitmap() -> Bitmap
        
        Returns the mask as a monochrome bitmap.
        """
    Bitmap = property(None, None)
# end of class Mask

NullBitmap = Bitmap()

@wx.deprecated
def BitmapFromBuffer(width, height, dataBuffer, alphaBuffer=None):
    """
    A compatibility wrapper for :meth:`wx.Bitmap.FromBuffer` and :meth:`wx.Bitmap.FromBufferAndAlpha`
    """
    pass

@wx.deprecated
def BitmapFromBufferRGBA(width, height, dataBuffer):
    """
    A compatibility wrapper for :meth:`wx.Bitmap.FromBufferRGBA`
    """
    pass

@wx.deprecated
def EmptyBitmapRGBA(width, height, red=0, green=0, blue=0, alpha=0):
    """
    A compatibility wrapper for :meth:`wx.Bitmap.FromRGBA`
    """
    pass

@wx.deprecated
def EmptyBitmap(width, height, depth=BITMAP_SCREEN_DEPTH):
    """
    A compatibility wrapper for the wx.Bitmap(width, height, depth) constructor
    """
    pass

@wx.deprecated
def BitmapFromImage(image):
    """
    A compatibility wrapper for the wx.Bitmap(wx.Image) constructor
    """
    pass
#-- end-bitmap --#
#-- begin-icon --#
ICON_SCREEN_DEPTH = 0

class Icon(GDIObject):
    """
    Icon()
    Icon(icon)
    Icon(name, type=BITMAP_TYPE_ANY, desiredWidth=-1, desiredHeight=-1)
    Icon(loc)
    Icon(bmp)
    
    An icon is a small rectangular bitmap usually used for denoting a
    minimized application.
    """

    def __init__(self, *args, **kw):
        """
        Icon()
        Icon(icon)
        Icon(name, type=BITMAP_TYPE_ANY, desiredWidth=-1, desiredHeight=-1)
        Icon(loc)
        Icon(bmp)
        
        An icon is a small rectangular bitmap usually used for denoting a
        minimized application.
        """

    def CreateFromHICON(self, hicon):
        """
        CreateFromHICON(hicon) -> bool
        
        MSW-only method to create a wx.Icon from a native icon handle.
        """

    def CopyFromBitmap(self, bmp):
        """
        CopyFromBitmap(bmp)
        
        Copies bmp bitmap to this icon.
        """

    def GetDepth(self):
        """
        GetDepth() -> int
        
        Gets the colour depth of the icon.
        """

    def GetHeight(self):
        """
        GetHeight() -> int
        
        Gets the height of the icon in pixels.
        """

    def GetWidth(self):
        """
        GetWidth() -> int
        
        Gets the width of the icon in pixels.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if icon data is present.
        """

    def LoadFile(self, name, type=BITMAP_TYPE_ANY, desiredWidth=-1, desiredHeight=-1):
        """
        LoadFile(name, type=BITMAP_TYPE_ANY, desiredWidth=-1, desiredHeight=-1) -> bool
        
        Loads an icon from a file or resource.
        """

    def SetDepth(self, depth):
        """
        SetDepth(depth)
        
        Sets the depth member (does not affect the icon data).
        """

    def SetHeight(self, height):
        """
        SetHeight(height)
        
        Sets the height member (does not affect the icon data).
        """

    def SetWidth(self, width):
        """
        SetWidth(width)
        
        Sets the width member (does not affect the icon data).
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """

    def GetHandle(self):
        """
        GetHandle() -> long
        """

    def SetHandle(self, handle):
        """
        SetHandle(handle)
        """
    Depth = property(None, None)
    Handle = property(None, None)
    Height = property(None, None)
    Width = property(None, None)
# end of class Icon

NullIcon = Icon()

@wx.deprecated
def EmptyIcon():
    """
    A compatibility wrapper for the :class:`Icon` constructor
    """
    pass
#-- end-icon --#
#-- begin-iconloc --#

class IconLocation(object):
    """
    IconLocation()
    IconLocation(filename, num=0)
    
    wxIconLocation is a tiny class describing the location of an
    (external, i.e.
    """

    def __init__(self, *args, **kw):
        """
        IconLocation()
        IconLocation(filename, num=0)
        
        wxIconLocation is a tiny class describing the location of an
        (external, i.e.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if the object is valid, i.e. was properly initialized,
        and false otherwise.
        """

    def SetFileName(self, filename):
        """
        SetFileName(filename)
        """

    def GetFileName(self):
        """
        GetFileName() -> String
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """

    def GetIndex(self):
        """
        GetIndex() -> int
        """

    def SetIndex(self, num):
        """
        SetIndex(num)
        """
    FileName = property(None, None)
    Index = property(None, None)
# end of class IconLocation

#-- end-iconloc --#
#-- begin-iconbndl --#

class IconBundle(GDIObject):
    """
    IconBundle()
    IconBundle(file, type=BITMAP_TYPE_ANY)
    IconBundle(stream, type=BITMAP_TYPE_ANY)
    IconBundle(icon)
    IconBundle(ic)
    
    This class contains multiple copies of an icon in different sizes.
    """
    FALLBACK_NONE = 0
    FALLBACK_SYSTEM = 0
    FALLBACK_NEAREST_LARGER = 0

    def __init__(self, *args, **kw):
        """
        IconBundle()
        IconBundle(file, type=BITMAP_TYPE_ANY)
        IconBundle(stream, type=BITMAP_TYPE_ANY)
        IconBundle(icon)
        IconBundle(ic)
        
        This class contains multiple copies of an icon in different sizes.
        """

    def AddIcon(self, *args, **kw):
        """
        AddIcon(file, type=BITMAP_TYPE_ANY)
        AddIcon(stream, type=BITMAP_TYPE_ANY)
        AddIcon(icon)
        
        Adds all the icons contained in the file to the bundle; if the
        collection already contains icons with the same width and height, they
        are replaced by the new ones.
        """

    def GetIcon(self, *args, **kw):
        """
        GetIcon(size, flags=FALLBACK_SYSTEM) -> Icon
        GetIcon(size=DefaultCoord, flags=FALLBACK_SYSTEM) -> Icon
        
        Returns the icon with the given size.
        """

    def GetIconOfExactSize(self, size):
        """
        GetIconOfExactSize(size) -> Icon
        
        Returns the icon with exactly the given size or wxNullIcon if this
        size is not available.
        """

    def GetIconCount(self):
        """
        GetIconCount() -> size_t
        
        return the number of available icons
        """

    def GetIconByIndex(self, n):
        """
        GetIconByIndex(n) -> Icon
        
        return the icon at index (must be < GetIconCount())
        """

    def IsEmpty(self):
        """
        IsEmpty() -> bool
        
        Returns true if the bundle doesn't contain any icons, false otherwise
        (in which case a call to GetIcon() with default parameter should
        return a valid icon).
        """
    Icon = property(None, None)
    IconCount = property(None, None)
# end of class IconBundle

NullIconBundle = IconBundle()
#-- end-iconbndl --#
#-- begin-font --#
FONTFAMILY_DEFAULT = 0
FONTFAMILY_DECORATIVE = 0
FONTFAMILY_ROMAN = 0
FONTFAMILY_SCRIPT = 0
FONTFAMILY_SWISS = 0
FONTFAMILY_MODERN = 0
FONTFAMILY_TELETYPE = 0
FONTFAMILY_MAX = 0
FONTFAMILY_UNKNOWN = 0
FONTSTYLE_NORMAL = 0
FONTSTYLE_ITALIC = 0
FONTSTYLE_SLANT = 0
FONTSTYLE_MAX = 0
FONTWEIGHT_NORMAL = 0
FONTWEIGHT_LIGHT = 0
FONTWEIGHT_BOLD = 0
FONTWEIGHT_MAX = 0
FONTSIZE_XX_SMALL = 0
FONTSIZE_X_SMALL = 0
FONTSIZE_SMALL = 0
FONTSIZE_MEDIUM = 0
FONTSIZE_LARGE = 0
FONTSIZE_X_LARGE = 0
FONTSIZE_XX_LARGE = 0
FONTFLAG_DEFAULT = 0
FONTFLAG_ITALIC = 0
FONTFLAG_SLANT = 0
FONTFLAG_LIGHT = 0
FONTFLAG_BOLD = 0
FONTFLAG_ANTIALIASED = 0
FONTFLAG_NOT_ANTIALIASED = 0
FONTFLAG_UNDERLINED = 0
FONTFLAG_STRIKETHROUGH = 0
FONTFLAG_MASK = 0
FONTENCODING_SYSTEM = 0
FONTENCODING_DEFAULT = 0
FONTENCODING_ISO8859_1 = 0
FONTENCODING_ISO8859_2 = 0
FONTENCODING_ISO8859_3 = 0
FONTENCODING_ISO8859_4 = 0
FONTENCODING_ISO8859_5 = 0
FONTENCODING_ISO8859_6 = 0
FONTENCODING_ISO8859_7 = 0
FONTENCODING_ISO8859_8 = 0
FONTENCODING_ISO8859_9 = 0
FONTENCODING_ISO8859_10 = 0
FONTENCODING_ISO8859_11 = 0
FONTENCODING_ISO8859_12 = 0
FONTENCODING_ISO8859_13 = 0
FONTENCODING_ISO8859_14 = 0
FONTENCODING_ISO8859_15 = 0
FONTENCODING_ISO8859_MAX = 0
FONTENCODING_KOI8 = 0
FONTENCODING_KOI8_U = 0
FONTENCODING_ALTERNATIVE = 0
FONTENCODING_BULGARIAN = 0
FONTENCODING_CP437 = 0
FONTENCODING_CP850 = 0
FONTENCODING_CP852 = 0
FONTENCODING_CP855 = 0
FONTENCODING_CP866 = 0
FONTENCODING_CP874 = 0
FONTENCODING_CP932 = 0
FONTENCODING_CP936 = 0
FONTENCODING_CP949 = 0
FONTENCODING_CP950 = 0
FONTENCODING_CP1250 = 0
FONTENCODING_CP1251 = 0
FONTENCODING_CP1252 = 0
FONTENCODING_CP1253 = 0
FONTENCODING_CP1254 = 0
FONTENCODING_CP1255 = 0
FONTENCODING_CP1256 = 0
FONTENCODING_CP1257 = 0
FONTENCODING_CP1258 = 0
FONTENCODING_CP1361 = 0
FONTENCODING_CP12_MAX = 0
FONTENCODING_UTF7 = 0
FONTENCODING_UTF8 = 0
FONTENCODING_EUC_JP = 0
FONTENCODING_UTF16BE = 0
FONTENCODING_UTF16LE = 0
FONTENCODING_UTF32BE = 0
FONTENCODING_UTF32LE = 0
FONTENCODING_MACROMAN = 0
FONTENCODING_MACJAPANESE = 0
FONTENCODING_MACCHINESETRAD = 0
FONTENCODING_MACKOREAN = 0
FONTENCODING_MACARABIC = 0
FONTENCODING_MACHEBREW = 0
FONTENCODING_MACGREEK = 0
FONTENCODING_MACCYRILLIC = 0
FONTENCODING_MACDEVANAGARI = 0
FONTENCODING_MACGURMUKHI = 0
FONTENCODING_MACGUJARATI = 0
FONTENCODING_MACORIYA = 0
FONTENCODING_MACBENGALI = 0
FONTENCODING_MACTAMIL = 0
FONTENCODING_MACTELUGU = 0
FONTENCODING_MACKANNADA = 0
FONTENCODING_MACMALAJALAM = 0
FONTENCODING_MACSINHALESE = 0
FONTENCODING_MACBURMESE = 0
FONTENCODING_MACKHMER = 0
FONTENCODING_MACTHAI = 0
FONTENCODING_MACLAOTIAN = 0
FONTENCODING_MACGEORGIAN = 0
FONTENCODING_MACARMENIAN = 0
FONTENCODING_MACCHINESESIMP = 0
FONTENCODING_MACTIBETAN = 0
FONTENCODING_MACMONGOLIAN = 0
FONTENCODING_MACETHIOPIC = 0
FONTENCODING_MACCENTRALEUR = 0
FONTENCODING_MACVIATNAMESE = 0
FONTENCODING_MACARABICEXT = 0
FONTENCODING_MACSYMBOL = 0
FONTENCODING_MACDINGBATS = 0
FONTENCODING_MACTURKISH = 0
FONTENCODING_MACCROATIAN = 0
FONTENCODING_MACICELANDIC = 0
FONTENCODING_MACROMANIAN = 0
FONTENCODING_MACCELTIC = 0
FONTENCODING_MACGAELIC = 0
FONTENCODING_MACKEYBOARD = 0
FONTENCODING_ISO2022_JP = 0
FONTENCODING_MAX = 0
FONTENCODING_MACMIN = 0
FONTENCODING_MACMAX = 0
FONTENCODING_UTF16 = 0
FONTENCODING_UTF32 = 0
FONTENCODING_UNICODE = 0
FONTENCODING_GB2312 = 0
FONTENCODING_BIG5 = 0
FONTENCODING_SHIFT_JIS = 0
FONTENCODING_EUC_KR = 0
FONTENCODING_JOHAB = 0
FONTENCODING_VIETNAMESE = 0

class FontInfo(object):
    """
    FontInfo()
    FontInfo(pointSize)
    FontInfo(pixelSize)
    
    This class is a helper used for wxFont creation using named parameter
    idiom: it allows to specify various wxFont attributes using the
    chained calls to its clearly named methods instead of passing them in
    the fixed order to wxFont constructors.
    """

    def __init__(self, *args, **kw):
        """
        FontInfo()
        FontInfo(pointSize)
        FontInfo(pixelSize)
        
        This class is a helper used for wxFont creation using named parameter
        idiom: it allows to specify various wxFont attributes using the
        chained calls to its clearly named methods instead of passing them in
        the fixed order to wxFont constructors.
        """

    def Family(self, family):
        """
        Family(family) -> FontInfo
        
        Set the font family.
        """

    def FaceName(self, faceName):
        """
        FaceName(faceName) -> FontInfo
        
        Set the font face name to use.
        """

    def Bold(self, bold=True):
        """
        Bold(bold=True) -> FontInfo
        
        Use a bold version of the font.
        """

    def Light(self, light=True):
        """
        Light(light=True) -> FontInfo
        
        Use a lighter version of the font.
        """

    def Italic(self, italic=True):
        """
        Italic(italic=True) -> FontInfo
        
        Use an italic version of the font.
        """

    def Slant(self, slant=True):
        """
        Slant(slant=True) -> FontInfo
        
        Use a slanted version of the font.
        """

    def AntiAliased(self, antiAliased=True):
        """
        AntiAliased(antiAliased=True) -> FontInfo
        
        Set anti-aliasing flag.
        """

    def Underlined(self, underlined=True):
        """
        Underlined(underlined=True) -> FontInfo
        
        Use an underlined version of the font.
        """

    def Strikethrough(self, strikethrough=True):
        """
        Strikethrough(strikethrough=True) -> FontInfo
        
        Use a strike-through version of the font.
        """

    def Encoding(self, encoding):
        """
        Encoding(encoding) -> FontInfo
        
        Set the font encoding to use.
        """

    def AllFlags(self, flags):
        """
        AllFlags(flags) -> FontInfo
        
        Set all the font attributes at once.
        """
# end of class FontInfo


class Font(GDIObject):
    """
    Font()
    Font(font)
    Font(fontInfo)
    Font(pointSize, family, style, weight, underline=False, faceName=EmptyString, encoding=FONTENCODING_DEFAULT)
    Font(pixelSize, family, style, weight, underline=False, faceName=EmptyString, encoding=FONTENCODING_DEFAULT)
    Font(nativeInfoString)
    Font(nativeInfo)
    
    A font is an object which determines the appearance of text.
    """

    def __init__(self, *args, **kw):
        """
        Font()
        Font(font)
        Font(fontInfo)
        Font(pointSize, family, style, weight, underline=False, faceName=EmptyString, encoding=FONTENCODING_DEFAULT)
        Font(pixelSize, family, style, weight, underline=False, faceName=EmptyString, encoding=FONTENCODING_DEFAULT)
        Font(nativeInfoString)
        Font(nativeInfo)
        
        A font is an object which determines the appearance of text.
        """

    def GetEncoding(self):
        """
        GetEncoding() -> FontEncoding
        
        Returns the encoding of this font.
        """

    def GetFaceName(self):
        """
        GetFaceName() -> String
        
        Returns the face name associated with the font, or the empty string if
        there is no face information.
        """

    def GetFamily(self):
        """
        GetFamily() -> FontFamily
        
        Gets the font family if possible.
        """

    def GetNativeFontInfoDesc(self):
        """
        GetNativeFontInfoDesc() -> String
        
        Returns the platform-dependent string completely describing this font.
        """

    def GetNativeFontInfoUserDesc(self):
        """
        GetNativeFontInfoUserDesc() -> String
        
        Returns a user-friendly string for this font object.
        """

    def GetNativeFontInfo(self):
        """
        GetNativeFontInfo() -> NativeFontInfo
        
        Returns the encoding of this font.
        """

    def GetPointSize(self):
        """
        GetPointSize() -> int
        
        Gets the point size.
        """

    def GetPixelSize(self):
        """
        GetPixelSize() -> Size
        
        Gets the pixel size.
        """

    def GetStyle(self):
        """
        GetStyle() -> FontStyle
        
        Gets the font style.
        """

    def GetUnderlined(self):
        """
        GetUnderlined() -> bool
        
        Returns true if the font is underlined, false otherwise.
        """

    def GetStrikethrough(self):
        """
        GetStrikethrough() -> bool
        
        Returns true if the font is stricken-through, false otherwise.
        """

    def GetWeight(self):
        """
        GetWeight() -> FontWeight
        
        Gets the font weight.
        """

    def IsFixedWidth(self):
        """
        IsFixedWidth() -> bool
        
        Returns true if the font is a fixed width (or monospaced) font, false
        if it is a proportional one or font is invalid.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if this object is a valid font, false otherwise.
        """

    def Bold(self):
        """
        Bold() -> Font
        
        Returns a bold version of this font.
        """

    def Italic(self):
        """
        Italic() -> Font
        
        Returns an italic version of this font.
        """

    def Larger(self):
        """
        Larger() -> Font
        
        Returns a larger version of this font.
        """

    def Smaller(self):
        """
        Smaller() -> Font
        
        Returns a smaller version of this font.
        """

    def Underlined(self):
        """
        Underlined() -> Font
        
        Returns underlined version of this font.
        """

    def Strikethrough(self):
        """
        Strikethrough() -> Font
        
        Returns stricken-through version of this font.
        """

    def MakeBold(self):
        """
        MakeBold() -> Font
        
        Changes this font to be bold.
        """

    def MakeItalic(self):
        """
        MakeItalic() -> Font
        
        Changes this font to be italic.
        """

    def MakeLarger(self):
        """
        MakeLarger() -> Font
        
        Changes this font to be larger.
        """

    def MakeSmaller(self):
        """
        MakeSmaller() -> Font
        
        Changes this font to be smaller.
        """

    def MakeUnderlined(self):
        """
        MakeUnderlined() -> Font
        
        Changes this font to be underlined.
        """

    def MakeStrikethrough(self):
        """
        MakeStrikethrough() -> Font
        
        Changes this font to be stricken-through.
        """

    def Scale(self, x):
        """
        Scale(x) -> Font
        
        Changes the size of this font.
        """

    def Scaled(self, x):
        """
        Scaled(x) -> Font
        
        Returns a scaled version of this font.
        """

    def SetEncoding(self, encoding):
        """
        SetEncoding(encoding)
        
        Sets the encoding for this font.
        """

    def SetFaceName(self, faceName):
        """
        SetFaceName(faceName) -> bool
        
        Sets the facename for the font.
        """

    def SetFamily(self, family):
        """
        SetFamily(family)
        
        Sets the font family.
        """

    def SetNativeFontInfo(self, *args, **kw):
        """
        SetNativeFontInfo(info) -> bool
        SetNativeFontInfo(info)
        
        Creates the font corresponding to the given native font description
        string which must have been previously returned by
        GetNativeFontInfoDesc().
        """

    def SetNativeFontInfoUserDesc(self, info):
        """
        SetNativeFontInfoUserDesc(info) -> bool
        
        Creates the font corresponding to the given native font description
        string and returns true if the creation was successful.
        """

    def SetPointSize(self, pointSize):
        """
        SetPointSize(pointSize)
        
        Sets the point size.
        """

    def SetPixelSize(self, pixelSize):
        """
        SetPixelSize(pixelSize)
        
        Sets the pixel size.
        """

    def SetStyle(self, style):
        """
        SetStyle(style)
        
        Sets the font style.
        """

    def SetSymbolicSize(self, size):
        """
        SetSymbolicSize(size)
        
        Sets the font size using a predefined symbolic size name.
        """

    def SetSymbolicSizeRelativeTo(self, size, base):
        """
        SetSymbolicSizeRelativeTo(size, base)
        
        Sets the font size compared to the base font size.
        """

    def SetUnderlined(self, underlined):
        """
        SetUnderlined(underlined)
        
        Sets underlining.
        """

    def SetStrikethrough(self, strikethrough):
        """
        SetStrikethrough(strikethrough)
        
        Sets strike-through attribute of the font.
        """

    def SetWeight(self, weight):
        """
        SetWeight(weight)
        
        Sets the font weight.
        """

    @staticmethod
    def New(*args, **kw):
        """
        New(pointSize, family, style, weight, underline=False, faceName=EmptyString, encoding=FONTENCODING_DEFAULT) -> Font
        New(pointSize, family, flags=FONTFLAG_DEFAULT, faceName=EmptyString, encoding=FONTENCODING_DEFAULT) -> Font
        New(pixelSize, family, style, weight, underline=False, faceName=EmptyString, encoding=FONTENCODING_DEFAULT) -> Font
        New(pixelSize, family, flags=FONTFLAG_DEFAULT, faceName=EmptyString, encoding=FONTENCODING_DEFAULT) -> Font
        New(nativeInfo) -> Font
        New(nativeInfoString) -> Font
        
        This function takes the same parameters as the relative wxFont
        constructor and returns a new font object allocated on the heap.
        """

    def __ne__(self):
        """
        """

    def __eq__(self):
        """
        """

    @staticmethod
    def GetDefaultEncoding():
        """
        GetDefaultEncoding() -> FontEncoding
        
        Returns the current application's default encoding.
        """

    @staticmethod
    def SetDefaultEncoding(encoding):
        """
        SetDefaultEncoding(encoding)
        
        Sets the default font encoding.
        """
    Encoding = property(None, None)
    FaceName = property(None, None)
    Family = property(None, None)
    NativeFontInfoDesc = property(None, None)
    NativeFontInfoUserDesc = property(None, None)
    PointSize = property(None, None)
    PixelSize = property(None, None)
    Style = property(None, None)
    Weight = property(None, None)

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """

    def GetHFONT(self):
        """
        GetHFONT() -> void
        
        Returns the font's native handle.
        """

    def OSXGetCGFont(self):
        """
        OSXGetCGFont() -> void
        
        Returns the font's native handle.
        """

    def GetPangoFontDescription(self):
        """
        GetPangoFontDescription() -> void
        
        Returns the font's native handle.
        """

    def _copyFrom(self, other):
        """
        _copyFrom(other)
        
        For internal use only.
        """

    def SetNoAntiAliasing(self, no=True):
        """
        
        """

    def GetNoAntiAliasing(self):
        """
        
        """
# end of class Font


class FontList(object):
    """
    FontList()
    
    A font list is a list containing all fonts which have been created.
    """

    def __init__(self):
        """
        FontList()
        
        A font list is a list containing all fonts which have been created.
        """

    def FindOrCreateFont(self, point_size, family, style, weight, underline=False, facename=EmptyString, encoding=FONTENCODING_DEFAULT):
        """
        FindOrCreateFont(point_size, family, style, weight, underline=False, facename=EmptyString, encoding=FONTENCODING_DEFAULT) -> Font
        
        Finds a font of the given specification, or creates one and adds it to
        the list.
        """
# end of class FontList

NullFont = Font()

def FFont(self, pointSize, family, flags=FONTFLAG_DEFAULT, faceName=EmptyString, encoding=FONTENCODING_DEFAULT):
    """
    FFont(pointSize, family, flags=FONTFLAG_DEFAULT, faceName=EmptyString, encoding=FONTENCODING_DEFAULT)
    """

# These stock fonts will be initialized when the wx.App object is created.
NORMAL_FONT = Font()
SMALL_FONT = Font()
ITALIC_FONT = Font()
SWISS_FONT = Font()

wx.DEFAULT    = int(wx.FONTFAMILY_DEFAULT)
wx.DECORATIVE = int(wx.FONTFAMILY_DECORATIVE)
wx.ROMAN      = int(wx.FONTFAMILY_ROMAN)
wx.SCRIPT     = int(wx.FONTFAMILY_SCRIPT)
wx.SWISS      = int(wx.FONTFAMILY_SWISS)
wx.MODERN     = int(wx.FONTFAMILY_MODERN)
wx.TELETYPE   = int(wx.FONTFAMILY_TELETYPE)

wx.NORMAL = int(wx.FONTWEIGHT_NORMAL)
wx.LIGHT  = int(wx.FONTWEIGHT_LIGHT)
wx.BOLD   = int(wx.FONTWEIGHT_BOLD)

wx.NORMAL = int(wx.FONTSTYLE_NORMAL)
wx.ITALIC = int(wx.FONTSTYLE_ITALIC)
wx.SLANT  = int(wx.FONTSTYLE_SLANT)
#-- end-font --#
#-- begin-fontutil --#

class NativeFontInfo(object):
    """
    NativeFontInfo()
    NativeFontInfo(info)
    
    wxNativeFontInfo is platform-specific font representation: this class
    should be considered as an opaque font description only used by the
    native functions, the user code can only get the objects of this type
    from somewhere and pass it somewhere else (possibly save them
    somewhere using ToString() and restore them using FromString())
    """

    def __init__(self, *args, **kw):
        """
        NativeFontInfo()
        NativeFontInfo(info)
        
        wxNativeFontInfo is platform-specific font representation: this class
        should be considered as an opaque font description only used by the
        native functions, the user code can only get the objects of this type
        from somewhere and pass it somewhere else (possibly save them
        somewhere using ToString() and restore them using FromString())
        """

    def Init(self):
        """
        Init()
        """

    def InitFromFont(self, font):
        """
        InitFromFont(font)
        """

    def GetPointSize(self):
        """
        GetPointSize() -> int
        """

    def GetStyle(self):
        """
        GetStyle() -> FontStyle
        """

    def GetWeight(self):
        """
        GetWeight() -> FontWeight
        """

    def GetUnderlined(self):
        """
        GetUnderlined() -> bool
        """

    def GetFaceName(self):
        """
        GetFaceName() -> String
        """

    def GetFamily(self):
        """
        GetFamily() -> FontFamily
        """

    def GetEncoding(self):
        """
        GetEncoding() -> FontEncoding
        """

    def SetPointSize(self, pointsize):
        """
        SetPointSize(pointsize)
        """

    def SetStyle(self, style):
        """
        SetStyle(style)
        """

    def SetWeight(self, weight):
        """
        SetWeight(weight)
        """

    def SetUnderlined(self, underlined):
        """
        SetUnderlined(underlined)
        """

    def SetFaceName(self, *args, **kw):
        """
        SetFaceName(facename) -> bool
        SetFaceName(facenames)
        """

    def SetFamily(self, family):
        """
        SetFamily(family)
        """

    def SetEncoding(self, encoding):
        """
        SetEncoding(encoding)
        """

    def FromString(self, s):
        """
        FromString(s) -> bool
        """

    def ToString(self):
        """
        ToString() -> String
        """

    def FromUserString(self, s):
        """
        FromUserString(s) -> bool
        """

    def ToUserString(self):
        """
        ToUserString() -> String
        """

    def __str__(self):
        """
        __str__() -> String
        """
    Encoding = property(None, None)
    FaceName = property(None, None)
    Family = property(None, None)
    PointSize = property(None, None)
    Style = property(None, None)
    Underlined = property(None, None)
    Weight = property(None, None)
# end of class NativeFontInfo

#-- end-fontutil --#
#-- begin-pen --#
PENSTYLE_INVALID = 0
PENSTYLE_SOLID = 0
PENSTYLE_DOT = 0
PENSTYLE_LONG_DASH = 0
PENSTYLE_SHORT_DASH = 0
PENSTYLE_DOT_DASH = 0
PENSTYLE_USER_DASH = 0
PENSTYLE_TRANSPARENT = 0
PENSTYLE_STIPPLE_MASK_OPAQUE = 0
PENSTYLE_STIPPLE_MASK = 0
PENSTYLE_STIPPLE = 0
PENSTYLE_BDIAGONAL_HATCH = 0
PENSTYLE_CROSSDIAG_HATCH = 0
PENSTYLE_FDIAGONAL_HATCH = 0
PENSTYLE_CROSS_HATCH = 0
PENSTYLE_HORIZONTAL_HATCH = 0
PENSTYLE_VERTICAL_HATCH = 0
PENSTYLE_FIRST_HATCH = 0
PENSTYLE_LAST_HATCH = 0
JOIN_INVALID = 0
JOIN_BEVEL = 0
JOIN_MITER = 0
JOIN_ROUND = 0
CAP_INVALID = 0
CAP_ROUND = 0
CAP_PROJECTING = 0
CAP_BUTT = 0

class Pen(GDIObject):
    """
    Pen()
    Pen(colour, width=1, style=PENSTYLE_SOLID)
    Pen(pen)
    
    A pen is a drawing tool for drawing outlines.
    """

    def __init__(self, *args, **kw):
        """
        Pen()
        Pen(colour, width=1, style=PENSTYLE_SOLID)
        Pen(pen)
        
        A pen is a drawing tool for drawing outlines.
        """

    def SetColour(self, *args, **kw):
        """
        SetColour(colour)
        SetColour(red, green, blue)
        
        The pen's colour is changed to the given colour.
        """

    def GetCap(self):
        """
        GetCap() -> PenCap
        
        Returns the pen cap style, which may be one of wxCAP_ROUND,
        wxCAP_PROJECTING and wxCAP_BUTT.
        """

    def GetColour(self):
        """
        GetColour() -> Colour
        
        Returns a reference to the pen colour.
        """

    def GetDashes(self):
        """
        GetDashes() -> ArrayInt
        
        Gets an array of dashes (defined as char in X, DWORD under Windows).
        """

    def GetJoin(self):
        """
        GetJoin() -> PenJoin
        
        Returns the pen join style, which may be one of wxJOIN_BEVEL,
        wxJOIN_ROUND and wxJOIN_MITER.
        """

    def GetStipple(self):
        """
        GetStipple() -> Bitmap
        
        Gets a pointer to the stipple bitmap.
        """

    def GetStyle(self):
        """
        GetStyle() -> PenStyle
        
        Returns the pen style.
        """

    def GetWidth(self):
        """
        GetWidth() -> int
        
        Returns the pen width.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if the pen is initialised.
        """

    def IsNonTransparent(self):
        """
        IsNonTransparent() -> bool
        
        Returns true if the pen is a valid non-transparent pen.
        """

    def IsTransparent(self):
        """
        IsTransparent() -> bool
        
        Returns true if the pen is transparent.
        """

    def SetCap(self, capStyle):
        """
        SetCap(capStyle)
        
        Sets the pen cap style, which may be one of wxCAP_ROUND,
        wxCAP_PROJECTING and wxCAP_BUTT.
        """

    def SetDashes(self, dashes):
        """
        SetDashes(dashes)
        
        Associates an array of dash values (defined as char in X, DWORD under
        Windows) with the pen.
        """

    def SetJoin(self, join_style):
        """
        SetJoin(join_style)
        
        Sets the pen join style, which may be one of wxJOIN_BEVEL,
        wxJOIN_ROUND and wxJOIN_MITER.
        """

    def SetStipple(self, stipple):
        """
        SetStipple(stipple)
        
        Sets the bitmap for stippling.
        """

    def SetStyle(self, style):
        """
        SetStyle(style)
        
        Set the pen style.
        """

    def SetWidth(self, width):
        """
        SetWidth(width)
        
        Sets the pen width.
        """

    def __ne__(self):
        """
        """

    def __eq__(self):
        """
        """
    Cap = property(None, None)
    Colour = property(None, None)
    Dashes = property(None, None)
    Join = property(None, None)
    Stipple = property(None, None)
    Style = property(None, None)
    Width = property(None, None)

    def _copyFrom(self, other):
        """
        _copyFrom(other)
        
        For internal use only.
        """
# end of class Pen


class PenList(object):
    """
    PenList()
    
    There is only one instance of this class: wxThePenList.
    """

    def __init__(self):
        """
        PenList()
        
        There is only one instance of this class: wxThePenList.
        """

    def FindOrCreatePen(self, colour, width=1, style=PENSTYLE_SOLID):
        """
        FindOrCreatePen(colour, width=1, style=PENSTYLE_SOLID) -> Pen
        
        Finds a pen with the specified attributes and returns it, else creates
        a new pen, adds it to the pen list, and returns it.
        """
# end of class PenList

NullPen = Pen()

# These stock pens will be initialized when the wx.App object is created.
RED_PEN = Pen()
BLUE_PEN = Pen()
CYAN_PEN = Pen()
GREEN_PEN = Pen()
YELLOW_PEN = Pen()
BLACK_PEN = Pen()
WHITE_PEN = Pen()
TRANSPARENT_PEN = Pen()
BLACK_DASHED_PEN = Pen()
GREY_PEN = Pen()
MEDIUM_GREY_PEN = Pen()
LIGHT_GREY_PEN = Pen()

wx.SOLID       = int(wx.PENSTYLE_SOLID)
wx.DOT         = int(wx.PENSTYLE_DOT)
wx.LONG_DASH   = int(wx.PENSTYLE_LONG_DASH)
wx.SHORT_DASH  = int(wx.PENSTYLE_SHORT_DASH)
wx.DOT_DASH    = int(wx.PENSTYLE_DOT_DASH)
wx.USER_DASH   = int(wx.PENSTYLE_USER_DASH)
wx.TRANSPARENT = int(wx.PENSTYLE_TRANSPARENT)
#-- end-pen --#
#-- begin-brush --#
BRUSHSTYLE_INVALID = 0
BRUSHSTYLE_SOLID = 0
BRUSHSTYLE_TRANSPARENT = 0
BRUSHSTYLE_STIPPLE_MASK_OPAQUE = 0
BRUSHSTYLE_STIPPLE_MASK = 0
BRUSHSTYLE_STIPPLE = 0
BRUSHSTYLE_BDIAGONAL_HATCH = 0
BRUSHSTYLE_CROSSDIAG_HATCH = 0
BRUSHSTYLE_FDIAGONAL_HATCH = 0
BRUSHSTYLE_CROSS_HATCH = 0
BRUSHSTYLE_HORIZONTAL_HATCH = 0
BRUSHSTYLE_VERTICAL_HATCH = 0
BRUSHSTYLE_FIRST_HATCH = 0
BRUSHSTYLE_LAST_HATCH = 0

class Brush(GDIObject):
    """
    Brush()
    Brush(colour, style=BRUSHSTYLE_SOLID)
    Brush(stippleBitmap)
    Brush(brush)
    
    A brush is a drawing tool for filling in areas.
    """

    def __init__(self, *args, **kw):
        """
        Brush()
        Brush(colour, style=BRUSHSTYLE_SOLID)
        Brush(stippleBitmap)
        Brush(brush)
        
        A brush is a drawing tool for filling in areas.
        """

    def SetColour(self, *args, **kw):
        """
        SetColour(colour)
        SetColour(red, green, blue)
        
        Sets the brush colour using red, green and blue values.
        """

    def GetColour(self):
        """
        GetColour() -> Colour
        
        Returns a reference to the brush colour.
        """

    def GetStipple(self):
        """
        GetStipple() -> Bitmap
        
        Gets a pointer to the stipple bitmap.
        """

    def GetStyle(self):
        """
        GetStyle() -> BrushStyle
        
        Returns the brush style, one of the wxBrushStyle values.
        """

    def IsHatch(self):
        """
        IsHatch() -> bool
        
        Returns true if the style of the brush is any of hatched fills.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if the brush is initialised.
        """

    def IsNonTransparent(self):
        """
        IsNonTransparent() -> bool
        
        Returns true if the brush is a valid non-transparent brush.
        """

    def IsTransparent(self):
        """
        IsTransparent() -> bool
        
        Returns true if the brush is transparent.
        """

    def SetStipple(self, bitmap):
        """
        SetStipple(bitmap)
        
        Sets the stipple bitmap.
        """

    def SetStyle(self, style):
        """
        SetStyle(style)
        
        Sets the brush style.
        """

    def __ne__(self):
        """
        """

    def __eq__(self):
        """
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """

    def MacSetTheme(self, macThemeBrushID):
        """
        MacSetTheme(macThemeBrushID)
        """
    Colour = property(None, None)
    Stipple = property(None, None)
    Style = property(None, None)

    def _copyFrom(self, other):
        """
        _copyFrom(other)
        
        For internal use only.
        """
# end of class Brush


class BrushList(object):
    """
    A brush list is a list containing all brushes which have been created.
    """

    def FindOrCreateBrush(self, colour, style=BRUSHSTYLE_SOLID):
        """
        FindOrCreateBrush(colour, style=BRUSHSTYLE_SOLID) -> Brush
        
        Finds a brush with the specified attributes and returns it, else
        creates a new brush, adds it to the brush list, and returns it.
        """
# end of class BrushList

NullBrush = Brush()

# These stock brushes will be initialized when the wx.App object is created.
BLUE_BRUSH = Brush()
GREEN_BRUSH = Brush()
YELLOW_BRUSH = Brush()
WHITE_BRUSH = Brush()
BLACK_BRUSH = Brush()
GREY_BRUSH = Brush()
MEDIUM_GREY_BRUSH = Brush()
LIGHT_GREY_BRUSH = Brush()
TRANSPARENT_BRUSH = Brush()
CYAN_BRUSH = Brush()
RED_BRUSH = Brush()

wx.STIPPLE_MASK_OPAQUE = int(wx.BRUSHSTYLE_STIPPLE_MASK_OPAQUE)
wx.STIPPLE_MASK        = int(wx.BRUSHSTYLE_STIPPLE_MASK)
wx.STIPPLE             = int(wx.BRUSHSTYLE_STIPPLE)
wx.BDIAGONAL_HATCH     = int(wx.BRUSHSTYLE_BDIAGONAL_HATCH)
wx.CROSSDIAG_HATCH     = int(wx.BRUSHSTYLE_CROSSDIAG_HATCH)
wx.FDIAGONAL_HATCH     = int(wx.BRUSHSTYLE_FDIAGONAL_HATCH)
wx.CROSS_HATCH         = int(wx.BRUSHSTYLE_CROSS_HATCH)
wx.HORIZONTAL_HATCH    = int(wx.BRUSHSTYLE_HORIZONTAL_HATCH)
wx.VERTICAL_HATCH      = int(wx.BRUSHSTYLE_VERTICAL_HATCH)
#-- end-brush --#
#-- begin-cursor --#

class Cursor(GDIObject):
    """
    Cursor()
    Cursor(cursorName, type=BITMAP_TYPE_ANY, hotSpotX=0, hotSpotY=0)
    Cursor(cursorId)
    Cursor(image)
    Cursor(cursor)
    
    A cursor is a small bitmap usually used for denoting where the mouse
    pointer is, with a picture that might indicate the interpretation of a
    mouse click.
    """

    def __init__(self, *args, **kw):
        """
        Cursor()
        Cursor(cursorName, type=BITMAP_TYPE_ANY, hotSpotX=0, hotSpotY=0)
        Cursor(cursorId)
        Cursor(image)
        Cursor(cursor)
        
        A cursor is a small bitmap usually used for denoting where the mouse
        pointer is, with a picture that might indicate the interpretation of a
        mouse click.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if cursor data is present.
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """

    def GetHandle(self):
        """
        GetHandle() -> long
        
        Get the handle for the Cursor.  Windows only.
        """

    def SetHandle(self, handle):
        """
        SetHandle(handle)
        
        Set the handle to use for this Cursor.  Windows only.
        """

    def _copyFrom(self, other):
        """
        _copyFrom(other)
        
        For internal use only.
        """
    Handle = property(None, None)
# end of class Cursor

NullCursor = Cursor()

# These stock cursors will be initialized when the wx.App object is created.
STANDARD_CURSOR = Cursor()
HOURGLASS_CURSOR = Cursor()
CROSS_CURSOR = Cursor()

StockCursor = wx.deprecated(Cursor, "Use Cursor instead.")

CursorFromImage = wx.deprecated(Cursor, "Use Cursor instead.")
#-- end-cursor --#
#-- begin-region --#
OutRegion = 0
PartRegion = 0
InRegion = 0

class RegionIterator(Object):
    """
    RegionIterator()
    RegionIterator(region)
    
    This class is used to iterate through the rectangles in a region,
    typically when examining the damaged regions of a window within an
    OnPaint call.
    """

    def __init__(self, *args, **kw):
        """
        RegionIterator()
        RegionIterator(region)
        
        This class is used to iterate through the rectangles in a region,
        typically when examining the damaged regions of a window within an
        OnPaint call.
        """

    def GetH(self):
        """
        GetH() -> Coord
        
        An alias for GetHeight().
        """

    def GetHeight(self):
        """
        GetHeight() -> Coord
        
        Returns the height value for the current region.
        """

    def GetRect(self):
        """
        GetRect() -> Rect
        
        Returns the current rectangle.
        """

    def GetW(self):
        """
        GetW() -> Coord
        
        An alias for GetWidth().
        """

    def GetWidth(self):
        """
        GetWidth() -> Coord
        
        Returns the width value for the current region.
        """

    def GetX(self):
        """
        GetX() -> Coord
        
        Returns the x value for the current region.
        """

    def GetY(self):
        """
        GetY() -> Coord
        
        Returns the y value for the current region.
        """

    def HaveRects(self):
        """
        HaveRects() -> bool
        
        Returns true if there are still some rectangles; otherwise returns
        false.
        """

    def Reset(self, *args, **kw):
        """
        Reset()
        Reset(region)
        
        Resets the iterator to the beginning of the rectangles.
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        
        Returns true while there are still rectangles available in the
        iteration.
        """

    def Next(self):
        """
        Next()
        
        Move the iterator to the next rectangle in the region.
        """
    H = property(None, None)
    Height = property(None, None)
    Rect = property(None, None)
    W = property(None, None)
    Width = property(None, None)
    X = property(None, None)
    Y = property(None, None)
# end of class RegionIterator


class Region(GDIObject):
    """
    Region()
    Region(x, y, width, height)
    Region(topLeft, bottomRight)
    Region(rect)
    Region(region)
    Region(bmp)
    Region(bmp, transColour, tolerance=0)
    Region(points, fillStyle=ODDEVEN_RULE)
    
    A wxRegion represents a simple or complex region on a device context
    or window.
    """

    def __init__(self, *args, **kw):
        """
        Region()
        Region(x, y, width, height)
        Region(topLeft, bottomRight)
        Region(rect)
        Region(region)
        Region(bmp)
        Region(bmp, transColour, tolerance=0)
        Region(points, fillStyle=ODDEVEN_RULE)
        
        A wxRegion represents a simple or complex region on a device context
        or window.
        """

    def GetBox(self):
        """
        GetBox() -> Rect
        
        Returns the outer bounds of the region.
        """

    def Offset(self, *args, **kw):
        """
        Offset(x, y) -> bool
        Offset(pt) -> bool
        
        Moves the region by the specified offsets in horizontal and vertical
        directions.
        """

    def Clear(self):
        """
        Clear()
        
        Clears the current region.
        """

    def Contains(self, *args, **kw):
        """
        Contains(x, y) -> RegionContain
        Contains(pt) -> RegionContain
        Contains(x, y, width, height) -> RegionContain
        Contains(rect) -> RegionContain
        
        Returns a value indicating whether the given point is contained within
        the region.
        """

    def ConvertToBitmap(self):
        """
        ConvertToBitmap() -> Bitmap
        
        Convert the region to a black and white bitmap with the white pixels
        being inside the region.
        """

    def Intersect(self, *args, **kw):
        """
        Intersect(x, y, width, height) -> bool
        Intersect(rect) -> bool
        Intersect(region) -> bool
        
        Finds the intersection of this region and another, rectangular region,
        specified using position and size.
        """

    def IsEmpty(self):
        """
        IsEmpty() -> bool
        
        Returns true if the region is empty, false otherwise.
        """

    def IsEqual(self, region):
        """
        IsEqual(region) -> bool
        
        Returns true if the region is equal to, i.e. covers the same area as,
        another one.
        """

    def Subtract(self, *args, **kw):
        """
        Subtract(rect) -> bool
        Subtract(region) -> bool
        
        Subtracts a rectangular region from this region.
        """

    def Union(self, *args, **kw):
        """
        Union(x, y, width, height) -> bool
        Union(rect) -> bool
        Union(region) -> bool
        Union(bmp) -> bool
        Union(bmp, transColour, tolerance=0) -> bool
        
        Finds the union of this region and another, rectangular region,
        specified using position and size.
        """

    def Xor(self, *args, **kw):
        """
        Xor(x, y, width, height) -> bool
        Xor(rect) -> bool
        Xor(region) -> bool
        
        Finds the Xor of this region and another, rectangular region,
        specified using position and size.
        """

    def __iter__(self):
        """
        Returns a rectangle interator conforming to the Python iterator
        protocol.
        """

    class PyRegionIterator(object):
        "A Python iterator for wx.Region objects"
        def __init__(self, region):
            self._region = region
            self._iterator = wx.RegionIterator(region)
        def next(self):
            if not self._iterator:
                raise StopIteration
            rect = self._iterator.GetRect()
            if self._iterator.HaveRects():
                self._iterator.Next()
            return rect
        __next__ = next  # for Python 3
    Box = property(None, None)
# end of class Region

#-- end-region --#
#-- begin-dc --#
CLEAR = 0
XOR = 0
INVERT = 0
OR_REVERSE = 0
AND_REVERSE = 0
COPY = 0
AND = 0
AND_INVERT = 0
NO_OP = 0
NOR = 0
EQUIV = 0
SRC_INVERT = 0
OR_INVERT = 0
NAND = 0
OR = 0
SET = 0
FLOOD_SURFACE = 0
FLOOD_BORDER = 0
MM_TEXT = 0
MM_METRIC = 0
MM_LOMETRIC = 0
MM_TWIPS = 0
MM_POINTS = 0

class FontMetrics(object):
    """
    FontMetrics()
    
    Simple collection of various font metrics.
    """

    def __init__(self):
        """
        FontMetrics()
        
        Simple collection of various font metrics.
        """
    height = property(None, None)
    ascent = property(None, None)
    descent = property(None, None)
    internalLeading = property(None, None)
    externalLeading = property(None, None)
    averageWidth = property(None, None)
# end of class FontMetrics


class DC(Object):
    """
    A wxDC is a "device context" onto which graphics and text can be
    drawn.
    """

    def DeviceToLogicalX(self, x):
        """
        DeviceToLogicalX(x) -> Coord
        
        Convert device X coordinate to logical coordinate, using the current
        mapping mode, user scale factor, device origin and axis orientation.
        """

    def DeviceToLogicalXRel(self, x):
        """
        DeviceToLogicalXRel(x) -> Coord
        
        Convert device X coordinate to relative logical coordinate, using the
        current mapping mode and user scale factor but ignoring the axis
        orientation.
        """

    def DeviceToLogicalY(self, y):
        """
        DeviceToLogicalY(y) -> Coord
        
        Converts device Y coordinate to logical coordinate, using the current
        mapping mode, user scale factor, device origin and axis orientation.
        """

    def DeviceToLogicalYRel(self, y):
        """
        DeviceToLogicalYRel(y) -> Coord
        
        Convert device Y coordinate to relative logical coordinate, using the
        current mapping mode and user scale factor but ignoring the axis
        orientation.
        """

    def LogicalToDeviceX(self, x):
        """
        LogicalToDeviceX(x) -> Coord
        
        Converts logical X coordinate to device coordinate, using the current
        mapping mode, user scale factor, device origin and axis orientation.
        """

    def LogicalToDeviceXRel(self, x):
        """
        LogicalToDeviceXRel(x) -> Coord
        
        Converts logical X coordinate to relative device coordinate, using the
        current mapping mode and user scale factor but ignoring the axis
        orientation.
        """

    def LogicalToDeviceY(self, y):
        """
        LogicalToDeviceY(y) -> Coord
        
        Converts logical Y coordinate to device coordinate, using the current
        mapping mode, user scale factor, device origin and axis orientation.
        """

    def LogicalToDeviceYRel(self, y):
        """
        LogicalToDeviceYRel(y) -> Coord
        
        Converts logical Y coordinate to relative device coordinate, using the
        current mapping mode and user scale factor but ignoring the axis
        orientation.
        """

    def Clear(self):
        """
        Clear()
        
        Clears the device context using the current background brush.
        """

    def DrawArc(self, *args, **kw):
        """
        DrawArc(xStart, yStart, xEnd, yEnd, xc, yc)
        DrawArc(ptStart, ptEnd, centre)
        
        Draws an arc from the given start to the given end point.
        """

    def DrawBitmap(self, *args, **kw):
        """
        DrawBitmap(bitmap, x, y, useMask=False)
        DrawBitmap(bmp, pt, useMask=False)
        
        Draw a bitmap on the device context at the specified point.
        """

    def DrawCheckMark(self, *args, **kw):
        """
        DrawCheckMark(x, y, width, height)
        DrawCheckMark(rect)
        
        Draws a check mark inside the given rectangle.
        """

    def DrawCircle(self, *args, **kw):
        """
        DrawCircle(x, y, radius)
        DrawCircle(pt, radius)
        
        Draws a circle with the given centre and radius.
        """

    def DrawEllipse(self, *args, **kw):
        """
        DrawEllipse(x, y, width, height)
        DrawEllipse(pt, size)
        DrawEllipse(rect)
        
        Draws an ellipse contained in the rectangle specified either with the
        given top left corner and the given size or directly.
        """

    def DrawEllipticArc(self, *args, **kw):
        """
        DrawEllipticArc(x, y, width, height, start, end)
        DrawEllipticArc(pt, sz, sa, ea)
        
        Draws an arc of an ellipse.
        """

    def DrawIcon(self, *args, **kw):
        """
        DrawIcon(icon, x, y)
        DrawIcon(icon, pt)
        
        Draw an icon on the display (does nothing if the device context is
        PostScript).
        """

    def DrawLabel(self, *args, **kw):
        """
        DrawLabel(text, bitmap, rect, alignment=ALIGN_LEFT|ALIGN_TOP, indexAccel=-1) -> Rect
        DrawLabel(text, rect, alignment=ALIGN_LEFT|ALIGN_TOP, indexAccel=-1)
        
        Draw optional bitmap and the text into the given rectangle and aligns
        it as specified by alignment parameter; it also will emphasize the
        character with the given index if it is != -1 and return the bounding
        rectangle if required.
        """

    def DrawLine(self, *args, **kw):
        """
        DrawLine(x1, y1, x2, y2)
        DrawLine(pt1, pt2)
        
        Draws a line from the first point to the second.
        """

    def DrawLines(self, points, xoffset=0, yoffset=0):
        """
        DrawLines(points, xoffset=0, yoffset=0)
        
        This method uses a list of wxPoints, adding the optional offset
        coordinate.
        """

    def DrawPoint(self, *args, **kw):
        """
        DrawPoint(x, y)
        DrawPoint(pt)
        
        Draws a point using the color of the current pen.
        """

    def DrawPolygon(self, points, xoffset=0, yoffset=0, fill_style=ODDEVEN_RULE):
        """
        DrawPolygon(points, xoffset=0, yoffset=0, fill_style=ODDEVEN_RULE)
        
        This method draws a filled polygon using a list of wxPoints, adding
        the optional offset coordinate.
        """

    def DrawRectangle(self, *args, **kw):
        """
        DrawRectangle(x, y, width, height)
        DrawRectangle(pt, sz)
        DrawRectangle(rect)
        
        Draws a rectangle with the given top left corner, and with the given
        size.
        """

    def DrawRotatedText(self, *args, **kw):
        """
        DrawRotatedText(text, x, y, angle)
        DrawRotatedText(text, point, angle)
        
        Draws the text rotated by angle degrees (positive angles are
        counterclockwise; the full angle is 360 degrees).
        """

    def DrawRoundedRectangle(self, *args, **kw):
        """
        DrawRoundedRectangle(x, y, width, height, radius)
        DrawRoundedRectangle(pt, sz, radius)
        DrawRoundedRectangle(rect, radius)
        
        Draws a rectangle with the given top left corner, and with the given
        size.
        """

    def DrawSpline(self, *args, **kw):
        """
        DrawSpline(points)
        DrawSpline(x1, y1, x2, y2, x3, y3)
        
        This is an overloaded member function, provided for convenience. It
        differs from the above function only in what argument(s) it accepts.
        """

    def DrawText(self, *args, **kw):
        """
        DrawText(text, x, y)
        DrawText(text, pt)
        
        Draws a text string at the specified point, using the current text
        font, and the current text foreground and background colours.
        """

    def GradientFillConcentric(self, *args, **kw):
        """
        GradientFillConcentric(rect, initialColour, destColour)
        GradientFillConcentric(rect, initialColour, destColour, circleCenter)
        
        Fill the area specified by rect with a radial gradient, starting from
        initialColour at the centre of the circle and fading to destColour on
        the circle outside.
        """

    def GradientFillLinear(self, rect, initialColour, destColour, nDirection=RIGHT):
        """
        GradientFillLinear(rect, initialColour, destColour, nDirection=RIGHT)
        
        Fill the area specified by rect with a linear gradient, starting from
        initialColour and eventually fading to destColour.
        """

    def FloodFill(self, *args, **kw):
        """
        FloodFill(x, y, colour, style=FLOOD_SURFACE) -> bool
        FloodFill(pt, col, style=FLOOD_SURFACE) -> bool
        
        Flood fills the device context starting from the given point, using
        the current brush colour, and using a style:
        """

    def CrossHair(self, *args, **kw):
        """
        CrossHair(x, y)
        CrossHair(pt)
        
        Displays a cross hair using the current pen.
        """

    def DestroyClippingRegion(self):
        """
        DestroyClippingRegion()
        
        Destroys the current clipping region so that none of the DC is
        clipped.
        """

    def GetClippingBox(self):
        """
        GetClippingBox() -> (x, y, width, height)
        
        Gets the rectangle surrounding the current clipping region.
        """

    def SetClippingRegion(self, *args, **kw):
        """
        SetClippingRegion(x, y, width, height)
        SetClippingRegion(pt, sz)
        SetClippingRegion(rect)
        
        Sets the clipping region for this device context to the intersection
        of the given region described by the parameters of this method and the
        previously set clipping region.
        """

    def SetDeviceClippingRegion(self, region):
        """
        SetDeviceClippingRegion(region)
        
        Sets the clipping region for this device context.
        """

    def GetCharHeight(self):
        """
        GetCharHeight() -> Coord
        
        Gets the character height of the currently set font.
        """

    def GetCharWidth(self):
        """
        GetCharWidth() -> Coord
        
        Gets the average character width of the currently set font.
        """

    def GetFontMetrics(self):
        """
        GetFontMetrics() -> FontMetrics
        
        Returns the various font characteristics.
        """

    def GetFullMultiLineTextExtent(self, string, font=None):
        """
        GetFullMultiLineTextExtent(string, font=None) -> (w, h, heightLine)
        
        Gets the dimensions of the string as it would be drawn.
        """

    def GetPartialTextExtents(self, text):
        """
        GetPartialTextExtents(text) -> ArrayInt
        
        Fills the widths array with the widths from the beginning of text to
        the corresponding character of text.
        """

    def GetFullTextExtent(self, string, font=None):
        """
        GetFullTextExtent(string, font=None) -> (w, h, descent, externalLeading)
        
        Gets the dimensions of the string as it would be drawn.
        """

    def GetBackgroundMode(self):
        """
        GetBackgroundMode() -> int
        
        Returns the current background mode: wxSOLID or wxTRANSPARENT.
        """

    def GetFont(self):
        """
        GetFont() -> Font
        
        Gets the current font.
        """

    def GetLayoutDirection(self):
        """
        GetLayoutDirection() -> LayoutDirection
        
        Gets the current layout direction of the device context.
        """

    def GetTextBackground(self):
        """
        GetTextBackground() -> Colour
        
        Gets the current text background colour.
        """

    def GetTextForeground(self):
        """
        GetTextForeground() -> Colour
        
        Gets the current text foreground colour.
        """

    def SetBackgroundMode(self, mode):
        """
        SetBackgroundMode(mode)
        
        mode may be one of wxSOLID and wxTRANSPARENT.
        """

    def SetFont(self, font):
        """
        SetFont(font)
        
        Sets the current font for the DC.
        """

    def SetTextBackground(self, colour):
        """
        SetTextBackground(colour)
        
        Sets the current text background colour for the DC.
        """

    def SetTextForeground(self, colour):
        """
        SetTextForeground(colour)
        
        Sets the current text foreground colour for the DC.
        """

    def SetLayoutDirection(self, dir):
        """
        SetLayoutDirection(dir)
        
        Sets the current layout direction for the device context.
        """

    def CalcBoundingBox(self, x, y):
        """
        CalcBoundingBox(x, y)
        
        Adds the specified point to the bounding box which can be retrieved
        with MinX(), MaxX() and MinY(), MaxY() functions.
        """

    def MaxX(self):
        """
        MaxX() -> Coord
        
        Gets the maximum horizontal extent used in drawing commands so far.
        """

    def MaxY(self):
        """
        MaxY() -> Coord
        
        Gets the maximum vertical extent used in drawing commands so far.
        """

    def MinX(self):
        """
        MinX() -> Coord
        
        Gets the minimum horizontal extent used in drawing commands so far.
        """

    def MinY(self):
        """
        MinY() -> Coord
        
        Gets the minimum vertical extent used in drawing commands so far.
        """

    def ResetBoundingBox(self):
        """
        ResetBoundingBox()
        
        Resets the bounding box: after a call to this function, the bounding
        box doesn't contain anything.
        """

    def StartDoc(self, message):
        """
        StartDoc(message) -> bool
        
        Starts a document (only relevant when outputting to a printer).
        """

    def StartPage(self):
        """
        StartPage()
        
        Starts a document page (only relevant when outputting to a printer).
        """

    def EndDoc(self):
        """
        EndDoc()
        
        Ends a document (only relevant when outputting to a printer).
        """

    def EndPage(self):
        """
        EndPage()
        
        Ends a document page (only relevant when outputting to a printer).
        """

    def Blit(self, xdest, ydest, width, height, source, xsrc, ysrc, logicalFunc=COPY, useMask=False, xsrcMask=DefaultCoord, ysrcMask=DefaultCoord):
        """
        Blit(xdest, ydest, width, height, source, xsrc, ysrc, logicalFunc=COPY, useMask=False, xsrcMask=DefaultCoord, ysrcMask=DefaultCoord) -> bool
        
        Copy from a source DC to this DC.
        """

    def StretchBlit(self, xdest, ydest, dstWidth, dstHeight, source, xsrc, ysrc, srcWidth, srcHeight, logicalFunc=COPY, useMask=False, xsrcMask=DefaultCoord, ysrcMask=DefaultCoord):
        """
        StretchBlit(xdest, ydest, dstWidth, dstHeight, source, xsrc, ysrc, srcWidth, srcHeight, logicalFunc=COPY, useMask=False, xsrcMask=DefaultCoord, ysrcMask=DefaultCoord) -> bool
        
        Copy from a source DC to this DC possibly changing the scale.
        """

    def GetBackground(self):
        """
        GetBackground() -> Brush
        
        Gets the brush used for painting the background.
        """

    def GetBrush(self):
        """
        GetBrush() -> Brush
        
        Gets the current brush.
        """

    def GetPen(self):
        """
        GetPen() -> Pen
        
        Gets the current pen.
        """

    def SetBackground(self, brush):
        """
        SetBackground(brush)
        
        Sets the current background brush for the DC.
        """

    def SetBrush(self, brush):
        """
        SetBrush(brush)
        
        Sets the current brush for the DC.
        """

    def SetPen(self, pen):
        """
        SetPen(pen)
        
        Sets the current pen for the DC.
        """

    def CanUseTransformMatrix(self):
        """
        CanUseTransformMatrix() -> bool
        
        Check if the use of transformation matrix is supported by the current
        system.
        """

    def SetTransformMatrix(self, matrix):
        """
        SetTransformMatrix(matrix) -> bool
        
        Set the transformation matrix.
        """

    def GetTransformMatrix(self):
        """
        GetTransformMatrix() -> AffineMatrix2D
        
        Return the transformation matrix used by this device context.
        """

    def ResetTransformMatrix(self):
        """
        ResetTransformMatrix()
        
        Revert the transformation matrix to identity matrix.
        """

    def CanDrawBitmap(self):
        """
        CanDrawBitmap() -> bool
        
        Does the DC support drawing bitmaps?
        """

    def CanGetTextExtent(self):
        """
        CanGetTextExtent() -> bool
        
        Does the DC support calculating the size required to draw text?
        """

    def GetLogicalOrigin(self):
        """
        GetLogicalOrigin() -> (x, y)
        
        Return the coordinates of the logical point (0, 0).
        """

    def CopyAttributes(self, dc):
        """
        CopyAttributes(dc)
        
        Copy attributes from another DC.
        """

    def GetDepth(self):
        """
        GetDepth() -> int
        
        Returns the depth (number of bits/pixel) of this DC.
        """

    def GetDeviceOrigin(self):
        """
        GetDeviceOrigin() -> Point
        
        Returns the current device origin.
        """

    def GetLogicalFunction(self):
        """
        GetLogicalFunction() -> RasterOperationMode
        
        Gets the current logical function.
        """

    def GetMapMode(self):
        """
        GetMapMode() -> MappingMode
        
        Gets the current mapping mode for the device context.
        """

    def GetPixel(self, x, y):
        """
        GetPixel(x, y) -> Colour
        
        Gets the colour at the specified location on the DC.
        """

    def GetPPI(self):
        """
        GetPPI() -> Size
        
        Returns the resolution of the device in pixels per inch.
        """

    def GetSize(self):
        """
        GetSize() -> Size
        
        This is an overloaded member function, provided for convenience. It
        differs from the above function only in what argument(s) it accepts.
        """

    def GetSizeMM(self):
        """
        GetSizeMM() -> Size
        
        This is an overloaded member function, provided for convenience. It
        differs from the above function only in what argument(s) it accepts.
        """

    def GetUserScale(self):
        """
        GetUserScale() -> (x, y)
        
        Gets the current user scale factor.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if the DC is ok to use.
        """

    def SetAxisOrientation(self, xLeftRight, yBottomUp):
        """
        SetAxisOrientation(xLeftRight, yBottomUp)
        
        Sets the x and y axis orientation (i.e. the direction from lowest to
        highest values on the axis).
        """

    def SetDeviceOrigin(self, x, y):
        """
        SetDeviceOrigin(x, y)
        
        Sets the device origin (i.e. the origin in pixels after scaling has
        been applied).
        """

    def SetLogicalFunction(self, function):
        """
        SetLogicalFunction(function)
        
        Sets the current logical function for the device context.
        """

    def SetMapMode(self, mode):
        """
        SetMapMode(mode)
        
        The mapping mode of the device context defines the unit of measurement
        used to convert logical units to device units.
        """

    def SetPalette(self, palette):
        """
        SetPalette(palette)
        
        If this is a window DC or memory DC, assigns the given palette to the
        window or bitmap associated with the DC.
        """

    def SetUserScale(self, xScale, yScale):
        """
        SetUserScale(xScale, yScale)
        
        Sets the user scaling factor, useful for applications which require
        'zooming'.
        """

    def GetHandle(self):
        """
        GetHandle() -> void
        
        Returns a value that can be used as a handle to the native drawing
        context, if this wxDC has something that could be thought of in that
        way.
        """

    def GetAsBitmap(self, subrect=None):
        """
        GetAsBitmap(subrect=None) -> Bitmap
        
        If supported by the platform and the type of DC, fetch the contents of
        the DC, or a subset of it, as a bitmap.
        """

    def SetLogicalScale(self, x, y):
        """
        SetLogicalScale(x, y)
        
        Set the scale to use for translating wxDC coordinates to the physical
        pixels.
        """

    def GetLogicalScale(self):
        """
        GetLogicalScale() -> (x, y)
        
        Return the scale set by the last call to SetLogicalScale().
        """

    def SetLogicalOrigin(self, x, y):
        """
        SetLogicalOrigin(x, y)
        
        Change the offset used for translating wxDC coordinates.
        """

    def GetClippingRect(self):
        """
        Gets the rectangle surrounding the current clipping region
        """

    def GetTextExtent(self, st):
        """
        GetTextExtent(st) -> Size
        
        Return the dimensions of the given string's text extent using the
        currently selected font.
        
        :param st: The string to be measured
        
        .. seealso:: :meth:`~wx.DC.GetFullTextExtent`
        """

    def GetMultiLineTextExtent(self, st):
        """
        GetMultiLineTextExtent(st) -> Size
        
        Return the dimensions of the given string's text extent using the
        currently selected font, taking into account multiple lines if
        present in the string.
        
        :param st: The string to be measured
        
        .. seealso:: :meth:`~wx.DC.GetFullMultiLineTextExtent`
        """

    DrawImageLabel = wx.deprecated(DrawLabel, "Use DrawLabel instead.")

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """

    def GetBoundingBox(self):
        """
        GetBoundingBox() -> (x1,y1, x2,y2)
        
        Returns the min and max points used in drawing commands so far.
        """

    def GetHDC(self):
        """
        GetHDC() -> long
        """

    def GetCGContext(self):
        """
        GetCGContext() -> void
        """

    def GetGdkDrawable(self):
        """
        GetGdkDrawable() -> void
        """

    GetHDC = wx.deprecated(GetHDC, "Use GetHandle instead.")

    GetCGContext = wx.deprecated(GetCGContext, "Use GetHandle instead.")

    GetGdkDrawable = wx.deprecated(GetGdkDrawable, "Use GetHandle instead.")

    def _DrawPointList(self, pyCoords, pyPens, pyBrushes):
        """
        _DrawPointList(pyCoords, pyPens, pyBrushes) -> PyObject
        """

    def _DrawLineList(self, pyCoords, pyPens, pyBrushes):
        """
        _DrawLineList(pyCoords, pyPens, pyBrushes) -> PyObject
        """

    def _DrawRectangleList(self, pyCoords, pyPens, pyBrushes):
        """
        _DrawRectangleList(pyCoords, pyPens, pyBrushes) -> PyObject
        """

    def _DrawEllipseList(self, pyCoords, pyPens, pyBrushes):
        """
        _DrawEllipseList(pyCoords, pyPens, pyBrushes) -> PyObject
        """

    def _DrawPolygonList(self, pyCoords, pyPens, pyBrushes):
        """
        _DrawPolygonList(pyCoords, pyPens, pyBrushes) -> PyObject
        """

    def _DrawTextList(self, textList, pyPoints, foregroundList, backgroundList):
        """
        _DrawTextList(textList, pyPoints, foregroundList, backgroundList) -> PyObject
        """

    def DrawPointList(self, points, pens=None):
        """
        Draw a list of points as quickly as possible.
        
        :param points: A sequence of 2-element sequences representing
                       each point to draw, (x,y).
        :param pens:   If None, then the current pen is used.  If a single
                       pen then it will be used for all points.  If a list of
                       pens then there should be one for each point in points.
        """

    def DrawLineList(self, lines, pens=None):
        """
        Draw a list of lines as quickly as possible.
        
        :param lines: A sequence of 4-element sequences representing
                      each line to draw, (x1,y1, x2,y2).
        :param pens:  If None, then the current pen is used.  If a
                      single pen then it will be used for all lines.  If
                      a list of pens then there should be one for each line
                      in lines.
        """

    def DrawRectangleList(self, rectangles, pens=None, brushes=None):
        """
        Draw a list of rectangles as quickly as possible.
        
        :param rectangles: A sequence of 4-element sequences representing
                           each rectangle to draw, (x,y, w,h).
        :param pens:       If None, then the current pen is used.  If a
                           single pen then it will be used for all rectangles.
                           If a list of pens then there should be one for each
                           rectangle in rectangles.
        :param brushes:    A brush or brushes to be used to fill the rectagles,
                           with similar semantics as the pens parameter.
        """

    def DrawEllipseList(self, ellipses, pens=None, brushes=None):
        """
        Draw a list of ellipses as quickly as possible.
        
        :param ellipses: A sequence of 4-element sequences representing
                         each ellipse to draw, (x,y, w,h).
        :param pens:     If None, then the current pen is used.  If a
                         single pen then it will be used for all ellipses.
                         If a list of pens then there should be one for each
                         ellipse in ellipses.
        :param brushes:  A brush or brushes to be used to fill the ellipses,
                         with similar semantics as the pens parameter.
        """

    def DrawPolygonList(self, polygons, pens=None, brushes=None):
        """
        Draw a list of polygons, each of which is a list of points.
        
        :param polygons: A sequence of sequences of sequences.
                         [[(x1,y1),(x2,y2),(x3,y3)...], [(x1,y1),(x2,y2),(x3,y3)...]]
        
        :param pens:     If None, then the current pen is used.  If a
                         single pen then it will be used for all polygons.
                         If a list of pens then there should be one for each
                         polygon.
        :param brushes:  A brush or brushes to be used to fill the polygons,
                         with similar semantics as the pens parameter.
        """

    def DrawTextList(self, textList, coords, foregrounds=None, backgrounds=None):
        """
        Draw a list of strings using a list of coordinants for positioning each string.
        
        :param textList:    A list of strings
        :param coords:      A list of (x,y) positions
        :param foregrounds: A list of `wx.Colour` objects to use for the
                            foregrounds of the strings.
        :param backgrounds: A list of `wx.Colour` objects to use for the
                            backgrounds of the strings.
        
        NOTE: Make sure you set background mode to wx.Solid (DC.SetBackgroundMode)
              If you want backgrounds to do anything.
        """
    AsBitmap = property(None, None)
    Background = property(None, None)
    BackgroundMode = property(None, None)
    BoundingBox = property(None, None)
    Brush = property(None, None)
    CGContext = property(None, None)
    CharHeight = property(None, None)
    CharWidth = property(None, None)
    ClippingRect = property(None, None)
    Depth = property(None, None)
    DeviceOrigin = property(None, None)
    Font = property(None, None)
    FontMetrics = property(None, None)
    GdkDrawable = property(None, None)
    HDC = property(None, None)
    Handle = property(None, None)
    LayoutDirection = property(None, None)
    LogicalFunction = property(None, None)
    MapMode = property(None, None)
    MultiLineTextExtent = property(None, None)
    PPI = property(None, None)
    Pen = property(None, None)
    Pixel = property(None, None)
    Size = property(None, None)
    SizeMM = property(None, None)
    TextBackground = property(None, None)
    TextExtent = property(None, None)
    TextForeground = property(None, None)
    TransformMatrix = property(None, None)
# end of class DC


class DCClipper(object):
    """
    DCClipper(dc, region)
    DCClipper(dc, rect)
    DCClipper(dc, x, y, w, h)
    
    wxDCClipper is a helper class for setting a clipping region on a wxDC
    during its lifetime.
    """

    def __init__(self, *args, **kw):
        """
        DCClipper(dc, region)
        DCClipper(dc, rect)
        DCClipper(dc, x, y, w, h)
        
        wxDCClipper is a helper class for setting a clipping region on a wxDC
        during its lifetime.
        """

    def __enter__(self):
        """
        
        """

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        
        """
# end of class DCClipper


class DCBrushChanger(object):
    """
    DCBrushChanger(dc, brush)
    
    wxDCBrushChanger is a small helper class for setting a brush on a wxDC
    and unsetting it automatically in the destructor, restoring the
    previous one.
    """

    def __init__(self, dc, brush):
        """
        DCBrushChanger(dc, brush)
        
        wxDCBrushChanger is a small helper class for setting a brush on a wxDC
        and unsetting it automatically in the destructor, restoring the
        previous one.
        """

    def __enter__(self):
        """
        
        """

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        
        """
# end of class DCBrushChanger


class DCPenChanger(object):
    """
    DCPenChanger(dc, pen)
    
    wxDCPenChanger is a small helper class for setting a pen on a wxDC and
    unsetting it automatically in the destructor, restoring the previous
    one.
    """

    def __init__(self, dc, pen):
        """
        DCPenChanger(dc, pen)
        
        wxDCPenChanger is a small helper class for setting a pen on a wxDC and
        unsetting it automatically in the destructor, restoring the previous
        one.
        """

    def __enter__(self):
        """
        
        """

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        
        """
# end of class DCPenChanger


class DCTextColourChanger(object):
    """
    DCTextColourChanger(dc)
    DCTextColourChanger(dc, col)
    
    wxDCTextColourChanger is a small helper class for setting a foreground
    text colour on a wxDC and unsetting it automatically in the
    destructor, restoring the previous one.
    """

    def __init__(self, *args, **kw):
        """
        DCTextColourChanger(dc)
        DCTextColourChanger(dc, col)
        
        wxDCTextColourChanger is a small helper class for setting a foreground
        text colour on a wxDC and unsetting it automatically in the
        destructor, restoring the previous one.
        """

    def Set(self, col):
        """
        Set(col)
        
        Set the colour to use.
        """

    def __enter__(self):
        """
        
        """

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        
        """
# end of class DCTextColourChanger


class DCFontChanger(object):
    """
    DCFontChanger(dc)
    DCFontChanger(dc, font)
    
    wxDCFontChanger is a small helper class for setting a font on a wxDC
    and unsetting it automatically in the destructor, restoring the
    previous one.
    """

    def __init__(self, *args, **kw):
        """
        DCFontChanger(dc)
        DCFontChanger(dc, font)
        
        wxDCFontChanger is a small helper class for setting a font on a wxDC
        and unsetting it automatically in the destructor, restoring the
        previous one.
        """

    def Set(self, font):
        """
        Set(font)
        
        Set the font to use.
        """

    def __enter__(self):
        """
        
        """

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        
        """
# end of class DCFontChanger

#-- end-dc --#
#-- begin-dcclient --#

class WindowDC(DC):
    """
    WindowDC(window)
    
    A wxWindowDC must be constructed if an application wishes to paint on
    the whole area of a window (client and decorations).
    """

    def __init__(self, window):
        """
        WindowDC(window)
        
        A wxWindowDC must be constructed if an application wishes to paint on
        the whole area of a window (client and decorations).
        """
# end of class WindowDC


class ClientDC(WindowDC):
    """
    ClientDC(window)
    
    A wxClientDC must be constructed if an application wishes to paint on
    the client area of a window from outside an EVT_PAINT() handler.
    """

    def __init__(self, window):
        """
        ClientDC(window)
        
        A wxClientDC must be constructed if an application wishes to paint on
        the client area of a window from outside an EVT_PAINT() handler.
        """
# end of class ClientDC


class PaintDC(ClientDC):
    """
    PaintDC(window)
    
    A wxPaintDC must be constructed if an application wishes to paint on
    the client area of a window from within an EVT_PAINT() event handler.
    """

    def __init__(self, window):
        """
        PaintDC(window)
        
        A wxPaintDC must be constructed if an application wishes to paint on
        the client area of a window from within an EVT_PAINT() event handler.
        """
# end of class PaintDC

#-- end-dcclient --#
#-- begin-dcmemory --#

class MemoryDC(DC):
    """
    MemoryDC()
    MemoryDC(dc)
    MemoryDC(bitmap)
    
    A memory device context provides a means to draw graphics onto a
    bitmap.
    """

    def __init__(self, *args, **kw):
        """
        MemoryDC()
        MemoryDC(dc)
        MemoryDC(bitmap)
        
        A memory device context provides a means to draw graphics onto a
        bitmap.
        """

    def SelectObject(self, bitmap):
        """
        SelectObject(bitmap)
        
        Works exactly like SelectObjectAsSource() but this is the function you
        should use when you select a bitmap because you want to modify it,
        e.g.
        """

    def SelectObjectAsSource(self, bitmap):
        """
        SelectObjectAsSource(bitmap)
        
        Selects the given bitmap into the device context, to use as the memory
        bitmap.
        """
# end of class MemoryDC

#-- end-dcmemory --#
#-- begin-dcbuffer --#
BUFFER_VIRTUAL_AREA = 0
BUFFER_CLIENT_AREA = 0
BUFFER_USES_SHARED_BUFFER = 0

class BufferedDC(MemoryDC):
    """
    BufferedDC()
    BufferedDC(dc, area, style=BUFFER_CLIENT_AREA)
    BufferedDC(dc, buffer=NullBitmap, style=BUFFER_CLIENT_AREA)
    
    This class provides a simple way to avoid flicker: when drawing on it,
    everything is in fact first drawn on an in-memory buffer (a wxBitmap)
    and then copied to the screen, using the associated wxDC, only once,
    when this object is destroyed.
    """

    def __init__(self, *args, **kw):
        """
        BufferedDC()
        BufferedDC(dc, area, style=BUFFER_CLIENT_AREA)
        BufferedDC(dc, buffer=NullBitmap, style=BUFFER_CLIENT_AREA)
        
        This class provides a simple way to avoid flicker: when drawing on it,
        everything is in fact first drawn on an in-memory buffer (a wxBitmap)
        and then copied to the screen, using the associated wxDC, only once,
        when this object is destroyed.
        """

    def Init(self, *args, **kw):
        """
        Init(dc, area, style=BUFFER_CLIENT_AREA)
        Init(dc, buffer=NullBitmap, style=BUFFER_CLIENT_AREA)
        
        Initializes the object created using the default constructor.
        """

    def UnMask(self):
        """
        UnMask()
        
        Blits the buffer to the dc, and detaches the dc from the buffer (so it
        can be effectively used once only).
        """

    def SetStyle(self, style):
        """
        SetStyle(style)
        
        Set the style.
        """

    def GetStyle(self):
        """
        GetStyle() -> int
        
        Get the style.
        """
    Style = property(None, None)
# end of class BufferedDC


class BufferedPaintDC(BufferedDC):
    """
    BufferedPaintDC(window, buffer, style=BUFFER_CLIENT_AREA)
    BufferedPaintDC(window, style=BUFFER_CLIENT_AREA)
    
    This is a subclass of wxBufferedDC which can be used inside of an
    EVT_PAINT() event handler to achieve double-buffered drawing.
    """

    def __init__(self, *args, **kw):
        """
        BufferedPaintDC(window, buffer, style=BUFFER_CLIENT_AREA)
        BufferedPaintDC(window, style=BUFFER_CLIENT_AREA)
        
        This is a subclass of wxBufferedDC which can be used inside of an
        EVT_PAINT() event handler to achieve double-buffered drawing.
        """
# end of class BufferedPaintDC


class AutoBufferedPaintDC(DC):
    """
    AutoBufferedPaintDC(window)
    
    This wxDC derivative can be used inside of an EVT_PAINT() event
    handler to achieve double-buffered drawing.
    """

    def __init__(self, window):
        """
        AutoBufferedPaintDC(window)
        
        This wxDC derivative can be used inside of an EVT_PAINT() event
        handler to achieve double-buffered drawing.
        """
# end of class AutoBufferedPaintDC


def AutoBufferedPaintDCFactory(window):
    """
    AutoBufferedPaintDCFactory(window) -> DC
    
    Check if the window is natively double buffered and will return a
    wxPaintDC if it is, a wxBufferedPaintDC otherwise.
    """
#-- end-dcbuffer --#
#-- begin-dcscreen --#

class ScreenDC(DC):
    """
    ScreenDC()
    
    A wxScreenDC can be used to paint on the screen.
    """

    def __init__(self):
        """
        ScreenDC()
        
        A wxScreenDC can be used to paint on the screen.
        """

    @staticmethod
    def EndDrawingOnTop():
        """
        EndDrawingOnTop() -> bool
        
        Use this in conjunction with StartDrawingOnTop().
        """

    @staticmethod
    def StartDrawingOnTop(*args, **kw):
        """
        StartDrawingOnTop(window) -> bool
        StartDrawingOnTop(rect=None) -> bool
        
        Use this in conjunction with EndDrawingOnTop() to ensure that drawing
        to the screen occurs on top of existing windows.
        """
# end of class ScreenDC

#-- end-dcscreen --#
#-- begin-dcgraph --#

class GCDC(DC):
    """
    GCDC(windowDC)
    GCDC(memoryDC)
    GCDC(printerDC)
    GCDC(context)
    GCDC()
    
    wxGCDC is a device context that draws on a wxGraphicsContext.
    """

    def __init__(self, *args, **kw):
        """
        GCDC(windowDC)
        GCDC(memoryDC)
        GCDC(printerDC)
        GCDC(context)
        GCDC()
        
        wxGCDC is a device context that draws on a wxGraphicsContext.
        """

    def GetGraphicsContext(self):
        """
        GetGraphicsContext() -> GraphicsContext
        
        Retrieves associated wxGraphicsContext.
        """

    def SetGraphicsContext(self, ctx):
        """
        SetGraphicsContext(ctx)
        
        Set the graphics context to be used for this wxGCDC.
        """
    GraphicsContext = property(None, None)
# end of class GCDC

#-- end-dcgraph --#
#-- begin-dcmirror --#

class MirrorDC(DC):
    """
    MirrorDC(dc, mirror)
    
    wxMirrorDC is a simple wrapper class which is always associated with a
    real wxDC object and either forwards all of its operations to it
    without changes (no mirroring takes place) or exchanges x and y
    coordinates which makes it possible to reuse the same code to draw a
    figure and its mirror  i.e.
    """

    def __init__(self, dc, mirror):
        """
        MirrorDC(dc, mirror)
        
        wxMirrorDC is a simple wrapper class which is always associated with a
        real wxDC object and either forwards all of its operations to it
        without changes (no mirroring takes place) or exchanges x and y
        coordinates which makes it possible to reuse the same code to draw a
        figure and its mirror  i.e.
        """
# end of class MirrorDC

#-- end-dcmirror --#
#-- begin-dcprint --#

class PrinterDC(DC):
    """
    PrinterDC(printData)
    
    A printer device context is specific to MSW and Mac, and allows access
    to any printer with a Windows or Macintosh driver.
    """

    def __init__(self, printData):
        """
        PrinterDC(printData)
        
        A printer device context is specific to MSW and Mac, and allows access
        to any printer with a Windows or Macintosh driver.
        """

    def GetPaperRect(self):
        """
        GetPaperRect() -> Rect
        
        Return the rectangle in device coordinates that corresponds to the
        full paper area, including the nonprinting regions of the paper.
        """
    PaperRect = property(None, None)
# end of class PrinterDC

#-- end-dcprint --#
#-- begin-dcps --#

class PostScriptDC(DC):
    """
    PostScriptDC()
    PostScriptDC(printData)
    
    This defines the wxWidgets Encapsulated PostScript device context,
    which can write PostScript files on any platform.
    """

    def __init__(self, *args, **kw):
        """
        PostScriptDC()
        PostScriptDC(printData)
        
        This defines the wxWidgets Encapsulated PostScript device context,
        which can write PostScript files on any platform.
        """
# end of class PostScriptDC

#-- end-dcps --#
#-- begin-dcsvg --#

class SVGFileDC(DC):
    """
    SVGFileDC(filename, width=320, height=240, dpi=72)
    
    A wxSVGFileDC is a device context onto which graphics and text can be
    drawn, and the output produced as a vector file, in SVG format.
    """

    def __init__(self, filename, width=320, height=240, dpi=72):
        """
        SVGFileDC(filename, width=320, height=240, dpi=72)
        
        A wxSVGFileDC is a device context onto which graphics and text can be
        drawn, and the output produced as a vector file, in SVG format.
        """

    def CrossHair(self, x, y):
        """
        CrossHair(x, y)
        
        Functions not implemented in this DC class.
        """

    def FloodFill(self, x, y, colour, style=FLOOD_SURFACE):
        """
        FloodFill(x, y, colour, style=FLOOD_SURFACE) -> bool
        
        Functions not implemented in this DC class.
        """

    def GetClippingBox(self, x, y, width, height):
        """
        GetClippingBox(x, y, width, height)
        
        Functions not implemented in this DC class.
        """

    def GetPixel(self, x, y, colour):
        """
        GetPixel(x, y, colour) -> bool
        
        Functions not implemented in this DC class.
        """

    def SetPalette(self, palette):
        """
        SetPalette(palette)
        
        Functions not implemented in this DC class.
        """

    def StartDoc(self, message):
        """
        StartDoc(message) -> bool
        
        Functions not implemented in this DC class.
        """

    def EndDoc(self):
        """
        EndDoc()
        
        Does nothing.
        """

    def EndPage(self):
        """
        EndPage()
        
        Does nothing.
        """

    def Clear(self):
        """
        Clear()
        
        This makes no sense in wxSVGFileDC and does nothing.
        """

    def SetLogicalFunction(self, function):
        """
        SetLogicalFunction(function)
        
        Does the same as wxDC::SetLogicalFunction(), except that only wxCOPY
        is available.
        """

    def SetClippingRegion(self, *args, **kw):
        """
        SetClippingRegion(x, y, width, height)
        SetClippingRegion(pt, sz)
        SetClippingRegion(rect)
        SetClippingRegion(region)
        
        Sets the clipping region for this device context to the intersection
        of the given region described by the parameters of this method and the
        previously set clipping region.
        """

    def DestroyClippingRegion(self):
        """
        DestroyClippingRegion()
        
        Destroys the current clipping region so that none of the DC is
        clipped.
        """
# end of class SVGFileDC

#-- end-dcsvg --#
#-- begin-graphics --#
ANTIALIAS_NONE = 0
ANTIALIAS_DEFAULT = 0
INTERPOLATION_DEFAULT = 0
INTERPOLATION_NONE = 0
INTERPOLATION_FAST = 0
INTERPOLATION_GOOD = 0
INTERPOLATION_BEST = 0
COMPOSITION_INVALID = 0
COMPOSITION_CLEAR = 0
COMPOSITION_SOURCE = 0
COMPOSITION_OVER = 0
COMPOSITION_IN = 0
COMPOSITION_OUT = 0
COMPOSITION_ATOP = 0
COMPOSITION_DEST = 0
COMPOSITION_DEST_OVER = 0
COMPOSITION_DEST_IN = 0
COMPOSITION_DEST_OUT = 0
COMPOSITION_DEST_ATOP = 0
COMPOSITION_XOR = 0
COMPOSITION_ADD = 0

class GraphicsObject(Object):
    """
    This class is the superclass of native graphics objects like pens etc.
    """

    def GetRenderer(self):
        """
        GetRenderer() -> GraphicsRenderer
        
        Returns the renderer that was used to create this instance, or NULL if
        it has not been initialized yet.
        """

    def IsNull(self):
        """
        IsNull() -> bool
        """

    def IsOk(self):
        """
        IsOk() -> bool
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """
    Renderer = property(None, None)
# end of class GraphicsObject


class GraphicsBitmap(GraphicsObject):
    """
    GraphicsBitmap()
    
    Represents a bitmap.
    """

    def __init__(self):
        """
        GraphicsBitmap()
        
        Represents a bitmap.
        """

    def ConvertToImage(self):
        """
        ConvertToImage() -> Image
        
        Return the contents of this bitmap as wxImage.
        """

    def GetNativeBitmap(self):
        """
        GetNativeBitmap() -> void
        
        Return the pointer to the native bitmap data.
        """
    NativeBitmap = property(None, None)
# end of class GraphicsBitmap


class GraphicsBrush(GraphicsObject):
    """
    A wxGraphicsBrush is a native representation of a brush.
    """
# end of class GraphicsBrush


class GraphicsFont(GraphicsObject):
    """
    A wxGraphicsFont is a native representation of a font.
    """
# end of class GraphicsFont


class GraphicsPen(GraphicsObject):
    """
    A wxGraphicsPen is a native representation of a pen.
    """
# end of class GraphicsPen


class GraphicsContext(GraphicsObject):
    """
    A wxGraphicsContext instance is the object that is drawn upon.
    """

    def CreateLinearGradientBrush(self, *args, **kw):
        """
        CreateLinearGradientBrush(x1, y1, x2, y2, c1, c2) -> GraphicsBrush
        CreateLinearGradientBrush(x1, y1, x2, y2, stops) -> GraphicsBrush
        
        Creates a native brush with a linear gradient.
        """

    def CreateRadialGradientBrush(self, *args, **kw):
        """
        CreateRadialGradientBrush(xo, yo, xc, yc, radius, oColor, cColor) -> GraphicsBrush
        CreateRadialGradientBrush(xo, yo, xc, yc, radius, stops) -> GraphicsBrush
        
        Creates a native brush with a radial gradient.
        """

    def DrawBitmap(self, *args, **kw):
        """
        DrawBitmap(bmp, x, y, w, h)
        DrawBitmap(bmp, x, y, w, h)
        
        Draws the bitmap.
        """

    @staticmethod
    def Create(*args, **kw):
        """
        Create(window) -> GraphicsContext
        Create(windowDC) -> GraphicsContext
        Create(memoryDC) -> GraphicsContext
        Create(printerDC) -> GraphicsContext
        Create(image) -> GraphicsContext
        Create() -> GraphicsContext
        
        Creates a wxGraphicsContext from a wxWindow.
        """

    @staticmethod
    def CreateFromNative(context):
        """
        CreateFromNative(context) -> GraphicsContext
        
        Creates a wxGraphicsContext from a native context.
        """

    @staticmethod
    def CreateFromNativeWindow(window):
        """
        CreateFromNativeWindow(window) -> GraphicsContext
        
        Creates a wxGraphicsContext from a native window.
        """

    def Clip(self, *args, **kw):
        """
        Clip(region)
        Clip(x, y, w, h)
        
        Clips drawings to the specified region.
        """

    def ConcatTransform(self, matrix):
        """
        ConcatTransform(matrix)
        
        Concatenates the passed in transform with the current transform of
        this context.
        """

    def CreateBitmap(self, bitmap):
        """
        CreateBitmap(bitmap) -> GraphicsBitmap
        
        Creates wxGraphicsBitmap from an existing wxBitmap.
        """

    def CreateBitmapFromImage(self, image):
        """
        CreateBitmapFromImage(image) -> GraphicsBitmap
        
        Creates wxGraphicsBitmap from an existing wxImage.
        """

    def CreateSubBitmap(self, bitmap, x, y, w, h):
        """
        CreateSubBitmap(bitmap, x, y, w, h) -> GraphicsBitmap
        
        Extracts a sub-bitmap from an existing bitmap.
        """

    def CreateBrush(self, brush):
        """
        CreateBrush(brush) -> GraphicsBrush
        
        Creates a native brush from a wxBrush.
        """

    def CreateFont(self, *args, **kw):
        """
        CreateFont(font, col=BLACK) -> GraphicsFont
        CreateFont(sizeInPixels, facename, flags=FONTFLAG_DEFAULT, col=BLACK) -> GraphicsFont
        
        Creates a native graphics font from a wxFont and a text colour.
        """

    def CreateMatrix(self, *args, **kw):
        """
        CreateMatrix(a=1.0, b=0.0, c=0.0, d=1.0, tx=0.0, ty=0.0) -> GraphicsMatrix
        CreateMatrix(mat) -> GraphicsMatrix
        
        Creates a native affine transformation matrix from the passed in
        values.
        """

    def CreatePath(self):
        """
        CreatePath() -> GraphicsPath
        
        Creates a native graphics path which is initially empty.
        """

    def CreatePen(self, pen):
        """
        CreatePen(pen) -> GraphicsPen
        
        Creates a native pen from a wxPen.
        """

    def DrawEllipse(self, x, y, w, h):
        """
        DrawEllipse(x, y, w, h)
        
        Draws an ellipse.
        """

    def DrawIcon(self, icon, x, y, w, h):
        """
        DrawIcon(icon, x, y, w, h)
        
        Draws the icon.
        """

    def DrawLines(self, point2Ds, fillStyle=ODDEVEN_RULE):
        """
        DrawLines(point2Ds, fillStyle=ODDEVEN_RULE)
        
        Draws a polygon.
        """

    def DrawPath(self, path, fillStyle=ODDEVEN_RULE):
        """
        DrawPath(path, fillStyle=ODDEVEN_RULE)
        
        Draws the path by first filling and then stroking.
        """

    def DrawRectangle(self, x, y, w, h):
        """
        DrawRectangle(x, y, w, h)
        
        Draws a rectangle.
        """

    def DrawRoundedRectangle(self, x, y, w, h, radius):
        """
        DrawRoundedRectangle(x, y, w, h, radius)
        
        Draws a rounded rectangle.
        """

    def DrawText(self, *args, **kw):
        """
        DrawText(str, x, y)
        DrawText(str, x, y, angle)
        DrawText(str, x, y, backgroundBrush)
        DrawText(str, x, y, angle, backgroundBrush)
        
        Draws text at the defined position.
        """

    def FillPath(self, path, fillStyle=ODDEVEN_RULE):
        """
        FillPath(path, fillStyle=ODDEVEN_RULE)
        
        Fills the path with the current brush.
        """

    def GetNativeContext(self):
        """
        GetNativeContext() -> void
        
        Returns the native context (CGContextRef for Core Graphics, Graphics
        pointer for GDIPlus and cairo_t pointer for cairo).
        """

    def GetPartialTextExtents(self, text):
        """
        GetPartialTextExtents(text) -> ArrayDouble
        
        Fills the widths array with the widths from the beginning of text to
        the corresponding character of text.
        """

    def GetFullTextExtent(self, *args, **kw):
        """
        GetFullTextExtent(text) -> (width, height, descent, externalLeading)
        GetTextExtent(text) -> (width, height)
        
        Gets the dimensions of the string using the currently selected font.
        """

    def GetTransform(self):
        """
        GetTransform() -> GraphicsMatrix
        
        Gets the current transformation matrix of this context.
        """

    def ResetClip(self):
        """
        ResetClip()
        
        Resets the clipping to original shape.
        """

    def Rotate(self, angle):
        """
        Rotate(angle)
        
        Rotates the current transformation matrix (in radians).
        """

    def Scale(self, xScale, yScale):
        """
        Scale(xScale, yScale)
        
        Scales the current transformation matrix.
        """

    def SetBrush(self, *args, **kw):
        """
        SetBrush(brush)
        SetBrush(brush)
        
        Sets the brush for filling paths.
        """

    def SetFont(self, *args, **kw):
        """
        SetFont(font, colour)
        SetFont(font)
        
        Sets the font for drawing text.
        """

    def SetPen(self, *args, **kw):
        """
        SetPen(pen)
        SetPen(pen)
        
        Sets the pen used for stroking.
        """

    def SetTransform(self, matrix):
        """
        SetTransform(matrix)
        
        Sets the current transformation matrix of this context.
        """

    def StrokeLine(self, x1, y1, x2, y2):
        """
        StrokeLine(x1, y1, x2, y2)
        
        Strokes a single line.
        """

    def StrokeLines(self, point2Ds):
        """
        StrokeLines(point2Ds)
        
        Stroke lines conencting all the points.
        """

    def StrokePath(self, path):
        """
        StrokePath(path)
        
        Strokes along a path with the current pen.
        """

    def Translate(self, dx, dy):
        """
        Translate(dx, dy)
        
        Translates the current transformation matrix.
        """

    def BeginLayer(self, opacity):
        """
        BeginLayer(opacity)
        
        Redirects all rendering is done into a fully transparent temporary
        context.
        """

    def EndLayer(self):
        """
        EndLayer()
        
        Composites back the drawings into the context with the opacity given
        at the BeginLayer call.
        """

    def SetAntialiasMode(self, antialias):
        """
        SetAntialiasMode(antialias) -> bool
        
        Sets the antialiasing mode, returns true if it supported.
        """

    def GetAntialiasMode(self):
        """
        GetAntialiasMode() -> AntialiasMode
        
        Returns the current shape antialiasing mode.
        """

    def SetInterpolationQuality(self, interpolation):
        """
        SetInterpolationQuality(interpolation) -> bool
        
        Sets the interpolation quality, returns true if it is supported.
        """

    def GetInterpolationQuality(self):
        """
        GetInterpolationQuality() -> InterpolationQuality
        
        Returns the current interpolation quality.
        """

    def SetCompositionMode(self, op):
        """
        SetCompositionMode(op) -> bool
        
        Sets the compositing operator, returns true if it supported.
        """

    def GetCompositionMode(self):
        """
        GetCompositionMode() -> CompositionMode
        
        Returns the current compositing operator.
        """

    def PushState(self):
        """
        PushState()
        
        Push the current state of the context's transformation matrix on a
        stack.
        """

    def PopState(self):
        """
        PopState()
        
        Pops a stored state from the stack and sets the current transformation
        matrix to that state.
        """

    def ShouldOffset(self):
        """
        ShouldOffset() -> bool
        """

    def EnableOffset(self, enable=True):
        """
        EnableOffset(enable=True)
        """

    def DisableOffset(self):
        """
        DisableOffset()
        """

    def OffsetEnabled(self):
        """
        OffsetEnabled() -> bool
        """

    def StartDoc(self, message):
        """
        StartDoc(message) -> bool
        
        Begin a new document (relevant only for printing / pdf etc.) If there
        is a progress dialog, message will be shown.
        """

    def EndDoc(self):
        """
        EndDoc()
        
        Done with that document (relevant only for printing / pdf etc.)
        """

    def StartPage(self, width=0, height=0):
        """
        StartPage(width=0, height=0)
        
        Opens a new page (relevant only for printing / pdf etc.) with the
        given size in points.
        """

    def EndPage(self):
        """
        EndPage()
        
        Ends the current page (relevant only for printing / pdf etc.)
        """

    def Flush(self):
        """
        Flush()
        
        Make sure that the current content of this context is immediately
        visible.
        """

    def GetSize(self):
        """
        GetSize() -> (width, height)
        
        Returns the size of the graphics context in device coordinates.
        """

    def GetDPI(self):
        """
        GetDPI() -> (dpiX, dpiY)
        
        Returns the resolution of the graphics context in device points per
        inch.
        """

    DrawRotatedText = wx.deprecated(DrawText, 'Use DrawText instead.')

    def StrokeLineSegments(self, beginPoint2Ds, endPoint2Ds):
        """
        StrokeLineSegments(beginPoint2Ds, endPoint2Ds)
        
        Stroke disconnected lines from begin to end points.
        """
    AntialiasMode = property(None, None)
    CompositionMode = property(None, None)
    InterpolationQuality = property(None, None)
    NativeContext = property(None, None)
    TextExtent = property(None, None)
    Transform = property(None, None)
# end of class GraphicsContext


class GraphicsGradientStop(object):
    """
    GraphicsGradientStop(col=TransparentColour, pos=0.)
    
    Represents a single gradient stop in a collection of gradient stops as
    represented by wxGraphicsGradientStops.
    """

    def __init__(self, col=TransparentColour, pos=0.):
        """
        GraphicsGradientStop(col=TransparentColour, pos=0.)
        
        Represents a single gradient stop in a collection of gradient stops as
        represented by wxGraphicsGradientStops.
        """

    def GetColour(self):
        """
        GetColour() -> Colour
        
        Return the stop colour.
        """

    def SetColour(self, col):
        """
        SetColour(col)
        
        Change the stop colour.
        """

    def GetPosition(self):
        """
        GetPosition() -> float
        
        Return the stop position.
        """

    def SetPosition(self, pos):
        """
        SetPosition(pos)
        
        Change the stop position.
        """
    Colour = property(None, None)
    Position = property(None, None)
# end of class GraphicsGradientStop


class GraphicsGradientStops(object):
    """
    GraphicsGradientStops(startCol=TransparentColour, endCol=TransparentColour)
    
    Represents a collection of wxGraphicGradientStop values for use with
    CreateLinearGradientBrush and CreateRadialGradientBrush.
    """

    def __init__(self, startCol=TransparentColour, endCol=TransparentColour):
        """
        GraphicsGradientStops(startCol=TransparentColour, endCol=TransparentColour)
        
        Represents a collection of wxGraphicGradientStop values for use with
        CreateLinearGradientBrush and CreateRadialGradientBrush.
        """

    def Add(self, *args, **kw):
        """
        Add(stop)
        Add(col, pos)
        
        Add a new stop.
        """

    def Item(self, n):
        """
        Item(n) -> GraphicsGradientStop
        
        Returns the stop at the given index.
        """

    def GetCount(self):
        """
        GetCount() -> size_t
        
        Returns the number of stops.
        """

    def SetStartColour(self, col):
        """
        SetStartColour(col)
        
        Set the start colour to col.
        """

    def GetStartColour(self):
        """
        GetStartColour() -> Colour
        
        Returns the start colour.
        """

    def SetEndColour(self, col):
        """
        SetEndColour(col)
        
        Set the end colour to col.
        """

    def GetEndColour(self):
        """
        GetEndColour() -> Colour
        
        Returns the end colour.
        """

    def __len__(self):
        """
        __len__() -> SIP_SSIZE_T
        """

    def __getitem__(self, n):
        """
        __getitem__(n)
        """
    Count = property(None, None)
    EndColour = property(None, None)
    StartColour = property(None, None)
# end of class GraphicsGradientStops


class GraphicsMatrix(GraphicsObject):
    """
    A wxGraphicsMatrix is a native representation of an affine matrix.
    """

    def Concat(self, t):
        """
        Concat(t)
        
        Concatenates the matrix passed with the current matrix.
        """

    def Get(self):
        """
        Get() -> (a, b, c, d, tx, ty)
        
        Returns the component values of the matrix via the argument pointers.
        """

    def GetNativeMatrix(self):
        """
        GetNativeMatrix() -> void
        
        Returns the native representation of the matrix.
        """

    def Invert(self):
        """
        Invert()
        
        Inverts the matrix.
        """

    def IsEqual(self, t):
        """
        IsEqual(t) -> bool
        
        Returns true if the elements of the transformation matrix are equal.
        """

    def IsIdentity(self):
        """
        IsIdentity() -> bool
        
        Return true if this is the identity matrix.
        """

    def Rotate(self, angle):
        """
        Rotate(angle)
        
        Rotates this matrix clockwise (in radians).
        """

    def Scale(self, xScale, yScale):
        """
        Scale(xScale, yScale)
        
        Scales this matrix.
        """

    def Set(self, a=1.0, b=0.0, c=0.0, d=1.0, tx=0.0, ty=0.0):
        """
        Set(a=1.0, b=0.0, c=0.0, d=1.0, tx=0.0, ty=0.0)
        
        Sets the matrix to the respective values (default values are the
        identity matrix).
        """

    def TransformDistance(self, dx, dy):
        """
        TransformDistance(dx, dy) -> (dx, dy)
        
        Applies this matrix to a distance (ie.
        """

    def TransformPoint(self, x, y):
        """
        TransformPoint(x, y) -> (x, y)
        
        Applies this matrix to a point.
        """

    def Translate(self, dx, dy):
        """
        Translate(dx, dy)
        
        Translates this matrix.
        """
    NativeMatrix = property(None, None)
# end of class GraphicsMatrix


class GraphicsPath(GraphicsObject):
    """
    A wxGraphicsPath is a native representation of a geometric path.
    """

    def AddArc(self, *args, **kw):
        """
        AddArc(x, y, r, startAngle, endAngle, clockwise)
        AddArc(c, r, startAngle, endAngle, clockwise)
        
        Adds an arc of a circle.
        """

    def AddArcToPoint(self, x1, y1, x2, y2, r):
        """
        AddArcToPoint(x1, y1, x2, y2, r)
        
        Appends a an arc to two tangents connecting (current) to (x1,y1) and
        (x1,y1) to (x2,y2), also a straight line from (current) to (x1,y1).
        """

    def AddCircle(self, x, y, r):
        """
        AddCircle(x, y, r)
        
        Appends a circle around (x,y) with radius r as a new closed subpath.
        """

    def AddCurveToPoint(self, *args, **kw):
        """
        AddCurveToPoint(cx1, cy1, cx2, cy2, x, y)
        AddCurveToPoint(c1, c2, e)
        
        Adds a cubic bezier curve from the current point, using two control
        points and an end point.
        """

    def AddEllipse(self, x, y, w, h):
        """
        AddEllipse(x, y, w, h)
        
        Appends an ellipse fitting into the passed in rectangle.
        """

    def AddLineToPoint(self, *args, **kw):
        """
        AddLineToPoint(x, y)
        AddLineToPoint(p)
        
        Adds a straight line from the current point to (x,y).
        """

    def AddPath(self, path):
        """
        AddPath(path)
        
        Adds another path.
        """

    def AddQuadCurveToPoint(self, cx, cy, x, y):
        """
        AddQuadCurveToPoint(cx, cy, x, y)
        
        Adds a quadratic bezier curve from the current point, using a control
        point and an end point.
        """

    def AddRectangle(self, x, y, w, h):
        """
        AddRectangle(x, y, w, h)
        
        Appends a rectangle as a new closed subpath.
        """

    def AddRoundedRectangle(self, x, y, w, h, radius):
        """
        AddRoundedRectangle(x, y, w, h, radius)
        
        Appends a rounded rectangle as a new closed subpath.
        """

    def CloseSubpath(self):
        """
        CloseSubpath()
        
        Closes the current sub-path.
        """

    def Contains(self, *args, **kw):
        """
        Contains(c, fillStyle=ODDEVEN_RULE) -> bool
        Contains(x, y, fillStyle=ODDEVEN_RULE) -> bool
        """

    def GetBox(self):
        """
        GetBox() -> Rect2D
        
        Gets the bounding box enclosing all points (possibly including control
        points).
        """

    def GetCurrentPoint(self):
        """
        GetCurrentPoint() -> Point2D
        
        Gets the last point of the current path, (0,0) if not yet set.
        """

    def GetNativePath(self):
        """
        GetNativePath() -> void
        
        Returns the native path (CGPathRef for Core Graphics, Path pointer for
        GDIPlus and a cairo_path_t pointer for cairo).
        """

    def MoveToPoint(self, *args, **kw):
        """
        MoveToPoint(x, y)
        MoveToPoint(p)
        
        Begins a new subpath at (x,y).
        """

    def Transform(self, matrix):
        """
        Transform(matrix)
        
        Transforms each point of this path by the matrix.
        """

    def UnGetNativePath(self, p):
        """
        UnGetNativePath(p)
        
        Gives back the native path returned by GetNativePath() because there
        might be some deallocations necessary (e.g.
        """
    Box = property(None, None)
    CurrentPoint = property(None, None)
    NativePath = property(None, None)
# end of class GraphicsPath


class GraphicsRenderer(Object):
    """
    A wxGraphicsRenderer is the instance corresponding to the rendering
    engine used.
    """

    def CreateBitmap(self, bitmap):
        """
        CreateBitmap(bitmap) -> GraphicsBitmap
        
        Creates wxGraphicsBitmap from an existing wxBitmap.
        """

    def CreateBitmapFromImage(self, image):
        """
        CreateBitmapFromImage(image) -> GraphicsBitmap
        
        Creates wxGraphicsBitmap from an existing wxImage.
        """

    def CreateImageFromBitmap(self, bmp):
        """
        CreateImageFromBitmap(bmp) -> Image
        
        Creates a wxImage from a wxGraphicsBitmap.
        """

    def CreateBitmapFromNativeBitmap(self, bitmap):
        """
        CreateBitmapFromNativeBitmap(bitmap) -> GraphicsBitmap
        
        Creates wxGraphicsBitmap from a native bitmap handle.
        """

    def CreateContext(self, *args, **kw):
        """
        CreateContext(window) -> GraphicsContext
        CreateContext(windowDC) -> GraphicsContext
        CreateContext(memoryDC) -> GraphicsContext
        CreateContext(printerDC) -> GraphicsContext
        
        Creates a wxGraphicsContext from a wxWindow.
        """

    def CreateContextFromImage(self, image):
        """
        CreateContextFromImage(image) -> GraphicsContext
        
        Creates a wxGraphicsContext associated with a wxImage.
        """

    def CreateBrush(self, brush):
        """
        CreateBrush(brush) -> GraphicsBrush
        
        Creates a native brush from a wxBrush.
        """

    def CreateContextFromNativeContext(self, context):
        """
        CreateContextFromNativeContext(context) -> GraphicsContext
        
        Creates a wxGraphicsContext from a native context.
        """

    def CreateContextFromNativeWindow(self, window):
        """
        CreateContextFromNativeWindow(window) -> GraphicsContext
        
        Creates a wxGraphicsContext from a native window.
        """

    def CreateMeasuringContext(self):
        """
        CreateMeasuringContext() -> GraphicsContext
        
        Creates a wxGraphicsContext that can be used for measuring texts only.
        """

    def CreateFont(self, *args, **kw):
        """
        CreateFont(font, col=BLACK) -> GraphicsFont
        CreateFont(sizeInPixels, facename, flags=FONTFLAG_DEFAULT, col=BLACK) -> GraphicsFont
        
        Creates a native graphics font from a wxFont and a text colour.
        """

    def CreateLinearGradientBrush(self, x1, y1, x2, y2, stops):
        """
        CreateLinearGradientBrush(x1, y1, x2, y2, stops) -> GraphicsBrush
        
        Creates a native brush with a linear gradient.
        """

    def CreateMatrix(self, a=1.0, b=0.0, c=0.0, d=1.0, tx=0.0, ty=0.0):
        """
        CreateMatrix(a=1.0, b=0.0, c=0.0, d=1.0, tx=0.0, ty=0.0) -> GraphicsMatrix
        
        Creates a native affine transformation matrix from the passed in
        values.
        """

    def CreatePath(self):
        """
        CreatePath() -> GraphicsPath
        
        Creates a native graphics path which is initially empty.
        """

    def CreatePen(self, pen):
        """
        CreatePen(pen) -> GraphicsPen
        
        Creates a native pen from a wxPen.
        """

    def CreateRadialGradientBrush(self, xo, yo, xc, yc, radius, stops):
        """
        CreateRadialGradientBrush(xo, yo, xc, yc, radius, stops) -> GraphicsBrush
        
        Creates a native brush with a radial gradient.
        """

    def CreateSubBitmap(self, bitmap, x, y, w, h):
        """
        CreateSubBitmap(bitmap, x, y, w, h) -> GraphicsBitmap
        
        Extracts a sub-bitmap from an existing bitmap.
        """

    @staticmethod
    def GetDefaultRenderer():
        """
        GetDefaultRenderer() -> GraphicsRenderer
        
        Returns the default renderer on this platform.
        """

    @staticmethod
    def GetCairoRenderer():
        """
        GetCairoRenderer() -> GraphicsRenderer
        """
# end of class GraphicsRenderer

NullGraphicsPen = GraphicsPen()
NullGraphicsBrush = GraphicsBrush()
NullGraphicsFont = GraphicsFont()
NullGraphicsBitmap = GraphicsBitmap()
NullGraphicsMatrix = GraphicsMatrix()
NullGraphicsPath = GraphicsPath()
#-- end-graphics --#
#-- begin-imaglist --#
IMAGELIST_DRAW_NORMAL = 0
IMAGELIST_DRAW_TRANSPARENT = 0
IMAGELIST_DRAW_SELECTED = 0
IMAGELIST_DRAW_FOCUSED = 0
IMAGE_LIST_NORMAL = 0
IMAGE_LIST_SMALL = 0
IMAGE_LIST_STATE = 0

class ImageList(Object):
    """
    ImageList()
    ImageList(width, height, mask=True, initialCount=1)
    
    A wxImageList contains a list of images, which are stored in an
    unspecified form.
    """

    def __init__(self, *args, **kw):
        """
        ImageList()
        ImageList(width, height, mask=True, initialCount=1)
        
        A wxImageList contains a list of images, which are stored in an
        unspecified form.
        """

    def Add(self, *args, **kw):
        """
        Add(bitmap, mask=NullBitmap) -> int
        Add(bitmap, maskColour) -> int
        Add(icon) -> int
        
        Adds a new image or images using a bitmap and optional mask bitmap.
        """

    def Create(self, width, height, mask=True, initialCount=1):
        """
        Create(width, height, mask=True, initialCount=1) -> bool
        
        Initializes the list.
        """

    def Draw(self, index, dc, x, y, flags=IMAGELIST_DRAW_NORMAL, solidBackground=False):
        """
        Draw(index, dc, x, y, flags=IMAGELIST_DRAW_NORMAL, solidBackground=False) -> bool
        
        Draws a specified image onto a device context.
        """

    def GetBitmap(self, index):
        """
        GetBitmap(index) -> Bitmap
        
        Returns the bitmap corresponding to the given index.
        """

    def GetIcon(self, index):
        """
        GetIcon(index) -> Icon
        
        Returns the icon corresponding to the given index.
        """

    def GetImageCount(self):
        """
        GetImageCount() -> int
        
        Returns the number of images in the list.
        """

    def GetSize(self, index):
        """
        GetSize(index) -> (width, height)
        
        Retrieves the size of the images in the list.
        """

    def Remove(self, index):
        """
        Remove(index) -> bool
        
        Removes the image at the given position.
        """

    def RemoveAll(self):
        """
        RemoveAll() -> bool
        
        Removes all the images in the list.
        """

    def Replace(self, *args, **kw):
        """
        Replace(index, bitmap, mask=NullBitmap) -> bool
        Replace(index, icon) -> bool
        
        Replaces the existing image with the new image.
        """
    ImageCount = property(None, None)
# end of class ImageList

#-- end-imaglist --#
#-- begin-overlay --#

class Overlay(object):
    """
    Overlay()
    
    Creates an overlay over an existing window, allowing for manipulations
    like rubberbanding, etc.
    """

    def __init__(self):
        """
        Overlay()
        
        Creates an overlay over an existing window, allowing for manipulations
        like rubberbanding, etc.
        """

    def Reset(self):
        """
        Reset()
        
        Clears the overlay without restoring the former state.
        """
# end of class Overlay


class DCOverlay(object):
    """
    DCOverlay(overlay, dc, x, y, width, height)
    DCOverlay(overlay, dc)
    
    Connects an overlay with a drawing DC.
    """

    def __init__(self, *args, **kw):
        """
        DCOverlay(overlay, dc, x, y, width, height)
        DCOverlay(overlay, dc)
        
        Connects an overlay with a drawing DC.
        """

    def Clear(self):
        """
        Clear()
        
        Clears the layer, restoring the state at the last init.
        """
# end of class DCOverlay

#-- end-overlay --#
#-- begin-palette --#

class Palette(GDIObject):
    """
    Palette()
    Palette(palette)
    Palette(red, green, blue)
    
    A palette is a table that maps pixel values to RGB colours.
    """

    def __init__(self, *args, **kw):
        """
        Palette()
        Palette(palette)
        Palette(red, green, blue)
        
        A palette is a table that maps pixel values to RGB colours.
        """

    def Create(self, red, green, blue):
        """
        Create(red, green, blue) -> bool
        
        Creates a palette from 3 sequences of integers, one for each red, blue
        or green component.
        
        :param red: A sequence of integer values in the range 0..255
        inclusive.
        :param green: A sequence of integer values in the range 0..255
        inclusive.
        :param blue: A sequence of integer values in the range 0..255
        inclusive.
        
        .. note:: All sequences must be the same length.
        """

    def GetColoursCount(self):
        """
        GetColoursCount() -> int
        
        Returns number of entries in palette.
        """

    def GetPixel(self, red, green, blue):
        """
        GetPixel(red, green, blue) -> int
        
        Returns a pixel value (index into the palette) for the given RGB
        values.
        """

    def GetRGB(self, pixel):
        """
        GetRGB(pixel) -> (red, green, blue)
        
        Returns RGB values for a given palette index.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if palette data is present.
        """
    ColoursCount = property(None, None)
    RGB = property(None, None)
# end of class Palette

NullPalette = Palette()
#-- end-palette --#
#-- begin-renderer --#
CONTROL_DISABLED = 0
CONTROL_FOCUSED = 0
CONTROL_PRESSED = 0
CONTROL_SPECIAL = 0
CONTROL_ISDEFAULT = 0
CONTROL_ISSUBMENU = 0
CONTROL_EXPANDED = 0
CONTROL_SIZEGRIP = 0
CONTROL_FLAT = 0
CONTROL_CURRENT = 0
CONTROL_SELECTED = 0
CONTROL_CHECKED = 0
CONTROL_CHECKABLE = 0
CONTROL_UNDETERMINED = 0
TITLEBAR_BUTTON_CLOSE = 0
TITLEBAR_BUTTON_MAXIMIZE = 0
TITLEBAR_BUTTON_ICONIZE = 0
TITLEBAR_BUTTON_RESTORE = 0
TITLEBAR_BUTTON_HELP = 0
HDR_SORT_ICON_NONE = 0
HDR_SORT_ICON_UP = 0
HDR_SORT_ICON_DOWN = 0

class SplitterRenderParams(object):
    """
    SplitterRenderParams(widthSash_, border_, isSens_)
    
    This is just a simple struct used as a return value of
    wxRendererNative::GetSplitterParams().
    """

    def __init__(self, widthSash_, border_, isSens_):
        """
        SplitterRenderParams(widthSash_, border_, isSens_)
        
        This is just a simple struct used as a return value of
        wxRendererNative::GetSplitterParams().
        """
    border = property(None, None)
    isHotSensitive = property(None, None)
    widthSash = property(None, None)
# end of class SplitterRenderParams


class HeaderButtonParams(object):
    """
    HeaderButtonParams()
    
    This struct can optionally be used with
    wxRendererNative::DrawHeaderButton() to specify custom values used to
    draw the text or bitmap label.
    """

    def __init__(self):
        """
        HeaderButtonParams()
        
        This struct can optionally be used with
        wxRendererNative::DrawHeaderButton() to specify custom values used to
        draw the text or bitmap label.
        """
    m_arrowColour = property(None, None)
    m_selectionColour = property(None, None)
    m_labelText = property(None, None)
    m_labelFont = property(None, None)
    m_labelColour = property(None, None)
    m_labelBitmap = property(None, None)
    m_labelAlignment = property(None, None)
# end of class HeaderButtonParams


class RendererNative(object):
    """
    First, a brief introduction to wxRendererNative and why it is needed.
    """

    def DrawCheckBox(self, win, dc, rect, flags=0):
        """
        DrawCheckBox(win, dc, rect, flags=0)
        
        Draw a check box.
        """

    def DrawComboBoxDropButton(self, win, dc, rect, flags=0):
        """
        DrawComboBoxDropButton(win, dc, rect, flags=0)
        
        Draw a button like the one used by wxComboBox to show a drop down
        window.
        """

    def DrawDropArrow(self, win, dc, rect, flags=0):
        """
        DrawDropArrow(win, dc, rect, flags=0)
        
        Draw a drop down arrow that is suitable for use outside a combo box.
        """

    def DrawFocusRect(self, win, dc, rect, flags=0):
        """
        DrawFocusRect(win, dc, rect, flags=0)
        
        Draw a focus rectangle using the specified rectangle.
        """

    def DrawHeaderButton(self, win, dc, rect, flags=0, sortArrow=HDR_SORT_ICON_NONE, params=None):
        """
        DrawHeaderButton(win, dc, rect, flags=0, sortArrow=HDR_SORT_ICON_NONE, params=None) -> int
        
        Draw the header control button (used, for example, by wxListCtrl).
        """

    def DrawHeaderButtonContents(self, win, dc, rect, flags=0, sortArrow=HDR_SORT_ICON_NONE, params=None):
        """
        DrawHeaderButtonContents(win, dc, rect, flags=0, sortArrow=HDR_SORT_ICON_NONE, params=None) -> int
        
        Draw the contents of a header control button (label, sort arrows,
        etc.).
        """

    def DrawItemSelectionRect(self, win, dc, rect, flags=0):
        """
        DrawItemSelectionRect(win, dc, rect, flags=0)
        
        Draw a selection rectangle underneath the text as used e.g.
        """

    def DrawPushButton(self, win, dc, rect, flags=0):
        """
        DrawPushButton(win, dc, rect, flags=0)
        
        Draw a blank push button that looks very similar to wxButton.
        """

    def DrawSplitterBorder(self, win, dc, rect, flags=0):
        """
        DrawSplitterBorder(win, dc, rect, flags=0)
        
        Draw the border for sash window: this border must be such that the
        sash drawn by DrawSplitterSash() blends into it well.
        """

    def DrawSplitterSash(self, win, dc, size, position, orient, flags=0):
        """
        DrawSplitterSash(win, dc, size, position, orient, flags=0)
        
        Draw a sash.
        """

    def DrawTreeItemButton(self, win, dc, rect, flags=0):
        """
        DrawTreeItemButton(win, dc, rect, flags=0)
        
        Draw the expanded/collapsed icon for a tree control item.
        """

    def DrawChoice(self, win, dc, rect, flags=0):
        """
        DrawChoice(win, dc, rect, flags=0)
        
        Draw a native wxChoice.
        """

    def DrawComboBox(self, win, dc, rect, flags=0):
        """
        DrawComboBox(win, dc, rect, flags=0)
        
        Draw a native wxComboBox.
        """

    def DrawTextCtrl(self, win, dc, rect, flags=0):
        """
        DrawTextCtrl(win, dc, rect, flags=0)
        
        Draw a native wxTextCtrl frame.
        """

    def DrawRadioBitmap(self, win, dc, rect, flags=0):
        """
        DrawRadioBitmap(win, dc, rect, flags=0)
        
        Draw a native wxRadioButton bitmap.
        """

    def DrawTitleBarBitmap(self, win, dc, rect, button, flags=0):
        """
        DrawTitleBarBitmap(win, dc, rect, button, flags=0)
        
        Draw a title bar button in the given state.
        """

    def GetCheckBoxSize(self, win):
        """
        GetCheckBoxSize(win) -> Size
        
        Returns the size of a check box.
        """

    def GetHeaderButtonHeight(self, win):
        """
        GetHeaderButtonHeight(win) -> int
        
        Returns the height of a header button, either a fixed platform height
        if available, or a generic height based on the win window's font.
        """

    def GetHeaderButtonMargin(self, win):
        """
        GetHeaderButtonMargin(win) -> int
        
        Returns the horizontal margin on the left and right sides of header
        button's label.
        """

    def GetSplitterParams(self, win):
        """
        GetSplitterParams(win) -> SplitterRenderParams
        
        Get the splitter parameters, see wxSplitterRenderParams.
        """

    def GetVersion(self):
        """
        GetVersion() -> RendererVersion
        
        This function is used for version checking: Load() refuses to load any
        shared libraries implementing an older or incompatible version.
        """

    @staticmethod
    def Get():
        """
        Get() -> RendererNative
        
        Return the currently used renderer.
        """

    @staticmethod
    def GetDefault():
        """
        GetDefault() -> RendererNative
        
        Return the default (native) implementation for this platform  this is
        also the one used by default but this may be changed by calling Set()
        in which case the return value of this method may be different from
        the return value of Get().
        """

    @staticmethod
    def GetGeneric():
        """
        GetGeneric() -> RendererNative
        
        Return the generic implementation of the renderer.
        """

    @staticmethod
    def Load(name):
        """
        Load(name) -> RendererNative
        
        Load the renderer from the specified DLL, the returned pointer must be
        deleted by caller if not NULL when it is not used any more.
        """

    @staticmethod
    def Set(renderer):
        """
        Set(renderer) -> RendererNative
        
        Set the renderer to use, passing NULL reverts to using the default
        renderer (the global renderer must always exist).
        """
    Version = property(None, None)
# end of class RendererNative


class DelegateRendererNative(RendererNative):
    """
    DelegateRendererNative()
    DelegateRendererNative(rendererNative)
    
    wxDelegateRendererNative allows reuse of renderers code by forwarding
    all the wxRendererNative methods to the given object and thus allowing
    you to only modify some of its methods  without having to reimplement
    all of them.
    """

    def __init__(self, *args, **kw):
        """
        DelegateRendererNative()
        DelegateRendererNative(rendererNative)
        
        wxDelegateRendererNative allows reuse of renderers code by forwarding
        all the wxRendererNative methods to the given object and thus allowing
        you to only modify some of its methods  without having to reimplement
        all of them.
        """

    def DrawHeaderButton(self, win, dc, rect, flags=0, sortArrow=HDR_SORT_ICON_NONE, params=None):
        """
        DrawHeaderButton(win, dc, rect, flags=0, sortArrow=HDR_SORT_ICON_NONE, params=None) -> int
        
        Draw the header control button (used, for example, by wxListCtrl).
        """

    def DrawHeaderButtonContents(self, win, dc, rect, flags=0, sortArrow=HDR_SORT_ICON_NONE, params=None):
        """
        DrawHeaderButtonContents(win, dc, rect, flags=0, sortArrow=HDR_SORT_ICON_NONE, params=None) -> int
        
        Draw the contents of a header control button (label, sort arrows,
        etc.).
        """

    def GetHeaderButtonHeight(self, win):
        """
        GetHeaderButtonHeight(win) -> int
        
        Returns the height of a header button, either a fixed platform height
        if available, or a generic height based on the win window's font.
        """

    def GetHeaderButtonMargin(self, win):
        """
        GetHeaderButtonMargin(win) -> int
        
        Returns the horizontal margin on the left and right sides of header
        button's label.
        """

    def DrawTreeItemButton(self, win, dc, rect, flags=0):
        """
        DrawTreeItemButton(win, dc, rect, flags=0)
        
        Draw the expanded/collapsed icon for a tree control item.
        """

    def DrawSplitterBorder(self, win, dc, rect, flags=0):
        """
        DrawSplitterBorder(win, dc, rect, flags=0)
        
        Draw the border for sash window: this border must be such that the
        sash drawn by DrawSplitterSash() blends into it well.
        """

    def DrawSplitterSash(self, win, dc, size, position, orient, flags=0):
        """
        DrawSplitterSash(win, dc, size, position, orient, flags=0)
        
        Draw a sash.
        """

    def DrawComboBoxDropButton(self, win, dc, rect, flags=0):
        """
        DrawComboBoxDropButton(win, dc, rect, flags=0)
        
        Draw a button like the one used by wxComboBox to show a drop down
        window.
        """

    def DrawDropArrow(self, win, dc, rect, flags=0):
        """
        DrawDropArrow(win, dc, rect, flags=0)
        
        Draw a drop down arrow that is suitable for use outside a combo box.
        """

    def DrawCheckBox(self, win, dc, rect, flags=0):
        """
        DrawCheckBox(win, dc, rect, flags=0)
        
        Draw a check box.
        """

    def GetCheckBoxSize(self, win):
        """
        GetCheckBoxSize(win) -> Size
        
        Returns the size of a check box.
        """

    def DrawPushButton(self, win, dc, rect, flags=0):
        """
        DrawPushButton(win, dc, rect, flags=0)
        
        Draw a blank push button that looks very similar to wxButton.
        """

    def DrawItemSelectionRect(self, win, dc, rect, flags=0):
        """
        DrawItemSelectionRect(win, dc, rect, flags=0)
        
        Draw a selection rectangle underneath the text as used e.g.
        """

    def DrawFocusRect(self, win, dc, rect, flags=0):
        """
        DrawFocusRect(win, dc, rect, flags=0)
        
        Draw a focus rectangle using the specified rectangle.
        """

    def GetSplitterParams(self, win):
        """
        GetSplitterParams(win) -> SplitterRenderParams
        
        Get the splitter parameters, see wxSplitterRenderParams.
        """

    def GetVersion(self):
        """
        GetVersion() -> RendererVersion
        
        This function is used for version checking: Load() refuses to load any
        shared libraries implementing an older or incompatible version.
        """
    Version = property(None, None)
# end of class DelegateRendererNative


class RendererVersion(object):
    """
    RendererVersion(version_, age_)
    
    This simple struct represents the wxRendererNative interface version
    and is only used as the return value of
    wxRendererNative::GetVersion().
    """

    def __init__(self, version_, age_):
        """
        RendererVersion(version_, age_)
        
        This simple struct represents the wxRendererNative interface version
        and is only used as the return value of
        wxRendererNative::GetVersion().
        """
    age = property(None, None)
    version = property(None, None)

    @staticmethod
    def IsCompatible(ver):
        """
        IsCompatible(ver) -> bool
        
        Checks if the main program is compatible with the renderer having the
        version ver, returns true if it is and false otherwise.
        """
# end of class RendererVersion

#-- end-renderer --#
#-- begin-rawbmp --#

class PixelDataBase(object):
    """
    PixelDataBase()
    """

    def GetOrigin(self):
        """
        GetOrigin() -> Point
        
        Return the origin of the area this pixel data represents.
        """

    def GetWidth(self):
        """
        GetWidth() -> int
        
        Return the width of the area this pixel data represents.
        """

    def GetHeight(self):
        """
        GetHeight() -> int
        
        Return the height of the area this pixel data represents.
        """

    def GetSize(self):
        """
        GetSize() -> Size
        
        Return the size of the area this pixel data represents.
        """

    def GetRowStride(self):
        """
        GetRowStride() -> int
        
        Returns the distance between the start of one row to the start of the
        next row.
        """

    def __iter__(self):
        """
        Create and return an iterator/generator object for traversing
        this pixel data object.
        """
    Height = property(None, None)
    Origin = property(None, None)
    RowStride = property(None, None)
    Size = property(None, None)
    Width = property(None, None)

    def wxPixelDataBase(self):
        """
        """
# end of class PixelDataBase


class NativePixelData(PixelDataBase):
    """
    NativePixelData(bmp)
    NativePixelData(bmp, rect)
    NativePixelData(bmp, pt, sz)
    
    A class providing direct access to a :class:`wx.Bitmap`'s
    internal data without alpha channel (RGB).
    """

    def __init__(self, *args, **kw):
        """
        NativePixelData(bmp)
        NativePixelData(bmp, rect)
        NativePixelData(bmp, pt, sz)
        
        A class providing direct access to a :class:`wx.Bitmap`'s
        internal data without alpha channel (RGB).
        """

    def GetPixels(self):
        """
        GetPixels() -> NativePixelData_Accessor
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """
    Pixels = property(None, None)
# end of class NativePixelData


class NativePixelData_Accessor(object):
    """
    NativePixelData_Accessor(data)
    NativePixelData_Accessor(bmp, data)
    NativePixelData_Accessor()
    """

    def __init__(self, *args, **kw):
        """
        NativePixelData_Accessor(data)
        NativePixelData_Accessor(bmp, data)
        NativePixelData_Accessor()
        """

    def Reset(self, data):
        """
        Reset(data)
        """

    def IsOk(self):
        """
        IsOk() -> bool
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """

    def Offset(self, data, x, y):
        """
        Offset(data, x, y)
        """

    def OffsetX(self, data, x):
        """
        OffsetX(data, x)
        """

    def OffsetY(self, data, y):
        """
        OffsetY(data, y)
        """

    def MoveTo(self, data, x, y):
        """
        MoveTo(data, x, y)
        """

    def nextPixel(self):
        """
        nextPixel()
        """

    def Set(self, red, green, blue):
        """
        Set(red, green, blue)
        """

    def Get(self):
        """
        Get() -> PyObject
        """
# end of class NativePixelData_Accessor


class AlphaPixelData(PixelDataBase):
    """
    AlphaPixelData(bmp)
    AlphaPixelData(bmp, rect)
    AlphaPixelData(bmp, pt, sz)
    
    A class providing direct access to a :class:`wx.Bitmap`'s
    internal data including the alpha channel (RGBA).
    """

    def __init__(self, *args, **kw):
        """
        AlphaPixelData(bmp)
        AlphaPixelData(bmp, rect)
        AlphaPixelData(bmp, pt, sz)
        
        A class providing direct access to a :class:`wx.Bitmap`'s
        internal data including the alpha channel (RGBA).
        """

    def GetPixels(self):
        """
        GetPixels() -> AlphaPixelData_Accessor
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """
    Pixels = property(None, None)
# end of class AlphaPixelData


class AlphaPixelData_Accessor(object):
    """
    AlphaPixelData_Accessor(data)
    AlphaPixelData_Accessor(bmp, data)
    AlphaPixelData_Accessor()
    """

    def __init__(self, *args, **kw):
        """
        AlphaPixelData_Accessor(data)
        AlphaPixelData_Accessor(bmp, data)
        AlphaPixelData_Accessor()
        """

    def Reset(self, data):
        """
        Reset(data)
        """

    def IsOk(self):
        """
        IsOk() -> bool
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """

    def Offset(self, data, x, y):
        """
        Offset(data, x, y)
        """

    def OffsetX(self, data, x):
        """
        OffsetX(data, x)
        """

    def OffsetY(self, data, y):
        """
        OffsetY(data, y)
        """

    def MoveTo(self, data, x, y):
        """
        MoveTo(data, x, y)
        """

    def nextPixel(self):
        """
        nextPixel()
        """

    def Set(self, red, green, blue, alpha):
        """
        Set(red, green, blue, alpha)
        """

    def Get(self):
        """
        Get() -> PyObject
        """
# end of class AlphaPixelData_Accessor

#-- end-rawbmp --#
#-- begin-accel --#
ACCEL_NORMAL = 0
ACCEL_ALT = 0
ACCEL_CTRL = 0
ACCEL_SHIFT = 0
ACCEL_RAW_CTRL = 0
ACCEL_CMD = 0

class AcceleratorEntry(object):
    """
    AcceleratorEntry(flags=0, keyCode=0, cmd=0, item=None)
    AcceleratorEntry(entry)
    
    An object used by an application wishing to create an accelerator
    table (see wxAcceleratorTable).
    """

    def __init__(self, *args, **kw):
        """
        AcceleratorEntry(flags=0, keyCode=0, cmd=0, item=None)
        AcceleratorEntry(entry)
        
        An object used by an application wishing to create an accelerator
        table (see wxAcceleratorTable).
        """

    def GetCommand(self):
        """
        GetCommand() -> int
        
        Returns the command identifier for the accelerator table entry.
        """

    def GetFlags(self):
        """
        GetFlags() -> int
        
        Returns the flags for the accelerator table entry.
        """

    def GetKeyCode(self):
        """
        GetKeyCode() -> int
        
        Returns the keycode for the accelerator table entry.
        """

    def GetMenuItem(self):
        """
        GetMenuItem() -> MenuItem
        
        Returns the menu item associated with this accelerator entry.
        """

    def Set(self, flags, keyCode, cmd, item=None):
        """
        Set(flags, keyCode, cmd, item=None)
        
        Sets the accelerator entry parameters.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if this object is correctly initialized.
        """

    def ToString(self):
        """
        ToString() -> String
        
        Returns a textual representation of this accelerator.
        """

    def ToRawString(self):
        """
        ToRawString() -> String
        
        Returns a textual representation of this accelerator which is
        appropriate for saving in configuration files.
        """

    def FromString(self, str):
        """
        FromString(str) -> bool
        
        Parses the given string and sets the accelerator accordingly.
        """

    def __eq__(self):
        """
        """

    def __ne__(self):
        """
        """
    Command = property(None, None)
    Flags = property(None, None)
    KeyCode = property(None, None)
    MenuItem = property(None, None)
# end of class AcceleratorEntry


class AcceleratorTable(Object):
    """
    AcceleratorTable()
    AcceleratorTable(entries)
    
    An accelerator table allows the application to specify a table of
    keyboard shortcuts for menu or button commands.
    """

    def __init__(self, *args, **kw):
        """
        AcceleratorTable()
        AcceleratorTable(entries)
        
        An accelerator table allows the application to specify a table of
        keyboard shortcuts for menu or button commands.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if the accelerator table is valid.
        """
# end of class AcceleratorTable

NullAcceleratorTable = AcceleratorTable()

@wx.deprecated
def GetAccelFromString(label):
    pass
#-- end-accel --#
#-- begin-log --#
LOG_FatalError = 0
LOG_Error = 0
LOG_Warning = 0
LOG_Message = 0
LOG_Status = 0
LOG_Info = 0
LOG_Debug = 0
LOG_Trace = 0
LOG_Progress = 0
LOG_User = 0
LOG_Max = 0

class Log(object):
    """
    wxLog class defines the interface for the log targets used by
    wxWidgets logging functions as explained in the Logging Overview.
    """

    @staticmethod
    def AddTraceMask(mask):
        """
        AddTraceMask(mask)
        
        Add the mask to the list of allowed masks for wxLogTrace().
        """

    @staticmethod
    def ClearTraceMasks():
        """
        ClearTraceMasks()
        
        Removes all trace masks previously set with AddTraceMask().
        """

    @staticmethod
    def GetTraceMasks():
        """
        GetTraceMasks() -> ArrayString
        
        Returns the currently allowed list of string trace masks.
        """

    @staticmethod
    def IsAllowedTraceMask(mask):
        """
        IsAllowedTraceMask(mask) -> bool
        
        Returns true if the mask is one of allowed masks for wxLogTrace().
        """

    @staticmethod
    def RemoveTraceMask(mask):
        """
        RemoveTraceMask(mask)
        
        Remove the mask from the list of allowed masks for wxLogTrace().
        """

    @staticmethod
    def DontCreateOnDemand():
        """
        DontCreateOnDemand()
        
        Instructs wxLog to not create new log targets on the fly if there is
        none currently (see GetActiveTarget()).
        """

    @staticmethod
    def GetActiveTarget():
        """
        GetActiveTarget() -> Log
        
        Returns the pointer to the active log target (may be NULL).
        """

    @staticmethod
    def SetActiveTarget(logtarget):
        """
        SetActiveTarget(logtarget) -> Log
        
        Sets the specified log target as the active one.
        """

    @staticmethod
    def SetThreadActiveTarget(logger):
        """
        SetThreadActiveTarget(logger) -> Log
        
        Sets a thread-specific log target.
        """

    @staticmethod
    def FlushActive():
        """
        FlushActive()
        
        Flushes the current log target if any, does nothing if there is none.
        """

    @staticmethod
    def Resume():
        """
        Resume()
        
        Resumes logging previously suspended by a call to Suspend().
        """

    @staticmethod
    def Suspend():
        """
        Suspend()
        
        Suspends the logging until Resume() is called.
        """

    @staticmethod
    def GetLogLevel():
        """
        GetLogLevel() -> LogLevel
        
        Returns the current log level limit.
        """

    @staticmethod
    def IsLevelEnabled(level, component):
        """
        IsLevelEnabled(level, component) -> bool
        
        Returns true if logging at this level is enabled for the current
        thread.
        """

    @staticmethod
    def SetComponentLevel(component, level):
        """
        SetComponentLevel(component, level)
        
        Sets the log level for the given component.
        """

    @staticmethod
    def SetLogLevel(logLevel):
        """
        SetLogLevel(logLevel)
        
        Specifies that log messages with level greater (numerically) than
        logLevel should be ignored and not sent to the active log target.
        """

    @staticmethod
    def EnableLogging(enable=True):
        """
        EnableLogging(enable=True) -> bool
        
        Globally enable or disable logging.
        """

    @staticmethod
    def IsEnabled():
        """
        IsEnabled() -> bool
        
        Returns true if logging is enabled at all now.
        """

    @staticmethod
    def GetRepetitionCounting():
        """
        GetRepetitionCounting() -> bool
        
        Returns whether the repetition counting mode is enabled.
        """

    @staticmethod
    def SetRepetitionCounting(repetCounting=True):
        """
        SetRepetitionCounting(repetCounting=True)
        
        Enables logging mode in which a log message is logged once, and in
        case exactly the same message successively repeats one or more times,
        only the number of repetitions is logged.
        """

    @staticmethod
    def GetTimestamp():
        """
        GetTimestamp() -> String
        
        Returns the current timestamp format string.
        """

    @staticmethod
    def SetTimestamp(format):
        """
        SetTimestamp(format)
        
        Sets the timestamp format prepended by the default log targets to all
        messages.
        """

    @staticmethod
    def DisableTimestamp():
        """
        DisableTimestamp()
        
        Disables time stamping of the log messages.
        """

    @staticmethod
    def GetVerbose():
        """
        GetVerbose() -> bool
        
        Returns whether the verbose mode is currently active.
        """

    @staticmethod
    def SetVerbose(verbose=True):
        """
        SetVerbose(verbose=True)
        
        Activates or deactivates verbose mode in which the verbose messages
        are logged as the normal ones instead of being silently dropped.
        """

    def SetFormatter(self, formatter):
        """
        SetFormatter(formatter) -> LogFormatter
        
        Sets the specified formatter as the active one.
        """

    def Flush(self):
        """
        Flush()
        
        Some of wxLog implementations, most notably the standard wxLogGui
        class, buffer the messages (for example, to avoid showing the user a
        zillion of modal message boxes one after another  which would be
        really annoying).
        """

    def LogRecord(self, level, msg, info):
        """
        LogRecord(level, msg, info)
        
        Log the given record.
        """

    def DoLogRecord(self, level, msg, info):
        """
        DoLogRecord(level, msg, info)
        
        Called to log a new record.
        """

    def DoLogTextAtLevel(self, level, msg):
        """
        DoLogTextAtLevel(level, msg)
        
        Called to log the specified string at given level.
        """

    def DoLogText(self, msg):
        """
        DoLogText(msg)
        
        Called to log the specified string.
        """
# end of class Log


class LogGui(Log):
    """
    LogGui()
    
    This is the default log target for the GUI wxWidgets applications.
    """

    def __init__(self):
        """
        LogGui()
        
        This is the default log target for the GUI wxWidgets applications.
        """

    def Flush(self):
        """
        Flush()
        
        Presents the accumulated log messages, if any, to the user.
        """
# end of class LogGui


class LogNull(object):
    """
    LogNull()
    
    This class allows you to temporarily suspend logging.
    """

    def __init__(self):
        """
        LogNull()
        
        This class allows you to temporarily suspend logging.
        """
# end of class LogNull


class LogRecordInfo(object):
    """
    Information about a log record (unit of the log output).
    """
    filename = property(None, None)
    line = property(None, None)
    func = property(None, None)
    timestamp = property(None, None)
# end of class LogRecordInfo


class LogChain(Log):
    """
    LogChain(logger)
    
    This simple class allows you to chain log sinks, that is to install a
    new sink but keep passing log messages to the old one instead of
    replacing it completely as wxLog::SetActiveTarget does.
    """

    def __init__(self, logger):
        """
        LogChain(logger)
        
        This simple class allows you to chain log sinks, that is to install a
        new sink but keep passing log messages to the old one instead of
        replacing it completely as wxLog::SetActiveTarget does.
        """

    def DetachOldLog(self):
        """
        DetachOldLog()
        
        Detaches the old log target so it won't be destroyed when the
        wxLogChain object is destroyed.
        """

    def GetOldLog(self):
        """
        GetOldLog() -> Log
        
        Returns the pointer to the previously active log target (which may be
        NULL).
        """

    def IsPassingMessages(self):
        """
        IsPassingMessages() -> bool
        
        Returns true if the messages are passed to the previously active log
        target (default) or false if PassMessages() had been called.
        """

    def PassMessages(self, passMessages):
        """
        PassMessages(passMessages)
        
        By default, the log messages are passed to the previously active log
        target.
        """

    def SetLog(self, logger):
        """
        SetLog(logger)
        
        Sets another log target to use (may be NULL).
        """
    OldLog = property(None, None)
# end of class LogChain


class LogInterposer(LogChain):
    """
    LogInterposer()
    
    A special version of wxLogChain which uses itself as the new log
    target.
    """

    def __init__(self):
        """
        LogInterposer()
        
        A special version of wxLogChain which uses itself as the new log
        target.
        """
# end of class LogInterposer


class LogInterposerTemp(LogChain):
    """
    LogInterposerTemp()
    
    A special version of wxLogChain which uses itself as the new log
    target.
    """

    def __init__(self):
        """
        LogInterposerTemp()
        
        A special version of wxLogChain which uses itself as the new log
        target.
        """
# end of class LogInterposerTemp


class LogWindow(LogInterposer):
    """
    LogWindow(pParent, szTitle, show=True, passToOld=True)
    
    This class represents a background log window: to be precise, it
    collects all log messages in the log frame which it manages but also
    passes them on to the log target which was active at the moment of its
    creation.
    """

    def __init__(self, pParent, szTitle, show=True, passToOld=True):
        """
        LogWindow(pParent, szTitle, show=True, passToOld=True)
        
        This class represents a background log window: to be precise, it
        collects all log messages in the log frame which it manages but also
        passes them on to the log target which was active at the moment of its
        creation.
        """

    def GetFrame(self):
        """
        GetFrame() -> Frame
        
        Returns the associated log frame window.
        """

    def OnFrameClose(self, frame):
        """
        OnFrameClose(frame) -> bool
        
        Called if the user closes the window interactively, will not be called
        if it is destroyed for another reason (such as when program exits).
        """

    def OnFrameDelete(self, frame):
        """
        OnFrameDelete(frame)
        
        Called right before the log frame is going to be deleted: will always
        be called unlike OnFrameClose().
        """

    def Show(self, show=True):
        """
        Show(show=True)
        
        Shows or hides the frame.
        """
    Frame = property(None, None)
# end of class LogWindow


class LogStderr(Log):
    """
    LogStderr()
    
    This class can be used to redirect the log messages to a C file stream
    (not to be confused with C++ streams).
    """

    def __init__(self):
        """
        LogStderr()
        
        This class can be used to redirect the log messages to a C file stream
        (not to be confused with C++ streams).
        """
# end of class LogStderr


class LogBuffer(Log):
    """
    LogBuffer()
    
    wxLogBuffer is a very simple implementation of log sink which simply
    collects all the logged messages in a string (except the debug
    messages which are output in the usual way immediately as we're
    presumably not interested in collecting them for later).
    """

    def __init__(self):
        """
        LogBuffer()
        
        wxLogBuffer is a very simple implementation of log sink which simply
        collects all the logged messages in a string (except the debug
        messages which are output in the usual way immediately as we're
        presumably not interested in collecting them for later).
        """

    def Flush(self):
        """
        Flush()
        
        Shows all the messages collected so far to the user (using a message
        box in the GUI applications or by printing them out to the console in
        text mode) and clears the internal buffer.
        """

    def GetBuffer(self):
        """
        GetBuffer() -> String
        
        Returns the current buffer contains.
        """
    Buffer = property(None, None)
# end of class LogBuffer


class LogTextCtrl(Log):
    """
    LogTextCtrl(pTextCtrl)
    
    Using these target all the log messages can be redirected to a text
    control.
    """

    def __init__(self, pTextCtrl):
        """
        LogTextCtrl(pTextCtrl)
        
        Using these target all the log messages can be redirected to a text
        control.
        """
# end of class LogTextCtrl


class LogFormatter(object):
    """
    LogFormatter()
    
    wxLogFormatter class is used to format the log messages.
    """

    def __init__(self):
        """
        LogFormatter()
        
        wxLogFormatter class is used to format the log messages.
        """

    def Format(self, level, msg, info):
        """
        Format(level, msg, info) -> String
        
        This function creates the full log message string.
        """

    def FormatTime(self, time):
        """
        FormatTime(time) -> String
        
        This function formats the time stamp part of the log message.
        """
# end of class LogFormatter


def SafeShowMessage(title, text):
    """
    SafeShowMessage(title, text)
    
    This function shows a message to the user in a safe way and should be
    safe to call even before the application has been initialized or if it
    is currently in some other strange state (for example, about to
    crash).
    """

def SysErrorCode():
    """
    SysErrorCode() -> unsignedlong
    
    Returns the error code from the last system call.
    """

def SysErrorMsg(errCode=0):
    """
    SysErrorMsg(errCode=0) -> String
    
    Returns the error message corresponding to the given system error
    code.
    """

def LogGeneric(level, message):
    """
    LogGeneric(level, message)
    
    Logs a message with the given wxLogLevel.
    """

def LogMessage(message):
    """
    LogMessage(message)
    
    For all normal, informational messages.
    """

def LogVerbose(message):
    """
    LogVerbose(message)
    
    For verbose output.
    """

def LogWarning(message):
    """
    LogWarning(message)
    
    For warnings - they are also normally shown to the user, but don't
    interrupt the program work.
    """

def LogFatalError(message):
    """
    LogFatalError(message)
    
    Like wxLogError(), but also terminates the program with the exit code
    3.
    """

def LogError(message):
    """
    LogError(message)
    
    The functions to use for error messages, i.e.
    """

def LogDebug(message):
    """
    LogDebug(message)
    
    The right functions for debug output.
    """

def LogStatus(*args, **kw):
    """
    LogStatus(frame, message)
    LogStatus(message)
    
    Messages logged by this function will appear in the statusbar of the
    frame or of the top level application window by default (i.e.
    """

def LogSysError(message):
    """
    LogSysError(message)
    
    Mostly used by wxWidgets itself, but might be handy for logging errors
    after system call (API function) failure.
    """
#-- end-log --#
#-- begin-dataobj --#

class DataFormat(object):
    """
    DataFormat(format=DF_INVALID)
    DataFormat(format)
    
    A wxDataFormat is an encapsulation of a platform-specific format
    handle which is used by the system for the clipboard and drag and drop
    operations.
    """

    def __init__(self, *args, **kw):
        """
        DataFormat(format=DF_INVALID)
        DataFormat(format)
        
        A wxDataFormat is an encapsulation of a platform-specific format
        handle which is used by the system for the clipboard and drag and drop
        operations.
        """

    def GetId(self):
        """
        GetId() -> String
        
        Returns the name of a custom format (this function will fail for a
        standard format).
        """

    def GetType(self):
        """
        GetType() -> DataFormatId
        
        Returns the platform-specific number identifying the format.
        """

    def SetId(self, format):
        """
        SetId(format)
        
        Sets the format to be the custom format identified by the given name.
        """

    def SetType(self, type):
        """
        SetType(type)
        
        Sets the format to the given value, which should be one of wxDF_XXX
        constants.
        """

    def __ne__(self, *args, **kw):
        """
        """

    def __eq__(self, *args, **kw):
        """
        """
    Id = property(None, None)
    Type = property(None, None)
# end of class DataFormat

FormatInvalid = DataFormat()

class DataObject(object):
    """
    DataObject()
    
    A wxDataObject represents data that can be copied to or from the
    clipboard, or dragged and dropped.
    """
    Get = 0
    Set = 0
    Both = 0

    def __init__(self):
        """
        DataObject()
        
        A wxDataObject represents data that can be copied to or from the
        clipboard, or dragged and dropped.
        """

    def GetAllFormats(self, dir=Get):
        """
        GetAllFormats(dir=Get)
        
        Returns a list of wx.DataFormat objects which this data object
        supports transfering in the given direction.
        """

    def GetDataHere(self, format, buf):
        """
        GetDataHere(format, buf) -> bool
        
        Copies this data object's data in the requested format to the buffer
        provided.
        """

    def GetDataSize(self, format):
        """
        GetDataSize(format) -> size_t
        
        Returns the data size of the given format format.
        """

    def GetFormatCount(self, dir=Get):
        """
        GetFormatCount(dir=Get) -> size_t
        
        Returns the number of available formats for rendering or setting the
        data.
        """

    def GetPreferredFormat(self, dir=Get):
        """
        GetPreferredFormat(dir=Get) -> DataFormat
        
        Returns the preferred format for either rendering the data (if dir is
        Get, its default value) or for setting it.
        """

    def SetData(self, format, buf):
        """
        SetData(format, buf) -> bool
        
        Copies data from the provided buffer to this data object for the
        specified format.
        """

    def IsSupported(self, format, dir=Get):
        """
        IsSupported(format, dir=Get) -> bool
        
        Returns true if this format is supported.
        """

    def _testGetAllFormats(self):
        """
        _testGetAllFormats()
        """
    AllFormats = property(None, None)
    DataHere = property(None, None)
    FormatCount = property(None, None)
    PreferredFormat = property(None, None)
# end of class DataObject


class DataObjectSimple(DataObject):
    """
    DataObjectSimple(format=FormatInvalid)
    DataObjectSimple(formatName)
    
    This is the simplest possible implementation of the wxDataObject
    class.
    """

    def __init__(self, *args, **kw):
        """
        DataObjectSimple(format=FormatInvalid)
        DataObjectSimple(formatName)
        
        This is the simplest possible implementation of the wxDataObject
        class.
        """

    def GetDataHere(self, buf):
        """
        GetDataHere(buf) -> bool
        
        Copies this data object's data bytes to the given buffer
        """

    def GetDataSize(self):
        """
        GetDataSize() -> size_t
        
        Gets the size of our data.
        """

    def GetFormat(self):
        """
        GetFormat() -> DataFormat
        
        Returns the (one and only one) format supported by this object.
        """

    def SetData(self, *args, **kw):
        """
        SetData(buf) -> bool
        SetData(format, buf) -> bool
        
        Copies data from the provided buffer to this data object.
        """

    def SetFormat(self, format):
        """
        SetFormat(format)
        
        Sets the supported format.
        """

    def GetAllFormats(self, dir=DataObject.Get):
        """
        GetAllFormats(dir=DataObject.Get)
        
        Returns a list of wx.DataFormat objects which this data object
        supports transfering in the given direction.
        """
    AllFormats = property(None, None)
    DataHere = property(None, None)
    DataSize = property(None, None)
    Format = property(None, None)
# end of class DataObjectSimple


class CustomDataObject(DataObjectSimple):
    """
    CustomDataObject(format=FormatInvalid)
    CustomDataObject(formatName)
    
    wxCustomDataObject is a specialization of wxDataObjectSimple for some
    application-specific data in arbitrary (either custom or one of the
    standard ones).
    """

    def __init__(self, *args, **kw):
        """
        CustomDataObject(format=FormatInvalid)
        CustomDataObject(formatName)
        
        wxCustomDataObject is a specialization of wxDataObjectSimple for some
        application-specific data in arbitrary (either custom or one of the
        standard ones).
        """

    def GetData(self):
        """
        GetData() -> PyObject
        
        Returns a reference to the data buffer.
        """

    def GetSize(self):
        """
        GetSize() -> size_t
        
        Returns the data size in bytes.
        """

    def SetData(self, *args, **kw):
        """
        SetData(buf) -> bool
        SetData(format, buf) -> bool
        
        Copies data from the provided buffer to this data object's buffer
        """

    def GetAllFormats(self, dir=DataObject.Get):
        """
        GetAllFormats(dir=DataObject.Get)
        
        Returns a list of wx.DataFormat objects which this data object
        supports transfering in the given direction.
        """
    AllFormats = property(None, None)
    Data = property(None, None)
    Size = property(None, None)
# end of class CustomDataObject


class DataObjectComposite(DataObject):
    """
    DataObjectComposite()
    
    wxDataObjectComposite is the simplest wxDataObject derivation which
    may be used to support multiple formats.
    """

    def __init__(self):
        """
        DataObjectComposite()
        
        wxDataObjectComposite is the simplest wxDataObject derivation which
        may be used to support multiple formats.
        """

    def Add(self, dataObject, preferred=False):
        """
        Add(dataObject, preferred=False)
        
        Adds the dataObject to the list of supported objects and it becomes
        the preferred object if preferred is true.
        """

    def GetReceivedFormat(self):
        """
        GetReceivedFormat() -> DataFormat
        
        Report the format passed to the SetData() method.
        """

    def GetObject(self, format, dir=DataObject.Get):
        """
        GetObject(format, dir=DataObject.Get) -> DataObjectSimple
        
        Returns the pointer to the object which supports the passed format for
        the specified direction.
        """

    def GetAllFormats(self, dir=DataObject.Get):
        """
        GetAllFormats(dir=DataObject.Get)
        
        Returns a list of wx.DataFormat objects which this data object
        supports transfering in the given direction.
        """

    def SetData(self, format, buf):
        """
        SetData(format, buf) -> bool
        """
    AllFormats = property(None, None)
    ReceivedFormat = property(None, None)
# end of class DataObjectComposite


class BitmapDataObject(DataObjectSimple):
    """
    BitmapDataObject(bitmap=NullBitmap)
    
    wxBitmapDataObject is a specialization of wxDataObject for bitmap
    data.
    """

    def __init__(self, bitmap=NullBitmap):
        """
        BitmapDataObject(bitmap=NullBitmap)
        
        wxBitmapDataObject is a specialization of wxDataObject for bitmap
        data.
        """

    def GetBitmap(self):
        """
        GetBitmap() -> Bitmap
        
        Returns the bitmap associated with the data object.
        """

    def SetBitmap(self, bitmap):
        """
        SetBitmap(bitmap)
        
        Sets the bitmap associated with the data object.
        """

    def GetAllFormats(self, dir=DataObject.Get):
        """
        GetAllFormats(dir=DataObject.Get)
        
        Returns a list of wx.DataFormat objects which this data object
        supports transfering in the given direction.
        """

    def SetData(self, format, buf):
        """
        SetData(format, buf) -> bool
        """
    AllFormats = property(None, None)
    Bitmap = property(None, None)
# end of class BitmapDataObject


class TextDataObject(DataObjectSimple):
    """
    TextDataObject(text=EmptyString)
    
    wxTextDataObject is a specialization of wxDataObjectSimple for text
    data.
    """

    def __init__(self, text=EmptyString):
        """
        TextDataObject(text=EmptyString)
        
        wxTextDataObject is a specialization of wxDataObjectSimple for text
        data.
        """

    def GetText(self):
        """
        GetText() -> String
        
        Returns the text associated with the data object.
        """

    def GetTextLength(self):
        """
        GetTextLength() -> size_t
        
        Returns the data size.
        """

    def GetFormatCount(self, dir=DataObject.Get):
        """
        GetFormatCount(dir=DataObject.Get) -> size_t
        
        Returns 2 under wxMac and wxGTK, where text data coming from the
        clipboard may be provided as ANSI (wxDF_TEXT) or as Unicode text
        (wxDF_UNICODETEXT, but only when wxUSE_UNICODE==1).
        """

    def GetFormat(self):
        """
        GetFormat() -> DataFormat
        
        Returns the preferred format supported by this object.
        """

    def GetAllFormats(self, dir=DataObject.Get):
        """
        GetAllFormats(dir=DataObject.Get)
        
        Returns a list of wx.DataFormat objects which this data object
        supports transfering in the given direction.
        """

    def SetText(self, strText):
        """
        SetText(strText)
        
        Sets the text associated with the data object.
        """

    def SetData(self, format, buf):
        """
        SetData(format, buf) -> bool
        """
    AllFormats = property(None, None)
    Format = property(None, None)
    FormatCount = property(None, None)
    Text = property(None, None)
    TextLength = property(None, None)
# end of class TextDataObject


class URLDataObject(DataObject):
    """
    URLDataObject(url=EmptyString)
    
    wxURLDataObject is a wxDataObject containing an URL and can be used
    e.g.
    """

    def __init__(self, url=EmptyString):
        """
        URLDataObject(url=EmptyString)
        
        wxURLDataObject is a wxDataObject containing an URL and can be used
        e.g.
        """

    def GetURL(self):
        """
        GetURL() -> String
        
        Returns the URL stored by this object, as a string.
        """

    def SetURL(self, url):
        """
        SetURL(url)
        
        Sets the URL stored by this object.
        """

    def GetAllFormats(self, dir=DataObject.Get):
        """
        GetAllFormats(dir=DataObject.Get)
        
        Returns a list of wx.DataFormat objects which this data object
        supports transfering in the given direction.
        """

    def SetData(self, format, buf):
        """
        SetData(format, buf) -> bool
        """
    AllFormats = property(None, None)
    URL = property(None, None)
# end of class URLDataObject


class FileDataObject(DataObjectSimple):
    """
    FileDataObject()
    
    wxFileDataObject is a specialization of wxDataObject for file names.
    """

    def __init__(self):
        """
        FileDataObject()
        
        wxFileDataObject is a specialization of wxDataObject for file names.
        """

    def AddFile(self, file):
        """
        AddFile(file)
        
        Adds a file to the file list represented by this data object (Windows
        only).
        """

    def GetFilenames(self):
        """
        GetFilenames() -> ArrayString
        
        Returns the array of file names.
        """

    def GetAllFormats(self, dir=DataObject.Get):
        """
        GetAllFormats(dir=DataObject.Get)
        
        Returns a list of wx.DataFormat objects which this data object
        supports transfering in the given direction.
        """

    def SetData(self, format, buf):
        """
        SetData(format, buf) -> bool
        """
    AllFormats = property(None, None)
    Filenames = property(None, None)
# end of class FileDataObject


class HTMLDataObject(DataObjectSimple):
    """
    HTMLDataObject(html=EmptyString)
    
    wxHTMLDataObject is used for working with HTML-formatted text.
    """

    def __init__(self, html=EmptyString):
        """
        HTMLDataObject(html=EmptyString)
        
        wxHTMLDataObject is used for working with HTML-formatted text.
        """

    def GetHTML(self):
        """
        GetHTML() -> String
        
        Returns the HTML string.
        """

    def SetHTML(self, html):
        """
        SetHTML(html)
        
        Sets the HTML string.
        """

    def GetAllFormats(self, dir=DataObject.Get):
        """
        GetAllFormats(dir=DataObject.Get)
        
        Returns a list of wx.DataFormat objects which this data object
        supports transfering in the given direction.
        """

    def SetData(self, format, buf):
        """
        SetData(format, buf) -> bool
        """
    AllFormats = property(None, None)
    HTML = property(None, None)
# end of class HTMLDataObject


PyDataObjectSimple = wx.deprecated(DataObjectSimple), 'Use DataObjectSimple instead.'

PyTextDataObject = wx.deprecated(TextDataObject, 'Use TextDataObject instead.')

PyBitmapDataObject = wx.deprecated(BitmapDataObject, 'Use TextDataObject instead.')
#-- end-dataobj --#
#-- begin-dnd --#
Drag_CopyOnly = 0
Drag_AllowMove = 0
Drag_DefaultMove = 0
DragError = 0
DragNone = 0
DragCopy = 0
DragMove = 0
DragLink = 0
DragCancel = 0

def IsDragResultOk(res):
    """
    IsDragResultOk(res) -> bool
    
    Returns true if res indicates that something was done during a DnD
    operation, i.e.
    """

class DropSource(object):
    """
    DropSource(win=None)
    DropSource(data, win=None)
    
    This class represents a source for a drag and drop operation.
    """

    def __init__(self, *args, **kw):
        """
        DropSource(win=None)
        DropSource(data, win=None)
        
        This class represents a source for a drag and drop operation.
        """

    def DoDragDrop(self, flags=Drag_CopyOnly):
        """
        DoDragDrop(flags=Drag_CopyOnly) -> DragResult
        
        Starts the drag-and-drop operation which will terminate when the user
        releases the mouse.
        """

    def GetDataObject(self):
        """
        GetDataObject() -> DataObject
        
        Returns the wxDataObject object that has been assigned previously.
        """

    def GiveFeedback(self, effect):
        """
        GiveFeedback(effect) -> bool
        
        You may give some custom UI feedback during the drag and drop
        operation by overriding this function.
        """

    def SetCursor(self, res, cursor):
        """
        SetCursor(res, cursor)
        
        Set the icon to use for a certain drag result.
        """

    def SetIcon(self, res, icon):
        """
        SetIcon(res, icon)
        
        Set the icon to use for a certain drag result.
        """

    def SetData(self, data):
        """
        SetData(data)
        
        Sets the data wxDataObject associated with the drop source.
        """
    DataObject = property(None, None)
# end of class DropSource


class DropTarget(object):
    """
    DropTarget(data=None)
    
    This class represents a target for a drag and drop operation.
    """

    def __init__(self, data=None):
        """
        DropTarget(data=None)
        
        This class represents a target for a drag and drop operation.
        """

    def GetData(self):
        """
        GetData() -> bool
        
        This method may only be called from within OnData().
        """

    def OnData(self, x, y, defResult):
        """
        OnData(x, y, defResult) -> DragResult
        
        Called after OnDrop() returns true.
        """

    def OnDragOver(self, x, y, defResult):
        """
        OnDragOver(x, y, defResult) -> DragResult
        
        Called when the mouse is being dragged over the drop target.
        """

    def OnDrop(self, x, y):
        """
        OnDrop(x, y) -> bool
        
        Called when the user drops a data object on the target.
        """

    def OnEnter(self, x, y, defResult):
        """
        OnEnter(x, y, defResult) -> DragResult
        
        Called when the mouse enters the drop target.
        """

    def OnLeave(self):
        """
        OnLeave()
        
        Called when the mouse leaves the drop target.
        """

    def GetDataObject(self):
        """
        GetDataObject() -> DataObject
        
        Returns the data wxDataObject associated with the drop target.
        """

    def SetDataObject(self, data):
        """
        SetDataObject(data)
        
        Sets the data wxDataObject associated with the drop target and deletes
        any previously associated data object.
        """

    def SetDefaultAction(self, action):
        """
        SetDefaultAction(action)
        
        Sets the default action for drag and drop.
        """

    def GetDefaultAction(self):
        """
        GetDefaultAction() -> DragResult
        
        Returns default action for drag and drop or wxDragNone if this not
        specified.
        """
    Data = property(None, None)
    DataObject = property(None, None)
    DefaultAction = property(None, None)
# end of class DropTarget


class TextDropTarget(DropTarget):
    """
    TextDropTarget()
    
    A predefined drop target for dealing with text data.
    """

    def __init__(self):
        """
        TextDropTarget()
        
        A predefined drop target for dealing with text data.
        """

    def OnDrop(self, x, y):
        """
        OnDrop(x, y) -> bool
        
        See wxDropTarget::OnDrop().
        """

    def OnDropText(self, x, y, data):
        """
        OnDropText(x, y, data) -> bool
        
        Override this function to receive dropped text.
        """
# end of class TextDropTarget


class FileDropTarget(DropTarget):
    """
    FileDropTarget()
    
    This is a drop target which accepts files (dragged from File Manager
    or Explorer).
    """

    def __init__(self):
        """
        FileDropTarget()
        
        This is a drop target which accepts files (dragged from File Manager
        or Explorer).
        """

    def OnDrop(self, x, y):
        """
        OnDrop(x, y) -> bool
        
        See wxDropTarget::OnDrop().
        """

    def OnDropFiles(self, x, y, filenames):
        """
        OnDropFiles(x, y, filenames) -> bool
        
        Override this function to receive dropped files.
        """
# end of class FileDropTarget


PyDropTarget = wx.deprecated(DropTarget, 'Use DropTarget instead.')
#-- end-dnd --#
#-- begin-clipbrd --#

class Clipboard(Object):
    """
    Clipboard()
    
    A class for manipulating the clipboard.
    """

    def __init__(self):
        """
        Clipboard()
        
        A class for manipulating the clipboard.
        """

    def AddData(self, data):
        """
        AddData(data) -> bool
        
        Call this function to add the data object to the clipboard.
        """

    def Clear(self):
        """
        Clear()
        
        Clears the global clipboard object and the system's clipboard if
        possible.
        """

    def Close(self):
        """
        Close()
        
        Call this function to close the clipboard, having opened it with
        Open().
        """

    def Flush(self):
        """
        Flush() -> bool
        
        Flushes the clipboard: this means that the data which is currently on
        clipboard will stay available even after the application exits
        (possibly eating memory), otherwise the clipboard will be emptied on
        exit.
        """

    def GetData(self, data):
        """
        GetData(data) -> bool
        
        Call this function to fill data with data on the clipboard, if
        available in the required format.
        """

    def IsOpened(self):
        """
        IsOpened() -> bool
        
        Returns true if the clipboard has been opened.
        """

    def IsSupported(self, format):
        """
        IsSupported(format) -> bool
        
        Returns true if there is data which matches the data format of the
        given data object currently available on the clipboard.
        """

    def IsUsingPrimarySelection(self):
        """
        IsUsingPrimarySelection() -> bool
        
        Returns true if we are using the primary selection, false if clipboard
        one.
        """

    def Open(self):
        """
        Open() -> bool
        
        Call this function to open the clipboard before calling SetData() and
        GetData().
        """

    def SetData(self, data):
        """
        SetData(data) -> bool
        
        Call this function to set the data object to the clipboard.
        """

    def UsePrimarySelection(self, primary=False):
        """
        UsePrimarySelection(primary=False)
        
        On platforms supporting it (all X11-based ports), wxClipboard uses the
        CLIPBOARD X11 selection by default.
        """

    @staticmethod
    def Get():
        """
        Get() -> Clipboard
        
        Returns the global instance (wxTheClipboard) of the clipboard object.
        """
# end of class Clipboard


# Since wxTheClipboard is not really a global variable (it is a macro
# that calls the Get static method) we can't declare it as a global
# variable for the wrapper generator, otherwise it will try to run the
# function at module import and the wxApp object won't exist yet.  So
# we'll use a class that will allow us to delay calling the Get until
# wx.TheClipboard is actually being used for the first time.
class _wxPyDelayedInitWrapper(object):
    def __init__(self, initfunc, *args, **kwargs):
        self._initfunc = initfunc
        self._args = args
        self._kwargs = kwargs
        self._instance = None
    def _checkInstance(self):
        if self._instance is None:
            if wx.GetApp():
                self._instance = self._initfunc(*self._args, **self._kwargs)
    def __getattr__(self, name):
        self._checkInstance()
        return getattr(self._instance, name)
    def __repr__(self):
        self._checkInstance()
        return repr(self._instance)

    # context manager methods
    def __enter__(self):
        self._checkInstance()
        if not self.Open():
            raise RuntimeError('Unable to open clipboard.')
        return self
    def __exit__(self, exc_type, exc_val, exc_tb):
        self.Close()

TheClipboard = _wxPyDelayedInitWrapper(Clipboard.Get)
#-- end-clipbrd --#
#-- begin-config --#

class ConfigBase(Object):
    """
    ConfigBase(appName=EmptyString, vendorName=EmptyString, localFilename=EmptyString, globalFilename=EmptyString, style=0)
    
    wxConfigBase defines the basic interface of all config classes.
    """
    Type_Unknown = 0
    Type_String = 0
    Type_Boolean = 0
    Type_Integer = 0
    Type_Float = 0

    def __init__(self, appName=EmptyString, vendorName=EmptyString, localFilename=EmptyString, globalFilename=EmptyString, style=0):
        """
        ConfigBase(appName=EmptyString, vendorName=EmptyString, localFilename=EmptyString, globalFilename=EmptyString, style=0)
        
        wxConfigBase defines the basic interface of all config classes.
        """

    def GetPath(self):
        """
        GetPath() -> String
        
        Retrieve the current path (always as absolute path).
        """

    def SetPath(self, strPath):
        """
        SetPath(strPath)
        
        Set current path: if the first character is '/', it is the absolute
        path, otherwise it is a relative path.
        """

    def GetFirstEntry(self):
        """
        GetFirstEntry() -> PyObject
        
        GetFirstEntry() -> (more, value, index)
        
        Allows enumerating the entries in the current group in a config
        object.  Returns a tuple containing a flag indicating if there are
        more
        items, the name of the current item, and an index to pass to
        GetNextEntry to fetch the next item.
        """

    def GetFirstGroup(self):
        """
        GetFirstGroup() -> PyObject
        
        GetFirstGroup() -> (more, value, index)
        
        Allows enumerating the subgroups in a config object.  Returns a tuple
        containing a flag indicating if there are more items, the name of the
        current item, and an index to pass to GetNextGroup to fetch the next
        item.
        """

    def GetNextEntry(self, index):
        """
        GetNextEntry(index) -> PyObject
        
        GetNextEntry() -> (more, value, index)
        
        Allows enumerating the entries in the current group in a config
        object.  Returns a tuple containing a flag indicating if there are
        more
        items, the name of the current item, and an index to pass to
        GetNextEntry to fetch the next item.
        """

    def GetNextGroup(self, index):
        """
        GetNextGroup(index) -> PyObject
        
        GetNextGroup(long index) -> (more, value, index)
        
        Allows enumerating the subgroups in a config object.  Returns a tuple
        containing a flag indicating if there are more items, the name of the
        current item, and an index to pass to GetNextGroup to fetch the next
        item.
        """

    def GetNumberOfEntries(self, bRecursive=False):
        """
        GetNumberOfEntries(bRecursive=False) -> size_t
        
        Get number of entries in the current group.
        """

    def GetNumberOfGroups(self, bRecursive=False):
        """
        GetNumberOfGroups(bRecursive=False) -> size_t
        
        Get number of entries/subgroups in the current group, with or without
        its subgroups.
        """

    def Exists(self, strName):
        """
        Exists(strName) -> bool
        """

    def GetEntryType(self, name):
        """
        GetEntryType(name) -> ConfigBase.EntryType
        
        Returns the type of the given entry or Unknown if the entry doesn't
        exist.
        """

    def HasEntry(self, strName):
        """
        HasEntry(strName) -> bool
        """

    def HasGroup(self, strName):
        """
        HasGroup(strName) -> bool
        """

    def GetAppName(self):
        """
        GetAppName() -> String
        
        Returns the application name.
        """

    def GetVendorName(self):
        """
        GetVendorName() -> String
        
        Returns the vendor name.
        """

    def Flush(self, bCurrentOnly=False):
        """
        Flush(bCurrentOnly=False) -> bool
        
        Permanently writes all changes (otherwise, they're only written from
        object's destructor).
        """

    def Read(self, key, defaultVal=EmptyString):
        """
        Read(key, defaultVal=EmptyString) -> String
        
        Another version of Read(), returning the string value directly.
        """

    def ReadBool(self, key, defaultVal=False):
        """
        ReadBool(key, defaultVal=False) -> bool
        """

    def ReadDouble(self, key, defaultVal):
        """
        ReadDouble(key, defaultVal) -> double
        
        Reads a double value from the key and returns it.
        """

    def ReadLong(self, key, defaultVal):
        """
        ReadLong(key, defaultVal) -> long
        
        Reads a long value from the key and returns it.
        """

    def Write(self, key, value):
        """
        Write(key, value) -> bool
        
        Writes the wxString value to the config file and returns true on
        success.
        """

    def RenameEntry(self, oldName, newName):
        """
        RenameEntry(oldName, newName) -> bool
        
        Renames an entry in the current group.
        """

    def RenameGroup(self, oldName, newName):
        """
        RenameGroup(oldName, newName) -> bool
        
        Renames a subgroup of the current group.
        """

    def DeleteAll(self):
        """
        DeleteAll() -> bool
        
        Delete the whole underlying object (disk file, registry key, ...).
        """

    def DeleteEntry(self, key, bDeleteGroupIfEmpty=True):
        """
        DeleteEntry(key, bDeleteGroupIfEmpty=True) -> bool
        
        Deletes the specified entry and the group it belongs to if it was the
        last key in it and the second parameter is true.
        """

    def DeleteGroup(self, key):
        """
        DeleteGroup(key) -> bool
        
        Delete the group (with all subgroups).
        """

    def IsExpandingEnvVars(self):
        """
        IsExpandingEnvVars() -> bool
        
        Returns true if we are expanding environment variables in key values.
        """

    def IsRecordingDefaults(self):
        """
        IsRecordingDefaults() -> bool
        
        Returns true if we are writing defaults back to the config file.
        """

    def SetExpandEnvVars(self, bDoIt=True):
        """
        SetExpandEnvVars(bDoIt=True)
        
        Determine whether we wish to expand environment variables in key
        values.
        """

    def SetRecordDefaults(self, bDoIt=True):
        """
        SetRecordDefaults(bDoIt=True)
        
        Sets whether defaults are recorded to the config file whenever an
        attempt to read the value which is not present in it is done.
        """

    @staticmethod
    def Create():
        """
        Create() -> ConfigBase
        
        Create a new config object and sets it as the current one.
        """

    @staticmethod
    def DontCreateOnDemand():
        """
        DontCreateOnDemand()
        
        Calling this function will prevent Get() from automatically creating a
        new config object if the current one is NULL.
        """

    @staticmethod
    def Get(CreateOnDemand=True):
        """
        Get(CreateOnDemand=True) -> ConfigBase
        
        Get the current config object.
        """

    @staticmethod
    def Set(pConfig):
        """
        Set(pConfig) -> ConfigBase
        
        Sets the config object as the current one, returns the pointer to the
        previous current object (both the parameter and returned value may be
        NULL).
        """

    def ReadInt(self, key, defaultVal=0):
        """
        ReadInt(key, defaultVal=0) -> long
        """

    def ReadFloat(self, key, defaultVal=0.0):
        """
        ReadFloat(key, defaultVal=0.0) -> double
        """

    def WriteInt(self, key, value):
        """
        WriteInt(key, value) -> bool
        """

    def WriteFloat(self, key, value):
        """
        WriteFloat(key, value) -> bool
        """

    def WriteBool(self, key, value):
        """
        WriteBool(key, value) -> bool
        """
    AppName = property(None, None)
    FirstEntry = property(None, None)
    FirstGroup = property(None, None)
    NextEntry = property(None, None)
    NextGroup = property(None, None)
    NumberOfEntries = property(None, None)
    NumberOfGroups = property(None, None)
    Path = property(None, None)
    VendorName = property(None, None)
# end of class ConfigBase


class FileConfig(ConfigBase):
    """
    FileConfig(appName=EmptyString, vendorName=EmptyString, localFilename=EmptyString, globalFilename=EmptyString, style=CONFIG_USE_LOCAL_FILE|CONFIG_USE_GLOBAL_FILE)
    FileConfig(is)
    
    wxFileConfig implements wxConfigBase interface for storing and
    retrieving configuration information using plain text files.
    """

    def __init__(self, *args, **kw):
        """
        FileConfig(appName=EmptyString, vendorName=EmptyString, localFilename=EmptyString, globalFilename=EmptyString, style=CONFIG_USE_LOCAL_FILE|CONFIG_USE_GLOBAL_FILE)
        FileConfig(is)
        
        wxFileConfig implements wxConfigBase interface for storing and
        retrieving configuration information using plain text files.
        """

    def Save(self, os):
        """
        Save(os) -> bool
        
        Saves all config data to the given stream, returns true if data was
        saved successfully or false on error.
        """

    def SetUmask(self, mode):
        """
        SetUmask(mode)
        
        Allows to set the mode to be used for the config file creation.
        """

    def SetPath(self, strPath):
        """
        SetPath(strPath)
        
        Set current path: if the first character is '/', it is the absolute
        path, otherwise it is a relative path.
        """

    def GetPath(self):
        """
        GetPath() -> String
        
        Retrieve the current path (always as absolute path).
        """

    def GetNumberOfEntries(self, bRecursive=False):
        """
        GetNumberOfEntries(bRecursive=False) -> size_t
        
        Get number of entries in the current group.
        """

    def GetNumberOfGroups(self, bRecursive=False):
        """
        GetNumberOfGroups(bRecursive=False) -> size_t
        
        Get number of entries/subgroups in the current group, with or without
        its subgroups.
        """

    def HasGroup(self, strName):
        """
        HasGroup(strName) -> bool
        """

    def HasEntry(self, strName):
        """
        HasEntry(strName) -> bool
        """

    def Flush(self, bCurrentOnly=False):
        """
        Flush(bCurrentOnly=False) -> bool
        
        Permanently writes all changes (otherwise, they're only written from
        object's destructor).
        """

    def RenameEntry(self, oldName, newName):
        """
        RenameEntry(oldName, newName) -> bool
        
        Renames an entry in the current group.
        """

    def RenameGroup(self, oldName, newName):
        """
        RenameGroup(oldName, newName) -> bool
        
        Renames a subgroup of the current group.
        """

    def DeleteEntry(self, key, bDeleteGroupIfEmpty=True):
        """
        DeleteEntry(key, bDeleteGroupIfEmpty=True) -> bool
        
        Deletes the specified entry and the group it belongs to if it was the
        last key in it and the second parameter is true.
        """

    def DeleteGroup(self, key):
        """
        DeleteGroup(key) -> bool
        
        Delete the group (with all subgroups).
        """

    def DeleteAll(self):
        """
        DeleteAll() -> bool
        
        Delete the whole underlying object (disk file, registry key, ...).
        """

    @staticmethod
    def GetGlobalFileName(szFile):
        """
        GetGlobalFileName(szFile) -> String
        """

    @staticmethod
    def GetLocalFileName(szFile, style=0):
        """
        GetLocalFileName(szFile, style=0) -> String
        """
    NumberOfEntries = property(None, None)
    NumberOfGroups = property(None, None)
    Path = property(None, None)
# end of class FileConfig


class ConfigPathChanger(object):
    """
    ConfigPathChanger(pContainer, strEntry)
    
    A handy little class which changes the current path in a wxConfig
    object and restores it in dtor.
    """

    def __init__(self, pContainer, strEntry):
        """
        ConfigPathChanger(pContainer, strEntry)
        
        A handy little class which changes the current path in a wxConfig
        object and restores it in dtor.
        """

    def Name(self):
        """
        Name() -> String
        
        Returns the name of the key which was passed to the ctor.
        """

    def UpdateIfDeleted(self):
        """
        UpdateIfDeleted()
        
        This method must be called if the original path inside the wxConfig
        object (i.e.
        """

    def __enter__(self):
        """
        
        """

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        
        """
# end of class ConfigPathChanger

#-- end-config --#
#-- begin-tracker --#

class Trackable(object):
    """
    Add-on base class for a trackable object.
    """
# end of class Trackable

#-- end-tracker --#
#-- begin-kbdstate --#

class KeyboardState(object):
    """
    KeyboardState(controlDown=False, shiftDown=False, altDown=False, metaDown=False)
    
    Provides methods for testing the state of the keyboard modifier keys.
    """

    def __init__(self, controlDown=False, shiftDown=False, altDown=False, metaDown=False):
        """
        KeyboardState(controlDown=False, shiftDown=False, altDown=False, metaDown=False)
        
        Provides methods for testing the state of the keyboard modifier keys.
        """

    def GetModifiers(self):
        """
        GetModifiers() -> int
        
        Return the bit mask of all pressed modifier keys.
        """

    def HasAnyModifiers(self):
        """
        HasAnyModifiers() -> bool
        
        Returns true if any modifiers at all are pressed.
        """

    def HasModifiers(self):
        """
        HasModifiers() -> bool
        
        Returns true if Control or Alt are pressed.
        """

    def ControlDown(self):
        """
        ControlDown() -> bool
        
        Returns true if the Control key or Apple/Command key under OS X is
        pressed.
        """

    def RawControlDown(self):
        """
        RawControlDown() -> bool
        
        Returns true if the Control key (also under OS X).
        """

    def ShiftDown(self):
        """
        ShiftDown() -> bool
        
        Returns true if the Shift key is pressed.
        """

    def MetaDown(self):
        """
        MetaDown() -> bool
        
        Returns true if the Meta/Windows/Apple key is pressed.
        """

    def AltDown(self):
        """
        AltDown() -> bool
        
        Returns true if the Alt key is pressed.
        """

    def CmdDown(self):
        """
        CmdDown() -> bool
        
        Returns true if the key used for command accelerators is pressed.
        """

    def SetControlDown(self, down):
        """
        SetControlDown(down)
        """

    def SetRawControlDown(self, down):
        """
        SetRawControlDown(down)
        """

    def SetShiftDown(self, down):
        """
        SetShiftDown(down)
        """

    def SetAltDown(self, down):
        """
        SetAltDown(down)
        """

    def SetMetaDown(self, down):
        """
        SetMetaDown(down)
        """
    controlDown = property(None, None)
    rawControlDown = property(None, None)
    shiftDown = property(None, None)
    altDown = property(None, None)
    metaDown = property(None, None)
    cmdDown = property(None, None)

    # For 2.8 compatibility
    m_controlDown = wx.deprecated(controlDown, "Use controlDown instead.")
    m_shiftDown   = wx.deprecated(shiftDown, "Use shiftDown instead.")
    m_altDown     = wx.deprecated(altDown, "Use altDown instead.")
    m_metaDown    = wx.deprecated(metaDown, "Use metaDown instead.")
# end of class KeyboardState

#-- end-kbdstate --#
#-- begin-mousestate --#
MOUSE_BTN_ANY = 0
MOUSE_BTN_NONE = 0
MOUSE_BTN_LEFT = 0
MOUSE_BTN_MIDDLE = 0
MOUSE_BTN_RIGHT = 0
MOUSE_BTN_AUX1 = 0
MOUSE_BTN_AUX2 = 0
MOUSE_BTN_MAX = 0

class MouseState(KeyboardState):
    """
    MouseState()
    
    Represents the mouse state.
    """

    def __init__(self):
        """
        MouseState()
        
        Represents the mouse state.
        """

    def GetPosition(self):
        """
        GetPosition() -> Point
        
        Returns the physical mouse position.
        """

    def GetX(self):
        """
        GetX() -> Coord
        
        Returns X coordinate of the physical mouse event position.
        """

    def GetY(self):
        """
        GetY() -> Coord
        
        Returns Y coordinate of the physical mouse event position.
        """

    def LeftIsDown(self):
        """
        LeftIsDown() -> bool
        
        Returns true if the left mouse button is currently down.
        """

    def MiddleIsDown(self):
        """
        MiddleIsDown() -> bool
        
        Returns true if the middle mouse button is currently down.
        """

    def RightIsDown(self):
        """
        RightIsDown() -> bool
        
        Returns true if the right mouse button is currently down.
        """

    def Aux1IsDown(self):
        """
        Aux1IsDown() -> bool
        
        Returns true if the first extra button mouse button is currently down.
        """

    def Aux2IsDown(self):
        """
        Aux2IsDown() -> bool
        
        Returns true if the second extra button mouse button is currently
        down.
        """

    def SetX(self, x):
        """
        SetX(x)
        """

    def SetY(self, y):
        """
        SetY(y)
        """

    def SetPosition(self, pos):
        """
        SetPosition(pos)
        """

    def SetLeftDown(self, down):
        """
        SetLeftDown(down)
        """

    def SetMiddleDown(self, down):
        """
        SetMiddleDown(down)
        """

    def SetRightDown(self, down):
        """
        SetRightDown(down)
        """

    def SetAux1Down(self, down):
        """
        SetAux1Down(down)
        """

    def SetAux2Down(self, down):
        """
        SetAux2Down(down)
        """

    def SetState(self, state):
        """
        SetState(state)
        """
    x = property(None, None)
    y = property(None, None)
    X = property(None, None)
    Y = property(None, None)
    leftIsDown = property(None, None)
    middleIsDown = property(None, None)
    rightIsDown = property(None, None)
    aux1IsDown = property(None, None)
    aux2IsDown = property(None, None)
    Position = property(None, None)
# end of class MouseState

#-- end-mousestate --#
#-- begin-tooltip --#

class ToolTip(Object):
    """
    ToolTip(tip)
    
    This class holds information about a tooltip associated with a window
    (see wxWindow::SetToolTip()).
    """

    def __init__(self, tip):
        """
        ToolTip(tip)
        
        This class holds information about a tooltip associated with a window
        (see wxWindow::SetToolTip()).
        """

    def GetTip(self):
        """
        GetTip() -> String
        
        Get the tooltip text.
        """

    def GetWindow(self):
        """
        GetWindow() -> Window
        
        Get the associated window.
        """

    def SetTip(self, tip):
        """
        SetTip(tip)
        
        Set the tooltip text.
        """

    @staticmethod
    def Enable(flag):
        """
        Enable(flag)
        
        Enable or disable tooltips globally.
        """

    @staticmethod
    def SetAutoPop(msecs):
        """
        SetAutoPop(msecs)
        
        Set the delay after which the tooltip disappears or how long a tooltip
        remains visible.
        """

    @staticmethod
    def SetDelay(msecs):
        """
        SetDelay(msecs)
        
        Set the delay after which the tooltip appears.
        """

    @staticmethod
    def SetMaxWidth(width):
        """
        SetMaxWidth(width)
        
        Set tooltip maximal width in pixels.
        """

    @staticmethod
    def SetReshow(msecs):
        """
        SetReshow(msecs)
        
        Set the delay between subsequent tooltips to appear.
        """
    Tip = property(None, None)
    Window = property(None, None)
# end of class ToolTip

#-- end-tooltip --#
#-- begin-layout --#
Left = 0
Top = 0
Right = 0
Bottom = 0
Width = 0
Height = 0
Centre = 0
Center = 0
CentreX = 0
CentreY = 0
Unconstrained = 0
AsIs = 0
PercentOf = 0
Above = 0
Below = 0
LeftOf = 0
RightOf = 0
SameAs = 0
Absolute = 0
LAYOUT_DEFAULT_MARGIN = 0

class IndividualLayoutConstraint(Object):
    """
    IndividualLayoutConstraint()
    """

    def __init__(self):
        """
        IndividualLayoutConstraint()
        """

    def Set(self, rel, otherW, otherE, val=0, margin=LAYOUT_DEFAULT_MARGIN):
        """
        Set(rel, otherW, otherE, val=0, margin=LAYOUT_DEFAULT_MARGIN)
        """

    def LeftOf(self, sibling, margin=LAYOUT_DEFAULT_MARGIN):
        """
        LeftOf(sibling, margin=LAYOUT_DEFAULT_MARGIN)
        """

    def RightOf(self, sibling, margin=LAYOUT_DEFAULT_MARGIN):
        """
        RightOf(sibling, margin=LAYOUT_DEFAULT_MARGIN)
        """

    def Above(self, sibling, margin=LAYOUT_DEFAULT_MARGIN):
        """
        Above(sibling, margin=LAYOUT_DEFAULT_MARGIN)
        """

    def Below(self, sibling, margin=LAYOUT_DEFAULT_MARGIN):
        """
        Below(sibling, margin=LAYOUT_DEFAULT_MARGIN)
        """

    def SameAs(self, otherW, edge, margin=LAYOUT_DEFAULT_MARGIN):
        """
        SameAs(otherW, edge, margin=LAYOUT_DEFAULT_MARGIN)
        """

    def PercentOf(self, otherW, wh, per):
        """
        PercentOf(otherW, wh, per)
        """

    def Absolute(self, val):
        """
        Absolute(val)
        """

    def Unconstrained(self):
        """
        Unconstrained()
        """

    def AsIs(self):
        """
        AsIs()
        """

    def GetOtherWindow(self):
        """
        GetOtherWindow() -> Window
        """

    def GetMyEdge(self):
        """
        GetMyEdge() -> Edge
        """

    def SetEdge(self, which):
        """
        SetEdge(which)
        """

    def SetValue(self, v):
        """
        SetValue(v)
        """

    def GetMargin(self):
        """
        GetMargin() -> int
        """

    def SetMargin(self, m):
        """
        SetMargin(m)
        """

    def GetValue(self):
        """
        GetValue() -> int
        """

    def GetPercent(self):
        """
        GetPercent() -> int
        """

    def GetOtherEdge(self):
        """
        GetOtherEdge() -> int
        """

    def GetDone(self):
        """
        GetDone() -> bool
        """

    def SetDone(self, d):
        """
        SetDone(d)
        """

    def GetRelationship(self):
        """
        GetRelationship() -> Relationship
        """

    def SetRelationship(self, r):
        """
        SetRelationship(r)
        """

    def ResetIfWin(self, otherW):
        """
        ResetIfWin(otherW) -> bool
        """

    def SatisfyConstraint(self, constraints, win):
        """
        SatisfyConstraint(constraints, win) -> bool
        """

    def GetEdge(self, which, thisWin, other):
        """
        GetEdge(which, thisWin, other) -> int
        """
    Done = property(None, None)
    Margin = property(None, None)
    MyEdge = property(None, None)
    OtherEdge = property(None, None)
    OtherWindow = property(None, None)
    Percent = property(None, None)
    Relationship = property(None, None)
    Value = property(None, None)
# end of class IndividualLayoutConstraint


class LayoutConstraints(Object):
    """
    LayoutConstraints()
    """

    def __init__(self):
        """
        LayoutConstraints()
        """
    left = property(None, None)
    top = property(None, None)
    right = property(None, None)
    bottom = property(None, None)
    width = property(None, None)
    height = property(None, None)
    centreX = property(None, None)
    centreY = property(None, None)

    def SatisfyConstraints(self, win, noChanges):
        """
        SatisfyConstraints(win, noChanges) -> bool
        """

    def AreSatisfied(self):
        """
        AreSatisfied() -> bool
        """
# end of class LayoutConstraints

#-- end-layout --#
#-- begin-event --#
EVENT_PROPAGATE_NONE = 0
EVENT_PROPAGATE_MAX = 0
wxEVT_CATEGORY_UI = 0
wxEVT_CATEGORY_USER_INPUT = 0
wxEVT_CATEGORY_SOCKET = 0
wxEVT_CATEGORY_TIMER = 0
wxEVT_CATEGORY_THREAD = 0
wxEVT_CATEGORY_ALL = 0
WXK_CATEGORY_ARROW = 0
WXK_CATEGORY_PAGING = 0
WXK_CATEGORY_JUMP = 0
WXK_CATEGORY_TAB = 0
WXK_CATEGORY_CUT = 0
WXK_CATEGORY_NAVIGATION = 0
JOYSTICK1 = 0
JOYSTICK2 = 0
JOY_BUTTON_ANY = 0
JOY_BUTTON1 = 0
JOY_BUTTON2 = 0
JOY_BUTTON3 = 0
JOY_BUTTON4 = 0
UPDATE_UI_PROCESS_ALL = 0
UPDATE_UI_PROCESS_SPECIFIED = 0
MOUSE_WHEEL_VERTICAL = 0
MOUSE_WHEEL_HORIZONTAL = 0
IDLE_PROCESS_ALL = 0
IDLE_PROCESS_SPECIFIED = 0
wxEVT_NULL = 0
wxEVT_ANY = 0
wxEVT_BUTTON = 0
wxEVT_CHECKBOX = 0
wxEVT_CHOICE = 0
wxEVT_LISTBOX = 0
wxEVT_LISTBOX_DCLICK = 0
wxEVT_CHECKLISTBOX = 0
wxEVT_MENU = 0
wxEVT_SLIDER = 0
wxEVT_RADIOBOX = 0
wxEVT_RADIOBUTTON = 0
wxEVT_SCROLLBAR = 0
wxEVT_VLBOX = 0
wxEVT_COMBOBOX = 0
wxEVT_TOOL_RCLICKED = 0
wxEVT_TOOL_DROPDOWN = 0
wxEVT_TOOL_ENTER = 0
wxEVT_COMBOBOX_DROPDOWN = 0
wxEVT_COMBOBOX_CLOSEUP = 0
wxEVT_THREAD = 0
wxEVT_LEFT_DOWN = 0
wxEVT_LEFT_UP = 0
wxEVT_MIDDLE_DOWN = 0
wxEVT_MIDDLE_UP = 0
wxEVT_RIGHT_DOWN = 0
wxEVT_RIGHT_UP = 0
wxEVT_MOTION = 0
wxEVT_ENTER_WINDOW = 0
wxEVT_LEAVE_WINDOW = 0
wxEVT_LEFT_DCLICK = 0
wxEVT_MIDDLE_DCLICK = 0
wxEVT_RIGHT_DCLICK = 0
wxEVT_SET_FOCUS = 0
wxEVT_KILL_FOCUS = 0
wxEVT_CHILD_FOCUS = 0
wxEVT_MOUSEWHEEL = 0
wxEVT_AUX1_DOWN = 0
wxEVT_AUX1_UP = 0
wxEVT_AUX1_DCLICK = 0
wxEVT_AUX2_DOWN = 0
wxEVT_AUX2_UP = 0
wxEVT_AUX2_DCLICK = 0
wxEVT_CHAR = 0
wxEVT_CHAR_HOOK = 0
wxEVT_NAVIGATION_KEY = 0
wxEVT_KEY_DOWN = 0
wxEVT_KEY_UP = 0
wxEVT_HOTKEY = 0
wxEVT_SET_CURSOR = 0
wxEVT_SCROLL_TOP = 0
wxEVT_SCROLL_BOTTOM = 0
wxEVT_SCROLL_LINEUP = 0
wxEVT_SCROLL_LINEDOWN = 0
wxEVT_SCROLL_PAGEUP = 0
wxEVT_SCROLL_PAGEDOWN = 0
wxEVT_SCROLL_THUMBTRACK = 0
wxEVT_SCROLL_THUMBRELEASE = 0
wxEVT_SCROLL_CHANGED = 0
wxEVT_SPIN_UP = 0
wxEVT_SPIN_DOWN = 0
wxEVT_SPIN = 0
wxEVT_SCROLLWIN_TOP = 0
wxEVT_SCROLLWIN_BOTTOM = 0
wxEVT_SCROLLWIN_LINEUP = 0
wxEVT_SCROLLWIN_LINEDOWN = 0
wxEVT_SCROLLWIN_PAGEUP = 0
wxEVT_SCROLLWIN_PAGEDOWN = 0
wxEVT_SCROLLWIN_THUMBTRACK = 0
wxEVT_SCROLLWIN_THUMBRELEASE = 0
wxEVT_SIZE = 0
wxEVT_MOVE = 0
wxEVT_CLOSE_WINDOW = 0
wxEVT_END_SESSION = 0
wxEVT_QUERY_END_SESSION = 0
wxEVT_ACTIVATE_APP = 0
wxEVT_ACTIVATE = 0
wxEVT_CREATE = 0
wxEVT_DESTROY = 0
wxEVT_SHOW = 0
wxEVT_ICONIZE = 0
wxEVT_MAXIMIZE = 0
wxEVT_MOUSE_CAPTURE_CHANGED = 0
wxEVT_MOUSE_CAPTURE_LOST = 0
wxEVT_PAINT = 0
wxEVT_ERASE_BACKGROUND = 0
wxEVT_NC_PAINT = 0
wxEVT_MENU_OPEN = 0
wxEVT_MENU_CLOSE = 0
wxEVT_MENU_HIGHLIGHT = 0
wxEVT_CONTEXT_MENU = 0
wxEVT_SYS_COLOUR_CHANGED = 0
wxEVT_DISPLAY_CHANGED = 0
wxEVT_QUERY_NEW_PALETTE = 0
wxEVT_PALETTE_CHANGED = 0
wxEVT_JOY_BUTTON_DOWN = 0
wxEVT_JOY_BUTTON_UP = 0
wxEVT_JOY_MOVE = 0
wxEVT_JOY_ZMOVE = 0
wxEVT_DROP_FILES = 0
wxEVT_INIT_DIALOG = 0
wxEVT_IDLE = 0
wxEVT_UPDATE_UI = 0
wxEVT_SIZING = 0
wxEVT_MOVING = 0
wxEVT_MOVE_START = 0
wxEVT_MOVE_END = 0
wxEVT_HIBERNATE = 0
wxEVT_TEXT_COPY = 0
wxEVT_TEXT_CUT = 0
wxEVT_TEXT_PASTE = 0
wxEVT_COMMAND_LEFT_CLICK = 0
wxEVT_COMMAND_LEFT_DCLICK = 0
wxEVT_COMMAND_RIGHT_CLICK = 0
wxEVT_COMMAND_RIGHT_DCLICK = 0
wxEVT_COMMAND_SET_FOCUS = 0
wxEVT_COMMAND_KILL_FOCUS = 0
wxEVT_COMMAND_ENTER = 0
wxEVT_HELP = 0
wxEVT_DETAILED_HELP = 0
wxEVT_TOOL = 0
wxEVT_WINDOW_MODAL_DIALOG_CLOSED = 0

class EvtHandler(Object, Trackable):
    """
    EvtHandler()
    
    A class that can handle events from the windowing system.
    """

    def __init__(self):
        """
        EvtHandler()
        
        A class that can handle events from the windowing system.
        """

    def QueueEvent(self, event):
        """
        QueueEvent(event)
        
        Queue event for a later processing.
        """

    def AddPendingEvent(self, event):
        """
        AddPendingEvent(event)
        
        Post an event to be processed later.
        """

    def ProcessEvent(self, event):
        """
        ProcessEvent(event) -> bool
        
        Processes an event, searching event tables and calling zero or more
        suitable event handler function(s).
        """

    def ProcessEventLocally(self, event):
        """
        ProcessEventLocally(event) -> bool
        
        Try to process the event in this handler and all those chained to it.
        """

    def SafelyProcessEvent(self, event):
        """
        SafelyProcessEvent(event) -> bool
        
        Processes an event by calling ProcessEvent() and handles any
        exceptions that occur in the process.
        """

    def ProcessPendingEvents(self):
        """
        ProcessPendingEvents()
        
        Processes the pending events previously queued using QueueEvent() or
        AddPendingEvent(); you must call this function only if you are sure
        there are pending events for this handler, otherwise a wxCHECK will
        fail.
        """

    def DeletePendingEvents(self):
        """
        DeletePendingEvents()
        
        Deletes all events queued on this event handler using QueueEvent() or
        AddPendingEvent().
        """

    def Connect(self, id, lastId, eventType, func):
        """
        Connect(id, lastId, eventType, func)
        
        Make an entry in the dynamic event table for an event binding.
        """

    def Disconnect(self, id, lastId=-1, eventType=wxEVT_NULL, func=None):
        """
        Disconnect(id, lastId=-1, eventType=wxEVT_NULL, func=None) -> bool
        
        Remove an event binding by removing its entry in the dynamic event
        table.
        """

    def GetEvtHandlerEnabled(self):
        """
        GetEvtHandlerEnabled() -> bool
        
        Returns true if the event handler is enabled, false otherwise.
        """

    def GetNextHandler(self):
        """
        GetNextHandler() -> EvtHandler
        
        Returns the pointer to the next handler in the chain.
        """

    def GetPreviousHandler(self):
        """
        GetPreviousHandler() -> EvtHandler
        
        Returns the pointer to the previous handler in the chain.
        """

    def SetEvtHandlerEnabled(self, enabled):
        """
        SetEvtHandlerEnabled(enabled)
        
        Enables or disables the event handler.
        """

    def SetNextHandler(self, handler):
        """
        SetNextHandler(handler)
        
        Sets the pointer to the next handler.
        """

    def SetPreviousHandler(self, handler):
        """
        SetPreviousHandler(handler)
        
        Sets the pointer to the previous handler.
        """

    def Unlink(self):
        """
        Unlink()
        
        Unlinks this event handler from the chain it's part of (if any); then
        links the "previous" event handler to the "next" one (so that the
        chain won't be interrupted).
        """

    def IsUnlinked(self):
        """
        IsUnlinked() -> bool
        
        Returns true if the next and the previous handler pointers of this
        event handler instance are NULL.
        """

    @staticmethod
    def AddFilter(filter):
        """
        AddFilter(filter)
        
        Add an event filter whose FilterEvent() method will be called for each
        and every event processed by wxWidgets.
        """

    @staticmethod
    def RemoveFilter(filter):
        """
        RemoveFilter(filter)
        
        Remove a filter previously installed with AddFilter().
        """

    def Bind(self, event, handler, source=None, id=wx.ID_ANY, id2=wx.ID_ANY):
        """
        Bind an event to an event handler.
        
        :param event: One of the ``EVT_*`` event binder objects that
                      specifies the type of event to bind.
        
        :param handler: A callable object to be invoked when the
                        event is delivered to self.  Pass ``None`` to
                        disconnect an event handler.
        
        :param source: Sometimes the event originates from a
                       different window than self, but you still
                       want to catch it in self.  (For example, a
                       button event delivered to a frame.)  By
                       passing the source of the event, the event
                       handling system is able to differentiate
                       between the same event type from different
                       controls.
        
        :param id: Used to spcify the event source by ID instead
                   of instance.
        
        :param id2: Used when it is desirable to bind a handler
                    to a range of IDs, such as with EVT_MENU_RANGE.
        """

    def Unbind(self, event, source=None, id=wx.ID_ANY, id2=wx.ID_ANY, handler=None):
        """
        Disconnects the event handler binding for event from `self`.
        Returns ``True`` if successful.
        """
    EvtHandlerEnabled = property(None, None)
    NextHandler = property(None, None)
    PreviousHandler = property(None, None)

    def TryBefore(self, event):
        """
        TryBefore(event) -> bool
        
        Method called by ProcessEvent() before examining this object event
        tables.
        """

    def TryAfter(self, event):
        """
        TryAfter(event) -> bool
        
        Method called by ProcessEvent() as last resort.
        """
# end of class EvtHandler


class EventBlocker(EvtHandler):
    """
    EventBlocker(win, type=-1)
    
    This class is a special event handler which allows to discard any
    event (or a set of event types) directed to a specific window.
    """

    def __init__(self, win, type=-1):
        """
        EventBlocker(win, type=-1)
        
        This class is a special event handler which allows to discard any
        event (or a set of event types) directed to a specific window.
        """

    def Block(self, eventType):
        """
        Block(eventType)
        
        Adds to the list of event types which should be blocked the given
        eventType.
        """

    def __enter__(self):
        """
        
        """

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        
        """
# end of class EventBlocker


class PropagationDisabler(object):
    """
    PropagationDisabler(event)
    
    Helper class to temporarily change an event to not propagate.
    """

    def __init__(self, event):
        """
        PropagationDisabler(event)
        
        Helper class to temporarily change an event to not propagate.
        """

    def __enter__(self):
        """
        
        """

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        
        """
# end of class PropagationDisabler


class PropagateOnce(object):
    """
    PropagateOnce(event)
    
    Helper class to temporarily lower propagation level.
    """

    def __init__(self, event):
        """
        PropagateOnce(event)
        
        Helper class to temporarily lower propagation level.
        """

    def __enter__(self):
        """
        
        """

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        
        """
# end of class PropagateOnce


class Event(Object):
    """
    Event(id=0, eventType=wxEVT_NULL)
    
    An event is a structure holding information about an event passed to a
    callback or member function.
    """

    def __init__(self, id=0, eventType=wxEVT_NULL):
        """
        Event(id=0, eventType=wxEVT_NULL)
        
        An event is a structure holding information about an event passed to a
        callback or member function.
        """

    def Clone(self):
        """
        Clone() -> Event
        
        Returns a copy of the event.
        """

    def GetEventObject(self):
        """
        GetEventObject() -> Object
        
        Returns the object (usually a window) associated with the event, if
        any.
        """

    def GetEventType(self):
        """
        GetEventType() -> EventType
        
        Returns the identifier of the given event type, such as wxEVT_BUTTON.
        """

    def GetEventCategory(self):
        """
        GetEventCategory() -> EventCategory
        
        Returns a generic category for this event.
        """

    def GetId(self):
        """
        GetId() -> int
        
        Returns the identifier associated with this event, such as a button
        command id.
        """

    def GetEventUserData(self):
        """
        GetEventUserData() -> Object
        
        Return the user data associated with a dynamically connected event
        handler.
        """

    def GetSkipped(self):
        """
        GetSkipped() -> bool
        
        Returns true if the event handler should be skipped, false otherwise.
        """

    def GetTimestamp(self):
        """
        GetTimestamp() -> long
        
        Gets the timestamp for the event.
        """

    def IsCommandEvent(self):
        """
        IsCommandEvent() -> bool
        
        Returns true if the event is or is derived from wxCommandEvent else it
        returns false.
        """

    def ResumePropagation(self, propagationLevel):
        """
        ResumePropagation(propagationLevel)
        
        Sets the propagation level to the given value (for example returned
        from an earlier call to wxEvent::StopPropagation).
        """

    def SetEventObject(self, object):
        """
        SetEventObject(object)
        
        Sets the originating object.
        """

    def SetEventType(self, type):
        """
        SetEventType(type)
        
        Sets the event type.
        """

    def SetId(self, id):
        """
        SetId(id)
        
        Sets the identifier associated with this event, such as a button
        command id.
        """

    def SetTimestamp(self, timeStamp=0):
        """
        SetTimestamp(timeStamp=0)
        
        Sets the timestamp for the event.
        """

    def ShouldPropagate(self):
        """
        ShouldPropagate() -> bool
        
        Test if this event should be propagated or not, i.e. if the
        propagation level is currently greater than 0.
        """

    def Skip(self, skip=True):
        """
        Skip(skip=True)
        
        This method can be used inside an event handler to control whether
        further event handlers bound to this event will be called after the
        current one returns.
        """

    def StopPropagation(self):
        """
        StopPropagation() -> int
        
        Stop the event from propagating to its parent window.
        """
    EventObject = property(None, None)
    EventType = property(None, None)
    Id = property(None, None)
    Skipped = property(None, None)
    Timestamp = property(None, None)
# end of class Event


class CommandEvent(Event):
    """
    CommandEvent(commandEventType=wxEVT_NULL, id=0)
    
    This event class contains information about command events, which
    originate from a variety of simple controls.
    """

    def __init__(self, commandEventType=wxEVT_NULL, id=0):
        """
        CommandEvent(commandEventType=wxEVT_NULL, id=0)
        
        This event class contains information about command events, which
        originate from a variety of simple controls.
        """

    def GetClientData(self):
        """
        GetClientData() -> ClientData
        
        Returns client object pointer for a listbox or choice selection event
        (not valid for a deselection).
        """

    def GetExtraLong(self):
        """
        GetExtraLong() -> long
        
        Returns extra information dependent on the event objects type.
        """

    def GetInt(self):
        """
        GetInt() -> int
        
        Returns the integer identifier corresponding to a listbox, choice or
        radiobox selection (only if the event was a selection, not a
        deselection), or a boolean value representing the value of a checkbox.
        """

    def GetSelection(self):
        """
        GetSelection() -> int
        
        Returns item index for a listbox or choice selection event (not valid
        for a deselection).
        """

    def GetString(self):
        """
        GetString() -> String
        
        Returns item string for a listbox or choice selection event.
        """

    def IsChecked(self):
        """
        IsChecked() -> bool
        
        This method can be used with checkbox and menu events: for the
        checkboxes, the method returns true for a selection event and false
        for a deselection one.
        """

    def IsSelection(self):
        """
        IsSelection() -> bool
        
        For a listbox or similar event, returns true if it is a selection,
        false if it is a deselection.
        """

    def SetClientData(self, data):
        """
        SetClientData(data)
        
        Sets the client object for this event.
        """

    def SetExtraLong(self, extraLong):
        """
        SetExtraLong(extraLong)
        
        Sets the m_extraLong member.
        """

    def SetInt(self, intCommand):
        """
        SetInt(intCommand)
        
        Sets the m_commandInt member.
        """

    def SetString(self, string):
        """
        SetString(string)
        
        Sets the m_commandString member.
        """

    def GetClientObject(self):
        """
        Alias for :meth:`GetClientData`
        """

    def SetClientObject(self, data):
        """
        Alias for :meth:`SetClientData`
        """
    ClientData = property(None, None)
    ExtraLong = property(None, None)
    Int = property(None, None)
    Selection = property(None, None)
    String = property(None, None)
# end of class CommandEvent


class ActivateEvent(Event):
    """
    ActivateEvent(eventType=wxEVT_NULL, active=True, id=0, ActivationReason=Reason_Unknown)
    
    An activate event is sent when a window or application is being
    activated or deactivated.
    """
    Reason_Mouse = 0
    Reason_Unknown = 0

    def __init__(self, eventType=wxEVT_NULL, active=True, id=0, ActivationReason=Reason_Unknown):
        """
        ActivateEvent(eventType=wxEVT_NULL, active=True, id=0, ActivationReason=Reason_Unknown)
        
        An activate event is sent when a window or application is being
        activated or deactivated.
        """

    def GetActive(self):
        """
        GetActive() -> bool
        
        Returns true if the application or window is being activated, false
        otherwise.
        """

    def GetActivationReason(self):
        """
        GetActivationReason() -> Reason
        
        Allows to check if the window was activated by clicking it with the
        mouse or in some other way.
        """
    Active = property(None, None)
# end of class ActivateEvent


class ChildFocusEvent(CommandEvent):
    """
    ChildFocusEvent(win=None)
    
    A child focus event is sent to a (parent-)window when one of its child
    windows gains focus, so that the window could restore the focus back
    to its corresponding child if it loses it now and regains later.
    """

    def __init__(self, win=None):
        """
        ChildFocusEvent(win=None)
        
        A child focus event is sent to a (parent-)window when one of its child
        windows gains focus, so that the window could restore the focus back
        to its corresponding child if it loses it now and regains later.
        """

    def GetWindow(self):
        """
        GetWindow() -> Window
        
        Returns the direct child which receives the focus, or a (grand-)parent
        of the control receiving the focus.
        """
    Window = property(None, None)
# end of class ChildFocusEvent


class ClipboardTextEvent(CommandEvent):
    """
    ClipboardTextEvent(commandType=wxEVT_NULL, id=0)
    
    This class represents the events generated by a control (typically a
    wxTextCtrl but other windows can generate these events as well) when
    its content gets copied or cut to, or pasted from the clipboard.
    """

    def __init__(self, commandType=wxEVT_NULL, id=0):
        """
        ClipboardTextEvent(commandType=wxEVT_NULL, id=0)
        
        This class represents the events generated by a control (typically a
        wxTextCtrl but other windows can generate these events as well) when
        its content gets copied or cut to, or pasted from the clipboard.
        """
# end of class ClipboardTextEvent


class CloseEvent(Event):
    """
    CloseEvent(commandEventType=wxEVT_NULL, id=0)
    
    This event class contains information about window and session close
    events.
    """

    def __init__(self, commandEventType=wxEVT_NULL, id=0):
        """
        CloseEvent(commandEventType=wxEVT_NULL, id=0)
        
        This event class contains information about window and session close
        events.
        """

    def CanVeto(self):
        """
        CanVeto() -> bool
        
        Returns true if you can veto a system shutdown or a window close
        event.
        """

    def GetLoggingOff(self):
        """
        GetLoggingOff() -> bool
        
        Returns true if the user is just logging off or false if the system is
        shutting down.
        """

    def SetCanVeto(self, canVeto):
        """
        SetCanVeto(canVeto)
        
        Sets the 'can veto' flag.
        """

    def SetLoggingOff(self, loggingOff):
        """
        SetLoggingOff(loggingOff)
        
        Sets the 'logging off' flag.
        """

    def Veto(self, veto=True):
        """
        Veto(veto=True)
        
        Call this from your event handler to veto a system shutdown or to
        signal to the calling application that a window close did not happen.
        """

    def GetVeto(self):
        """
        GetVeto() -> bool
        
        Returns whether the Veto flag was set.
        """
    LoggingOff = property(None, None)
# end of class CloseEvent


class ContextMenuEvent(CommandEvent):
    """
    ContextMenuEvent(type=wxEVT_NULL, id=0, pos=DefaultPosition)
    
    This class is used for context menu events, sent to give the
    application a chance to show a context (popup) menu for a wxWindow.
    """

    def __init__(self, type=wxEVT_NULL, id=0, pos=DefaultPosition):
        """
        ContextMenuEvent(type=wxEVT_NULL, id=0, pos=DefaultPosition)
        
        This class is used for context menu events, sent to give the
        application a chance to show a context (popup) menu for a wxWindow.
        """

    def GetPosition(self):
        """
        GetPosition() -> Point
        
        Returns the position in screen coordinates at which the menu should be
        shown.
        """

    def SetPosition(self, point):
        """
        SetPosition(point)
        
        Sets the position at which the menu should be shown.
        """
    Position = property(None, None)
# end of class ContextMenuEvent


class DisplayChangedEvent(Event):
    """
    DisplayChangedEvent()
    """

    def __init__(self):
        """
        DisplayChangedEvent()
        """
# end of class DisplayChangedEvent


class DropFilesEvent(Event):
    """
    DropFilesEvent(id=0, files=None)
    
    This class is used for drop files events, that is, when files have
    been dropped onto the window.
    """

    def __init__(self, id=0, files=None):
        """
        DropFilesEvent(id=0, files=None)
        
        This class is used for drop files events, that is, when files have
        been dropped onto the window.
        """

    def GetFiles(self):
        """
        GetFiles() -> PyObject
        
        Returns an array of filenames.
        """

    def GetNumberOfFiles(self):
        """
        GetNumberOfFiles() -> int
        
        Returns the number of files dropped.
        """

    def GetPosition(self):
        """
        GetPosition() -> Point
        
        Returns the position at which the files were dropped.
        """
    Files = property(None, None)
    NumberOfFiles = property(None, None)
    Position = property(None, None)
# end of class DropFilesEvent


class EraseEvent(Event):
    """
    EraseEvent(id=0, dc=None)
    
    An erase event is sent when a window's background needs to be
    repainted.
    """

    def __init__(self, id=0, dc=None):
        """
        EraseEvent(id=0, dc=None)
        
        An erase event is sent when a window's background needs to be
        repainted.
        """

    def GetDC(self):
        """
        GetDC() -> DC
        
        Returns the device context associated with the erase event to draw on.
        """
    DC = property(None, None)
# end of class EraseEvent


class FocusEvent(Event):
    """
    FocusEvent(eventType=wxEVT_NULL, id=0)
    
    A focus event is sent when a window's focus changes.
    """

    def __init__(self, eventType=wxEVT_NULL, id=0):
        """
        FocusEvent(eventType=wxEVT_NULL, id=0)
        
        A focus event is sent when a window's focus changes.
        """

    def GetWindow(self):
        """
        GetWindow() -> Window
        
        Returns the window associated with this event, that is the window
        which had the focus before for the wxEVT_SET_FOCUS event and the
        window which is going to receive focus for the wxEVT_KILL_FOCUS one.
        """

    def SetWindow(self, win):
        """
        SetWindow(win)
        """
    Window = property(None, None)
# end of class FocusEvent


class HelpEvent(CommandEvent):
    """
    HelpEvent(type=wxEVT_NULL, winid=0, pt=DefaultPosition, origin=Origin_Unknown)
    
    A help event is sent when the user has requested context-sensitive
    help.
    """
    Origin_Unknown = 0
    Origin_Keyboard = 0
    Origin_HelpButton = 0

    def __init__(self, type=wxEVT_NULL, winid=0, pt=DefaultPosition, origin=Origin_Unknown):
        """
        HelpEvent(type=wxEVT_NULL, winid=0, pt=DefaultPosition, origin=Origin_Unknown)
        
        A help event is sent when the user has requested context-sensitive
        help.
        """

    def GetOrigin(self):
        """
        GetOrigin() -> HelpEvent.Origin
        
        Returns the origin of the help event which is one of the
        wxHelpEvent::Origin values.
        """

    def GetPosition(self):
        """
        GetPosition() -> Point
        
        Returns the left-click position of the mouse, in screen coordinates.
        """

    def SetOrigin(self, origin):
        """
        SetOrigin(origin)
        
        Set the help event origin, only used internally by wxWidgets normally.
        """

    def SetPosition(self, pt):
        """
        SetPosition(pt)
        
        Sets the left-click position of the mouse, in screen coordinates.
        """
    Position = property(None, None)
# end of class HelpEvent


class IconizeEvent(Event):
    """
    IconizeEvent(id=0, iconized=True)
    
    An event being sent when the frame is iconized (minimized) or
    restored.
    """

    def __init__(self, id=0, iconized=True):
        """
        IconizeEvent(id=0, iconized=True)
        
        An event being sent when the frame is iconized (minimized) or
        restored.
        """

    def IsIconized(self):
        """
        IsIconized() -> bool
        
        Returns true if the frame has been iconized, false if it has been
        restored.
        """

    def Iconized(self):
        """
        Iconized() -> bool
        """
# end of class IconizeEvent


class IdleEvent(Event):
    """
    IdleEvent()
    
    This class is used for idle events, which are generated when the
    system becomes idle.
    """

    def __init__(self):
        """
        IdleEvent()
        
        This class is used for idle events, which are generated when the
        system becomes idle.
        """

    def MoreRequested(self):
        """
        MoreRequested() -> bool
        
        Returns true if the OnIdle function processing this event requested
        more processing time.
        """

    def RequestMore(self, needMore=True):
        """
        RequestMore(needMore=True)
        
        Tells wxWidgets that more processing is required.
        """

    @staticmethod
    def GetMode():
        """
        GetMode() -> IdleMode
        
        Static function returning a value specifying how wxWidgets will send
        idle events: to all windows, or only to those which specify that they
        will process the events.
        """

    @staticmethod
    def SetMode(mode):
        """
        SetMode(mode)
        
        Static function for specifying how wxWidgets will send idle events: to
        all windows, or only to those which specify that they will process the
        events.
        """
# end of class IdleEvent


class InitDialogEvent(Event):
    """
    InitDialogEvent(id=0)
    
    A wxInitDialogEvent is sent as a dialog or panel is being initialised.
    """

    def __init__(self, id=0):
        """
        InitDialogEvent(id=0)
        
        A wxInitDialogEvent is sent as a dialog or panel is being initialised.
        """
# end of class InitDialogEvent


class JoystickEvent(Event):
    """
    JoystickEvent(eventType=wxEVT_NULL, state=0, joystick=JOYSTICK1, change=0)
    
    This event class contains information about joystick events,
    particularly events received by windows.
    """

    def __init__(self, eventType=wxEVT_NULL, state=0, joystick=JOYSTICK1, change=0):
        """
        JoystickEvent(eventType=wxEVT_NULL, state=0, joystick=JOYSTICK1, change=0)
        
        This event class contains information about joystick events,
        particularly events received by windows.
        """

    def ButtonDown(self, button=JOY_BUTTON_ANY):
        """
        ButtonDown(button=JOY_BUTTON_ANY) -> bool
        
        Returns true if the event was a down event from the specified button
        (or any button).
        """

    def ButtonIsDown(self, button=JOY_BUTTON_ANY):
        """
        ButtonIsDown(button=JOY_BUTTON_ANY) -> bool
        
        Returns true if the specified button (or any button) was in a down
        state.
        """

    def ButtonUp(self, button=JOY_BUTTON_ANY):
        """
        ButtonUp(button=JOY_BUTTON_ANY) -> bool
        
        Returns true if the event was an up event from the specified button
        (or any button).
        """

    def GetButtonChange(self):
        """
        GetButtonChange() -> int
        
        Returns the identifier of the button changing state.
        """

    def GetButtonState(self):
        """
        GetButtonState() -> int
        
        Returns the down state of the buttons.
        """

    def GetJoystick(self):
        """
        GetJoystick() -> int
        
        Returns the identifier of the joystick generating the event - one of
        wxJOYSTICK1 and wxJOYSTICK2.
        """

    def GetPosition(self):
        """
        GetPosition() -> Point
        
        Returns the x, y position of the joystick event.
        """

    def GetZPosition(self):
        """
        GetZPosition() -> int
        
        Returns the z position of the joystick event.
        """

    def IsButton(self):
        """
        IsButton() -> bool
        
        Returns true if this was a button up or down event (not 'is any button
        down?').
        """

    def IsMove(self):
        """
        IsMove() -> bool
        
        Returns true if this was an x, y move event.
        """

    def IsZMove(self):
        """
        IsZMove() -> bool
        
        Returns true if this was a z move event.
        """
    ButtonChange = property(None, None)
    ButtonState = property(None, None)
    Joystick = property(None, None)
    Position = property(None, None)
    ZPosition = property(None, None)
# end of class JoystickEvent


class KeyEvent(Event, KeyboardState):
    """
    KeyEvent(keyEventType=wxEVT_NULL)
    
    This event class contains information about key press and release
    events.
    """

    def __init__(self, keyEventType=wxEVT_NULL):
        """
        KeyEvent(keyEventType=wxEVT_NULL)
        
        This event class contains information about key press and release
        events.
        """

    def GetPosition(self):
        """
        GetPosition() -> Point
        
        Obtains the position (in client coordinates) at which the key was
        pressed.
        """

    def GetKeyCode(self):
        """
        GetKeyCode() -> int
        
        Returns the key code of the key that generated this event.
        """

    def IsKeyInCategory(self, category):
        """
        IsKeyInCategory(category) -> bool
        
        Returns true if the key is in the given key category.
        """

    def GetRawKeyCode(self):
        """
        GetRawKeyCode() -> Uint32
        
        Returns the raw key code for this event.
        """

    def GetRawKeyFlags(self):
        """
        GetRawKeyFlags() -> Uint32
        
        Returns the low level key flags for this event.
        """

    def GetUnicodeKey(self):
        """
        GetUnicodeKey() -> int
        
        Returns the Unicode character corresponding to this key event.
        """

    def GetX(self):
        """
        GetX() -> Coord
        
        Returns the X position (in client coordinates) of the event.
        """

    def GetY(self):
        """
        GetY() -> Coord
        
        Returns the Y position (in client coordinates) of the event.
        """

    def DoAllowNextEvent(self):
        """
        DoAllowNextEvent()
        
        Allow normal key events generation.
        """

    def IsNextEventAllowed(self):
        """
        IsNextEventAllowed() -> bool
        
        Returns true if DoAllowNextEvent() had been called, false by default.
        """
    X = property(None, None)
    Y = property(None, None)
    KeyCode = property(None, None)
    Position = property(None, None)
    RawKeyCode = property(None, None)
    RawKeyFlags = property(None, None)
    UnicodeKey = property(None, None)
# end of class KeyEvent


class MaximizeEvent(Event):
    """
    MaximizeEvent(id=0)
    
    An event being sent when a top level window is maximized.
    """

    def __init__(self, id=0):
        """
        MaximizeEvent(id=0)
        
        An event being sent when a top level window is maximized.
        """
# end of class MaximizeEvent


class MenuEvent(Event):
    """
    MenuEvent(type=wxEVT_NULL, id=0, menu=None)
    
    This class is used for a variety of menu-related events.
    """

    def __init__(self, type=wxEVT_NULL, id=0, menu=None):
        """
        MenuEvent(type=wxEVT_NULL, id=0, menu=None)
        
        This class is used for a variety of menu-related events.
        """

    def GetMenu(self):
        """
        GetMenu() -> Menu
        
        Returns the menu which is being opened or closed.
        """

    def GetMenuId(self):
        """
        GetMenuId() -> int
        
        Returns the menu identifier associated with the event.
        """

    def IsPopup(self):
        """
        IsPopup() -> bool
        
        Returns true if the menu which is being opened or closed is a popup
        menu, false if it is a normal one.
        """
    Menu = property(None, None)
    MenuId = property(None, None)
# end of class MenuEvent


class MouseCaptureChangedEvent(Event):
    """
    MouseCaptureChangedEvent(windowId=0, gainedCapture=None)
    
    An mouse capture changed event is sent to a window that loses its
    mouse capture.
    """

    def __init__(self, windowId=0, gainedCapture=None):
        """
        MouseCaptureChangedEvent(windowId=0, gainedCapture=None)
        
        An mouse capture changed event is sent to a window that loses its
        mouse capture.
        """

    def GetCapturedWindow(self):
        """
        GetCapturedWindow() -> Window
        
        Returns the window that gained the capture, or NULL if it was a non-
        wxWidgets window.
        """
    CapturedWindow = property(None, None)
# end of class MouseCaptureChangedEvent


class MouseCaptureLostEvent(Event):
    """
    MouseCaptureLostEvent(windowId=0)
    
    A mouse capture lost event is sent to a window that had obtained mouse
    capture, which was subsequently lost due to an "external" event (for
    example, when a dialog box is shown or if another application captures
    the mouse).
    """

    def __init__(self, windowId=0):
        """
        MouseCaptureLostEvent(windowId=0)
        
        A mouse capture lost event is sent to a window that had obtained mouse
        capture, which was subsequently lost due to an "external" event (for
        example, when a dialog box is shown or if another application captures
        the mouse).
        """
# end of class MouseCaptureLostEvent


class MouseEvent(Event, MouseState):
    """
    MouseEvent(mouseEventType=wxEVT_NULL)
    
    This event class contains information about the events generated by
    the mouse: they include mouse buttons press and release events and
    mouse move events.
    """

    def __init__(self, mouseEventType=wxEVT_NULL):
        """
        MouseEvent(mouseEventType=wxEVT_NULL)
        
        This event class contains information about the events generated by
        the mouse: they include mouse buttons press and release events and
        mouse move events.
        """

    def Aux1DClick(self):
        """
        Aux1DClick() -> bool
        
        Returns true if the event was a first extra button double click.
        """

    def Aux1Down(self):
        """
        Aux1Down() -> bool
        
        Returns true if the first extra button mouse button changed to down.
        """

    def Aux1Up(self):
        """
        Aux1Up() -> bool
        
        Returns true if the first extra button mouse button changed to up.
        """

    def Aux2DClick(self):
        """
        Aux2DClick() -> bool
        
        Returns true if the event was a second extra button double click.
        """

    def Aux2Down(self):
        """
        Aux2Down() -> bool
        
        Returns true if the second extra button mouse button changed to down.
        """

    def Aux2Up(self):
        """
        Aux2Up() -> bool
        
        Returns true if the second extra button mouse button changed to up.
        """

    def Button(self, but):
        """
        Button(but) -> bool
        
        Returns true if the event was generated by the specified button.
        """

    def ButtonDClick(self, but=MOUSE_BTN_ANY):
        """
        ButtonDClick(but=MOUSE_BTN_ANY) -> bool
        
        If the argument is omitted, this returns true if the event was a mouse
        double click event.
        """

    def ButtonDown(self, but=MOUSE_BTN_ANY):
        """
        ButtonDown(but=MOUSE_BTN_ANY) -> bool
        
        If the argument is omitted, this returns true if the event was a mouse
        button down event.
        """

    def ButtonUp(self, but=MOUSE_BTN_ANY):
        """
        ButtonUp(but=MOUSE_BTN_ANY) -> bool
        
        If the argument is omitted, this returns true if the event was a mouse
        button up event.
        """

    def Dragging(self):
        """
        Dragging() -> bool
        
        Returns true if this was a dragging event (motion while a button is
        depressed).
        """

    def Entering(self):
        """
        Entering() -> bool
        
        Returns true if the mouse was entering the window.
        """

    def GetButton(self):
        """
        GetButton() -> int
        
        Returns the mouse button which generated this event or
        wxMOUSE_BTN_NONE if no button is involved (for mouse move, enter or
        leave event, for example).
        """

    def GetClickCount(self):
        """
        GetClickCount() -> int
        
        Returns the number of mouse clicks for this event: 1 for a simple
        click, 2 for a double-click, 3 for a triple-click and so on.
        """

    def GetLinesPerAction(self):
        """
        GetLinesPerAction() -> int
        
        Returns the configured number of lines (or whatever) to be scrolled
        per wheel action.
        """

    def GetColumnsPerAction(self):
        """
        GetColumnsPerAction() -> int
        
        Returns the configured number of columns (or whatever) to be scrolled
        per wheel action.
        """

    def GetLogicalPosition(self, dc):
        """
        GetLogicalPosition(dc) -> Point
        
        Returns the logical mouse position in pixels (i.e. translated
        according to the translation set for the DC, which usually indicates
        that the window has been scrolled).
        """

    def GetWheelDelta(self):
        """
        GetWheelDelta() -> int
        
        Get wheel delta, normally 120.
        """

    def GetWheelRotation(self):
        """
        GetWheelRotation() -> int
        
        Get wheel rotation, positive or negative indicates direction of
        rotation.
        """

    def GetWheelAxis(self):
        """
        GetWheelAxis() -> MouseWheelAxis
        
        Gets the axis the wheel operation concerns.
        """

    def IsButton(self):
        """
        IsButton() -> bool
        
        Returns true if the event was a mouse button event (not necessarily a
        button down event - that may be tested using ButtonDown()).
        """

    def IsPageScroll(self):
        """
        IsPageScroll() -> bool
        
        Returns true if the system has been setup to do page scrolling with
        the mouse wheel instead of line scrolling.
        """

    def Leaving(self):
        """
        Leaving() -> bool
        
        Returns true if the mouse was leaving the window.
        """

    def LeftDClick(self):
        """
        LeftDClick() -> bool
        
        Returns true if the event was a left double click.
        """

    def LeftDown(self):
        """
        LeftDown() -> bool
        
        Returns true if the left mouse button changed to down.
        """

    def LeftUp(self):
        """
        LeftUp() -> bool
        
        Returns true if the left mouse button changed to up.
        """

    def MetaDown(self):
        """
        MetaDown() -> bool
        
        Returns true if the Meta key was down at the time of the event.
        """

    def MiddleDClick(self):
        """
        MiddleDClick() -> bool
        
        Returns true if the event was a middle double click.
        """

    def MiddleDown(self):
        """
        MiddleDown() -> bool
        
        Returns true if the middle mouse button changed to down.
        """

    def MiddleUp(self):
        """
        MiddleUp() -> bool
        
        Returns true if the middle mouse button changed to up.
        """

    def Moving(self):
        """
        Moving() -> bool
        
        Returns true if this was a motion event and no mouse buttons were
        pressed.
        """

    def RightDClick(self):
        """
        RightDClick() -> bool
        
        Returns true if the event was a right double click.
        """

    def RightDown(self):
        """
        RightDown() -> bool
        
        Returns true if the right mouse button changed to down.
        """

    def RightUp(self):
        """
        RightUp() -> bool
        
        Returns true if the right mouse button changed to up.
        """
    LinesPerAction = property(None, None)
    LogicalPosition = property(None, None)
    WheelDelta = property(None, None)
    WheelRotation = property(None, None)
# end of class MouseEvent


class MoveEvent(Event):
    """
    MoveEvent(pt, id=0)
    
    A move event holds information about wxTopLevelWindow move change
    events.
    """

    def __init__(self, pt, id=0):
        """
        MoveEvent(pt, id=0)
        
        A move event holds information about wxTopLevelWindow move change
        events.
        """

    def GetPosition(self):
        """
        GetPosition() -> Point
        
        Returns the position of the window generating the move change event.
        """

    def GetRect(self):
        """
        GetRect() -> Rect
        """

    def SetRect(self, rect):
        """
        SetRect(rect)
        """

    def SetPosition(self, pos):
        """
        SetPosition(pos)
        """
    Rect = property(None, None)
    Position = property(None, None)
# end of class MoveEvent


class NavigationKeyEvent(Event):
    """
    NavigationKeyEvent()
    NavigationKeyEvent(event)
    
    This event class contains information about navigation events,
    generated by navigation keys such as tab and page down.
    """
    IsBackward = 0
    IsForward = 0
    WinChange = 0
    FromTab = 0

    def __init__(self, *args, **kw):
        """
        NavigationKeyEvent()
        NavigationKeyEvent(event)
        
        This event class contains information about navigation events,
        generated by navigation keys such as tab and page down.
        """

    def GetCurrentFocus(self):
        """
        GetCurrentFocus() -> Window
        
        Returns the child that has the focus, or NULL.
        """

    def GetDirection(self):
        """
        GetDirection() -> bool
        
        Returns true if the navigation was in the forward direction.
        """

    def IsFromTab(self):
        """
        IsFromTab() -> bool
        
        Returns true if the navigation event was from a tab key.
        """

    def IsWindowChange(self):
        """
        IsWindowChange() -> bool
        
        Returns true if the navigation event represents a window change (for
        example, from Ctrl-Page Down in a notebook).
        """

    def SetCurrentFocus(self, currentFocus):
        """
        SetCurrentFocus(currentFocus)
        
        Sets the current focus window member.
        """

    def SetDirection(self, direction):
        """
        SetDirection(direction)
        
        Sets the direction to forward if direction is true, or backward if
        false.
        """

    def SetFlags(self, flags):
        """
        SetFlags(flags)
        
        Sets the flags for this event.
        """

    def SetFromTab(self, fromTab):
        """
        SetFromTab(fromTab)
        
        Marks the navigation event as from a tab key.
        """

    def SetWindowChange(self, windowChange):
        """
        SetWindowChange(windowChange)
        
        Marks the event as a window change event.
        """
    CurrentFocus = property(None, None)
    Direction = property(None, None)
# end of class NavigationKeyEvent


class NotifyEvent(CommandEvent):
    """
    NotifyEvent(eventType=wxEVT_NULL, id=0)
    
    This class is not used by the event handlers by itself, but is a base
    class for other event classes (such as wxBookCtrlEvent).
    """

    def __init__(self, eventType=wxEVT_NULL, id=0):
        """
        NotifyEvent(eventType=wxEVT_NULL, id=0)
        
        This class is not used by the event handlers by itself, but is a base
        class for other event classes (such as wxBookCtrlEvent).
        """

    def Allow(self):
        """
        Allow()
        
        This is the opposite of Veto(): it explicitly allows the event to be
        processed.
        """

    def IsAllowed(self):
        """
        IsAllowed() -> bool
        
        Returns true if the change is allowed (Veto() hasn't been called) or
        false otherwise (if it was).
        """

    def Veto(self):
        """
        Veto()
        
        Prevents the change announced by this event from happening.
        """
# end of class NotifyEvent


class PaintEvent(Event):
    """
    PaintEvent(id=0)
    
    A paint event is sent when a window's contents needs to be repainted.
    """

    def __init__(self, id=0):
        """
        PaintEvent(id=0)
        
        A paint event is sent when a window's contents needs to be repainted.
        """
# end of class PaintEvent


class PaletteChangedEvent(Event):
    """
    PaletteChangedEvent(winid=0)
    """

    def __init__(self, winid=0):
        """
        PaletteChangedEvent(winid=0)
        """

    def SetChangedWindow(self, win):
        """
        SetChangedWindow(win)
        """

    def GetChangedWindow(self):
        """
        GetChangedWindow() -> Window
        """
    ChangedWindow = property(None, None)
# end of class PaletteChangedEvent


class QueryNewPaletteEvent(Event):
    """
    QueryNewPaletteEvent(winid=0)
    """

    def __init__(self, winid=0):
        """
        QueryNewPaletteEvent(winid=0)
        """

    def SetPaletteRealized(self, realized):
        """
        SetPaletteRealized(realized)
        """

    def GetPaletteRealized(self):
        """
        GetPaletteRealized() -> bool
        """
    PaletteRealized = property(None, None)
# end of class QueryNewPaletteEvent


class ScrollEvent(CommandEvent):
    """
    ScrollEvent(commandType=wxEVT_NULL, id=0, pos=0, orientation=0)
    
    A scroll event holds information about events sent from stand-alone
    scrollbars (see wxScrollBar) and sliders (see wxSlider).
    """

    def __init__(self, commandType=wxEVT_NULL, id=0, pos=0, orientation=0):
        """
        ScrollEvent(commandType=wxEVT_NULL, id=0, pos=0, orientation=0)
        
        A scroll event holds information about events sent from stand-alone
        scrollbars (see wxScrollBar) and sliders (see wxSlider).
        """

    def GetOrientation(self):
        """
        GetOrientation() -> int
        
        Returns wxHORIZONTAL or wxVERTICAL, depending on the orientation of
        the scrollbar.
        """

    def GetPosition(self):
        """
        GetPosition() -> int
        
        Returns the position of the scrollbar.
        """

    def SetOrientation(self, orient):
        """
        SetOrientation(orient)
        """

    def SetPosition(self, pos):
        """
        SetPosition(pos)
        """
    Orientation = property(None, None)
    Position = property(None, None)
# end of class ScrollEvent


class ScrollWinEvent(Event):
    """
    ScrollWinEvent(commandType=wxEVT_NULL, pos=0, orientation=0)
    
    A scroll event holds information about events sent from scrolling
    windows.
    """

    def __init__(self, commandType=wxEVT_NULL, pos=0, orientation=0):
        """
        ScrollWinEvent(commandType=wxEVT_NULL, pos=0, orientation=0)
        
        A scroll event holds information about events sent from scrolling
        windows.
        """

    def GetOrientation(self):
        """
        GetOrientation() -> int
        
        Returns wxHORIZONTAL or wxVERTICAL, depending on the orientation of
        the scrollbar.
        """

    def GetPosition(self):
        """
        GetPosition() -> int
        
        Returns the position of the scrollbar for the thumb track and release
        events.
        """

    def SetOrientation(self, orient):
        """
        SetOrientation(orient)
        """

    def SetPosition(self, pos):
        """
        SetPosition(pos)
        """
    Orientation = property(None, None)
    Position = property(None, None)
# end of class ScrollWinEvent


class SetCursorEvent(Event):
    """
    SetCursorEvent(x=0, y=0)
    
    A wxSetCursorEvent is generated from wxWindow when the mouse cursor is
    about to be set as a result of mouse motion.
    """

    def __init__(self, x=0, y=0):
        """
        SetCursorEvent(x=0, y=0)
        
        A wxSetCursorEvent is generated from wxWindow when the mouse cursor is
        about to be set as a result of mouse motion.
        """

    def GetCursor(self):
        """
        GetCursor() -> Cursor
        
        Returns a reference to the cursor specified by this event.
        """

    def GetX(self):
        """
        GetX() -> Coord
        
        Returns the X coordinate of the mouse in client coordinates.
        """

    def GetY(self):
        """
        GetY() -> Coord
        
        Returns the Y coordinate of the mouse in client coordinates.
        """

    def HasCursor(self):
        """
        HasCursor() -> bool
        
        Returns true if the cursor specified by this event is a valid cursor.
        """

    def SetCursor(self, cursor):
        """
        SetCursor(cursor)
        
        Sets the cursor associated with this event.
        """
    Cursor = property(None, None)
    X = property(None, None)
    Y = property(None, None)
# end of class SetCursorEvent


class ShowEvent(Event):
    """
    ShowEvent(winid=0, show=False)
    
    An event being sent when the window is shown or hidden.
    """

    def __init__(self, winid=0, show=False):
        """
        ShowEvent(winid=0, show=False)
        
        An event being sent when the window is shown or hidden.
        """

    def SetShow(self, show):
        """
        SetShow(show)
        
        Set whether the windows was shown or hidden.
        """

    def IsShown(self):
        """
        IsShown() -> bool
        
        Return true if the window has been shown, false if it has been hidden.
        """
    Show = property(None, None)
# end of class ShowEvent


class SizeEvent(Event):
    """
    SizeEvent(sz, id=0)
    
    A size event holds information about size change events of wxWindow.
    """

    def __init__(self, sz, id=0):
        """
        SizeEvent(sz, id=0)
        
        A size event holds information about size change events of wxWindow.
        """

    def GetSize(self):
        """
        GetSize() -> Size
        
        Returns the entire size of the window generating the size change
        event.
        """

    def SetSize(self, size):
        """
        SetSize(size)
        """

    def GetRect(self):
        """
        GetRect() -> Rect
        """

    def SetRect(self, rect):
        """
        SetRect(rect)
        """
    Rect = property(None, None)
    Size = property(None, None)
# end of class SizeEvent


class SysColourChangedEvent(Event):
    """
    SysColourChangedEvent()
    
    This class is used for system colour change events, which are
    generated when the user changes the colour settings using the control
    panel.
    """

    def __init__(self):
        """
        SysColourChangedEvent()
        
        This class is used for system colour change events, which are
        generated when the user changes the colour settings using the control
        panel.
        """
# end of class SysColourChangedEvent


class UpdateUIEvent(CommandEvent):
    """
    UpdateUIEvent(commandId=0)
    
    This class is used for pseudo-events which are called by wxWidgets to
    give an application the chance to update various user interface
    elements.
    """

    def __init__(self, commandId=0):
        """
        UpdateUIEvent(commandId=0)
        
        This class is used for pseudo-events which are called by wxWidgets to
        give an application the chance to update various user interface
        elements.
        """

    def Check(self, check):
        """
        Check(check)
        
        Check or uncheck the UI element.
        """

    def Enable(self, enable):
        """
        Enable(enable)
        
        Enable or disable the UI element.
        """

    def GetChecked(self):
        """
        GetChecked() -> bool
        
        Returns true if the UI element should be checked.
        """

    def GetEnabled(self):
        """
        GetEnabled() -> bool
        
        Returns true if the UI element should be enabled.
        """

    def GetSetChecked(self):
        """
        GetSetChecked() -> bool
        
        Returns true if the application has called Check().
        """

    def GetSetEnabled(self):
        """
        GetSetEnabled() -> bool
        
        Returns true if the application has called Enable().
        """

    def GetSetShown(self):
        """
        GetSetShown() -> bool
        
        Returns true if the application has called Show().
        """

    def GetSetText(self):
        """
        GetSetText() -> bool
        
        Returns true if the application has called SetText().
        """

    def GetShown(self):
        """
        GetShown() -> bool
        
        Returns true if the UI element should be shown.
        """

    def GetText(self):
        """
        GetText() -> String
        
        Returns the text that should be set for the UI element.
        """

    def SetText(self, text):
        """
        SetText(text)
        
        Sets the text for this UI element.
        """

    def Show(self, show):
        """
        Show(show)
        
        Show or hide the UI element.
        """

    @staticmethod
    def CanUpdate(window):
        """
        CanUpdate(window) -> bool
        
        Returns true if it is appropriate to update (send UI update events to)
        this window.
        """

    @staticmethod
    def GetMode():
        """
        GetMode() -> UpdateUIMode
        
        Static function returning a value specifying how wxWidgets will send
        update events: to all windows, or only to those which specify that
        they will process the events.
        """

    @staticmethod
    def GetUpdateInterval():
        """
        GetUpdateInterval() -> long
        
        Returns the current interval between updates in milliseconds.
        """

    @staticmethod
    def ResetUpdateTime():
        """
        ResetUpdateTime()
        
        Used internally to reset the last-updated time to the current time.
        """

    @staticmethod
    def SetMode(mode):
        """
        SetMode(mode)
        
        Specify how wxWidgets will send update events: to all windows, or only
        to those which specify that they will process the events.
        """

    @staticmethod
    def SetUpdateInterval(updateInterval):
        """
        SetUpdateInterval(updateInterval)
        
        Sets the interval between updates in milliseconds.
        """
    Checked = property(None, None)
    Enabled = property(None, None)
    Shown = property(None, None)
    Text = property(None, None)
# end of class UpdateUIEvent


class WindowCreateEvent(CommandEvent):
    """
    WindowCreateEvent(win=None)
    
    This event is sent just after the actual window associated with a
    wxWindow object has been created.
    """

    def __init__(self, win=None):
        """
        WindowCreateEvent(win=None)
        
        This event is sent just after the actual window associated with a
        wxWindow object has been created.
        """

    def GetWindow(self):
        """
        GetWindow() -> Window
        
        Return the window being created.
        """
    Window = property(None, None)
# end of class WindowCreateEvent


class WindowDestroyEvent(CommandEvent):
    """
    WindowDestroyEvent(win=None)
    
    This event is sent as early as possible during the window destruction
    process.
    """

    def __init__(self, win=None):
        """
        WindowDestroyEvent(win=None)
        
        This event is sent as early as possible during the window destruction
        process.
        """

    def GetWindow(self):
        """
        GetWindow() -> Window
        
        Return the window being destroyed.
        """
    Window = property(None, None)
# end of class WindowDestroyEvent


def NewEventType():
    """
    NewEventType() -> EventType
    
    Generates a new unique event type.
    """

def PostEvent(dest, event):
    """
    PostEvent(dest, event)
    
    In a GUI application, this function posts event to the specified dest
    object using wxEvtHandler::AddPendingEvent().
    """

def QueueEvent(dest, event):
    """
    QueueEvent(dest, event)
    
    Queue an event for processing on the given object.
    """
class PyEventBinder(object):
    """
    Instances of this class are used to bind specific events to event handlers.
    """

    def __init__(self, evtType, expectedIDs=0):
        pass

    def Bind(self, target, id1, id2, function):
        """
        Bind this set of event types to target using its Connect() method.
        """
        pass

    def Unbind(self, target, id1, id2, handler=None):
        """
        Remove an event binding.
        """
        pass

    def _getEvtType(self):
        """
        Make it easy to get to the default wxEventType typeID for this
        event binder.
        """
        pass
    typeId = property(None, None)

    @wx.deprecated
    def __call__(self, *args):
        """
        For backwards compatibility with the old ``EVT_*`` functions.
        Should be called with either (window, func), (window, ID,
        func) or (window, ID1, ID2, func) parameters depending on the
        type of the event.
        """
        pass

#-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# This code block was included from src/event_ex.py
# Create some event binders
EVT_SIZE = wx.PyEventBinder( wxEVT_SIZE )
EVT_SIZING = wx.PyEventBinder( wxEVT_SIZING )
EVT_MOVE = wx.PyEventBinder( wxEVT_MOVE )
EVT_MOVING = wx.PyEventBinder( wxEVT_MOVING )
EVT_MOVE_START = wx.PyEventBinder( wxEVT_MOVE_START )
EVT_MOVE_END = wx.PyEventBinder( wxEVT_MOVE_END )
EVT_CLOSE = wx.PyEventBinder( wxEVT_CLOSE_WINDOW )
EVT_END_SESSION = wx.PyEventBinder( wxEVT_END_SESSION )
EVT_QUERY_END_SESSION = wx.PyEventBinder( wxEVT_QUERY_END_SESSION )
EVT_PAINT = wx.PyEventBinder( wxEVT_PAINT )
EVT_NC_PAINT = wx.PyEventBinder( wxEVT_NC_PAINT )
EVT_ERASE_BACKGROUND = wx.PyEventBinder( wxEVT_ERASE_BACKGROUND )
EVT_CHAR = wx.PyEventBinder( wxEVT_CHAR )
EVT_KEY_DOWN = wx.PyEventBinder( wxEVT_KEY_DOWN )
EVT_KEY_UP = wx.PyEventBinder( wxEVT_KEY_UP )
EVT_HOTKEY = wx.PyEventBinder( wxEVT_HOTKEY, 1)
EVT_CHAR_HOOK = wx.PyEventBinder( wxEVT_CHAR_HOOK )
EVT_MENU_OPEN = wx.PyEventBinder( wxEVT_MENU_OPEN )
EVT_MENU_CLOSE = wx.PyEventBinder( wxEVT_MENU_CLOSE )
EVT_MENU_HIGHLIGHT = wx.PyEventBinder( wxEVT_MENU_HIGHLIGHT, 1)
EVT_MENU_HIGHLIGHT_ALL = wx.PyEventBinder( wxEVT_MENU_HIGHLIGHT )
EVT_SET_FOCUS = wx.PyEventBinder( wxEVT_SET_FOCUS )
EVT_KILL_FOCUS = wx.PyEventBinder( wxEVT_KILL_FOCUS )
EVT_CHILD_FOCUS = wx.PyEventBinder( wxEVT_CHILD_FOCUS )
EVT_ACTIVATE = wx.PyEventBinder( wxEVT_ACTIVATE )
EVT_ACTIVATE_APP = wx.PyEventBinder( wxEVT_ACTIVATE_APP )
EVT_HIBERNATE = wx.PyEventBinder( wxEVT_HIBERNATE )
EVT_DROP_FILES = wx.PyEventBinder( wxEVT_DROP_FILES )
EVT_INIT_DIALOG = wx.PyEventBinder( wxEVT_INIT_DIALOG )
EVT_SYS_COLOUR_CHANGED = wx.PyEventBinder( wxEVT_SYS_COLOUR_CHANGED )
EVT_DISPLAY_CHANGED = wx.PyEventBinder( wxEVT_DISPLAY_CHANGED )
EVT_SHOW = wx.PyEventBinder( wxEVT_SHOW )
EVT_MAXIMIZE = wx.PyEventBinder( wxEVT_MAXIMIZE )
EVT_ICONIZE = wx.PyEventBinder( wxEVT_ICONIZE )
EVT_NAVIGATION_KEY = wx.PyEventBinder( wxEVT_NAVIGATION_KEY )
EVT_PALETTE_CHANGED = wx.PyEventBinder( wxEVT_PALETTE_CHANGED )
EVT_QUERY_NEW_PALETTE = wx.PyEventBinder( wxEVT_QUERY_NEW_PALETTE )
EVT_WINDOW_CREATE = wx.PyEventBinder( wxEVT_CREATE )
EVT_WINDOW_DESTROY = wx.PyEventBinder( wxEVT_DESTROY )
EVT_SET_CURSOR = wx.PyEventBinder( wxEVT_SET_CURSOR )
EVT_MOUSE_CAPTURE_CHANGED = wx.PyEventBinder( wxEVT_MOUSE_CAPTURE_CHANGED )
EVT_MOUSE_CAPTURE_LOST = wx.PyEventBinder( wxEVT_MOUSE_CAPTURE_LOST )

EVT_LEFT_DOWN = wx.PyEventBinder( wxEVT_LEFT_DOWN )
EVT_LEFT_UP = wx.PyEventBinder( wxEVT_LEFT_UP )
EVT_MIDDLE_DOWN = wx.PyEventBinder( wxEVT_MIDDLE_DOWN )
EVT_MIDDLE_UP = wx.PyEventBinder( wxEVT_MIDDLE_UP )
EVT_RIGHT_DOWN = wx.PyEventBinder( wxEVT_RIGHT_DOWN )
EVT_RIGHT_UP = wx.PyEventBinder( wxEVT_RIGHT_UP )
EVT_MOTION = wx.PyEventBinder( wxEVT_MOTION )
EVT_LEFT_DCLICK = wx.PyEventBinder( wxEVT_LEFT_DCLICK )
EVT_MIDDLE_DCLICK = wx.PyEventBinder( wxEVT_MIDDLE_DCLICK )
EVT_RIGHT_DCLICK = wx.PyEventBinder( wxEVT_RIGHT_DCLICK )
EVT_LEAVE_WINDOW = wx.PyEventBinder( wxEVT_LEAVE_WINDOW )
EVT_ENTER_WINDOW = wx.PyEventBinder( wxEVT_ENTER_WINDOW )
EVT_MOUSEWHEEL = wx.PyEventBinder( wxEVT_MOUSEWHEEL )
EVT_MOUSE_AUX1_DOWN = wx.PyEventBinder( wxEVT_AUX1_DOWN )
EVT_MOUSE_AUX1_UP = wx.PyEventBinder( wxEVT_AUX1_UP )
EVT_MOUSE_AUX1_DCLICK = wx.PyEventBinder( wxEVT_AUX1_DCLICK )
EVT_MOUSE_AUX2_DOWN = wx.PyEventBinder( wxEVT_AUX2_DOWN )
EVT_MOUSE_AUX2_UP = wx.PyEventBinder( wxEVT_AUX2_UP )
EVT_MOUSE_AUX2_DCLICK = wx.PyEventBinder( wxEVT_AUX2_DCLICK )

EVT_MOUSE_EVENTS = wx.PyEventBinder([ wxEVT_LEFT_DOWN,
                                      wxEVT_LEFT_UP,
                                      wxEVT_MIDDLE_DOWN,
                                      wxEVT_MIDDLE_UP,
                                      wxEVT_RIGHT_DOWN,
                                      wxEVT_RIGHT_UP,
                                      wxEVT_MOTION,
                                      wxEVT_LEFT_DCLICK,
                                      wxEVT_MIDDLE_DCLICK,
                                      wxEVT_RIGHT_DCLICK,
                                      wxEVT_ENTER_WINDOW,
                                      wxEVT_LEAVE_WINDOW,
                                      wxEVT_MOUSEWHEEL,
                                      wxEVT_AUX1_DOWN,
                                      wxEVT_AUX1_UP,
                                      wxEVT_AUX1_DCLICK,
                                      wxEVT_AUX2_DOWN,
                                      wxEVT_AUX2_UP,
                                      wxEVT_AUX2_DCLICK,
                                     ])


# Scrolling from wxWindow (sent to wxScrolledWindow)
EVT_SCROLLWIN = wx.PyEventBinder([ wxEVT_SCROLLWIN_TOP,
                                  wxEVT_SCROLLWIN_BOTTOM,
                                  wxEVT_SCROLLWIN_LINEUP,
                                  wxEVT_SCROLLWIN_LINEDOWN,
                                  wxEVT_SCROLLWIN_PAGEUP,
                                  wxEVT_SCROLLWIN_PAGEDOWN,
                                  wxEVT_SCROLLWIN_THUMBTRACK,
                                  wxEVT_SCROLLWIN_THUMBRELEASE,
                                  ])

EVT_SCROLLWIN_TOP = wx.PyEventBinder( wxEVT_SCROLLWIN_TOP )
EVT_SCROLLWIN_BOTTOM = wx.PyEventBinder( wxEVT_SCROLLWIN_BOTTOM )
EVT_SCROLLWIN_LINEUP = wx.PyEventBinder( wxEVT_SCROLLWIN_LINEUP )
EVT_SCROLLWIN_LINEDOWN = wx.PyEventBinder( wxEVT_SCROLLWIN_LINEDOWN )
EVT_SCROLLWIN_PAGEUP = wx.PyEventBinder( wxEVT_SCROLLWIN_PAGEUP )
EVT_SCROLLWIN_PAGEDOWN = wx.PyEventBinder( wxEVT_SCROLLWIN_PAGEDOWN )
EVT_SCROLLWIN_THUMBTRACK = wx.PyEventBinder( wxEVT_SCROLLWIN_THUMBTRACK )
EVT_SCROLLWIN_THUMBRELEASE = wx.PyEventBinder( wxEVT_SCROLLWIN_THUMBRELEASE )

# Scrolling from wx.Slider and wx.ScrollBar
EVT_SCROLL = wx.PyEventBinder([ wxEVT_SCROLL_TOP,
                               wxEVT_SCROLL_BOTTOM,
                               wxEVT_SCROLL_LINEUP,
                               wxEVT_SCROLL_LINEDOWN,
                               wxEVT_SCROLL_PAGEUP,
                               wxEVT_SCROLL_PAGEDOWN,
                               wxEVT_SCROLL_THUMBTRACK,
                               wxEVT_SCROLL_THUMBRELEASE,
                               wxEVT_SCROLL_CHANGED,
                               ])

EVT_SCROLL_TOP = wx.PyEventBinder( wxEVT_SCROLL_TOP )
EVT_SCROLL_BOTTOM = wx.PyEventBinder( wxEVT_SCROLL_BOTTOM )
EVT_SCROLL_LINEUP = wx.PyEventBinder( wxEVT_SCROLL_LINEUP )
EVT_SCROLL_LINEDOWN = wx.PyEventBinder( wxEVT_SCROLL_LINEDOWN )
EVT_SCROLL_PAGEUP = wx.PyEventBinder( wxEVT_SCROLL_PAGEUP )
EVT_SCROLL_PAGEDOWN = wx.PyEventBinder( wxEVT_SCROLL_PAGEDOWN )
EVT_SCROLL_THUMBTRACK = wx.PyEventBinder( wxEVT_SCROLL_THUMBTRACK )
EVT_SCROLL_THUMBRELEASE = wx.PyEventBinder( wxEVT_SCROLL_THUMBRELEASE )
EVT_SCROLL_CHANGED = wx.PyEventBinder( wxEVT_SCROLL_CHANGED )
EVT_SCROLL_ENDSCROLL = EVT_SCROLL_CHANGED

# Scrolling from wx.Slider and wx.ScrollBar, with an id
EVT_COMMAND_SCROLL = wx.PyEventBinder([ wxEVT_SCROLL_TOP,
                                       wxEVT_SCROLL_BOTTOM,
                                       wxEVT_SCROLL_LINEUP,
                                       wxEVT_SCROLL_LINEDOWN,
                                       wxEVT_SCROLL_PAGEUP,
                                       wxEVT_SCROLL_PAGEDOWN,
                                       wxEVT_SCROLL_THUMBTRACK,
                                       wxEVT_SCROLL_THUMBRELEASE,
                                       wxEVT_SCROLL_CHANGED,
                                       ], 1)

EVT_COMMAND_SCROLL_TOP = wx.PyEventBinder( wxEVT_SCROLL_TOP, 1)
EVT_COMMAND_SCROLL_BOTTOM = wx.PyEventBinder( wxEVT_SCROLL_BOTTOM, 1)
EVT_COMMAND_SCROLL_LINEUP = wx.PyEventBinder( wxEVT_SCROLL_LINEUP, 1)
EVT_COMMAND_SCROLL_LINEDOWN = wx.PyEventBinder( wxEVT_SCROLL_LINEDOWN, 1)
EVT_COMMAND_SCROLL_PAGEUP = wx.PyEventBinder( wxEVT_SCROLL_PAGEUP, 1)
EVT_COMMAND_SCROLL_PAGEDOWN = wx.PyEventBinder( wxEVT_SCROLL_PAGEDOWN, 1)
EVT_COMMAND_SCROLL_THUMBTRACK = wx.PyEventBinder( wxEVT_SCROLL_THUMBTRACK, 1)
EVT_COMMAND_SCROLL_THUMBRELEASE = wx.PyEventBinder( wxEVT_SCROLL_THUMBRELEASE, 1)
EVT_COMMAND_SCROLL_CHANGED = wx.PyEventBinder( wxEVT_SCROLL_CHANGED, 1)
EVT_COMMAND_SCROLL_ENDSCROLL = EVT_COMMAND_SCROLL_CHANGED

EVT_BUTTON = wx.PyEventBinder( wxEVT_BUTTON, 1)
EVT_CHECKBOX = wx.PyEventBinder( wxEVT_CHECKBOX, 1)
EVT_CHOICE = wx.PyEventBinder( wxEVT_CHOICE, 1)
EVT_LISTBOX = wx.PyEventBinder( wxEVT_LISTBOX, 1)
EVT_LISTBOX_DCLICK = wx.PyEventBinder( wxEVT_LISTBOX_DCLICK, 1)
EVT_MENU = wx.PyEventBinder( wxEVT_MENU, 1)
EVT_MENU_RANGE = wx.PyEventBinder( wxEVT_MENU, 2)
EVT_SLIDER = wx.PyEventBinder( wxEVT_SLIDER, 1)
EVT_RADIOBOX = wx.PyEventBinder( wxEVT_RADIOBOX, 1)
EVT_RADIOBUTTON = wx.PyEventBinder( wxEVT_RADIOBUTTON, 1)

EVT_SCROLLBAR = wx.PyEventBinder( wxEVT_SCROLLBAR, 1)
EVT_VLBOX = wx.PyEventBinder( wxEVT_VLBOX, 1)
EVT_COMBOBOX = wx.PyEventBinder( wxEVT_COMBOBOX, 1)
EVT_TOOL = wx.PyEventBinder( wxEVT_TOOL, 1)
EVT_TOOL_RANGE = wx.PyEventBinder( wxEVT_TOOL, 2)
EVT_TOOL_RCLICKED = wx.PyEventBinder( wxEVT_TOOL_RCLICKED, 1)
EVT_TOOL_RCLICKED_RANGE = wx.PyEventBinder( wxEVT_TOOL_RCLICKED, 2)
EVT_TOOL_ENTER = wx.PyEventBinder( wxEVT_TOOL_ENTER, 1)
EVT_TOOL_DROPDOWN = wx.PyEventBinder( wxEVT_TOOL_DROPDOWN, 1)
EVT_CHECKLISTBOX = wx.PyEventBinder( wxEVT_CHECKLISTBOX, 1)
EVT_COMBOBOX_DROPDOWN = wx.PyEventBinder( wxEVT_COMBOBOX_DROPDOWN , 1)
EVT_COMBOBOX_CLOSEUP  = wx.PyEventBinder( wxEVT_COMBOBOX_CLOSEUP , 1)

EVT_COMMAND_LEFT_CLICK = wx.PyEventBinder( wxEVT_COMMAND_LEFT_CLICK, 1)
EVT_COMMAND_LEFT_DCLICK = wx.PyEventBinder( wxEVT_COMMAND_LEFT_DCLICK, 1)
EVT_COMMAND_RIGHT_CLICK = wx.PyEventBinder( wxEVT_COMMAND_RIGHT_CLICK, 1)
EVT_COMMAND_RIGHT_DCLICK = wx.PyEventBinder( wxEVT_COMMAND_RIGHT_DCLICK, 1)
EVT_COMMAND_SET_FOCUS = wx.PyEventBinder( wxEVT_COMMAND_SET_FOCUS, 1)
EVT_COMMAND_KILL_FOCUS = wx.PyEventBinder( wxEVT_COMMAND_KILL_FOCUS, 1)
EVT_COMMAND_ENTER = wx.PyEventBinder( wxEVT_COMMAND_ENTER, 1)

EVT_HELP = wx.PyEventBinder( wxEVT_HELP, 1)
EVT_HELP_RANGE = wx.PyEventBinder(  wxEVT_HELP, 2)
EVT_DETAILED_HELP = wx.PyEventBinder( wxEVT_DETAILED_HELP, 1)
EVT_DETAILED_HELP_RANGE = wx.PyEventBinder( wxEVT_DETAILED_HELP, 2)

EVT_IDLE = wx.PyEventBinder( wxEVT_IDLE )

EVT_UPDATE_UI = wx.PyEventBinder( wxEVT_UPDATE_UI, 1)
EVT_UPDATE_UI_RANGE = wx.PyEventBinder( wxEVT_UPDATE_UI, 2)

EVT_CONTEXT_MENU = wx.PyEventBinder( wxEVT_CONTEXT_MENU )

EVT_THREAD = wx.PyEventBinder( wxEVT_THREAD )

EVT_WINDOW_MODAL_DIALOG_CLOSED = wx.PyEventBinder( wxEVT_WINDOW_MODAL_DIALOG_CLOSED )

EVT_JOY_BUTTON_DOWN = wx.PyEventBinder( wxEVT_JOY_BUTTON_DOWN )
EVT_JOY_BUTTON_UP = wx.PyEventBinder( wxEVT_JOY_BUTTON_UP )
EVT_JOY_MOVE = wx.PyEventBinder( wxEVT_JOY_MOVE )
EVT_JOY_ZMOVE = wx.PyEventBinder( wxEVT_JOY_ZMOVE )
EVT_JOYSTICK_EVENTS = wx.PyEventBinder([ wxEVT_JOY_BUTTON_DOWN,
                                        wxEVT_JOY_BUTTON_UP,
                                        wxEVT_JOY_MOVE,
                                        wxEVT_JOY_ZMOVE,
                                        ])

# deprecated wxEVT aliases
wxEVT_COMMAND_BUTTON_CLICKED         = wxEVT_BUTTON
wxEVT_COMMAND_CHECKBOX_CLICKED       = wxEVT_CHECKBOX
wxEVT_COMMAND_CHOICE_SELECTED        = wxEVT_CHOICE
wxEVT_COMMAND_LISTBOX_SELECTED       = wxEVT_LISTBOX
wxEVT_COMMAND_LISTBOX_DOUBLECLICKED  = wxEVT_LISTBOX_DCLICK
wxEVT_COMMAND_CHECKLISTBOX_TOGGLED   = wxEVT_CHECKLISTBOX
wxEVT_COMMAND_MENU_SELECTED          = wxEVT_MENU
wxEVT_COMMAND_TOOL_CLICKED           = wxEVT_TOOL
wxEVT_COMMAND_SLIDER_UPDATED         = wxEVT_SLIDER
wxEVT_COMMAND_RADIOBOX_SELECTED      = wxEVT_RADIOBOX
wxEVT_COMMAND_RADIOBUTTON_SELECTED   = wxEVT_RADIOBUTTON
wxEVT_COMMAND_SCROLLBAR_UPDATED      = wxEVT_SCROLLBAR
wxEVT_COMMAND_VLBOX_SELECTED         = wxEVT_VLBOX
wxEVT_COMMAND_COMBOBOX_SELECTED      = wxEVT_COMBOBOX
wxEVT_COMMAND_TOOL_RCLICKED          = wxEVT_TOOL_RCLICKED
wxEVT_COMMAND_TOOL_DROPDOWN_CLICKED  = wxEVT_TOOL_DROPDOWN
wxEVT_COMMAND_TOOL_ENTER             = wxEVT_TOOL_ENTER
wxEVT_COMMAND_COMBOBOX_DROPDOWN      = wxEVT_COMBOBOX_DROPDOWN
wxEVT_COMMAND_COMBOBOX_CLOSEUP       = wxEVT_COMBOBOX_CLOSEUP

# End of included code block
#-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

PyEvtHandler = wx.deprecated(EvtHandler, "Use :class:`EvtHandler` instead.")
#-- end-event --#
#-- begin-pyevent --#

class PyEvent(Event):
    """
    PyEvent(id=0, eventType=wxEVT_NULL)
    
    :class:`PyEvent` can be used as a base class for implementing custom
    event types in Python. You should derive from this class instead
    of :class:`Event` because this class is Python-aware and is able to
    transport its Python bits safely through the wxWidgets event
    system and have them still be there when the event handler is
    invoked. Note that since :class:`PyEvent` is taking care of preserving
    the extra attributes that have been set then you do not need to
    override the Clone method in your derived classes.
    
    :see: :class:`PyCommandEvent`
    """

    def __init__(self, id=0, eventType=wxEVT_NULL):
        """
        PyEvent(id=0, eventType=wxEVT_NULL)
        
        :class:`PyEvent` can be used as a base class for implementing custom
        event types in Python. You should derive from this class instead
        of :class:`Event` because this class is Python-aware and is able to
        transport its Python bits safely through the wxWidgets event
        system and have them still be there when the event handler is
        invoked. Note that since :class:`PyEvent` is taking care of preserving
        the extra attributes that have been set then you do not need to
        override the Clone method in your derived classes.
        
        :see: :class:`PyCommandEvent`
        """

    def __getattr__(self, name):
        """
        __getattr__(name) -> PyObject
        """

    def __delattr__(self, name):
        """
        __delattr__(name)
        """

    def __setattr__(self, name, value):
        """
        __setattr__(name, value)
        """

    def Clone(self):
        """
        Clone() -> Event
        """

    def _getAttrDict(self):
        """
        _getAttrDict() -> PyObject
        
        Gives access to the internal object that is tracking the event's
        python attributes.
        """

    def Clone(self):
        """
        Make a new instance of the event that is a copy of self.
        
        Through the magic of Python this implementation should work for
        this and all derived classes.
        """
# end of class PyEvent


class PyCommandEvent(CommandEvent):
    """
    PyCommandEvent(eventType=wxEVT_NULL, id=0)
    
    :class:`PyCommandEvent` can be used as a base class for implementing
    custom event types in Python. You should derive from this class
    instead of :class:`CommandEvent` because this class is Python-aware
    and is able to transport its Python bits safely through the
    wxWidgets event system and have them still be there when the
    event handler is invoked. Note that since :class:`PyCommandEvent` is
    taking care of preserving the extra attributes that have been set
    then you do not need to override the Clone method in your
    derived classes.
    
    :see: :class:`PyEvent`
    """

    def __init__(self, eventType=wxEVT_NULL, id=0):
        """
        PyCommandEvent(eventType=wxEVT_NULL, id=0)
        
        :class:`PyCommandEvent` can be used as a base class for implementing
        custom event types in Python. You should derive from this class
        instead of :class:`CommandEvent` because this class is Python-aware
        and is able to transport its Python bits safely through the
        wxWidgets event system and have them still be there when the
        event handler is invoked. Note that since :class:`PyCommandEvent` is
        taking care of preserving the extra attributes that have been set
        then you do not need to override the Clone method in your
        derived classes.
        
        :see: :class:`PyEvent`
        """

    def __getattr__(self, name):
        """
        __getattr__(name) -> PyObject
        """

    def __delattr__(self, name):
        """
        __delattr__(name)
        """

    def __setattr__(self, name, value):
        """
        __setattr__(name, value)
        """

    def Clone(self):
        """
        Clone() -> Event
        """

    def _getAttrDict(self):
        """
        _getAttrDict() -> PyObject
        
        Gives access to the internal object that is tracking the event's
        python attributes.
        """

    def Clone(self):
        """
        Make a new instance of the event that is a copy of self.
        
        Through the magic of Python this implementation should work for
        this and all derived classes.
        """
# end of class PyCommandEvent

#-- end-pyevent --#
#-- begin-sizer --#
FLEX_GROWMODE_NONE = 0
FLEX_GROWMODE_SPECIFIED = 0
FLEX_GROWMODE_ALL = 0

class SizerItem(Object):
    """
    SizerItem(window, flags)
    SizerItem(window, proportion=0, flag=0, border=0, userData=None)
    SizerItem(sizer, flags)
    SizerItem(sizer, proportion=0, flag=0, border=0, userData=None)
    SizerItem(width, height, proportion=0, flag=0, border=0, userData=None)
    
    The wxSizerItem class is used to track the position, size and other
    attributes of each item managed by a wxSizer.
    """

    def __init__(self, *args, **kw):
        """
        SizerItem(window, flags)
        SizerItem(window, proportion=0, flag=0, border=0, userData=None)
        SizerItem(sizer, flags)
        SizerItem(sizer, proportion=0, flag=0, border=0, userData=None)
        SizerItem(width, height, proportion=0, flag=0, border=0, userData=None)
        
        The wxSizerItem class is used to track the position, size and other
        attributes of each item managed by a wxSizer.
        """

    def AssignSpacer(self, *args, **kw):
        """
        AssignSpacer(size)
        AssignSpacer(w, h)
        
        Set the size of the spacer tracked by this item.
        """

    def SetRatio(self, *args, **kw):
        """
        SetRatio(width, height)
        SetRatio(size)
        SetRatio(ratio)
        
        Set the ratio item attribute.
        """

    def AssignWindow(self, window):
        """
        AssignWindow(window)
        
        Set the window to be tracked by this item.
        """

    def AssignSizer(self, sizer):
        """
        AssignSizer(sizer)
        
        Set the sizer tracked by this item.
        """

    def CalcMin(self):
        """
        CalcMin() -> Size
        
        Calculates the minimum desired size for the item, including any space
        needed by borders.
        """

    def DeleteWindows(self):
        """
        DeleteWindows()
        
        Destroy the window or the windows in a subsizer, depending on the type
        of item.
        """

    def DetachSizer(self):
        """
        DetachSizer()
        
        Enable deleting the SizerItem without destroying the contained sizer.
        """

    def GetBorder(self):
        """
        GetBorder() -> int
        
        Return the border attribute.
        """

    def GetFlag(self):
        """
        GetFlag() -> int
        
        Return the flags attribute.
        """

    def GetId(self):
        """
        GetId() -> int
        
        Return the numeric id of wxSizerItem, or wxID_NONE if the id has not
        been set.
        """

    def GetMinSize(self):
        """
        GetMinSize() -> Size
        
        Get the minimum size needed for the item.
        """

    def SetMinSize(self, *args, **kw):
        """
        SetMinSize(size)
        SetMinSize(x, y)
        
        Sets the minimum size to be allocated for this item.
        """

    def GetPosition(self):
        """
        GetPosition() -> Point
        
        What is the current position of the item, as set in the last Layout.
        """

    def GetProportion(self):
        """
        GetProportion() -> int
        
        Get the proportion item attribute.
        """

    def GetRatio(self):
        """
        GetRatio() -> float
        
        Get the ration item attribute.
        """

    def GetRect(self):
        """
        GetRect() -> Rect
        
        Get the rectangle of the item on the parent window, excluding borders.
        """

    def GetSize(self):
        """
        GetSize() -> Size
        
        Get the current size of the item, as set in the last Layout.
        """

    def GetSizer(self):
        """
        GetSizer() -> Sizer
        
        If this item is tracking a sizer, return it.
        """

    def GetSpacer(self):
        """
        GetSpacer() -> Size
        
        If this item is tracking a spacer, return its size.
        """

    def GetUserData(self):
        """
        GetUserData() -> PyUserData
        
        Get the userData item attribute.
        """

    def GetWindow(self):
        """
        GetWindow() -> Window
        
        If this item is tracking a window then return it.
        """

    def IsShown(self):
        """
        IsShown() -> bool
        
        Returns true if this item is a window or a spacer and it is shown or
        if this item is a sizer and not all of its elements are hidden.
        """

    def IsSizer(self):
        """
        IsSizer() -> bool
        
        Is this item a sizer?
        """

    def IsSpacer(self):
        """
        IsSpacer() -> bool
        
        Is this item a spacer?
        """

    def IsWindow(self):
        """
        IsWindow() -> bool
        
        Is this item a window?
        """

    def SetBorder(self, border):
        """
        SetBorder(border)
        
        Set the border item attribute.
        """

    def SetDimension(self, pos, size):
        """
        SetDimension(pos, size)
        
        Set the position and size of the space allocated to the sizer, and
        adjust the position and size of the item to be within that space
        taking alignment and borders into account.
        """

    def SetFlag(self, flag):
        """
        SetFlag(flag)
        
        Set the flag item attribute.
        """

    def SetId(self, id):
        """
        SetId(id)
        
        Sets the numeric id of the wxSizerItem to id.
        """

    def SetInitSize(self, x, y):
        """
        SetInitSize(x, y)
        """

    def SetProportion(self, proportion):
        """
        SetProportion(proportion)
        
        Set the proportion item attribute.
        """

    def SetUserData(self, userData):
        """
        SetUserData(userData)
        """

    def Show(self, show):
        """
        Show(show)
        
        Set the show item attribute, which sizers use to determine if the item
        is to be made part of the layout or not.
        """
    Border = property(None, None)
    Flag = property(None, None)
    Id = property(None, None)
    MinSize = property(None, None)
    Position = property(None, None)
    Proportion = property(None, None)
    Ratio = property(None, None)
    Rect = property(None, None)
    Size = property(None, None)
    Sizer = property(None, None)
    Spacer = property(None, None)
    UserData = property(None, None)
    Window = property(None, None)
# end of class SizerItem


class SizerFlags(object):
    """
    SizerFlags(proportion=0)
    
    Container for sizer items flags providing readable names for them.
    """

    def __init__(self, proportion=0):
        """
        SizerFlags(proportion=0)
        
        Container for sizer items flags providing readable names for them.
        """

    def Align(self, alignment):
        """
        Align(alignment) -> SizerFlags
        
        Sets the alignment of this wxSizerFlags to align.
        """

    def Border(self, *args, **kw):
        """
        Border(direction, borderinpixels) -> SizerFlags
        Border(direction=ALL) -> SizerFlags
        
        Sets the wxSizerFlags to have a border of a number of pixels specified
        by borderinpixels with the directions specified by direction.
        """

    def Bottom(self):
        """
        Bottom() -> SizerFlags
        
        Aligns the object to the bottom, similar for Align(wxALIGN_BOTTOM).
        """

    def Center(self):
        """
        Center() -> SizerFlags
        
        Sets the object of the wxSizerFlags to center itself in the area it is
        given.
        """

    def Centre(self):
        """
        Centre() -> SizerFlags
        
        Center() for people with the other dialect of English.
        """

    def DoubleBorder(self, direction=ALL):
        """
        DoubleBorder(direction=ALL) -> SizerFlags
        
        Sets the border in the given direction having twice the default border
        size.
        """

    def DoubleHorzBorder(self):
        """
        DoubleHorzBorder() -> SizerFlags
        
        Sets the border in left and right directions having twice the default
        border size.
        """

    def Expand(self):
        """
        Expand() -> SizerFlags
        
        Sets the object of the wxSizerFlags to expand to fill as much area as
        it can.
        """

    def FixedMinSize(self):
        """
        FixedMinSize() -> SizerFlags
        
        Set the wxFIXED_MINSIZE flag which indicates that the initial size of
        the window should be also set as its minimal size.
        """

    def ReserveSpaceEvenIfHidden(self):
        """
        ReserveSpaceEvenIfHidden() -> SizerFlags
        
        Set the wxRESERVE_SPACE_EVEN_IF_HIDDEN flag.
        """

    def Left(self):
        """
        Left() -> SizerFlags
        
        Aligns the object to the left, similar for Align(wxALIGN_LEFT).
        """

    def Proportion(self, proportion):
        """
        Proportion(proportion) -> SizerFlags
        
        Sets the proportion of this wxSizerFlags to proportion.
        """

    def Right(self):
        """
        Right() -> SizerFlags
        
        Aligns the object to the right, similar for Align(wxALIGN_RIGHT).
        """

    def Shaped(self):
        """
        Shaped() -> SizerFlags
        
        Set the wx_SHAPED flag which indicates that the elements should always
        keep the fixed width to height ratio equal to its original value.
        """

    def Top(self):
        """
        Top() -> SizerFlags
        
        Aligns the object to the top, similar for Align(wxALIGN_TOP).
        """

    def TripleBorder(self, direction=ALL):
        """
        TripleBorder(direction=ALL) -> SizerFlags
        
        Sets the border in the given direction having thrice the default
        border size.
        """

    @staticmethod
    def GetDefaultBorder():
        """
        GetDefaultBorder() -> int
        
        Returns the border used by default in Border() method.
        """
# end of class SizerFlags


class Sizer(Object):
    """
    Sizer()
    
    wxSizer is the abstract base class used for laying out subwindows in a
    window.
    """

    def __init__(self):
        """
        Sizer()
        
        wxSizer is the abstract base class used for laying out subwindows in a
        window.
        """

    def GetChildren(self):
        """
        GetChildren() -> SizerItemList
        
        Returns the list of the items in this sizer.
        """

    def SetItemMinSize(self, *args, **kw):
        """
        SetItemMinSize(window, width, height) -> bool
        SetItemMinSize(window, size) -> bool
        SetItemMinSize(sizer, width, height) -> bool
        SetItemMinSize(sizer, size) -> bool
        SetItemMinSize(index, width, height) -> bool
        SetItemMinSize(index, size) -> bool
        
        Set an item's minimum size by window, sizer, or position.
        """

    def Add(self, *args, **kw):
        """
        Add(window, flags) -> SizerItem
        Add(window, proportion=0, flag=0, border=0, userData=None) -> SizerItem
        Add(sizer, flags) -> SizerItem
        Add(sizer, proportion=0, flag=0, border=0, userData=None) -> SizerItem
        Add(width, height, proportion=0, flag=0, border=0, userData=None) -> SizerItem
        Add(width, height, flags) -> SizerItem
        Add(item) -> SizerItem
        Add(size, proportion=0, flag=0, border=0, /Transfer/=None) -> SizerItem
        Add(size, flags) -> SizerItem
        
        Appends a child to the sizer.
        """

    def AddSpacer(self, size):
        """
        AddSpacer(size) -> SizerItem
        
        This base function adds non-stretchable space to both the horizontal
        and vertical orientation of the sizer.
        """

    def AddStretchSpacer(self, prop=1):
        """
        AddStretchSpacer(prop=1) -> SizerItem
        
        Adds stretchable space to the sizer.
        """

    def CalcMin(self):
        """
        CalcMin() -> Size
        
        This method is abstract and has to be overwritten by any derived
        class.
        """

    def Clear(self, delete_windows=False):
        """
        Clear(delete_windows=False)
        
        Detaches all children from the sizer.
        """

    def ComputeFittingClientSize(self, window):
        """
        ComputeFittingClientSize(window) -> Size
        
        Computes client area size for window so that it matches the sizer's
        minimal size.
        """

    def ComputeFittingWindowSize(self, window):
        """
        ComputeFittingWindowSize(window) -> Size
        
        Like ComputeFittingClientSize(), but converts the result into window
        size.
        """

    def Detach(self, *args, **kw):
        """
        Detach(window) -> bool
        Detach(sizer) -> bool
        Detach(index) -> bool
        
        Detach the child window from the sizer without destroying it.
        """

    def Fit(self, window):
        """
        Fit(window) -> Size
        
        Tell the sizer to resize the window so that its client area matches
        the sizer's minimal size (ComputeFittingClientSize() is called to
        determine it).
        """

    def FitInside(self, window):
        """
        FitInside(window)
        
        Tell the sizer to resize the virtual size of the window to match the
        sizer's minimal size.
        """

    def InformFirstDirection(self, direction, size, availableOtherDir):
        """
        InformFirstDirection(direction, size, availableOtherDir) -> bool
        
        Inform sizer about the first direction that has been decided (by
        parent item).
        """

    def GetContainingWindow(self):
        """
        GetContainingWindow() -> Window
        
        Returns the window this sizer is used in or NULL if none.
        """

    def SetContainingWindow(self, window):
        """
        SetContainingWindow(window)
        
        Set the window this sizer is used in.
        """

    def GetItemCount(self):
        """
        GetItemCount() -> size_t
        
        Returns the number of items in the sizer.
        """

    def GetItem(self, *args, **kw):
        """
        GetItem(window, recursive=False) -> SizerItem
        GetItem(sizer, recursive=False) -> SizerItem
        GetItem(index) -> SizerItem
        
        Finds wxSizerItem which holds the given window.
        """

    def GetItemById(self, id, recursive=False):
        """
        GetItemById(id, recursive=False) -> SizerItem
        
        Finds item of the sizer which has the given id.
        """

    def GetMinSize(self):
        """
        GetMinSize() -> Size
        
        Returns the minimal size of the sizer.
        """

    def GetPosition(self):
        """
        GetPosition() -> Point
        
        Returns the current position of the sizer.
        """

    def GetSize(self):
        """
        GetSize() -> Size
        
        Returns the current size of the sizer.
        """

    def Hide(self, *args, **kw):
        """
        Hide(window, recursive=False) -> bool
        Hide(sizer, recursive=False) -> bool
        Hide(index) -> bool
        
        Hides the child window.
        """

    def Insert(self, *args, **kw):
        """
        Insert(index, window, flags) -> SizerItem
        Insert(index, window, proportion=0, flag=0, border=0, userData=None) -> SizerItem
        Insert(index, sizer, flags) -> SizerItem
        Insert(index, sizer, proportion=0, flag=0, border=0, userData=None) -> SizerItem
        Insert(index, width, height, proportion=0, flag=0, border=0, userData=None) -> SizerItem
        Insert(index, width, height, flags) -> SizerItem
        Insert(index, item) -> SizerItem
        Insert(index, size, proportion=0, flag=0, border=0, /Transfer/=None) -> SizerItem
        Insert(index, size, flags) -> SizerItem
        
        Insert a child into the sizer before any existing item at index.
        """

    def InsertSpacer(self, index, size):
        """
        InsertSpacer(index, size) -> SizerItem
        
        Inserts non-stretchable space to the sizer.
        """

    def InsertStretchSpacer(self, index, prop=1):
        """
        InsertStretchSpacer(index, prop=1) -> SizerItem
        
        Inserts stretchable space to the sizer.
        """

    def IsEmpty(self):
        """
        IsEmpty() -> bool
        
        Return true if the sizer has no elements.
        """

    def IsShown(self, *args, **kw):
        """
        IsShown(window) -> bool
        IsShown(sizer) -> bool
        IsShown(index) -> bool
        
        Returns true if the window is shown.
        """

    def Layout(self):
        """
        Layout()
        
        Call this to force layout of the children anew, e.g. after having
        added a child to or removed a child (window, other sizer or space)
        from the sizer while keeping the current dimension.
        """

    def Prepend(self, *args, **kw):
        """
        Prepend(window, flags) -> SizerItem
        Prepend(window, proportion=0, flag=0, border=0, userData=None) -> SizerItem
        Prepend(sizer, flags) -> SizerItem
        Prepend(sizer, proportion=0, flag=0, border=0, userData=None) -> SizerItem
        Prepend(width, height, proportion=0, flag=0, border=0, userData=None) -> SizerItem
        Prepend(width, height, flags) -> SizerItem
        Prepend(item) -> SizerItem
        Prepend(size, proportion=0, flag=0, border=0, /Transfer/=None) -> SizerItem
        Prepend(size, flags) -> SizerItem
        
        Same as Add(), but prepends the items to the beginning of the list of
        items (windows, subsizers or spaces) owned by this sizer.
        """

    def PrependSpacer(self, size):
        """
        PrependSpacer(size) -> SizerItem
        
        Prepends non-stretchable space to the sizer.
        """

    def PrependStretchSpacer(self, prop=1):
        """
        PrependStretchSpacer(prop=1) -> SizerItem
        
        Prepends stretchable space to the sizer.
        """

    def RecalcSizes(self):
        """
        RecalcSizes()
        
        This method is abstract and has to be overwritten by any derived
        class.
        """

    def Remove(self, *args, **kw):
        """
        Remove(sizer) -> bool
        Remove(index) -> bool
        
        Removes a sizer child from the sizer and destroys it.
        """

    def Replace(self, *args, **kw):
        """
        Replace(oldwin, newwin, recursive=False) -> bool
        Replace(oldsz, newsz, recursive=False) -> bool
        Replace(index, newitem) -> bool
        
        Detaches the given oldwin from the sizer and replaces it with the
        given newwin.
        """

    def SetDimension(self, *args, **kw):
        """
        SetDimension(x, y, width, height)
        SetDimension(pos, size)
        
        Call this to force the sizer to take the given dimension and thus
        force the items owned by the sizer to resize themselves according to
        the rules defined by the parameter in the Add() and Prepend() methods.
        """

    def SetMinSize(self, *args, **kw):
        """
        SetMinSize(size)
        SetMinSize(width, height)
        
        Call this to give the sizer a minimal size.
        """

    def SetSizeHints(self, window):
        """
        SetSizeHints(window)
        
        This method first calls Fit() and then
        wxTopLevelWindow::SetSizeHints() on the window passed to it.
        """

    def SetVirtualSizeHints(self, window):
        """
        SetVirtualSizeHints(window)
        
        Tell the sizer to set the minimal size of the window virtual area to
        match the sizer's minimal size.
        """

    def Show(self, *args, **kw):
        """
        Show(window, show=True, recursive=False) -> bool
        Show(sizer, show=True, recursive=False) -> bool
        Show(index, show=True) -> bool
        
        Shows or hides the window.
        """

    def ShowItems(self, show):
        """
        ShowItems(show)
        
        Show or hide all items managed by the sizer.
        """

    def AddMany(self, items):
        """
        :meth:`AddMany` is a convenience method for adding several items to a sizer
        at one time. Simply pass it a list of tuples, where each tuple
        consists of the parameters that you would normally pass to the :meth:`Add`
        method.
        """

    def __nonzero__(self):
        """
        Can be used to test if the C++ part of the sizer still exists, with 
        code like this::
        
            if theSizer:
                doSomething()
        """

    __bool__ = __nonzero__
    Children = property(None, None)
    ContainingWindow = property(None, None)
    ItemCount = property(None, None)
    MinSize = property(None, None)
    Position = property(None, None)
    Size = property(None, None)
# end of class Sizer


class BoxSizer(Sizer):
    """
    BoxSizer(orient=HORIZONTAL)
    
    The basic idea behind a box sizer is that windows will most often be
    laid out in rather simple basic geometry, typically in a row or a
    column or several hierarchies of either.
    """

    def __init__(self, orient=HORIZONTAL):
        """
        BoxSizer(orient=HORIZONTAL)
        
        The basic idea behind a box sizer is that windows will most often be
        laid out in rather simple basic geometry, typically in a row or a
        column or several hierarchies of either.
        """

    def AddSpacer(self, size):
        """
        AddSpacer(size) -> SizerItem
        
        Adds non-stretchable space to the main orientation of the sizer only.
        """

    def CalcMin(self):
        """
        CalcMin() -> Size
        
        Implements the calculation of a box sizer's minimal.
        """

    def GetOrientation(self):
        """
        GetOrientation() -> int
        
        Returns the orientation of the box sizer, either wxVERTICAL or
        wxHORIZONTAL.
        """

    def SetOrientation(self, orient):
        """
        SetOrientation(orient)
        
        Sets the orientation of the box sizer, either wxVERTICAL or
        wxHORIZONTAL.
        """

    def RecalcSizes(self):
        """
        RecalcSizes()
        
        Implements the calculation of a box sizer's dimensions and then sets
        the size of its children (calling wxWindow::SetSize if the child is a
        window).
        """
    Orientation = property(None, None)
# end of class BoxSizer


class StaticBoxSizer(BoxSizer):
    """
    StaticBoxSizer(box, orient=HORIZONTAL)
    StaticBoxSizer(orient, parent, label=EmptyString)
    
    wxStaticBoxSizer is a sizer derived from wxBoxSizer but adds a static
    box around the sizer.
    """

    def __init__(self, *args, **kw):
        """
        StaticBoxSizer(box, orient=HORIZONTAL)
        StaticBoxSizer(orient, parent, label=EmptyString)
        
        wxStaticBoxSizer is a sizer derived from wxBoxSizer but adds a static
        box around the sizer.
        """

    def GetStaticBox(self):
        """
        GetStaticBox() -> StaticBox
        
        Returns the static box associated with the sizer.
        """

    def CalcMin(self):
        """
        CalcMin() -> Size
        
        Implements the calculation of a box sizer's minimal.
        """

    def RecalcSizes(self):
        """
        RecalcSizes()
        
        Implements the calculation of a box sizer's dimensions and then sets
        the size of its children (calling wxWindow::SetSize if the child is a
        window).
        """
    StaticBox = property(None, None)
# end of class StaticBoxSizer


class GridSizer(Sizer):
    """
    GridSizer(cols, vgap, hgap)
    GridSizer(cols, gap=Size(0,0))
    GridSizer(rows, cols, vgap, hgap)
    GridSizer(rows, cols, gap)
    
    A grid sizer is a sizer which lays out its children in a two-
    dimensional table with all table fields having the same size, i.e.
    """

    def __init__(self, *args, **kw):
        """
        GridSizer(cols, vgap, hgap)
        GridSizer(cols, gap=Size(0,0))
        GridSizer(rows, cols, vgap, hgap)
        GridSizer(rows, cols, gap)
        
        A grid sizer is a sizer which lays out its children in a two-
        dimensional table with all table fields having the same size, i.e.
        """

    def GetCols(self):
        """
        GetCols() -> int
        
        Returns the number of columns that has been specified for the sizer.
        """

    def GetRows(self):
        """
        GetRows() -> int
        
        Returns the number of rows that has been specified for the sizer.
        """

    def GetEffectiveColsCount(self):
        """
        GetEffectiveColsCount() -> int
        
        Returns the number of columns currently used by the sizer.
        """

    def GetEffectiveRowsCount(self):
        """
        GetEffectiveRowsCount() -> int
        
        Returns the number of rows currently used by the sizer.
        """

    def GetHGap(self):
        """
        GetHGap() -> int
        
        Returns the horizontal gap (in pixels) between cells in the sizer.
        """

    def GetVGap(self):
        """
        GetVGap() -> int
        
        Returns the vertical gap (in pixels) between the cells in the sizer.
        """

    def SetCols(self, cols):
        """
        SetCols(cols)
        
        Sets the number of columns in the sizer.
        """

    def SetHGap(self, gap):
        """
        SetHGap(gap)
        
        Sets the horizontal gap (in pixels) between cells in the sizer.
        """

    def SetRows(self, rows):
        """
        SetRows(rows)
        
        Sets the number of rows in the sizer.
        """

    def SetVGap(self, gap):
        """
        SetVGap(gap)
        
        Sets the vertical gap (in pixels) between the cells in the sizer.
        """

    def CalcMin(self):
        """
        CalcMin() -> Size
        
        This method is abstract and has to be overwritten by any derived
        class.
        """

    def RecalcSizes(self):
        """
        RecalcSizes()
        
        This method is abstract and has to be overwritten by any derived
        class.
        """

    def CalcRowsCols(self):
        """
        CalcRowsCols() -> (rows, cols)
        
        Calculates how many rows and columns will be in the sizer based
        on the current number of items and also the rows, cols specified
        in the constructor.
        """
    Cols = property(None, None)
    EffectiveColsCount = property(None, None)
    EffectiveRowsCount = property(None, None)
    HGap = property(None, None)
    Rows = property(None, None)
    VGap = property(None, None)
# end of class GridSizer


class FlexGridSizer(GridSizer):
    """
    FlexGridSizer(cols, vgap, hgap)
    FlexGridSizer(cols, gap=Size(0,0))
    FlexGridSizer(rows, cols, vgap, hgap)
    FlexGridSizer(rows, cols, gap)
    
    A flex grid sizer is a sizer which lays out its children in a two-
    dimensional table with all table fields in one row having the same
    height and all fields in one column having the same width, but all
    rows or all columns are not necessarily the same height or width as in
    the wxGridSizer.
    """

    def __init__(self, *args, **kw):
        """
        FlexGridSizer(cols, vgap, hgap)
        FlexGridSizer(cols, gap=Size(0,0))
        FlexGridSizer(rows, cols, vgap, hgap)
        FlexGridSizer(rows, cols, gap)
        
        A flex grid sizer is a sizer which lays out its children in a two-
        dimensional table with all table fields in one row having the same
        height and all fields in one column having the same width, but all
        rows or all columns are not necessarily the same height or width as in
        the wxGridSizer.
        """

    def AddGrowableCol(self, idx, proportion=0):
        """
        AddGrowableCol(idx, proportion=0)
        
        Specifies that column idx (starting from zero) should be grown if
        there is extra space available to the sizer.
        """

    def AddGrowableRow(self, idx, proportion=0):
        """
        AddGrowableRow(idx, proportion=0)
        
        Specifies that row idx (starting from zero) should be grown if there
        is extra space available to the sizer.
        """

    def GetFlexibleDirection(self):
        """
        GetFlexibleDirection() -> int
        
        Returns a wxOrientation value that specifies whether the sizer
        flexibly resizes its columns, rows, or both (default).
        """

    def GetNonFlexibleGrowMode(self):
        """
        GetNonFlexibleGrowMode() -> FlexSizerGrowMode
        
        Returns the value that specifies how the sizer grows in the "non-
        flexible" direction if there is one.
        """

    def IsColGrowable(self, idx):
        """
        IsColGrowable(idx) -> bool
        
        Returns true if column idx is growable.
        """

    def IsRowGrowable(self, idx):
        """
        IsRowGrowable(idx) -> bool
        
        Returns true if row idx is growable.
        """

    def RemoveGrowableCol(self, idx):
        """
        RemoveGrowableCol(idx)
        
        Specifies that the idx column index is no longer growable.
        """

    def RemoveGrowableRow(self, idx):
        """
        RemoveGrowableRow(idx)
        
        Specifies that the idx row index is no longer growable.
        """

    def SetFlexibleDirection(self, direction):
        """
        SetFlexibleDirection(direction)
        
        Specifies whether the sizer should flexibly resize its columns, rows,
        or both.
        """

    def SetNonFlexibleGrowMode(self, mode):
        """
        SetNonFlexibleGrowMode(mode)
        
        Specifies how the sizer should grow in the non-flexible direction if
        there is one (so SetFlexibleDirection() must have been called
        previously).
        """

    def GetRowHeights(self):
        """
        GetRowHeights() -> ArrayInt
        
        Returns a read-only array containing the heights of the rows in the
        sizer.
        """

    def GetColWidths(self):
        """
        GetColWidths() -> ArrayInt
        
        Returns a read-only array containing the widths of the columns in the
        sizer.
        """

    def RecalcSizes(self):
        """
        RecalcSizes()
        
        This method is abstract and has to be overwritten by any derived
        class.
        """

    def CalcMin(self):
        """
        CalcMin() -> Size
        
        This method is abstract and has to be overwritten by any derived
        class.
        """
    ColWidths = property(None, None)
    FlexibleDirection = property(None, None)
    NonFlexibleGrowMode = property(None, None)
    RowHeights = property(None, None)
# end of class FlexGridSizer


class StdDialogButtonSizer(BoxSizer):
    """
    StdDialogButtonSizer()
    
    This class creates button layouts which conform to the standard button
    spacing and ordering defined by the platform or toolkit's user
    interface guidelines (if such things exist).
    """

    def __init__(self):
        """
        StdDialogButtonSizer()
        
        This class creates button layouts which conform to the standard button
        spacing and ordering defined by the platform or toolkit's user
        interface guidelines (if such things exist).
        """

    def AddButton(self, button):
        """
        AddButton(button)
        
        Adds a button to the wxStdDialogButtonSizer.
        """

    def Realize(self):
        """
        Realize()
        
        Rearranges the buttons and applies proper spacing between buttons to
        make them match the platform or toolkit's interface guidelines.
        """

    def SetAffirmativeButton(self, button):
        """
        SetAffirmativeButton(button)
        
        Sets the affirmative button for the sizer.
        """

    def SetCancelButton(self, button):
        """
        SetCancelButton(button)
        
        Sets the cancel button for the sizer.
        """

    def SetNegativeButton(self, button):
        """
        SetNegativeButton(button)
        
        Sets the negative button for the sizer.
        """

    def RecalcSizes(self):
        """
        RecalcSizes()
        
        Implements the calculation of a box sizer's dimensions and then sets
        the size of its children (calling wxWindow::SetSize if the child is a
        window).
        """

    def CalcMin(self):
        """
        CalcMin() -> Size
        
        Implements the calculation of a box sizer's minimal.
        """
# end of class StdDialogButtonSizer


PySizer = wx.deprecated(Sizer, 'Use Sizer instead.')
#-- end-sizer --#
#-- begin-gbsizer --#

class GBPosition(object):
    """
    GBPosition()
    GBPosition(row, col)
    
    This class represents the position of an item in a virtual grid of
    rows and columns managed by a wxGridBagSizer.
    """

    def __init__(self, *args, **kw):
        """
        GBPosition()
        GBPosition(row, col)
        
        This class represents the position of an item in a virtual grid of
        rows and columns managed by a wxGridBagSizer.
        """

    def GetCol(self):
        """
        GetCol() -> int
        
        Get the current column value.
        """

    def GetRow(self):
        """
        GetRow() -> int
        
        Get the current row value.
        """

    def SetCol(self, col):
        """
        SetCol(col)
        
        Set a new column value.
        """

    def SetRow(self, row):
        """
        SetRow(row)
        
        Set a new row value.
        """

    def __ne__(self):
        """
        """

    def __eq__(self):
        """
        """

    def Get(self):
        """
        Get() -> (row, col)
        
        Return the row and col properties as a tuple.
        """

    def Set(self, row=0, col=0):
        """
        Set(row=0, col=0)
        
        Set both the row and column properties.
        """

    def GetIM(self):
        """
        Returns an immutable representation of the ``wx.GBPosition`` object, based on ``namedtuple``.
        
        This new object is hashable and can be used as a dictionary key,
        be added to sets, etc.  It can be converted back into a real ``wx.GBPosition``
        with a simple statement like this: ``obj = wx.GBPosition(imObj)``.
        """

    def __str__(self):
        """
        
        """

    def __repr__(self):
        """
        
        """

    def __len__(self):
        """
        
        """

    def __nonzero__(self):
        """
        
        """

    def __reduce__(self):
        """
        
        """

    def __getitem__(self, idx):
        """
        
        """

    def __setitem__(self, idx, val):
        """
        
        """

    __safe_for_unpickling__ = True
    Row = property(None, None)
    Col = property(None, None)
    row = property(None, None)
    col = property(None, None)
# end of class GBPosition


class GBSpan(object):
    """
    GBSpan()
    GBSpan(rowspan, colspan)
    
    This class is used to hold the row and column spanning attributes of
    items in a wxGridBagSizer.
    """

    def __init__(self, *args, **kw):
        """
        GBSpan()
        GBSpan(rowspan, colspan)
        
        This class is used to hold the row and column spanning attributes of
        items in a wxGridBagSizer.
        """

    def GetColspan(self):
        """
        GetColspan() -> int
        
        Get the current colspan value.
        """

    def GetRowspan(self):
        """
        GetRowspan() -> int
        
        Get the current rowspan value.
        """

    def SetColspan(self, colspan):
        """
        SetColspan(colspan)
        
        Set a new colspan value.
        """

    def SetRowspan(self, rowspan):
        """
        SetRowspan(rowspan)
        
        Set a new rowspan value.
        """

    def __ne__(self):
        """
        """

    def __eq__(self):
        """
        """

    def Get(self):
        """
        Get() -> (rowspan, colspan)
        
        Return the rowspan and colspan properties as a tuple.
        """

    def Set(self, rowspan=0, colspan=0):
        """
        Set(rowspan=0, colspan=0)
        
        Set both the rowspan and colspan properties.
        """

    def GetIM(self):
        """
        Returns an immutable representation of the ``wx.GBSpan`` object, based on ``namedtuple``.
        
        This new object is hashable and can be used as a dictionary key,
        be added to sets, etc.  It can be converted back into a real ``wx.GBSpan``
        with a simple statement like this: ``obj = wx.GBSpan(imObj)``.
        """

    def __str__(self):
        """
        
        """

    def __repr__(self):
        """
        
        """

    def __len__(self):
        """
        
        """

    def __nonzero__(self):
        """
        
        """

    def __reduce__(self):
        """
        
        """

    def __getitem__(self, idx):
        """
        
        """

    def __setitem__(self, idx, val):
        """
        
        """

    __safe_for_unpickling__ = True
    Rowspan = property(None, None)
    Colspan = property(None, None)
    rowspan = property(None, None)
    colspan = property(None, None)
# end of class GBSpan


class GBSizerItem(SizerItem):
    """
    GBSizerItem(width, height, pos, span=DefaultSpan, flag=0, border=0, userData=None)
    GBSizerItem(window, pos, span=DefaultSpan, flag=0, border=0, userData=None)
    GBSizerItem(sizer, pos, span=DefaultSpan, flag=0, border=0, userData=None)
    
    The wxGBSizerItem class is used by the wxGridBagSizer for tracking the
    items in the sizer.
    """

    def __init__(self, *args, **kw):
        """
        GBSizerItem(width, height, pos, span=DefaultSpan, flag=0, border=0, userData=None)
        GBSizerItem(window, pos, span=DefaultSpan, flag=0, border=0, userData=None)
        GBSizerItem(sizer, pos, span=DefaultSpan, flag=0, border=0, userData=None)
        
        The wxGBSizerItem class is used by the wxGridBagSizer for tracking the
        items in the sizer.
        """

    def GetPos(self):
        """
        GetPos() -> GBPosition
        
        Get the grid position of the item.
        """

    def GetSpan(self):
        """
        GetSpan() -> GBSpan
        
        Get the row and column spanning of the item.
        """

    def GetEndPos(self):
        """
        GetEndPos() -> (row, col)
        
        Get the row and column of the endpoint of this item.
        """

    def Intersects(self, *args, **kw):
        """
        Intersects(other) -> bool
        Intersects(pos, span) -> bool
        
        Returns true if this item and the other item intersect.
        """

    def SetPos(self, pos):
        """
        SetPos(pos) -> bool
        
        If the item is already a member of a sizer then first ensure that
        there is no other item that would intersect with this one at the new
        position, then set the new position.
        """

    def SetSpan(self, span):
        """
        SetSpan(span) -> bool
        
        If the item is already a member of a sizer then first ensure that
        there is no other item that would intersect with this one with its new
        spanning size, then set the new spanning.
        """

    def GetGBSizer(self):
        """
        GetGBSizer() -> GridBagSizer
        """

    def SetGBSizer(self, sizer):
        """
        SetGBSizer(sizer)
        """
    GBSizer = property(None, None)
    Pos = property(None, None)
    Span = property(None, None)
# end of class GBSizerItem


class GridBagSizer(FlexGridSizer):
    """
    GridBagSizer(vgap=0, hgap=0)
    
    A wxSizer that can lay out items in a virtual grid like a
    wxFlexGridSizer but in this case explicit positioning of the items is
    allowed using wxGBPosition, and items can optionally span more than
    one row and/or column using wxGBSpan.
    """

    def __init__(self, vgap=0, hgap=0):
        """
        GridBagSizer(vgap=0, hgap=0)
        
        A wxSizer that can lay out items in a virtual grid like a
        wxFlexGridSizer but in this case explicit positioning of the items is
        allowed using wxGBPosition, and items can optionally span more than
        one row and/or column using wxGBSpan.
        """

    def Add(self, *args, **kw):
        """
        Add(window, pos, span=DefaultSpan, flag=0, border=0, userData=None) -> SizerItem
        Add(sizer, pos, span=DefaultSpan, flag=0, border=0, userData=None) -> SizerItem
        Add(item) -> SizerItem
        Add(width, height, pos, span=DefaultSpan, flag=0, border=0, userData=None) -> SizerItem
        Add(size, pos, span=DefaultSpan, flag=0, border=0, /Transfer/=None) -> SizerItem
        
        Adds the given item to the given position.
        """

    def CheckForIntersection(self, *args, **kw):
        """
        CheckForIntersection(item, excludeItem=None) -> bool
        CheckForIntersection(pos, span, excludeItem=None) -> bool
        
        Look at all items and see if any intersect (or would overlap) the
        given item.
        """

    def FindItem(self, *args, **kw):
        """
        FindItem(window) -> GBSizerItem
        FindItem(sizer) -> GBSizerItem
        
        Find the sizer item for the given window or subsizer, returns NULL if
        not found.
        """

    def GetItemPosition(self, *args, **kw):
        """
        GetItemPosition(window) -> GBPosition
        GetItemPosition(sizer) -> GBPosition
        GetItemPosition(index) -> GBPosition
        
        Get the grid position of the specified item.
        """

    def GetItemSpan(self, *args, **kw):
        """
        GetItemSpan(window) -> GBSpan
        GetItemSpan(sizer) -> GBSpan
        GetItemSpan(index) -> GBSpan
        
        Get the row/col spanning of the specified item.
        """

    def SetItemPosition(self, *args, **kw):
        """
        SetItemPosition(window, pos) -> bool
        SetItemPosition(sizer, pos) -> bool
        SetItemPosition(index, pos) -> bool
        
        Set the grid position of the specified item.
        """

    def SetItemSpan(self, *args, **kw):
        """
        SetItemSpan(window, span) -> bool
        SetItemSpan(sizer, span) -> bool
        SetItemSpan(index, span) -> bool
        
        Set the row/col spanning of the specified item.
        """

    def CalcMin(self):
        """
        CalcMin() -> Size
        
        Called when the managed size of the sizer is needed or when layout
        needs done.
        """

    def FindItemAtPoint(self, pt):
        """
        FindItemAtPoint(pt) -> GBSizerItem
        
        Return the sizer item located at the point given in pt, or NULL if
        there is no item at that point.
        """

    def FindItemAtPosition(self, pos):
        """
        FindItemAtPosition(pos) -> GBSizerItem
        
        Return the sizer item for the given grid cell, or NULL if there is no
        item at that position.
        """

    def FindItemWithData(self, userData):
        """
        FindItemWithData(userData) -> GBSizerItem
        
        Return the sizer item that has a matching user data (it only compares
        pointer values) or NULL if not found.
        """

    def GetCellSize(self, row, col):
        """
        GetCellSize(row, col) -> Size
        
        Get the size of the specified cell, including hgap and vgap.
        """

    def GetEmptyCellSize(self):
        """
        GetEmptyCellSize() -> Size
        
        Get the size used for cells in the grid with no item.
        """

    def RecalcSizes(self):
        """
        RecalcSizes()
        
        Called when the managed size of the sizer is needed or when layout
        needs done.
        """

    def SetEmptyCellSize(self, sz):
        """
        SetEmptyCellSize(sz)
        
        Set the size used for cells in the grid with no item.
        """

    CheckForIntersectionPos = wx.deprecated(CheckForIntersection, 'Use CheckForIntersection instead.')
    EmptyCellSize = property(None, None)
# end of class GridBagSizer

DefaultSpan = GBSpan()

from collections import namedtuple
_im_GBPosition = namedtuple('_im_GBPosition', ['row', 'col'])
del namedtuple

from collections import namedtuple
_im_GBSpan = namedtuple('_im_GBSpan', ['rowspan', 'colspan'])
del namedtuple
#-- end-gbsizer --#
#-- begin-wrapsizer --#
EXTEND_LAST_ON_EACH_LINE = 0
REMOVE_LEADING_SPACES = 0
WRAPSIZER_DEFAULT_FLAGS = 0

class WrapSizer(BoxSizer):
    """
    WrapSizer(orient=HORIZONTAL, flags=WRAPSIZER_DEFAULT_FLAGS)
    
    A wrap sizer lays out its items in a single line, like a box sizer  as
    long as there is space available in that direction.
    """

    def __init__(self, orient=HORIZONTAL, flags=WRAPSIZER_DEFAULT_FLAGS):
        """
        WrapSizer(orient=HORIZONTAL, flags=WRAPSIZER_DEFAULT_FLAGS)
        
        A wrap sizer lays out its items in a single line, like a box sizer  as
        long as there is space available in that direction.
        """

    def InformFirstDirection(self, direction, size, availableOtherDir):
        """
        InformFirstDirection(direction, size, availableOtherDir) -> bool
        
        Not used by an application.
        """

    def RecalcSizes(self):
        """
        RecalcSizes()
        
        Implements the calculation of a box sizer's dimensions and then sets
        the size of its children (calling wxWindow::SetSize if the child is a
        window).
        """

    def CalcMin(self):
        """
        CalcMin() -> Size
        
        Implements the calculation of a box sizer's minimal.
        """

    def IsSpaceItem(self, item):
        """
        IsSpaceItem(item) -> bool
        
        Can be overridden in the derived classes to treat some normal items as
        spacers.
        """
# end of class WrapSizer

#-- end-wrapsizer --#
#-- begin-stdpaths --#

class StandardPaths(object):
    """
    StandardPaths()
    
    wxStandardPaths returns the standard locations in the file system and
    should be used by applications to find their data files in a portable
    way.
    """
    ResourceCat_None = 0
    ResourceCat_Messages = 0

    def GetAppDocumentsDir(self):
        """
        GetAppDocumentsDir() -> String
        
        Return the directory for the document files used by this application.
        """

    def GetConfigDir(self):
        """
        GetConfigDir() -> String
        
        Return the directory containing the system config files.
        """

    def GetDataDir(self):
        """
        GetDataDir() -> String
        
        Return the location of the applications global, i.e. not user-
        specific, data files.
        """

    def GetDocumentsDir(self):
        """
        GetDocumentsDir() -> String
        
        Return the directory containing the current user's documents.
        """

    def GetExecutablePath(self):
        """
        GetExecutablePath() -> String
        
        Return the directory and the filename for the current executable.
        """

    def GetInstallPrefix(self):
        """
        GetInstallPrefix() -> String
        
        Return the program installation prefix, e.g. /usr, /opt or
        /home/zeitlin.
        """

    def GetLocalDataDir(self):
        """
        GetLocalDataDir() -> String
        
        Return the location for application data files which are host-specific
        and can't, or shouldn't, be shared with the other machines.
        """

    def GetLocalizedResourcesDir(self, lang, category=ResourceCat_None):
        """
        GetLocalizedResourcesDir(lang, category=ResourceCat_None) -> String
        
        Return the localized resources directory containing the resource files
        of the specified category for the given language.
        """

    def GetPluginsDir(self):
        """
        GetPluginsDir() -> String
        
        Return the directory where the loadable modules (plugins) live.
        """

    def GetResourcesDir(self):
        """
        GetResourcesDir() -> String
        
        Return the directory where the application resource files are located.
        """

    def GetTempDir(self):
        """
        GetTempDir() -> String
        
        Return the directory for storing temporary files.
        """

    def GetUserConfigDir(self):
        """
        GetUserConfigDir() -> String
        
        Return the directory for the user config files:
        """

    def GetUserDataDir(self):
        """
        GetUserDataDir() -> String
        
        Return the directory for the user-dependent application data files:
        """

    def GetUserLocalDataDir(self):
        """
        GetUserLocalDataDir() -> String
        
        Return the directory for user data files which shouldn't be shared
        with the other machines.
        """

    def SetInstallPrefix(self, prefix):
        """
        SetInstallPrefix(prefix)
        
        Lets wxStandardPaths know about the real program installation prefix
        on a Unix system.
        """

    def UseAppInfo(self, info):
        """
        UseAppInfo(info)
        
        Controls what application information is used when constructing paths
        that should be unique to this program, such as the application data
        directory, the plugins directory on Unix, etc.
        """

    @staticmethod
    def Get():
        """
        Get() -> StandardPaths
        
        Returns reference to the unique global standard paths object.
        """

    @staticmethod
    def MSWGetShellDir(csidl):
        """
        MSWGetShellDir(csidl) -> String
        
        Returns location of Windows shell special folder.
        """
    AppDocumentsDir = property(None, None)
    ConfigDir = property(None, None)
    DataDir = property(None, None)
    DocumentsDir = property(None, None)
    ExecutablePath = property(None, None)
    InstallPrefix = property(None, None)
    LocalDataDir = property(None, None)
    PluginsDir = property(None, None)
    ResourcesDir = property(None, None)
    TempDir = property(None, None)
    UserConfigDir = property(None, None)
    UserDataDir = property(None, None)
    UserLocalDataDir = property(None, None)

    def wxStandardPaths(self):
        """
        """
# end of class StandardPaths

#-- end-stdpaths --#
#-- begin-eventfilter --#

class EventFilter(object):
    """
    EventFilter()
    
    A global event filter for pre-processing all the events generated in
    the program.
    """
    Event_Skip = 0
    Event_Ignore = 0
    Event_Processed = 0

    def __init__(self):
        """
        EventFilter()
        
        A global event filter for pre-processing all the events generated in
        the program.
        """

    def FilterEvent(self, event):
        """
        FilterEvent(event) -> int
        
        Override this method to implement event pre-processing.
        """
# end of class EventFilter

#-- end-eventfilter --#
#-- begin-evtloop --#

class EventLoopBase(object):
    """
    Base class for all event loop implementations.
    """

    def Run(self):
        """
        Run() -> int
        
        Start the event loop, return the exit code when it is finished.
        """

    def IsRunning(self):
        """
        IsRunning() -> bool
        
        Return true if this event loop is currently running.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Use this to check whether the event loop was successfully created
        before using it.
        """

    def Exit(self, rc=0):
        """
        Exit(rc=0)
        
        Exit the currently running loop with the given exit code.
        """

    def ScheduleExit(self, rc=0):
        """
        ScheduleExit(rc=0)
        
        Schedule an exit from the loop with the given exit code.
        """

    def Pending(self):
        """
        Pending() -> bool
        
        Return true if any events are available.
        """

    def Dispatch(self):
        """
        Dispatch() -> bool
        
        Dispatches the next event in the windowing system event queue.
        """

    def DispatchTimeout(self, timeout):
        """
        DispatchTimeout(timeout) -> int
        
        Dispatch an event but not wait longer than the specified timeout for
        it.
        """

    def WakeUp(self):
        """
        WakeUp()
        
        Called by wxWidgets to wake up the event loop even if it is currently
        blocked inside Dispatch().
        """

    def WakeUpIdle(self):
        """
        WakeUpIdle()
        
        Makes sure that idle events are sent again.
        """

    def ProcessIdle(self):
        """
        ProcessIdle() -> bool
        
        This virtual function is called when the application becomes idle and
        normally just sends wxIdleEvent to all interested parties.
        """

    def IsYielding(self):
        """
        IsYielding() -> bool
        
        Returns true if called from inside Yield() or from inside YieldFor().
        """

    def Yield(self, onlyIfNeeded=False):
        """
        Yield(onlyIfNeeded=False) -> bool
        
        Yields control to pending messages in the windowing system.
        """

    def YieldFor(self, eventsToProcess):
        """
        YieldFor(eventsToProcess) -> bool
        
        Works like Yield() with onlyIfNeeded == true, except that it allows
        the caller to specify a mask of the wxEventCategory values which
        indicates which events should be processed and which should instead be
        "delayed" (i.e.
        """

    def IsEventAllowedInsideYield(self, cat):
        """
        IsEventAllowedInsideYield(cat) -> bool
        
        Returns true if the given event category is allowed inside a
        YieldFor() call (i.e.
        """

    @staticmethod
    def GetActive():
        """
        GetActive() -> EventLoopBase
        
        Return the currently active (running) event loop.
        """

    @staticmethod
    def SetActive(loop):
        """
        SetActive(loop)
        
        Set currently active (running) event loop.
        """

    def IsMain(self):
        """
        IsMain() -> bool
        
        Returns true if this is the main loop executed by wxApp::OnRun().
        """

    def OnExit(self):
        """
        OnExit()
        
        This function is called before the event loop terminates, whether this
        happens normally (because of Exit() call) or abnormally (because of an
        exception thrown from inside the loop).
        """
# end of class EventLoopBase


class EventLoopActivator(object):
    """
    EventLoopActivator(loop)
    
    Makes an event loop temporarily active.
    """

    def __init__(self, loop):
        """
        EventLoopActivator(loop)
        
        Makes an event loop temporarily active.
        """

    def __enter__(self):
        """
        
        """

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        
        """
# end of class EventLoopActivator


class GUIEventLoop(EventLoopBase):
    """
    GUIEventLoop()
    
    A generic implementation of the GUI event loop.
    """

    def __init__(self):
        """
        GUIEventLoop()
        
        A generic implementation of the GUI event loop.
        """
# end of class GUIEventLoop


@wx.deprecatedMsg('Use GUIEventLoop instead.')
class EventLoop(GUIEventLoop):
    '''A class using the old name for compatibility.'''
    def __init__(self):
        GUIEventLoop.__init__(self)
#-- end-evtloop --#
#-- begin-apptrait --#

class AppTraits(object):
    """
    The wxAppTraits class defines various configurable aspects of a wxApp.
    """

    def CreateConfig(self):
        """
        CreateConfig() -> ConfigBase
        
        Called by wxWidgets to create the default configuration object for the
        application.
        """

    def CreateEventLoop(self):
        """
        CreateEventLoop() -> EventLoopBase
        
        Used by wxWidgets to create the main event loop used by
        wxApp::OnRun().
        """

    def CreateLogTarget(self):
        """
        CreateLogTarget() -> Log
        
        Creates a wxLog class for the application to use for logging errors.
        """

    def GetDesktopEnvironment(self):
        """
        GetDesktopEnvironment() -> String
        
        This method returns the name of the desktop environment currently
        running in a Unix desktop.
        """

    def GetStandardPaths(self):
        """
        GetStandardPaths() -> StandardPaths
        
        Returns the wxStandardPaths object for the application.
        """

    def GetToolkitVersion(self, major=None, minor=None):
        """
        GetToolkitVersion(major=None, minor=None) -> PortId
        
        Returns the wxWidgets port ID used by the running program and
        eventually fills the given pointers with the values of the major and
        minor digits of the native toolkit currently used.
        """

    def HasStderr(self):
        """
        HasStderr() -> bool
        
        Returns true if fprintf(stderr) goes somewhere, false otherwise.
        """

    def IsUsingUniversalWidgets(self):
        """
        IsUsingUniversalWidgets() -> bool
        
        Returns true if the library was built as wxUniversal.
        """

    def ShowAssertDialog(self, msg):
        """
        ShowAssertDialog(msg) -> bool
        
        Shows the assert dialog with the specified message in GUI mode or just
        prints the string to stderr in console mode.
        """
    DesktopEnvironment = property(None, None)
    StandardPaths = property(None, None)
    ToolkitVersion = property(None, None)
# end of class AppTraits

#-- end-apptrait --#
#-- begin-app --#

class AppConsole(EvtHandler, EventFilter):
    """
    This class is essential for writing console-only or hybrid apps
    without having to define wxUSE_GUI=0.
    """

    def MainLoop(self):
        """
        MainLoop() -> int
        
        Called by wxWidgets on creation of the application.
        """

    def ExitMainLoop(self):
        """
        ExitMainLoop()
        
        Call this to explicitly exit the main message (event) loop.
        """

    def FilterEvent(self, event):
        """
        FilterEvent(event) -> int
        
        Overridden wxEventFilter method.
        """

    def GetMainLoop(self):
        """
        GetMainLoop() -> EventLoopBase
        
        Returns the main event loop instance, i.e. the event loop which is
        started by OnRun() and which dispatches all events sent from the
        native toolkit to the application (except when new event loops are
        temporarily set-up).
        """

    def ProcessPendingEvents(self):
        """
        ProcessPendingEvents()
        
        Process all pending events; it is necessary to call this function to
        process events posted with wxEvtHandler::QueueEvent or
        wxEvtHandler::AddPendingEvent.
        """

    def DeletePendingEvents(self):
        """
        DeletePendingEvents()
        
        Deletes the pending events of all wxEvtHandlers of this application.
        """

    def HasPendingEvents(self):
        """
        HasPendingEvents() -> bool
        
        Returns true if there are pending events on the internal pending event
        list.
        """

    def SuspendProcessingOfPendingEvents(self):
        """
        SuspendProcessingOfPendingEvents()
        
        Temporary suspends processing of the pending events.
        """

    def ResumeProcessingOfPendingEvents(self):
        """
        ResumeProcessingOfPendingEvents()
        
        Resume processing of the pending events previously stopped because of
        a call to SuspendProcessingOfPendingEvents().
        """

    def ScheduleForDestruction(self, object):
        """
        ScheduleForDestruction(object)
        
        Delayed objects destruction.
        """

    def IsScheduledForDestruction(self, object):
        """
        IsScheduledForDestruction(object) -> bool
        
        Check if the object had been scheduled for destruction with
        ScheduleForDestruction().
        """

    def OnEventLoopEnter(self, loop):
        """
        OnEventLoopEnter(loop)
        
        Called by wxEventLoopBase::SetActive(): you can override this function
        and put here the code which needs an active event loop.
        """

    def OnEventLoopExit(self, loop):
        """
        OnEventLoopExit(loop)
        
        Called by wxEventLoopBase::OnExit() for each event loop which is
        exited.
        """

    def OnExit(self):
        """
        OnExit() -> int
        
        Override this member function for any processing which needs to be
        done as the application is about to exit.
        """

    def OnInit(self):
        """
        OnInit() -> bool
        
        This must be provided by the application, and will usually create the
        application's main window, optionally calling SetTopWindow().
        """

    def OnRun(self):
        """
        OnRun() -> int
        
        This virtual function is where the execution of a program written in
        wxWidgets starts.
        """

    def GetAppDisplayName(self):
        """
        GetAppDisplayName() -> String
        
        Returns the user-readable application name.
        """

    def GetAppName(self):
        """
        GetAppName() -> String
        
        Returns the application name.
        """

    def GetClassName(self):
        """
        GetClassName() -> String
        
        Gets the class name of the application.
        """

    def GetTraits(self):
        """
        GetTraits() -> AppTraits
        
        Returns a pointer to the wxAppTraits object for the application.
        """

    def GetVendorDisplayName(self):
        """
        GetVendorDisplayName() -> String
        
        Returns the user-readable vendor name.
        """

    def GetVendorName(self):
        """
        GetVendorName() -> String
        
        Returns the application's vendor name.
        """

    def SetAppDisplayName(self, name):
        """
        SetAppDisplayName(name)
        
        Set the application name to be used in the user-visible places such as
        window titles.
        """

    def SetAppName(self, name):
        """
        SetAppName(name)
        
        Sets the name of the application.
        """

    def SetClassName(self, name):
        """
        SetClassName(name)
        
        Sets the class name of the application.
        """

    def SetVendorDisplayName(self, name):
        """
        SetVendorDisplayName(name)
        
        Set the vendor name to be used in the user-visible places.
        """

    def SetVendorName(self, name):
        """
        SetVendorName(name)
        
        Sets the name of application's vendor.
        """

    def Yield(self, onlyIfNeeded=False):
        """
        Yield(onlyIfNeeded=False) -> bool
        """

    def SetCLocale(self):
        """
        SetCLocale()
        
        Sets the C locale to the default locale for the current environment.
        """

    @staticmethod
    def SetInstance(app):
        """
        SetInstance(app)
        
        Allows external code to modify global wxTheApp, but you should really
        know what you're doing if you call it.
        """

    @staticmethod
    def GetInstance():
        """
        GetInstance() -> AppConsole
        
        Returns the one and only global application object.
        """

    @staticmethod
    def IsMainLoopRunning():
        """
        IsMainLoopRunning() -> bool
        
        Returns true if the main event loop is currently running, i.e. if the
        application is inside OnRun().
        """
    AppDisplayName = property(None, None)
    AppName = property(None, None)
    ClassName = property(None, None)
    VendorDisplayName = property(None, None)
    VendorName = property(None, None)
    Traits = property(None, None)
# end of class AppConsole

APP_ASSERT_SUPPRESS = 0
APP_ASSERT_EXCEPTION = 0
APP_ASSERT_DIALOG = 0
APP_ASSERT_LOG = 0

class PyApp(AppConsole):
    """
    PyApp()
    
    The wxApp class represents the application itself when wxUSE_GUI=1.
    """

    def __init__(self):
        """
        PyApp()
        
        The wxApp class represents the application itself when wxUSE_GUI=1.
        """

    def MacNewFile(self):
        """
        MacNewFile()
        
        Called in response of an "open-application" Apple event.
        """

    def MacOpenFiles(self, fileNames):
        """
        MacOpenFiles(fileNames)
        
        Called in response of an openFiles message with Cocoa, or an "open-
        document" Apple event with Carbon.
        """

    def MacOpenFile(self, fileName):
        """
        MacOpenFile(fileName)
        
        Called in response of an "open-document" Apple event.
        """

    def MacOpenURL(self, url):
        """
        MacOpenURL(url)
        
        Called in response of a "get-url" Apple event.
        """

    def MacPrintFile(self, fileName):
        """
        MacPrintFile(fileName)
        
        Called in response of a "print-document" Apple event.
        """

    def MacReopenApp(self):
        """
        MacReopenApp()
        
        Called in response of a "reopen-application" Apple event.
        """

    def OSXIsGUIApplication(self):
        """
        OSXIsGUIApplication() -> bool
        
        May be overridden to indicate that the application is not a foreground
        GUI application under OS X.
        """

    def GetDisplayMode(self):
        """
        GetDisplayMode() -> VideoMode
        
        Get display mode that is used use.
        """

    def GetExitOnFrameDelete(self):
        """
        GetExitOnFrameDelete() -> bool
        
        Returns true if the application will exit when the top-level frame is
        deleted.
        """

    def GetLayoutDirection(self):
        """
        GetLayoutDirection() -> LayoutDirection
        
        Return the layout direction for the current locale or wxLayout_Default
        if it's unknown.
        """

    def GetUseBestVisual(self):
        """
        GetUseBestVisual() -> bool
        
        Returns true if the application will use the best visual on systems
        that support different visuals, false otherwise.
        """

    def GetTopWindow(self):
        """
        GetTopWindow() -> Window
        
        Returns a pointer to the top window.
        """

    def IsActive(self):
        """
        IsActive() -> bool
        
        Returns true if the application is active, i.e. if one of its windows
        is currently in the foreground.
        """

    def SafeYield(self, win, onlyIfNeeded):
        """
        SafeYield(win, onlyIfNeeded) -> bool
        
        This function is similar to wxYield(), except that it disables the
        user input to all program windows before calling wxAppConsole::Yield
        and re-enables it again afterwards.
        """

    def SafeYieldFor(self, win, eventsToProcess):
        """
        SafeYieldFor(win, eventsToProcess) -> bool
        
        Works like SafeYield() with onlyIfNeeded == true except that it allows
        the caller to specify a mask of events to be processed.
        """

    def SetDisplayMode(self, info):
        """
        SetDisplayMode(info) -> bool
        
        Set display mode to use.
        """

    def SetExitOnFrameDelete(self, flag):
        """
        SetExitOnFrameDelete(flag)
        
        Allows the programmer to specify whether the application will exit
        when the top-level frame is deleted.
        """

    def SetNativeTheme(self, theme):
        """
        SetNativeTheme(theme) -> bool
        
        Allows runtime switching of the UI environment theme.
        """

    def SetTopWindow(self, window):
        """
        SetTopWindow(window)
        
        Sets the 'top' window.
        """

    def SetUseBestVisual(self, flag, forceTrueColour=False):
        """
        SetUseBestVisual(flag, forceTrueColour=False)
        
        Allows the programmer to specify whether the application will use the
        best visual on systems that support several visual on the same
        display.
        """

    def MacHideApp(self):
        """
        MacHideApp()
        
        Hide all application windows just as the user can do with the
        system Hide command.  Mac only.
        """

    @staticmethod
    def GetComCtl32Version():
        """
        GetComCtl32Version() -> int
        
        Returns 400, 470, 471, etc. for comctl32.dll 4.00, 4.70, 4.71 or 0 if
        it wasn't found at all.  Raises an exception on non-Windows platforms.
        """

    @staticmethod
    def GetShell32Version():
        """
        GetShell32Version() -> int
        
        Returns 400, 470, 471, etc. for shell32.dll 4.00, 4.70, 4.71 or 0 if
        it wasn't found at all.  Raises an exception on non-Windows platforms.
        """

    def GetAssertMode(self):
        """
        GetAssertMode() -> AppAssertMode
        
        Returns the current mode for how the application responds to wx
        asserts.
        """

    def SetAssertMode(self, AppAssertMode):
        """
        SetAssertMode(AppAssertMode)
        
        Set the mode indicating how the application responds to wx assertion
        statements. Valid settings are a combination of these flags:
        
            - wx.APP_ASSERT_SUPPRESS
            - wx.APP_ASSERT_EXCEPTION
            - wx.APP_ASSERT_DIALOG
            - wx.APP_ASSERT_LOG
        
        The default behavior is to raise a wx.wxAssertionError exception.
        """

    @staticmethod
    def IsDisplayAvailable():
        """
        IsDisplayAvailable() -> bool
        
        Returns True if the application is able to connect to the system's
        display, or whatever the equivallent is for the platform.
        """
    AssertMode = property(None, None)
    DisplayMode = property(None, None)
    ExitOnFrameDelete = property(None, None)
    LayoutDirection = property(None, None)
    UseBestVisual = property(None, None)
    TopWindow = property(None, None)
# end of class PyApp


def GetApp():
    """
    GetApp() -> PyApp
    
    Returns the current application object.
    """

def HandleFatalExceptions(doIt=True):
    """
    HandleFatalExceptions(doIt=True) -> bool
    
    If doIt is true, the fatal exceptions (also known as general
    protection faults under Windows or segmentation violations in the Unix
    world) will be caught and passed to wxApp::OnFatalException.
    """

def WakeUpIdle():
    """
    WakeUpIdle()
    
    This function wakes up the (internal and platform dependent) idle
    system, i.e.
    """

def Yield():
    """
    Yield() -> bool
    
    Calls wxAppConsole::Yield.
    """

def SafeYield(win=None, onlyIfNeeded=False):
    """
    SafeYield(win=None, onlyIfNeeded=False) -> bool
    
    Calls wxApp::SafeYield.
    """

def Exit():
    """
    Exit()
    
    Exits application after calling wxApp::OnExit.
    """

def YieldIfNeeded():
    """
    Convenience function for wx.GetApp().Yield(True)
    """
    pass
class PyOnDemandOutputWindow(object):
    """
    A class that can be used for redirecting Python's stdout and
    stderr streams.  It will do nothing until something is wrriten to
    the stream at which point it will create a Frame with a text area
    and write the text there.
    """

    def __init__(self, title="wxPython: stdout/stderr"):
        pass

    def SetParent(self, parent):
        """
        Set the window to be used as the popup Frame's parent.
        """
        pass

    def CreateOutputWindow(self, txt):
        pass

    def OnCloseWindow(self, event):
        pass

    def write(self, text):
        """
        Create the output window if needed and write the string to it.
        If not called in the context of the gui thread then CallAfter is
        used to do the work there.
        """
        pass

    def close(self):
        pass

    def flush(self):
        pass
class App(PyApp):
    """
    The ``wx.App`` class represents the application and is used to:
    
      * bootstrap the wxPython system and initialize the underlying
        gui toolkit
      * set and get application-wide properties
      * implement the native windowing system main message or event loop,
        and to dispatch events to window instances
      * etc.
    
    Every wx application must have a single ``wx.App`` instance, and all
    creation of UI objects should be delayed until after the ``wx.App`` object
    has been created in order to ensure that the gui platform and wxWidgets
    have been fully initialized.
    
    Normally you would derive from this class and implement an ``OnInit``
    method that creates a frame and then calls ``self.SetTopWindow(frame)``,
    however ``wx.App`` is also usable on it's own without derivation.
    """

    outputWindowClass = PyOnDemandOutputWindow

    def __init__(self, redirect=False, filename=None, useBestVisual=False, clearSigInt=True):
        """
        Construct a ``wx.App`` object.
        
        :param redirect: Should ``sys.stdout`` and ``sys.stderr`` be
            redirected?  Defaults to False. If ``filename`` is None
            then output will be redirected to a window that pops up
            as needed.  (You can control what kind of window is created
            for the output by resetting the class variable
            ``outputWindowClass`` to a class of your choosing.)
        
        :param filename: The name of a file to redirect output to, if
            redirect is True.
        
        :param useBestVisual: Should the app try to use the best
            available visual provided by the system (only relevant on
            systems that have more than one visual.)  This parameter
            must be used instead of calling `SetUseBestVisual` later
            on because it must be set before the underlying GUI
            toolkit is initialized.
        
        :param clearSigInt: Should SIGINT be cleared?  This allows the
            app to terminate upon a Ctrl-C in the console like other
            GUI apps will.
        
        :note: You should override OnInit to do application
            initialization to ensure that the system, toolkit and
            wxWidgets are fully initialized.
        """
        pass

    def OnPreInit(self):
        """
        Things that must be done after _BootstrapApp has done its thing, but
        would be nice if they were already done by the time that OnInit is
        called.  This can be overridden in derived classes, but be sure to call
        this method from there.
        """
        pass

    def __del__(self):
        pass

    def SetTopWindow(self, frame):
        """
        Set the "main" top level window, which will be used for the parent of
        the on-demand output window as well as for dialogs that do not have
        an explicit parent set.
        """
        pass

    def MainLoop(self):
        """
        Execute the main GUI event loop
        """
        pass

    def RedirectStdio(self, filename=None):
        """
        Redirect sys.stdout and sys.stderr to a file or a popup window.
        """
        pass

    def RestoreStdio(self):
        pass

    def SetOutputWindowAttributes(self, title=None, pos=None, size=None):
        """
        Set the title, position and/or size of the output window if the stdio
        has been redirected. This should be called before any output would
        cause the output window to be created.
        """
        pass

    @staticmethod
    def Get():
        """
        A staticmethod returning the currently active application object.
        Essentially just a more pythonic version of :meth:`GetApp`.
        """
        pass
@wx.deprecated
class PySimpleApp(App):
    """
    This class is deprecated.  Please use :class:`App` instead.
    """

    def __init__(self, *args, **kw):
        pass
#-- end-app --#
#-- begin-timer --#
TIMER_CONTINUOUS = 0
TIMER_ONE_SHOT = 0
wxEVT_TIMER = 0

class Timer(EvtHandler):
    """
    Timer()
    Timer(owner, id=-1)
    
    The wxTimer class allows you to execute code at specified intervals.
    """

    def __init__(self, *args, **kw):
        """
        Timer()
        Timer(owner, id=-1)
        
        The wxTimer class allows you to execute code at specified intervals.
        """

    def GetId(self):
        """
        GetId() -> int
        
        Returns the ID of the events generated by this timer.
        """

    def GetInterval(self):
        """
        GetInterval() -> int
        
        Returns the current interval for the timer (in milliseconds).
        """

    def GetOwner(self):
        """
        GetOwner() -> EvtHandler
        
        Returns the current owner of the timer.
        """

    def IsOneShot(self):
        """
        IsOneShot() -> bool
        
        Returns true if the timer is one shot, i.e. if it will stop after
        firing the first notification automatically.
        """

    def IsRunning(self):
        """
        IsRunning() -> bool
        
        Returns true if the timer is running, false if it is stopped.
        """

    def Notify(self):
        """
        Notify()
        
        This member should be overridden by the user if the default
        constructor was used and SetOwner() wasn't called.
        """

    def SetOwner(self, owner, id=-1):
        """
        SetOwner(owner, id=-1)
        
        Associates the timer with the given owner object.
        """

    def Start(self, milliseconds=-1, oneShot=TIMER_CONTINUOUS):
        """
        Start(milliseconds=-1, oneShot=TIMER_CONTINUOUS) -> bool
        
        (Re)starts the timer.
        """

    def StartOnce(self, milliseconds=-1):
        """
        StartOnce(milliseconds=-1) -> bool
        
        Starts the timer for a once-only notification.
        """

    def Stop(self):
        """
        Stop()
        
        Stops the timer.
        """
    Id = property(None, None)
    Interval = property(None, None)
    Owner = property(None, None)
# end of class Timer


class TimerRunner(object):
    """
    TimerRunner(timer)
    TimerRunner(timer, milli, oneShot=False)
    
    Starts the timer in its ctor, stops in the dtor.
    """

    def __init__(self, *args, **kw):
        """
        TimerRunner(timer)
        TimerRunner(timer, milli, oneShot=False)
        
        Starts the timer in its ctor, stops in the dtor.
        """

    def Start(self, milli, oneShot=False):
        """
        Start(milli, oneShot=False)
        """
# end of class TimerRunner


class TimerEvent(Event):
    """
    TimerEvent()
    TimerEvent(timer)
    
    wxTimerEvent object is passed to the event handler of timer events
    (see wxTimer::SetOwner).
    """

    def __init__(self, *args, **kw):
        """
        TimerEvent()
        TimerEvent(timer)
        
        wxTimerEvent object is passed to the event handler of timer events
        (see wxTimer::SetOwner).
        """

    def GetInterval(self):
        """
        GetInterval() -> int
        
        Returns the interval of the timer which generated this event.
        """

    def GetTimer(self):
        """
        GetTimer() -> Timer
        
        Returns the timer object which generated this event.
        """
    Interval = property(None, None)
    Timer = property(None, None)
# end of class TimerEvent


EVT_TIMER = wx.PyEventBinder( wxEVT_TIMER )

class PyTimer(Timer):
    '''This timer class is passed the callable object to be called when the timer expires.'''
    def __init__(self, notify):
        Timer.__init__(self)
        self.notify = notify

    def Notify(self):
        if self.notify:
            self.notify()
#-- end-timer --#
#-- begin-window --#
SHOW_EFFECT_NONE = 0
SHOW_EFFECT_ROLL_TO_LEFT = 0
SHOW_EFFECT_ROLL_TO_RIGHT = 0
SHOW_EFFECT_ROLL_TO_TOP = 0
SHOW_EFFECT_ROLL_TO_BOTTOM = 0
SHOW_EFFECT_SLIDE_TO_LEFT = 0
SHOW_EFFECT_SLIDE_TO_RIGHT = 0
SHOW_EFFECT_SLIDE_TO_TOP = 0
SHOW_EFFECT_SLIDE_TO_BOTTOM = 0
SHOW_EFFECT_BLEND = 0
SHOW_EFFECT_EXPAND = 0
SHOW_EFFECT_MAX = 0
SEND_EVENT_POST = 0
WINDOW_VARIANT_NORMAL = 0
WINDOW_VARIANT_SMALL = 0
WINDOW_VARIANT_MINI = 0
WINDOW_VARIANT_LARGE = 0
WINDOW_VARIANT_MAX = 0

class VisualAttributes(object):
    """
    Struct containing all the visual attributes of a control.
    """
    font = property(None, None)
    colFg = property(None, None)
    colBg = property(None, None)
# end of class VisualAttributes

PanelNameStr = ""

class WindowBase(EvtHandler):
    """
    
    """

    def AddChild(self, child):
        """
        AddChild(child)
        """

    def RemoveChild(self, child):
        """
        RemoveChild(child)
        """
# end of class WindowBase


class Window(WindowBase):
    """
    Window()
    Window(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=PanelNameStr)
    
    wxWindow is the base class for all windows and represents any visible
    object on screen.
    """

    class ChildrenRepositioningGuard(object):
        """
        ChildrenRepositioningGuard(win)
        
        Helper for ensuring EndRepositioningChildren() is called correctly.
        """

        def __init__(self, win):
            """
            ChildrenRepositioningGuard(win)
            
            Helper for ensuring EndRepositioningChildren() is called correctly.
            """
    # end of class ChildrenRepositioningGuard


    def __init__(self, *args, **kw):
        """
        Window()
        Window(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=PanelNameStr)
        
        wxWindow is the base class for all windows and represents any visible
        object on screen.
        """

    def AcceptsFocus(self):
        """
        AcceptsFocus() -> bool
        
        This method may be overridden in the derived classes to return false
        to indicate that this control doesn't accept input at all (i.e.
        behaves like e.g. wxStaticText) and so doesn't need focus.
        """

    def AcceptsFocusFromKeyboard(self):
        """
        AcceptsFocusFromKeyboard() -> bool
        
        This method may be overridden in the derived classes to return false
        to indicate that while this control can, in principle, have focus if
        the user clicks it with the mouse, it shouldn't be included in the TAB
        traversal chain when using the keyboard.
        """

    def AcceptsFocusRecursively(self):
        """
        AcceptsFocusRecursively() -> bool
        
        Overridden to indicate whether this window or one of its children
        accepts focus.
        """

    def IsFocusable(self):
        """
        IsFocusable() -> bool
        
        Can this window itself have focus?
        """

    def CanAcceptFocus(self):
        """
        CanAcceptFocus() -> bool
        
        Can this window have focus right now?
        """

    def CanAcceptFocusFromKeyboard(self):
        """
        CanAcceptFocusFromKeyboard() -> bool
        
        Can this window be assigned focus from keyboard right now?
        """

    def HasFocus(self):
        """
        HasFocus() -> bool
        
        Returns true if the window (or in case of composite controls, its main
        child window) has focus.
        """

    def SetCanFocus(self, canFocus):
        """
        SetCanFocus(canFocus)
        
        This method is only implemented by ports which have support for native
        TAB traversal (such as GTK+ 2.0).
        """

    def SetFocus(self):
        """
        SetFocus()
        
        This sets the window to receive keyboard input.
        """

    def SetFocusFromKbd(self):
        """
        SetFocusFromKbd()
        
        This function is called by wxWidgets keyboard navigation code when the
        user gives the focus to this window from keyboard (e.g.
        """

    def AddChild(self, child):
        """
        AddChild(child)
        
        Adds a child window.
        """

    def DestroyChildren(self):
        """
        DestroyChildren() -> bool
        
        Destroys all children of a window.
        """

    def FindWindow(self, *args, **kw):
        """
        FindWindow(id) -> Window
        FindWindow(name) -> Window
        
        Find a child of this window, by id.
        """

    def GetChildren(self):
        """
        GetChildren() -> WindowList
        
        Returns a reference to the list of the window's children.
        """

    def RemoveChild(self, child):
        """
        RemoveChild(child)
        
        Removes a child window.
        """

    def GetGrandParent(self):
        """
        GetGrandParent() -> Window
        
        Returns the grandparent of a window, or NULL if there isn't one.
        """

    def GetNextSibling(self):
        """
        GetNextSibling() -> Window
        
        Returns the next window after this one among the parent's children or
        NULL if this window is the last child.
        """

    def GetParent(self):
        """
        GetParent() -> Window
        
        Returns the parent of the window, or NULL if there is no parent.
        """

    def GetPrevSibling(self):
        """
        GetPrevSibling() -> Window
        
        Returns the previous window before this one among the parent's
        children or  NULL if this window is the first child.
        """

    def IsDescendant(self, win):
        """
        IsDescendant(win) -> bool
        
        Check if the specified window is a descendant of this one.
        """

    def Reparent(self, newParent):
        """
        Reparent(newParent) -> bool
        
        Reparents the window, i.e. the window will be removed from its current
        parent window (e.g.
        """

    def AlwaysShowScrollbars(self, hflag=True, vflag=True):
        """
        AlwaysShowScrollbars(hflag=True, vflag=True)
        
        Call this function to force one or both scrollbars to be always shown,
        even if the window is big enough to show its entire contents without
        scrolling.
        """

    def GetScrollPos(self, orientation):
        """
        GetScrollPos(orientation) -> int
        
        Returns the built-in scrollbar position.
        """

    def GetScrollRange(self, orientation):
        """
        GetScrollRange(orientation) -> int
        
        Returns the built-in scrollbar range.
        """

    def GetScrollThumb(self, orientation):
        """
        GetScrollThumb(orientation) -> int
        
        Returns the built-in scrollbar thumb size.
        """

    def CanScroll(self, orient):
        """
        CanScroll(orient) -> bool
        
        Returns true if this window can have a scroll bar in this orientation.
        """

    def HasScrollbar(self, orient):
        """
        HasScrollbar(orient) -> bool
        
        Returns true if this window currently has a scroll bar for this
        orientation.
        """

    def IsScrollbarAlwaysShown(self, orient):
        """
        IsScrollbarAlwaysShown(orient) -> bool
        
        Return whether a scrollbar is always shown.
        """

    def ScrollLines(self, lines):
        """
        ScrollLines(lines) -> bool
        
        Scrolls the window by the given number of lines down (if lines is
        positive) or up.
        """

    def ScrollPages(self, pages):
        """
        ScrollPages(pages) -> bool
        
        Scrolls the window by the given number of pages down (if pages is
        positive) or up.
        """

    def ScrollWindow(self, dx, dy, rect=None):
        """
        ScrollWindow(dx, dy, rect=None)
        
        Physically scrolls the pixels in the window and move child windows
        accordingly.
        """

    def LineUp(self):
        """
        LineUp() -> bool
        
        Same as ScrollLines (-1).
        """

    def LineDown(self):
        """
        LineDown() -> bool
        
        Same as ScrollLines (1).
        """

    def PageUp(self):
        """
        PageUp() -> bool
        
        Same as ScrollPages (-1).
        """

    def PageDown(self):
        """
        PageDown() -> bool
        
        Same as ScrollPages (1).
        """

    def SetScrollPos(self, orientation, pos, refresh=True):
        """
        SetScrollPos(orientation, pos, refresh=True)
        
        Sets the position of one of the built-in scrollbars.
        """

    def SetScrollbar(self, orientation, position, thumbSize, range, refresh=True):
        """
        SetScrollbar(orientation, position, thumbSize, range, refresh=True)
        
        Sets the scrollbar properties of a built-in scrollbar.
        """

    def BeginRepositioningChildren(self):
        """
        BeginRepositioningChildren() -> bool
        
        Prepare for changing positions of multiple child windows.
        """

    def EndRepositioningChildren(self):
        """
        EndRepositioningChildren()
        
        Fix child window positions after setting all of them at once.
        """

    def CacheBestSize(self, size):
        """
        CacheBestSize(size)
        
        Sets the cached best size value.
        """

    def ClientToWindowSize(self, size):
        """
        ClientToWindowSize(size) -> Size
        
        Converts client area size size to corresponding window size.
        """

    def WindowToClientSize(self, size):
        """
        WindowToClientSize(size) -> Size
        
        Converts window size size to corresponding client area size In other
        words, the returned value is what would GetClientSize() return if this
        window had given window size.
        """

    def Fit(self):
        """
        Fit()
        
        Sizes the window so that it fits around its subwindows.
        """

    def FitInside(self):
        """
        FitInside()
        
        Similar to Fit(), but sizes the interior (virtual) size of a window.
        """

    def GetBestSize(self):
        """
        GetBestSize() -> Size
        
        This functions returns the best acceptable minimal size for the
        window.
        """

    def GetBestHeight(self, width):
        """
        GetBestHeight(width) -> int
        
        Returns the best height needed by this window if it had the given
        width.
        """

    def GetBestWidth(self, height):
        """
        GetBestWidth(height) -> int
        
        Returns the best width needed by this window if it had the given
        height.
        """

    def GetClientSize(self):
        """
        GetClientSize() -> Size
        
        Returns the size of the window 'client area' in pixels.
        """

    def GetEffectiveMinSize(self):
        """
        GetEffectiveMinSize() -> Size
        
        Merges the window's best size into the min size and returns the
        result.
        """

    def GetMaxClientSize(self):
        """
        GetMaxClientSize() -> Size
        
        Returns the maximum size of window's client area.
        """

    def GetMaxSize(self):
        """
        GetMaxSize() -> Size
        
        Returns the maximum size of the window.
        """

    def GetMinClientSize(self):
        """
        GetMinClientSize() -> Size
        
        Returns the minimum size of window's client area, an indication to the
        sizer layout mechanism that this is the minimum required size of its
        client area.
        """

    def GetMinSize(self):
        """
        GetMinSize() -> Size
        
        Returns the minimum size of the window, an indication to the sizer
        layout mechanism that this is the minimum required size.
        """

    def GetMinWidth(self):
        """
        GetMinWidth() -> int
        
        Returns the horizontal component of window minimal size.
        """

    def GetMinHeight(self):
        """
        GetMinHeight() -> int
        
        Returns the vertical component of window minimal size.
        """

    def GetMaxWidth(self):
        """
        GetMaxWidth() -> int
        
        Returns the horizontal component of window maximal size.
        """

    def GetMaxHeight(self):
        """
        GetMaxHeight() -> int
        
        Returns the vertical component of window maximal size.
        """

    def GetSize(self):
        """
        GetSize() -> Size
        
        Returns the size of the entire window in pixels, including title bar,
        border, scrollbars, etc.
        """

    def GetVirtualSize(self):
        """
        GetVirtualSize() -> Size
        
        This gets the virtual size of the window in pixels.
        """

    def GetBestVirtualSize(self):
        """
        GetBestVirtualSize() -> Size
        
        Return the largest of ClientSize and BestSize (as determined by a
        sizer, interior children, or other means)
        """

    def GetContentScaleFactor(self):
        """
        GetContentScaleFactor() -> double
        
        Returns the magnification of the backing store of this window, eg 2.0
        for a window on a retina screen.
        """

    def GetWindowBorderSize(self):
        """
        GetWindowBorderSize() -> Size
        
        Returns the size of the left/right and top/bottom borders of this
        window in x and y components of the result respectively.
        """

    def InformFirstDirection(self, direction, size, availableOtherDir):
        """
        InformFirstDirection(direction, size, availableOtherDir) -> bool
        
        wxSizer and friends use this to give a chance to a component to recalc
        its min size once one of the final size components is known.
        """

    def InvalidateBestSize(self):
        """
        InvalidateBestSize()
        
        Resets the cached best size value so it will be recalculated the next
        time it is needed.
        """

    def PostSizeEvent(self):
        """
        PostSizeEvent()
        
        Posts a size event to the window.
        """

    def PostSizeEventToParent(self):
        """
        PostSizeEventToParent()
        
        Posts a size event to the parent of this window.
        """

    def SendSizeEvent(self, flags=0):
        """
        SendSizeEvent(flags=0)
        
        This function sends a dummy size event to the window allowing it to
        re-layout its children positions.
        """

    def SendSizeEventToParent(self, flags=0):
        """
        SendSizeEventToParent(flags=0)
        
        Safe wrapper for GetParent()->SendSizeEvent().
        """

    def SetClientSize(self, *args, **kw):
        """
        SetClientSize(width, height)
        SetClientSize(size)
        SetClientSize(rect)
        
        This sets the size of the window client area in pixels.
        """

    def SetContainingSizer(self, sizer):
        """
        SetContainingSizer(sizer)
        
        This normally does not need to be called by user code.
        """

    def SetInitialSize(self, size=DefaultSize):
        """
        SetInitialSize(size=DefaultSize)
        
        A smart SetSize that will fill in default size components with the
        window's best size values.
        """

    def SetMaxClientSize(self, size):
        """
        SetMaxClientSize(size)
        
        Sets the maximum client size of the window, to indicate to the sizer
        layout mechanism that this is the maximum possible size of its client
        area.
        """

    def SetMaxSize(self, size):
        """
        SetMaxSize(size)
        
        Sets the maximum size of the window, to indicate to the sizer layout
        mechanism that this is the maximum possible size.
        """

    def SetMinClientSize(self, size):
        """
        SetMinClientSize(size)
        
        Sets the minimum client size of the window, to indicate to the sizer
        layout mechanism that this is the minimum required size of window's
        client area.
        """

    def SetMinSize(self, size):
        """
        SetMinSize(size)
        
        Sets the minimum size of the window, to indicate to the sizer layout
        mechanism that this is the minimum required size.
        """

    def SetSize(self, *args, **kw):
        """
        SetSize(x, y, width, height, sizeFlags=SIZE_AUTO)
        SetSize(rect)
        SetSize(size)
        SetSize(width, height)
        
        Sets the size of the window in pixels.
        """

    def SetSizeHints(self, *args, **kw):
        """
        SetSizeHints(minSize, maxSize=DefaultSize, incSize=DefaultSize)
        SetSizeHints(minW, minH, maxW=-1, maxH=-1, incW=-1, incH=-1)
        
        Use of this function for windows which are not toplevel windows (such
        as wxDialog or wxFrame) is discouraged.
        """

    def SetVirtualSize(self, *args, **kw):
        """
        SetVirtualSize(width, height)
        SetVirtualSize(size)
        
        Sets the virtual size of the window in pixels.
        """

    def Center(self, dir=BOTH):
        """
        Center(dir=BOTH)
        
        A synonym for Centre().
        """

    def CenterOnParent(self, dir=BOTH):
        """
        CenterOnParent(dir=BOTH)
        
        A synonym for CentreOnParent().
        """

    def Centre(self, direction=BOTH):
        """
        Centre(direction=BOTH)
        
        Centres the window.
        """

    def CentreOnParent(self, direction=BOTH):
        """
        CentreOnParent(direction=BOTH)
        
        Centres the window on its parent.
        """

    def GetPosition(self):
        """
        GetPosition() -> Point
        
        This gets the position of the window in pixels, relative to the parent
        window for the child windows or relative to the display origin for the
        top level windows.
        """

    def GetRect(self):
        """
        GetRect() -> Rect
        
        Returns the position and size of the window as a wxRect object.
        """

    def GetScreenPosition(self):
        """
        GetScreenPosition() -> Point
        
        Returns the window position in screen coordinates, whether the window
        is a child window or a top level one.
        """

    def GetScreenRect(self):
        """
        GetScreenRect() -> Rect
        
        Returns the position and size of the window on the screen as a wxRect
        object.
        """

    def GetClientAreaOrigin(self):
        """
        GetClientAreaOrigin() -> Point
        
        Get the origin of the client area of the window relative to the window
        top left corner (the client area may be shifted because of the
        borders, scrollbars, other decorations...)
        """

    def GetClientRect(self):
        """
        GetClientRect() -> Rect
        
        Get the client rectangle in window (i.e. client) coordinates.
        """

    def Move(self, *args, **kw):
        """
        Move(x, y, flags=SIZE_USE_EXISTING)
        Move(pt, flags=SIZE_USE_EXISTING)
        
        Moves the window to the given position.
        """

    def SetPosition(self, pt):
        """
        SetPosition(pt)
        
        Moves the window to the specified position.
        """

    def ClientToScreen(self, *args, **kw):
        """
        ClientToScreen(x, y) -> (x, y)
        ClientToScreen(pt) -> Point
        
        Converts to screen coordinates from coordinates relative to this
        window.
        """

    def ConvertDialogToPixels(self, *args, **kw):
        """
        ConvertDialogToPixels(pt) -> Point
        ConvertDialogToPixels(sz) -> Size
        
        Converts a point or size from dialog units to pixels.
        """

    def ConvertPixelsToDialog(self, *args, **kw):
        """
        ConvertPixelsToDialog(pt) -> Point
        ConvertPixelsToDialog(sz) -> Size
        
        Converts a point or size from pixels to dialog units.
        """

    def ScreenToClient(self, *args, **kw):
        """
        ScreenToClient(x, y) -> (x, y)
        ScreenToClient(pt) -> Point
        
        Converts from screen to client window coordinates.
        """

    def ClearBackground(self):
        """
        ClearBackground()
        
        Clears the window by filling it with the current background colour.
        """

    def Freeze(self):
        """
        Freeze()
        
        Freezes the window or, in other words, prevents any updates from
        taking place on screen, the window is not redrawn at all.
        """

    def Thaw(self):
        """
        Thaw()
        
        Re-enables window updating after a previous call to Freeze().
        """

    def IsFrozen(self):
        """
        IsFrozen() -> bool
        
        Returns true if the window is currently frozen by a call to Freeze().
        """

    def GetBackgroundColour(self):
        """
        GetBackgroundColour() -> Colour
        
        Returns the background colour of the window.
        """

    def GetBackgroundStyle(self):
        """
        GetBackgroundStyle() -> BackgroundStyle
        
        Returns the background style of the window.
        """

    def GetCharHeight(self):
        """
        GetCharHeight() -> int
        
        Returns the character height for this window.
        """

    def GetCharWidth(self):
        """
        GetCharWidth() -> int
        
        Returns the average character width for this window.
        """

    def GetDefaultAttributes(self):
        """
        GetDefaultAttributes() -> VisualAttributes
        
        Currently this is the same as calling
        wxWindow::GetClassDefaultAttributes(wxWindow::GetWindowVariant()).
        """

    def GetFont(self):
        """
        GetFont() -> Font
        
        Returns the font for this window.
        """

    def GetForegroundColour(self):
        """
        GetForegroundColour() -> Colour
        
        Returns the foreground colour of the window.
        """

    def GetFullTextExtent(self, *args, **kw):
        """
        GetFullTextExtent(string, font=None) -> (w, h, descent, externalLeading)
        GetTextExtent(string) -> Size
        
        Gets the dimensions of the string as it would be drawn on the window
        with the currently selected font.
        """

    def GetUpdateRegion(self):
        """
        GetUpdateRegion() -> Region
        
        Returns the region specifying which parts of the window have been
        damaged.
        """

    def GetUpdateClientRect(self):
        """
        GetUpdateClientRect() -> Rect
        
        Get the update rectangle bounding box in client coords.
        """

    def HasTransparentBackground(self):
        """
        HasTransparentBackground() -> bool
        
        Returns true if this window background is transparent (as, for
        example, for wxStaticText) and should show the parent window
        background.
        """

    def Refresh(self, eraseBackground=True, rect=None):
        """
        Refresh(eraseBackground=True, rect=None)
        
        Causes this window, and all of its children recursively (except under
        wxGTK1 where this is not implemented), to be repainted.
        """

    def RefreshRect(self, rect, eraseBackground=True):
        """
        RefreshRect(rect, eraseBackground=True)
        
        Redraws the contents of the given rectangle: only the area inside it
        will be repainted.
        """

    def Update(self):
        """
        Update()
        
        Calling this method immediately repaints the invalidated area of the
        window and all of its children recursively (this normally only happens
        when the flow of control returns to the event loop).
        """

    def SetBackgroundColour(self, colour):
        """
        SetBackgroundColour(colour) -> bool
        
        Sets the background colour of the window.
        """

    def SetBackgroundStyle(self, style):
        """
        SetBackgroundStyle(style) -> bool
        
        Sets the background style of the window.
        """

    def IsTransparentBackgroundSupported(self, reason=None):
        """
        IsTransparentBackgroundSupported(reason=None) -> bool
        
        Checks whether using transparent background might work.
        """

    def SetFont(self, font):
        """
        SetFont(font) -> bool
        
        Sets the font for this window.
        """

    def SetForegroundColour(self, colour):
        """
        SetForegroundColour(colour) -> bool
        
        Sets the foreground colour of the window.
        """

    def SetOwnBackgroundColour(self, colour):
        """
        SetOwnBackgroundColour(colour)
        
        Sets the background colour of the window but prevents it from being
        inherited by the children of this window.
        """

    def InheritsBackgroundColour(self):
        """
        InheritsBackgroundColour() -> bool
        
        Return true if this window inherits the background colour from its
        parent.
        """

    def UseBgCol(self):
        """
        UseBgCol() -> bool
        
        Return true if a background colour has been set for this window.
        """

    def SetOwnFont(self, font):
        """
        SetOwnFont(font)
        
        Sets the font of the window but prevents it from being inherited by
        the children of this window.
        """

    def SetOwnForegroundColour(self, colour):
        """
        SetOwnForegroundColour(colour)
        
        Sets the foreground colour of the window but prevents it from being
        inherited by the children of this window.
        """

    def SetPalette(self, pal):
        """
        SetPalette(pal)
        """

    def ShouldInheritColours(self):
        """
        ShouldInheritColours() -> bool
        
        Return true from here to allow the colours of this window to be
        changed by InheritAttributes().
        """

    def SetThemeEnabled(self, enable):
        """
        SetThemeEnabled(enable)
        
        This function tells a window if it should use the system's "theme"
        code to draw the windows' background instead of its own background
        drawing code.
        """

    def GetThemeEnabled(self):
        """
        GetThemeEnabled() -> bool
        
        Clears the window by filling it with the current background colour.
        """

    def CanSetTransparent(self):
        """
        CanSetTransparent() -> bool
        
        Returns true if the system supports transparent windows and calling
        SetTransparent() may succeed.
        """

    def SetTransparent(self, alpha):
        """
        SetTransparent(alpha) -> bool
        
        Set the transparency of the window.
        """

    def GetEventHandler(self):
        """
        GetEventHandler() -> EvtHandler
        
        Returns the event handler for this window.
        """

    def HandleAsNavigationKey(self, event):
        """
        HandleAsNavigationKey(event) -> bool
        
        This function will generate the appropriate call to Navigate() if the
        key event is one normally used for keyboard navigation and return true
        in this case.
        """

    def HandleWindowEvent(self, event):
        """
        HandleWindowEvent(event) -> bool
        
        Shorthand for:
        """

    def ProcessWindowEvent(self, event):
        """
        ProcessWindowEvent(event) -> bool
        
        Convenient wrapper for ProcessEvent().
        """

    def ProcessWindowEventLocally(self, event):
        """
        ProcessWindowEventLocally(event) -> bool
        
        Wrapper for wxEvtHandler::ProcessEventLocally().
        """

    def PopEventHandler(self, deleteHandler=False):
        """
        PopEventHandler(deleteHandler=False) -> EvtHandler
        
        Removes and returns the top-most event handler on the event handler
        stack.
        """

    def PushEventHandler(self, handler):
        """
        PushEventHandler(handler)
        
        Pushes this event handler onto the event stack for the window.
        """

    def RemoveEventHandler(self, handler):
        """
        RemoveEventHandler(handler) -> bool
        
        Find the given handler in the windows event handler stack and removes
        (but does not delete) it from the stack.
        """

    def SetEventHandler(self, handler):
        """
        SetEventHandler(handler)
        
        Sets the event handler for this window.
        """

    def SetNextHandler(self, handler):
        """
        SetNextHandler(handler)
        
        wxWindows cannot be used to form event handler chains; this function
        thus will assert when called.
        """

    def SetPreviousHandler(self, handler):
        """
        SetPreviousHandler(handler)
        
        wxWindows cannot be used to form event handler chains; this function
        thus will assert when called.
        """

    def GetExtraStyle(self):
        """
        GetExtraStyle() -> long
        
        Returns the extra style bits for the window.
        """

    def GetWindowStyleFlag(self):
        """
        GetWindowStyleFlag() -> long
        
        Gets the window style that was passed to the constructor or Create()
        method.
        """

    def GetWindowStyle(self):
        """
        GetWindowStyle() -> long
        
        See GetWindowStyleFlag() for more info.
        """

    def HasExtraStyle(self, exFlag):
        """
        HasExtraStyle(exFlag) -> bool
        
        Returns true if the window has the given exFlag bit set in its extra
        styles.
        """

    def HasFlag(self, flag):
        """
        HasFlag(flag) -> bool
        
        Returns true if the window has the given flag bit set.
        """

    def SetExtraStyle(self, exStyle):
        """
        SetExtraStyle(exStyle)
        
        Sets the extra style bits for the window.
        """

    def SetWindowStyleFlag(self, style):
        """
        SetWindowStyleFlag(style)
        
        Sets the style of the window.
        """

    def SetWindowStyle(self, style):
        """
        SetWindowStyle(style)
        
        See SetWindowStyleFlag() for more info.
        """

    def ToggleWindowStyle(self, flag):
        """
        ToggleWindowStyle(flag) -> bool
        
        Turns the given flag on if it's currently turned off and vice versa.
        """

    def MoveAfterInTabOrder(self, win):
        """
        MoveAfterInTabOrder(win)
        
        Moves this window in the tab navigation order after the specified win.
        """

    def MoveBeforeInTabOrder(self, win):
        """
        MoveBeforeInTabOrder(win)
        
        Same as MoveAfterInTabOrder() except that it inserts this window just
        before win instead of putting it right after it.
        """

    def Navigate(self, flags=NavigationKeyEvent.IsForward):
        """
        Navigate(flags=NavigationKeyEvent.IsForward) -> bool
        
        Performs a keyboard navigation action starting from this window.
        """

    def NavigateIn(self, flags=NavigationKeyEvent.IsForward):
        """
        NavigateIn(flags=NavigationKeyEvent.IsForward) -> bool
        
        Performs a keyboard navigation action inside this window.
        """

    def Lower(self):
        """
        Lower()
        
        Lowers the window to the bottom of the window hierarchy (Z-order).
        """

    def Raise(self):
        """
        Raise()
        
        Raises the window to the top of the window hierarchy (Z-order).
        """

    def Hide(self):
        """
        Hide() -> bool
        
        Equivalent to calling wxWindow::Show(false).
        """

    def HideWithEffect(self, effect, timeout=0):
        """
        HideWithEffect(effect, timeout=0) -> bool
        
        This function hides a window, like Hide(), but using a special visual
        effect if possible.
        """

    def IsEnabled(self):
        """
        IsEnabled() -> bool
        
        Returns true if the window is enabled, i.e. if it accepts user input,
        false otherwise.
        """

    def IsExposed(self, *args, **kw):
        """
        IsExposed(x, y) -> bool
        IsExposed(pt) -> bool
        IsExposed(x, y, w, h) -> bool
        IsExposed(rect) -> bool
        
        Returns true if the given point or rectangle area has been exposed
        since the last repaint.
        """

    def IsShown(self):
        """
        IsShown() -> bool
        
        Returns true if the window is shown, false if it has been hidden.
        """

    def IsShownOnScreen(self):
        """
        IsShownOnScreen() -> bool
        
        Returns true if the window is physically visible on the screen, i.e.
        it is shown and all its parents up to the toplevel window are shown as
        well.
        """

    def Disable(self):
        """
        Disable() -> bool
        
        Disables the window.
        """

    def Enable(self, enable=True):
        """
        Enable(enable=True) -> bool
        
        Enable or disable the window for user input.
        """

    def Show(self, show=True):
        """
        Show(show=True) -> bool
        
        Shows or hides the window.
        """

    def ShowWithEffect(self, effect, timeout=0):
        """
        ShowWithEffect(effect, timeout=0) -> bool
        
        This function shows a window, like Show(), but using a special visual
        effect if possible.
        """

    def GetHelpText(self):
        """
        GetHelpText() -> String
        
        Gets the help text to be used as context-sensitive help for this
        window.
        """

    def SetHelpText(self, helpText):
        """
        SetHelpText(helpText)
        
        Sets the help text to be used as context-sensitive help for this
        window.
        """

    def GetHelpTextAtPoint(self, point, origin):
        """
        GetHelpTextAtPoint(point, origin) -> String
        
        Gets the help text to be used as context-sensitive help for this
        window.
        """

    def GetToolTip(self):
        """
        GetToolTip() -> ToolTip
        
        Get the associated tooltip or NULL if none.
        """

    def GetToolTipText(self):
        """
        GetToolTipText() -> String
        
        Get the text of the associated tooltip or empty string if none.
        """

    def SetToolTip(self, *args, **kw):
        """
        SetToolTip(tipString)
        SetToolTip(tip)
        
        Attach a tooltip to the window.
        """

    def UnsetToolTip(self):
        """
        UnsetToolTip()
        
        Unset any existing tooltip.
        """

    def GetPopupMenuSelectionFromUser(self, *args, **kw):
        """
        GetPopupMenuSelectionFromUser(menu, pos=DefaultPosition) -> int
        GetPopupMenuSelectionFromUser(menu, x, y) -> int
        
        This function shows a popup menu at the given position in this window
        and returns the selected id.
        """

    def PopupMenu(self, *args, **kw):
        """
        PopupMenu(menu, pos=DefaultPosition) -> bool
        PopupMenu(menu, x, y) -> bool
        
        Pops up the given menu at the specified coordinates, relative to this
        window, and returns control when the user has dismissed the menu.
        """

    def GetValidator(self):
        """
        GetValidator() -> Validator
        
        Validator functions.
        """

    def SetValidator(self, validator):
        """
        SetValidator(validator)
        
        Deletes the current validator (if any) and sets the window validator,
        having called wxValidator::Clone to create a new validator of this
        type.
        """

    def TransferDataFromWindow(self):
        """
        TransferDataFromWindow() -> bool
        
        Transfers values from child controls to data areas specified by their
        validators.
        """

    def TransferDataToWindow(self):
        """
        TransferDataToWindow() -> bool
        
        Transfers values to child controls from data areas specified by their
        validators.
        """

    def Validate(self):
        """
        Validate() -> bool
        
        Validates the current values of the child controls using their
        validators.
        """

    def GetId(self):
        """
        GetId() -> WindowID
        
        Returns the identifier of the window.
        """

    def GetLabel(self):
        """
        GetLabel() -> String
        
        Generic way of getting a label from any window, for identification
        purposes.
        """

    def GetLayoutDirection(self):
        """
        GetLayoutDirection() -> LayoutDirection
        
        Returns the layout direction for this window, Note that
        wxLayout_Default is returned if layout direction is not supported.
        """

    def AdjustForLayoutDirection(self, x, width, widthTotal):
        """
        AdjustForLayoutDirection(x, width, widthTotal) -> Coord
        
        Mirror coordinates for RTL layout if this window uses it and if the
        mirroring is not done automatically like Win32.
        """

    def GetName(self):
        """
        GetName() -> String
        
        Returns the window's name.
        """

    def GetWindowVariant(self):
        """
        GetWindowVariant() -> WindowVariant
        
        Returns the value previously passed to SetWindowVariant().
        """

    def SetId(self, winid):
        """
        SetId(winid)
        
        Sets the identifier of the window.
        """

    def SetLabel(self, label):
        """
        SetLabel(label)
        
        Sets the window's label.
        """

    def SetLayoutDirection(self, dir):
        """
        SetLayoutDirection(dir)
        
        Sets the layout direction for this window.
        """

    def SetName(self, name):
        """
        SetName(name)
        
        Sets the window's name.
        """

    def SetWindowVariant(self, variant):
        """
        SetWindowVariant(variant)
        
        Chooses a different variant of the window display to use.
        """

    def GetAcceleratorTable(self):
        """
        GetAcceleratorTable() -> AcceleratorTable
        
        Gets the accelerator table for this window.
        """

    def SetAcceleratorTable(self, accel):
        """
        SetAcceleratorTable(accel)
        
        Sets the accelerator table for this window.
        """

    def Close(self, force=False):
        """
        Close(force=False) -> bool
        
        This function simply generates a wxCloseEvent whose handler usually
        tries to close the window.
        """

    def Destroy(self):
        """
        Destroy() -> bool
        
        Destroys the window safely.
        """

    def IsBeingDeleted(self):
        """
        IsBeingDeleted() -> bool
        
        Returns true if this window is in process of being destroyed.
        """

    def GetDropTarget(self):
        """
        GetDropTarget() -> DropTarget
        
        Returns the associated drop target, which may be NULL.
        """

    def SetDropTarget(self, target):
        """
        SetDropTarget(target)
        
        Associates a drop target with this window.
        """

    def DragAcceptFiles(self, accept):
        """
        DragAcceptFiles(accept)
        
        Enables or disables eligibility for drop file events (OnDropFiles).
        """

    def GetContainingSizer(self):
        """
        GetContainingSizer() -> Sizer
        
        Returns the sizer of which this window is a member, if any, otherwise
        NULL.
        """

    def GetSizer(self):
        """
        GetSizer() -> Sizer
        
        Returns the sizer associated with the window by a previous call to
        SetSizer(), or NULL.
        """

    def SetSizer(self, sizer, deleteOld=True):
        """
        SetSizer(sizer, deleteOld=True)
        
        Sets the window to have the given layout sizer.
        """

    def SetSizerAndFit(self, sizer, deleteOld=True):
        """
        SetSizerAndFit(sizer, deleteOld=True)
        
        This method calls SetSizer() and then wxSizer::SetSizeHints which sets
        the initial window size to the size needed to accommodate all sizer
        elements and sets the size hints which, if this window is a top level
        one, prevent the user from resizing it to be less than this minimal
        size.
        """

    def GetConstraints(self):
        """
        GetConstraints() -> LayoutConstraints
        
        Returns a pointer to the window's layout constraints, or NULL if there
        are none.
        """

    def SetConstraints(self, constraints):
        """
        SetConstraints(constraints)
        
        Sets the window to have the given layout constraints.
        """

    def Layout(self):
        """
        Layout() -> bool
        
        Invokes the constraint-based layout algorithm or the sizer-based
        algorithm for this window.
        """

    def SetAutoLayout(self, autoLayout):
        """
        SetAutoLayout(autoLayout)
        
        Determines whether the Layout() function will be called automatically
        when the window is resized.
        """

    def GetAutoLayout(self):
        """
        GetAutoLayout() -> bool
        
        Returns the sizer of which this window is a member, if any, otherwise
        NULL.
        """

    def CaptureMouse(self):
        """
        CaptureMouse()
        
        Directs all mouse input to this window.
        """

    def GetCaret(self):
        """
        GetCaret() -> Caret
        
        Returns the caret() associated with the window.
        """

    def GetCursor(self):
        """
        GetCursor() -> Cursor
        
        Return the cursor associated with this window.
        """

    def HasCapture(self):
        """
        HasCapture() -> bool
        
        Returns true if this window has the current mouse capture.
        """

    def ReleaseMouse(self):
        """
        ReleaseMouse()
        
        Releases mouse input captured with CaptureMouse().
        """

    def SetCaret(self, caret):
        """
        SetCaret(caret)
        
        Sets the caret() associated with the window.
        """

    def SetCursor(self, cursor):
        """
        SetCursor(cursor) -> bool
        
        Sets the window's cursor.
        """

    def WarpPointer(self, x, y):
        """
        WarpPointer(x, y)
        
        Moves the pointer to the given position on the window.
        """

    def HitTest(self, *args, **kw):
        """
        HitTest(x, y) -> HitTest
        HitTest(pt) -> HitTest
        
        Get the window border style from the given flags: this is different
        from simply doing flags & wxBORDER_MASK because it uses
        GetDefaultBorder() to translate wxBORDER_DEFAULT to something
        reasonable.
        """

    def GetBorder(self, *args, **kw):
        """
        GetBorder(flags) -> Border
        GetBorder() -> Border
        
        Get the window border style from the given flags: this is different
        from simply doing flags & wxBORDER_MASK because it uses
        GetDefaultBorder() to translate wxBORDER_DEFAULT to something
        reasonable.
        """

    def DoUpdateWindowUI(self, event):
        """
        DoUpdateWindowUI(event)
        
        Does the window-specific updating after processing the update event.
        """

    def GetHandle(self):
        """
        GetHandle() -> UIntPtr
        
        Returns the platform-specific handle of the physical window.
        """

    def HasMultiplePages(self):
        """
        HasMultiplePages() -> bool
        
        This method should be overridden to return true if this window has
        multiple pages.
        """

    def InheritAttributes(self):
        """
        InheritAttributes()
        
        This function is (or should be, in case of custom controls) called
        during window creation to intelligently set up the window visual
        attributes, that is the font and the foreground and background
        colours.
        """

    def InitDialog(self):
        """
        InitDialog()
        
        Sends an wxEVT_INIT_DIALOG event, whose handler usually transfers data
        to the dialog via validators.
        """

    def IsDoubleBuffered(self):
        """
        IsDoubleBuffered() -> bool
        
        Returns true if the window contents is double-buffered by the system,
        i.e. if any drawing done on the window is really done on a temporary
        backing surface and transferred to the screen all at once later.
        """

    def SetDoubleBuffered(self, on):
        """
        SetDoubleBuffered(on)
        
        Turn on or off double buffering of the window if the system supports
        it.
        """

    def IsRetained(self):
        """
        IsRetained() -> bool
        
        Returns true if the window is retained, false otherwise.
        """

    def IsThisEnabled(self):
        """
        IsThisEnabled() -> bool
        
        Returns true if this window is intrinsically enabled, false otherwise,
        i.e. if Enable() Enable(false) had been called.
        """

    def IsTopLevel(self):
        """
        IsTopLevel() -> bool
        
        Returns true if the given window is a top-level one.
        """

    def OnInternalIdle(self):
        """
        OnInternalIdle()
        
        This virtual function is normally only used internally, but sometimes
        an application may need it to implement functionality that should not
        be disabled by an application defining an OnIdle handler in a derived
        class.
        """

    def SendIdleEvents(self, event):
        """
        SendIdleEvents(event) -> bool
        
        Send idle event to window and all subwindows.
        """

    def RegisterHotKey(self, hotkeyId, modifiers, virtualKeyCode):
        """
        RegisterHotKey(hotkeyId, modifiers, virtualKeyCode) -> bool
        
        Registers a system wide hotkey.
        """

    def UnregisterHotKey(self, hotkeyId):
        """
        UnregisterHotKey(hotkeyId) -> bool
        
        Unregisters a system wide hotkey.
        """

    def UpdateWindowUI(self, flags=UPDATE_UI_NONE):
        """
        UpdateWindowUI(flags=UPDATE_UI_NONE)
        
        This function sends one or more wxUpdateUIEvent to the window.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=WINDOW_VARIANT_NORMAL) -> VisualAttributes
        
        Returns the default font and colours which are used by the control.
        """

    @staticmethod
    def FindFocus():
        """
        FindFocus() -> Window
        
        Finds the window or control which currently has the keyboard focus.
        """

    @staticmethod
    def FindWindowById(id, parent=None):
        """
        FindWindowById(id, parent=None) -> Window
        
        Find the first window with the given id.
        """

    @staticmethod
    def FindWindowByLabel(label, parent=None):
        """
        FindWindowByLabel(label, parent=None) -> Window
        
        Find a window by its label.
        """

    @staticmethod
    def FindWindowByName(name, parent=None):
        """
        FindWindowByName(name, parent=None) -> Window
        
        Find a window by its name (as given in a window constructor or
        Create() function call).
        """

    @staticmethod
    def GetCapture():
        """
        GetCapture() -> Window
        
        Returns the currently captured window.
        """

    @staticmethod
    def NewControlId(count=1):
        """
        NewControlId(count=1) -> WindowID
        
        Create a new ID or range of IDs that are not currently in use.
        """

    @staticmethod
    def UnreserveControlId(id, count=1):
        """
        UnreserveControlId(id, count=1)
        
        Unreserve an ID or range of IDs that was reserved by NewControlId().
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=PanelNameStr):
        """
        Create(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=PanelNameStr) -> bool
        """

    def SetRect(self, rect):
        """
        
        """
    Rect = property(None, None)

    def SetClientRect(self, rect):
        """
        
        """
    ClientRect = property(None, None)

    def GetGtkWidget(self):
        """
        GetGtkWidget() -> void
        """

    def AssociateHandle(self, handle):
        """
        AssociateHandle(handle)
        
        Associate the window with a new native handle
        """

    def DissociateHandle(self):
        """
        DissociateHandle()
        
        Dissociate the current native handle from the window
        """

    def GetTopLevelParent(self):
        """
        GetTopLevelParent() -> Window
        
        Returns the first ancestor of this window which is a top-level window.
        """

    def MacIsWindowScrollbar(self, sb):
        """
        MacIsWindowScrollbar(sb)
        
        Is the given widget one of this window's built-in scrollbars?  Only
        applicable on Mac.
        """

    def SetDimensions(self, x, y, width, height, sizeFlags=SIZE_AUTO):
        """
        SetDimensions(x, y, width, height, sizeFlags=SIZE_AUTO)
        """

    SetDimensions = wx.deprecated(SetDimensions, 'Use SetSize instead.')

    def __nonzero__(self):
        """
        Can be used to test if the C++ part of the window still exists, with 
        code like this::
        
            if theWindow:
                doSomething()
        """

    __bool__ = __nonzero__

    def DestroyLater(self):
        """
        Schedules the window to be destroyed in the near future.
        
        This should be used whenever Destroy could happen too soon, such
        as when there may still be events for this window or its children
        waiting in the event queue.
        """

    def DLG_UNIT(self, dlg_unit):
        """
        A convenience wrapper for :meth:`ConvertDialogToPixels`.
        """

    def PostCreate(self, pre):
        """
        
        """
    AcceleratorTable = property(None, None)
    AutoLayout = property(None, None)
    BackgroundColour = property(None, None)
    BackgroundStyle = property(None, None)
    EffectiveMinSize = property(None, None)
    BestSize = property(None, None)
    BestVirtualSize = property(None, None)
    Border = property(None, None)
    Caret = property(None, None)
    CharHeight = property(None, None)
    CharWidth = property(None, None)
    Children = property(None, None)
    ClientAreaOrigin = property(None, None)
    ClientSize = property(None, None)
    Constraints = property(None, None)
    ContainingSizer = property(None, None)
    Cursor = property(None, None)
    DefaultAttributes = property(None, None)
    DropTarget = property(None, None)
    EventHandler = property(None, None)
    ExtraStyle = property(None, None)
    Font = property(None, None)
    ForegroundColour = property(None, None)
    GrandParent = property(None, None)
    TopLevelParent = property(None, None)
    Handle = property(None, None)
    HelpText = property(None, None)
    Id = property(None, None)
    Label = property(None, None)
    LayoutDirection = property(None, None)
    MaxHeight = property(None, None)
    MaxSize = property(None, None)
    MaxWidth = property(None, None)
    MinHeight = property(None, None)
    MinSize = property(None, None)
    MinWidth = property(None, None)
    Name = property(None, None)
    Parent = property(None, None)
    Position = property(None, None)
    ScreenPosition = property(None, None)
    ScreenRect = property(None, None)
    Size = property(None, None)
    Sizer = property(None, None)
    ThemeEnabled = property(None, None)
    ToolTip = property(None, None)
    UpdateClientRect = property(None, None)
    UpdateRegion = property(None, None)
    Validator = property(None, None)
    VirtualSize = property(None, None)
    WindowStyle = property(None, None)
    WindowStyleFlag = property(None, None)
    WindowVariant = property(None, None)
    Shown = property(None, None)
    Enabled = property(None, None)
    TopLevel = property(None, None)
    MinClientSize = property(None, None)
    MaxClientSize = property(None, None)

    def GetPositionTuple(self):
        """
        
        """

    def GetSizeTuple(self):
        """
        
        """

    def MoveXY(self, x, y):
        """
        
        """

    def SetSizeWH(self, w, h):
        """
        
        """

    def SetVirtualSizeWH(self, w, h):
        """
        
        """

    def GetVirtualSizeTuple(self):
        """
        
        """

    def SetToolTipString(self, string):
        """
        
        """

    def ConvertDialogPointToPixels(self, point):
        """
        
        """

    def ConvertDialogSizeToPixels(self, size):
        """
        
        """

    def SetSizeHintsSz(self, minSize, maxSize=wx.DefaultSize, incSize=wx.DefaultSize):
        """
        
        """

    def DoGetBestSize(self):
        """
        DoGetBestSize() -> Size
        
        Implementation of GetBestSize() that can be overridden.
        """

    def DoGetBestClientSize(self):
        """
        DoGetBestClientSize() -> Size
        
        Override this method to return the best size for a custom control.
        """

    def SendDestroyEvent(self):
        """
        SendDestroyEvent()
        
        Generate wxWindowDestroyEvent for this window.
        """

    def ProcessEvent(self, event):
        """
        ProcessEvent(event) -> bool
        
        This function is public in wxEvtHandler but protected in wxWindow
        because for wxWindows you should always call ProcessEvent() on the
        pointer returned by GetEventHandler() and not on the wxWindow object
        itself.
        """
# end of class Window


def FindWindowAtPointer():
    """
    FindWindowAtPointer() -> (Window, pt)
    
    Find the deepest window at the mouse pointer position, returning the
    window and current pointer position in screen coordinates.
    """

def GetActiveWindow():
    """
    GetActiveWindow() -> Window
    
    Gets the currently active window (implemented for MSW and GTK only
    currently, always returns NULL in the other ports).
    """

def GetTopLevelParent(window):
    """
    GetTopLevelParent(window) -> Window
    
    Returns the first top level parent of the given window, or in other
    words, the frame or dialog containing it, or NULL.
    """

class FrozenWindow(object):
    """
    A context manager to be used with Python 'with' statements
    that will freeze the given window for the duration of the
    with block.
    """
    def __init__(self, window):
        self._win = window
    def __enter__(self):
        self._win.Freeze()
        return self
    def __exit__(self, exc_type, exc_val, exc_tb):
        self._win.Thaw()

def DLG_UNIT(win, dlg_unit, val2=None):
    """
    Convenience function for converting a wx.Point, wx.Size or
    (x,y) in dialog units to pixels.
    """
    if val2 is not None:
        dlg_unit = (dlg_unit, val2)
    return win.ConvertDialogToPixels(dlg_unit)

DLG_PNT = wx.deprecated(DLG_UNIT, "Use DLG_UNIT instead.")
DLG_SZE = wx.deprecated(DLG_UNIT, "Use DLG_UNIT instead.")

def GetTopLevelWindows(self):
    """
    GetTopLevelWindows() -> WindowList
    
    Returns a list-like object of the the application's top-level windows,
    (frames,dialogs, etc.)
    """

PyWindow = wx.deprecated(Window, 'Use Window instead.')

def FindWindowById(self, id, parent=None):
    """
    FindWindowById(id, parent=None) -> Window
    
    FindWindowById(id, parent=None) -> Window
    
    Find the first window in the application with the given id. If parent
    is None, the search will start from all top-level frames and dialog
    boxes; if non-None, the search will be limited to the given window
    hierarchy. The search is recursive in both cases.
    """

def FindWindowByName(self, name, parent=None):
    """
    FindWindowByName(name, parent=None) -> Window
    
    FindWindowByName(name, parent=None) -> Window
    
    Find a window by its name (as given in a window constructor or Create
    function call). If parent is None, the search will start from all
    top-level frames and dialog boxes; if non-None, the search will be
    limited to the given window hierarchy. The search is recursive in both
    cases.
    
    If no window with the name is found, wx.FindWindowByLabel is called.
    """

def FindWindowByLabel(self, label, parent=None):
    """
    FindWindowByLabel(label, parent=None) -> Window
    
    FindWindowByLabel(label, parent=None) -> Window
    
    Find a window by its label. Depending on the type of window, the label
    may be a window title or panel item label. If parent is None, the
    search will start from all top-level frames and dialog boxes; if
    non-None, the search will be limited to the given window
    hierarchy. The search is recursive in both cases.
    """
#-- end-window --#
#-- begin-validate --#

class Validator(EvtHandler):
    """
    Validator()
    
    wxValidator is the base class for a family of validator classes that
    mediate between a class of control, and application data.
    """

    def __init__(self):
        """
        Validator()
        
        wxValidator is the base class for a family of validator classes that
        mediate between a class of control, and application data.
        """

    def Clone(self):
        """
        Clone() -> Object
        
        All validator classes must implement the Clone() function, which
        returns an identical copy of itself.
        """

    def GetWindow(self):
        """
        GetWindow() -> Window
        
        Returns the window associated with the validator.
        """

    def SetWindow(self, window):
        """
        SetWindow(window)
        
        Associates a window with the validator.
        """

    def TransferFromWindow(self):
        """
        TransferFromWindow() -> bool
        
        This overridable function is called when the value in the window must
        be transferred to the validator.
        """

    def TransferToWindow(self):
        """
        TransferToWindow() -> bool
        
        This overridable function is called when the value associated with the
        validator must be transferred to the window.
        """

    def Validate(self, parent):
        """
        Validate(parent) -> bool
        
        This overridable function is called when the value in the associated
        window must be validated.
        """

    @staticmethod
    def SuppressBellOnError(suppress=True):
        """
        SuppressBellOnError(suppress=True)
        
        This functions switches on or turns off the error sound produced by
        the validators if an invalid key is pressed.
        """

    @staticmethod
    def IsSilent():
        """
        IsSilent() -> bool
        
        Returns if the error sound is currently disabled.
        """
    Window = property(None, None)
# end of class Validator

DefaultValidator = Validator()

PyValidator = wx.deprecated(Validator, 'Use Validator instead.')
#-- end-validate --#
#-- begin-panel --#

class Panel(Window):
    """
    Panel()
    Panel(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=TAB_TRAVERSAL, name=PanelNameStr)
    
    A panel is a window on which controls are placed.
    """

    def __init__(self, *args, **kw):
        """
        Panel()
        Panel(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=TAB_TRAVERSAL, name=PanelNameStr)
        
        A panel is a window on which controls are placed.
        """

    def AcceptsFocus(self):
        """
        AcceptsFocus() -> bool
        
        This method is overridden from wxWindow::AcceptsFocus() and returns
        true only if there is no child window in the panel which can accept
        the focus.
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=TAB_TRAVERSAL, name=PanelNameStr):
        """
        Create(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=TAB_TRAVERSAL, name=PanelNameStr) -> bool
        
        Used for two-step panel construction.
        """

    def InitDialog(self):
        """
        InitDialog()
        
        Sends a wxInitDialogEvent, which in turn transfers data to the dialog
        via validators.
        """

    def Layout(self):
        """
        Layout() -> bool
        
        See wxWindow::SetAutoLayout(): when auto layout is on, this function
        gets called automatically when the window is resized.
        """

    def SetFocus(self):
        """
        SetFocus()
        
        Overrides wxWindow::SetFocus().
        """

    def SetFocusIgnoringChildren(self):
        """
        SetFocusIgnoringChildren()
        
        In contrast to SetFocus() (see above) this will set the focus to the
        panel even if there are child windows in the panel.
        """
# end of class Panel


PyPanel = wx.deprecated(Panel, 'Use Panel instead.')
#-- end-panel --#
#-- begin-menuitem --#

class MenuItem(Object):
    """
    MenuItem(parentMenu=None, id=ID_SEPARATOR, text=EmptyString, helpString=EmptyString, kind=ITEM_NORMAL, subMenu=None)
    
    A menu item represents an item in a menu.
    """

    def __init__(self, parentMenu=None, id=ID_SEPARATOR, text=EmptyString, helpString=EmptyString, kind=ITEM_NORMAL, subMenu=None):
        """
        MenuItem(parentMenu=None, id=ID_SEPARATOR, text=EmptyString, helpString=EmptyString, kind=ITEM_NORMAL, subMenu=None)
        
        A menu item represents an item in a menu.
        """

    def GetBackgroundColour(self):
        """
        GetBackgroundColour() -> Colour
        
        Returns the background colour associated with the menu item.
        """

    def GetBitmap(self, checked=True):
        """
        GetBitmap(checked=True) -> Bitmap
        
        Returns the checked or unchecked bitmap.
        """

    def GetDisabledBitmap(self):
        """
        GetDisabledBitmap() -> Bitmap
        
        Returns the bitmap to be used for disabled items.
        """

    def GetFont(self):
        """
        GetFont() -> Font
        
        Returns the font associated with the menu item.
        """

    def GetHelp(self):
        """
        GetHelp() -> String
        
        Returns the help string associated with the menu item.
        """

    def GetId(self):
        """
        GetId() -> int
        
        Returns the menu item identifier.
        """

    def GetItemLabel(self):
        """
        GetItemLabel() -> String
        
        Returns the text associated with the menu item including any
        accelerator characters that were passed to the constructor or
        SetItemLabel().
        """

    def GetItemLabelText(self):
        """
        GetItemLabelText() -> String
        
        Returns the text associated with the menu item, without any
        accelerator characters.
        """

    def GetKind(self):
        """
        GetKind() -> ItemKind
        
        Returns the item kind, one of wxITEM_SEPARATOR, wxITEM_NORMAL,
        wxITEM_CHECK or wxITEM_RADIO.
        """

    def GetLabel(self):
        """
        GetLabel() -> String
        
        Returns the text associated with the menu item without any accelerator
        characters it might contain.
        """

    def GetMarginWidth(self):
        """
        GetMarginWidth() -> int
        
        Gets the width of the menu item checkmark bitmap.
        """

    def GetMenu(self):
        """
        GetMenu() -> Menu
        
        Returns the menu this menu item is in, or NULL if this menu item is
        not attached.
        """

    def GetName(self):
        """
        GetName() -> String
        
        Returns the text associated with the menu item.
        """

    def GetSubMenu(self):
        """
        GetSubMenu() -> Menu
        
        Returns the submenu associated with the menu item, or NULL if there
        isn't one.
        """

    def GetText(self):
        """
        GetText() -> String
        
        Returns the text associated with the menu item, such as it was passed
        to the wxMenuItem constructor, i.e.
        """

    def GetTextColour(self):
        """
        GetTextColour() -> Colour
        
        Returns the text colour associated with the menu item.
        """

    def GetAccel(self):
        """
        GetAccel() -> AcceleratorEntry
        
        Get our accelerator or NULL (caller must delete the pointer)
        """

    def IsCheck(self):
        """
        IsCheck() -> bool
        
        Returns true if the item is a check item.
        """

    def IsCheckable(self):
        """
        IsCheckable() -> bool
        
        Returns true if the item is checkable.
        """

    def IsChecked(self):
        """
        IsChecked() -> bool
        
        Returns true if the item is checked.
        """

    def IsEnabled(self):
        """
        IsEnabled() -> bool
        
        Returns true if the item is enabled.
        """

    def IsRadio(self):
        """
        IsRadio() -> bool
        
        Returns true if the item is a radio button.
        """

    def IsSeparator(self):
        """
        IsSeparator() -> bool
        
        Returns true if the item is a separator.
        """

    def IsSubMenu(self):
        """
        IsSubMenu() -> bool
        
        Returns true if the item is a submenu.
        """

    def SetBackgroundColour(self, colour):
        """
        SetBackgroundColour(colour)
        
        Sets the background colour associated with the menu item.
        """

    def SetBitmap(self, bmp, checked=True):
        """
        SetBitmap(bmp, checked=True)
        
        Sets the bitmap for the menu item.
        """

    def SetBitmaps(self, checked, unchecked=NullBitmap):
        """
        SetBitmaps(checked, unchecked=NullBitmap)
        
        Sets the checked/unchecked bitmaps for the menu item.
        """

    def SetDisabledBitmap(self, disabled):
        """
        SetDisabledBitmap(disabled)
        
        Sets the to be used for disabled menu items.
        """

    def SetFont(self, font):
        """
        SetFont(font)
        
        Sets the font associated with the menu item.
        """

    def SetHelp(self, helpString):
        """
        SetHelp(helpString)
        
        Sets the help string.
        """

    def SetItemLabel(self, label):
        """
        SetItemLabel(label)
        
        Sets the label associated with the menu item.
        """

    def SetMarginWidth(self, width):
        """
        SetMarginWidth(width)
        
        Sets the width of the menu item checkmark bitmap.
        """

    def SetMenu(self, menu):
        """
        SetMenu(menu)
        
        Sets the parent menu which will contain this menu item.
        """

    def SetSubMenu(self, menu):
        """
        SetSubMenu(menu)
        
        Sets the submenu of this menu item.
        """

    def SetText(self, text):
        """
        SetText(text)
        
        Sets the text associated with the menu item.
        """

    def SetTextColour(self, colour):
        """
        SetTextColour(colour)
        
        Sets the text colour associated with the menu item.
        """

    def SetAccel(self, accel):
        """
        SetAccel(accel)
        
        Set the accel for this item - this may also be done indirectly with
        SetText()
        """

    def Check(self, check=True):
        """
        Check(check=True)
        
        Checks or unchecks the menu item.
        """

    def Enable(self, enable=True):
        """
        Enable(enable=True)
        
        Enables or disables the menu item.
        """

    @staticmethod
    def GetLabelFromText(text):
        """
        GetLabelFromText(text) -> String
        """

    @staticmethod
    def GetLabelText(text):
        """
        GetLabelText(text) -> String
        
        Strips all accelerator characters and mnemonics from the given text.
        """
    Accel = property(None, None)
    BackgroundColour = property(None, None)
    Bitmap = property(None, None)
    DisabledBitmap = property(None, None)
    Font = property(None, None)
    Help = property(None, None)
    Id = property(None, None)
    ItemLabel = property(None, None)
    ItemLabelText = property(None, None)
    Kind = property(None, None)
    Label = property(None, None)
    MarginWidth = property(None, None)
    Menu = property(None, None)
    Name = property(None, None)
    SubMenu = property(None, None)
    Text = property(None, None)
    TextColour = property(None, None)
# end of class MenuItem

#-- end-menuitem --#
#-- begin-menu --#

class Menu(EvtHandler):
    """
    Menu()
    Menu(style)
    Menu(title, style=0)
    
    A menu is a popup (or pull down) list of items, one of which may be
    selected before the menu goes away (clicking elsewhere dismisses the
    menu).
    """

    def __init__(self, *args, **kw):
        """
        Menu()
        Menu(style)
        Menu(title, style=0)
        
        A menu is a popup (or pull down) list of items, one of which may be
        selected before the menu goes away (clicking elsewhere dismisses the
        menu).
        """

    def GetMenuItems(self):
        """
        GetMenuItems() -> MenuItemList
        
        Returns the list of items in the menu.
        """

    def Append(self, *args, **kw):
        """
        Append(id, item=EmptyString, helpString=EmptyString, kind=ITEM_NORMAL) -> MenuItem
        Append(id, item, subMenu, helpString=EmptyString) -> MenuItem
        Append(menuItem) -> MenuItem
        
        Adds a menu item.
        """

    def AppendCheckItem(self, id, item, help=EmptyString):
        """
        AppendCheckItem(id, item, help=EmptyString) -> MenuItem
        
        Adds a checkable item to the end of the menu.
        """

    def AppendRadioItem(self, id, item, help=EmptyString):
        """
        AppendRadioItem(id, item, help=EmptyString) -> MenuItem
        
        Adds a radio item to the end of the menu.
        """

    def AppendSeparator(self):
        """
        AppendSeparator() -> MenuItem
        
        Adds a separator to the end of the menu.
        """

    def AppendSubMenu(self, submenu, text, help=EmptyString):
        """
        AppendSubMenu(submenu, text, help=EmptyString) -> MenuItem
        
        Adds the given submenu to this menu.
        """

    def Break(self):
        """
        Break()
        
        Inserts a break in a menu, causing the next appended item to appear in
        a new column.
        """

    def Check(self, id, check):
        """
        Check(id, check)
        
        Checks or unchecks the menu item.
        """

    def Delete(self, *args, **kw):
        """
        Delete(id) -> bool
        Delete(item) -> bool
        
        Deletes the menu item from the menu.
        """

    def DestroyItem(self, *args, **kw):
        """
        DestroyItem(id) -> bool
        DestroyItem(item) -> bool
        
        Deletes the menu item from the menu.
        """

    def Enable(self, id, enable):
        """
        Enable(id, enable)
        
        Enables or disables (greys out) a menu item.
        """

    def FindChildItem(self, id):
        """
        FindChildItem(id) -> (MenuItem, pos)
        
        Finds the menu item object associated with the given menu item
        identifier and, optionally, the position of the item in the menu.
        """

    def FindItem(self, *args, **kw):
        """
        FindItem(itemString) -> int
        FindItem(id) -> (MenuItem, menu)
        
        Finds the menu id for a menu item string.
        """

    def FindItemByPosition(self, position):
        """
        FindItemByPosition(position) -> MenuItem
        
        Returns the wxMenuItem given a position in the menu.
        """

    def GetHelpString(self, id):
        """
        GetHelpString(id) -> String
        
        Returns the help string associated with a menu item.
        """

    def GetLabel(self, id):
        """
        GetLabel(id) -> String
        
        Returns a menu item label.
        """

    def GetLabelText(self, id):
        """
        GetLabelText(id) -> String
        
        Returns a menu item label, without any of the original mnemonics and
        accelerators.
        """

    def GetMenuItemCount(self):
        """
        GetMenuItemCount() -> size_t
        
        Returns the number of items in the menu.
        """

    def GetTitle(self):
        """
        GetTitle() -> String
        
        Returns the title of the menu.
        """

    def Insert(self, *args, **kw):
        """
        Insert(pos, menuItem) -> MenuItem
        Insert(pos, id, item=EmptyString, helpString=EmptyString, kind=ITEM_NORMAL) -> MenuItem
        Insert(pos, id, text, submenu, help=EmptyString) -> MenuItem
        
        Inserts the given item before the position pos.
        """

    def InsertCheckItem(self, pos, id, item, helpString=EmptyString):
        """
        InsertCheckItem(pos, id, item, helpString=EmptyString) -> MenuItem
        
        Inserts a checkable item at the given position.
        """

    def InsertRadioItem(self, pos, id, item, helpString=EmptyString):
        """
        InsertRadioItem(pos, id, item, helpString=EmptyString) -> MenuItem
        
        Inserts a radio item at the given position.
        """

    def InsertSeparator(self, pos):
        """
        InsertSeparator(pos) -> MenuItem
        
        Inserts a separator at the given position.
        """

    def IsChecked(self, id):
        """
        IsChecked(id) -> bool
        
        Determines whether a menu item is checked.
        """

    def IsEnabled(self, id):
        """
        IsEnabled(id) -> bool
        
        Determines whether a menu item is enabled.
        """

    def Prepend(self, *args, **kw):
        """
        Prepend(menuItem) -> MenuItem
        Prepend(id, item=EmptyString, helpString=EmptyString, kind=ITEM_NORMAL) -> MenuItem
        Prepend(id, text, subMenu, help=EmptyString) -> MenuItem
        
        Inserts the given item at position 0, i.e. before all the other
        existing items.
        """

    def PrependCheckItem(self, id, item, helpString=EmptyString):
        """
        PrependCheckItem(id, item, helpString=EmptyString) -> MenuItem
        
        Inserts a checkable item at position 0.
        """

    def PrependRadioItem(self, id, item, helpString=EmptyString):
        """
        PrependRadioItem(id, item, helpString=EmptyString) -> MenuItem
        
        Inserts a radio item at position 0.
        """

    def PrependSeparator(self):
        """
        PrependSeparator() -> MenuItem
        
        Inserts a separator at position 0.
        """

    def Remove(self, *args, **kw):
        """
        Remove(id) -> MenuItem
        Remove(item) -> MenuItem
        
        Removes the menu item from the menu but doesn't delete the associated
        C++ object.
        """

    def SetHelpString(self, id, helpString):
        """
        SetHelpString(id, helpString)
        
        Sets an item's help string.
        """

    def SetLabel(self, id, label):
        """
        SetLabel(id, label)
        
        Sets the label of a menu item.
        """

    def SetTitle(self, title):
        """
        SetTitle(title)
        
        Sets the title of the menu.
        """

    def UpdateUI(self, source=None):
        """
        UpdateUI(source=None)
        
        Sends events to source (or owning window if NULL) to update the menu
        UI.
        """

    def SetInvokingWindow(self, win):
        """
        SetInvokingWindow(win)
        """

    def GetInvokingWindow(self):
        """
        GetInvokingWindow() -> Window
        """

    def GetWindow(self):
        """
        GetWindow() -> Window
        """

    def GetStyle(self):
        """
        GetStyle() -> long
        """

    def SetParent(self, parent):
        """
        SetParent(parent)
        """

    def GetParent(self):
        """
        GetParent() -> Menu
        """

    def Attach(self, menubar):
        """
        Attach(menubar)
        """

    def Detach(self):
        """
        Detach()
        """

    def IsAttached(self):
        """
        IsAttached() -> bool
        """

    def AppendMenu(self, id, item, subMenu, help=""):
        """
        
        """

    def AppendItem(self, menuItem):
        """
        
        """

    def InsertMenu(self, pos, id, item, subMenu, help=""):
        """
        
        """

    def InsertItem(self, pos, menuItem):
        """
        
        """

    def PrependMenu(self, id, item, subMenu, help=""):
        """
        
        """

    def PrependItem(self, menuItem):
        """
        
        """

    def RemoveMenu(self, id, item, subMenu, help=""):
        """
        
        """

    def RemoveItem(self, menuItem):
        """
        
        """

    def FindItemById(self, id):
        """
        FindItemById(id) -> MenuItem
        
        FindItemById(id) -> MenuItem
        
        Finds the menu item object associated with the given menu item
        identifier.
        """
    InvokingWindow = property(None, None)
    MenuItemCount = property(None, None)
    MenuItems = property(None, None)
    Parent = property(None, None)
    Style = property(None, None)
    Title = property(None, None)
    Window = property(None, None)
# end of class Menu


class MenuBar(Window):
    """
    MenuBar(style=0)
    
    A menu bar is a series of menus accessible from the top of a frame.
    """

    def __init__(self, style=0):
        """
        MenuBar(style=0)
        
        A menu bar is a series of menus accessible from the top of a frame.
        """

    def Append(self, menu, title):
        """
        Append(menu, title) -> bool
        
        Adds the item to the end of the menu bar.
        """

    def Check(self, id, check):
        """
        Check(id, check)
        
        Checks or unchecks a menu item.
        """

    def Enable(self, id, enable):
        """
        Enable(id, enable)
        
        Enables or disables (greys out) a menu item.
        """

    def IsEnabledTop(self, pos):
        """
        IsEnabledTop(pos) -> bool
        
        Returns true if the menu with the given index is enabled.
        """

    def EnableTop(self, pos, enable):
        """
        EnableTop(pos, enable)
        
        Enables or disables a whole menu.
        """

    def FindItem(self, id):
        """
        FindItem(id) -> (MenuItem, menu)
        
        Finds the menu item object associated with the given menu item
        identifier.
        """

    def FindMenu(self, title):
        """
        FindMenu(title) -> int
        
        Returns the index of the menu with the given title or wxNOT_FOUND if
        no such menu exists in this menubar.
        """

    def FindMenuItem(self, menuString, itemString):
        """
        FindMenuItem(menuString, itemString) -> int
        
        Finds the menu item id for a menu name/menu item string pair.
        """

    def GetHelpString(self, id):
        """
        GetHelpString(id) -> String
        
        Gets the help string associated with the menu item identifier.
        """

    def GetLabel(self, id):
        """
        GetLabel(id) -> String
        
        Gets the label associated with a menu item.
        """

    def GetLabelTop(self, pos):
        """
        GetLabelTop(pos) -> String
        
        Returns the label of a top-level menu.
        """

    def GetMenu(self, menuIndex):
        """
        GetMenu(menuIndex) -> Menu
        
        Returns the menu at menuIndex (zero-based).
        """

    def GetMenuCount(self):
        """
        GetMenuCount() -> size_t
        
        Returns the number of menus in this menubar.
        """

    def GetMenuLabel(self, pos):
        """
        GetMenuLabel(pos) -> String
        
        Returns the label of a top-level menu.
        """

    def GetMenuLabelText(self, pos):
        """
        GetMenuLabelText(pos) -> String
        
        Returns the label of a top-level menu.
        """

    def Insert(self, pos, menu, title):
        """
        Insert(pos, menu, title) -> bool
        
        Inserts the menu at the given position into the menu bar.
        """

    def IsChecked(self, id):
        """
        IsChecked(id) -> bool
        
        Determines whether an item is checked.
        """

    def IsEnabled(self, id):
        """
        IsEnabled(id) -> bool
        
        Determines whether an item is enabled.
        """

    def Refresh(self, eraseBackground=True, rect=None):
        """
        Refresh(eraseBackground=True, rect=None)
        
        Redraw the menu bar.
        """

    def Remove(self, pos):
        """
        Remove(pos) -> Menu
        
        Removes the menu from the menu bar and returns the menu object - the
        caller is responsible for deleting it.
        """

    def Replace(self, pos, menu, title):
        """
        Replace(pos, menu, title) -> Menu
        
        Replaces the menu at the given position with another one.
        """

    def SetHelpString(self, id, helpString):
        """
        SetHelpString(id, helpString)
        
        Sets the help string associated with a menu item.
        """

    def SetLabel(self, id, label):
        """
        SetLabel(id, label)
        
        Sets the label of a menu item.
        """

    def SetLabelTop(self, pos, label):
        """
        SetLabelTop(pos, label)
        
        Sets the label of a top-level menu.
        """

    def SetMenuLabel(self, pos, label):
        """
        SetMenuLabel(pos, label)
        
        Sets the label of a top-level menu.
        """

    def OSXGetAppleMenu(self):
        """
        OSXGetAppleMenu() -> Menu
        
        Returns the Apple menu.
        """

    def GetFrame(self):
        """
        GetFrame() -> Frame
        """

    def IsAttached(self):
        """
        IsAttached() -> bool
        """

    def Attach(self, frame):
        """
        Attach(frame)
        """

    def Detach(self):
        """
        Detach()
        """

    @staticmethod
    def MacSetCommonMenuBar(menubar):
        """
        MacSetCommonMenuBar(menubar)
        
        Enables you to set the global menubar on Mac, that is, the menubar
        displayed when the app is running without any frames open.
        """

    @staticmethod
    def MacGetCommonMenuBar():
        """
        MacGetCommonMenuBar() -> MenuBar
        
        Enables you to get the global menubar on Mac, that is, the menubar
        displayed when the app is running without any frames open.
        """

    def FindItemById(self, id):
        """
        FindItemById(id) -> MenuItem
        
        FindItemById(id) -> MenuItem
        
        Finds the menu item object associated with the given menu item
        identifier.
        """

    def GetMenus(self):
        """
        GetMenus() -> (menu, label)
        
        Return a list of (menu, label) items for the menus in the :class:`MenuBar`.
        """

    def SetMenus(self, items):
        """
        SetMenus()
        
        Clear and add new menus to the :class:`MenuBar` from a list of (menu, label) items.
        """
    Menus = property(None, None)
# end of class MenuBar

#-- end-menu --#
#-- begin-scrolwin --#
SHOW_SB_NEVER = 0
SHOW_SB_DEFAULT = 0
SHOW_SB_ALWAYS = 0

class Scrolled(object):
    """
    Scrolled()
    Scrolled(parent, id=-1, pos=DefaultPosition, size=DefaultSize, style=HSCROLL|VSCROLL, name="scrolledWindow")
    
    The wxScrolled class manages scrolling for its client area,
    transforming the coordinates according to the scrollbar positions, and
    setting the scroll positions, thumb sizes and ranges according to the
    area in view.
    """

    def __init__(self, *args, **kw):
        """
        Scrolled()
        Scrolled(parent, id=-1, pos=DefaultPosition, size=DefaultSize, style=HSCROLL|VSCROLL, name="scrolledWindow")
        
        The wxScrolled class manages scrolling for its client area,
        transforming the coordinates according to the scrollbar positions, and
        setting the scroll positions, thumb sizes and ranges according to the
        area in view.
        """

    def CalcScrolledPosition(self, *args, **kw):
        """
        CalcScrolledPosition(x, y) -> (xx, yy)
        CalcScrolledPosition(pt) -> Point
        
        Translates the logical coordinates to the device ones.
        """

    def CalcUnscrolledPosition(self, *args, **kw):
        """
        CalcUnscrolledPosition(x, y) -> (xx, yy)
        CalcUnscrolledPosition(pt) -> Point
        
        Translates the device coordinates to the logical ones.
        """

    def Create(self, parent, id=-1, pos=DefaultPosition, size=DefaultSize, style=HSCROLL|VSCROLL, name="scrolledWindow"):
        """
        Create(parent, id=-1, pos=DefaultPosition, size=DefaultSize, style=HSCROLL|VSCROLL, name="scrolledWindow") -> bool
        
        Creates the window for two-step construction.
        """

    def DisableKeyboardScrolling(self):
        """
        DisableKeyboardScrolling()
        
        Disable use of keyboard keys for scrolling.
        """

    def DoPrepareDC(self, dc):
        """
        DoPrepareDC(dc)
        
        Call this function to prepare the device context for drawing a
        scrolled image.
        """

    def EnableScrolling(self, xScrolling, yScrolling):
        """
        EnableScrolling(xScrolling, yScrolling)
        
        Enable or disable use of wxWindow::ScrollWindow() for scrolling.
        """

    def ShowScrollbars(self, horz, vert):
        """
        ShowScrollbars(horz, vert)
        
        Set the scrollbar visibility.
        """

    def GetScrollPixelsPerUnit(self):
        """
        GetScrollPixelsPerUnit() -> (xUnit, yUnit)
        
        Get the number of pixels per scroll unit (line), in each direction, as
        set by SetScrollbars().
        """

    def GetViewStart(self):
        """
        GetViewStart() -> (x, y)
        
        Get the position at which the visible portion of the window starts.
        """

    def GetVirtualSize(self):
        """
        GetVirtualSize() -> (x, y)
        
        Gets the size in device units of the scrollable window area (as
        opposed to the client size, which is the area of the window currently
        visible).
        """

    def IsRetained(self):
        """
        IsRetained() -> bool
        
        Motif only: true if the window has a backing bitmap.
        """

    def OnDraw(self, dc):
        """
        OnDraw(dc)
        
        Called by the default paint event handler to allow the application to
        define painting behaviour without having to worry about calling
        DoPrepareDC().
        """

    def PrepareDC(self, dc):
        """
        PrepareDC(dc)
        
        This function is for backwards compatibility only and simply calls
        DoPrepareDC() now.
        """

    def Scroll(self, *args, **kw):
        """
        Scroll(x, y)
        Scroll(pt)
        
        Scrolls a window so the view start is at the given point.
        """

    def SetScrollRate(self, xstep, ystep):
        """
        SetScrollRate(xstep, ystep)
        
        Set the horizontal and vertical scrolling increment only.
        """

    def SetScrollbars(self, pixelsPerUnitX, pixelsPerUnitY, noUnitsX, noUnitsY, xPos=0, yPos=0, noRefresh=False):
        """
        SetScrollbars(pixelsPerUnitX, pixelsPerUnitY, noUnitsX, noUnitsY, xPos=0, yPos=0, noRefresh=False)
        
        Sets up vertical and/or horizontal scrollbars.
        """

    def SetTargetWindow(self, window):
        """
        SetTargetWindow(window)
        
        Call this function to tell wxScrolled to perform the actual scrolling
        on a different window (and not on itself).
        """

    def GetTargetWindow(self):
        """
        GetTargetWindow() -> Window
        """

    def SetTargetRect(self, rect):
        """
        SetTargetRect(rect)
        """

    def GetTargetRect(self):
        """
        GetTargetRect() -> Rect
        """

    def GetScrollPageSize(self, orient):
        """
        GetScrollPageSize(orient) -> int
        """

    def SetScrollPageSize(self, orient, pageSize):
        """
        SetScrollPageSize(orient, pageSize)
        """

    def GetScrollLines(self, orient):
        """
        GetScrollLines(orient) -> int
        """

    def SetScale(self, xs, ys):
        """
        SetScale(xs, ys)
        """

    def GetScaleX(self):
        """
        GetScaleX() -> double
        """

    def GetScaleY(self):
        """
        GetScaleY() -> double
        """

    def AdjustScrollbars(self):
        """
        AdjustScrollbars()
        """

    def IsAutoScrolling(self):
        """
        IsAutoScrolling() -> bool
        
        Are we generating the autoscroll events?
        """

    def StopAutoScrolling(self):
        """
        StopAutoScrolling()
        
        Stop generating the scroll events when mouse is held outside the
        window.
        """

    def SendAutoScrollEvents(self, event):
        """
        SendAutoScrollEvents(event) -> bool
        
        This method can be overridden in a derived class to forbid sending the
        auto scroll events - note that unlike StopAutoScrolling() it doesn't
        stop the timer, so it will be called repeatedly and will typically
        return different values depending on the current mouse position.
        """
    ScaleX = property(None, None)
    ScaleY = property(None, None)
    TargetRect = property(None, None)
    TargetWindow = property(None, None)

    def GetSizeAvailableForScrollTarget(self, size):
        """
        GetSizeAvailableForScrollTarget(size) -> Size
        
        Function which must be overridden to implement the size available for
        the scroll target for the given size of the main window.
        """
# end of class Scrolled

class ScrolledCanvas(Window, Scrolled):
    """
    The :ref:`ScrolledCanvas` class is a combination of the :ref:`Window` and
    :ref:`Scrolled` classes, and manages scrolling for its client area,
    transforming the coordinates according to the scrollbar positions,
    and setting the scroll positions, thumb sizes and ranges according to
    the area in view.
    """

class ScrolledWindow(Window, Scrolled):
    """
    ScrolledWindow()
    ScrolledWindow(parent, winid=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=ScrolledWindowStyle, name=PanelNameStr)
    
    Scrolled window derived from wxPanel.
    """

    def __init__(self, *args, **kw):
        """
        ScrolledWindow()
        ScrolledWindow(parent, winid=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=ScrolledWindowStyle, name=PanelNameStr)
        
        Scrolled window derived from wxPanel.
        """

    def SetFocusIgnoringChildren(self):
        """
        SetFocusIgnoringChildren()
        
        In contrast to SetFocus() this will set the focus to the panel even if
        there are child windows in the panel. This is only rarely needed.
        """
# end of class ScrolledWindow


PyScrolledWindow = wx.deprecated(ScrolledWindow, 'Use ScrolledWindow instead.')
#-- end-scrolwin --#
#-- begin-vscroll --#

class VarScrollHelperBase(object):
    """
    VarScrollHelperBase(winToScroll)
    
    This class provides all common base functionality for scroll
    calculations shared among all variable scrolled window implementations
    as well as automatic scrollbar functionality, saved scroll positions,
    controlling target windows to be scrolled, as well as defining all
    required virtual functions that need to be implemented for any
    orientation specific work.
    """

    def __init__(self, winToScroll):
        """
        VarScrollHelperBase(winToScroll)
        
        This class provides all common base functionality for scroll
        calculations shared among all variable scrolled window implementations
        as well as automatic scrollbar functionality, saved scroll positions,
        controlling target windows to be scrolled, as well as defining all
        required virtual functions that need to be implemented for any
        orientation specific work.
        """

    def CalcScrolledPosition(self, coord):
        """
        CalcScrolledPosition(coord) -> int
        
        Translates the logical coordinate given to the current device
        coordinate.
        """

    def CalcUnscrolledPosition(self, coord):
        """
        CalcUnscrolledPosition(coord) -> int
        
        Translates the device coordinate given to the corresponding logical
        coordinate.
        """

    def EnablePhysicalScrolling(self, scrolling=True):
        """
        EnablePhysicalScrolling(scrolling=True)
        
        With physical scrolling on (when this is true), the device origin is
        changed properly when a wxPaintDC is prepared, children are actually
        moved and laid out properly, and the contents of the window (pixels)
        are actually moved.
        """

    def GetNonOrientationTargetSize(self):
        """
        GetNonOrientationTargetSize() -> int
        
        This function needs to be overridden in the in the derived class to
        return the window size with respect to the opposing orientation.
        """

    def GetOrientation(self):
        """
        GetOrientation() -> Orientation
        
        This function need to be overridden to return the orientation that
        this helper is working with, either wxHORIZONTAL or wxVERTICAL.
        """

    def GetOrientationTargetSize(self):
        """
        GetOrientationTargetSize() -> int
        
        This function needs to be overridden in the in the derived class to
        return the window size with respect to the orientation this helper is
        working with.
        """

    def GetTargetWindow(self):
        """
        GetTargetWindow() -> Window
        
        This function will return the target window this helper class is
        currently scrolling.
        """

    def GetVisibleBegin(self):
        """
        GetVisibleBegin() -> size_t
        
        Returns the index of the first visible unit based on the scroll
        position.
        """

    def GetVisibleEnd(self):
        """
        GetVisibleEnd() -> size_t
        
        Returns the index of the last visible unit based on the scroll
        position.
        """

    def IsVisible(self, unit):
        """
        IsVisible(unit) -> bool
        
        Returns true if the given scroll unit is currently visible (even if
        only partially visible) or false otherwise.
        """

    def RefreshAll(self):
        """
        RefreshAll()
        
        Recalculate all parameters and repaint all units.
        """

    def SetTargetWindow(self, target):
        """
        SetTargetWindow(target)
        
        Normally the window will scroll itself, but in some rare occasions you
        might want it to scroll (part of) another window (e.g.
        """

    def UpdateScrollbar(self):
        """
        UpdateScrollbar()
        
        Update the thumb size shown by the scrollbar.
        """

    def VirtualHitTest(self, coord):
        """
        VirtualHitTest(coord) -> int
        
        Returns the virtual scroll unit under the device unit given accounting
        for scroll position or wxNOT_FOUND if none (i.e.
        """
    NonOrientationTargetSize = property(None, None)
    Orientation = property(None, None)
    OrientationTargetSize = property(None, None)
    TargetWindow = property(None, None)
    VisibleBegin = property(None, None)
    VisibleEnd = property(None, None)

    def OnGetUnitsSizeHint(self, unitMin, unitMax):
        """
        OnGetUnitsSizeHint(unitMin, unitMax)
        
        This function doesn't have to be overridden but it may be useful to do
        so if calculating the units' sizes is a relatively expensive operation
        as it gives your code a chance to calculate several of them at once
        and cache the result if necessary.
        """

    def EstimateTotalSize(self):
        """
        EstimateTotalSize() -> Coord
        
        When the number of scroll units change, we try to estimate the total
        size of all units when the full window size is needed (i.e.
        """

    def OnGetUnitSize(self, unit):
        """
        OnGetUnitSize(unit) -> Coord
        
        This function must be overridden in the derived class, and should
        return the size of the given unit in pixels.
        """
# end of class VarScrollHelperBase


class VarVScrollHelper(VarScrollHelperBase):
    """
    VarVScrollHelper(winToScroll)
    
    This class provides functions wrapping the wxVarScrollHelperBase
    class, targeted for vertical-specific scrolling.
    """

    def __init__(self, winToScroll):
        """
        VarVScrollHelper(winToScroll)
        
        This class provides functions wrapping the wxVarScrollHelperBase
        class, targeted for vertical-specific scrolling.
        """

    def GetRowCount(self):
        """
        GetRowCount() -> size_t
        
        Returns the number of rows the target window contains.
        """

    def GetVisibleRowsBegin(self):
        """
        GetVisibleRowsBegin() -> size_t
        
        Returns the index of the first visible row based on the scroll
        position.
        """

    def GetVisibleRowsEnd(self):
        """
        GetVisibleRowsEnd() -> size_t
        
        Returns the index of the last visible row based on the scroll
        position.
        """

    def IsRowVisible(self, row):
        """
        IsRowVisible(row) -> bool
        
        Returns true if the given row is currently visible (even if only
        partially visible) or false otherwise.
        """

    def RefreshRow(self, row):
        """
        RefreshRow(row)
        
        Triggers a refresh for just the given row's area of the window if it's
        visible.
        """

    def RefreshRows(self, from_, to_):
        """
        RefreshRows(from_, to_)
        
        Triggers a refresh for the area between the specified range of rows
        given (inclusively).
        """

    def ScrollRowPages(self, pages):
        """
        ScrollRowPages(pages) -> bool
        
        Scroll by the specified number of pages which may be positive (to
        scroll down) or negative (to scroll up).
        """

    def ScrollRows(self, rows):
        """
        ScrollRows(rows) -> bool
        
        Scroll by the specified number of rows which may be positive (to
        scroll down) or negative (to scroll up).
        """

    def ScrollToRow(self, row):
        """
        ScrollToRow(row) -> bool
        
        Scroll to the specified row.
        """

    def SetRowCount(self, rowCount):
        """
        SetRowCount(rowCount)
        
        Set the number of rows the window contains.
        """
    RowCount = property(None, None)
    VisibleRowsBegin = property(None, None)
    VisibleRowsEnd = property(None, None)

    def OnGetRowsHeightHint(self, rowMin, rowMax):
        """
        OnGetRowsHeightHint(rowMin, rowMax)
        
        This function doesn't have to be overridden but it may be useful to do
        so if calculating the rows' sizes is a relatively expensive operation
        as it gives your code a chance to calculate several of them at once
        and cache the result if necessary.
        """

    def EstimateTotalHeight(self):
        """
        EstimateTotalHeight() -> Coord
        
        This class forwards calls from EstimateTotalSize() to this function so
        derived classes can override either just the height or the width
        estimation, or just estimate both differently if desired in any
        wxHVScrolledWindow derived class.
        """

    def OnGetRowHeight(self, row):
        """
        OnGetRowHeight(row) -> Coord
        
        This function must be overridden in the derived class, and should
        return the height of the given row in pixels.
        """
# end of class VarVScrollHelper


class VarHScrollHelper(VarScrollHelperBase):
    """
    VarHScrollHelper(winToScroll)
    
    This class provides functions wrapping the wxVarScrollHelperBase
    class, targeted for horizontal-specific scrolling.
    """

    def __init__(self, winToScroll):
        """
        VarHScrollHelper(winToScroll)
        
        This class provides functions wrapping the wxVarScrollHelperBase
        class, targeted for horizontal-specific scrolling.
        """

    def GetColumnCount(self):
        """
        GetColumnCount() -> size_t
        
        Returns the number of columns the target window contains.
        """

    def GetVisibleColumnsBegin(self):
        """
        GetVisibleColumnsBegin() -> size_t
        
        Returns the index of the first visible column based on the scroll
        position.
        """

    def GetVisibleColumnsEnd(self):
        """
        GetVisibleColumnsEnd() -> size_t
        
        Returns the index of the last visible column based on the scroll
        position.
        """

    def IsColumnVisible(self, column):
        """
        IsColumnVisible(column) -> bool
        
        Returns true if the given column is currently visible (even if only
        partially visible) or false otherwise.
        """

    def RefreshColumn(self, column):
        """
        RefreshColumn(column)
        
        Triggers a refresh for just the given column's area of the window if
        it's visible.
        """

    def RefreshColumns(self, from_, to_):
        """
        RefreshColumns(from_, to_)
        
        Triggers a refresh for the area between the specified range of columns
        given (inclusively).
        """

    def ScrollColumnPages(self, pages):
        """
        ScrollColumnPages(pages) -> bool
        
        Scroll by the specified number of pages which may be positive (to
        scroll right) or negative (to scroll left).
        """

    def ScrollColumns(self, columns):
        """
        ScrollColumns(columns) -> bool
        
        Scroll by the specified number of columns which may be positive (to
        scroll right) or negative (to scroll left).
        """

    def ScrollToColumn(self, column):
        """
        ScrollToColumn(column) -> bool
        
        Scroll to the specified column.
        """

    def SetColumnCount(self, columnCount):
        """
        SetColumnCount(columnCount)
        
        Set the number of columns the window contains.
        """
    ColumnCount = property(None, None)
    VisibleColumnsBegin = property(None, None)
    VisibleColumnsEnd = property(None, None)

    def EstimateTotalWidth(self):
        """
        EstimateTotalWidth() -> Coord
        
        This class forwards calls from EstimateTotalSize() to this function so
        derived classes can override either just the height or the width
        estimation, or just estimate both differently if desired in any
        wxHVScrolledWindow derived class.
        """

    def OnGetColumnsWidthHint(self, columnMin, columnMax):
        """
        OnGetColumnsWidthHint(columnMin, columnMax)
        
        This function doesn't have to be overridden but it may be useful to do
        so if calculating the columns' sizes is a relatively expensive
        operation as it gives your code a chance to calculate several of them
        at once and cache the result if necessary.
        """

    def OnGetColumnWidth(self, column):
        """
        OnGetColumnWidth(column) -> Coord
        
        This function must be overridden in the derived class, and should
        return the width of the given column in pixels.
        """
# end of class VarHScrollHelper


class VarHVScrollHelper(VarVScrollHelper, VarHScrollHelper):
    """
    VarHVScrollHelper(winToScroll)
    
    This class provides functions wrapping the wxVarHScrollHelper and
    wxVarVScrollHelper classes, targeted for scrolling a window in both
    axis.
    """

    def __init__(self, winToScroll):
        """
        VarHVScrollHelper(winToScroll)
        
        This class provides functions wrapping the wxVarHScrollHelper and
        wxVarVScrollHelper classes, targeted for scrolling a window in both
        axis.
        """

    def IsVisible(self, *args, **kw):
        """
        IsVisible(row, column) -> bool
        IsVisible(pos) -> bool
        
        Returns true if both the given row and column are currently visible
        (even if only partially visible) or false otherwise.
        """

    def RefreshRowColumn(self, *args, **kw):
        """
        RefreshRowColumn(row, column)
        RefreshRowColumn(pos)
        
        Triggers a refresh for just the area shared between the given row and
        column of the window if it is visible.
        """

    def RefreshRowsColumns(self, *args, **kw):
        """
        RefreshRowsColumns(fromRow, toRow, fromColumn, toColumn)
        RefreshRowsColumns(from, to)
        
        Triggers a refresh for the visible area shared between all given rows
        and columns (inclusive) of the window.
        """

    def ScrollToRowColumn(self, *args, **kw):
        """
        ScrollToRowColumn(row, column) -> bool
        ScrollToRowColumn(pos) -> bool
        
        Scroll to the specified row and column.
        """

    def VirtualHitTest(self, *args, **kw):
        """
        VirtualHitTest(x, y) -> Position
        VirtualHitTest(pos) -> Position
        
        Returns the virtual scroll unit under the device unit given accounting
        for scroll position or wxNOT_FOUND (for the row, column, or possibly
        both values) if none.
        """

    def EnablePhysicalScrolling(self, vscrolling=True, hscrolling=True):
        """
        EnablePhysicalScrolling(vscrolling=True, hscrolling=True)
        
        With physical scrolling on (when this is true), the device origin is
        changed properly when a wxPaintDC is prepared, children are actually
        moved and laid out properly, and the contents of the window (pixels)
        are actually moved.
        """

    def GetRowColumnCount(self):
        """
        GetRowColumnCount() -> Size
        
        Returns the number of columns and rows the target window contains.
        """

    def GetVisibleBegin(self):
        """
        GetVisibleBegin() -> Position
        
        Returns the index of the first visible column and row based on the
        current scroll position.
        """

    def GetVisibleEnd(self):
        """
        GetVisibleEnd() -> Position
        
        Returns the index of the last visible column and row based on the
        scroll position.
        """

    def SetRowColumnCount(self, rowCount, columnCount):
        """
        SetRowColumnCount(rowCount, columnCount)
        
        Set the number of rows and columns the target window will contain.
        """
    RowColumnCount = property(None, None)
    VisibleBegin = property(None, None)
    VisibleEnd = property(None, None)
# end of class VarHVScrollHelper


class VScrolledWindow(Panel, VarVScrollHelper):
    """
    VScrolledWindow()
    VScrolledWindow(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=PanelNameStr)
    
    In the name of this class, "V" may stand for "variable" because it can
    be used for scrolling rows of variable heights; "virtual", because it
    is not necessary to know the heights of all rows in advance  only
    those which are shown on the screen need to be measured; or even
    "vertical", because this class only supports scrolling vertically.
    """

    def __init__(self, *args, **kw):
        """
        VScrolledWindow()
        VScrolledWindow(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=PanelNameStr)
        
        In the name of this class, "V" may stand for "variable" because it can
        be used for scrolling rows of variable heights; "virtual", because it
        is not necessary to know the heights of all rows in advance  only
        those which are shown on the screen need to be measured; or even
        "vertical", because this class only supports scrolling vertically.
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=PanelNameStr):
        """
        Create(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=PanelNameStr) -> bool
        
        Same as the non-default constructor, but returns a status code: true
        if ok, false if the window couldn't be created.
        """
# end of class VScrolledWindow


class HScrolledWindow(Panel, VarHScrollHelper):
    """
    HScrolledWindow()
    HScrolledWindow(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=PanelNameStr)
    
    In the name of this class, "H" stands for "horizontal" because it can
    be used for scrolling columns of variable widths.
    """

    def __init__(self, *args, **kw):
        """
        HScrolledWindow()
        HScrolledWindow(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=PanelNameStr)
        
        In the name of this class, "H" stands for "horizontal" because it can
        be used for scrolling columns of variable widths.
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=PanelNameStr):
        """
        Create(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=PanelNameStr) -> bool
        
        Same as the non-default constructor, but returns a status code: true
        if ok, false if the window couldn't be created.
        """
# end of class HScrolledWindow


class HVScrolledWindow(Panel, VarHVScrollHelper):
    """
    HVScrolledWindow()
    HVScrolledWindow(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=PanelNameStr)
    
    This window inherits all functionality of both vertical and
    horizontal, variable scrolled windows.
    """

    def __init__(self, *args, **kw):
        """
        HVScrolledWindow()
        HVScrolledWindow(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=PanelNameStr)
        
        This window inherits all functionality of both vertical and
        horizontal, variable scrolled windows.
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=PanelNameStr):
        """
        Create(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=PanelNameStr) -> bool
        
        Same as the non-default constructor, but returns a status code: true
        if ok, false if the window couldn't be created.
        """
# end of class HVScrolledWindow

#-- end-vscroll --#
#-- begin-control --#
ELLIPSIZE_FLAGS_NONE = 0
ELLIPSIZE_FLAGS_PROCESS_MNEMONICS = 0
ELLIPSIZE_FLAGS_EXPAND_TABS = 0
ELLIPSIZE_FLAGS_DEFAULT = 0
ELLIPSIZE_NONE = 0
ELLIPSIZE_START = 0
ELLIPSIZE_MIDDLE = 0
ELLIPSIZE_END = 0
ControlNameStr = ""

class Control(Window):
    """
    Control(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=ControlNameStr)
    Control()
    
    This is the base class for a control or "widget".
    """

    def __init__(self, *args, **kw):
        """
        Control(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=ControlNameStr)
        Control()
        
        This is the base class for a control or "widget".
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=ControlNameStr):
        """
        Create(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=ControlNameStr) -> bool
        """

    def Command(self, event):
        """
        Command(event)
        
        Simulates the effect of the user issuing a command to the item.
        """

    def GetLabel(self):
        """
        GetLabel() -> String
        
        Returns the control's label, as it was passed to SetLabel().
        """

    def GetLabelText(self, *args, **kw):
        """
        GetLabelText() -> String
        GetLabelText(label) -> String
        
        Returns the control's label without mnemonics.
        """

    def GetSizeFromTextSize(self, *args, **kw):
        """
        GetSizeFromTextSize(xlen, ylen=-1) -> Size
        GetSizeFromTextSize(tsize) -> Size
        
        Determine the size needed by the control to leave the given area for
        its text.
        """

    def SetLabel(self, label):
        """
        SetLabel(label)
        
        Sets the control's label.
        """

    def SetLabelText(self, text):
        """
        SetLabelText(text)
        
        Sets the control's label to exactly the given string.
        """

    def SetLabelMarkup(self, markup):
        """
        SetLabelMarkup(markup) -> bool
        
        Sets the controls label to a string using markup.
        """

    @staticmethod
    def RemoveMnemonics(str):
        """
        RemoveMnemonics(str) -> String
        
        Returns the given str string without mnemonics ("&" characters).
        """

    @staticmethod
    def EscapeMnemonics(text):
        """
        EscapeMnemonics(text) -> String
        
        Escapes the special mnemonics characters ("&") in the given string.
        """

    @staticmethod
    def Ellipsize(label, dc, mode, maxWidth, flags=ELLIPSIZE_FLAGS_DEFAULT):
        """
        Ellipsize(label, dc, mode, maxWidth, flags=ELLIPSIZE_FLAGS_DEFAULT) -> String
        
        Replaces parts of the label string with ellipsis, if needed, so that
        it fits into maxWidth pixels if possible.
        """
    Label = property(None, None)
    LabelText = property(None, None)
# end of class Control


PyControl = wx.deprecated(Control, 'Use Control instead.')
#-- end-control --#
#-- begin-ctrlsub --#

class ItemContainerImmutable(object):
    """
    ItemContainerImmutable()
    
    wxItemContainer defines an interface which is implemented by all
    controls which have string subitems each of which may be selected.
    """

    def __init__(self):
        """
        ItemContainerImmutable()
        
        wxItemContainer defines an interface which is implemented by all
        controls which have string subitems each of which may be selected.
        """

    def GetCount(self):
        """
        GetCount() -> unsignedint
        
        Returns the number of items in the control.
        """

    def IsEmpty(self):
        """
        IsEmpty() -> bool
        
        Returns true if the control is empty or false if it has some items.
        """

    def GetString(self, n):
        """
        GetString(n) -> String
        
        Returns the label of the item with the given index.
        """

    def GetStrings(self):
        """
        GetStrings() -> ArrayString
        
        Returns the array of the labels of all items in the control.
        """

    def SetString(self, n, string):
        """
        SetString(n, string)
        
        Sets the label for the given item.
        """

    def FindString(self, string, caseSensitive=False):
        """
        FindString(string, caseSensitive=False) -> int
        
        Finds an item whose label matches the given string.
        """

    def SetSelection(self, n):
        """
        SetSelection(n)
        
        Sets the selection to the given item n or removes the selection
        entirely if n == wxNOT_FOUND.
        """

    def GetSelection(self):
        """
        GetSelection() -> int
        
        Returns the index of the selected item or wxNOT_FOUND if no item is
        selected.
        """

    def SetStringSelection(self, string):
        """
        SetStringSelection(string) -> bool
        
        Selects the item with the specified string in the control.
        """

    def GetStringSelection(self):
        """
        GetStringSelection() -> String
        
        Returns the label of the selected item or an empty string if no item
        is selected.
        """

    def Select(self, n):
        """
        Select(n)
        
        This is the same as SetSelection() and exists only because it is
        slightly more natural for controls which support multiple selection.
        """
    Count = property(None, None)
    Selection = property(None, None)
    StringSelection = property(None, None)
    Strings = property(None, None)
# end of class ItemContainerImmutable


class ItemContainer(ItemContainerImmutable):
    """
    This class is an abstract base class for some wxWidgets controls which
    contain several items such as wxListBox, wxCheckListBox, wxComboBox or
    wxChoice.
    """

    def Append(self, *args, **kw):
        """
        Append(item) -> int
        Append(item, clientData) -> int
        Append(items) -> int
        
        Appends item into the control.
        """

    def GetClientData(self, n):
        """
        GetClientData(n) -> ClientData
        
        Returns a pointer to the client data associated with the given item
        (if any).
        """

    def SetClientData(self, n, data):
        """
        SetClientData(n, data)
        
        Associates the given typed client data pointer with the given item:
        the data object will be deleted when the item is deleted (either
        explicitly by using Delete() or implicitly when the control itself is
        destroyed).
        """

    def Insert(self, *args, **kw):
        """
        Insert(item, pos) -> int
        Insert(item, pos, clientData) -> int
        Insert(items, pos) -> int
        
        Inserts item into the control.
        """

    def Set(self, items):
        """
        Set(items)
        
        Replaces the current control contents with the given items.
        """

    def Clear(self):
        """
        Clear()
        
        Removes all items from the control.
        """

    def Delete(self, n):
        """
        Delete(n)
        
        Deletes an item from the control.
        """

    def DetachClientObject(self, n):
        """
        DetachClientObject(n) -> ClientData
        
        Returns the client object associated with the given item and transfers
        its ownership to the caller.
        """

    def HasClientData(self):
        """
        HasClientData() -> bool
        
        Returns true, if either untyped data (void*) or object data
        (wxClientData*) is associated with the items of the control.
        """

    def HasClientObjectData(self):
        """
        HasClientObjectData() -> bool
        
        Returns true, if object data is associated with the items of the
        control.
        """

    def HasClientUntypedData(self):
        """
        HasClientUntypedData() -> bool
        
        Returns true, if untyped data (void*) is associated with the items of
        the control.
        """

    def GetClientObject(self, n):
        """
        Alias for :meth:`GetClientData`
        """

    def SetClientObject(self, n, data):
        """
        Alias for :meth:`SetClientData`
        """

    def AppendItems(self, items):
        """
        
        """

    def GetItems(self):
        """
        
        """

    def SetItems(self, items):
        """
        
        """
    Items = property(None, None)
# end of class ItemContainer


class ControlWithItems(Control, ItemContainer):
    """
    This is convenience class that derives from both wxControl and
    wxItemContainer.
    """
# end of class ControlWithItems

#-- end-ctrlsub --#
#-- begin-statbmp --#
StaticBitmapNameStr = ""

class StaticBitmap(Control):
    """
    StaticBitmap()
    StaticBitmap(parent, id=ID_ANY, label=NullBitmap, pos=DefaultPosition, size=DefaultSize, style=0, name=StaticBitmapNameStr)
    
    A static bitmap control displays a bitmap.
    """

    def __init__(self, *args, **kw):
        """
        StaticBitmap()
        StaticBitmap(parent, id=ID_ANY, label=NullBitmap, pos=DefaultPosition, size=DefaultSize, style=0, name=StaticBitmapNameStr)
        
        A static bitmap control displays a bitmap.
        """

    def Create(self, parent, id=ID_ANY, label=NullBitmap, pos=DefaultPosition, size=DefaultSize, style=0, name=StaticBitmapNameStr):
        """
        Create(parent, id=ID_ANY, label=NullBitmap, pos=DefaultPosition, size=DefaultSize, style=0, name=StaticBitmapNameStr) -> bool
        
        Creation function, for two-step construction.
        """

    def GetBitmap(self):
        """
        GetBitmap() -> Bitmap
        
        Returns the bitmap currently used in the control.
        """

    def GetIcon(self):
        """
        GetIcon() -> Icon
        
        Returns the icon currently used in the control.
        """

    def SetBitmap(self, label):
        """
        SetBitmap(label)
        
        Sets the bitmap label.
        """

    def SetIcon(self, label):
        """
        SetIcon(label)
        
        Sets the label to the given icon.
        """
    Bitmap = property(None, None)
    Icon = property(None, None)
# end of class StaticBitmap

#-- end-statbmp --#
#-- begin-stattext --#
ST_NO_AUTORESIZE = 0
ST_ELLIPSIZE_START = 0
ST_ELLIPSIZE_MIDDLE = 0
ST_ELLIPSIZE_END = 0
StaticTextNameStr = ""

class StaticText(Control):
    """
    StaticText()
    StaticText(parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, name=StaticTextNameStr)
    
    A static text control displays one or more lines of read-only text.
    """

    def __init__(self, *args, **kw):
        """
        StaticText()
        StaticText(parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, name=StaticTextNameStr)
        
        A static text control displays one or more lines of read-only text.
        """

    def Create(self, parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, name=StaticTextNameStr):
        """
        Create(parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, name=StaticTextNameStr) -> bool
        
        Creation function, for two-step construction.
        """

    def IsEllipsized(self):
        """
        IsEllipsized() -> bool
        
        Returns true if the window styles for this control contains one of the
        wxST_ELLIPSIZE_START, wxST_ELLIPSIZE_MIDDLE or wxST_ELLIPSIZE_END
        styles.
        """

    def Wrap(self, width):
        """
        Wrap(width)
        
        This functions wraps the controls label so that each of its lines
        becomes at most width pixels wide if possible (the lines are broken at
        words boundaries so it might not be the case if words are too long).
        """
# end of class StaticText

#-- end-stattext --#
#-- begin-statbox --#
StaticBoxNameStr = ""

class StaticBox(Control):
    """
    StaticBox()
    StaticBox(parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, name=StaticBoxNameStr)
    
    A static box is a rectangle drawn around other windows to denote a
    logical grouping of items.
    """

    def __init__(self, *args, **kw):
        """
        StaticBox()
        StaticBox(parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, name=StaticBoxNameStr)
        
        A static box is a rectangle drawn around other windows to denote a
        logical grouping of items.
        """

    def Create(self, parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, name=StaticBoxNameStr):
        """
        Create(parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, name=StaticBoxNameStr) -> bool
        
        Creates the static box for two-step construction.
        """
# end of class StaticBox

#-- end-statbox --#
#-- begin-statusbar --#
STB_SIZEGRIP = 0
STB_SHOW_TIPS = 0
STB_ELLIPSIZE_START = 0
STB_ELLIPSIZE_MIDDLE = 0
STB_ELLIPSIZE_END = 0
STB_DEFAULT_STYLE = 0
SB_NORMAL = 0
SB_FLAT = 0
SB_RAISED = 0
SB_SUNKEN = 0
StatusBarNameStr = ""

class StatusBar(Control):
    """
    StatusBar()
    StatusBar(parent, id=ID_ANY, style=STB_DEFAULT_STYLE, name=StatusBarNameStr)
    
    A status bar is a narrow window that can be placed along the bottom of
    a frame to give small amounts of status information.
    """

    def __init__(self, *args, **kw):
        """
        StatusBar()
        StatusBar(parent, id=ID_ANY, style=STB_DEFAULT_STYLE, name=StatusBarNameStr)
        
        A status bar is a narrow window that can be placed along the bottom of
        a frame to give small amounts of status information.
        """

    def Create(self, parent, id=ID_ANY, style=STB_DEFAULT_STYLE, name=StatusBarNameStr):
        """
        Create(parent, id=ID_ANY, style=STB_DEFAULT_STYLE, name=StatusBarNameStr) -> bool
        
        Creates the window, for two-step construction.
        """

    def GetFieldRect(self, i):
        """
        GetFieldRect(i) -> Rect
        
        Returns the size and position of a field's internal bounding
        rectangle.
        """

    def GetFieldsCount(self):
        """
        GetFieldsCount() -> int
        
        Returns the number of fields in the status bar.
        """

    def GetField(self, n):
        """
        GetField(n) -> StatusBarPane
        
        Returns the wxStatusBarPane representing the n-th field.
        """

    def GetBorders(self):
        """
        GetBorders() -> Size
        
        Returns the horizontal and vertical borders used when rendering the
        field text inside the field area.
        """

    def GetStatusText(self, i=0):
        """
        GetStatusText(i=0) -> String
        
        Returns the string associated with a status bar field.
        """

    def GetStatusWidth(self, n):
        """
        GetStatusWidth(n) -> int
        
        Returns the width of the n-th field.
        """

    def GetStatusStyle(self, n):
        """
        GetStatusStyle(n) -> int
        
        Returns the style of the n-th field.
        """

    def PopStatusText(self, field=0):
        """
        PopStatusText(field=0)
        
        Restores the text to the value it had before the last call to
        PushStatusText().
        """

    def PushStatusText(self, string, field=0):
        """
        PushStatusText(string, field=0)
        
        Saves the current field text in a per-field stack, and sets the field
        text to the string passed as argument.
        """

    def SetFieldsCount(self, number=1, widths=None):
        """
        SetFieldsCount(number=1, widths=None)
        
        Sets the number of fields, and optionally the field widths.
        """

    def SetMinHeight(self, height):
        """
        SetMinHeight(height)
        
        Sets the minimal possible height for the status bar.
        """

    def SetStatusStyles(self, styles):
        """
        SetStatusStyles(styles)
        
        Sets the styles of the fields in the status line which can make fields
        appear flat or raised instead of the standard sunken 3D border.
        """

    def SetStatusText(self, text, i=0):
        """
        SetStatusText(text, i=0)
        
        Sets the status text for the i-th field.
        """

    def SetStatusWidths(self, widths):
        """
        SetStatusWidths(widths)
        
        Sets the widths of the fields in the status line.
        """
    Borders = property(None, None)
    FieldRect = property(None, None)
    FieldsCount = property(None, None)
    StatusText = property(None, None)
# end of class StatusBar


class StatusBarPane(object):
    """
    StatusBarPane(style=SB_NORMAL, width=0)
    
    A status bar pane data container used by wxStatusBar.
    """

    def __init__(self, style=SB_NORMAL, width=0):
        """
        StatusBarPane(style=SB_NORMAL, width=0)
        
        A status bar pane data container used by wxStatusBar.
        """

    def GetWidth(self):
        """
        GetWidth() -> int
        
        Returns the pane width; it maybe negative, indicating a variable-width
        field.
        """

    def GetStyle(self):
        """
        GetStyle() -> int
        
        Returns the pane style.
        """

    def GetText(self):
        """
        GetText() -> String
        
        Returns the text currently shown in this pane.
        """

    def IsEllipsized(self):
        """
        IsEllipsized() -> bool
        """

    def SetIsEllipsized(self, isEllipsized):
        """
        SetIsEllipsized(isEllipsized)
        """

    def SetWidth(self, width):
        """
        SetWidth(width)
        """

    def SetStyle(self, style):
        """
        SetStyle(style)
        """

    def SetText(self, text):
        """
        SetText(text) -> bool
        
        Set text.
        """

    def PushText(self, text):
        """
        PushText(text) -> bool
        
        Save the existing text on top of a stack and make the new text
        current.
        """

    def PopText(self):
        """
        PopText() -> bool
        
        Restore the message saved by the last call to Push() (unless it was
        changed by an intervening call to SetText()) and return true if we
        really restored anything.
        """
    Style = property(None, None)
    Text = property(None, None)
    Width = property(None, None)
# end of class StatusBarPane

#-- end-statusbar --#
#-- begin-choice --#
ChoiceNameStr = ""

class Choice(Control, ItemContainer):
    """
    Choice()
    Choice(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, choices=[], style=0, validator=DefaultValidator, name=ChoiceNameStr)
    
    A choice item is used to select one of a list of strings.
    """

    def __init__(self, *args, **kw):
        """
        Choice()
        Choice(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, choices=[], style=0, validator=DefaultValidator, name=ChoiceNameStr)
        
        A choice item is used to select one of a list of strings.
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, choices=[], style=0, validator=DefaultValidator, name=ChoiceNameStr):
        """
        Create(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, choices=[], style=0, validator=DefaultValidator, name=ChoiceNameStr) -> bool
        
        Creates the choice for two-step construction.
        """

    def GetColumns(self):
        """
        GetColumns() -> int
        
        Gets the number of columns in this choice item.
        """

    def GetCurrentSelection(self):
        """
        GetCurrentSelection() -> int
        
        Unlike wxControlWithItems::GetSelection() which only returns the
        accepted selection value (the selection in the control once the user
        closes the dropdown list), this function returns the current
        selection.
        """

    def SetColumns(self, n=1):
        """
        SetColumns(n=1)
        
        Sets the number of columns in this choice item.
        """

    def IsSorted(self):
        """
        IsSorted() -> bool
        """

    def GetCount(self):
        """
        GetCount() -> unsignedint
        
        Returns the number of items in the control.
        """

    def GetSelection(self):
        """
        GetSelection() -> int
        
        Returns the index of the selected item or wxNOT_FOUND if no item is
        selected.
        """

    def SetSelection(self, n):
        """
        SetSelection(n)
        
        Sets the selection to the given item n or removes the selection
        entirely if n == wxNOT_FOUND.
        """

    def FindString(self, string, caseSensitive=False):
        """
        FindString(string, caseSensitive=False) -> int
        
        Finds an item whose label matches the given string.
        """

    def GetString(self, n):
        """
        GetString(n) -> String
        
        Returns the label of the item with the given index.
        """

    def SetString(self, n, string):
        """
        SetString(n, string)
        
        Sets the label for the given item.
        """
    Columns = property(None, None)
    Count = property(None, None)
    CurrentSelection = property(None, None)
    Selection = property(None, None)
# end of class Choice

#-- end-choice --#
#-- begin-anybutton --#
BU_LEFT = 0
BU_TOP = 0
BU_RIGHT = 0
BU_BOTTOM = 0
BU_ALIGN_MASK = 0
BU_EXACTFIT = 0
BU_NOTEXT = 0
BU_AUTODRAW = 0

class AnyButton(Control):
    """
    AnyButton()
    
    A class for common button functionality used as the base for the
    various button classes.
    """

    def __init__(self):
        """
        AnyButton()
        
        A class for common button functionality used as the base for the
        various button classes.
        """

    def SetBitmapMargins(self, *args, **kw):
        """
        SetBitmapMargins(x, y)
        SetBitmapMargins(sz)
        
        Set the margins between the bitmap and the text of the button.
        """

    def GetBitmap(self):
        """
        GetBitmap() -> Bitmap
        
        Return the bitmap shown by the button.
        """

    def GetBitmapCurrent(self):
        """
        GetBitmapCurrent() -> Bitmap
        
        Returns the bitmap used when the mouse is over the button, which may
        be invalid.
        """

    def GetBitmapDisabled(self):
        """
        GetBitmapDisabled() -> Bitmap
        
        Returns the bitmap for the disabled state, which may be invalid.
        """

    def GetBitmapFocus(self):
        """
        GetBitmapFocus() -> Bitmap
        
        Returns the bitmap for the focused state, which may be invalid.
        """

    def GetBitmapLabel(self):
        """
        GetBitmapLabel() -> Bitmap
        
        Returns the bitmap for the normal state.
        """

    def GetBitmapPressed(self):
        """
        GetBitmapPressed() -> Bitmap
        
        Returns the bitmap for the pressed state, which may be invalid.
        """

    def SetBitmap(self, bitmap, dir=LEFT):
        """
        SetBitmap(bitmap, dir=LEFT)
        
        Sets the bitmap to display in the button.
        """

    def SetBitmapCurrent(self, bitmap):
        """
        SetBitmapCurrent(bitmap)
        
        Sets the bitmap to be shown when the mouse is over the button.
        """

    def SetBitmapDisabled(self, bitmap):
        """
        SetBitmapDisabled(bitmap)
        
        Sets the bitmap for the disabled button appearance.
        """

    def SetBitmapFocus(self, bitmap):
        """
        SetBitmapFocus(bitmap)
        
        Sets the bitmap for the button appearance when it has the keyboard
        focus.
        """

    def SetBitmapLabel(self, bitmap):
        """
        SetBitmapLabel(bitmap)
        
        Sets the bitmap label for the button.
        """

    def SetBitmapPressed(self, bitmap):
        """
        SetBitmapPressed(bitmap)
        
        Sets the bitmap for the selected (depressed) button appearance.
        """

    def GetBitmapMargins(self):
        """
        GetBitmapMargins() -> Size
        
        Get the margins between the bitmap and the text of the button.
        """

    def SetBitmapPosition(self, dir):
        """
        SetBitmapPosition(dir)
        
        Set the position at which the bitmap is displayed.
        """
    Bitmap = property(None, None)
    BitmapCurrent = property(None, None)
    BitmapDisabled = property(None, None)
    BitmapFocus = property(None, None)
    BitmapLabel = property(None, None)
    BitmapMargins = property(None, None)
    BitmapPressed = property(None, None)
# end of class AnyButton

#-- end-anybutton --#
#-- begin-button --#
ButtonNameStr = ""

class Button(AnyButton):
    """
    Button()
    Button(parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=ButtonNameStr)
    
    A button is a control that contains a text string, and is one of the
    most common elements of a GUI.
    """

    def __init__(self, *args, **kw):
        """
        Button()
        Button(parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=ButtonNameStr)
        
        A button is a control that contains a text string, and is one of the
        most common elements of a GUI.
        """

    def Create(self, parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=ButtonNameStr):
        """
        Create(parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=ButtonNameStr) -> bool
        
        Button creation function for two-step creation.
        """

    def GetAuthNeeded(self):
        """
        GetAuthNeeded() -> bool
        
        Returns true if an authentication needed symbol is displayed on the
        button.
        """

    def GetLabel(self):
        """
        GetLabel() -> String
        
        Returns the string label for the button.
        """

    def SetAuthNeeded(self, needed=True):
        """
        SetAuthNeeded(needed=True)
        
        Sets whether an authentication needed symbol should be displayed on
        the button.
        """

    def SetDefault(self):
        """
        SetDefault() -> Window
        
        This sets the button to be the default item in its top-level window
        (e.g.
        """

    def SetLabel(self, label):
        """
        SetLabel(label)
        
        Sets the string label for the button.
        """

    @staticmethod
    def GetDefaultSize():
        """
        GetDefaultSize() -> Size
        
        Returns the default size for the buttons.
        """
    AuthNeeded = property(None, None)
    Label = property(None, None)
# end of class Button

#-- end-button --#
#-- begin-bmpbuttn --#

class BitmapButton(Button):
    """
    BitmapButton()
    BitmapButton(parent, id=ID_ANY, bitmap=NullBitmap, pos=DefaultPosition, size=DefaultSize, style=BU_AUTODRAW, validator=DefaultValidator, name=ButtonNameStr)
    
    A bitmap button is a control that contains a bitmap.
    """

    def __init__(self, *args, **kw):
        """
        BitmapButton()
        BitmapButton(parent, id=ID_ANY, bitmap=NullBitmap, pos=DefaultPosition, size=DefaultSize, style=BU_AUTODRAW, validator=DefaultValidator, name=ButtonNameStr)
        
        A bitmap button is a control that contains a bitmap.
        """

    def Create(self, parent, id=ID_ANY, bitmap=NullBitmap, pos=DefaultPosition, size=DefaultSize, style=BU_AUTODRAW, validator=DefaultValidator, name=ButtonNameStr):
        """
        Create(parent, id=ID_ANY, bitmap=NullBitmap, pos=DefaultPosition, size=DefaultSize, style=BU_AUTODRAW, validator=DefaultValidator, name=ButtonNameStr) -> bool
        
        Button creation function for two-step creation.
        """

    @staticmethod
    def NewCloseButton(parent, winid):
        """
        NewCloseButton(parent, winid) -> BitmapButton
        
        Helper function creating a standard-looking "Close" button.
        """
# end of class BitmapButton

#-- end-bmpbuttn --#
#-- begin-withimage --#

class WithImages(object):
    """
    WithImages()
    
    A mixin class to be used with other classes that use a wxImageList.
    """
    NO_IMAGE = 0

    def __init__(self):
        """
        WithImages()
        
        A mixin class to be used with other classes that use a wxImageList.
        """

    def AssignImageList(self, imageList):
        """
        AssignImageList(imageList)
        
        Sets the image list for the page control and takes ownership of the
        list.
        """

    def SetImageList(self, imageList):
        """
        SetImageList(imageList)
        
        Sets the image list to use.
        """

    def GetImageList(self):
        """
        GetImageList() -> ImageList
        
        Returns the associated image list, may be NULL.
        """
    ImageList = property(None, None)
# end of class WithImages

NO_IMAGE = 0
#-- end-withimage --#
#-- begin-bookctrl --#
BK_DEFAULT = 0
BK_TOP = 0
BK_BOTTOM = 0
BK_LEFT = 0
BK_RIGHT = 0
BK_ALIGN_MASK = 0
BK_HITTEST_NOWHERE = 0
BK_HITTEST_ONICON = 0
BK_HITTEST_ONLABEL = 0
BK_HITTEST_ONITEM = 0
BK_HITTEST_ONPAGE = 0

class BookCtrlBase(Control, WithImages):
    """
    BookCtrlBase()
    BookCtrlBase(parent, winid, pos=DefaultPosition, size=DefaultSize, style=0, name=EmptyString)
    
    A book control is a convenient way of displaying multiple pages of
    information, displayed one page at a time.
    """
    NO_IMAGE = 0

    def __init__(self, *args, **kw):
        """
        BookCtrlBase()
        BookCtrlBase(parent, winid, pos=DefaultPosition, size=DefaultSize, style=0, name=EmptyString)
        
        A book control is a convenient way of displaying multiple pages of
        information, displayed one page at a time.
        """

    def GetPageImage(self, nPage):
        """
        GetPageImage(nPage) -> int
        
        Returns the image index for the given page.
        """

    def SetPageImage(self, page, image):
        """
        SetPageImage(page, image) -> bool
        
        Sets the image index for the given page.
        """

    def GetPageText(self, nPage):
        """
        GetPageText(nPage) -> String
        
        Returns the string for the given page.
        """

    def SetPageText(self, page, text):
        """
        SetPageText(page, text) -> bool
        
        Sets the text for the given page.
        """

    def GetSelection(self):
        """
        GetSelection() -> int
        
        Returns the currently selected page, or wxNOT_FOUND if none was
        selected.
        """

    def GetCurrentPage(self):
        """
        GetCurrentPage() -> Window
        
        Returns the currently selected page or NULL.
        """

    def SetSelection(self, page):
        """
        SetSelection(page) -> int
        
        Sets the selection to the given page, returning the previous
        selection.
        """

    def AdvanceSelection(self, forward=True):
        """
        AdvanceSelection(forward=True)
        
        Cycles through the tabs.
        """

    def ChangeSelection(self, page):
        """
        ChangeSelection(page) -> int
        
        Changes the selection to the given page, returning the previous
        selection.
        """

    def FindPage(self, page):
        """
        FindPage(page) -> int
        
        Returns the index of the specified tab window or wxNOT_FOUND if not
        found.
        """

    def AddPage(self, page, text, select=False, imageId=NO_IMAGE):
        """
        AddPage(page, text, select=False, imageId=NO_IMAGE) -> bool
        
        Adds a new page.
        """

    def DeleteAllPages(self):
        """
        DeleteAllPages() -> bool
        
        Deletes all pages.
        """

    def DeletePage(self, page):
        """
        DeletePage(page) -> bool
        
        Deletes the specified page, and the associated window.
        """

    def InsertPage(self, index, page, text, select=False, imageId=NO_IMAGE):
        """
        InsertPage(index, page, text, select=False, imageId=NO_IMAGE) -> bool
        
        Inserts a new page at the specified position.
        """

    def RemovePage(self, page):
        """
        RemovePage(page) -> bool
        
        Deletes the specified page, without deleting the associated window.
        """

    def GetPageCount(self):
        """
        GetPageCount() -> size_t
        
        Returns the number of pages in the control.
        """

    def GetPage(self, page):
        """
        GetPage(page) -> Window
        
        Returns the window at the given page position.
        """

    def Create(self, parent, winid, pos=DefaultPosition, size=DefaultSize, style=0, name=EmptyString):
        """
        Create(parent, winid, pos=DefaultPosition, size=DefaultSize, style=0, name=EmptyString) -> bool
        
        Constructs the book control with the given parameters.
        """

    def SetPageSize(self, size):
        """
        SetPageSize(size)
        
        Sets the width and height of the pages.
        """

    def HitTest(self, pt):
        """
        HitTest(pt) -> (int, flags)
        
        Returns the index of the tab at the specified position or wxNOT_FOUND
        if none.
        """
    CurrentPage = property(None, None)
    PageCount = property(None, None)
    Selection = property(None, None)
# end of class BookCtrlBase


class BookCtrlEvent(NotifyEvent):
    """
    BookCtrlEvent(eventType=wxEVT_NULL, id=0, sel=NOT_FOUND, oldSel=NOT_FOUND)
    
    This class represents the events generated by book controls
    (wxNotebook, wxListbook, wxChoicebook, wxTreebook, wxAuiNotebook).
    """

    def __init__(self, eventType=wxEVT_NULL, id=0, sel=NOT_FOUND, oldSel=NOT_FOUND):
        """
        BookCtrlEvent(eventType=wxEVT_NULL, id=0, sel=NOT_FOUND, oldSel=NOT_FOUND)
        
        This class represents the events generated by book controls
        (wxNotebook, wxListbook, wxChoicebook, wxTreebook, wxAuiNotebook).
        """

    def GetOldSelection(self):
        """
        GetOldSelection() -> int
        
        Returns the page that was selected before the change, wxNOT_FOUND if
        none was selected.
        """

    def GetSelection(self):
        """
        GetSelection() -> int
        
        Returns the currently selected page, or wxNOT_FOUND if none was
        selected.
        """

    def SetOldSelection(self, page):
        """
        SetOldSelection(page)
        
        Sets the id of the page selected before the change.
        """

    def SetSelection(self, page):
        """
        SetSelection(page)
        
        Sets the selection member variable.
        """
    OldSelection = property(None, None)
    Selection = property(None, None)
# end of class BookCtrlEvent

#-- end-bookctrl --#
#-- begin-notebook --#
NB_DEFAULT = 0
NB_TOP = 0
NB_BOTTOM = 0
NB_LEFT = 0
NB_RIGHT = 0
NB_FIXEDWIDTH = 0
NB_MULTILINE = 0
NB_NOPAGETHEME = 0
NB_FLAT = 0
NB_HITTEST_NOWHERE = 0
NB_HITTEST_ONICON = 0
NB_HITTEST_ONLABEL = 0
NB_HITTEST_ONITEM = 0
NB_HITTEST_ONPAGE = 0
wxEVT_NOTEBOOK_PAGE_CHANGED = 0
wxEVT_NOTEBOOK_PAGE_CHANGING = 0
NotebookNameStr = ""

class Notebook(BookCtrlBase):
    """
    Notebook()
    Notebook(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=NotebookNameStr)
    
    This class represents a notebook control, which manages multiple
    windows with associated tabs.
    """

    def __init__(self, *args, **kw):
        """
        Notebook()
        Notebook(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=NotebookNameStr)
        
        This class represents a notebook control, which manages multiple
        windows with associated tabs.
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=NotebookNameStr):
        """
        Create(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=NotebookNameStr) -> bool
        
        Creates a notebook control.
        """

    def GetRowCount(self):
        """
        GetRowCount() -> int
        
        Returns the number of rows in the notebook control.
        """

    def GetThemeBackgroundColour(self):
        """
        GetThemeBackgroundColour() -> Colour
        
        If running under Windows and themes are enabled for the application,
        this function returns a suitable colour for painting the background of
        a notebook page, and can be passed to SetBackgroundColour().
        """

    def SetPadding(self, padding):
        """
        SetPadding(padding)
        
        Sets the amount of space around each page's icon and label, in pixels.
        """

    def GetPageImage(self, nPage):
        """
        GetPageImage(nPage) -> int
        
        Returns the image index for the given page.
        """

    def SetPageImage(self, page, image):
        """
        SetPageImage(page, image) -> bool
        
        Sets the image index for the given page.
        """

    def GetPageText(self, nPage):
        """
        GetPageText(nPage) -> String
        
        Returns the string for the given page.
        """

    def SetPageText(self, page, text):
        """
        SetPageText(page, text) -> bool
        
        Sets the text for the given page.
        """

    def GetSelection(self):
        """
        GetSelection() -> int
        
        Returns the currently selected page, or wxNOT_FOUND if none was
        selected.
        """

    def SetSelection(self, page):
        """
        SetSelection(page) -> int
        
        Sets the selection to the given page, returning the previous
        selection.
        """

    def ChangeSelection(self, page):
        """
        ChangeSelection(page) -> int
        
        Changes the selection to the given page, returning the previous
        selection.
        """

    def InsertPage(self, index, page, text, select=False, imageId=NO_IMAGE):
        """
        InsertPage(index, page, text, select=False, imageId=NO_IMAGE) -> bool
        
        Inserts a new page at the specified position.
        """
    RowCount = property(None, None)
    Selection = property(None, None)
    ThemeBackgroundColour = property(None, None)
# end of class Notebook


EVT_NOTEBOOK_PAGE_CHANGED  = wx.PyEventBinder( wxEVT_NOTEBOOK_PAGE_CHANGED, 1 )
EVT_NOTEBOOK_PAGE_CHANGING = wx.PyEventBinder( wxEVT_NOTEBOOK_PAGE_CHANGING, 1 )

# Aliases for the "best book" control as described in the overview
BookCtrl =                       Notebook
wxEVT_BOOKCTRL_PAGE_CHANGED =    wxEVT_NOTEBOOK_PAGE_CHANGED
wxEVT_BOOKCTRL_PAGE_CHANGING =   wxEVT_NOTEBOOK_PAGE_CHANGING
EVT_BOOKCTRL_PAGE_CHANGED =      EVT_NOTEBOOK_PAGE_CHANGED
EVT_BOOKCTRL_PAGE_CHANGING =     EVT_NOTEBOOK_PAGE_CHANGING

# deprecated wxEVT aliases
wxEVT_COMMAND_BOOKCTRL_PAGE_CHANGED   = wxEVT_BOOKCTRL_PAGE_CHANGED
wxEVT_COMMAND_BOOKCTRL_PAGE_CHANGING  = wxEVT_BOOKCTRL_PAGE_CHANGING
wxEVT_COMMAND_NOTEBOOK_PAGE_CHANGED   = wxEVT_NOTEBOOK_PAGE_CHANGED
wxEVT_COMMAND_NOTEBOOK_PAGE_CHANGING  = wxEVT_NOTEBOOK_PAGE_CHANGING
#-- end-notebook --#
#-- begin-splitter --#
SP_NOBORDER = 0
SP_THIN_SASH = 0
SP_NOSASH = 0
SP_PERMIT_UNSPLIT = 0
SP_LIVE_UPDATE = 0
SP_3DSASH = 0
SP_3DBORDER = 0
SP_NO_XP_THEME = 0
SP_BORDER = 0
SP_3D = 0
SPLIT_HORIZONTAL = 0
SPLIT_VERTICAL = 0
SPLIT_DRAG_NONE = 0
SPLIT_DRAG_DRAGGING = 0
SPLIT_DRAG_LEFT_DOWN = 0
wxEVT_SPLITTER_SASH_POS_CHANGED = 0
wxEVT_SPLITTER_SASH_POS_CHANGING = 0
wxEVT_SPLITTER_DOUBLECLICKED = 0
wxEVT_SPLITTER_UNSPLIT = 0

class SplitterWindow(Window):
    """
    SplitterWindow()
    SplitterWindow(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=SP_3D, name="splitterWindow")
    
    This class manages up to two subwindows.
    """

    def __init__(self, *args, **kw):
        """
        SplitterWindow()
        SplitterWindow(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=SP_3D, name="splitterWindow")
        
        This class manages up to two subwindows.
        """

    def Create(self, parent, id=ID_ANY, point=DefaultPosition, size=DefaultSize, style=SP_3D, name="splitter"):
        """
        Create(parent, id=ID_ANY, point=DefaultPosition, size=DefaultSize, style=SP_3D, name="splitter") -> bool
        
        Creation function, for two-step construction.
        """

    def GetMinimumPaneSize(self):
        """
        GetMinimumPaneSize() -> int
        
        Returns the current minimum pane size (defaults to zero).
        """

    def GetSashGravity(self):
        """
        GetSashGravity() -> double
        
        Returns the current sash gravity.
        """

    def GetSashPosition(self):
        """
        GetSashPosition() -> int
        
        Returns the current sash position.
        """

    def GetSashSize(self):
        """
        GetSashSize() -> int
        
        Returns the default sash size in pixels or 0 if it is invisible.
        """

    def GetDefaultSashSize(self):
        """
        GetDefaultSashSize() -> int
        
        Returns the default sash size in pixels.
        """

    def GetSplitMode(self):
        """
        GetSplitMode() -> SplitMode
        
        Gets the split mode.
        """

    def GetWindow1(self):
        """
        GetWindow1() -> Window
        
        Returns the left/top or only pane.
        """

    def GetWindow2(self):
        """
        GetWindow2() -> Window
        
        Returns the right/bottom pane.
        """

    def Initialize(self, window):
        """
        Initialize(window)
        
        Initializes the splitter window to have one pane.
        """

    def IsSashInvisible(self):
        """
        IsSashInvisible() -> bool
        
        Returns true if the sash is invisible even when the window is split,
        false otherwise.
        """

    def IsSplit(self):
        """
        IsSplit() -> bool
        
        Returns true if the window is split, false otherwise.
        """

    def ReplaceWindow(self, winOld, winNew):
        """
        ReplaceWindow(winOld, winNew) -> bool
        
        This function replaces one of the windows managed by the
        wxSplitterWindow with another one.
        """

    def SetMinimumPaneSize(self, paneSize):
        """
        SetMinimumPaneSize(paneSize)
        
        Sets the minimum pane size.
        """

    def SetSashGravity(self, gravity):
        """
        SetSashGravity(gravity)
        
        Sets the sash gravity.
        """

    def SetSashPosition(self, position, redraw=True):
        """
        SetSashPosition(position, redraw=True)
        
        Sets the sash position.
        """

    def SetSashSize(self, size):
        """
        SetSashSize(size)
        
        Returns the default sash size in pixels or 0 if it is invisible.
        """

    def SetSplitMode(self, mode):
        """
        SetSplitMode(mode)
        
        Sets the split mode.
        """

    def SetSashInvisible(self, invisible=True):
        """
        SetSashInvisible(invisible=True)
        
        Sets whether the sash should be invisible, even when the window is
        split.
        """

    def SplitHorizontally(self, window1, window2, sashPosition=0):
        """
        SplitHorizontally(window1, window2, sashPosition=0) -> bool
        
        Initializes the top and bottom panes of the splitter window.
        """

    def SplitVertically(self, window1, window2, sashPosition=0):
        """
        SplitVertically(window1, window2, sashPosition=0) -> bool
        
        Initializes the left and right panes of the splitter window.
        """

    def Unsplit(self, toRemove=None):
        """
        Unsplit(toRemove=None) -> bool
        
        Unsplits the window.
        """

    def UpdateSize(self):
        """
        UpdateSize()
        
        Causes any pending sizing of the sash and child panes to take place
        immediately.
        """
    DefaultSashSize = property(None, None)
    MinimumPaneSize = property(None, None)
    SashGravity = property(None, None)
    SashPosition = property(None, None)
    SashSize = property(None, None)
    SplitMode = property(None, None)
    Window1 = property(None, None)
    Window2 = property(None, None)
    SashInvisible = property(None, None)
# end of class SplitterWindow


class SplitterEvent(NotifyEvent):
    """
    SplitterEvent(eventType=wxEVT_NULL, splitter=None)
    
    This class represents the events generated by a splitter control.
    """

    def __init__(self, eventType=wxEVT_NULL, splitter=None):
        """
        SplitterEvent(eventType=wxEVT_NULL, splitter=None)
        
        This class represents the events generated by a splitter control.
        """

    def GetSashPosition(self):
        """
        GetSashPosition() -> int
        
        Returns the new sash position.
        """

    def GetWindowBeingRemoved(self):
        """
        GetWindowBeingRemoved() -> Window
        
        Returns a pointer to the window being removed when a splitter window
        is unsplit.
        """

    def GetX(self):
        """
        GetX() -> int
        
        Returns the x coordinate of the double-click point.
        """

    def GetY(self):
        """
        GetY() -> int
        
        Returns the y coordinate of the double-click point.
        """

    def SetSashPosition(self, pos):
        """
        SetSashPosition(pos)
        
        In the case of wxEVT_SPLITTER_SASH_POS_CHANGED events, sets the new
        sash position.
        """

    EVT_SPLITTER_SASH_POS_CHANGED = wx.PyEventBinder( wxEVT_SPLITTER_SASH_POS_CHANGED, 1 )
    EVT_SPLITTER_SASH_POS_CHANGING = wx.PyEventBinder( wxEVT_SPLITTER_SASH_POS_CHANGING, 1 )
    EVT_SPLITTER_DOUBLECLICKED = wx.PyEventBinder( wxEVT_SPLITTER_DOUBLECLICKED, 1 )
    EVT_SPLITTER_UNSPLIT = wx.PyEventBinder( wxEVT_SPLITTER_UNSPLIT, 1 )
    EVT_SPLITTER_DCLICK = EVT_SPLITTER_DOUBLECLICKED
    
    # deprecated wxEVT aliases
    wxEVT_COMMAND_SPLITTER_SASH_POS_CHANGED   = wxEVT_SPLITTER_SASH_POS_CHANGED
    wxEVT_COMMAND_SPLITTER_SASH_POS_CHANGING  = wxEVT_SPLITTER_SASH_POS_CHANGING
    wxEVT_COMMAND_SPLITTER_DOUBLECLICKED      = wxEVT_SPLITTER_DOUBLECLICKED
    wxEVT_COMMAND_SPLITTER_UNSPLIT            = wxEVT_SPLITTER_UNSPLIT
    SashPosition = property(None, None)
    WindowBeingRemoved = property(None, None)
    X = property(None, None)
    Y = property(None, None)
# end of class SplitterEvent

#-- end-splitter --#
#-- begin-collpane --#
CP_DEFAULT_STYLE = 0
CP_NO_TLW_RESIZE = 0
wxEVT_COLLAPSIBLEPANE_CHANGED = 0
CollapsiblePaneNameStr = ""

class CollapsiblePane(Control):
    """
    CollapsiblePane()
    CollapsiblePane(parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=CP_DEFAULT_STYLE, validator=DefaultValidator, name=CollapsiblePaneNameStr)
    
    A collapsible pane is a container with an embedded button-like control
    which can be used by the user to collapse or expand the pane's
    contents.
    """

    def __init__(self, *args, **kw):
        """
        CollapsiblePane()
        CollapsiblePane(parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=CP_DEFAULT_STYLE, validator=DefaultValidator, name=CollapsiblePaneNameStr)
        
        A collapsible pane is a container with an embedded button-like control
        which can be used by the user to collapse or expand the pane's
        contents.
        """

    def Create(self, parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=CP_DEFAULT_STYLE, validator=DefaultValidator, name=CollapsiblePaneNameStr):
        """
        Create(parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=CP_DEFAULT_STYLE, validator=DefaultValidator, name=CollapsiblePaneNameStr) -> bool
        """

    def Collapse(self, collapse=True):
        """
        Collapse(collapse=True)
        
        Collapses or expands the pane window.
        """

    def Expand(self):
        """
        Expand()
        
        Same as calling Collapse(false).
        """

    def GetPane(self):
        """
        GetPane() -> Window
        
        Returns a pointer to the pane window.
        """

    def IsCollapsed(self):
        """
        IsCollapsed() -> bool
        
        Returns true if the pane window is currently hidden.
        """

    def IsExpanded(self):
        """
        IsExpanded() -> bool
        
        Returns true if the pane window is currently shown.
        """
    Pane = property(None, None)
# end of class CollapsiblePane


class CollapsiblePaneEvent(CommandEvent):
    """
    CollapsiblePaneEvent(generator, id, collapsed)
    
    This event class is used for the events generated by
    wxCollapsiblePane.
    """

    def __init__(self, generator, id, collapsed):
        """
        CollapsiblePaneEvent(generator, id, collapsed)
        
        This event class is used for the events generated by
        wxCollapsiblePane.
        """

    def GetCollapsed(self):
        """
        GetCollapsed() -> bool
        
        Returns true if the pane has been collapsed.
        """

    def SetCollapsed(self, collapsed):
        """
        SetCollapsed(collapsed)
        
        Sets this as a collapsed pane event (if collapsed is true) or as an
        expanded pane event (if collapsed is false).
        """
    Collapsed = property(None, None)
# end of class CollapsiblePaneEvent


EVT_COLLAPSIBLEPANE_CHANGED = wx.PyEventBinder( wxEVT_COLLAPSIBLEPANE_CHANGED )

# deprecated wxEVT alias
wxEVT_COMMAND_COLLPANE_CHANGED  = wxEVT_COLLAPSIBLEPANE_CHANGED
#-- end-collpane --#
#-- begin-statline --#
StaticLineNameStr = ""

class StaticLine(Control):
    """
    StaticLine()
    StaticLine(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=LI_HORIZONTAL, name=StaticLineNameStr)
    
    A static line is just a line which may be used in a dialog to separate
    the groups of controls.
    """

    def __init__(self, *args, **kw):
        """
        StaticLine()
        StaticLine(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=LI_HORIZONTAL, name=StaticLineNameStr)
        
        A static line is just a line which may be used in a dialog to separate
        the groups of controls.
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=LI_HORIZONTAL, name=StaticLineNameStr):
        """
        Create(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=LI_HORIZONTAL, name=StaticLineNameStr) -> bool
        
        Creates the static line for two-step construction.
        """

    def IsVertical(self):
        """
        IsVertical() -> bool
        
        Returns true if the line is vertical, false if horizontal.
        """

    @staticmethod
    def GetDefaultSize():
        """
        GetDefaultSize() -> int
        
        This static function returns the size which will be given to the
        smaller dimension of the static line, i.e.
        """
# end of class StaticLine

#-- end-statline --#
#-- begin-textcompleter --#

class TextCompleter(object):
    """
    Base class for custom text completer objects.
    """

    def Start(self, prefix):
        """
        Start(prefix) -> bool
        
        Function called to start iteration over the completions for the given
        prefix.
        """

    def GetNext(self):
        """
        GetNext() -> String
        
        Called to retrieve the next completion.
        """
    Next = property(None, None)
# end of class TextCompleter


class TextCompleterSimple(TextCompleter):
    """
    A simpler base class for custom completer objects.
    """

    def GetCompletions(self, prefix, res):
        """
        GetCompletions(prefix, res)
        
        Pure virtual method returning all possible completions for the given
        prefix.
        """
# end of class TextCompleterSimple

#-- end-textcompleter --#
#-- begin-textentry --#

class TextEntry(object):
    """
    Common base class for single line text entry fields.
    """

    def SetMargins(self, *args, **kw):
        """
        SetMargins(pt) -> bool
        SetMargins(left, top=-1) -> bool
        
        Attempts to set the control margins.
        """

    def AppendText(self, text):
        """
        AppendText(text)
        
        Appends the text to the end of the text control.
        """

    def AutoComplete(self, *args, **kw):
        """
        AutoComplete(choices) -> bool
        AutoComplete(completer) -> bool
        
        Call this function to enable auto-completion of the text typed in a
        single-line text control using the given choices.
        """

    def AutoCompleteFileNames(self):
        """
        AutoCompleteFileNames() -> bool
        
        Call this function to enable auto-completion of the text typed in a
        single-line text control using all valid file system paths.
        """

    def AutoCompleteDirectories(self):
        """
        AutoCompleteDirectories() -> bool
        
        Call this function to enable auto-completion of the text using the
        file system directories.
        """

    def CanCopy(self):
        """
        CanCopy() -> bool
        
        Returns true if the selection can be copied to the clipboard.
        """

    def CanCut(self):
        """
        CanCut() -> bool
        
        Returns true if the selection can be cut to the clipboard.
        """

    def CanPaste(self):
        """
        CanPaste() -> bool
        
        Returns true if the contents of the clipboard can be pasted into the
        text control.
        """

    def CanRedo(self):
        """
        CanRedo() -> bool
        
        Returns true if there is a redo facility available and the last
        operation can be redone.
        """

    def CanUndo(self):
        """
        CanUndo() -> bool
        
        Returns true if there is an undo facility available and the last
        operation can be undone.
        """

    def ChangeValue(self, value):
        """
        ChangeValue(value)
        
        Sets the new text control value.
        """

    def Clear(self):
        """
        Clear()
        
        Clears the text in the control.
        """

    def Copy(self):
        """
        Copy()
        
        Copies the selected text to the clipboard.
        """

    def Cut(self):
        """
        Cut()
        
        Copies the selected text to the clipboard and removes it from the
        control.
        """

    def GetInsertionPoint(self):
        """
        GetInsertionPoint() -> long
        
        Returns the insertion point, or cursor, position.
        """

    def GetLastPosition(self):
        """
        GetLastPosition() -> TextPos
        
        Returns the zero based index of the last position in the text control,
        which is equal to the number of characters in the control.
        """

    def GetRange(self, from_, to_):
        """
        GetRange(from_, to_) -> String
        
        Returns the string containing the text starting in the positions from
        and up to to in the control.
        """

    def GetSelection(self):
        """
        GetSelection() -> (from, to)
        
        Gets the current selection span.
        """

    def GetStringSelection(self):
        """
        GetStringSelection() -> String
        
        Gets the text currently selected in the control.
        """

    def GetValue(self):
        """
        GetValue() -> String
        
        Gets the contents of the control.
        """

    def IsEditable(self):
        """
        IsEditable() -> bool
        
        Returns true if the controls contents may be edited by user (note that
        it always can be changed by the program).
        """

    def IsEmpty(self):
        """
        IsEmpty() -> bool
        
        Returns true if the control is currently empty.
        """

    def Paste(self):
        """
        Paste()
        
        Pastes text from the clipboard to the text item.
        """

    def Redo(self):
        """
        Redo()
        
        If there is a redo facility and the last operation can be redone,
        redoes the last operation.
        """

    def Remove(self, from_, to_):
        """
        Remove(from_, to_)
        
        Removes the text starting at the first given position up to (but not
        including) the character at the last position.
        """

    def Replace(self, from_, to_, value):
        """
        Replace(from_, to_, value)
        
        Replaces the text starting at the first position up to (but not
        including) the character at the last position with the given text.
        """

    def SetEditable(self, editable):
        """
        SetEditable(editable)
        
        Makes the text item editable or read-only, overriding the
        wxTE_READONLY flag.
        """

    def SetInsertionPoint(self, pos):
        """
        SetInsertionPoint(pos)
        
        Sets the insertion point at the given position.
        """

    def SetInsertionPointEnd(self):
        """
        SetInsertionPointEnd()
        
        Sets the insertion point at the end of the text control.
        """

    def SetMaxLength(self, len):
        """
        SetMaxLength(len)
        
        This function sets the maximum number of characters the user can enter
        into the control.
        """

    def SetSelection(self, from_, to_):
        """
        SetSelection(from_, to_)
        
        Selects the text starting at the first position up to (but not
        including) the character at the last position.
        """

    def SelectAll(self):
        """
        SelectAll()
        
        Selects all text in the control.
        """

    def SelectNone(self):
        """
        SelectNone()
        
        Deselects selected text in the control.
        """

    def SetHint(self, hint):
        """
        SetHint(hint) -> bool
        
        Sets a hint shown in an empty unfocused text control.
        """

    def GetHint(self):
        """
        GetHint() -> String
        
        Returns the current hint string.
        """

    def GetMargins(self):
        """
        GetMargins() -> Point
        
        Returns the margins used by the control.
        """

    def SetValue(self, value):
        """
        SetValue(value)
        
        Sets the new text control value.
        """

    def Undo(self):
        """
        Undo()
        
        If there is an undo facility and the last operation can be undone,
        undoes the last operation.
        """

    def WriteText(self, text):
        """
        WriteText(text)
        
        Writes the text into the text control at the current insertion
        position.
        """
    Hint = property(None, None)
    InsertionPoint = property(None, None)
    LastPosition = property(None, None)
    Margins = property(None, None)
    StringSelection = property(None, None)
    Value = property(None, None)
# end of class TextEntry

#-- end-textentry --#
#-- begin-textctrl --#
TE_NO_VSCROLL = 0
TE_READONLY = 0
TE_MULTILINE = 0
TE_PROCESS_TAB = 0
TE_LEFT = 0
TE_CENTER = 0
TE_RIGHT = 0
TE_CENTRE = 0
TE_RICH = 0
TE_PROCESS_ENTER = 0
TE_PASSWORD = 0
TE_AUTO_URL = 0
TE_NOHIDESEL = 0
TE_DONTWRAP = 0
TE_CHARWRAP = 0
TE_WORDWRAP = 0
TE_BESTWRAP = 0
TE_RICH2 = 0
TEXT_TYPE_ANY = 0
TEXT_ALIGNMENT_DEFAULT = 0
TEXT_ALIGNMENT_LEFT = 0
TEXT_ALIGNMENT_CENTRE = 0
TEXT_ALIGNMENT_CENTER = 0
TEXT_ALIGNMENT_RIGHT = 0
TEXT_ALIGNMENT_JUSTIFIED = 0
TEXT_ATTR_TEXT_COLOUR = 0
TEXT_ATTR_BACKGROUND_COLOUR = 0
TEXT_ATTR_FONT_FACE = 0
TEXT_ATTR_FONT_POINT_SIZE = 0
TEXT_ATTR_FONT_PIXEL_SIZE = 0
TEXT_ATTR_FONT_WEIGHT = 0
TEXT_ATTR_FONT_ITALIC = 0
TEXT_ATTR_FONT_UNDERLINE = 0
TEXT_ATTR_FONT_STRIKETHROUGH = 0
TEXT_ATTR_FONT_ENCODING = 0
TEXT_ATTR_FONT_FAMILY = 0
TEXT_ATTR_FONT_SIZE = 0
TEXT_ATTR_FONT = 0
TEXT_ATTR_ALIGNMENT = 0
TEXT_ATTR_LEFT_INDENT = 0
TEXT_ATTR_RIGHT_INDENT = 0
TEXT_ATTR_TABS = 0
TEXT_ATTR_PARA_SPACING_AFTER = 0
TEXT_ATTR_PARA_SPACING_BEFORE = 0
TEXT_ATTR_LINE_SPACING = 0
TEXT_ATTR_CHARACTER_STYLE_NAME = 0
TEXT_ATTR_PARAGRAPH_STYLE_NAME = 0
TEXT_ATTR_LIST_STYLE_NAME = 0
TEXT_ATTR_BULLET_STYLE = 0
TEXT_ATTR_BULLET_NUMBER = 0
TEXT_ATTR_BULLET_TEXT = 0
TEXT_ATTR_BULLET_NAME = 0
TEXT_ATTR_BULLET = 0
TEXT_ATTR_URL = 0
TEXT_ATTR_PAGE_BREAK = 0
TEXT_ATTR_EFFECTS = 0
TEXT_ATTR_OUTLINE_LEVEL = 0
TEXT_ATTR_CHARACTER = 0
TEXT_ATTR_PARAGRAPH = 0
TEXT_ATTR_ALL = 0
TEXT_ATTR_BULLET_STYLE_NONE = 0
TEXT_ATTR_BULLET_STYLE_ARABIC = 0
TEXT_ATTR_BULLET_STYLE_LETTERS_UPPER = 0
TEXT_ATTR_BULLET_STYLE_LETTERS_LOWER = 0
TEXT_ATTR_BULLET_STYLE_ROMAN_UPPER = 0
TEXT_ATTR_BULLET_STYLE_ROMAN_LOWER = 0
TEXT_ATTR_BULLET_STYLE_SYMBOL = 0
TEXT_ATTR_BULLET_STYLE_BITMAP = 0
TEXT_ATTR_BULLET_STYLE_PARENTHESES = 0
TEXT_ATTR_BULLET_STYLE_PERIOD = 0
TEXT_ATTR_BULLET_STYLE_STANDARD = 0
TEXT_ATTR_BULLET_STYLE_RIGHT_PARENTHESIS = 0
TEXT_ATTR_BULLET_STYLE_OUTLINE = 0
TEXT_ATTR_BULLET_STYLE_ALIGN_LEFT = 0
TEXT_ATTR_BULLET_STYLE_ALIGN_RIGHT = 0
TEXT_ATTR_BULLET_STYLE_ALIGN_CENTRE = 0
TEXT_ATTR_BULLET_STYLE_CONTINUATION = 0
TEXT_ATTR_EFFECT_NONE = 0
TEXT_ATTR_EFFECT_CAPITALS = 0
TEXT_ATTR_EFFECT_SMALL_CAPITALS = 0
TEXT_ATTR_EFFECT_STRIKETHROUGH = 0
TEXT_ATTR_EFFECT_DOUBLE_STRIKETHROUGH = 0
TEXT_ATTR_EFFECT_SHADOW = 0
TEXT_ATTR_EFFECT_EMBOSS = 0
TEXT_ATTR_EFFECT_OUTLINE = 0
TEXT_ATTR_EFFECT_ENGRAVE = 0
TEXT_ATTR_EFFECT_SUPERSCRIPT = 0
TEXT_ATTR_EFFECT_SUBSCRIPT = 0
TEXT_ATTR_LINE_SPACING_NORMAL = 0
TEXT_ATTR_LINE_SPACING_HALF = 0
TEXT_ATTR_LINE_SPACING_TWICE = 0
TE_HT_UNKNOWN = 0
TE_HT_BEFORE = 0
TE_HT_ON_TEXT = 0
TE_HT_BELOW = 0
TE_HT_BEYOND = 0
wxEVT_TEXT = 0
wxEVT_TEXT_ENTER = 0
wxEVT_TEXT_URL = 0
wxEVT_TEXT_MAXLEN = 0

class TextAttr(object):
    """
    TextAttr()
    TextAttr(colText, colBack=NullColour, font=NullFont, alignment=TEXT_ALIGNMENT_DEFAULT)
    TextAttr(attr)
    
    wxTextAttr represents the character and paragraph attributes, or
    style, for a range of text in a wxTextCtrl or wxRichTextCtrl.
    """

    def __init__(self, *args, **kw):
        """
        TextAttr()
        TextAttr(colText, colBack=NullColour, font=NullFont, alignment=TEXT_ALIGNMENT_DEFAULT)
        TextAttr(attr)
        
        wxTextAttr represents the character and paragraph attributes, or
        style, for a range of text in a wxTextCtrl or wxRichTextCtrl.
        """

    def GetAlignment(self):
        """
        GetAlignment() -> TextAttrAlignment
        
        Returns the alignment flags.
        """

    def GetBackgroundColour(self):
        """
        GetBackgroundColour() -> Colour
        
        Returns the background colour.
        """

    def GetBulletFont(self):
        """
        GetBulletFont() -> String
        
        Returns a string containing the name of the font associated with the
        bullet symbol.
        """

    def GetBulletName(self):
        """
        GetBulletName() -> String
        
        Returns the standard bullet name, applicable if the bullet style is
        wxTEXT_ATTR_BULLET_STYLE_STANDARD.
        """

    def GetBulletNumber(self):
        """
        GetBulletNumber() -> int
        
        Returns the bullet number.
        """

    def GetBulletStyle(self):
        """
        GetBulletStyle() -> int
        
        Returns the bullet style.
        """

    def GetBulletText(self):
        """
        GetBulletText() -> String
        
        Returns the bullet text, which could be a symbol, or (for example)
        cached outline text.
        """

    def GetCharacterStyleName(self):
        """
        GetCharacterStyleName() -> String
        
        Returns the name of the character style.
        """

    def GetFlags(self):
        """
        GetFlags() -> long
        
        Returns flags indicating which attributes are applicable.
        """

    def GetFont(self):
        """
        GetFont() -> Font
        
        Creates and returns a font specified by the font attributes in the
        wxTextAttr object.
        """

    def GetFontAttributes(self, font, flags=TEXT_ATTR_FONT):
        """
        GetFontAttributes(font, flags=TEXT_ATTR_FONT) -> bool
        
        Gets the font attributes from the given font, using only the
        attributes specified by flags.
        """

    def GetFontEncoding(self):
        """
        GetFontEncoding() -> FontEncoding
        
        Returns the font encoding.
        """

    def GetFontFaceName(self):
        """
        GetFontFaceName() -> String
        
        Returns the font face name.
        """

    def GetFontFamily(self):
        """
        GetFontFamily() -> FontFamily
        
        Returns the font family.
        """

    def GetFontSize(self):
        """
        GetFontSize() -> int
        
        Returns the font size in points.
        """

    def GetFontStyle(self):
        """
        GetFontStyle() -> FontStyle
        
        Returns the font style.
        """

    def GetFontUnderlined(self):
        """
        GetFontUnderlined() -> bool
        
        Returns true if the font is underlined.
        """

    def GetFontWeight(self):
        """
        GetFontWeight() -> FontWeight
        
        Returns the font weight.
        """

    def GetLeftIndent(self):
        """
        GetLeftIndent() -> long
        
        Returns the left indent in tenths of a millimetre.
        """

    def GetLeftSubIndent(self):
        """
        GetLeftSubIndent() -> long
        
        Returns the left sub-indent in tenths of a millimetre.
        """

    def GetLineSpacing(self):
        """
        GetLineSpacing() -> int
        
        Returns the line spacing value, one of wxTextAttrLineSpacing values.
        """

    def GetListStyleName(self):
        """
        GetListStyleName() -> String
        
        Returns the name of the list style.
        """

    def GetOutlineLevel(self):
        """
        GetOutlineLevel() -> int
        
        Returns the outline level.
        """

    def GetParagraphSpacingAfter(self):
        """
        GetParagraphSpacingAfter() -> int
        
        Returns the space in tenths of a millimeter after the paragraph.
        """

    def GetParagraphSpacingBefore(self):
        """
        GetParagraphSpacingBefore() -> int
        
        Returns the space in tenths of a millimeter before the paragraph.
        """

    def GetParagraphStyleName(self):
        """
        GetParagraphStyleName() -> String
        
        Returns the name of the paragraph style.
        """

    def GetRightIndent(self):
        """
        GetRightIndent() -> long
        
        Returns the right indent in tenths of a millimeter.
        """

    def GetTabs(self):
        """
        GetTabs() -> ArrayInt
        
        Returns an array of tab stops, each expressed in tenths of a
        millimeter.
        """

    def GetTextColour(self):
        """
        GetTextColour() -> Colour
        
        Returns the text foreground colour.
        """

    def GetTextEffectFlags(self):
        """
        GetTextEffectFlags() -> int
        
        Returns the text effect bits of interest.
        """

    def GetTextEffects(self):
        """
        GetTextEffects() -> int
        
        Returns the text effects, a bit list of styles.
        """

    def GetURL(self):
        """
        GetURL() -> String
        
        Returns the URL for the content.
        """

    def HasAlignment(self):
        """
        HasAlignment() -> bool
        
        Returns true if the attribute object specifies alignment.
        """

    def HasBackgroundColour(self):
        """
        HasBackgroundColour() -> bool
        
        Returns true if the attribute object specifies a background colour.
        """

    def HasBulletName(self):
        """
        HasBulletName() -> bool
        
        Returns true if the attribute object specifies a standard bullet name.
        """

    def HasBulletNumber(self):
        """
        HasBulletNumber() -> bool
        
        Returns true if the attribute object specifies a bullet number.
        """

    def HasBulletStyle(self):
        """
        HasBulletStyle() -> bool
        
        Returns true if the attribute object specifies a bullet style.
        """

    def HasBulletText(self):
        """
        HasBulletText() -> bool
        
        Returns true if the attribute object specifies bullet text (usually
        specifying a symbol).
        """

    def HasCharacterStyleName(self):
        """
        HasCharacterStyleName() -> bool
        
        Returns true if the attribute object specifies a character style name.
        """

    def HasFlag(self, flag):
        """
        HasFlag(flag) -> bool
        
        Returns true if the flag is present in the attribute object's flag
        bitlist.
        """

    def HasFont(self):
        """
        HasFont() -> bool
        
        Returns true if the attribute object specifies any font attributes.
        """

    def HasFontEncoding(self):
        """
        HasFontEncoding() -> bool
        
        Returns true if the attribute object specifies an encoding.
        """

    def HasFontFaceName(self):
        """
        HasFontFaceName() -> bool
        
        Returns true if the attribute object specifies a font face name.
        """

    def HasFontFamily(self):
        """
        HasFontFamily() -> bool
        
        Returns true if the attribute object specifies a font family.
        """

    def HasFontItalic(self):
        """
        HasFontItalic() -> bool
        
        Returns true if the attribute object specifies italic style.
        """

    def HasFontSize(self):
        """
        HasFontSize() -> bool
        
        Returns true if the attribute object specifies a font point or pixel
        size.
        """

    def HasFontPointSize(self):
        """
        HasFontPointSize() -> bool
        
        Returns true if the attribute object specifies a font point size.
        """

    def HasFontPixelSize(self):
        """
        HasFontPixelSize() -> bool
        
        Returns true if the attribute object specifies a font pixel size.
        """

    def HasFontUnderlined(self):
        """
        HasFontUnderlined() -> bool
        
        Returns true if the attribute object specifies either underlining or
        no underlining.
        """

    def HasFontWeight(self):
        """
        HasFontWeight() -> bool
        
        Returns true if the attribute object specifies font weight (bold,
        light or normal).
        """

    def HasLeftIndent(self):
        """
        HasLeftIndent() -> bool
        
        Returns true if the attribute object specifies a left indent.
        """

    def HasLineSpacing(self):
        """
        HasLineSpacing() -> bool
        
        Returns true if the attribute object specifies line spacing.
        """

    def HasListStyleName(self):
        """
        HasListStyleName() -> bool
        
        Returns true if the attribute object specifies a list style name.
        """

    def HasOutlineLevel(self):
        """
        HasOutlineLevel() -> bool
        
        Returns true if the attribute object specifies an outline level.
        """

    def HasPageBreak(self):
        """
        HasPageBreak() -> bool
        
        Returns true if the attribute object specifies a page break before
        this paragraph.
        """

    def HasParagraphSpacingAfter(self):
        """
        HasParagraphSpacingAfter() -> bool
        
        Returns true if the attribute object specifies spacing after a
        paragraph.
        """

    def HasParagraphSpacingBefore(self):
        """
        HasParagraphSpacingBefore() -> bool
        
        Returns true if the attribute object specifies spacing before a
        paragraph.
        """

    def HasParagraphStyleName(self):
        """
        HasParagraphStyleName() -> bool
        
        Returns true if the attribute object specifies a paragraph style name.
        """

    def HasRightIndent(self):
        """
        HasRightIndent() -> bool
        
        Returns true if the attribute object specifies a right indent.
        """

    def HasTabs(self):
        """
        HasTabs() -> bool
        
        Returns true if the attribute object specifies tab stops.
        """

    def HasTextColour(self):
        """
        HasTextColour() -> bool
        
        Returns true if the attribute object specifies a text foreground
        colour.
        """

    def HasTextEffects(self):
        """
        HasTextEffects() -> bool
        
        Returns true if the attribute object specifies text effects.
        """

    def HasURL(self):
        """
        HasURL() -> bool
        
        Returns true if the attribute object specifies a URL.
        """

    def IsCharacterStyle(self):
        """
        IsCharacterStyle() -> bool
        
        Returns true if the object represents a character style, that is, the
        flags specify a font or a text background or foreground colour.
        """

    def IsDefault(self):
        """
        IsDefault() -> bool
        
        Returns false if we have any attributes set, true otherwise.
        """

    def IsParagraphStyle(self):
        """
        IsParagraphStyle() -> bool
        
        Returns true if the object represents a paragraph style, that is, the
        flags specify alignment, indentation, tabs, paragraph spacing, or
        bullet style.
        """

    def SetAlignment(self, alignment):
        """
        SetAlignment(alignment)
        
        Sets the paragraph alignment.
        """

    def SetBackgroundColour(self, colBack):
        """
        SetBackgroundColour(colBack)
        
        Sets the background colour.
        """

    def SetBulletFont(self, font):
        """
        SetBulletFont(font)
        
        Sets the name of the font associated with the bullet symbol.
        """

    def SetBulletName(self, name):
        """
        SetBulletName(name)
        
        Sets the standard bullet name, applicable if the bullet style is
        wxTEXT_ATTR_BULLET_STYLE_STANDARD.
        """

    def SetBulletNumber(self, n):
        """
        SetBulletNumber(n)
        
        Sets the bullet number.
        """

    def SetBulletStyle(self, style):
        """
        SetBulletStyle(style)
        
        Sets the bullet style.
        """

    def SetBulletText(self, text):
        """
        SetBulletText(text)
        
        Sets the bullet text, which could be a symbol, or (for example) cached
        outline text.
        """

    def SetCharacterStyleName(self, name):
        """
        SetCharacterStyleName(name)
        
        Sets the character style name.
        """

    def SetFlags(self, flags):
        """
        SetFlags(flags)
        
        Sets the flags determining which styles are being specified.
        """

    def SetFont(self, font, flags=TEXT_ATTR_FONT & ~TEXT_ATTR_FONT_PIXEL_SIZE):
        """
        SetFont(font, flags=TEXT_ATTR_FONT & ~TEXT_ATTR_FONT_PIXEL_SIZE)
        
        Sets the attributes for the given font.
        """

    def SetFontEncoding(self, encoding):
        """
        SetFontEncoding(encoding)
        
        Sets the font encoding.
        """

    def SetFontFaceName(self, faceName):
        """
        SetFontFaceName(faceName)
        
        Sets the font face name.
        """

    def SetFontFamily(self, family):
        """
        SetFontFamily(family)
        
        Sets the font family.
        """

    def SetFontSize(self, pointSize):
        """
        SetFontSize(pointSize)
        
        Sets the font size in points.
        """

    def SetFontPointSize(self, pointSize):
        """
        SetFontPointSize(pointSize)
        
        Sets the font size in points.
        """

    def SetFontPixelSize(self, pixelSize):
        """
        SetFontPixelSize(pixelSize)
        
        Sets the font size in pixels.
        """

    def SetFontStyle(self, fontStyle):
        """
        SetFontStyle(fontStyle)
        
        Sets the font style (normal, italic or slanted).
        """

    def SetFontUnderlined(self, underlined):
        """
        SetFontUnderlined(underlined)
        
        Sets the font underlining.
        """

    def SetFontWeight(self, fontWeight):
        """
        SetFontWeight(fontWeight)
        
        Sets the font weight.
        """

    def SetLeftIndent(self, indent, subIndent=0):
        """
        SetLeftIndent(indent, subIndent=0)
        
        Sets the left indent and left subindent in tenths of a millimetre.
        """

    def SetLineSpacing(self, spacing):
        """
        SetLineSpacing(spacing)
        
        Sets the line spacing.
        """

    def SetListStyleName(self, name):
        """
        SetListStyleName(name)
        
        Sets the list style name.
        """

    def SetOutlineLevel(self, level):
        """
        SetOutlineLevel(level)
        
        Specifies the outline level.
        """

    def SetPageBreak(self, pageBreak=True):
        """
        SetPageBreak(pageBreak=True)
        
        Specifies a page break before this paragraph.
        """

    def SetParagraphSpacingAfter(self, spacing):
        """
        SetParagraphSpacingAfter(spacing)
        
        Sets the spacing after a paragraph, in tenths of a millimetre.
        """

    def SetParagraphSpacingBefore(self, spacing):
        """
        SetParagraphSpacingBefore(spacing)
        
        Sets the spacing before a paragraph, in tenths of a millimetre.
        """

    def SetParagraphStyleName(self, name):
        """
        SetParagraphStyleName(name)
        
        Sets the name of the paragraph style.
        """

    def SetRightIndent(self, indent):
        """
        SetRightIndent(indent)
        
        Sets the right indent in tenths of a millimetre.
        """

    def SetTabs(self, tabs):
        """
        SetTabs(tabs)
        
        Sets the tab stops, expressed in tenths of a millimetre.
        """

    def SetTextColour(self, colText):
        """
        SetTextColour(colText)
        
        Sets the text foreground colour.
        """

    def SetTextEffectFlags(self, flags):
        """
        SetTextEffectFlags(flags)
        
        Sets the text effect bits of interest.
        """

    def SetTextEffects(self, effects):
        """
        SetTextEffects(effects)
        
        Sets the text effects, a bit list of styles.
        """

    def SetURL(self, url):
        """
        SetURL(url)
        
        Sets the URL for the content.
        """

    def Apply(self, style, compareWith=None):
        """
        Apply(style, compareWith=None) -> bool
        
        Applies the attributes in style to the original object, but not those
        attributes from style that are the same as those in compareWith (if
        passed).
        """

    def Merge(self, *args, **kw):
        """
        Merge(overlay)
        Merge(base, overlay) -> TextAttr
        
        Copies all defined/valid properties from overlay to current object.
        """

    def EqPartial(self, attr, weakTest=True):
        """
        EqPartial(attr, weakTest=True) -> bool
        
        Partial equality test.
        """
    Alignment = property(None, None)
    BackgroundColour = property(None, None)
    BulletFont = property(None, None)
    BulletName = property(None, None)
    BulletNumber = property(None, None)
    BulletStyle = property(None, None)
    BulletText = property(None, None)
    CharacterStyleName = property(None, None)
    Flags = property(None, None)
    Font = property(None, None)
    FontEncoding = property(None, None)
    FontFaceName = property(None, None)
    FontFamily = property(None, None)
    FontSize = property(None, None)
    FontStyle = property(None, None)
    FontUnderlined = property(None, None)
    FontWeight = property(None, None)
    LeftIndent = property(None, None)
    LeftSubIndent = property(None, None)
    LineSpacing = property(None, None)
    ListStyleName = property(None, None)
    OutlineLevel = property(None, None)
    ParagraphSpacingAfter = property(None, None)
    ParagraphSpacingBefore = property(None, None)
    ParagraphStyleName = property(None, None)
    RightIndent = property(None, None)
    Tabs = property(None, None)
    TextColour = property(None, None)
    TextEffectFlags = property(None, None)
    TextEffects = property(None, None)
    URL = property(None, None)
# end of class TextAttr

TextCtrlNameStr = ""

class TextCtrl(Control, TextEntry):
    """
    TextCtrl()
    TextCtrl(parent, id=ID_ANY, value=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=TextCtrlNameStr)
    
    A text control allows text to be displayed and edited.
    """

    def __init__(self, *args, **kw):
        """
        TextCtrl()
        TextCtrl(parent, id=ID_ANY, value=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=TextCtrlNameStr)
        
        A text control allows text to be displayed and edited.
        """

    def Create(self, parent, id=ID_ANY, value=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=TextCtrlNameStr):
        """
        Create(parent, id=ID_ANY, value=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=TextCtrlNameStr) -> bool
        
        Creates the text control for two-step construction.
        """

    def DiscardEdits(self):
        """
        DiscardEdits()
        
        Resets the internal modified flag as if the current changes had been
        saved.
        """

    def EmulateKeyPress(self, event):
        """
        EmulateKeyPress(event) -> bool
        
        This function inserts into the control the character which would have
        been inserted if the given key event had occurred in the text control.
        """

    def GetDefaultStyle(self):
        """
        GetDefaultStyle() -> TextAttr
        
        Returns the style currently used for the new text.
        """

    def GetLineLength(self, lineNo):
        """
        GetLineLength(lineNo) -> int
        
        Gets the length of the specified line, not including any trailing
        newline character(s).
        """

    def GetLineText(self, lineNo):
        """
        GetLineText(lineNo) -> String
        
        Returns the contents of a given line in the text control, not
        including any trailing newline character(s).
        """

    def GetNumberOfLines(self):
        """
        GetNumberOfLines() -> int
        
        Returns the number of lines in the text control buffer.
        """

    def GetStyle(self, position, style):
        """
        GetStyle(position, style) -> bool
        
        Returns the style at this position in the text control.
        """

    def HitTestPos(self, pt):
        """
        HitTestPos(pt) -> (TextCtrlHitTestResult, pos)
        
        Finds the position of the character at the specified point.
        """

    def HitTest(self, pt):
        """
        HitTest(pt) -> (TextCtrlHitTestResult, col, row)
        
        Finds the row and column of the character at the specified point.
        """

    def IsModified(self):
        """
        IsModified() -> bool
        
        Returns true if the text has been modified by user.
        """

    def IsMultiLine(self):
        """
        IsMultiLine() -> bool
        
        Returns true if this is a multi line edit control and false otherwise.
        """

    def IsSingleLine(self):
        """
        IsSingleLine() -> bool
        
        Returns true if this is a single line edit control and false
        otherwise.
        """

    def LoadFile(self, filename, fileType=TEXT_TYPE_ANY):
        """
        LoadFile(filename, fileType=TEXT_TYPE_ANY) -> bool
        
        Loads and displays the named file, if it exists.
        """

    def MarkDirty(self):
        """
        MarkDirty()
        
        Mark text as modified (dirty).
        """

    def PositionToXY(self, pos):
        """
        PositionToXY(pos) -> (bool, x, y)
        
        Converts given position to a zero-based column, line number pair.
        """

    def PositionToCoords(self, pos):
        """
        PositionToCoords(pos) -> Point
        
        Converts given text position to client coordinates in pixels.
        """

    def SaveFile(self, filename=EmptyString, fileType=TEXT_TYPE_ANY):
        """
        SaveFile(filename=EmptyString, fileType=TEXT_TYPE_ANY) -> bool
        
        Saves the contents of the control in a text file.
        """

    def SetDefaultStyle(self, style):
        """
        SetDefaultStyle(style) -> bool
        
        Changes the default style to use for the new text which is going to be
        added to the control using WriteText() or AppendText().
        """

    def SetModified(self, modified):
        """
        SetModified(modified)
        
        Marks the control as being modified by the user or not.
        """

    def SetStyle(self, start, end, style):
        """
        SetStyle(start, end, style) -> bool
        
        Changes the style of the given range.
        """

    def ShowPosition(self, pos):
        """
        ShowPosition(pos)
        
        Makes the line containing the given position visible.
        """

    def XYToPosition(self, x, y):
        """
        XYToPosition(x, y) -> long
        
        Converts the given zero based column and line number to a position.
        """

    def MacCheckSpelling(self, check):
        """
        MacCheckSpelling(check)
        
        Turn on the native spell checking for the text widget on
        OSX.  Ignored on other platforms.
        """

    def ShowNativeCaret(self, show=True):
        """
        ShowNativeCaret(show=True) -> bool
        
        Turn on the widget's native caret on Windows.
        Ignored on other platforms.
        """

    def HideNativeCaret(self):
        """
        HideNativeCaret() -> bool
        
        Turn off the widget's native caret on Windows.
        Ignored on other platforms.
        """
    DefaultStyle = property(None, None)
    NumberOfLines = property(None, None)
# end of class TextCtrl


class TextUrlEvent(CommandEvent):
    """
    TextUrlEvent(winid, evtMouse, start, end)
    TextUrlEvent(event)
    """

    def __init__(self, *args, **kw):
        """
        TextUrlEvent(winid, evtMouse, start, end)
        TextUrlEvent(event)
        """

    def GetMouseEvent(self):
        """
        GetMouseEvent() -> MouseEvent
        """

    def GetURLStart(self):
        """
        GetURLStart() -> long
        """

    def GetURLEnd(self):
        """
        GetURLEnd() -> long
        """

    def Clone(self):
        """
        Clone() -> Event
        
        Returns a copy of the event.
        """
    MouseEvent = property(None, None)
    URLEnd = property(None, None)
    URLStart = property(None, None)
# end of class TextUrlEvent


EVT_TEXT        = wx.PyEventBinder( wxEVT_TEXT, 1)
EVT_TEXT_ENTER  = wx.PyEventBinder( wxEVT_TEXT_ENTER, 1)
EVT_TEXT_URL    = wx.PyEventBinder( wxEVT_TEXT_URL, 1)
EVT_TEXT_MAXLEN = wx.PyEventBinder( wxEVT_TEXT_MAXLEN, 1)
EVT_TEXT_CUT    = wx.PyEventBinder( wxEVT_TEXT_CUT )
EVT_TEXT_COPY   = wx.PyEventBinder( wxEVT_TEXT_COPY )
EVT_TEXT_PASTE  = wx.PyEventBinder( wxEVT_TEXT_PASTE )

# deprecated wxEVT aliases
wxEVT_COMMAND_TEXT_UPDATED   = wxEVT_TEXT
wxEVT_COMMAND_TEXT_ENTER     = wxEVT_TEXT_ENTER
wxEVT_COMMAND_TEXT_URL       = wxEVT_TEXT_URL
wxEVT_COMMAND_TEXT_MAXLEN    = wxEVT_TEXT_MAXLEN
wxEVT_COMMAND_TEXT_CUT       = wxEVT_TEXT_CUT
wxEVT_COMMAND_TEXT_COPY      = wxEVT_TEXT_COPY
wxEVT_COMMAND_TEXT_PASTE     = wxEVT_TEXT_PASTE
#-- end-textctrl --#
#-- begin-combobox --#
ComboBoxNameStr = ""

class ComboBox(Control, ItemContainer, TextEntry):
    """
    ComboBox()
    ComboBox(parent, id=ID_ANY, value=EmptyString, pos=DefaultPosition, size=DefaultSize, choices=[], style=0, validator=DefaultValidator, name=ComboBoxNameStr)
    
    A combobox is like a combination of an edit control and a listbox.
    """

    def __init__(self, *args, **kw):
        """
        ComboBox()
        ComboBox(parent, id=ID_ANY, value=EmptyString, pos=DefaultPosition, size=DefaultSize, choices=[], style=0, validator=DefaultValidator, name=ComboBoxNameStr)
        
        A combobox is like a combination of an edit control and a listbox.
        """

    def Create(self, parent, id=ID_ANY, value=EmptyString, pos=DefaultPosition, size=DefaultSize, choices=[], style=0, validator=DefaultValidator, name=ComboBoxNameStr):
        """
        Create(parent, id=ID_ANY, value=EmptyString, pos=DefaultPosition, size=DefaultSize, choices=[], style=0, validator=DefaultValidator, name=ComboBoxNameStr) -> bool
        
        Creates the combobox for two-step construction.
        """

    def GetCurrentSelection(self):
        """
        GetCurrentSelection() -> int
        
        Returns the item being selected right now.
        """

    def GetInsertionPoint(self):
        """
        GetInsertionPoint() -> long
        
        Same as wxTextEntry::GetInsertionPoint().
        """

    def IsListEmpty(self):
        """
        IsListEmpty() -> bool
        
        Returns true if the list of combobox choices is empty.
        """

    def IsTextEmpty(self):
        """
        IsTextEmpty() -> bool
        
        Returns true if the text of the combobox is empty.
        """

    def SetSelection(self, *args, **kw):
        """
        SetSelection(from_, to_)
        SetSelection(n)
        
        Same as wxTextEntry::SetSelection().
        """

    def SetTextSelection(self, from_, to_):
        """
        SetTextSelection(from_, to_)
        
        Same as wxTextEntry::SetSelection().
        """

    def SetValue(self, text):
        """
        SetValue(text)
        
        Sets the text for the combobox text field.
        """

    def Popup(self):
        """
        Popup()
        
        Shows the list box portion of the combo box.
        """

    def Dismiss(self):
        """
        Dismiss()
        
        Hides the list box portion of the combo box.
        """

    def GetSelection(self):
        """
        GetSelection() -> int
        
        Returns the index of the selected item or wxNOT_FOUND if no item is
        selected.
        """

    def GetTextSelection(self):
        """
        GetTextSelection() -> (from, to)
        
        Gets the current selection span.
        """

    def FindString(self, string, caseSensitive=False):
        """
        FindString(string, caseSensitive=False) -> int
        
        Finds an item whose label matches the given string.
        """

    def GetString(self, n):
        """
        GetString(n) -> String
        
        Returns the label of the item with the given index.
        """

    def GetStringSelection(self):
        """
        GetStringSelection() -> String
        
        Gets the text currently selected in the control.
        """

    def SetString(self, n, text):
        """
        SetString(n, text)
        
        Changes the text of the specified combobox item.
        """

    def GetCount(self):
        """
        GetCount() -> unsignedint
        
        Returns the number of items in the control.
        """

    SetMark = wx.deprecated(SetTextSelection, 'Use SetTextSelection instead.')

    GetMark = wx.deprecated(GetTextSelection, 'Use GetTextSelection instead.')
    Count = property(None, None)
    CurrentSelection = property(None, None)
    InsertionPoint = property(None, None)
    Selection = property(None, None)
    StringSelection = property(None, None)
# end of class ComboBox

#-- end-combobox --#
#-- begin-checkbox --#
CHK_2STATE = 0
CHK_3STATE = 0
CHK_ALLOW_3RD_STATE_FOR_USER = 0
CHK_UNCHECKED = 0
CHK_CHECKED = 0
CHK_UNDETERMINED = 0
CheckBoxNameStr = ""

class CheckBox(Control):
    """
    CheckBox()
    CheckBox(parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=CheckBoxNameStr)
    
    A checkbox is a labelled box which by default is either on (checkmark
    is visible) or off (no checkmark).
    """

    def __init__(self, *args, **kw):
        """
        CheckBox()
        CheckBox(parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=CheckBoxNameStr)
        
        A checkbox is a labelled box which by default is either on (checkmark
        is visible) or off (no checkmark).
        """

    def Create(self, parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=CheckBoxNameStr):
        """
        Create(parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=CheckBoxNameStr) -> bool
        
        Creates the checkbox for two-step construction.
        """

    def GetValue(self):
        """
        GetValue() -> bool
        
        Gets the state of a 2-state checkbox.
        """

    def Get3StateValue(self):
        """
        Get3StateValue() -> CheckBoxState
        
        Gets the state of a 3-state checkbox.
        """

    def Is3State(self):
        """
        Is3State() -> bool
        
        Returns whether or not the checkbox is a 3-state checkbox.
        """

    def Is3rdStateAllowedForUser(self):
        """
        Is3rdStateAllowedForUser() -> bool
        
        Returns whether or not the user can set the checkbox to the third
        state.
        """

    def IsChecked(self):
        """
        IsChecked() -> bool
        
        This is just a maybe more readable synonym for GetValue(): just as the
        latter, it returns true if the checkbox is checked and false
        otherwise.
        """

    def SetValue(self, state):
        """
        SetValue(state)
        
        Sets the checkbox to the given state.
        """

    def Set3StateValue(self, state):
        """
        Set3StateValue(state)
        
        Sets the checkbox to the given state.
        """
    Value = property(None, None)
    ThreeStateValue = property(None, None)
# end of class CheckBox

#-- end-checkbox --#
#-- begin-listbox --#
ListBoxNameStr = ""

class ListBox(Control, ItemContainer):
    """
    ListBox()
    ListBox(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, choices=[], style=0, validator=DefaultValidator, name=ListBoxNameStr)
    
    A listbox is used to select one or more of a list of strings.
    """

    def __init__(self, *args, **kw):
        """
        ListBox()
        ListBox(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, choices=[], style=0, validator=DefaultValidator, name=ListBoxNameStr)
        
        A listbox is used to select one or more of a list of strings.
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, choices=[], style=0, validator=DefaultValidator, name=ListBoxNameStr):
        """
        Create(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, choices=[], style=0, validator=DefaultValidator, name=ListBoxNameStr) -> bool
        
        Creates the listbox for two-step construction.
        """

    def Deselect(self, n):
        """
        Deselect(n)
        
        Deselects an item in the list box.
        """

    def SetSelection(self, n):
        """
        SetSelection(n)
        
        Sets the selection to the given item n or removes the selection
        entirely if n == wxNOT_FOUND.
        """

    def GetSelection(self):
        """
        GetSelection() -> int
        
        Returns the index of the selected item or wxNOT_FOUND if no item is
        selected.
        """

    def SetStringSelection(self, *args, **kw):
        """
        SetStringSelection(s, select) -> bool
        SetStringSelection(s) -> bool
        """

    def GetSelections(self):
        """
        GetSelections() -> ArrayInt
        
        Fill an array of ints with the positions of the currently selected
        items.
        """

    def HitTest(self, *args, **kw):
        """
        HitTest(point) -> int
        HitTest(x, y) -> int
        
        Returns the item located at point, or wxNOT_FOUND if there is no item
        located at point.
        """

    def InsertItems(self, items, pos):
        """
        InsertItems(items, pos)
        
        Insert the given number of strings before the specified position.
        """

    def IsSelected(self, n):
        """
        IsSelected(n) -> bool
        
        Determines whether an item is selected.
        """

    def SetFirstItem(self, *args, **kw):
        """
        SetFirstItem(n)
        SetFirstItem(string)
        
        Set the specified item to be the first visible item.
        """

    def EnsureVisible(self, n):
        """
        EnsureVisible(n)
        
        Ensure that the item with the given index is currently shown.
        """

    def IsSorted(self):
        """
        IsSorted() -> bool
        
        Return true if the listbox has wxLB_SORT style.
        """

    def GetCount(self):
        """
        GetCount() -> unsignedint
        
        Returns the number of items in the control.
        """

    def GetString(self, n):
        """
        GetString(n) -> String
        
        Returns the label of the item with the given index.
        """

    def SetString(self, n, string):
        """
        SetString(n, string)
        
        Sets the label for the given item.
        """

    def FindString(self, string, caseSensitive=False):
        """
        FindString(string, caseSensitive=False) -> int
        
        Finds an item whose label matches the given string.
        """
    Count = property(None, None)
    Selection = property(None, None)
    Selections = property(None, None)
# end of class ListBox

#-- end-listbox --#
#-- begin-checklst --#

class CheckListBox(ListBox):
    """
    CheckListBox(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, choices=[], style=0, validator=DefaultValidator, name="listBox")
    CheckListBox()
    
    A wxCheckListBox is like a wxListBox, but allows items to be checked
    or unchecked.
    """

    def __init__(self, *args, **kw):
        """
        CheckListBox(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, choices=[], style=0, validator=DefaultValidator, name="listBox")
        CheckListBox()
        
        A wxCheckListBox is like a wxListBox, but allows items to be checked
        or unchecked.
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, choices=[], style=0, validator=DefaultValidator, name=ListBoxNameStr):
        """
        Create(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, choices=[], style=0, validator=DefaultValidator, name=ListBoxNameStr) -> bool
        """

    def Check(self, item, check=True):
        """
        Check(item, check=True)
        
        Checks the given item.
        """

    def IsChecked(self, item):
        """
        IsChecked(item) -> bool
        
        Returns true if the given item is checked, false otherwise.
        """

    def GetCheckedItems(self):
        """
        GetCheckedItems()
        
        Return a sequence of integers corresponding to the checked items in
        the control, based on :meth:`IsChecked`.
        """

    def GetCheckedStrings(self):
        """
        GetCheckedStrings()
        
        Return a tuple of strings corresponding to the checked
        items of the control, based on :meth:`GetChecked`.
        """

    def SetCheckedItems(self, indexes):
        """
        SetCheckedItems(indexes)
        
        Sets the checked state of items if the index of the item is
        found in the indexes sequence.
        """

    def SetCheckedStrings(self, strings):
        """
        SetCheckedStrings(strings)
        
        Sets the checked state of items if the item's string is found
        in the strings sequence.
        """

    def GetChecked(self):
        """
        
        """

    def SetChecked(self, indexes):
        """
        
        """
    Checked = property(None, None)
    CheckedItems = property(None, None)
    CheckedStrings = property(None, None)
# end of class CheckListBox

#-- end-checklst --#
#-- begin-gauge --#
GA_HORIZONTAL = 0
GA_VERTICAL = 0
GA_SMOOTH = 0
GaugeNameStr = ""

class Gauge(Control):
    """
    Gauge()
    Gauge(parent, id=ID_ANY, range=100, pos=DefaultPosition, size=DefaultSize, style=GA_HORIZONTAL, validator=DefaultValidator, name=GaugeNameStr)
    
    A gauge is a horizontal or vertical bar which shows a quantity (often
    time).
    """

    def __init__(self, *args, **kw):
        """
        Gauge()
        Gauge(parent, id=ID_ANY, range=100, pos=DefaultPosition, size=DefaultSize, style=GA_HORIZONTAL, validator=DefaultValidator, name=GaugeNameStr)
        
        A gauge is a horizontal or vertical bar which shows a quantity (often
        time).
        """

    def Create(self, parent, id=ID_ANY, range=100, pos=DefaultPosition, size=DefaultSize, style=GA_HORIZONTAL, validator=DefaultValidator, name=GaugeNameStr):
        """
        Create(parent, id=ID_ANY, range=100, pos=DefaultPosition, size=DefaultSize, style=GA_HORIZONTAL, validator=DefaultValidator, name=GaugeNameStr) -> bool
        
        Creates the gauge for two-step construction.
        """

    def GetBezelFace(self):
        """
        GetBezelFace() -> int
        
        Returns the width of the 3D bezel face.
        """

    def GetRange(self):
        """
        GetRange() -> int
        
        Returns the maximum position of the gauge.
        """

    def GetShadowWidth(self):
        """
        GetShadowWidth() -> int
        
        Returns the 3D shadow margin width.
        """

    def GetValue(self):
        """
        GetValue() -> int
        
        Returns the current position of the gauge.
        """

    def IsVertical(self):
        """
        IsVertical() -> bool
        
        Returns true if the gauge is vertical (has wxGA_VERTICAL style) and
        false otherwise.
        """

    def Pulse(self):
        """
        Pulse()
        
        Switch the gauge to indeterminate mode (if required) and makes the
        gauge move a bit to indicate the user that some progress has been
        made.
        """

    def SetBezelFace(self, width):
        """
        SetBezelFace(width)
        
        Sets the 3D bezel face width.
        """

    def SetRange(self, range):
        """
        SetRange(range)
        
        Sets the range (maximum value) of the gauge.
        """

    def SetShadowWidth(self, width):
        """
        SetShadowWidth(width)
        
        Sets the 3D shadow width.
        """

    def SetValue(self, pos):
        """
        SetValue(pos)
        
        Sets the position of the gauge.
        """
    BezelFace = property(None, None)
    Range = property(None, None)
    ShadowWidth = property(None, None)
    Value = property(None, None)
# end of class Gauge

#-- end-gauge --#
#-- begin-headercol --#
COL_WIDTH_DEFAULT = 0
COL_WIDTH_AUTOSIZE = 0
COL_RESIZABLE = 0
COL_SORTABLE = 0
COL_REORDERABLE = 0
COL_HIDDEN = 0
COL_DEFAULT_FLAGS = 0

class HeaderColumn(object):
    """
    Represents a column header in controls displaying tabular data such as
    wxDataViewCtrl or wxGrid.
    """

    def GetTitle(self):
        """
        GetTitle() -> String
        
        Get the text shown in the column header.
        """

    def GetBitmap(self):
        """
        GetBitmap() -> Bitmap
        
        Returns the bitmap in the header of the column, if any.
        """

    def GetWidth(self):
        """
        GetWidth() -> int
        
        Returns the current width of the column.
        """

    def GetMinWidth(self):
        """
        GetMinWidth() -> int
        
        Return the minimal column width.
        """

    def GetAlignment(self):
        """
        GetAlignment() -> Alignment
        
        Returns the current column alignment.
        """

    def GetFlags(self):
        """
        GetFlags() -> int
        
        Get the column flags.
        """

    def HasFlag(self, flag):
        """
        HasFlag(flag) -> bool
        
        Return true if the specified flag is currently set for this column.
        """

    def IsResizeable(self):
        """
        IsResizeable() -> bool
        
        Return true if the column can be resized by the user.
        """

    def IsSortable(self):
        """
        IsSortable() -> bool
        
        Returns true if the column can be clicked by user to sort the control
        contents by the field in this column.
        """

    def IsReorderable(self):
        """
        IsReorderable() -> bool
        
        Returns true if the column can be dragged by user to change its order.
        """

    def IsHidden(self):
        """
        IsHidden() -> bool
        
        Returns true if the column is currently hidden.
        """

    def IsShown(self):
        """
        IsShown() -> bool
        
        Returns true if the column is currently shown.
        """

    def IsSortKey(self):
        """
        IsSortKey() -> bool
        
        Returns true if the column is currently used for sorting.
        """

    def IsSortOrderAscending(self):
        """
        IsSortOrderAscending() -> bool
        
        Returns true, if the sort order is ascending.
        """
    Alignment = property(None, None)
    Bitmap = property(None, None)
    Flags = property(None, None)
    MinWidth = property(None, None)
    Title = property(None, None)
    Width = property(None, None)
    Resizeable = property(None, None)
    Sortable = property(None, None)
    Reorderable = property(None, None)
    Hidden = property(None, None)
    Shown = property(None, None)
    SortOrderAscending = property(None, None)
    SortKey = property(None, None)
# end of class HeaderColumn


class SettableHeaderColumn(HeaderColumn):
    """
    Adds methods to set the column attributes to wxHeaderColumn.
    """

    def SetTitle(self, title):
        """
        SetTitle(title)
        
        Set the text to display in the column header.
        """

    def SetBitmap(self, bitmap):
        """
        SetBitmap(bitmap)
        
        Set the bitmap to be displayed in the column header.
        """

    def SetWidth(self, width):
        """
        SetWidth(width)
        
        Set the column width.
        """

    def SetMinWidth(self, minWidth):
        """
        SetMinWidth(minWidth)
        
        Set the minimal column width.
        """

    def SetAlignment(self, align):
        """
        SetAlignment(align)
        
        Set the alignment of the column header.
        """

    def SetFlags(self, flags):
        """
        SetFlags(flags)
        
        Set the column flags.
        """

    def ChangeFlag(self, flag, set):
        """
        ChangeFlag(flag, set)
        
        Set or clear the given flag.
        """

    def SetFlag(self, flag):
        """
        SetFlag(flag)
        
        Set the specified flag for the column.
        """

    def ClearFlag(self, flag):
        """
        ClearFlag(flag)
        
        Clear the specified flag for the column.
        """

    def ToggleFlag(self, flag):
        """
        ToggleFlag(flag)
        
        Toggle the specified flag for the column.
        """

    def SetResizeable(self, resizable):
        """
        SetResizeable(resizable)
        
        Call this to enable or disable interactive resizing of the column by
        the user.
        """

    def SetSortable(self, sortable):
        """
        SetSortable(sortable)
        
        Allow clicking the column to sort the control contents by the field in
        this column.
        """

    def SetReorderable(self, reorderable):
        """
        SetReorderable(reorderable)
        
        Allow changing the column order by dragging it.
        """

    def SetHidden(self, hidden):
        """
        SetHidden(hidden)
        
        Hide or show the column.
        """

    def UnsetAsSortKey(self):
        """
        UnsetAsSortKey()
        
        Don't use this column for sorting.
        """

    def SetSortOrder(self, ascending):
        """
        SetSortOrder(ascending)
        
        Sets this column as the sort key for the associated control.
        """

    def ToggleSortOrder(self):
        """
        ToggleSortOrder()
        
        Inverses the sort order.
        """
    Title = property(None, None)
    Bitmap = property(None, None)
    Width = property(None, None)
    MinWidth = property(None, None)
    Alignment = property(None, None)
    Flags = property(None, None)
    Resizeable = property(None, None)
    Sortable = property(None, None)
    Reorderable = property(None, None)
    Hidden = property(None, None)
# end of class SettableHeaderColumn


class HeaderColumnSimple(SettableHeaderColumn):
    """
    HeaderColumnSimple(title, width=COL_WIDTH_DEFAULT, align=ALIGN_NOT, flags=COL_DEFAULT_FLAGS)
    HeaderColumnSimple(bitmap, width=COL_WIDTH_DEFAULT, align=ALIGN_CENTER, flags=COL_DEFAULT_FLAGS)
    
    Simple container for the information about the column.
    """

    def __init__(self, *args, **kw):
        """
        HeaderColumnSimple(title, width=COL_WIDTH_DEFAULT, align=ALIGN_NOT, flags=COL_DEFAULT_FLAGS)
        HeaderColumnSimple(bitmap, width=COL_WIDTH_DEFAULT, align=ALIGN_CENTER, flags=COL_DEFAULT_FLAGS)
        
        Simple container for the information about the column.
        """

    def SetTitle(self, title):
        """
        SetTitle(title)
        
        Trivial implementations of the base class pure virtual functions.
        """

    def GetTitle(self):
        """
        GetTitle() -> String
        
        Trivial implementations of the base class pure virtual functions.
        """

    def SetBitmap(self, bitmap):
        """
        SetBitmap(bitmap)
        
        Trivial implementations of the base class pure virtual functions.
        """

    def GetBitmap(self):
        """
        GetBitmap() -> Bitmap
        
        Trivial implementations of the base class pure virtual functions.
        """

    def SetWidth(self, width):
        """
        SetWidth(width)
        
        Trivial implementations of the base class pure virtual functions.
        """

    def GetWidth(self):
        """
        GetWidth() -> int
        
        Trivial implementations of the base class pure virtual functions.
        """

    def SetMinWidth(self, minWidth):
        """
        SetMinWidth(minWidth)
        
        Trivial implementations of the base class pure virtual functions.
        """

    def GetMinWidth(self):
        """
        GetMinWidth() -> int
        
        Trivial implementations of the base class pure virtual functions.
        """

    def SetAlignment(self, align):
        """
        SetAlignment(align)
        
        Trivial implementations of the base class pure virtual functions.
        """

    def GetAlignment(self):
        """
        GetAlignment() -> Alignment
        
        Trivial implementations of the base class pure virtual functions.
        """

    def SetFlags(self, flags):
        """
        SetFlags(flags)
        
        Trivial implementations of the base class pure virtual functions.
        """

    def GetFlags(self):
        """
        GetFlags() -> int
        
        Trivial implementations of the base class pure virtual functions.
        """

    def IsSortKey(self):
        """
        IsSortKey() -> bool
        
        Trivial implementations of the base class pure virtual functions.
        """

    def SetSortOrder(self, ascending):
        """
        SetSortOrder(ascending)
        
        Trivial implementations of the base class pure virtual functions.
        """

    def IsSortOrderAscending(self):
        """
        IsSortOrderAscending() -> bool
        
        Trivial implementations of the base class pure virtual functions.
        """
    Alignment = property(None, None)
    Bitmap = property(None, None)
    Flags = property(None, None)
    MinWidth = property(None, None)
    Title = property(None, None)
    Width = property(None, None)
# end of class HeaderColumnSimple

#-- end-headercol --#
#-- begin-headerctrl --#
HD_ALLOW_REORDER = 0
HD_ALLOW_HIDE = 0
HD_DEFAULT_STYLE = 0
wxEVT_HEADER_CLICK = 0
wxEVT_HEADER_RIGHT_CLICK = 0
wxEVT_HEADER_MIDDLE_CLICK = 0
wxEVT_HEADER_DCLICK = 0
wxEVT_HEADER_RIGHT_DCLICK = 0
wxEVT_HEADER_MIDDLE_DCLICK = 0
wxEVT_HEADER_SEPARATOR_DCLICK = 0
wxEVT_HEADER_BEGIN_RESIZE = 0
wxEVT_HEADER_RESIZING = 0
wxEVT_HEADER_END_RESIZE = 0
wxEVT_HEADER_BEGIN_REORDER = 0
wxEVT_HEADER_END_REORDER = 0
wxEVT_HEADER_DRAGGING_CANCELLED = 0
HeaderCtrlNameStr = ""

class HeaderCtrl(Control):
    """
    HeaderCtrl()
    HeaderCtrl(parent, winid=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=HD_DEFAULT_STYLE, name=HeaderCtrlNameStr)
    
    wxHeaderCtrl is the control containing the column headings which is
    usually used for display of tabular data.
    """

    def __init__(self, *args, **kw):
        """
        HeaderCtrl()
        HeaderCtrl(parent, winid=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=HD_DEFAULT_STYLE, name=HeaderCtrlNameStr)
        
        wxHeaderCtrl is the control containing the column headings which is
        usually used for display of tabular data.
        """

    def Create(self, parent, winid=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=HD_DEFAULT_STYLE, name=HeaderCtrlNameStr):
        """
        Create(parent, winid=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=HD_DEFAULT_STYLE, name=HeaderCtrlNameStr) -> bool
        
        Create the header control window.
        """

    def SetColumnCount(self, count):
        """
        SetColumnCount(count)
        
        Set the number of columns in the control.
        """

    def GetColumnCount(self):
        """
        GetColumnCount() -> unsignedint
        
        Return the number of columns in the control.
        """

    def IsEmpty(self):
        """
        IsEmpty() -> bool
        
        Return whether the control has any columns.
        """

    def UpdateColumn(self, idx):
        """
        UpdateColumn(idx)
        
        Update the column with the given index.
        """

    def SetColumnsOrder(self, order):
        """
        SetColumnsOrder(order)
        
        Change the columns display order.
        """

    def GetColumnsOrder(self):
        """
        GetColumnsOrder() -> ArrayInt
        
        Return the array describing the columns display order.
        """

    def GetColumnAt(self, pos):
        """
        GetColumnAt(pos) -> unsignedint
        
        Return the index of the column displayed at the given position.
        """

    def GetColumnPos(self, idx):
        """
        GetColumnPos(idx) -> unsignedint
        
        Get the position at which this column is currently displayed.
        """

    def ResetColumnsOrder(self):
        """
        ResetColumnsOrder()
        
        Reset the columns order to the natural one.
        """

    def ShowColumnsMenu(self, pt, title=""):
        """
        ShowColumnsMenu(pt, title="") -> bool
        
        Show the popup menu allowing the user to show or hide the columns.
        """

    def AddColumnsItems(self, menu, idColumnsBase=0):
        """
        AddColumnsItems(menu, idColumnsBase=0)
        
        Helper function appending the checkable items corresponding to all the
        columns to the given menu.
        """

    def ShowCustomizeDialog(self):
        """
        ShowCustomizeDialog() -> bool
        
        Show the column customization dialog.
        """

    def GetColumnTitleWidth(self, col):
        """
        GetColumnTitleWidth(col) -> int
        
        Returns width needed for given column's title.
        """

    @staticmethod
    def MoveColumnInOrderArray(order, idx, pos):
        """
        MoveColumnInOrderArray(order, idx, pos)
        
        Helper function to manipulate the array of column indices.
        """
    ColumnCount = property(None, None)
    ColumnsOrder = property(None, None)

    def GetColumn(self, idx):
        """
        GetColumn(idx) -> HeaderColumn
        
        Method to be implemented by the derived classes to return the
        information for the given column.
        """

    def UpdateColumnVisibility(self, idx, show):
        """
        UpdateColumnVisibility(idx, show)
        
        Method called when the column visibility is changed by the user.
        """

    def UpdateColumnsOrder(self, order):
        """
        UpdateColumnsOrder(order)
        
        Method called when the columns order is changed in the customization
        dialog.
        """

    def UpdateColumnWidthToFit(self, idx, widthTitle):
        """
        UpdateColumnWidthToFit(idx, widthTitle) -> bool
        
        Method which may be implemented by the derived classes to allow double
        clicking the column separator to resize the column to fit its
        contents.
        """

    def OnColumnCountChanging(self, count):
        """
        OnColumnCountChanging(count)
        
        Can be overridden in the derived class to update internal data
        structures when the number of the columns in the control changes.
        """
# end of class HeaderCtrl


class HeaderCtrlSimple(HeaderCtrl):
    """
    HeaderCtrlSimple()
    HeaderCtrlSimple(parent, winid=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=HD_DEFAULT_STYLE, name=HeaderCtrlNameStr)
    
    wxHeaderCtrlSimple is a concrete header control which can be used
    directly, without inheriting from it as you need to do when using
    wxHeaderCtrl itself.
    """

    def __init__(self, *args, **kw):
        """
        HeaderCtrlSimple()
        HeaderCtrlSimple(parent, winid=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=HD_DEFAULT_STYLE, name=HeaderCtrlNameStr)
        
        wxHeaderCtrlSimple is a concrete header control which can be used
        directly, without inheriting from it as you need to do when using
        wxHeaderCtrl itself.
        """

    def InsertColumn(self, col, idx):
        """
        InsertColumn(col, idx)
        
        Insert the column at the given position.
        """

    def AppendColumn(self, col):
        """
        AppendColumn(col)
        
        Append the column to the end of the control.
        """

    def DeleteColumn(self, idx):
        """
        DeleteColumn(idx)
        
        Delete the column at the given position.
        """

    def ShowColumn(self, idx, show=True):
        """
        ShowColumn(idx, show=True)
        
        Show or hide the column.
        """

    def HideColumn(self, idx):
        """
        HideColumn(idx)
        
        Hide the column with the given index.
        """

    def ShowSortIndicator(self, idx, sortOrder=True):
        """
        ShowSortIndicator(idx, sortOrder=True)
        
        Update the column sort indicator.
        """

    def RemoveSortIndicator(self):
        """
        RemoveSortIndicator()
        
        Remove the sort indicator from the column being used as sort key.
        """

    def GetBestFittingWidth(self, idx):
        """
        GetBestFittingWidth(idx) -> int
        
        This function can be overridden in the classes deriving from this
        control instead of overriding UpdateColumnWidthToFit().
        """
# end of class HeaderCtrlSimple


class HeaderCtrlEvent(NotifyEvent):
    """
    HeaderCtrlEvent(commandType=wxEVT_NULL, winid=0)
    HeaderCtrlEvent(event)
    
    Event class representing the events generated by wxHeaderCtrl.
    """

    def __init__(self, *args, **kw):
        """
        HeaderCtrlEvent(commandType=wxEVT_NULL, winid=0)
        HeaderCtrlEvent(event)
        
        Event class representing the events generated by wxHeaderCtrl.
        """

    def GetColumn(self):
        """
        GetColumn() -> int
        
        Return the index of the column affected by this event.
        """

    def SetColumn(self, col):
        """
        SetColumn(col)
        """

    def GetWidth(self):
        """
        GetWidth() -> int
        
        Return the current width of the column.
        """

    def SetWidth(self, width):
        """
        SetWidth(width)
        """

    def GetNewOrder(self):
        """
        GetNewOrder() -> unsignedint
        
        Return the new order of the column.
        """

    def SetNewOrder(self, order):
        """
        SetNewOrder(order)
        """
    Column = property(None, None)
    NewOrder = property(None, None)
    Width = property(None, None)
# end of class HeaderCtrlEvent


EVT_HEADER_CLICK =              wx.PyEventBinder( wxEVT_HEADER_CLICK )
EVT_HEADER_RIGHT_CLICK =        wx.PyEventBinder( wxEVT_HEADER_RIGHT_CLICK )
EVT_HEADER_MIDDLE_CLICK =       wx.PyEventBinder( wxEVT_HEADER_MIDDLE_CLICK )
EVT_HEADER_DCLICK =             wx.PyEventBinder( wxEVT_HEADER_DCLICK )
EVT_HEADER_RIGHT_DCLICK =       wx.PyEventBinder( wxEVT_HEADER_RIGHT_DCLICK )
EVT_HEADER_MIDDLE_DCLICK =      wx.PyEventBinder( wxEVT_HEADER_MIDDLE_DCLICK )
EVT_HEADER_SEPARATOR_DCLICK =   wx.PyEventBinder( wxEVT_HEADER_SEPARATOR_DCLICK )
EVT_HEADER_BEGIN_RESIZE =       wx.PyEventBinder( wxEVT_HEADER_BEGIN_RESIZE )
EVT_HEADER_RESIZING =           wx.PyEventBinder( wxEVT_HEADER_RESIZING )
EVT_HEADER_END_RESIZE =         wx.PyEventBinder( wxEVT_HEADER_END_RESIZE )
EVT_HEADER_BEGIN_REORDER =      wx.PyEventBinder( wxEVT_HEADER_BEGIN_REORDER )
EVT_HEADER_END_REORDER =        wx.PyEventBinder( wxEVT_HEADER_END_REORDER )
EVT_HEADER_DRAGGING_CANCELLED = wx.PyEventBinder( wxEVT_HEADER_DRAGGING_CANCELLED )

# deprecated wxEVT aliases
wxEVT_COMMAND_HEADER_CLICK               = wxEVT_HEADER_CLICK
wxEVT_COMMAND_HEADER_RIGHT_CLICK         = wxEVT_HEADER_RIGHT_CLICK
wxEVT_COMMAND_HEADER_MIDDLE_CLICK        = wxEVT_HEADER_MIDDLE_CLICK
wxEVT_COMMAND_HEADER_DCLICK              = wxEVT_HEADER_DCLICK
wxEVT_COMMAND_HEADER_RIGHT_DCLICK        = wxEVT_HEADER_RIGHT_DCLICK
wxEVT_COMMAND_HEADER_MIDDLE_DCLICK       = wxEVT_HEADER_MIDDLE_DCLICK
wxEVT_COMMAND_HEADER_SEPARATOR_DCLICK    = wxEVT_HEADER_SEPARATOR_DCLICK
wxEVT_COMMAND_HEADER_BEGIN_RESIZE        = wxEVT_HEADER_BEGIN_RESIZE
wxEVT_COMMAND_HEADER_RESIZING            = wxEVT_HEADER_RESIZING
wxEVT_COMMAND_HEADER_END_RESIZE          = wxEVT_HEADER_END_RESIZE
wxEVT_COMMAND_HEADER_BEGIN_REORDER       = wxEVT_HEADER_BEGIN_REORDER
wxEVT_COMMAND_HEADER_END_REORDER         = wxEVT_HEADER_END_REORDER
wxEVT_COMMAND_HEADER_DRAGGING_CANCELLED  = wxEVT_HEADER_DRAGGING_CANCELLED
#-- end-headerctrl --#
#-- begin-srchctrl --#
wxEVT_SEARCHCTRL_CANCEL_BTN = 0
wxEVT_SEARCHCTRL_SEARCH_BTN = 0
SearchCtrlNameStr = ""

class SearchCtrl(Control):
    """
    SearchCtrl()
    SearchCtrl(parent, id=ID_ANY, value=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=SearchCtrlNameStr)
    
    A search control is a composite control with a search button, a text
    control, and a cancel button.
    """

    def __init__(self, *args, **kw):
        """
        SearchCtrl()
        SearchCtrl(parent, id=ID_ANY, value=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=SearchCtrlNameStr)
        
        A search control is a composite control with a search button, a text
        control, and a cancel button.
        """

    def Create(self, parent, id=ID_ANY, value=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=SearchCtrlNameStr):
        """
        Create(parent, id=ID_ANY, value=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=SearchCtrlNameStr) -> bool
        """

    def GetMenu(self):
        """
        GetMenu() -> Menu
        
        Returns a pointer to the search control's menu object or NULL if there
        is no menu attached.
        """

    def IsSearchButtonVisible(self):
        """
        IsSearchButtonVisible() -> bool
        
        Returns the search button visibility value.
        """

    def IsCancelButtonVisible(self):
        """
        IsCancelButtonVisible() -> bool
        
        Returns the cancel button's visibility state.
        """

    def SetMenu(self, menu):
        """
        SetMenu(menu)
        
        Sets the search control's menu object.
        """

    def ShowCancelButton(self, show):
        """
        ShowCancelButton(show)
        
        Shows or hides the cancel button.
        """

    def ShowSearchButton(self, show):
        """
        ShowSearchButton(show)
        
        Sets the search button visibility value on the search control.
        """

    def SetDescriptiveText(self, text):
        """
        SetDescriptiveText(text)
        
        Set the text to be displayed in the search control when the user has
        not yet typed anything in it.
        """

    def GetDescriptiveText(self):
        """
        GetDescriptiveText() -> String
        
        Return the text displayed when there is not yet any user input.
        """

    def SetSearchBitmap(self, bmp):
        """
        SetSearchBitmap(bmp)
        """

    def SetSearchMenuBitmap(self, bmp):
        """
        SetSearchMenuBitmap(bmp)
        """

    def SetCancelBitmap(self, bmp):
        """
        SetCancelBitmap(bmp)
        """

    def SetMargins(self, *args, **kw):
        """
        SetMargins(pt) -> bool
        SetMargins(left, top=-1) -> bool
        
        Attempts to set the control margins.
        """

    def AppendText(self, text):
        """
        AppendText(text)
        
        Appends the text to the end of the text control.
        """

    def AutoComplete(self, *args, **kw):
        """
        AutoComplete(choices) -> bool
        AutoComplete(completer) -> bool
        
        Call this function to enable auto-completion of the text typed in a
        single-line text control using the given choices.
        """

    def AutoCompleteFileNames(self):
        """
        AutoCompleteFileNames() -> bool
        
        Call this function to enable auto-completion of the text typed in a
        single-line text control using all valid file system paths.
        """

    def AutoCompleteDirectories(self):
        """
        AutoCompleteDirectories() -> bool
        
        Call this function to enable auto-completion of the text using the
        file system directories.
        """

    def CanCopy(self):
        """
        CanCopy() -> bool
        
        Returns true if the selection can be copied to the clipboard.
        """

    def CanCut(self):
        """
        CanCut() -> bool
        
        Returns true if the selection can be cut to the clipboard.
        """

    def CanPaste(self):
        """
        CanPaste() -> bool
        
        Returns true if the contents of the clipboard can be pasted into the
        text control.
        """

    def CanRedo(self):
        """
        CanRedo() -> bool
        
        Returns true if there is a redo facility available and the last
        operation can be redone.
        """

    def CanUndo(self):
        """
        CanUndo() -> bool
        
        Returns true if there is an undo facility available and the last
        operation can be undone.
        """

    def ChangeValue(self, value):
        """
        ChangeValue(value)
        
        Sets the new text control value.
        """

    def Clear(self):
        """
        Clear()
        
        Clears the text in the control.
        """

    def Copy(self):
        """
        Copy()
        
        Copies the selected text to the clipboard.
        """

    def Cut(self):
        """
        Cut()
        
        Copies the selected text to the clipboard and removes it from the
        control.
        """

    def GetInsertionPoint(self):
        """
        GetInsertionPoint() -> long
        
        Returns the insertion point, or cursor, position.
        """

    def GetLastPosition(self):
        """
        GetLastPosition() -> TextPos
        
        Returns the zero based index of the last position in the text control,
        which is equal to the number of characters in the control.
        """

    def GetRange(self, from_, to_):
        """
        GetRange(from_, to_) -> String
        
        Returns the string containing the text starting in the positions from
        and up to to in the control.
        """

    def GetSelection(self):
        """
        GetSelection() -> (from, to)
        
        Gets the current selection span.
        """

    def GetStringSelection(self):
        """
        GetStringSelection() -> String
        
        Gets the text currently selected in the control.
        """

    def GetValue(self):
        """
        GetValue() -> String
        
        Gets the contents of the control.
        """

    def IsEditable(self):
        """
        IsEditable() -> bool
        
        Returns true if the controls contents may be edited by user (note that
        it always can be changed by the program).
        """

    def IsEmpty(self):
        """
        IsEmpty() -> bool
        
        Returns true if the control is currently empty.
        """

    def Paste(self):
        """
        Paste()
        
        Pastes text from the clipboard to the text item.
        """

    def Redo(self):
        """
        Redo()
        
        If there is a redo facility and the last operation can be redone,
        redoes the last operation.
        """

    def Remove(self, from_, to_):
        """
        Remove(from_, to_)
        
        Removes the text starting at the first given position up to (but not
        including) the character at the last position.
        """

    def Replace(self, from_, to_, value):
        """
        Replace(from_, to_, value)
        
        Replaces the text starting at the first position up to (but not
        including) the character at the last position with the given text.
        """

    def SetEditable(self, editable):
        """
        SetEditable(editable)
        
        Makes the text item editable or read-only, overriding the
        wxTE_READONLY flag.
        """

    def SetInsertionPoint(self, pos):
        """
        SetInsertionPoint(pos)
        
        Sets the insertion point at the given position.
        """

    def SetInsertionPointEnd(self):
        """
        SetInsertionPointEnd()
        
        Sets the insertion point at the end of the text control.
        """

    def SetMaxLength(self, len):
        """
        SetMaxLength(len)
        
        This function sets the maximum number of characters the user can enter
        into the control.
        """

    def SetSelection(self, from_, to_):
        """
        SetSelection(from_, to_)
        
        Selects the text starting at the first position up to (but not
        including) the character at the last position.
        """

    def SelectAll(self):
        """
        SelectAll()
        
        Selects all text in the control.
        """

    def SelectNone(self):
        """
        SelectNone()
        
        Deselects selected text in the control.
        """

    def SetHint(self, hint):
        """
        SetHint(hint) -> bool
        
        Sets a hint shown in an empty unfocused text control.
        """

    def GetHint(self):
        """
        GetHint() -> String
        
        Returns the current hint string.
        """

    def GetMargins(self):
        """
        GetMargins() -> Point
        
        Returns the margins used by the control.
        """

    def SetValue(self, value):
        """
        SetValue(value)
        
        Sets the new text control value.
        """

    def Undo(self):
        """
        Undo()
        
        If there is an undo facility and the last operation can be undone,
        undoes the last operation.
        """

    def WriteText(self, text):
        """
        WriteText(text)
        
        Writes the text into the text control at the current insertion
        position.
        """

    def DiscardEdits(self):
        """
        DiscardEdits()
        
        Resets the internal modified flag as if the current changes had been
        saved.
        """

    def EmulateKeyPress(self, event):
        """
        EmulateKeyPress(event) -> bool
        
        This function inserts into the control the character which would have
        been inserted if the given key event had occurred in the text control.
        """

    def GetDefaultStyle(self):
        """
        GetDefaultStyle() -> TextAttr
        
        Returns the style currently used for the new text.
        """

    def GetLineLength(self, lineNo):
        """
        GetLineLength(lineNo) -> int
        
        Gets the length of the specified line, not including any trailing
        newline character(s).
        """

    def GetLineText(self, lineNo):
        """
        GetLineText(lineNo) -> String
        
        Returns the contents of a given line in the text control, not
        including any trailing newline character(s).
        """

    def GetNumberOfLines(self):
        """
        GetNumberOfLines() -> int
        
        Returns the number of lines in the text control buffer.
        """

    def GetStyle(self, position, style):
        """
        GetStyle(position, style) -> bool
        
        Returns the style at this position in the text control.
        """

    def HitTestPos(self, pt):
        """
        HitTestPos(pt) -> (TextCtrlHitTestResult, pos)
        
        Finds the position of the character at the specified point.
        """

    def HitTest(self, pt):
        """
        HitTest(pt) -> (TextCtrlHitTestResult, col, row)
        
        Finds the row and column of the character at the specified point.
        """

    def IsModified(self):
        """
        IsModified() -> bool
        
        Returns true if the text has been modified by user.
        """

    def IsMultiLine(self):
        """
        IsMultiLine() -> bool
        
        Returns true if this is a multi line edit control and false otherwise.
        """

    def IsSingleLine(self):
        """
        IsSingleLine() -> bool
        
        Returns true if this is a single line edit control and false
        otherwise.
        """

    def MarkDirty(self):
        """
        MarkDirty()
        
        Mark text as modified (dirty).
        """

    def PositionToXY(self, pos):
        """
        PositionToXY(pos) -> (bool, x, y)
        
        Converts given position to a zero-based column, line number pair.
        """

    def PositionToCoords(self, pos):
        """
        PositionToCoords(pos) -> Point
        
        Converts given text position to client coordinates in pixels.
        """

    def SetDefaultStyle(self, style):
        """
        SetDefaultStyle(style) -> bool
        
        Changes the default style to use for the new text which is going to be
        added to the control using WriteText() or AppendText().
        """

    def SetModified(self, modified):
        """
        SetModified(modified)
        
        Marks the control as being modified by the user or not.
        """

    def SetStyle(self, start, end, style):
        """
        SetStyle(start, end, style) -> bool
        
        Changes the style of the given range.
        """

    def ShowPosition(self, pos):
        """
        ShowPosition(pos)
        
        Makes the line containing the given position visible.
        """

    def XYToPosition(self, x, y):
        """
        XYToPosition(x, y) -> long
        
        Converts the given zero based column and line number to a position.
        """
    SearchButtonVisible = property(None, None)
    CancelButtonVisible = property(None, None)
    DefaultStyle = property(None, None)
    DescriptiveText = property(None, None)
    Hint = property(None, None)
    InsertionPoint = property(None, None)
    LastPosition = property(None, None)
    Margins = property(None, None)
    Menu = property(None, None)
    NumberOfLines = property(None, None)
    StringSelection = property(None, None)
    Value = property(None, None)
# end of class SearchCtrl


EVT_SEARCHCTRL_CANCEL_BTN = wx.PyEventBinder( wxEVT_SEARCHCTRL_CANCEL_BTN, 1)
EVT_SEARCHCTRL_SEARCH_BTN = wx.PyEventBinder( wxEVT_SEARCHCTRL_SEARCH_BTN, 1)

# deprecated wxEVT aliases
wxEVT_COMMAND_SEARCHCTRL_CANCEL_BTN  = wxEVT_SEARCHCTRL_CANCEL_BTN
wxEVT_COMMAND_SEARCHCTRL_SEARCH_BTN  = wxEVT_SEARCHCTRL_SEARCH_BTN
#-- end-srchctrl --#
#-- begin-radiobox --#
RadioBoxNameStr = ""

class RadioBox(Control, ItemContainerImmutable):
    """
    RadioBox()
    RadioBox(parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, choices=[], majorDimension=0, style=RA_SPECIFY_COLS, validator=DefaultValidator, name=RadioBoxNameStr)
    
    A radio box item is used to select one of number of mutually exclusive
    choices.
    """

    def __init__(self, *args, **kw):
        """
        RadioBox()
        RadioBox(parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, choices=[], majorDimension=0, style=RA_SPECIFY_COLS, validator=DefaultValidator, name=RadioBoxNameStr)
        
        A radio box item is used to select one of number of mutually exclusive
        choices.
        """

    def Create(self, parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, choices=[], majorDimension=0, style=RA_SPECIFY_COLS, validator=DefaultValidator, name=RadioBoxNameStr):
        """
        Create(parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, choices=[], majorDimension=0, style=RA_SPECIFY_COLS, validator=DefaultValidator, name=RadioBoxNameStr) -> bool
        
        Creates the radiobox for two-step construction.
        """

    def EnableItem(self, n, enable=True):
        """
        EnableItem(n, enable=True) -> bool
        
        Enables or disables an individual button in the radiobox.
        """

    def FindString(self, string, bCase=False):
        """
        FindString(string, bCase=False) -> int
        
        Finds a button matching the given string, returning the position if
        found, or wxNOT_FOUND if not found.
        """

    def GetColumnCount(self):
        """
        GetColumnCount() -> unsignedint
        
        Returns the number of columns in the radiobox.
        """

    def GetItemFromPoint(self, pt):
        """
        GetItemFromPoint(pt) -> int
        
        Returns a radio box item under the point, a zero-based item index, or
        wxNOT_FOUND if no item is under the point.
        """

    def GetItemHelpText(self, item):
        """
        GetItemHelpText(item) -> String
        
        Returns the helptext associated with the specified item if any or
        wxEmptyString.
        """

    def GetItemToolTip(self, item):
        """
        GetItemToolTip(item) -> ToolTip
        
        Returns the tooltip associated with the specified item if any or NULL.
        """

    def GetRowCount(self):
        """
        GetRowCount() -> unsignedint
        
        Returns the number of rows in the radiobox.
        """

    def IsItemEnabled(self, n):
        """
        IsItemEnabled(n) -> bool
        
        Returns true if the item is enabled or false if it was disabled using
        Enable(n, false).
        """

    def IsItemShown(self, n):
        """
        IsItemShown(n) -> bool
        
        Returns true if the item is currently shown or false if it was hidden
        using Show(n, false).
        """

    def SetItemHelpText(self, item, helptext):
        """
        SetItemHelpText(item, helptext)
        
        Sets the helptext for an item.
        """

    def SetItemToolTip(self, item, text):
        """
        SetItemToolTip(item, text)
        
        Sets the tooltip text for the specified item in the radio group.
        """

    def SetSelection(self, n):
        """
        SetSelection(n)
        
        Sets the selection to the given item.
        """

    def ShowItem(self, item, show=True):
        """
        ShowItem(item, show=True) -> bool
        
        Shows or hides individual buttons.
        """

    def GetCount(self):
        """
        GetCount() -> unsignedint
        
        Returns the number of items in the control.
        """

    def GetString(self, n):
        """
        GetString(n) -> String
        
        Returns the label of the item with the given index.
        """

    def SetString(self, n, string):
        """
        SetString(n, string)
        
        Sets the label for the given item.
        """

    def GetSelection(self):
        """
        GetSelection() -> int
        
        Returns the index of the selected item or wxNOT_FOUND if no item is
        selected.
        """

    def GetItemLabel(self, n):
        """
        GetItemLabel(self, n) -> string
        
        Return the text of the n'th item in the radio box.
        """

    def SetItemLabel(self, n, text):
        """
        SetItemLabel(self, n, text)
        
        Set the text of the n'th item in the radio box.
        """
    ColumnCount = property(None, None)
    Count = property(None, None)
    RowCount = property(None, None)
    Selection = property(None, None)
# end of class RadioBox

#-- end-radiobox --#
#-- begin-radiobut --#
RadioButtonNameStr = ""

class RadioButton(Control):
    """
    RadioButton()
    RadioButton(parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=RadioButtonNameStr)
    
    A radio button item is a button which usually denotes one of several
    mutually exclusive options.
    """

    def __init__(self, *args, **kw):
        """
        RadioButton()
        RadioButton(parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=RadioButtonNameStr)
        
        A radio button item is a button which usually denotes one of several
        mutually exclusive options.
        """

    def Create(self, parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=RadioButtonNameStr):
        """
        Create(parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=RadioButtonNameStr) -> bool
        
        Creates the choice for two-step construction.
        """

    def GetValue(self):
        """
        GetValue() -> bool
        
        Returns true if the radio button is checked, false otherwise.
        """

    def SetValue(self, value):
        """
        SetValue(value)
        
        Sets the radio button to checked or unchecked status.
        """
    Value = property(None, None)
# end of class RadioButton

#-- end-radiobut --#
#-- begin-slider --#
SL_HORIZONTAL = 0
SL_VERTICAL = 0
SL_TICKS = 0
SL_AUTOTICKS = 0
SL_LEFT = 0
SL_TOP = 0
SL_RIGHT = 0
SL_BOTTOM = 0
SL_BOTH = 0
SL_SELRANGE = 0
SL_INVERSE = 0
SL_MIN_MAX_LABELS = 0
SL_VALUE_LABEL = 0
SL_LABELS = 0
SliderNameStr = ""

class Slider(Control):
    """
    Slider()
    Slider(parent, id=ID_ANY, value=0, minValue=0, maxValue=100, pos=DefaultPosition, size=DefaultSize, style=SL_HORIZONTAL, validator=DefaultValidator, name=SliderNameStr)
    
    A slider is a control with a handle which can be pulled back and forth
    to change the value.
    """

    def __init__(self, *args, **kw):
        """
        Slider()
        Slider(parent, id=ID_ANY, value=0, minValue=0, maxValue=100, pos=DefaultPosition, size=DefaultSize, style=SL_HORIZONTAL, validator=DefaultValidator, name=SliderNameStr)
        
        A slider is a control with a handle which can be pulled back and forth
        to change the value.
        """

    def ClearSel(self):
        """
        ClearSel()
        
        Clears the selection, for a slider with the wxSL_SELRANGE style.
        """

    def ClearTicks(self):
        """
        ClearTicks()
        
        Clears the ticks.
        """

    def Create(self, parent, id=ID_ANY, value=0, minValue=0, maxValue=100, point=DefaultPosition, size=DefaultSize, style=SL_HORIZONTAL, validator=DefaultValidator, name=SliderNameStr):
        """
        Create(parent, id=ID_ANY, value=0, minValue=0, maxValue=100, point=DefaultPosition, size=DefaultSize, style=SL_HORIZONTAL, validator=DefaultValidator, name=SliderNameStr) -> bool
        
        Used for two-step slider construction.
        """

    def GetLineSize(self):
        """
        GetLineSize() -> int
        
        Returns the line size.
        """

    def GetMax(self):
        """
        GetMax() -> int
        
        Gets the maximum slider value.
        """

    def GetMin(self):
        """
        GetMin() -> int
        
        Gets the minimum slider value.
        """

    def GetPageSize(self):
        """
        GetPageSize() -> int
        
        Returns the page size.
        """

    def GetSelEnd(self):
        """
        GetSelEnd() -> int
        
        Returns the selection end point.
        """

    def GetSelStart(self):
        """
        GetSelStart() -> int
        
        Returns the selection start point.
        """

    def GetThumbLength(self):
        """
        GetThumbLength() -> int
        
        Returns the thumb length.
        """

    def GetTickFreq(self):
        """
        GetTickFreq() -> int
        
        Returns the tick frequency.
        """

    def GetValue(self):
        """
        GetValue() -> int
        
        Gets the current slider value.
        """

    def SetLineSize(self, lineSize):
        """
        SetLineSize(lineSize)
        
        Sets the line size for the slider.
        """

    def SetMin(self, minValue):
        """
        SetMin(minValue)
        
        Sets the minimum slider value.
        """

    def SetMax(self, maxValue):
        """
        SetMax(maxValue)
        
        Sets the maximum slider value.
        """

    def SetPageSize(self, pageSize):
        """
        SetPageSize(pageSize)
        
        Sets the page size for the slider.
        """

    def SetRange(self, minValue, maxValue):
        """
        SetRange(minValue, maxValue)
        
        Sets the minimum and maximum slider values.
        """

    def SetSelection(self, startPos, endPos):
        """
        SetSelection(startPos, endPos)
        
        Sets the selection.
        """

    def SetThumbLength(self, len):
        """
        SetThumbLength(len)
        
        Sets the slider thumb length.
        """

    def SetTick(self, tickPos):
        """
        SetTick(tickPos)
        
        Sets a tick position.
        """

    def SetTickFreq(self, n):
        """
        SetTickFreq(n)
        
        Sets the tick mark frequency and position.
        """

    def SetValue(self, value):
        """
        SetValue(value)
        
        Sets the slider position.
        """

    def GetRange(self):
        """
        
        """
    LineSize = property(None, None)
    Max = property(None, None)
    Min = property(None, None)
    PageSize = property(None, None)
    Range = property(None, None)
    SelEnd = property(None, None)
    SelStart = property(None, None)
    ThumbLength = property(None, None)
    TickFreq = property(None, None)
    Value = property(None, None)
# end of class Slider

#-- end-slider --#
#-- begin-spinbutt --#

class SpinButton(Control):
    """
    SpinButton()
    SpinButton(parent, id=-1, pos=DefaultPosition, size=DefaultSize, style=SP_VERTICAL, name="spinButton")
    
    A wxSpinButton has two small up and down (or left and right) arrow
    buttons.
    """

    def __init__(self, *args, **kw):
        """
        SpinButton()
        SpinButton(parent, id=-1, pos=DefaultPosition, size=DefaultSize, style=SP_VERTICAL, name="spinButton")
        
        A wxSpinButton has two small up and down (or left and right) arrow
        buttons.
        """

    def Create(self, parent, id=-1, pos=DefaultPosition, size=DefaultSize, style=SP_VERTICAL, name="wxSpinButton"):
        """
        Create(parent, id=-1, pos=DefaultPosition, size=DefaultSize, style=SP_VERTICAL, name="wxSpinButton") -> bool
        
        Scrollbar creation function called by the spin button constructor.
        """

    def GetMax(self):
        """
        GetMax() -> int
        
        Returns the maximum permissible value.
        """

    def GetMin(self):
        """
        GetMin() -> int
        
        Returns the minimum permissible value.
        """

    def GetValue(self):
        """
        GetValue() -> int
        
        Returns the current spin button value.
        """

    def SetRange(self, min, max):
        """
        SetRange(min, max)
        
        Sets the range of the spin button.
        """

    def SetValue(self, value):
        """
        SetValue(value)
        
        Sets the value of the spin button.
        """

    def GetRange(self):
        """
        
        """

    def SetMin(self, minVal):
        """
        
        """

    def SetMax(self, maxVal):
        """
        
        """

    EVT_SPIN_UP   = wx.PyEventBinder( wxEVT_SPIN_UP, 1)
    EVT_SPIN_DOWN = wx.PyEventBinder( wxEVT_SPIN_DOWN, 1)
    EVT_SPIN      = wx.PyEventBinder( wxEVT_SPIN, 1)
    Max = property(None, None)
    Min = property(None, None)
    Range = property(None, None)
    Value = property(None, None)
# end of class SpinButton


class SpinEvent(NotifyEvent):
    """
    SpinEvent(commandType=wxEVT_NULL, id=0)
    
    This event class is used for the events generated by wxSpinButton and
    wxSpinCtrl.
    """

    def __init__(self, commandType=wxEVT_NULL, id=0):
        """
        SpinEvent(commandType=wxEVT_NULL, id=0)
        
        This event class is used for the events generated by wxSpinButton and
        wxSpinCtrl.
        """

    def GetPosition(self):
        """
        GetPosition() -> int
        
        Retrieve the current spin button or control value.
        """

    def SetPosition(self, pos):
        """
        SetPosition(pos)
        
        Set the value associated with the event.
        """
    Position = property(None, None)
# end of class SpinEvent

#-- end-spinbutt --#
#-- begin-spinctrl --#
wxEVT_SPINCTRL = 0
wxEVT_SPINCTRLDOUBLE = 0

class SpinCtrl(Control):
    """
    SpinCtrl()
    SpinCtrl(parent, id=ID_ANY, value=EmptyString, pos=DefaultPosition, size=DefaultSize, style=SP_ARROW_KEYS, min=0, max=100, initial=0, name="wxSpinCtrl")
    
    wxSpinCtrl combines wxTextCtrl and wxSpinButton in one control.
    """

    def __init__(self, *args, **kw):
        """
        SpinCtrl()
        SpinCtrl(parent, id=ID_ANY, value=EmptyString, pos=DefaultPosition, size=DefaultSize, style=SP_ARROW_KEYS, min=0, max=100, initial=0, name="wxSpinCtrl")
        
        wxSpinCtrl combines wxTextCtrl and wxSpinButton in one control.
        """

    def Create(self, parent, id=ID_ANY, value=EmptyString, pos=DefaultPosition, size=DefaultSize, style=SP_ARROW_KEYS, min=0, max=100, initial=0, name="wxSpinCtrl"):
        """
        Create(parent, id=ID_ANY, value=EmptyString, pos=DefaultPosition, size=DefaultSize, style=SP_ARROW_KEYS, min=0, max=100, initial=0, name="wxSpinCtrl") -> bool
        
        Creation function called by the spin control constructor.
        """

    def GetBase(self):
        """
        GetBase() -> int
        
        Returns the numerical base being currently used, 10 by default.
        """

    def GetMax(self):
        """
        GetMax() -> int
        
        Gets maximal allowable value.
        """

    def GetMin(self):
        """
        GetMin() -> int
        
        Gets minimal allowable value.
        """

    def GetValue(self):
        """
        GetValue() -> int
        
        Gets the value of the spin control.
        """

    def SetBase(self, base):
        """
        SetBase(base) -> bool
        
        Sets the base to use for the numbers in this control.
        """

    def SetRange(self, minVal, maxVal):
        """
        SetRange(minVal, maxVal)
        
        Sets range of allowable values.
        """

    def SetSelection(self, from_, to_):
        """
        SetSelection(from_, to_)
        
        Select the text in the text part of the control between positions from
        (inclusive) and to (exclusive).
        """

    def SetValue(self, *args, **kw):
        """
        SetValue(text)
        SetValue(value)
        
        Sets the value of the spin control.
        """

    def GetRange(self):
        """
        
        """

    def SetMin(self, minVal):
        """
        
        """

    def SetMax(self, maxVal):
        """
        
        """
    Base = property(None, None)
    Max = property(None, None)
    Min = property(None, None)
    Range = property(None, None)
    Value = property(None, None)
# end of class SpinCtrl


class SpinCtrlDouble(Control):
    """
    SpinCtrlDouble()
    SpinCtrlDouble(parent, id=-1, value=EmptyString, pos=DefaultPosition, size=DefaultSize, style=SP_ARROW_KEYS, min=0, max=100, initial=0, inc=1, name=T("wxSpinCtrlDouble"))
    
    wxSpinCtrlDouble combines wxTextCtrl and wxSpinButton in one control
    and displays a real number.
    """

    def __init__(self, *args, **kw):
        """
        SpinCtrlDouble()
        SpinCtrlDouble(parent, id=-1, value=EmptyString, pos=DefaultPosition, size=DefaultSize, style=SP_ARROW_KEYS, min=0, max=100, initial=0, inc=1, name=T("wxSpinCtrlDouble"))
        
        wxSpinCtrlDouble combines wxTextCtrl and wxSpinButton in one control
        and displays a real number.
        """

    def Create(self, parent, id=ID_ANY, value=EmptyString, pos=DefaultPosition, size=DefaultSize, style=SP_ARROW_KEYS, min=0, max=100, initial=0, inc=1, name="wxSpinCtrlDouble"):
        """
        Create(parent, id=ID_ANY, value=EmptyString, pos=DefaultPosition, size=DefaultSize, style=SP_ARROW_KEYS, min=0, max=100, initial=0, inc=1, name="wxSpinCtrlDouble") -> bool
        
        Creation function called by the spin control constructor.
        """

    def GetDigits(self):
        """
        GetDigits() -> unsignedint
        
        Gets the number of digits in the display.
        """

    def GetIncrement(self):
        """
        GetIncrement() -> double
        
        Gets the increment value.
        """

    def GetMax(self):
        """
        GetMax() -> double
        
        Gets maximal allowable value.
        """

    def GetMin(self):
        """
        GetMin() -> double
        
        Gets minimal allowable value.
        """

    def GetValue(self):
        """
        GetValue() -> double
        
        Gets the value of the spin control.
        """

    def SetDigits(self, digits):
        """
        SetDigits(digits)
        
        Sets the number of digits in the display.
        """

    def SetIncrement(self, inc):
        """
        SetIncrement(inc)
        
        Sets the increment value.
        """

    def SetRange(self, minVal, maxVal):
        """
        SetRange(minVal, maxVal)
        
        Sets range of allowable values.
        """

    def SetValue(self, *args, **kw):
        """
        SetValue(text)
        SetValue(value)
        
        Sets the value of the spin control.
        """

    def GetRange(self):
        """
        
        """

    def SetMin(self, minVal):
        """
        
        """

    def SetMax(self, maxVal):
        """
        
        """
    Digits = property(None, None)
    Increment = property(None, None)
    Max = property(None, None)
    Min = property(None, None)
    Range = property(None, None)
    Value = property(None, None)
# end of class SpinCtrlDouble


class SpinDoubleEvent(NotifyEvent):
    """
    SpinDoubleEvent(commandType=wxEVT_NULL, winid=0, value=0)
    SpinDoubleEvent(event)
    
    This event class is used for the events generated by wxSpinCtrlDouble.
    """

    def __init__(self, *args, **kw):
        """
        SpinDoubleEvent(commandType=wxEVT_NULL, winid=0, value=0)
        SpinDoubleEvent(event)
        
        This event class is used for the events generated by wxSpinCtrlDouble.
        """

    def GetValue(self):
        """
        GetValue() -> double
        
        Returns the value associated with this spin control event.
        """

    def SetValue(self, value):
        """
        SetValue(value)
        
        Set the value associated with the event.
        """
    Value = property(None, None)
# end of class SpinDoubleEvent


EVT_SPINCTRL = wx.PyEventBinder( wxEVT_SPINCTRL, 1)
EVT_SPINCTRLDOUBLE = wx.PyEventBinder( wxEVT_SPINCTRLDOUBLE, 1)

# deprecated wxEVT aliases
wxEVT_COMMAND_SPINCTRL_UPDATED        = wxEVT_SPINCTRL
wxEVT_COMMAND_SPINCTRLDOUBLE_UPDATED  = wxEVT_SPINCTRLDOUBLE
#-- end-spinctrl --#
#-- begin-tglbtn --#
wxEVT_TOGGLEBUTTON = 0

class ToggleButton(AnyButton):
    """
    ToggleButton()
    ToggleButton(parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, val=DefaultValidator, name=CheckBoxNameStr)
    
    wxToggleButton is a button that stays pressed when clicked by the
    user.
    """

    def __init__(self, *args, **kw):
        """
        ToggleButton()
        ToggleButton(parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, val=DefaultValidator, name=CheckBoxNameStr)
        
        wxToggleButton is a button that stays pressed when clicked by the
        user.
        """

    def Create(self, parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, val=DefaultValidator, name=CheckBoxNameStr):
        """
        Create(parent, id=ID_ANY, label=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, val=DefaultValidator, name=CheckBoxNameStr) -> bool
        
        Creates the toggle button for two-step construction.
        """

    def GetValue(self):
        """
        GetValue() -> bool
        
        Gets the state of the toggle button.
        """

    def SetValue(self, state):
        """
        SetValue(state)
        
        Sets the toggle button to the given state.
        """
    Value = property(None, None)
# end of class ToggleButton


class BitmapToggleButton(ToggleButton):
    """
    BitmapToggleButton()
    BitmapToggleButton(parent, id=ID_ANY, label=NullBitmap, pos=DefaultPosition, size=DefaultSize, style=0, val=DefaultValidator, name=CheckBoxNameStr)
    
    wxBitmapToggleButton is a wxToggleButton that contains a bitmap
    instead of text.
    """

    def __init__(self, *args, **kw):
        """
        BitmapToggleButton()
        BitmapToggleButton(parent, id=ID_ANY, label=NullBitmap, pos=DefaultPosition, size=DefaultSize, style=0, val=DefaultValidator, name=CheckBoxNameStr)
        
        wxBitmapToggleButton is a wxToggleButton that contains a bitmap
        instead of text.
        """

    def Create(self, parent, id=ID_ANY, label=NullBitmap, pos=DefaultPosition, size=DefaultSize, style=0, val=DefaultValidator, name=CheckBoxNameStr):
        """
        Create(parent, id=ID_ANY, label=NullBitmap, pos=DefaultPosition, size=DefaultSize, style=0, val=DefaultValidator, name=CheckBoxNameStr) -> bool
        
        Create method for two-step construction.
        """

    def GetValue(self):
        """
        GetValue() -> bool
        
        Gets the state of the toggle button.
        """

    def SetValue(self, state):
        """
        SetValue(state)
        
        Sets the toggle button to the given state.
        """
    Value = property(None, None)
# end of class BitmapToggleButton


EVT_TOGGLEBUTTON = PyEventBinder(wxEVT_TOGGLEBUTTON, 1)

# deprecated wxEVT alias
wxEVT_COMMAND_TOGGLEBUTTON_CLICKED   = wxEVT_TOGGLEBUTTON
#-- end-tglbtn --#
#-- begin-scrolbar --#
ScrollBarNameStr = ""

class ScrollBar(Control):
    """
    ScrollBar()
    ScrollBar(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=SB_HORIZONTAL, validator=DefaultValidator, name=ScrollBarNameStr)
    
    A wxScrollBar is a control that represents a horizontal or vertical
    scrollbar.
    """

    def __init__(self, *args, **kw):
        """
        ScrollBar()
        ScrollBar(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=SB_HORIZONTAL, validator=DefaultValidator, name=ScrollBarNameStr)
        
        A wxScrollBar is a control that represents a horizontal or vertical
        scrollbar.
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=SB_HORIZONTAL, validator=DefaultValidator, name=ScrollBarNameStr):
        """
        Create(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=SB_HORIZONTAL, validator=DefaultValidator, name=ScrollBarNameStr) -> bool
        
        Scrollbar creation function called by the scrollbar constructor.
        """

    def GetPageSize(self):
        """
        GetPageSize() -> int
        
        Returns the page size of the scrollbar.
        """

    def GetRange(self):
        """
        GetRange() -> int
        
        Returns the length of the scrollbar.
        """

    def GetThumbPosition(self):
        """
        GetThumbPosition() -> int
        
        Returns the current position of the scrollbar thumb.
        """

    def GetThumbSize(self):
        """
        GetThumbSize() -> int
        
        Returns the thumb or 'view' size.
        """

    def SetScrollbar(self, position, thumbSize, range, pageSize, refresh=True):
        """
        SetScrollbar(position, thumbSize, range, pageSize, refresh=True)
        
        Sets the scrollbar properties.
        """

    def SetThumbPosition(self, viewStart):
        """
        SetThumbPosition(viewStart)
        
        Sets the position of the scrollbar.
        """

    def IsVertical(self):
        """
        IsVertical() -> bool
        
        Returns true for scrollbars that have the vertical style set.
        """
    PageSize = property(None, None)
    Range = property(None, None)
    ThumbPosition = property(None, None)
    ThumbSize = property(None, None)
# end of class ScrollBar

#-- end-scrolbar --#
#-- begin-toolbar --#
TOOL_STYLE_BUTTON = 0
TOOL_STYLE_SEPARATOR = 0
TOOL_STYLE_CONTROL = 0
TB_HORIZONTAL = 0
TB_TOP = 0
TB_VERTICAL = 0
TB_LEFT = 0
TB_3DBUTTONS = 0
TB_FLAT = 0
TB_DOCKABLE = 0
TB_NOICONS = 0
TB_TEXT = 0
TB_NODIVIDER = 0
TB_NOALIGN = 0
TB_HORZ_LAYOUT = 0
TB_HORZ_TEXT = 0
TB_NO_TOOLTIPS = 0
TB_BOTTOM = 0
TB_RIGHT = 0
TB_DEFAULT_STYLE = 0

class ToolBarToolBase(Object):
    """
    ToolBarToolBase(tbar=None, toolid=ID_SEPARATOR, label=EmptyString, bmpNormal=NullBitmap, bmpDisabled=NullBitmap, kind=ITEM_NORMAL, clientData=None, shortHelpString=EmptyString, longHelpString=EmptyString)
    ToolBarToolBase(tbar, control, label)
    
    A toolbar tool represents one item on the toolbar.
    """

    def __init__(self, *args, **kw):
        """
        ToolBarToolBase(tbar=None, toolid=ID_SEPARATOR, label=EmptyString, bmpNormal=NullBitmap, bmpDisabled=NullBitmap, kind=ITEM_NORMAL, clientData=None, shortHelpString=EmptyString, longHelpString=EmptyString)
        ToolBarToolBase(tbar, control, label)
        
        A toolbar tool represents one item on the toolbar.
        """

    def GetId(self):
        """
        GetId() -> int
        """

    def GetControl(self):
        """
        GetControl() -> Control
        """

    def GetToolBar(self):
        """
        GetToolBar() -> ToolBar
        
        Return the toolbar this tool is a member of.
        """

    def IsStretchable(self):
        """
        IsStretchable() -> bool
        """

    def IsButton(self):
        """
        IsButton() -> bool
        """

    def IsControl(self):
        """
        IsControl() -> bool
        """

    def IsSeparator(self):
        """
        IsSeparator() -> bool
        """

    def IsStretchableSpace(self):
        """
        IsStretchableSpace() -> bool
        """

    def GetStyle(self):
        """
        GetStyle() -> int
        """

    def GetKind(self):
        """
        GetKind() -> ItemKind
        """

    def MakeStretchable(self):
        """
        MakeStretchable()
        """

    def IsEnabled(self):
        """
        IsEnabled() -> bool
        """

    def IsToggled(self):
        """
        IsToggled() -> bool
        """

    def CanBeToggled(self):
        """
        CanBeToggled() -> bool
        """

    def GetNormalBitmap(self):
        """
        GetNormalBitmap() -> Bitmap
        """

    def GetDisabledBitmap(self):
        """
        GetDisabledBitmap() -> Bitmap
        """

    def GetBitmap(self):
        """
        GetBitmap() -> Bitmap
        """

    def GetLabel(self):
        """
        GetLabel() -> String
        """

    def GetShortHelp(self):
        """
        GetShortHelp() -> String
        """

    def GetLongHelp(self):
        """
        GetLongHelp() -> String
        """

    def GetClientData(self):
        """
        GetClientData() -> PyUserData
        """

    def Enable(self, enable):
        """
        Enable(enable) -> bool
        """

    def Toggle(self, *args, **kw):
        """
        Toggle(toggle) -> bool
        Toggle()
        """

    def SetToggle(self, toggle):
        """
        SetToggle(toggle) -> bool
        """

    def SetShortHelp(self, help):
        """
        SetShortHelp(help) -> bool
        """

    def SetLongHelp(self, help):
        """
        SetLongHelp(help) -> bool
        """

    def SetNormalBitmap(self, bmp):
        """
        SetNormalBitmap(bmp)
        """

    def SetDisabledBitmap(self, bmp):
        """
        SetDisabledBitmap(bmp)
        """

    def SetLabel(self, label):
        """
        SetLabel(label)
        """

    def SetClientData(self, clientData):
        """
        SetClientData(clientData)
        """

    def Detach(self):
        """
        Detach()
        """

    def Attach(self, tbar):
        """
        Attach(tbar)
        """

    def SetDropdownMenu(self, menu):
        """
        SetDropdownMenu(menu)
        """

    def GetDropdownMenu(self):
        """
        GetDropdownMenu() -> Menu
        """
    Bitmap = property(None, None)
    ClientData = property(None, None)
    Control = property(None, None)
    DisabledBitmap = property(None, None)
    DropdownMenu = property(None, None)
    Id = property(None, None)
    Kind = property(None, None)
    Label = property(None, None)
    LongHelp = property(None, None)
    NormalBitmap = property(None, None)
    ShortHelp = property(None, None)
    Style = property(None, None)
    ToolBar = property(None, None)
# end of class ToolBarToolBase

ToolBarNameStr = ""

class ToolBar(Control):
    """
    ToolBar()
    ToolBar(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=TB_HORIZONTAL, name=ToolBarNameStr)
    
    A toolbar is a bar of buttons and/or other controls usually placed
    below the menu bar in a wxFrame.
    """

    def __init__(self, *args, **kw):
        """
        ToolBar()
        ToolBar(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=TB_HORIZONTAL, name=ToolBarNameStr)
        
        A toolbar is a bar of buttons and/or other controls usually placed
        below the menu bar in a wxFrame.
        """

    def AddTool(self, *args, **kw):
        """
        AddTool(tool) -> ToolBarToolBase
        AddTool(toolId, label, bitmap, shortHelp=EmptyString, kind=ITEM_NORMAL) -> ToolBarToolBase
        AddTool(toolId, label, bitmap, bmpDisabled, kind=ITEM_NORMAL, shortHelpString=EmptyString, longHelpString=EmptyString, clientData=None) -> ToolBarToolBase
        
        Adds a tool to the toolbar.
        """

    def InsertTool(self, *args, **kw):
        """
        InsertTool(pos, toolId, label, bitmap, bmpDisabled=NullBitmap, kind=ITEM_NORMAL, shortHelp=EmptyString, longHelp=EmptyString, clientData=None) -> ToolBarToolBase
        InsertTool(pos, tool) -> ToolBarToolBase
        
        Inserts the tool with the specified attributes into the toolbar at the
        given position.
        """

    def SetMargins(self, *args, **kw):
        """
        SetMargins(x, y)
        SetMargins(size)
        
        Set the values to be used as margins for the toolbar.
        """

    def AddCheckTool(self, toolId, label, bitmap1, bmpDisabled=NullBitmap, shortHelp=EmptyString, longHelp=EmptyString, clientData=None):
        """
        AddCheckTool(toolId, label, bitmap1, bmpDisabled=NullBitmap, shortHelp=EmptyString, longHelp=EmptyString, clientData=None) -> ToolBarToolBase
        
        Adds a new check (or toggle) tool to the toolbar.
        """

    def AddControl(self, control, label=EmptyString):
        """
        AddControl(control, label=EmptyString) -> ToolBarToolBase
        
        Adds any control to the toolbar, typically e.g. a wxComboBox.
        """

    def AddRadioTool(self, toolId, label, bitmap1, bmpDisabled=NullBitmap, shortHelp=EmptyString, longHelp=EmptyString, clientData=None):
        """
        AddRadioTool(toolId, label, bitmap1, bmpDisabled=NullBitmap, shortHelp=EmptyString, longHelp=EmptyString, clientData=None) -> ToolBarToolBase
        
        Adds a new radio tool to the toolbar.
        """

    def AddSeparator(self):
        """
        AddSeparator() -> ToolBarToolBase
        
        Adds a separator for spacing groups of tools.
        """

    def AddStretchableSpace(self):
        """
        AddStretchableSpace() -> ToolBarToolBase
        
        Adds a stretchable space to the toolbar.
        """

    def ClearTools(self):
        """
        ClearTools()
        
        Deletes all the tools in the toolbar.
        """

    def DeleteTool(self, toolId):
        """
        DeleteTool(toolId) -> bool
        
        Removes the specified tool from the toolbar and deletes it.
        """

    def DeleteToolByPos(self, pos):
        """
        DeleteToolByPos(pos) -> bool
        
        This function behaves like DeleteTool() but it deletes the tool at the
        specified position and not the one with the given id.
        """

    def EnableTool(self, toolId, enable):
        """
        EnableTool(toolId, enable)
        
        Enables or disables the tool.
        """

    def FindById(self, id):
        """
        FindById(id) -> ToolBarToolBase
        
        Returns a pointer to the tool identified by id or NULL if no
        corresponding tool is found.
        """

    def FindControl(self, id):
        """
        FindControl(id) -> Control
        
        Returns a pointer to the control identified by id or NULL if no
        corresponding control is found.
        """

    def FindToolForPosition(self, x, y):
        """
        FindToolForPosition(x, y) -> ToolBarToolBase
        
        Finds a tool for the given mouse position.
        """

    def GetMargins(self):
        """
        GetMargins() -> Size
        
        Returns the left/right and top/bottom margins, which are also used for
        inter-toolspacing.
        """

    def GetToolBitmapSize(self):
        """
        GetToolBitmapSize() -> Size
        
        Returns the size of bitmap that the toolbar expects to have.
        """

    def GetToolByPos(self, pos):
        """
        GetToolByPos(pos) -> ToolBarToolBase
        
        Returns a pointer to the tool at ordinal position pos.
        """

    def GetToolClientData(self, toolId):
        """
        GetToolClientData(toolId) -> PyUserData
        
        Get any client data associated with the tool.
        """

    def GetToolEnabled(self, toolId):
        """
        GetToolEnabled(toolId) -> bool
        
        Called to determine whether a tool is enabled (responds to user
        input).
        """

    def GetToolLongHelp(self, toolId):
        """
        GetToolLongHelp(toolId) -> String
        
        Returns the long help for the given tool.
        """

    def GetToolPacking(self):
        """
        GetToolPacking() -> int
        
        Returns the value used for packing tools.
        """

    def GetToolPos(self, toolId):
        """
        GetToolPos(toolId) -> int
        
        Returns the tool position in the toolbar, or wxNOT_FOUND if the tool
        is not found.
        """

    def GetToolSeparation(self):
        """
        GetToolSeparation() -> int
        
        Returns the default separator size.
        """

    def GetToolShortHelp(self, toolId):
        """
        GetToolShortHelp(toolId) -> String
        
        Returns the short help for the given tool.
        """

    def GetToolSize(self):
        """
        GetToolSize() -> Size
        
        Returns the size of a whole button, which is usually larger than a
        tool bitmap because of added 3D effects.
        """

    def GetToolState(self, toolId):
        """
        GetToolState(toolId) -> bool
        
        Gets the on/off state of a toggle tool.
        """

    def GetToolsCount(self):
        """
        GetToolsCount() -> size_t
        
        Returns the number of tools in the toolbar.
        """

    def InsertControl(self, pos, control, label=EmptyString):
        """
        InsertControl(pos, control, label=EmptyString) -> ToolBarToolBase
        
        Inserts the control into the toolbar at the given position.
        """

    def InsertSeparator(self, pos):
        """
        InsertSeparator(pos) -> ToolBarToolBase
        
        Inserts the separator into the toolbar at the given position.
        """

    def InsertStretchableSpace(self, pos):
        """
        InsertStretchableSpace(pos) -> ToolBarToolBase
        
        Inserts a stretchable space at the given position.
        """

    def Realize(self):
        """
        Realize() -> bool
        
        This function should be called after you have added tools.
        """

    def RemoveTool(self, id):
        """
        RemoveTool(id) -> ToolBarToolBase
        
        Removes the given tool from the toolbar but doesn't delete it.
        """

    def SetDropdownMenu(self, id, menu):
        """
        SetDropdownMenu(id, menu) -> bool
        
        Sets the dropdown menu for the tool given by its id.
        """

    def SetToolBitmapSize(self, size):
        """
        SetToolBitmapSize(size)
        
        Sets the default size of each tool bitmap.
        """

    def SetToolClientData(self, id, clientData):
        """
        SetToolClientData(id, clientData)
        
        Sets the client data associated with the tool.
        """

    def SetToolDisabledBitmap(self, id, bitmap):
        """
        SetToolDisabledBitmap(id, bitmap)
        
        Sets the bitmap to be used by the tool with the given ID when the tool
        is in a disabled state.
        """

    def SetToolLongHelp(self, toolId, helpString):
        """
        SetToolLongHelp(toolId, helpString)
        
        Sets the long help for the given tool.
        """

    def SetToolNormalBitmap(self, id, bitmap):
        """
        SetToolNormalBitmap(id, bitmap)
        
        Sets the bitmap to be used by the tool with the given ID.
        """

    def SetToolPacking(self, packing):
        """
        SetToolPacking(packing)
        
        Sets the value used for spacing tools.
        """

    def SetToolSeparation(self, separation):
        """
        SetToolSeparation(separation)
        
        Sets the default separator size.
        """

    def SetToolShortHelp(self, toolId, helpString):
        """
        SetToolShortHelp(toolId, helpString)
        
        Sets the short help for the given tool.
        """

    def ToggleTool(self, toolId, toggle):
        """
        ToggleTool(toolId, toggle)
        
        Toggles a tool on or off.
        """

    def CreateTool(self, *args, **kw):
        """
        CreateTool(toolId, label, bmpNormal, bmpDisabled=NullBitmap, kind=ITEM_NORMAL, clientData=None, shortHelp=EmptyString, longHelp=EmptyString) -> ToolBarToolBase
        CreateTool(control, label) -> ToolBarToolBase
        
        Factory function to create a new toolbar tool.
        """

    def AddSimpleTool(self, toolId, bitmap, shortHelpString="", longHelpString="", isToggle=0):
        """
        Old style method to add a tool to the toolbar.
        """

    def AddLabelTool(self, id, label, bitmap, bmpDisabled=wx.NullBitmap, kind=wx.ITEM_NORMAL, shortHelp="", longHelp="", clientData=None):
        """
        Old style method to add a tool in the toolbar.
        """

    def InsertSimpleTool(self, pos, toolId, bitmap, shortHelpString="", longHelpString="", isToggle=0):
        """
        Old style method to insert a tool in the toolbar.
        """

    def InsertLabelTool(self, pos, id, label, bitmap, bmpDisabled=wx.NullBitmap, kind=wx.ITEM_NORMAL, shortHelp="", longHelp="", clientData=None):
        """
        Old style method to insert a tool in the toolbar.
        """
    Margins = property(None, None)
    ToolBitmapSize = property(None, None)
    ToolPacking = property(None, None)
    ToolSeparation = property(None, None)
    ToolSize = property(None, None)
    ToolsCount = property(None, None)
# end of class ToolBar

#-- end-toolbar --#
#-- begin-infobar --#

class InfoBar(Control):
    """
    InfoBar()
    InfoBar(parent, winid=ID_ANY)
    
    An info bar is a transient window shown at top or bottom of its parent
    window to display non-critical information to the user.
    """

    def __init__(self, *args, **kw):
        """
        InfoBar()
        InfoBar(parent, winid=ID_ANY)
        
        An info bar is a transient window shown at top or bottom of its parent
        window to display non-critical information to the user.
        """

    def SetShowHideEffects(self, showEffect, hideEffect):
        """
        SetShowHideEffects(showEffect, hideEffect)
        
        Set the effects to use when showing and hiding the bar.
        """

    def GetShowEffect(self):
        """
        GetShowEffect() -> ShowEffect
        
        Return the effect currently used for showing the bar.
        """

    def GetHideEffect(self):
        """
        GetHideEffect() -> ShowEffect
        
        Return the effect currently used for hiding the bar.
        """

    def SetEffectDuration(self, duration):
        """
        SetEffectDuration(duration)
        
        Set the duration of the animation used when showing or hiding the bar.
        """

    def GetEffectDuration(self):
        """
        GetEffectDuration() -> int
        
        Return the effect animation duration currently used.
        """

    def SetFont(self, font):
        """
        SetFont(font) -> bool
        
        Overridden base class methods changes the font of the text message.
        """

    def Create(self, parent, winid=ID_ANY):
        """
        Create(parent, winid=ID_ANY) -> bool
        
        Create the info bar window.
        """

    def AddButton(self, btnid, label=""):
        """
        AddButton(btnid, label="")
        
        Add a button to be shown in the info bar.
        """

    def Dismiss(self):
        """
        Dismiss()
        
        Hide the info bar window.
        """

    def RemoveButton(self, btnid):
        """
        RemoveButton(btnid)
        
        Remove a button previously added by AddButton().
        """

    def ShowMessage(self, msg, flags=ICON_INFORMATION):
        """
        ShowMessage(msg, flags=ICON_INFORMATION)
        
        Show a message in the bar.
        """
    EffectDuration = property(None, None)
    HideEffect = property(None, None)
    ShowEffect = property(None, None)
# end of class InfoBar

#-- end-infobar --#
#-- begin-listctrl --#
LC_VRULES = 0
LC_HRULES = 0
LC_ICON = 0
LC_SMALL_ICON = 0
LC_LIST = 0
LC_REPORT = 0
LC_ALIGN_TOP = 0
LC_ALIGN_LEFT = 0
LC_AUTOARRANGE = 0
LC_VIRTUAL = 0
LC_EDIT_LABELS = 0
LC_NO_HEADER = 0
LC_NO_SORT_HEADER = 0
LC_SINGLE_SEL = 0
LC_SORT_ASCENDING = 0
LC_SORT_DESCENDING = 0
LC_MASK_TYPE = 0
LC_MASK_ALIGN = 0
LC_MASK_SORT = 0
LIST_MASK_STATE = 0
LIST_MASK_TEXT = 0
LIST_MASK_IMAGE = 0
LIST_MASK_DATA = 0
LIST_SET_ITEM = 0
LIST_MASK_WIDTH = 0
LIST_MASK_FORMAT = 0
LIST_STATE_DONTCARE = 0
LIST_STATE_DROPHILITED = 0
LIST_STATE_FOCUSED = 0
LIST_STATE_SELECTED = 0
LIST_STATE_CUT = 0
LIST_STATE_DISABLED = 0
LIST_STATE_FILTERED = 0
LIST_STATE_INUSE = 0
LIST_STATE_PICKED = 0
LIST_STATE_SOURCE = 0
LIST_HITTEST_ABOVE = 0
LIST_HITTEST_BELOW = 0
LIST_HITTEST_NOWHERE = 0
LIST_HITTEST_ONITEMICON = 0
LIST_HITTEST_ONITEMLABEL = 0
LIST_HITTEST_ONITEMRIGHT = 0
LIST_HITTEST_ONITEMSTATEICON = 0
LIST_HITTEST_TOLEFT = 0
LIST_HITTEST_TORIGHT = 0
LIST_HITTEST_ONITEM = 0
LIST_GETSUBITEMRECT_WHOLEITEM = 0
LIST_NEXT_ABOVE = 0
LIST_NEXT_ALL = 0
LIST_NEXT_BELOW = 0
LIST_NEXT_LEFT = 0
LIST_NEXT_RIGHT = 0
LIST_ALIGN_DEFAULT = 0
LIST_ALIGN_LEFT = 0
LIST_ALIGN_TOP = 0
LIST_ALIGN_SNAP_TO_GRID = 0
LIST_FORMAT_LEFT = 0
LIST_FORMAT_RIGHT = 0
LIST_FORMAT_CENTRE = 0
LIST_FORMAT_CENTER = 0
LIST_AUTOSIZE = 0
LIST_AUTOSIZE_USEHEADER = 0
LIST_RECT_BOUNDS = 0
LIST_RECT_ICON = 0
LIST_RECT_LABEL = 0
LIST_FIND_UP = 0
LIST_FIND_DOWN = 0
LIST_FIND_LEFT = 0
LIST_FIND_RIGHT = 0
wxEVT_LIST_BEGIN_DRAG = 0
wxEVT_LIST_BEGIN_RDRAG = 0
wxEVT_LIST_BEGIN_LABEL_EDIT = 0
wxEVT_LIST_END_LABEL_EDIT = 0
wxEVT_LIST_DELETE_ITEM = 0
wxEVT_LIST_DELETE_ALL_ITEMS = 0
wxEVT_LIST_ITEM_SELECTED = 0
wxEVT_LIST_ITEM_DESELECTED = 0
wxEVT_LIST_KEY_DOWN = 0
wxEVT_LIST_INSERT_ITEM = 0
wxEVT_LIST_COL_CLICK = 0
wxEVT_LIST_ITEM_RIGHT_CLICK = 0
wxEVT_LIST_ITEM_MIDDLE_CLICK = 0
wxEVT_LIST_ITEM_ACTIVATED = 0
wxEVT_LIST_CACHE_HINT = 0
wxEVT_LIST_COL_RIGHT_CLICK = 0
wxEVT_LIST_COL_BEGIN_DRAG = 0
wxEVT_LIST_COL_DRAGGING = 0
wxEVT_LIST_COL_END_DRAG = 0
wxEVT_LIST_ITEM_FOCUSED = 0

class ListItemAttr(object):
    """
    ListItemAttr()
    ListItemAttr(colText, colBack, font)
    
    Represents the attributes (color, font, ...) of a wxListCtrl's
    wxListItem.
    """

    def __init__(self, *args, **kw):
        """
        ListItemAttr()
        ListItemAttr(colText, colBack, font)
        
        Represents the attributes (color, font, ...) of a wxListCtrl's
        wxListItem.
        """

    def GetBackgroundColour(self):
        """
        GetBackgroundColour() -> Colour
        
        Returns the currently set background color.
        """

    def GetFont(self):
        """
        GetFont() -> Font
        
        Returns the currently set font.
        """

    def GetTextColour(self):
        """
        GetTextColour() -> Colour
        
        Returns the currently set text color.
        """

    def HasBackgroundColour(self):
        """
        HasBackgroundColour() -> bool
        
        Returns true if the currently set background color is valid.
        """

    def HasFont(self):
        """
        HasFont() -> bool
        
        Returns true if the currently set font is valid.
        """

    def HasTextColour(self):
        """
        HasTextColour() -> bool
        
        Returns true if the currently set text color is valid.
        """

    def SetBackgroundColour(self, colour):
        """
        SetBackgroundColour(colour)
        
        Sets a new background color.
        """

    def SetFont(self, font):
        """
        SetFont(font)
        
        Sets a new font.
        """

    def SetTextColour(self, colour):
        """
        SetTextColour(colour)
        
        Sets a new text color.
        """
    BackgroundColour = property(None, None)
    Font = property(None, None)
    TextColour = property(None, None)
# end of class ListItemAttr


class ListItem(Object):
    """
    ListItem()
    
    This class stores information about a wxListCtrl item or column.
    """

    def __init__(self):
        """
        ListItem()
        
        This class stores information about a wxListCtrl item or column.
        """

    def SetData(self, data):
        """
        SetData(data)
        
        Sets client data for the item.
        """

    def Clear(self):
        """
        Clear()
        
        Resets the item state to the default.
        """

    def GetAlign(self):
        """
        GetAlign() -> ListColumnFormat
        
        Returns the alignment for this item.
        """

    def GetBackgroundColour(self):
        """
        GetBackgroundColour() -> Colour
        
        Returns the background colour for this item.
        """

    def GetColumn(self):
        """
        GetColumn() -> int
        
        Returns the zero-based column; meaningful only in report mode.
        """

    def GetData(self):
        """
        GetData() -> long
        
        Returns client data associated with the control.
        """

    def GetFont(self):
        """
        GetFont() -> Font
        
        Returns the font used to display the item.
        """

    def GetId(self):
        """
        GetId() -> long
        
        Returns the zero-based item position.
        """

    def GetImage(self):
        """
        GetImage() -> int
        
        Returns the zero-based index of the image associated with the item
        into the image list.
        """

    def GetMask(self):
        """
        GetMask() -> long
        
        Returns a bit mask indicating which fields of the structure are valid.
        """

    def GetState(self):
        """
        GetState() -> long
        
        Returns a bit field representing the state of the item.
        """

    def GetText(self):
        """
        GetText() -> String
        
        Returns the label/header text.
        """

    def GetTextColour(self):
        """
        GetTextColour() -> Colour
        
        Returns the text colour.
        """

    def GetWidth(self):
        """
        GetWidth() -> int
        
        Meaningful only for column headers in report mode.
        """

    def SetAlign(self, align):
        """
        SetAlign(align)
        
        Sets the alignment for the item.
        """

    def SetBackgroundColour(self, colBack):
        """
        SetBackgroundColour(colBack)
        
        Sets the background colour for the item.
        """

    def SetColumn(self, col):
        """
        SetColumn(col)
        
        Sets the zero-based column.
        """

    def SetFont(self, font):
        """
        SetFont(font)
        
        Sets the font for the item.
        """

    def SetId(self, id):
        """
        SetId(id)
        
        Sets the zero-based item position.
        """

    def SetImage(self, image):
        """
        SetImage(image)
        
        Sets the zero-based index of the image associated with the item into
        the image list.
        """

    def SetMask(self, mask):
        """
        SetMask(mask)
        
        Sets the mask of valid fields.
        """

    def SetState(self, state):
        """
        SetState(state)
        
        Sets the item state flags (note that the valid state flags are
        influenced by the value of the state mask, see
        wxListItem::SetStateMask).
        """

    def SetStateMask(self, stateMask):
        """
        SetStateMask(stateMask)
        
        Sets the bitmask that is used to determine which of the state flags
        are to be set.
        """

    def SetText(self, text):
        """
        SetText(text)
        
        Sets the text label for the item.
        """

    def SetTextColour(self, colText):
        """
        SetTextColour(colText)
        
        Sets the text colour for the item.
        """

    def SetWidth(self, width):
        """
        SetWidth(width)
        
        Meaningful only for column headers in report mode.
        """
    Align = property(None, None)
    BackgroundColour = property(None, None)
    Column = property(None, None)
    Data = property(None, None)
    Font = property(None, None)
    Id = property(None, None)
    Image = property(None, None)
    Mask = property(None, None)
    State = property(None, None)
    Text = property(None, None)
    TextColour = property(None, None)
    Width = property(None, None)
# end of class ListItem

ListCtrlNameStr = ""

class ListCtrl(Control):
    """
    ListCtrl()
    ListCtrl(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=LC_ICON, validator=DefaultValidator, name=ListCtrlNameStr)
    
    A list control presents lists in a number of formats: list view,
    report view, icon view and small icon view.
    """

    def __init__(self, *args, **kw):
        """
        ListCtrl()
        ListCtrl(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=LC_ICON, validator=DefaultValidator, name=ListCtrlNameStr)
        
        A list control presents lists in a number of formats: list view,
        report view, icon view and small icon view.
        """

    def AppendColumn(self, heading, format=LIST_FORMAT_LEFT, width=-1):
        """
        AppendColumn(heading, format=LIST_FORMAT_LEFT, width=-1) -> long
        
        Adds a new column to the list control in report view mode.
        """

    def Arrange(self, flag=LIST_ALIGN_DEFAULT):
        """
        Arrange(flag=LIST_ALIGN_DEFAULT) -> bool
        
        Arranges the items in icon or small icon view.
        """

    def AssignImageList(self, imageList, which):
        """
        AssignImageList(imageList, which)
        
        Sets the image list associated with the control and takes ownership of
        it (i.e.
        """

    def ClearAll(self):
        """
        ClearAll()
        
        Deletes all items and all columns.
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=LC_ICON, validator=DefaultValidator, name=ListCtrlNameStr):
        """
        Create(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=LC_ICON, validator=DefaultValidator, name=ListCtrlNameStr) -> bool
        
        Creates the list control.
        """

    def DeleteAllItems(self):
        """
        DeleteAllItems() -> bool
        
        Deletes all items in the list control.
        """

    def DeleteColumn(self, col):
        """
        DeleteColumn(col) -> bool
        
        Deletes a column.
        """

    def DeleteItem(self, item):
        """
        DeleteItem(item) -> bool
        
        Deletes the specified item.
        """

    def EditLabel(self, item):
        """
        EditLabel(item) -> TextCtrl
        
        Starts editing the label of the given item.
        """

    def EnableAlternateRowColours(self, enable=True):
        """
        EnableAlternateRowColours(enable=True)
        
        Enable alternating row background colours (also called zebra
        striping).
        """

    def EnableBellOnNoMatch(self, on=True):
        """
        EnableBellOnNoMatch(on=True)
        
        Enable or disable a beep if there is no match for the currently
        entered text when searching for the item from keyboard.
        """

    def EnsureVisible(self, item):
        """
        EnsureVisible(item) -> bool
        
        Ensures this item is visible.
        """

    def FindItem(self, *args, **kw):
        """
        FindItem(start, str, partial=False) -> long
        FindItem(start, data) -> long
        FindItem(start, pt, direction) -> long
        
        Find an item whose label matches this string, starting from start or
        the beginning if start is -1.
        """

    def GetColumn(self, col):
        """
        GetColumn(col) -> ListItem
        
        Gets information about this column. See SetItem() for more
        information.
        """

    def GetColumnCount(self):
        """
        GetColumnCount() -> int
        
        Returns the number of columns.
        """

    def GetColumnIndexFromOrder(self, pos):
        """
        GetColumnIndexFromOrder(pos) -> int
        
        Gets the column index from its position in visual order.
        """

    def GetColumnOrder(self, col):
        """
        GetColumnOrder(col) -> int
        
        Gets the column visual order position.
        """

    def GetColumnWidth(self, col):
        """
        GetColumnWidth(col) -> int
        
        Gets the column width (report view only).
        """

    def GetColumnsOrder(self):
        """
        GetColumnsOrder() -> ArrayInt
        
        Returns the array containing the orders of all columns.
        """

    def GetCountPerPage(self):
        """
        GetCountPerPage() -> int
        
        Gets the number of items that can fit vertically in the visible area
        of the list control (list or report view) or the total number of items
        in the list control (icon or small icon view).
        """

    def GetEditControl(self):
        """
        GetEditControl() -> TextCtrl
        
        Returns the edit control being currently used to edit a label.
        """

    def GetImageList(self, which):
        """
        GetImageList(which) -> ImageList
        
        Returns the specified image list.
        """

    def GetItem(self, itemIdx, col=0):
        """
        GetItem(itemIdx, col=0) -> ListItem
        
        Gets information about the item. See SetItem() for more information.
        """

    def GetItemBackgroundColour(self, item):
        """
        GetItemBackgroundColour(item) -> Colour
        
        Returns the colour for this item.
        """

    def GetItemCount(self):
        """
        GetItemCount() -> int
        
        Returns the number of items in the list control.
        """

    def GetItemData(self, item):
        """
        GetItemData(item) -> UIntPtr
        
        Gets the application-defined data associated with this item.
        """

    def GetItemFont(self, item):
        """
        GetItemFont(item) -> Font
        
        Returns the item's font.
        """

    def GetItemPosition(self, item):
        """
        GetItemPosition(item) -> Point
        
        Returns the position of the item, in icon or small icon view.
        """

    def GetItemRect(self, item, code=LIST_RECT_BOUNDS):
        """
        GetItemRect(item, code=LIST_RECT_BOUNDS) -> Rect
        
        Returns the rectangle representing the item's size and position, in
        physical coordinates.
        code is one of wx.LIST_RECT_BOUNDS, wx.LIST_RECT_ICON,
        wx.LIST_RECT_LABEL.
        """

    def GetItemSpacing(self):
        """
        GetItemSpacing() -> Size
        
        Retrieves the spacing between icons in pixels: horizontal spacing is
        returned as x component of the wxSize object and the vertical spacing
        as its y component.
        """

    def GetItemState(self, item, stateMask):
        """
        GetItemState(item, stateMask) -> int
        
        Gets the item state.
        """

    def GetItemText(self, item, col=0):
        """
        GetItemText(item, col=0) -> String
        
        Gets the item text for this item.
        """

    def GetItemTextColour(self, item):
        """
        GetItemTextColour(item) -> Colour
        
        Returns the colour for this item.
        """

    def GetNextItem(self, item, geometry=LIST_NEXT_ALL, state=LIST_STATE_DONTCARE):
        """
        GetNextItem(item, geometry=LIST_NEXT_ALL, state=LIST_STATE_DONTCARE) -> long
        
        Searches for an item with the given geometry or state, starting from
        item but excluding the item itself.
        """

    def GetSelectedItemCount(self):
        """
        GetSelectedItemCount() -> int
        
        Returns the number of selected items in the list control.
        """

    def GetSubItemRect(self, item, subItem, rect, code=LIST_RECT_BOUNDS):
        """
        GetSubItemRect(item, subItem, rect, code=LIST_RECT_BOUNDS) -> bool
        
        Returns the rectangle representing the size and position, in physical
        coordinates, of the given subitem, i.e.
        """

    def GetTextColour(self):
        """
        GetTextColour() -> Colour
        
        Gets the text colour of the list control.
        """

    def GetTopItem(self):
        """
        GetTopItem() -> long
        
        Gets the index of the topmost visible item when in list or report
        view.
        """

    def GetViewRect(self):
        """
        GetViewRect() -> Rect
        
        Returns the rectangle taken by all items in the control.
        """

    def SetAlternateRowColour(self, colour):
        """
        SetAlternateRowColour(colour)
        
        Set the alternative row background colour to a specific colour.
        """

    def HitTest(self, point):
        """
        HitTest(point) -> (long, flags)
        
        Determines which item (if any) is at the specified point, giving
        details in flags.
        """

    def InReportView(self):
        """
        InReportView() -> bool
        
        Returns true if the control is currently using wxLC_REPORT style.
        """

    def InsertColumn(self, *args, **kw):
        """
        InsertColumn(col, info) -> long
        InsertColumn(col, heading, format=LIST_FORMAT_LEFT, width=LIST_AUTOSIZE) -> long
        
        For report view mode (only), inserts a column.
        """

    def InsertItem(self, *args, **kw):
        """
        InsertItem(info) -> long
        InsertItem(index, label) -> long
        InsertItem(index, imageIndex) -> long
        InsertItem(index, label, imageIndex) -> long
        
        Inserts an item, returning the index of the new item if successful, -1
        otherwise.
        """

    def IsVirtual(self):
        """
        IsVirtual() -> bool
        
        Returns true if the control is currently in virtual report view.
        """

    def RefreshItem(self, item):
        """
        RefreshItem(item)
        
        Redraws the given item.
        """

    def RefreshItems(self, itemFrom, itemTo):
        """
        RefreshItems(itemFrom, itemTo)
        
        Redraws the items between itemFrom and itemTo.
        """

    def ScrollList(self, dx, dy):
        """
        ScrollList(dx, dy) -> bool
        
        Scrolls the list control.
        """

    def SetBackgroundColour(self, col):
        """
        SetBackgroundColour(col) -> bool
        
        Sets the background colour.
        """

    def SetColumn(self, col, item):
        """
        SetColumn(col, item) -> bool
        
        Sets information about this column.
        """

    def SetColumnWidth(self, col, width):
        """
        SetColumnWidth(col, width) -> bool
        
        Sets the column width.
        """

    def SetColumnsOrder(self, orders):
        """
        SetColumnsOrder(orders) -> bool
        
        Changes the order in which the columns are shown.
        """

    def SetImageList(self, imageList, which):
        """
        SetImageList(imageList, which)
        
        Sets the image list associated with the control.
        """

    def SetItem(self, *args, **kw):
        """
        SetItem(info) -> bool
        SetItem(index, column, label, imageId=-1) -> long
        
        Sets the data of an item.
        """

    def SetItemBackgroundColour(self, item, col):
        """
        SetItemBackgroundColour(item, col)
        
        Sets the background colour for this item.
        """

    def SetItemColumnImage(self, item, column, image):
        """
        SetItemColumnImage(item, column, image) -> bool
        
        Sets the image associated with the item.
        """

    def SetItemCount(self, count):
        """
        SetItemCount(count)
        
        This method can only be used with virtual list controls.
        """

    def SetItemData(self, item, data):
        """
        SetItemData(item, data) -> bool
        
        Associates application-defined data with this item.
        """

    def SetItemFont(self, item, font):
        """
        SetItemFont(item, font)
        
        Sets the item's font.
        """

    def SetItemImage(self, item, image, selImage=-1):
        """
        SetItemImage(item, image, selImage=-1) -> bool
        
        Sets the unselected and selected images associated with the item.
        """

    def SetItemPosition(self, item, pos):
        """
        SetItemPosition(item, pos) -> bool
        
        Sets the position of the item, in icon or small icon view.
        """

    def SetItemPtrData(self, item, data):
        """
        SetItemPtrData(item, data) -> bool
        
        Associates application-defined data with this item.
        """

    def SetItemState(self, item, state, stateMask):
        """
        SetItemState(item, state, stateMask) -> bool
        
        Sets the item state.
        """

    def SetItemText(self, item, text):
        """
        SetItemText(item, text)
        
        Sets the item text for this item.
        """

    def SetItemTextColour(self, item, col):
        """
        SetItemTextColour(item, col)
        
        Sets the colour for this item.
        """

    def SetSingleStyle(self, style, add=True):
        """
        SetSingleStyle(style, add=True)
        
        Adds or removes a single window style.
        """

    def SetTextColour(self, col):
        """
        SetTextColour(col)
        
        Sets the text colour of the list control.
        """

    def SetWindowStyleFlag(self, style):
        """
        SetWindowStyleFlag(style)
        
        Sets the whole window style, deleting all items.
        """

    def SortItems(self, fnSortCallBack):
        """
        SortItems(fnSortCallBack) -> bool
        
        Call this function to sort the items in the list control.
        """

    def HitTestSubItem(self, point):
        """
        HitTestSubItemHitTestSubItem(point) -> (item, flags, subitem)
        
        Determines which item (if any) is at the specified point, giving
        details in flags.
        """

    FindItemData = wx.deprecated(FindItem, "Use FindItem instead.")

    FindItemAtPos = wx.deprecated(FindItem, "Use FindItem instead.")

    InsertStringItem = wx.deprecated(InsertItem, "Use InsertItem instead.")

    InsertImageItem = wx.deprecated(InsertItem, "Use InsertItem instead.")

    InsertImageStringItem = wx.deprecated(InsertItem, "Use InsertItem instead.")

    SetStringItem = wx.deprecated(SetItem, "Use SetItem instead.")

    def HasColumnOrderSupport(self):
        """
        HasColumnOrderSupport() -> bool
        """

    def Select(self, idx, on=1):
        """
        Selects/deselects an item.
        """

    def Focus(self, idx):
        """
        Focus and show the given item.
        """

    def GetFocusedItem(self):
        """
        Gets the currently focused item or -1 if none is focused.
        """

    def GetFirstSelected(self, *args):
        """
        Returns the first selected item, or -1 when none is selected.
        """

    def GetNextSelected(self, item):
        """
        Returns subsequent selected items, or -1 when no more are selected.
        """

    def IsSelected(self, idx):
        """
        Returns ``True`` if the item is selected.
        """

    def SetColumnImage(self, col, image):
        """
        
        """

    def ClearColumnImage(self, col):
        """
        
        """

    def Append(self, entry):
        """
        Append an item to the list control.  The `entry` parameter should be a
        sequence with an item for each column
        """

    def GetMainWindow(self):
        """
        GetMainWindow() -> Window
        """
    Column = property(None, None)
    ColumnCount = property(None, None)
    ColumnsOrder = property(None, None)
    CountPerPage = property(None, None)
    EditControl = property(None, None)
    FocusedItem = property(None, None)
    Item = property(None, None)
    ItemCount = property(None, None)
    ItemPosition = property(None, None)
    ItemRect = property(None, None)
    ItemSpacing = property(None, None)
    MainWindow = property(None, None)
    SelectedItemCount = property(None, None)
    TextColour = property(None, None)
    TopItem = property(None, None)
    ViewRect = property(None, None)

    def OnGetItemAttr(self, item):
        """
        OnGetItemAttr(item) -> ListItemAttr
        
        This function may be overridden in the derived class for a control
        with wxLC_VIRTUAL style.
        """

    def OnGetItemColumnImage(self, item, column):
        """
        OnGetItemColumnImage(item, column) -> int
        
        Override this function in the derived class for a control with
        wxLC_VIRTUAL and wxLC_REPORT styles in order to specify the image
        index for the given line and column.
        """

    def OnGetItemImage(self, item):
        """
        OnGetItemImage(item) -> int
        
        This function must be overridden in the derived class for a control
        with wxLC_VIRTUAL style having an "image list" (see SetImageList(); if
        the control doesn't have an image list, it is not necessary to
        override it).
        """

    def OnGetItemText(self, item, column):
        """
        OnGetItemText(item, column) -> String
        
        This function must be overridden in the derived class for a control
        with wxLC_VIRTUAL style.
        """
# end of class ListCtrl


class ListView(ListCtrl):
    """
    ListView()
    ListView(parent, winid=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=LC_REPORT, validator=DefaultValidator, name=ListCtrlNameStr)
    
    This class currently simply presents a simpler to use interface for
    the wxListCtrl  it can be thought of as a façade for that complicated
    class.
    """

    def __init__(self, *args, **kw):
        """
        ListView()
        ListView(parent, winid=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=LC_REPORT, validator=DefaultValidator, name=ListCtrlNameStr)
        
        This class currently simply presents a simpler to use interface for
        the wxListCtrl  it can be thought of as a façade for that complicated
        class.
        """

    def ClearColumnImage(self, col):
        """
        ClearColumnImage(col)
        
        Resets the column image  after calling this function, no image will be
        shown.
        """

    def Focus(self, index):
        """
        Focus(index)
        
        Sets focus to the item with the given index.
        """

    def GetFirstSelected(self):
        """
        GetFirstSelected() -> long
        
        Returns the first selected item in a (presumably) multiple selection
        control.
        """

    def GetFocusedItem(self):
        """
        GetFocusedItem() -> long
        
        Returns the currently focused item or -1 if none.
        """

    def GetNextSelected(self, item):
        """
        GetNextSelected(item) -> long
        
        Used together with GetFirstSelected() to iterate over all selected
        items in the control.
        """

    def IsSelected(self, index):
        """
        IsSelected(index) -> bool
        
        Returns true if the item with the given index is selected, false
        otherwise.
        """

    def Select(self, n, on=True):
        """
        Select(n, on=True)
        
        Selects or unselects the given item.
        """

    def SetColumnImage(self, col, image):
        """
        SetColumnImage(col, image)
        
        Sets the column image for the specified column.
        """
    FirstSelected = property(None, None)
    FocusedItem = property(None, None)
# end of class ListView


class ListEvent(NotifyEvent):
    """
    ListEvent(commandType=wxEVT_NULL, id=0)
    
    A list event holds information about events associated with wxListCtrl
    objects.
    """

    def __init__(self, commandType=wxEVT_NULL, id=0):
        """
        ListEvent(commandType=wxEVT_NULL, id=0)
        
        A list event holds information about events associated with wxListCtrl
        objects.
        """

    def GetCacheFrom(self):
        """
        GetCacheFrom() -> long
        
        For EVT_LIST_CACHE_HINT event only: return the first item which the
        list control advises us to cache.
        """

    def GetCacheTo(self):
        """
        GetCacheTo() -> long
        
        For EVT_LIST_CACHE_HINT event only: return the last item (inclusive)
        which the list control advises us to cache.
        """

    def GetColumn(self):
        """
        GetColumn() -> int
        
        The column position: it is only used with COL events.
        """

    def GetData(self):
        """
        GetData() -> UIntPtr
        
        The data.
        """

    def GetImage(self):
        """
        GetImage() -> int
        
        The image.
        """

    def GetIndex(self):
        """
        GetIndex() -> long
        
        The item index.
        """

    def GetItem(self):
        """
        GetItem() -> ListItem
        
        An item object, used by some events.
        """

    def GetKeyCode(self):
        """
        GetKeyCode() -> int
        
        Key code if the event is a keypress event.
        """

    def GetLabel(self):
        """
        GetLabel() -> String
        
        The (new) item label for EVT_LIST_END_LABEL_EDIT event.
        """

    def GetMask(self):
        """
        GetMask() -> long
        
        The mask.
        """

    def GetPoint(self):
        """
        GetPoint() -> Point
        
        The position of the mouse pointer if the event is a drag event.
        """

    def GetText(self):
        """
        GetText() -> String
        
        The text.
        """

    def IsEditCancelled(self):
        """
        IsEditCancelled() -> bool
        
        This method only makes sense for EVT_LIST_END_LABEL_EDIT message and
        returns true if it the label editing has been cancelled by the user
        (GetLabel() returns an empty string in this case but it doesn't allow
        the application to distinguish between really cancelling the edit and
        the admittedly rare case when the user wants to rename it to an empty
        string).
        """

    def SetKeyCode(self, code):
        """
        SetKeyCode(code)
        """

    def SetIndex(self, index):
        """
        SetIndex(index)
        """

    def SetColumn(self, col):
        """
        SetColumn(col)
        """

    def SetPoint(self, point):
        """
        SetPoint(point)
        """

    def SetItem(self, item):
        """
        SetItem(item)
        """

    def SetCacheFrom(self, cacheFrom):
        """
        SetCacheFrom(cacheFrom)
        """

    def SetCacheTo(self, cacheTo):
        """
        SetCacheTo(cacheTo)
        """

    EVT_LIST_BEGIN_DRAG        = PyEventBinder(wxEVT_LIST_BEGIN_DRAG       , 1)
    EVT_LIST_BEGIN_RDRAG       = PyEventBinder(wxEVT_LIST_BEGIN_RDRAG      , 1)
    EVT_LIST_BEGIN_LABEL_EDIT  = PyEventBinder(wxEVT_LIST_BEGIN_LABEL_EDIT , 1)
    EVT_LIST_END_LABEL_EDIT    = PyEventBinder(wxEVT_LIST_END_LABEL_EDIT   , 1)
    EVT_LIST_DELETE_ITEM       = PyEventBinder(wxEVT_LIST_DELETE_ITEM      , 1)
    EVT_LIST_DELETE_ALL_ITEMS  = PyEventBinder(wxEVT_LIST_DELETE_ALL_ITEMS , 1)
    EVT_LIST_ITEM_SELECTED     = PyEventBinder(wxEVT_LIST_ITEM_SELECTED    , 1)
    EVT_LIST_ITEM_DESELECTED   = PyEventBinder(wxEVT_LIST_ITEM_DESELECTED  , 1)
    EVT_LIST_KEY_DOWN          = PyEventBinder(wxEVT_LIST_KEY_DOWN         , 1)
    EVT_LIST_INSERT_ITEM       = PyEventBinder(wxEVT_LIST_INSERT_ITEM      , 1)
    EVT_LIST_COL_CLICK         = PyEventBinder(wxEVT_LIST_COL_CLICK        , 1)
    EVT_LIST_ITEM_RIGHT_CLICK  = PyEventBinder(wxEVT_LIST_ITEM_RIGHT_CLICK , 1)
    EVT_LIST_ITEM_MIDDLE_CLICK = PyEventBinder(wxEVT_LIST_ITEM_MIDDLE_CLICK, 1)
    EVT_LIST_ITEM_ACTIVATED    = PyEventBinder(wxEVT_LIST_ITEM_ACTIVATED   , 1)
    EVT_LIST_CACHE_HINT        = PyEventBinder(wxEVT_LIST_CACHE_HINT       , 1)
    EVT_LIST_COL_RIGHT_CLICK   = PyEventBinder(wxEVT_LIST_COL_RIGHT_CLICK  , 1)
    EVT_LIST_COL_BEGIN_DRAG    = PyEventBinder(wxEVT_LIST_COL_BEGIN_DRAG   , 1)
    EVT_LIST_COL_DRAGGING      = PyEventBinder(wxEVT_LIST_COL_DRAGGING     , 1)
    EVT_LIST_COL_END_DRAG      = PyEventBinder(wxEVT_LIST_COL_END_DRAG     , 1)
    EVT_LIST_ITEM_FOCUSED      = PyEventBinder(wxEVT_LIST_ITEM_FOCUSED     , 1)
    
    # deprecated wxEVT aliases
    wxEVT_COMMAND_LIST_BEGIN_DRAG         = wxEVT_LIST_BEGIN_DRAG
    wxEVT_COMMAND_LIST_BEGIN_RDRAG        = wxEVT_LIST_BEGIN_RDRAG
    wxEVT_COMMAND_LIST_BEGIN_LABEL_EDIT   = wxEVT_LIST_BEGIN_LABEL_EDIT
    wxEVT_COMMAND_LIST_END_LABEL_EDIT     = wxEVT_LIST_END_LABEL_EDIT
    wxEVT_COMMAND_LIST_DELETE_ITEM        = wxEVT_LIST_DELETE_ITEM
    wxEVT_COMMAND_LIST_DELETE_ALL_ITEMS   = wxEVT_LIST_DELETE_ALL_ITEMS
    wxEVT_COMMAND_LIST_ITEM_SELECTED      = wxEVT_LIST_ITEM_SELECTED
    wxEVT_COMMAND_LIST_ITEM_DESELECTED    = wxEVT_LIST_ITEM_DESELECTED
    wxEVT_COMMAND_LIST_KEY_DOWN           = wxEVT_LIST_KEY_DOWN
    wxEVT_COMMAND_LIST_INSERT_ITEM        = wxEVT_LIST_INSERT_ITEM
    wxEVT_COMMAND_LIST_COL_CLICK          = wxEVT_LIST_COL_CLICK
    wxEVT_COMMAND_LIST_ITEM_RIGHT_CLICK   = wxEVT_LIST_ITEM_RIGHT_CLICK
    wxEVT_COMMAND_LIST_ITEM_MIDDLE_CLICK  = wxEVT_LIST_ITEM_MIDDLE_CLICK
    wxEVT_COMMAND_LIST_ITEM_ACTIVATED     = wxEVT_LIST_ITEM_ACTIVATED
    wxEVT_COMMAND_LIST_CACHE_HINT         = wxEVT_LIST_CACHE_HINT
    wxEVT_COMMAND_LIST_COL_RIGHT_CLICK    = wxEVT_LIST_COL_RIGHT_CLICK
    wxEVT_COMMAND_LIST_COL_BEGIN_DRAG     = wxEVT_LIST_COL_BEGIN_DRAG
    wxEVT_COMMAND_LIST_COL_DRAGGING       = wxEVT_LIST_COL_DRAGGING
    wxEVT_COMMAND_LIST_COL_END_DRAG       = wxEVT_LIST_COL_END_DRAG
    wxEVT_COMMAND_LIST_ITEM_FOCUSED       = wxEVT_LIST_ITEM_FOCUSED
    CacheFrom = property(None, None)
    CacheTo = property(None, None)
    Column = property(None, None)
    Data = property(None, None)
    Image = property(None, None)
    Index = property(None, None)
    Item = property(None, None)
    KeyCode = property(None, None)
    Label = property(None, None)
    Mask = property(None, None)
    Point = property(None, None)
    Text = property(None, None)
# end of class ListEvent

#-- end-listctrl --#
#-- begin-treectrl --#
TR_NO_BUTTONS = 0
TR_HAS_BUTTONS = 0
TR_NO_LINES = 0
TR_LINES_AT_ROOT = 0
TR_TWIST_BUTTONS = 0
TR_SINGLE = 0
TR_MULTIPLE = 0
TR_HAS_VARIABLE_ROW_HEIGHT = 0
TR_EDIT_LABELS = 0
TR_ROW_LINES = 0
TR_HIDE_ROOT = 0
TR_FULL_ROW_HIGHLIGHT = 0
TR_DEFAULT_STYLE = 0
TreeItemIcon_Normal = 0
TreeItemIcon_Selected = 0
TreeItemIcon_Expanded = 0
TreeItemIcon_SelectedExpanded = 0
TreeItemIcon_Max = 0
TREE_ITEMSTATE_NONE = 0
TREE_ITEMSTATE_NEXT = 0
TREE_ITEMSTATE_PREV = 0
TREE_HITTEST_ABOVE = 0
TREE_HITTEST_BELOW = 0
TREE_HITTEST_NOWHERE = 0
TREE_HITTEST_ONITEMBUTTON = 0
TREE_HITTEST_ONITEMICON = 0
TREE_HITTEST_ONITEMINDENT = 0
TREE_HITTEST_ONITEMLABEL = 0
TREE_HITTEST_ONITEMRIGHT = 0
TREE_HITTEST_ONITEMSTATEICON = 0
TREE_HITTEST_TOLEFT = 0
TREE_HITTEST_TORIGHT = 0
TREE_HITTEST_ONITEMUPPERPART = 0
TREE_HITTEST_ONITEMLOWERPART = 0
TREE_HITTEST_ONITEM = 0
wxEVT_TREE_BEGIN_DRAG = 0
wxEVT_TREE_BEGIN_RDRAG = 0
wxEVT_TREE_BEGIN_LABEL_EDIT = 0
wxEVT_TREE_END_LABEL_EDIT = 0
wxEVT_TREE_DELETE_ITEM = 0
wxEVT_TREE_GET_INFO = 0
wxEVT_TREE_SET_INFO = 0
wxEVT_TREE_ITEM_EXPANDED = 0
wxEVT_TREE_ITEM_EXPANDING = 0
wxEVT_TREE_ITEM_COLLAPSED = 0
wxEVT_TREE_ITEM_COLLAPSING = 0
wxEVT_TREE_SEL_CHANGED = 0
wxEVT_TREE_SEL_CHANGING = 0
wxEVT_TREE_KEY_DOWN = 0
wxEVT_TREE_ITEM_ACTIVATED = 0
wxEVT_TREE_ITEM_RIGHT_CLICK = 0
wxEVT_TREE_ITEM_MIDDLE_CLICK = 0
wxEVT_TREE_END_DRAG = 0
wxEVT_TREE_STATE_IMAGE_CLICK = 0
wxEVT_TREE_ITEM_GETTOOLTIP = 0
wxEVT_TREE_ITEM_MENU = 0

class TreeItemId(object):
    """
    TreeItemId()
    
    An opaque reference to a tree item.
    """

    def __init__(self):
        """
        TreeItemId()
        
        An opaque reference to a tree item.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if this instance is referencing a valid tree item.
        """

    def GetID(self):
        """
        GetID() -> void
        """

    def Unset(self):
        """
        Unset()
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """
    ID = property(None, None)
# end of class TreeItemId

TreeCtrlNameStr = ""

class TreeCtrl(Control):
    """
    TreeCtrl()
    TreeCtrl(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=TR_DEFAULT_STYLE, validator=DefaultValidator, name=TreeCtrlNameStr)
    
    A tree control presents information as a hierarchy, with items that
    may be expanded to show further items.
    """

    def __init__(self, *args, **kw):
        """
        TreeCtrl()
        TreeCtrl(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=TR_DEFAULT_STYLE, validator=DefaultValidator, name=TreeCtrlNameStr)
        
        A tree control presents information as a hierarchy, with items that
        may be expanded to show further items.
        """

    def AddRoot(self, text, image=-1, selImage=-1, data=None):
        """
        AddRoot(text, image=-1, selImage=-1, data=None) -> TreeItemId
        
        Adds the root node to the tree, returning the new item.
        """

    def AppendItem(self, parent, text, image=-1, selImage=-1, data=None):
        """
        AppendItem(parent, text, image=-1, selImage=-1, data=None) -> TreeItemId
        
        Appends an item to the end of the branch identified by parent, return
        a new item id.
        """

    def AssignImageList(self, imageList):
        """
        AssignImageList(imageList)
        
        Sets the normal image list.
        """

    def AssignStateImageList(self, imageList):
        """
        AssignStateImageList(imageList)
        
        Sets the state image list.
        """

    def Collapse(self, item):
        """
        Collapse(item)
        
        Collapses the given item.
        """

    def CollapseAll(self):
        """
        CollapseAll()
        
        Collapses the root item.
        """

    def CollapseAllChildren(self, item):
        """
        CollapseAllChildren(item)
        
        Collapses this item and all of its children, recursively.
        """

    def CollapseAndReset(self, item):
        """
        CollapseAndReset(item)
        
        Collapses the given item and removes all children.
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=TR_DEFAULT_STYLE, validator=DefaultValidator, name=TreeCtrlNameStr):
        """
        Create(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=TR_DEFAULT_STYLE, validator=DefaultValidator, name=TreeCtrlNameStr) -> bool
        
        Creates the tree control.
        """

    def Delete(self, item):
        """
        Delete(item)
        
        Deletes the specified item.
        """

    def DeleteAllItems(self):
        """
        DeleteAllItems()
        
        Deletes all items in the control.
        """

    def DeleteChildren(self, item):
        """
        DeleteChildren(item)
        
        Deletes all children of the given item (but not the item itself).
        """

    def EditLabel(self, item):
        """
        EditLabel(item) -> TextCtrl
        
        Starts editing the label of the given item.
        """

    def EnableBellOnNoMatch(self, on=True):
        """
        EnableBellOnNoMatch(on=True)
        
        Enable or disable a beep if there is no match for the currently
        entered text when searching for the item from keyboard.
        """

    def EndEditLabel(self, item, discardChanges=False):
        """
        EndEditLabel(item, discardChanges=False)
        
        Ends label editing.
        """

    def EnsureVisible(self, item):
        """
        EnsureVisible(item)
        
        Scrolls and/or expands items to ensure that the given item is visible.
        """

    def Expand(self, item):
        """
        Expand(item)
        
        Expands the given item.
        """

    def ExpandAll(self):
        """
        ExpandAll()
        
        Expands all items in the tree.
        """

    def ExpandAllChildren(self, item):
        """
        ExpandAllChildren(item)
        
        Expands the given item and all its children recursively.
        """

    def GetBoundingRect(self, item, textOnly=False):
        """
        GetBoundingRect(item, textOnly=False) -> PyObject
        
        Returns the rectangle bounding the item. If textOnly is true,
        only the rectangle around the item's label will be returned, otherwise
        the item's image is also taken into account. The return value may be
        None
        if the rectangle was not successfully retrieved, such as if the item
        is
        currently not visible.
        """

    def GetChildrenCount(self, item, recursively=True):
        """
        GetChildrenCount(item, recursively=True) -> size_t
        
        Returns the number of items in the branch.
        """

    def GetCount(self):
        """
        GetCount() -> unsignedint
        
        Returns the number of items in the control.
        """

    def GetEditControl(self):
        """
        GetEditControl() -> TextCtrl
        
        Returns the edit control being currently used to edit a label.
        """

    def GetFirstChild(self, item):
        """
        GetFirstChild(item) -> (TreeItemId, cookie)
        
        Returns the first child; call GetNextChild() for the next child.
        """

    def GetFirstVisibleItem(self):
        """
        GetFirstVisibleItem() -> TreeItemId
        
        Returns the first visible item.
        """

    def GetFocusedItem(self):
        """
        GetFocusedItem() -> TreeItemId
        
        Returns the item last clicked or otherwise selected.
        """

    def ClearFocusedItem(self):
        """
        ClearFocusedItem()
        
        Clears the currently focused item.
        """

    def SetFocusedItem(self, item):
        """
        SetFocusedItem(item)
        
        Sets the currently focused item.
        """

    def GetImageList(self):
        """
        GetImageList() -> ImageList
        
        Returns the normal image list.
        """

    def GetIndent(self):
        """
        GetIndent() -> unsignedint
        
        Returns the current tree control indentation.
        """

    def GetItemBackgroundColour(self, item):
        """
        GetItemBackgroundColour(item) -> Colour
        
        Returns the background colour of the item.
        """

    def GetItemData(self, item):
        """
        GetItemData(item) -> TreeItemData
        
        Returns the tree item data associated with the item.
        """

    def GetItemFont(self, item):
        """
        GetItemFont(item) -> Font
        
        Returns the font of the item label.
        """

    def GetItemImage(self, item, which=TreeItemIcon_Normal):
        """
        GetItemImage(item, which=TreeItemIcon_Normal) -> int
        
        Gets the specified item image.
        """

    def GetItemParent(self, item):
        """
        GetItemParent(item) -> TreeItemId
        
        Returns the item's parent.
        """

    def GetItemState(self, item):
        """
        GetItemState(item) -> int
        
        Gets the specified item state.
        """

    def GetItemText(self, item):
        """
        GetItemText(item) -> String
        
        Returns the item label.
        """

    def GetItemTextColour(self, item):
        """
        GetItemTextColour(item) -> Colour
        
        Returns the colour of the item label.
        """

    def GetLastChild(self, item):
        """
        GetLastChild(item) -> TreeItemId
        
        Returns the last child of the item (or an invalid tree item if this
        item has no children).
        """

    def GetNextChild(self, item, cookie):
        """
        GetNextChild(item, cookie) -> (TreeItemId, cookie)
        
        Returns the next child; call GetFirstChild() for the first child.
        """

    def GetNextSibling(self, item):
        """
        GetNextSibling(item) -> TreeItemId
        
        Returns the next sibling of the specified item; call GetPrevSibling()
        for the previous sibling.
        """

    def GetNextVisible(self, item):
        """
        GetNextVisible(item) -> TreeItemId
        
        Returns the next visible item or an invalid item if this item is the
        last visible one.
        """

    def GetPrevSibling(self, item):
        """
        GetPrevSibling(item) -> TreeItemId
        
        Returns the previous sibling of the specified item; call
        GetNextSibling() for the next sibling.
        """

    def GetPrevVisible(self, item):
        """
        GetPrevVisible(item) -> TreeItemId
        
        Returns the previous visible item or an invalid item if this item is
        the first visible one.
        """

    def GetQuickBestSize(self):
        """
        GetQuickBestSize() -> bool
        
        Returns true if the control will use a quick calculation for the best
        size, looking only at the first and last items.
        """

    def GetRootItem(self):
        """
        GetRootItem() -> TreeItemId
        
        Returns the root item for the tree control.
        """

    def GetSelection(self):
        """
        GetSelection() -> TreeItemId
        
        Returns the selection, or an invalid item if there is no selection.
        """

    def GetSelections(self):
        """
        GetSelections() -> PyObject
        
        Returns a list of currently selected items in the tree.  This function
        can be called only if the control has the wx.TR_MULTIPLE style.
        """

    def GetStateImageList(self):
        """
        GetStateImageList() -> ImageList
        
        Returns the state image list (from which application-defined state
        images are taken).
        """

    def HitTest(self, point, flags):
        """
        HitTest(point, flags) -> TreeItemId
        
        Calculates which (if any) item is under the given point, returning the
        tree item id at this point plus extra information flags.
        """

    def InsertItem(self, *args, **kw):
        """
        InsertItem(parent, previous, text, image=-1, selImage=-1, data=None) -> TreeItemId
        InsertItem(parent, pos, text, image=-1, selImage=-1, data=None) -> TreeItemId
        
        Inserts an item after a given one (previous).
        """

    def IsBold(self, item):
        """
        IsBold(item) -> bool
        
        Returns true if the given item is in bold state.
        """

    def IsEmpty(self):
        """
        IsEmpty() -> bool
        
        Returns true if the control is empty (i.e. has no items, even no root
        one).
        """

    def IsExpanded(self, item):
        """
        IsExpanded(item) -> bool
        
        Returns true if the item is expanded (only makes sense if it has
        children).
        """

    def IsSelected(self, item):
        """
        IsSelected(item) -> bool
        
        Returns true if the item is selected.
        """

    def IsVisible(self, item):
        """
        IsVisible(item) -> bool
        
        Returns true if the item is visible on the screen.
        """

    def ItemHasChildren(self, item):
        """
        ItemHasChildren(item) -> bool
        
        Returns true if the item has children.
        """

    def OnCompareItems(self, item1, item2):
        """
        OnCompareItems(item1, item2) -> int
        
        Override this function in the derived class to change the sort order
        of the items in the tree control.
        """

    def PrependItem(self, parent, text, image=-1, selImage=-1, data=None):
        """
        PrependItem(parent, text, image=-1, selImage=-1, data=None) -> TreeItemId
        
        Appends an item as the first child of parent, return a new item id.
        """

    def ScrollTo(self, item):
        """
        ScrollTo(item)
        
        Scrolls the specified item into view.
        """

    def SelectItem(self, item, select=True):
        """
        SelectItem(item, select=True)
        
        Selects the given item.
        """

    def SetImageList(self, imageList):
        """
        SetImageList(imageList)
        
        Sets the normal image list.
        """

    def SetIndent(self, indent):
        """
        SetIndent(indent)
        
        Sets the indentation for the tree control.
        """

    def SetItemBackgroundColour(self, item, col):
        """
        SetItemBackgroundColour(item, col)
        
        Sets the colour of the item's background.
        """

    def SetItemBold(self, item, bold=True):
        """
        SetItemBold(item, bold=True)
        
        Makes item appear in bold font if bold parameter is true or resets it
        to the normal state.
        """

    def SetItemData(self, item, data):
        """
        SetItemData(item, data)
        
        Sets the item client data.
        """

    def SetItemDropHighlight(self, item, highlight=True):
        """
        SetItemDropHighlight(item, highlight=True)
        
        Gives the item the visual feedback for Drag'n'Drop actions, which is
        useful if something is dragged from the outside onto the tree control
        (as opposed to a DnD operation within the tree control, which already
        is implemented internally).
        """

    def SetItemFont(self, item, font):
        """
        SetItemFont(item, font)
        
        Sets the item's font.
        """

    def SetItemHasChildren(self, item, hasChildren=True):
        """
        SetItemHasChildren(item, hasChildren=True)
        
        Force appearance of the button next to the item.
        """

    def SetItemImage(self, item, image, which=TreeItemIcon_Normal):
        """
        SetItemImage(item, image, which=TreeItemIcon_Normal)
        
        Sets the specified item's image.
        """

    def SetItemState(self, item, state):
        """
        SetItemState(item, state)
        
        Sets the specified item state.
        """

    def SetItemText(self, item, text):
        """
        SetItemText(item, text)
        
        Sets the item label.
        """

    def SetItemTextColour(self, item, col):
        """
        SetItemTextColour(item, col)
        
        Sets the colour of the item's text.
        """

    def SetQuickBestSize(self, quickBestSize):
        """
        SetQuickBestSize(quickBestSize)
        
        If true is passed, specifies that the control will use a quick
        calculation for the best size, looking only at the first and last
        items.
        """

    def SetStateImageList(self, imageList):
        """
        SetStateImageList(imageList)
        
        Sets the state image list (from which application-defined state images
        are taken).
        """

    def SetWindowStyle(self, styles):
        """
        SetWindowStyle(styles)
        
        Sets the mode flags associated with the display of the tree control.
        """

    def SortChildren(self, item):
        """
        SortChildren(item)
        
        Sorts the children of the given item using OnCompareItems().
        """

    def Toggle(self, item):
        """
        Toggle(item)
        
        Toggles the given item between collapsed and expanded states.
        """

    def ToggleItemSelection(self, item):
        """
        ToggleItemSelection(item)
        
        Toggles the given item between selected and unselected states.
        """

    def Unselect(self):
        """
        Unselect()
        
        Removes the selection from the currently selected item (if any).
        """

    def UnselectAll(self):
        """
        UnselectAll()
        
        This function either behaves the same as Unselect() if the control
        doesn't have wxTR_MULTIPLE style, or removes the selection from all
        items if it does have this style.
        """

    def UnselectItem(self, item):
        """
        UnselectItem(item)
        
        Unselects the given item.
        """

    def SelectChildren(self, parent):
        """
        SelectChildren(parent)
        
        Select all the immediate children of the given parent.
        """

    GetItemPyData = wx.deprecated(GetItemData, 'Use GetItemData instead.')
    SetItemPyData = wx.deprecated(SetItemData, 'Use SetItemData instead.')
    GetPyData = wx.deprecated(GetItemData, 'Use GetItemData instead.')
    SetPyData = wx.deprecated(SetItemData, 'Use SetItemData instead.')
    BoundingRect = property(None, None)
    Count = property(None, None)
    EditControl = property(None, None)
    FirstVisibleItem = property(None, None)
    FocusedItem = property(None, None)
    ImageList = property(None, None)
    Indent = property(None, None)
    QuickBestSize = property(None, None)
    RootItem = property(None, None)
    Selection = property(None, None)
    Selections = property(None, None)
    StateImageList = property(None, None)
# end of class TreeCtrl


class TreeEvent(NotifyEvent):
    """
    TreeEvent(commandType, tree, item=TreeItemId())
    
    A tree event holds information about events associated with wxTreeCtrl
    objects.
    """

    def __init__(self, commandType, tree, item=TreeItemId()):
        """
        TreeEvent(commandType, tree, item=TreeItemId())
        
        A tree event holds information about events associated with wxTreeCtrl
        objects.
        """

    def GetItem(self):
        """
        GetItem() -> TreeItemId
        
        Returns the item (valid for all events).
        """

    def GetKeyCode(self):
        """
        GetKeyCode() -> int
        
        Returns the key code if the event is a key event.
        """

    def GetKeyEvent(self):
        """
        GetKeyEvent() -> KeyEvent
        
        Returns the key event for EVT_TREE_KEY_DOWN events.
        """

    def GetLabel(self):
        """
        GetLabel() -> String
        
        Returns the label if the event is a begin or end edit label event.
        """

    def GetOldItem(self):
        """
        GetOldItem() -> TreeItemId
        
        Returns the old item index (valid for EVT_TREE_ITEM_CHANGING and
        EVT_TREE_ITEM_CHANGED events).
        """

    def GetPoint(self):
        """
        GetPoint() -> Point
        
        Returns the position of the mouse pointer if the event is a drag or
        menu-context event.
        """

    def IsEditCancelled(self):
        """
        IsEditCancelled() -> bool
        
        Returns true if the label edit was cancelled.
        """

    def SetToolTip(self, tooltip):
        """
        SetToolTip(tooltip)
        
        Set the tooltip for the item (valid for EVT_TREE_ITEM_GETTOOLTIP
        events).
        """

    EVT_TREE_BEGIN_DRAG        = PyEventBinder(wxEVT_TREE_BEGIN_DRAG       , 1)
    EVT_TREE_BEGIN_RDRAG       = PyEventBinder(wxEVT_TREE_BEGIN_RDRAG      , 1)
    EVT_TREE_BEGIN_LABEL_EDIT  = PyEventBinder(wxEVT_TREE_BEGIN_LABEL_EDIT , 1)
    EVT_TREE_END_LABEL_EDIT    = PyEventBinder(wxEVT_TREE_END_LABEL_EDIT   , 1)
    EVT_TREE_DELETE_ITEM       = PyEventBinder(wxEVT_TREE_DELETE_ITEM      , 1)
    EVT_TREE_GET_INFO          = PyEventBinder(wxEVT_TREE_GET_INFO         , 1)
    EVT_TREE_SET_INFO          = PyEventBinder(wxEVT_TREE_SET_INFO         , 1)
    EVT_TREE_ITEM_EXPANDED     = PyEventBinder(wxEVT_TREE_ITEM_EXPANDED    , 1)
    EVT_TREE_ITEM_EXPANDING    = PyEventBinder(wxEVT_TREE_ITEM_EXPANDING   , 1)
    EVT_TREE_ITEM_COLLAPSED    = PyEventBinder(wxEVT_TREE_ITEM_COLLAPSED   , 1)
    EVT_TREE_ITEM_COLLAPSING   = PyEventBinder(wxEVT_TREE_ITEM_COLLAPSING  , 1)
    EVT_TREE_SEL_CHANGED       = PyEventBinder(wxEVT_TREE_SEL_CHANGED      , 1)
    EVT_TREE_SEL_CHANGING      = PyEventBinder(wxEVT_TREE_SEL_CHANGING     , 1)
    EVT_TREE_KEY_DOWN          = PyEventBinder(wxEVT_TREE_KEY_DOWN         , 1)
    EVT_TREE_ITEM_ACTIVATED    = PyEventBinder(wxEVT_TREE_ITEM_ACTIVATED   , 1)
    EVT_TREE_ITEM_RIGHT_CLICK  = PyEventBinder(wxEVT_TREE_ITEM_RIGHT_CLICK , 1)
    EVT_TREE_ITEM_MIDDLE_CLICK = PyEventBinder(wxEVT_TREE_ITEM_MIDDLE_CLICK, 1)
    EVT_TREE_END_DRAG          = PyEventBinder(wxEVT_TREE_END_DRAG         , 1)
    EVT_TREE_STATE_IMAGE_CLICK = PyEventBinder(wxEVT_TREE_STATE_IMAGE_CLICK, 1)
    EVT_TREE_ITEM_GETTOOLTIP   = PyEventBinder(wxEVT_TREE_ITEM_GETTOOLTIP,   1)
    EVT_TREE_ITEM_MENU         = PyEventBinder(wxEVT_TREE_ITEM_MENU,         1)
    
    # deprecated wxEVT aliases
    wxEVT_COMMAND_TREE_BEGIN_DRAG         = wxEVT_TREE_BEGIN_DRAG
    wxEVT_COMMAND_TREE_BEGIN_RDRAG        = wxEVT_TREE_BEGIN_RDRAG
    wxEVT_COMMAND_TREE_BEGIN_LABEL_EDIT   = wxEVT_TREE_BEGIN_LABEL_EDIT
    wxEVT_COMMAND_TREE_END_LABEL_EDIT     = wxEVT_TREE_END_LABEL_EDIT
    wxEVT_COMMAND_TREE_DELETE_ITEM        = wxEVT_TREE_DELETE_ITEM
    wxEVT_COMMAND_TREE_GET_INFO           = wxEVT_TREE_GET_INFO
    wxEVT_COMMAND_TREE_SET_INFO           = wxEVT_TREE_SET_INFO
    wxEVT_COMMAND_TREE_ITEM_EXPANDED      = wxEVT_TREE_ITEM_EXPANDED
    wxEVT_COMMAND_TREE_ITEM_EXPANDING     = wxEVT_TREE_ITEM_EXPANDING
    wxEVT_COMMAND_TREE_ITEM_COLLAPSED     = wxEVT_TREE_ITEM_COLLAPSED
    wxEVT_COMMAND_TREE_ITEM_COLLAPSING    = wxEVT_TREE_ITEM_COLLAPSING
    wxEVT_COMMAND_TREE_SEL_CHANGED        = wxEVT_TREE_SEL_CHANGED
    wxEVT_COMMAND_TREE_SEL_CHANGING       = wxEVT_TREE_SEL_CHANGING
    wxEVT_COMMAND_TREE_KEY_DOWN           = wxEVT_TREE_KEY_DOWN
    wxEVT_COMMAND_TREE_ITEM_ACTIVATED     = wxEVT_TREE_ITEM_ACTIVATED
    wxEVT_COMMAND_TREE_ITEM_RIGHT_CLICK   = wxEVT_TREE_ITEM_RIGHT_CLICK
    wxEVT_COMMAND_TREE_ITEM_MIDDLE_CLICK  = wxEVT_TREE_ITEM_MIDDLE_CLICK
    wxEVT_COMMAND_TREE_END_DRAG           = wxEVT_TREE_END_DRAG
    wxEVT_COMMAND_TREE_STATE_IMAGE_CLICK  = wxEVT_TREE_STATE_IMAGE_CLICK
    wxEVT_COMMAND_TREE_ITEM_GETTOOLTIP    = wxEVT_TREE_ITEM_GETTOOLTIP
    wxEVT_COMMAND_TREE_ITEM_MENU          = wxEVT_TREE_ITEM_MENU
    Item = property(None, None)
    KeyCode = property(None, None)
    KeyEvent = property(None, None)
    Label = property(None, None)
    OldItem = property(None, None)
    Point = property(None, None)
# end of class TreeEvent


def TreeItemData(data):
    return data
TreeItemData = deprecated(TreeItemData, "The TreeItemData class no longer exists, just pass your object directly to the tree instead.")
#-- end-treectrl --#
#-- begin-pickers --#
PB_USE_TEXTCTRL = 0
PB_SMALL = 0
CLRP_USE_TEXTCTRL = 0
CLRP_DEFAULT_STYLE = 0
CLRP_SHOW_LABEL = 0
wxEVT_COLOURPICKER_CHANGED = 0
FLP_OPEN = 0
FLP_SAVE = 0
FLP_OVERWRITE_PROMPT = 0
FLP_FILE_MUST_EXIST = 0
FLP_CHANGE_DIR = 0
FLP_SMALL = 0
FLP_USE_TEXTCTRL = 0
FLP_DEFAULT_STYLE = 0
DIRP_DIR_MUST_EXIST = 0
DIRP_CHANGE_DIR = 0
DIRP_SMALL = 0
DIRP_USE_TEXTCTRL = 0
DIRP_DEFAULT_STYLE = 0
wxEVT_FILEPICKER_CHANGED = 0
wxEVT_DIRPICKER_CHANGED = 0
FNTP_FONTDESC_AS_LABEL = 0
FNTP_USEFONT_FOR_LABEL = 0
FONTBTN_DEFAULT_STYLE = 0
FNTP_USE_TEXTCTRL = 0
FNTP_DEFAULT_STYLE = 0
wxEVT_FONTPICKER_CHANGED = 0

class PickerBase(Control):
    """
    PickerBase()
    
    Base abstract class for all pickers which support an auxiliary text
    control.
    """

    def __init__(self):
        """
        PickerBase()
        
        Base abstract class for all pickers which support an auxiliary text
        control.
        """

    def CreateBase(self, parent, id=ID_ANY, text=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=ButtonNameStr):
        """
        CreateBase(parent, id=ID_ANY, text=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=ButtonNameStr) -> bool
        """

    def GetInternalMargin(self):
        """
        GetInternalMargin() -> int
        
        Returns the margin (in pixel) between the picker and the text control.
        """

    def GetPickerCtrlProportion(self):
        """
        GetPickerCtrlProportion() -> int
        
        Returns the proportion value of the picker.
        """

    def GetTextCtrl(self):
        """
        GetTextCtrl() -> TextCtrl
        
        Returns a pointer to the text control handled by this window or NULL
        if the wxPB_USE_TEXTCTRL style was not specified when this control was
        created.
        """

    def GetPickerCtrl(self):
        """
        GetPickerCtrl() -> Control
        
        Returns the native implementation of the real picker control.
        """

    def GetTextCtrlProportion(self):
        """
        GetTextCtrlProportion() -> int
        
        Returns the proportion value of the text control.
        """

    def HasTextCtrl(self):
        """
        HasTextCtrl() -> bool
        
        Returns true if this window has a valid text control (i.e. if the
        wxPB_USE_TEXTCTRL style was given when creating this control).
        """

    def IsPickerCtrlGrowable(self):
        """
        IsPickerCtrlGrowable() -> bool
        
        Returns true if the picker control is growable.
        """

    def IsTextCtrlGrowable(self):
        """
        IsTextCtrlGrowable() -> bool
        
        Returns true if the text control is growable.
        """

    def SetInternalMargin(self, margin):
        """
        SetInternalMargin(margin)
        
        Sets the margin (in pixel) between the picker and the text control.
        """

    def SetPickerCtrlGrowable(self, grow=True):
        """
        SetPickerCtrlGrowable(grow=True)
        
        Sets the picker control as growable when grow is true.
        """

    def SetPickerCtrlProportion(self, prop):
        """
        SetPickerCtrlProportion(prop)
        
        Sets the proportion value of the picker.
        """

    def SetTextCtrlGrowable(self, grow=True):
        """
        SetTextCtrlGrowable(grow=True)
        
        Sets the text control as growable when grow is true.
        """

    def SetTextCtrlProportion(self, prop):
        """
        SetTextCtrlProportion(prop)
        
        Sets the proportion value of the text control.
        """

    def SetTextCtrl(self, text):
        """
        SetTextCtrl(text)
        """

    def SetPickerCtrl(self, picker):
        """
        SetPickerCtrl(picker)
        """

    def UpdatePickerFromTextCtrl(self):
        """
        UpdatePickerFromTextCtrl()
        """

    def UpdateTextCtrlFromPicker(self):
        """
        UpdateTextCtrlFromPicker()
        """
    InternalMargin = property(None, None)
    PickerCtrl = property(None, None)
    PickerCtrlProportion = property(None, None)
    TextCtrl = property(None, None)
    TextCtrlProportion = property(None, None)

    def GetTextCtrlStyle(self, style):
        """
        GetTextCtrlStyle(style) -> long
        """

    def GetPickerStyle(self, style):
        """
        GetPickerStyle(style) -> long
        """

    def PostCreation(self):
        """
        PostCreation()
        """
# end of class PickerBase

ColourPickerWidgetNameStr = ""
ColourPickerCtrlNameStr = ""

class ColourPickerCtrl(PickerBase):
    """
    ColourPickerCtrl()
    ColourPickerCtrl(parent, id=ID_ANY, colour=BLACK, pos=DefaultPosition, size=DefaultSize, style=CLRP_DEFAULT_STYLE, validator=DefaultValidator, name=ColourPickerCtrlNameStr)
    
    This control allows the user to select a colour.
    """

    def __init__(self, *args, **kw):
        """
        ColourPickerCtrl()
        ColourPickerCtrl(parent, id=ID_ANY, colour=BLACK, pos=DefaultPosition, size=DefaultSize, style=CLRP_DEFAULT_STYLE, validator=DefaultValidator, name=ColourPickerCtrlNameStr)
        
        This control allows the user to select a colour.
        """

    def SetColour(self, *args, **kw):
        """
        SetColour(col)
        SetColour(colname)
        
        Sets the currently selected colour.
        """

    def Create(self, parent, id=ID_ANY, colour=BLACK, pos=DefaultPosition, size=DefaultSize, style=CLRP_DEFAULT_STYLE, validator=DefaultValidator, name=ColourPickerCtrlNameStr):
        """
        Create(parent, id=ID_ANY, colour=BLACK, pos=DefaultPosition, size=DefaultSize, style=CLRP_DEFAULT_STYLE, validator=DefaultValidator, name=ColourPickerCtrlNameStr) -> bool
        
        Creates a colour picker with the given arguments.
        """

    def GetColour(self):
        """
        GetColour() -> Colour
        
        Returns the currently selected colour.
        """
    Colour = property(None, None)
# end of class ColourPickerCtrl


class ColourPickerEvent(CommandEvent):
    """
    ColourPickerEvent()
    ColourPickerEvent(generator, id, colour)
    
    This event class is used for the events generated by
    wxColourPickerCtrl.
    """

    def __init__(self, *args, **kw):
        """
        ColourPickerEvent()
        ColourPickerEvent(generator, id, colour)
        
        This event class is used for the events generated by
        wxColourPickerCtrl.
        """

    def GetColour(self):
        """
        GetColour() -> Colour
        
        Retrieve the colour the user has just selected.
        """

    def SetColour(self, pos):
        """
        SetColour(pos)
        
        Set the colour associated with the event.
        """

    EVT_COLOURPICKER_CHANGED = wx.PyEventBinder( wxEVT_COLOURPICKER_CHANGED, 1 )
    
    # deprecated wxEVT alias
    wxEVT_COMMAND_COLOURPICKER_CHANGED  = wxEVT_COLOURPICKER_CHANGED
    Colour = property(None, None)
# end of class ColourPickerEvent

FilePickerWidgetLabel = ""
FilePickerWidgetNameStr = ""
FilePickerCtrlNameStr = ""
FileSelectorPromptStr = ""
FileSelectorDefaultWildcardStr = ""

class FilePickerCtrl(PickerBase):
    """
    FilePickerCtrl()
    FilePickerCtrl(parent, id=ID_ANY, path=EmptyString, message=FileSelectorPromptStr, wildcard=FileSelectorDefaultWildcardStr, pos=DefaultPosition, size=DefaultSize, style=FLP_DEFAULT_STYLE, validator=DefaultValidator, name=FilePickerCtrlNameStr)
    
    This control allows the user to select a file.
    """

    def __init__(self, *args, **kw):
        """
        FilePickerCtrl()
        FilePickerCtrl(parent, id=ID_ANY, path=EmptyString, message=FileSelectorPromptStr, wildcard=FileSelectorDefaultWildcardStr, pos=DefaultPosition, size=DefaultSize, style=FLP_DEFAULT_STYLE, validator=DefaultValidator, name=FilePickerCtrlNameStr)
        
        This control allows the user to select a file.
        """

    def Create(self, parent, id=ID_ANY, path=EmptyString, message=FileSelectorPromptStr, wildcard=FileSelectorDefaultWildcardStr, pos=DefaultPosition, size=DefaultSize, style=FLP_DEFAULT_STYLE, validator=DefaultValidator, name=FilePickerCtrlNameStr):
        """
        Create(parent, id=ID_ANY, path=EmptyString, message=FileSelectorPromptStr, wildcard=FileSelectorDefaultWildcardStr, pos=DefaultPosition, size=DefaultSize, style=FLP_DEFAULT_STYLE, validator=DefaultValidator, name=FilePickerCtrlNameStr) -> bool
        
        Creates this widget with the given parameters.
        """

    def GetPath(self):
        """
        GetPath() -> String
        
        Returns the absolute path of the currently selected file.
        """

    def SetInitialDirectory(self, dir):
        """
        SetInitialDirectory(dir)
        
        Set the directory to show when starting to browse for files.
        """

    def SetPath(self, filename):
        """
        SetPath(filename)
        
        Sets the absolute path of the currently selected file.
        """
    Path = property(None, None)
# end of class FilePickerCtrl

DirPickerWidgetLabel = ""
DirPickerWidgetNameStr = ""
DirPickerCtrlNameStr = ""
DirSelectorPromptStr = ""

class DirPickerCtrl(PickerBase):
    """
    DirPickerCtrl()
    DirPickerCtrl(parent, id=ID_ANY, path=EmptyString, message=DirSelectorPromptStr, pos=DefaultPosition, size=DefaultSize, style=DIRP_DEFAULT_STYLE, validator=DefaultValidator, name=DirPickerCtrlNameStr)
    
    This control allows the user to select a directory.
    """

    def __init__(self, *args, **kw):
        """
        DirPickerCtrl()
        DirPickerCtrl(parent, id=ID_ANY, path=EmptyString, message=DirSelectorPromptStr, pos=DefaultPosition, size=DefaultSize, style=DIRP_DEFAULT_STYLE, validator=DefaultValidator, name=DirPickerCtrlNameStr)
        
        This control allows the user to select a directory.
        """

    def Create(self, parent, id=ID_ANY, path=EmptyString, message=DirSelectorPromptStr, pos=DefaultPosition, size=DefaultSize, style=DIRP_DEFAULT_STYLE, validator=DefaultValidator, name=DirPickerCtrlNameStr):
        """
        Create(parent, id=ID_ANY, path=EmptyString, message=DirSelectorPromptStr, pos=DefaultPosition, size=DefaultSize, style=DIRP_DEFAULT_STYLE, validator=DefaultValidator, name=DirPickerCtrlNameStr) -> bool
        
        Creates the widgets with the given parameters.
        """

    def GetPath(self):
        """
        GetPath() -> String
        
        Returns the absolute path of the currently selected directory.
        """

    def SetInitialDirectory(self, dir):
        """
        SetInitialDirectory(dir)
        
        Set the directory to show when starting to browse for directories.
        """

    def SetPath(self, dirname):
        """
        SetPath(dirname)
        
        Sets the absolute path of the currently selected directory (the
        default converter uses current locale's charset).
        """
    Path = property(None, None)
# end of class DirPickerCtrl


class FileDirPickerEvent(CommandEvent):
    """
    FileDirPickerEvent()
    FileDirPickerEvent(type, generator, id, path)
    
    This event class is used for the events generated by wxFilePickerCtrl
    and by wxDirPickerCtrl.
    """

    def __init__(self, *args, **kw):
        """
        FileDirPickerEvent()
        FileDirPickerEvent(type, generator, id, path)
        
        This event class is used for the events generated by wxFilePickerCtrl
        and by wxDirPickerCtrl.
        """

    def GetPath(self):
        """
        GetPath() -> String
        
        Retrieve the absolute path of the file/directory the user has just
        selected.
        """

    def SetPath(self, path):
        """
        SetPath(path)
        
        Set the absolute path of the file/directory associated with the event.
        """

    EVT_FILEPICKER_CHANGED = wx.PyEventBinder( wxEVT_FILEPICKER_CHANGED, 1 )
    EVT_DIRPICKER_CHANGED = wx.PyEventBinder( wxEVT_DIRPICKER_CHANGED, 1 )
    
    # deprecated wxEVT aliases
    wxEVT_COMMAND_FILEPICKER_CHANGED   = wxEVT_FILEPICKER_CHANGED
    wxEVT_COMMAND_DIRPICKER_CHANGED    = wxEVT_DIRPICKER_CHANGED
    Path = property(None, None)
# end of class FileDirPickerEvent

FontPickerWidgetNameStr = ""
FontPickerCtrlNameStr = ""

class FontPickerCtrl(PickerBase):
    """
    FontPickerCtrl()
    FontPickerCtrl(parent, id=ID_ANY, font=NullFont, pos=DefaultPosition, size=DefaultSize, style=FNTP_DEFAULT_STYLE, validator=DefaultValidator, name=FontPickerCtrlNameStr)
    
    This control allows the user to select a font.
    """

    def __init__(self, *args, **kw):
        """
        FontPickerCtrl()
        FontPickerCtrl(parent, id=ID_ANY, font=NullFont, pos=DefaultPosition, size=DefaultSize, style=FNTP_DEFAULT_STYLE, validator=DefaultValidator, name=FontPickerCtrlNameStr)
        
        This control allows the user to select a font.
        """

    def Create(self, parent, id=ID_ANY, font=NullFont, pos=DefaultPosition, size=DefaultSize, style=FNTP_DEFAULT_STYLE, validator=DefaultValidator, name=FontPickerCtrlNameStr):
        """
        Create(parent, id=ID_ANY, font=NullFont, pos=DefaultPosition, size=DefaultSize, style=FNTP_DEFAULT_STYLE, validator=DefaultValidator, name=FontPickerCtrlNameStr) -> bool
        
        Creates this widget with given parameters.
        """

    def GetMaxPointSize(self):
        """
        GetMaxPointSize() -> unsignedint
        
        Returns the maximum point size value allowed for the user-chosen font.
        """

    def GetSelectedFont(self):
        """
        GetSelectedFont() -> Font
        
        Returns the currently selected font.
        """

    def SetMaxPointSize(self, max):
        """
        SetMaxPointSize(max)
        
        Sets the maximum point size value allowed for the user-chosen font.
        """

    def SetSelectedFont(self, font):
        """
        SetSelectedFont(font)
        
        Sets the currently selected font.
        """
    MaxPointSize = property(None, None)
    SelectedFont = property(None, None)
# end of class FontPickerCtrl


class FontPickerEvent(CommandEvent):
    """
    FontPickerEvent(generator, id, font)
    
    This event class is used for the events generated by wxFontPickerCtrl.
    """

    def __init__(self, generator, id, font):
        """
        FontPickerEvent(generator, id, font)
        
        This event class is used for the events generated by wxFontPickerCtrl.
        """

    def GetFont(self):
        """
        GetFont() -> Font
        
        Retrieve the font the user has just selected.
        """

    def SetFont(self, f):
        """
        SetFont(f)
        
        Set the font associated with the event.
        """

    EVT_FONTPICKER_CHANGED = wx.PyEventBinder( wxEVT_FONTPICKER_CHANGED, 1 )
    
    # deprecated wxEVT alias
    wxEVT_COMMAND_FONTPICKER_CHANGED  = wxEVT_FONTPICKER_CHANGED
    Font = property(None, None)
# end of class FontPickerEvent


if 'wxMac' in wx.PlatformInfo:
    class ColourPickerCtrl(PickerBase):
        '''
        This control allows the user to select a colour. The
        implementation varies by platform but is usually a button which
        brings up a `wx.ColourDialog` when clicked.


        Window Styles
        -------------

            ======================  ============================================
            wx.CLRP_DEFAULT         Default style.
            wx.CLRP_USE_TEXTCTRL    Creates a text control to the left of the
                                    picker button which is completely managed
                                    by the `wx.ColourPickerCtrl` and which can
                                    be used by the user to specify a colour.
                                    The text control is automatically synchronized
                                    with the button's value. Use functions defined in
                                    `wx.PickerBase` to modify the text control.
            wx.CLRP_SHOW_LABEL      Shows the colour in HTML form (AABBCC) as the
                                    colour button label (instead of no label at all).
            ======================  ============================================

        Events
        ------

            ========================  ==========================================
            EVT_COLOURPICKER_CHANGED  The user changed the colour selected in the
                                      control either using the button or using the
                                      text control (see wx.CLRP_USE_TEXTCTRL; note
                                      that in this case the event is fired only if
                                      the user's input is valid, i.e. recognizable).
            ========================  ==========================================
        '''

        # ColourData object to be shared by all colour pickers, so they can
        # share the custom colours
        _colourData = None

        #--------------------------------------------------
        class ColourPickerButton(BitmapButton):
            def __init__(self, parent, id=-1, colour=wx.BLACK,
                         pos=wx.DefaultPosition, size=wx.DefaultSize,
                         style = CLRP_DEFAULT_STYLE,
                         validator = wx.DefaultValidator,
                         name = "colourpickerwidget"):

                wx.BitmapButton.__init__(self, parent, id, wx.Bitmap(1,1),
                                         pos, size, style, validator, name)
                self.SetColour(colour)
                self.InvalidateBestSize()
                self.SetInitialSize(size)
                self.Bind(wx.EVT_BUTTON, self.OnButtonClick)

                if ColourPickerCtrl._colourData is None:
                    ColourPickerCtrl._colourData = wx.ColourData()
                    ColourPickerCtrl._colourData.SetChooseFull(True)
                    grey = 0
                    for i in range(16):
                        c = wx.Colour(grey, grey, grey)
                        ColourPickerCtrl._colourData.SetCustomColour(i, c)
                        grey += 16

            def SetColour(self, colour):
                # force a copy, in case the _colorData is shared
                self.colour = wx.Colour(colour)
                bmp = self._makeBitmap()
                self.SetBitmapLabel(bmp)

            def GetColour(self):
                return self.colour

            def OnButtonClick(self, evt):
                ColourPickerCtrl._colourData.SetColour(self.colour)
                dlg = wx.ColourDialog(self, ColourPickerCtrl._colourData)
                if dlg.ShowModal() == wx.ID_OK:
                    ColourPickerCtrl._colourData = dlg.GetColourData()
                    self.SetColour(ColourPickerCtrl._colourData.GetColour())
                    evt = wx.ColourPickerEvent(self, self.GetId(), self.GetColour())
                    self.GetEventHandler().ProcessEvent(evt)

            def _makeBitmap(self):
                width = height = 24
                bg = self.GetColour()
                if self.HasFlag(CLRP_SHOW_LABEL):
                    w, h = self.GetTextExtent(bg.GetAsString(wx.C2S_HTML_SYNTAX))
                    width += w
                bmp = wx.Bitmap(width, height)
                dc = wx.MemoryDC(bmp)
                dc.SetBackground(wx.Brush(self.colour))
                dc.Clear()
                if self.HasFlag(CLRP_SHOW_LABEL):
                    from wx.lib.colourutils import BestLabelColour
                    fg = BestLabelColour(bg)
                    dc.SetTextForeground(fg)
                    dc.DrawText(bg.GetAsString(wx.C2S_HTML_SYNTAX),
                                (width - w)/2, (height - h)/2)
                return bmp

        #--------------------------------------------------

        def __init__(self, parent, id=-1, colour=wx.BLACK,
                     pos=wx.DefaultPosition, size=wx.DefaultSize,
                     style = CLRP_DEFAULT_STYLE,
                     validator = wx.DefaultValidator,
                     name = "colourpicker"):
            if type(colour) != wx.Colour:
                colour = wx.Colour(colour)
            wx.PickerBase.__init__(self)
            self.CreateBase(parent, id, colour.GetAsString(),
                            pos, size, style, validator, name)
            widget = ColourPickerCtrl.ColourPickerButton(
                self, -1, colour, style=self.GetPickerStyle(style))
            self.SetPickerCtrl(widget)
            widget.Bind(wx.EVT_COLOURPICKER_CHANGED, self.OnColourChange)
            self.PostCreation()


        def GetColour(self):
            '''Set the displayed colour.'''
            return self.GetPickerCtrl().GetColour()

        def SetColour(self, colour):
            '''Returns the currently selected colour.'''
            self.GetPickerCtrl().SetColour(colour)
            self.UpdateTextCtrlFromPicker()
        Colour = property(GetColour, SetColour)


        def UpdatePickerFromTextCtrl(self):
            col = wx.Colour(self.GetTextCtrl().GetValue())
            if not col.IsOk():
                return
            if self.GetColour() != col:
                self.GetPickerCtrl().SetColour(col)
                evt = wx.ColourPickerEvent(self, self.GetId(), self.GetColour())
                self.GetEventHandler().ProcessEvent(evt)

        def UpdateTextCtrlFromPicker(self):
            if not self.GetTextCtrl():
                return
            self.GetTextCtrl().SetValue(self.GetColour().GetAsString())

        def GetPickerStyle(self, style):
            return style & CLRP_SHOW_LABEL

        def OnColourChange(self, evt):
            self.UpdateTextCtrlFromPicker()
            evt = wx.ColourPickerEvent(self, self.GetId(), self.GetColour())
            self.GetEventHandler().ProcessEvent(evt)
#-- end-pickers --#
#-- begin-filectrl --#
FC_DEFAULT_STYLE = 0
FC_OPEN = 0
FC_SAVE = 0
FC_MULTIPLE = 0
FC_NOSHOWHIDDEN = 0
wxEVT_FILECTRL_SELECTIONCHANGED = 0
wxEVT_FILECTRL_FILEACTIVATED = 0
wxEVT_FILECTRL_FOLDERCHANGED = 0
wxEVT_FILECTRL_FILTERCHANGED = 0
FileCtrlNameStr = ""

class FileCtrl(Control):
    """
    FileCtrl()
    FileCtrl(parent, id=ID_ANY, defaultDirectory=EmptyString, defaultFilename=EmptyString, wildCard=FileSelectorDefaultWildcardStr, style=FC_DEFAULT_STYLE, pos=DefaultPosition, size=DefaultSize, name=FileCtrlNameStr)
    
    This control allows the user to select a file.
    """

    def __init__(self, *args, **kw):
        """
        FileCtrl()
        FileCtrl(parent, id=ID_ANY, defaultDirectory=EmptyString, defaultFilename=EmptyString, wildCard=FileSelectorDefaultWildcardStr, style=FC_DEFAULT_STYLE, pos=DefaultPosition, size=DefaultSize, name=FileCtrlNameStr)
        
        This control allows the user to select a file.
        """

    def Create(self, parent, id=ID_ANY, defaultDirectory=EmptyString, defaultFilename=EmptyString, wildCard=FileSelectorDefaultWildcardStr, style=FC_DEFAULT_STYLE, pos=DefaultPosition, size=DefaultSize, name=FileCtrlNameStr):
        """
        Create(parent, id=ID_ANY, defaultDirectory=EmptyString, defaultFilename=EmptyString, wildCard=FileSelectorDefaultWildcardStr, style=FC_DEFAULT_STYLE, pos=DefaultPosition, size=DefaultSize, name=FileCtrlNameStr) -> bool
        
        Create function for two-step construction.
        """

    def GetDirectory(self):
        """
        GetDirectory() -> String
        
        Returns the current directory of the file control (i.e. the directory
        shown by it).
        """

    def GetFilename(self):
        """
        GetFilename() -> String
        
        Returns the currently selected filename.
        """

    def GetFilenames(self):
        """
        GetFilenames() -> ArrayString
        
        Returns a list of filenames selected in the control.  This function
        should only be used with controls which have the wx.FC_MULTIPLE style,
        use GetFilename for the others.
        """

    def GetFilterIndex(self):
        """
        GetFilterIndex() -> int
        
        Returns the zero-based index of the currently selected filter.
        """

    def GetPath(self):
        """
        GetPath() -> String
        
        Returns the full path (directory and filename) of the currently
        selected file.
        """

    def GetPaths(self):
        """
        GetPaths() -> ArrayString
        
        Returns a list of the full paths (directory and filename) of the files
        chosen. This function should only be used with controlss which have
        the wx.FC_MULTIPLE style, use GetPath for the others.
        """

    def GetWildcard(self):
        """
        GetWildcard() -> String
        
        Returns the current wildcard.
        """

    def SetDirectory(self, directory):
        """
        SetDirectory(directory) -> bool
        
        Sets(changes) the current directory displayed in the control.
        """

    def SetFilename(self, filename):
        """
        SetFilename(filename) -> bool
        
        Selects a certain file.
        """

    def SetPath(self, path):
        """
        SetPath(path) -> bool
        
        Changes to a certain directory and selects a certain file.
        """

    def SetFilterIndex(self, filterIndex):
        """
        SetFilterIndex(filterIndex)
        
        Sets the current filter index, starting from zero.
        """

    def SetWildcard(self, wildCard):
        """
        SetWildcard(wildCard)
        
        Sets the wildcard, which can contain multiple file types, for example:
        "BMP files (*.bmp)|*.bmp|GIF files (*.gif)|*.gif".
        """

    def ShowHidden(self, show):
        """
        ShowHidden(show)
        
        Sets whether hidden files and folders are shown or not.
        """
    Directory = property(None, None)
    Filename = property(None, None)
    Filenames = property(None, None)
    FilterIndex = property(None, None)
    Path = property(None, None)
    Paths = property(None, None)
    Wildcard = property(None, None)
# end of class FileCtrl


class FileCtrlEvent(CommandEvent):
    """
    FileCtrlEvent(type, evtObject, id)
    
    A file control event holds information about events associated with
    wxFileCtrl objects.
    """

    def __init__(self, type, evtObject, id):
        """
        FileCtrlEvent(type, evtObject, id)
        
        A file control event holds information about events associated with
        wxFileCtrl objects.
        """

    def GetDirectory(self):
        """
        GetDirectory() -> String
        
        Returns the current directory.
        """

    def GetFile(self):
        """
        GetFile() -> String
        
        Returns the file selected (assuming it is only one file).
        """

    def GetFiles(self):
        """
        GetFiles() -> ArrayString
        
        Returns the files selected.
        """

    def GetFilterIndex(self):
        """
        GetFilterIndex() -> int
        
        Returns the current file filter index.
        """

    def SetFiles(self, files):
        """
        SetFiles(files)
        
        Sets the files changed by this event.
        """

    def SetDirectory(self, directory):
        """
        SetDirectory(directory)
        
        Sets the directory of this event.
        """

    def SetFilterIndex(self, index):
        """
        SetFilterIndex(index)
        
        Sets the filter index changed by this event.
        """

    EVT_FILECTRL_SELECTIONCHANGED = wx.PyEventBinder( wxEVT_FILECTRL_SELECTIONCHANGED, 1)
    EVT_FILECTRL_FILEACTIVATED = wx.PyEventBinder( wxEVT_FILECTRL_FILEACTIVATED, 1)
    EVT_FILECTRL_FOLDERCHANGED = wx.PyEventBinder( wxEVT_FILECTRL_FOLDERCHANGED, 1)
    EVT_FILECTRL_FILTERCHANGED = wx.PyEventBinder( wxEVT_FILECTRL_FILTERCHANGED, 1)
    Directory = property(None, None)
    File = property(None, None)
    Files = property(None, None)
    FilterIndex = property(None, None)
# end of class FileCtrlEvent

#-- end-filectrl --#
#-- begin-combo --#
CC_SPECIAL_DCLICK = 0
CC_STD_BUTTON = 0

class ComboPopup(object):
    """
    ComboPopup()
    
    In order to use a custom popup with wxComboCtrl, an interface class
    must be derived from wxComboPopup.
    """

    def __init__(self):
        """
        ComboPopup()
        
        In order to use a custom popup with wxComboCtrl, an interface class
        must be derived from wxComboPopup.
        """

    def Create(self, parent):
        """
        Create(parent) -> bool
        
        The derived class must implement this to create the popup control.
        """

    def DestroyPopup(self):
        """
        DestroyPopup()
        
        You only need to implement this member function if you create your
        popup class in non-standard way.
        """

    def Dismiss(self):
        """
        Dismiss()
        
        Utility function that hides the popup.
        """

    def FindItem(self, item, trueItem=None):
        """
        FindItem(item, trueItem=None) -> bool
        
        Implement to customize matching of value string to an item container
        entry.
        """

    def GetAdjustedSize(self, minWidth, prefHeight, maxHeight):
        """
        GetAdjustedSize(minWidth, prefHeight, maxHeight) -> Size
        
        The derived class may implement this to return adjusted size for the
        popup control, according to the variables given.
        """

    def GetComboCtrl(self):
        """
        GetComboCtrl() -> ComboCtrl
        
        Returns pointer to the associated parent wxComboCtrl.
        """

    def GetControl(self):
        """
        GetControl() -> Window
        
        The derived class must implement this to return pointer to the
        associated control created in Create().
        """

    def GetStringValue(self):
        """
        GetStringValue() -> String
        
        The derived class must implement this to return string representation
        of the value.
        """

    def Init(self):
        """
        Init()
        
        The derived class must implement this to initialize its internal
        variables.
        """

    def IsCreated(self):
        """
        IsCreated() -> bool
        
        Utility method that returns true if Create has been called.
        """

    def LazyCreate(self):
        """
        LazyCreate() -> bool
        
        The derived class may implement this to return true if it wants to
        delay call to Create() until the popup is shown for the first time.
        """

    def OnComboDoubleClick(self):
        """
        OnComboDoubleClick()
        
        The derived class may implement this to do something when the parent
        wxComboCtrl gets double-clicked.
        """

    def OnComboKeyEvent(self, event):
        """
        OnComboKeyEvent(event)
        
        The derived class may implement this to receive key events from the
        parent wxComboCtrl.
        """

    def OnDismiss(self):
        """
        OnDismiss()
        
        The derived class may implement this to do special processing when
        popup is hidden.
        """

    def OnPopup(self):
        """
        OnPopup()
        
        The derived class may implement this to do special processing when
        popup is shown.
        """

    def PaintComboControl(self, dc, rect):
        """
        PaintComboControl(dc, rect)
        
        The derived class may implement this to paint the parent wxComboCtrl.
        """

    def SetStringValue(self, value):
        """
        SetStringValue(value)
        
        The derived class must implement this to receive string value changes
        from wxComboCtrl.
        """
    ComboCtrl = property(None, None)
    Control = property(None, None)
    StringValue = property(None, None)
# end of class ComboPopup


class ComboCtrlFeatures(object):
    """
    Features enabled for wxComboCtrl.
    """
    MovableButton = 0
    BitmapButton = 0
    ButtonSpacing = 0
    TextIndent = 0
    PaintControl = 0
    PaintWritable = 0
    Borderless = 0
    All = 0
# end of class ComboCtrlFeatures


class ComboCtrl(Control, TextEntry):
    """
    ComboCtrl()
    ComboCtrl(parent, id=ID_ANY, value=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=ComboBoxNameStr)
    
    A combo control is a generic combobox that allows totally custom
    popup.
    """

    def __init__(self, *args, **kw):
        """
        ComboCtrl()
        ComboCtrl(parent, id=ID_ANY, value=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=ComboBoxNameStr)
        
        A combo control is a generic combobox that allows totally custom
        popup.
        """

    def SetMargins(self, *args, **kw):
        """
        SetMargins(pt) -> bool
        SetMargins(left, top=-1) -> bool
        
        Attempts to set the control margins.
        """

    def Copy(self):
        """
        Copy()
        
        Copies the selected text to the clipboard.
        """

    def Create(self, parent, id=ID_ANY, value=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=ComboBoxNameStr):
        """
        Create(parent, id=ID_ANY, value=EmptyString, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=ComboBoxNameStr) -> bool
        
        Creates the combo control for two-step construction.
        """

    def Cut(self):
        """
        Cut()
        
        Copies the selected text to the clipboard and removes the selection.
        """

    def Dismiss(self):
        """
        Dismiss()
        
        Dismisses the popup window.
        """

    def EnablePopupAnimation(self, enable=True):
        """
        EnablePopupAnimation(enable=True)
        
        Enables or disables popup animation, if any, depending on the value of
        the argument.
        """

    def IsKeyPopupToggle(self, event):
        """
        IsKeyPopupToggle(event) -> bool
        
        Returns true if given key combination should toggle the popup.
        """

    def PrepareBackground(self, dc, rect, flags):
        """
        PrepareBackground(dc, rect, flags)
        
        Prepare background of combo control or an item in a dropdown list in a
        way typical on platform.
        """

    def ShouldDrawFocus(self):
        """
        ShouldDrawFocus() -> bool
        
        Returns true if focus indicator should be drawn in the control.
        """

    def GetBitmapDisabled(self):
        """
        GetBitmapDisabled() -> Bitmap
        
        Returns disabled button bitmap that has been set with
        SetButtonBitmaps().
        """

    def GetBitmapHover(self):
        """
        GetBitmapHover() -> Bitmap
        
        Returns button mouse hover bitmap that has been set with
        SetButtonBitmaps().
        """

    def GetBitmapNormal(self):
        """
        GetBitmapNormal() -> Bitmap
        
        Returns default button bitmap that has been set with
        SetButtonBitmaps().
        """

    def GetBitmapPressed(self):
        """
        GetBitmapPressed() -> Bitmap
        
        Returns depressed button bitmap that has been set with
        SetButtonBitmaps().
        """

    def GetButtonSize(self):
        """
        GetButtonSize() -> Size
        
        Returns current size of the dropdown button.
        """

    def GetCustomPaintWidth(self):
        """
        GetCustomPaintWidth() -> int
        
        Returns custom painted area in control.
        """

    def GetHint(self):
        """
        GetHint() -> String
        
        Returns the current hint string.
        """

    def GetInsertionPoint(self):
        """
        GetInsertionPoint() -> long
        
        Returns the insertion point for the combo control's text field.
        """

    def GetLastPosition(self):
        """
        GetLastPosition() -> long
        
        Returns the last position in the combo control text field.
        """

    def GetMargins(self):
        """
        GetMargins() -> Point
        
        Returns the margins used by the control.
        """

    def GetPopupControl(self):
        """
        GetPopupControl() -> ComboPopup
        
        Returns current popup interface that has been set with
        SetPopupControl().
        """

    def GetPopupWindow(self):
        """
        GetPopupWindow() -> Window
        
        Returns popup window containing the popup control.
        """

    def GetTextCtrl(self):
        """
        GetTextCtrl() -> TextCtrl
        
        Get the text control which is part of the combo control.
        """

    def GetTextIndent(self):
        """
        GetTextIndent() -> Coord
        
        Returns actual indentation in pixels.
        """

    def GetTextRect(self):
        """
        GetTextRect() -> Rect
        
        Returns area covered by the text field (includes everything except
        borders and the dropdown button).
        """

    def GetValue(self):
        """
        GetValue() -> String
        
        Returns text representation of the current value.
        """

    def HidePopup(self, generateEvent=False):
        """
        HidePopup(generateEvent=False)
        
        Dismisses the popup window.
        """

    def IsPopupShown(self):
        """
        IsPopupShown() -> bool
        
        Returns true if the popup is currently shown.
        """

    def IsPopupWindowState(self, state):
        """
        IsPopupWindowState(state) -> bool
        
        Returns true if the popup window is in the given state.
        """

    def OnButtonClick(self):
        """
        OnButtonClick()
        
        Implement in a derived class to define what happens on dropdown button
        click.
        """

    def Paste(self):
        """
        Paste()
        
        Pastes text from the clipboard to the text field.
        """

    def Popup(self):
        """
        Popup()
        
        Shows the popup portion of the combo control.
        """

    def Remove(self, frm, to):
        """
        Remove(frm, to)
        
        Removes the text between the two positions in the combo control text
        field.
        """

    def Replace(self, frm, to, text):
        """
        Replace(frm, to, text)
        
        Replaces the text between two positions with the given text, in the
        combo control text field.
        """

    def SetButtonBitmaps(self, bmpNormal, pushButtonBg=False, bmpPressed=NullBitmap, bmpHover=NullBitmap, bmpDisabled=NullBitmap):
        """
        SetButtonBitmaps(bmpNormal, pushButtonBg=False, bmpPressed=NullBitmap, bmpHover=NullBitmap, bmpDisabled=NullBitmap)
        
        Sets custom dropdown button graphics.
        """

    def SetButtonPosition(self, width=-1, height=-1, side=RIGHT, spacingX=0):
        """
        SetButtonPosition(width=-1, height=-1, side=RIGHT, spacingX=0)
        
        Sets size and position of dropdown button.
        """

    def SetCustomPaintWidth(self, width):
        """
        SetCustomPaintWidth(width)
        
        Set width, in pixels, of custom painted area in control without
        wxCB_READONLY style.
        """

    def SetHint(self, hint):
        """
        SetHint(hint) -> bool
        
        Sets a hint shown in an empty unfocused combo control.
        """

    def SetInsertionPoint(self, pos):
        """
        SetInsertionPoint(pos)
        
        Sets the insertion point in the text field.
        """

    def SetInsertionPointEnd(self):
        """
        SetInsertionPointEnd()
        
        Sets the insertion point at the end of the combo control text field.
        """

    def SetPopupAnchor(self, anchorSide):
        """
        SetPopupAnchor(anchorSide)
        
        Set side of the control to which the popup will align itself.
        """

    def SetPopupControl(self, popup):
        """
        SetPopupControl(popup)
        
        Set popup interface class derived from wxComboPopup.
        """

    def SetPopupExtents(self, extLeft, extRight):
        """
        SetPopupExtents(extLeft, extRight)
        
        Extends popup size horizontally, relative to the edges of the combo
        control.
        """

    def SetPopupMaxHeight(self, height):
        """
        SetPopupMaxHeight(height)
        
        Sets preferred maximum height of the popup.
        """

    def SetPopupMinWidth(self, width):
        """
        SetPopupMinWidth(width)
        
        Sets minimum width of the popup.
        """

    def SetSelection(self, frm, to):
        """
        SetSelection(frm, to)
        
        Selects the text between the two positions, in the combo control text
        field.
        """

    def SetText(self, value):
        """
        SetText(value)
        
        Sets the text for the text field without affecting the popup.
        """

    def SetTextCtrlStyle(self, style):
        """
        SetTextCtrlStyle(style)
        
        Set a custom window style for the embedded wxTextCtrl.
        """

    def SetTextIndent(self, indent):
        """
        SetTextIndent(indent)
        
        This will set the space in pixels between left edge of the control and
        the text, regardless whether control is read-only or not.
        """

    def SetValue(self, value):
        """
        SetValue(value)
        
        Sets the text for the combo control text field.
        """

    def SetValueByUser(self, value):
        """
        SetValueByUser(value)
        
        Changes value of the control as if user had done it by selecting an
        item from a combo box drop-down list.
        """

    def ShowPopup(self):
        """
        ShowPopup()
        
        Show the popup.
        """

    def Undo(self):
        """
        Undo()
        
        Undoes the last edit in the text field.
        """

    def UseAltPopupWindow(self, enable=True):
        """
        UseAltPopupWindow(enable=True)
        
        Enable or disable usage of an alternative popup window, which
        guarantees ability to focus the popup control, and allows common
        native controls to function normally.
        """

    @staticmethod
    def GetFeatures():
        """
        GetFeatures() -> int
        
        Returns features supported by wxComboCtrl.
        """
    BitmapDisabled = property(None, None)
    BitmapHover = property(None, None)
    BitmapNormal = property(None, None)
    BitmapPressed = property(None, None)
    ButtonSize = property(None, None)
    CustomPaintWidth = property(None, None)
    Hint = property(None, None)
    InsertionPoint = property(None, None)
    LastPosition = property(None, None)
    Margins = property(None, None)
    PopupControl = property(None, None)
    PopupWindow = property(None, None)
    TextCtrl = property(None, None)
    TextIndent = property(None, None)
    TextRect = property(None, None)
    Value = property(None, None)

    def AnimateShow(self, rect, flags):
        """
        AnimateShow(rect, flags) -> bool
        
        This member function is not normally called in application code.
        """

    def DoSetPopupControl(self, popup):
        """
        DoSetPopupControl(popup)
        
        This member function is not normally called in application code.
        """

    def DoShowPopup(self, rect, flags):
        """
        DoShowPopup(rect, flags)
        
        This member function is not normally called in application code.
        """
# end of class ComboCtrl

#-- end-combo --#
#-- begin-choicebk --#
CHB_DEFAULT = 0
CHB_TOP = 0
CHB_BOTTOM = 0
CHB_LEFT = 0
CHB_RIGHT = 0
CHB_ALIGN_MASK = 0
wxEVT_CHOICEBOOK_PAGE_CHANGED = 0
wxEVT_CHOICEBOOK_PAGE_CHANGING = 0

class Choicebook(BookCtrlBase):
    """
    Choicebook()
    Choicebook(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=EmptyString)
    
    wxChoicebook is a class similar to wxNotebook, but uses a wxChoice
    control to show the labels instead of the tabs.
    """

    def __init__(self, *args, **kw):
        """
        Choicebook()
        Choicebook(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=EmptyString)
        
        wxChoicebook is a class similar to wxNotebook, but uses a wxChoice
        control to show the labels instead of the tabs.
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=EmptyString):
        """
        Create(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=EmptyString) -> bool
        
        Create the choicebook control that has already been constructed with
        the default constructor.
        """

    def GetChoiceCtrl(self):
        """
        GetChoiceCtrl() -> Choice
        
        Returns the wxChoice associated with the control.
        """
    ChoiceCtrl = property(None, None)
# end of class Choicebook


EVT_CHOICEBOOK_PAGE_CHANGED  = wx.PyEventBinder( wxEVT_CHOICEBOOK_PAGE_CHANGED, 1 )
EVT_CHOICEBOOK_PAGE_CHANGING = wx.PyEventBinder( wxEVT_CHOICEBOOK_PAGE_CHANGING, 1 )

# deprecated wxEVT aliases
wxEVT_COMMAND_CHOICEBOOK_PAGE_CHANGED   = wxEVT_CHOICEBOOK_PAGE_CHANGED
wxEVT_COMMAND_CHOICEBOOK_PAGE_CHANGING  = wxEVT_CHOICEBOOK_PAGE_CHANGING
#-- end-choicebk --#
#-- begin-listbook --#
LB_DEFAULT = 0
LB_TOP = 0
LB_BOTTOM = 0
LB_LEFT = 0
LB_RIGHT = 0
LB_ALIGN_MASK = 0
wxEVT_LISTBOOK_PAGE_CHANGED = 0
wxEVT_LISTBOOK_PAGE_CHANGING = 0

class Listbook(BookCtrlBase):
    """
    Listbook()
    Listbook(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=EmptyString)
    
    wxListbook is a class similar to wxNotebook but which uses a
    wxListCtrl to show the labels instead of the tabs.
    """

    def __init__(self, *args, **kw):
        """
        Listbook()
        Listbook(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=EmptyString)
        
        wxListbook is a class similar to wxNotebook but which uses a
        wxListCtrl to show the labels instead of the tabs.
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=EmptyString):
        """
        Create(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=EmptyString) -> bool
        
        Create the list book control that has already been constructed with
        the default constructor.
        """

    def GetListView(self):
        """
        GetListView() -> ListView
        
        Returns the wxListView associated with the control.
        """
    ListView = property(None, None)
# end of class Listbook


EVT_LISTBOOK_PAGE_CHANGED  = wx.PyEventBinder( wxEVT_LISTBOOK_PAGE_CHANGED, 1 )
EVT_LISTBOOK_PAGE_CHANGING = wx.PyEventBinder( wxEVT_LISTBOOK_PAGE_CHANGING, 1 )

# deprecated wxEVT aliases
wxEVT_COMMAND_LISTBOOK_PAGE_CHANGED   = wxEVT_LISTBOOK_PAGE_CHANGED
wxEVT_COMMAND_LISTBOOK_PAGE_CHANGING  = wxEVT_LISTBOOK_PAGE_CHANGING
#-- end-listbook --#
#-- begin-toolbook --#
TBK_BUTTONBAR = 0
TBK_HORZ_LAYOUT = 0
wxEVT_TOOLBOOK_PAGE_CHANGED = 0
wxEVT_TOOLBOOK_PAGE_CHANGING = 0

class Toolbook(BookCtrlBase):
    """
    Toolbook()
    Toolbook(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=EmptyString)
    
    wxToolbook is a class similar to wxNotebook but which uses a wxToolBar
    to show the labels instead of the tabs.
    """

    def __init__(self, *args, **kw):
        """
        Toolbook()
        Toolbook(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=EmptyString)
        
        wxToolbook is a class similar to wxNotebook but which uses a wxToolBar
        to show the labels instead of the tabs.
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=EmptyString):
        """
        Create(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=EmptyString) -> bool
        
        Create the tool book control that has already been constructed with
        the default constructor.
        """

    def GetToolBar(self):
        """
        GetToolBar() -> ToolBar
        
        Return the toolbar used for page selection.
        """
    ToolBar = property(None, None)
# end of class Toolbook


EVT_TOOLBOOK_PAGE_CHANGED  = wx.PyEventBinder( wxEVT_TOOLBOOK_PAGE_CHANGED, 1 )
EVT_TOOLBOOK_PAGE_CHANGING = wx.PyEventBinder( wxEVT_TOOLBOOK_PAGE_CHANGING, 1 )

# deprecated wxEVT aliases
wxEVT_COMMAND_TOOLBOOK_PAGE_CHANGED   = wxEVT_TOOLBOOK_PAGE_CHANGED
wxEVT_COMMAND_TOOLBOOK_PAGE_CHANGING  = wxEVT_TOOLBOOK_PAGE_CHANGING
#-- end-toolbook --#
#-- begin-treebook --#
wxEVT_TREEBOOK_PAGE_CHANGED = 0
wxEVT_TREEBOOK_PAGE_CHANGING = 0
wxEVT_TREEBOOK_NODE_COLLAPSED = 0
wxEVT_TREEBOOK_NODE_EXPANDED = 0

class Treebook(BookCtrlBase):
    """
    Treebook()
    Treebook(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=BK_DEFAULT, name=EmptyString)
    
    This class is an extension of the wxNotebook class that allows a tree
    structured set of pages to be shown in a control.
    """

    def __init__(self, *args, **kw):
        """
        Treebook()
        Treebook(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=BK_DEFAULT, name=EmptyString)
        
        This class is an extension of the wxNotebook class that allows a tree
        structured set of pages to be shown in a control.
        """

    def AddPage(self, page, text, bSelect=False, imageId=NOT_FOUND):
        """
        AddPage(page, text, bSelect=False, imageId=NOT_FOUND) -> bool
        
        Adds a new page.
        """

    def AddSubPage(self, page, text, bSelect=False, imageId=NOT_FOUND):
        """
        AddSubPage(page, text, bSelect=False, imageId=NOT_FOUND) -> bool
        
        Adds a new child-page to the last top-level page.
        """

    def CollapseNode(self, pageId):
        """
        CollapseNode(pageId) -> bool
        
        Shortcut for ExpandNode( pageId, false ).
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=BK_DEFAULT, name=EmptyString):
        """
        Create(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=BK_DEFAULT, name=EmptyString) -> bool
        
        Creates a treebook control.
        """

    def DeletePage(self, pagePos):
        """
        DeletePage(pagePos) -> bool
        
        Deletes the page at the specified position and all its children.
        """

    def ExpandNode(self, pageId, expand=True):
        """
        ExpandNode(pageId, expand=True) -> bool
        
        Expands (collapses) the pageId node.
        """

    def GetPageParent(self, page):
        """
        GetPageParent(page) -> int
        
        Returns the parent page of the given one or wxNOT_FOUND if this is a
        top-level page.
        """

    def GetSelection(self):
        """
        GetSelection() -> int
        
        Returns the currently selected page, or wxNOT_FOUND if none was
        selected.
        """

    def InsertPage(self, pagePos, page, text, bSelect=False, imageId=NOT_FOUND):
        """
        InsertPage(pagePos, page, text, bSelect=False, imageId=NOT_FOUND) -> bool
        
        Inserts a new page just before the page indicated by pagePos.
        """

    def InsertSubPage(self, pagePos, page, text, bSelect=False, imageId=NOT_FOUND):
        """
        InsertSubPage(pagePos, page, text, bSelect=False, imageId=NOT_FOUND) -> bool
        
        Inserts a sub page under the specified page.
        """

    def IsNodeExpanded(self, pageId):
        """
        IsNodeExpanded(pageId) -> bool
        
        Returns true if the page represented by pageId is expanded.
        """
    Selection = property(None, None)
# end of class Treebook


EVT_TREEBOOK_PAGE_CHANGED = wx.PyEventBinder( wxEVT_TREEBOOK_PAGE_CHANGED, 1 )
EVT_TREEBOOK_PAGE_CHANGING = wx.PyEventBinder( wxEVT_TREEBOOK_PAGE_CHANGING, 1)
EVT_TREEBOOK_NODE_COLLAPSED = wx.PyEventBinder( wxEVT_TREEBOOK_NODE_COLLAPSED, 1 )
EVT_TREEBOOK_NODE_EXPANDED = wx.PyEventBinder( wxEVT_TREEBOOK_NODE_EXPANDED, 1 )

# deprecated wxEVT aliases
wxEVT_COMMAND_TREEBOOK_PAGE_CHANGED    = wxEVT_TREEBOOK_PAGE_CHANGED
wxEVT_COMMAND_TREEBOOK_PAGE_CHANGING   = wxEVT_TREEBOOK_PAGE_CHANGING
wxEVT_COMMAND_TREEBOOK_NODE_COLLAPSED  = wxEVT_TREEBOOK_NODE_COLLAPSED
wxEVT_COMMAND_TREEBOOK_NODE_EXPANDED   = wxEVT_TREEBOOK_NODE_EXPANDED
#-- end-treebook --#
#-- begin-vlbox --#
VListBoxNameStr = ""

class VListBox(VScrolledWindow):
    """
    VListBox()
    VListBox(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=VListBoxNameStr)
    
    wxVListBox is a wxListBox-like control with the following two main
    differences from a regular wxListBox: it can have an arbitrarily huge
    number of items because it doesn't store them itself but uses the
    OnDrawItem() callback to draw them (so it is a virtual listbox) and
    its items can have variable height as determined by OnMeasureItem()
    (so it is also a listbox with the lines of variable height).
    """

    def __init__(self, *args, **kw):
        """
        VListBox()
        VListBox(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=VListBoxNameStr)
        
        wxVListBox is a wxListBox-like control with the following two main
        differences from a regular wxListBox: it can have an arbitrarily huge
        number of items because it doesn't store them itself but uses the
        OnDrawItem() callback to draw them (so it is a virtual listbox) and
        its items can have variable height as determined by OnMeasureItem()
        (so it is also a listbox with the lines of variable height).
        """

    def SetMargins(self, *args, **kw):
        """
        SetMargins(pt)
        SetMargins(x, y)
        
        Set the margins: horizontal margin is the distance between the window
        border and the item contents while vertical margin is half of the
        distance between items.
        """

    def Clear(self):
        """
        Clear()
        
        Deletes all items from the control.
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=VListBoxNameStr):
        """
        Create(parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=VListBoxNameStr) -> bool
        
        Creates the control.
        """

    def DeselectAll(self):
        """
        DeselectAll() -> bool
        
        Deselects all the items in the listbox.
        """

    def GetFirstSelected(self):
        """
        GetFirstSelected() -> (int, cookie)
        
        Returns the index of the first selected item in the listbox or
        wxNOT_FOUND if no items are currently selected.
        """

    def GetItemCount(self):
        """
        GetItemCount() -> size_t
        
        Get the number of items in the control.
        """

    def GetMargins(self):
        """
        GetMargins() -> Point
        
        Returns the margins used by the control.
        """

    def GetItemRect(self, item):
        """
        GetItemRect(item) -> Rect
        
        Returns the rectangle occupied by this item in physical coordinates.
        """

    def GetNextSelected(self, cookie):
        """
        GetNextSelected(cookie) -> (int, cookie)
        
        Returns the index of the next selected item or wxNOT_FOUND if there
        are no more.
        """

    def GetSelectedCount(self):
        """
        GetSelectedCount() -> size_t
        
        Returns the number of the items currently selected.
        """

    def GetSelection(self):
        """
        GetSelection() -> int
        
        Get the currently selected item or wxNOT_FOUND if there is no
        selection.
        """

    def GetSelectionBackground(self):
        """
        GetSelectionBackground() -> Colour
        
        Returns the background colour used for the selected cells.
        """

    def HasMultipleSelection(self):
        """
        HasMultipleSelection() -> bool
        
        Returns true if the listbox was created with wxLB_MULTIPLE style and
        so supports multiple selection or false if it is a single selection
        listbox.
        """

    def IsCurrent(self, item):
        """
        IsCurrent(item) -> bool
        
        Returns true if this item is the current one, false otherwise.
        """

    def IsSelected(self, item):
        """
        IsSelected(item) -> bool
        
        Returns true if this item is selected, false otherwise.
        """

    def Select(self, item, select=True):
        """
        Select(item, select=True) -> bool
        
        Selects or deselects the specified item which must be valid (i.e. not
        equal to wxNOT_FOUND).
        """

    def SelectAll(self):
        """
        SelectAll() -> bool
        
        Selects all the items in the listbox.
        """

    def SelectRange(self, from_, to_):
        """
        SelectRange(from_, to_) -> bool
        
        Selects all items in the specified range which may be given in any
        order.
        """

    def SetItemCount(self, count):
        """
        SetItemCount(count)
        
        Set the number of items to be shown in the control.
        """

    def SetSelection(self, selection):
        """
        SetSelection(selection)
        
        Set the selection to the specified item, if it is -1 the selection is
        unset.
        """

    def SetSelectionBackground(self, col):
        """
        SetSelectionBackground(col)
        
        Sets the colour to be used for the selected cells background.
        """

    def Toggle(self, item):
        """
        Toggle(item)
        
        Toggles the state of the specified item, i.e. selects it if it was
        unselected and deselects it if it was selected.
        """
    ItemCount = property(None, None)
    Margins = property(None, None)
    SelectedCount = property(None, None)
    Selection = property(None, None)
    SelectionBackground = property(None, None)

    def OnDrawItem(self, dc, rect, n):
        """
        OnDrawItem(dc, rect, n)
        
        The derived class must implement this function to actually draw the
        item with the given index on the provided DC.
        """

    def OnDrawBackground(self, dc, rect, n):
        """
        OnDrawBackground(dc, rect, n)
        
        This method is used to draw the item's background and, maybe, a border
        around it.
        """

    def OnDrawSeparator(self, dc, rect, n):
        """
        OnDrawSeparator(dc, rect, n)
        
        This method may be used to draw separators between the lines.
        """

    def OnMeasureItem(self, n):
        """
        OnMeasureItem(n) -> Coord
        
        The derived class must implement this method to return the height of
        the specified item (in pixels).
        """
# end of class VListBox

#-- end-vlbox --#
#-- begin-nonownedwnd --#
FRAME_SHAPED = 0

class NonOwnedWindow(Window):
    """
    Common base class for all non-child windows.
    """

    def SetShape(self, *args, **kw):
        """
        SetShape(region) -> bool
        SetShape(path) -> bool
        
        If the platform supports it, sets the shape of the window to that
        depicted by region.
        """
# end of class NonOwnedWindow

#-- end-nonownedwnd --#
#-- begin-toplevel --#
DEFAULT_FRAME_STYLE = 0
USER_ATTENTION_INFO = 0
USER_ATTENTION_ERROR = 0
FULLSCREEN_NOMENUBAR = 0
FULLSCREEN_NOTOOLBAR = 0
FULLSCREEN_NOSTATUSBAR = 0
FULLSCREEN_NOBORDER = 0
FULLSCREEN_NOCAPTION = 0
FULLSCREEN_ALL = 0
FrameNameStr = ""

class TopLevelWindow(NonOwnedWindow):
    """
    TopLevelWindow()
    TopLevelWindow(parent, id=ID_ANY, title=EmptyString, pos=DefaultPosition, size=DefaultSize, style=DEFAULT_FRAME_STYLE, name=FrameNameStr)
    
    wxTopLevelWindow is a common base class for wxDialog and wxFrame.
    """

    def __init__(self, *args, **kw):
        """
        TopLevelWindow()
        TopLevelWindow(parent, id=ID_ANY, title=EmptyString, pos=DefaultPosition, size=DefaultSize, style=DEFAULT_FRAME_STYLE, name=FrameNameStr)
        
        wxTopLevelWindow is a common base class for wxDialog and wxFrame.
        """

    def Create(self, parent, id=ID_ANY, title=EmptyString, pos=DefaultPosition, size=DefaultSize, style=DEFAULT_FRAME_STYLE, name=FrameNameStr):
        """
        Create(parent, id=ID_ANY, title=EmptyString, pos=DefaultPosition, size=DefaultSize, style=DEFAULT_FRAME_STYLE, name=FrameNameStr) -> bool
        
        Creates the top level window.
        """

    def CanSetTransparent(self):
        """
        CanSetTransparent() -> bool
        
        Returns true if the platform supports making the window translucent.
        """

    def CenterOnScreen(self, direction=BOTH):
        """
        CenterOnScreen(direction=BOTH)
        
        A synonym for CentreOnScreen().
        """

    def CentreOnScreen(self, direction=BOTH):
        """
        CentreOnScreen(direction=BOTH)
        
        Centres the window on screen.
        """

    def EnableCloseButton(self, enable=True):
        """
        EnableCloseButton(enable=True) -> bool
        
        Enables or disables the Close button (most often in the right upper
        corner of a dialog) and the Close entry of the system menu (most often
        in the left upper corner of the dialog).
        """

    def GetDefaultItem(self):
        """
        GetDefaultItem() -> Window
        
        Returns a pointer to the button which is the default for this window,
        or  NULL.
        """

    def GetIcon(self):
        """
        GetIcon() -> Icon
        
        Returns the standard icon of the window.
        """

    def GetIcons(self):
        """
        GetIcons() -> IconBundle
        
        Returns all icons associated with the window, there will be none of
        them if neither SetIcon() nor SetIcons() had been called before.
        """

    def GetTitle(self):
        """
        GetTitle() -> String
        
        Gets a string containing the window title.
        """

    def Iconize(self, iconize=True):
        """
        Iconize(iconize=True)
        
        Iconizes or restores the window.
        """

    def IsActive(self):
        """
        IsActive() -> bool
        
        Returns true if this window is currently active, i.e. if the user is
        currently working with it.
        """

    def IsAlwaysMaximized(self):
        """
        IsAlwaysMaximized() -> bool
        
        Returns true if this window is expected to be always maximized, either
        due to platform policy or due to local policy regarding particular
        class.
        """

    def IsFullScreen(self):
        """
        IsFullScreen() -> bool
        
        Returns true if the window is in fullscreen mode.
        """

    def IsIconized(self):
        """
        IsIconized() -> bool
        
        Returns true if the window is iconized.
        """

    def IsMaximized(self):
        """
        IsMaximized() -> bool
        
        Returns true if the window is maximized.
        """

    def Layout(self):
        """
        Layout() -> bool
        
        See wxWindow::SetAutoLayout(): when auto layout is on, this function
        gets called automatically when the window is resized.
        """

    def Maximize(self, maximize=True):
        """
        Maximize(maximize=True)
        
        Maximizes or restores the window.
        """

    def RequestUserAttention(self, flags=USER_ATTENTION_INFO):
        """
        RequestUserAttention(flags=USER_ATTENTION_INFO)
        
        Use a system-dependent way to attract users attention to the window
        when it is in background.
        """

    def Restore(self):
        """
        Restore()
        
        Restore a previously iconized or maximized window to its normal state.
        """

    def SetDefaultItem(self, win):
        """
        SetDefaultItem(win) -> Window
        
        Changes the default item for the panel, usually win is a button.
        """

    def SetTmpDefaultItem(self, win):
        """
        SetTmpDefaultItem(win) -> Window
        """

    def GetTmpDefaultItem(self):
        """
        GetTmpDefaultItem() -> Window
        """

    def SetIcon(self, icon):
        """
        SetIcon(icon)
        
        Sets the icon for this window.
        """

    def SetIcons(self, icons):
        """
        SetIcons(icons)
        
        Sets several icons of different sizes for this window: this allows to
        use different icons for different situations (e.g.
        """

    def SetMaxSize(self, size):
        """
        SetMaxSize(size)
        
        A simpler interface for setting the size hints than SetSizeHints().
        """

    def SetMinSize(self, size):
        """
        SetMinSize(size)
        
        A simpler interface for setting the size hints than SetSizeHints().
        """

    def SetSizeHints(self, *args, **kw):
        """
        SetSizeHints(minW, minH, maxW=-1, maxH=-1, incW=-1, incH=-1)
        SetSizeHints(minSize, maxSize=DefaultSize, incSize=DefaultSize)
        
        Allows specification of minimum and maximum window sizes, and window
        size increments.
        """

    def SetTitle(self, title):
        """
        SetTitle(title)
        
        Sets the window title.
        """

    def SetTransparent(self, alpha):
        """
        SetTransparent(alpha) -> bool
        
        If the platform supports it will set the window to be translucent.
        """

    def ShouldPreventAppExit(self):
        """
        ShouldPreventAppExit() -> bool
        
        This virtual function is not meant to be called directly but can be
        overridden to return false (it returns true by default) to allow the
        application to close even if this, presumably not very important,
        window is still opened.
        """

    def OSXSetModified(self, modified):
        """
        OSXSetModified(modified)
        
        This function sets the wxTopLevelWindow's modified state on OS X,
        which currently draws a black dot in the wxTopLevelWindow's close
        button.
        """

    def OSXIsModified(self):
        """
        OSXIsModified() -> bool
        
        Returns the current modified state of the wxTopLevelWindow on OS X.
        """

    def SetRepresentedFilename(self, filename):
        """
        SetRepresentedFilename(filename)
        
        Sets the file name represented by this wxTopLevelWindow.
        """

    def ShowWithoutActivating(self):
        """
        ShowWithoutActivating()
        
        Show the wxTopLevelWindow, but do not give it keyboard focus.
        """

    def ShowFullScreen(self, show, style=FULLSCREEN_ALL):
        """
        ShowFullScreen(show, style=FULLSCREEN_ALL) -> bool
        
        Depending on the value of show parameter the window is either shown
        full screen or restored to its normal state.
        """

    @staticmethod
    def GetDefaultSize():
        """
        GetDefaultSize() -> Size
        
        Get the default size for a new top level window.
        """

    def MacSetMetalAppearance(self, on):
        """
        MacSetMetalAppearance(on)
        """

    def MacGetMetalAppearance(self):
        """
        MacGetMetalAppearance() -> bool
        """

    def MacGetUnifiedAppearance(self):
        """
        MacGetUnifiedAppearance() -> bool
        """

    def MacGetTopLevelWindowRef(self):
        """
        MacGetTopLevelWindowRef() -> void
        """
    DefaultItem = property(None, None)
    Icon = property(None, None)
    Title = property(None, None)
    TmpDefaultItem = property(None, None)
    OSXModified = property(None, None)
    MacMetalAppearance = property(None, None)
# end of class TopLevelWindow

#-- end-toplevel --#
#-- begin-dialog --#
DIALOG_NO_PARENT = 0
DEFAULT_DIALOG_STYLE = 0
DIALOG_ADAPTATION_NONE = 0
DIALOG_ADAPTATION_STANDARD_SIZER = 0
DIALOG_ADAPTATION_ANY_SIZER = 0
DIALOG_ADAPTATION_LOOSE_BUTTONS = 0
DIALOG_ADAPTATION_MODE_DEFAULT = 0
DIALOG_ADAPTATION_MODE_ENABLED = 0
DIALOG_ADAPTATION_MODE_DISABLED = 0
DialogNameStr = ""

class Dialog(TopLevelWindow):
    """
    Dialog()
    Dialog(parent, id=ID_ANY, title=EmptyString, pos=DefaultPosition, size=DefaultSize, style=DEFAULT_DIALOG_STYLE, name=DialogNameStr)
    
    A dialog box is a window with a title bar and sometimes a system menu,
    which can be moved around the screen.
    """

    def __init__(self, *args, **kw):
        """
        Dialog()
        Dialog(parent, id=ID_ANY, title=EmptyString, pos=DefaultPosition, size=DefaultSize, style=DEFAULT_DIALOG_STYLE, name=DialogNameStr)
        
        A dialog box is a window with a title bar and sometimes a system menu,
        which can be moved around the screen.
        """

    def AddMainButtonId(self, id):
        """
        AddMainButtonId(id)
        
        Adds an identifier to be regarded as a main button for the non-
        scrolling area of a dialog.
        """

    def CanDoLayoutAdaptation(self):
        """
        CanDoLayoutAdaptation() -> bool
        
        Returns true if this dialog can and should perform layout adaptation
        using DoLayoutAdaptation(), usually if the dialog is too large to fit
        on the display.
        """

    def Centre(self, direction=BOTH):
        """
        Centre(direction=BOTH)
        
        Centres the dialog box on the display.
        """

    def Create(self, parent, id=ID_ANY, title=EmptyString, pos=DefaultPosition, size=DefaultSize, style=DEFAULT_DIALOG_STYLE, name=DialogNameStr):
        """
        Create(parent, id=ID_ANY, title=EmptyString, pos=DefaultPosition, size=DefaultSize, style=DEFAULT_DIALOG_STYLE, name=DialogNameStr) -> bool
        
        Used for two-step dialog box construction.
        """

    def CreateButtonSizer(self, flags):
        """
        CreateButtonSizer(flags) -> Sizer
        
        Creates a sizer with standard buttons.
        """

    def CreateSeparatedButtonSizer(self, flags):
        """
        CreateSeparatedButtonSizer(flags) -> Sizer
        
        Creates a sizer with standard buttons using CreateButtonSizer()
        separated from the rest of the dialog contents by a horizontal
        wxStaticLine.
        """

    def CreateSeparatedSizer(self, sizer):
        """
        CreateSeparatedSizer(sizer) -> Sizer
        
        Returns the sizer containing the given one with a separating
        wxStaticLine if necessarily.
        """

    def CreateStdDialogButtonSizer(self, flags):
        """
        CreateStdDialogButtonSizer(flags) -> StdDialogButtonSizer
        
        Creates a wxStdDialogButtonSizer with standard buttons.
        """

    def CreateTextSizer(self, message):
        """
        CreateTextSizer(message) -> Sizer
        
        Splits text up at newlines and places the lines into wxStaticText
        objects in a vertical wxBoxSizer.
        """

    def DoLayoutAdaptation(self):
        """
        DoLayoutAdaptation() -> bool
        
        Performs layout adaptat