# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# This file is generated by wxPython's PI generator.  Do not edit by hand.
#
# The *.pyi files are used by PyCharm to provide more information than it is
# able to glean from introspection of extension types and methods.  They are
# not intended to be imported, executed or used for any other purpose other
# than providing info to the IDE.  If you don't use PyCharm you can safely
# ignore this file.
#
# See: https://www.jetbrains.com/help/pycharm/2016.1/type-hinting-in-pycharm.html
#
# Copyright: (c) 2011-2016 by Total Control Software
# License:   wxWindows License
#---------------------------------------------------------------------------


"""
The :class:`RichTextCtrl` is a generic, ground-up implementation of a rich
text control capable of showing multiple text styles and images.  This module
contains the control and many supporting classes needed for using the features
of the :class:`RichTextCtrl`.

.. note:: Due to some internal dynamic initialization in wxWidgets, this
          module should be imported **before** the :class:`wx.App` object is
          created.
"""
#-- begin-_richtext --#
import wx.xml
import wx.html
import wx.adv

import wx
#-- end-_richtext --#
#-- begin-richtextbuffer --#
RICHTEXT_FIXED_WIDTH = 0
RICHTEXT_FIXED_HEIGHT = 0
RICHTEXT_VARIABLE_WIDTH = 0
RICHTEXT_VARIABLE_HEIGHT = 0
RICHTEXT_LAYOUT_SPECIFIED_RECT = 0
RICHTEXT_DRAW_IGNORE_CACHE = 0
RICHTEXT_DRAW_SELECTED = 0
RICHTEXT_DRAW_PRINT = 0
RICHTEXT_DRAW_GUIDELINES = 0
RICHTEXT_FORMATTED = 0
RICHTEXT_UNFORMATTED = 0
RICHTEXT_CACHE_SIZE = 0
RICHTEXT_HEIGHT_ONLY = 0
RICHTEXT_SETSTYLE_NONE = 0
RICHTEXT_SETSTYLE_WITH_UNDO = 0
RICHTEXT_SETSTYLE_OPTIMIZE = 0
RICHTEXT_SETSTYLE_PARAGRAPHS_ONLY = 0
RICHTEXT_SETSTYLE_CHARACTERS_ONLY = 0
RICHTEXT_SETSTYLE_RENUMBER = 0
RICHTEXT_SETSTYLE_SPECIFY_LEVEL = 0
RICHTEXT_SETSTYLE_RESET = 0
RICHTEXT_SETSTYLE_REMOVE = 0
RICHTEXT_SETPROPERTIES_NONE = 0
RICHTEXT_SETPROPERTIES_WITH_UNDO = 0
RICHTEXT_SETPROPERTIES_PARAGRAPHS_ONLY = 0
RICHTEXT_SETPROPERTIES_CHARACTERS_ONLY = 0
RICHTEXT_SETPROPERTIES_RESET = 0
RICHTEXT_SETPROPERTIES_REMOVE = 0
RICHTEXT_INSERT_NONE = 0
RICHTEXT_INSERT_WITH_PREVIOUS_PARAGRAPH_STYLE = 0
RICHTEXT_INSERT_INTERACTIVE = 0
TEXT_ATTR_KEEP_FIRST_PARA_STYLE = 0
SCRIPT_MUL_FACTOR = 0
RICHTEXT_HANDLER_INCLUDE_STYLESHEET = 0
RICHTEXT_HANDLER_SAVE_IMAGES_TO_MEMORY = 0
RICHTEXT_HANDLER_SAVE_IMAGES_TO_FILES = 0
RICHTEXT_HANDLER_SAVE_IMAGES_TO_BASE64 = 0
RICHTEXT_HANDLER_NO_HEADER_FOOTER = 0
RICHTEXT_HANDLER_CONVERT_FACENAMES = 0
RICHTEXT_TYPE_ANY = 0
RICHTEXT_TYPE_TEXT = 0
RICHTEXT_TYPE_XML = 0
RICHTEXT_TYPE_HTML = 0
RICHTEXT_TYPE_RTF = 0
RICHTEXT_TYPE_PDF = 0
RICHTEXT_HITTEST_NONE = 0
RICHTEXT_HITTEST_BEFORE = 0
RICHTEXT_HITTEST_AFTER = 0
RICHTEXT_HITTEST_ON = 0
RICHTEXT_HITTEST_OUTSIDE = 0
RICHTEXT_HITTEST_NO_NESTED_OBJECTS = 0
RICHTEXT_HITTEST_NO_FLOATING_OBJECTS = 0
RICHTEXT_HITTEST_HONOUR_ATOMIC = 0
TEXT_BOX_ATTR_FLOAT = 0
TEXT_BOX_ATTR_CLEAR = 0
TEXT_BOX_ATTR_COLLAPSE_BORDERS = 0
TEXT_BOX_ATTR_VERTICAL_ALIGNMENT = 0
TEXT_ATTR_VALUE_VALID = 0
TEXT_ATTR_VALUE_VALID_MASK = 0
TEXT_ATTR_UNITS_TENTHS_MM = 0
TEXT_ATTR_UNITS_PIXELS = 0
TEXT_ATTR_UNITS_PERCENTAGE = 0
TEXT_ATTR_UNITS_POINTS = 0
TEXT_ATTR_UNITS_HUNDREDTHS_POINT = 0
TEXT_ATTR_UNITS_MASK = 0
TEXT_BOX_ATTR_POSITION_STATIC = 0
TEXT_BOX_ATTR_POSITION_RELATIVE = 0
TEXT_BOX_ATTR_POSITION_ABSOLUTE = 0
TEXT_BOX_ATTR_POSITION_FIXED = 0
TEXT_BOX_ATTR_POSITION_MASK = 0
TEXT_BOX_ATTR_BORDER_NONE = 0
TEXT_BOX_ATTR_BORDER_SOLID = 0
TEXT_BOX_ATTR_BORDER_DOTTED = 0
TEXT_BOX_ATTR_BORDER_DASHED = 0
TEXT_BOX_ATTR_BORDER_DOUBLE = 0
TEXT_BOX_ATTR_BORDER_GROOVE = 0
TEXT_BOX_ATTR_BORDER_RIDGE = 0
TEXT_BOX_ATTR_BORDER_INSET = 0
TEXT_BOX_ATTR_BORDER_OUTSET = 0
TEXT_BOX_ATTR_BORDER_STYLE = 0
TEXT_BOX_ATTR_BORDER_COLOUR = 0
TEXT_BOX_ATTR_BORDER_THIN = 0
TEXT_BOX_ATTR_BORDER_MEDIUM = 0
TEXT_BOX_ATTR_BORDER_THICK = 0
TEXT_BOX_ATTR_FLOAT_NONE = 0
TEXT_BOX_ATTR_FLOAT_LEFT = 0
TEXT_BOX_ATTR_FLOAT_RIGHT = 0
TEXT_BOX_ATTR_CLEAR_NONE = 0
TEXT_BOX_ATTR_CLEAR_LEFT = 0
TEXT_BOX_ATTR_CLEAR_RIGHT = 0
TEXT_BOX_ATTR_CLEAR_BOTH = 0
TEXT_BOX_ATTR_COLLAPSE_NONE = 0
TEXT_BOX_ATTR_COLLAPSE_FULL = 0
TEXT_BOX_ATTR_VERTICAL_ALIGNMENT_NONE = 0
TEXT_BOX_ATTR_VERTICAL_ALIGNMENT_TOP = 0
TEXT_BOX_ATTR_VERTICAL_ALIGNMENT_CENTRE = 0
TEXT_BOX_ATTR_VERTICAL_ALIGNMENT_BOTTOM = 0
RICHTEXT_INSERT = 0
RICHTEXT_DELETE = 0
RICHTEXT_CHANGE_ATTRIBUTES = 0
RICHTEXT_CHANGE_STYLE = 0
RICHTEXT_CHANGE_OBJECT = 0
RichTextLineBreakChar = ""

class TextAttrDimension(object):
    """
    TextAttrDimension()
    TextAttrDimension(value, units=TEXT_ATTR_UNITS_TENTHS_MM)
    
    A class representing a rich text dimension, including units and
    position.
    """

    def __init__(self, *args, **kw):
        """
        TextAttrDimension()
        TextAttrDimension(value, units=TEXT_ATTR_UNITS_TENTHS_MM)
        
        A class representing a rich text dimension, including units and
        position.
        """
    m_value = property(None, None)
    m_flags = property(None, None)

    def Reset(self):
        """
        Reset()
        
        Resets the dimension value and flags.
        """

    def EqPartial(self, dim, weakTest=True):
        """
        EqPartial(dim, weakTest=True) -> bool
        
        Partial equality test.
        """

    def Apply(self, dim, compareWith=None):
        """
        Apply(dim, compareWith=None) -> bool
        
        Apply the dimension, but not those identical to compareWith if
        present.
        """

    def CollectCommonAttributes(self, attr, clashingAttr, absentAttr):
        """
        CollectCommonAttributes(attr, clashingAttr, absentAttr)
        
        Collects the attributes that are common to a range of content,
        building up a note of which attributes are absent in some objects and
        which clash in some objects.
        """

    def __eq__(self):
        """
        """

    def GetValue(self):
        """
        GetValue() -> int
        
        Returns the integer value of the dimension.
        """

    def GetValueMM(self):
        """
        GetValueMM() -> float
        
        Returns the floating-pointing value of the dimension in mm.
        """

    def SetValueMM(self, value):
        """
        SetValueMM(value)
        
        Sets the value of the dimension in mm.
        """

    def SetValue(self, *args, **kw):
        """
        SetValue(value)
        SetValue(value, flags)
        SetValue(dim)
        
        Sets the integer value of the dimension.
        """

    def GetUnits(self):
        """
        GetUnits() -> TextAttrUnits
        
        Gets the units of the dimension.
        """

    def SetUnits(self, units):
        """
        SetUnits(units)
        
        Sets the units of the dimension.
        """

    def GetPosition(self):
        """
        GetPosition() -> TextBoxAttrPosition
        
        Gets the position flags.
        """

    def SetPosition(self, pos):
        """
        SetPosition(pos)
        
        Sets the position flags.
        """

    def IsValid(self):
        """
        IsValid() -> bool
        
        Returns true if the dimension is valid.
        """

    def SetValid(self, b):
        """
        SetValid(b)
        
        Sets the valid flag.
        """

    def GetFlags(self):
        """
        GetFlags() -> TextAttrDimensionFlags
        
        Gets the dimension flags.
        """

    def SetFlags(self, flags):
        """
        SetFlags(flags)
        
        Sets the dimension flags.
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """
    Flags = property(None, None)
    Position = property(None, None)
    Units = property(None, None)
    Value = property(None, None)
    ValueMM = property(None, None)
# end of class TextAttrDimension


class TextAttrDimensions(object):
    """
    TextAttrDimensions()
    
    A class for left, right, top and bottom dimensions.
    """

    def __init__(self):
        """
        TextAttrDimensions()
        
        A class for left, right, top and bottom dimensions.
        """
    m_left = property(None, None)
    m_top = property(None, None)
    m_right = property(None, None)
    m_bottom = property(None, None)

    def Reset(self):
        """
        Reset()
        
        Resets the value and flags for all dimensions.
        """

    def __eq__(self):
        """
        """

    def EqPartial(self, dims, weakTest=True):
        """
        EqPartial(dims, weakTest=True) -> bool
        
        Partial equality test.
        """

    def Apply(self, dims, compareWith=None):
        """
        Apply(dims, compareWith=None) -> bool
        
        Apply to 'this', but not if the same as compareWith.
        """

    def CollectCommonAttributes(self, attr, clashingAttr, absentAttr):
        """
        CollectCommonAttributes(attr, clashingAttr, absentAttr)
        
        Collects the attributes that are common to a range of content,
        building up a note of which attributes are absent in some objects and
        which clash in some objects.
        """

    def RemoveStyle(self, attr):
        """
        RemoveStyle(attr) -> bool
        
        Remove specified attributes from this object.
        """

    def GetLeft(self):
        """
        GetLeft() -> TextAttrDimension
        """

    def GetRight(self):
        """
        GetRight() -> TextAttrDimension
        """

    def GetTop(self):
        """
        GetTop() -> TextAttrDimension
        """

    def GetBottom(self):
        """
        GetBottom() -> TextAttrDimension
        """

    def IsValid(self):
        """
        IsValid() -> bool
        
        Are all dimensions valid?
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """
    Bottom = property(None, None)
    Left = property(None, None)
    Right = property(None, None)
    Top = property(None, None)
# end of class TextAttrDimensions


class TextAttrSize(object):
    """
    TextAttrSize()
    
    A class for representing width and height.
    """

    def __init__(self):
        """
        TextAttrSize()
        
        A class for representing width and height.
        """
    m_width = property(None, None)
    m_height = property(None, None)

    def Reset(self):
        """
        Reset()
        
        Resets the width and height dimensions.
        """

    def __eq__(self):
        """
        """

    def EqPartial(self, size, weakTest=True):
        """
        EqPartial(size, weakTest=True) -> bool
        
        Partial equality test.
        """

    def Apply(self, dims, compareWith=None):
        """
        Apply(dims, compareWith=None) -> bool
        
        Apply to this object, but not if the same as compareWith.
        """

    def CollectCommonAttributes(self, attr, clashingAttr, absentAttr):
        """
        CollectCommonAttributes(attr, clashingAttr, absentAttr)
        
        Collects the attributes that are common to a range of content,
        building up a note of which attributes are absent in some objects and
        which clash in some objects.
        """

    def RemoveStyle(self, attr):
        """
        RemoveStyle(attr) -> bool
        
        Removes the specified attributes from this object.
        """

    def GetWidth(self):
        """
        GetWidth() -> TextAttrDimension
        
        Returns the width.
        """

    def SetWidth(self, *args, **kw):
        """
        SetWidth(value, flags)
        SetWidth(dim)
        
        Sets the width.
        """

    def GetHeight(self):
        """
        GetHeight() -> TextAttrDimension
        
        Gets the height.
        """

    def SetHeight(self, *args, **kw):
        """
        SetHeight(value, flags)
        SetHeight(dim)
        
        Sets the height.
        """

    def IsValid(self):
        """
        IsValid() -> bool
        
        Is the size valid?
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """
    Height = property(None, None)
    Width = property(None, None)
# end of class TextAttrSize


class TextAttrDimensionConverter(object):
    """
    TextAttrDimensionConverter(dc, scale=1.0, parentSize=wx.DefaultSize)
    TextAttrDimensionConverter(ppi, scale=1.0, parentSize=wx.DefaultSize)
    
    A class to make it easier to convert dimensions.
    """

    def __init__(self, *args, **kw):
        """
        TextAttrDimensionConverter(dc, scale=1.0, parentSize=wx.DefaultSize)
        TextAttrDimensionConverter(ppi, scale=1.0, parentSize=wx.DefaultSize)
        
        A class to make it easier to convert dimensions.
        """
    m_ppi = property(None, None)
    m_scale = property(None, None)
    m_parentSize = property(None, None)

    def GetPixels(self, dim, direction=wx.HORIZONTAL):
        """
        GetPixels(dim, direction=wx.HORIZONTAL) -> int
        
        Gets the pixel size for the given dimension.
        """

    def GetTenthsMM(self, dim):
        """
        GetTenthsMM(dim) -> int
        
        Gets the mm size for the given dimension.
        """

    def ConvertTenthsMMToPixels(self, units):
        """
        ConvertTenthsMMToPixels(units) -> int
        
        Converts tenths of a mm to pixels.
        """

    def ConvertPixelsToTenthsMM(self, pixels):
        """
        ConvertPixelsToTenthsMM(pixels) -> int
        
        Converts pixels to tenths of a mm.
        """
# end of class TextAttrDimensionConverter


class TextAttrBorder(object):
    """
    TextAttrBorder()
    
    A class representing a rich text object border.
    """

    def __init__(self):
        """
        TextAttrBorder()
        
        A class representing a rich text object border.
        """
    m_borderStyle = property(None, None)
    m_borderColour = property(None, None)
    m_borderWidth = property(None, None)
    m_flags = property(None, None)

    def __eq__(self):
        """
        """

    def Reset(self):
        """
        Reset()
        
        Resets the border style, colour, width and flags.
        """

    def EqPartial(self, border, weakTest=True):
        """
        EqPartial(border, weakTest=True) -> bool
        
        Partial equality test.
        """

    def Apply(self, border, compareWith=None):
        """
        Apply(border, compareWith=None) -> bool
        
        Applies the border to this object, but not if the same as compareWith.
        """

    def RemoveStyle(self, attr):
        """
        RemoveStyle(attr) -> bool
        
        Removes the specified attributes from this object.
        """

    def CollectCommonAttributes(self, attr, clashingAttr, absentAttr):
        """
        CollectCommonAttributes(attr, clashingAttr, absentAttr)
        
        Collects the attributes that are common to a range of content,
        building up a note of which attributes are absent in some objects and
        which clash in some objects.
        """

    def SetStyle(self, style):
        """
        SetStyle(style)
        
        Sets the border style.
        """

    def GetStyle(self):
        """
        GetStyle() -> int
        
        Gets the border style.
        """

    def SetColour(self, *args, **kw):
        """
        SetColour(colour)
        SetColour(colour)
        
        Sets the border colour.
        """

    def GetColourLong(self):
        """
        GetColourLong() -> unsignedlong
        
        Gets the colour as a long.
        """

    def GetColour(self):
        """
        GetColour() -> wx.Colour
        
        Gets the colour.
        """

    def GetWidth(self):
        """
        GetWidth() -> TextAttrDimension
        
        Gets the border width.
        """

    def SetWidth(self, *args, **kw):
        """
        SetWidth(width)
        SetWidth(value, units=TEXT_ATTR_UNITS_TENTHS_MM)
        
        Sets the border width.
        """

    def HasStyle(self):
        """
        HasStyle() -> bool
        
        True if the border has a valid style.
        """

    def HasColour(self):
        """
        HasColour() -> bool
        
        True if the border has a valid colour.
        """

    def HasWidth(self):
        """
        HasWidth() -> bool
        
        True if the border has a valid width.
        """

    def IsValid(self):
        """
        IsValid() -> bool
        
        True if the border is valid.
        """

    def IsDefault(self):
        """
        IsDefault() -> bool
        
        True if the border has no attributes set.
        """

    def MakeValid(self):
        """
        MakeValid()
        
        Set the valid flag for this border.
        """

    def GetFlags(self):
        """
        GetFlags() -> int
        
        Returns the border flags.
        """

    def SetFlags(self, flags):
        """
        SetFlags(flags)
        
        Sets the border flags.
        """

    def AddFlag(self, flag):
        """
        AddFlag(flag)
        
        Adds a border flag.
        """

    def RemoveFlag(self, flag):
        """
        RemoveFlag(flag)
        
        Removes a border flag.
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """
    Colour = property(None, None)
    ColourLong = property(None, None)
    Flags = property(None, None)
    Style = property(None, None)
    Width = property(None, None)
# end of class TextAttrBorder


class TextAttrBorders(object):
    """
    TextAttrBorders()
    
    A class representing a rich text object's borders.
    """

    def __init__(self):
        """
        TextAttrBorders()
        
        A class representing a rich text object's borders.
        """
    m_left = property(None, None)
    m_right = property(None, None)
    m_top = property(None, None)
    m_bottom = property(None, None)

    def __eq__(self):
        """
        """

    def SetStyle(self, style):
        """
        SetStyle(style)
        
        Sets the style of all borders.
        """

    def SetColour(self, *args, **kw):
        """
        SetColour(colour)
        SetColour(colour)
        
        Sets colour of all borders.
        """

    def SetWidth(self, *args, **kw):
        """
        SetWidth(width)
        SetWidth(value, units=TEXT_ATTR_UNITS_TENTHS_MM)
        
        Sets the width of all borders.
        """

    def Reset(self):
        """
        Reset()
        
        Resets all borders.
        """

    def EqPartial(self, borders, weakTest=True):
        """
        EqPartial(borders, weakTest=True) -> bool
        
        Partial equality test.
        """

    def Apply(self, borders, compareWith=None):
        """
        Apply(borders, compareWith=None) -> bool
        
        Applies border to this object, but not if the same as compareWith.
        """

    def RemoveStyle(self, attr):
        """
        RemoveStyle(attr) -> bool
        
        Removes the specified attributes from this object.
        """

    def CollectCommonAttributes(self, attr, clashingAttr, absentAttr):
        """
        CollectCommonAttributes(attr, clashingAttr, absentAttr)
        
        Collects the attributes that are common to a range of content,
        building up a note of which attributes are absent in some objects and
        which clash in some objects.
        """

    def IsValid(self):
        """
        IsValid() -> bool
        
        Returns true if at least one border is valid.
        """

    def GetLeft(self):
        """
        GetLeft() -> TextAttrBorder
        """

    def GetRight(self):
        """
        GetRight() -> TextAttrBorder
        """

    def GetTop(self):
        """
        GetTop() -> TextAttrBorder
        """

    def GetBottom(self):
        """
        GetBottom() -> TextAttrBorder
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """
    Bottom = property(None, None)
    Left = property(None, None)
    Right = property(None, None)
    Top = property(None, None)
# end of class TextAttrBorders


class TextBoxAttr(object):
    """
    TextBoxAttr()
    TextBoxAttr(attr)
    
    A class representing the box attributes of a rich text object.
    """

    def __init__(self, *args, **kw):
        """
        TextBoxAttr()
        TextBoxAttr(attr)
        
        A class representing the box attributes of a rich text object.
        """
    m_flags = property(None, None)
    m_margins = property(None, None)
    m_padding = property(None, None)
    m_position = property(None, None)
    m_size = property(None, None)
    m_minSize = property(None, None)
    m_maxSize = property(None, None)
    m_border = property(None, None)
    m_outline = property(None, None)
    m_floatMode = property(None, None)
    m_clearMode = property(None, None)
    m_collapseMode = property(None, None)
    m_verticalAlignment = property(None, None)
    m_boxStyleName = property(None, None)

    def Init(self):
        """
        Init()
        
        Initialises this object.
        """

    def Reset(self):
        """
        Reset()
        
        Resets this object.
        """

    def __eq__(self):
        """
        """

    def EqPartial(self, attr, weakTest=True):
        """
        EqPartial(attr, weakTest=True) -> bool
        
        Partial equality test, ignoring unset attributes.
        """

    def Apply(self, style, compareWith=None):
        """
        Apply(style, compareWith=None) -> bool
        
        Merges the given attributes.
        """

    def CollectCommonAttributes(self, attr, clashingAttr, absentAttr):
        """
        CollectCommonAttributes(attr, clashingAttr, absentAttr)
        
        Collects the attributes that are common to a range of content,
        building up a note of which attributes are absent in some objects and
        which clash in some objects.
        """

    def RemoveStyle(self, attr):
        """
        RemoveStyle(attr) -> bool
        
        Removes the specified attributes from this object.
        """

    def SetFlags(self, flags):
        """
        SetFlags(flags)
        
        Sets the flags.
        """

    def GetFlags(self):
        """
        GetFlags() -> int
        
        Returns the flags.
        """

    def HasFlag(self, flag):
        """
        HasFlag(flag) -> bool
        
        Is this flag present?
        """

    def RemoveFlag(self, flag):
        """
        RemoveFlag(flag)
        
        Removes this flag.
        """

    def AddFlag(self, flag):
        """
        AddFlag(flag)
        
        Adds this flag.
        """

    def IsDefault(self):
        """
        IsDefault() -> bool
        
        Returns true if no attributes are set.
        """

    def GetFloatMode(self):
        """
        GetFloatMode() -> TextBoxAttrFloatStyle
        
        Returns the float mode.
        """

    def SetFloatMode(self, mode):
        """
        SetFloatMode(mode)
        
        Sets the float mode.
        """

    def HasFloatMode(self):
        """
        HasFloatMode() -> bool
        
        Returns true if float mode is active.
        """

    def IsFloating(self):
        """
        IsFloating() -> bool
        
        Returns true if this object is floating.
        """

    def GetClearMode(self):
        """
        GetClearMode() -> TextBoxAttrClearStyle
        
        Returns the clear mode - whether to wrap text after object.
        """

    def SetClearMode(self, mode):
        """
        SetClearMode(mode)
        
        Set the clear mode.
        """

    def HasClearMode(self):
        """
        HasClearMode() -> bool
        
        Returns true if we have a clear flag.
        """

    def GetCollapseBorders(self):
        """
        GetCollapseBorders() -> TextBoxAttrCollapseMode
        
        Returns the collapse mode - whether to collapse borders.
        """

    def SetCollapseBorders(self, collapse):
        """
        SetCollapseBorders(collapse)
        
        Sets the collapse mode - whether to collapse borders.
        """

    def HasCollapseBorders(self):
        """
        HasCollapseBorders() -> bool
        
        Returns true if the collapse borders flag is present.
        """

    def GetVerticalAlignment(self):
        """
        GetVerticalAlignment() -> TextBoxAttrVerticalAlignment
        
        Returns the vertical alignment.
        """

    def SetVerticalAlignment(self, verticalAlignment):
        """
        SetVerticalAlignment(verticalAlignment)
        
        Sets the vertical alignment.
        """

    def HasVerticalAlignment(self):
        """
        HasVerticalAlignment() -> bool
        
        Returns true if a vertical alignment flag is present.
        """

    def GetMargins(self):
        """
        GetMargins() -> TextAttrDimensions
        
        Returns the margin values.
        """

    def GetLeftMargin(self):
        """
        GetLeftMargin() -> TextAttrDimension
        
        Returns the left margin.
        """

    def GetRightMargin(self):
        """
        GetRightMargin() -> TextAttrDimension
        
        Returns the right margin.
        """

    def GetTopMargin(self):
        """
        GetTopMargin() -> TextAttrDimension
        
        Returns the top margin.
        """

    def GetBottomMargin(self):
        """
        GetBottomMargin() -> TextAttrDimension
        
        Returns the bottom margin.
        """

    def GetPosition(self):
        """
        GetPosition() -> TextAttrDimensions
        
        Returns the position.
        """

    def GetLeft(self):
        """
        GetLeft() -> TextAttrDimension
        
        Returns the left position.
        """

    def GetRight(self):
        """
        GetRight() -> TextAttrDimension
        
        Returns the right position.
        """

    def GetTop(self):
        """
        GetTop() -> TextAttrDimension
        
        Returns the top position.
        """

    def GetBottom(self):
        """
        GetBottom() -> TextAttrDimension
        
        Returns the bottom position.
        """

    def GetPadding(self):
        """
        GetPadding() -> TextAttrDimensions
        
        Returns the padding values.
        """

    def GetLeftPadding(self):
        """
        GetLeftPadding() -> TextAttrDimension
        
        Returns the left padding value.
        """

    def GetRightPadding(self):
        """
        GetRightPadding() -> TextAttrDimension
        
        Returns the right padding value.
        """

    def GetTopPadding(self):
        """
        GetTopPadding() -> TextAttrDimension
        
        Returns the top padding value.
        """

    def GetBottomPadding(self):
        """
        GetBottomPadding() -> TextAttrDimension
        
        Returns the bottom padding value.
        """

    def GetBorder(self):
        """
        GetBorder() -> TextAttrBorders
        
        Returns the borders.
        """

    def GetLeftBorder(self):
        """
        GetLeftBorder() -> TextAttrBorder
        
        Returns the left border.
        """

    def GetTopBorder(self):
        """
        GetTopBorder() -> TextAttrBorder
        
        Returns the top border.
        """

    def GetRightBorder(self):
        """
        GetRightBorder() -> TextAttrBorder
        
        Returns the right border.
        """

    def GetBottomBorder(self):
        """
        GetBottomBorder() -> TextAttrBorder
        
        Returns the bottom border.
        """

    def GetOutline(self):
        """
        GetOutline() -> TextAttrBorders
        
        Returns the outline.
        """

    def GetLeftOutline(self):
        """
        GetLeftOutline() -> TextAttrBorder
        
        Returns the left outline.
        """

    def GetTopOutline(self):
        """
        GetTopOutline() -> TextAttrBorder
        
        Returns the top outline.
        """

    def GetRightOutline(self):
        """
        GetRightOutline() -> TextAttrBorder
        
        Returns the right outline.
        """

    def GetBottomOutline(self):
        """
        GetBottomOutline() -> TextAttrBorder
        
        Returns the bottom outline.
        """

    def GetSize(self):
        """
        GetSize() -> TextAttrSize
        
        Returns the object size.
        """

    def GetMinSize(self):
        """
        GetMinSize() -> TextAttrSize
        
        Returns the object minimum size.
        """

    def GetMaxSize(self):
        """
        GetMaxSize() -> TextAttrSize
        
        Returns the object maximum size.
        """

    def SetSize(self, sz):
        """
        SetSize(sz)
        
        Sets the object size.
        """

    def SetMinSize(self, sz):
        """
        SetMinSize(sz)
        
        Sets the object minimum size.
        """

    def SetMaxSize(self, sz):
        """
        SetMaxSize(sz)
        
        Sets the object maximum size.
        """

    def GetWidth(self):
        """
        GetWidth() -> TextAttrDimension
        
        Returns the object width.
        """

    def GetHeight(self):
        """
        GetHeight() -> TextAttrDimension
        
        Returns the object height.
        """

    def GetBoxStyleName(self):
        """
        GetBoxStyleName() -> String
        
        Returns the box style name.
        """

    def SetBoxStyleName(self, name):
        """
        SetBoxStyleName(name)
        
        Sets the box style name.
        """

    def HasBoxStyleName(self):
        """
        HasBoxStyleName() -> bool
        
        Returns true if the box style name is present.
        """
    Border = property(None, None)
    Bottom = property(None, None)
    BottomBorder = property(None, None)
    BottomMargin = property(None, None)
    BottomOutline = property(None, None)
    BottomPadding = property(None, None)
    BoxStyleName = property(None, None)
    ClearMode = property(None, None)
    CollapseBorders = property(None, None)
    Flags = property(None, None)
    FloatMode = property(None, None)
    Height = property(None, None)
    Left = property(None, None)
    LeftBorder = property(None, None)
    LeftMargin = property(None, None)
    LeftOutline = property(None, None)
    LeftPadding = property(None, None)
    Margins = property(None, None)
    MaxSize = property(None, None)
    MinSize = property(None, None)
    Outline = property(None, None)
    Padding = property(None, None)
    Position = property(None, None)
    Right = property(None, None)
    RightBorder = property(None, None)
    RightMargin = property(None, None)
    RightOutline = property(None, None)
    RightPadding = property(None, None)
    Size = property(None, None)
    Top = property(None, None)
    TopBorder = property(None, None)
    TopMargin = property(None, None)
    TopOutline = property(None, None)
    TopPadding = property(None, None)
    VerticalAlignment = property(None, None)
    Width = property(None, None)
# end of class TextBoxAttr


class RichTextAttr(wx.TextAttr):
    """
    RichTextAttr(attr)
    RichTextAttr(attr)
    RichTextAttr()
    
    A class representing enhanced attributes for rich text objects.
    """

    def __init__(self, *args, **kw):
        """
        RichTextAttr(attr)
        RichTextAttr(attr)
        RichTextAttr()
        
        A class representing enhanced attributes for rich text objects.
        """
    m_textBoxAttr = property(None, None)

    def Copy(self, attr):
        """
        Copy(attr)
        
        Copy function.
        """

    def __eq__(self):
        """
        """

    def EqPartial(self, attr, weakTest=True):
        """
        EqPartial(attr, weakTest=True) -> bool
        
        Partial equality test.
        """

    def Apply(self, style, compareWith=None):
        """
        Apply(style, compareWith=None) -> bool
        
        Merges the given attributes.
        """

    def CollectCommonAttributes(self, attr, clashingAttr, absentAttr):
        """
        CollectCommonAttributes(attr, clashingAttr, absentAttr)
        
        Collects the attributes that are common to a range of content,
        building up a note of which attributes are absent in some objects and
        which clash in some objects.
        """

    def RemoveStyle(self, attr):
        """
        RemoveStyle(attr) -> bool
        
        Removes the specified attributes from this object.
        """

    def GetTextBoxAttr(self):
        """
        GetTextBoxAttr() -> TextBoxAttr
        
        Returns the text box attributes.
        """

    def SetTextBoxAttr(self, attr):
        """
        SetTextBoxAttr(attr)
        
        Set the text box attributes.
        """

    def IsDefault(self):
        """
        IsDefault() -> bool
        
        Returns true if no attributes are set.
        """
    TextBoxAttr = property(None, None)
# end of class RichTextAttr


class RichTextProperties(wx.Object):
    """
    RichTextProperties()
    RichTextProperties(props)
    
    A simple property class using wxVariants.
    """

    def __init__(self, *args, **kw):
        """
        RichTextProperties()
        RichTextProperties(props)
        
        A simple property class using wxVariants.
        """

    def __eq__(self):
        """
        """

    def Copy(self, props):
        """
        Copy(props)
        
        Copies from props.
        """

    def Clear(self):
        """
        Clear()
        
        Clears the properties.
        """

    def GetProperties(self):
        """
        GetProperties() -> RichTextVariantArray
        
        Returns the array of variants implementing the properties.
        """

    def SetProperties(self, props):
        """
        SetProperties(props)
        
        Sets the array of variants.
        """

    def GetPropertyNames(self):
        """
        GetPropertyNames() -> ArrayString
        
        Returns all the property names.
        """

    def GetCount(self):
        """
        GetCount() -> size_t
        
        Returns a count of the properties.
        """

    def HasProperty(self, name):
        """
        HasProperty(name) -> bool
        
        Returns true if the given property is found.
        """

    def Find(self, name):
        """
        Find(name) -> int
        
        Finds the given property.
        """

    def Remove(self, name):
        """
        Remove(name) -> bool
        
        Removes the given property.
        """

    def GetProperty(self, name):
        """
        GetProperty(name) -> Variant
        
        Gets the property variant by name.
        """

    def FindOrCreateProperty(self, name):
        """
        FindOrCreateProperty(name) -> Variant
        
        Finds or creates a property with the given name, returning a pointer
        to the variant.
        """

    def GetPropertyString(self, name):
        """
        GetPropertyString(name) -> String
        
        Gets the value of the named property as a string.
        """

    def GetPropertyLong(self, name):
        """
        GetPropertyLong(name) -> long
        
        Gets the value of the named property as a long integer.
        """

    def GetPropertyBool(self, name):
        """
        GetPropertyBool(name) -> bool
        
        Gets the value of the named property as a boolean.
        """

    def GetPropertyDouble(self, name):
        """
        GetPropertyDouble(name) -> double
        
        Gets the value of the named property as a double.
        """

    def SetProperty(self, *args, **kw):
        """
        SetProperty(variant)
        SetProperty(name, variant)
        SetProperty(name, value)
        SetProperty(name, value)
        SetProperty(name, value)
        SetProperty(name, value)
        
        Sets the property by passing a variant which contains a name and
        value.
        """

    def RemoveProperties(self, properties):
        """
        RemoveProperties(properties)
        
        Removes the given properties from these properties.
        """

    def MergeProperties(self, properties):
        """
        MergeProperties(properties)
        
        Merges the given properties with these properties.
        """
    Count = property(None, None)
    Properties = property(None, None)
    PropertyNames = property(None, None)
# end of class RichTextProperties


class RichTextFontTable(wx.Object):
    """
    RichTextFontTable()
    RichTextFontTable(table)
    
    Manages quick access to a pool of fonts for rendering rich text.
    """

    def __init__(self, *args, **kw):
        """
        RichTextFontTable()
        RichTextFontTable(table)
        
        Manages quick access to a pool of fonts for rendering rich text.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if the font table is valid.
        """

    def FindFont(self, fontSpec):
        """
        FindFont(fontSpec) -> wx.Font
        
        Finds a font for the given attribute object.
        """

    def Clear(self):
        """
        Clear()
        
        Clears the font table.
        """

    def __eq__(self):
        """
        """

    def __ne__(self):
        """
        """

    def SetFontScale(self, fontScale):
        """
        SetFontScale(fontScale)
        
        Set the font scale factor.
        """
# end of class RichTextFontTable


class RichTextRange(object):
    """
    RichTextRange()
    RichTextRange(start, end)
    RichTextRange(range)
    
    This stores beginning and end positions for a range of data.
    """

    def __init__(self, *args, **kw):
        """
        RichTextRange()
        RichTextRange(start, end)
        RichTextRange(range)
        
        This stores beginning and end positions for a range of data.
        """

    def __eq__(self):
        """
        """

    def __ne__(self):
        """
        """

    def __sub__(self):
        """
        """

    def __add__(self):
        """
        """

    def SetRange(self, start, end):
        """
        SetRange(start, end)
        
        Sets the range start and end positions.
        """

    def SetStart(self, start):
        """
        SetStart(start)
        
        Sets the start position.
        """

    def GetStart(self):
        """
        GetStart() -> long
        
        Returns the start position.
        """

    def SetEnd(self, end):
        """
        SetEnd(end)
        
        Sets the end position.
        """

    def GetEnd(self):
        """
        GetEnd() -> long
        
        Gets the end position.
        """

    def IsOutside(self, range):
        """
        IsOutside(range) -> bool
        
        Returns true if this range is completely outside range.
        """

    def IsWithin(self, range):
        """
        IsWithin(range) -> bool
        
        Returns true if this range is completely within range.
        """

    def Contains(self, pos):
        """
        Contains(pos) -> bool
        
        Returns true if pos was within the range.
        """

    def LimitTo(self, range):
        """
        LimitTo(range) -> bool
        
        Limit this range to be within range.
        """

    def GetLength(self):
        """
        GetLength() -> long
        
        Gets the length of the range.
        """

    def Swap(self):
        """
        Swap()
        
        Swaps the start and end.
        """

    def ToInternal(self):
        """
        ToInternal() -> RichTextRange
        
        Converts the API-standard range, whose end is one past the last
        character in the range, to the internal form, which uses the first and
        last character positions of the range.
        """

    def FromInternal(self):
        """
        FromInternal() -> RichTextRange
        
        Converts the internal range, which uses the first and last character
        positions of the range, to the API-standard range, whose end is one
        past the last character in the range.
        """
    End = property(None, None)
    Length = property(None, None)
    Start = property(None, None)

    def Get(self):
        """
        Get() -> (start, end)
        
        Return the start and end properties as a tuple.
        """

    def GetIM(self):
        """
        Returns an immutable representation of the ``wx.RichTextRange`` object, based on ``namedtuple``.
        
        This new object is hashable and can be used as a dictionary key,
        be added to sets, etc.  It can be converted back into a real ``wx.RichTextRange``
        with a simple statement like this: ``obj = wx.RichTextRange(imObj)``.
        """

    def __str__(self):
        """
        
        """

    def __repr__(self):
        """
        
        """

    def __len__(self):
        """
        
        """

    def __nonzero__(self):
        """
        
        """

    def __reduce__(self):
        """
        
        """

    def __getitem__(self, idx):
        """
        
        """

    def __setitem__(self, idx, val):
        """
        
        """

    __safe_for_unpickling__ = True
# end of class RichTextRange


RICHTEXT_ALL = RichTextRange(-2, -2)
RICHTEXT_NONE = RichTextRange(-1, -1)
RICHTEXT_NO_SELECTION = RichTextRange(-2, -2)

class RichTextSelection(object):
    """
    RichTextSelection(sel)
    RichTextSelection(range, container)
    RichTextSelection()
    
    Stores selection information.
    """

    def __init__(self, *args, **kw):
        """
        RichTextSelection(sel)
        RichTextSelection(range, container)
        RichTextSelection()
        
        Stores selection information.
        """
    m_ranges = property(None, None)
    m_container = property(None, None)

    def Reset(self):
        """
        Reset()
        
        Resets the selection.
        """

    def Set(self, *args, **kw):
        """
        Set(range, container)
        Set(ranges, container)
        
        Sets the selection.
        """

    def Add(self, range):
        """
        Add(range)
        
        Adds a range to the selection.
        """

    def Copy(self, sel):
        """
        Copy(sel)
        
        Copies from sel.
        """

    def __eq__(self):
        """
        """

    def GetRanges(self):
        """
        GetRanges() -> RichTextRangeArray
        
        Returns the selection ranges.
        """

    def SetRanges(self, ranges):
        """
        SetRanges(ranges)
        
        Sets the selection ranges.
        """

    def GetCount(self):
        """
        GetCount() -> size_t
        
        Returns the number of ranges in the selection.
        """

    def GetRange(self, *args, **kw):
        """
        GetRange(i) -> RichTextRange
        GetRange() -> RichTextRange
        
        Returns the range at the given index.
        """

    def SetRange(self, range):
        """
        SetRange(range)
        
        Sets a single range.
        """

    def GetContainer(self):
        """
        GetContainer() -> RichTextParagraphLayoutBox
        
        Returns the container for which the selection is valid.
        """

    def SetContainer(self, container):
        """
        SetContainer(container)
        
        Sets the container for which the selection is valid.
        """

    def IsValid(self):
        """
        IsValid() -> bool
        
        Returns true if the selection is valid.
        """

    def GetSelectionForObject(self, obj):
        """
        GetSelectionForObject(obj) -> RichTextRangeArray
        
        Returns the selection appropriate to the specified object, if any;
        returns an empty array if none at the level of the object's container.
        """

    def WithinSelection(self, *args, **kw):
        """
        WithinSelection(pos, obj) -> bool
        WithinSelection(pos) -> bool
        WithinSelection(pos, ranges) -> bool
        WithinSelection(range, ranges) -> bool
        
        Returns true if the given position is within the selection.
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """
    Container = property(None, None)
    Count = property(None, None)
    Range = property(None, None)
    Ranges = property(None, None)
# end of class RichTextSelection


class RichTextDrawingContext(wx.Object):
    """
    RichTextDrawingContext(buffer)
    
    A class for passing information to drawing and measuring functions.
    """

    def __init__(self, buffer):
        """
        RichTextDrawingContext(buffer)
        
        A class for passing information to drawing and measuring functions.
        """
    m_buffer = property(None, None)

    def Init(self):
        """
        Init()
        """

    def HasVirtualAttributes(self, obj):
        """
        HasVirtualAttributes(obj) -> bool
        
        Does this object have virtual attributes? Virtual attributes can be
        provided for visual cues without affecting the actual styling.
        """

    def GetVirtualAttributes(self, obj):
        """
        GetVirtualAttributes(obj) -> RichTextAttr
        
        Returns the virtual attributes for this object.
        """

    def ApplyVirtualAttributes(self, attr, obj):
        """
        ApplyVirtualAttributes(attr, obj) -> bool
        
        Applies any virtual attributes relevant to this object.
        """

    def GetVirtualSubobjectAttributesCount(self, obj):
        """
        GetVirtualSubobjectAttributesCount(obj) -> int
        
        Gets the count for mixed virtual attributes for individual positions
        within the object.
        """

    def GetVirtualSubobjectAttributes(self, obj, positions, attributes):
        """
        GetVirtualSubobjectAttributes(obj, positions, attributes) -> int
        
        Gets the mixed virtual attributes for individual positions within the
        object.
        """

    def HasVirtualText(self, obj):
        """
        HasVirtualText(obj) -> bool
        
        Do we have virtual text for this object? Virtual text allows an
        application to replace characters in an object for editing and display
        purposes, for example for highlighting special characters.
        """

    def GetVirtualText(self, obj, text):
        """
        GetVirtualText(obj, text) -> bool
        
        Gets the virtual text for this object.
        """

    def EnableVirtualAttributes(self, b):
        """
        EnableVirtualAttributes(b)
        
        Enables virtual attribute processing.
        """

    def GetVirtualAttributesEnabled(self):
        """
        GetVirtualAttributesEnabled() -> bool
        
        Returns true if virtual attribute processing is enabled.
        """
    VirtualAttributesEnabled = property(None, None)
# end of class RichTextDrawingContext


class RichTextObject(wx.Object):
    """
    RichTextObject(parent=None)
    
    This is the base for drawable rich text objects.
    """

    def __init__(self, parent=None):
        """
        RichTextObject(parent=None)
        
        This is the base for drawable rich text objects.
        """

    def Draw(self, dc, context, range, selection, rect, descent, style):
        """
        Draw(dc, context, range, selection, rect, descent, style) -> bool
        
        Draw the item, within the given range.
        """

    def Layout(self, dc, context, rect, parentRect, style):
        """
        Layout(dc, context, rect, parentRect, style) -> bool
        
        Lay the item out at the specified position with the given size
        constraint.
        """

    def HitTest(self, dc, context, pt, flags=0):
        """
        HitTest(dc, context, pt, flags=0) -> (int, textPosition, obj, contextObj)
        
        Hit-testing: returns a flag indicating hit test details, plus
        information about position.
        """

    def FindPosition(self, dc, context, index, forceLineStart):
        """
        FindPosition(dc, context, index, forceLineStart) -> (bool, pt, height)
        
        Finds the absolute position and row height for the given character
        position.
        """

    def GetBestSize(self):
        """
        GetBestSize() -> wx.Size
        
        Returns the best size, i.e. the ideal starting size for this object
        irrespective of available space.
        """

    def GetRangeSize(self, range, size, descent, dc, context, flags, position=wx.Point(0,0), parentSize=wx.DefaultSize, partialExtents=None):
        """
        GetRangeSize(range, size, descent, dc, context, flags, position=wx.Point(0,0), parentSize=wx.DefaultSize, partialExtents=None) -> bool
        
        Returns the object size for the given range.
        """

    def DoSplit(self, pos):
        """
        DoSplit(pos) -> RichTextObject
        
        Do a split from pos, returning an object containing the second part,
        and setting the first part in 'this'.
        """

    def CalculateRange(self, start):
        """
        CalculateRange(start) -> end
        
        Calculates the range of the object.
        """

    def DeleteRange(self, range):
        """
        DeleteRange(range) -> bool
        
        Deletes the given range.
        """

    def IsEmpty(self):
        """
        IsEmpty() -> bool
        
        Returns true if the object is empty.
        """

    def IsFloatable(self):
        """
        IsFloatable() -> bool
        
        Returns true if this class of object is floatable.
        """

    def IsFloating(self):
        """
        IsFloating() -> bool
        
        Returns true if this object is currently floating.
        """

    def GetFloatDirection(self):
        """
        GetFloatDirection() -> int
        
        Returns the floating direction.
        """

    def GetTextForRange(self, range):
        """
        GetTextForRange(range) -> String
        
        Returns any text in this object for the given range.
        """

    def CanMerge(self, object, context):
        """
        CanMerge(object, context) -> bool
        
        Returns true if this object can merge itself with the given one.
        """

    def Merge(self, object, context):
        """
        Merge(object, context) -> bool
        
        Returns true if this object merged itself with the given one.
        """

    def CanSplit(self, context):
        """
        CanSplit(context) -> bool
        
        Returns true if this object can potentially be split, by virtue of
        having different virtual attributes for individual sub-objects.
        """

    def Split(self, context):
        """
        Split(context) -> RichTextObject
        
        Returns the final object in the split objects if this object was split
        due to differences between sub-object virtual attributes.
        """

    def CanEditProperties(self):
        """
        CanEditProperties() -> bool
        
        Returns true if we can edit the object's properties via a GUI.
        """

    def EditProperties(self, parent, buffer):
        """
        EditProperties(parent, buffer) -> bool
        
        Edits the object's properties via a GUI.
        """

    def GetPropertiesMenuLabel(self):
        """
        GetPropertiesMenuLabel() -> String
        
        Returns the label to be used for the properties context menu item.
        """

    def AcceptsFocus(self):
        """
        AcceptsFocus() -> bool
        
        Returns true if objects of this class can accept the focus, i.e. a
        call to SetFocusObject is possible.
        """

    def ImportFromXML(self, buffer, node, handler, recurse):
        """
        ImportFromXML(buffer, node, handler, recurse) -> bool
        
        Imports this object from XML.
        """

    def UsesParagraphAttributes(self):
        """
        UsesParagraphAttributes() -> bool
        
        Returns true if this object takes note of paragraph attributes (text
        and image objects don't).
        """

    def GetXMLNodeName(self):
        """
        GetXMLNodeName() -> String
        
        Returns the XML node name of this object.
        """

    def Invalidate(self, invalidRange=RICHTEXT_ALL):
        """
        Invalidate(invalidRange=RICHTEXT_ALL)
        
        Invalidates the object at the given range.
        """

    def HandlesChildSelections(self):
        """
        HandlesChildSelections() -> bool
        
        Returns true if this object can handle the selections of its children,
        fOr example a table.
        """

    def GetSelection(self, start, end):
        """
        GetSelection(start, end) -> RichTextSelection
        
        Returns a selection object specifying the selections between start and
        end character positions.
        """

    def GetCachedSize(self):
        """
        GetCachedSize() -> wx.Size
        
        Gets the cached object size as calculated by Layout.
        """

    def SetCachedSize(self, sz):
        """
        SetCachedSize(sz)
        
        Sets the cached object size as calculated by Layout.
        """

    def GetMaxSize(self):
        """
        GetMaxSize() -> wx.Size
        
        Gets the maximum object size as calculated by Layout.
        """

    def SetMaxSize(self, sz):
        """
        SetMaxSize(sz)
        
        Sets the maximum object size as calculated by Layout.
        """

    def GetMinSize(self):
        """
        GetMinSize() -> wx.Size
        
        Gets the minimum object size as calculated by Layout.
        """

    def SetMinSize(self, sz):
        """
        SetMinSize(sz)
        
        Sets the minimum object size as calculated by Layout.
        """

    def GetNaturalSize(self):
        """
        GetNaturalSize() -> TextAttrSize
        
        Gets the 'natural' size for an object.
        """

    def GetPosition(self):
        """
        GetPosition() -> wx.Point
        
        Returns the object position in pixels.
        """

    def SetPosition(self, pos):
        """
        SetPosition(pos)
        
        Sets the object position in pixels.
        """

    def GetAbsolutePosition(self):
        """
        GetAbsolutePosition() -> wx.Point
        
        Returns the absolute object position, by traversing up the
        child/parent hierarchy.
        """

    def GetRect(self):
        """
        GetRect() -> wx.Rect
        
        Returns the rectangle enclosing the object.
        """

    def SetRange(self, range):
        """
        SetRange(range)
        
        Sets the object's range within its container.
        """

    def GetRange(self):
        """
        GetRange() -> RichTextRange
        
        Returns the object's range.
        """

    def SetOwnRange(self, range):
        """
        SetOwnRange(range)
        
        Set the object's own range, for a top-level object with its own
        position space.
        """

    def GetOwnRange(self):
        """
        GetOwnRange() -> RichTextRange
        
        Returns the object's own range (valid if top-level).
        """

    def GetOwnRangeIfTopLevel(self):
        """
        GetOwnRangeIfTopLevel() -> RichTextRange
        
        Returns the object's own range only if a top-level object.
        """

    def IsComposite(self):
        """
        IsComposite() -> bool
        
        Returns true if this object is composite.
        """

    def IsAtomic(self):
        """
        IsAtomic() -> bool
        
        Returns true if no user editing can be done inside the object.
        """

    def GetParent(self):
        """
        GetParent() -> RichTextObject
        
        Returns a pointer to the parent object.
        """

    def SetParent(self, parent):
        """
        SetParent(parent)
        
        Sets the pointer to the parent object.
        """

    def GetContainer(self):
        """
        GetContainer() -> RichTextParagraphLayoutBox
        
        Returns the top-level container of this object.
        """

    def GetParentContainer(self):
        """
        GetParentContainer() -> RichTextParagraphLayoutBox
        
        Returns the top-level container of this object.
        """

    def SetMargins(self, *args, **kw):
        """
        SetMargins(margin)
        SetMargins(leftMargin, rightMargin, topMargin, bottomMargin)
        
        Set the margin around the object, in pixels.
        """

    def GetLeftMargin(self):
        """
        GetLeftMargin() -> int
        
        Returns the left margin of the object, in pixels.
        """

    def GetRightMargin(self):
        """
        GetRightMargin() -> int
        
        Returns the right margin of the object, in pixels.
        """

    def GetTopMargin(self):
        """
        GetTopMargin() -> int
        
        Returns the top margin of the object, in pixels.
        """

    def GetBottomMargin(self):
        """
        GetBottomMargin() -> int
        
        Returns the bottom margin of the object, in pixels.
        """

    def GetAvailableContentArea(self, dc, context, outerRect):
        """
        GetAvailableContentArea(dc, context, outerRect) -> wx.Rect
        
        Calculates the available content space in the given rectangle, given
        the margins, border and padding specified in the object's attributes.
        """

    def LayoutToBestSize(self, dc, context, buffer, parentAttr, attr, availableParentSpace, availableContainerSpace, style):
        """
        LayoutToBestSize(dc, context, buffer, parentAttr, attr, availableParentSpace, availableContainerSpace, style) -> bool
        
        Lays out the object first with a given amount of space, and then if no
        width was specified in attr, lays out the object again using the
        minimum size.
        """

    def AdjustAttributes(self, attr, context):
        """
        AdjustAttributes(attr, context) -> bool
        
        Adjusts the attributes for virtual attribute provision, collapsed
        borders, etc.
        """

    def SetAttributes(self, attr):
        """
        SetAttributes(attr)
        
        Sets the object's attributes.
        """

    def GetAttributes(self):
        """
        GetAttributes() -> RichTextAttr
        
        Returns the object's attributes.
        """

    def GetProperties(self):
        """
        GetProperties() -> RichTextProperties
        
        Returns the object's properties.
        """

    def SetProperties(self, props):
        """
        SetProperties(props)
        
        Sets the object's properties.
        """

    def SetDescent(self, descent):
        """
        SetDescent(descent)
        
        Sets the stored descent value.
        """

    def GetDescent(self):
        """
        GetDescent() -> int
        
        Returns the stored descent value.
        """

    def GetBuffer(self):
        """
        GetBuffer() -> RichTextBuffer
        
        Returns the containing buffer.
        """

    def SetName(self, name):
        """
        SetName(name)
        
        Sets the identifying name for this object as a property using the
        "name" key.
        """

    def GetName(self):
        """
        GetName() -> String
        
        Returns the identifying name for this object from the properties,
        using the "name" key.
        """

    def IsTopLevel(self):
        """
        IsTopLevel() -> bool
        
        Returns true if this object is top-level, i.e. contains its own
        paragraphs, such as a text box.
        """

    def IsShown(self):
        """
        IsShown() -> bool
        
        Returns true if the object will be shown, false otherwise.
        """

    def Show(self, show):
        """
        Show(show)
        
        Call to show or hide this object.
        """

    def Clone(self):
        """
        Clone() -> RichTextObject
        
        Clones the object.
        """

    def Copy(self, obj):
        """
        Copy(obj)
        
        Copies the object.
        """

    def Reference(self):
        """
        Reference()
        
        Reference-counting allows us to use the same object in multiple lists
        (not yet used).
        """

    def Dereference(self):
        """
        Dereference()
        
        Reference-counting allows us to use the same object in multiple lists
        (not yet used).
        """

    def Move(self, pt):
        """
        Move(pt)
        
        Moves the object recursively, by adding the offset from old to new.
        """

    def ConvertTenthsMMToPixels(self, *args, **kw):
        """
        ConvertTenthsMMToPixels(dc, units) -> int
        ConvertTenthsMMToPixels(ppi, units, scale=1.0) -> int
        
        Converts units in tenths of a millimetre to device units.
        """

    def ConvertPixelsToTenthsMM(self, *args, **kw):
        """
        ConvertPixelsToTenthsMM(dc, pixels) -> int
        ConvertPixelsToTenthsMM(ppi, pixels, scale=1.0) -> int
        
        Convert units in pixels to tenths of a millimetre.
        """

    @staticmethod
    def DrawBoxAttributes(dc, buffer, attr, boxRect, flags=0, obj=None):
        """
        DrawBoxAttributes(dc, buffer, attr, boxRect, flags=0, obj=None) -> bool
        
        Draws the borders and background for the given rectangle and
        attributes.
        """

    @staticmethod
    def DrawBorder(dc, buffer, attr, rect, flags=0):
        """
        DrawBorder(dc, buffer, attr, rect, flags=0) -> bool
        
        Draws a border.
        """

    @staticmethod
    def GetBoxRects(dc, buffer, attr):
        """
        GetBoxRects(dc, buffer, attr) -> (bool, marginRect, borderRect, contentRect, paddingRect, outlineRect)
        
        Returns the various rectangles of the box model in pixels.
        """

    @staticmethod
    def GetTotalMargin(dc, buffer, attr):
        """
        GetTotalMargin(dc, buffer, attr) -> (bool, leftMargin, rightMargin, topMargin, bottomMargin)
        
        Returns the total margin for the object in pixels, taking into account
        margin, padding and border size.
        """

    @staticmethod
    def AdjustAvailableSpace(dc, buffer, parentAttr, childAttr, availableParentSpace, availableContainerSpace):
        """
        AdjustAvailableSpace(dc, buffer, parentAttr, childAttr, availableParentSpace, availableContainerSpace) -> wx.Rect
        
        Returns the rectangle which the child has available to it given
        restrictions specified in the child attribute, e.g.
        """
    AbsolutePosition = property(None, None)
    Attributes = property(None, None)
    BestSize = property(None, None)
    BottomMargin = property(None, None)
    Buffer = property(None, None)
    CachedSize = property(None, None)
    Container = property(None, None)
    Descent = property(None, None)
    FloatDirection = property(None, None)
    LeftMargin = property(None, None)
    MaxSize = property(None, None)
    MinSize = property(None, None)
    Name = property(None, None)
    NaturalSize = property(None, None)
    OwnRange = property(None, None)
    OwnRangeIfTopLevel = property(None, None)
    Parent = property(None, None)
    ParentContainer = property(None, None)
    Position = property(None, None)
    Properties = property(None, None)
    PropertiesMenuLabel = property(None, None)
    Range = property(None, None)
    Rect = property(None, None)
    RightMargin = property(None, None)
    TopMargin = property(None, None)
    XMLNodeName = property(None, None)
# end of class RichTextObject


class RichTextCompositeObject(RichTextObject):
    """
    RichTextCompositeObject(parent=None)
    
    Objects of this class can contain other objects.
    """

    def __init__(self, parent=None):
        """
        RichTextCompositeObject(parent=None)
        
        Objects of this class can contain other objects.
        """

    def HitTest(self, dc, context, pt, flags=0):
        """
        HitTest(dc, context, pt, flags=0) -> (int, textPosition, obj, contextObj)
        
        Hit-testing: returns a flag indicating hit test details, plus
        information about position.
        """

    def FindPosition(self, dc, context, index, forceLineStart):
        """
        FindPosition(dc, context, index, forceLineStart) -> (bool, pt, height)
        
        Finds the absolute position and row height for the given character
        position.
        """

    def CalculateRange(self, start):
        """
        CalculateRange(start) -> end
        
        Calculates the range of the object.
        """

    def DeleteRange(self, range):
        """
        DeleteRange(range) -> bool
        
        Deletes the given range.
        """

    def GetTextForRange(self, range):
        """
        GetTextForRange(range) -> String
        
        Returns any text in this object for the given range.
        """

    def GetRangeSize(self, range, size, descent, dc, context, flags, position=wx.Point(0,0), parentSize=wx.DefaultSize, partialExtents=None):
        """
        GetRangeSize(range, size, descent, dc, context, flags, position=wx.Point(0,0), parentSize=wx.DefaultSize, partialExtents=None) -> bool
        
        Returns the object size for the given range.
        """

    def Invalidate(self, invalidRange=RICHTEXT_ALL):
        """
        Invalidate(invalidRange=RICHTEXT_ALL)
        
        Invalidates the object at the given range.
        """

    def GetChildren(self):
        """
        GetChildren() -> RichTextObjectList
        
        Returns the children.
        """

    def GetChildCount(self):
        """
        GetChildCount() -> size_t
        
        Returns the number of children.
        """

    def GetChild(self, n):
        """
        GetChild(n) -> RichTextObject
        
        Returns the nth child.
        """

    def IsComposite(self):
        """
        IsComposite() -> bool
        
        Returns true if this object is composite.
        """

    def IsAtomic(self):
        """
        IsAtomic() -> bool
        
        Returns true if no user editing can be done inside the object.
        """

    def IsEmpty(self):
        """
        IsEmpty() -> bool
        
        Returns true if the buffer is empty.
        """

    def GetChildAtPosition(self, pos):
        """
        GetChildAtPosition(pos) -> RichTextObject
        
        Returns the child object at the given character position.
        """

    def Copy(self, obj):
        """
        Copy(obj)
        """

    def AppendChild(self, child):
        """
        AppendChild(child) -> size_t
        
        Appends a child, returning the position.
        """

    def InsertChild(self, child, inFrontOf):
        """
        InsertChild(child, inFrontOf) -> bool
        
        Inserts the child in front of the given object, or at the beginning.
        """

    def RemoveChild(self, child, deleteChild=False):
        """
        RemoveChild(child, deleteChild=False) -> bool
        
        Removes and optionally deletes the specified child.
        """

    def DeleteChildren(self):
        """
        DeleteChildren() -> bool
        
        Deletes all the children.
        """

    def Defragment(self, context, range=RICHTEXT_ALL):
        """
        Defragment(context, range=RICHTEXT_ALL) -> bool
        
        Recursively merges all pieces that can be merged.
        """

    def Move(self, pt):
        """
        Move(pt)
        
        Moves the object recursively, by adding the offset from old to new.
        """
    ChildCount = property(None, None)
    Children = property(None, None)
# end of class RichTextCompositeObject


class RichTextParagraphLayoutBox(RichTextCompositeObject):
    """
    RichTextParagraphLayoutBox(parent=None)
    RichTextParagraphLayoutBox(obj)
    
    This class knows how to lay out paragraphs.
    """

    def __init__(self, *args, **kw):
        """
        RichTextParagraphLayoutBox(parent=None)
        RichTextParagraphLayoutBox(obj)
        
        This class knows how to lay out paragraphs.
        """

    def SetListStyle(self, *args, **kw):
        """
        SetListStyle(range, styleDef, flags=RICHTEXT_SETSTYLE_WITH_UNDO, startFrom=1, specifiedLevel=-1) -> bool
        SetListStyle(range, defName, flags=RICHTEXT_SETSTYLE_WITH_UNDO, startFrom=1, specifiedLevel=-1) -> bool
        
        Sets the list attributes for the given range, passing flags to
        determine how the attributes are set.
        """

    def NumberList(self, *args, **kw):
        """
        NumberList(range, def=None, flags=RICHTEXT_SETSTYLE_WITH_UNDO, startFrom=1, specifiedLevel=-1) -> bool
        NumberList(range, defName, flags=RICHTEXT_SETSTYLE_WITH_UNDO, startFrom=1, specifiedLevel=-1) -> bool
        
        Numbers the paragraphs in the given range.
        """

    def PromoteList(self, *args, **kw):
        """
        PromoteList(promoteBy, range, def=None, flags=RICHTEXT_SETSTYLE_WITH_UNDO, specifiedLevel=-1) -> bool
        PromoteList(promoteBy, range, defName, flags=RICHTEXT_SETSTYLE_WITH_UNDO, specifiedLevel=-1) -> bool
        
        Promotes the list items within the given range.
        """

    def HitTest(self, dc, context, pt, flags=0):
        """
        HitTest(dc, context, pt, flags=0) -> (int, textPosition, obj, contextObj)
        
        Hit-testing: returns a flag indicating hit test details, plus
        information about position.
        """

    def Draw(self, dc, context, range, selection, rect, descent, style):
        """
        Draw(dc, context, range, selection, rect, descent, style) -> bool
        
        Draw the item, within the given range.
        """

    def Layout(self, dc, context, rect, parentRect, style):
        """
        Layout(dc, context, rect, parentRect, style) -> bool
        
        Lay the item out at the specified position with the given size
        constraint.
        """

    def GetRangeSize(self, range, size, descent, dc, context, flags, position=wx.Point(0,0), parentSize=wx.DefaultSize, partialExtents=None):
        """
        GetRangeSize(range, size, descent, dc, context, flags, position=wx.Point(0,0), parentSize=wx.DefaultSize, partialExtents=None) -> bool
        
        Returns the object size for the given range.
        """

    def DeleteRange(self, range):
        """
        DeleteRange(range) -> bool
        
        Deletes the given range.
        """

    def GetTextForRange(self, range):
        """
        GetTextForRange(range) -> String
        
        Returns any text in this object for the given range.
        """

    def ImportFromXML(self, buffer, node, handler, recurse):
        """
        ImportFromXML(buffer, node, handler, recurse) -> bool
        
        Imports this object from XML.
        """

    def GetXMLNodeName(self):
        """
        GetXMLNodeName() -> String
        
        Returns the XML node name of this object.
        """

    def AcceptsFocus(self):
        """
        AcceptsFocus() -> bool
        
        Returns true if objects of this class can accept the focus, i.e. a
        call to SetFocusObject is possible.
        """

    def SetRichTextCtrl(self, ctrl):
        """
        SetRichTextCtrl(ctrl)
        
        Associates a control with the buffer, for operations that for example
        require refreshing the window.
        """

    def GetRichTextCtrl(self):
        """
        GetRichTextCtrl() -> RichTextCtrl
        
        Returns the associated control.
        """

    def SetPartialParagraph(self, partialPara):
        """
        SetPartialParagraph(partialPara)
        
        Sets a flag indicating whether the last paragraph is partial or
        complete.
        """

    def GetPartialParagraph(self):
        """
        GetPartialParagraph() -> bool
        
        Returns a flag indicating whether the last paragraph is partial or
        complete.
        """

    def GetStyleSheet(self):
        """
        GetStyleSheet() -> RichTextStyleSheet
        
        Returns the style sheet associated with the overall buffer.
        """

    def IsTopLevel(self):
        """
        IsTopLevel() -> bool
        
        Returns true if this object is top-level, i.e. contains its own
        paragraphs, such as a text box.
        """

    def InsertParagraphsWithUndo(self, buffer, pos, paragraphs, ctrl, flags=0):
        """
        InsertParagraphsWithUndo(buffer, pos, paragraphs, ctrl, flags=0) -> bool
        
        Submits a command to insert paragraphs.
        """

    def InsertTextWithUndo(self, buffer, pos, text, ctrl, flags=0):
        """
        InsertTextWithUndo(buffer, pos, text, ctrl, flags=0) -> bool
        
        Submits a command to insert the given text.
        """

    def InsertNewlineWithUndo(self, buffer, pos, ctrl, flags=0):
        """
        InsertNewlineWithUndo(buffer, pos, ctrl, flags=0) -> bool
        
        Submits a command to insert the given text.
        """

    def InsertImageWithUndo(self, buffer, pos, imageBlock, ctrl, flags, textAttr):
        """
        InsertImageWithUndo(buffer, pos, imageBlock, ctrl, flags, textAttr) -> bool
        
        Submits a command to insert the given image.
        """

    def InsertFieldWithUndo(self, buffer, pos, fieldType, properties, ctrl, flags, textAttr):
        """
        InsertFieldWithUndo(buffer, pos, fieldType, properties, ctrl, flags, textAttr) -> RichTextField
        
        Submits a command to insert the given field.
        """

    def GetStyleForNewParagraph(self, buffer, pos, caretPosition=False, lookUpNewParaStyle=False):
        """
        GetStyleForNewParagraph(buffer, pos, caretPosition=False, lookUpNewParaStyle=False) -> RichTextAttr
        
        Returns the style that is appropriate for a new paragraph at this
        position.
        """

    def InsertObjectWithUndo(self, buffer, pos, object, ctrl, flags=0):
        """
        InsertObjectWithUndo(buffer, pos, object, ctrl, flags=0) -> RichTextObject
        
        Inserts an object.
        """

    def DeleteRangeWithUndo(self, range, ctrl, buffer):
        """
        DeleteRangeWithUndo(range, ctrl, buffer) -> bool
        
        Submits a command to delete this range.
        """

    def DrawFloats(self, dc, context, range, selection, rect, descent, style):
        """
        DrawFloats(dc, context, range, selection, rect, descent, style)
        
        Draws the floating objects in this buffer.
        """

    def MoveAnchoredObjectToParagraph(self, from_, to_, obj):
        """
        MoveAnchoredObjectToParagraph(from_, to_, obj)
        
        Moves an anchored object to another paragraph.
        """

    def Init(self):
        """
        Init()
        
        Initializes the object.
        """

    def Clear(self):
        """
        Clear()
        
        Clears all the children.
        """

    def Reset(self):
        """
        Reset()
        
        Clears and initializes with one blank paragraph.
        """

    def AddParagraph(self, text, paraStyle=None):
        """
        AddParagraph(text, paraStyle=None) -> RichTextRange
        
        Convenience function to add a paragraph of text.
        """

    def AddImage(self, image, paraStyle=None):
        """
        AddImage(image, paraStyle=None) -> RichTextRange
        
        Convenience function to add an image.
        """

    def AddParagraphs(self, text, paraStyle=None):
        """
        AddParagraphs(text, paraStyle=None) -> RichTextRange
        
        Adds multiple paragraphs, based on newlines.
        """

    def GetLineAtPosition(self, pos, caretPosition=False):
        """
        GetLineAtPosition(pos, caretPosition=False) -> RichTextLine
        
        Returns the line at the given position.
        """

    def GetLineAtYPosition(self, y):
        """
        GetLineAtYPosition(y) -> RichTextLine
        
        Returns the line at the given y pixel position, or the last line.
        """

    def GetParagraphAtPosition(self, pos, caretPosition=False):
        """
        GetParagraphAtPosition(pos, caretPosition=False) -> RichTextParagraph
        
        Returns the paragraph at the given character or caret position.
        """

    def GetLineSizeAtPosition(self, pos, caretPosition=False):
        """
        GetLineSizeAtPosition(pos, caretPosition=False) -> wx.Size
        
        Returns the line size at the given position.
        """

    def GetVisibleLineNumber(self, pos, caretPosition=False, startOfLine=False):
        """
        GetVisibleLineNumber(pos, caretPosition=False, startOfLine=False) -> long
        
        Given a position, returns the number of the visible line (potentially
        many to a paragraph), starting from zero at the start of the buffer.
        """

    def GetLineForVisibleLineNumber(self, lineNumber):
        """
        GetLineForVisibleLineNumber(lineNumber) -> RichTextLine
        
        Given a line number, returns the corresponding wxRichTextLine object.
        """

    def GetLeafObjectAtPosition(self, position):
        """
        GetLeafObjectAtPosition(position) -> RichTextObject
        
        Returns the leaf object in a paragraph at this position.
        """

    def GetParagraphAtLine(self, paragraphNumber):
        """
        GetParagraphAtLine(paragraphNumber) -> RichTextParagraph
        
        Returns the paragraph by number.
        """

    def GetParagraphForLine(self, line):
        """
        GetParagraphForLine(line) -> RichTextParagraph
        
        Returns the paragraph for a given line.
        """

    def GetParagraphLength(self, paragraphNumber):
        """
        GetParagraphLength(paragraphNumber) -> int
        
        Returns the length of the paragraph.
        """

    def GetParagraphCount(self):
        """
        GetParagraphCount() -> int
        
        Returns the number of paragraphs.
        """

    def GetLineCount(self):
        """
        GetLineCount() -> int
        
        Returns the number of visible lines.
        """

    def GetParagraphText(self, paragraphNumber):
        """
        GetParagraphText(paragraphNumber) -> String
        
        Returns the text of the paragraph.
        """

    def XYToPosition(self, x, y):
        """
        XYToPosition(x, y) -> long
        
        Converts zero-based line column and paragraph number to a position.
        """

    def PositionToXY(self, pos, x, y):
        """
        PositionToXY(pos, x, y) -> bool
        
        Converts a zero-based position to line column and paragraph number.
        """

    def SetStyle(self, *args, **kw):
        """
        SetStyle(range, style, flags=RICHTEXT_SETSTYLE_WITH_UNDO) -> bool
        SetStyle(obj, textAttr, flags=RICHTEXT_SETSTYLE_WITH_UNDO)
        
        Sets the attributes for the given range.
        """

    def GetStyle(self, position, style):
        """
        GetStyle(position, style) -> bool
        
        Returns the combined text attributes for this position.
        """

    def GetUncombinedStyle(self, position, style):
        """
        GetUncombinedStyle(position, style) -> bool
        
        Returns the content (uncombined) attributes for this position.
        """

    def DoGetStyle(self, position, style, combineStyles=True):
        """
        DoGetStyle(position, style, combineStyles=True) -> bool
        
        Implementation helper for GetStyle.
        """

    def GetStyleForRange(self, range, style):
        """
        GetStyleForRange(range, style) -> bool
        
        This function gets a style representing the common, combined
        attributes in the given range.
        """

    def CollectStyle(self, currentStyle, style, clashingAttr, absentAttr):
        """
        CollectStyle(currentStyle, style, clashingAttr, absentAttr) -> bool
        
        Combines style with currentStyle for the purpose of summarising the
        attributes of a range of content.
        """

    def ClearListStyle(self, range, flags=RICHTEXT_SETSTYLE_WITH_UNDO):
        """
        ClearListStyle(range, flags=RICHTEXT_SETSTYLE_WITH_UNDO) -> bool
        
        Clears the list style from the given range, clearing list-related
        attributes and applying any named paragraph style associated with each
        paragraph.
        """

    def DoNumberList(self, range, promotionRange, promoteBy, styleDef, flags=RICHTEXT_SETSTYLE_WITH_UNDO, startFrom=1, specifiedLevel=-1):
        """
        DoNumberList(range, promotionRange, promoteBy, styleDef, flags=RICHTEXT_SETSTYLE_WITH_UNDO, startFrom=1, specifiedLevel=-1) -> bool
        
        Helper for NumberList and PromoteList, that does renumbering and
        promotion simultaneously def can be NULL/empty to indicate that the
        existing list style should be used.
        """

    def FindNextParagraphNumber(self, previousParagraph, attr):
        """
        FindNextParagraphNumber(previousParagraph, attr) -> bool
        
        Fills in the attributes for numbering a paragraph after
        previousParagraph.
        """

    def SetProperties(self, range, properties, flags=RICHTEXT_SETPROPERTIES_WITH_UNDO):
        """
        SetProperties(range, properties, flags=RICHTEXT_SETPROPERTIES_WITH_UNDO) -> bool
        
        Sets the properties for the given range, passing flags to determine
        how the attributes are set.
        """

    def SetObjectPropertiesWithUndo(self, obj, properties, objToSet=None):
        """
        SetObjectPropertiesWithUndo(obj, properties, objToSet=None) -> bool
        
        Sets with undo the properties for the given object.
        """

    def HasCharacterAttributes(self, range, style):
        """
        HasCharacterAttributes(range, style) -> bool
        
        Test if this whole range has character attributes of the specified
        kind.
        """

    def HasParagraphAttributes(self, range, style):
        """
        HasParagraphAttributes(range, style) -> bool
        
        Test if this whole range has paragraph attributes of the specified
        kind.
        """

    def Clone(self):
        """
        Clone() -> RichTextObject
        
        Clones the object.
        """

    def PrepareContent(self, container):
        """
        PrepareContent(container)
        
        Prepares the content just before insertion (or after buffer reset).
        """

    def InsertFragment(self, position, fragment):
        """
        InsertFragment(position, fragment) -> bool
        
        Insert fragment into this box at the given position.
        """

    def CopyFragment(self, range, fragment):
        """
        CopyFragment(range, fragment) -> bool
        
        Make a copy of the fragment corresponding to the given range, putting
        it in fragment.
        """

    def ApplyStyleSheet(self, styleSheet):
        """
        ApplyStyleSheet(styleSheet) -> bool
        
        Apply the style sheet to the buffer, for example if the styles have
        changed.
        """

    def Copy(self, obj):
        """
        Copy(obj)
        """

    def UpdateRanges(self):
        """
        UpdateRanges()
        
        Calculate ranges.
        """

    def GetText(self):
        """
        GetText() -> String
        
        Get all the text.
        """

    def SetDefaultStyle(self, style):
        """
        SetDefaultStyle(style) -> bool
        
        Sets the default style, affecting the style currently being applied
        (for example, setting the default style to bold will cause
        subsequently inserted text to be bold).
        """

    def GetDefaultStyle(self):
        """
        GetDefaultStyle() -> RichTextAttr
        
        Returns the current default style, affecting the style currently being
        applied (for example, setting the default style to bold will cause
        subsequently inserted text to be bold).
        """

    def SetBasicStyle(self, style):
        """
        SetBasicStyle(style)
        
        Sets the basic (overall) style.
        """

    def GetBasicStyle(self):
        """
        GetBasicStyle() -> RichTextAttr
        
        Returns the basic (overall) style.
        """

    def Invalidate(self, invalidRange=RICHTEXT_ALL):
        """
        Invalidate(invalidRange=RICHTEXT_ALL)
        
        Invalidates the buffer.
        """

    def DoInvalidate(self, invalidRange):
        """
        DoInvalidate(invalidRange)
        
        Do the (in)validation for this object only.
        """

    def InvalidateHierarchy(self, invalidRange=RICHTEXT_ALL):
        """
        InvalidateHierarchy(invalidRange=RICHTEXT_ALL)
        
        Do the (in)validation both up and down the hierarchy.
        """

    def UpdateFloatingObjects(self, availableRect, untilObj=None):
        """
        UpdateFloatingObjects(availableRect, untilObj=None) -> bool
        
        Gather information about floating objects.
        """

    def GetInvalidRange(self, wholeParagraphs=False):
        """
        GetInvalidRange(wholeParagraphs=False) -> RichTextRange
        
        Get invalid range, rounding to entire paragraphs if argument is true.
        """

    def IsDirty(self):
        """
        IsDirty() -> bool
        
        Returns true if this object needs layout.
        """

    def GetFloatCollector(self):
        """
        GetFloatCollector() -> RichTextFloatCollector
        
        Returns the wxRichTextFloatCollector of this object.
        """

    def GetFloatingObjectCount(self):
        """
        GetFloatingObjectCount() -> int
        
        Returns the number of floating objects at this level.
        """

    def GetFloatingObjects(self, objects):
        """
        GetFloatingObjects(objects) -> bool
        
        Returns a list of floating objects.
        """
    BasicStyle = property(None, None)
    DefaultStyle = property(None, None)
    FloatCollector = property(None, None)
    FloatingObjectCount = property(None, None)
    InvalidRange = property(None, None)
    LineCount = property(None, None)
    ParagraphCount = property(None, None)
    PartialParagraph = property(None, None)
    RichTextCtrl = property(None, None)
    StyleSheet = property(None, None)
    Text = property(None, None)
    XMLNodeName = property(None, None)
# end of class RichTextParagraphLayoutBox


class RichTextBox(RichTextParagraphLayoutBox):
    """
    RichTextBox(parent=None)
    RichTextBox(obj)
    
    This class implements a floating or inline text box, containing
    paragraphs.
    """

    def __init__(self, *args, **kw):
        """
        RichTextBox(parent=None)
        RichTextBox(obj)
        
        This class implements a floating or inline text box, containing
        paragraphs.
        """

    def Draw(self, dc, context, range, selection, rect, descent, style):
        """
        Draw(dc, context, range, selection, rect, descent, style) -> bool
        
        Draw the item, within the given range.
        """

    def GetXMLNodeName(self):
        """
        GetXMLNodeName() -> String
        
        Returns the XML node name of this object.
        """

    def CanEditProperties(self):
        """
        CanEditProperties() -> bool
        
        Returns true if we can edit the object's properties via a GUI.
        """

    def EditProperties(self, parent, buffer):
        """
        EditProperties(parent, buffer) -> bool
        
        Edits the object's properties via a GUI.
        """

    def GetPropertiesMenuLabel(self):
        """
        GetPropertiesMenuLabel() -> String
        
        Returns the label to be used for the properties context menu item.
        """

    def Clone(self):
        """
        Clone() -> RichTextObject
        
        Clones the object.
        """

    def Copy(self, obj):
        """
        Copy(obj)
        """
    PropertiesMenuLabel = property(None, None)
    XMLNodeName = property(None, None)
# end of class RichTextBox


class RichTextField(RichTextParagraphLayoutBox):
    """
    RichTextField(fieldType=wx.EmptyString, parent=None)
    RichTextField(obj)
    
    This class implements the general concept of a field, an object that
    represents additional functionality such as a footnote, a bookmark, a
    page number, a table of contents, and so on.
    """

    def __init__(self, *args, **kw):
        """
        RichTextField(fieldType=wx.EmptyString, parent=None)
        RichTextField(obj)
        
        This class implements the general concept of a field, an object that
        represents additional functionality such as a footnote, a bookmark, a
        page number, a table of contents, and so on.
        """

    def Draw(self, dc, context, range, selection, rect, descent, style):
        """
        Draw(dc, context, range, selection, rect, descent, style) -> bool
        
        Draw the item, within the given range.
        """

    def Layout(self, dc, context, rect, parentRect, style):
        """
        Layout(dc, context, rect, parentRect, style) -> bool
        
        Lay the item out at the specified position with the given size
        constraint.
        """

    def GetRangeSize(self, range, size, descent, dc, context, flags, position=wx.Point(0,0), parentSize=wx.DefaultSize, partialExtents=None):
        """
        GetRangeSize(range, size, descent, dc, context, flags, position=wx.Point(0,0), parentSize=wx.DefaultSize, partialExtents=None) -> bool
        
        Returns the object size for the given range.
        """

    def GetXMLNodeName(self):
        """
        GetXMLNodeName() -> String
        
        Returns the XML node name of this object.
        """

    def CanEditProperties(self):
        """
        CanEditProperties() -> bool
        
        Returns true if we can edit the object's properties via a GUI.
        """

    def EditProperties(self, parent, buffer):
        """
        EditProperties(parent, buffer) -> bool
        
        Edits the object's properties via a GUI.
        """

    def GetPropertiesMenuLabel(self):
        """
        GetPropertiesMenuLabel() -> String
        
        Returns the label to be used for the properties context menu item.
        """

    def AcceptsFocus(self):
        """
        AcceptsFocus() -> bool
        
        Returns true if objects of this class can accept the focus, i.e. a
        call to SetFocusObject is possible.
        """

    def CalculateRange(self, start):
        """
        CalculateRange(start) -> end
        
        Calculates the range of the object.
        """

    def IsAtomic(self):
        """
        IsAtomic() -> bool
        
        If a field has children, we don't want the user to be able to edit it.
        """

    def IsEmpty(self):
        """
        IsEmpty() -> bool
        
        Returns true if the buffer is empty.
        """

    def IsTopLevel(self):
        """
        IsTopLevel() -> bool
        
        Returns true if this object is top-level, i.e. contains its own
        paragraphs, such as a text box.
        """

    def SetFieldType(self, fieldType):
        """
        SetFieldType(fieldType)
        """

    def GetFieldType(self):
        """
        GetFieldType() -> String
        """

    def UpdateField(self, buffer):
        """
        UpdateField(buffer) -> bool
        
        Update the field; delegated to the associated field type.
        """

    def Clone(self):
        """
        Clone() -> RichTextObject
        
        Clones the object.
        """

    def Copy(self, obj):
        """
        Copy(obj)
        """
    FieldType = property(None, None)
    PropertiesMenuLabel = property(None, None)
    XMLNodeName = property(None, None)
# end of class RichTextField


class RichTextFieldType(wx.Object):
    """
    RichTextFieldType(name=wx.EmptyString)
    RichTextFieldType(fieldType)
    
    The base class for custom field types.
    """

    def __init__(self, *args, **kw):
        """
        RichTextFieldType(name=wx.EmptyString)
        RichTextFieldType(fieldType)
        
        The base class for custom field types.
        """

    def Copy(self, fieldType):
        """
        Copy(fieldType)
        """

    def Draw(self, obj, dc, context, range, selection, rect, descent, style):
        """
        Draw(obj, dc, context, range, selection, rect, descent, style) -> bool
        
        Draw the item, within the given range.
        """

    def Layout(self, obj, dc, context, rect, parentRect, style):
        """
        Layout(obj, dc, context, rect, parentRect, style) -> bool
        
        Lay the item out at the specified position with the given size
        constraint.
        """

    def GetRangeSize(self, obj, range, size, descent, dc, context, flags, position=wx.Point(0,0), parentSize=wx.DefaultSize, partialExtents=None):
        """
        GetRangeSize(obj, range, size, descent, dc, context, flags, position=wx.Point(0,0), parentSize=wx.DefaultSize, partialExtents=None) -> bool
        
        Returns the object size for the given range.
        """

    def CanEditProperties(self, obj):
        """
        CanEditProperties(obj) -> bool
        
        Returns true if we can edit the object's properties via a GUI.
        """

    def EditProperties(self, obj, parent, buffer):
        """
        EditProperties(obj, parent, buffer) -> bool
        
        Edits the object's properties via a GUI.
        """

    def GetPropertiesMenuLabel(self, obj):
        """
        GetPropertiesMenuLabel(obj) -> String
        
        Returns the label to be used for the properties context menu item.
        """

    def UpdateField(self, buffer, obj):
        """
        UpdateField(buffer, obj) -> bool
        
        Update the field.
        """

    def IsTopLevel(self, obj):
        """
        IsTopLevel(obj) -> bool
        
        Returns true if this object is top-level, i.e. contains its own
        paragraphs, such as a text box.
        """

    def SetName(self, name):
        """
        SetName(name)
        
        Sets the field type name.
        """

    def GetName(self):
        """
        GetName() -> String
        
        Returns the field type name.
        """
    Name = property(None, None)
# end of class RichTextFieldType


class RichTextFieldTypeStandard(RichTextFieldType):
    """
    RichTextFieldTypeStandard(name, label, displayStyle=RICHTEXT_FIELD_STYLE_RECTANGLE)
    RichTextFieldTypeStandard(name, bitmap, displayStyle=RICHTEXT_FIELD_STYLE_NO_BORDER)
    RichTextFieldTypeStandard()
    RichTextFieldTypeStandard(field)
    
    A field type that can handle fields with text or bitmap labels, with a
    small range of styles for implementing rectangular fields and fields
    that can be used for start and end tags.
    """
    RICHTEXT_FIELD_STYLE_COMPOSITE = 0
    RICHTEXT_FIELD_STYLE_RECTANGLE = 0
    RICHTEXT_FIELD_STYLE_NO_BORDER = 0
    RICHTEXT_FIELD_STYLE_START_TAG = 0
    RICHTEXT_FIELD_STYLE_END_TAG = 0

    def __init__(self, *args, **kw):
        """
        RichTextFieldTypeStandard(name, label, displayStyle=RICHTEXT_FIELD_STYLE_RECTANGLE)
        RichTextFieldTypeStandard(name, bitmap, displayStyle=RICHTEXT_FIELD_STYLE_NO_BORDER)
        RichTextFieldTypeStandard()
        RichTextFieldTypeStandard(field)
        
        A field type that can handle fields with text or bitmap labels, with a
        small range of styles for implementing rectangular fields and fields
        that can be used for start and end tags.
        """

    def Init(self):
        """
        Init()
        
        Initialises the object.
        """

    def Copy(self, field):
        """
        Copy(field)
        
        Copies the object.
        """

    def Draw(self, obj, dc, context, range, selection, rect, descent, style):
        """
        Draw(obj, dc, context, range, selection, rect, descent, style) -> bool
        
        Draw the item, within the given range.
        """

    def Layout(self, obj, dc, context, rect, parentRect, style):
        """
        Layout(obj, dc, context, rect, parentRect, style) -> bool
        
        Lay the item out at the specified position with the given size
        constraint.
        """

    def GetRangeSize(self, obj, range, size, descent, dc, context, flags, position=wx.Point(0,0), parentSize=wx.DefaultSize, partialExtents=None):
        """
        GetRangeSize(obj, range, size, descent, dc, context, flags, position=wx.Point(0,0), parentSize=wx.DefaultSize, partialExtents=None) -> bool
        
        Returns the object size for the given range.
        """

    def GetSize(self, obj, dc, context, style):
        """
        GetSize(obj, dc, context, style) -> wx.Size
        
        Get the size of the field, given the label, font size, and so on.
        """

    def IsTopLevel(self, obj):
        """
        IsTopLevel(obj) -> bool
        
        Returns true if the display type is wxRICHTEXT_FIELD_STYLE_COMPOSITE,
        false otherwise.
        """

    def SetLabel(self, label):
        """
        SetLabel(label)
        
        Sets the text label for fields of this type.
        """

    def GetLabel(self):
        """
        GetLabel() -> String
        
        Returns the text label for fields of this type.
        """

    def SetBitmap(self, bitmap):
        """
        SetBitmap(bitmap)
        
        Sets the bitmap label for fields of this type.
        """

    def GetBitmap(self):
        """
        GetBitmap() -> wx.Bitmap
        
        Gets the bitmap label for fields of this type.
        """

    def GetDisplayStyle(self):
        """
        GetDisplayStyle() -> int
        
        Gets the display style for fields of this type.
        """

    def SetDisplayStyle(self, displayStyle):
        """
        SetDisplayStyle(displayStyle)
        
        Sets the display style for fields of this type.
        """

    def GetFont(self):
        """
        GetFont() -> wx.Font
        
        Gets the font used for drawing the text label.
        """

    def SetFont(self, font):
        """
        SetFont(font)
        
        Sets the font used for drawing the text label.
        """

    def GetTextColour(self):
        """
        GetTextColour() -> wx.Colour
        
        Gets the colour used for drawing the text label.
        """

    def SetTextColour(self, colour):
        """
        SetTextColour(colour)
        
        Sets the colour used for drawing the text label.
        """

    def GetBorderColour(self):
        """
        GetBorderColour() -> wx.Colour
        
        Gets the colour used for drawing the field border.
        """

    def SetBorderColour(self, colour):
        """
        SetBorderColour(colour)
        
        Sets the colour used for drawing the field border.
        """

    def GetBackgroundColour(self):
        """
        GetBackgroundColour() -> wx.Colour
        
        Gets the colour used for drawing the field background.
        """

    def SetBackgroundColour(self, colour):
        """
        SetBackgroundColour(colour)
        
        Sets the colour used for drawing the field background.
        """

    def SetVerticalPadding(self, padding):
        """
        SetVerticalPadding(padding)
        
        Sets the vertical padding (the distance between the border and the
        text).
        """

    def GetVerticalPadding(self):
        """
        GetVerticalPadding() -> int
        
        Gets the vertical padding (the distance between the border and the
        text).
        """

    def SetHorizontalPadding(self, padding):
        """
        SetHorizontalPadding(padding)
        
        Sets the horizontal padding (the distance between the border and the
        text).
        """

    def GetHorizontalPadding(self):
        """
        GetHorizontalPadding() -> int
        
        Sets the horizontal padding (the distance between the border and the
        text).
        """

    def SetHorizontalMargin(self, margin):
        """
        SetHorizontalMargin(margin)
        
        Sets the horizontal margin surrounding the field object.
        """

    def GetHorizontalMargin(self):
        """
        GetHorizontalMargin() -> int
        
        Gets the horizontal margin surrounding the field object.
        """

    def SetVerticalMargin(self, margin):
        """
        SetVerticalMargin(margin)
        
        Sets the vertical margin surrounding the field object.
        """

    def GetVerticalMargin(self):
        """
        GetVerticalMargin() -> int
        
        Gets the vertical margin surrounding the field object.
        """
    BackgroundColour = property(None, None)
    Bitmap = property(None, None)
    BorderColour = property(None, None)
    DisplayStyle = property(None, None)
    Font = property(None, None)
    HorizontalMargin = property(None, None)
    HorizontalPadding = property(None, None)
    Label = property(None, None)
    TextColour = property(None, None)
    VerticalMargin = property(None, None)
    VerticalPadding = property(None, None)
# end of class RichTextFieldTypeStandard


class RichTextLine(object):
    """
    RichTextLine(parent)
    RichTextLine(obj)
    
    This object represents a line in a paragraph, and stores offsets from
    the start of the paragraph representing the start and end positions of
    the line.
    """

    def __init__(self, *args, **kw):
        """
        RichTextLine(parent)
        RichTextLine(obj)
        
        This object represents a line in a paragraph, and stores offsets from
        the start of the paragraph representing the start and end positions of
        the line.
        """

    def SetRange(self, *args, **kw):
        """
        SetRange(range)
        SetRange(from_, to_)
        
        Sets the range associated with this line.
        """

    def GetParent(self):
        """
        GetParent() -> RichTextParagraph
        
        Returns the parent paragraph.
        """

    def GetRange(self):
        """
        GetRange() -> RichTextRange
        
        Returns the range.
        """

    def GetAbsoluteRange(self):
        """
        GetAbsoluteRange() -> RichTextRange
        
        Returns the absolute range.
        """

    def GetSize(self):
        """
        GetSize() -> wx.Size
        
        Returns the line size as calculated by Layout.
        """

    def SetSize(self, sz):
        """
        SetSize(sz)
        
        Sets the line size as calculated by Layout.
        """

    def GetPosition(self):
        """
        GetPosition() -> wx.Point
        
        Returns the object position relative to the parent.
        """

    def SetPosition(self, pos):
        """
        SetPosition(pos)
        
        Sets the object position relative to the parent.
        """

    def GetAbsolutePosition(self):
        """
        GetAbsolutePosition() -> wx.Point
        
        Returns the absolute object position.
        """

    def GetRect(self):
        """
        GetRect() -> wx.Rect
        
        Returns the rectangle enclosing the line.
        """

    def SetDescent(self, descent):
        """
        SetDescent(descent)
        
        Sets the stored descent.
        """

    def GetDescent(self):
        """
        GetDescent() -> int
        
        Returns the stored descent.
        """

    def Init(self, parent):
        """
        Init(parent)
        
        Initialises the object.
        """

    def Copy(self, obj):
        """
        Copy(obj)
        
        Copies from obj.
        """

    def Clone(self):
        """
        Clone() -> RichTextLine
        """
    AbsolutePosition = property(None, None)
    AbsoluteRange = property(None, None)
    Descent = property(None, None)
    Parent = property(None, None)
    Position = property(None, None)
    Range = property(None, None)
    Rect = property(None, None)
    Size = property(None, None)
# end of class RichTextLine


class RichTextParagraph(RichTextCompositeObject):
    """
    RichTextParagraph(parent=None, style=None)
    RichTextParagraph(text, parent=None, paraStyle=None, charStyle=None)
    RichTextParagraph(obj)
    
    This object represents a single paragraph containing various objects
    such as text content, images, and further paragraph layout objects.
    """

    def __init__(self, *args, **kw):
        """
        RichTextParagraph(parent=None, style=None)
        RichTextParagraph(text, parent=None, paraStyle=None, charStyle=None)
        RichTextParagraph(obj)
        
        This object represents a single paragraph containing various objects
        such as text content, images, and further paragraph layout objects.
        """

    def Draw(self, dc, context, range, selection, rect, descent, style):
        """
        Draw(dc, context, range, selection, rect, descent, style) -> bool
        
        Draw the item, within the given range.
        """

    def Layout(self, dc, context, rect, parentRect, style):
        """
        Layout(dc, context, rect, parentRect, style) -> bool
        
        Lay the item out at the specified position with the given size
        constraint.
        """

    def GetRangeSize(self, range, size, descent, dc, context, flags, position=wx.Point(0,0), parentSize=wx.DefaultSize, partialExtents=None):
        """
        GetRangeSize(range, size, descent, dc, context, flags, position=wx.Point(0,0), parentSize=wx.DefaultSize, partialExtents=None) -> bool
        
        Returns the object size for the given range.
        """

    def FindPosition(self, dc, context, index, forceLineStart):
        """
        FindPosition(dc, context, index, forceLineStart) -> (bool, pt, height)
        
        Finds the absolute position and row height for the given character
        position.
        """

    def HitTest(self, dc, context, pt, flags=0):
        """
        HitTest(dc, context, pt, flags=0) -> (int, textPosition, obj, contextObj)
        
        Hit-testing: returns a flag indicating hit test details, plus
        information about position.
        """

    def CalculateRange(self, start):
        """
        CalculateRange(start) -> end
        
        Calculates the range of the object.
        """

    def GetXMLNodeName(self):
        """
        GetXMLNodeName() -> String
        
        Returns the XML node name of this object.
        """

    def GetLines(self):
        """
        GetLines() -> RichTextLineList
        
        Returns the cached lines.
        """

    def Copy(self, obj):
        """
        Copy(obj)
        
        Copies the object.
        """

    def Clone(self):
        """
        Clone() -> RichTextObject
        
        Clones the object.
        """

    def ClearLines(self):
        """
        ClearLines()
        
        Clears the cached lines.
        """

    def ApplyParagraphStyle(self, line, attr, rect, dc):
        """
        ApplyParagraphStyle(line, attr, rect, dc)
        
        Applies paragraph styles such as centering to the wrapped lines.
        """

    def InsertText(self, pos, text):
        """
        InsertText(pos, text) -> bool
        
        Inserts text at the given position.
        """

    def SplitAt(self, pos, previousObject=None):
        """
        SplitAt(pos, previousObject=None) -> RichTextObject
        
        Splits an object at this position if necessary, and returns the
        previous object, or NULL if inserting at the beginning.
        """

    def MoveToList(self, obj, list):
        """
        MoveToList(obj, list)
        
        Moves content to a list from this point.
        """

    def MoveFromList(self, list):
        """
        MoveFromList(list)
        
        Adds content back from a list.
        """

    def GetContiguousPlainText(self, text, range, fromStart=True):
        """
        GetContiguousPlainText(text, range, fromStart=True) -> bool
        
        Returns the plain text searching from the start or end of the range.
        """

    def FindWrapPosition(self, range, dc, context, availableSpace, wrapPosition, partialExtents):
        """
        FindWrapPosition(range, dc, context, availableSpace, wrapPosition, partialExtents) -> bool
        
        Finds a suitable wrap position.
        """

    def FindObjectAtPosition(self, position):
        """
        FindObjectAtPosition(position) -> RichTextObject
        
        Finds the object at the given position.
        """

    def GetBulletText(self):
        """
        GetBulletText() -> String
        
        Returns the bullet text for this paragraph.
        """

    def AllocateLine(self, pos):
        """
        AllocateLine(pos) -> RichTextLine
        
        Allocates or reuses a line object.
        """

    def ClearUnusedLines(self, lineCount):
        """
        ClearUnusedLines(lineCount) -> bool
        
        Clears remaining unused line objects, if any.
        """

    def GetCombinedAttributes(self, *args, **kw):
        """
        GetCombinedAttributes(contentStyle, includingBoxAttr=False) -> RichTextAttr
        GetCombinedAttributes(includingBoxAttr=False) -> RichTextAttr
        
        Returns combined attributes of the base style, paragraph style and
        character style.
        """

    def GetFirstLineBreakPosition(self, pos):
        """
        GetFirstLineBreakPosition(pos) -> long
        
        Returns the first position from pos that has a line break character.
        """

    def LayoutFloat(self, dc, context, rect, parentRect, style, floatCollector):
        """
        LayoutFloat(dc, context, rect, parentRect, style, floatCollector)
        
        Lays out the floating objects.
        """

    @staticmethod
    def InitDefaultTabs():
        """
        InitDefaultTabs()
        
        Creates a default tabstop array.
        """

    @staticmethod
    def ClearDefaultTabs():
        """
        ClearDefaultTabs()
        
        Clears the default tabstop array.
        """

    @staticmethod
    def GetDefaultTabs():
        """
        GetDefaultTabs() -> ArrayInt
        
        Returns the default tabstop array.
        """
    BulletText = property(None, None)
    CombinedAttributes = property(None, None)
    Lines = property(None, None)
    XMLNodeName = property(None, None)
# end of class RichTextParagraph


class RichTextPlainText(RichTextObject):
    """
    RichTextPlainText(text=wx.EmptyString, parent=None, style=None)
    RichTextPlainText(obj)
    
    This object represents a single piece of text.
    """

    def __init__(self, *args, **kw):
        """
        RichTextPlainText(text=wx.EmptyString, parent=None, style=None)
        RichTextPlainText(obj)
        
        This object represents a single piece of text.
        """

    def Draw(self, dc, context, range, selection, rect, descent, style):
        """
        Draw(dc, context, range, selection, rect, descent, style) -> bool
        
        Draw the item, within the given range.
        """

    def Layout(self, dc, context, rect, parentRect, style):
        """
        Layout(dc, context, rect, parentRect, style) -> bool
        
        Lay the item out at the specified position with the given size
        constraint.
        """

    def GetRangeSize(self, range, size, descent, dc, context, flags, position=wx.Point(0,0), parentSize=wx.DefaultSize, partialExtents=None):
        """
        GetRangeSize(range, size, descent, dc, context, flags, position=wx.Point(0,0), parentSize=wx.DefaultSize, partialExtents=None) -> bool
        
        Returns the object size for the given range.
        """

    def GetTextForRange(self, range):
        """
        GetTextForRange(range) -> String
        
        Returns any text in this object for the given range.
        """

    def DoSplit(self, pos):
        """
        DoSplit(pos) -> RichTextObject
        
        Do a split from pos, returning an object containing the second part,
        and setting the first part in 'this'.
        """

    def CalculateRange(self, start):
        """
        CalculateRange(start) -> end
        
        Calculates the range of the object.
        """

    def DeleteRange(self, range):
        """
        DeleteRange(range) -> bool
        
        Deletes the given range.
        """

    def IsEmpty(self):
        """
        IsEmpty() -> bool
        
        Returns true if the object is empty.
        """

    def CanMerge(self, object, context):
        """
        CanMerge(object, context) -> bool
        
        Returns true if this object can merge itself with the given one.
        """

    def Merge(self, object, context):
        """
        Merge(object, context) -> bool
        
        Returns true if this object merged itself with the given one.
        """

    def CanSplit(self, context):
        """
        CanSplit(context) -> bool
        
        Returns true if this object can potentially be split, by virtue of
        having different virtual attributes for individual sub-objects.
        """

    def Split(self, context):
        """
        Split(context) -> RichTextObject
        
        Returns the final object in the split objects if this object was split
        due to differences between sub-object virtual attributes.
        """

    def GetFirstLineBreakPosition(self, pos):
        """
        GetFirstLineBreakPosition(pos) -> long
        
        Get the first position from pos that has a line break character.
        """

    def UsesParagraphAttributes(self):
        """
        UsesParagraphAttributes() -> bool
        
        Does this object take note of paragraph attributes? Text and image
        objects don't.
        """

    def ImportFromXML(self, buffer, node, handler, recurse):
        """
        ImportFromXML(buffer, node, handler, recurse) -> bool
        
        Imports this object from XML.
        """

    def GetXMLNodeName(self):
        """
        GetXMLNodeName() -> String
        
        Returns the XML node name of this object.
        """

    def GetText(self):
        """
        GetText() -> String
        
        Returns the text.
        """

    def SetText(self, text):
        """
        SetText(text)
        
        Sets the text.
        """

    def Copy(self, obj):
        """
        Copy(obj)
        """

    def Clone(self):
        """
        Clone() -> RichTextObject
        
        Clones the object.
        """
    Text = property(None, None)
    XMLNodeName = property(None, None)
# end of class RichTextPlainText


class RichTextImageBlock(wx.Object):
    """
    RichTextImageBlock()
    RichTextImageBlock(block)
    
    This class stores information about an image, in binary in-memory
    form.
    """

    def __init__(self, *args, **kw):
        """
        RichTextImageBlock()
        RichTextImageBlock(block)
        
        This class stores information about an image, in binary in-memory
        form.
        """

    def Init(self):
        """
        Init()
        
        Initialises the block.
        """

    def Clear(self):
        """
        Clear()
        
        Clears the block.
        """

    def MakeImageBlock(self, *args, **kw):
        """
        MakeImageBlock(filename, imageType, image, convertToJPEG=True) -> bool
        MakeImageBlock(image, imageType, quality=80) -> bool
        
        Load the original image into a memory block.
        """

    def MakeImageBlockDefaultQuality(self, image, imageType):
        """
        MakeImageBlockDefaultQuality(image, imageType) -> bool
        
        Uses a const wxImage for efficiency, but can't set quality (only
        relevant for JPEG)
        """

    def DoMakeImageBlock(self, image, imageType):
        """
        DoMakeImageBlock(image, imageType) -> bool
        
        Makes the image block.
        """

    def Write(self, filename):
        """
        Write(filename) -> bool
        
        Writes the block to a file.
        """

    def WriteHex(self, stream):
        """
        WriteHex(stream) -> bool
        
        Writes the data in hex to a stream.
        """

    def ReadHex(self, stream, length, imageType):
        """
        ReadHex(stream, length, imageType) -> bool
        
        Reads the data in hex from a stream.
        """

    def Copy(self, block):
        """
        Copy(block)
        
        Copy from block.
        """

    def Load(self, image):
        """
        Load(image) -> bool
        """

    def GetData(self):
        """
        GetData() -> unsignedchar
        
        Returns the raw data.
        """

    def GetDataSize(self):
        """
        GetDataSize() -> size_t
        
        Returns the data size in bytes.
        """

    def GetImageType(self):
        """
        GetImageType() -> BitmapType
        
        Returns the image type.
        """

    def SetData(self, image):
        """
        SetData(image)
        """

    def SetDataSize(self, size):
        """
        SetDataSize(size)
        
        Sets the data size.
        """

    def SetImageType(self, imageType):
        """
        SetImageType(imageType)
        
        Sets the image type.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if the data is non-NULL.
        """

    def Ok(self):
        """
        Ok() -> bool
        """

    def GetExtension(self):
        """
        GetExtension() -> String
        
        Gets the extension for the block's type.
        """

    @staticmethod
    def ReadBlock(*args, **kw):
        """
        ReadBlock(stream, size) -> unsignedchar
        ReadBlock(filename, size) -> unsignedchar
        
        Implementation.
        """

    @staticmethod
    def WriteBlock(*args, **kw):
        """
        WriteBlock(stream, block, size) -> bool
        WriteBlock(filename, block, size) -> bool
        
        Writes a memory block to stream.
        """
    Data = property(None, None)
    DataSize = property(None, None)
    Extension = property(None, None)
    ImageType = property(None, None)
# end of class RichTextImageBlock


class RichTextImage(RichTextObject):
    """
    RichTextImage(parent=None)
    RichTextImage(image, parent=None, charStyle=None)
    RichTextImage(imageBlock, parent=None, charStyle=None)
    RichTextImage(obj)
    
    This class implements a graphic object.
    """

    def __init__(self, *args, **kw):
        """
        RichTextImage(parent=None)
        RichTextImage(image, parent=None, charStyle=None)
        RichTextImage(imageBlock, parent=None, charStyle=None)
        RichTextImage(obj)
        
        This class implements a graphic object.
        """

    def Draw(self, dc, context, range, selection, rect, descent, style):
        """
        Draw(dc, context, range, selection, rect, descent, style) -> bool
        
        Draw the item, within the given range.
        """

    def Layout(self, dc, context, rect, parentRect, style):
        """
        Layout(dc, context, rect, parentRect, style) -> bool
        
        Lay the item out at the specified position with the given size
        constraint.
        """

    def GetRangeSize(self, range, size, descent, dc, context, flags, position=wx.Point(0,0), parentSize=wx.DefaultSize, partialExtents=None):
        """
        GetRangeSize(range, size, descent, dc, context, flags, position=wx.Point(0,0), parentSize=wx.DefaultSize, partialExtents=None) -> bool
        
        Returns the object size for the given range.
        """

    def GetNaturalSize(self):
        """
        GetNaturalSize() -> TextAttrSize
        
        Returns the 'natural' size for this object - the image size.
        """

    def IsEmpty(self):
        """
        IsEmpty() -> bool
        
        Returns true if the object is empty.
        """

    def CanEditProperties(self):
        """
        CanEditProperties() -> bool
        
        Returns true if we can edit the object's properties via a GUI.
        """

    def EditProperties(self, parent, buffer):
        """
        EditProperties(parent, buffer) -> bool
        
        Edits the object's properties via a GUI.
        """

    def GetPropertiesMenuLabel(self):
        """
        GetPropertiesMenuLabel() -> String
        
        Returns the label to be used for the properties context menu item.
        """

    def UsesParagraphAttributes(self):
        """
        UsesParagraphAttributes() -> bool
        
        Returns true if this object takes note of paragraph attributes (text
        and image objects don't).
        """

    def ImportFromXML(self, buffer, node, handler, recurse):
        """
        ImportFromXML(buffer, node, handler, recurse) -> bool
        
        Imports this object from XML.
        """

    def IsFloatable(self):
        """
        IsFloatable() -> bool
        
        Returns true if this class of object is floatable.
        """

    def GetXMLNodeName(self):
        """
        GetXMLNodeName() -> String
        
        Returns the XML node name of this object.
        """

    def GetImageCache(self):
        """
        GetImageCache() -> wx.Bitmap
        
        Returns the image cache (a scaled bitmap).
        """

    def SetImageCache(self, bitmap):
        """
        SetImageCache(bitmap)
        
        Sets the image cache.
        """

    def ResetImageCache(self):
        """
        ResetImageCache()
        
        Resets the image cache.
        """

    def GetImageBlock(self):
        """
        GetImageBlock() -> RichTextImageBlock
        
        Returns the image block containing the raw data.
        """

    def GetOriginalImageSize(self):
        """
        GetOriginalImageSize() -> wx.Size
        
        Gets the original image size.
        """

    def SetOriginalImageSize(self, sz):
        """
        SetOriginalImageSize(sz)
        
        Sets the original image size.
        """

    def Copy(self, obj):
        """
        Copy(obj)
        
        Copies the image object.
        """

    def Clone(self):
        """
        Clone() -> RichTextObject
        
        Clones the image object.
        """

    def LoadImageCache(self, dc, resetCache=False, parentSize=wx.DefaultSize):
        """
        LoadImageCache(dc, resetCache=False, parentSize=wx.DefaultSize) -> bool
        
        Creates a cached image at the required size.
        """
    ImageBlock = property(None, None)
    ImageCache = property(None, None)
    NaturalSize = property(None, None)
    OriginalImageSize = property(None, None)
    PropertiesMenuLabel = property(None, None)
    XMLNodeName = property(None, None)
# end of class RichTextImage


class RichTextBuffer(RichTextParagraphLayoutBox):
    """
    RichTextBuffer()
    RichTextBuffer(obj)
    
    This is a kind of paragraph layout box, used to represent the whole
    buffer.
    """

    def __init__(self, *args, **kw):
        """
        RichTextBuffer()
        RichTextBuffer(obj)
        
        This is a kind of paragraph layout box, used to represent the whole
        buffer.
        """

    def LoadFile(self, *args, **kw):
        """
        LoadFile(filename, type=RICHTEXT_TYPE_ANY) -> bool
        LoadFile(stream, type=RICHTEXT_TYPE_ANY) -> bool
        
        Loads content from a stream or file.
        """

    def SaveFile(self, *args, **kw):
        """
        SaveFile(filename, type=RICHTEXT_TYPE_ANY) -> bool
        SaveFile(stream, type=RICHTEXT_TYPE_ANY) -> bool
        
        Saves content to a stream or file.
        """

    def GetCommandProcessor(self):
        """
        GetCommandProcessor() -> wx.CommandProcessor
        
        Returns the command processor.
        """

    def SetStyleSheet(self, styleSheet):
        """
        SetStyleSheet(styleSheet)
        
        Sets style sheet, if any.
        """

    def GetStyleSheet(self):
        """
        GetStyleSheet() -> RichTextStyleSheet
        
        Returns the style sheet.
        """

    def SetStyleSheetAndNotify(self, sheet):
        """
        SetStyleSheetAndNotify(sheet) -> bool
        
        Sets the style sheet and sends a notification of the change.
        """

    def PushStyleSheet(self, styleSheet):
        """
        PushStyleSheet(styleSheet) -> bool
        
        Pushes the style sheet to the top of the style sheet stack.
        """

    def PopStyleSheet(self):
        """
        PopStyleSheet() -> RichTextStyleSheet
        
        Pops the style sheet from the top of the style sheet stack.
        """

    def GetFontTable(self):
        """
        GetFontTable() -> RichTextFontTable
        
        Returns the table storing fonts, for quick access and font reuse.
        """

    def SetFontTable(self, table):
        """
        SetFontTable(table)
        
        Sets table storing fonts, for quick access and font reuse.
        """

    def SetFontScale(self, fontScale):
        """
        SetFontScale(fontScale)
        
        Sets the scale factor for displaying fonts, for example for more
        comfortable editing.
        """

    def GetFontScale(self):
        """
        GetFontScale() -> double
        
        Returns the scale factor for displaying fonts, for example for more
        comfortable editing.
        """

    def SetDimensionScale(self, dimScale):
        """
        SetDimensionScale(dimScale)
        
        Sets the scale factor for displaying certain dimensions such as
        indentation and inter-paragraph spacing.
        """

    def GetDimensionScale(self):
        """
        GetDimensionScale() -> double
        
        Returns the scale factor for displaying certain dimensions such as
        indentation and inter-paragraph spacing.
        """

    def Init(self):
        """
        Init()
        
        Initialisation.
        """

    def ResetAndClearCommands(self):
        """
        ResetAndClearCommands()
        
        Clears the buffer, adds an empty paragraph, and clears the command
        processor.
        """

    def SetHandlerFlags(self, flags):
        """
        SetHandlerFlags(flags)
        
        Sets the handler flags, controlling loading and saving.
        """

    def GetHandlerFlags(self):
        """
        GetHandlerFlags() -> int
        
        Gets the handler flags, controlling loading and saving.
        """

    def AddParagraph(self, text, paraStyle=None):
        """
        AddParagraph(text, paraStyle=None) -> RichTextRange
        
        Convenience function to add a paragraph of text.
        """

    def BeginBatchUndo(self, cmdName):
        """
        BeginBatchUndo(cmdName) -> bool
        
        Begin collapsing undo/redo commands.
        """

    def EndBatchUndo(self):
        """
        EndBatchUndo() -> bool
        
        End collapsing undo/redo commands.
        """

    def BatchingUndo(self):
        """
        BatchingUndo() -> bool
        
        Returns true if we are collapsing commands.
        """

    def SubmitAction(self, action):
        """
        SubmitAction(action) -> bool
        
        Submit the action immediately, or delay according to whether
        collapsing is on.
        """

    def GetBatchedCommand(self):
        """
        GetBatchedCommand() -> RichTextCommand
        
        Returns the collapsed command.
        """

    def BeginSuppressUndo(self):
        """
        BeginSuppressUndo() -> bool
        
        Begin suppressing undo/redo commands.
        """

    def EndSuppressUndo(self):
        """
        EndSuppressUndo() -> bool
        
        End suppressing undo/redo commands.
        """

    def SuppressingUndo(self):
        """
        SuppressingUndo() -> bool
        
        Are we suppressing undo??
        """

    def CopyToClipboard(self, range):
        """
        CopyToClipboard(range) -> bool
        
        Copy the range to the clipboard.
        """

    def PasteFromClipboard(self, position):
        """
        PasteFromClipboard(position) -> bool
        
        Paste the clipboard content to the buffer.
        """

    def CanPasteFromClipboard(self):
        """
        CanPasteFromClipboard() -> bool
        
        Returns true if we can paste from the clipboard.
        """

    def BeginStyle(self, style):
        """
        BeginStyle(style) -> bool
        
        Begin using a style.
        """

    def EndStyle(self):
        """
        EndStyle() -> bool
        
        End the style.
        """

    def EndAllStyles(self):
        """
        EndAllStyles() -> bool
        
        End all styles.
        """

    def ClearStyleStack(self):
        """
        ClearStyleStack()
        
        Clears the style stack.
        """

    def GetStyleStackSize(self):
        """
        GetStyleStackSize() -> size_t
        
        Returns the size of the style stack, for example to check correct
        nesting.
        """

    def BeginBold(self):
        """
        BeginBold() -> bool
        
        Begins using bold.
        """

    def EndBold(self):
        """
        EndBold() -> bool
        
        Ends using bold.
        """

    def BeginItalic(self):
        """
        BeginItalic() -> bool
        
        Begins using italic.
        """

    def EndItalic(self):
        """
        EndItalic() -> bool
        
        Ends using italic.
        """

    def BeginUnderline(self):
        """
        BeginUnderline() -> bool
        
        Begins using underline.
        """

    def EndUnderline(self):
        """
        EndUnderline() -> bool
        
        Ends using underline.
        """

    def BeginFontSize(self, pointSize):
        """
        BeginFontSize(pointSize) -> bool
        
        Begins using point size.
        """

    def EndFontSize(self):
        """
        EndFontSize() -> bool
        
        Ends using point size.
        """

    def BeginFont(self, font):
        """
        BeginFont(font) -> bool
        
        Begins using this font.
        """

    def EndFont(self):
        """
        EndFont() -> bool
        
        Ends using a font.
        """

    def BeginTextColour(self, colour):
        """
        BeginTextColour(colour) -> bool
        
        Begins using this colour.
        """

    def EndTextColour(self):
        """
        EndTextColour() -> bool
        
        Ends using a colour.
        """

    def BeginAlignment(self, alignment):
        """
        BeginAlignment(alignment) -> bool
        
        Begins using alignment.
        """

    def EndAlignment(self):
        """
        EndAlignment() -> bool
        
        Ends alignment.
        """

    def BeginLeftIndent(self, leftIndent, leftSubIndent=0):
        """
        BeginLeftIndent(leftIndent, leftSubIndent=0) -> bool
        
        Begins using leftIndent for the left indent, and optionally
        leftSubIndent for the sub-indent.
        """

    def EndLeftIndent(self):
        """
        EndLeftIndent() -> bool
        
        Ends left indent.
        """

    def BeginRightIndent(self, rightIndent):
        """
        BeginRightIndent(rightIndent) -> bool
        
        Begins a right indent, specified in tenths of a millimetre.
        """

    def EndRightIndent(self):
        """
        EndRightIndent() -> bool
        
        Ends right indent.
        """

    def BeginParagraphSpacing(self, before, after):
        """
        BeginParagraphSpacing(before, after) -> bool
        
        Begins paragraph spacing; pass the before-paragraph and after-
        paragraph spacing in tenths of a millimetre.
        """

    def EndParagraphSpacing(self):
        """
        EndParagraphSpacing() -> bool
        
        Ends paragraph spacing.
        """

    def BeginLineSpacing(self, lineSpacing):
        """
        BeginLineSpacing(lineSpacing) -> bool
        
        Begins line spacing using the specified value.
        """

    def EndLineSpacing(self):
        """
        EndLineSpacing() -> bool
        
        Ends line spacing.
        """

    def BeginNumberedBullet(self, bulletNumber, leftIndent, leftSubIndent, bulletStyle=wx.TEXT_ATTR_BULLET_STYLE_ARABIC|wx.TEXT_ATTR_BULLET_STYLE_PERIOD):
        """
        BeginNumberedBullet(bulletNumber, leftIndent, leftSubIndent, bulletStyle=wx.TEXT_ATTR_BULLET_STYLE_ARABIC|wx.TEXT_ATTR_BULLET_STYLE_PERIOD) -> bool
        
        Begins numbered bullet.
        """

    def EndNumberedBullet(self):
        """
        EndNumberedBullet() -> bool
        
        Ends numbered bullet.
        """

    def BeginSymbolBullet(self, symbol, leftIndent, leftSubIndent, bulletStyle=wx.TEXT_ATTR_BULLET_STYLE_SYMBOL):
        """
        BeginSymbolBullet(symbol, leftIndent, leftSubIndent, bulletStyle=wx.TEXT_ATTR_BULLET_STYLE_SYMBOL) -> bool
        
        Begins applying a symbol bullet, using a character from the current
        font.
        """

    def EndSymbolBullet(self):
        """
        EndSymbolBullet() -> bool
        
        Ends symbol bullet.
        """

    def BeginStandardBullet(self, bulletName, leftIndent, leftSubIndent, bulletStyle=wx.TEXT_ATTR_BULLET_STYLE_STANDARD):
        """
        BeginStandardBullet(bulletName, leftIndent, leftSubIndent, bulletStyle=wx.TEXT_ATTR_BULLET_STYLE_STANDARD) -> bool
        
        Begins applying a standard bullet, using one of the standard bullet
        names (currently standard/circle or standard/square.
        """

    def EndStandardBullet(self):
        """
        EndStandardBullet() -> bool
        
        Ends standard bullet.
        """

    def BeginCharacterStyle(self, characterStyle):
        """
        BeginCharacterStyle(characterStyle) -> bool
        
        Begins named character style.
        """

    def EndCharacterStyle(self):
        """
        EndCharacterStyle() -> bool
        
        Ends named character style.
        """

    def BeginParagraphStyle(self, paragraphStyle):
        """
        BeginParagraphStyle(paragraphStyle) -> bool
        
        Begins named paragraph style.
        """

    def EndParagraphStyle(self):
        """
        EndParagraphStyle() -> bool
        
        Ends named character style.
        """

    def BeginListStyle(self, listStyle, level=1, number=1):
        """
        BeginListStyle(listStyle, level=1, number=1) -> bool
        
        Begins named list style.
        """

    def EndListStyle(self):
        """
        EndListStyle() -> bool
        
        Ends named character style.
        """

    def BeginURL(self, url, characterStyle=wx.EmptyString):
        """
        BeginURL(url, characterStyle=wx.EmptyString) -> bool
        
        Begins applying wxTEXT_ATTR_URL to the content.
        """

    def EndURL(self):
        """
        EndURL() -> bool
        
        Ends URL.
        """

    def AddEventHandler(self, handler):
        """
        AddEventHandler(handler) -> bool
        
        Adds an event handler.
        """

    def RemoveEventHandler(self, handler, deleteHandler=False):
        """
        RemoveEventHandler(handler, deleteHandler=False) -> bool
        
        Removes an event handler from the buffer's list of handlers, deleting
        the object if deleteHandler is true.
        """

    def ClearEventHandlers(self):
        """
        ClearEventHandlers()
        
        Clear event handlers.
        """

    def SendEvent(self, event, sendToAll=True):
        """
        SendEvent(event, sendToAll=True) -> bool
        
        Send event to event handlers.
        """

    def HitTest(self, dc, context, pt, flags=0):
        """
        HitTest(dc, context, pt, flags=0) -> (int, textPosition, obj, contextObj)
        
        Hit-testing: returns a flag indicating hit test details, plus
        information about position.
        """

    def Copy(self, obj):
        """
        Copy(obj)
        
        Copies the buffer.
        """

    def Clone(self):
        """
        Clone() -> RichTextObject
        
        Clones the buffer.
        """

    def InsertParagraphsWithUndo(self, pos, paragraphs, ctrl, flags=0):
        """
        InsertParagraphsWithUndo(pos, paragraphs, ctrl, flags=0) -> bool
        
        Submits a command to insert paragraphs.
        """

    def InsertTextWithUndo(self, pos, text, ctrl, flags=0):
        """
        InsertTextWithUndo(pos, text, ctrl, flags=0) -> bool
        
        Submits a command to insert the given text.
        """

    def InsertNewlineWithUndo(self, pos, ctrl, flags=0):
        """
        InsertNewlineWithUndo(pos, ctrl, flags=0) -> bool
        
        Submits a command to insert a newline.
        """

    def InsertImageWithUndo(self, pos, imageBlock, ctrl, flags=0, textAttr=RichTextAttr()):
        """
        InsertImageWithUndo(pos, imageBlock, ctrl, flags=0, textAttr=RichTextAttr()) -> bool
        
        Submits a command to insert the given image.
        """

    def InsertObjectWithUndo(self, pos, object, ctrl, flags):
        """
        InsertObjectWithUndo(pos, object, ctrl, flags) -> RichTextObject
        
        Submits a command to insert an object.
        """

    def DeleteRangeWithUndo(self, range, ctrl):
        """
        DeleteRangeWithUndo(range, ctrl) -> bool
        
        Submits a command to delete this range.
        """

    def Modify(self, modify=True):
        """
        Modify(modify=True)
        
        Mark modified.
        """

    def IsModified(self):
        """
        IsModified() -> bool
        
        Returns true if the buffer was modified.
        """

    def GetScale(self):
        """
        GetScale() -> double
        
        Returns the scale factor for calculating dimensions.
        """

    def SetScale(self, scale):
        """
        SetScale(scale)
        
        Sets the scale factor for calculating dimensions.
        """

    @staticmethod
    def GetHandlers():
        """
        GetHandlers() -> RichTextFileHandlerList
        
        Returns the file handlers.
        """

    @staticmethod
    def AddHandler(handler):
        """
        AddHandler(handler)
        
        Adds a file handler to the end.
        """

    @staticmethod
    def InsertHandler(handler):
        """
        InsertHandler(handler)
        
        Inserts a file handler at the front.
        """

    @staticmethod
    def RemoveHandler(name):
        """
        RemoveHandler(name) -> bool
        
        Removes a file handler.
        """

    @staticmethod
    def FindHandlerByType(imageType):
        """
        FindHandlerByType(imageType) -> RichTextFileHandler
        
        Finds a handler by type.
        """

    @staticmethod
    def FindHandlerByExtension(extension, imageType):
        """
        FindHandlerByExtension(extension, imageType) -> RichTextFileHandler
        
        Finds a file handler by extension and type.
        """

    @staticmethod
    def FindHandlerByName(name):
        """
        FindHandlerByName(name) -> RichTextFileHandler
        
        Finds a file handler by name.
        """

    @staticmethod
    def FindHandlerByFilename(filename, imageType):
        """
        FindHandlerByFilename(filename, imageType) -> RichTextFileHandler
        
        Finds a handler by filename or, if supplied, type.
        """

    @staticmethod
    def GetExtWildcard(combine=False, save=False, types=None):
        """
        GetExtWildcard(combine=False, save=False, types=None) -> String
        
        Gets a wildcard incorporating all visible handlers.
        """

    @staticmethod
    def CleanUpHandlers():
        """
        CleanUpHandlers()
        
        Clean up file handlers.
        """

    @staticmethod
    def InitStandardHandlers():
        """
        InitStandardHandlers()
        
        Initialise the standard file handlers.
        """

    @staticmethod
    def GetDrawingHandlers():
        """
        GetDrawingHandlers() -> RichTextDrawingHandlerList
        
        Returns the drawing handlers.
        """

    @staticmethod
    def AddDrawingHandler(handler):
        """
        AddDrawingHandler(handler)
        
        Adds a drawing handler to the end.
        """

    @staticmethod
    def InsertDrawingHandler(handler):
        """
        InsertDrawingHandler(handler)
        
        Inserts a drawing handler at the front.
        """

    @staticmethod
    def RemoveDrawingHandler(name):
        """
        RemoveDrawingHandler(name) -> bool
        
        Removes a drawing handler.
        """

    @staticmethod
    def FindDrawingHandler(name):
        """
        FindDrawingHandler(name) -> RichTextDrawingHandler
        
        Finds a drawing handler by name.
        """

    @staticmethod
    def CleanUpDrawingHandlers():
        """
        CleanUpDrawingHandlers()
        
        Clean up drawing handlers.
        """

    @staticmethod
    def AddFieldType(fieldType):
        """
        AddFieldType(fieldType)
        
        Adds a field type.
        """

    @staticmethod
    def RemoveFieldType(name):
        """
        RemoveFieldType(name) -> bool
        
        Removes a field type by name.
        """

    @staticmethod
    def FindFieldType(name):
        """
        FindFieldType(name) -> RichTextFieldType
        
        Finds a field type by name.
        """

    @staticmethod
    def CleanUpFieldTypes():
        """
        CleanUpFieldTypes()
        
        Cleans up field types.
        """

    @staticmethod
    def GetRenderer():
        """
        GetRenderer() -> RichTextRenderer
        
        Returns the renderer object.
        """

    @staticmethod
    def SetRenderer(renderer):
        """
        SetRenderer(renderer)
        
        Sets renderer as the object to be used to render certain aspects of
        the content, such as bullets.
        """

    @staticmethod
    def GetBulletRightMargin():
        """
        GetBulletRightMargin() -> int
        
        Returns the minimum margin between bullet and paragraph in 10ths of a
        mm.
        """

    @staticmethod
    def SetBulletRightMargin(margin):
        """
        SetBulletRightMargin(margin)
        
        Sets the minimum margin between bullet and paragraph in 10ths of a mm.
        """

    @staticmethod
    def GetBulletProportion():
        """
        GetBulletProportion() -> float
        
        Returns the factor to multiply by character height to get a reasonable
        bullet size.
        """

    @staticmethod
    def SetBulletProportion(prop):
        """
        SetBulletProportion(prop)
        
        Sets the factor to multiply by character height to get a reasonable
        bullet size.
        """

    @staticmethod
    def GetFloatingLayoutMode():
        """
        GetFloatingLayoutMode() -> bool
        
        Returns the floating layout mode.
        """

    @staticmethod
    def SetFloatingLayoutMode(mode):
        """
        SetFloatingLayoutMode(mode)
        
        Sets the floating layout mode.
        """
    BatchedCommand = property(None, None)
    CommandProcessor = property(None, None)
    DimensionScale = property(None, None)
    FontScale = property(None, None)
    FontTable = property(None, None)
    HandlerFlags = property(None, None)
    Scale = property(None, None)
    StyleSheet = property(None, None)
    StyleStackSize = property(None, None)
# end of class RichTextBuffer


class RichTextCell(RichTextBox):
    """
    RichTextCell(parent=None)
    RichTextCell(obj)
    
    wxRichTextCell is the cell in a table, in which the user can type.
    """

    def __init__(self, *args, **kw):
        """
        RichTextCell(parent=None)
        RichTextCell(obj)
        
        wxRichTextCell is the cell in a table, in which the user can type.
        """

    def Draw(self, dc, context, range, selection, rect, descent, style):
        """
        Draw(dc, context, range, selection, rect, descent, style) -> bool
        
        Draw the item, within the given range.
        """

    def HitTest(self, dc, context, pt, flags=0):
        """
        HitTest(dc, context, pt, flags=0) -> (int, textPosition, obj, contextObj)
        
        Hit-testing: returns a flag indicating hit test details, plus
        information about position.
        """

    def GetXMLNodeName(self):
        """
        GetXMLNodeName() -> String
        
        Returns the XML node name of this object.
        """

    def CanEditProperties(self):
        """
        CanEditProperties() -> bool
        
        Returns true if we can edit the object's properties via a GUI.
        """

    def EditProperties(self, parent, buffer):
        """
        EditProperties(parent, buffer) -> bool
        
        Edits the object's properties via a GUI.
        """

    def GetPropertiesMenuLabel(self):
        """
        GetPropertiesMenuLabel() -> String
        
        Returns the label to be used for the properties context menu item.
        """

    def GetColSpan(self):
        """
        GetColSpan() -> int
        
        Returns the number of columns spanned by the cell.
        """

    def SetColSpan(self, span):
        """
        SetColSpan(span)
        
        Set the number of columns spanned by the cell.
        """

    def GetRowSpan(self):
        """
        GetRowSpan() -> int
        
        Returns the number of rows spanned by the cell.
        """

    def SetRowSpan(self, span):
        """
        SetRowSpan(span)
        
        Set the number of rows spanned by the cell.
        """

    def Clone(self):
        """
        Clone() -> RichTextObject
        
        Clones the object.
        """

    def Copy(self, obj):
        """
        Copy(obj)
        """
    ColSpan = property(None, None)
    PropertiesMenuLabel = property(None, None)
    RowSpan = property(None, None)
    XMLNodeName = property(None, None)
# end of class RichTextCell


class RichTextTable(RichTextBox):
    """
    RichTextTable(parent=None)
    RichTextTable(obj)
    
    wxRichTextTable represents a table with arbitrary columns and rows.
    """

    def __init__(self, *args, **kw):
        """
        RichTextTable(parent=None)
        RichTextTable(obj)
        
        wxRichTextTable represents a table with arbitrary columns and rows.
        """

    def Draw(self, dc, context, range, selection, rect, descent, style):
        """
        Draw(dc, context, range, selection, rect, descent, style) -> bool
        
        Draw the item, within the given range.
        """

    def HitTest(self, dc, context, pt, flags=0):
        """
        HitTest(dc, context, pt, flags=0) -> (int, textPosition, obj, contextObj)
        
        Hit-testing: returns a flag indicating hit test details, plus
        information about position.
        """

    def GetXMLNodeName(self):
        """
        GetXMLNodeName() -> String
        
        Returns the XML node name of this object.
        """

    def Layout(self, dc, context, rect, parentRect, style):
        """
        Layout(dc, context, rect, parentRect, style) -> bool
        
        Lay the item out at the specified position with the given size
        constraint.
        """

    def GetRangeSize(self, range, size, descent, dc, context, flags, position=wx.Point(0,0), parentSize=wx.DefaultSize, partialExtents=None):
        """
        GetRangeSize(range, size, descent, dc, context, flags, position=wx.Point(0,0), parentSize=wx.DefaultSize, partialExtents=None) -> bool
        
        Returns the object size for the given range.
        """

    def DeleteRange(self, range):
        """
        DeleteRange(range) -> bool
        
        Deletes the given range.
        """

    def GetTextForRange(self, range):
        """
        GetTextForRange(range) -> String
        
        Returns any text in this object for the given range.
        """

    def ImportFromXML(self, buffer, node, handler, recurse):
        """
        ImportFromXML(buffer, node, handler, recurse) -> bool
        
        Imports this object from XML.
        """

    def FindPosition(self, dc, context, index, forceLineStart):
        """
        FindPosition(dc, context, index, forceLineStart) -> (bool, pt, height)
        
        Finds the absolute position and row height for the given character
        position.
        """

    def CalculateRange(self, start):
        """
        CalculateRange(start) -> end
        
        Calculates the range of the object.
        """

    def HandlesChildSelections(self):
        """
        HandlesChildSelections() -> bool
        
        Returns true if this object can handle the selections of its children,
        fOr example a table.
        """

    def GetSelection(self, start, end):
        """
        GetSelection(start, end) -> RichTextSelection
        
        Returns a selection object specifying the selections between start and
        end character positions.
        """

    def CanEditProperties(self):
        """
        CanEditProperties() -> bool
        
        Returns true if we can edit the object's properties via a GUI.
        """

    def EditProperties(self, parent, buffer):
        """
        EditProperties(parent, buffer) -> bool
        
        Edits the object's properties via a GUI.
        """

    def GetPropertiesMenuLabel(self):
        """
        GetPropertiesMenuLabel() -> String
        
        Returns the label to be used for the properties context menu item.
        """

    def AcceptsFocus(self):
        """
        AcceptsFocus() -> bool
        
        Returns true if objects of this class can accept the focus, i.e. a
        call to SetFocusObject is possible.
        """

    def GetCells(self):
        """
        GetCells() -> RichTextObjectPtrArrayArray
        
        Returns the cells array.
        """

    def GetRowCount(self):
        """
        GetRowCount() -> int
        
        Returns the row count.
        """

    def GetColumnCount(self):
        """
        GetColumnCount() -> int
        
        Returns the column count.
        """

    def GetCell(self, *args, **kw):
        """
        GetCell(row, col) -> RichTextCell
        GetCell(pos) -> RichTextCell
        
        Returns the cell at the given row/column position.
        """

    def GetCellRowColumnPosition(self, pos, row, col):
        """
        GetCellRowColumnPosition(pos, row, col) -> bool
        
        Returns the row/column for a given character position.
        """

    def GetFocusedCell(self):
        """
        GetFocusedCell() -> wx.Position
        
        Returns the coordinates of the cell with keyboard focus, or (-1,-1) if
        none.
        """

    def ClearTable(self):
        """
        ClearTable()
        
        Clears the table.
        """

    def CreateTable(self, rows, cols):
        """
        CreateTable(rows, cols) -> bool
        
        Creates a table of the given dimensions.
        """

    def SetCellStyle(self, selection, style, flags=RICHTEXT_SETSTYLE_WITH_UNDO):
        """
        SetCellStyle(selection, style, flags=RICHTEXT_SETSTYLE_WITH_UNDO) -> bool
        
        Sets the attributes for the cells specified by the selection.
        """

    def DeleteRows(self, startRow, noRows=1):
        """
        DeleteRows(startRow, noRows=1) -> bool
        
        Deletes rows from the given row position.
        """

    def DeleteColumns(self, startCol, noCols=1):
        """
        DeleteColumns(startCol, noCols=1) -> bool
        
        Deletes columns from the given column position.
        """

    def AddRows(self, startRow, noRows=1, attr=RichTextAttr()):
        """
        AddRows(startRow, noRows=1, attr=RichTextAttr()) -> bool
        
        Adds rows from the given row position.
        """

    def AddColumns(self, startCol, noCols=1, attr=RichTextAttr()):
        """
        AddColumns(startCol, noCols=1, attr=RichTextAttr()) -> bool
        
        Adds columns from the given column position.
        """

    def Clone(self):
        """
        Clone() -> RichTextObject
        
        Clones the object.
        """

    def Copy(self, obj):
        """
        Copy(obj)
        """
    Cells = property(None, None)
    ColumnCount = property(None, None)
    FocusedCell = property(None, None)
    PropertiesMenuLabel = property(None, None)
    RowCount = property(None, None)
    XMLNodeName = property(None, None)
# end of class RichTextTable


class RichTextObjectAddress(object):
    """
    RichTextObjectAddress(topLevelContainer, obj)
    RichTextObjectAddress()
    RichTextObjectAddress(address)
    
    A class for specifying an object anywhere in an object hierarchy,
    without using a pointer, necessary since wxRTC commands may delete and
    recreate sub-objects so physical object addresses change.
    """

    def __init__(self, *args, **kw):
        """
        RichTextObjectAddress(topLevelContainer, obj)
        RichTextObjectAddress()
        RichTextObjectAddress(address)
        
        A class for specifying an object anywhere in an object hierarchy,
        without using a pointer, necessary since wxRTC commands may delete and
        recreate sub-objects so physical object addresses change.
        """

    def Init(self):
        """
        Init()
        """

    def Copy(self, address):
        """
        Copy(address)
        
        Copies the address.
        """

    def GetObject(self, topLevelContainer):
        """
        GetObject(topLevelContainer) -> RichTextObject
        
        Returns the object specified by the address, given a top level
        container.
        """

    def Create(self, topLevelContainer, obj):
        """
        Create(topLevelContainer, obj) -> bool
        
        Creates the address given a container and an object.
        """

    def GetAddress(self):
        """
        GetAddress() -> ArrayInt
        
        Returns the array of integers representing the object address.
        """

    def SetAddress(self, address):
        """
        SetAddress(address)
        
        Sets the address from an array of integers.
        """
    Address = property(None, None)
# end of class RichTextObjectAddress


class RichTextCommand(wx.Command):
    """
    RichTextCommand(name, id, buffer, container, ctrl, ignoreFirstTime=False)
    RichTextCommand(name)
    
    Implements a command on the undo/redo stack.
    """

    def __init__(self, *args, **kw):
        """
        RichTextCommand(name, id, buffer, container, ctrl, ignoreFirstTime=False)
        RichTextCommand(name)
        
        Implements a command on the undo/redo stack.
        """

    def Do(self):
        """
        Do() -> bool
        
        Performs the command.
        """

    def Undo(self):
        """
        Undo() -> bool
        
        Undoes the command.
        """

    def AddAction(self, action):
        """
        AddAction(action)
        
        Adds an action to the action list.
        """

    def ClearActions(self):
        """
        ClearActions()
        
        Clears the action list.
        """

    def GetActions(self):
        """
        GetActions() -> RichTextActionList
        
        Returns the action list.
        """
    Actions = property(None, None)
# end of class RichTextCommand


class RichTextAction(wx.Object):
    """
    RichTextAction(cmd, name, id, buffer, container, ctrl, ignoreFirstTime=False)
    
    Implements a part of a command.
    """

    def __init__(self, cmd, name, id, buffer, container, ctrl, ignoreFirstTime=False):
        """
        RichTextAction(cmd, name, id, buffer, container, ctrl, ignoreFirstTime=False)
        
        Implements a part of a command.
        """

    def Do(self):
        """
        Do() -> bool
        
        Performs the action.
        """

    def Undo(self):
        """
        Undo() -> bool
        
        Undoes the action.
        """

    def UpdateAppearance(self, caretPosition, sendUpdateEvent=False, optimizationLineCharPositions=None, optimizationLineYPositions=None, isDoCmd=True):
        """
        UpdateAppearance(caretPosition, sendUpdateEvent=False, optimizationLineCharPositions=None, optimizationLineYPositions=None, isDoCmd=True)
        
        Updates the control appearance, optimizing if possible given
        information from the call to Layout.
        """

    def ApplyParagraphs(self, fragment):
        """
        ApplyParagraphs(fragment)
        
        Replaces the buffer paragraphs with the given fragment.
        """

    def GetNewParagraphs(self):
        """
        GetNewParagraphs() -> RichTextParagraphLayoutBox
        
        Returns the new fragments.
        """

    def GetOldParagraphs(self):
        """
        GetOldParagraphs() -> RichTextParagraphLayoutBox
        
        Returns the old fragments.
        """

    def GetAttributes(self):
        """
        GetAttributes() -> RichTextAttr
        
        Returns the attributes, for single-object commands.
        """

    def GetObject(self):
        """
        GetObject() -> RichTextObject
        
        Returns the object to replace the one at the position defined by the
        container address and the action's range start position.
        """

    def StoreObject(self, obj):
        """
        StoreObject(obj)
        
        Stores the object to replace the one at the position defined by the
        container address without making an address for it.
        """

    def SetObject(self, obj):
        """
        SetObject(obj)
        
        Sets the object to replace the one at the position defined by the
        container address and the action's range start position.
        """

    def MakeObject(self, obj):
        """
        MakeObject(obj)
        
        Makes an address from the given object.
        """

    def SetOldAndNewObjects(self, oldObj, newObj):
        """
        SetOldAndNewObjects(oldObj, newObj)
        
        Sets the existing and new objects, for use with
        wxRICHTEXT_CHANGE_OBJECT.
        """

    def CalculateRefreshOptimizations(self, optimizationLineCharPositions, optimizationLineYPositions):
        """
        CalculateRefreshOptimizations(optimizationLineCharPositions, optimizationLineYPositions)
        
        Calculate arrays for refresh optimization.
        """

    def SetPosition(self, pos):
        """
        SetPosition(pos)
        
        Sets the position used for e.g.
        """

    def GetPosition(self):
        """
        GetPosition() -> long
        
        Returns the position used for e.g.
        """

    def SetRange(self, range):
        """
        SetRange(range)
        
        Sets the range for e.g.
        """

    def GetRange(self):
        """
        GetRange() -> RichTextRange
        
        Returns the range for e.g.
        """

    def GetContainerAddress(self):
        """
        GetContainerAddress() -> RichTextObjectAddress
        
        Returns the address (nested position) of the container within the
        buffer being manipulated.
        """

    def SetContainerAddress(self, *args, **kw):
        """
        SetContainerAddress(address)
        SetContainerAddress(container, obj)
        
        Sets the address (nested position) of the container within the buffer
        being manipulated.
        """

    def GetContainer(self):
        """
        GetContainer() -> RichTextParagraphLayoutBox
        
        Returns the container that this action refers to, using the container
        address and top-level buffer.
        """

    def GetName(self):
        """
        GetName() -> String
        
        Returns the action name.
        """

    def SetIgnoreFirstTime(self, b):
        """
        SetIgnoreFirstTime(b)
        
        Instructs the first Do() command should be skipped as it's already
        been applied.
        """

    def GetIgnoreFirstTime(self):
        """
        GetIgnoreFirstTime() -> bool
        
        Returns true if the first Do() command should be skipped as it's
        already been applied.
        """
    Attributes = property(None, None)
    Container = property(None, None)
    ContainerAddress = property(None, None)
    IgnoreFirstTime = property(None, None)
    Name = property(None, None)
    NewParagraphs = property(None, None)
    Object = property(None, None)
    OldParagraphs = property(None, None)
    Position = property(None, None)
    Range = property(None, None)
# end of class RichTextAction


class RichTextFileHandler(wx.Object):
    """
    RichTextFileHandler(name=wx.EmptyString, ext=wx.EmptyString, type=0)
    
    The base class for file handlers.
    """

    def __init__(self, name=wx.EmptyString, ext=wx.EmptyString, type=0):
        """
        RichTextFileHandler(name=wx.EmptyString, ext=wx.EmptyString, type=0)
        
        The base class for file handlers.
        """

    def LoadFile(self, *args, **kw):
        """
        LoadFile(buffer, stream) -> bool
        LoadFile(buffer, filename) -> bool
        
        Loads the buffer from a stream.
        """

    def SaveFile(self, *args, **kw):
        """
        SaveFile(buffer, stream) -> bool
        SaveFile(buffer, filename) -> bool
        
        Saves the buffer to a stream.
        """

    def CanHandle(self, filename):
        """
        CanHandle(filename) -> bool
        
        Returns true if we handle this filename (if using files).
        """

    def CanSave(self):
        """
        CanSave() -> bool
        
        Returns true if we can save using this handler.
        """

    def CanLoad(self):
        """
        CanLoad() -> bool
        
        Returns true if we can load using this handler.
        """

    def IsVisible(self):
        """
        IsVisible() -> bool
        
        Returns true if this handler should be visible to the user.
        """

    def SetVisible(self, visible):
        """
        SetVisible(visible)
        
        Sets whether the handler should be visible to the user (via the
        application's load and save dialogs).
        """

    def SetName(self, name):
        """
        SetName(name)
        
        Sets the name of the handler.
        """

    def GetName(self):
        """
        GetName() -> String
        
        Returns the name of the handler.
        """

    def SetExtension(self, ext):
        """
        SetExtension(ext)
        
        Sets the default extension to recognise.
        """

    def GetExtension(self):
        """
        GetExtension() -> String
        
        Returns the default extension to recognise.
        """

    def SetType(self, type):
        """
        SetType(type)
        
        Sets the handler type.
        """

    def GetType(self):
        """
        GetType() -> int
        
        Returns the handler type.
        """

    def SetFlags(self, flags):
        """
        SetFlags(flags)
        
        Sets flags that change the behaviour of loading or saving.
        """

    def GetFlags(self):
        """
        GetFlags() -> int
        
        Returns flags controlling how loading and saving is done.
        """

    def SetEncoding(self, encoding):
        """
        SetEncoding(encoding)
        
        Sets the encoding to use when saving a file.
        """

    def GetEncoding(self):
        """
        GetEncoding() -> String
        
        Returns the encoding to use when saving a file.
        """
    Encoding = property(None, None)
    Extension = property(None, None)
    Flags = property(None, None)
    Name = property(None, None)
    Type = property(None, None)

    def DoLoadFile(self, buffer, stream):
        """
        DoLoadFile(buffer, stream) -> bool
        
        Override to load content from stream into buffer.
        """

    def DoSaveFile(self, buffer, stream):
        """
        DoSaveFile(buffer, stream) -> bool
        
        Override to save content to stream from buffer.
        """
# end of class RichTextFileHandler


class RichTextPlainTextHandler(RichTextFileHandler):
    """
    RichTextPlainTextHandler(name="Text", ext="txt", type=RICHTEXT_TYPE_TEXT)
    
    Implements saving a buffer to plain text.
    """

    def __init__(self, name="Text", ext="txt", type=RICHTEXT_TYPE_TEXT):
        """
        RichTextPlainTextHandler(name="Text", ext="txt", type=RICHTEXT_TYPE_TEXT)
        
        Implements saving a buffer to plain text.
        """

    def CanSave(self):
        """
        CanSave() -> bool
        
        Returns true if we can save using this handler.
        """

    def CanLoad(self):
        """
        CanLoad() -> bool
        
        Returns true if we can load using this handler.
        """

    def DoLoadFile(self, buffer, stream):
        """
        DoLoadFile(buffer, stream) -> bool
        
        Override to load content from stream into buffer.
        """

    def DoSaveFile(self, buffer, stream):
        """
        DoSaveFile(buffer, stream) -> bool
        
        Override to save content to stream from buffer.
        """
# end of class RichTextPlainTextHandler


class RichTextDrawingHandler(wx.Object):
    """
    RichTextDrawingHandler(name=wx.EmptyString)
    
    The base class for custom drawing handlers.
    """

    def __init__(self, name=wx.EmptyString):
        """
        RichTextDrawingHandler(name=wx.EmptyString)
        
        The base class for custom drawing handlers.
        """

    def HasVirtualAttributes(self, obj):
        """
        HasVirtualAttributes(obj) -> bool
        
        Returns true if this object has virtual attributes that we can
        provide.
        """

    def GetVirtualAttributes(self, attr, obj):
        """
        GetVirtualAttributes(attr, obj) -> bool
        
        Provides virtual attributes that we can provide.
        """

    def GetVirtualSubobjectAttributesCount(self, obj):
        """
        GetVirtualSubobjectAttributesCount(obj) -> int
        
        Gets the count for mixed virtual attributes for individual positions
        within the object.
        """

    def GetVirtualSubobjectAttributes(self, obj, positions, attributes):
        """
        GetVirtualSubobjectAttributes(obj, positions, attributes) -> int
        
        Gets the mixed virtual attributes for individual positions within the
        object.
        """

    def HasVirtualText(self, obj):
        """
        HasVirtualText(obj) -> bool
        
        Do we have virtual text for this object? Virtual text allows an
        application to replace characters in an object for editing and display
        purposes, for example for highlighting special characters.
        """

    def GetVirtualText(self, obj, text):
        """
        GetVirtualText(obj, text) -> bool
        
        Gets the virtual text for this object.
        """

    def SetName(self, name):
        """
        SetName(name)
        
        Sets the name of the handler.
        """

    def GetName(self):
        """
        GetName() -> String
        
        Returns the name of the handler.
        """
    Name = property(None, None)
# end of class RichTextDrawingHandler


class RichTextBufferDataObject(wx.DataObjectSimple):
    """
    RichTextBufferDataObject(richTextBuffer=None)
    
    Implements a rich text data object for clipboard transfer.
    """

    def __init__(self, richTextBuffer=None):
        """
        RichTextBufferDataObject(richTextBuffer=None)
        
        Implements a rich text data object for clipboard transfer.
        """

    def GetRichTextBuffer(self):
        """
        GetRichTextBuffer() -> RichTextBuffer
        
        After a call to this function, the buffer is owned by the caller and
        it is responsible for deleting it.
        """

    def GetPreferredFormat(self, dir):
        """
        GetPreferredFormat(dir) -> wx.DataFormat
        
        Returns the preferred format for either rendering the data (if dir is
        Get, its default value) or for setting it.
        """

    def GetDataSize(self, *args, **kw):
        """
        GetDataSize() -> size_t
        GetDataSize(format) -> size_t
        
        Gets the size of our data.
        """

    def GetDataHere(self, *args, **kw):
        """
        GetDataHere(buf) -> bool
        GetDataHere(format, buf) -> bool
        
        Copy the data to the buffer, return true on success.
        """

    def SetData(self, *args, **kw):
        """
        SetData(len, buf) -> bool
        SetData(format, len, buf) -> bool
        
        Copy the data from the buffer, return true on success.
        """

    @staticmethod
    def GetRichTextBufferFormatId():
        """
        GetRichTextBufferFormatId() -> Char
        
        Returns the id for the new data format.
        """
    DataSize = property(None, None)
    RichTextBuffer = property(None, None)
# end of class RichTextBufferDataObject


class RichTextRenderer(wx.Object):
    """
    RichTextRenderer()
    
    This class isolates some common drawing functionality.
    """

    def __init__(self):
        """
        RichTextRenderer()
        
        This class isolates some common drawing functionality.
        """

    def DrawStandardBullet(self, paragraph, dc, attr, rect):
        """
        DrawStandardBullet(paragraph, dc, attr, rect) -> bool
        
        Draws a standard bullet, as specified by the value of GetBulletName.
        """

    def DrawTextBullet(self, paragraph, dc, attr, rect, text):
        """
        DrawTextBullet(paragraph, dc, attr, rect, text) -> bool
        
        Draws a bullet that can be described by text, such as numbered or
        symbol bullets.
        """

    def DrawBitmapBullet(self, paragraph, dc, attr, rect):
        """
        DrawBitmapBullet(paragraph, dc, attr, rect) -> bool
        
        Draws a bitmap bullet, where the bullet bitmap is specified by the
        value of GetBulletName.
        """

    def EnumerateStandardBulletNames(self, bulletNames):
        """
        EnumerateStandardBulletNames(bulletNames) -> bool
        
        Enumerate the standard bullet names currently supported.
        """
# end of class RichTextRenderer


class RichTextStdRenderer(RichTextRenderer):
    """
    RichTextStdRenderer()
    
    The standard renderer for drawing bullets.
    """

    def __init__(self):
        """
        RichTextStdRenderer()
        
        The standard renderer for drawing bullets.
        """

    def DrawStandardBullet(self, paragraph, dc, attr, rect):
        """
        DrawStandardBullet(paragraph, dc, attr, rect) -> bool
        
        Draws a standard bullet, as specified by the value of GetBulletName.
        """

    def DrawTextBullet(self, paragraph, dc, attr, rect, text):
        """
        DrawTextBullet(paragraph, dc, attr, rect, text) -> bool
        
        Draws a bullet that can be described by text, such as numbered or
        symbol bullets.
        """

    def DrawBitmapBullet(self, paragraph, dc, attr, rect):
        """
        DrawBitmapBullet(paragraph, dc, attr, rect) -> bool
        
        Draws a bitmap bullet, where the bullet bitmap is specified by the
        value of GetBulletName.
        """

    def EnumerateStandardBulletNames(self, bulletNames):
        """
        EnumerateStandardBulletNames(bulletNames) -> bool
        
        Enumerate the standard bullet names currently supported.
        """
# end of class RichTextStdRenderer


def RichTextHasStyle(flags, style):
    """
    RichTextHasStyle(flags, style) -> bool
    """

def TextAttrEq(attr1, attr2):
    """
    TextAttrEq(attr1, attr2) -> bool
    
    Compare two attribute objects.
    """

def RichTextApplyStyle(destStyle, style, compareWith=None):
    """
    RichTextApplyStyle(destStyle, style, compareWith=None) -> bool
    
    Apply one style to another.
    """

def RichTextRemoveStyle(destStyle, style):
    """
    RichTextRemoveStyle(destStyle, style) -> bool
    """

def RichTextCombineBitlists(valueA, valueB, flagsA, flagsB):
    """
    RichTextCombineBitlists(valueA, valueB, flagsA, flagsB) -> bool
    
    Combine two bitlists.
    """

def RichTextBitlistsEqPartial(valueA, valueB, flags):
    """
    RichTextBitlistsEqPartial(valueA, valueB, flags) -> bool
    
    Compare two bitlists.
    """

def RichTextSplitParaCharStyles(style, parStyle, charStyle):
    """
    RichTextSplitParaCharStyles(style, parStyle, charStyle) -> bool
    
    Split into paragraph and character styles.
    """

def RichTextTabsEq(tabs1, tabs2):
    """
    RichTextTabsEq(tabs1, tabs2) -> bool
    
    Compare tabs.
    """

def RichTextDecimalToRoman(n):
    """
    RichTextDecimalToRoman(n) -> String
    
    Convert a decimal to Roman numerals.
    """

def TextAttrCollectCommonAttributes(currentStyle, attr, clashingAttr, absentAttr):
    """
    TextAttrCollectCommonAttributes(currentStyle, attr, clashingAttr, absentAttr)
    """

def RichTextModuleInit():
    """
    RichTextModuleInit()
    """

from collections import namedtuple
_im_RichTextRange = namedtuple('_im_RichTextRange', ['Start', 'End'])
del namedtuple
#-- end-richtextbuffer --#
#-- begin-richtextctrl --#
RE_READONLY = 0
RE_MULTILINE = 0
RE_CENTRE_CARET = 0
RE_CENTER_CARET = 0
RICHTEXT_SHIFT_DOWN = 0
RICHTEXT_CTRL_DOWN = 0
RICHTEXT_ALT_DOWN = 0
RICHTEXT_EX_NO_GUIDELINES = 0
ID_RICHTEXT_PROPERTIES1 = 0
ID_RICHTEXT_PROPERTIES2 = 0
ID_RICHTEXT_PROPERTIES3 = 0
RichTextCtrlSelectionState_Normal = 0
RichTextCtrlSelectionState_CommonAncestor = 0
wxEVT_RICHTEXT_LEFT_CLICK = 0
wxEVT_RICHTEXT_RIGHT_CLICK = 0
wxEVT_RICHTEXT_MIDDLE_CLICK = 0
wxEVT_RICHTEXT_LEFT_DCLICK = 0
wxEVT_RICHTEXT_RETURN = 0
wxEVT_RICHTEXT_CHARACTER = 0
wxEVT_RICHTEXT_CONSUMING_CHARACTER = 0
wxEVT_RICHTEXT_DELETE = 0
wxEVT_RICHTEXT_STYLESHEET_CHANGING = 0
wxEVT_RICHTEXT_STYLESHEET_CHANGED = 0
wxEVT_RICHTEXT_STYLESHEET_REPLACING = 0
wxEVT_RICHTEXT_STYLESHEET_REPLACED = 0
wxEVT_RICHTEXT_CONTENT_INSERTED = 0
wxEVT_RICHTEXT_CONTENT_DELETED = 0
wxEVT_RICHTEXT_STYLE_CHANGED = 0
wxEVT_RICHTEXT_PROPERTIES_CHANGED = 0
wxEVT_RICHTEXT_SELECTION_CHANGED = 0
wxEVT_RICHTEXT_BUFFER_RESET = 0
wxEVT_RICHTEXT_FOCUS_OBJECT_CHANGED = 0

class RichTextContextMenuPropertiesInfo(object):
    """
    RichTextContextMenuPropertiesInfo()
    
    wxRichTextContextMenuPropertiesInfo keeps track of objects that appear
    in the context menu, whose properties are available to be edited.
    """

    def __init__(self):
        """
        RichTextContextMenuPropertiesInfo()
        
        wxRichTextContextMenuPropertiesInfo keeps track of objects that appear
        in the context menu, whose properties are available to be edited.
        """
    m_objects = property(None, None)
    m_labels = property(None, None)

    def Init(self):
        """
        Init()
        
        Initialisation.
        """

    def AddItem(self, label, obj):
        """
        AddItem(label, obj) -> bool
        
        Adds an item.
        """

    def AddMenuItems(self, menu, startCmd=ID_RICHTEXT_PROPERTIES1):
        """
        AddMenuItems(menu, startCmd=ID_RICHTEXT_PROPERTIES1) -> int
        
        Returns the number of menu items that were added.
        """

    def AddItems(self, ctrl, container, obj):
        """
        AddItems(ctrl, container, obj) -> int
        
        Adds appropriate menu items for the current container and clicked on
        object (and container's parent, if appropriate).
        """

    def Clear(self):
        """
        Clear()
        
        Clears the items.
        """

    def GetLabel(self, n):
        """
        GetLabel(n) -> String
        
        Returns the nth label.
        """

    def GetObject(self, n):
        """
        GetObject(n) -> RichTextObject
        
        Returns the nth object.
        """

    def GetObjects(self):
        """
        GetObjects() -> RichTextObjectPtrArray
        
        Returns the array of objects.
        """

    def GetLabels(self):
        """
        GetLabels() -> ArrayString
        
        Returns the array of labels.
        """

    def GetCount(self):
        """
        GetCount() -> int
        
        Returns the number of items.
        """
    Count = property(None, None)
    Labels = property(None, None)
    Objects = property(None, None)
# end of class RichTextContextMenuPropertiesInfo


class RichTextCtrl(wx.Control):
    """
    RichTextCtrl()
    RichTextCtrl(parent, id=-1, value=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=RE_MULTILINE, validator=wx.DefaultValidator, name=wx.TextCtrlNameStr)
    
    wxRichTextCtrl provides a generic, ground-up implementation of a text
    control capable of showing multiple styles and images.
    """

    def __init__(self, *args, **kw):
        """
        RichTextCtrl()
        RichTextCtrl(parent, id=-1, value=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=RE_MULTILINE, validator=wx.DefaultValidator, name=wx.TextCtrlNameStr)
        
        wxRichTextCtrl provides a generic, ground-up implementation of a text
        control capable of showing multiple styles and images.
        """

    def GetSelection(self):
        """
        GetSelection() -> RichTextSelection
        
        Returns the range of the current selection.
        """

    def GetContextMenuPropertiesInfo(self):
        """
        GetContextMenuPropertiesInfo() -> RichTextContextMenuPropertiesInfo
        
        Returns an object that stores information about context menu property
        item(s), in order to communicate between the context menu event
        handler and the code that responds to it.
        """

    def GetStyle(self, *args, **kw):
        """
        GetStyle(position, style) -> bool
        GetStyle(position, style) -> bool
        GetStyle(position, style, container) -> bool
        
        Gets the attributes at the given position.
        """

    def SetStyle(self, *args, **kw):
        """
        SetStyle(start, end, style) -> bool
        SetStyle(start, end, style) -> bool
        SetStyle(range, style) -> bool
        SetStyle(range, style) -> bool
        SetStyle(obj, textAttr, flags=RICHTEXT_SETSTYLE_WITH_UNDO)
        
        Sets the attributes for the given range.
        """

    def GetStyleForRange(self, *args, **kw):
        """
        GetStyleForRange(range, style) -> bool
        GetStyleForRange(range, style) -> bool
        GetStyleForRange(range, style, container) -> bool
        
        Gets the attributes common to the specified range.
        """

    def GetUncombinedStyle(self, *args, **kw):
        """
        GetUncombinedStyle(position, style) -> bool
        GetUncombinedStyle(position, style, container) -> bool
        
        Gets the attributes at the given position.
        """

    def SetDefaultStyle(self, *args, **kw):
        """
        SetDefaultStyle(style) -> bool
        SetDefaultStyle(style) -> bool
        
        Sets the current default style, which can be used to change how
        subsequently inserted text is displayed.
        """

    def SetListStyle(self, *args, **kw):
        """
        SetListStyle(range, styleDef, flags=RICHTEXT_SETSTYLE_WITH_UNDO, startFrom=1, specifiedLevel=-1) -> bool
        SetListStyle(range, defName, flags=RICHTEXT_SETSTYLE_WITH_UNDO, startFrom=1, specifiedLevel=-1) -> bool
        
        Sets the list attributes for the given range, passing flags to
        determine how the attributes are set.
        """

    def NumberList(self, *args, **kw):
        """
        NumberList(range, def=None, flags=RICHTEXT_SETSTYLE_WITH_UNDO, startFrom=1, specifiedLevel=-1) -> bool
        NumberList(range, defName, flags=RICHTEXT_SETSTYLE_WITH_UNDO, startFrom=1, specifiedLevel=-1) -> bool
        
        Numbers the paragraphs in the given range.
        """

    def PromoteList(self, *args, **kw):
        """
        PromoteList(promoteBy, range, def=None, flags=RICHTEXT_SETSTYLE_WITH_UNDO, specifiedLevel=-1) -> bool
        PromoteList(promoteBy, range, defName, flags=RICHTEXT_SETSTYLE_WITH_UNDO, specifiedLevel=-1) -> bool
        
        Promotes or demotes the paragraphs in the given range.
        """

    def HitTest(self, pt):
        """
        HitTest(pt) -> (TextCtrlHitTestResult, pos)
        
        Finds the character at the given position in pixels.
        """

    def HitTestXY(self, pt):
        """
        HitTestXY(pt) -> (TextCtrlHitTestResult, col, row)
        
        Finds the character at the given position in pixels.
        """

    def FindContainerAtPoint(self, pt, position, hit, hitObj, flags=0):
        """
        FindContainerAtPoint(pt, position, hit, hitObj, flags=0) -> RichTextParagraphLayoutBox
        
        Finds the container at the given point, which is assumed to be in
        client coordinates.
        """

    def SetSelection(self, *args, **kw):
        """
        SetSelection(from_, to_)
        SetSelection(sel)
        
        Sets the selection to the given range.
        """

    def WriteImage(self, *args, **kw):
        """
        WriteImage(image, bitmapType=wx.BITMAP_TYPE_PNG, textAttr=RichTextAttr()) -> bool
        WriteImage(bitmap, bitmapType=wx.BITMAP_TYPE_PNG, textAttr=RichTextAttr()) -> bool
        WriteImage(filename, bitmapType, textAttr=RichTextAttr()) -> bool
        WriteImage(imageBlock, textAttr=RichTextAttr()) -> bool
        
        Write a bitmap or image at the current insertion point.
        """

    def GetBuffer(self):
        """
        GetBuffer() -> RichTextBuffer
        
        Returns the buffer associated with the control.
        """

    def Create(self, parent, id=-1, value=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=RE_MULTILINE, validator=wx.DefaultValidator, name=wx.TextCtrlNameStr):
        """
        Create(parent, id=-1, value=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=RE_MULTILINE, validator=wx.DefaultValidator, name=wx.TextCtrlNameStr) -> bool
        
        Creates the underlying window.
        """

    def Init(self):
        """
        Init()
        
        Initialises the members of the control.
        """

    def GetRange(self, from_, to_):
        """
        GetRange(from_, to_) -> String
        
        Gets the text for the given range.
        """

    def GetLineLength(self, lineNo):
        """
        GetLineLength(lineNo) -> int
        
        Returns the length of the specified line in characters.
        """

    def GetLineText(self, lineNo):
        """
        GetLineText(lineNo) -> String
        
        Returns the text for the given line.
        """

    def GetNumberOfLines(self):
        """
        GetNumberOfLines() -> int
        
        Returns the number of lines in the buffer.
        """

    def IsModified(self):
        """
        IsModified() -> bool
        
        Returns true if the buffer has been modified.
        """

    def IsEditable(self):
        """
        IsEditable() -> bool
        
        Returns true if the control is editable.
        """

    def IsSingleLine(self):
        """
        IsSingleLine() -> bool
        
        Returns true if the control is single-line.
        """

    def IsMultiLine(self):
        """
        IsMultiLine() -> bool
        
        Returns true if the control is multiline.
        """

    def GetStringSelection(self):
        """
        GetStringSelection() -> String
        
        Returns the text within the current selection range, if any.
        """

    def GetFilename(self):
        """
        GetFilename() -> String
        
        Gets the current filename associated with the control.
        """

    def SetFilename(self, filename):
        """
        SetFilename(filename)
        
        Sets the current filename.
        """

    def SetDelayedLayoutThreshold(self, threshold):
        """
        SetDelayedLayoutThreshold(threshold)
        
        Sets the size of the buffer beyond which layout is delayed during
        resizing.
        """

    def GetDelayedLayoutThreshold(self):
        """
        GetDelayedLayoutThreshold() -> long
        
        Gets the size of the buffer beyond which layout is delayed during
        resizing.
        """

    def GetFullLayoutRequired(self):
        """
        GetFullLayoutRequired() -> bool
        """

    def SetFullLayoutRequired(self, b):
        """
        SetFullLayoutRequired(b)
        """

    def GetFullLayoutTime(self):
        """
        GetFullLayoutTime() -> LongLong
        """

    def SetFullLayoutTime(self, t):
        """
        SetFullLayoutTime(t)
        """

    def GetFullLayoutSavedPosition(self):
        """
        GetFullLayoutSavedPosition() -> long
        """

    def SetFullLayoutSavedPosition(self, p):
        """
        SetFullLayoutSavedPosition(p)
        """

    def ForceDelayedLayout(self):
        """
        ForceDelayedLayout()
        """

    def SetTextCursor(self, cursor):
        """
        SetTextCursor(cursor)
        
        Sets the text (normal) cursor.
        """

    def GetTextCursor(self):
        """
        GetTextCursor() -> wx.Cursor
        
        Returns the text (normal) cursor.
        """

    def SetURLCursor(self, cursor):
        """
        SetURLCursor(cursor)
        
        Sets the cursor to be used over URLs.
        """

    def GetURLCursor(self):
        """
        GetURLCursor() -> wx.Cursor
        
        Returns the cursor to be used over URLs.
        """

    def GetCaretAtLineStart(self):
        """
        GetCaretAtLineStart() -> bool
        
        Returns true if we are showing the caret position at the start of a
        line instead of at the end of the previous one.
        """

    def SetCaretAtLineStart(self, atStart):
        """
        SetCaretAtLineStart(atStart)
        
        Sets a flag to remember that we are showing the caret position at the
        start of a line instead of at the end of the previous one.
        """

    def GetDragging(self):
        """
        GetDragging() -> bool
        
        Returns true if we are extending a selection.
        """

    def SetDragging(self, dragging):
        """
        SetDragging(dragging)
        
        Sets a flag to remember if we are extending a selection.
        """

    def GetPreDrag(self):
        """
        GetPreDrag() -> bool
        
        Are we trying to start Drag'n'Drop?
        """

    def SetPreDrag(self, pd):
        """
        SetPreDrag(pd)
        
        Set if we're trying to start Drag'n'Drop.
        """

    def GetDragStartPoint(self):
        """
        GetDragStartPoint() -> wx.Point
        
        Get the possible Drag'n'Drop start point.
        """

    def SetDragStartPoint(self, sp):
        """
        SetDragStartPoint(sp)
        
        Set the possible Drag'n'Drop start point.
        """

    def GetDragStartTime(self):
        """
        GetDragStartTime() -> wx.DateTime
        
        Get the possible Drag'n'Drop start time.
        """

    def SetDragStartTime(self, st):
        """
        SetDragStartTime(st)
        
        Set the possible Drag'n'Drop start time.
        """

    def GetContextMenu(self):
        """
        GetContextMenu() -> wx.Menu
        
        Returns the current context menu.
        """

    def SetContextMenu(self, menu):
        """
        SetContextMenu(menu)
        
        Sets the current context menu.
        """

    def GetSelectionAnchor(self):
        """
        GetSelectionAnchor() -> long
        
        Returns an anchor so we know how to extend the selection.
        """

    def SetSelectionAnchor(self, anchor):
        """
        SetSelectionAnchor(anchor)
        
        Sets an anchor so we know how to extend the selection.
        """

    def GetSelectionAnchorObject(self):
        """
        GetSelectionAnchorObject() -> RichTextObject
        
        Returns the anchor object if selecting multiple containers.
        """

    def SetSelectionAnchorObject(self, anchor):
        """
        SetSelectionAnchorObject(anchor)
        
        Sets the anchor object if selecting multiple containers.
        """

    def GetFocusObject(self):
        """
        GetFocusObject() -> RichTextParagraphLayoutBox
        
        Returns the wxRichTextObject object that currently has the editing
        focus.
        """

    def StoreFocusObject(self, obj):
        """
        StoreFocusObject(obj)
        
        Setter for m_focusObject.
        """

    def SetFocusObject(self, obj, setCaretPosition=True):
        """
        SetFocusObject(obj, setCaretPosition=True) -> bool
        
        Sets the wxRichTextObject object that currently has the editing focus.
        """

    def Invalidate(self):
        """
        Invalidate()
        
        Invalidates the whole buffer to trigger painting later.
        """

    def Clear(self):
        """
        Clear()
        
        Clears the buffer content, leaving a single empty paragraph.
        """

    def Replace(self, from_, to_, value):
        """
        Replace(from_, to_, value)
        
        Replaces the content in the specified range with the string specified
        by value.
        """

    def Remove(self, from_, to_):
        """
        Remove(from_, to_)
        
        Removes the content in the specified range.
        """

    def LoadFile(self, file, type=RICHTEXT_TYPE_ANY):
        """
        LoadFile(file, type=RICHTEXT_TYPE_ANY) -> bool
        
        Loads content into the control's buffer using the given type.
        """

    def DoLoadFile(self, file, fileType):
        """
        DoLoadFile(file, fileType) -> bool
        
        Helper function for LoadFile().
        """

    def SaveFile(self, file=wx.EmptyString, type=RICHTEXT_TYPE_ANY):
        """
        SaveFile(file=wx.EmptyString, type=RICHTEXT_TYPE_ANY) -> bool
        
        Saves the buffer content using the given type.
        """

    def DoSaveFile(self, file=wx.EmptyString, fileType=RICHTEXT_TYPE_ANY):
        """
        DoSaveFile(file=wx.EmptyString, fileType=RICHTEXT_TYPE_ANY) -> bool
        
        Helper function for SaveFile().
        """

    def SetHandlerFlags(self, flags):
        """
        SetHandlerFlags(flags)
        
        Sets flags that change the behaviour of loading or saving.
        """

    def GetHandlerFlags(self):
        """
        GetHandlerFlags() -> int
        
        Returns flags that change the behaviour of loading or saving.
        """

    def MarkDirty(self):
        """
        MarkDirty()
        
        Marks the buffer as modified.
        """

    def DiscardEdits(self):
        """
        DiscardEdits()
        
        Sets the buffer's modified status to false, and clears the buffer's
        command history.
        """

    def SetModified(self, modified):
        """
        SetModified(modified)
        """

    def SetMaxLength(self, len):
        """
        SetMaxLength(len)
        
        Sets the maximum number of characters that may be entered in a single
        line text control.
        """

    def WriteText(self, text):
        """
        WriteText(text)
        
        Writes text at the current position.
        """

    def AppendText(self, text):
        """
        AppendText(text)
        
        Sets the insertion point to the end of the buffer and writes the text.
        """

    def SetStyleEx(self, range, style, flags=RICHTEXT_SETSTYLE_WITH_UNDO):
        """
        SetStyleEx(range, style, flags=RICHTEXT_SETSTYLE_WITH_UNDO) -> bool
        
        Sets the attributes for the given range, passing flags to determine
        how the attributes are set.
        """

    def GetDefaultStyleEx(self):
        """
        GetDefaultStyleEx() -> RichTextAttr
        
        Returns the current default style, which can be used to change how
        subsequently inserted text is displayed.
        """

    def ClearListStyle(self, range, flags=RICHTEXT_SETSTYLE_WITH_UNDO):
        """
        ClearListStyle(range, flags=RICHTEXT_SETSTYLE_WITH_UNDO) -> bool
        
        Clears the list style from the given range, clearing list-related
        attributes and applying any named paragraph style associated with each
        paragraph.
        """

    def SetProperties(self, range, properties, flags=RICHTEXT_SETPROPERTIES_WITH_UNDO):
        """
        SetProperties(range, properties, flags=RICHTEXT_SETPROPERTIES_WITH_UNDO) -> bool
        
        Sets the properties for the given range, passing flags to determine
        how the attributes are set.
        """

    def Delete(self, range):
        """
        Delete(range) -> bool
        
        Deletes the content within the given range.
        """

    def XYToPosition(self, x, y):
        """
        XYToPosition(x, y) -> long
        
        Translates from column and line number to position.
        """

    def PositionToXY(self, pos):
        """
        PositionToXY(pos) -> (bool, x, y)
        
        Converts a text position to zero-based column and line numbers.
        """

    def ShowPosition(self, pos):
        """
        ShowPosition(pos)
        
        Scrolls the buffer so that the given position is in view.
        """

    def Copy(self):
        """
        Copy()
        
        Copies the selected content (if any) to the clipboard.
        """

    def Cut(self):
        """
        Cut()
        
        Copies the selected content (if any) to the clipboard and deletes the
        selection.
        """

    def Paste(self):
        """
        Paste()
        
        Pastes content from the clipboard to the buffer.
        """

    def DeleteSelection(self):
        """
        DeleteSelection()
        
        Deletes the content in the selection, if any.
        """

    def CanCopy(self):
        """
        CanCopy() -> bool
        
        Returns true if selected content can be copied to the clipboard.
        """

    def CanCut(self):
        """
        CanCut() -> bool
        
        Returns true if selected content can be copied to the clipboard and
        deleted.
        """

    def CanPaste(self):
        """
        CanPaste() -> bool
        
        Returns true if the clipboard content can be pasted to the buffer.
        """

    def CanDeleteSelection(self):
        """
        CanDeleteSelection() -> bool
        
        Returns true if selected content can be deleted.
        """

    def Undo(self):
        """
        Undo()
        
        Undoes the command at the top of the command history, if there is one.
        """

    def Redo(self):
        """
        Redo()
        
        Redoes the current command.
        """

    def CanUndo(self):
        """
        CanUndo() -> bool
        
        Returns true if there is a command in the command history that can be
        undone.
        """

    def CanRedo(self):
        """
        CanRedo() -> bool
        
        Returns true if there is a command in the command history that can be
        redone.
        """

    def SetInsertionPoint(self, pos):
        """
        SetInsertionPoint(pos)
        
        Sets the insertion point and causes the current editing style to be
        taken from the new position (unlike wxRichTextCtrl::SetCaretPosition).
        """

    def SetInsertionPointEnd(self):
        """
        SetInsertionPointEnd()
        
        Sets the insertion point to the end of the text control.
        """

    def GetInsertionPoint(self):
        """
        GetInsertionPoint() -> long
        
        Returns the current insertion point.
        """

    def GetLastPosition(self):
        """
        GetLastPosition() -> TextPos
        
        Returns the last position in the buffer.
        """

    def SelectAll(self):
        """
        SelectAll()
        
        Selects all the text in the buffer.
        """

    def SetEditable(self, editable):
        """
        SetEditable(editable)
        
        Makes the control editable, or not.
        """

    def HasSelection(self):
        """
        HasSelection() -> bool
        
        Returns true if there is a selection and the object containing the
        selection was the same as the current focus object.
        """

    def HasUnfocusedSelection(self):
        """
        HasUnfocusedSelection() -> bool
        
        Returns true if there was a selection, whether or not the current
        focus object is the same as the selection's container object.
        """

    def WriteTextBox(self, textAttr=RichTextAttr()):
        """
        WriteTextBox(textAttr=RichTextAttr()) -> RichTextBox
        
        Write a text box at the current insertion point, returning the text
        box.
        """

    def WriteField(self, fieldType, properties, textAttr=RichTextAttr()):
        """
        WriteField(fieldType, properties, textAttr=RichTextAttr()) -> RichTextField
        
        Writes a field at the current insertion point.
        """

    def WriteTable(self, rows, cols, tableAttr=RichTextAttr(), cellAttr=RichTextAttr()):
        """
        WriteTable(rows, cols, tableAttr=RichTextAttr(), cellAttr=RichTextAttr()) -> RichTextTable
        
        Write a table at the current insertion point, returning the table.
        """

    def Newline(self):
        """
        Newline() -> bool
        
        Inserts a new paragraph at the current insertion point.
        """

    def LineBreak(self):
        """
        LineBreak() -> bool
        
        Inserts a line break at the current insertion point.
        """

    def SetBasicStyle(self, style):
        """
        SetBasicStyle(style)
        
        Sets the basic (overall) style.
        """

    def GetBasicStyle(self):
        """
        GetBasicStyle() -> RichTextAttr
        
        Gets the basic (overall) style.
        """

    def BeginStyle(self, style):
        """
        BeginStyle(style) -> bool
        
        Begins applying a style.
        """

    def EndStyle(self):
        """
        EndStyle() -> bool
        
        Ends the current style.
        """

    def EndAllStyles(self):
        """
        EndAllStyles() -> bool
        
        Ends application of all styles in the current style stack.
        """

    def BeginBold(self):
        """
        BeginBold() -> bool
        
        Begins using bold.
        """

    def EndBold(self):
        """
        EndBold() -> bool
        
        Ends using bold.
        """

    def BeginItalic(self):
        """
        BeginItalic() -> bool
        
        Begins using italic.
        """

    def EndItalic(self):
        """
        EndItalic() -> bool
        
        Ends using italic.
        """

    def BeginUnderline(self):
        """
        BeginUnderline() -> bool
        
        Begins using underlining.
        """

    def EndUnderline(self):
        """
        EndUnderline() -> bool
        
        End applying underlining.
        """

    def BeginFontSize(self, pointSize):
        """
        BeginFontSize(pointSize) -> bool
        
        Begins using the given point size.
        """

    def EndFontSize(self):
        """
        EndFontSize() -> bool
        
        Ends using a point size.
        """

    def BeginFont(self, font):
        """
        BeginFont(font) -> bool
        
        Begins using this font.
        """

    def EndFont(self):
        """
        EndFont() -> bool
        
        Ends using a font.
        """

    def BeginTextColour(self, colour):
        """
        BeginTextColour(colour) -> bool
        
        Begins using this colour.
        """

    def EndTextColour(self):
        """
        EndTextColour() -> bool
        
        Ends applying a text colour.
        """

    def BeginAlignment(self, alignment):
        """
        BeginAlignment(alignment) -> bool
        
        Begins using alignment.
        """

    def EndAlignment(self):
        """
        EndAlignment() -> bool
        
        Ends alignment.
        """

    def BeginLeftIndent(self, leftIndent, leftSubIndent=0):
        """
        BeginLeftIndent(leftIndent, leftSubIndent=0) -> bool
        
        Begins applying a left indent and subindent in tenths of a millimetre.
        """

    def EndLeftIndent(self):
        """
        EndLeftIndent() -> bool
        
        Ends left indent.
        """

    def BeginRightIndent(self, rightIndent):
        """
        BeginRightIndent(rightIndent) -> bool
        
        Begins a right indent, specified in tenths of a millimetre.
        """

    def EndRightIndent(self):
        """
        EndRightIndent() -> bool
        
        Ends right indent.
        """

    def BeginParagraphSpacing(self, before, after):
        """
        BeginParagraphSpacing(before, after) -> bool
        
        Begins paragraph spacing; pass the before-paragraph and after-
        paragraph spacing in tenths of a millimetre.
        """

    def EndParagraphSpacing(self):
        """
        EndParagraphSpacing() -> bool
        
        Ends paragraph spacing.
        """

    def BeginLineSpacing(self, lineSpacing):
        """
        BeginLineSpacing(lineSpacing) -> bool
        
        Begins appling line spacing.
        """

    def EndLineSpacing(self):
        """
        EndLineSpacing() -> bool
        
        Ends line spacing.
        """

    def BeginNumberedBullet(self, bulletNumber, leftIndent, leftSubIndent, bulletStyle=wx.TEXT_ATTR_BULLET_STYLE_ARABIC|wx.TEXT_ATTR_BULLET_STYLE_PERIOD):
        """
        BeginNumberedBullet(bulletNumber, leftIndent, leftSubIndent, bulletStyle=wx.TEXT_ATTR_BULLET_STYLE_ARABIC|wx.TEXT_ATTR_BULLET_STYLE_PERIOD) -> bool
        
        Begins a numbered bullet.
        """

    def EndNumberedBullet(self):
        """
        EndNumberedBullet() -> bool
        
        Ends application of a numbered bullet.
        """

    def BeginSymbolBullet(self, symbol, leftIndent, leftSubIndent, bulletStyle=wx.TEXT_ATTR_BULLET_STYLE_SYMBOL):
        """
        BeginSymbolBullet(symbol, leftIndent, leftSubIndent, bulletStyle=wx.TEXT_ATTR_BULLET_STYLE_SYMBOL) -> bool
        
        Begins applying a symbol bullet, using a character from the current
        font.
        """

    def EndSymbolBullet(self):
        """
        EndSymbolBullet() -> bool
        
        Ends applying a symbol bullet.
        """

    def BeginStandardBullet(self, bulletName, leftIndent, leftSubIndent, bulletStyle=wx.TEXT_ATTR_BULLET_STYLE_STANDARD):
        """
        BeginStandardBullet(bulletName, leftIndent, leftSubIndent, bulletStyle=wx.TEXT_ATTR_BULLET_STYLE_STANDARD) -> bool
        
        Begins applying a symbol bullet.
        """

    def EndStandardBullet(self):
        """
        EndStandardBullet() -> bool
        
        Begins applying a standard bullet.
        """

    def BeginCharacterStyle(self, characterStyle):
        """
        BeginCharacterStyle(characterStyle) -> bool
        
        Begins using the named character style.
        """

    def EndCharacterStyle(self):
        """
        EndCharacterStyle() -> bool
        
        Ends application of a named character style.
        """

    def BeginParagraphStyle(self, paragraphStyle):
        """
        BeginParagraphStyle(paragraphStyle) -> bool
        
        Begins applying the named paragraph style.
        """

    def EndParagraphStyle(self):
        """
        EndParagraphStyle() -> bool
        
        Ends application of a named paragraph style.
        """

    def BeginListStyle(self, listStyle, level=1, number=1):
        """
        BeginListStyle(listStyle, level=1, number=1) -> bool
        
        Begins using a specified list style.
        """

    def EndListStyle(self):
        """
        EndListStyle() -> bool
        
        Ends using a specified list style.
        """

    def BeginURL(self, url, characterStyle=wx.EmptyString):
        """
        BeginURL(url, characterStyle=wx.EmptyString) -> bool
        
        Begins applying wxTEXT_ATTR_URL to the content.
        """

    def EndURL(self):
        """
        EndURL() -> bool
        
        Ends applying a URL.
        """

    def SetDefaultStyleToCursorStyle(self):
        """
        SetDefaultStyleToCursorStyle() -> bool
        
        Sets the default style to the style under the cursor.
        """

    def SelectNone(self):
        """
        SelectNone()
        
        Cancels any selection.
        """

    def SelectWord(self, position):
        """
        SelectWord(position) -> bool
        
        Selects the word at the given character position.
        """

    def GetSelectionRange(self):
        """
        GetSelectionRange() -> RichTextRange
        
        Returns the selection range in character positions.
        """

    def SetSelectionRange(self, range):
        """
        SetSelectionRange(range)
        
        Sets the selection to the given range.
        """

    def GetInternalSelectionRange(self):
        """
        GetInternalSelectionRange() -> RichTextRange
        
        Returns the selection range in character positions.
        """

    def SetInternalSelectionRange(self, range):
        """
        SetInternalSelectionRange(range)
        
        Sets the selection range in character positions.
        """

    def AddParagraph(self, text):
        """
        AddParagraph(text) -> RichTextRange
        
        Adds a new paragraph of text to the end of the buffer.
        """

    def AddImage(self, image):
        """
        AddImage(image) -> RichTextRange
        
        Adds an image to the control's buffer.
        """

    def LayoutContent(self, onlyVisibleRect=False):
        """
        LayoutContent(onlyVisibleRect=False) -> bool
        
        Lays out the buffer, which must be done before certain operations,
        such as setting the caret position.
        """

    def MoveCaret(self, pos, showAtLineStart=False, container=None):
        """
        MoveCaret(pos, showAtLineStart=False, container=None) -> bool
        
        Move the caret to the given character position.
        """

    def MoveRight(self, noPositions=1, flags=0):
        """
        MoveRight(noPositions=1, flags=0) -> bool
        
        Moves right.
        """

    def MoveLeft(self, noPositions=1, flags=0):
        """
        MoveLeft(noPositions=1, flags=0) -> bool
        
        Moves left.
        """

    def MoveUp(self, noLines=1, flags=0):
        """
        MoveUp(noLines=1, flags=0) -> bool
        
        Moves to the start of the paragraph.
        """

    def MoveDown(self, noLines=1, flags=0):
        """
        MoveDown(noLines=1, flags=0) -> bool
        
        Moves the caret down.
        """

    def MoveToLineEnd(self, flags=0):
        """
        MoveToLineEnd(flags=0) -> bool
        
        Moves to the end of the line.
        """

    def MoveToLineStart(self, flags=0):
        """
        MoveToLineStart(flags=0) -> bool
        
        Moves to the start of the line.
        """

    def MoveToParagraphEnd(self, flags=0):
        """
        MoveToParagraphEnd(flags=0) -> bool
        
        Moves to the end of the paragraph.
        """

    def MoveToParagraphStart(self, flags=0):
        """
        MoveToParagraphStart(flags=0) -> bool
        
        Moves to the start of the paragraph.
        """

    def MoveHome(self, flags=0):
        """
        MoveHome(flags=0) -> bool
        
        Moves to the start of the buffer.
        """

    def MoveEnd(self, flags=0):
        """
        MoveEnd(flags=0) -> bool
        
        Moves to the end of the buffer.
        """

    def PageUp(self, noPages=1, flags=0):
        """
        PageUp(noPages=1, flags=0) -> bool
        
        Moves one or more pages up.
        """

    def PageDown(self, noPages=1, flags=0):
        """
        PageDown(noPages=1, flags=0) -> bool
        
        Moves one or more pages down.
        """

    def WordLeft(self, noPages=1, flags=0):
        """
        WordLeft(noPages=1, flags=0) -> bool
        
        Moves a number of words to the left.
        """

    def WordRight(self, noPages=1, flags=0):
        """
        WordRight(noPages=1, flags=0) -> bool
        
        Move a nuber of words to the right.
        """

    def BeginBatchUndo(self, cmdName):
        """
        BeginBatchUndo(cmdName) -> bool
        
        Starts batching undo history for commands.
        """

    def EndBatchUndo(self):
        """
        EndBatchUndo() -> bool
        
        Ends batching undo command history.
        """

    def BatchingUndo(self):
        """
        BatchingUndo() -> bool
        
        Returns true if undo commands are being batched.
        """

    def BeginSuppressUndo(self):
        """
        BeginSuppressUndo() -> bool
        
        Starts suppressing undo history for commands.
        """

    def EndSuppressUndo(self):
        """
        EndSuppressUndo() -> bool
        
        Ends suppressing undo command history.
        """

    def SuppressingUndo(self):
        """
        SuppressingUndo() -> bool
        
        Returns true if undo history suppression is on.
        """

    def HasCharacterAttributes(self, range, style):
        """
        HasCharacterAttributes(range, style) -> bool
        
        Test if this whole range has character attributes of the specified
        kind.
        """

    def HasParagraphAttributes(self, range, style):
        """
        HasParagraphAttributes(range, style) -> bool
        
        Test if this whole range has paragraph attributes of the specified
        kind.
        """

    def IsSelectionBold(self):
        """
        IsSelectionBold() -> bool
        
        Returns true if all of the selection, or the content at the caret
        position, is bold.
        """

    def IsSelectionItalics(self):
        """
        IsSelectionItalics() -> bool
        
        Returns true if all of the selection, or the content at the caret
        position, is italic.
        """

    def IsSelectionUnderlined(self):
        """
        IsSelectionUnderlined() -> bool
        
        Returns true if all of the selection, or the content at the caret
        position, is underlined.
        """

    def DoesSelectionHaveTextEffectFlag(self, flag):
        """
        DoesSelectionHaveTextEffectFlag(flag) -> bool
        
        Returns true if all of the selection, or the content at the current
        caret position, has the supplied wxTextAttrEffects flag(s).
        """

    def IsSelectionAligned(self, alignment):
        """
        IsSelectionAligned(alignment) -> bool
        
        Returns true if all of the selection is aligned according to the
        specified flag.
        """

    def ApplyBoldToSelection(self):
        """
        ApplyBoldToSelection() -> bool
        
        Apples bold to the selection or the default style (undoable).
        """

    def ApplyItalicToSelection(self):
        """
        ApplyItalicToSelection() -> bool
        
        Applies italic to the selection or the default style (undoable).
        """

    def ApplyUnderlineToSelection(self):
        """
        ApplyUnderlineToSelection() -> bool
        
        Applies underline to the selection or the default style (undoable).
        """

    def ApplyTextEffectToSelection(self, flags):
        """
        ApplyTextEffectToSelection(flags) -> bool
        
        Applies one or more wxTextAttrEffects flags to the selection
        (undoable).
        """

    def ApplyAlignmentToSelection(self, alignment):
        """
        ApplyAlignmentToSelection(alignment) -> bool
        
        Applies the given alignment to the selection or the default style
        (undoable).
        """

    def ApplyStyle(self, styleDef):
        """
        ApplyStyle(styleDef) -> bool
        
        Applies the style sheet to the buffer, matching paragraph styles in
        the sheet against named styles in the buffer.
        """

    def SetStyleSheet(self, styleSheet):
        """
        SetStyleSheet(styleSheet)
        
        Sets the style sheet associated with the control.
        """

    def GetStyleSheet(self):
        """
        GetStyleSheet() -> RichTextStyleSheet
        
        Returns the style sheet associated with the control, if any.
        """

    def PushStyleSheet(self, styleSheet):
        """
        PushStyleSheet(styleSheet) -> bool
        
        Push the style sheet to top of stack.
        """

    def PopStyleSheet(self):
        """
        PopStyleSheet() -> RichTextStyleSheet
        
        Pops the style sheet from top of stack.
        """

    def ApplyStyleSheet(self, styleSheet=None):
        """
        ApplyStyleSheet(styleSheet=None) -> bool
        
        Applies the style sheet to the buffer, for example if the styles have
        changed.
        """

    def ShowContextMenu(self, menu, pt, addPropertyCommands):
        """
        ShowContextMenu(menu, pt, addPropertyCommands) -> bool
        
        Shows the given context menu, optionally adding appropriate property-
        editing commands for the current position in the object hierarchy.
        """

    def PrepareContextMenu(self, menu, pt, addPropertyCommands):
        """
        PrepareContextMenu(menu, pt, addPropertyCommands) -> int
        
        Prepares the context menu, optionally adding appropriate property-
        editing commands.
        """

    def CanEditProperties(self, obj):
        """
        CanEditProperties(obj) -> bool
        
        Returns true if we can edit the object's properties via a GUI.
        """

    def EditProperties(self, obj, parent):
        """
        EditProperties(obj, parent) -> bool
        
        Edits the object's properties via a GUI.
        """

    def GetPropertiesMenuLabel(self, obj):
        """
        GetPropertiesMenuLabel(obj) -> String
        
        Gets the object's properties menu label.
        """

    def PrepareContent(self, container):
        """
        PrepareContent(container)
        
        Prepares the content just before insertion (or after buffer reset).
        """

    def CanDeleteRange(self, container, range):
        """
        CanDeleteRange(container, range) -> bool
        
        Can we delete this range? Sends an event to the control.
        """

    def CanInsertContent(self, container, pos):
        """
        CanInsertContent(container, pos) -> bool
        
        Can we insert content at this position? Sends an event to the control.
        """

    def EnableVerticalScrollbar(self, enable):
        """
        EnableVerticalScrollbar(enable)
        
        Enable or disable the vertical scrollbar.
        """

    def GetVerticalScrollbarEnabled(self):
        """
        GetVerticalScrollbarEnabled() -> bool
        
        Returns true if the vertical scrollbar is enabled.
        """

    def SetFontScale(self, fontScale, refresh=False):
        """
        SetFontScale(fontScale, refresh=False)
        
        Sets the scale factor for displaying fonts, for example for more
        comfortable editing.
        """

    def GetFontScale(self):
        """
        GetFontScale() -> double
        
        Returns the scale factor for displaying fonts, for example for more
        comfortable editing.
        """

    def SetDimensionScale(self, dimScale, refresh=False):
        """
        SetDimensionScale(dimScale, refresh=False)
        
        Sets the scale factor for displaying certain dimensions such as
        indentation and inter-paragraph spacing.
        """

    def GetDimensionScale(self):
        """
        GetDimensionScale() -> double
        
        Returns the scale factor for displaying certain dimensions such as
        indentation and inter-paragraph spacing.
        """

    def SetScale(self, scale, refresh=False):
        """
        SetScale(scale, refresh=False)
        
        Sets an overall scale factor for displaying and editing the content.
        """

    def GetScale(self):
        """
        GetScale() -> double
        
        Returns an overall scale factor for displaying and editing the
        content.
        """

    def GetUnscaledPoint(self, pt):
        """
        GetUnscaledPoint(pt) -> wx.Point
        
        Returns an unscaled point.
        """

    def GetScaledPoint(self, pt):
        """
        GetScaledPoint(pt) -> wx.Point
        
        Returns a scaled point.
        """

    def GetUnscaledSize(self, sz):
        """
        GetUnscaledSize(sz) -> wx.Size
        
        Returns an unscaled size.
        """

    def GetScaledSize(self, sz):
        """
        GetScaledSize(sz) -> wx.Size
        
        Returns a scaled size.
        """

    def GetUnscaledRect(self, rect):
        """
        GetUnscaledRect(rect) -> wx.Rect
        
        Returns an unscaled rectangle.
        """

    def GetScaledRect(self, rect):
        """
        GetScaledRect(rect) -> wx.Rect
        
        Returns a scaled rectangle.
        """

    def GetVirtualAttributesEnabled(self):
        """
        GetVirtualAttributesEnabled() -> bool
        
        Returns true if this control can use virtual attributes and virtual
        text.
        """

    def EnableVirtualAttributes(self, b):
        """
        EnableVirtualAttributes(b)
        
        Pass true to let the control use virtual attributes.
        """

    def Command(self, event):
        """
        Command(event)
        
        Sends the event to the control.
        """

    def OnDropFiles(self, event):
        """
        OnDropFiles(event)
        
        Loads the first dropped file.
        """

    def OnCaptureLost(self, event):
        """
        OnCaptureLost(event)
        """

    def OnSysColourChanged(self, event):
        """
        OnSysColourChanged(event)
        """

    def OnCut(self, event):
        """
        OnCut(event)
        
        Standard handler for the wxID_CUT command.
        """

    def OnCopy(self, event):
        """
        OnCopy(event)
        
        Standard handler for the wxID_COPY command.
        """

    def OnPaste(self, event):
        """
        OnPaste(event)
        
        Standard handler for the wxID_PASTE command.
        """

    def OnUndo(self, event):
        """
        OnUndo(event)
        
        Standard handler for the wxID_UNDO command.
        """

    def OnRedo(self, event):
        """
        OnRedo(event)
        
        Standard handler for the wxID_REDO command.
        """

    def OnSelectAll(self, event):
        """
        OnSelectAll(event)
        
        Standard handler for the wxID_SELECTALL command.
        """

    def OnProperties(self, event):
        """
        OnProperties(event)
        
        Standard handler for property commands.
        """

    def OnClear(self, event):
        """
        OnClear(event)
        
        Standard handler for the wxID_CLEAR command.
        """

    def OnUpdateCut(self, event):
        """
        OnUpdateCut(event)
        
        Standard update handler for the wxID_CUT command.
        """

    def OnUpdateCopy(self, event):
        """
        OnUpdateCopy(event)
        
        Standard update handler for the wxID_COPY command.
        """

    def OnUpdatePaste(self, event):
        """
        OnUpdatePaste(event)
        
        Standard update handler for the wxID_PASTE command.
        """

    def OnUpdateUndo(self, event):
        """
        OnUpdateUndo(event)
        
        Standard update handler for the wxID_UNDO command.
        """

    def OnUpdateRedo(self, event):
        """
        OnUpdateRedo(event)
        
        Standard update handler for the wxID_REDO command.
        """

    def OnUpdateSelectAll(self, event):
        """
        OnUpdateSelectAll(event)
        
        Standard update handler for the wxID_SELECTALL command.
        """

    def OnUpdateProperties(self, event):
        """
        OnUpdateProperties(event)
        
        Standard update handler for property commands.
        """

    def OnUpdateClear(self, event):
        """
        OnUpdateClear(event)
        
        Standard update handler for the wxID_CLEAR command.
        """

    def OnContextMenu(self, event):
        """
        OnContextMenu(event)
        
        Shows a standard context menu with undo, redo, cut, copy, paste,
        clear, and select all commands.
        """

    def OnPaint(self, event):
        """
        OnPaint(event)
        """

    def OnEraseBackground(self, event):
        """
        OnEraseBackground(event)
        """

    def OnLeftClick(self, event):
        """
        OnLeftClick(event)
        """

    def OnLeftUp(self, event):
        """
        OnLeftUp(event)
        """

    def OnMoveMouse(self, event):
        """
        OnMoveMouse(event)
        """

    def OnLeftDClick(self, event):
        """
        OnLeftDClick(event)
        """

    def OnMiddleClick(self, event):
        """
        OnMiddleClick(event)
        """

    def OnRightClick(self, event):
        """
        OnRightClick(event)
        """

    def OnChar(self, event):
        """
        OnChar(event)
        """

    def OnSize(self, event):
        """
        OnSize(event)
        """

    def OnSetFocus(self, event):
        """
        OnSetFocus(event)
        """

    def OnKillFocus(self, event):
        """
        OnKillFocus(event)
        """

    def OnIdle(self, event):
        """
        OnIdle(event)
        """

    def OnScroll(self, event):
        """
        OnScroll(event)
        """

    def SetFont(self, font):
        """
        SetFont(font) -> bool
        
        Sets the font, and also the basic and default attributes (see
        wxRichTextCtrl::SetDefaultStyle).
        """

    def SetupScrollbars(self, atTop=False):
        """
        SetupScrollbars(atTop=False)
        
        A helper function setting up scrollbars, for example after a resize.
        """

    def KeyboardNavigate(self, keyCode, flags):
        """
        KeyboardNavigate(keyCode, flags) -> bool
        
        Helper function implementing keyboard navigation.
        """

    def PaintBackground(self, dc):
        """
        PaintBackground(dc)
        
        Paints the background.
        """

    def PaintAboveContent(self, WXUNUSED):
        """
        PaintAboveContent(WXUNUSED)
        
        Other user defined painting after everything else (i.e. all text) is
        painted.
        """

    def DoWriteText(self, value, flags=0):
        """
        DoWriteText(value, flags=0)
        """

    def ShouldInheritColours(self):
        """
        ShouldInheritColours() -> bool
        
        Return true from here to allow the colours of this window to be
        changed by InheritAttributes().
        """

    def PositionCaret(self, container=None):
        """
        PositionCaret(container=None)
        
        Internal function to position the visible caret according to the
        current caret position.
        """

    def ExtendSelection(self, oldPosition, newPosition, flags):
        """
        ExtendSelection(oldPosition, newPosition, flags) -> bool
        
        Helper function for extending the selection, returning true if the
        selection was changed.
        """

    def ScrollIntoView(self, position, keyCode):
        """
        ScrollIntoView(position, keyCode) -> bool
        
        Scrolls position into view.
        """

    def RefreshForSelectionChange(self, oldSelection, newSelection):
        """
        RefreshForSelectionChange(oldSelection, newSelection) -> bool
        
        Refreshes the area affected by a selection change.
        """

    def SetCaretPosition(self, position, showAtLineStart=False):
        """
        SetCaretPosition(position, showAtLineStart=False)
        
        Sets the caret position.
        """

    def GetCaretPosition(self):
        """
        GetCaretPosition() -> long
        
        Returns the current caret position.
        """

    def GetAdjustedCaretPosition(self, caretPos):
        """
        GetAdjustedCaretPosition(caretPos) -> long
        
        The adjusted caret position is the character position adjusted to take
        into account whether we're at the start of a paragraph, in which case
        style information should be taken from the next position, not current
        one.
        """

    def MoveCaretForward(self, oldPosition):
        """
        MoveCaretForward(oldPosition)
        
        Move the caret one visual step forward: this may mean setting a flag
        and keeping the same position if we're going from the end of one line
        to the start of the next, which may be the exact same caret position.
        """

    def MoveCaretBack(self, oldPosition):
        """
        MoveCaretBack(oldPosition)
        
        Move the caret one visual step forward: this may mean setting a flag
        and keeping the same position if we're going from the end of one line
        to the start of the next, which may be the exact same caret position.
        """

    def GetCaretPositionForIndex(self, position, rect, container=None):
        """
        GetCaretPositionForIndex(position, rect, container=None) -> bool
        
        Returns the caret height and position for the given character
        position.
        """

    def GetVisibleLineForCaretPosition(self, caretPosition):
        """
        GetVisibleLineForCaretPosition(caretPosition) -> RichTextLine
        
        Internal helper function returning the line for the visible caret
        position.
        """

    def GetCommandProcessor(self):
        """
        GetCommandProcessor() -> wx.CommandProcessor
        
        Gets the command processor associated with the control's buffer.
        """

    def DeleteSelectedContent(self, newPos=None):
        """
        DeleteSelectedContent(newPos=None) -> bool
        
        Deletes content if there is a selection, e.g.
        """

    def GetPhysicalPoint(self, ptLogical):
        """
        GetPhysicalPoint(ptLogical) -> wx.Point
        
        Transforms logical (unscrolled) position to physical window position.
        """

    def GetLogicalPoint(self, ptPhysical):
        """
        GetLogicalPoint(ptPhysical) -> wx.Point
        
        Transforms physical window position to logical (unscrolled) position.
        """

    def FindNextWordPosition(self, direction=1):
        """
        FindNextWordPosition(direction=1) -> long
        
        Helper function for finding the caret position for the next word.
        """

    def IsPositionVisible(self, pos):
        """
        IsPositionVisible(pos) -> bool
        
        Returns true if the given position is visible on the screen.
        """

    def GetFirstVisiblePosition(self):
        """
        GetFirstVisiblePosition() -> long
        
        Returns the first visible position in the current view.
        """

    def GetCaretPositionForDefaultStyle(self):
        """
        GetCaretPositionForDefaultStyle() -> long
        
        Returns the caret position since the default formatting was changed.
        """

    def SetCaretPositionForDefaultStyle(self, pos):
        """
        SetCaretPositionForDefaultStyle(pos)
        
        Set the caret position for the default style that the user is
        selecting.
        """

    def IsDefaultStyleShowing(self):
        """
        IsDefaultStyleShowing() -> bool
        
        Returns true if the user has recently set the default style without
        moving the caret, and therefore the UI needs to reflect the default
        style and not the style at the caret.
        """

    def SetAndShowDefaultStyle(self, attr):
        """
        SetAndShowDefaultStyle(attr)
        
        Sets attr as the default style and tells the control that the UI
        should reflect this attribute until the user moves the caret.
        """

    def GetFirstVisiblePoint(self):
        """
        GetFirstVisiblePoint() -> wx.Point
        
        Returns the first visible point in the window.
        """

    def GetValue(self):
        """
        GetValue() -> String
        
        Returns the content of the entire control as a string.
        """

    def SetValue(self, value):
        """
        SetValue(value)
        
        Replaces existing content with the given text.
        """

    def ProcessBackKey(self, event, flags):
        """
        ProcessBackKey(event, flags) -> bool
        
        Processes the back key.
        """

    def FindRangeForList(self, pos, isNumberedList):
        """
        FindRangeForList(pos, isNumberedList) -> RichTextRange
        
        Given a character position at which there is a list style, find the
        range encompassing the same list style by looking backwards and
        forwards.
        """

    def SetCaretPositionAfterClick(self, container, position, hitTestFlags, extendSelection=False):
        """
        SetCaretPositionAfterClick(container, position, hitTestFlags, extendSelection=False) -> bool
        
        Sets up the caret for the given position and container, after a mouse
        click.
        """

    def FindCaretPositionForCharacterPosition(self, position, hitTestFlags, container, caretLineStart):
        """
        FindCaretPositionForCharacterPosition(position, hitTestFlags, container, caretLineStart) -> long
        
        Find the caret position for the combination of hit-test flags and
        character position.
        """

    def ProcessMouseMovement(self, container, obj, position, pos):
        """
        ProcessMouseMovement(container, obj, position, pos) -> bool
        
        Processes mouse movement in order to change the cursor.
        """

    def DoGetValue(self):
        """
        DoGetValue() -> String
        """

    @staticmethod
    def GetAvailableFontNames():
        """
        GetAvailableFontNames() -> ArrayString
        
        Font names take a long time to retrieve, so cache them (on demand).
        """

    @staticmethod
    def ClearAvailableFontNames():
        """
        ClearAvailableFontNames()
        
        Clears the cache of available font names.
        """

    def GetDefaultStyle(self):
        """
        
        """

    def SetMargins(self, *args, **kw):
        """
        SetMargins(pt) -> bool
        SetMargins(left, top=-1) -> bool
        
        Attempts to set the control margins.
        """

    def AutoComplete(self, *args, **kw):
        """
        AutoComplete(choices) -> bool
        AutoComplete(completer) -> bool
        
        Call this function to enable auto-completion of the text typed in a
        single-line text control using the given choices.
        """

    def AutoCompleteFileNames(self):
        """
        AutoCompleteFileNames() -> bool
        
        Call this function to enable auto-completion of the text typed in a
        single-line text control using all valid file system paths.
        """

    def AutoCompleteDirectories(self):
        """
        AutoCompleteDirectories() -> bool
        
        Call this function to enable auto-completion of the text using the
        file system directories.
        """

    def ChangeValue(self, value):
        """
        ChangeValue(value)
        
        Sets the new text control value.
        """

    def IsEmpty(self):
        """
        IsEmpty() -> bool
        
        Returns true if the control is currently empty.
        """

    def SetHint(self, hint):
        """
        SetHint(hint) -> bool
        
        Sets a hint shown in an empty unfocused text control.
        """

    def GetHint(self):
        """
        GetHint() -> String
        
        Returns the current hint string.
        """

    def GetMargins(self):
        """
        GetMargins() -> Point
        
        Returns the margins used by the control.
        """
    BasicStyle = property(None, None)
    Buffer = property(None, None)
    CaretAtLineStart = property(None, None)
    CaretPosition = property(None, None)
    CaretPositionForDefaultStyle = property(None, None)
    CommandProcessor = property(None, None)
    ContextMenu = property(None, None)
    ContextMenuPropertiesInfo = property(None, None)
    DefaultStyle = property(None, None)
    DefaultStyleEx = property(None, None)
    DelayedLayoutThreshold = property(None, None)
    DimensionScale = property(None, None)
    DragStartPoint = property(None, None)
    DragStartTime = property(None, None)
    Dragging = property(None, None)
    Filename = property(None, None)
    FirstVisiblePoint = property(None, None)
    FirstVisiblePosition = property(None, None)
    FocusObject = property(None, None)
    FontScale = property(None, None)
    FullLayoutRequired = property(None, None)
    FullLayoutSavedPosition = property(None, None)
    FullLayoutTime = property(None, None)
    HandlerFlags = property(None, None)
    Hint = property(None, None)
    InsertionPoint = property(None, None)
    InternalSelectionRange = property(None, None)
    LastPosition = property(None, None)
    Margins = property(None, None)
    NumberOfLines = property(None, None)
    PreDrag = property(None, None)
    Scale = property(None, None)
    Selection = property(None, None)
    SelectionAnchor = property(None, None)
    SelectionAnchorObject = property(None, None)
    SelectionRange = property(None, None)
    StringSelection = property(None, None)
    StyleSheet = property(None, None)
    TextCursor = property(None, None)
    URLCursor = property(None, None)
    Value = property(None, None)
    VerticalScrollbarEnabled = property(None, None)
    VirtualAttributesEnabled = property(None, None)

    def DoGetBestSize(self):
        """
        DoGetBestSize() -> wx.Size
        
        Currently this simply returns wxSize(10, 10).
        """

    def DoThaw(self):
        """
        DoThaw()
        """
# end of class RichTextCtrl


class RichTextEvent(wx.NotifyEvent):
    """
    RichTextEvent(commandType=wx.wxEVT_NULL, winid=0)
    RichTextEvent(event)
    
    This is the event class for wxRichTextCtrl notifications.
    """

    def __init__(self, *args, **kw):
        """
        RichTextEvent(commandType=wx.wxEVT_NULL, winid=0)
        RichTextEvent(event)
        
        This is the event class for wxRichTextCtrl notifications.
        """

    def GetPosition(self):
        """
        GetPosition() -> long
        
        Returns the buffer position at which the event occurred.
        """

    def SetPosition(self, pos):
        """
        SetPosition(pos)
        
        Sets the buffer position variable.
        """

    def GetFlags(self):
        """
        GetFlags() -> int
        
        Returns flags indicating modifier keys pressed.
        """

    def SetFlags(self, flags):
        """
        SetFlags(flags)
        
        Sets flags indicating modifier keys pressed.
        """

    def GetOldStyleSheet(self):
        """
        GetOldStyleSheet() -> RichTextStyleSheet
        
        Returns the old style sheet.
        """

    def SetOldStyleSheet(self, sheet):
        """
        SetOldStyleSheet(sheet)
        
        Sets the old style sheet variable.
        """

    def GetNewStyleSheet(self):
        """
        GetNewStyleSheet() -> RichTextStyleSheet
        
        Returns the new style sheet.
        """

    def SetNewStyleSheet(self, sheet):
        """
        SetNewStyleSheet(sheet)
        
        Sets the new style sheet variable.
        """

    def GetRange(self):
        """
        GetRange() -> RichTextRange
        
        Gets the range for the current operation.
        """

    def SetRange(self, range):
        """
        SetRange(range)
        
        Sets the range variable.
        """

    def GetCharacter(self):
        """
        GetCharacter() -> Char
        
        Returns the character pressed, within a wxEVT_RICHTEXT_CHARACTER
        event.
        """

    def SetCharacter(self, ch):
        """
        SetCharacter(ch)
        
        Sets the character variable.
        """

    def GetContainer(self):
        """
        GetContainer() -> RichTextParagraphLayoutBox
        
        Returns the container for which the event is relevant.
        """

    def SetContainer(self, container):
        """
        SetContainer(container)
        
        Sets the container for which the event is relevant.
        """

    def GetOldContainer(self):
        """
        GetOldContainer() -> RichTextParagraphLayoutBox
        
        Returns the old container, for a focus change event.
        """

    def SetOldContainer(self, container):
        """
        SetOldContainer(container)
        
        Sets the old container, for a focus change event.
        """

    def Clone(self):
        """
        Clone() -> wx.Event
        
        Returns a copy of the event.
        """
    Character = property(None, None)
    Container = property(None, None)
    Flags = property(None, None)
    NewStyleSheet = property(None, None)
    OldContainer = property(None, None)
    OldStyleSheet = property(None, None)
    Position = property(None, None)
    Range = property(None, None)
# end of class RichTextEvent


EVT_RICHTEXT_LEFT_CLICK = wx.PyEventBinder(wxEVT_RICHTEXT_LEFT_CLICK)
EVT_RICHTEXT_RIGHT_CLICK = wx.PyEventBinder(wxEVT_RICHTEXT_RIGHT_CLICK)
EVT_RICHTEXT_MIDDLE_CLICK = wx.PyEventBinder(wxEVT_RICHTEXT_MIDDLE_CLICK)
EVT_RICHTEXT_LEFT_DCLICK = wx.PyEventBinder(wxEVT_RICHTEXT_LEFT_DCLICK)
EVT_RICHTEXT_RETURN = wx.PyEventBinder(wxEVT_RICHTEXT_RETURN)
EVT_RICHTEXT_CHARACTER = wx.PyEventBinder(wxEVT_RICHTEXT_CHARACTER)
EVT_RICHTEXT_DELETE = wx.PyEventBinder(wxEVT_RICHTEXT_DELETE)

EVT_RICHTEXT_STYLESHEET_CHANGING = wx.PyEventBinder(wxEVT_RICHTEXT_STYLESHEET_CHANGING)
EVT_RICHTEXT_STYLESHEET_CHANGED = wx.PyEventBinder(wxEVT_RICHTEXT_STYLESHEET_CHANGED)
EVT_RICHTEXT_STYLESHEET_REPLACING = wx.PyEventBinder(wxEVT_RICHTEXT_STYLESHEET_REPLACING)
EVT_RICHTEXT_STYLESHEET_REPLACED = wx.PyEventBinder(wxEVT_RICHTEXT_STYLESHEET_REPLACED)

EVT_RICHTEXT_CONTENT_INSERTED = wx.PyEventBinder(wxEVT_RICHTEXT_CONTENT_INSERTED)
EVT_RICHTEXT_CONTENT_DELETED = wx.PyEventBinder(wxEVT_RICHTEXT_CONTENT_DELETED)
EVT_RICHTEXT_STYLE_CHANGED = wx.PyEventBinder(wxEVT_RICHTEXT_STYLE_CHANGED)
EVT_RICHTEXT_STYLE_CHANGED = wx.PyEventBinder(wxEVT_RICHTEXT_PROPERTIES_CHANGED)
EVT_RICHTEXT_SELECTION_CHANGED = wx.PyEventBinder(wxEVT_RICHTEXT_SELECTION_CHANGED)
EVT_RICHTEXT_BUFFER_RESET = wx.PyEventBinder(wxEVT_RICHTEXT_BUFFER_RESET)
EVT_RICHTEXT_FOCUS_OBJECT_CHANGED = wx.PyEventBinder(wxEVT_RICHTEXT_FOCUS_OBJECT_CHANGED)
#-- end-richtextctrl --#
#-- begin-richtexthtml --#

class RichTextHTMLHandler(RichTextFileHandler):
    """
    RichTextHTMLHandler(name="HTML", ext="html", type=RICHTEXT_TYPE_HTML)
    
    Handles HTML output (only) for wxRichTextCtrl content.
    """

    def __init__(self, name="HTML", ext="html", type=RICHTEXT_TYPE_HTML):
        """
        RichTextHTMLHandler(name="HTML", ext="html", type=RICHTEXT_TYPE_HTML)
        
        Handles HTML output (only) for wxRichTextCtrl content.
        """

    def ClearTemporaryImageLocations(self):
        """
        ClearTemporaryImageLocations()
        
        Clears the image locations generated by the last operation.
        """

    def DeleteTemporaryImages(self, *args, **kw):
        """
        DeleteTemporaryImages() -> bool
        DeleteTemporaryImages(flags, imageLocations) -> bool
        
        Deletes the in-memory or temporary files generated by the last
        operation.
        """

    def GetFontSizeMapping(self):
        """
        GetFontSizeMapping() -> ArrayInt
        
        Returns the mapping for converting point sizes to HTML font sizes.
        """

    def GetTempDir(self):
        """
        GetTempDir() -> String
        
        Returns the directory used to store temporary image files.
        """

    def GetTemporaryImageLocations(self):
        """
        GetTemporaryImageLocations() -> ArrayString
        
        Returns the image locations for the last operation.
        """

    def SetFontSizeMapping(self, fontSizeMapping):
        """
        SetFontSizeMapping(fontSizeMapping)
        
        Sets the mapping for converting point sizes to HTML font sizes.
        """

    def SetTempDir(self, tempDir):
        """
        SetTempDir(tempDir)
        
        Sets the directory for storing temporary files.
        """

    def SetTemporaryImageLocations(self, locations):
        """
        SetTemporaryImageLocations(locations)
        
        Sets the list of image locations generated by the last operation.
        """

    @staticmethod
    def SetFileCounter(counter):
        """
        SetFileCounter(counter)
        
        Reset the file counter, in case, for example, the same names are
        required each time.
        """
    FontSizeMapping = property(None, None)
    TempDir = property(None, None)
    TemporaryImageLocations = property(None, None)
# end of class RichTextHTMLHandler

#-- end-richtexthtml --#
#-- begin-richtextxml --#

class RichTextXMLHandler(RichTextFileHandler):
    """
    RichTextXMLHandler(name="XML", ext="xml", type=RICHTEXT_TYPE_XML)
    
    A handler for loading and saving content in an XML format specific to
    wxRichTextBuffer.
    """

    def __init__(self, name="XML", ext="xml", type=RICHTEXT_TYPE_XML):
        """
        RichTextXMLHandler(name="XML", ext="xml", type=RICHTEXT_TYPE_XML)
        
        A handler for loading and saving content in an XML format specific to
        wxRichTextBuffer.
        """

    def CanLoad(self):
        """
        CanLoad() -> bool
        
        Returns true.
        """

    def CanSave(self):
        """
        CanSave() -> bool
        
        Returns true.
        """

    def ExportXML(self, stream, obj, level):
        """
        ExportXML(stream, obj, level) -> bool
        
        Recursively exports an object to the stream.
        """

    def ImportXML(self, buffer, obj, node):
        """
        ImportXML(buffer, obj, node) -> bool
        
        Recursively imports an object.
        """

    @staticmethod
    def RegisterNodeName(nodeName, className):
        """
        RegisterNodeName(nodeName, className)
        
        Call with XML node name, C++ class name so that wxRTC can read in the
        node.
        """

    @staticmethod
    def ClearNodeToClassMap():
        """
        ClearNodeToClassMap()
        
        Cleans up the mapping between node name and C++ class.
        """
# end of class RichTextXMLHandler

#-- end-richtextxml --#
#-- begin-richtextprint --#
RICHTEXT_PAGE_ODD = 0
RICHTEXT_PAGE_EVEN = 0
RICHTEXT_PAGE_ALL = 0
RICHTEXT_PAGE_LEFT = 0
RICHTEXT_PAGE_CENTRE = 0
RICHTEXT_PAGE_RIGHT = 0

class RichTextHeaderFooterData(wx.Object):
    """
    RichTextHeaderFooterData()
    RichTextHeaderFooterData(data)
    
    This class represents header and footer data to be passed to the
    wxRichTextPrinting and wxRichTextPrintout classes.
    """

    def __init__(self, *args, **kw):
        """
        RichTextHeaderFooterData()
        RichTextHeaderFooterData(data)
        
        This class represents header and footer data to be passed to the
        wxRichTextPrinting and wxRichTextPrintout classes.
        """

    def Clear(self):
        """
        Clear()
        
        Clears all text.
        """

    def Copy(self, data):
        """
        Copy(data)
        
        Copies the data.
        """

    def GetFont(self):
        """
        GetFont() -> wx.Font
        
        Returns the font specified for printing the header and footer.
        """

    def GetFooterMargin(self):
        """
        GetFooterMargin() -> int
        
        Returns the margin between the text and the footer.
        """

    def GetFooterText(self, page=RICHTEXT_PAGE_EVEN, location=RICHTEXT_PAGE_CENTRE):
        """
        GetFooterText(page=RICHTEXT_PAGE_EVEN, location=RICHTEXT_PAGE_CENTRE) -> String
        
        Returns the footer text on odd or even pages, and at a given position
        on the page (left, centre or right).
        """

    def GetHeaderMargin(self):
        """
        GetHeaderMargin() -> int
        
        Returns the margin between the text and the header.
        """

    def GetHeaderText(self, page=RICHTEXT_PAGE_EVEN, location=RICHTEXT_PAGE_CENTRE):
        """
        GetHeaderText(page=RICHTEXT_PAGE_EVEN, location=RICHTEXT_PAGE_CENTRE) -> String
        
        Returns the header text on odd or even pages, and at a given position
        on the page (left, centre or right).
        """

    def GetShowOnFirstPage(self):
        """
        GetShowOnFirstPage() -> bool
        
        Returns true if the header and footer will be shown on the first page.
        """

    def GetText(self, headerFooter, page, location):
        """
        GetText(headerFooter, page, location) -> String
        
        Helper function for getting the header or footer text, odd or even
        pages, and at a given position on the page (left, centre or right).
        """

    def GetTextColour(self):
        """
        GetTextColour() -> wx.Colour
        
        Returns the text colour for drawing the header and footer.
        """

    def Init(self):
        """
        Init()
        
        Initialises the object.
        """

    def SetFont(self, font):
        """
        SetFont(font)
        
        Sets the font for drawing the header and footer.
        """

    def SetFooterText(self, text, page=RICHTEXT_PAGE_ALL, location=RICHTEXT_PAGE_CENTRE):
        """
        SetFooterText(text, page=RICHTEXT_PAGE_ALL, location=RICHTEXT_PAGE_CENTRE)
        
        Sets the footer text on odd or even pages, and at a given position on
        the page (left, centre or right).
        """

    def SetHeaderText(self, text, page=RICHTEXT_PAGE_ALL, location=RICHTEXT_PAGE_CENTRE):
        """
        SetHeaderText(text, page=RICHTEXT_PAGE_ALL, location=RICHTEXT_PAGE_CENTRE)
        
        Sets the header text on odd or even pages, and at a given position on
        the page (left, centre or right).
        """

    def SetMargins(self, headerMargin, footerMargin):
        """
        SetMargins(headerMargin, footerMargin)
        
        Sets the margins between text and header or footer, in tenths of a
        millimeter.
        """

    def SetShowOnFirstPage(self, showOnFirstPage):
        """
        SetShowOnFirstPage(showOnFirstPage)
        
        Pass true to show the header or footer on first page (the default).
        """

    def SetText(self, text, headerFooter, page, location):
        """
        SetText(text, headerFooter, page, location)
        
        Helper function for setting the header or footer text, odd or even
        pages, and at a given position on the page (left, centre or right).
        """

    def SetTextColour(self, col):
        """
        SetTextColour(col)
        
        Sets the text colour for drawing the header and footer.
        """
    Font = property(None, None)
    FooterMargin = property(None, None)
    FooterText = property(None, None)
    HeaderMargin = property(None, None)
    HeaderText = property(None, None)
    ShowOnFirstPage = property(None, None)
    TextColour = property(None, None)
# end of class RichTextHeaderFooterData


class RichTextPrintout(wx.Printout):
    """
    RichTextPrintout(title="Printout")
    
    This class implements print layout for wxRichTextBuffer.
    """

    def __init__(self, title="Printout"):
        """
        RichTextPrintout(title="Printout")
        
        This class implements print layout for wxRichTextBuffer.
        """

    def CalculateScaling(self, dc, textRect, headerRect, footerRect):
        """
        CalculateScaling(dc, textRect, headerRect, footerRect)
        
        Calculates scaling and text, header and footer rectangles.
        """

    def GetHeaderFooterData(self):
        """
        GetHeaderFooterData() -> RichTextHeaderFooterData
        
        Returns the header and footer data associated with the printout.
        """

    def GetPageInfo(self):
        """
        GetPageInfo() -> (minPage, maxPage, selPageFrom, selPageTo)
        
        Gets the page information.
        """

    def GetRichTextBuffer(self):
        """
        GetRichTextBuffer() -> RichTextBuffer
        
        Returns a pointer to the buffer being rendered.
        """

    def HasPage(self, page):
        """
        HasPage(page) -> bool
        
        Returns true if the given page exists in the printout.
        """

    def OnPreparePrinting(self):
        """
        OnPreparePrinting()
        
        Prepares for printing, laying out the buffer and calculating
        pagination.
        """

    def OnPrintPage(self, page):
        """
        OnPrintPage(page) -> bool
        
        Does the actual printing for this page.
        """

    def SetHeaderFooterData(self, data):
        """
        SetHeaderFooterData(data)
        
        Sets the header and footer data associated with the printout.
        """

    def SetMargins(self, top=254, bottom=254, left=254, right=254):
        """
        SetMargins(top=254, bottom=254, left=254, right=254)
        
        Sets margins in 10ths of millimetre.
        """

    def SetRichTextBuffer(self, buffer):
        """
        SetRichTextBuffer(buffer)
        
        Sets the buffer to print.
        """
    HeaderFooterData = property(None, None)
    RichTextBuffer = property(None, None)
# end of class RichTextPrintout


class RichTextPrinting(wx.Object):
    """
    RichTextPrinting(name="Printing", parentWindow=None)
    
    This class provides a simple interface for performing wxRichTextBuffer
    printing and previewing.
    """

    def __init__(self, name="Printing", parentWindow=None):
        """
        RichTextPrinting(name="Printing", parentWindow=None)
        
        This class provides a simple interface for performing wxRichTextBuffer
        printing and previewing.
        """

    def GetFooterText(self, page=RICHTEXT_PAGE_EVEN, location=RICHTEXT_PAGE_CENTRE):
        """
        GetFooterText(page=RICHTEXT_PAGE_EVEN, location=RICHTEXT_PAGE_CENTRE) -> String
        
        A convenience function to get the footer text.
        """

    def GetHeaderFooterData(self):
        """
        GetHeaderFooterData() -> RichTextHeaderFooterData
        
        Returns the internal wxRichTextHeaderFooterData object.
        """

    def GetHeaderText(self, page=RICHTEXT_PAGE_EVEN, location=RICHTEXT_PAGE_CENTRE):
        """
        GetHeaderText(page=RICHTEXT_PAGE_EVEN, location=RICHTEXT_PAGE_CENTRE) -> String
        
        A convenience function to get the header text.
        """

    def GetPageSetupData(self):
        """
        GetPageSetupData() -> wx.PageSetupDialogData
        
        Returns a pointer to the internal page setup data.
        """

    def GetParentWindow(self):
        """
        GetParentWindow() -> wx.Window
        
        Returns the parent window to be used for the preview window and
        printing wait dialog.
        """

    def GetPreviewRect(self):
        """
        GetPreviewRect() -> wx.Rect
        
        Returns the dimensions to be used for the preview window.
        """

    def GetPrintData(self):
        """
        GetPrintData() -> wx.PrintData
        
        Returns a pointer to the internal print data.
        """

    def GetTitle(self):
        """
        GetTitle() -> String
        
        Returns the title of the preview window or printing wait caption.
        """

    def PageSetup(self):
        """
        PageSetup()
        
        Shows the page setup dialog.
        """

    def PreviewBuffer(self, buffer):
        """
        PreviewBuffer(buffer) -> bool
        
        Shows a preview window for the given buffer.
        """

    def PreviewFile(self, richTextFile):
        """
        PreviewFile(richTextFile) -> bool
        
        Shows a preview window for the given file.
        """

    def PrintBuffer(self, buffer, showPrintDialog=True):
        """
        PrintBuffer(buffer, showPrintDialog=True) -> bool
        
        Prints the given buffer.
        """

    def PrintFile(self, richTextFile, showPrintDialog=True):
        """
        PrintFile(richTextFile, showPrintDialog=True) -> bool
        
        Prints the given file.
        """

    def SetFooterText(self, text, page=RICHTEXT_PAGE_ALL, location=RICHTEXT_PAGE_CENTRE):
        """
        SetFooterText(text, page=RICHTEXT_PAGE_ALL, location=RICHTEXT_PAGE_CENTRE)
        
        A convenience function to set the footer text.
        """

    def SetHeaderFooterData(self, data):
        """
        SetHeaderFooterData(data)
        
        Sets the internal wxRichTextHeaderFooterData object.
        """

    def SetHeaderFooterFont(self, font):
        """
        SetHeaderFooterFont(font)
        
        Sets the wxRichTextHeaderFooterData font.
        """

    def SetHeaderFooterTextColour(self, colour):
        """
        SetHeaderFooterTextColour(colour)
        
        Sets the wxRichTextHeaderFooterData text colour.
        """

    def SetHeaderText(self, text, page=RICHTEXT_PAGE_ALL, location=RICHTEXT_PAGE_CENTRE):
        """
        SetHeaderText(text, page=RICHTEXT_PAGE_ALL, location=RICHTEXT_PAGE_CENTRE)
        
        A convenience function to set the header text.
        """

    def SetPageSetupData(self, pageSetupData):
        """
        SetPageSetupData(pageSetupData)
        
        Sets the page setup data.
        """

    def SetParentWindow(self, parent):
        """
        SetParentWindow(parent)
        
        Sets the parent window to be used for the preview window and printing
        wait dialog.
        """

    def SetPreviewRect(self, rect):
        """
        SetPreviewRect(rect)
        
        Sets the dimensions to be used for the preview window.
        """

    def SetPrintData(self, printData):
        """
        SetPrintData(printData)
        
        Sets the print data.
        """

    def SetShowOnFirstPage(self, show):
        """
        SetShowOnFirstPage(show)
        
        Pass true to show the header and footer on the first page.
        """

    def SetTitle(self, title):
        """
        SetTitle(title)
        
        Pass the title of the preview window or printing wait caption.
        """
    FooterText = property(None, None)
    HeaderFooterData = property(None, None)
    HeaderText = property(None, None)
    PageSetupData = property(None, None)
    ParentWindow = property(None, None)
    PreviewRect = property(None, None)
    PrintData = property(None, None)
    Title = property(None, None)
# end of class RichTextPrinting

#-- end-richtextprint --#
#-- begin-richtextstyles --#

class RichTextStyleListCtrl(wx.Control):
    """
    RichTextStyleListCtrl(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0)
    RichTextStyleListCtrl()
    
    This class incorporates a wxRichTextStyleListBox and a choice control
    that allows the user to select the category of style to view.
    """

    def __init__(self, *args, **kw):
        """
        RichTextStyleListCtrl(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0)
        RichTextStyleListCtrl()
        
        This class incorporates a wxRichTextStyleListBox and a choice control
        that allows the user to select the category of style to view.
        """

    def Create(self, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0):
        """
        Create(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0) -> bool
        
        Creates the windows.
        """

    def GetRichTextCtrl(self):
        """
        GetRichTextCtrl() -> RichTextCtrl
        
        Returns the associated rich text control, if any.
        """

    def GetStyleChoice(self):
        """
        GetStyleChoice() -> wx.Choice
        
        Returns the wxChoice control used for selecting the style category.
        """

    def GetStyleListBox(self):
        """
        GetStyleListBox() -> RichTextStyleListBox
        
        Returns the wxListBox control used to view the style list.
        """

    def GetStyleSheet(self):
        """
        GetStyleSheet() -> RichTextStyleSheet
        
        Returns the associated style sheet, if any.
        """

    def GetStyleType(self):
        """
        GetStyleType() -> RichTextStyleListBox.wxRichTextStyleType
        
        Returns the type of style to show in the list box.
        """

    def SetRichTextCtrl(self, ctrl):
        """
        SetRichTextCtrl(ctrl)
        
        Associates the control with a wxRichTextCtrl.
        """

    def SetStyleSheet(self, styleSheet):
        """
        SetStyleSheet(styleSheet)
        
        Associates the control with a style sheet.
        """

    def SetStyleType(self, styleType):
        """
        SetStyleType(styleType)
        
        Sets the style type to display.
        """

    def UpdateStyles(self):
        """
        UpdateStyles()
        
        Updates the style list box.
        """
    RichTextCtrl = property(None, None)
    StyleChoice = property(None, None)
    StyleListBox = property(None, None)
    StyleSheet = property(None, None)
    StyleType = property(None, None)
# end of class RichTextStyleListCtrl


class RichTextStyleListBox(wx.html.HtmlListBox):
    """
    RichTextStyleListBox(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0)
    RichTextStyleListBox()
    
    This is a listbox that can display the styles in a
    wxRichTextStyleSheet, and apply the selection to an associated
    wxRichTextCtrl.
    """
    RICHTEXT_STYLE_ALL = 0
    RICHTEXT_STYLE_PARAGRAPH = 0
    RICHTEXT_STYLE_CHARACTER = 0
    RICHTEXT_STYLE_LIST = 0
    RICHTEXT_STYLE_BOX = 0

    def __init__(self, *args, **kw):
        """
        RichTextStyleListBox(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0)
        RichTextStyleListBox()
        
        This is a listbox that can display the styles in a
        wxRichTextStyleSheet, and apply the selection to an associated
        wxRichTextCtrl.
        """

    def Create(self, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0):
        """
        Create(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0) -> bool
        
        Creates the window.
        """

    def ApplyStyle(self, i):
        """
        ApplyStyle(i)
        
        Applies the ith style to the associated rich text control.
        """

    def ConvertTenthsMMToPixels(self, dc, units):
        """
        ConvertTenthsMMToPixels(dc, units) -> int
        
        Converts units in tenths of a millimetre to device units.
        """

    def CreateHTML(self, styleDef):
        """
        CreateHTML(styleDef) -> String
        
        Creates a suitable HTML fragment for a definition.
        """

    def GetApplyOnSelection(self):
        """
        GetApplyOnSelection() -> bool
        
        If the return value is true, clicking on a style name in the list will
        immediately apply the style to the associated rich text control.
        """

    def GetRichTextCtrl(self):
        """
        GetRichTextCtrl() -> RichTextCtrl
        
        Returns the wxRichTextCtrl associated with this listbox.
        """

    def GetStyle(self, i):
        """
        GetStyle(i) -> RichTextStyleDefinition
        
        Gets a style for a listbox index.
        """

    def GetStyleSheet(self):
        """
        GetStyleSheet() -> RichTextStyleSheet
        
        Returns the style sheet associated with this listbox.
        """

    def GetStyleType(self):
        """
        GetStyleType() -> RichTextStyleListBox.wxRichTextStyleType
        
        Returns the type of style to show in the list box.
        """

    def OnLeftDown(self, event):
        """
        OnLeftDown(event)
        
        Implements left click behaviour, applying the clicked style to the
        wxRichTextCtrl.
        """

    def SetApplyOnSelection(self, applyOnSelection):
        """
        SetApplyOnSelection(applyOnSelection)
        
        If applyOnSelection is true, clicking on a style name in the list will
        immediately apply the style to the associated rich text control.
        """

    def SetRichTextCtrl(self, ctrl):
        """
        SetRichTextCtrl(ctrl)
        
        Associates the listbox with a wxRichTextCtrl.
        """

    def SetStyleSheet(self, styleSheet):
        """
        SetStyleSheet(styleSheet)
        
        Associates the control with a style sheet.
        """

    def SetStyleType(self, styleType):
        """
        SetStyleType(styleType)
        
        Sets the style type to display.
        """

    def UpdateStyles(self):
        """
        UpdateStyles()
        
        Updates the list from the associated style sheet.
        """
    ApplyOnSelection = property(None, None)
    RichTextCtrl = property(None, None)
    StyleSheet = property(None, None)
    StyleType = property(None, None)

    def OnGetItem(self, n):
        """
        OnGetItem(n) -> String
        
        Returns the HTML for this item.
        """
# end of class RichTextStyleListBox


class RichTextStyleComboCtrl(wx.ComboCtrl):
    """
    RichTextStyleComboCtrl(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0)
    RichTextStyleComboCtrl()
    
    This is a combo control that can display the styles in a
    wxRichTextStyleSheet, and apply the selection to an associated
    wxRichTextCtrl.
    """

    def __init__(self, *args, **kw):
        """
        RichTextStyleComboCtrl(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0)
        RichTextStyleComboCtrl()
        
        This is a combo control that can display the styles in a
        wxRichTextStyleSheet, and apply the selection to an associated
        wxRichTextCtrl.
        """

    def Create(self, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0):
        """
        Create(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0) -> bool
        
        Creates the windows.
        """

    def GetRichTextCtrl(self):
        """
        GetRichTextCtrl() -> RichTextCtrl
        
        Returns the wxRichTextCtrl associated with this control.
        """

    def GetStyleSheet(self):
        """
        GetStyleSheet() -> RichTextStyleSheet
        
        Returns the style sheet associated with this control.
        """

    def SetRichTextCtrl(self, ctrl):
        """
        SetRichTextCtrl(ctrl)
        
        Associates the control with a wxRichTextCtrl.
        """

    def SetStyleSheet(self, styleSheet):
        """
        SetStyleSheet(styleSheet)
        
        Associates the control with a style sheet.
        """

    def UpdateStyles(self):
        """
        UpdateStyles()
        
        Updates the combo control from the associated style sheet.
        """
    RichTextCtrl = property(None, None)
    StyleSheet = property(None, None)
# end of class RichTextStyleComboCtrl


class RichTextStyleDefinition(wx.Object):
    """
    RichTextStyleDefinition(name=wx.EmptyString)
    
    This is a base class for paragraph and character styles.
    """

    def __init__(self, name=wx.EmptyString):
        """
        RichTextStyleDefinition(name=wx.EmptyString)
        
        This is a base class for paragraph and character styles.
        """

    def GetStyle(self):
        """
        GetStyle() -> RichTextAttr
        
        Returns the attributes associated with this style.
        """

    def GetBaseStyle(self):
        """
        GetBaseStyle() -> String
        
        Returns the style on which this style is based.
        """

    def GetDescription(self):
        """
        GetDescription() -> String
        
        Returns the style's description.
        """

    def GetName(self):
        """
        GetName() -> String
        
        Returns the style name.
        """

    def GetStyleMergedWithBase(self, sheet):
        """
        GetStyleMergedWithBase(sheet) -> RichTextAttr
        
        Returns the style attributes combined with the attributes of the
        specified base style, if any.
        """

    def SetBaseStyle(self, name):
        """
        SetBaseStyle(name)
        
        Sets the name of the style that this style is based on.
        """

    def SetDescription(self, descr):
        """
        SetDescription(descr)
        
        Sets the style description.
        """

    def SetName(self, name):
        """
        SetName(name)
        
        Sets the name of the style.
        """

    def SetStyle(self, style):
        """
        SetStyle(style)
        
        Sets the attributes for this style.
        """

    def GetProperties(self):
        """
        GetProperties() -> RichTextProperties
        
        Returns the definition's properties.
        """

    def SetProperties(self, props):
        """
        SetProperties(props)
        
        Sets the definition's properties.
        """
    BaseStyle = property(None, None)
    Description = property(None, None)
    Name = property(None, None)
    Properties = property(None, None)
    Style = property(None, None)
# end of class RichTextStyleDefinition


class RichTextParagraphStyleDefinition(RichTextStyleDefinition):
    """
    RichTextParagraphStyleDefinition(name=wx.EmptyString)
    
    This class represents a paragraph style definition, usually added to a
    wxRichTextStyleSheet.
    """

    def __init__(self, name=wx.EmptyString):
        """
        RichTextParagraphStyleDefinition(name=wx.EmptyString)
        
        This class represents a paragraph style definition, usually added to a
        wxRichTextStyleSheet.
        """

    def GetNextStyle(self):
        """
        GetNextStyle() -> String
        
        Returns the style that should normally follow this style.
        """

    def SetNextStyle(self, name):
        """
        SetNextStyle(name)
        
        Sets the style that should normally follow this style.
        """
    NextStyle = property(None, None)
# end of class RichTextParagraphStyleDefinition


class RichTextCharacterStyleDefinition(RichTextStyleDefinition):
    """
    RichTextCharacterStyleDefinition(name=wx.EmptyString)
    
    This class represents a character style definition, usually added to a
    wxRichTextStyleSheet.
    """

    def __init__(self, name=wx.EmptyString):
        """
        RichTextCharacterStyleDefinition(name=wx.EmptyString)
        
        This class represents a character style definition, usually added to a
        wxRichTextStyleSheet.
        """
# end of class RichTextCharacterStyleDefinition


class RichTextListStyleDefinition(RichTextParagraphStyleDefinition):
    """
    RichTextListStyleDefinition(name=wx.EmptyString)
    
    This class represents a list style definition, usually added to a
    wxRichTextStyleSheet.
    """

    def __init__(self, name=wx.EmptyString):
        """
        RichTextListStyleDefinition(name=wx.EmptyString)
        
        This class represents a list style definition, usually added to a
        wxRichTextStyleSheet.
        """

    def CombineWithParagraphStyle(self, indent, paraStyle, styleSheet=None):
        """
        CombineWithParagraphStyle(indent, paraStyle, styleSheet=None) -> RichTextAttr
        
        This function combines the given paragraph style with the list style's
        base attributes and level style matching the given indent, returning
        the combined attributes.
        """

    def FindLevelForIndent(self, indent):
        """
        FindLevelForIndent(indent) -> int
        
        This function finds the level (from 0 to 9) whose indentation
        attribute mostly closely matches indent (expressed in tenths of a
        millimetre).
        """

    def GetCombinedStyle(self, indent, styleSheet=None):
        """
        GetCombinedStyle(indent, styleSheet=None) -> RichTextAttr
        
        This function combines the list style's base attributes and the level
        style matching the given indent, returning the combined attributes.
        """

    def GetCombinedStyleForLevel(self, level, styleSheet=None):
        """
        GetCombinedStyleForLevel(level, styleSheet=None) -> RichTextAttr
        
        This function combines the list style's base attributes and the style
        for the specified level, returning the combined attributes.
        """

    def GetLevelAttributes(self, level):
        """
        GetLevelAttributes(level) -> RichTextAttr
        
        Returns the style for the given level.
        """

    def GetLevelCount(self):
        """
        GetLevelCount() -> int
        
        Returns the number of levels.
        """

    def IsNumbered(self, level):
        """
        IsNumbered(level) -> bool
        
        Returns true if the given level has numbered list attributes.
        """

    def SetLevelAttributes(self, level, attr):
        """
        SetLevelAttributes(level, attr)
        
        Sets the style for the given level.
        """
    LevelCount = property(None, None)
# end of class RichTextListStyleDefinition


class RichTextStyleSheet(wx.Object):
    """
    RichTextStyleSheet()
    
    A style sheet contains named paragraph and character styles that make
    it easy for a user to apply combinations of attributes to a
    wxRichTextCtrl.
    """

    def __init__(self):
        """
        RichTextStyleSheet()
        
        A style sheet contains named paragraph and character styles that make
        it easy for a user to apply combinations of attributes to a
        wxRichTextCtrl.
        """

    def AddCharacterStyle(self, styleDef):
        """
        AddCharacterStyle(styleDef) -> bool
        
        Adds a definition to the character style list.
        """

    def AddListStyle(self, styleDef):
        """
        AddListStyle(styleDef) -> bool
        
        Adds a definition to the list style list.
        """

    def AddParagraphStyle(self, styleDef):
        """
        AddParagraphStyle(styleDef) -> bool
        
        Adds a definition to the paragraph style list.
        """

    def AddStyle(self, styleDef):
        """
        AddStyle(styleDef) -> bool
        
        Adds a definition to the appropriate style list.
        """

    def DeleteStyles(self):
        """
        DeleteStyles()
        
        Deletes all styles.
        """

    def FindCharacterStyle(self, name, recurse=True):
        """
        FindCharacterStyle(name, recurse=True) -> RichTextCharacterStyleDefinition
        
        Finds a character definition by name.
        """

    def FindListStyle(self, name, recurse=True):
        """
        FindListStyle(name, recurse=True) -> RichTextListStyleDefinition
        
        Finds a list definition by name.
        """

    def FindParagraphStyle(self, name, recurse=True):
        """
        FindParagraphStyle(name, recurse=True) -> RichTextParagraphStyleDefinition
        
        Finds a paragraph definition by name.
        """

    def FindStyle(self, name):
        """
        FindStyle(name) -> RichTextStyleDefinition
        
        Finds a style definition by name.
        """

    def GetCharacterStyle(self, n):
        """
        GetCharacterStyle(n) -> RichTextCharacterStyleDefinition
        
        Returns the nth character style.
        """

    def GetCharacterStyleCount(self):
        """
        GetCharacterStyleCount() -> size_t
        
        Returns the number of character styles.
        """

    def GetDescription(self):
        """
        GetDescription() -> String
        
        Returns the style sheet's description.
        """

    def GetListStyle(self, n):
        """
        GetListStyle(n) -> RichTextListStyleDefinition
        
        Returns the nth list style.
        """

    def GetListStyleCount(self):
        """
        GetListStyleCount() -> size_t
        
        Returns the number of list styles.
        """

    def GetName(self):
        """
        GetName() -> String
        
        Returns the style sheet's name.
        """

    def GetParagraphStyle(self, n):
        """
        GetParagraphStyle(n) -> RichTextParagraphStyleDefinition
        
        Returns the nth paragraph style.
        """

    def GetParagraphStyleCount(self):
        """
        GetParagraphStyleCount() -> size_t
        
        Returns the number of paragraph styles.
        """

    def RemoveCharacterStyle(self, styleDef, deleteStyle=False):
        """
        RemoveCharacterStyle(styleDef, deleteStyle=False) -> bool
        
        Removes a character style.
        """

    def RemoveListStyle(self, styleDef, deleteStyle=False):
        """
        RemoveListStyle(styleDef, deleteStyle=False) -> bool
        
        Removes a list style.
        """

    def RemoveParagraphStyle(self, styleDef, deleteStyle=False):
        """
        RemoveParagraphStyle(styleDef, deleteStyle=False) -> bool
        
        Removes a paragraph style.
        """

    def RemoveStyle(self, styleDef, deleteStyle=False):
        """
        RemoveStyle(styleDef, deleteStyle=False) -> bool
        
        Removes a style.
        """

    def SetDescription(self, descr):
        """
        SetDescription(descr)
        
        Sets the style sheet's description.
        """

    def SetName(self, name):
        """
        SetName(name)
        
        Sets the style sheet's name.
        """

    def GetProperties(self):
        """
        GetProperties() -> RichTextProperties
        
        Returns the sheet's properties.
        """

    def SetProperties(self, props):
        """
        SetProperties(props)
        
        Sets the sheet's properties.
        """
    CharacterStyleCount = property(None, None)
    Description = property(None, None)
    ListStyleCount = property(None, None)
    Name = property(None, None)
    ParagraphStyleCount = property(None, None)
    Properties = property(None, None)
# end of class RichTextStyleSheet

#-- end-richtextstyles --#
#-- begin-richtextstyledlg --#
RICHTEXT_ORGANISER_DELETE_STYLES = 0
RICHTEXT_ORGANISER_CREATE_STYLES = 0
RICHTEXT_ORGANISER_APPLY_STYLES = 0
RICHTEXT_ORGANISER_EDIT_STYLES = 0
RICHTEXT_ORGANISER_RENAME_STYLES = 0
RICHTEXT_ORGANISER_OK_CANCEL = 0
RICHTEXT_ORGANISER_RENUMBER = 0
RICHTEXT_ORGANISER_SHOW_CHARACTER = 0
RICHTEXT_ORGANISER_SHOW_PARAGRAPH = 0
RICHTEXT_ORGANISER_SHOW_LIST = 0
RICHTEXT_ORGANISER_SHOW_BOX = 0
RICHTEXT_ORGANISER_SHOW_ALL = 0
RICHTEXT_ORGANISER_ORGANISE = 0
RICHTEXT_ORGANISER_BROWSE = 0
RICHTEXT_ORGANISER_BROWSE_NUMBERING = 0

class RichTextStyleOrganiserDialog(wx.Dialog):
    """
    RichTextStyleOrganiserDialog()
    RichTextStyleOrganiserDialog(flags, sheet, ctrl, parent, id=wx.ID_ANY, caption=_("StyleOrganiser"), pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.DEFAULT_DIALOG_STYLE|wx.RESIZE_BORDER|wx.SYSTEM_MENU|wx.CLOSE_BOX)
    
    This class shows a style sheet and allows the user to edit, add and
    remove styles.
    """

    def __init__(self, *args, **kw):
        """
        RichTextStyleOrganiserDialog()
        RichTextStyleOrganiserDialog(flags, sheet, ctrl, parent, id=wx.ID_ANY, caption=_("StyleOrganiser"), pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.DEFAULT_DIALOG_STYLE|wx.RESIZE_BORDER|wx.SYSTEM_MENU|wx.CLOSE_BOX)
        
        This class shows a style sheet and allows the user to edit, add and
        remove styles.
        """

    def ApplyStyle(self, ctrl=None):
        """
        ApplyStyle(ctrl=None) -> bool
        
        Applies the selected style to selection in the given control or the
        control passed to the constructor.
        """

    def Create(self, flags, sheet, ctrl, parent, id=wx.ID_ANY, caption=wx.GetTranslation("StyleOrganiser"), pos=wx.DefaultPosition, size=wx.Size(400,300), style=wx.DEFAULT_DIALOG_STYLE|wx.RESIZE_BORDER|wx.SYSTEM_MENU|wx.CLOSE_BOX):
        """
        Create(flags, sheet, ctrl, parent, id=wx.ID_ANY, caption=wx.GetTranslation("StyleOrganiser"), pos=wx.DefaultPosition, size=wx.Size(400,300), style=wx.DEFAULT_DIALOG_STYLE|wx.RESIZE_BORDER|wx.SYSTEM_MENU|wx.CLOSE_BOX) -> bool
        
        Creates the dialog.
        """

    def GetRestartNumbering(self):
        """
        GetRestartNumbering() -> bool
        
        Returns true if the user has opted to restart numbering.
        """

    def GetRichTextCtrl(self):
        """
        GetRichTextCtrl() -> RichTextCtrl
        
        Returns the associated rich text control (if any).
        """

    def GetSelectedStyle(self):
        """
        GetSelectedStyle() -> String
        
        Returns selected style name.
        """

    def GetSelectedStyleDefinition(self):
        """
        GetSelectedStyleDefinition() -> RichTextStyleDefinition
        
        Returns selected style definition.
        """

    def GetStyleSheet(self):
        """
        GetStyleSheet() -> RichTextStyleSheet
        
        Returns the associated style sheet.
        """

    def SetFlags(self, flags):
        """
        SetFlags(flags)
        
        Sets the flags used to control the interface presented to the user.
        """

    def SetRestartNumbering(self, restartNumbering):
        """
        SetRestartNumbering(restartNumbering)
        
        Checks or unchecks the restart numbering checkbox.
        """

    def SetRichTextCtrl(self, ctrl):
        """
        SetRichTextCtrl(ctrl)
        
        Sets the control to be associated with the dialog, for the purposes of
        applying a style to the selection.
        """

    def SetStyleSheet(self, sheet):
        """
        SetStyleSheet(sheet)
        
        Sets the associated style sheet.
        """

    def GetFlags(self):
        """
        GetFlags() -> int
        
        Returns the flags used to control the interface presented to the user.
        """

    @staticmethod
    def SetShowToolTips(show):
        """
        SetShowToolTips(show)
        
        Determines whether tooltips will be shown.
        """
    Flags = property(None, None)
    RestartNumbering = property(None, None)
    RichTextCtrl = property(None, None)
    SelectedStyle = property(None, None)
    SelectedStyleDefinition = property(None, None)
    StyleSheet = property(None, None)
# end of class RichTextStyleOrganiserDialog

#-- end-richtextstyledlg --#
#-- begin-richtextsymboldlg --#

class SymbolPickerDialog(wx.Dialog):
    """
    SymbolPickerDialog()
    SymbolPickerDialog(symbol, initialFont, normalTextFont, parent, id=wx.ID_ANY, title=_("Symbols"), pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.DEFAULT_DIALOG_STYLE|wx.RESIZE_BORDER|wx.CLOSE_BOX)
    
    wxSymbolPickerDialog presents the user with a choice of fonts and a
    grid of available characters.
    """

    def __init__(self, *args, **kw):
        """
        SymbolPickerDialog()
        SymbolPickerDialog(symbol, initialFont, normalTextFont, parent, id=wx.ID_ANY, title=_("Symbols"), pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.DEFAULT_DIALOG_STYLE|wx.RESIZE_BORDER|wx.CLOSE_BOX)
        
        wxSymbolPickerDialog presents the user with a choice of fonts and a
        grid of available characters.
        """

    def Create(self, symbol, initialFont, normalTextFont, parent, id=wx.ID_ANY, caption=wx.GetTranslation("Symbols"), pos=wx.DefaultPosition, size=wx.Size(400,300), style=wx.DEFAULT_DIALOG_STYLE|wx.RESIZE_BORDER|wx.CLOSE_BOX):
        """
        Create(symbol, initialFont, normalTextFont, parent, id=wx.ID_ANY, caption=wx.GetTranslation("Symbols"), pos=wx.DefaultPosition, size=wx.Size(400,300), style=wx.DEFAULT_DIALOG_STYLE|wx.RESIZE_BORDER|wx.CLOSE_BOX) -> bool
        
        Creation: see the constructor for details about the parameters.
        """

    def GetFontName(self):
        """
        GetFontName() -> String
        
        Returns the font name (the font reflected in the font list).
        """

    def GetFromUnicode(self):
        """
        GetFromUnicode() -> bool
        
        Returns true if the dialog is showing the full range of Unicode
        characters.
        """

    def GetNormalTextFontName(self):
        """
        GetNormalTextFontName() -> String
        
        Gets the font name used for displaying symbols in the absence of a
        selected font.
        """

    def GetSymbol(self):
        """
        GetSymbol() -> String
        
        Gets the current or initial symbol as a string.
        """

    def GetSymbolChar(self):
        """
        GetSymbolChar() -> int
        
        Gets the selected symbol character as an integer.
        """

    def HasSelection(self):
        """
        HasSelection() -> bool
        
        Returns true if a symbol is selected.
        """

    def SetFontName(self, value):
        """
        SetFontName(value)
        
        Sets the initial/selected font name.
        """

    def SetFromUnicode(self, value):
        """
        SetFromUnicode(value)
        
        Sets the internal flag indicating that the full Unicode range should
        be displayed.
        """

    def SetNormalTextFontName(self, value):
        """
        SetNormalTextFontName(value)
        
        Sets the name of the font to be used in the absence of a selected
        font.
        """

    def SetSymbol(self, value):
        """
        SetSymbol(value)
        
        Sets the symbol as a one or zero character string.
        """

    def SetUnicodeMode(self, unicodeMode):
        """
        SetUnicodeMode(unicodeMode)
        
        Sets Unicode display mode.
        """

    def UseNormalFont(self):
        """
        UseNormalFont() -> bool
        
        Returns true if the has specified normal text - that is, there is no
        selected font.
        """
    FontName = property(None, None)
    FromUnicode = property(None, None)
    NormalTextFontName = property(None, None)
    Symbol = property(None, None)
    SymbolChar = property(None, None)
# end of class SymbolPickerDialog

#-- end-richtextsymboldlg --#
#-- begin-richtextformatdlg --#
RICHTEXT_FORMAT_STYLE_EDITOR = 0
RICHTEXT_FORMAT_FONT = 0
RICHTEXT_FORMAT_TABS = 0
RICHTEXT_FORMAT_BULLETS = 0
RICHTEXT_FORMAT_INDENTS_SPACING = 0

class RichTextFormattingDialogFactory(wx.Object):
    """
    RichTextFormattingDialogFactory()
    
    This class provides pages for wxRichTextFormattingDialog, and allows
    other customization of the dialog.
    """

    def __init__(self):
        """
        RichTextFormattingDialogFactory()
        
        This class provides pages for wxRichTextFormattingDialog, and allows
        other customization of the dialog.
        """

    def CreateButtons(self, dialog):
        """
        CreateButtons(dialog) -> bool
        
        Creates the main dialog buttons.
        """

    def CreatePage(self, page, title, dialog):
        """
        CreatePage(page, title, dialog) -> wx.Panel
        
        Creates a page, given a page identifier.
        """

    def CreatePages(self, pages, dialog):
        """
        CreatePages(pages, dialog) -> bool
        
        Creates all pages under the dialog's book control, also calling
        AddPage().
        """

    def GetPageId(self, i):
        """
        GetPageId(i) -> int
        
        Enumerate all available page identifiers.
        """

    def GetPageIdCount(self):
        """
        GetPageIdCount() -> int
        
        Gets the number of available page identifiers.
        """

    def GetPageImage(self, id):
        """
        GetPageImage(id) -> int
        
        Gets the image index for the given page identifier.
        """

    def SetSheetStyle(self, dialog):
        """
        SetSheetStyle(dialog) -> bool
        
        Set the property sheet style, called at the start of
        wxRichTextFormattingDialog::Create.
        """

    def ShowHelp(self, page, dialog):
        """
        ShowHelp(page, dialog) -> bool
        
        Invokes help for the dialog.
        """
    PageIdCount = property(None, None)
# end of class RichTextFormattingDialogFactory


class RichTextFormattingDialog(wx.adv.PropertySheetDialog):
    """
    RichTextFormattingDialog()
    RichTextFormattingDialog(flags, parent, title="Formatting", id=wx.ID_ANY, pos=wx.DefaultPosition, sz=wx.DefaultSize, style=wx.DEFAULT_DIALOG_STYLE)
    
    This dialog allows the user to edit a character and/or paragraph
    style.
    """
    Option_AllowPixelFontSize = 0

    def __init__(self, *args, **kw):
        """
        RichTextFormattingDialog()
        RichTextFormattingDialog(flags, parent, title="Formatting", id=wx.ID_ANY, pos=wx.DefaultPosition, sz=wx.DefaultSize, style=wx.DEFAULT_DIALOG_STYLE)
        
        This dialog allows the user to edit a character and/or paragraph
        style.
        """

    def GetAttributes(self):
        """
        GetAttributes() -> wx.TextAttr
        
        Gets the attributes being edited.
        """

    def ApplyStyle(self, ctrl, range, flags=RICHTEXT_SETSTYLE_WITH_UNDO|RICHTEXT_SETSTYLE_OPTIMIZE):
        """
        ApplyStyle(ctrl, range, flags=RICHTEXT_SETSTYLE_WITH_UNDO|RICHTEXT_SETSTYLE_OPTIMIZE) -> bool
        
        Apply attributes to the given range, only changing attributes that
        need to be changed.
        """

    def Create(self, flags, parent, title=wx.GetTranslation("Formatting"), id=wx.ID_ANY, pos=wx.DefaultPosition, sz=wx.DefaultSize, style=wx.DEFAULT_DIALOG_STYLE):
        """
        Create(flags, parent, title=wx.GetTranslation("Formatting"), id=wx.ID_ANY, pos=wx.DefaultPosition, sz=wx.DefaultSize, style=wx.DEFAULT_DIALOG_STYLE) -> bool
        
        Creation: see wxRichTextFormattingDialog() "the constructor" for
        details about the parameters.
        """

    def GetImageList(self):
        """
        GetImageList() -> wx.ImageList
        
        Returns the image list associated with the dialog, used for example if
        showing the dialog as a toolbook.
        """

    def GetStyle(self, ctrl, range):
        """
        GetStyle(ctrl, range) -> bool
        
        Gets common attributes from the given range and calls SetAttributes().
        """

    def GetStyleDefinition(self):
        """
        GetStyleDefinition() -> RichTextStyleDefinition
        
        Gets the associated style definition, if any.
        """

    def GetStyleSheet(self):
        """
        GetStyleSheet() -> RichTextStyleSheet
        
        Gets the associated style sheet, if any.
        """

    def SetAttributes(self, attr):
        """
        SetAttributes(attr)
        
        Sets the attributes to be edited.
        """

    def SetOptions(self, options):
        """
        SetOptions(options)
        
        Sets the dialog options, determining what the interface presents to
        the user.
        """

    def GetOptions(self):
        """
        GetOptions() -> int
        
        Gets the dialog options, determining what the interface presents to
        the user.
        """

    def HasOption(self, option):
        """
        HasOption(option) -> bool
        
        Returns true if the given option is present.
        """

    def SetImageList(self, imageList):
        """
        SetImageList(imageList)
        
        Sets the image list associated with the dialog's property sheet.
        """

    def SetStyle(self, style, update=True):
        """
        SetStyle(style, update=True) -> bool
        
        Sets the attributes and optionally updates the display, if update is
        true.
        """

    def SetStyleDefinition(self, styleDef, sheet, update=True):
        """
        SetStyleDefinition(styleDef, sheet, update=True) -> bool
        
        Sets the style definition and optionally update the display, if update
        is true.
        """

    def UpdateDisplay(self):
        """
        UpdateDisplay() -> bool
        
        Updates the display.
        """

    @staticmethod
    def GetDialog(win):
        """
        GetDialog(win) -> RichTextFormattingDialog
        
        Helper for pages to get the top-level dialog.
        """

    @staticmethod
    def GetDialogAttributes(win):
        """
        GetDialogAttributes(win) -> wx.TextAttr
        
        Helper for pages to get the attributes.
        """

    @staticmethod
    def GetDialogStyleDefinition(win):
        """
        GetDialogStyleDefinition(win) -> RichTextStyleDefinition
        
        Helper for pages to get the style.
        """

    @staticmethod
    def GetFormattingDialogFactory():
        """
        GetFormattingDialogFactory() -> RichTextFormattingDialogFactory
        
        Returns the object to be used to customize the dialog and provide
        pages.
        """

    @staticmethod
    def SetFormattingDialogFactory(factory):
        """
        SetFormattingDialogFactory(factory)
        
        Sets the formatting factory object to be used for customization and
        page creation.
        """
    Attributes = property(None, None)
    ImageList = property(None, None)
    Options = property(None, None)
    StyleDefinition = property(None, None)
    StyleSheet = property(None, None)
# end of class RichTextFormattingDialog

#-- end-richtextformatdlg --#
