/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.2
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/accel.h>

        #include <wx/menuitem.h>


PyDoc_STRVAR(doc_wxAcceleratorEntry_GetCommand, "GetCommand() -> int\n"
    "\n"
    "Returns the command identifier for the accelerator table entry.");

extern "C" {static PyObject *meth_wxAcceleratorEntry_GetCommand(PyObject *, PyObject *);}
static PyObject *meth_wxAcceleratorEntry_GetCommand(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAcceleratorEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAcceleratorEntry, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetCommand();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AcceleratorEntry, sipName_GetCommand, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAcceleratorEntry_GetFlags, "GetFlags() -> int\n"
    "\n"
    "Returns the flags for the accelerator table entry.");

extern "C" {static PyObject *meth_wxAcceleratorEntry_GetFlags(PyObject *, PyObject *);}
static PyObject *meth_wxAcceleratorEntry_GetFlags(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAcceleratorEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAcceleratorEntry, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFlags();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AcceleratorEntry, sipName_GetFlags, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAcceleratorEntry_GetKeyCode, "GetKeyCode() -> int\n"
    "\n"
    "Returns the keycode for the accelerator table entry.");

extern "C" {static PyObject *meth_wxAcceleratorEntry_GetKeyCode(PyObject *, PyObject *);}
static PyObject *meth_wxAcceleratorEntry_GetKeyCode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAcceleratorEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAcceleratorEntry, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetKeyCode();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AcceleratorEntry, sipName_GetKeyCode, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAcceleratorEntry_GetMenuItem, "GetMenuItem() -> MenuItem\n"
    "\n"
    "Returns the menu item associated with this accelerator entry.");

extern "C" {static PyObject *meth_wxAcceleratorEntry_GetMenuItem(PyObject *, PyObject *);}
static PyObject *meth_wxAcceleratorEntry_GetMenuItem(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAcceleratorEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAcceleratorEntry, &sipCpp))
        {
             ::wxMenuItem*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetMenuItem();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxMenuItem,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AcceleratorEntry, sipName_GetMenuItem, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAcceleratorEntry_Set, "Set(flags, keyCode, cmd, item=None)\n"
    "\n"
    "Sets the accelerator entry parameters.");

extern "C" {static PyObject *meth_wxAcceleratorEntry_Set(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAcceleratorEntry_Set(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int flags;
        int keyCode;
        int cmd;
         ::wxMenuItem* item = 0;
         ::wxAcceleratorEntry *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
            sipName_keyCode,
            sipName_cmd,
            sipName_item,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Biii|J8", &sipSelf, sipType_wxAcceleratorEntry, &sipCpp, &flags, &keyCode, &cmd, sipType_wxMenuItem, &item))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Set(flags,keyCode,cmd,item);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AcceleratorEntry, sipName_Set, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAcceleratorEntry_IsOk, "IsOk() -> bool\n"
    "\n"
    "Returns true if this object is correctly initialized.");

extern "C" {static PyObject *meth_wxAcceleratorEntry_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxAcceleratorEntry_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAcceleratorEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAcceleratorEntry, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AcceleratorEntry, sipName_IsOk, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAcceleratorEntry_ToString, "ToString() -> String\n"
    "\n"
    "Returns a textual representation of this accelerator.");

extern "C" {static PyObject *meth_wxAcceleratorEntry_ToString(PyObject *, PyObject *);}
static PyObject *meth_wxAcceleratorEntry_ToString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAcceleratorEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAcceleratorEntry, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->ToString());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AcceleratorEntry, sipName_ToString, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAcceleratorEntry_ToRawString, "ToRawString() -> String\n"
    "\n"
    "Returns a textual representation of this accelerator which is\n"
    "appropriate for saving in configuration files.");

extern "C" {static PyObject *meth_wxAcceleratorEntry_ToRawString(PyObject *, PyObject *);}
static PyObject *meth_wxAcceleratorEntry_ToRawString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxAcceleratorEntry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAcceleratorEntry, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->ToRawString());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AcceleratorEntry, sipName_ToRawString, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxAcceleratorEntry_FromString, "FromString(str) -> bool\n"
    "\n"
    "Parses the given string and sets the accelerator accordingly.");

extern "C" {static PyObject *meth_wxAcceleratorEntry_FromString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAcceleratorEntry_FromString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* str;
        int strState = 0;
         ::wxAcceleratorEntry *sipCpp;

        static const char *sipKwdList[] = {
            sipName_str,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxAcceleratorEntry, &sipCpp, sipType_wxString,&str, &strState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->FromString(*str);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(str),sipType_wxString,strState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AcceleratorEntry, sipName_FromString, NULL);

    return NULL;
}


extern "C" {static PyObject *slot_wxAcceleratorEntry___ne__(PyObject *,PyObject *);}
static PyObject *slot_wxAcceleratorEntry___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxAcceleratorEntry *sipCpp = reinterpret_cast< ::wxAcceleratorEntry *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxAcceleratorEntry));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxAcceleratorEntry* entry;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxAcceleratorEntry, &entry))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxAcceleratorEntry::operator!=(*entry);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, ne_slot, sipType_wxAcceleratorEntry, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxAcceleratorEntry___eq__(PyObject *,PyObject *);}
static PyObject *slot_wxAcceleratorEntry___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxAcceleratorEntry *sipCpp = reinterpret_cast< ::wxAcceleratorEntry *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxAcceleratorEntry));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxAcceleratorEntry* entry;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxAcceleratorEntry, &entry))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxAcceleratorEntry::operator==(*entry);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, eq_slot, sipType_wxAcceleratorEntry, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_wxAcceleratorEntry(void *, int);}
static void release_wxAcceleratorEntry(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxAcceleratorEntry *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxAcceleratorEntry(void *, SIP_SSIZE_T, const void *);}
static void assign_wxAcceleratorEntry(void *sipDst, SIP_SSIZE_T sipDstIdx, const void *sipSrc)
{
    reinterpret_cast< ::wxAcceleratorEntry *>(sipDst)[sipDstIdx] = *reinterpret_cast<const  ::wxAcceleratorEntry *>(sipSrc);
}


extern "C" {static void *array_wxAcceleratorEntry(SIP_SSIZE_T);}
static void *array_wxAcceleratorEntry(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxAcceleratorEntry[sipNrElem];
}


extern "C" {static void *copy_wxAcceleratorEntry(const void *, SIP_SSIZE_T);}
static void *copy_wxAcceleratorEntry(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxAcceleratorEntry(reinterpret_cast<const  ::wxAcceleratorEntry *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxAcceleratorEntry(sipSimpleWrapper *);}
static void dealloc_wxAcceleratorEntry(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxAcceleratorEntry(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxAcceleratorEntry(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxAcceleratorEntry(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxAcceleratorEntry *sipCpp = 0;

    {
        int flags = 0;
        int keyCode = 0;
        int cmd = 0;
         ::wxMenuItem* item = 0;

        static const char *sipKwdList[] = {
            sipName_flags,
            sipName_keyCode,
            sipName_cmd,
            sipName_item,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|iiiJ8", &flags, &keyCode, &cmd, sipType_wxMenuItem, &item))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxAcceleratorEntry(flags,keyCode,cmd,item);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxAcceleratorEntry* entry;

        static const char *sipKwdList[] = {
            sipName_entry,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxAcceleratorEntry, &entry))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxAcceleratorEntry(*entry);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxAcceleratorEntry[] = {
    {(void *)slot_wxAcceleratorEntry___ne__, ne_slot},
    {(void *)slot_wxAcceleratorEntry___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxAcceleratorEntry[] = {
    {SIP_MLNAME_CAST(sipName_FromString), (PyCFunction)meth_wxAcceleratorEntry_FromString, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAcceleratorEntry_FromString)},
    {SIP_MLNAME_CAST(sipName_GetCommand), meth_wxAcceleratorEntry_GetCommand, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAcceleratorEntry_GetCommand)},
    {SIP_MLNAME_CAST(sipName_GetFlags), meth_wxAcceleratorEntry_GetFlags, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAcceleratorEntry_GetFlags)},
    {SIP_MLNAME_CAST(sipName_GetKeyCode), meth_wxAcceleratorEntry_GetKeyCode, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAcceleratorEntry_GetKeyCode)},
    {SIP_MLNAME_CAST(sipName_GetMenuItem), meth_wxAcceleratorEntry_GetMenuItem, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAcceleratorEntry_GetMenuItem)},
    {SIP_MLNAME_CAST(sipName_IsOk), meth_wxAcceleratorEntry_IsOk, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAcceleratorEntry_IsOk)},
    {SIP_MLNAME_CAST(sipName_Set), (PyCFunction)meth_wxAcceleratorEntry_Set, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAcceleratorEntry_Set)},
    {SIP_MLNAME_CAST(sipName_ToRawString), meth_wxAcceleratorEntry_ToRawString, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAcceleratorEntry_ToRawString)},
    {SIP_MLNAME_CAST(sipName_ToString), meth_wxAcceleratorEntry_ToString, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAcceleratorEntry_ToString)}
};

sipVariableDef variables_wxAcceleratorEntry[] = {
    {PropertyVariable, sipName_MenuItem, &methods_wxAcceleratorEntry[4], NULL, NULL, NULL},
    {PropertyVariable, sipName_KeyCode, &methods_wxAcceleratorEntry[3], NULL, NULL, NULL},
    {PropertyVariable, sipName_Flags, &methods_wxAcceleratorEntry[2], NULL, NULL, NULL},
    {PropertyVariable, sipName_Command, &methods_wxAcceleratorEntry[1], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxAcceleratorEntry, "AcceleratorEntry(flags=0, keyCode=0, cmd=0, item=None)\n"
    "AcceleratorEntry(entry)\n"
    "\n"
    "An object used by an application wishing to create an accelerator\n"
    "table (see wxAcceleratorTable).");


sipClassTypeDef sipTypeDef__core_wxAcceleratorEntry = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxAcceleratorEntry,
        {0},
        0
    },
    {
        sipNameNr_AcceleratorEntry,
        {0, 0, 1},
        9, methods_wxAcceleratorEntry,
        0, 0,
        4, variables_wxAcceleratorEntry,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxAcceleratorEntry,
    -1,
    -1,
    0,
    slots_wxAcceleratorEntry,
    init_type_wxAcceleratorEntry,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxAcceleratorEntry,
    assign_wxAcceleratorEntry,
    array_wxAcceleratorEntry,
    copy_wxAcceleratorEntry,
    release_wxAcceleratorEntry,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
