/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.2
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"




extern "C" {static void assign_wxArrayDouble(void *, SIP_SSIZE_T, const void *);}
static void assign_wxArrayDouble(void *sipDst, SIP_SSIZE_T sipDstIdx, const void *sipSrc)
{
    reinterpret_cast< ::wxArrayDouble *>(sipDst)[sipDstIdx] = *reinterpret_cast<const  ::wxArrayDouble *>(sipSrc);
}


extern "C" {static void *array_wxArrayDouble(SIP_SSIZE_T);}
static void *array_wxArrayDouble(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxArrayDouble[sipNrElem];
}


extern "C" {static void *copy_wxArrayDouble(const void *, SIP_SSIZE_T);}
static void *copy_wxArrayDouble(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxArrayDouble(reinterpret_cast<const  ::wxArrayDouble *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_wxArrayDouble(void *, int);}
static void release_wxArrayDouble(void *ptr, int)
{
    Py_BEGIN_ALLOW_THREADS
    delete reinterpret_cast< ::wxArrayDouble *>(ptr);
    Py_END_ALLOW_THREADS
}



extern "C" {static int convertTo_wxArrayDouble(PyObject *, void **, int *, PyObject *);}
static int convertTo_wxArrayDouble(PyObject *sipPy,void **sipCppPtrV,int *sipIsErr,PyObject *sipTransferObj)
{
     ::wxArrayDouble **sipCppPtr = reinterpret_cast< ::wxArrayDouble **>(sipCppPtrV);

        // Code to test a PyObject for compatibility
        if (!sipIsErr) {
            int success = TRUE;
            // ensure that it is a sequence
            if (! PySequence_Check(sipPy))
                success = FALSE;
            // ensure each item is a number object
            else {
                Py_ssize_t i, len = PySequence_Length(sipPy);
                for (i=0; i<len; i++) {
                    PyObject* item = PySequence_GetItem(sipPy, i);
                    if (!PyNumber_Check(item)) {
                        Py_DECREF(item);
                        success = FALSE;
                        break;
                    }
                    Py_DECREF(item);
                }
            }
            if (!success)
                PyErr_SetString(PyExc_TypeError, "Sequence of numbers expected.");
            return success;
        }

        // Code to create a new wxArrayDouble and convert a compatible PyObject
        wxArrayDouble *array = new wxArrayDouble;
        Py_ssize_t i, len = PySequence_Length(sipPy);
        for (i=0; i<len; i++) {
            PyObject* item = PySequence_GetItem(sipPy, i);
            PyObject* number = PyNumber_Float(item);
            if (PyErr_Occurred()) {
                *sipIsErr = 1;
                delete array;
                Py_DECREF(item);
                return 0;
            }
            array->Add(PyFloat_AS_DOUBLE(number));
            Py_DECREF(item);
            Py_DECREF(number);
        }
        *sipCppPtr = array;
        return sipGetState(sipTransferObj);
}


extern "C" {static PyObject *convertFrom_wxArrayDouble(void *, PyObject *);}
static PyObject *convertFrom_wxArrayDouble(void *sipCppV, PyObject *)
{
    ::wxArrayDouble *sipCpp = reinterpret_cast< ::wxArrayDouble *>(sipCppV);

        // Code to convert a wxArrayDouble to a Python list of floating point values.
        PyObject* list = PyList_New(0);
        for (size_t i=0; i < sipCpp->GetCount(); i++) {
            PyObject* number = PyFloat_FromDouble(sipCpp->Item(i));
            PyList_Append(list, number);
            Py_DECREF(number);
        }
        return list;
}


sipMappedTypeDef sipTypeDef__core_wxArrayDouble = {
    {
        -1,
        0,
        0,
        SIP_TYPE_MAPPED,
        sipNameNr_wxArrayDouble,     /* wxArrayDouble */
        {0},
        0
    },
    {
        -1,
        {0, 0, 1},
        0, 0,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
    assign_wxArrayDouble,
    array_wxArrayDouble,
    copy_wxArrayDouble,
    release_wxArrayDouble,
    convertTo_wxArrayDouble,
    convertFrom_wxArrayDouble
};
