/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.2
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"




extern "C" {static void assign_wxArrayInt(void *, SIP_SSIZE_T, const void *);}
static void assign_wxArrayInt(void *sipDst, SIP_SSIZE_T sipDstIdx, const void *sipSrc)
{
    reinterpret_cast< ::wxArrayInt *>(sipDst)[sipDstIdx] = *reinterpret_cast<const  ::wxArrayInt *>(sipSrc);
}


extern "C" {static void *array_wxArrayInt(SIP_SSIZE_T);}
static void *array_wxArrayInt(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxArrayInt[sipNrElem];
}


extern "C" {static void *copy_wxArrayInt(const void *, SIP_SSIZE_T);}
static void *copy_wxArrayInt(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxArrayInt(reinterpret_cast<const  ::wxArrayInt *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_wxArrayInt(void *, int);}
static void release_wxArrayInt(void *ptr, int)
{
    Py_BEGIN_ALLOW_THREADS
    delete reinterpret_cast< ::wxArrayInt *>(ptr);
    Py_END_ALLOW_THREADS
}



extern "C" {static int convertTo_wxArrayInt(PyObject *, void **, int *, PyObject *);}
static int convertTo_wxArrayInt(PyObject *sipPy,void **sipCppPtrV,int *sipIsErr,PyObject *sipTransferObj)
{
     ::wxArrayInt **sipCppPtr = reinterpret_cast< ::wxArrayInt **>(sipCppPtrV);

        // Code to test a PyObject for compatibility
        if (!sipIsErr) {
            int success = TRUE;
            // ensure that it is a sequence
            if (! PySequence_Check(sipPy))
                success = FALSE;
            // ensure each item is a number object
            else {
                Py_ssize_t i, len = PySequence_Length(sipPy);
                for (i=0; i<len; i++) {
                    PyObject* item = PySequence_GetItem(sipPy, i);
                    if (!PyNumber_Check(item)) {
                        Py_DECREF(item);
                        success = FALSE;
                        break;
                    }
                    Py_DECREF(item);
                }
            }
            if (!success)
                PyErr_SetString(PyExc_TypeError, "Sequence of numbers expected.");
            return success;
        }

        // Code to create a new wxArrayInt and convert a compatible PyObject
        wxArrayInt *array = new wxArrayInt;
        Py_ssize_t i, len = PySequence_Length(sipPy);
        for (i=0; i<len; i++) {
            PyObject* item = PySequence_GetItem(sipPy, i);
            PyObject* number = wxPyNumber_Int(item);
            if (PyErr_Occurred()) {
                *sipIsErr = 1;
                delete array;
                Py_DECREF(item);
                return 0;
            }
            array->Add(wxPyInt_AS_LONG(number));
            Py_DECREF(item);
            Py_DECREF(number);
        }
        *sipCppPtr = array;
        return sipGetState(sipTransferObj);
}


extern "C" {static PyObject *convertFrom_wxArrayInt(void *, PyObject *);}
static PyObject *convertFrom_wxArrayInt(void *sipCppV, PyObject *)
{
    ::wxArrayInt *sipCpp = reinterpret_cast< ::wxArrayInt *>(sipCppV);

        // Code to convert a wxArrayInt to a Python list of integers.
        PyObject* list = PyList_New(0);
        for (size_t i=0; i < sipCpp->GetCount(); i++) {
            PyObject* number = wxPyInt_FromLong(sipCpp->Item(i));
            PyList_Append(list, number);
            Py_DECREF(number);
        }
        return list;
}


sipMappedTypeDef sipTypeDef__core_wxArrayInt = {
    {
        -1,
        0,
        0,
        SIP_TYPE_MAPPED,
        sipNameNr_wxArrayInt,     /* wxArrayInt */
        {0},
        0
    },
    {
        -1,
        {0, 0, 1},
        0, 0,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
    assign_wxArrayInt,
    array_wxArrayInt,
    copy_wxArrayInt,
    release_wxArrayInt,
    convertTo_wxArrayInt,
    convertFrom_wxArrayInt
};
