/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.2
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/brush.h>

        #include <wx/brush.h>
        #include <wx/colour.h>


PyDoc_STRVAR(doc_wxBrushList_FindOrCreateBrush, "FindOrCreateBrush(colour, style=BRUSHSTYLE_SOLID) -> Brush\n"
    "\n"
    "Finds a brush with the specified attributes and returns it, else\n"
    "creates a new brush, adds it to the brush list, and returns it.");

extern "C" {static PyObject *meth_wxBrushList_FindOrCreateBrush(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBrushList_FindOrCreateBrush(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxColour* colour;
        int colourState = 0;
         ::wxBrushStyle style = wxBRUSHSTYLE_SOLID;
         ::wxBrushList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
            sipName_style,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|E", &sipSelf, sipType_wxBrushList, &sipCpp, sipType_wxColour, &colour, &colourState, sipType_wxBrushStyle, &style))
        {
             ::wxBrush*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->FindOrCreateBrush(*colour,style);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour),sipType_wxColour,colourState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxBrush,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_BrushList, sipName_FindOrCreateBrush, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxBrushList(void *, int);}
static void release_wxBrushList(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxBrushList *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxBrushList(void *, SIP_SSIZE_T, const void *);}
static void assign_wxBrushList(void *sipDst, SIP_SSIZE_T sipDstIdx, const void *sipSrc)
{
    reinterpret_cast< ::wxBrushList *>(sipDst)[sipDstIdx] = *reinterpret_cast<const  ::wxBrushList *>(sipSrc);
}


extern "C" {static void *array_wxBrushList(SIP_SSIZE_T);}
static void *array_wxBrushList(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxBrushList[sipNrElem];
}


extern "C" {static void *copy_wxBrushList(const void *, SIP_SSIZE_T);}
static void *copy_wxBrushList(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxBrushList(reinterpret_cast<const  ::wxBrushList *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxBrushList(sipSimpleWrapper *);}
static void dealloc_wxBrushList(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxBrushList(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxBrushList(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxBrushList(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxBrushList *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxBrushList();
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const  ::wxBrushList* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxBrushList, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxBrushList(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return NULL;
}


static PyMethodDef methods_wxBrushList[] = {
    {SIP_MLNAME_CAST(sipName_FindOrCreateBrush), (PyCFunction)meth_wxBrushList_FindOrCreateBrush, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxBrushList_FindOrCreateBrush)}
};

PyDoc_STRVAR(doc_wxBrushList, "A brush list is a list containing all brushes which have been created.");


sipClassTypeDef sipTypeDef__core_wxBrushList = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxBrushList,
        {0},
        0
    },
    {
        sipNameNr_BrushList,
        {0, 0, 1},
        1, methods_wxBrushList,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxBrushList,
    -1,
    -1,
    0,
    0,
    init_type_wxBrushList,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxBrushList,
    assign_wxBrushList,
    array_wxBrushList,
    copy_wxBrushList,
    release_wxBrushList,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
