/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.2
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/display.h>

        #include <wx/window.h>
        #include <wx/gdicmn.h>
        #include <wx/vidmode.h>
        #include <wx/gdicmn.h>


PyDoc_STRVAR(doc_wxDisplay_ChangeMode, "ChangeMode(mode=DefaultVideoMode) -> bool\n"
    "\n"
    "Changes the video mode of this display to the mode specified in the\n"
    "mode parameter.");

extern "C" {static PyObject *meth_wxDisplay_ChangeMode(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDisplay_ChangeMode(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxVideoMode& modedef = wxDefaultVideoMode;
        const  ::wxVideoMode* mode = &modedef;
         ::wxDisplay *sipCpp;

        static const char *sipKwdList[] = {
            sipName_mode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|J9", &sipSelf, sipType_wxDisplay, &sipCpp, sipType_wxVideoMode, &mode))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ChangeMode(*mode);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Display, sipName_ChangeMode, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDisplay_GetClientArea, "GetClientArea() -> Rect\n"
    "\n"
    "Returns the client area of the display.");

extern "C" {static PyObject *meth_wxDisplay_GetClientArea(PyObject *, PyObject *);}
static PyObject *meth_wxDisplay_GetClientArea(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDisplay *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDisplay, &sipCpp))
        {
             ::wxRect*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxRect(sipCpp->GetClientArea());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxRect,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Display, sipName_GetClientArea, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDisplay_GetCurrentMode, "GetCurrentMode() -> VideoMode\n"
    "\n"
    "Returns the current video mode that this display is in.");

extern "C" {static PyObject *meth_wxDisplay_GetCurrentMode(PyObject *, PyObject *);}
static PyObject *meth_wxDisplay_GetCurrentMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDisplay *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDisplay, &sipCpp))
        {
             ::wxVideoMode*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxVideoMode(sipCpp->GetCurrentMode());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxVideoMode,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Display, sipName_GetCurrentMode, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDisplay_GetGeometry, "GetGeometry() -> Rect\n"
    "\n"
    "Returns the bounding rectangle of the display whose index was passed\n"
    "to the constructor.");

extern "C" {static PyObject *meth_wxDisplay_GetGeometry(PyObject *, PyObject *);}
static PyObject *meth_wxDisplay_GetGeometry(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDisplay *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDisplay, &sipCpp))
        {
             ::wxRect*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxRect(sipCpp->GetGeometry());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxRect,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Display, sipName_GetGeometry, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDisplay_GetModes, "GetModes(mode=DefaultVideoMode) -> ArrayVideoModes\n"
    "\n"
    "Fills and returns an array with all the video modes that are supported\n"
    "by this display, or video modes that are supported by this display and\n"
    "match the mode parameter (if mode is not wxDefaultVideoMode).");

extern "C" {static PyObject *meth_wxDisplay_GetModes(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDisplay_GetModes(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxVideoMode& modedef = wxDefaultVideoMode;
        const  ::wxVideoMode* mode = &modedef;
        const  ::wxDisplay *sipCpp;

        static const char *sipKwdList[] = {
            sipName_mode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|J9", &sipSelf, sipType_wxDisplay, &sipCpp, sipType_wxVideoMode, &mode))
        {
             ::wxArrayVideoModes*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxArrayVideoModes(sipCpp->GetModes(*mode));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxArrayVideoModes,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Display, sipName_GetModes, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDisplay_GetName, "GetName() -> String\n"
    "\n"
    "Returns the display's name.");

extern "C" {static PyObject *meth_wxDisplay_GetName(PyObject *, PyObject *);}
static PyObject *meth_wxDisplay_GetName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDisplay *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDisplay, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Display, sipName_GetName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDisplay_IsPrimary, "IsPrimary() -> bool\n"
    "\n"
    "Returns true if the display is the primary display.");

extern "C" {static PyObject *meth_wxDisplay_IsPrimary(PyObject *, PyObject *);}
static PyObject *meth_wxDisplay_IsPrimary(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxDisplay *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDisplay, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsPrimary();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Display, sipName_IsPrimary, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDisplay_GetCount, "GetCount() -> unsignedint\n"
    "\n"
    "Returns the number of connected displays.");

extern "C" {static PyObject *meth_wxDisplay_GetCount(PyObject *, PyObject *);}
static PyObject *meth_wxDisplay_GetCount(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            uint sipRes;

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxDisplay::GetCount();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Display, sipName_GetCount, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDisplay_GetFromPoint, "GetFromPoint(pt) -> int\n"
    "\n"
    "Returns the index of the display on which the given point lies, or\n"
    "wxNOT_FOUND if the point is not on any connected display.");

extern "C" {static PyObject *meth_wxDisplay_GetFromPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDisplay_GetFromPoint(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxPoint* pt;
        int ptState = 0;

        static const char *sipKwdList[] = {
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxPoint, &pt, &ptState))
        {
            int sipRes;

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxDisplay::GetFromPoint(*pt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt),sipType_wxPoint,ptState);

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Display, sipName_GetFromPoint, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxDisplay_GetFromWindow, "GetFromWindow(win) -> int\n"
    "\n"
    "Returns the index of the display on which the given window lies.");

extern "C" {static PyObject *meth_wxDisplay_GetFromWindow(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDisplay_GetFromWindow(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxWindow* win;

        static const char *sipKwdList[] = {
            sipName_win,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J8", sipType_wxWindow, &win))
        {
            int sipRes;

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxDisplay::GetFromWindow(win);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Display, sipName_GetFromWindow, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxDisplay(void *, int);}
static void release_wxDisplay(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxDisplay *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxDisplay(sipSimpleWrapper *);}
static void dealloc_wxDisplay(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxDisplay(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxDisplay(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxDisplay(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxDisplay *sipCpp = 0;

    {
        uint index = 0;

        static const char *sipKwdList[] = {
            sipName_index,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|u", &index))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxDisplay(index);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    return NULL;
}


static PyMethodDef methods_wxDisplay[] = {
    {SIP_MLNAME_CAST(sipName_ChangeMode), (PyCFunction)meth_wxDisplay_ChangeMode, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDisplay_ChangeMode)},
    {SIP_MLNAME_CAST(sipName_GetClientArea), meth_wxDisplay_GetClientArea, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDisplay_GetClientArea)},
    {SIP_MLNAME_CAST(sipName_GetCount), meth_wxDisplay_GetCount, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDisplay_GetCount)},
    {SIP_MLNAME_CAST(sipName_GetCurrentMode), meth_wxDisplay_GetCurrentMode, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDisplay_GetCurrentMode)},
    {SIP_MLNAME_CAST(sipName_GetFromPoint), (PyCFunction)meth_wxDisplay_GetFromPoint, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDisplay_GetFromPoint)},
    {SIP_MLNAME_CAST(sipName_GetFromWindow), (PyCFunction)meth_wxDisplay_GetFromWindow, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDisplay_GetFromWindow)},
    {SIP_MLNAME_CAST(sipName_GetGeometry), meth_wxDisplay_GetGeometry, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDisplay_GetGeometry)},
    {SIP_MLNAME_CAST(sipName_GetModes), (PyCFunction)meth_wxDisplay_GetModes, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDisplay_GetModes)},
    {SIP_MLNAME_CAST(sipName_GetName), meth_wxDisplay_GetName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDisplay_GetName)},
    {SIP_MLNAME_CAST(sipName_IsPrimary), meth_wxDisplay_IsPrimary, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDisplay_IsPrimary)}
};

sipVariableDef variables_wxDisplay[] = {
    {PropertyVariable, sipName_Name, &methods_wxDisplay[8], NULL, NULL, NULL},
    {PropertyVariable, sipName_Geometry, &methods_wxDisplay[6], NULL, NULL, NULL},
    {PropertyVariable, sipName_CurrentMode, &methods_wxDisplay[3], NULL, NULL, NULL},
    {PropertyVariable, sipName_ClientArea, &methods_wxDisplay[1], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxDisplay, "Display(index=0)\n"
    "\n"
    "Determines the sizes and locations of displays connected to the\n"
    "system.");


sipClassTypeDef sipTypeDef__core_wxDisplay = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxDisplay,
        {0},
        0
    },
    {
        sipNameNr_Display,
        {0, 0, 1},
        10, methods_wxDisplay,
        0, 0,
        4, variables_wxDisplay,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxDisplay,
    -1,
    -1,
    0,
    0,
    init_type_wxDisplay,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxDisplay,
    0,
    0,
    0,
    release_wxDisplay,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
