/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.2
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/fileconf.h>

        #include <wx/stream.h>
    #include <wxpy_api.h>
        #include <wx/stream.h>
        #include <wx/config.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxFileConfig : public  ::wxFileConfig
{
public:
    sipwxFileConfig(const  ::wxString&,const  ::wxString&,const  ::wxString&,const  ::wxString&,long);
    sipwxFileConfig( ::wxInputStream&);
    virtual ~sipwxFileConfig();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    bool Save( ::wxOutputStream&);
    const  ::wxString& GetPath() const;
    void SetPath(const  ::wxString&);
     ::size_t GetNumberOfEntries(bool) const;
     ::size_t GetNumberOfGroups(bool) const;
     ::wxConfigBase::EntryType GetEntryType(const  ::wxString&) const;
    bool HasEntry(const  ::wxString&) const;
    bool HasGroup(const  ::wxString&) const;
    bool Flush(bool);
    bool RenameEntry(const  ::wxString&,const  ::wxString&);
    bool RenameGroup(const  ::wxString&,const  ::wxString&);
    bool DeleteAll();
    bool DeleteEntry(const  ::wxString&,bool);
    bool DeleteGroup(const  ::wxString&);

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxFileConfig(const sipwxFileConfig &);
    sipwxFileConfig &operator = (const sipwxFileConfig &);

    char sipPyMethods[14];
};

sipwxFileConfig::sipwxFileConfig(const  ::wxString& appName,const  ::wxString& vendorName,const  ::wxString& localFilename,const  ::wxString& globalFilename,long style):  ::wxFileConfig(appName,vendorName,localFilename,globalFilename,style), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxFileConfig::sipwxFileConfig( ::wxInputStream& is):  ::wxFileConfig(is), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxFileConfig::~sipwxFileConfig()
{
    sipCommonDtor(sipPySelf);
}

bool sipwxFileConfig::Save( ::wxOutputStream& os)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[0],sipPySelf,NULL,sipName_Save);

    if (!sipMeth)
        return  ::wxFileConfig::Save(os);

    extern bool sipVH__core_80(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxOutputStream&);

    return sipVH__core_80(sipGILState, 0, sipPySelf, sipMeth, os);
}

const  ::wxString& sipwxFileConfig::GetPath() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[1]),sipPySelf,NULL,sipName_GetPath);

    if (!sipMeth)
        return  ::wxFileConfig::GetPath();

    extern const  ::wxString& sipVH__core_75(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_75(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxFileConfig::SetPath(const  ::wxString& strPath)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[2],sipPySelf,NULL,sipName_SetPath);

    if (!sipMeth)
    {
         ::wxFileConfig::SetPath(strPath);
        return;
    }

    extern void sipVH__core_38(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&);

    sipVH__core_38(sipGILState, 0, sipPySelf, sipMeth, strPath);
}

 ::size_t sipwxFileConfig::GetNumberOfEntries(bool bRecursive) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[3]),sipPySelf,NULL,sipName_GetNumberOfEntries);

    if (!sipMeth)
        return  ::wxFileConfig::GetNumberOfEntries(bRecursive);

    extern  ::size_t sipVH__core_76(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, bool);

    return sipVH__core_76(sipGILState, 0, sipPySelf, sipMeth, bRecursive);
}

 ::size_t sipwxFileConfig::GetNumberOfGroups(bool bRecursive) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[4]),sipPySelf,NULL,sipName_GetNumberOfGroups);

    if (!sipMeth)
        return  ::wxFileConfig::GetNumberOfGroups(bRecursive);

    extern  ::size_t sipVH__core_76(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, bool);

    return sipVH__core_76(sipGILState, 0, sipPySelf, sipMeth, bRecursive);
}

 ::wxConfigBase::EntryType sipwxFileConfig::GetEntryType(const  ::wxString& name) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[5]),sipPySelf,NULL,sipName_GetEntryType);

    if (!sipMeth)
        return  ::wxFileConfig::GetEntryType(name);

    extern  ::wxConfigBase::EntryType sipVH__core_77(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&);

    return sipVH__core_77(sipGILState, 0, sipPySelf, sipMeth, name);
}

bool sipwxFileConfig::HasEntry(const  ::wxString& strName) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[6]),sipPySelf,NULL,sipName_HasEntry);

    if (!sipMeth)
        return  ::wxFileConfig::HasEntry(strName);

    extern bool sipVH__core_11(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&);

    return sipVH__core_11(sipGILState, 0, sipPySelf, sipMeth, strName);
}

bool sipwxFileConfig::HasGroup(const  ::wxString& strName) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[7]),sipPySelf,NULL,sipName_HasGroup);

    if (!sipMeth)
        return  ::wxFileConfig::HasGroup(strName);

    extern bool sipVH__core_11(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&);

    return sipVH__core_11(sipGILState, 0, sipPySelf, sipMeth, strName);
}

bool sipwxFileConfig::Flush(bool bCurrentOnly)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[8],sipPySelf,NULL,sipName_Flush);

    if (!sipMeth)
        return  ::wxFileConfig::Flush(bCurrentOnly);

    extern bool sipVH__core_78(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, bool);

    return sipVH__core_78(sipGILState, 0, sipPySelf, sipMeth, bCurrentOnly);
}

bool sipwxFileConfig::RenameEntry(const  ::wxString& oldName,const  ::wxString& newName)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[9],sipPySelf,NULL,sipName_RenameEntry);

    if (!sipMeth)
        return  ::wxFileConfig::RenameEntry(oldName,newName);

    extern bool sipVH__core_21(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&,const  ::wxString&);

    return sipVH__core_21(sipGILState, 0, sipPySelf, sipMeth, oldName, newName);
}

bool sipwxFileConfig::RenameGroup(const  ::wxString& oldName,const  ::wxString& newName)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[10],sipPySelf,NULL,sipName_RenameGroup);

    if (!sipMeth)
        return  ::wxFileConfig::RenameGroup(oldName,newName);

    extern bool sipVH__core_21(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&,const  ::wxString&);

    return sipVH__core_21(sipGILState, 0, sipPySelf, sipMeth, oldName, newName);
}

bool sipwxFileConfig::DeleteAll()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[11],sipPySelf,NULL,sipName_DeleteAll);

    if (!sipMeth)
        return  ::wxFileConfig::DeleteAll();

    extern bool sipVH__core_8(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_8(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxFileConfig::DeleteEntry(const  ::wxString& key,bool bDeleteGroupIfEmpty)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[12],sipPySelf,NULL,sipName_DeleteEntry);

    if (!sipMeth)
        return  ::wxFileConfig::DeleteEntry(key,bDeleteGroupIfEmpty);

    extern bool sipVH__core_79(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&,bool);

    return sipVH__core_79(sipGILState, 0, sipPySelf, sipMeth, key, bDeleteGroupIfEmpty);
}

bool sipwxFileConfig::DeleteGroup(const  ::wxString& key)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[13],sipPySelf,NULL,sipName_DeleteGroup);

    if (!sipMeth)
        return  ::wxFileConfig::DeleteGroup(key);

    extern bool sipVH__core_11(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&);

    return sipVH__core_11(sipGILState, 0, sipPySelf, sipMeth, key);
}


PyDoc_STRVAR(doc_wxFileConfig_Save, "Save(os) -> bool\n"
    "\n"
    "Saves all config data to the given stream, returns true if data was\n"
    "saved successfully or false on error.");

extern "C" {static PyObject *meth_wxFileConfig_Save(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileConfig_Save(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxOutputStream* os;
        int osState = 0;
         ::wxFileConfig *sipCpp;

        static const char *sipKwdList[] = {
            sipName_os,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxFileConfig, &sipCpp, sipType_wxOutputStream, &os, &osState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxFileConfig::Save(*os) : sipCpp->Save(*os));
            Py_END_ALLOW_THREADS
            sipReleaseType(os,sipType_wxOutputStream,osState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileConfig, sipName_Save, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileConfig_SetUmask, "SetUmask(mode)\n"
    "\n"
    "Allows to set the mode to be used for the config file creation.");

extern "C" {static PyObject *meth_wxFileConfig_SetUmask(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileConfig_SetUmask(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int mode;
         ::wxFileConfig *sipCpp;

        static const char *sipKwdList[] = {
            sipName_mode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxFileConfig, &sipCpp, &mode))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetUmask(mode);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileConfig, sipName_SetUmask, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileConfig_SetPath, "SetPath(strPath)\n"
    "\n"
    "Set current path: if the first character is '/', it is the absolute\n"
    "path, otherwise it is a relative path.");

extern "C" {static PyObject *meth_wxFileConfig_SetPath(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileConfig_SetPath(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* strPath;
        int strPathState = 0;
         ::wxFileConfig *sipCpp;

        static const char *sipKwdList[] = {
            sipName_strPath,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxFileConfig, &sipCpp, sipType_wxString,&strPath, &strPathState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxFileConfig::SetPath(*strPath) : sipCpp->SetPath(*strPath));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(strPath),sipType_wxString,strPathState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileConfig, sipName_SetPath, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileConfig_GetPath, "GetPath() -> String\n"
    "\n"
    "Retrieve the current path (always as absolute path).");

extern "C" {static PyObject *meth_wxFileConfig_GetPath(PyObject *, PyObject *);}
static PyObject *meth_wxFileConfig_GetPath(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxFileConfig *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFileConfig, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString((sipSelfWasArg ? sipCpp-> ::wxFileConfig::GetPath() : sipCpp->GetPath()));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileConfig, sipName_GetPath, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileConfig_GetNumberOfEntries, "GetNumberOfEntries(bRecursive=False) -> size_t\n"
    "\n"
    "Get number of entries in the current group.");

extern "C" {static PyObject *meth_wxFileConfig_GetNumberOfEntries(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileConfig_GetNumberOfEntries(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        bool bRecursive = 0;
        const  ::wxFileConfig *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bRecursive,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|b", &sipSelf, sipType_wxFileConfig, &sipCpp, &bRecursive))
        {
             ::size_t*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::size_t((sipSelfWasArg ? sipCpp-> ::wxFileConfig::GetNumberOfEntries(bRecursive) : sipCpp->GetNumberOfEntries(bRecursive)));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_size_t,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileConfig, sipName_GetNumberOfEntries, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileConfig_GetNumberOfGroups, "GetNumberOfGroups(bRecursive=False) -> size_t\n"
    "\n"
    "Get number of entries/subgroups in the current group, with or without\n"
    "its subgroups.");

extern "C" {static PyObject *meth_wxFileConfig_GetNumberOfGroups(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileConfig_GetNumberOfGroups(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        bool bRecursive = 0;
        const  ::wxFileConfig *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bRecursive,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|b", &sipSelf, sipType_wxFileConfig, &sipCpp, &bRecursive))
        {
             ::size_t*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::size_t((sipSelfWasArg ? sipCpp-> ::wxFileConfig::GetNumberOfGroups(bRecursive) : sipCpp->GetNumberOfGroups(bRecursive)));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_size_t,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileConfig, sipName_GetNumberOfGroups, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileConfig_HasGroup, "HasGroup(strName) -> bool");

extern "C" {static PyObject *meth_wxFileConfig_HasGroup(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileConfig_HasGroup(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* strName;
        int strNameState = 0;
        const  ::wxFileConfig *sipCpp;

        static const char *sipKwdList[] = {
            sipName_strName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxFileConfig, &sipCpp, sipType_wxString,&strName, &strNameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxFileConfig::HasGroup(*strName) : sipCpp->HasGroup(*strName));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(strName),sipType_wxString,strNameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileConfig, sipName_HasGroup, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileConfig_HasEntry, "HasEntry(strName) -> bool");

extern "C" {static PyObject *meth_wxFileConfig_HasEntry(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileConfig_HasEntry(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* strName;
        int strNameState = 0;
        const  ::wxFileConfig *sipCpp;

        static const char *sipKwdList[] = {
            sipName_strName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxFileConfig, &sipCpp, sipType_wxString,&strName, &strNameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxFileConfig::HasEntry(*strName) : sipCpp->HasEntry(*strName));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(strName),sipType_wxString,strNameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileConfig, sipName_HasEntry, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileConfig_Flush, "Flush(bCurrentOnly=False) -> bool\n"
    "\n"
    "Permanently writes all changes (otherwise, they're only written from\n"
    "object's destructor).");

extern "C" {static PyObject *meth_wxFileConfig_Flush(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileConfig_Flush(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        bool bCurrentOnly = 0;
         ::wxFileConfig *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bCurrentOnly,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|b", &sipSelf, sipType_wxFileConfig, &sipCpp, &bCurrentOnly))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxFileConfig::Flush(bCurrentOnly) : sipCpp->Flush(bCurrentOnly));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileConfig, sipName_Flush, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileConfig_RenameEntry, "RenameEntry(oldName, newName) -> bool\n"
    "\n"
    "Renames an entry in the current group.");

extern "C" {static PyObject *meth_wxFileConfig_RenameEntry(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileConfig_RenameEntry(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* oldName;
        int oldNameState = 0;
        const  ::wxString* newName;
        int newNameState = 0;
         ::wxFileConfig *sipCpp;

        static const char *sipKwdList[] = {
            sipName_oldName,
            sipName_newName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxFileConfig, &sipCpp, sipType_wxString,&oldName, &oldNameState, sipType_wxString,&newName, &newNameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxFileConfig::RenameEntry(*oldName,*newName) : sipCpp->RenameEntry(*oldName,*newName));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(oldName),sipType_wxString,oldNameState);
            sipReleaseType(const_cast< ::wxString *>(newName),sipType_wxString,newNameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileConfig, sipName_RenameEntry, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileConfig_RenameGroup, "RenameGroup(oldName, newName) -> bool\n"
    "\n"
    "Renames a subgroup of the current group.");

extern "C" {static PyObject *meth_wxFileConfig_RenameGroup(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileConfig_RenameGroup(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* oldName;
        int oldNameState = 0;
        const  ::wxString* newName;
        int newNameState = 0;
         ::wxFileConfig *sipCpp;

        static const char *sipKwdList[] = {
            sipName_oldName,
            sipName_newName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxFileConfig, &sipCpp, sipType_wxString,&oldName, &oldNameState, sipType_wxString,&newName, &newNameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxFileConfig::RenameGroup(*oldName,*newName) : sipCpp->RenameGroup(*oldName,*newName));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(oldName),sipType_wxString,oldNameState);
            sipReleaseType(const_cast< ::wxString *>(newName),sipType_wxString,newNameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileConfig, sipName_RenameGroup, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileConfig_DeleteEntry, "DeleteEntry(key, bDeleteGroupIfEmpty=True) -> bool\n"
    "\n"
    "Deletes the specified entry and the group it belongs to if it was the\n"
    "last key in it and the second parameter is true.");

extern "C" {static PyObject *meth_wxFileConfig_DeleteEntry(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileConfig_DeleteEntry(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* key;
        int keyState = 0;
        bool bDeleteGroupIfEmpty = 1;
         ::wxFileConfig *sipCpp;

        static const char *sipKwdList[] = {
            sipName_key,
            sipName_bDeleteGroupIfEmpty,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|b", &sipSelf, sipType_wxFileConfig, &sipCpp, sipType_wxString,&key, &keyState, &bDeleteGroupIfEmpty))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxFileConfig::DeleteEntry(*key,bDeleteGroupIfEmpty) : sipCpp->DeleteEntry(*key,bDeleteGroupIfEmpty));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(key),sipType_wxString,keyState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileConfig, sipName_DeleteEntry, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileConfig_DeleteGroup, "DeleteGroup(key) -> bool\n"
    "\n"
    "Delete the group (with all subgroups).");

extern "C" {static PyObject *meth_wxFileConfig_DeleteGroup(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileConfig_DeleteGroup(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* key;
        int keyState = 0;
         ::wxFileConfig *sipCpp;

        static const char *sipKwdList[] = {
            sipName_key,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxFileConfig, &sipCpp, sipType_wxString,&key, &keyState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxFileConfig::DeleteGroup(*key) : sipCpp->DeleteGroup(*key));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(key),sipType_wxString,keyState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileConfig, sipName_DeleteGroup, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileConfig_DeleteAll, "DeleteAll() -> bool\n"
    "\n"
    "Delete the whole underlying object (disk file, registry key, ...).");

extern "C" {static PyObject *meth_wxFileConfig_DeleteAll(PyObject *, PyObject *);}
static PyObject *meth_wxFileConfig_DeleteAll(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxFileConfig *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFileConfig, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxFileConfig::DeleteAll() : sipCpp->DeleteAll());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileConfig, sipName_DeleteAll, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileConfig_GetGlobalFileName, "GetGlobalFileName(szFile) -> String");

extern "C" {static PyObject *meth_wxFileConfig_GetGlobalFileName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileConfig_GetGlobalFileName(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* szFile;
        int szFileState = 0;

        static const char *sipKwdList[] = {
            sipName_szFile,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&szFile, &szFileState))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString( ::wxFileConfig::GetGlobalFileName(*szFile));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(szFile),sipType_wxString,szFileState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileConfig, sipName_GetGlobalFileName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileConfig_GetLocalFileName, "GetLocalFileName(szFile, style=0) -> String");

extern "C" {static PyObject *meth_wxFileConfig_GetLocalFileName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileConfig_GetLocalFileName(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* szFile;
        int szFileState = 0;
        int style = 0;

        static const char *sipKwdList[] = {
            sipName_szFile,
            sipName_style,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1|i", sipType_wxString,&szFile, &szFileState, &style))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString( ::wxFileConfig::GetLocalFileName(*szFile,style));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(szFile),sipType_wxString,szFileState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileConfig, sipName_GetLocalFileName, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxFileConfig(void *, const sipTypeDef *);}
static void *cast_wxFileConfig(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxFileConfig *sipCpp = reinterpret_cast< ::wxFileConfig *>(sipCppV);

    if (targetType == sipType_wxConfigBase)
        return static_cast< ::wxConfigBase *>(sipCpp);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxFileConfig(void *, int);}
static void release_wxFileConfig(void *sipCppV, int sipIsDerived)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipIsDerived)
        delete reinterpret_cast<sipwxFileConfig *>(sipCppV);
    else
        delete reinterpret_cast< ::wxFileConfig *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxFileConfig(sipSimpleWrapper *);}
static void dealloc_wxFileConfig(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxFileConfig *>(sipGetAddress(sipSelf))->sipPySelf = NULL;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxFileConfig(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxFileConfig(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxFileConfig(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxFileConfig *sipCpp = 0;

    {
        const  ::wxString& appNamedef = wxEmptyString;
        const  ::wxString* appName = &appNamedef;
        int appNameState = 0;
        const  ::wxString& vendorNamedef = wxEmptyString;
        const  ::wxString* vendorName = &vendorNamedef;
        int vendorNameState = 0;
        const  ::wxString& localFilenamedef = wxEmptyString;
        const  ::wxString* localFilename = &localFilenamedef;
        int localFilenameState = 0;
        const  ::wxString& globalFilenamedef = wxEmptyString;
        const  ::wxString* globalFilename = &globalFilenamedef;
        int globalFilenameState = 0;
        long style = wxCONFIG_USE_LOCAL_FILE|wxCONFIG_USE_GLOBAL_FILE;

        static const char *sipKwdList[] = {
            sipName_appName,
            sipName_vendorName,
            sipName_localFilename,
            sipName_globalFilename,
            sipName_style,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J1J1J1J1l", sipType_wxString,&appName, &appNameState, sipType_wxString,&vendorName, &vendorNameState, sipType_wxString,&localFilename, &localFilenameState, sipType_wxString,&globalFilename, &globalFilenameState, &style))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxFileConfig(*appName,*vendorName,*localFilename,*globalFilename,style);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(appName),sipType_wxString,appNameState);
            sipReleaseType(const_cast< ::wxString *>(vendorName),sipType_wxString,vendorNameState);
            sipReleaseType(const_cast< ::wxString *>(localFilename),sipType_wxString,localFilenameState);
            sipReleaseType(const_cast< ::wxString *>(globalFilename),sipType_wxString,globalFilenameState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
         ::wxInputStream* is;
        int isState = 0;

        static const char *sipKwdList[] = {
            sipName_is,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1", sipType_wxInputStream, &is, &isState))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxFileConfig(*is);
            Py_END_ALLOW_THREADS
            sipReleaseType(is,sipType_wxInputStream,isState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxFileConfig[] = {{78, 255, 1}};


static PyMethodDef methods_wxFileConfig[] = {
    {SIP_MLNAME_CAST(sipName_DeleteAll), meth_wxFileConfig_DeleteAll, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFileConfig_DeleteAll)},
    {SIP_MLNAME_CAST(sipName_DeleteEntry), (PyCFunction)meth_wxFileConfig_DeleteEntry, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileConfig_DeleteEntry)},
    {SIP_MLNAME_CAST(sipName_DeleteGroup), (PyCFunction)meth_wxFileConfig_DeleteGroup, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileConfig_DeleteGroup)},
    {SIP_MLNAME_CAST(sipName_Flush), (PyCFunction)meth_wxFileConfig_Flush, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileConfig_Flush)},
    {SIP_MLNAME_CAST(sipName_GetGlobalFileName), (PyCFunction)meth_wxFileConfig_GetGlobalFileName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileConfig_GetGlobalFileName)},
    {SIP_MLNAME_CAST(sipName_GetLocalFileName), (PyCFunction)meth_wxFileConfig_GetLocalFileName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileConfig_GetLocalFileName)},
    {SIP_MLNAME_CAST(sipName_GetNumberOfEntries), (PyCFunction)meth_wxFileConfig_GetNumberOfEntries, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileConfig_GetNumberOfEntries)},
    {SIP_MLNAME_CAST(sipName_GetNumberOfGroups), (PyCFunction)meth_wxFileConfig_GetNumberOfGroups, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileConfig_GetNumberOfGroups)},
    {SIP_MLNAME_CAST(sipName_GetPath), meth_wxFileConfig_GetPath, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFileConfig_GetPath)},
    {SIP_MLNAME_CAST(sipName_HasEntry), (PyCFunction)meth_wxFileConfig_HasEntry, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileConfig_HasEntry)},
    {SIP_MLNAME_CAST(sipName_HasGroup), (PyCFunction)meth_wxFileConfig_HasGroup, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileConfig_HasGroup)},
    {SIP_MLNAME_CAST(sipName_RenameEntry), (PyCFunction)meth_wxFileConfig_RenameEntry, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileConfig_RenameEntry)},
    {SIP_MLNAME_CAST(sipName_RenameGroup), (PyCFunction)meth_wxFileConfig_RenameGroup, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileConfig_RenameGroup)},
    {SIP_MLNAME_CAST(sipName_Save), (PyCFunction)meth_wxFileConfig_Save, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileConfig_Save)},
    {SIP_MLNAME_CAST(sipName_SetPath), (PyCFunction)meth_wxFileConfig_SetPath, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileConfig_SetPath)},
    {SIP_MLNAME_CAST(sipName_SetUmask), (PyCFunction)meth_wxFileConfig_SetUmask, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileConfig_SetUmask)}
};

sipVariableDef variables_wxFileConfig[] = {
    {PropertyVariable, sipName_Path, &methods_wxFileConfig[8], &methods_wxFileConfig[14], NULL, NULL},
    {PropertyVariable, sipName_NumberOfGroups, &methods_wxFileConfig[7], NULL, NULL, NULL},
    {PropertyVariable, sipName_NumberOfEntries, &methods_wxFileConfig[6], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxFileConfig, "FileConfig(appName=EmptyString, vendorName=EmptyString, localFilename=EmptyString, globalFilename=EmptyString, style=CONFIG_USE_LOCAL_FILE|CONFIG_USE_GLOBAL_FILE)\n"
    "FileConfig(is)\n"
    "\n"
    "wxFileConfig implements wxConfigBase interface for storing and\n"
    "retrieving configuration information using plain text files.");


sipClassTypeDef sipTypeDef__core_wxFileConfig = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxFileConfig,
        {0},
        0
    },
    {
        sipNameNr_FileConfig,
        {0, 0, 1},
        16, methods_wxFileConfig,
        0, 0,
        3, variables_wxFileConfig,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxFileConfig,
    -1,
    -1,
    supers_wxFileConfig,
    0,
    init_type_wxFileConfig,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxFileConfig,
    0,
    0,
    0,
    release_wxFileConfig,
    cast_wxFileConfig,
    0,
    0,
    0,
    0,
    0,
    0
};
