/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.2
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/dataobj.h>

        #include <wx/dataobj.h>
    #include <wxpy_api.h>
        #include <wx/dataobj.h>
    PyObject* _wxFileDataObject_GetAllFormats(const wxFileDataObject* self, wxDataObject::Direction dir)
    {
        size_t count = self->GetFormatCount(dir);
        wxDataFormat* formats = new wxDataFormat[count];
        self->GetAllFormats(formats, dir);
        wxPyThreadBlocker blocker;
        PyObject* list = PyList_New(count);
        for (size_t i=0; i<count; i++) {
            wxDataFormat* format = new wxDataFormat(formats[i]);
            PyObject* obj = wxPyConstructObject((void*)format, wxT("wxDataFormat"), true);
            PyList_SET_ITEM(list, i, obj); // PyList_SET_ITEM steals a reference
        }
        delete [] formats;
        return list;
    }
    bool _wxFileDataObject_SetData(wxFileDataObject* self, const wxDataFormat* format, wxPyBuffer* buf)
    {
        return self->SetData(*format, buf->m_len, buf->m_ptr);
    }


class sipwxFileDataObject : public  ::wxFileDataObject
{
public:
    sipwxFileDataObject();
    virtual ~sipwxFileDataObject();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    bool SetData(const  ::wxDataFormat&, ::size_t,const void*);
     ::wxDataFormat GetPreferredFormat( ::wxDataObject::Direction) const;
     ::size_t GetFormatCount( ::wxDataObject::Direction) const;
    void GetAllFormats( ::wxDataFormat*, ::wxDataObject::Direction) const;
    bool GetDataHere(void*) const;
     ::size_t GetDataSize() const;
    bool SetData( ::size_t,const void*);

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxFileDataObject(const sipwxFileDataObject &);
    sipwxFileDataObject &operator = (const sipwxFileDataObject &);

    char sipPyMethods[7];
};

sipwxFileDataObject::sipwxFileDataObject():  ::wxFileDataObject(), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxFileDataObject::~sipwxFileDataObject()
{
    sipCommonDtor(sipPySelf);
}

bool sipwxFileDataObject::SetData(const  ::wxDataFormat& format, ::size_t len,const void*buf)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[0],sipPySelf,NULL,sipName_SetData);

    if (!sipMeth)
        return  ::wxFileDataObject::SetData(format,len,buf);

    extern bool sipVH__core_63(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxDataFormat&, ::size_t,const void*);

    return sipVH__core_63(sipGILState, 0, sipPySelf, sipMeth, format, len, buf);
}

 ::wxDataFormat sipwxFileDataObject::GetPreferredFormat( ::wxDataObject::Direction dir) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[1]),sipPySelf,NULL,sipName_GetPreferredFormat);

    if (!sipMeth)
        return  ::wxFileDataObject::GetPreferredFormat(dir);

    extern  ::wxDataFormat sipVH__core_47(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxDataObject::Direction);

    return sipVH__core_47(sipGILState, 0, sipPySelf, sipMeth, dir);
}

 ::size_t sipwxFileDataObject::GetFormatCount( ::wxDataObject::Direction dir) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[2]),sipPySelf,NULL,sipName_GetFormatCount);

    if (!sipMeth)
        return  ::wxFileDataObject::GetFormatCount(dir);

    extern  ::size_t sipVH__core_46(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxDataObject::Direction);

    return sipVH__core_46(sipGILState, 0, sipPySelf, sipMeth, dir);
}

void sipwxFileDataObject::GetAllFormats( ::wxDataFormat*formats, ::wxDataObject::Direction dir) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[3]),sipPySelf,NULL,sipName_GetAllFormats);

    if (!sipMeth)
    {
         ::wxFileDataObject::GetAllFormats(formats,dir);
        return;
    }

    extern void sipVH__core_43(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxDataFormat*, ::wxDataObject::Direction);

    sipVH__core_43(sipGILState, 0, sipPySelf, sipMeth, formats, dir);
}

bool sipwxFileDataObject::GetDataHere(void*buf) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[4]),sipPySelf,NULL,sipName_GetDataHere);

    if (!sipMeth)
        return  ::wxFileDataObject::GetDataHere(buf);

    extern bool sipVH__core_55(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, void*);

    return sipVH__core_55(sipGILState, 0, sipPySelf, sipMeth, buf);
}

 ::size_t sipwxFileDataObject::GetDataSize() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[5]),sipPySelf,NULL,sipName_GetDataSize);

    if (!sipMeth)
        return  ::wxFileDataObject::GetDataSize();

    extern  ::size_t sipVH__core_52(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_52(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxFileDataObject::SetData( ::size_t len,const void*buf)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[6],sipPySelf,NULL,sipName_SetData);

    if (!sipMeth)
        return  ::wxFileDataObject::SetData(len,buf);

    extern bool sipVH__core_54(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::size_t,const void*);

    return sipVH__core_54(sipGILState, 0, sipPySelf, sipMeth, len, buf);
}


PyDoc_STRVAR(doc_wxFileDataObject_AddFile, "AddFile(file)\n"
    "\n"
    "Adds a file to the file list represented by this data object (Windows\n"
    "only).");

extern "C" {static PyObject *meth_wxFileDataObject_AddFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileDataObject_AddFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* file;
        int fileState = 0;
         ::wxFileDataObject *sipCpp;

        static const char *sipKwdList[] = {
            sipName_file,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxFileDataObject, &sipCpp, sipType_wxString,&file, &fileState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddFile(*file);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(file),sipType_wxString,fileState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileDataObject, sipName_AddFile, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileDataObject_GetFilenames, "GetFilenames() -> ArrayString\n"
    "\n"
    "Returns the array of file names.");

extern "C" {static PyObject *meth_wxFileDataObject_GetFilenames(PyObject *, PyObject *);}
static PyObject *meth_wxFileDataObject_GetFilenames(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFileDataObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFileDataObject, &sipCpp))
        {
             ::wxArrayString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxArrayString(sipCpp->GetFilenames());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxArrayString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileDataObject, sipName_GetFilenames, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileDataObject_GetAllFormats, "GetAllFormats(dir=DataObject.Get)\n"
    "\n"
    "Returns a list of wx.DataFormat objects which this data object\n"
    "supports transferring in the given direction.");

extern "C" {static PyObject *meth_wxFileDataObject_GetAllFormats(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileDataObject_GetAllFormats(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxDataObject::Direction dir = wxDataObject::Get;
        const  ::wxFileDataObject *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dir,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|E", &sipSelf, sipType_wxFileDataObject, &sipCpp, sipType_wxDataObject_Direction, &dir))
        {
            PyObject * sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxFileDataObject_GetAllFormats(sipCpp, dir);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileDataObject, sipName_GetAllFormats, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileDataObject_SetData, "SetData(format, buf) -> bool");

extern "C" {static PyObject *meth_wxFileDataObject_SetData(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileDataObject_SetData(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxDataFormat* format;
         ::wxPyBuffer* buf;
        int bufState = 0;
         ::wxFileDataObject *sipCpp;

        static const char *sipKwdList[] = {
            sipName_format,
            sipName_buf,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9J0", &sipSelf, sipType_wxFileDataObject, &sipCpp, sipType_wxDataFormat, &format, sipType_wxPyBuffer,&buf, &bufState))
        {
            bool sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxFileDataObject_SetData(sipCpp, format, buf);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(buf,sipType_wxPyBuffer,bufState);

            if (sipIsErr)
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
         ::size_t* len;
        int lenState = 0;
        const void* buf;
         ::wxFileDataObject *sipCpp;

        static const char *sipKwdList[] = {
            sipName_len,
            sipName_buf,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1v", &sipSelf, sipType_wxFileDataObject, &sipCpp, sipType_size_t,&len, &lenState, &buf))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxFileDataObject::SetData(*len,buf) : sipCpp->SetData(*len,buf));
            Py_END_ALLOW_THREADS
            sipReleaseType(len,sipType_size_t,lenState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileDataObject, sipName_SetData, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileDataObject_GetFormatCount, "GetFormatCount(self, dir: DataObject.Direction = wxDataObject.Get) -> object");

extern "C" {static PyObject *meth_wxFileDataObject_GetFormatCount(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileDataObject_GetFormatCount(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxDataObject::Direction dir =  ::wxDataObject::Get;
        const  ::wxFileDataObject *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dir,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|E", &sipSelf, sipType_wxFileDataObject, &sipCpp, sipType_wxDataObject_Direction, &dir))
        {
             ::size_t*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::size_t((sipSelfWasArg ? sipCpp-> ::wxFileDataObject::GetFormatCount(dir) : sipCpp->GetFormatCount(dir)));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_size_t,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileDataObject, sipName_GetFormatCount, doc_wxFileDataObject_GetFormatCount);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileDataObject_GetPreferredFormat, "GetPreferredFormat(self, dir: DataObject.Direction = wxDataObject.Get) -> DataFormat");

extern "C" {static PyObject *meth_wxFileDataObject_GetPreferredFormat(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileDataObject_GetPreferredFormat(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxDataObject::Direction dir =  ::wxDataObject::Get;
        const  ::wxFileDataObject *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dir,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|E", &sipSelf, sipType_wxFileDataObject, &sipCpp, sipType_wxDataObject_Direction, &dir))
        {
             ::wxDataFormat*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDataFormat((sipSelfWasArg ? sipCpp-> ::wxFileDataObject::GetPreferredFormat(dir) : sipCpp->GetPreferredFormat(dir)));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDataFormat,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileDataObject, sipName_GetPreferredFormat, doc_wxFileDataObject_GetPreferredFormat);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileDataObject_GetDataSize, "GetDataSize(self) -> object");

extern "C" {static PyObject *meth_wxFileDataObject_GetDataSize(PyObject *, PyObject *);}
static PyObject *meth_wxFileDataObject_GetDataSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxFileDataObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFileDataObject, &sipCpp))
        {
             ::size_t*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::size_t((sipSelfWasArg ? sipCpp-> ::wxFileDataObject::GetDataSize() : sipCpp->GetDataSize()));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_size_t,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileDataObject, sipName_GetDataSize, doc_wxFileDataObject_GetDataSize);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileDataObject_GetDataHere, "GetDataHere(self, buf: sip.voidptr) -> bool");

extern "C" {static PyObject *meth_wxFileDataObject_GetDataHere(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFileDataObject_GetDataHere(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        void* buf;
        const  ::wxFileDataObject *sipCpp;

        static const char *sipKwdList[] = {
            sipName_buf,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bv", &sipSelf, sipType_wxFileDataObject, &sipCpp, &buf))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxFileDataObject::GetDataHere(buf) : sipCpp->GetDataHere(buf));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileDataObject, sipName_GetDataHere, doc_wxFileDataObject_GetDataHere);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxFileDataObject(void *, const sipTypeDef *);}
static void *cast_wxFileDataObject(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxFileDataObject *sipCpp = reinterpret_cast< ::wxFileDataObject *>(sipCppV);

    if (targetType == sipType_wxDataObjectSimple)
        return static_cast< ::wxDataObjectSimple *>(sipCpp);

    if (targetType == sipType_wxDataObject)
        return static_cast< ::wxDataObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxFileDataObject(void *, int);}
static void release_wxFileDataObject(void *sipCppV, int sipIsDerived)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipIsDerived)
        delete reinterpret_cast<sipwxFileDataObject *>(sipCppV);
    else
        delete reinterpret_cast< ::wxFileDataObject *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxFileDataObject(sipSimpleWrapper *);}
static void dealloc_wxFileDataObject(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxFileDataObject *>(sipGetAddress(sipSelf))->sipPySelf = NULL;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxFileDataObject(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxFileDataObject(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxFileDataObject(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxFileDataObject *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxFileDataObject();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxFileDataObject[] = {{101, 255, 1}};


static PyMethodDef methods_wxFileDataObject[] = {
    {SIP_MLNAME_CAST(sipName_AddFile), (PyCFunction)meth_wxFileDataObject_AddFile, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileDataObject_AddFile)},
    {SIP_MLNAME_CAST(sipName_GetAllFormats), (PyCFunction)meth_wxFileDataObject_GetAllFormats, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileDataObject_GetAllFormats)},
    {SIP_MLNAME_CAST(sipName_GetDataHere), (PyCFunction)meth_wxFileDataObject_GetDataHere, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileDataObject_GetDataHere)},
    {SIP_MLNAME_CAST(sipName_GetDataSize), meth_wxFileDataObject_GetDataSize, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFileDataObject_GetDataSize)},
    {SIP_MLNAME_CAST(sipName_GetFilenames), meth_wxFileDataObject_GetFilenames, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFileDataObject_GetFilenames)},
    {SIP_MLNAME_CAST(sipName_GetFormatCount), (PyCFunction)meth_wxFileDataObject_GetFormatCount, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileDataObject_GetFormatCount)},
    {SIP_MLNAME_CAST(sipName_GetPreferredFormat), (PyCFunction)meth_wxFileDataObject_GetPreferredFormat, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileDataObject_GetPreferredFormat)},
    {SIP_MLNAME_CAST(sipName_SetData), (PyCFunction)meth_wxFileDataObject_SetData, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFileDataObject_SetData)}
};

sipVariableDef variables_wxFileDataObject[] = {
    {PropertyVariable, sipName_Filenames, &methods_wxFileDataObject[4], NULL, NULL, NULL},
    {PropertyVariable, sipName_AllFormats, &methods_wxFileDataObject[1], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxFileDataObject, "FileDataObject()\n"
    "\n"
    "wxFileDataObject is a specialization of wxDataObject for file names.");


sipClassTypeDef sipTypeDef__core_wxFileDataObject = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxFileDataObject,
        {0},
        0
    },
    {
        sipNameNr_FileDataObject,
        {0, 0, 1},
        8, methods_wxFileDataObject,
        0, 0,
        2, variables_wxFileDataObject,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxFileDataObject,
    -1,
    -1,
    supers_wxFileDataObject,
    0,
    init_type_wxFileDataObject,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxFileDataObject,
    0,
    0,
    0,
    release_wxFileDataObject,
    cast_wxFileDataObject,
    0,
    0,
    0,
    0,
    0,
    0
};
