/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.2
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/fswatcher.h>

        #include <wx/event.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxFileSystemWatcherEvent : public  ::wxFileSystemWatcherEvent
{
public:
    sipwxFileSystemWatcherEvent(int,int);
    sipwxFileSystemWatcherEvent(int, ::wxFSWWarningType,const  ::wxString&,int);
    sipwxFileSystemWatcherEvent(int,const  ::wxFileName&,const  ::wxFileName&,int);
    sipwxFileSystemWatcherEvent(const  ::wxFileSystemWatcherEvent&);
    virtual ~sipwxFileSystemWatcherEvent();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
     ::wxEvent* Clone() const;
     ::wxEventCategory GetEventCategory() const;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxFileSystemWatcherEvent(const sipwxFileSystemWatcherEvent &);
    sipwxFileSystemWatcherEvent &operator = (const sipwxFileSystemWatcherEvent &);

    char sipPyMethods[2];
};

sipwxFileSystemWatcherEvent::sipwxFileSystemWatcherEvent(int changeType,int watchid):  ::wxFileSystemWatcherEvent(changeType,watchid), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxFileSystemWatcherEvent::sipwxFileSystemWatcherEvent(int changeType, ::wxFSWWarningType warningType,const  ::wxString& errorMsg,int watchid):  ::wxFileSystemWatcherEvent(changeType,warningType,errorMsg,watchid), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxFileSystemWatcherEvent::sipwxFileSystemWatcherEvent(int changeType,const  ::wxFileName& path,const  ::wxFileName& newPath,int watchid):  ::wxFileSystemWatcherEvent(changeType,path,newPath,watchid), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxFileSystemWatcherEvent::sipwxFileSystemWatcherEvent(const  ::wxFileSystemWatcherEvent& a0):  ::wxFileSystemWatcherEvent(a0), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxFileSystemWatcherEvent::~sipwxFileSystemWatcherEvent()
{
    sipCommonDtor(sipPySelf);
}

 ::wxEvent* sipwxFileSystemWatcherEvent::Clone() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[0]),sipPySelf,NULL,sipName_Clone);

    if (!sipMeth)
        return  ::wxFileSystemWatcherEvent::Clone();

    extern  ::wxEvent* sipVH__core_82(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_82(sipGILState, 0, sipPySelf, sipMeth);
}

 ::wxEventCategory sipwxFileSystemWatcherEvent::GetEventCategory() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[1]),sipPySelf,NULL,sipName_GetEventCategory);

    if (!sipMeth)
        return  ::wxFileSystemWatcherEvent::GetEventCategory();

    extern  ::wxEventCategory sipVH__core_83(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_83(sipGILState, 0, sipPySelf, sipMeth);
}


PyDoc_STRVAR(doc_wxFileSystemWatcherEvent_GetPath, "GetPath() -> FileName\n"
    "\n"
    "Returns the path at which the event occurred.");

extern "C" {static PyObject *meth_wxFileSystemWatcherEvent_GetPath(PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemWatcherEvent_GetPath(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFileSystemWatcherEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFileSystemWatcherEvent, &sipCpp))
        {
             ::wxFileName*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxFileName(sipCpp->GetPath());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFileName,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemWatcherEvent, sipName_GetPath, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystemWatcherEvent_GetNewPath, "GetNewPath() -> FileName\n"
    "\n"
    "Returns the new path of the renamed file/directory if this is a rename\n"
    "event.");

extern "C" {static PyObject *meth_wxFileSystemWatcherEvent_GetNewPath(PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemWatcherEvent_GetNewPath(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFileSystemWatcherEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFileSystemWatcherEvent, &sipCpp))
        {
             ::wxFileName*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxFileName(sipCpp->GetNewPath());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFileName,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemWatcherEvent, sipName_GetNewPath, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystemWatcherEvent_GetChangeType, "GetChangeType() -> int\n"
    "\n"
    "Returns the type of file system change that occurred.");

extern "C" {static PyObject *meth_wxFileSystemWatcherEvent_GetChangeType(PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemWatcherEvent_GetChangeType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFileSystemWatcherEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFileSystemWatcherEvent, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetChangeType();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemWatcherEvent, sipName_GetChangeType, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystemWatcherEvent_IsError, "IsError() -> bool\n"
    "\n"
    "Returns true if this error is an error event.");

extern "C" {static PyObject *meth_wxFileSystemWatcherEvent_IsError(PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemWatcherEvent_IsError(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFileSystemWatcherEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFileSystemWatcherEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsError();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemWatcherEvent, sipName_IsError, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystemWatcherEvent_GetErrorDescription, "GetErrorDescription() -> String\n"
    "\n"
    "Return a description of the warning or error if this is an error\n"
    "event.");

extern "C" {static PyObject *meth_wxFileSystemWatcherEvent_GetErrorDescription(PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemWatcherEvent_GetErrorDescription(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFileSystemWatcherEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFileSystemWatcherEvent, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetErrorDescription());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemWatcherEvent, sipName_GetErrorDescription, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystemWatcherEvent_GetWarningType, "GetWarningType() -> FSWWarningType\n"
    "\n"
    "Return the type of the warning if this event is a warning one.");

extern "C" {static PyObject *meth_wxFileSystemWatcherEvent_GetWarningType(PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemWatcherEvent_GetWarningType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFileSystemWatcherEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFileSystemWatcherEvent, &sipCpp))
        {
             ::wxFSWWarningType sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetWarningType();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(sipRes,sipType_wxFSWWarningType);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemWatcherEvent, sipName_GetWarningType, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystemWatcherEvent_ToString, "ToString() -> String\n"
    "\n"
    "Returns a wxString describing an event, useful for logging, debugging\n"
    "or testing.");

extern "C" {static PyObject *meth_wxFileSystemWatcherEvent_ToString(PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemWatcherEvent_ToString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxFileSystemWatcherEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFileSystemWatcherEvent, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->ToString());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemWatcherEvent, sipName_ToString, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFileSystemWatcherEvent_Clone, "Clone(self) -> Event");

extern "C" {static PyObject *meth_wxFileSystemWatcherEvent_Clone(PyObject *, PyObject *);}
static PyObject *meth_wxFileSystemWatcherEvent_Clone(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxFileSystemWatcherEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFileSystemWatcherEvent, &sipCpp))
        {
             ::wxEvent*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxFileSystemWatcherEvent::Clone() : sipCpp->Clone());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxEvent,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FileSystemWatcherEvent, sipName_Clone, doc_wxFileSystemWatcherEvent_Clone);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxFileSystemWatcherEvent(void *, const sipTypeDef *);}
static void *cast_wxFileSystemWatcherEvent(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxFileSystemWatcherEvent *sipCpp = reinterpret_cast< ::wxFileSystemWatcherEvent *>(sipCppV);

    if (targetType == sipType_wxEvent)
        return static_cast< ::wxEvent *>(sipCpp);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxFileSystemWatcherEvent(void *, int);}
static void release_wxFileSystemWatcherEvent(void *sipCppV, int sipIsDerived)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipIsDerived)
        delete reinterpret_cast<sipwxFileSystemWatcherEvent *>(sipCppV);
    else
        delete reinterpret_cast< ::wxFileSystemWatcherEvent *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxFileSystemWatcherEvent(sipSimpleWrapper *);}
static void dealloc_wxFileSystemWatcherEvent(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxFileSystemWatcherEvent *>(sipGetAddress(sipSelf))->sipPySelf = NULL;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxFileSystemWatcherEvent(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxFileSystemWatcherEvent(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxFileSystemWatcherEvent(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxFileSystemWatcherEvent *sipCpp = 0;

    {
        int changeType = 0;
        int watchid = wxID_ANY;

        static const char *sipKwdList[] = {
            sipName_changeType,
            sipName_watchid,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|ii", &changeType, &watchid))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxFileSystemWatcherEvent(changeType,watchid);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        int changeType;
         ::wxFSWWarningType warningType;
        const  ::wxString* errorMsg;
        int errorMsgState = 0;
        int watchid = wxID_ANY;

        static const char *sipKwdList[] = {
            sipName_changeType,
            sipName_warningType,
            sipName_errorMsg,
            sipName_watchid,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "iEJ1|i", &changeType, sipType_wxFSWWarningType, &warningType, sipType_wxString,&errorMsg, &errorMsgState, &watchid))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxFileSystemWatcherEvent(changeType,warningType,*errorMsg,watchid);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(errorMsg),sipType_wxString,errorMsgState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        int changeType;
        const  ::wxFileName* path;
        int pathState = 0;
        const  ::wxFileName* newPath;
        int newPathState = 0;
        int watchid = wxID_ANY;

        static const char *sipKwdList[] = {
            sipName_changeType,
            sipName_path,
            sipName_newPath,
            sipName_watchid,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "iJ1J1|i", &changeType, sipType_wxFileName,&path, &pathState, sipType_wxFileName,&newPath, &newPathState, &watchid))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxFileSystemWatcherEvent(changeType,*path,*newPath,watchid);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxFileName *>(path),sipType_wxFileName,pathState);
            sipReleaseType(const_cast< ::wxFileName *>(newPath),sipType_wxFileName,newPathState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxFileSystemWatcherEvent* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxFileSystemWatcherEvent, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxFileSystemWatcherEvent(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxFileSystemWatcherEvent[] = {{135, 255, 1}};


static PyMethodDef methods_wxFileSystemWatcherEvent[] = {
    {SIP_MLNAME_CAST(sipName_Clone), meth_wxFileSystemWatcherEvent_Clone, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFileSystemWatcherEvent_Clone)},
    {SIP_MLNAME_CAST(sipName_GetChangeType), meth_wxFileSystemWatcherEvent_GetChangeType, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFileSystemWatcherEvent_GetChangeType)},
    {SIP_MLNAME_CAST(sipName_GetErrorDescription), meth_wxFileSystemWatcherEvent_GetErrorDescription, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFileSystemWatcherEvent_GetErrorDescription)},
    {SIP_MLNAME_CAST(sipName_GetNewPath), meth_wxFileSystemWatcherEvent_GetNewPath, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFileSystemWatcherEvent_GetNewPath)},
    {SIP_MLNAME_CAST(sipName_GetPath), meth_wxFileSystemWatcherEvent_GetPath, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFileSystemWatcherEvent_GetPath)},
    {SIP_MLNAME_CAST(sipName_GetWarningType), meth_wxFileSystemWatcherEvent_GetWarningType, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFileSystemWatcherEvent_GetWarningType)},
    {SIP_MLNAME_CAST(sipName_IsError), meth_wxFileSystemWatcherEvent_IsError, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFileSystemWatcherEvent_IsError)},
    {SIP_MLNAME_CAST(sipName_ToString), meth_wxFileSystemWatcherEvent_ToString, METH_VARARGS, SIP_MLDOC_CAST(doc_wxFileSystemWatcherEvent_ToString)}
};

sipVariableDef variables_wxFileSystemWatcherEvent[] = {
    {PropertyVariable, sipName_WarningType, &methods_wxFileSystemWatcherEvent[5], NULL, NULL, NULL},
    {PropertyVariable, sipName_Path, &methods_wxFileSystemWatcherEvent[4], NULL, NULL, NULL},
    {PropertyVariable, sipName_NewPath, &methods_wxFileSystemWatcherEvent[3], NULL, NULL, NULL},
    {PropertyVariable, sipName_ErrorDescription, &methods_wxFileSystemWatcherEvent[2], NULL, NULL, NULL},
    {PropertyVariable, sipName_ChangeType, &methods_wxFileSystemWatcherEvent[1], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxFileSystemWatcherEvent, "FileSystemWatcherEvent(changeType=0, watchid=ID_ANY)\n"
    "FileSystemWatcherEvent(changeType, warningType, errorMsg, watchid=ID_ANY)\n"
    "FileSystemWatcherEvent(changeType, path, newPath, watchid=ID_ANY)\n"
    "\n"
    "A class of events sent when a file system event occurs.");


sipClassTypeDef sipTypeDef__core_wxFileSystemWatcherEvent = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxFileSystemWatcherEvent,
        {0},
        0
    },
    {
        sipNameNr_FileSystemWatcherEvent,
        {0, 0, 1},
        8, methods_wxFileSystemWatcherEvent,
        0, 0,
        5, variables_wxFileSystemWatcherEvent,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxFileSystemWatcherEvent,
    -1,
    -1,
    supers_wxFileSystemWatcherEvent,
    0,
    init_type_wxFileSystemWatcherEvent,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxFileSystemWatcherEvent,
    0,
    0,
    0,
    release_wxFileSystemWatcherEvent,
    cast_wxFileSystemWatcherEvent,
    0,
    0,
    0,
    0,
    0,
    0
};
