/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.2
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/fontenum.h>



class sipwxFontEnumerator : public  ::wxFontEnumerator
{
public:
    sipwxFontEnumerator();
    virtual ~sipwxFontEnumerator();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    bool OnFontEncoding(const  ::wxString&,const  ::wxString&);
    bool OnFacename(const  ::wxString&);
    bool EnumerateFacenames( ::wxFontEncoding,bool);
    bool EnumerateEncodings(const  ::wxString&);

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxFontEnumerator(const sipwxFontEnumerator &);
    sipwxFontEnumerator &operator = (const sipwxFontEnumerator &);

    char sipPyMethods[4];
};

sipwxFontEnumerator::sipwxFontEnumerator():  ::wxFontEnumerator(), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxFontEnumerator::~sipwxFontEnumerator()
{
    sipCommonDtor(sipPySelf);
}

bool sipwxFontEnumerator::OnFontEncoding(const  ::wxString& font,const  ::wxString& encoding)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[0],sipPySelf,NULL,sipName_OnFontEncoding);

    if (!sipMeth)
        return  ::wxFontEnumerator::OnFontEncoding(font,encoding);

    extern bool sipVH__core_21(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&,const  ::wxString&);

    return sipVH__core_21(sipGILState, 0, sipPySelf, sipMeth, font, encoding);
}

bool sipwxFontEnumerator::OnFacename(const  ::wxString& font)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[1],sipPySelf,NULL,sipName_OnFacename);

    if (!sipMeth)
        return  ::wxFontEnumerator::OnFacename(font);

    extern bool sipVH__core_11(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&);

    return sipVH__core_11(sipGILState, 0, sipPySelf, sipMeth, font);
}

bool sipwxFontEnumerator::EnumerateFacenames( ::wxFontEncoding encoding,bool fixedWidthOnly)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[2],sipPySelf,NULL,sipName_EnumerateFacenames);

    if (!sipMeth)
        return  ::wxFontEnumerator::EnumerateFacenames(encoding,fixedWidthOnly);

    extern bool sipVH__core_205(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxFontEncoding,bool);

    return sipVH__core_205(sipGILState, 0, sipPySelf, sipMeth, encoding, fixedWidthOnly);
}

bool sipwxFontEnumerator::EnumerateEncodings(const  ::wxString& font)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[3],sipPySelf,NULL,sipName_EnumerateEncodings);

    if (!sipMeth)
        return  ::wxFontEnumerator::EnumerateEncodings(font);

    extern bool sipVH__core_11(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&);

    return sipVH__core_11(sipGILState, 0, sipPySelf, sipMeth, font);
}


PyDoc_STRVAR(doc_wxFontEnumerator_EnumerateEncodings, "EnumerateEncodings(font=EmptyString) -> bool\n"
    "\n"
    "Call OnFontEncoding() for each encoding supported by the given font -\n"
    "or for each encoding supported by at least some font if font is not\n"
    "specified.");

extern "C" {static PyObject *meth_wxFontEnumerator_EnumerateEncodings(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontEnumerator_EnumerateEncodings(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString& fontdef = wxEmptyString;
        const  ::wxString* font = &fontdef;
        int fontState = 0;
         ::wxFontEnumerator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_font,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|J1", &sipSelf, sipType_wxFontEnumerator, &sipCpp, sipType_wxString,&font, &fontState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxFontEnumerator::EnumerateEncodings(*font) : sipCpp->EnumerateEncodings(*font));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(font),sipType_wxString,fontState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontEnumerator, sipName_EnumerateEncodings, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFontEnumerator_EnumerateFacenames, "EnumerateFacenames(encoding=FONTENCODING_SYSTEM, fixedWidthOnly=False) -> bool\n"
    "\n"
    "Call OnFacename() for each font which supports given encoding (only if\n"
    "it is not wxFONTENCODING_SYSTEM) and is of fixed width (if\n"
    "fixedWidthOnly is true).");

extern "C" {static PyObject *meth_wxFontEnumerator_EnumerateFacenames(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontEnumerator_EnumerateFacenames(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxFontEncoding encoding = wxFONTENCODING_SYSTEM;
        bool fixedWidthOnly = 0;
         ::wxFontEnumerator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_encoding,
            sipName_fixedWidthOnly,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|Eb", &sipSelf, sipType_wxFontEnumerator, &sipCpp, sipType_wxFontEncoding, &encoding, &fixedWidthOnly))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxFontEnumerator::EnumerateFacenames(encoding,fixedWidthOnly) : sipCpp->EnumerateFacenames(encoding,fixedWidthOnly));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontEnumerator, sipName_EnumerateFacenames, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFontEnumerator_OnFacename, "OnFacename(font) -> bool\n"
    "\n"
    "Called by EnumerateFacenames() for each match.");

extern "C" {static PyObject *meth_wxFontEnumerator_OnFacename(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontEnumerator_OnFacename(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* font;
        int fontState = 0;
         ::wxFontEnumerator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_font,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxFontEnumerator, &sipCpp, sipType_wxString,&font, &fontState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxFontEnumerator::OnFacename(*font) : sipCpp->OnFacename(*font));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(font),sipType_wxString,fontState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontEnumerator, sipName_OnFacename, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFontEnumerator_OnFontEncoding, "OnFontEncoding(font, encoding) -> bool\n"
    "\n"
    "Called by EnumerateEncodings() for each match.");

extern "C" {static PyObject *meth_wxFontEnumerator_OnFontEncoding(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontEnumerator_OnFontEncoding(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* font;
        int fontState = 0;
        const  ::wxString* encoding;
        int encodingState = 0;
         ::wxFontEnumerator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_font,
            sipName_encoding,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxFontEnumerator, &sipCpp, sipType_wxString,&font, &fontState, sipType_wxString,&encoding, &encodingState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxFontEnumerator::OnFontEncoding(*font,*encoding) : sipCpp->OnFontEncoding(*font,*encoding));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(font),sipType_wxString,fontState);
            sipReleaseType(const_cast< ::wxString *>(encoding),sipType_wxString,encodingState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontEnumerator, sipName_OnFontEncoding, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFontEnumerator_GetEncodings, "GetEncodings(facename=EmptyString) -> ArrayString\n"
    "\n"
    "Return array of strings containing all encodings found by\n"
    "EnumerateEncodings().");

extern "C" {static PyObject *meth_wxFontEnumerator_GetEncodings(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontEnumerator_GetEncodings(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString& facenamedef = wxEmptyString;
        const  ::wxString* facename = &facenamedef;
        int facenameState = 0;

        static const char *sipKwdList[] = {
            sipName_facename,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "|J1", sipType_wxString,&facename, &facenameState))
        {
             ::wxArrayString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxArrayString( ::wxFontEnumerator::GetEncodings(*facename));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(facename),sipType_wxString,facenameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxArrayString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontEnumerator, sipName_GetEncodings, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFontEnumerator_GetFacenames, "GetFacenames(encoding=FONTENCODING_SYSTEM, fixedWidthOnly=False) -> ArrayString\n"
    "\n"
    "Return array of strings containing all facenames found by\n"
    "EnumerateFacenames().");

extern "C" {static PyObject *meth_wxFontEnumerator_GetFacenames(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontEnumerator_GetFacenames(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxFontEncoding encoding = wxFONTENCODING_SYSTEM;
        bool fixedWidthOnly = 0;

        static const char *sipKwdList[] = {
            sipName_encoding,
            sipName_fixedWidthOnly,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "|Eb", sipType_wxFontEncoding, &encoding, &fixedWidthOnly))
        {
             ::wxArrayString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxArrayString( ::wxFontEnumerator::GetFacenames(encoding,fixedWidthOnly));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxArrayString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontEnumerator, sipName_GetFacenames, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxFontEnumerator_IsValidFacename, "IsValidFacename(facename) -> bool\n"
    "\n"
    "Returns true if the given string is valid face name, i.e.");

extern "C" {static PyObject *meth_wxFontEnumerator_IsValidFacename(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontEnumerator_IsValidFacename(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* facename;
        int facenameState = 0;

        static const char *sipKwdList[] = {
            sipName_facename,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&facename, &facenameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxFontEnumerator::IsValidFacename(*facename);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(facename),sipType_wxString,facenameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontEnumerator, sipName_IsValidFacename, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxFontEnumerator(void *, int);}
static void release_wxFontEnumerator(void *sipCppV, int sipIsDerived)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipIsDerived)
        delete reinterpret_cast<sipwxFontEnumerator *>(sipCppV);
    else
        delete reinterpret_cast< ::wxFontEnumerator *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxFontEnumerator(sipSimpleWrapper *);}
static void dealloc_wxFontEnumerator(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxFontEnumerator *>(sipGetAddress(sipSelf))->sipPySelf = NULL;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxFontEnumerator(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxFontEnumerator(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxFontEnumerator(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxFontEnumerator *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxFontEnumerator();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return NULL;
}


static PyMethodDef methods_wxFontEnumerator[] = {
    {SIP_MLNAME_CAST(sipName_EnumerateEncodings), (PyCFunction)meth_wxFontEnumerator_EnumerateEncodings, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontEnumerator_EnumerateEncodings)},
    {SIP_MLNAME_CAST(sipName_EnumerateFacenames), (PyCFunction)meth_wxFontEnumerator_EnumerateFacenames, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontEnumerator_EnumerateFacenames)},
    {SIP_MLNAME_CAST(sipName_GetEncodings), (PyCFunction)meth_wxFontEnumerator_GetEncodings, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontEnumerator_GetEncodings)},
    {SIP_MLNAME_CAST(sipName_GetFacenames), (PyCFunction)meth_wxFontEnumerator_GetFacenames, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontEnumerator_GetFacenames)},
    {SIP_MLNAME_CAST(sipName_IsValidFacename), (PyCFunction)meth_wxFontEnumerator_IsValidFacename, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontEnumerator_IsValidFacename)},
    {SIP_MLNAME_CAST(sipName_OnFacename), (PyCFunction)meth_wxFontEnumerator_OnFacename, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontEnumerator_OnFacename)},
    {SIP_MLNAME_CAST(sipName_OnFontEncoding), (PyCFunction)meth_wxFontEnumerator_OnFontEncoding, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontEnumerator_OnFontEncoding)}
};

PyDoc_STRVAR(doc_wxFontEnumerator, "FontEnumerator()\n"
    "\n"
    "wxFontEnumerator enumerates either all available fonts on the system\n"
    "or only the ones with given attributes - either only fixed-width\n"
    "(suited for use in programs such as terminal emulators and the like)\n"
    "or the fonts available in the given encoding).");


sipClassTypeDef sipTypeDef__core_wxFontEnumerator = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxFontEnumerator,
        {0},
        0
    },
    {
        sipNameNr_FontEnumerator,
        {0, 0, 1},
        7, methods_wxFontEnumerator,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxFontEnumerator,
    -1,
    -1,
    0,
    0,
    init_type_wxFontEnumerator,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxFontEnumerator,
    0,
    0,
    0,
    release_wxFontEnumerator,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
