/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.2
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/gbsizer.h>

    PyObject* _wxGBSpan_Get(wxGBSpan* self)
    {
        wxPyThreadBlocker blocker;
        return sipBuildResult(0, "(ii)", self->GetRowspan(), self->GetColspan());
    }
    void _wxGBSpan_Set(wxGBSpan* self, int rowspan, int colspan)
    {
        self->SetRowspan(rowspan);
        self->SetColspan(colspan);
    }


PyDoc_STRVAR(doc_wxGBSpan_GetColspan, "GetColspan() -> int\n"
    "\n"
    "Get the current colspan value.");

extern "C" {static PyObject *meth_wxGBSpan_GetColspan(PyObject *, PyObject *);}
static PyObject *meth_wxGBSpan_GetColspan(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxGBSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGBSpan, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetColspan();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GBSpan, sipName_GetColspan, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGBSpan_GetRowspan, "GetRowspan() -> int\n"
    "\n"
    "Get the current rowspan value.");

extern "C" {static PyObject *meth_wxGBSpan_GetRowspan(PyObject *, PyObject *);}
static PyObject *meth_wxGBSpan_GetRowspan(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxGBSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGBSpan, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetRowspan();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GBSpan, sipName_GetRowspan, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGBSpan_SetColspan, "SetColspan(colspan)\n"
    "\n"
    "Set a new colspan value.");

extern "C" {static PyObject *meth_wxGBSpan_SetColspan(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGBSpan_SetColspan(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int colspan;
         ::wxGBSpan *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colspan,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxGBSpan, &sipCpp, &colspan))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetColspan(colspan);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GBSpan, sipName_SetColspan, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGBSpan_SetRowspan, "SetRowspan(rowspan)\n"
    "\n"
    "Set a new rowspan value.");

extern "C" {static PyObject *meth_wxGBSpan_SetRowspan(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGBSpan_SetRowspan(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int rowspan;
         ::wxGBSpan *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rowspan,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxGBSpan, &sipCpp, &rowspan))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetRowspan(rowspan);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GBSpan, sipName_SetRowspan, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGBSpan_Get, "Get() -> (rowspan, colspan)\n"
    "\n"
    "Return the rowspan and colspan properties as a tuple.");

extern "C" {static PyObject *meth_wxGBSpan_Get(PyObject *, PyObject *);}
static PyObject *meth_wxGBSpan_Get(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxGBSpan *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGBSpan, &sipCpp))
        {
            PyObject * sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxGBSpan_Get(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GBSpan, sipName_Get, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGBSpan_Set, "Set(rowspan=0, colspan=0)\n"
    "\n"
    "Set both the rowspan and colspan properties.");

extern "C" {static PyObject *meth_wxGBSpan_Set(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGBSpan_Set(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int rowspan = 0;
        int colspan = 0;
         ::wxGBSpan *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rowspan,
            sipName_colspan,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|ii", &sipSelf, sipType_wxGBSpan, &sipCpp, &rowspan, &colspan))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxGBSpan_Set(sipCpp, rowspan, colspan);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GBSpan, sipName_Set, NULL);

    return NULL;
}


extern "C" {static PyObject *slot_wxGBSpan___eq__(PyObject *,PyObject *);}
static PyObject *slot_wxGBSpan___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxGBSpan *sipCpp = reinterpret_cast< ::wxGBSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxGBSpan));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxGBSpan* o;
        int oState = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_wxGBSpan, &o, &oState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxGBSpan::operator==(*o);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxGBSpan *>(o),sipType_wxGBSpan,oState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, eq_slot, sipType_wxGBSpan, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxGBSpan___ne__(PyObject *,PyObject *);}
static PyObject *slot_wxGBSpan___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxGBSpan *sipCpp = reinterpret_cast< ::wxGBSpan *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxGBSpan));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const  ::wxGBSpan* o;
        int oState = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_wxGBSpan, &o, &oState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxGBSpan::operator!=(*o);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxGBSpan *>(o),sipType_wxGBSpan,oState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI__core, ne_slot, sipType_wxGBSpan, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_wxGBSpan(void *, int);}
static void release_wxGBSpan(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxGBSpan *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxGBSpan(void *, SIP_SSIZE_T, const void *);}
static void assign_wxGBSpan(void *sipDst, SIP_SSIZE_T sipDstIdx, const void *sipSrc)
{
    reinterpret_cast< ::wxGBSpan *>(sipDst)[sipDstIdx] = *reinterpret_cast<const  ::wxGBSpan *>(sipSrc);
}


extern "C" {static void *array_wxGBSpan(SIP_SSIZE_T);}
static void *array_wxGBSpan(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxGBSpan[sipNrElem];
}


extern "C" {static void *copy_wxGBSpan(const void *, SIP_SSIZE_T);}
static void *copy_wxGBSpan(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxGBSpan(reinterpret_cast<const  ::wxGBSpan *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxGBSpan(sipSimpleWrapper *);}
static void dealloc_wxGBSpan(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxGBSpan(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxGBSpan(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxGBSpan(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxGBSpan *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxGBSpan();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        int rowspan;
        int colspan;

        static const char *sipKwdList[] = {
            sipName_rowspan,
            sipName_colspan,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "ii", &rowspan, &colspan))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxGBSpan(rowspan,colspan);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxGBSpan* a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J1", sipType_wxGBSpan, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxGBSpan(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxGBSpan *>(a0),sipType_wxGBSpan,a0State);

            return sipCpp;
        }
    }

    return NULL;
}


extern "C" {static int convertTo_wxGBSpan(PyObject *, void **, int *, PyObject *);}
static int convertTo_wxGBSpan(PyObject *sipPy,void **sipCppPtrV,int *sipIsErr,PyObject *sipTransferObj)
{
     ::wxGBSpan **sipCppPtr = reinterpret_cast< ::wxGBSpan **>(sipCppPtrV);

        // is it just a typecheck?
        if (!sipIsErr) {
            // is it already an instance of wxGBSpan?
            if (sipCanConvertToType(sipPy, sipType_wxGBSpan, SIP_NO_CONVERTORS))
                return 1;
        
            if (wxPyNumberSequenceCheck(sipPy, 2)) {
                return 1;
            }
            return 0;
        }
        
         // otherwise do the conversion
         if (sipCanConvertToType(sipPy, sipType_wxGBSpan, SIP_NO_CONVERTORS)) {
             // Just fetch the existing instance
             *sipCppPtr = reinterpret_cast<wxGBSpan*>(sipConvertToType(
                     sipPy, sipType_wxGBSpan, sipTransferObj, SIP_NO_CONVERTORS, 0, sipIsErr));
             return 0;  // not a new instance
         }
        
         // or create a new instance
         PyObject* o1 = PySequence_ITEM(sipPy, 0);
         PyObject* o2 = PySequence_ITEM(sipPy, 1);
         *sipCppPtr = new wxGBSpan(wxPyInt_AsLong(o1), wxPyInt_AsLong(o2));
         Py_DECREF(o1);
         Py_DECREF(o2);
         return SIP_TEMPORARY;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxGBSpan[] = {
    {(void *)slot_wxGBSpan___eq__, eq_slot},
    {(void *)slot_wxGBSpan___ne__, ne_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxGBSpan[] = {
    {SIP_MLNAME_CAST(sipName_Get), meth_wxGBSpan_Get, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGBSpan_Get)},
    {SIP_MLNAME_CAST(sipName_GetColspan), meth_wxGBSpan_GetColspan, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGBSpan_GetColspan)},
    {SIP_MLNAME_CAST(sipName_GetRowspan), meth_wxGBSpan_GetRowspan, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGBSpan_GetRowspan)},
    {SIP_MLNAME_CAST(sipName_Set), (PyCFunction)meth_wxGBSpan_Set, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGBSpan_Set)},
    {SIP_MLNAME_CAST(sipName_SetColspan), (PyCFunction)meth_wxGBSpan_SetColspan, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGBSpan_SetColspan)},
    {SIP_MLNAME_CAST(sipName_SetRowspan), (PyCFunction)meth_wxGBSpan_SetRowspan, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGBSpan_SetRowspan)}
};

sipVariableDef variables_wxGBSpan[] = {
    {PropertyVariable, sipName_colspan, &methods_wxGBSpan[1], &methods_wxGBSpan[4], NULL, NULL},
    {PropertyVariable, sipName_rowspan, &methods_wxGBSpan[2], &methods_wxGBSpan[5], NULL, NULL},
    {PropertyVariable, sipName_Colspan, &methods_wxGBSpan[1], &methods_wxGBSpan[4], NULL, NULL},
    {PropertyVariable, sipName_Rowspan, &methods_wxGBSpan[2], &methods_wxGBSpan[5], NULL, NULL},
};

PyDoc_STRVAR(doc_wxGBSpan, "GBSpan()\n"
    "GBSpan(rowspan, colspan)\n"
    "\n"
    "This class is used to hold the row and column spanning attributes of\n"
    "items in a wxGridBagSizer.");


sipClassTypeDef sipTypeDef__core_wxGBSpan = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxGBSpan,
        {0},
        0
    },
    {
        sipNameNr_GBSpan,
        {0, 0, 1},
        6, methods_wxGBSpan,
        0, 0,
        4, variables_wxGBSpan,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxGBSpan,
    -1,
    -1,
    0,
    slots_wxGBSpan,
    init_type_wxGBSpan,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxGBSpan,
    assign_wxGBSpan,
    array_wxGBSpan,
    copy_wxGBSpan,
    release_wxGBSpan,
    0,
    convertTo_wxGBSpan,
    0,
    0,
    0,
    0,
    0
};
