/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.2
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/graphics.h>

        #include <wx/colour.h>


PyDoc_STRVAR(doc_wxGraphicsGradientStop_GetColour, "GetColour() -> Colour\n"
    "\n"
    "Return the stop colour.");

extern "C" {static PyObject *meth_wxGraphicsGradientStop_GetColour(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsGradientStop_GetColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxGraphicsGradientStop *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsGradientStop, &sipCpp))
        {
             ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxColour(sipCpp->GetColour());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxColour,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsGradientStop, sipName_GetColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsGradientStop_SetColour, "SetColour(col)\n"
    "\n"
    "Change the stop colour.");

extern "C" {static PyObject *meth_wxGraphicsGradientStop_SetColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsGradientStop_SetColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxColour* col;
        int colState = 0;
         ::wxGraphicsGradientStop *sipCpp;

        static const char *sipKwdList[] = {
            sipName_col,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxGraphicsGradientStop, &sipCpp, sipType_wxColour, &col, &colState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetColour(*col);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(col),sipType_wxColour,colState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsGradientStop, sipName_SetColour, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsGradientStop_GetPosition, "GetPosition() -> float\n"
    "\n"
    "Return the stop position.");

extern "C" {static PyObject *meth_wxGraphicsGradientStop_GetPosition(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsGradientStop_GetPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxGraphicsGradientStop *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsGradientStop, &sipCpp))
        {
            float sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPosition();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsGradientStop, sipName_GetPosition, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxGraphicsGradientStop_SetPosition, "SetPosition(pos)\n"
    "\n"
    "Change the stop position.");

extern "C" {static PyObject *meth_wxGraphicsGradientStop_SetPosition(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsGradientStop_SetPosition(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        float pos;
         ::wxGraphicsGradientStop *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bf", &sipSelf, sipType_wxGraphicsGradientStop, &sipCpp, &pos))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPosition(pos);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_GraphicsGradientStop, sipName_SetPosition, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxGraphicsGradientStop(void *, int);}
static void release_wxGraphicsGradientStop(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxGraphicsGradientStop *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxGraphicsGradientStop(void *, SIP_SSIZE_T, const void *);}
static void assign_wxGraphicsGradientStop(void *sipDst, SIP_SSIZE_T sipDstIdx, const void *sipSrc)
{
    reinterpret_cast< ::wxGraphicsGradientStop *>(sipDst)[sipDstIdx] = *reinterpret_cast<const  ::wxGraphicsGradientStop *>(sipSrc);
}


extern "C" {static void *array_wxGraphicsGradientStop(SIP_SSIZE_T);}
static void *array_wxGraphicsGradientStop(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxGraphicsGradientStop[sipNrElem];
}


extern "C" {static void *copy_wxGraphicsGradientStop(const void *, SIP_SSIZE_T);}
static void *copy_wxGraphicsGradientStop(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxGraphicsGradientStop(reinterpret_cast<const  ::wxGraphicsGradientStop *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxGraphicsGradientStop(sipSimpleWrapper *);}
static void dealloc_wxGraphicsGradientStop(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxGraphicsGradientStop(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxGraphicsGradientStop(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxGraphicsGradientStop(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxGraphicsGradientStop *sipCpp = 0;

    {
         ::wxColour coldef = wxTransparentColour;
         ::wxColour* col = &coldef;
        int colState = 0;
        float pos = 0;

        static const char *sipKwdList[] = {
            sipName_col,
            sipName_pos,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J1f", sipType_wxColour, &col, &colState, &pos))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxGraphicsGradientStop(*col,pos);
            Py_END_ALLOW_THREADS
            sipReleaseType(col,sipType_wxColour,colState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxGraphicsGradientStop* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxGraphicsGradientStop, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxGraphicsGradientStop(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return NULL;
}


static PyMethodDef methods_wxGraphicsGradientStop[] = {
    {SIP_MLNAME_CAST(sipName_GetColour), meth_wxGraphicsGradientStop_GetColour, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGraphicsGradientStop_GetColour)},
    {SIP_MLNAME_CAST(sipName_GetPosition), meth_wxGraphicsGradientStop_GetPosition, METH_VARARGS, SIP_MLDOC_CAST(doc_wxGraphicsGradientStop_GetPosition)},
    {SIP_MLNAME_CAST(sipName_SetColour), (PyCFunction)meth_wxGraphicsGradientStop_SetColour, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsGradientStop_SetColour)},
    {SIP_MLNAME_CAST(sipName_SetPosition), (PyCFunction)meth_wxGraphicsGradientStop_SetPosition, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxGraphicsGradientStop_SetPosition)}
};

sipVariableDef variables_wxGraphicsGradientStop[] = {
    {PropertyVariable, sipName_Position, &methods_wxGraphicsGradientStop[1], &methods_wxGraphicsGradientStop[3], NULL, NULL},
    {PropertyVariable, sipName_Colour, &methods_wxGraphicsGradientStop[0], &methods_wxGraphicsGradientStop[2], NULL, NULL},
};

PyDoc_STRVAR(doc_wxGraphicsGradientStop, "GraphicsGradientStop(col=TransparentColour, pos=0.)\n"
    "\n"
    "Represents a single gradient stop in a collection of gradient stops as\n"
    "represented by wxGraphicsGradientStops.");


sipClassTypeDef sipTypeDef__core_wxGraphicsGradientStop = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxGraphicsGradientStop,
        {0},
        0
    },
    {
        sipNameNr_GraphicsGradientStop,
        {0, 0, 1},
        4, methods_wxGraphicsGradientStop,
        0, 0,
        2, variables_wxGraphicsGradientStop,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxGraphicsGradientStop,
    -1,
    -1,
    0,
    0,
    init_type_wxGraphicsGradientStop,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxGraphicsGradientStop,
    assign_wxGraphicsGradientStop,
    array_wxGraphicsGradientStop,
    copy_wxGraphicsGradientStop,
    release_wxGraphicsGradientStop,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
