/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.2
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/help.h>

        #include <wx/window.h>
        #include <wx/gdicmn.h>
        #include <wx/gdicmn.h>
        #include <wx/frame.h>
        #include <wx/object.h>
        #include <wx/object.h>


PyDoc_STRVAR(doc_wxHelpControllerBase_Initialize, "Initialize(file) -> bool\n"
    "Initialize(file, server) -> bool\n"
    "\n"
    "Initializes the help instance with a help filename, and optionally a\n"
    "server socket number if using wxHelp (now obsolete).");

extern "C" {static PyObject *meth_wxHelpControllerBase_Initialize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_Initialize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* file;
        int fileState = 0;
         ::wxHelpControllerBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_file,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxHelpControllerBase, &sipCpp, sipType_wxString,&file, &fileState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxHelpControllerBase::Initialize(*file) : sipCpp->Initialize(*file));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(file),sipType_wxString,fileState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxString* file;
        int fileState = 0;
        int server;
         ::wxHelpControllerBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_file,
            sipName_server,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1i", &sipSelf, sipType_wxHelpControllerBase, &sipCpp, sipType_wxString,&file, &fileState, &server))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxHelpControllerBase::Initialize(*file,server) : sipCpp->Initialize(*file,server));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(file),sipType_wxString,fileState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_Initialize, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_DisplayBlock, "DisplayBlock(blockNo) -> bool\n"
    "\n"
    "If the help viewer is not running, runs it and displays the file at\n"
    "the given block number.");

extern "C" {static PyObject *meth_wxHelpControllerBase_DisplayBlock(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_DisplayBlock(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
        long blockNo;
         ::wxHelpControllerBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_blockNo,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bl", &sipSelf, sipType_wxHelpControllerBase, &sipCpp, &blockNo))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_HelpControllerBase, sipName_DisplayBlock);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->DisplayBlock(blockNo);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_DisplayBlock, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_DisplayContents, "DisplayContents() -> bool\n"
    "\n"
    "If the help viewer is not running, runs it and displays the contents.");

extern "C" {static PyObject *meth_wxHelpControllerBase_DisplayContents(PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_DisplayContents(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
         ::wxHelpControllerBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHelpControllerBase, &sipCpp))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_HelpControllerBase, sipName_DisplayContents);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->DisplayContents();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_DisplayContents, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_DisplayContextPopup, "DisplayContextPopup(contextId) -> bool\n"
    "\n"
    "Displays the section as a popup window using a context id.");

extern "C" {static PyObject *meth_wxHelpControllerBase_DisplayContextPopup(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_DisplayContextPopup(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        int contextId;
         ::wxHelpControllerBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_contextId,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxHelpControllerBase, &sipCpp, &contextId))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxHelpControllerBase::DisplayContextPopup(contextId) : sipCpp->DisplayContextPopup(contextId));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_DisplayContextPopup, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_DisplaySection, "DisplaySection(section) -> bool\n"
    "DisplaySection(sectionNo) -> bool\n"
    "\n"
    "If the help viewer is not running, runs it and displays the given\n"
    "section.");

extern "C" {static PyObject *meth_wxHelpControllerBase_DisplaySection(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_DisplaySection(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxString* section;
        int sectionState = 0;
         ::wxHelpControllerBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_section,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxHelpControllerBase, &sipCpp, sipType_wxString,&section, &sectionState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxHelpControllerBase::DisplaySection(*section) : sipCpp->DisplaySection(*section));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(section),sipType_wxString,sectionState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        int sectionNo;
         ::wxHelpControllerBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sectionNo,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxHelpControllerBase, &sipCpp, &sectionNo))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_HelpControllerBase, sipName_DisplaySection);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->DisplaySection(sectionNo);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_DisplaySection, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_DisplayTextPopup, "DisplayTextPopup(text, pos) -> bool\n"
    "\n"
    "Displays the text in a popup window, if possible.");

extern "C" {static PyObject *meth_wxHelpControllerBase_DisplayTextPopup(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_DisplayTextPopup(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* text;
        int textState = 0;
        const  ::wxPoint* pos;
        int posState = 0;
         ::wxHelpControllerBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxHelpControllerBase, &sipCpp, sipType_wxString,&text, &textState, sipType_wxPoint, &pos, &posState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxHelpControllerBase::DisplayTextPopup(*text,*pos) : sipCpp->DisplayTextPopup(*text,*pos));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);
            sipReleaseType(const_cast< ::wxPoint *>(pos),sipType_wxPoint,posState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_DisplayTextPopup, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_GetFrameParameters, "GetFrameParameters() -> (Frame, size, pos, newFrameEachTime)\n"
    "\n"
    "For wxHtmlHelpController, returns the latest frame size and position\n"
    "settings and whether a new frame is drawn with each invocation.");

extern "C" {static PyObject *meth_wxHelpControllerBase_GetFrameParameters(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_GetFrameParameters(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxSize* size;
         ::wxPoint* pos;
        bool newFrameEachTime;
         ::wxHelpControllerBase *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, "B", &sipSelf, sipType_wxHelpControllerBase, &sipCpp))
        {
             ::wxFrame*sipRes;
            size = new  ::wxSize();
            pos = new  ::wxPoint();

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxHelpControllerBase::GetFrameParameters(size,pos,&newFrameEachTime) : sipCpp->GetFrameParameters(size,pos,&newFrameEachTime));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            PyObject *sipResObj = sipConvertFromType(sipRes,sipType_wxFrame,NULL);
            return sipBuildResult(0,"(RNNb)",sipResObj,size,sipType_wxSize,NULL,pos,sipType_wxPoint,NULL,newFrameEachTime);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_GetFrameParameters, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_GetParentWindow, "GetParentWindow() -> Window\n"
    "\n"
    "Returns the window to be used as the parent for the help window.");

extern "C" {static PyObject *meth_wxHelpControllerBase_GetParentWindow(PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_GetParentWindow(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxHelpControllerBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHelpControllerBase, &sipCpp))
        {
             ::wxWindow*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxHelpControllerBase::GetParentWindow() : sipCpp->GetParentWindow());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxWindow,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_GetParentWindow, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_KeywordSearch, "KeywordSearch(keyWord, mode=HELP_SEARCH_ALL) -> bool\n"
    "\n"
    "If the help viewer is not running, runs it, and searches for sections\n"
    "matching the given keyword.");

extern "C" {static PyObject *meth_wxHelpControllerBase_KeywordSearch(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_KeywordSearch(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxString* keyWord;
        int keyWordState = 0;
         ::wxHelpSearchMode mode = wxHELP_SEARCH_ALL;
         ::wxHelpControllerBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_keyWord,
            sipName_mode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|E", &sipSelf, sipType_wxHelpControllerBase, &sipCpp, sipType_wxString,&keyWord, &keyWordState, sipType_wxHelpSearchMode, &mode))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_HelpControllerBase, sipName_KeywordSearch);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->KeywordSearch(*keyWord,mode);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(keyWord),sipType_wxString,keyWordState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_KeywordSearch, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_LoadFile, "LoadFile(file=EmptyString) -> bool\n"
    "\n"
    "If the help viewer is not running, runs it and loads the given file.");

extern "C" {static PyObject *meth_wxHelpControllerBase_LoadFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_LoadFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxString& filedef = wxEmptyString;
        const  ::wxString* file = &filedef;
        int fileState = 0;
         ::wxHelpControllerBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_file,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|J1", &sipSelf, sipType_wxHelpControllerBase, &sipCpp, sipType_wxString,&file, &fileState))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_HelpControllerBase, sipName_LoadFile);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadFile(*file);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(file),sipType_wxString,fileState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_LoadFile, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_OnQuit, "OnQuit()\n"
    "\n"
    "Overridable member called when this application's viewer is quit by\n"
    "the user.");

extern "C" {static PyObject *meth_wxHelpControllerBase_OnQuit(PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_OnQuit(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxHelpControllerBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHelpControllerBase, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxHelpControllerBase::OnQuit() : sipCpp->OnQuit());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_OnQuit, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_Quit, "Quit() -> bool\n"
    "\n"
    "If the viewer is running, quits it by disconnecting.");

extern "C" {static PyObject *meth_wxHelpControllerBase_Quit(PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_Quit(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
         ::wxHelpControllerBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHelpControllerBase, &sipCpp))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_HelpControllerBase, sipName_Quit);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Quit();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_Quit, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_SetFrameParameters, "SetFrameParameters(titleFormat, size, pos=DefaultPosition, newFrameEachTime=False)\n"
    "\n"
    "Set the parameters of the frame window.");

extern "C" {static PyObject *meth_wxHelpControllerBase_SetFrameParameters(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_SetFrameParameters(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* titleFormat;
        int titleFormatState = 0;
        const  ::wxSize* size;
        int sizeState = 0;
        const  ::wxPoint& posdef = wxDefaultPosition;
        const  ::wxPoint* pos = &posdef;
        int posState = 0;
        bool newFrameEachTime = 0;
         ::wxHelpControllerBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_titleFormat,
            sipName_size,
            sipName_pos,
            sipName_newFrameEachTime,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1|J1b", &sipSelf, sipType_wxHelpControllerBase, &sipCpp, sipType_wxString,&titleFormat, &titleFormatState, sipType_wxSize, &size, &sizeState, sipType_wxPoint, &pos, &posState, &newFrameEachTime))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxHelpControllerBase::SetFrameParameters(*titleFormat,*size,*pos,newFrameEachTime) : sipCpp->SetFrameParameters(*titleFormat,*size,*pos,newFrameEachTime));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(titleFormat),sipType_wxString,titleFormatState);
            sipReleaseType(const_cast< ::wxSize *>(size),sipType_wxSize,sizeState);
            sipReleaseType(const_cast< ::wxPoint *>(pos),sipType_wxPoint,posState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_SetFrameParameters, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_SetParentWindow, "SetParentWindow(parentWindow)\n"
    "\n"
    "Sets the window to be used as the parent for the help window.");

extern "C" {static PyObject *meth_wxHelpControllerBase_SetParentWindow(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_SetParentWindow(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxWindow* parentWindow;
         ::wxHelpControllerBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_parentWindow,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxHelpControllerBase, &sipCpp, sipType_wxWindow, &parentWindow))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxHelpControllerBase::SetParentWindow(parentWindow) : sipCpp->SetParentWindow(parentWindow));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_SetParentWindow, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHelpControllerBase_SetViewer, "SetViewer(viewer, flags=HELP_NETSCAPE)\n"
    "\n"
    "Sets detailed viewer information.");

extern "C" {static PyObject *meth_wxHelpControllerBase_SetViewer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpControllerBase_SetViewer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* viewer;
        int viewerState = 0;
        long flags = wxHELP_NETSCAPE;
         ::wxHelpControllerBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_viewer,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|l", &sipSelf, sipType_wxHelpControllerBase, &sipCpp, sipType_wxString,&viewer, &viewerState, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxHelpControllerBase::SetViewer(*viewer,flags) : sipCpp->SetViewer(*viewer,flags));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(viewer),sipType_wxString,viewerState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HelpControllerBase, sipName_SetViewer, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxHelpControllerBase(void *, const sipTypeDef *);}
static void *cast_wxHelpControllerBase(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxHelpControllerBase *sipCpp = reinterpret_cast< ::wxHelpControllerBase *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxHelpControllerBase(void *, int);}
static void release_wxHelpControllerBase(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxHelpControllerBase *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxHelpControllerBase(sipSimpleWrapper *);}
static void dealloc_wxHelpControllerBase(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxHelpControllerBase(sipGetAddress(sipSelf), 0);
    }
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxHelpControllerBase[] = {{349, 255, 1}};


static PyMethodDef methods_wxHelpControllerBase[] = {
    {SIP_MLNAME_CAST(sipName_DisplayBlock), (PyCFunction)meth_wxHelpControllerBase_DisplayBlock, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHelpControllerBase_DisplayBlock)},
    {SIP_MLNAME_CAST(sipName_DisplayContents), meth_wxHelpControllerBase_DisplayContents, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHelpControllerBase_DisplayContents)},
    {SIP_MLNAME_CAST(sipName_DisplayContextPopup), (PyCFunction)meth_wxHelpControllerBase_DisplayContextPopup, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHelpControllerBase_DisplayContextPopup)},
    {SIP_MLNAME_CAST(sipName_DisplaySection), (PyCFunction)meth_wxHelpControllerBase_DisplaySection, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHelpControllerBase_DisplaySection)},
    {SIP_MLNAME_CAST(sipName_DisplayTextPopup), (PyCFunction)meth_wxHelpControllerBase_DisplayTextPopup, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHelpControllerBase_DisplayTextPopup)},
    {SIP_MLNAME_CAST(sipName_GetFrameParameters), (PyCFunction)meth_wxHelpControllerBase_GetFrameParameters, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHelpControllerBase_GetFrameParameters)},
    {SIP_MLNAME_CAST(sipName_GetParentWindow), meth_wxHelpControllerBase_GetParentWindow, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHelpControllerBase_GetParentWindow)},
    {SIP_MLNAME_CAST(sipName_Initialize), (PyCFunction)meth_wxHelpControllerBase_Initialize, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHelpControllerBase_Initialize)},
    {SIP_MLNAME_CAST(sipName_KeywordSearch), (PyCFunction)meth_wxHelpControllerBase_KeywordSearch, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHelpControllerBase_KeywordSearch)},
    {SIP_MLNAME_CAST(sipName_LoadFile), (PyCFunction)meth_wxHelpControllerBase_LoadFile, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHelpControllerBase_LoadFile)},
    {SIP_MLNAME_CAST(sipName_OnQuit), meth_wxHelpControllerBase_OnQuit, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHelpControllerBase_OnQuit)},
    {SIP_MLNAME_CAST(sipName_Quit), meth_wxHelpControllerBase_Quit, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHelpControllerBase_Quit)},
    {SIP_MLNAME_CAST(sipName_SetFrameParameters), (PyCFunction)meth_wxHelpControllerBase_SetFrameParameters, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHelpControllerBase_SetFrameParameters)},
    {SIP_MLNAME_CAST(sipName_SetParentWindow), (PyCFunction)meth_wxHelpControllerBase_SetParentWindow, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHelpControllerBase_SetParentWindow)},
    {SIP_MLNAME_CAST(sipName_SetViewer), (PyCFunction)meth_wxHelpControllerBase_SetViewer, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHelpControllerBase_SetViewer)}
};

sipVariableDef variables_wxHelpControllerBase[] = {
    {PropertyVariable, sipName_ParentWindow, &methods_wxHelpControllerBase[6], &methods_wxHelpControllerBase[13], NULL, NULL},
    {PropertyVariable, sipName_FrameParameters, &methods_wxHelpControllerBase[5], &methods_wxHelpControllerBase[12], NULL, NULL},
};

PyDoc_STRVAR(doc_wxHelpControllerBase, "HelpControllerBase(parentWindow=None)\n"
    "\n"
    "This is the abstract base class a family of classes by which\n"
    "applications may invoke a help viewer to provide on-line help.");


sipClassTypeDef sipTypeDef__core_wxHelpControllerBase = {
    {
        -1,
        0,
        0,
        SIP_TYPE_ABSTRACT|SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxHelpControllerBase,
        {0},
        0
    },
    {
        sipNameNr_HelpControllerBase,
        {0, 0, 1},
        15, methods_wxHelpControllerBase,
        0, 0,
        2, variables_wxHelpControllerBase,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxHelpControllerBase,
    -1,
    -1,
    supers_wxHelpControllerBase,
    0,
    0,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxHelpControllerBase,
    0,
    0,
    0,
    release_wxHelpControllerBase,
    cast_wxHelpControllerBase,
    0,
    0,
    0,
    0,
    0,
    0
};
