/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.2
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/cshelp.h>

        #include <wx/gdicmn.h>
        #include <wx/event.h>


PyDoc_STRVAR(doc_wxHelpProvider_AddHelp, "AddHelp(window, text)\n"
    "AddHelp(id, text)\n"
    "\n"
    "Associates the text with the given window.");

extern "C" {static PyObject *meth_wxHelpProvider_AddHelp(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpProvider_AddHelp(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxWindowBase* window;
        const  ::wxString* text;
        int textState = 0;
         ::wxHelpProvider *sipCpp;

        static const char *sipKwdList[] = {
            sipName_window,
            sipName_text,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8J1", &sipSelf, sipType_wxHelpProvider, &sipCpp, sipType_wxWindowBase, &window, sipType_wxString,&text, &textState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxHelpProvider::AddHelp(window,*text) : sipCpp->AddHelp(window,*text));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
         ::wxWindowID id;
        const  ::wxString* text;
        int textState = 0;
         ::wxHelpProvider *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_text,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BiJ1", &sipSelf, sipType_wxHelpProvider, &sipCpp, &id, sipType_wxString,&text, &textState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxHelpProvider::AddHelp(id,*text) : sipCpp->AddHelp(id,*text));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HelpProvider, sipName_AddHelp, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHelpProvider_GetHelp, "GetHelp(window) -> String\n"
    "\n"
    "This version associates the given text with all windows with this id.");

extern "C" {static PyObject *meth_wxHelpProvider_GetHelp(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpProvider_GetHelp(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxWindowBase* window;
         ::wxHelpProvider *sipCpp;

        static const char *sipKwdList[] = {
            sipName_window,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxHelpProvider, &sipCpp, sipType_wxWindowBase, &window))
        {
             ::wxString*sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_HelpProvider, sipName_GetHelp);
                return NULL;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetHelp(window));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HelpProvider, sipName_GetHelp, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHelpProvider_RemoveHelp, "RemoveHelp(window)\n"
    "\n"
    "Removes the association between the window pointer and the help text.");

extern "C" {static PyObject *meth_wxHelpProvider_RemoveHelp(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpProvider_RemoveHelp(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxWindowBase* window;
         ::wxHelpProvider *sipCpp;

        static const char *sipKwdList[] = {
            sipName_window,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxHelpProvider, &sipCpp, sipType_wxWindowBase, &window))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxHelpProvider::RemoveHelp(window) : sipCpp->RemoveHelp(window));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HelpProvider, sipName_RemoveHelp, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHelpProvider_ShowHelp, "ShowHelp(window) -> bool\n"
    "\n"
    "Shows help for the given window.");

extern "C" {static PyObject *meth_wxHelpProvider_ShowHelp(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpProvider_ShowHelp(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxWindowBase* window;
         ::wxHelpProvider *sipCpp;

        static const char *sipKwdList[] = {
            sipName_window,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxHelpProvider, &sipCpp, sipType_wxWindowBase, &window))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxHelpProvider::ShowHelp(window) : sipCpp->ShowHelp(window));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HelpProvider, sipName_ShowHelp, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHelpProvider_ShowHelpAtPoint, "ShowHelpAtPoint(window, point, origin) -> bool\n"
    "\n"
    "This function may be overridden to show help for the window when it\n"
    "should depend on the position inside the window, By default this\n"
    "method forwards to ShowHelp(), so it is enough to only implement the\n"
    "latter if the help doesn't depend on the position.");

extern "C" {static PyObject *meth_wxHelpProvider_ShowHelpAtPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpProvider_ShowHelpAtPoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxWindowBase* window;
        const  ::wxPoint* point;
        int pointState = 0;
         ::wxHelpEvent::Origin origin;
         ::wxHelpProvider *sipCpp;

        static const char *sipKwdList[] = {
            sipName_window,
            sipName_point,
            sipName_origin,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8J1E", &sipSelf, sipType_wxHelpProvider, &sipCpp, sipType_wxWindowBase, &window, sipType_wxPoint, &point, &pointState, sipType_wxHelpEvent_Origin, &origin))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxHelpProvider::ShowHelpAtPoint(window,*point,origin) : sipCpp->ShowHelpAtPoint(window,*point,origin));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(point),sipType_wxPoint,pointState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HelpProvider, sipName_ShowHelpAtPoint, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHelpProvider_Get, "Get() -> HelpProvider\n"
    "\n"
    "Returns pointer to help provider instance.");

extern "C" {static PyObject *meth_wxHelpProvider_Get(PyObject *, PyObject *);}
static PyObject *meth_wxHelpProvider_Get(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxHelpProvider*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxHelpProvider::Get();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxHelpProvider,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HelpProvider, sipName_Get, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHelpProvider_Set, "Set(helpProvider) -> HelpProvider\n"
    "\n"
    "Set the current, application-wide help provider.");

extern "C" {static PyObject *meth_wxHelpProvider_Set(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHelpProvider_Set(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxHelpProvider* helpProvider;

        static const char *sipKwdList[] = {
            sipName_helpProvider,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J:", sipType_wxHelpProvider, &helpProvider))
        {
             ::wxHelpProvider*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxHelpProvider::Set(helpProvider);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxHelpProvider,Py_None);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HelpProvider, sipName_Set, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxHelpProvider(void *, int);}
static void release_wxHelpProvider(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxHelpProvider *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxHelpProvider(sipSimpleWrapper *);}
static void dealloc_wxHelpProvider(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxHelpProvider(sipGetAddress(sipSelf), 0);
    }
}


static PyMethodDef methods_wxHelpProvider[] = {
    {SIP_MLNAME_CAST(sipName_AddHelp), (PyCFunction)meth_wxHelpProvider_AddHelp, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHelpProvider_AddHelp)},
    {SIP_MLNAME_CAST(sipName_Get), meth_wxHelpProvider_Get, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHelpProvider_Get)},
    {SIP_MLNAME_CAST(sipName_GetHelp), (PyCFunction)meth_wxHelpProvider_GetHelp, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHelpProvider_GetHelp)},
    {SIP_MLNAME_CAST(sipName_RemoveHelp), (PyCFunction)meth_wxHelpProvider_RemoveHelp, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHelpProvider_RemoveHelp)},
    {SIP_MLNAME_CAST(sipName_Set), (PyCFunction)meth_wxHelpProvider_Set, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHelpProvider_Set)},
    {SIP_MLNAME_CAST(sipName_ShowHelp), (PyCFunction)meth_wxHelpProvider_ShowHelp, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHelpProvider_ShowHelp)},
    {SIP_MLNAME_CAST(sipName_ShowHelpAtPoint), (PyCFunction)meth_wxHelpProvider_ShowHelpAtPoint, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHelpProvider_ShowHelpAtPoint)}
};

PyDoc_STRVAR(doc_wxHelpProvider, "wxHelpProvider is an abstract class used by a program implementing\n"
    "context-sensitive help to show the help text for the given window.");


sipClassTypeDef sipTypeDef__core_wxHelpProvider = {
    {
        -1,
        0,
        0,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxHelpProvider,
        {0},
        0
    },
    {
        sipNameNr_HelpProvider,
        {0, 0, 1},
        7, methods_wxHelpProvider,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxHelpProvider,
    -1,
    -1,
    0,
    0,
    0,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxHelpProvider,
    0,
    0,
    0,
    release_wxHelpProvider,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
