/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.2
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/kbdstate.h>



PyDoc_STRVAR(doc_wxKeyboardState_GetModifiers, "GetModifiers() -> int\n"
    "\n"
    "Return the bit mask of all pressed modifier keys.");

extern "C" {static PyObject *meth_wxKeyboardState_GetModifiers(PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_GetModifiers(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxKeyboardState *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyboardState, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetModifiers();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_GetModifiers, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxKeyboardState_HasAnyModifiers, "HasAnyModifiers() -> bool\n"
    "\n"
    "Returns true if any modifiers at all are pressed.");

extern "C" {static PyObject *meth_wxKeyboardState_HasAnyModifiers(PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_HasAnyModifiers(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxKeyboardState *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyboardState, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasAnyModifiers();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_HasAnyModifiers, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxKeyboardState_HasModifiers, "HasModifiers() -> bool\n"
    "\n"
    "Returns true if Control or Alt are pressed.");

extern "C" {static PyObject *meth_wxKeyboardState_HasModifiers(PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_HasModifiers(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxKeyboardState *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyboardState, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasModifiers();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_HasModifiers, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxKeyboardState_ControlDown, "ControlDown() -> bool\n"
    "\n"
    "Returns true if the Control key or Apple/Command key under OS X is\n"
    "pressed.");

extern "C" {static PyObject *meth_wxKeyboardState_ControlDown(PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_ControlDown(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxKeyboardState *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyboardState, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ControlDown();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_ControlDown, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxKeyboardState_RawControlDown, "RawControlDown() -> bool\n"
    "\n"
    "Returns true if the Control key (also under OS X).");

extern "C" {static PyObject *meth_wxKeyboardState_RawControlDown(PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_RawControlDown(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxKeyboardState *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyboardState, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->RawControlDown();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_RawControlDown, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxKeyboardState_ShiftDown, "ShiftDown() -> bool\n"
    "\n"
    "Returns true if the Shift key is pressed.");

extern "C" {static PyObject *meth_wxKeyboardState_ShiftDown(PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_ShiftDown(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxKeyboardState *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyboardState, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ShiftDown();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_ShiftDown, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxKeyboardState_MetaDown, "MetaDown() -> bool\n"
    "\n"
    "Returns true if the Meta/Windows/Apple key is pressed.");

extern "C" {static PyObject *meth_wxKeyboardState_MetaDown(PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_MetaDown(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxKeyboardState *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyboardState, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MetaDown();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_MetaDown, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxKeyboardState_AltDown, "AltDown() -> bool\n"
    "\n"
    "Returns true if the Alt key is pressed.");

extern "C" {static PyObject *meth_wxKeyboardState_AltDown(PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_AltDown(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxKeyboardState *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyboardState, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->AltDown();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_AltDown, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxKeyboardState_CmdDown, "CmdDown() -> bool\n"
    "\n"
    "Returns true if the key used for command accelerators is pressed.");

extern "C" {static PyObject *meth_wxKeyboardState_CmdDown(PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_CmdDown(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxKeyboardState *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyboardState, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CmdDown();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_CmdDown, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxKeyboardState_SetControlDown, "SetControlDown(down)");

extern "C" {static PyObject *meth_wxKeyboardState_SetControlDown(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_SetControlDown(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool down;
         ::wxKeyboardState *sipCpp;

        static const char *sipKwdList[] = {
            sipName_down,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bb", &sipSelf, sipType_wxKeyboardState, &sipCpp, &down))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetControlDown(down);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_SetControlDown, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxKeyboardState_SetRawControlDown, "SetRawControlDown(down)");

extern "C" {static PyObject *meth_wxKeyboardState_SetRawControlDown(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_SetRawControlDown(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool down;
         ::wxKeyboardState *sipCpp;

        static const char *sipKwdList[] = {
            sipName_down,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bb", &sipSelf, sipType_wxKeyboardState, &sipCpp, &down))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetRawControlDown(down);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_SetRawControlDown, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxKeyboardState_SetShiftDown, "SetShiftDown(down)");

extern "C" {static PyObject *meth_wxKeyboardState_SetShiftDown(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_SetShiftDown(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool down;
         ::wxKeyboardState *sipCpp;

        static const char *sipKwdList[] = {
            sipName_down,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bb", &sipSelf, sipType_wxKeyboardState, &sipCpp, &down))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetShiftDown(down);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_SetShiftDown, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxKeyboardState_SetAltDown, "SetAltDown(down)");

extern "C" {static PyObject *meth_wxKeyboardState_SetAltDown(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_SetAltDown(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool down;
         ::wxKeyboardState *sipCpp;

        static const char *sipKwdList[] = {
            sipName_down,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bb", &sipSelf, sipType_wxKeyboardState, &sipCpp, &down))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetAltDown(down);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_SetAltDown, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxKeyboardState_SetMetaDown, "SetMetaDown(down)");

extern "C" {static PyObject *meth_wxKeyboardState_SetMetaDown(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_SetMetaDown(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool down;
         ::wxKeyboardState *sipCpp;

        static const char *sipKwdList[] = {
            sipName_down,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bb", &sipSelf, sipType_wxKeyboardState, &sipCpp, &down))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetMetaDown(down);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_SetMetaDown, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxKeyboardState(void *, int);}
static void release_wxKeyboardState(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxKeyboardState *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxKeyboardState(void *, SIP_SSIZE_T, const void *);}
static void assign_wxKeyboardState(void *sipDst, SIP_SSIZE_T sipDstIdx, const void *sipSrc)
{
    reinterpret_cast< ::wxKeyboardState *>(sipDst)[sipDstIdx] = *reinterpret_cast<const  ::wxKeyboardState *>(sipSrc);
}


extern "C" {static void *array_wxKeyboardState(SIP_SSIZE_T);}
static void *array_wxKeyboardState(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxKeyboardState[sipNrElem];
}


extern "C" {static void *copy_wxKeyboardState(const void *, SIP_SSIZE_T);}
static void *copy_wxKeyboardState(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxKeyboardState(reinterpret_cast<const  ::wxKeyboardState *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxKeyboardState(sipSimpleWrapper *);}
static void dealloc_wxKeyboardState(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxKeyboardState(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxKeyboardState(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxKeyboardState(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxKeyboardState *sipCpp = 0;

    {
        bool controlDown = 0;
        bool shiftDown = 0;
        bool altDown = 0;
        bool metaDown = 0;

        static const char *sipKwdList[] = {
            sipName_controlDown,
            sipName_shiftDown,
            sipName_altDown,
            sipName_metaDown,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|bbbb", &controlDown, &shiftDown, &altDown, &metaDown))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxKeyboardState(controlDown,shiftDown,altDown,metaDown);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxKeyboardState* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxKeyboardState, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxKeyboardState(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return NULL;
}


static PyMethodDef methods_wxKeyboardState[] = {
    {SIP_MLNAME_CAST(sipName_AltDown), meth_wxKeyboardState_AltDown, METH_VARARGS, SIP_MLDOC_CAST(doc_wxKeyboardState_AltDown)},
    {SIP_MLNAME_CAST(sipName_CmdDown), meth_wxKeyboardState_CmdDown, METH_VARARGS, SIP_MLDOC_CAST(doc_wxKeyboardState_CmdDown)},
    {SIP_MLNAME_CAST(sipName_ControlDown), meth_wxKeyboardState_ControlDown, METH_VARARGS, SIP_MLDOC_CAST(doc_wxKeyboardState_ControlDown)},
    {SIP_MLNAME_CAST(sipName_GetModifiers), meth_wxKeyboardState_GetModifiers, METH_VARARGS, SIP_MLDOC_CAST(doc_wxKeyboardState_GetModifiers)},
    {SIP_MLNAME_CAST(sipName_HasAnyModifiers), meth_wxKeyboardState_HasAnyModifiers, METH_VARARGS, SIP_MLDOC_CAST(doc_wxKeyboardState_HasAnyModifiers)},
    {SIP_MLNAME_CAST(sipName_HasModifiers), meth_wxKeyboardState_HasModifiers, METH_VARARGS, SIP_MLDOC_CAST(doc_wxKeyboardState_HasModifiers)},
    {SIP_MLNAME_CAST(sipName_MetaDown), meth_wxKeyboardState_MetaDown, METH_VARARGS, SIP_MLDOC_CAST(doc_wxKeyboardState_MetaDown)},
    {SIP_MLNAME_CAST(sipName_RawControlDown), meth_wxKeyboardState_RawControlDown, METH_VARARGS, SIP_MLDOC_CAST(doc_wxKeyboardState_RawControlDown)},
    {SIP_MLNAME_CAST(sipName_SetAltDown), (PyCFunction)meth_wxKeyboardState_SetAltDown, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxKeyboardState_SetAltDown)},
    {SIP_MLNAME_CAST(sipName_SetControlDown), (PyCFunction)meth_wxKeyboardState_SetControlDown, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxKeyboardState_SetControlDown)},
    {SIP_MLNAME_CAST(sipName_SetMetaDown), (PyCFunction)meth_wxKeyboardState_SetMetaDown, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxKeyboardState_SetMetaDown)},
    {SIP_MLNAME_CAST(sipName_SetRawControlDown), (PyCFunction)meth_wxKeyboardState_SetRawControlDown, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxKeyboardState_SetRawControlDown)},
    {SIP_MLNAME_CAST(sipName_SetShiftDown), (PyCFunction)meth_wxKeyboardState_SetShiftDown, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxKeyboardState_SetShiftDown)},
    {SIP_MLNAME_CAST(sipName_ShiftDown), meth_wxKeyboardState_ShiftDown, METH_VARARGS, SIP_MLDOC_CAST(doc_wxKeyboardState_ShiftDown)}
};

sipVariableDef variables_wxKeyboardState[] = {
    {PropertyVariable, sipName_cmdDown, &methods_wxKeyboardState[1], NULL, NULL, NULL},
    {PropertyVariable, sipName_metaDown, &methods_wxKeyboardState[6], &methods_wxKeyboardState[10], NULL, NULL},
    {PropertyVariable, sipName_altDown, &methods_wxKeyboardState[0], &methods_wxKeyboardState[8], NULL, NULL},
    {PropertyVariable, sipName_shiftDown, &methods_wxKeyboardState[13], &methods_wxKeyboardState[12], NULL, NULL},
    {PropertyVariable, sipName_rawControlDown, &methods_wxKeyboardState[7], &methods_wxKeyboardState[11], NULL, NULL},
    {PropertyVariable, sipName_controlDown, &methods_wxKeyboardState[2], &methods_wxKeyboardState[9], NULL, NULL},
};

PyDoc_STRVAR(doc_wxKeyboardState, "KeyboardState(controlDown=False, shiftDown=False, altDown=False, metaDown=False)\n"
    "\n"
    "Provides methods for testing the state of the keyboard modifier keys.");


sipClassTypeDef sipTypeDef__core_wxKeyboardState = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxKeyboardState,
        {0},
        0
    },
    {
        sipNameNr_KeyboardState,
        {0, 0, 1},
        14, methods_wxKeyboardState,
        0, 0,
        6, variables_wxKeyboardState,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxKeyboardState,
    -1,
    -1,
    0,
    0,
    init_type_wxKeyboardState,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxKeyboardState,
    assign_wxKeyboardState,
    array_wxKeyboardState,
    copy_wxKeyboardState,
    release_wxKeyboardState,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
