/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.2
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/intl.h>

        #include <wx/intl.h>
    int _wxLocale___nonzero__(wxLocale* self)
    {
        return self->IsOk();
    }


class sipwxLocale : public  ::wxLocale
{
public:
    sipwxLocale();
    sipwxLocale(int,int);
    sipwxLocale(const  ::wxString&,const  ::wxString&,const  ::wxString&,bool);
    virtual ~sipwxLocale();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    const  ::wxString& GetString(const  ::wxString&,const  ::wxString&,uint,const  ::wxString&) const;
    const  ::wxString& GetString(const  ::wxString&,const  ::wxString&) const;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxLocale(const sipwxLocale &);
    sipwxLocale &operator = (const sipwxLocale &);

    char sipPyMethods[2];
};

sipwxLocale::sipwxLocale():  ::wxLocale(), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxLocale::sipwxLocale(int language,int flags):  ::wxLocale(language,flags), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxLocale::sipwxLocale(const  ::wxString& name,const  ::wxString& shortName,const  ::wxString& locale,bool bLoadDefault):  ::wxLocale(name,shortName,locale,bLoadDefault), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxLocale::~sipwxLocale()
{
    sipCommonDtor(sipPySelf);
}

const  ::wxString& sipwxLocale::GetString(const  ::wxString& origString,const  ::wxString& origString2,uint n,const  ::wxString& domain) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[0]),sipPySelf,NULL,sipName_GetString);

    if (!sipMeth)
        return  ::wxLocale::GetString(origString,origString2,n,domain);

    extern const  ::wxString& sipVH__core_1(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&,const  ::wxString&,uint,const  ::wxString&);

    return sipVH__core_1(sipGILState, 0, sipPySelf, sipMeth, origString, origString2, n, domain);
}

const  ::wxString& sipwxLocale::GetString(const  ::wxString& origString,const  ::wxString& domain) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[1]),sipPySelf,NULL,sipName_GetString);

    if (!sipMeth)
        return  ::wxLocale::GetString(origString,domain);

    extern const  ::wxString& sipVH__core_0(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&,const  ::wxString&);

    return sipVH__core_0(sipGILState, 0, sipPySelf, sipMeth, origString, domain);
}


PyDoc_STRVAR(doc_wxLocale_AddCatalog, "AddCatalog(domain) -> bool\n"
    "AddCatalog(domain, msgIdLanguage) -> bool\n"
    "AddCatalog(domain, msgIdLanguage, msgIdCharset) -> bool\n"
    "\n"
    "Calls wxTranslations::AddCatalog(const wxString&).");

extern "C" {static PyObject *meth_wxLocale_AddCatalog(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLocale_AddCatalog(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* domain;
        int domainState = 0;
         ::wxLocale *sipCpp;

        static const char *sipKwdList[] = {
            sipName_domain,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxLocale, &sipCpp, sipType_wxString,&domain, &domainState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->AddCatalog(*domain);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(domain),sipType_wxString,domainState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxString* domain;
        int domainState = 0;
         ::wxLanguage msgIdLanguage;
         ::wxLocale *sipCpp;

        static const char *sipKwdList[] = {
            sipName_domain,
            sipName_msgIdLanguage,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1E", &sipSelf, sipType_wxLocale, &sipCpp, sipType_wxString,&domain, &domainState, sipType_wxLanguage, &msgIdLanguage))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->AddCatalog(*domain,msgIdLanguage);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(domain),sipType_wxString,domainState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxString* domain;
        int domainState = 0;
         ::wxLanguage msgIdLanguage;
        const  ::wxString* msgIdCharset;
        int msgIdCharsetState = 0;
         ::wxLocale *sipCpp;

        static const char *sipKwdList[] = {
            sipName_domain,
            sipName_msgIdLanguage,
            sipName_msgIdCharset,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1EJ1", &sipSelf, sipType_wxLocale, &sipCpp, sipType_wxString,&domain, &domainState, sipType_wxLanguage, &msgIdLanguage, sipType_wxString,&msgIdCharset, &msgIdCharsetState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->AddCatalog(*domain,msgIdLanguage,*msgIdCharset);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(domain),sipType_wxString,domainState);
            sipReleaseType(const_cast< ::wxString *>(msgIdCharset),sipType_wxString,msgIdCharsetState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Locale, sipName_AddCatalog, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLocale_GetCanonicalName, "GetCanonicalName() -> String\n"
    "\n"
    "Returns the canonical form of current locale name.");

extern "C" {static PyObject *meth_wxLocale_GetCanonicalName(PyObject *, PyObject *);}
static PyObject *meth_wxLocale_GetCanonicalName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxLocale *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxLocale, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetCanonicalName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Locale, sipName_GetCanonicalName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLocale_GetHeaderValue, "GetHeaderValue(header, domain=EmptyString) -> String\n"
    "\n"
    "Calls wxTranslations::GetHeaderValue().");

extern "C" {static PyObject *meth_wxLocale_GetHeaderValue(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLocale_GetHeaderValue(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* header;
        int headerState = 0;
        const  ::wxString& domaindef = wxEmptyString;
        const  ::wxString* domain = &domaindef;
        int domainState = 0;
        const  ::wxLocale *sipCpp;

        static const char *sipKwdList[] = {
            sipName_header,
            sipName_domain,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|J1", &sipSelf, sipType_wxLocale, &sipCpp, sipType_wxString,&header, &headerState, sipType_wxString,&domain, &domainState))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetHeaderValue(*header,*domain));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(header),sipType_wxString,headerState);
            sipReleaseType(const_cast< ::wxString *>(domain),sipType_wxString,domainState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Locale, sipName_GetHeaderValue, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLocale_GetLanguage, "GetLanguage() -> int\n"
    "\n"
    "Returns the wxLanguage constant of current language.");

extern "C" {static PyObject *meth_wxLocale_GetLanguage(PyObject *, PyObject *);}
static PyObject *meth_wxLocale_GetLanguage(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxLocale *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxLocale, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLanguage();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Locale, sipName_GetLanguage, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLocale_GetLocale, "GetLocale() -> String\n"
    "\n"
    "Returns the locale name as passed to the constructor or Init().");

extern "C" {static PyObject *meth_wxLocale_GetLocale(PyObject *, PyObject *);}
static PyObject *meth_wxLocale_GetLocale(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxLocale *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxLocale, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetLocale());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Locale, sipName_GetLocale, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLocale_GetName, "GetName() -> String\n"
    "\n"
    "Returns the current short name for the locale (as given to the\n"
    "constructor or the Init() function).");

extern "C" {static PyObject *meth_wxLocale_GetName(PyObject *, PyObject *);}
static PyObject *meth_wxLocale_GetName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxLocale *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxLocale, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Locale, sipName_GetName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLocale_GetString, "GetString(origString, domain=EmptyString) -> String\n"
    "GetString(origString, origString2, n, domain=EmptyString) -> String\n"
    "\n"
    "Calls wxGetTranslation(const wxString&, const wxString&).");

extern "C" {static PyObject *meth_wxLocale_GetString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLocale_GetString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* origString;
        int origStringState = 0;
        const  ::wxString& domaindef = wxEmptyString;
        const  ::wxString* domain = &domaindef;
        int domainState = 0;
        const  ::wxLocale *sipCpp;

        static const char *sipKwdList[] = {
            sipName_origString,
            sipName_domain,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|J1", &sipSelf, sipType_wxLocale, &sipCpp, sipType_wxString,&origString, &origStringState, sipType_wxString,&domain, &domainState))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString((sipSelfWasArg ? sipCpp-> ::wxLocale::GetString(*origString,*domain) : sipCpp->GetString(*origString,*domain)));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(origString),sipType_wxString,origStringState);
            sipReleaseType(const_cast< ::wxString *>(domain),sipType_wxString,domainState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    {
        const  ::wxString* origString;
        int origStringState = 0;
        const  ::wxString* origString2;
        int origString2State = 0;
        uint n;
        const  ::wxString& domaindef = wxEmptyString;
        const  ::wxString* domain = &domaindef;
        int domainState = 0;
        const  ::wxLocale *sipCpp;

        static const char *sipKwdList[] = {
            sipName_origString,
            sipName_origString2,
            sipName_n,
            sipName_domain,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1u|J1", &sipSelf, sipType_wxLocale, &sipCpp, sipType_wxString,&origString, &origStringState, sipType_wxString,&origString2, &origString2State, &n, sipType_wxString,&domain, &domainState))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString((sipSelfWasArg ? sipCpp-> ::wxLocale::GetString(*origString,*origString2,n,*domain) : sipCpp->GetString(*origString,*origString2,n,*domain)));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(origString),sipType_wxString,origStringState);
            sipReleaseType(const_cast< ::wxString *>(origString2),sipType_wxString,origString2State);
            sipReleaseType(const_cast< ::wxString *>(domain),sipType_wxString,domainState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Locale, sipName_GetString, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLocale_GetSysName, "GetSysName() -> String\n"
    "\n"
    "Returns current platform-specific locale name as passed to\n"
    "setlocale().");

extern "C" {static PyObject *meth_wxLocale_GetSysName(PyObject *, PyObject *);}
static PyObject *meth_wxLocale_GetSysName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxLocale *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxLocale, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetSysName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Locale, sipName_GetSysName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLocale_Init, "Init(language=LANGUAGE_DEFAULT, flags=LOCALE_LOAD_DEFAULT) -> bool\n"
    "Init(name, shortName=EmptyString, locale=EmptyString, bLoadDefault=True) -> bool\n"
    "\n"
    "Initializes the wxLocale instance.");

extern "C" {static PyObject *meth_wxLocale_Init(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLocale_Init(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int language = wxLANGUAGE_DEFAULT;
        int flags = wxLOCALE_LOAD_DEFAULT;
         ::wxLocale *sipCpp;

        static const char *sipKwdList[] = {
            sipName_language,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|ii", &sipSelf, sipType_wxLocale, &sipCpp, &language, &flags))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Init(language,flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxString& shortNamedef = wxEmptyString;
        const  ::wxString* shortName = &shortNamedef;
        int shortNameState = 0;
        const  ::wxString& localedef = wxEmptyString;
        const  ::wxString* locale = &localedef;
        int localeState = 0;
        bool bLoadDefault = 1;
         ::wxLocale *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_shortName,
            sipName_locale,
            sipName_bLoadDefault,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|J1J1b", &sipSelf, sipType_wxLocale, &sipCpp, sipType_wxString,&name, &nameState, sipType_wxString,&shortName, &shortNameState, sipType_wxString,&locale, &localeState, &bLoadDefault))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Init(*name,*shortName,*locale,bLoadDefault);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);
            sipReleaseType(const_cast< ::wxString *>(shortName),sipType_wxString,shortNameState);
            sipReleaseType(const_cast< ::wxString *>(locale),sipType_wxString,localeState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Locale, sipName_Init, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLocale_IsLoaded, "IsLoaded(domain) -> bool\n"
    "\n"
    "Calls wxTranslations::IsLoaded().");

extern "C" {static PyObject *meth_wxLocale_IsLoaded(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLocale_IsLoaded(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* domain;
        int domainState = 0;
        const  ::wxLocale *sipCpp;

        static const char *sipKwdList[] = {
            sipName_domain,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxLocale, &sipCpp, sipType_wxString,&domain, &domainState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsLoaded(*domain);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(domain),sipType_wxString,domainState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Locale, sipName_IsLoaded, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLocale_IsOk, "IsOk() -> bool\n"
    "\n"
    "Returns true if the locale could be set successfully.");

extern "C" {static PyObject *meth_wxLocale_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxLocale_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxLocale *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxLocale, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Locale, sipName_IsOk, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLocale_AddCatalogLookupPathPrefix, "AddCatalogLookupPathPrefix(prefix)\n"
    "\n"
    "Calls wxFileTranslationsLoader::AddCatalogLookupPathPrefix().");

extern "C" {static PyObject *meth_wxLocale_AddCatalogLookupPathPrefix(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLocale_AddCatalogLookupPathPrefix(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* prefix;
        int prefixState = 0;

        static const char *sipKwdList[] = {
            sipName_prefix,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&prefix, &prefixState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxLocale::AddCatalogLookupPathPrefix(*prefix);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(prefix),sipType_wxString,prefixState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Locale, sipName_AddCatalogLookupPathPrefix, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLocale_AddLanguage, "AddLanguage(info)\n"
    "\n"
    "Adds custom, user-defined language to the database of known languages.");

extern "C" {static PyObject *meth_wxLocale_AddLanguage(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLocale_AddLanguage(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxLanguageInfo* info;

        static const char *sipKwdList[] = {
            sipName_info,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J9", sipType_wxLanguageInfo, &info))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxLocale::AddLanguage(*info);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Locale, sipName_AddLanguage, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLocale_FindLanguageInfo, "FindLanguageInfo(locale) -> LanguageInfo\n"
    "\n"
    "This function may be used to find the language description structure\n"
    "for the given locale, specified either as a two letter ISO language\n"
    "code (for example, \"pt\"), a language code followed by the country code\n"
    "(\"pt_BR\") or a full, human readable, language description\n"
    "(\"Portuguese-Brazil\").");

extern "C" {static PyObject *meth_wxLocale_FindLanguageInfo(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLocale_FindLanguageInfo(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* locale;
        int localeState = 0;

        static const char *sipKwdList[] = {
            sipName_locale,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&locale, &localeState))
        {
            const  ::wxLanguageInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxLocale::FindLanguageInfo(*locale);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(locale),sipType_wxString,localeState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(const_cast< ::wxLanguageInfo *>(sipRes),sipType_wxLanguageInfo,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Locale, sipName_FindLanguageInfo, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLocale_GetLanguageInfo, "GetLanguageInfo(lang) -> LanguageInfo\n"
    "\n"
    "Returns a pointer to wxLanguageInfo structure containing information\n"
    "about the given language or NULL if this language is unknown.");

extern "C" {static PyObject *meth_wxLocale_GetLanguageInfo(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLocale_GetLanguageInfo(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int lang;

        static const char *sipKwdList[] = {
            sipName_lang,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "i", &lang))
        {
            const  ::wxLanguageInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxLocale::GetLanguageInfo(lang);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(const_cast< ::wxLanguageInfo *>(sipRes),sipType_wxLanguageInfo,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Locale, sipName_GetLanguageInfo, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLocale_GetLanguageName, "GetLanguageName(lang) -> String\n"
    "\n"
    "Returns English name of the given language or empty string if this\n"
    "language is unknown.");

extern "C" {static PyObject *meth_wxLocale_GetLanguageName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLocale_GetLanguageName(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int lang;

        static const char *sipKwdList[] = {
            sipName_lang,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "i", &lang))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString( ::wxLocale::GetLanguageName(lang));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Locale, sipName_GetLanguageName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLocale_GetLanguageCanonicalName, "GetLanguageCanonicalName(lang) -> String\n"
    "\n"
    "Returns canonical name (see GetCanonicalName()) of the given language\n"
    "or empty string if this language is unknown.");

extern "C" {static PyObject *meth_wxLocale_GetLanguageCanonicalName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLocale_GetLanguageCanonicalName(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int lang;

        static const char *sipKwdList[] = {
            sipName_lang,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "i", &lang))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString( ::wxLocale::GetLanguageCanonicalName(lang));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Locale, sipName_GetLanguageCanonicalName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLocale_GetSystemEncoding, "GetSystemEncoding() -> FontEncoding\n"
    "\n"
    "Tries to detect the user's default font encoding.");

extern "C" {static PyObject *meth_wxLocale_GetSystemEncoding(PyObject *, PyObject *);}
static PyObject *meth_wxLocale_GetSystemEncoding(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxFontEncoding sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxLocale::GetSystemEncoding();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(sipRes,sipType_wxFontEncoding);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Locale, sipName_GetSystemEncoding, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLocale_GetSystemEncodingName, "GetSystemEncodingName() -> String\n"
    "\n"
    "Tries to detect the name of the user's default font encoding.");

extern "C" {static PyObject *meth_wxLocale_GetSystemEncodingName(PyObject *, PyObject *);}
static PyObject *meth_wxLocale_GetSystemEncodingName(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString( ::wxLocale::GetSystemEncodingName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Locale, sipName_GetSystemEncodingName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLocale_GetSystemLanguage, "GetSystemLanguage() -> int\n"
    "\n"
    "Tries to detect the user's default locale setting.");

extern "C" {static PyObject *meth_wxLocale_GetSystemLanguage(PyObject *, PyObject *);}
static PyObject *meth_wxLocale_GetSystemLanguage(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxLocale::GetSystemLanguage();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Locale, sipName_GetSystemLanguage, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLocale_GetInfo, "GetInfo(index, cat=LOCALE_CAT_DEFAULT) -> String\n"
    "\n"
    "Get the values of the given locale-dependent datum.");

extern "C" {static PyObject *meth_wxLocale_GetInfo(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLocale_GetInfo(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxLocaleInfo index;
         ::wxLocaleCategory cat = wxLOCALE_CAT_DEFAULT;

        static const char *sipKwdList[] = {
            sipName_index,
            sipName_cat,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "E|E", sipType_wxLocaleInfo, &index, sipType_wxLocaleCategory, &cat))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString( ::wxLocale::GetInfo(index,cat));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Locale, sipName_GetInfo, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLocale_IsAvailable, "IsAvailable(lang) -> bool\n"
    "\n"
    "Check whether the operating system and/or C run time environment\n"
    "supports this locale.");

extern "C" {static PyObject *meth_wxLocale_IsAvailable(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLocale_IsAvailable(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int lang;

        static const char *sipKwdList[] = {
            sipName_lang,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "i", &lang))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxLocale::IsAvailable(lang);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Locale, sipName_IsAvailable, NULL);

    return NULL;
}


extern "C" {static int slot_wxLocale___nonzero__(PyObject *);}
static int slot_wxLocale___nonzero__(PyObject *sipSelf)
{
     ::wxLocale *sipCpp = reinterpret_cast< ::wxLocale *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxLocale));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxLocale___nonzero__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return -1;

            return sipRes;
        }
    }

    return 0;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxLocale(void *, int);}
static void release_wxLocale(void *sipCppV, int sipIsDerived)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipIsDerived)
        delete reinterpret_cast<sipwxLocale *>(sipCppV);
    else
        delete reinterpret_cast< ::wxLocale *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxLocale(sipSimpleWrapper *);}
static void dealloc_wxLocale(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxLocale *>(sipGetAddress(sipSelf))->sipPySelf = NULL;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxLocale(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxLocale(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxLocale(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxLocale *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxLocale();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        int language;
        int flags = wxLOCALE_LOAD_DEFAULT;

        static const char *sipKwdList[] = {
            sipName_language,
            sipName_flags,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "i|i", &language, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxLocale(language,flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxString& shortNamedef = wxEmptyString;
        const  ::wxString* shortName = &shortNamedef;
        int shortNameState = 0;
        const  ::wxString& localedef = wxEmptyString;
        const  ::wxString* locale = &localedef;
        int localeState = 0;
        bool bLoadDefault = 1;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_shortName,
            sipName_locale,
            sipName_bLoadDefault,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1|J1J1b", sipType_wxString,&name, &nameState, sipType_wxString,&shortName, &shortNameState, sipType_wxString,&locale, &localeState, &bLoadDefault))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxLocale(*name,*shortName,*locale,bLoadDefault);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);
            sipReleaseType(const_cast< ::wxString *>(shortName),sipType_wxString,shortNameState);
            sipReleaseType(const_cast< ::wxString *>(locale),sipType_wxString,localeState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxLocale[] = {
    {(void *)slot_wxLocale___nonzero__, bool_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxLocale[] = {
    {SIP_MLNAME_CAST(sipName_AddCatalog), (PyCFunction)meth_wxLocale_AddCatalog, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLocale_AddCatalog)},
    {SIP_MLNAME_CAST(sipName_AddCatalogLookupPathPrefix), (PyCFunction)meth_wxLocale_AddCatalogLookupPathPrefix, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLocale_AddCatalogLookupPathPrefix)},
    {SIP_MLNAME_CAST(sipName_AddLanguage), (PyCFunction)meth_wxLocale_AddLanguage, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLocale_AddLanguage)},
    {SIP_MLNAME_CAST(sipName_FindLanguageInfo), (PyCFunction)meth_wxLocale_FindLanguageInfo, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLocale_FindLanguageInfo)},
    {SIP_MLNAME_CAST(sipName_GetCanonicalName), meth_wxLocale_GetCanonicalName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxLocale_GetCanonicalName)},
    {SIP_MLNAME_CAST(sipName_GetHeaderValue), (PyCFunction)meth_wxLocale_GetHeaderValue, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLocale_GetHeaderValue)},
    {SIP_MLNAME_CAST(sipName_GetInfo), (PyCFunction)meth_wxLocale_GetInfo, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLocale_GetInfo)},
    {SIP_MLNAME_CAST(sipName_GetLanguage), meth_wxLocale_GetLanguage, METH_VARARGS, SIP_MLDOC_CAST(doc_wxLocale_GetLanguage)},
    {SIP_MLNAME_CAST(sipName_GetLanguageCanonicalName), (PyCFunction)meth_wxLocale_GetLanguageCanonicalName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLocale_GetLanguageCanonicalName)},
    {SIP_MLNAME_CAST(sipName_GetLanguageInfo), (PyCFunction)meth_wxLocale_GetLanguageInfo, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLocale_GetLanguageInfo)},
    {SIP_MLNAME_CAST(sipName_GetLanguageName), (PyCFunction)meth_wxLocale_GetLanguageName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLocale_GetLanguageName)},
    {SIP_MLNAME_CAST(sipName_GetLocale), meth_wxLocale_GetLocale, METH_VARARGS, SIP_MLDOC_CAST(doc_wxLocale_GetLocale)},
    {SIP_MLNAME_CAST(sipName_GetName), meth_wxLocale_GetName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxLocale_GetName)},
    {SIP_MLNAME_CAST(sipName_GetString), (PyCFunction)meth_wxLocale_GetString, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLocale_GetString)},
    {SIP_MLNAME_CAST(sipName_GetSysName), meth_wxLocale_GetSysName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxLocale_GetSysName)},
    {SIP_MLNAME_CAST(sipName_GetSystemEncoding), meth_wxLocale_GetSystemEncoding, METH_VARARGS, SIP_MLDOC_CAST(doc_wxLocale_GetSystemEncoding)},
    {SIP_MLNAME_CAST(sipName_GetSystemEncodingName), meth_wxLocale_GetSystemEncodingName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxLocale_GetSystemEncodingName)},
    {SIP_MLNAME_CAST(sipName_GetSystemLanguage), meth_wxLocale_GetSystemLanguage, METH_VARARGS, SIP_MLDOC_CAST(doc_wxLocale_GetSystemLanguage)},
    {SIP_MLNAME_CAST(sipName_Init), (PyCFunction)meth_wxLocale_Init, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLocale_Init)},
    {SIP_MLNAME_CAST(sipName_IsAvailable), (PyCFunction)meth_wxLocale_IsAvailable, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLocale_IsAvailable)},
    {SIP_MLNAME_CAST(sipName_IsLoaded), (PyCFunction)meth_wxLocale_IsLoaded, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLocale_IsLoaded)},
    {SIP_MLNAME_CAST(sipName_IsOk), meth_wxLocale_IsOk, METH_VARARGS, SIP_MLDOC_CAST(doc_wxLocale_IsOk)}
};

sipVariableDef variables_wxLocale[] = {
    {PropertyVariable, sipName_SysName, &methods_wxLocale[14], NULL, NULL, NULL},
    {PropertyVariable, sipName_Name, &methods_wxLocale[12], NULL, NULL, NULL},
    {PropertyVariable, sipName_Locale, &methods_wxLocale[11], NULL, NULL, NULL},
    {PropertyVariable, sipName_Language, &methods_wxLocale[7], NULL, NULL, NULL},
    {PropertyVariable, sipName_CanonicalName, &methods_wxLocale[4], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxLocale, "Locale()\n"
    "Locale(language, flags=LOCALE_LOAD_DEFAULT)\n"
    "Locale(name, shortName=EmptyString, locale=EmptyString, bLoadDefault=True)\n"
    "\n"
    "wxLocale class encapsulates all language-dependent settings and is a\n"
    "generalization of the C locale concept.");


sipClassTypeDef sipTypeDef__core_wxLocale = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxLocale,
        {0},
        0
    },
    {
        sipNameNr_Locale,
        {0, 0, 1},
        22, methods_wxLocale,
        0, 0,
        5, variables_wxLocale,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxLocale,
    -1,
    -1,
    0,
    slots_wxLocale,
    init_type_wxLocale,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxLocale,
    0,
    0,
    0,
    release_wxLocale,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
