/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.2
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/log.h>

        #include <wx/log.h>
        #include <wx/log.h>


class sipwxLog : public  ::wxLog
{
public:
    sipwxLog();
    sipwxLog(const  ::wxLog&);
    virtual ~sipwxLog();

    /*
     * There is a public method for every protected method visible from
     * this class.
     */
    void sipProtectVirt_DoLogRecord(bool, ::wxLogLevel,const  ::wxString&,const  ::wxLogRecordInfo&);
    void sipProtectVirt_DoLogTextAtLevel(bool, ::wxLogLevel,const  ::wxString&);
    void sipProtectVirt_DoLogText(bool,const  ::wxString&);

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    void DoLogText(const  ::wxString&);
    void DoLogTextAtLevel( ::wxLogLevel,const  ::wxString&);
    void DoLogRecord( ::wxLogLevel,const  ::wxString&,const  ::wxLogRecordInfo&);
    void Flush();

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxLog(const sipwxLog &);
    sipwxLog &operator = (const sipwxLog &);

    char sipPyMethods[4];
};

sipwxLog::sipwxLog():  ::wxLog(), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxLog::sipwxLog(const  ::wxLog& a0):  ::wxLog(a0), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxLog::~sipwxLog()
{
    sipCommonDtor(sipPySelf);
}

void sipwxLog::DoLogText(const  ::wxString& msg)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[0],sipPySelf,NULL,sipName_DoLogText);

    if (!sipMeth)
    {
         ::wxLog::DoLogText(msg);
        return;
    }

    extern void sipVH__core_38(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&);

    sipVH__core_38(sipGILState, 0, sipPySelf, sipMeth, msg);
}

void sipwxLog::DoLogTextAtLevel( ::wxLogLevel level,const  ::wxString& msg)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[1],sipPySelf,NULL,sipName_DoLogTextAtLevel);

    if (!sipMeth)
    {
         ::wxLog::DoLogTextAtLevel(level,msg);
        return;
    }

    extern void sipVH__core_37(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxLogLevel,const  ::wxString&);

    sipVH__core_37(sipGILState, 0, sipPySelf, sipMeth, level, msg);
}

void sipwxLog::DoLogRecord( ::wxLogLevel level,const  ::wxString& msg,const  ::wxLogRecordInfo& info)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[2],sipPySelf,NULL,sipName_DoLogRecord);

    if (!sipMeth)
    {
         ::wxLog::DoLogRecord(level,msg,info);
        return;
    }

    extern void sipVH__core_36(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxLogLevel,const  ::wxString&,const  ::wxLogRecordInfo&);

    sipVH__core_36(sipGILState, 0, sipPySelf, sipMeth, level, msg, info);
}

void sipwxLog::Flush()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[3],sipPySelf,NULL,sipName_Flush);

    if (!sipMeth)
    {
         ::wxLog::Flush();
        return;
    }

    extern void sipVH__core_35(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_35(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxLog::sipProtectVirt_DoLogRecord(bool sipSelfWasArg, ::wxLogLevel level,const  ::wxString& msg,const  ::wxLogRecordInfo& info)
{
    (sipSelfWasArg ?  ::wxLog::DoLogRecord(level,msg,info) : DoLogRecord(level,msg,info));
}

void sipwxLog::sipProtectVirt_DoLogTextAtLevel(bool sipSelfWasArg, ::wxLogLevel level,const  ::wxString& msg)
{
    (sipSelfWasArg ?  ::wxLog::DoLogTextAtLevel(level,msg) : DoLogTextAtLevel(level,msg));
}

void sipwxLog::sipProtectVirt_DoLogText(bool sipSelfWasArg,const  ::wxString& msg)
{
    (sipSelfWasArg ?  ::wxLog::DoLogText(msg) : DoLogText(msg));
}


PyDoc_STRVAR(doc_wxLog_AddTraceMask, "AddTraceMask(mask)\n"
    "\n"
    "Add the mask to the list of allowed masks for wxLogTrace().");

extern "C" {static PyObject *meth_wxLog_AddTraceMask(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLog_AddTraceMask(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* mask;
        int maskState = 0;

        static const char *sipKwdList[] = {
            sipName_mask,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&mask, &maskState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxLog::AddTraceMask(*mask);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(mask),sipType_wxString,maskState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_AddTraceMask, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_ClearTraceMasks, "ClearTraceMasks()\n"
    "\n"
    "Removes all trace masks previously set with AddTraceMask().");

extern "C" {static PyObject *meth_wxLog_ClearTraceMasks(PyObject *, PyObject *);}
static PyObject *meth_wxLog_ClearTraceMasks(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxLog::ClearTraceMasks();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_ClearTraceMasks, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_GetTraceMasks, "GetTraceMasks() -> ArrayString\n"
    "\n"
    "Returns the currently allowed list of string trace masks.");

extern "C" {static PyObject *meth_wxLog_GetTraceMasks(PyObject *, PyObject *);}
static PyObject *meth_wxLog_GetTraceMasks(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxArrayString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxArrayString( ::wxLog::GetTraceMasks());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxArrayString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_GetTraceMasks, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_IsAllowedTraceMask, "IsAllowedTraceMask(mask) -> bool\n"
    "\n"
    "Returns true if the mask is one of allowed masks for wxLogTrace().");

extern "C" {static PyObject *meth_wxLog_IsAllowedTraceMask(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLog_IsAllowedTraceMask(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* mask;
        int maskState = 0;

        static const char *sipKwdList[] = {
            sipName_mask,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&mask, &maskState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxLog::IsAllowedTraceMask(*mask);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(mask),sipType_wxString,maskState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_IsAllowedTraceMask, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_RemoveTraceMask, "RemoveTraceMask(mask)\n"
    "\n"
    "Remove the mask from the list of allowed masks for wxLogTrace().");

extern "C" {static PyObject *meth_wxLog_RemoveTraceMask(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLog_RemoveTraceMask(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* mask;
        int maskState = 0;

        static const char *sipKwdList[] = {
            sipName_mask,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&mask, &maskState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxLog::RemoveTraceMask(*mask);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(mask),sipType_wxString,maskState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_RemoveTraceMask, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_DontCreateOnDemand, "DontCreateOnDemand()\n"
    "\n"
    "Instructs wxLog to not create new log targets on the fly if there is\n"
    "none currently (see GetActiveTarget()).");

extern "C" {static PyObject *meth_wxLog_DontCreateOnDemand(PyObject *, PyObject *);}
static PyObject *meth_wxLog_DontCreateOnDemand(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxLog::DontCreateOnDemand();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_DontCreateOnDemand, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_GetActiveTarget, "GetActiveTarget() -> Log\n"
    "\n"
    "Returns the pointer to the active log target (may be NULL).");

extern "C" {static PyObject *meth_wxLog_GetActiveTarget(PyObject *, PyObject *);}
static PyObject *meth_wxLog_GetActiveTarget(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxLog*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxLog::GetActiveTarget();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxLog,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_GetActiveTarget, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_SetActiveTarget, "SetActiveTarget(logtarget) -> Log\n"
    "\n"
    "Sets the specified log target as the active one.");

extern "C" {static PyObject *meth_wxLog_SetActiveTarget(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLog_SetActiveTarget(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxLog* logtarget;

        static const char *sipKwdList[] = {
            sipName_logtarget,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J:", sipType_wxLog, &logtarget))
        {
             ::wxLog*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxLog::SetActiveTarget(logtarget);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxLog,Py_None);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_SetActiveTarget, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_SetThreadActiveTarget, "SetThreadActiveTarget(logger) -> Log\n"
    "\n"
    "Sets a thread-specific log target.");

extern "C" {static PyObject *meth_wxLog_SetThreadActiveTarget(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLog_SetThreadActiveTarget(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxLog* logger;

        static const char *sipKwdList[] = {
            sipName_logger,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J:", sipType_wxLog, &logger))
        {
             ::wxLog*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxLog::SetThreadActiveTarget(logger);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxLog,Py_None);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_SetThreadActiveTarget, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_FlushActive, "FlushActive()\n"
    "\n"
    "Flushes the current log target if any, does nothing if there is none.");

extern "C" {static PyObject *meth_wxLog_FlushActive(PyObject *, PyObject *);}
static PyObject *meth_wxLog_FlushActive(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxLog::FlushActive();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_FlushActive, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_Resume, "Resume()\n"
    "\n"
    "Resumes logging previously suspended by a call to Suspend().");

extern "C" {static PyObject *meth_wxLog_Resume(PyObject *, PyObject *);}
static PyObject *meth_wxLog_Resume(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxLog::Resume();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_Resume, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_Suspend, "Suspend()\n"
    "\n"
    "Suspends the logging until Resume() is called.");

extern "C" {static PyObject *meth_wxLog_Suspend(PyObject *, PyObject *);}
static PyObject *meth_wxLog_Suspend(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxLog::Suspend();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_Suspend, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_GetLogLevel, "GetLogLevel() -> LogLevel\n"
    "\n"
    "Returns the current log level limit.");

extern "C" {static PyObject *meth_wxLog_GetLogLevel(PyObject *, PyObject *);}
static PyObject *meth_wxLog_GetLogLevel(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxLogLevel sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxLog::GetLogLevel();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_GetLogLevel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_IsLevelEnabled, "IsLevelEnabled(level, component) -> bool\n"
    "\n"
    "Returns true if logging at this level is enabled for the current\n"
    "thread.");

extern "C" {static PyObject *meth_wxLog_IsLevelEnabled(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLog_IsLevelEnabled(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxLogLevel level;
         ::wxString* component;
        int componentState = 0;

        static const char *sipKwdList[] = {
            sipName_level,
            sipName_component,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "mJ1", &level, sipType_wxString,&component, &componentState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxLog::IsLevelEnabled(level,*component);
            Py_END_ALLOW_THREADS
            sipReleaseType(component,sipType_wxString,componentState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_IsLevelEnabled, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_SetComponentLevel, "SetComponentLevel(component, level)\n"
    "\n"
    "Sets the log level for the given component.");

extern "C" {static PyObject *meth_wxLog_SetComponentLevel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLog_SetComponentLevel(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* component;
        int componentState = 0;
         ::wxLogLevel level;

        static const char *sipKwdList[] = {
            sipName_component,
            sipName_level,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1m", sipType_wxString,&component, &componentState, &level))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxLog::SetComponentLevel(*component,level);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(component),sipType_wxString,componentState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_SetComponentLevel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_SetLogLevel, "SetLogLevel(logLevel)\n"
    "\n"
    "Specifies that log messages with level greater (numerically) than\n"
    "logLevel should be ignored and not sent to the active log target.");

extern "C" {static PyObject *meth_wxLog_SetLogLevel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLog_SetLogLevel(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxLogLevel logLevel;

        static const char *sipKwdList[] = {
            sipName_logLevel,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "m", &logLevel))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxLog::SetLogLevel(logLevel);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_SetLogLevel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_EnableLogging, "EnableLogging(enable=True) -> bool\n"
    "\n"
    "Globally enable or disable logging.");

extern "C" {static PyObject *meth_wxLog_EnableLogging(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLog_EnableLogging(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool enable = 1;

        static const char *sipKwdList[] = {
            sipName_enable,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "|b", &enable))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxLog::EnableLogging(enable);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_EnableLogging, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_IsEnabled, "IsEnabled() -> bool\n"
    "\n"
    "Returns true if logging is enabled at all now.");

extern "C" {static PyObject *meth_wxLog_IsEnabled(PyObject *, PyObject *);}
static PyObject *meth_wxLog_IsEnabled(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxLog::IsEnabled();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_IsEnabled, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_GetRepetitionCounting, "GetRepetitionCounting() -> bool\n"
    "\n"
    "Returns whether the repetition counting mode is enabled.");

extern "C" {static PyObject *meth_wxLog_GetRepetitionCounting(PyObject *, PyObject *);}
static PyObject *meth_wxLog_GetRepetitionCounting(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxLog::GetRepetitionCounting();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_GetRepetitionCounting, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_SetRepetitionCounting, "SetRepetitionCounting(repetCounting=True)\n"
    "\n"
    "Enables logging mode in which a log message is logged once, and in\n"
    "case exactly the same message successively repeats one or more times,\n"
    "only the number of repetitions is logged.");

extern "C" {static PyObject *meth_wxLog_SetRepetitionCounting(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLog_SetRepetitionCounting(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool repetCounting = 1;

        static const char *sipKwdList[] = {
            sipName_repetCounting,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "|b", &repetCounting))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxLog::SetRepetitionCounting(repetCounting);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_SetRepetitionCounting, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_GetTimestamp, "GetTimestamp() -> String\n"
    "\n"
    "Returns the current timestamp format string.");

extern "C" {static PyObject *meth_wxLog_GetTimestamp(PyObject *, PyObject *);}
static PyObject *meth_wxLog_GetTimestamp(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString( ::wxLog::GetTimestamp());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_GetTimestamp, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_SetTimestamp, "SetTimestamp(format)\n"
    "\n"
    "Sets the timestamp format prepended by the default log targets to all\n"
    "messages.");

extern "C" {static PyObject *meth_wxLog_SetTimestamp(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLog_SetTimestamp(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* format;
        int formatState = 0;

        static const char *sipKwdList[] = {
            sipName_format,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J1", sipType_wxString,&format, &formatState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxLog::SetTimestamp(*format);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(format),sipType_wxString,formatState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_SetTimestamp, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_DisableTimestamp, "DisableTimestamp()\n"
    "\n"
    "Disables time stamping of the log messages.");

extern "C" {static PyObject *meth_wxLog_DisableTimestamp(PyObject *, PyObject *);}
static PyObject *meth_wxLog_DisableTimestamp(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxLog::DisableTimestamp();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_DisableTimestamp, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_GetVerbose, "GetVerbose() -> bool\n"
    "\n"
    "Returns whether the verbose mode is currently active.");

extern "C" {static PyObject *meth_wxLog_GetVerbose(PyObject *, PyObject *);}
static PyObject *meth_wxLog_GetVerbose(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxLog::GetVerbose();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_GetVerbose, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_SetVerbose, "SetVerbose(verbose=True)\n"
    "\n"
    "Activates or deactivates verbose mode in which the verbose messages\n"
    "are logged as the normal ones instead of being silently dropped.");

extern "C" {static PyObject *meth_wxLog_SetVerbose(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLog_SetVerbose(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool verbose = 1;

        static const char *sipKwdList[] = {
            sipName_verbose,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "|b", &verbose))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxLog::SetVerbose(verbose);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_SetVerbose, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_SetFormatter, "SetFormatter(formatter) -> LogFormatter\n"
    "\n"
    "Sets the specified formatter as the active one.");

extern "C" {static PyObject *meth_wxLog_SetFormatter(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLog_SetFormatter(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxLogFormatter* formatter;
         ::wxLog *sipCpp;

        static const char *sipKwdList[] = {
            sipName_formatter,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxLog, &sipCpp, sipType_wxLogFormatter, &formatter))
        {
             ::wxLogFormatter*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetFormatter(formatter);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxLogFormatter,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_SetFormatter, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_Flush, "Flush()\n"
    "\n"
    "Some of wxLog implementations, most notably the standard wxLogGui\n"
    "class, buffer the messages (for example, to avoid showing the user a\n"
    "zillion of modal message boxes one after another  which would be\n"
    "really annoying).");

extern "C" {static PyObject *meth_wxLog_Flush(PyObject *, PyObject *);}
static PyObject *meth_wxLog_Flush(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxLog *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxLog, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxLog::Flush() : sipCpp->Flush());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_Flush, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_LogRecord, "LogRecord(level, msg, info)\n"
    "\n"
    "Log the given record.");

extern "C" {static PyObject *meth_wxLog_LogRecord(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLog_LogRecord(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxLogLevel level;
        const  ::wxString* msg;
        int msgState = 0;
        const  ::wxLogRecordInfo* info;
         ::wxLog *sipCpp;

        static const char *sipKwdList[] = {
            sipName_level,
            sipName_msg,
            sipName_info,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BmJ1J9", &sipSelf, sipType_wxLog, &sipCpp, &level, sipType_wxString,&msg, &msgState, sipType_wxLogRecordInfo, &info))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->LogRecord(level,*msg,*info);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(msg),sipType_wxString,msgState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_LogRecord, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_DoLogRecord, "DoLogRecord(level, msg, info)\n"
    "\n"
    "Called to log a new record.");

extern "C" {static PyObject *meth_wxLog_DoLogRecord(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLog_DoLogRecord(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxLogLevel level;
        const  ::wxString* msg;
        int msgState = 0;
        const  ::wxLogRecordInfo* info;
        sipwxLog *sipCpp;

        static const char *sipKwdList[] = {
            sipName_level,
            sipName_msg,
            sipName_info,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BmJ1J9", &sipSelf, sipType_wxLog, &sipCpp, &level, sipType_wxString,&msg, &msgState, sipType_wxLogRecordInfo, &info))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->sipProtectVirt_DoLogRecord(sipSelfWasArg,level,*msg,*info);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(msg),sipType_wxString,msgState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_DoLogRecord, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_DoLogTextAtLevel, "DoLogTextAtLevel(level, msg)\n"
    "\n"
    "Called to log the specified string at given level.");

extern "C" {static PyObject *meth_wxLog_DoLogTextAtLevel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLog_DoLogTextAtLevel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxLogLevel level;
        const  ::wxString* msg;
        int msgState = 0;
        sipwxLog *sipCpp;

        static const char *sipKwdList[] = {
            sipName_level,
            sipName_msg,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BmJ1", &sipSelf, sipType_wxLog, &sipCpp, &level, sipType_wxString,&msg, &msgState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->sipProtectVirt_DoLogTextAtLevel(sipSelfWasArg,level,*msg);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(msg),sipType_wxString,msgState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_DoLogTextAtLevel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxLog_DoLogText, "DoLogText(msg)\n"
    "\n"
    "Called to log the specified string.");

extern "C" {static PyObject *meth_wxLog_DoLogText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxLog_DoLogText(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* msg;
        int msgState = 0;
        sipwxLog *sipCpp;

        static const char *sipKwdList[] = {
            sipName_msg,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxLog, &sipCpp, sipType_wxString,&msg, &msgState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->sipProtectVirt_DoLogText(sipSelfWasArg,*msg);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(msg),sipType_wxString,msgState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Log, sipName_DoLogText, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxLog(void *, int);}
static void release_wxLog(void *sipCppV, int sipIsDerived)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipIsDerived)
        delete reinterpret_cast<sipwxLog *>(sipCppV);
    else
        delete reinterpret_cast< ::wxLog *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxLog(void *, SIP_SSIZE_T, const void *);}
static void assign_wxLog(void *sipDst, SIP_SSIZE_T sipDstIdx, const void *sipSrc)
{
    reinterpret_cast< ::wxLog *>(sipDst)[sipDstIdx] = *reinterpret_cast<const  ::wxLog *>(sipSrc);
}


extern "C" {static void *array_wxLog(SIP_SSIZE_T);}
static void *array_wxLog(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxLog[sipNrElem];
}


extern "C" {static void *copy_wxLog(const void *, SIP_SSIZE_T);}
static void *copy_wxLog(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxLog(reinterpret_cast<const  ::wxLog *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxLog(sipSimpleWrapper *);}
static void dealloc_wxLog(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxLog *>(sipGetAddress(sipSelf))->sipPySelf = NULL;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxLog(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxLog(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxLog(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxLog *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxLog();
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxLog* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxLog, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxLog(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return NULL;
}


static PyMethodDef methods_wxLog[] = {
    {SIP_MLNAME_CAST(sipName_AddTraceMask), (PyCFunction)meth_wxLog_AddTraceMask, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLog_AddTraceMask)},
    {SIP_MLNAME_CAST(sipName_ClearTraceMasks), meth_wxLog_ClearTraceMasks, METH_VARARGS, SIP_MLDOC_CAST(doc_wxLog_ClearTraceMasks)},
    {SIP_MLNAME_CAST(sipName_DisableTimestamp), meth_wxLog_DisableTimestamp, METH_VARARGS, SIP_MLDOC_CAST(doc_wxLog_DisableTimestamp)},
    {SIP_MLNAME_CAST(sipName_DoLogRecord), (PyCFunction)meth_wxLog_DoLogRecord, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLog_DoLogRecord)},
    {SIP_MLNAME_CAST(sipName_DoLogText), (PyCFunction)meth_wxLog_DoLogText, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLog_DoLogText)},
    {SIP_MLNAME_CAST(sipName_DoLogTextAtLevel), (PyCFunction)meth_wxLog_DoLogTextAtLevel, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLog_DoLogTextAtLevel)},
    {SIP_MLNAME_CAST(sipName_DontCreateOnDemand), meth_wxLog_DontCreateOnDemand, METH_VARARGS, SIP_MLDOC_CAST(doc_wxLog_DontCreateOnDemand)},
    {SIP_MLNAME_CAST(sipName_EnableLogging), (PyCFunction)meth_wxLog_EnableLogging, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLog_EnableLogging)},
    {SIP_MLNAME_CAST(sipName_Flush), meth_wxLog_Flush, METH_VARARGS, SIP_MLDOC_CAST(doc_wxLog_Flush)},
    {SIP_MLNAME_CAST(sipName_FlushActive), meth_wxLog_FlushActive, METH_VARARGS, SIP_MLDOC_CAST(doc_wxLog_FlushActive)},
    {SIP_MLNAME_CAST(sipName_GetActiveTarget), meth_wxLog_GetActiveTarget, METH_VARARGS, SIP_MLDOC_CAST(doc_wxLog_GetActiveTarget)},
    {SIP_MLNAME_CAST(sipName_GetLogLevel), meth_wxLog_GetLogLevel, METH_VARARGS, SIP_MLDOC_CAST(doc_wxLog_GetLogLevel)},
    {SIP_MLNAME_CAST(sipName_GetRepetitionCounting), meth_wxLog_GetRepetitionCounting, METH_VARARGS, SIP_MLDOC_CAST(doc_wxLog_GetRepetitionCounting)},
    {SIP_MLNAME_CAST(sipName_GetTimestamp), meth_wxLog_GetTimestamp, METH_VARARGS, SIP_MLDOC_CAST(doc_wxLog_GetTimestamp)},
    {SIP_MLNAME_CAST(sipName_GetTraceMasks), meth_wxLog_GetTraceMasks, METH_VARARGS, SIP_MLDOC_CAST(doc_wxLog_GetTraceMasks)},
    {SIP_MLNAME_CAST(sipName_GetVerbose), meth_wxLog_GetVerbose, METH_VARARGS, SIP_MLDOC_CAST(doc_wxLog_GetVerbose)},
    {SIP_MLNAME_CAST(sipName_IsAllowedTraceMask), (PyCFunction)meth_wxLog_IsAllowedTraceMask, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLog_IsAllowedTraceMask)},
    {SIP_MLNAME_CAST(sipName_IsEnabled), meth_wxLog_IsEnabled, METH_VARARGS, SIP_MLDOC_CAST(doc_wxLog_IsEnabled)},
    {SIP_MLNAME_CAST(sipName_IsLevelEnabled), (PyCFunction)meth_wxLog_IsLevelEnabled, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLog_IsLevelEnabled)},
    {SIP_MLNAME_CAST(sipName_LogRecord), (PyCFunction)meth_wxLog_LogRecord, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLog_LogRecord)},
    {SIP_MLNAME_CAST(sipName_RemoveTraceMask), (PyCFunction)meth_wxLog_RemoveTraceMask, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLog_RemoveTraceMask)},
    {SIP_MLNAME_CAST(sipName_Resume), meth_wxLog_Resume, METH_VARARGS, SIP_MLDOC_CAST(doc_wxLog_Resume)},
    {SIP_MLNAME_CAST(sipName_SetActiveTarget), (PyCFunction)meth_wxLog_SetActiveTarget, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLog_SetActiveTarget)},
    {SIP_MLNAME_CAST(sipName_SetComponentLevel), (PyCFunction)meth_wxLog_SetComponentLevel, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLog_SetComponentLevel)},
    {SIP_MLNAME_CAST(sipName_SetFormatter), (PyCFunction)meth_wxLog_SetFormatter, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLog_SetFormatter)},
    {SIP_MLNAME_CAST(sipName_SetLogLevel), (PyCFunction)meth_wxLog_SetLogLevel, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLog_SetLogLevel)},
    {SIP_MLNAME_CAST(sipName_SetRepetitionCounting), (PyCFunction)meth_wxLog_SetRepetitionCounting, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLog_SetRepetitionCounting)},
    {SIP_MLNAME_CAST(sipName_SetThreadActiveTarget), (PyCFunction)meth_wxLog_SetThreadActiveTarget, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLog_SetThreadActiveTarget)},
    {SIP_MLNAME_CAST(sipName_SetTimestamp), (PyCFunction)meth_wxLog_SetTimestamp, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLog_SetTimestamp)},
    {SIP_MLNAME_CAST(sipName_SetVerbose), (PyCFunction)meth_wxLog_SetVerbose, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxLog_SetVerbose)},
    {SIP_MLNAME_CAST(sipName_Suspend), meth_wxLog_Suspend, METH_VARARGS, SIP_MLDOC_CAST(doc_wxLog_Suspend)}
};

PyDoc_STRVAR(doc_wxLog, "wxLog class defines the interface for the log targets used by\n"
    "wxWidgets logging functions as explained in the Logging Overview.");


sipClassTypeDef sipTypeDef__core_wxLog = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxLog,
        {0},
        0
    },
    {
        sipNameNr_Log,
        {0, 0, 1},
        31, methods_wxLog,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxLog,
    -1,
    -1,
    0,
    0,
    init_type_wxLog,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxLog,
    assign_wxLog,
    array_wxLog,
    copy_wxLog,
    release_wxLog,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
