/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.2
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/renderer.h>



PyDoc_STRVAR(doc_wxRendererVersion_IsCompatible, "IsCompatible(ver) -> bool\n"
    "\n"
    "Checks if the main program is compatible with the renderer having the\n"
    "version ver, returns true if it is and false otherwise.");

extern "C" {static PyObject *meth_wxRendererVersion_IsCompatible(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRendererVersion_IsCompatible(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRendererVersion* ver;

        static const char *sipKwdList[] = {
            sipName_ver,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "J9", sipType_wxRendererVersion, &ver))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxRendererVersion::IsCompatible(*ver);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RendererVersion, sipName_IsCompatible, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxRendererVersion(void *, int);}
static void release_wxRendererVersion(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxRendererVersion *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxRendererVersion(sipSimpleWrapper *);}
static void dealloc_wxRendererVersion(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxRendererVersion(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxRendererVersion(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxRendererVersion(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxRendererVersion *sipCpp = 0;

    {
        int version_;
        int age_;

        static const char *sipKwdList[] = {
            sipName_version_,
            sipName_age_,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "ii", &version_, &age_))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxRendererVersion(version_,age_);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxRendererVersion* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxRendererVersion, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxRendererVersion(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return NULL;
}


static PyMethodDef methods_wxRendererVersion[] = {
    {SIP_MLNAME_CAST(sipName_IsCompatible), (PyCFunction)meth_wxRendererVersion_IsCompatible, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRendererVersion_IsCompatible)}
};


extern "C" {static PyObject *varget_wxRendererVersion_age(void *, PyObject *, PyObject *);}
static PyObject *varget_wxRendererVersion_age(void *sipSelf, PyObject *, PyObject *)
{
    int sipVal;
     ::wxRendererVersion *sipCpp = reinterpret_cast< ::wxRendererVersion *>(sipSelf);

    sipVal = sipCpp->age;

    return SIPLong_FromLong(sipVal);
}


extern "C" {static PyObject *varget_wxRendererVersion_version(void *, PyObject *, PyObject *);}
static PyObject *varget_wxRendererVersion_version(void *sipSelf, PyObject *, PyObject *)
{
    int sipVal;
     ::wxRendererVersion *sipCpp = reinterpret_cast< ::wxRendererVersion *>(sipSelf);

    sipVal = sipCpp->version;

    return SIPLong_FromLong(sipVal);
}

sipVariableDef variables_wxRendererVersion[] = {
    {InstanceVariable, sipName_age, (PyMethodDef *)varget_wxRendererVersion_age, NULL, NULL, NULL},
    {InstanceVariable, sipName_version, (PyMethodDef *)varget_wxRendererVersion_version, NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxRendererVersion, "RendererVersion(version_, age_)\n"
    "\n"
    "This simple struct represents the wxRendererNative interface version\n"
    "and is only used as the return value of\n"
    "wxRendererNative::GetVersion().");


sipClassTypeDef sipTypeDef__core_wxRendererVersion = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxRendererVersion,
        {0},
        0
    },
    {
        sipNameNr_RendererVersion,
        {0, 0, 1},
        1, methods_wxRendererVersion,
        0, 0,
        2, variables_wxRendererVersion,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxRendererVersion,
    -1,
    -1,
    0,
    0,
    init_type_wxRendererVersion,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxRendererVersion,
    0,
    0,
    0,
    release_wxRendererVersion,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
