/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.2
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/uiaction.h>

        #include <wx/gdicmn.h>


PyDoc_STRVAR(doc_wxUIActionSimulator_MouseMove, "MouseMove(x, y) -> bool\n"
    "MouseMove(point) -> bool\n"
    "\n"
    "Move the mouse to the specified coordinates.");

extern "C" {static PyObject *meth_wxUIActionSimulator_MouseMove(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUIActionSimulator_MouseMove(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        long x;
        long y;
         ::wxUIActionSimulator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bll", &sipSelf, sipType_wxUIActionSimulator, &sipCpp, &x, &y))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MouseMove(x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxPoint* point;
        int pointState = 0;
         ::wxUIActionSimulator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_point,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxUIActionSimulator, &sipCpp, sipType_wxPoint, &point, &pointState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MouseMove(*point);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(point),sipType_wxPoint,pointState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_UIActionSimulator, sipName_MouseMove, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxUIActionSimulator_MouseDown, "MouseDown(button=MOUSE_BTN_LEFT) -> bool\n"
    "\n"
    "Press a mouse button.");

extern "C" {static PyObject *meth_wxUIActionSimulator_MouseDown(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUIActionSimulator_MouseDown(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int button = wxMOUSE_BTN_LEFT;
         ::wxUIActionSimulator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_button,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|i", &sipSelf, sipType_wxUIActionSimulator, &sipCpp, &button))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MouseDown(button);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_UIActionSimulator, sipName_MouseDown, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxUIActionSimulator_MouseUp, "MouseUp(button=MOUSE_BTN_LEFT) -> bool\n"
    "\n"
    "Release a mouse button.");

extern "C" {static PyObject *meth_wxUIActionSimulator_MouseUp(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUIActionSimulator_MouseUp(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int button = wxMOUSE_BTN_LEFT;
         ::wxUIActionSimulator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_button,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|i", &sipSelf, sipType_wxUIActionSimulator, &sipCpp, &button))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MouseUp(button);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_UIActionSimulator, sipName_MouseUp, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxUIActionSimulator_MouseClick, "MouseClick(button=MOUSE_BTN_LEFT) -> bool\n"
    "\n"
    "Click a mouse button.");

extern "C" {static PyObject *meth_wxUIActionSimulator_MouseClick(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUIActionSimulator_MouseClick(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int button = wxMOUSE_BTN_LEFT;
         ::wxUIActionSimulator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_button,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|i", &sipSelf, sipType_wxUIActionSimulator, &sipCpp, &button))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MouseClick(button);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_UIActionSimulator, sipName_MouseClick, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxUIActionSimulator_MouseDblClick, "MouseDblClick(button=MOUSE_BTN_LEFT) -> bool\n"
    "\n"
    "Double-click a mouse button.");

extern "C" {static PyObject *meth_wxUIActionSimulator_MouseDblClick(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUIActionSimulator_MouseDblClick(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int button = wxMOUSE_BTN_LEFT;
         ::wxUIActionSimulator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_button,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|i", &sipSelf, sipType_wxUIActionSimulator, &sipCpp, &button))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MouseDblClick(button);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_UIActionSimulator, sipName_MouseDblClick, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxUIActionSimulator_MouseDragDrop, "MouseDragDrop(x1, y1, x2, y2, button=MOUSE_BTN_LEFT) -> bool\n"
    "\n"
    "Perform a drag and drop operation.");

extern "C" {static PyObject *meth_wxUIActionSimulator_MouseDragDrop(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUIActionSimulator_MouseDragDrop(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        long x1;
        long y1;
        long x2;
        long y2;
        int button = wxMOUSE_BTN_LEFT;
         ::wxUIActionSimulator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x1,
            sipName_y1,
            sipName_x2,
            sipName_y2,
            sipName_button,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bllll|i", &sipSelf, sipType_wxUIActionSimulator, &sipCpp, &x1, &y1, &x2, &y2, &button))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MouseDragDrop(x1,y1,x2,y2,button);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_UIActionSimulator, sipName_MouseDragDrop, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxUIActionSimulator_KeyDown, "KeyDown(keycode, modifiers=MOD_NONE) -> bool\n"
    "\n"
    "Press a key.");

extern "C" {static PyObject *meth_wxUIActionSimulator_KeyDown(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUIActionSimulator_KeyDown(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int keycode;
        int modifiers = wxMOD_NONE;
         ::wxUIActionSimulator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_keycode,
            sipName_modifiers,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi|i", &sipSelf, sipType_wxUIActionSimulator, &sipCpp, &keycode, &modifiers))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->KeyDown(keycode,modifiers);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_UIActionSimulator, sipName_KeyDown, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxUIActionSimulator_KeyUp, "KeyUp(keycode, modifiers=MOD_NONE) -> bool\n"
    "\n"
    "Release a key.");

extern "C" {static PyObject *meth_wxUIActionSimulator_KeyUp(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUIActionSimulator_KeyUp(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int keycode;
        int modifiers = wxMOD_NONE;
         ::wxUIActionSimulator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_keycode,
            sipName_modifiers,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi|i", &sipSelf, sipType_wxUIActionSimulator, &sipCpp, &keycode, &modifiers))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->KeyUp(keycode,modifiers);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_UIActionSimulator, sipName_KeyUp, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxUIActionSimulator_Char, "Char(keycode, modifiers=MOD_NONE) -> bool\n"
    "\n"
    "Press and release a key.");

extern "C" {static PyObject *meth_wxUIActionSimulator_Char(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUIActionSimulator_Char(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int keycode;
        int modifiers = wxMOD_NONE;
         ::wxUIActionSimulator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_keycode,
            sipName_modifiers,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi|i", &sipSelf, sipType_wxUIActionSimulator, &sipCpp, &keycode, &modifiers))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Char(keycode,modifiers);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_UIActionSimulator, sipName_Char, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxUIActionSimulator_Text, "Text(text) -> bool\n"
    "\n"
    "Emulate typing in the keys representing the given string.");

extern "C" {static PyObject *meth_wxUIActionSimulator_Text(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUIActionSimulator_Text(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* text;
        int textState = 0;
         ::wxUIActionSimulator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxUIActionSimulator, &sipCpp, sipType_wxString,&text, &textState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Text(*text);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_UIActionSimulator, sipName_Text, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxUIActionSimulator(void *, int);}
static void release_wxUIActionSimulator(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxUIActionSimulator *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxUIActionSimulator(void *, SIP_SSIZE_T, const void *);}
static void assign_wxUIActionSimulator(void *sipDst, SIP_SSIZE_T sipDstIdx, const void *sipSrc)
{
    reinterpret_cast< ::wxUIActionSimulator *>(sipDst)[sipDstIdx] = *reinterpret_cast<const  ::wxUIActionSimulator *>(sipSrc);
}


extern "C" {static void *array_wxUIActionSimulator(SIP_SSIZE_T);}
static void *array_wxUIActionSimulator(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxUIActionSimulator[sipNrElem];
}


extern "C" {static void *copy_wxUIActionSimulator(const void *, SIP_SSIZE_T);}
static void *copy_wxUIActionSimulator(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxUIActionSimulator(reinterpret_cast<const  ::wxUIActionSimulator *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxUIActionSimulator(sipSimpleWrapper *);}
static void dealloc_wxUIActionSimulator(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxUIActionSimulator(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxUIActionSimulator(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxUIActionSimulator(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxUIActionSimulator *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxUIActionSimulator();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxUIActionSimulator* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxUIActionSimulator, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxUIActionSimulator(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return NULL;
}


static PyMethodDef methods_wxUIActionSimulator[] = {
    {SIP_MLNAME_CAST(sipName_Char), (PyCFunction)meth_wxUIActionSimulator_Char, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxUIActionSimulator_Char)},
    {SIP_MLNAME_CAST(sipName_KeyDown), (PyCFunction)meth_wxUIActionSimulator_KeyDown, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxUIActionSimulator_KeyDown)},
    {SIP_MLNAME_CAST(sipName_KeyUp), (PyCFunction)meth_wxUIActionSimulator_KeyUp, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxUIActionSimulator_KeyUp)},
    {SIP_MLNAME_CAST(sipName_MouseClick), (PyCFunction)meth_wxUIActionSimulator_MouseClick, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxUIActionSimulator_MouseClick)},
    {SIP_MLNAME_CAST(sipName_MouseDblClick), (PyCFunction)meth_wxUIActionSimulator_MouseDblClick, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxUIActionSimulator_MouseDblClick)},
    {SIP_MLNAME_CAST(sipName_MouseDown), (PyCFunction)meth_wxUIActionSimulator_MouseDown, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxUIActionSimulator_MouseDown)},
    {SIP_MLNAME_CAST(sipName_MouseDragDrop), (PyCFunction)meth_wxUIActionSimulator_MouseDragDrop, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxUIActionSimulator_MouseDragDrop)},
    {SIP_MLNAME_CAST(sipName_MouseMove), (PyCFunction)meth_wxUIActionSimulator_MouseMove, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxUIActionSimulator_MouseMove)},
    {SIP_MLNAME_CAST(sipName_MouseUp), (PyCFunction)meth_wxUIActionSimulator_MouseUp, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxUIActionSimulator_MouseUp)},
    {SIP_MLNAME_CAST(sipName_Text), (PyCFunction)meth_wxUIActionSimulator_Text, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxUIActionSimulator_Text)}
};

PyDoc_STRVAR(doc_wxUIActionSimulator, "UIActionSimulator()\n"
    "\n"
    "wxUIActionSimulator is a class used to simulate user interface actions\n"
    "such as a mouse click or a key press.");


sipClassTypeDef sipTypeDef__core_wxUIActionSimulator = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxUIActionSimulator,
        {0},
        0
    },
    {
        sipNameNr_UIActionSimulator,
        {0, 0, 1},
        10, methods_wxUIActionSimulator,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxUIActionSimulator,
    -1,
    -1,
    0,
    0,
    init_type_wxUIActionSimulator,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxUIActionSimulator,
    assign_wxUIActionSimulator,
    array_wxUIActionSimulator,
    copy_wxUIActionSimulator,
    release_wxUIActionSimulator,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
