/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.2
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_html.h"

        #include <wx/html/helpdata.h>

        #include <wx/object.h>
        #include <wx/object.h>


PyDoc_STRVAR(doc_wxHtmlHelpData_AddBook, "AddBook(book_url) -> bool\n"
    "\n"
    "Adds new book.");

extern "C" {static PyObject *meth_wxHtmlHelpData_AddBook(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlHelpData_AddBook(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* book_url;
        int book_urlState = 0;
         ::wxHtmlHelpData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_book_url,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxHtmlHelpData, &sipCpp, sipType_wxString,&book_url, &book_urlState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->AddBook(*book_url);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(book_url),sipType_wxString,book_urlState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlHelpData, sipName_AddBook, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlHelpData_FindPageById, "FindPageById(id) -> String\n"
    "\n"
    "Returns page's URL based on integer ID stored in project.");

extern "C" {static PyObject *meth_wxHtmlHelpData_FindPageById(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlHelpData_FindPageById(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int id;
         ::wxHtmlHelpData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxHtmlHelpData, &sipCpp, &id))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->FindPageById(id));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlHelpData, sipName_FindPageById, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlHelpData_FindPageByName, "FindPageByName(page) -> String\n"
    "\n"
    "Returns page's URL based on its (file)name.");

extern "C" {static PyObject *meth_wxHtmlHelpData_FindPageByName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlHelpData_FindPageByName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* page;
        int pageState = 0;
         ::wxHtmlHelpData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_page,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxHtmlHelpData, &sipCpp, sipType_wxString,&page, &pageState))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->FindPageByName(*page));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(page),sipType_wxString,pageState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlHelpData, sipName_FindPageByName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlHelpData_GetBookRecArray, "GetBookRecArray() -> HtmlBookRecArray\n"
    "\n"
    "Returns array with help books info.");

extern "C" {static PyObject *meth_wxHtmlHelpData_GetBookRecArray(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlHelpData_GetBookRecArray(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlHelpData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlHelpData, &sipCpp))
        {
             ::wxHtmlBookRecArray*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxHtmlBookRecArray(sipCpp->GetBookRecArray());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxHtmlBookRecArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlHelpData, sipName_GetBookRecArray, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlHelpData_GetContentsArray, "GetContentsArray() -> HtmlHelpDataItems\n"
    "\n"
    "Returns reference to array with contents entries.");

extern "C" {static PyObject *meth_wxHtmlHelpData_GetContentsArray(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlHelpData_GetContentsArray(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlHelpData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlHelpData, &sipCpp))
        {
             ::wxHtmlHelpDataItems*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxHtmlHelpDataItems(sipCpp->GetContentsArray());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxHtmlHelpDataItems,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlHelpData, sipName_GetContentsArray, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlHelpData_GetIndexArray, "GetIndexArray() -> HtmlHelpDataItems\n"
    "\n"
    "Returns reference to array with index entries.");

extern "C" {static PyObject *meth_wxHtmlHelpData_GetIndexArray(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlHelpData_GetIndexArray(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxHtmlHelpData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlHelpData, &sipCpp))
        {
             ::wxHtmlHelpDataItems*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxHtmlHelpDataItems(sipCpp->GetIndexArray());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxHtmlHelpDataItems,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlHelpData, sipName_GetIndexArray, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxHtmlHelpData_SetTempDir, "SetTempDir(path)\n"
    "\n"
    "Sets the temporary directory where binary cached versions of MS HTML\n"
    "Workshop files will be stored.");

extern "C" {static PyObject *meth_wxHtmlHelpData_SetTempDir(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlHelpData_SetTempDir(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* path;
        int pathState = 0;
         ::wxHtmlHelpData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_path,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxHtmlHelpData, &sipCpp, sipType_wxString,&path, &pathState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetTempDir(*path);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(path),sipType_wxString,pathState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlHelpData, sipName_SetTempDir, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxHtmlHelpData(void *, const sipTypeDef *);}
static void *cast_wxHtmlHelpData(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxHtmlHelpData *sipCpp = reinterpret_cast< ::wxHtmlHelpData *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxHtmlHelpData(void *, int);}
static void release_wxHtmlHelpData(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxHtmlHelpData *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxHtmlHelpData(sipSimpleWrapper *);}
static void dealloc_wxHtmlHelpData(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxHtmlHelpData(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxHtmlHelpData(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxHtmlHelpData(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxHtmlHelpData *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxHtmlHelpData();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxHtmlHelpData[] = {{26, 0, 1}};


static PyMethodDef methods_wxHtmlHelpData[] = {
    {SIP_MLNAME_CAST(sipName_AddBook), (PyCFunction)meth_wxHtmlHelpData_AddBook, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlHelpData_AddBook)},
    {SIP_MLNAME_CAST(sipName_FindPageById), (PyCFunction)meth_wxHtmlHelpData_FindPageById, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlHelpData_FindPageById)},
    {SIP_MLNAME_CAST(sipName_FindPageByName), (PyCFunction)meth_wxHtmlHelpData_FindPageByName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlHelpData_FindPageByName)},
    {SIP_MLNAME_CAST(sipName_GetBookRecArray), meth_wxHtmlHelpData_GetBookRecArray, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlHelpData_GetBookRecArray)},
    {SIP_MLNAME_CAST(sipName_GetContentsArray), meth_wxHtmlHelpData_GetContentsArray, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlHelpData_GetContentsArray)},
    {SIP_MLNAME_CAST(sipName_GetIndexArray), meth_wxHtmlHelpData_GetIndexArray, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlHelpData_GetIndexArray)},
    {SIP_MLNAME_CAST(sipName_SetTempDir), (PyCFunction)meth_wxHtmlHelpData_SetTempDir, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlHelpData_SetTempDir)}
};

sipVariableDef variables_wxHtmlHelpData[] = {
    {PropertyVariable, sipName_IndexArray, &methods_wxHtmlHelpData[5], NULL, NULL, NULL},
    {PropertyVariable, sipName_ContentsArray, &methods_wxHtmlHelpData[4], NULL, NULL, NULL},
    {PropertyVariable, sipName_BookRecArray, &methods_wxHtmlHelpData[3], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxHtmlHelpData, "HtmlHelpData()\n"
    "\n"
    "This class is used by wxHtmlHelpController and wxHtmlHelpFrame to\n"
    "access HTML help items.");


sipClassTypeDef sipTypeDef__html_wxHtmlHelpData = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxHtmlHelpData,
        {0},
        0
    },
    {
        sipNameNr_HtmlHelpData,
        {0, 0, 1},
        7, methods_wxHtmlHelpData,
        0, 0,
        3, variables_wxHtmlHelpData,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxHtmlHelpData,
    -1,
    -1,
    supers_wxHtmlHelpData,
    0,
    init_type_wxHtmlHelpData,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxHtmlHelpData,
    0,
    0,
    0,
    release_wxHtmlHelpData,
    cast_wxHtmlHelpData,
    0,
    0,
    0,
    0,
    0,
    0
};
