/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.2
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"

        #include <wx/richtext/richtextstyles.h>

        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextstyles.h>
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxRichTextListStyleDefinition : public  ::wxRichTextListStyleDefinition
{
public:
    sipwxRichTextListStyleDefinition(const  ::wxString&);
    sipwxRichTextListStyleDefinition(const  ::wxRichTextListStyleDefinition&);
    virtual ~sipwxRichTextListStyleDefinition();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
     ::wxRichTextAttr GetStyleMergedWithBase(const  ::wxRichTextStyleSheet*) const;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxRichTextListStyleDefinition(const sipwxRichTextListStyleDefinition &);
    sipwxRichTextListStyleDefinition &operator = (const sipwxRichTextListStyleDefinition &);

    char sipPyMethods[1];
};

sipwxRichTextListStyleDefinition::sipwxRichTextListStyleDefinition(const  ::wxString& name):  ::wxRichTextListStyleDefinition(name), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxRichTextListStyleDefinition::sipwxRichTextListStyleDefinition(const  ::wxRichTextListStyleDefinition& a0):  ::wxRichTextListStyleDefinition(a0), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxRichTextListStyleDefinition::~sipwxRichTextListStyleDefinition()
{
    sipCommonDtor(sipPySelf);
}

 ::wxRichTextAttr sipwxRichTextListStyleDefinition::GetStyleMergedWithBase(const  ::wxRichTextStyleSheet*sheet) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[0]),sipPySelf,NULL,sipName_GetStyleMergedWithBase);

    if (!sipMeth)
        return  ::wxRichTextListStyleDefinition::GetStyleMergedWithBase(sheet);

    extern  ::wxRichTextAttr sipVH__richtext_156(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxRichTextStyleSheet*);

    return sipVH__richtext_156(sipGILState, 0, sipPySelf, sipMeth, sheet);
}


PyDoc_STRVAR(doc_wxRichTextListStyleDefinition_CombineWithParagraphStyle, "CombineWithParagraphStyle(indent, paraStyle, styleSheet=None) -> RichTextAttr\n"
    "\n"
    "This function combines the given paragraph style with the list style's\n"
    "base attributes and level style matching the given indent, returning\n"
    "the combined attributes.");

extern "C" {static PyObject *meth_wxRichTextListStyleDefinition_CombineWithParagraphStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextListStyleDefinition_CombineWithParagraphStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int indent;
        const  ::wxRichTextAttr* paraStyle;
         ::wxRichTextStyleSheet* styleSheet = 0;
         ::wxRichTextListStyleDefinition *sipCpp;

        static const char *sipKwdList[] = {
            sipName_indent,
            sipName_paraStyle,
            sipName_styleSheet,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BiJ9|J8", &sipSelf, sipType_wxRichTextListStyleDefinition, &sipCpp, &indent, sipType_wxRichTextAttr, &paraStyle, sipType_wxRichTextStyleSheet, &styleSheet))
        {
             ::wxRichTextAttr*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxRichTextAttr(sipCpp->CombineWithParagraphStyle(indent,*paraStyle,styleSheet));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxRichTextAttr,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextListStyleDefinition, sipName_CombineWithParagraphStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextListStyleDefinition_FindLevelForIndent, "FindLevelForIndent(indent) -> int\n"
    "\n"
    "This function finds the level (from 0 to 9) whose indentation\n"
    "attribute mostly closely matches indent (expressed in tenths of a\n"
    "millimetre).");

extern "C" {static PyObject *meth_wxRichTextListStyleDefinition_FindLevelForIndent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextListStyleDefinition_FindLevelForIndent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int indent;
        const  ::wxRichTextListStyleDefinition *sipCpp;

        static const char *sipKwdList[] = {
            sipName_indent,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxRichTextListStyleDefinition, &sipCpp, &indent))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->FindLevelForIndent(indent);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextListStyleDefinition, sipName_FindLevelForIndent, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextListStyleDefinition_GetCombinedStyle, "GetCombinedStyle(indent, styleSheet=None) -> RichTextAttr\n"
    "\n"
    "This function combines the list style's base attributes and the level\n"
    "style matching the given indent, returning the combined attributes.");

extern "C" {static PyObject *meth_wxRichTextListStyleDefinition_GetCombinedStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextListStyleDefinition_GetCombinedStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int indent;
         ::wxRichTextStyleSheet* styleSheet = 0;
         ::wxRichTextListStyleDefinition *sipCpp;

        static const char *sipKwdList[] = {
            sipName_indent,
            sipName_styleSheet,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi|J8", &sipSelf, sipType_wxRichTextListStyleDefinition, &sipCpp, &indent, sipType_wxRichTextStyleSheet, &styleSheet))
        {
             ::wxRichTextAttr*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxRichTextAttr(sipCpp->GetCombinedStyle(indent,styleSheet));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxRichTextAttr,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextListStyleDefinition, sipName_GetCombinedStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextListStyleDefinition_GetCombinedStyleForLevel, "GetCombinedStyleForLevel(level, styleSheet=None) -> RichTextAttr\n"
    "\n"
    "This function combines the list style's base attributes and the style\n"
    "for the specified level, returning the combined attributes.");

extern "C" {static PyObject *meth_wxRichTextListStyleDefinition_GetCombinedStyleForLevel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextListStyleDefinition_GetCombinedStyleForLevel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int level;
         ::wxRichTextStyleSheet* styleSheet = 0;
         ::wxRichTextListStyleDefinition *sipCpp;

        static const char *sipKwdList[] = {
            sipName_level,
            sipName_styleSheet,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi|J8", &sipSelf, sipType_wxRichTextListStyleDefinition, &sipCpp, &level, sipType_wxRichTextStyleSheet, &styleSheet))
        {
             ::wxRichTextAttr*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxRichTextAttr(sipCpp->GetCombinedStyleForLevel(level,styleSheet));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxRichTextAttr,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextListStyleDefinition, sipName_GetCombinedStyleForLevel, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextListStyleDefinition_GetLevelAttributes, "GetLevelAttributes(level) -> RichTextAttr\n"
    "\n"
    "Returns the style for the given level.");

extern "C" {static PyObject *meth_wxRichTextListStyleDefinition_GetLevelAttributes(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextListStyleDefinition_GetLevelAttributes(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int level;
        const  ::wxRichTextListStyleDefinition *sipCpp;

        static const char *sipKwdList[] = {
            sipName_level,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxRichTextListStyleDefinition, &sipCpp, &level))
        {
            const  ::wxRichTextAttr*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLevelAttributes(level);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(const_cast< ::wxRichTextAttr *>(sipRes),sipType_wxRichTextAttr,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextListStyleDefinition, sipName_GetLevelAttributes, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextListStyleDefinition_GetLevelCount, "GetLevelCount() -> int\n"
    "\n"
    "Returns the number of levels.");

extern "C" {static PyObject *meth_wxRichTextListStyleDefinition_GetLevelCount(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextListStyleDefinition_GetLevelCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextListStyleDefinition *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextListStyleDefinition, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLevelCount();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextListStyleDefinition, sipName_GetLevelCount, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextListStyleDefinition_IsNumbered, "IsNumbered(level) -> bool\n"
    "\n"
    "Returns true if the given level has numbered list attributes.");

extern "C" {static PyObject *meth_wxRichTextListStyleDefinition_IsNumbered(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextListStyleDefinition_IsNumbered(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int level;
        const  ::wxRichTextListStyleDefinition *sipCpp;

        static const char *sipKwdList[] = {
            sipName_level,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_wxRichTextListStyleDefinition, &sipCpp, &level))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsNumbered(level);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextListStyleDefinition, sipName_IsNumbered, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextListStyleDefinition_SetLevelAttributes, "SetLevelAttributes(level, attr)\n"
    "\n"
    "Sets the style for the given level.");

extern "C" {static PyObject *meth_wxRichTextListStyleDefinition_SetLevelAttributes(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextListStyleDefinition_SetLevelAttributes(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int level;
        const  ::wxRichTextAttr* attr;
         ::wxRichTextListStyleDefinition *sipCpp;

        static const char *sipKwdList[] = {
            sipName_level,
            sipName_attr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BiJ9", &sipSelf, sipType_wxRichTextListStyleDefinition, &sipCpp, &level, sipType_wxRichTextAttr, &attr))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLevelAttributes(level,*attr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextListStyleDefinition, sipName_SetLevelAttributes, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxRichTextListStyleDefinition(void *, const sipTypeDef *);}
static void *cast_wxRichTextListStyleDefinition(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxRichTextListStyleDefinition *sipCpp = reinterpret_cast< ::wxRichTextListStyleDefinition *>(sipCppV);

    if (targetType == sipType_wxRichTextParagraphStyleDefinition)
        return static_cast< ::wxRichTextParagraphStyleDefinition *>(sipCpp);

    if (targetType == sipType_wxRichTextStyleDefinition)
        return static_cast< ::wxRichTextStyleDefinition *>(sipCpp);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxRichTextListStyleDefinition(void *, int);}
static void release_wxRichTextListStyleDefinition(void *sipCppV, int sipIsDerived)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipIsDerived)
        delete reinterpret_cast<sipwxRichTextListStyleDefinition *>(sipCppV);
    else
        delete reinterpret_cast< ::wxRichTextListStyleDefinition *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxRichTextListStyleDefinition(void *, SIP_SSIZE_T, const void *);}
static void assign_wxRichTextListStyleDefinition(void *sipDst, SIP_SSIZE_T sipDstIdx, const void *sipSrc)
{
    reinterpret_cast< ::wxRichTextListStyleDefinition *>(sipDst)[sipDstIdx] = *reinterpret_cast<const  ::wxRichTextListStyleDefinition *>(sipSrc);
}


extern "C" {static void *array_wxRichTextListStyleDefinition(SIP_SSIZE_T);}
static void *array_wxRichTextListStyleDefinition(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxRichTextListStyleDefinition[sipNrElem];
}


extern "C" {static void *copy_wxRichTextListStyleDefinition(const void *, SIP_SSIZE_T);}
static void *copy_wxRichTextListStyleDefinition(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxRichTextListStyleDefinition(reinterpret_cast<const  ::wxRichTextListStyleDefinition *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxRichTextListStyleDefinition(sipSimpleWrapper *);}
static void dealloc_wxRichTextListStyleDefinition(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxRichTextListStyleDefinition *>(sipGetAddress(sipSelf))->sipPySelf = NULL;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxRichTextListStyleDefinition(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxRichTextListStyleDefinition(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxRichTextListStyleDefinition(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxRichTextListStyleDefinition *sipCpp = 0;

    {
        const  ::wxString& namedef = wxEmptyString;
        const  ::wxString* name = &namedef;
        int nameState = 0;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J1", sipType_wxString,&name, &nameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxRichTextListStyleDefinition(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxRichTextListStyleDefinition* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxRichTextListStyleDefinition, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxRichTextListStyleDefinition(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxRichTextListStyleDefinition[] = {{53, 255, 1}};


static PyMethodDef methods_wxRichTextListStyleDefinition[] = {
    {SIP_MLNAME_CAST(sipName_CombineWithParagraphStyle), (PyCFunction)meth_wxRichTextListStyleDefinition_CombineWithParagraphStyle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextListStyleDefinition_CombineWithParagraphStyle)},
    {SIP_MLNAME_CAST(sipName_FindLevelForIndent), (PyCFunction)meth_wxRichTextListStyleDefinition_FindLevelForIndent, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextListStyleDefinition_FindLevelForIndent)},
    {SIP_MLNAME_CAST(sipName_GetCombinedStyle), (PyCFunction)meth_wxRichTextListStyleDefinition_GetCombinedStyle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextListStyleDefinition_GetCombinedStyle)},
    {SIP_MLNAME_CAST(sipName_GetCombinedStyleForLevel), (PyCFunction)meth_wxRichTextListStyleDefinition_GetCombinedStyleForLevel, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextListStyleDefinition_GetCombinedStyleForLevel)},
    {SIP_MLNAME_CAST(sipName_GetLevelAttributes), (PyCFunction)meth_wxRichTextListStyleDefinition_GetLevelAttributes, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextListStyleDefinition_GetLevelAttributes)},
    {SIP_MLNAME_CAST(sipName_GetLevelCount), meth_wxRichTextListStyleDefinition_GetLevelCount, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextListStyleDefinition_GetLevelCount)},
    {SIP_MLNAME_CAST(sipName_IsNumbered), (PyCFunction)meth_wxRichTextListStyleDefinition_IsNumbered, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextListStyleDefinition_IsNumbered)},
    {SIP_MLNAME_CAST(sipName_SetLevelAttributes), (PyCFunction)meth_wxRichTextListStyleDefinition_SetLevelAttributes, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextListStyleDefinition_SetLevelAttributes)}
};

sipVariableDef variables_wxRichTextListStyleDefinition[] = {
    {PropertyVariable, sipName_LevelCount, &methods_wxRichTextListStyleDefinition[5], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxRichTextListStyleDefinition, "RichTextListStyleDefinition(name=wx.EmptyString)\n"
    "\n"
    "This class represents a list style definition, usually added to a\n"
    "wxRichTextStyleSheet.");


sipClassTypeDef sipTypeDef__richtext_wxRichTextListStyleDefinition = {
    {
        -1,
        0,
        0,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxRichTextListStyleDefinition,
        {0},
        0
    },
    {
        sipNameNr_RichTextListStyleDefinition,
        {0, 0, 1},
        8, methods_wxRichTextListStyleDefinition,
        0, 0,
        1, variables_wxRichTextListStyleDefinition,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxRichTextListStyleDefinition,
    -1,
    -1,
    supers_wxRichTextListStyleDefinition,
    0,
    init_type_wxRichTextListStyleDefinition,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxRichTextListStyleDefinition,
    assign_wxRichTextListStyleDefinition,
    array_wxRichTextListStyleDefinition,
    copy_wxRichTextListStyleDefinition,
    release_wxRichTextListStyleDefinition,
    cast_wxRichTextListStyleDefinition,
    0,
    0,
    0,
    0,
    0,
    0
};
