/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.2
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"


        #include <wx/richtext/richtextbuffer.h>


PyDoc_STRVAR(doc_wxRichTextObjectPtrArray_append, "append(self, obj: RichTextObject)");

extern "C" {static PyObject *meth_wxRichTextObjectPtrArray_append(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextObjectPtrArray_append(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextObject* obj;
         ::wxRichTextObjectPtrArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_obj,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxRichTextObjectPtrArray, &sipCpp, sipType_wxRichTextObject, &obj))
        {
        sipCpp->Add(obj);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextObjectPtrArray, sipName_append, doc_wxRichTextObjectPtrArray_append);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextObjectPtrArray_index, "index(self, obj: RichTextObject) -> int");

extern "C" {static PyObject *meth_wxRichTextObjectPtrArray_index(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextObjectPtrArray_index(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextObject* obj;
         ::wxRichTextObjectPtrArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_obj,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxRichTextObjectPtrArray, &sipCpp, sipType_wxRichTextObject, &obj))
        {
            int sipRes = 0;
            sipErrorState sipError = sipErrorNone;

        int idx = sipCpp->Index(obj, false);
        if (idx == wxNOT_FOUND) {
            sipError = sipErrorFail;
            wxPyErr_SetString(PyExc_ValueError,
                              "sequence.index(x): x not in sequence");
            }
        sipRes = idx;

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return SIPLong_FromLong(sipRes);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextObjectPtrArray, sipName_index, doc_wxRichTextObjectPtrArray_index);

    return NULL;
}


extern "C" {static int slot_wxRichTextObjectPtrArray___contains__(PyObject *,PyObject *);}
static int slot_wxRichTextObjectPtrArray___contains__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxRichTextObjectPtrArray *sipCpp = reinterpret_cast< ::wxRichTextObjectPtrArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxRichTextObjectPtrArray));

    if (!sipCpp)
        return -1;

    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextObject* obj;

        if (sipParseArgs(&sipParseErr, sipArg, "1J8", sipType_wxRichTextObject, &obj))
        {
            int sipRes = 0;

        int idx = sipCpp->Index(obj, false);
        sipRes = idx != wxNOT_FOUND;

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextObjectPtrArray, sipName___contains__, NULL);

    return -1;
}


extern "C" {static PyObject *slot_wxRichTextObjectPtrArray___getitem__(PyObject *,PyObject *);}
static PyObject *slot_wxRichTextObjectPtrArray___getitem__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxRichTextObjectPtrArray *sipCpp = reinterpret_cast< ::wxRichTextObjectPtrArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxRichTextObjectPtrArray));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
         ::ulong index;

        if (sipParseArgs(&sipParseErr, sipArg, "1m", &index))
        {
             ::wxRichTextObject*sipRes = 0;
            sipErrorState sipError = sipErrorNone;

        if (index < sipCpp->GetCount()) {
            sipRes = sipCpp->Item(index);
        }
        else {
            wxPyErr_SetString(PyExc_IndexError, "sequence index out of range");
            sipError = sipErrorFail;
        }

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return sipConvertFromType(sipRes,sipType_wxRichTextObject,NULL);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextObjectPtrArray, sipName___getitem__, NULL);

    return 0;
}


extern "C" {static SIP_SSIZE_T slot_wxRichTextObjectPtrArray___len__(PyObject *);}
static SIP_SSIZE_T slot_wxRichTextObjectPtrArray___len__(PyObject *sipSelf)
{
     ::wxRichTextObjectPtrArray *sipCpp = reinterpret_cast< ::wxRichTextObjectPtrArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxRichTextObjectPtrArray));

    if (!sipCpp)
        return 0;


    {
        {
            SIP_SSIZE_T sipRes = 0;

        sipRes = sipCpp->GetCount();

            return sipRes;
        }
    }

    return 0;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxRichTextObjectPtrArray(void *, int);}
static void release_wxRichTextObjectPtrArray(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxRichTextObjectPtrArray *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxRichTextObjectPtrArray(void *, SIP_SSIZE_T, const void *);}
static void assign_wxRichTextObjectPtrArray(void *sipDst, SIP_SSIZE_T sipDstIdx, const void *sipSrc)
{
    reinterpret_cast< ::wxRichTextObjectPtrArray *>(sipDst)[sipDstIdx] = *reinterpret_cast<const  ::wxRichTextObjectPtrArray *>(sipSrc);
}


extern "C" {static void *array_wxRichTextObjectPtrArray(SIP_SSIZE_T);}
static void *array_wxRichTextObjectPtrArray(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxRichTextObjectPtrArray[sipNrElem];
}


extern "C" {static void *copy_wxRichTextObjectPtrArray(const void *, SIP_SSIZE_T);}
static void *copy_wxRichTextObjectPtrArray(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxRichTextObjectPtrArray(reinterpret_cast<const  ::wxRichTextObjectPtrArray *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxRichTextObjectPtrArray(sipSimpleWrapper *);}
static void dealloc_wxRichTextObjectPtrArray(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxRichTextObjectPtrArray(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxRichTextObjectPtrArray(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxRichTextObjectPtrArray(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxRichTextObjectPtrArray *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxRichTextObjectPtrArray();
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const  ::wxRichTextObjectPtrArray* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_wxRichTextObjectPtrArray, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxRichTextObjectPtrArray(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxRichTextObjectPtrArray[] = {
    {(void *)slot_wxRichTextObjectPtrArray___contains__, contains_slot},
    {(void *)slot_wxRichTextObjectPtrArray___getitem__, getitem_slot},
    {(void *)slot_wxRichTextObjectPtrArray___len__, len_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxRichTextObjectPtrArray[] = {
    {SIP_MLNAME_CAST(sipName_append), (PyCFunction)meth_wxRichTextObjectPtrArray_append, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextObjectPtrArray_append)},
    {SIP_MLNAME_CAST(sipName_index), (PyCFunction)meth_wxRichTextObjectPtrArray_index, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextObjectPtrArray_index)}
};

PyDoc_STRVAR(doc_wxRichTextObjectPtrArray, "\1RichTextObjectPtrArray()\n"
    "RichTextObjectPtrArray(RichTextObjectPtrArray)");


sipClassTypeDef sipTypeDef__richtext_wxRichTextObjectPtrArray = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxRichTextObjectPtrArray,
        {0},
        0
    },
    {
        sipNameNr_RichTextObjectPtrArray,
        {0, 0, 1},
        2, methods_wxRichTextObjectPtrArray,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxRichTextObjectPtrArray,
    -1,
    -1,
    0,
    slots_wxRichTextObjectPtrArray,
    init_type_wxRichTextObjectPtrArray,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxRichTextObjectPtrArray,
    assign_wxRichTextObjectPtrArray,
    array_wxRichTextObjectPtrArray,
    copy_wxRichTextObjectPtrArray,
    release_wxRichTextObjectPtrArray,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
