/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.2
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"

        #include <wx/richtext/richtextstyles.h>

        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextstyles.h>
        #include <wx/object.h>
        #include <wx/object.h>


PyDoc_STRVAR(doc_wxRichTextStyleDefinition_GetStyle, "GetStyle() -> RichTextAttr\n"
    "\n"
    "Returns the attributes associated with this style.");

extern "C" {static PyObject *meth_wxRichTextStyleDefinition_GetStyle(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleDefinition_GetStyle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextStyleDefinition *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextStyleDefinition, &sipCpp))
        {
             ::wxRichTextAttr*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxRichTextAttr(sipCpp->GetStyle());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxRichTextAttr,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleDefinition, sipName_GetStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleDefinition_GetBaseStyle, "GetBaseStyle() -> String\n"
    "\n"
    "Returns the style on which this style is based.");

extern "C" {static PyObject *meth_wxRichTextStyleDefinition_GetBaseStyle(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleDefinition_GetBaseStyle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextStyleDefinition *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextStyleDefinition, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetBaseStyle());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleDefinition, sipName_GetBaseStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleDefinition_GetDescription, "GetDescription() -> String\n"
    "\n"
    "Returns the style's description.");

extern "C" {static PyObject *meth_wxRichTextStyleDefinition_GetDescription(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleDefinition_GetDescription(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextStyleDefinition *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextStyleDefinition, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetDescription());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleDefinition, sipName_GetDescription, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleDefinition_GetName, "GetName() -> String\n"
    "\n"
    "Returns the style name.");

extern "C" {static PyObject *meth_wxRichTextStyleDefinition_GetName(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleDefinition_GetName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextStyleDefinition *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextStyleDefinition, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleDefinition, sipName_GetName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleDefinition_GetStyleMergedWithBase, "GetStyleMergedWithBase(sheet) -> RichTextAttr\n"
    "\n"
    "Returns the style attributes combined with the attributes of the\n"
    "specified base style, if any.");

extern "C" {static PyObject *meth_wxRichTextStyleDefinition_GetStyleMergedWithBase(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleDefinition_GetStyleMergedWithBase(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxRichTextStyleSheet* sheet;
        const  ::wxRichTextStyleDefinition *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sheet,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxRichTextStyleDefinition, &sipCpp, sipType_wxRichTextStyleSheet, &sheet))
        {
             ::wxRichTextAttr*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxRichTextAttr((sipSelfWasArg ? sipCpp-> ::wxRichTextStyleDefinition::GetStyleMergedWithBase(sheet) : sipCpp->GetStyleMergedWithBase(sheet)));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxRichTextAttr,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleDefinition, sipName_GetStyleMergedWithBase, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleDefinition_SetBaseStyle, "SetBaseStyle(name)\n"
    "\n"
    "Sets the name of the style that this style is based on.");

extern "C" {static PyObject *meth_wxRichTextStyleDefinition_SetBaseStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleDefinition_SetBaseStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxRichTextStyleDefinition *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxRichTextStyleDefinition, &sipCpp, sipType_wxString,&name, &nameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBaseStyle(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleDefinition, sipName_SetBaseStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleDefinition_SetDescription, "SetDescription(descr)\n"
    "\n"
    "Sets the style description.");

extern "C" {static PyObject *meth_wxRichTextStyleDefinition_SetDescription(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleDefinition_SetDescription(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* descr;
        int descrState = 0;
         ::wxRichTextStyleDefinition *sipCpp;

        static const char *sipKwdList[] = {
            sipName_descr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxRichTextStyleDefinition, &sipCpp, sipType_wxString,&descr, &descrState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDescription(*descr);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(descr),sipType_wxString,descrState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleDefinition, sipName_SetDescription, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleDefinition_SetName, "SetName(name)\n"
    "\n"
    "Sets the name of the style.");

extern "C" {static PyObject *meth_wxRichTextStyleDefinition_SetName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleDefinition_SetName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxRichTextStyleDefinition *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxRichTextStyleDefinition, &sipCpp, sipType_wxString,&name, &nameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetName(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleDefinition, sipName_SetName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleDefinition_SetStyle, "SetStyle(style)\n"
    "\n"
    "Sets the attributes for this style.");

extern "C" {static PyObject *meth_wxRichTextStyleDefinition_SetStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleDefinition_SetStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextAttr* style;
         ::wxRichTextStyleDefinition *sipCpp;

        static const char *sipKwdList[] = {
            sipName_style,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxRichTextStyleDefinition, &sipCpp, sipType_wxRichTextAttr, &style))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetStyle(*style);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleDefinition, sipName_SetStyle, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleDefinition_GetProperties, "GetProperties() -> RichTextProperties\n"
    "\n"
    "Returns the definition's properties.");

extern "C" {static PyObject *meth_wxRichTextStyleDefinition_GetProperties(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleDefinition_GetProperties(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxRichTextStyleDefinition *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextStyleDefinition, &sipCpp))
        {
             ::wxRichTextProperties*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetProperties();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxRichTextProperties,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleDefinition, sipName_GetProperties, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxRichTextStyleDefinition_SetProperties, "SetProperties(props)\n"
    "\n"
    "Sets the definition's properties.");

extern "C" {static PyObject *meth_wxRichTextStyleDefinition_SetProperties(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextStyleDefinition_SetProperties(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxRichTextProperties* props;
         ::wxRichTextStyleDefinition *sipCpp;

        static const char *sipKwdList[] = {
            sipName_props,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_wxRichTextStyleDefinition, &sipCpp, sipType_wxRichTextProperties, &props))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetProperties(*props);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextStyleDefinition, sipName_SetProperties, NULL);

    return NULL;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxRichTextStyleDefinition(void *, const sipTypeDef *);}
static void *cast_wxRichTextStyleDefinition(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxRichTextStyleDefinition *sipCpp = reinterpret_cast< ::wxRichTextStyleDefinition *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxRichTextStyleDefinition(void *, int);}
static void release_wxRichTextStyleDefinition(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxRichTextStyleDefinition *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxRichTextStyleDefinition(sipSimpleWrapper *);}
static void dealloc_wxRichTextStyleDefinition(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxRichTextStyleDefinition(sipGetAddress(sipSelf), 0);
    }
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxRichTextStyleDefinition[] = {{42, 0, 1}};


static PyMethodDef methods_wxRichTextStyleDefinition[] = {
    {SIP_MLNAME_CAST(sipName_GetBaseStyle), meth_wxRichTextStyleDefinition_GetBaseStyle, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextStyleDefinition_GetBaseStyle)},
    {SIP_MLNAME_CAST(sipName_GetDescription), meth_wxRichTextStyleDefinition_GetDescription, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextStyleDefinition_GetDescription)},
    {SIP_MLNAME_CAST(sipName_GetName), meth_wxRichTextStyleDefinition_GetName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextStyleDefinition_GetName)},
    {SIP_MLNAME_CAST(sipName_GetProperties), meth_wxRichTextStyleDefinition_GetProperties, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextStyleDefinition_GetProperties)},
    {SIP_MLNAME_CAST(sipName_GetStyle), meth_wxRichTextStyleDefinition_GetStyle, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextStyleDefinition_GetStyle)},
    {SIP_MLNAME_CAST(sipName_GetStyleMergedWithBase), (PyCFunction)meth_wxRichTextStyleDefinition_GetStyleMergedWithBase, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextStyleDefinition_GetStyleMergedWithBase)},
    {SIP_MLNAME_CAST(sipName_SetBaseStyle), (PyCFunction)meth_wxRichTextStyleDefinition_SetBaseStyle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextStyleDefinition_SetBaseStyle)},
    {SIP_MLNAME_CAST(sipName_SetDescription), (PyCFunction)meth_wxRichTextStyleDefinition_SetDescription, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextStyleDefinition_SetDescription)},
    {SIP_MLNAME_CAST(sipName_SetName), (PyCFunction)meth_wxRichTextStyleDefinition_SetName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextStyleDefinition_SetName)},
    {SIP_MLNAME_CAST(sipName_SetProperties), (PyCFunction)meth_wxRichTextStyleDefinition_SetProperties, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextStyleDefinition_SetProperties)},
    {SIP_MLNAME_CAST(sipName_SetStyle), (PyCFunction)meth_wxRichTextStyleDefinition_SetStyle, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextStyleDefinition_SetStyle)}
};

sipVariableDef variables_wxRichTextStyleDefinition[] = {
    {PropertyVariable, sipName_Style, &methods_wxRichTextStyleDefinition[4], &methods_wxRichTextStyleDefinition[10], NULL, NULL},
    {PropertyVariable, sipName_Properties, &methods_wxRichTextStyleDefinition[3], &methods_wxRichTextStyleDefinition[9], NULL, NULL},
    {PropertyVariable, sipName_Name, &methods_wxRichTextStyleDefinition[2], &methods_wxRichTextStyleDefinition[8], NULL, NULL},
    {PropertyVariable, sipName_Description, &methods_wxRichTextStyleDefinition[1], &methods_wxRichTextStyleDefinition[7], NULL, NULL},
    {PropertyVariable, sipName_BaseStyle, &methods_wxRichTextStyleDefinition[0], &methods_wxRichTextStyleDefinition[6], NULL, NULL},
};

PyDoc_STRVAR(doc_wxRichTextStyleDefinition, "RichTextStyleDefinition(name=wx.EmptyString)\n"
    "\n"
    "This is a base class for paragraph and character styles.");


sipClassTypeDef sipTypeDef__richtext_wxRichTextStyleDefinition = {
    {
        -1,
        0,
        0,
        SIP_TYPE_ABSTRACT|SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxRichTextStyleDefinition,
        {0},
        0
    },
    {
        sipNameNr_RichTextStyleDefinition,
        {0, 0, 1},
        11, methods_wxRichTextStyleDefinition,
        0, 0,
        5, variables_wxRichTextStyleDefinition,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxRichTextStyleDefinition,
    -1,
    -1,
    supers_wxRichTextStyleDefinition,
    0,
    0,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxRichTextStyleDefinition,
    0,
    0,
    0,
    release_wxRichTextStyleDefinition,
    cast_wxRichTextStyleDefinition,
    0,
    0,
    0,
    0,
    0,
    0
};
