/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.2
 *
 *     Copyright: (c) 2017 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_xml.h"

        #include <wx/xml/xml.h>

        #include <wx/xml/xml.h>


class sipwxXmlNode : public  ::wxXmlNode
{
public:
    sipwxXmlNode( ::wxXmlNode*, ::wxXmlNodeType,const  ::wxString&,const  ::wxString&, ::wxXmlAttribute*, ::wxXmlNode*,int);
    sipwxXmlNode( ::wxXmlNodeType,const  ::wxString&,const  ::wxString&,int);
    sipwxXmlNode(const  ::wxXmlNode&);
    virtual ~sipwxXmlNode();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    bool RemoveChild( ::wxXmlNode*);
    bool InsertChildAfter( ::wxXmlNode*, ::wxXmlNode*);
    bool InsertChild( ::wxXmlNode*, ::wxXmlNode*);
    bool DeleteAttribute(const  ::wxString&);
    void AddChild( ::wxXmlNode*);
    void AddAttribute( ::wxXmlAttribute*);
    void AddAttribute(const  ::wxString&,const  ::wxString&);

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxXmlNode(const sipwxXmlNode &);
    sipwxXmlNode &operator = (const sipwxXmlNode &);

    char sipPyMethods[7];
};

sipwxXmlNode::sipwxXmlNode( ::wxXmlNode*parent, ::wxXmlNodeType type,const  ::wxString& name,const  ::wxString& content, ::wxXmlAttribute*attrs, ::wxXmlNode*next,int lineNo):  ::wxXmlNode(parent,type,name,content,attrs,next,lineNo), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxXmlNode::sipwxXmlNode( ::wxXmlNodeType type,const  ::wxString& name,const  ::wxString& content,int lineNo):  ::wxXmlNode(type,name,content,lineNo), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxXmlNode::sipwxXmlNode(const  ::wxXmlNode& node):  ::wxXmlNode(node), sipPySelf(0)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxXmlNode::~sipwxXmlNode()
{
    sipCommonDtor(sipPySelf);
}

bool sipwxXmlNode::RemoveChild( ::wxXmlNode*child)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[0],sipPySelf,NULL,sipName_RemoveChild);

    if (!sipMeth)
        return  ::wxXmlNode::RemoveChild(child);

    extern bool sipVH__xml_5(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxXmlNode*);

    return sipVH__xml_5(sipGILState, 0, sipPySelf, sipMeth, child);
}

bool sipwxXmlNode::InsertChildAfter( ::wxXmlNode*child, ::wxXmlNode*precedingNode)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[1],sipPySelf,NULL,sipName_InsertChildAfter);

    if (!sipMeth)
        return  ::wxXmlNode::InsertChildAfter(child,precedingNode);

    extern bool sipVH__xml_4(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxXmlNode*, ::wxXmlNode*);

    return sipVH__xml_4(sipGILState, 0, sipPySelf, sipMeth, child, precedingNode);
}

bool sipwxXmlNode::InsertChild( ::wxXmlNode*child, ::wxXmlNode*followingNode)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[2],sipPySelf,NULL,sipName_InsertChild);

    if (!sipMeth)
        return  ::wxXmlNode::InsertChild(child,followingNode);

    extern bool sipVH__xml_4(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxXmlNode*, ::wxXmlNode*);

    return sipVH__xml_4(sipGILState, 0, sipPySelf, sipMeth, child, followingNode);
}

bool sipwxXmlNode::DeleteAttribute(const  ::wxString& name)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[3],sipPySelf,NULL,sipName_DeleteAttribute);

    if (!sipMeth)
        return  ::wxXmlNode::DeleteAttribute(name);

    extern bool sipVH__xml_3(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&);

    return sipVH__xml_3(sipGILState, 0, sipPySelf, sipMeth, name);
}

void sipwxXmlNode::AddChild( ::wxXmlNode*child)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[4],sipPySelf,NULL,sipName_AddChild);

    if (!sipMeth)
    {
         ::wxXmlNode::AddChild(child);
        return;
    }

    extern void sipVH__xml_2(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxXmlNode*);

    sipVH__xml_2(sipGILState, 0, sipPySelf, sipMeth, child);
}

void sipwxXmlNode::AddAttribute( ::wxXmlAttribute*attr)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[5],sipPySelf,NULL,sipName_AddAttribute);

    if (!sipMeth)
    {
         ::wxXmlNode::AddAttribute(attr);
        return;
    }

    extern void sipVH__xml_1(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxXmlAttribute*);

    sipVH__xml_1(sipGILState, 0, sipPySelf, sipMeth, attr);
}

void sipwxXmlNode::AddAttribute(const  ::wxString& name,const  ::wxString& value)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[6],sipPySelf,NULL,sipName_AddAttribute);

    if (!sipMeth)
    {
         ::wxXmlNode::AddAttribute(name,value);
        return;
    }

    extern void sipVH__xml_0(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&,const  ::wxString&);

    sipVH__xml_0(sipGILState, 0, sipPySelf, sipMeth, name, value);
}


PyDoc_STRVAR(doc_wxXmlNode_AddAttribute, "AddAttribute(name, value)\n"
    "AddAttribute(attr)\n"
    "\n"
    "Appends a attribute with given name and value to the list of\n"
    "attributes for this node.");

extern "C" {static PyObject *meth_wxXmlNode_AddAttribute(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlNode_AddAttribute(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxString* value;
        int valueState = 0;
         ::wxXmlNode *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1", &sipSelf, sipType_wxXmlNode, &sipCpp, sipType_wxString,&name, &nameState, sipType_wxString,&value, &valueState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxXmlNode::AddAttribute(*name,*value) : sipCpp->AddAttribute(*name,*value));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);
            sipReleaseType(const_cast< ::wxString *>(value),sipType_wxString,valueState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
         ::wxXmlAttribute* attr;
         ::wxXmlNode *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ:", &sipSelf, sipType_wxXmlNode, &sipCpp, sipType_wxXmlAttribute, &attr))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxXmlNode::AddAttribute(attr) : sipCpp->AddAttribute(attr));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlNode, sipName_AddAttribute, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlNode_AddChild, "AddChild(child)\n"
    "\n"
    "Adds node child as the last child of this node.");

extern "C" {static PyObject *meth_wxXmlNode_AddChild(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlNode_AddChild(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxXmlNode* child;
         ::wxXmlNode *sipCpp;

        static const char *sipKwdList[] = {
            sipName_child,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ:", &sipSelf, sipType_wxXmlNode, &sipCpp, sipType_wxXmlNode, &child))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxXmlNode::AddChild(child) : sipCpp->AddChild(child));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlNode, sipName_AddChild, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlNode_DeleteAttribute, "DeleteAttribute(name) -> bool\n"
    "\n"
    "Removes the first attributes which has the given name from the list of\n"
    "attributes for this node.");

extern "C" {static PyObject *meth_wxXmlNode_DeleteAttribute(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlNode_DeleteAttribute(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxXmlNode *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxXmlNode, &sipCpp, sipType_wxString,&name, &nameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxXmlNode::DeleteAttribute(*name) : sipCpp->DeleteAttribute(*name));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlNode, sipName_DeleteAttribute, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlNode_GetAttribute, "GetAttribute(attrName, defaultVal=wx.EmptyString) -> String\n"
    "\n"
    "Returns the value of the attribute named attrName if it does exist.");

extern "C" {static PyObject *meth_wxXmlNode_GetAttribute(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlNode_GetAttribute(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* attrName;
        int attrNameState = 0;
        const  ::wxString& defaultValdef = wxEmptyString;
        const  ::wxString* defaultVal = &defaultValdef;
        int defaultValState = 0;
        const  ::wxXmlNode *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attrName,
            sipName_defaultVal,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|J1", &sipSelf, sipType_wxXmlNode, &sipCpp, sipType_wxString,&attrName, &attrNameState, sipType_wxString,&defaultVal, &defaultValState))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetAttribute(*attrName,*defaultVal));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(attrName),sipType_wxString,attrNameState);
            sipReleaseType(const_cast< ::wxString *>(defaultVal),sipType_wxString,defaultValState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlNode, sipName_GetAttribute, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlNode_GetAttributes, "GetAttributes() -> XmlAttribute\n"
    "\n"
    "Return a pointer to the first attribute of this node.");

extern "C" {static PyObject *meth_wxXmlNode_GetAttributes(PyObject *, PyObject *);}
static PyObject *meth_wxXmlNode_GetAttributes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxXmlNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlNode, &sipCpp))
        {
             ::wxXmlAttribute*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetAttributes();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxXmlAttribute,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlNode, sipName_GetAttributes, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlNode_GetChildren, "GetChildren() -> XmlNode\n"
    "\n"
    "Returns the first child of this node.");

extern "C" {static PyObject *meth_wxXmlNode_GetChildren(PyObject *, PyObject *);}
static PyObject *meth_wxXmlNode_GetChildren(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxXmlNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlNode, &sipCpp))
        {
             ::wxXmlNode*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetChildren();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxXmlNode,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlNode, sipName_GetChildren, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlNode_GetContent, "GetContent() -> String\n"
    "\n"
    "Returns the content of this node.");

extern "C" {static PyObject *meth_wxXmlNode_GetContent(PyObject *, PyObject *);}
static PyObject *meth_wxXmlNode_GetContent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxXmlNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlNode, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetContent());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlNode, sipName_GetContent, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlNode_GetDepth, "GetDepth(grandparent=None) -> int\n"
    "\n"
    "Returns the number of nodes which separate this node from grandparent.");

extern "C" {static PyObject *meth_wxXmlNode_GetDepth(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlNode_GetDepth(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxXmlNode* grandparent = 0;
        const  ::wxXmlNode *sipCpp;

        static const char *sipKwdList[] = {
            sipName_grandparent,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "B|J8", &sipSelf, sipType_wxXmlNode, &sipCpp, sipType_wxXmlNode, &grandparent))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDepth(grandparent);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlNode, sipName_GetDepth, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlNode_GetNoConversion, "GetNoConversion() -> bool\n"
    "\n"
    "Returns a flag indicating whether encoding conversion is necessary\n"
    "when saving.");

extern "C" {static PyObject *meth_wxXmlNode_GetNoConversion(PyObject *, PyObject *);}
static PyObject *meth_wxXmlNode_GetNoConversion(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxXmlNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlNode, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetNoConversion();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlNode, sipName_GetNoConversion, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlNode_GetLineNumber, "GetLineNumber() -> int\n"
    "\n"
    "Returns line number of the node in the input XML file or -1 if it is\n"
    "unknown.");

extern "C" {static PyObject *meth_wxXmlNode_GetLineNumber(PyObject *, PyObject *);}
static PyObject *meth_wxXmlNode_GetLineNumber(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxXmlNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlNode, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLineNumber();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlNode, sipName_GetLineNumber, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlNode_GetName, "GetName() -> String\n"
    "\n"
    "Returns the name of this node.");

extern "C" {static PyObject *meth_wxXmlNode_GetName(PyObject *, PyObject *);}
static PyObject *meth_wxXmlNode_GetName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxXmlNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlNode, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlNode, sipName_GetName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlNode_GetNext, "GetNext() -> XmlNode\n"
    "\n"
    "Returns a pointer to the sibling of this node or NULL if there are no\n"
    "siblings.");

extern "C" {static PyObject *meth_wxXmlNode_GetNext(PyObject *, PyObject *);}
static PyObject *meth_wxXmlNode_GetNext(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxXmlNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlNode, &sipCpp))
        {
             ::wxXmlNode*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetNext();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxXmlNode,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlNode, sipName_GetNext, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlNode_GetNodeContent, "GetNodeContent() -> String\n"
    "\n"
    "Returns the content of the first child node of type wxXML_TEXT_NODE or\n"
    "wxXML_CDATA_SECTION_NODE.");

extern "C" {static PyObject *meth_wxXmlNode_GetNodeContent(PyObject *, PyObject *);}
static PyObject *meth_wxXmlNode_GetNodeContent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxXmlNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlNode, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetNodeContent());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlNode, sipName_GetNodeContent, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlNode_GetParent, "GetParent() -> XmlNode\n"
    "\n"
    "Returns a pointer to the parent of this node or NULL if this node has\n"
    "no parent.");

extern "C" {static PyObject *meth_wxXmlNode_GetParent(PyObject *, PyObject *);}
static PyObject *meth_wxXmlNode_GetParent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxXmlNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlNode, &sipCpp))
        {
             ::wxXmlNode*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetParent();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxXmlNode,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlNode, sipName_GetParent, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlNode_GetType, "GetType() -> XmlNodeType\n"
    "\n"
    "Returns the type of this node.");

extern "C" {static PyObject *meth_wxXmlNode_GetType(PyObject *, PyObject *);}
static PyObject *meth_wxXmlNode_GetType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxXmlNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlNode, &sipCpp))
        {
             ::wxXmlNodeType sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetType();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(sipRes,sipType_wxXmlNodeType);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlNode, sipName_GetType, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlNode_HasAttribute, "HasAttribute(attrName) -> bool\n"
    "\n"
    "Returns true if this node has a attribute named attrName.");

extern "C" {static PyObject *meth_wxXmlNode_HasAttribute(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlNode_HasAttribute(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* attrName;
        int attrNameState = 0;
        const  ::wxXmlNode *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attrName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxXmlNode, &sipCpp, sipType_wxString,&attrName, &attrNameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasAttribute(*attrName);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(attrName),sipType_wxString,attrNameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlNode, sipName_HasAttribute, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlNode_InsertChild, "InsertChild(child, followingNode) -> bool\n"
    "\n"
    "Inserts the child node immediately before followingNode in the\n"
    "children list.");

extern "C" {static PyObject *meth_wxXmlNode_InsertChild(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlNode_InsertChild(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxXmlNode* child;
         ::wxXmlNode* followingNode;
         ::wxXmlNode *sipCpp;

        static const char *sipKwdList[] = {
            sipName_child,
            sipName_followingNode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ:J8", &sipSelf, sipType_wxXmlNode, &sipCpp, sipType_wxXmlNode, &child, sipType_wxXmlNode, &followingNode))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxXmlNode::InsertChild(child,followingNode) : sipCpp->InsertChild(child,followingNode));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlNode, sipName_InsertChild, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlNode_InsertChildAfter, "InsertChildAfter(child, precedingNode) -> bool\n"
    "\n"
    "Inserts the child node immediately after precedingNode in the children\n"
    "list.");

extern "C" {static PyObject *meth_wxXmlNode_InsertChildAfter(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlNode_InsertChildAfter(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxXmlNode* child;
         ::wxXmlNode* precedingNode;
         ::wxXmlNode *sipCpp;

        static const char *sipKwdList[] = {
            sipName_child,
            sipName_precedingNode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ:J8", &sipSelf, sipType_wxXmlNode, &sipCpp, sipType_wxXmlNode, &child, sipType_wxXmlNode, &precedingNode))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxXmlNode::InsertChildAfter(child,precedingNode) : sipCpp->InsertChildAfter(child,precedingNode));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlNode, sipName_InsertChildAfter, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlNode_IsWhitespaceOnly, "IsWhitespaceOnly() -> bool\n"
    "\n"
    "Returns true if the content of this node is a string containing only\n"
    "whitespaces (spaces, tabs, new lines, etc).");

extern "C" {static PyObject *meth_wxXmlNode_IsWhitespaceOnly(PyObject *, PyObject *);}
static PyObject *meth_wxXmlNode_IsWhitespaceOnly(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxXmlNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlNode, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsWhitespaceOnly();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlNode, sipName_IsWhitespaceOnly, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlNode_RemoveChild, "RemoveChild(child) -> bool\n"
    "\n"
    "Removes the given node from the children list.");

extern "C" {static PyObject *meth_wxXmlNode_RemoveChild(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlNode_RemoveChild(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxXmlNode* child;
         ::wxXmlNode *sipCpp;

        static const char *sipKwdList[] = {
            sipName_child,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ<", &sipSelf, sipType_wxXmlNode, &sipCpp, sipType_wxXmlNode, &child))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxXmlNode::RemoveChild(child) : sipCpp->RemoveChild(child));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlNode, sipName_RemoveChild, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlNode_SetContent, "SetContent(con)\n"
    "\n"
    "Sets the content of this node.");

extern "C" {static PyObject *meth_wxXmlNode_SetContent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlNode_SetContent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* con;
        int conState = 0;
         ::wxXmlNode *sipCpp;

        static const char *sipKwdList[] = {
            sipName_con,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxXmlNode, &sipCpp, sipType_wxString,&con, &conState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetContent(*con);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(con),sipType_wxString,conState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlNode, sipName_SetContent, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlNode_SetName, "SetName(name)\n"
    "\n"
    "Sets the name of this node.");

extern "C" {static PyObject *meth_wxXmlNode_SetName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlNode_SetName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxXmlNode *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_wxXmlNode, &sipCpp, sipType_wxString,&name, &nameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetName(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlNode, sipName_SetName, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlNode_SetNext, "SetNext(next)\n"
    "\n"
    "Sets as sibling the given node.");

extern "C" {static PyObject *meth_wxXmlNode_SetNext(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlNode_SetNext(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxXmlNode* next;
         ::wxXmlNode *sipCpp;

        static const char *sipKwdList[] = {
            sipName_next,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxXmlNode, &sipCpp, sipType_wxXmlNode, &next))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetNext(next);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlNode, sipName_SetNext, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlNode_SetNoConversion, "SetNoConversion(noconversion)\n"
    "\n"
    "Sets a flag to indicate whether encoding conversion is necessary when\n"
    "saving.");

extern "C" {static PyObject *meth_wxXmlNode_SetNoConversion(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlNode_SetNoConversion(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        bool noconversion;
         ::wxXmlNode *sipCpp;

        static const char *sipKwdList[] = {
            sipName_noconversion,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bb", &sipSelf, sipType_wxXmlNode, &sipCpp, &noconversion))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetNoConversion(noconversion);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlNode, sipName_SetNoConversion, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlNode_SetParent, "SetParent(parent)\n"
    "\n"
    "Sets as parent the given node.");

extern "C" {static PyObject *meth_wxXmlNode_SetParent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlNode_SetParent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxXmlNode* parent;
         ::wxXmlNode *sipCpp;

        static const char *sipKwdList[] = {
            sipName_parent,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ8", &sipSelf, sipType_wxXmlNode, &sipCpp, sipType_wxXmlNode, &parent))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetParent(parent);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlNode, sipName_SetParent, NULL);

    return NULL;
}


PyDoc_STRVAR(doc_wxXmlNode_SetType, "SetType(type)\n"
    "\n"
    "Sets the type of this node.");

extern "C" {static PyObject *meth_wxXmlNode_SetType(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlNode_SetType(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
         ::wxXmlNodeType type;
         ::wxXmlNode *sipCpp;

        static const char *sipKwdList[] = {
            sipName_type,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BE", &sipSelf, sipType_wxXmlNode, &sipCpp, sipType_wxXmlNodeType, &type))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetType(type);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlNode, sipName_SetType, NULL);

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxXmlNode(void *, int);}
static void release_wxXmlNode(void *sipCppV, int sipIsDerived)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipIsDerived)
        delete reinterpret_cast<sipwxXmlNode *>(sipCppV);
    else
        delete reinterpret_cast< ::wxXmlNode *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxXmlNode(sipSimpleWrapper *);}
static void dealloc_wxXmlNode(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxXmlNode *>(sipGetAddress(sipSelf))->sipPySelf = NULL;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxXmlNode(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxXmlNode(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxXmlNode(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **sipOwner, PyObject **sipParseErr)
{
    sipwxXmlNode *sipCpp = 0;

    {
         ::wxXmlNode* parent;
         ::wxXmlNodeType type;
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxString& contentdef = wxEmptyString;
        const  ::wxString* content = &contentdef;
        int contentState = 0;
         ::wxXmlAttribute* attrs = 0;
         ::wxXmlNode* next = 0;
        int lineNo = -1;

        static const char *sipKwdList[] = {
            sipName_parent,
            sipName_type,
            sipName_name,
            sipName_content,
            sipName_attrs,
            sipName_next,
            sipName_lineNo,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "JHEJ1|J1J8J8i", sipType_wxXmlNode, &parent, sipOwner, sipType_wxXmlNodeType, &type, sipType_wxString,&name, &nameState, sipType_wxString,&content, &contentState, sipType_wxXmlAttribute, &attrs, sipType_wxXmlNode, &next, &lineNo))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxXmlNode(parent,type,*name,*content,attrs,next,lineNo);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);
            sipReleaseType(const_cast< ::wxString *>(content),sipType_wxString,contentState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
         ::wxXmlNodeType type;
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxString& contentdef = wxEmptyString;
        const  ::wxString* content = &contentdef;
        int contentState = 0;
        int lineNo = -1;

        static const char *sipKwdList[] = {
            sipName_type,
            sipName_name,
            sipName_content,
            sipName_lineNo,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "EJ1|J1i", sipType_wxXmlNodeType, &type, sipType_wxString,&name, &nameState, sipType_wxString,&content, &contentState, &lineNo))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxXmlNode(type,*name,*content,lineNo);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);
            sipReleaseType(const_cast< ::wxString *>(content),sipType_wxString,contentState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxXmlNode* node;

        static const char *sipKwdList[] = {
            sipName_node,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxXmlNode, &node))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxXmlNode(*node);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return NULL;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return NULL;
}


static PyMethodDef methods_wxXmlNode[] = {
    {SIP_MLNAME_CAST(sipName_AddAttribute), (PyCFunction)meth_wxXmlNode_AddAttribute, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlNode_AddAttribute)},
    {SIP_MLNAME_CAST(sipName_AddChild), (PyCFunction)meth_wxXmlNode_AddChild, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlNode_AddChild)},
    {SIP_MLNAME_CAST(sipName_DeleteAttribute), (PyCFunction)meth_wxXmlNode_DeleteAttribute, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlNode_DeleteAttribute)},
    {SIP_MLNAME_CAST(sipName_GetAttribute), (PyCFunction)meth_wxXmlNode_GetAttribute, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlNode_GetAttribute)},
    {SIP_MLNAME_CAST(sipName_GetAttributes), meth_wxXmlNode_GetAttributes, METH_VARARGS, SIP_MLDOC_CAST(doc_wxXmlNode_GetAttributes)},
    {SIP_MLNAME_CAST(sipName_GetChildren), meth_wxXmlNode_GetChildren, METH_VARARGS, SIP_MLDOC_CAST(doc_wxXmlNode_GetChildren)},
    {SIP_MLNAME_CAST(sipName_GetContent), meth_wxXmlNode_GetContent, METH_VARARGS, SIP_MLDOC_CAST(doc_wxXmlNode_GetContent)},
    {SIP_MLNAME_CAST(sipName_GetDepth), (PyCFunction)meth_wxXmlNode_GetDepth, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlNode_GetDepth)},
    {SIP_MLNAME_CAST(sipName_GetLineNumber), meth_wxXmlNode_GetLineNumber, METH_VARARGS, SIP_MLDOC_CAST(doc_wxXmlNode_GetLineNumber)},
    {SIP_MLNAME_CAST(sipName_GetName), meth_wxXmlNode_GetName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxXmlNode_GetName)},
    {SIP_MLNAME_CAST(sipName_GetNext), meth_wxXmlNode_GetNext, METH_VARARGS, SIP_MLDOC_CAST(doc_wxXmlNode_GetNext)},
    {SIP_MLNAME_CAST(sipName_GetNoConversion), meth_wxXmlNode_GetNoConversion, METH_VARARGS, SIP_MLDOC_CAST(doc_wxXmlNode_GetNoConversion)},
    {SIP_MLNAME_CAST(sipName_GetNodeContent), meth_wxXmlNode_GetNodeContent, METH_VARARGS, SIP_MLDOC_CAST(doc_wxXmlNode_GetNodeContent)},
    {SIP_MLNAME_CAST(sipName_GetParent), meth_wxXmlNode_GetParent, METH_VARARGS, SIP_MLDOC_CAST(doc_wxXmlNode_GetParent)},
    {SIP_MLNAME_CAST(sipName_GetType), meth_wxXmlNode_GetType, METH_VARARGS, SIP_MLDOC_CAST(doc_wxXmlNode_GetType)},
    {SIP_MLNAME_CAST(sipName_HasAttribute), (PyCFunction)meth_wxXmlNode_HasAttribute, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlNode_HasAttribute)},
    {SIP_MLNAME_CAST(sipName_InsertChild), (PyCFunction)meth_wxXmlNode_InsertChild, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlNode_InsertChild)},
    {SIP_MLNAME_CAST(sipName_InsertChildAfter), (PyCFunction)meth_wxXmlNode_InsertChildAfter, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlNode_InsertChildAfter)},
    {SIP_MLNAME_CAST(sipName_IsWhitespaceOnly), meth_wxXmlNode_IsWhitespaceOnly, METH_VARARGS, SIP_MLDOC_CAST(doc_wxXmlNode_IsWhitespaceOnly)},
    {SIP_MLNAME_CAST(sipName_RemoveChild), (PyCFunction)meth_wxXmlNode_RemoveChild, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlNode_RemoveChild)},
    {SIP_MLNAME_CAST(sipName_SetContent), (PyCFunction)meth_wxXmlNode_SetContent, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlNode_SetContent)},
    {SIP_MLNAME_CAST(sipName_SetName), (PyCFunction)meth_wxXmlNode_SetName, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlNode_SetName)},
    {SIP_MLNAME_CAST(sipName_SetNext), (PyCFunction)meth_wxXmlNode_SetNext, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlNode_SetNext)},
    {SIP_MLNAME_CAST(sipName_SetNoConversion), (PyCFunction)meth_wxXmlNode_SetNoConversion, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlNode_SetNoConversion)},
    {SIP_MLNAME_CAST(sipName_SetParent), (PyCFunction)meth_wxXmlNode_SetParent, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlNode_SetParent)},
    {SIP_MLNAME_CAST(sipName_SetType), (PyCFunction)meth_wxXmlNode_SetType, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxXmlNode_SetType)}
};

sipVariableDef variables_wxXmlNode[] = {
    {PropertyVariable, sipName_Type, &methods_wxXmlNode[14], &methods_wxXmlNode[25], NULL, NULL},
    {PropertyVariable, sipName_Parent, &methods_wxXmlNode[13], &methods_wxXmlNode[24], NULL, NULL},
    {PropertyVariable, sipName_NodeContent, &methods_wxXmlNode[12], NULL, NULL, NULL},
    {PropertyVariable, sipName_NoConversion, &methods_wxXmlNode[11], &methods_wxXmlNode[23], NULL, NULL},
    {PropertyVariable, sipName_Next, &methods_wxXmlNode[10], &methods_wxXmlNode[22], NULL, NULL},
    {PropertyVariable, sipName_Name, &methods_wxXmlNode[9], &methods_wxXmlNode[21], NULL, NULL},
    {PropertyVariable, sipName_LineNumber, &methods_wxXmlNode[8], NULL, NULL, NULL},
    {PropertyVariable, sipName_Depth, &methods_wxXmlNode[7], NULL, NULL, NULL},
    {PropertyVariable, sipName_Content, &methods_wxXmlNode[6], &methods_wxXmlNode[20], NULL, NULL},
    {PropertyVariable, sipName_Children, &methods_wxXmlNode[5], NULL, NULL, NULL},
    {PropertyVariable, sipName_Attributes, &methods_wxXmlNode[4], NULL, NULL, NULL},
};

PyDoc_STRVAR(doc_wxXmlNode, "XmlNode(parent, type, name, content=wx.EmptyString, attrs=None, next=None, lineNo=-1)\n"
    "XmlNode(type, name, content=wx.EmptyString, lineNo=-1)\n"
    "XmlNode(node)\n"
    "\n"
    "Represents a node in an XML document.");


sipClassTypeDef sipTypeDef__xml_wxXmlNode = {
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_wxXmlNode,
        {0},
        0
    },
    {
        sipNameNr_XmlNode,
        {0, 0, 1},
        26, methods_wxXmlNode,
        0, 0,
        11, variables_wxXmlNode,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_wxXmlNode,
    -1,
    -1,
    0,
    0,
    init_type_wxXmlNode,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_wxXmlNode,
    0,
    0,
    0,
    release_wxXmlNode,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};
